// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.permissions');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
fluree.db.permissions.rule_fn_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$threshold,(300)], 0)));
fluree.db.permissions.parse_fn = (function fluree$db$permissions$parse_fn(var_args){
var G__117996 = arguments.length;
switch (G__117996) {
case 2:
return fluree.db.permissions.parse_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.permissions.parse_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.permissions.parse_fn.cljs$core$IFn$_invoke$arity$2 = (function (db,fn_str){
return fluree.db.permissions.parse_fn.cljs$core$IFn$_invoke$arity$3(db,fn_str,null);
});

fluree.db.permissions.parse_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_str,params){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_118044){
var state_val_118045 = (state_118044[(1)]);
if((state_val_118045 === (7))){
var inst_118040 = (state_118044[(2)]);
var state_118044__$1 = state_118044;
var statearr_118046_118076 = state_118044__$1;
(statearr_118046_118076[(2)] = inst_118040);


cljs.core.async.impl.ioc_helpers.process_exception(state_118044__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_118045 === (20))){
var inst_118032 = (state_118044[(2)]);
var state_118044__$1 = state_118044;
var statearr_118047_118077 = state_118044__$1;
(statearr_118047_118077[(2)] = inst_118032);

(statearr_118047_118077[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118045 === (1))){
var state_118044__$1 = state_118044;
var statearr_118048_118078 = state_118044__$1;
(statearr_118048_118078[(2)] = null);

(statearr_118048_118078[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118045 === (4))){
var inst_118002 = (state_118044[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_118044,(3),Error,null,(2));
var inst_118001 = cljs.core.deref(fluree.db.permissions.rule_fn_cache);
var inst_118002__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_118001,fn_str);
var state_118044__$1 = (function (){var statearr_118049 = state_118044;
(statearr_118049[(7)] = inst_118002__$1);

return statearr_118049;
})();
if(cljs.core.truth_(inst_118002__$1)){
var statearr_118050_118079 = state_118044__$1;
(statearr_118050_118079[(1)] = (5));

} else {
var statearr_118051_118080 = state_118044__$1;
(statearr_118051_118080[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118045 === (15))){
var state_118044__$1 = state_118044;
var statearr_118052_118081 = state_118044__$1;
(statearr_118052_118081[(1)] = (18));



return cljs.core.cst$kw$recur;
} else {
if((state_val_118045 === (13))){
var inst_118036 = (state_118044[(2)]);
var state_118044__$1 = state_118044;
var statearr_118054_118082 = state_118044__$1;
(statearr_118054_118082[(2)] = inst_118036);

(statearr_118054_118082[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118045 === (6))){
var inst_118005 = fn_str === true;
var inst_118006 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("true",fn_str);
var inst_118007 = ((inst_118005) || (inst_118006));
var state_118044__$1 = state_118044;
if(cljs.core.truth_(inst_118007)){
var statearr_118055_118083 = state_118044__$1;
(statearr_118055_118083[(1)] = (8));

} else {
var statearr_118056_118084 = state_118044__$1;
(statearr_118056_118084[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118045 === (17))){
var inst_118019 = (state_118044[(2)]);
var inst_118020 = fluree.db.util.async.throw_err(inst_118019);
var inst_118021 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.permissions.rule_fn_cache,cljs.core.assoc,fn_str,inst_118020);
var state_118044__$1 = (function (){var statearr_118057 = state_118044;
(statearr_118057[(8)] = inst_118021);

return statearr_118057;
})();
var statearr_118058_118085 = state_118044__$1;
(statearr_118058_118085[(2)] = inst_118020);

(statearr_118058_118085[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118045 === (3))){
var inst_117997 = (state_118044[(2)]);
var state_118044__$1 = state_118044;
var statearr_118059_118086 = state_118044__$1;
(statearr_118059_118086[(2)] = inst_117997);


cljs.core.async.impl.ioc_helpers.process_exception(state_118044__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_118045 === (12))){
var inst_118015 = cljs.core.re_matches(/^\(.+\)$/,fn_str);
var state_118044__$1 = state_118044;
if(cljs.core.truth_(inst_118015)){
var statearr_118060_118087 = state_118044__$1;
(statearr_118060_118087[(1)] = (14));

} else {
var statearr_118061_118088 = state_118044__$1;
(statearr_118061_118088[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118045 === (2))){
var inst_118042 = (state_118044[(2)]);
var state_118044__$1 = state_118044;
return cljs.core.async.impl.ioc_helpers.return_chan(state_118044__$1,inst_118042);
} else {
if((state_val_118045 === (19))){
var state_118044__$1 = state_118044;
var statearr_118062_118089 = state_118044__$1;
(statearr_118062_118089[(2)] = null);

(statearr_118062_118089[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118045 === (11))){
var state_118044__$1 = state_118044;
var statearr_118063_118090 = state_118044__$1;
(statearr_118063_118090[(2)] = false);

(statearr_118063_118090[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118045 === (9))){
var inst_118010 = fn_str === false;
var inst_118011 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("false",fn_str);
var inst_118012 = ((inst_118010) || (inst_118011));
var state_118044__$1 = state_118044;
if(cljs.core.truth_(inst_118012)){
var statearr_118064_118091 = state_118044__$1;
(statearr_118064_118091[(1)] = (11));

} else {
var statearr_118065_118092 = state_118044__$1;
(statearr_118065_118092[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118045 === (5))){
var inst_118002 = (state_118044[(7)]);
var state_118044__$1 = state_118044;
var statearr_118066_118093 = state_118044__$1;
(statearr_118066_118093[(2)] = inst_118002);

(statearr_118066_118093[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118045 === (14))){
var inst_118017 = fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4(db,fn_str,"functionDec",params);
var state_118044__$1 = state_118044;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_118044__$1,(17),inst_118017);
} else {
if((state_val_118045 === (16))){
var inst_118034 = (state_118044[(2)]);
var state_118044__$1 = state_118044;
var statearr_118067_118094 = state_118044__$1;
(statearr_118067_118094[(2)] = inst_118034);

(statearr_118067_118094[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118045 === (10))){
var inst_118038 = (state_118044[(2)]);
var state_118044__$1 = state_118044;
var statearr_118068_118095 = state_118044__$1;
(statearr_118068_118095[(2)] = inst_118038);

(statearr_118068_118095[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118045 === (18))){
var inst_118024 = ["Invalid rule function provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_str)].join('');
var inst_118025 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_118026 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_118027 = cljs.core.PersistentHashMap.fromArrays(inst_118025,inst_118026);
var inst_118028 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_118024,inst_118027);
var inst_118029 = (function(){throw inst_118028})();
var state_118044__$1 = state_118044;
var statearr_118069_118096 = state_118044__$1;
(statearr_118069_118096[(2)] = inst_118029);

(statearr_118069_118096[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118045 === (8))){
var state_118044__$1 = state_118044;
var statearr_118070_118097 = state_118044__$1;
(statearr_118070_118097[(2)] = true);

(statearr_118070_118097[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$permissions$state_machine__99037__auto__ = null;
var fluree$db$permissions$state_machine__99037__auto____0 = (function (){
var statearr_118071 = [null,null,null,null,null,null,null,null,null];
(statearr_118071[(0)] = fluree$db$permissions$state_machine__99037__auto__);

(statearr_118071[(1)] = (1));

return statearr_118071;
});
var fluree$db$permissions$state_machine__99037__auto____1 = (function (state_118044){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_118044);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e118072){if((e118072 instanceof Object)){
var ex__99040__auto__ = e118072;
var statearr_118073_118098 = state_118044;
(statearr_118073_118098[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_118044);

return cljs.core.cst$kw$recur;
} else {
throw e118072;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__118099 = state_118044;
state_118044 = G__118099;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$permissions$state_machine__99037__auto__ = function(state_118044){
switch(arguments.length){
case 0:
return fluree$db$permissions$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$permissions$state_machine__99037__auto____1.call(this,state_118044);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$permissions$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$permissions$state_machine__99037__auto____0;
fluree$db$permissions$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$permissions$state_machine__99037__auto____1;
return fluree$db$permissions$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_118074 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_118074[(6)] = c__99059__auto__);

return statearr_118074;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

fluree.db.permissions.parse_fn.cljs$lang$maxFixedArity = 3;

/**
 * Determine which collections, predicates, and operations this rule applies to. Then fetch all function refs
 *   from _rule/fns, and apply to all relevant 
 */
fluree.db.permissions.parse_rules = (function fluree$db$permissions$parse_rules(db,rule){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_118311){
var state_val_118312 = (state_118311[(1)]);
if((state_val_118312 === (65))){
var inst_118212 = (state_118311[(7)]);
var inst_118197 = (state_118311[(8)]);
var inst_118272 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_118273 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_118274 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_118275 = [cljs.core.cst$kw$collection,inst_118212,cljs.core.cst$kw$default];
var inst_118276 = (new cljs.core.PersistentVector(null,3,(5),inst_118274,inst_118275,null));
var inst_118277 = [inst_118276,inst_118197];
var inst_118278 = (new cljs.core.PersistentVector(null,2,(5),inst_118273,inst_118277,null));
var inst_118279 = [inst_118278];
var inst_118280 = (new cljs.core.PersistentVector(null,1,(5),inst_118272,inst_118279,null));
var state_118311__$1 = state_118311;
var statearr_118313_118418 = state_118311__$1;
(statearr_118313_118418[(2)] = inst_118280);

(statearr_118313_118418[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (70))){
var inst_118299 = (state_118311[(2)]);
var state_118311__$1 = state_118311;
var statearr_118314_118419 = state_118311__$1;
(statearr_118314_118419[(2)] = inst_118299);

(statearr_118314_118419[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (62))){
var inst_118113 = (state_118311[(9)]);
var state_118311__$1 = state_118311;
if(cljs.core.truth_(inst_118113)){
var statearr_118315_118420 = state_118311__$1;
(statearr_118315_118420[(1)] = (65));

} else {
var statearr_118316_118421 = state_118311__$1;
(statearr_118316_118421[(1)] = (66));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (7))){
var inst_118127 = (state_118311[(10)]);
var inst_118128 = (state_118311[(11)]);
var inst_118138 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_118139 = [inst_118127,inst_118128];
var inst_118140 = (new cljs.core.PersistentVector(null,2,(5),inst_118138,inst_118139,null));
var state_118311__$1 = state_118311;
var statearr_118317_118422 = state_118311__$1;
(statearr_118317_118422[(2)] = inst_118140);

(statearr_118317_118422[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (59))){
var inst_118207 = (state_118311[(12)]);
var state_118311__$1 = state_118311;
var statearr_118318_118423 = state_118311__$1;
(statearr_118318_118423[(2)] = inst_118207);

(statearr_118318_118423[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (20))){
var inst_118164 = (state_118311[(13)]);
var state_118311__$1 = state_118311;
var statearr_118319_118424 = state_118311__$1;
(statearr_118319_118424[(2)] = inst_118164);

(statearr_118319_118424[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (58))){
var inst_118303 = (state_118311[(2)]);
var state_118311__$1 = state_118311;
var statearr_118320_118425 = state_118311__$1;
(statearr_118320_118425[(2)] = inst_118303);

(statearr_118320_118425[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (60))){
var inst_118265 = (state_118311[(14)]);
var state_118311__$1 = state_118311;
var statearr_118321_118426 = state_118311__$1;
(statearr_118321_118426[(2)] = inst_118265);

(statearr_118321_118426[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (27))){
var inst_118164 = (state_118311[(13)]);
var inst_118193 = (state_118311[(2)]);
var inst_118194 = fluree.db.permissions.parse_fn.cljs$core$IFn$_invoke$arity$3(db,inst_118164,null);
var state_118311__$1 = (function (){var statearr_118322 = state_118311;
(statearr_118322[(15)] = inst_118193);

return statearr_118322;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_118311__$1,(28),inst_118194);
} else {
if((state_val_118312 === (1))){
var state_118311__$1 = state_118311;
var statearr_118323_118427 = state_118311__$1;
(statearr_118323_118427[(2)] = null);

(statearr_118323_118427[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (69))){
var state_118311__$1 = state_118311;
var statearr_118324_118428 = state_118311__$1;
(statearr_118324_118428[(2)] = null);

(statearr_118324_118428[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (24))){
var inst_118172 = (state_118311[(2)]);
var state_118311__$1 = state_118311;
var statearr_118325_118429 = state_118311__$1;
(statearr_118325_118429[(2)] = inst_118172);

(statearr_118325_118429[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (55))){
var inst_118260 = (state_118311[(2)]);
var state_118311__$1 = state_118311;
if(cljs.core.truth_(inst_118260)){
var statearr_118326_118430 = state_118311__$1;
(statearr_118326_118430[(1)] = (56));

} else {
var statearr_118327_118431 = state_118311__$1;
(statearr_118327_118431[(1)] = (57));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (39))){
var inst_118200 = (state_118311[(16)]);
var state_118311__$1 = state_118311;
var statearr_118328_118432 = state_118311__$1;
(statearr_118328_118432[(2)] = inst_118200);

(statearr_118328_118432[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (46))){
var inst_118307 = (state_118311[(2)]);
var state_118311__$1 = state_118311;
var statearr_118329_118433 = state_118311__$1;
(statearr_118329_118433[(2)] = inst_118307);


cljs.core.async.impl.ioc_helpers.process_exception(state_118311__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (4))){
var inst_118112 = (state_118311[(17)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_118311,(3),Error,null,(2));
var inst_118109 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(rule,"_rule/ops");
var inst_118110 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(rule,"_rule/collection");
var inst_118111 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(rule,"_rule/predicates");
var inst_118112__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(rule,"_rule/fns");
var inst_118113 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(rule,"_rule/collectionDefault");
var inst_118121 = cljs.core.seq(inst_118112__$1);
var inst_118122 = cljs.core.first(inst_118121);
var inst_118123 = cljs.core.next(inst_118121);
var inst_118124 = cljs.core.PersistentVector.EMPTY;
var inst_118125 = cljs.core.PersistentVector.EMPTY;
var inst_118126 = inst_118112__$1;
var inst_118127 = inst_118124;
var inst_118128 = inst_118125;
var state_118311__$1 = (function (){var statearr_118330 = state_118311;
(statearr_118330[(10)] = inst_118127);

(statearr_118330[(18)] = inst_118123);

(statearr_118330[(19)] = inst_118111);

(statearr_118330[(17)] = inst_118112__$1);

(statearr_118330[(20)] = inst_118110);

(statearr_118330[(11)] = inst_118128);

(statearr_118330[(21)] = inst_118109);

(statearr_118330[(9)] = inst_118113);

(statearr_118330[(22)] = inst_118126);

(statearr_118330[(23)] = inst_118122);

return statearr_118330;
})();
var statearr_118331_118434 = state_118311__$1;
(statearr_118331_118434[(2)] = null);

(statearr_118331_118434[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (54))){
var inst_118200 = (state_118311[(16)]);
var state_118311__$1 = state_118311;
var statearr_118332_118435 = state_118311__$1;
(statearr_118332_118435[(2)] = inst_118200);

(statearr_118332_118435[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (15))){
var inst_118181 = (state_118311[(2)]);
var state_118311__$1 = state_118311;
if(cljs.core.truth_(inst_118181)){
var statearr_118333_118436 = state_118311__$1;
(statearr_118333_118436[(1)] = (25));

} else {
var statearr_118334_118437 = state_118311__$1;
(statearr_118334_118437[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (48))){
var inst_118113 = (state_118311[(9)]);
var state_118311__$1 = state_118311;
var statearr_118335_118438 = state_118311__$1;
(statearr_118335_118438[(2)] = inst_118113);

(statearr_118335_118438[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (50))){
var inst_118197 = (state_118311[(8)]);
var inst_118246 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_118247 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_118248 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_118249 = [cljs.core.cst$kw$collection,cljs.core.cst$kw$default];
var inst_118250 = (new cljs.core.PersistentVector(null,2,(5),inst_118248,inst_118249,null));
var inst_118251 = [inst_118250,inst_118197];
var inst_118252 = (new cljs.core.PersistentVector(null,2,(5),inst_118247,inst_118251,null));
var inst_118253 = [inst_118252];
var inst_118254 = (new cljs.core.PersistentVector(null,1,(5),inst_118246,inst_118253,null));
var state_118311__$1 = state_118311;
var statearr_118336_118439 = state_118311__$1;
(statearr_118336_118439[(2)] = inst_118254);

(statearr_118336_118439[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (21))){
var inst_118175 = (state_118311[(2)]);
var state_118311__$1 = state_118311;
var statearr_118337_118440 = state_118311__$1;
(statearr_118337_118440[(2)] = inst_118175);

(statearr_118337_118440[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (31))){
var inst_118200 = (state_118311[(16)]);
var inst_118207 = (state_118311[(2)]);
var state_118311__$1 = (function (){var statearr_118338 = state_118311;
(statearr_118338[(12)] = inst_118207);

return statearr_118338;
})();
if(cljs.core.truth_(inst_118200)){
var statearr_118339_118441 = state_118311__$1;
(statearr_118339_118441[(1)] = (32));

} else {
var statearr_118340_118442 = state_118311__$1;
(statearr_118340_118442[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (32))){
var state_118311__$1 = state_118311;
var statearr_118341_118443 = state_118311__$1;
(statearr_118341_118443[(2)] = null);

(statearr_118341_118443[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (40))){
var inst_118229 = (state_118311[(2)]);
var state_118311__$1 = state_118311;
if(cljs.core.truth_(inst_118229)){
var statearr_118342_118444 = state_118311__$1;
(statearr_118342_118444[(1)] = (44));

} else {
var statearr_118343_118445 = state_118311__$1;
(statearr_118343_118445[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (56))){
var inst_118164 = (state_118311[(13)]);
var inst_118193 = (state_118311[(15)]);
var inst_118111 = (state_118311[(19)]);
var inst_118112 = (state_118311[(17)]);
var inst_118110 = (state_118311[(20)]);
var inst_118218 = (state_118311[(24)]);
var inst_118151 = (state_118311[(25)]);
var inst_118212 = (state_118311[(7)]);
var inst_118207 = (state_118311[(12)]);
var inst_118109 = (state_118311[(21)]);
var inst_118113 = (state_118311[(9)]);
var inst_118197 = (state_118311[(8)]);
var inst_118150 = (state_118311[(26)]);
var inst_118200 = (state_118311[(16)]);
var inst_118152 = (state_118311[(27)]);
var inst_118153 = (state_118311[(28)]);
var inst_118262 = (function (){var params_STAR_ = inst_118153;
var collection = inst_118110;
var fn_str = inst_118164;
var fun = inst_118197;
var collection_id = inst_118212;
var _ = inst_118193;
var predicate_ids = inst_118218;
var fn_refs = inst_118112;
var params = inst_118151;
var wild_predicate_QMARK_ = inst_118207;
var wild_collection_QMARK_ = inst_118200;
var vec__118106 = inst_118150;
var fn_strs = inst_118152;
var ops = inst_118109;
var default_QMARK_ = inst_118113;
var predicates = inst_118111;
return ((function (params_STAR_,collection,fn_str,fun,collection_id,_,predicate_ids,fn_refs,params,wild_predicate_QMARK_,wild_collection_QMARK_,vec__118106,fn_strs,ops,default_QMARK_,predicates,inst_118164,inst_118193,inst_118111,inst_118112,inst_118110,inst_118218,inst_118151,inst_118212,inst_118207,inst_118109,inst_118113,inst_118197,inst_118150,inst_118200,inst_118152,inst_118153,state_val_118312,c__99059__auto__){
return (function (pred_id){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$predicate,pred_id], null),fun], null);
});
;})(params_STAR_,collection,fn_str,fun,collection_id,_,predicate_ids,fn_refs,params,wild_predicate_QMARK_,wild_collection_QMARK_,vec__118106,fn_strs,ops,default_QMARK_,predicates,inst_118164,inst_118193,inst_118111,inst_118112,inst_118110,inst_118218,inst_118151,inst_118212,inst_118207,inst_118109,inst_118113,inst_118197,inst_118150,inst_118200,inst_118152,inst_118153,state_val_118312,c__99059__auto__))
})();
var inst_118263 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_118262,inst_118218);
var state_118311__$1 = state_118311;
var statearr_118344_118446 = state_118311__$1;
(statearr_118344_118446[(2)] = inst_118263);

(statearr_118344_118446[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (33))){
var inst_118110 = (state_118311[(20)]);
var inst_118210 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$id,inst_118110);
var state_118311__$1 = state_118311;
var statearr_118345_118447 = state_118311__$1;
(statearr_118345_118447[(2)] = inst_118210);

(statearr_118345_118447[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (13))){
var inst_118110 = (state_118311[(20)]);
var state_118311__$1 = state_118311;
if(cljs.core.truth_(inst_118110)){
var statearr_118346_118448 = state_118311__$1;
(statearr_118346_118448[(1)] = (16));

} else {
var statearr_118347_118449 = state_118311__$1;
(statearr_118347_118449[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (22))){
var inst_118168 = (state_118311[(29)]);
var state_118311__$1 = state_118311;
var statearr_118348_118450 = state_118311__$1;
(statearr_118348_118450[(2)] = inst_118168);

(statearr_118348_118450[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (36))){
var inst_118164 = (state_118311[(13)]);
var inst_118193 = (state_118311[(15)]);
var inst_118111 = (state_118311[(19)]);
var inst_118112 = (state_118311[(17)]);
var inst_118110 = (state_118311[(20)]);
var inst_118151 = (state_118311[(25)]);
var inst_118212 = (state_118311[(7)]);
var inst_118207 = (state_118311[(12)]);
var inst_118109 = (state_118311[(21)]);
var inst_118113 = (state_118311[(9)]);
var inst_118197 = (state_118311[(8)]);
var inst_118150 = (state_118311[(26)]);
var inst_118200 = (state_118311[(16)]);
var inst_118152 = (state_118311[(27)]);
var inst_118153 = (state_118311[(28)]);
var inst_118215 = (function (){var params_STAR_ = inst_118153;
var collection = inst_118110;
var fn_str = inst_118164;
var fun = inst_118197;
var collection_id = inst_118212;
var _ = inst_118193;
var fn_refs = inst_118112;
var params = inst_118151;
var wild_predicate_QMARK_ = inst_118207;
var wild_collection_QMARK_ = inst_118200;
var vec__118106 = inst_118150;
var fn_strs = inst_118152;
var ops = inst_118109;
var default_QMARK_ = inst_118113;
var predicates = inst_118111;
return ((function (params_STAR_,collection,fn_str,fun,collection_id,_,fn_refs,params,wild_predicate_QMARK_,wild_collection_QMARK_,vec__118106,fn_strs,ops,default_QMARK_,predicates,inst_118164,inst_118193,inst_118111,inst_118112,inst_118110,inst_118151,inst_118212,inst_118207,inst_118109,inst_118113,inst_118197,inst_118150,inst_118200,inst_118152,inst_118153,state_val_118312,c__99059__auto__){
return (function (p1__118101_SHARP_){
return fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p1__118101_SHARP_);
});
;})(params_STAR_,collection,fn_str,fun,collection_id,_,fn_refs,params,wild_predicate_QMARK_,wild_collection_QMARK_,vec__118106,fn_strs,ops,default_QMARK_,predicates,inst_118164,inst_118193,inst_118111,inst_118112,inst_118110,inst_118151,inst_118212,inst_118207,inst_118109,inst_118113,inst_118197,inst_118150,inst_118200,inst_118152,inst_118153,state_val_118312,c__99059__auto__))
})();
var inst_118216 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_118215,inst_118111);
var state_118311__$1 = state_118311;
var statearr_118349_118451 = state_118311__$1;
(statearr_118349_118451[(2)] = inst_118216);

(statearr_118349_118451[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (41))){
var inst_118113 = (state_118311[(9)]);
var inst_118197 = (state_118311[(8)]);
var inst_118221 = cljs.core.not(inst_118113);
var inst_118222 = inst_118197 === true;
var inst_118223 = ((inst_118221) && (inst_118222));
var state_118311__$1 = state_118311;
var statearr_118350_118452 = state_118311__$1;
(statearr_118350_118452[(2)] = inst_118223);

(statearr_118350_118452[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (43))){
var inst_118226 = (state_118311[(2)]);
var state_118311__$1 = state_118311;
var statearr_118351_118453 = state_118311__$1;
(statearr_118351_118453[(2)] = inst_118226);

(statearr_118351_118453[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (61))){
var inst_118269 = (state_118311[(2)]);
var state_118311__$1 = state_118311;
if(cljs.core.truth_(inst_118269)){
var statearr_118352_118454 = state_118311__$1;
(statearr_118352_118454[(1)] = (62));

} else {
var statearr_118353_118455 = state_118311__$1;
(statearr_118353_118455[(1)] = (63));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (29))){
var inst_118201 = (state_118311[(30)]);
var state_118311__$1 = state_118311;
var statearr_118354_118456 = state_118311__$1;
(statearr_118354_118456[(2)] = inst_118201);

(statearr_118354_118456[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (44))){
var inst_118231 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_118232 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_118233 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_118234 = [cljs.core.cst$kw$root_QMARK_];
var inst_118235 = (new cljs.core.PersistentVector(null,1,(5),inst_118233,inst_118234,null));
var inst_118236 = [inst_118235,true];
var inst_118237 = (new cljs.core.PersistentVector(null,2,(5),inst_118232,inst_118236,null));
var inst_118238 = [inst_118237];
var inst_118239 = (new cljs.core.PersistentVector(null,1,(5),inst_118231,inst_118238,null));
var state_118311__$1 = state_118311;
var statearr_118355_118457 = state_118311__$1;
(statearr_118355_118457[(2)] = inst_118239);

(statearr_118355_118457[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (6))){
var inst_118151 = (state_118311[(25)]);
var inst_118150 = (state_118311[(26)]);
var inst_118153 = (state_118311[(28)]);
var inst_118150__$1 = (state_118311[(2)]);
var inst_118151__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_118150__$1,(0),null);
var inst_118152 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_118150__$1,(1),null);
var inst_118153__$1 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.empty_QMARK_,inst_118151__$1);
var inst_118154 = cljs.core.empty_QMARK_(inst_118153__$1);
var state_118311__$1 = (function (){var statearr_118356 = state_118311;
(statearr_118356[(25)] = inst_118151__$1);

(statearr_118356[(26)] = inst_118150__$1);

(statearr_118356[(27)] = inst_118152);

(statearr_118356[(28)] = inst_118153__$1);

return statearr_118356;
})();
if(inst_118154){
var statearr_118357_118458 = state_118311__$1;
(statearr_118357_118458[(1)] = (10));

} else {
var statearr_118358_118459 = state_118311__$1;
(statearr_118358_118459[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (28))){
var inst_118111 = (state_118311[(19)]);
var inst_118110 = (state_118311[(20)]);
var inst_118201 = (state_118311[(30)]);
var inst_118196 = (state_118311[(2)]);
var inst_118197 = fluree.db.util.async.throw_err(inst_118196);
var inst_118198 = (inst_118110 == null);
var inst_118199 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("*",inst_118110);
var inst_118200 = ((inst_118198) || (inst_118199));
var inst_118201__$1 = cljs.core.empty_QMARK_(inst_118111);
var state_118311__$1 = (function (){var statearr_118359 = state_118311;
(statearr_118359[(8)] = inst_118197);

(statearr_118359[(16)] = inst_118200);

(statearr_118359[(30)] = inst_118201__$1);

return statearr_118359;
})();
if(inst_118201__$1){
var statearr_118360_118460 = state_118311__$1;
(statearr_118360_118460[(1)] = (29));

} else {
var statearr_118361_118461 = state_118311__$1;
(statearr_118361_118461[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (64))){
var inst_118301 = (state_118311[(2)]);
var state_118311__$1 = state_118311;
var statearr_118362_118462 = state_118311__$1;
(statearr_118362_118462[(2)] = inst_118301);

(statearr_118362_118462[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (51))){
var inst_118200 = (state_118311[(16)]);
var state_118311__$1 = state_118311;
if(cljs.core.truth_(inst_118200)){
var statearr_118363_118463 = state_118311__$1;
(statearr_118363_118463[(1)] = (53));

} else {
var statearr_118364_118464 = state_118311__$1;
(statearr_118364_118464[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (25))){
var state_118311__$1 = state_118311;
var statearr_118365_118465 = state_118311__$1;
(statearr_118365_118465[(2)] = null);

(statearr_118365_118465[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (34))){
var inst_118207 = (state_118311[(12)]);
var inst_118212 = (state_118311[(2)]);
var state_118311__$1 = (function (){var statearr_118366 = state_118311;
(statearr_118366[(7)] = inst_118212);

return statearr_118366;
})();
if(cljs.core.truth_(inst_118207)){
var statearr_118367_118466 = state_118311__$1;
(statearr_118367_118466[(1)] = (35));

} else {
var statearr_118368_118467 = state_118311__$1;
(statearr_118368_118467[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (17))){
var inst_118110 = (state_118311[(20)]);
var state_118311__$1 = state_118311;
var statearr_118369_118468 = state_118311__$1;
(statearr_118369_118468[(2)] = inst_118110);

(statearr_118369_118468[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (3))){
var inst_118102 = (state_118311[(2)]);
var state_118311__$1 = state_118311;
var statearr_118370_118469 = state_118311__$1;
(statearr_118370_118469[(2)] = inst_118102);


cljs.core.async.impl.ioc_helpers.process_exception(state_118311__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (12))){
var inst_118109 = (state_118311[(21)]);
var inst_118152 = (state_118311[(27)]);
var inst_118163 = (state_118311[(2)]);
var inst_118164 = fluree.db.dbfunctions.core.combine_fns(inst_118152);
var state_118311__$1 = (function (){var statearr_118371 = state_118311;
(statearr_118371[(31)] = inst_118163);

(statearr_118371[(13)] = inst_118164);

return statearr_118371;
})();
if(cljs.core.truth_(inst_118109)){
var statearr_118372_118470 = state_118311__$1;
(statearr_118372_118470[(1)] = (13));

} else {
var statearr_118373_118471 = state_118311__$1;
(statearr_118373_118471[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (2))){
var inst_118309 = (state_118311[(2)]);
var state_118311__$1 = state_118311;
return cljs.core.async.impl.ioc_helpers.return_chan(state_118311__$1,inst_118309);
} else {
if((state_val_118312 === (66))){
var inst_118212 = (state_118311[(7)]);
var inst_118197 = (state_118311[(8)]);
var inst_118282 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_118283 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_118284 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_118285 = [cljs.core.cst$kw$collection,inst_118212,cljs.core.cst$kw$all];
var inst_118286 = (new cljs.core.PersistentVector(null,3,(5),inst_118284,inst_118285,null));
var inst_118287 = [inst_118286,inst_118197];
var inst_118288 = (new cljs.core.PersistentVector(null,2,(5),inst_118283,inst_118287,null));
var inst_118289 = [inst_118288];
var inst_118290 = (new cljs.core.PersistentVector(null,1,(5),inst_118282,inst_118289,null));
var state_118311__$1 = state_118311;
var statearr_118374_118472 = state_118311__$1;
(statearr_118374_118472[(2)] = inst_118290);

(statearr_118374_118472[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (23))){
var inst_118113 = (state_118311[(9)]);
var state_118311__$1 = state_118311;
var statearr_118375_118473 = state_118311__$1;
(statearr_118375_118473[(2)] = inst_118113);

(statearr_118375_118473[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (47))){
var inst_118200 = (state_118311[(16)]);
var state_118311__$1 = state_118311;
var statearr_118376_118474 = state_118311__$1;
(statearr_118376_118474[(2)] = inst_118200);

(statearr_118376_118474[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (35))){
var state_118311__$1 = state_118311;
var statearr_118377_118475 = state_118311__$1;
(statearr_118377_118475[(2)] = null);

(statearr_118377_118475[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (19))){
var inst_118111 = (state_118311[(19)]);
var inst_118168 = (state_118311[(29)]);
var inst_118168__$1 = cljs.core.not_empty(inst_118111);
var state_118311__$1 = (function (){var statearr_118378 = state_118311;
(statearr_118378[(29)] = inst_118168__$1);

return statearr_118378;
})();
if(cljs.core.truth_(inst_118168__$1)){
var statearr_118379_118476 = state_118311__$1;
(statearr_118379_118476[(1)] = (22));

} else {
var statearr_118380_118477 = state_118311__$1;
(statearr_118380_118477[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (57))){
var inst_118200 = (state_118311[(16)]);
var inst_118265 = (state_118311[(14)]);
var inst_118265__$1 = cljs.core.not(inst_118200);
var state_118311__$1 = (function (){var statearr_118381 = state_118311;
(statearr_118381[(14)] = inst_118265__$1);

return statearr_118381;
})();
if(inst_118265__$1){
var statearr_118382_118478 = state_118311__$1;
(statearr_118382_118478[(1)] = (59));

} else {
var statearr_118383_118479 = state_118311__$1;
(statearr_118383_118479[(1)] = (60));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (68))){
var inst_118164 = (state_118311[(13)]);
var inst_118193 = (state_118311[(15)]);
var inst_118111 = (state_118311[(19)]);
var inst_118112 = (state_118311[(17)]);
var inst_118110 = (state_118311[(20)]);
var inst_118218 = (state_118311[(24)]);
var inst_118151 = (state_118311[(25)]);
var inst_118212 = (state_118311[(7)]);
var inst_118207 = (state_118311[(12)]);
var inst_118109 = (state_118311[(21)]);
var inst_118113 = (state_118311[(9)]);
var inst_118197 = (state_118311[(8)]);
var inst_118150 = (state_118311[(26)]);
var inst_118200 = (state_118311[(16)]);
var inst_118152 = (state_118311[(27)]);
var inst_118153 = (state_118311[(28)]);
var inst_118295 = (function (){var params_STAR_ = inst_118153;
var collection = inst_118110;
var fn_str = inst_118164;
var fun = inst_118197;
var collection_id = inst_118212;
var _ = inst_118193;
var predicate_ids = inst_118218;
var fn_refs = inst_118112;
var params = inst_118151;
var wild_predicate_QMARK_ = inst_118207;
var wild_collection_QMARK_ = inst_118200;
var vec__118106 = inst_118150;
var fn_strs = inst_118152;
var ops = inst_118109;
var default_QMARK_ = inst_118113;
var predicates = inst_118111;
return ((function (params_STAR_,collection,fn_str,fun,collection_id,_,predicate_ids,fn_refs,params,wild_predicate_QMARK_,wild_collection_QMARK_,vec__118106,fn_strs,ops,default_QMARK_,predicates,inst_118164,inst_118193,inst_118111,inst_118112,inst_118110,inst_118218,inst_118151,inst_118212,inst_118207,inst_118109,inst_118113,inst_118197,inst_118150,inst_118200,inst_118152,inst_118153,state_val_118312,c__99059__auto__){
return (function (pred_id){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$collection,collection_id,pred_id], null),fun], null);
});
;})(params_STAR_,collection,fn_str,fun,collection_id,_,predicate_ids,fn_refs,params,wild_predicate_QMARK_,wild_collection_QMARK_,vec__118106,fn_strs,ops,default_QMARK_,predicates,inst_118164,inst_118193,inst_118111,inst_118112,inst_118110,inst_118218,inst_118151,inst_118212,inst_118207,inst_118109,inst_118113,inst_118197,inst_118150,inst_118200,inst_118152,inst_118153,state_val_118312,c__99059__auto__))
})();
var inst_118296 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_118295,inst_118218);
var state_118311__$1 = state_118311;
var statearr_118384_118480 = state_118311__$1;
(statearr_118384_118480[(2)] = inst_118296);

(statearr_118384_118480[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (11))){
var inst_118157 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_118158 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_118159 = cljs.core.PersistentHashMap.fromArrays(inst_118157,inst_118158);
var inst_118160 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("You can only use functions with additional parameters in transactions functions. ",inst_118159);
var inst_118161 = (function(){throw inst_118160})();
var state_118311__$1 = state_118311;
var statearr_118385_118481 = state_118311__$1;
(statearr_118385_118481[(2)] = inst_118161);

(statearr_118385_118481[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (9))){
var inst_118148 = (state_118311[(2)]);
var state_118311__$1 = state_118311;
var statearr_118386_118482 = state_118311__$1;
(statearr_118386_118482[(2)] = inst_118148);

(statearr_118386_118482[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (5))){
var inst_118134 = (state_118311[(32)]);
var inst_118126 = (state_118311[(22)]);
var inst_118133 = cljs.core.seq(inst_118126);
var inst_118134__$1 = cljs.core.first(inst_118133);
var inst_118135 = cljs.core.next(inst_118133);
var inst_118136 = cljs.core.not(inst_118134__$1);
var state_118311__$1 = (function (){var statearr_118387 = state_118311;
(statearr_118387[(32)] = inst_118134__$1);

(statearr_118387[(33)] = inst_118135);

return statearr_118387;
})();
if(inst_118136){
var statearr_118388_118483 = state_118311__$1;
(statearr_118388_118483[(1)] = (7));

} else {
var statearr_118389_118484 = state_118311__$1;
(statearr_118389_118484[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (14))){
var inst_118109 = (state_118311[(21)]);
var state_118311__$1 = state_118311;
var statearr_118390_118485 = state_118311__$1;
(statearr_118390_118485[(2)] = inst_118109);

(statearr_118390_118485[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (45))){
var inst_118113 = (state_118311[(9)]);
var state_118311__$1 = state_118311;
if(cljs.core.truth_(inst_118113)){
var statearr_118391_118486 = state_118311__$1;
(statearr_118391_118486[(1)] = (47));

} else {
var statearr_118392_118487 = state_118311__$1;
(statearr_118392_118487[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (53))){
var inst_118207 = (state_118311[(12)]);
var inst_118257 = cljs.core.not(inst_118207);
var state_118311__$1 = state_118311;
var statearr_118393_118488 = state_118311__$1;
(statearr_118393_118488[(2)] = inst_118257);

(statearr_118393_118488[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (26))){
var inst_118184 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(rule,"_id");
var inst_118185 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_118184], 0));
var inst_118186 = ["Incomplete rule, does not contain all required predicates for rule id:",inst_118185].join('');
var inst_118187 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_118188 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_rule];
var inst_118189 = cljs.core.PersistentHashMap.fromArrays(inst_118187,inst_118188);
var inst_118190 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_118186,inst_118189);
var inst_118191 = (function(){throw inst_118190})();
var state_118311__$1 = state_118311;
var statearr_118394_118489 = state_118311__$1;
(statearr_118394_118489[(2)] = inst_118191);

(statearr_118394_118489[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (16))){
var inst_118164 = (state_118311[(13)]);
var state_118311__$1 = state_118311;
if(cljs.core.truth_(inst_118164)){
var statearr_118395_118490 = state_118311__$1;
(statearr_118395_118490[(1)] = (19));

} else {
var statearr_118396_118491 = state_118311__$1;
(statearr_118396_118491[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (38))){
var inst_118207 = (state_118311[(12)]);
var state_118311__$1 = state_118311;
if(cljs.core.truth_(inst_118207)){
var statearr_118397_118492 = state_118311__$1;
(statearr_118397_118492[(1)] = (41));

} else {
var statearr_118398_118493 = state_118311__$1;
(statearr_118398_118493[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (30))){
var inst_118164 = (state_118311[(13)]);
var inst_118193 = (state_118311[(15)]);
var inst_118111 = (state_118311[(19)]);
var inst_118112 = (state_118311[(17)]);
var inst_118110 = (state_118311[(20)]);
var inst_118151 = (state_118311[(25)]);
var inst_118109 = (state_118311[(21)]);
var inst_118113 = (state_118311[(9)]);
var inst_118197 = (state_118311[(8)]);
var inst_118150 = (state_118311[(26)]);
var inst_118200 = (state_118311[(16)]);
var inst_118201 = (state_118311[(30)]);
var inst_118152 = (state_118311[(27)]);
var inst_118153 = (state_118311[(28)]);
var inst_118204 = (function (){var params_STAR_ = inst_118153;
var collection = inst_118110;
var fn_str = inst_118164;
var fun = inst_118197;
var _ = inst_118193;
var fn_refs = inst_118112;
var params = inst_118151;
var wild_collection_QMARK_ = inst_118200;
var vec__118106 = inst_118150;
var fn_strs = inst_118152;
var ops = inst_118109;
var default_QMARK_ = inst_118113;
var or__4131__auto__ = inst_118201;
var predicates = inst_118111;
return ((function (params_STAR_,collection,fn_str,fun,_,fn_refs,params,wild_collection_QMARK_,vec__118106,fn_strs,ops,default_QMARK_,or__4131__auto__,predicates,inst_118164,inst_118193,inst_118111,inst_118112,inst_118110,inst_118151,inst_118109,inst_118113,inst_118197,inst_118150,inst_118200,inst_118201,inst_118152,inst_118153,state_val_118312,c__99059__auto__){
return (function (p1__118100_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("*",p1__118100_SHARP_);
});
;})(params_STAR_,collection,fn_str,fun,_,fn_refs,params,wild_collection_QMARK_,vec__118106,fn_strs,ops,default_QMARK_,or__4131__auto__,predicates,inst_118164,inst_118193,inst_118111,inst_118112,inst_118110,inst_118151,inst_118109,inst_118113,inst_118197,inst_118150,inst_118200,inst_118201,inst_118152,inst_118153,state_val_118312,c__99059__auto__))
})();
var inst_118205 = cljs.core.some(inst_118204,inst_118111);
var state_118311__$1 = state_118311;
var statearr_118399_118494 = state_118311__$1;
(statearr_118399_118494[(2)] = inst_118205);

(statearr_118399_118494[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (10))){
var state_118311__$1 = state_118311;
var statearr_118400_118495 = state_118311__$1;
(statearr_118400_118495[(2)] = null);

(statearr_118400_118495[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (18))){
var inst_118178 = (state_118311[(2)]);
var state_118311__$1 = state_118311;
var statearr_118401_118496 = state_118311__$1;
(statearr_118401_118496[(2)] = inst_118178);

(statearr_118401_118496[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (52))){
var inst_118305 = (state_118311[(2)]);
var state_118311__$1 = state_118311;
var statearr_118402_118497 = state_118311__$1;
(statearr_118402_118497[(2)] = inst_118305);

(statearr_118402_118497[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (67))){
var inst_118292 = (state_118311[(2)]);
var state_118311__$1 = state_118311;
var statearr_118403_118498 = state_118311__$1;
(statearr_118403_118498[(2)] = inst_118292);

(statearr_118403_118498[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (42))){
var inst_118207 = (state_118311[(12)]);
var state_118311__$1 = state_118311;
var statearr_118404_118499 = state_118311__$1;
(statearr_118404_118499[(2)] = inst_118207);

(statearr_118404_118499[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (37))){
var inst_118200 = (state_118311[(16)]);
var inst_118218 = (state_118311[(2)]);
var state_118311__$1 = (function (){var statearr_118405 = state_118311;
(statearr_118405[(24)] = inst_118218);

return statearr_118405;
})();
if(cljs.core.truth_(inst_118200)){
var statearr_118406_118500 = state_118311__$1;
(statearr_118406_118500[(1)] = (38));

} else {
var statearr_118407_118501 = state_118311__$1;
(statearr_118407_118501[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (63))){
var state_118311__$1 = state_118311;
var statearr_118408_118502 = state_118311__$1;
(statearr_118408_118502[(1)] = (68));



return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (8))){
var inst_118127 = (state_118311[(10)]);
var inst_118128 = (state_118311[(11)]);
var inst_118134 = (state_118311[(32)]);
var inst_118135 = (state_118311[(33)]);
var inst_118142 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_118134,"_fn/params");
var inst_118143 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_118127,inst_118142);
var inst_118144 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_118134,"_fn/code");
var inst_118145 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_118128,inst_118144);
var inst_118126 = inst_118135;
var inst_118127__$1 = inst_118143;
var inst_118128__$1 = inst_118145;
var state_118311__$1 = (function (){var statearr_118410 = state_118311;
(statearr_118410[(10)] = inst_118127__$1);

(statearr_118410[(11)] = inst_118128__$1);

(statearr_118410[(22)] = inst_118126);

return statearr_118410;
})();
var statearr_118411_118503 = state_118311__$1;
(statearr_118411_118503[(2)] = null);

(statearr_118411_118503[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118312 === (49))){
var inst_118244 = (state_118311[(2)]);
var state_118311__$1 = state_118311;
if(cljs.core.truth_(inst_118244)){
var statearr_118412_118504 = state_118311__$1;
(statearr_118412_118504[(1)] = (50));

} else {
var statearr_118413_118505 = state_118311__$1;
(statearr_118413_118505[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$permissions$parse_rules_$_state_machine__99037__auto__ = null;
var fluree$db$permissions$parse_rules_$_state_machine__99037__auto____0 = (function (){
var statearr_118414 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_118414[(0)] = fluree$db$permissions$parse_rules_$_state_machine__99037__auto__);

(statearr_118414[(1)] = (1));

return statearr_118414;
});
var fluree$db$permissions$parse_rules_$_state_machine__99037__auto____1 = (function (state_118311){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_118311);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e118415){if((e118415 instanceof Object)){
var ex__99040__auto__ = e118415;
var statearr_118416_118506 = state_118311;
(statearr_118416_118506[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_118311);

return cljs.core.cst$kw$recur;
} else {
throw e118415;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__118507 = state_118311;
state_118311 = G__118507;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$permissions$parse_rules_$_state_machine__99037__auto__ = function(state_118311){
switch(arguments.length){
case 0:
return fluree$db$permissions$parse_rules_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$permissions$parse_rules_$_state_machine__99037__auto____1.call(this,state_118311);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$permissions$parse_rules_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$permissions$parse_rules_$_state_machine__99037__auto____0;
fluree$db$permissions$parse_rules_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$permissions$parse_rules_$_state_machine__99037__auto____1;
return fluree$db$permissions$parse_rules_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_118417 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_118417[(6)] = c__99059__auto__);

return statearr_118417;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Given a role, returns rules associated with it. Optionally can filter by
 *   a specific '_rule/ops' type as a keyword, i.e. :all, :query, :transact, :token.
 */
fluree.db.permissions.rules_from_role = (function fluree$db$permissions$rules_from_role(var_args){
var G__118510 = arguments.length;
switch (G__118510) {
case 2:
return fluree.db.permissions.rules_from_role.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.permissions.rules_from_role.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.permissions.rules_from_role.cljs$core$IFn$_invoke$arity$2 = (function (db,role){
return fluree.db.permissions.rules_from_role.cljs$core$IFn$_invoke$arity$3(db,role,cljs.core.cst$kw$all);
});

fluree.db.permissions.rules_from_role.cljs$core$IFn$_invoke$arity$3 = (function (db,role,filter_op_type){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_118568){
var state_val_118569 = (state_118568[(1)]);
if((state_val_118569 === (7))){
var inst_118539 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([role], 0));
var inst_118540 = ["Invalid role ident, doesn't exist: ",inst_118539].join('');
var inst_118541 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_118542 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_role];
var inst_118543 = cljs.core.PersistentHashMap.fromArrays(inst_118541,inst_118542);
var inst_118544 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_118540,inst_118543);
var inst_118545 = (function(){throw inst_118544})();
var state_118568__$1 = state_118568;
var statearr_118570_118593 = state_118568__$1;
(statearr_118570_118593[(2)] = inst_118545);

(statearr_118570_118593[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118569 === (1))){
var state_118568__$1 = state_118568;
var statearr_118571_118594 = state_118568__$1;
(statearr_118571_118594[(2)] = null);

(statearr_118571_118594[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118569 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_118568,(3),Error,null,(2));
var inst_118515 = [cljs.core.cst$kw$selectOne,cljs.core.cst$kw$from];
var inst_118516 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_118517 = ["_role/rules"];
var inst_118518 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_118519 = ["_rule/fns"];
var inst_118520 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_118521 = ["_fn/code","_fn/params"];
var inst_118522 = (new cljs.core.PersistentVector(null,2,(5),inst_118520,inst_118521,null));
var inst_118523 = [inst_118522];
var inst_118524 = cljs.core.PersistentHashMap.fromArrays(inst_118519,inst_118523);
var inst_118525 = ["*",inst_118524];
var inst_118526 = (new cljs.core.PersistentVector(null,2,(5),inst_118518,inst_118525,null));
var inst_118527 = [inst_118526];
var inst_118528 = cljs.core.PersistentHashMap.fromArrays(inst_118517,inst_118527);
var inst_118529 = [inst_118528];
var inst_118530 = (new cljs.core.PersistentVector(null,1,(5),inst_118516,inst_118529,null));
var inst_118531 = [inst_118530,role];
var inst_118532 = cljs.core.PersistentHashMap.fromArrays(inst_118515,inst_118531);
var inst_118533 = fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$2(db,inst_118532);
var state_118568__$1 = state_118568;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_118568__$1,(5),inst_118533);
} else {
if((state_val_118569 === (13))){
var inst_118548 = (state_118568[(7)]);
var state_118568__$1 = state_118568;
var statearr_118572_118595 = state_118568__$1;
(statearr_118572_118595[(2)] = inst_118548);

(statearr_118572_118595[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118569 === (6))){
var state_118568__$1 = state_118568;
var statearr_118573_118596 = state_118568__$1;
(statearr_118573_118596[(2)] = null);

(statearr_118573_118596[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118569 === (3))){
var inst_118511 = (state_118568[(2)]);
var state_118568__$1 = state_118568;
var statearr_118574_118597 = state_118568__$1;
(statearr_118574_118597[(2)] = inst_118511);


cljs.core.async.impl.ioc_helpers.process_exception(state_118568__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_118569 === (12))){
var inst_118558 = (state_118568[(8)]);
var inst_118547 = (state_118568[(9)]);
var inst_118536 = (state_118568[(10)]);
var inst_118548 = (state_118568[(7)]);
var inst_118560 = (function (){var rules_res = inst_118536;
var _ = inst_118547;
var rules = inst_118548;
var op_filter = inst_118558;
return ((function (rules_res,_,rules,op_filter,inst_118558,inst_118547,inst_118536,inst_118548,state_val_118569,c__99059__auto__){
return (function (p1__118508_SHARP_){
return cljs.core.some(((function (rules_res,_,rules,op_filter,inst_118558,inst_118547,inst_118536,inst_118548,state_val_118569,c__99059__auto__){
return (function (op){
return (op_filter.cljs$core$IFn$_invoke$arity$1 ? op_filter.cljs$core$IFn$_invoke$arity$1(op) : op_filter.call(null,op));
});})(rules_res,_,rules,op_filter,inst_118558,inst_118547,inst_118536,inst_118548,state_val_118569,c__99059__auto__))
,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__118508_SHARP_,"_rule/ops"));
});
;})(rules_res,_,rules,op_filter,inst_118558,inst_118547,inst_118536,inst_118548,state_val_118569,c__99059__auto__))
})();
var inst_118561 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_118560,inst_118548);
var state_118568__$1 = state_118568;
var statearr_118575_118598 = state_118568__$1;
(statearr_118575_118598[(2)] = inst_118561);

(statearr_118575_118598[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118569 === (2))){
var inst_118566 = (state_118568[(2)]);
var state_118568__$1 = state_118568;
return cljs.core.async.impl.ioc_helpers.return_chan(state_118568__$1,inst_118566);
} else {
if((state_val_118569 === (11))){
var inst_118558 = (state_118568[(8)]);
var inst_118558__$1 = (state_118568[(2)]);
var state_118568__$1 = (function (){var statearr_118576 = state_118568;
(statearr_118576[(8)] = inst_118558__$1);

return statearr_118576;
})();
if(cljs.core.truth_(inst_118558__$1)){
var statearr_118577_118599 = state_118568__$1;
(statearr_118577_118599[(1)] = (12));

} else {
var statearr_118578_118600 = state_118568__$1;
(statearr_118578_118600[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118569 === (9))){
var state_118568__$1 = state_118568;
var statearr_118579_118601 = state_118568__$1;
(statearr_118579_118601[(2)] = null);

(statearr_118579_118601[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118569 === (5))){
var inst_118536 = (state_118568[(10)]);
var inst_118535 = (state_118568[(2)]);
var inst_118536__$1 = fluree.db.util.async.throw_err(inst_118535);
var state_118568__$1 = (function (){var statearr_118580 = state_118568;
(statearr_118580[(10)] = inst_118536__$1);

return statearr_118580;
})();
if(cljs.core.truth_(inst_118536__$1)){
var statearr_118581_118602 = state_118568__$1;
(statearr_118581_118602[(1)] = (6));

} else {
var statearr_118582_118603 = state_118568__$1;
(statearr_118582_118603[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118569 === (14))){
var inst_118564 = (state_118568[(2)]);
var state_118568__$1 = state_118568;
var statearr_118583_118604 = state_118568__$1;
(statearr_118583_118604[(2)] = inst_118564);


cljs.core.async.impl.ioc_helpers.process_exception(state_118568__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_118569 === (10))){
var inst_118552 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_118553 = cljs.core.name(filter_op_type);
var inst_118554 = ["all",inst_118553];
var inst_118555 = (new cljs.core.PersistentVector(null,2,(5),inst_118552,inst_118554,null));
var inst_118556 = cljs.core.set(inst_118555);
var state_118568__$1 = state_118568;
var statearr_118584_118605 = state_118568__$1;
(statearr_118584_118605[(2)] = inst_118556);

(statearr_118584_118605[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118569 === (8))){
var inst_118536 = (state_118568[(10)]);
var inst_118547 = (state_118568[(2)]);
var inst_118548 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_118536,"_role/rules");
var inst_118549 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$all,filter_op_type);
var state_118568__$1 = (function (){var statearr_118585 = state_118568;
(statearr_118585[(9)] = inst_118547);

(statearr_118585[(7)] = inst_118548);

return statearr_118585;
})();
if(inst_118549){
var statearr_118586_118606 = state_118568__$1;
(statearr_118586_118606[(1)] = (9));

} else {
var statearr_118587_118607 = state_118568__$1;
(statearr_118587_118607[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$permissions$state_machine__99037__auto__ = null;
var fluree$db$permissions$state_machine__99037__auto____0 = (function (){
var statearr_118588 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_118588[(0)] = fluree$db$permissions$state_machine__99037__auto__);

(statearr_118588[(1)] = (1));

return statearr_118588;
});
var fluree$db$permissions$state_machine__99037__auto____1 = (function (state_118568){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_118568);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e118589){if((e118589 instanceof Object)){
var ex__99040__auto__ = e118589;
var statearr_118590_118608 = state_118568;
(statearr_118590_118608[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_118568);

return cljs.core.cst$kw$recur;
} else {
throw e118589;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__118609 = state_118568;
state_118568 = G__118609;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$permissions$state_machine__99037__auto__ = function(state_118568){
switch(arguments.length){
case 0:
return fluree$db$permissions$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$permissions$state_machine__99037__auto____1.call(this,state_118568);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$permissions$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$permissions$state_machine__99037__auto____0;
fluree$db$permissions$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$permissions$state_machine__99037__auto____1;
return fluree$db$permissions$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_118591 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_118591[(6)] = c__99059__auto__);

return statearr_118591;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

fluree.db.permissions.rules_from_role.cljs$lang$maxFixedArity = 3;

fluree.db.permissions.role_permission_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.ttl_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$ttl,(((5) * (60)) * (1000))], 0)));
fluree.db.permissions.role_permissions = (function fluree$db$permissions$role_permissions(db,role_ident,permission_type){

var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_118691){
var state_val_118692 = (state_118691[(1)]);
if((state_val_118692 === (7))){
var inst_118625 = (state_118691[(7)]);
var inst_118625__$1 = (state_118691[(2)]);
var state_118691__$1 = (function (){var statearr_118693 = state_118691;
(statearr_118693[(7)] = inst_118625__$1);

return statearr_118693;
})();
if(cljs.core.truth_(inst_118625__$1)){
var statearr_118694_118724 = state_118691__$1;
(statearr_118694_118724[(1)] = (8));

} else {
var statearr_118695_118725 = state_118691__$1;
(statearr_118695_118725[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118692 === (20))){
var inst_118666 = (state_118691[(8)]);
var inst_118659 = (state_118691[(9)]);
var inst_118672 = (state_118691[(2)]);
var inst_118673 = fluree.db.util.async.throw_err(inst_118672);
var inst_118674 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_118659,inst_118673);
var inst_118658 = inst_118666;
var inst_118659__$1 = inst_118674;
var state_118691__$1 = (function (){var statearr_118696 = state_118691;
(statearr_118696[(9)] = inst_118659__$1);

(statearr_118696[(10)] = inst_118658);

return statearr_118696;
})();
var statearr_118697_118726 = state_118691__$1;
(statearr_118697_118726[(2)] = null);

(statearr_118697_118726[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118692 === (1))){
var state_118691__$1 = state_118691;
var statearr_118698_118727 = state_118691__$1;
(statearr_118698_118727[(2)] = null);

(statearr_118698_118727[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118692 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_118691,(3),Error,null,(2));
var inst_118614 = cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db);
var state_118691__$1 = state_118691;
if(cljs.core.truth_(inst_118614)){
var statearr_118699_118728 = state_118691__$1;
(statearr_118699_118728[(1)] = (5));

} else {
var statearr_118700_118729 = state_118691__$1;
(statearr_118700_118729[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118692 === (15))){
var inst_118665 = (state_118691[(11)]);
var inst_118658 = (state_118691[(10)]);
var inst_118664 = cljs.core.seq(inst_118658);
var inst_118665__$1 = cljs.core.first(inst_118664);
var inst_118666 = cljs.core.next(inst_118664);
var inst_118667 = cljs.core.not(inst_118665__$1);
var state_118691__$1 = (function (){var statearr_118701 = state_118691;
(statearr_118701[(8)] = inst_118666);

(statearr_118701[(11)] = inst_118665__$1);

return statearr_118701;
})();
if(inst_118667){
var statearr_118702_118730 = state_118691__$1;
(statearr_118702_118730[(1)] = (17));

} else {
var statearr_118703_118731 = state_118691__$1;
(statearr_118703_118731[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118692 === (13))){
var inst_118642 = (state_118691[(2)]);
var inst_118643 = fluree.db.permissions.rules_from_role.cljs$core$IFn$_invoke$arity$3(db,role_ident,permission_type);
var state_118691__$1 = (function (){var statearr_118704 = state_118691;
(statearr_118704[(12)] = inst_118642);

return statearr_118704;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_118691__$1,(14),inst_118643);
} else {
if((state_val_118692 === (6))){
var inst_118617 = cljs.core.deref(fluree.db.permissions.role_permission_cache);
var inst_118618 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_118619 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(db);
var inst_118620 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_118621 = [inst_118619,inst_118620,role_ident,permission_type];
var inst_118622 = (new cljs.core.PersistentVector(null,4,(5),inst_118618,inst_118621,null));
var inst_118623 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_118617,inst_118622);
var state_118691__$1 = state_118691;
var statearr_118705_118732 = state_118691__$1;
(statearr_118705_118732[(2)] = inst_118623);

(statearr_118705_118732[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118692 === (17))){
var inst_118659 = (state_118691[(9)]);
var state_118691__$1 = state_118691;
var statearr_118706_118733 = state_118691__$1;
(statearr_118706_118733[(2)] = inst_118659);

(statearr_118706_118733[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118692 === (3))){
var inst_118610 = (state_118691[(2)]);
var state_118691__$1 = state_118691;
var statearr_118707_118734 = state_118691__$1;
(statearr_118707_118734[(2)] = inst_118610);


cljs.core.async.impl.ioc_helpers.process_exception(state_118691__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_118692 === (12))){
var inst_118634 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([permission_type], 0));
var inst_118635 = ["Invalid permission op type:",inst_118634].join('');
var inst_118636 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_118637 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_role];
var inst_118638 = cljs.core.PersistentHashMap.fromArrays(inst_118636,inst_118637);
var inst_118639 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_118635,inst_118638);
var inst_118640 = (function(){throw inst_118639})();
var state_118691__$1 = state_118691;
var statearr_118708_118735 = state_118691__$1;
(statearr_118708_118735[(2)] = inst_118640);

(statearr_118708_118735[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118692 === (2))){
var inst_118689 = (state_118691[(2)]);
var state_118691__$1 = state_118691;
return cljs.core.async.impl.ioc_helpers.return_chan(state_118691__$1,inst_118689);
} else {
if((state_val_118692 === (19))){
var inst_118677 = (state_118691[(2)]);
var state_118691__$1 = state_118691;
var statearr_118709_118736 = state_118691__$1;
(statearr_118709_118736[(2)] = inst_118677);

(statearr_118709_118736[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118692 === (11))){
var state_118691__$1 = state_118691;
var statearr_118710_118737 = state_118691__$1;
(statearr_118710_118737[(2)] = null);

(statearr_118710_118737[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118692 === (9))){
var inst_118628 = [cljs.core.cst$kw$token,null,cljs.core.cst$kw$transact,null,cljs.core.cst$kw$query,null];
var inst_118629 = (new cljs.core.PersistentArrayMap(null,3,inst_118628,null));
var inst_118630 = (new cljs.core.PersistentHashSet(null,inst_118629,null));
var inst_118631 = (inst_118630.cljs$core$IFn$_invoke$arity$1 ? inst_118630.cljs$core$IFn$_invoke$arity$1(permission_type) : inst_118630.call(null,permission_type));
var state_118691__$1 = state_118691;
if(cljs.core.truth_(inst_118631)){
var statearr_118711_118738 = state_118691__$1;
(statearr_118711_118738[(1)] = (11));

} else {
var statearr_118712_118739 = state_118691__$1;
(statearr_118712_118739[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118692 === (5))){
var state_118691__$1 = state_118691;
var statearr_118713_118740 = state_118691__$1;
(statearr_118713_118740[(2)] = null);

(statearr_118713_118740[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118692 === (14))){
var inst_118645 = (state_118691[(2)]);
var inst_118646 = fluree.db.util.async.throw_err(inst_118645);
var inst_118654 = cljs.core.seq(inst_118646);
var inst_118655 = cljs.core.first(inst_118654);
var inst_118656 = cljs.core.next(inst_118654);
var inst_118657 = cljs.core.PersistentVector.EMPTY;
var inst_118658 = inst_118646;
var inst_118659 = inst_118657;
var state_118691__$1 = (function (){var statearr_118714 = state_118691;
(statearr_118714[(9)] = inst_118659);

(statearr_118714[(13)] = inst_118656);

(statearr_118714[(14)] = inst_118655);

(statearr_118714[(10)] = inst_118658);

return statearr_118714;
})();
var statearr_118715_118741 = state_118691__$1;
(statearr_118715_118741[(2)] = null);

(statearr_118715_118741[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118692 === (16))){
var inst_118679 = (state_118691[(2)]);
var inst_118680 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_118681 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(db);
var inst_118682 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_118683 = [inst_118681,inst_118682,role_ident,permission_type];
var inst_118684 = (new cljs.core.PersistentVector(null,4,(5),inst_118680,inst_118683,null));
var inst_118685 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.permissions.role_permission_cache,cljs.core.assoc,inst_118684,inst_118679);
var state_118691__$1 = (function (){var statearr_118716 = state_118691;
(statearr_118716[(15)] = inst_118685);

return statearr_118716;
})();
var statearr_118717_118742 = state_118691__$1;
(statearr_118717_118742[(2)] = inst_118679);

(statearr_118717_118742[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118692 === (10))){
var inst_118687 = (state_118691[(2)]);
var state_118691__$1 = state_118691;
var statearr_118718_118743 = state_118691__$1;
(statearr_118718_118743[(2)] = inst_118687);


cljs.core.async.impl.ioc_helpers.process_exception(state_118691__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_118692 === (18))){
var inst_118665 = (state_118691[(11)]);
var inst_118670 = fluree.db.permissions.parse_rules(db,inst_118665);
var state_118691__$1 = state_118691;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_118691__$1,(20),inst_118670);
} else {
if((state_val_118692 === (8))){
var inst_118625 = (state_118691[(7)]);
var state_118691__$1 = state_118691;
var statearr_118719_118744 = state_118691__$1;
(statearr_118719_118744[(2)] = inst_118625);

(statearr_118719_118744[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$permissions$role_permissions_$_state_machine__99037__auto__ = null;
var fluree$db$permissions$role_permissions_$_state_machine__99037__auto____0 = (function (){
var statearr_118720 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_118720[(0)] = fluree$db$permissions$role_permissions_$_state_machine__99037__auto__);

(statearr_118720[(1)] = (1));

return statearr_118720;
});
var fluree$db$permissions$role_permissions_$_state_machine__99037__auto____1 = (function (state_118691){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_118691);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e118721){if((e118721 instanceof Object)){
var ex__99040__auto__ = e118721;
var statearr_118722_118745 = state_118691;
(statearr_118722_118745[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_118691);

return cljs.core.cst$kw$recur;
} else {
throw e118721;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__118746 = state_118691;
state_118691 = G__118746;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$permissions$role_permissions_$_state_machine__99037__auto__ = function(state_118691){
switch(arguments.length){
case 0:
return fluree$db$permissions$role_permissions_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$permissions$role_permissions_$_state_machine__99037__auto____1.call(this,state_118691);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$permissions$role_permissions_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$permissions$role_permissions_$_state_machine__99037__auto____0;
fluree$db$permissions$role_permissions_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$permissions$role_permissions_$_state_machine__99037__auto____1;
return fluree$db$permissions$role_permissions_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_118723 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_118723[(6)] = c__99059__auto__);

return statearr_118723;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
fluree.db.permissions.permission_map = (function fluree$db$permissions$permission_map(db,roles,permission_type){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_118793){
var state_val_118794 = (state_118793[(1)]);
if((state_val_118794 === (7))){
var inst_118764 = (state_118793[(7)]);
var state_118793__$1 = state_118793;
var statearr_118795_118813 = state_118793__$1;
(statearr_118795_118813[(2)] = inst_118764);

(statearr_118795_118813[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118794 === (1))){
var state_118793__$1 = state_118793;
var statearr_118796_118814 = state_118793__$1;
(statearr_118796_118814[(2)] = null);

(statearr_118796_118814[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118794 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_118793,(3),Error,null,(2));
var inst_118759 = cljs.core.seq(roles);
var inst_118760 = cljs.core.first(inst_118759);
var inst_118761 = cljs.core.next(inst_118759);
var inst_118762 = cljs.core.PersistentVector.EMPTY;
var inst_118763 = roles;
var inst_118764 = inst_118762;
var state_118793__$1 = (function (){var statearr_118797 = state_118793;
(statearr_118797[(7)] = inst_118764);

(statearr_118797[(8)] = inst_118760);

(statearr_118797[(9)] = inst_118761);

(statearr_118797[(10)] = inst_118763);

return statearr_118797;
})();
var statearr_118798_118815 = state_118793__$1;
(statearr_118798_118815[(2)] = null);

(statearr_118798_118815[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118794 === (6))){
var inst_118783 = (state_118793[(2)]);
var inst_118785 = (function (){var all_parsed_rules = inst_118783;
return ((function (all_parsed_rules,inst_118783,state_val_118794,c__99059__auto__){
return (function (acc,p__118784){
var vec__118799 = p__118784;
var path = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__118799,(0),null);
var function$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__118799,(1),null);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc,path,((function (vec__118799,path,function$,all_parsed_rules,inst_118783,state_val_118794,c__99059__auto__){
return (function (p1__118747_SHARP_){
if((p1__118747_SHARP_ == null)){
if(cljs.core.boolean_QMARK_(function$)){
return function$;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [function$], null);
}
} else {
if(((p1__118747_SHARP_ === true) || (function$ === true))){
return true;
} else {
if(((p1__118747_SHARP_ === false) && (function$ === false))){
return false;
} else {
if(cljs.core.vector_QMARK_(p1__118747_SHARP_)){
if(function$ === false){
return p1__118747_SHARP_;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__118747_SHARP_,function$);
}
} else {
if((p1__118747_SHARP_ == null)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [function$], null);
} else {
return null;
}
}
}
}
}
});})(vec__118799,path,function$,all_parsed_rules,inst_118783,state_val_118794,c__99059__auto__))
);
});
;})(all_parsed_rules,inst_118783,state_val_118794,c__99059__auto__))
})();
var inst_118786 = [cljs.core.cst$kw$root_QMARK_];
var inst_118787 = [false];
var inst_118788 = cljs.core.PersistentHashMap.fromArrays(inst_118786,inst_118787);
var inst_118789 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_118785,inst_118788,inst_118783);
var state_118793__$1 = state_118793;
var statearr_118802_118816 = state_118793__$1;
(statearr_118802_118816[(2)] = inst_118789);


cljs.core.async.impl.ioc_helpers.process_exception(state_118793__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_118794 === (3))){
var inst_118748 = (state_118793[(2)]);
var state_118793__$1 = state_118793;
var statearr_118803_118817 = state_118793__$1;
(statearr_118803_118817[(2)] = inst_118748);


cljs.core.async.impl.ioc_helpers.process_exception(state_118793__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_118794 === (2))){
var inst_118791 = (state_118793[(2)]);
var state_118793__$1 = state_118793;
return cljs.core.async.impl.ioc_helpers.return_chan(state_118793__$1,inst_118791);
} else {
if((state_val_118794 === (9))){
var inst_118781 = (state_118793[(2)]);
var state_118793__$1 = state_118793;
var statearr_118804_118818 = state_118793__$1;
(statearr_118804_118818[(2)] = inst_118781);

(statearr_118804_118818[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118794 === (5))){
var inst_118770 = (state_118793[(11)]);
var inst_118763 = (state_118793[(10)]);
var inst_118769 = cljs.core.seq(inst_118763);
var inst_118770__$1 = cljs.core.first(inst_118769);
var inst_118771 = cljs.core.next(inst_118769);
var inst_118772 = cljs.core.not(inst_118770__$1);
var state_118793__$1 = (function (){var statearr_118805 = state_118793;
(statearr_118805[(12)] = inst_118771);

(statearr_118805[(11)] = inst_118770__$1);

return statearr_118805;
})();
if(inst_118772){
var statearr_118806_118819 = state_118793__$1;
(statearr_118806_118819[(1)] = (7));

} else {
var statearr_118807_118820 = state_118793__$1;
(statearr_118807_118820[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118794 === (10))){
var inst_118764 = (state_118793[(7)]);
var inst_118777 = (state_118793[(2)]);
var inst_118778 = fluree.db.util.async.throw_err(inst_118777);
var inst_118779 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_118764,inst_118778);
var state_118793__$1 = state_118793;
var statearr_118808_118821 = state_118793__$1;
(statearr_118808_118821[(2)] = inst_118779);

(statearr_118808_118821[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118794 === (8))){
var inst_118770 = (state_118793[(11)]);
var inst_118775 = fluree.db.permissions.role_permissions(db,inst_118770,permission_type);
var state_118793__$1 = state_118793;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_118793__$1,(10),inst_118775);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$permissions$permission_map_$_state_machine__99037__auto__ = null;
var fluree$db$permissions$permission_map_$_state_machine__99037__auto____0 = (function (){
var statearr_118809 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_118809[(0)] = fluree$db$permissions$permission_map_$_state_machine__99037__auto__);

(statearr_118809[(1)] = (1));

return statearr_118809;
});
var fluree$db$permissions$permission_map_$_state_machine__99037__auto____1 = (function (state_118793){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_118793);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e118810){if((e118810 instanceof Object)){
var ex__99040__auto__ = e118810;
var statearr_118811_118822 = state_118793;
(statearr_118811_118822[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_118793);

return cljs.core.cst$kw$recur;
} else {
throw e118810;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__118823 = state_118793;
state_118793 = G__118823;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$permissions$permission_map_$_state_machine__99037__auto__ = function(state_118793){
switch(arguments.length){
case 0:
return fluree$db$permissions$permission_map_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$permissions$permission_map_$_state_machine__99037__auto____1.call(this,state_118793);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$permissions$permission_map_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$permissions$permission_map_$_state_machine__99037__auto____0;
fluree$db$permissions$permission_map_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$permissions$permission_map_$_state_machine__99037__auto____1;
return fluree$db$permissions$permission_map_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_118812 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_118812[(6)] = c__99059__auto__);

return statearr_118812;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

//# sourceMappingURL=permissions.js.map?rel=1593118621929
