// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"spot","spot",-1706962147),idx)) && ((!((start_flake.o == null)))) && (cljs.core._EQ_.call(null,start_flake.o,end_flake.o)) && (cljs.core._EQ_.call(null,(-1),start_flake.p)) && (cljs.core._EQ_.call(null,fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__4126__auto__ = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__13038 = match;
var p1 = cljs.core.nth.call(null,vec__13038,(0),null);
var p2 = cljs.core.nth.call(null,vec__13038,(1),null);
var p3 = cljs.core.nth.call(null,vec__13038,(2),null);
var t = cljs.core.nth.call(null,vec__13038,(3),null);
var op = cljs.core.nth.call(null,vec__13038,(4),null);
var m = cljs.core.nth.call(null,vec__13038,(5),null);
var G__13041 = idx;
var G__13041__$1 = (((G__13041 instanceof cljs.core.Keyword))?G__13041.fqn:null);
switch (G__13041__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__13041__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__13043 = idx;
var G__13043__$1 = (((G__13043 instanceof cljs.core.Keyword))?G__13043.fqn:null);
switch (G__13043__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__13043__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__13045 = idx;
var G__13045__$1 = (((G__13045 instanceof cljs.core.Keyword))?G__13045.fqn:null);
switch (G__13045__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__13045__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__13048 = arguments.length;
switch (G__13048) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.call(null,db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.call(null,db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.call(null,db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__13049 = (function (){var pred__13052 = cljs.core.identical_QMARK_;
var expr__13053 = test;
if(cljs.core.truth_(pred__13052.call(null,cljs.core._EQ_,expr__13053))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__13052.call(null,cljs.core._LT_,expr__13053))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_(pred__13052.call(null,cljs.core._LT__EQ_,expr__13053))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__13052.call(null,cljs.core._GT_,expr__13053))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
if(cljs.core.truth_(pred__13052.call(null,cljs.core._GT__EQ_,expr__13053))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__13053)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.call(null,vec__13049,(0),null);
var start_match = cljs.core.nth.call(null,vec__13049,(1),null);
var end_test = cljs.core.nth.call(null,vec__13049,(2),null);
var end_match = cljs.core.nth.call(null,vec__13049,(3),null);
return fluree.db.query.range.time_range.call(null,db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.call(null,db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_13266){
var state_val_13267 = (state_13266[(1)]);
if((state_val_13267 === (65))){
var inst_13219 = (state_13266[(7)]);
var inst_13187 = (state_13266[(8)]);
var inst_13231 = cljs.core.into.call(null,inst_13219,inst_13187);
var state_13266__$1 = state_13266;
var statearr_13268_13384 = state_13266__$1;
(statearr_13268_13384[(2)] = inst_13231);

(statearr_13268_13384[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (70))){
var inst_13249 = (state_13266[(2)]);
var inst_13250 = cljs.core.not.call(null,inst_13249);
var state_13266__$1 = state_13266;
if(inst_13250){
var statearr_13269_13385 = state_13266__$1;
(statearr_13269_13385[(1)] = (71));

} else {
var statearr_13270_13386 = state_13266__$1;
(statearr_13270_13386[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (62))){
var inst_13201 = (state_13266[(9)]);
var inst_13240 = (state_13266[(10)]);
var inst_13240__$1 = (state_13266[(2)]);
var inst_13241 = cljs.core.count.call(null,inst_13240__$1);
var state_13266__$1 = (function (){var statearr_13271 = state_13266;
(statearr_13271[(11)] = inst_13241);

(statearr_13271[(10)] = inst_13240__$1);

return statearr_13271;
})();
if(cljs.core.truth_(inst_13201)){
var statearr_13272_13387 = state_13266__$1;
(statearr_13272_13387[(1)] = (68));

} else {
var statearr_13273_13388 = state_13266__$1;
(statearr_13273_13388[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (74))){
var inst_13241 = (state_13266[(11)]);
var inst_13240 = (state_13266[(10)]);
var inst_13255 = (state_13266[(2)]);
var inst_13256 = fluree.db.util.async.throw_err.call(null,inst_13255);
var inst_13185 = inst_13256;
var inst_13186 = inst_13241;
var inst_13187 = inst_13240;
var state_13266__$1 = (function (){var statearr_13274 = state_13266;
(statearr_13274[(12)] = inst_13185);

(statearr_13274[(13)] = inst_13186);

(statearr_13274[(8)] = inst_13187);

return statearr_13274;
})();
var statearr_13275_13389 = state_13266__$1;
(statearr_13275_13389[(2)] = null);

(statearr_13275_13389[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (7))){
var inst_13068 = (state_13266[(14)]);
var state_13266__$1 = state_13266;
var statearr_13276_13390 = state_13266__$1;
(statearr_13276_13390[(2)] = inst_13068);

(statearr_13276_13390[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (59))){
var inst_13185 = (state_13266[(12)]);
var inst_13200 = (state_13266[(2)]);
var inst_13201 = fluree.db.dbproto._rhs.call(null,inst_13185);
var state_13266__$1 = (function (){var statearr_13277 = state_13266;
(statearr_13277[(9)] = inst_13201);

(statearr_13277[(15)] = inst_13200);

return statearr_13277;
})();
var statearr_13278_13391 = state_13266__$1;
(statearr_13278_13391[(1)] = (60));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (20))){
var inst_13069 = (state_13266[(16)]);
var inst_13116 = (state_13266[(2)]);
var inst_13117 = (inst_13069 == null);
var state_13266__$1 = (function (){var statearr_13280 = state_13266;
(statearr_13280[(17)] = inst_13116);

return statearr_13280;
})();
if(cljs.core.truth_(inst_13117)){
var statearr_13281_13392 = state_13266__$1;
(statearr_13281_13392[(1)] = (22));

} else {
var statearr_13282_13393 = state_13266__$1;
(statearr_13282_13393[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (72))){
var inst_13180 = (state_13266[(18)]);
var inst_13201 = (state_13266[(9)]);
var inst_13253 = fluree.db.dbproto._lookup_leaf.call(null,inst_13180,inst_13201);
var state_13266__$1 = state_13266;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13266__$1,(74),inst_13253);
} else {
if((state_val_13267 === (58))){
var inst_13193 = (state_13266[(19)]);
var state_13266__$1 = state_13266;
var statearr_13283_13394 = state_13266__$1;
(statearr_13283_13394[(2)] = inst_13193);

(statearr_13283_13394[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (60))){
var inst_13159 = (state_13266[(20)]);
var inst_13186 = (state_13266[(13)]);
var inst_13187 = (state_13266[(8)]);
var inst_13200 = (state_13266[(15)]);
var inst_13203 = (inst_13159 - inst_13186);
var inst_13204 = fluree.db.flake.take.call(null,inst_13203,inst_13200);
var inst_13205 = cljs.core.into.call(null,inst_13204,inst_13187);
var state_13266__$1 = state_13266;
var statearr_13284_13395 = state_13266__$1;
(statearr_13284_13395[(2)] = inst_13205);

(statearr_13284_13395[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (27))){
var inst_13076 = (state_13266[(21)]);
var inst_13125 = (state_13266[(2)]);
var inst_13126 = (inst_13076 == null);
var state_13266__$1 = (function (){var statearr_13285 = state_13266;
(statearr_13285[(22)] = inst_13125);

return statearr_13285;
})();
if(cljs.core.truth_(inst_13126)){
var statearr_13286_13396 = state_13266__$1;
(statearr_13286_13396[(1)] = (28));

} else {
var statearr_13287_13397 = state_13266__$1;
(statearr_13287_13397[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (1))){
var state_13266__$1 = state_13266;
var statearr_13288_13398 = state_13266__$1;
(statearr_13288_13398[(2)] = null);

(statearr_13288_13398[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (69))){
var inst_13201 = (state_13266[(9)]);
var state_13266__$1 = state_13266;
var statearr_13289_13399 = state_13266__$1;
(statearr_13289_13399[(2)] = inst_13201);

(statearr_13289_13399[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (24))){
var inst_13121 = (state_13266[(2)]);
var state_13266__$1 = state_13266;
if(cljs.core.truth_(inst_13121)){
var statearr_13290_13400 = state_13266__$1;
(statearr_13290_13400[(1)] = (25));

} else {
var statearr_13291_13401 = state_13266__$1;
(statearr_13291_13401[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (55))){
var inst_13261 = (state_13266[(2)]);
var _ = (function (){var statearr_13292 = state_13266;
(statearr_13292[(4)] = cljs.core.rest.call(null,(state_13266[(4)])));

return statearr_13292;
})();
var state_13266__$1 = state_13266;
var statearr_13293_13402 = state_13266__$1;
(statearr_13293_13402[(2)] = inst_13261);

(statearr_13293_13402[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (39))){
var inst_13141 = (state_13266[(2)]);
var state_13266__$1 = state_13266;
var statearr_13294_13403 = state_13266__$1;
(statearr_13294_13403[(2)] = inst_13141);

(statearr_13294_13403[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (46))){
var inst_13155 = (state_13266[(23)]);
var state_13266__$1 = state_13266;
var statearr_13295_13404 = state_13266__$1;
(statearr_13295_13404[(2)] = inst_13155);

(statearr_13295_13404[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (4))){
var inst_13055 = (state_13266[(2)]);
var state_13266__$1 = state_13266;
var statearr_13296_13405 = state_13266__$1;
(statearr_13296_13405[(2)] = inst_13055);

(statearr_13296_13405[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (54))){
var inst_13185 = (state_13266[(12)]);
var inst_13175 = (state_13266[(24)]);
var inst_13170 = (state_13266[(25)]);
var inst_13171 = (state_13266[(26)]);
var inst_13189 = fluree.db.dbproto._resolve_history_range.call(null,inst_13185,inst_13170,inst_13171,inst_13175);
var state_13266__$1 = state_13266;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13266__$1,(56),inst_13189);
} else {
if((state_val_13267 === (15))){
var inst_13070 = (state_13266[(27)]);
var state_13266__$1 = state_13266;
var statearr_13297_13406 = state_13266__$1;
(statearr_13297_13406[(2)] = inst_13070);

(statearr_13297_13406[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (48))){
var inst_13165 = (state_13266[(28)]);
var inst_13159 = (state_13266[(2)]);
var inst_13160 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_13161 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13162 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_13163 = (new cljs.core.PersistentVector(null,3,(5),inst_13161,inst_13162,null));
var inst_13164 = cljs.core.get_in.call(null,db,inst_13163);
var inst_13165__$1 = new cljs.core.Keyword(null,"from-t","from-t",1730913525).cljs$core$IFn$_invoke$arity$1(opts);
var state_13266__$1 = (function (){var statearr_13298 = state_13266;
(statearr_13298[(20)] = inst_13159);

(statearr_13298[(28)] = inst_13165__$1);

(statearr_13298[(29)] = inst_13160);

(statearr_13298[(30)] = inst_13164);

return statearr_13298;
})();
if(cljs.core.truth_(inst_13165__$1)){
var statearr_13299_13407 = state_13266__$1;
(statearr_13299_13407[(1)] = (49));

} else {
var statearr_13300_13408 = state_13266__$1;
(statearr_13300_13408[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (50))){
var inst_13168 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var state_13266__$1 = state_13266;
var statearr_13301_13409 = state_13266__$1;
(statearr_13301_13409[(2)] = inst_13168);

(statearr_13301_13409[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (21))){
var inst_13112 = (state_13266[(2)]);
var inst_13113 = fluree.db.util.async.throw_err.call(null,inst_13112);
var state_13266__$1 = state_13266;
var statearr_13302_13410 = state_13266__$1;
(statearr_13302_13410[(2)] = inst_13113);

(statearr_13302_13410[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (31))){
var state_13266__$1 = state_13266;
var statearr_13303_13411 = state_13266__$1;
(statearr_13303_13411[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_13303_13411[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (32))){
var inst_13076 = (state_13266[(21)]);
var state_13266__$1 = state_13266;
var statearr_13304_13412 = state_13266__$1;
(statearr_13304_13412[(2)] = inst_13076);

(statearr_13304_13412[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (40))){
var inst_13080 = (state_13266[(31)]);
var state_13266__$1 = state_13266;
var statearr_13305_13413 = state_13266__$1;
(statearr_13305_13413[(2)] = inst_13080);

(statearr_13305_13413[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (56))){
var inst_13153 = (state_13266[(32)]);
var inst_13192 = (state_13266[(33)]);
var inst_13154 = (state_13266[(34)]);
var inst_13191 = (state_13266[(2)]);
var inst_13192__$1 = fluree.db.util.async.throw_err.call(null,inst_13191);
var inst_13193 = fluree.db.flake.subrange.call(null,inst_13192__$1,start_test,inst_13153,end_test,inst_13154);
var inst_13194 = fluree.db.query.range.value_with_nil_pred.call(null,idx,inst_13153,inst_13154);
var state_13266__$1 = (function (){var statearr_13306 = state_13266;
(statearr_13306[(33)] = inst_13192__$1);

(statearr_13306[(19)] = inst_13193);

return statearr_13306;
})();
if(inst_13194){
var statearr_13307_13414 = state_13266__$1;
(statearr_13307_13414[(1)] = (57));

} else {
var statearr_13308_13415 = state_13266__$1;
(statearr_13308_13415[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (33))){
var inst_13073 = (state_13266[(35)]);
var inst_13134 = (state_13266[(2)]);
var state_13266__$1 = (function (){var statearr_13309 = state_13266;
(statearr_13309[(36)] = inst_13134);

return statearr_13309;
})();
if(cljs.core.truth_(inst_13073)){
var statearr_13310_13416 = state_13266__$1;
(statearr_13310_13416[(1)] = (34));

} else {
var statearr_13311_13417 = state_13266__$1;
(statearr_13311_13417[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (13))){
var inst_13094 = (state_13266[(2)]);
var inst_13095 = fluree.db.util.async.throw_err.call(null,inst_13094);
var state_13266__$1 = state_13266;
var statearr_13312_13418 = state_13266__$1;
(statearr_13312_13418[(2)] = inst_13095);

(statearr_13312_13418[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (22))){
var inst_13107 = (state_13266[(37)]);
var state_13266__$1 = state_13266;
var statearr_13313_13419 = state_13266__$1;
(statearr_13313_13419[(2)] = inst_13107);

(statearr_13313_13419[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (36))){
var inst_13080 = (state_13266[(31)]);
var inst_13143 = (state_13266[(2)]);
var state_13266__$1 = (function (){var statearr_13314 = state_13266;
(statearr_13314[(38)] = inst_13143);

return statearr_13314;
})();
if(cljs.core.truth_(inst_13080)){
var statearr_13315_13420 = state_13266__$1;
(statearr_13315_13420[(1)] = (40));

} else {
var statearr_13316_13421 = state_13266__$1;
(statearr_13316_13421[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (41))){
var inst_13146 = (cljs.core._LT__EQ_ === end_test);
var state_13266__$1 = state_13266;
if(cljs.core.truth_(inst_13146)){
var statearr_13317_13422 = state_13266__$1;
(statearr_13317_13422[(1)] = (43));

} else {
var statearr_13318_13423 = state_13266__$1;
(statearr_13318_13423[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (43))){
var state_13266__$1 = state_13266;
var statearr_13319_13424 = state_13266__$1;
(statearr_13319_13424[(2)] = (2147483647));

(statearr_13319_13424[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (61))){
var inst_13186 = (state_13266[(13)]);
var inst_13200 = (state_13266[(15)]);
var inst_13214 = cljs.core.seq.call(null,inst_13200);
var inst_13215 = cljs.core.first.call(null,inst_13214);
var inst_13216 = cljs.core.next.call(null,inst_13214);
var inst_13217 = inst_13200;
var inst_13218 = inst_13186;
var inst_13219 = inst_13200;
var state_13266__$1 = (function (){var statearr_13320 = state_13266;
(statearr_13320[(39)] = inst_13216);

(statearr_13320[(7)] = inst_13219);

(statearr_13320[(40)] = inst_13218);

(statearr_13320[(41)] = inst_13215);

(statearr_13320[(42)] = inst_13217);

return statearr_13320;
})();
var statearr_13321_13425 = state_13266__$1;
(statearr_13321_13425[(2)] = null);

(statearr_13321_13425[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (29))){
var state_13266__$1 = state_13266;
var statearr_13322_13426 = state_13266__$1;
(statearr_13322_13426[(2)] = false);

(statearr_13322_13426[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (44))){
var state_13266__$1 = state_13266;
var statearr_13323_13427 = state_13266__$1;
(statearr_13323_13427[(2)] = fluree.db.util.core.min_integer);

(statearr_13323_13427[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (6))){
var inst_13068 = (state_13266[(14)]);
var inst_13083 = fluree.db.dbproto._subid.call(null,db,inst_13068);
var state_13266__$1 = state_13266;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13266__$1,(9),inst_13083);
} else {
if((state_val_13267 === (28))){
var inst_13116 = (state_13266[(17)]);
var state_13266__$1 = state_13266;
var statearr_13324_13428 = state_13266__$1;
(statearr_13324_13428[(2)] = inst_13116);

(statearr_13324_13428[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (64))){
var inst_13238 = (state_13266[(2)]);
var state_13266__$1 = state_13266;
var statearr_13325_13429 = state_13266__$1;
(statearr_13325_13429[(2)] = inst_13238);

(statearr_13325_13429[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (51))){
var inst_13170 = (state_13266[(2)]);
var inst_13171 = new cljs.core.Keyword(null,"to-t","to-t",569467359).cljs$core$IFn$_invoke$arity$1(opts);
var inst_13172 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13173 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_13174 = (new cljs.core.PersistentVector(null,2,(5),inst_13172,inst_13173,null));
var inst_13175 = cljs.core.get_in.call(null,db,inst_13174);
var inst_13176 = cljs.core.get.call(null,db,idx);
var inst_13177 = fluree.db.dbproto._resolve.call(null,inst_13176);
var state_13266__$1 = (function (){var statearr_13326 = state_13266;
(statearr_13326[(24)] = inst_13175);

(statearr_13326[(25)] = inst_13170);

(statearr_13326[(26)] = inst_13171);

return statearr_13326;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13266__$1,(52),inst_13177);
} else {
if((state_val_13267 === (25))){
var state_13266__$1 = state_13266;
var statearr_13327_13430 = state_13266__$1;
(statearr_13327_13430[(2)] = (-1));

(statearr_13327_13430[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (34))){
var inst_13073 = (state_13266[(35)]);
var state_13266__$1 = state_13266;
var statearr_13328_13431 = state_13266__$1;
(statearr_13328_13431[(2)] = inst_13073);

(statearr_13328_13431[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (17))){
var inst_13103 = (state_13266[(2)]);
var inst_13104 = fluree.db.util.async.throw_err.call(null,inst_13103);
var state_13266__$1 = state_13266;
var statearr_13329_13432 = state_13266__$1;
(statearr_13329_13432[(2)] = inst_13104);

(statearr_13329_13432[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (3))){
var inst_13264 = (state_13266[(2)]);
var state_13266__$1 = state_13266;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13266__$1,inst_13264);
} else {
if((state_val_13267 === (12))){
var inst_13070 = (state_13266[(27)]);
var inst_13098 = (state_13266[(2)]);
var inst_13099 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_13070);
var state_13266__$1 = (function (){var statearr_13331 = state_13266;
(statearr_13331[(43)] = inst_13098);

return statearr_13331;
})();
if(inst_13099){
var statearr_13332_13433 = state_13266__$1;
(statearr_13332_13433[(1)] = (14));

} else {
var statearr_13333_13434 = state_13266__$1;
(statearr_13333_13434[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (2))){
var inst_13068 = (state_13266[(14)]);
var inst_13074 = (state_13266[(44)]);
var inst_13067 = (state_13266[(45)]);
var _ = (function (){var statearr_13334 = state_13266;
(statearr_13334[(4)] = cljs.core.cons.call(null,(5),(state_13266[(4)])));

return statearr_13334;
})();
var inst_13067__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,start_match);
var inst_13068__$1 = cljs.core.nth.call(null,inst_13067__$1,(0),null);
var inst_13069 = cljs.core.nth.call(null,inst_13067__$1,(1),null);
var inst_13070 = cljs.core.nth.call(null,inst_13067__$1,(2),null);
var inst_13071 = cljs.core.nth.call(null,inst_13067__$1,(3),null);
var inst_13072 = cljs.core.nth.call(null,inst_13067__$1,(4),null);
var inst_13073 = cljs.core.nth.call(null,inst_13067__$1,(5),null);
var inst_13074__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,end_match);
var inst_13075 = cljs.core.nth.call(null,inst_13074__$1,(0),null);
var inst_13076 = cljs.core.nth.call(null,inst_13074__$1,(1),null);
var inst_13077 = cljs.core.nth.call(null,inst_13074__$1,(2),null);
var inst_13078 = cljs.core.nth.call(null,inst_13074__$1,(3),null);
var inst_13079 = cljs.core.nth.call(null,inst_13074__$1,(4),null);
var inst_13080 = cljs.core.nth.call(null,inst_13074__$1,(5),null);
var inst_13081 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_13068__$1);
var state_13266__$1 = (function (){var statearr_13335 = state_13266;
(statearr_13335[(46)] = inst_13079);

(statearr_13335[(47)] = inst_13075);

(statearr_13335[(48)] = inst_13078);

(statearr_13335[(14)] = inst_13068__$1);

(statearr_13335[(31)] = inst_13080);

(statearr_13335[(44)] = inst_13074__$1);

(statearr_13335[(49)] = inst_13071);

(statearr_13335[(50)] = inst_13077);

(statearr_13335[(45)] = inst_13067__$1);

(statearr_13335[(35)] = inst_13073);

(statearr_13335[(21)] = inst_13076);

(statearr_13335[(51)] = inst_13072);

(statearr_13335[(27)] = inst_13070);

(statearr_13335[(16)] = inst_13069);

return statearr_13335;
})();
if(inst_13081){
var statearr_13336_13435 = state_13266__$1;
(statearr_13336_13435[(1)] = (6));

} else {
var statearr_13337_13436 = state_13266__$1;
(statearr_13337_13436[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (66))){
var inst_13219 = (state_13266[(7)]);
var inst_13218 = (state_13266[(40)]);
var inst_13226 = (state_13266[(52)]);
var inst_13233 = (inst_13218 + (1));
var tmp13330 = inst_13219;
var inst_13217 = inst_13226;
var inst_13218__$1 = inst_13233;
var inst_13219__$1 = tmp13330;
var state_13266__$1 = (function (){var statearr_13338 = state_13266;
(statearr_13338[(7)] = inst_13219__$1);

(statearr_13338[(40)] = inst_13218__$1);

(statearr_13338[(42)] = inst_13217);

return statearr_13338;
})();
var statearr_13339_13437 = state_13266__$1;
(statearr_13339_13437[(2)] = null);

(statearr_13339_13437[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (23))){
var state_13266__$1 = state_13266;
var statearr_13340_13438 = state_13266__$1;
(statearr_13340_13438[(2)] = false);

(statearr_13340_13438[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (47))){
var state_13266__$1 = state_13266;
var statearr_13341_13439 = state_13266__$1;
(statearr_13341_13439[(2)] = fluree.db.util.core.max_long);

(statearr_13341_13439[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (35))){
var inst_13137 = (cljs.core._GT__EQ_ === start_test);
var state_13266__$1 = state_13266;
if(cljs.core.truth_(inst_13137)){
var statearr_13342_13440 = state_13266__$1;
(statearr_13342_13440[(1)] = (37));

} else {
var statearr_13343_13441 = state_13266__$1;
(statearr_13343_13441[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (19))){
var inst_13077 = (state_13266[(50)]);
var state_13266__$1 = state_13266;
var statearr_13344_13442 = state_13266__$1;
(statearr_13344_13442[(2)] = inst_13077);

(statearr_13344_13442[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (57))){
var inst_13159 = (state_13266[(20)]);
var inst_13152 = (state_13266[(53)]);
var inst_13185 = (state_13266[(12)]);
var inst_13098 = (state_13266[(43)]);
var inst_13180 = (state_13266[(18)]);
var inst_13186 = (state_13266[(13)]);
var inst_13079 = (state_13266[(46)]);
var inst_13153 = (state_13266[(32)]);
var inst_13187 = (state_13266[(8)]);
var inst_13160 = (state_13266[(29)]);
var inst_13089 = (state_13266[(54)]);
var inst_13078 = (state_13266[(48)]);
var inst_13192 = (state_13266[(33)]);
var inst_13074 = (state_13266[(44)]);
var inst_13071 = (state_13266[(49)]);
var inst_13116 = (state_13266[(17)]);
var inst_13067 = (state_13266[(45)]);
var inst_13125 = (state_13266[(22)]);
var inst_13164 = (state_13266[(30)]);
var inst_13175 = (state_13266[(24)]);
var inst_13143 = (state_13266[(38)]);
var inst_13072 = (state_13266[(51)]);
var inst_13193 = (state_13266[(19)]);
var inst_13107 = (state_13266[(37)]);
var inst_13170 = (state_13266[(25)]);
var inst_13134 = (state_13266[(36)]);
var inst_13154 = (state_13266[(34)]);
var inst_13171 = (state_13266[(26)]);
var inst_13196 = (function (){var no_filter_QMARK_ = true;
var next_node = inst_13185;
var vec__13064 = inst_13074;
var flakes = inst_13192;
var s1 = inst_13089;
var o2 = inst_13116;
var t1 = inst_13071;
var vec__13061 = inst_13067;
var i = inst_13186;
var m1 = inst_13143;
var root_node = inst_13180;
var to_t = inst_13171;
var s2 = inst_13098;
var p2 = inst_13134;
var permissions = inst_13160;
var limit = inst_13159;
var start_flake = inst_13153;
var acc = inst_13187;
var t2 = inst_13078;
var op1 = inst_13072;
var o1 = inst_13107;
var end_flake = inst_13154;
var base_result = inst_13193;
var p1 = inst_13125;
var idx_compare = inst_13164;
var op2 = inst_13079;
var from_t = inst_13170;
var m2 = inst_13152;
var novelty = inst_13175;
return (function (filtered_result,f){
if(cljs.core._EQ_.call(null,f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.call(null,filtered_result,f);
}
});
})();
var inst_13197 = cljs.core.reduce.call(null,inst_13196,inst_13193,inst_13193);
var state_13266__$1 = state_13266;
var statearr_13345_13443 = state_13266__$1;
(statearr_13345_13443[(2)] = inst_13197);

(statearr_13345_13443[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (68))){
var inst_13159 = (state_13266[(20)]);
var inst_13241 = (state_13266[(11)]);
var inst_13201 = (state_13266[(9)]);
var inst_13164 = (state_13266[(30)]);
var inst_13154 = (state_13266[(34)]);
var inst_13243 = inst_13164.call(null,inst_13201,inst_13154);
var inst_13244 = (inst_13243 < (0));
var inst_13245 = (inst_13241 < inst_13159);
var inst_13246 = ((inst_13244) && (inst_13245));
var state_13266__$1 = state_13266;
var statearr_13346_13444 = state_13266__$1;
(statearr_13346_13444[(2)] = inst_13246);

(statearr_13346_13444[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (11))){
var inst_13075 = (state_13266[(47)]);
var state_13266__$1 = state_13266;
var statearr_13348_13445 = state_13266__$1;
(statearr_13348_13445[(2)] = inst_13075);

(statearr_13348_13445[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (9))){
var inst_13085 = (state_13266[(2)]);
var inst_13086 = fluree.db.util.async.throw_err.call(null,inst_13085);
var state_13266__$1 = state_13266;
var statearr_13349_13446 = state_13266__$1;
(statearr_13349_13446[(2)] = inst_13086);

(statearr_13349_13446[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (5))){
var _ = (function (){var statearr_13350 = state_13266;
(statearr_13350[(4)] = cljs.core.rest.call(null,(state_13266[(4)])));

return statearr_13350;
})();
var state_13266__$1 = state_13266;
var ex13347 = (state_13266__$1[(2)]);
var statearr_13351_13447 = state_13266__$1;
(statearr_13351_13447[(5)] = ex13347);


if((ex13347 instanceof Error)){
var statearr_13352_13448 = state_13266__$1;
(statearr_13352_13448[(1)] = (4));

(statearr_13352_13448[(5)] = null);

} else {
throw ex13347;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (14))){
var inst_13070 = (state_13266[(27)]);
var inst_13101 = fluree.db.dbproto._subid.call(null,db,inst_13070);
var state_13266__$1 = state_13266;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13266__$1,(17),inst_13101);
} else {
if((state_val_13267 === (45))){
var inst_13150 = (state_13266[(2)]);
var state_13266__$1 = state_13266;
var statearr_13353_13449 = state_13266__$1;
(statearr_13353_13449[(2)] = inst_13150);

(statearr_13353_13449[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (53))){
var inst_13183 = (state_13266[(2)]);
var inst_13184 = fluree.db.util.async.throw_err.call(null,inst_13183);
var inst_13185 = inst_13184;
var inst_13186 = (0);
var inst_13187 = null;
var state_13266__$1 = (function (){var statearr_13354 = state_13266;
(statearr_13354[(12)] = inst_13185);

(statearr_13354[(13)] = inst_13186);

(statearr_13354[(8)] = inst_13187);

return statearr_13354;
})();
var statearr_13355_13450 = state_13266__$1;
(statearr_13355_13450[(2)] = null);

(statearr_13355_13450[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (26))){
var inst_13069 = (state_13266[(16)]);
var state_13266__$1 = state_13266;
var statearr_13356_13451 = state_13266__$1;
(statearr_13356_13451[(2)] = inst_13069);

(statearr_13356_13451[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (16))){
var inst_13077 = (state_13266[(50)]);
var inst_13107 = (state_13266[(2)]);
var inst_13108 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_13077);
var state_13266__$1 = (function (){var statearr_13357 = state_13266;
(statearr_13357[(37)] = inst_13107);

return statearr_13357;
})();
if(inst_13108){
var statearr_13358_13452 = state_13266__$1;
(statearr_13358_13452[(1)] = (18));

} else {
var statearr_13359_13453 = state_13266__$1;
(statearr_13359_13453[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (38))){
var state_13266__$1 = state_13266;
var statearr_13360_13454 = state_13266__$1;
(statearr_13360_13454[(2)] = (2147483647));

(statearr_13360_13454[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (30))){
var inst_13130 = (state_13266[(2)]);
var state_13266__$1 = state_13266;
if(cljs.core.truth_(inst_13130)){
var statearr_13361_13455 = state_13266__$1;
(statearr_13361_13455[(1)] = (31));

} else {
var statearr_13362_13456 = state_13266__$1;
(statearr_13362_13456[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (73))){
var inst_13259 = (state_13266[(2)]);
var state_13266__$1 = state_13266;
var statearr_13363_13457 = state_13266__$1;
(statearr_13363_13457[(2)] = inst_13259);

(statearr_13363_13457[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (10))){
var inst_13075 = (state_13266[(47)]);
var inst_13092 = fluree.db.dbproto._subid.call(null,db,inst_13075);
var state_13266__$1 = state_13266;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13266__$1,(13),inst_13092);
} else {
if((state_val_13267 === (18))){
var inst_13077 = (state_13266[(50)]);
var inst_13110 = fluree.db.dbproto._subid.call(null,db,inst_13077);
var state_13266__$1 = state_13266;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13266__$1,(21),inst_13110);
} else {
if((state_val_13267 === (52))){
var inst_13180 = (state_13266[(18)]);
var inst_13153 = (state_13266[(32)]);
var inst_13179 = (state_13266[(2)]);
var inst_13180__$1 = fluree.db.util.async.throw_err.call(null,inst_13179);
var inst_13181 = fluree.db.dbproto._lookup_leaf.call(null,inst_13180__$1,inst_13153);
var state_13266__$1 = (function (){var statearr_13364 = state_13266;
(statearr_13364[(18)] = inst_13180__$1);

return statearr_13364;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13266__$1,(53),inst_13181);
} else {
if((state_val_13267 === (67))){
var inst_13236 = (state_13266[(2)]);
var state_13266__$1 = state_13266;
var statearr_13365_13458 = state_13266__$1;
(statearr_13365_13458[(2)] = inst_13236);

(statearr_13365_13458[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (71))){
var inst_13240 = (state_13266[(10)]);
var state_13266__$1 = state_13266;
var statearr_13366_13459 = state_13266__$1;
(statearr_13366_13459[(2)] = inst_13240);

(statearr_13366_13459[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (42))){
var inst_13152 = (state_13266[(53)]);
var inst_13098 = (state_13266[(43)]);
var inst_13079 = (state_13266[(46)]);
var inst_13089 = (state_13266[(54)]);
var inst_13078 = (state_13266[(48)]);
var inst_13071 = (state_13266[(49)]);
var inst_13116 = (state_13266[(17)]);
var inst_13125 = (state_13266[(22)]);
var inst_13143 = (state_13266[(38)]);
var inst_13155 = (state_13266[(23)]);
var inst_13072 = (state_13266[(51)]);
var inst_13107 = (state_13266[(37)]);
var inst_13134 = (state_13266[(36)]);
var inst_13152__$1 = (state_13266[(2)]);
var inst_13153 = fluree.db.flake.__GT_Flake.call(null,inst_13089,inst_13125,inst_13107,inst_13071,inst_13072,inst_13143);
var inst_13154 = fluree.db.flake.__GT_Flake.call(null,inst_13098,inst_13134,inst_13116,inst_13078,inst_13079,inst_13152__$1);
var inst_13155__$1 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
var state_13266__$1 = (function (){var statearr_13367 = state_13266;
(statearr_13367[(53)] = inst_13152__$1);

(statearr_13367[(32)] = inst_13153);

(statearr_13367[(23)] = inst_13155__$1);

(statearr_13367[(34)] = inst_13154);

return statearr_13367;
})();
if(cljs.core.truth_(inst_13155__$1)){
var statearr_13368_13460 = state_13266__$1;
(statearr_13368_13460[(1)] = (46));

} else {
var statearr_13369_13461 = state_13266__$1;
(statearr_13369_13461[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (37))){
var state_13266__$1 = state_13266;
var statearr_13370_13462 = state_13266__$1;
(statearr_13370_13462[(2)] = fluree.db.util.core.min_integer);

(statearr_13370_13462[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (63))){
var inst_13159 = (state_13266[(20)]);
var inst_13218 = (state_13266[(40)]);
var inst_13217 = (state_13266[(42)]);
var inst_13224 = cljs.core.seq.call(null,inst_13217);
var inst_13225 = cljs.core.first.call(null,inst_13224);
var inst_13226 = cljs.core.next.call(null,inst_13224);
var inst_13227 = (inst_13225 == null);
var inst_13228 = (inst_13218 > inst_13159);
var inst_13229 = ((inst_13227) || (inst_13228));
var state_13266__$1 = (function (){var statearr_13371 = state_13266;
(statearr_13371[(52)] = inst_13226);

return statearr_13371;
})();
if(cljs.core.truth_(inst_13229)){
var statearr_13372_13463 = state_13266__$1;
(statearr_13372_13463[(1)] = (65));

} else {
var statearr_13373_13464 = state_13266__$1;
(statearr_13373_13464[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (8))){
var inst_13075 = (state_13266[(47)]);
var inst_13089 = (state_13266[(2)]);
var inst_13090 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_13075);
var state_13266__$1 = (function (){var statearr_13374 = state_13266;
(statearr_13374[(54)] = inst_13089);

return statearr_13374;
})();
if(inst_13090){
var statearr_13375_13465 = state_13266__$1;
(statearr_13375_13465[(1)] = (10));

} else {
var statearr_13376_13466 = state_13266__$1;
(statearr_13376_13466[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13267 === (49))){
var inst_13165 = (state_13266[(28)]);
var state_13266__$1 = state_13266;
var statearr_13377_13467 = state_13266__$1;
(statearr_13377_13467[(2)] = inst_13165);

(statearr_13377_13467[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2468__auto__ = null;
var fluree$db$query$range$state_machine__2468__auto____0 = (function (){
var statearr_13378 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13378[(0)] = fluree$db$query$range$state_machine__2468__auto__);

(statearr_13378[(1)] = (1));

return statearr_13378;
});
var fluree$db$query$range$state_machine__2468__auto____1 = (function (state_13266){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_13266);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e13379){var ex__2471__auto__ = e13379;
var statearr_13380_13468 = state_13266;
(statearr_13380_13468[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_13266[(4)]))){
var statearr_13381_13469 = state_13266;
(statearr_13381_13469[(1)] = cljs.core.first.call(null,(state_13266[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13470 = state_13266;
state_13266 = G__13470;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2468__auto__ = function(state_13266){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2468__auto____1.call(this,state_13266);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2468__auto____0;
fluree$db$query$range$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2468__auto____1;
return fluree$db$query$range$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_13382 = f__2491__auto__.call(null);
(statearr_13382[(6)] = c__2490__auto__);

return statearr_13382;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_13520){
var state_val_13521 = (state_13520[(1)]);
if((state_val_13521 === (7))){
var state_13520__$1 = state_13520;
var statearr_13522_13541 = state_13520__$1;
(statearr_13522_13541[(2)] = (0));

(statearr_13522_13541[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13521 === (1))){
var inst_13478 = subject_groups;
var inst_13479 = cljs.core.seq.call(null,inst_13478);
var inst_13480 = cljs.core.first.call(null,inst_13479);
var inst_13481 = cljs.core.next.call(null,inst_13479);
var inst_13482 = flake_start;
var inst_13483 = subject_start;
var inst_13484 = cljs.core.PersistentVector.EMPTY;
var inst_13485 = inst_13478;
var inst_13486 = inst_13482;
var inst_13487 = inst_13483;
var inst_13488 = inst_13484;
var state_13520__$1 = (function (){var statearr_13523 = state_13520;
(statearr_13523[(7)] = inst_13481);

(statearr_13523[(8)] = inst_13488);

(statearr_13523[(9)] = inst_13485);

(statearr_13523[(10)] = inst_13486);

(statearr_13523[(11)] = inst_13487);

(statearr_13523[(12)] = inst_13480);

return statearr_13523;
})();
var statearr_13524_13542 = state_13520__$1;
(statearr_13524_13542[(2)] = null);

(statearr_13524_13542[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13521 === (4))){
var inst_13488 = (state_13520[(8)]);
var inst_13486 = (state_13520[(10)]);
var inst_13487 = (state_13520[(11)]);
var inst_13501 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13502 = [inst_13486,inst_13487,inst_13488];
var inst_13503 = (new cljs.core.PersistentVector(null,3,(5),inst_13501,inst_13502,null));
var state_13520__$1 = state_13520;
var statearr_13525_13543 = state_13520__$1;
(statearr_13525_13543[(2)] = inst_13503);

(statearr_13525_13543[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13521 === (6))){
var inst_13516 = (state_13520[(2)]);
var state_13520__$1 = state_13520;
var statearr_13526_13544 = state_13520__$1;
(statearr_13526_13544[(2)] = inst_13516);

(statearr_13526_13544[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13521 === (3))){
var inst_13518 = (state_13520[(2)]);
var state_13520__$1 = state_13520;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13520__$1,inst_13518);
} else {
if((state_val_13521 === (2))){
var inst_13494 = (state_13520[(13)]);
var inst_13485 = (state_13520[(9)]);
var inst_13486 = (state_13520[(10)]);
var inst_13487 = (state_13520[(11)]);
var inst_13493 = cljs.core.seq.call(null,inst_13485);
var inst_13494__$1 = cljs.core.first.call(null,inst_13493);
var inst_13495 = cljs.core.next.call(null,inst_13493);
var inst_13496 = (inst_13494__$1 == null);
var inst_13497 = (inst_13486 >= flake_limit);
var inst_13498 = (inst_13487 >= subject_limit);
var inst_13499 = ((inst_13496) || (inst_13497) || (inst_13498));
var state_13520__$1 = (function (){var statearr_13527 = state_13520;
(statearr_13527[(13)] = inst_13494__$1);

(statearr_13527[(14)] = inst_13495);

return statearr_13527;
})();
if(cljs.core.truth_(inst_13499)){
var statearr_13528_13545 = state_13520__$1;
(statearr_13528_13545[(1)] = (4));

} else {
var statearr_13529_13546 = state_13520__$1;
(statearr_13529_13546[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13521 === (9))){
var inst_13505 = (state_13520[(15)]);
var inst_13494 = (state_13520[(13)]);
var inst_13495 = (state_13520[(14)]);
var inst_13488 = (state_13520[(8)]);
var inst_13486 = (state_13520[(10)]);
var inst_13487 = (state_13520[(11)]);
var inst_13510 = (state_13520[(2)]);
var inst_13511 = (inst_13486 + inst_13505);
var inst_13512 = (inst_13487 + inst_13510);
var inst_13513 = cljs.core.into.call(null,inst_13488,inst_13494);
var inst_13485 = inst_13495;
var inst_13486__$1 = inst_13511;
var inst_13487__$1 = inst_13512;
var inst_13488__$1 = inst_13513;
var state_13520__$1 = (function (){var statearr_13530 = state_13520;
(statearr_13530[(8)] = inst_13488__$1);

(statearr_13530[(9)] = inst_13485);

(statearr_13530[(10)] = inst_13486__$1);

(statearr_13530[(11)] = inst_13487__$1);

return statearr_13530;
})();
var statearr_13531_13547 = state_13520__$1;
(statearr_13531_13547[(2)] = null);

(statearr_13531_13547[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13521 === (5))){
var inst_13505 = (state_13520[(15)]);
var inst_13494 = (state_13520[(13)]);
var inst_13505__$1 = cljs.core.count.call(null,inst_13494);
var inst_13506 = cljs.core._EQ_.call(null,(0),inst_13505__$1);
var state_13520__$1 = (function (){var statearr_13532 = state_13520;
(statearr_13532[(15)] = inst_13505__$1);

return statearr_13532;
})();
if(inst_13506){
var statearr_13533_13548 = state_13520__$1;
(statearr_13533_13548[(1)] = (7));

} else {
var statearr_13534_13549 = state_13520__$1;
(statearr_13534_13549[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13521 === (8))){
var state_13520__$1 = state_13520;
var statearr_13535_13550 = state_13520__$1;
(statearr_13535_13550[(2)] = (1));

(statearr_13535_13550[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2468__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2468__auto____0 = (function (){
var statearr_13536 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13536[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2468__auto__);

(statearr_13536[(1)] = (1));

return statearr_13536;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2468__auto____1 = (function (state_13520){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_13520);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e13537){var ex__2471__auto__ = e13537;
var statearr_13538_13551 = state_13520;
(statearr_13538_13551[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_13520[(4)]))){
var statearr_13539_13552 = state_13520;
(statearr_13539_13552[(1)] = cljs.core.first.call(null,(state_13520[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13553 = state_13520;
state_13520 = G__13553;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2468__auto__ = function(state_13520){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2468__auto____1.call(this,state_13520);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2468__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2468__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_13540 = f__2491__auto__.call(null);
(statearr_13540[(6)] = c__2490__auto__);

return statearr_13540;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_13599){
var state_val_13600 = (state_13599[(1)]);
if((state_val_13600 === (7))){
var state_13599__$1 = state_13599;
var statearr_13601_13639 = state_13599__$1;
(statearr_13601_13639[(2)] = null);

(statearr_13601_13639[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13600 === (20))){
var inst_13585 = (state_13599[(2)]);
var inst_13586 = fluree.db.util.async.throw_err.call(null,inst_13585);
var inst_13564 = inst_13586;
var state_13599__$1 = (function (){var statearr_13602 = state_13599;
(statearr_13602[(7)] = inst_13564);

return statearr_13602;
})();
var statearr_13603_13640 = state_13599__$1;
(statearr_13603_13640[(2)] = null);

(statearr_13603_13640[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13600 === (1))){
var state_13599__$1 = state_13599;
var statearr_13604_13641 = state_13599__$1;
(statearr_13604_13641[(2)] = null);

(statearr_13604_13641[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13600 === (4))){
var inst_13554 = (state_13599[(2)]);
var state_13599__$1 = state_13599;
var statearr_13605_13642 = state_13599__$1;
(statearr_13605_13642[(2)] = inst_13554);

(statearr_13605_13642[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13600 === (15))){
var inst_13564 = (state_13599[(7)]);
var inst_13581 = (state_13599[(8)]);
var inst_13581__$1 = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(inst_13564);
var state_13599__$1 = (function (){var statearr_13606 = state_13599;
(statearr_13606[(8)] = inst_13581__$1);

return statearr_13606;
})();
if(cljs.core.truth_(inst_13581__$1)){
var statearr_13607_13643 = state_13599__$1;
(statearr_13607_13643[(1)] = (17));

} else {
var statearr_13608_13644 = state_13599__$1;
(statearr_13608_13644[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13600 === (13))){
var inst_13574 = (state_13599[(2)]);
var inst_13575 = fluree.db.util.async.throw_err.call(null,inst_13574);
var _ = (function (){var statearr_13609 = state_13599;
(statearr_13609[(4)] = cljs.core.rest.call(null,(state_13599[(4)])));

return statearr_13609;
})();
var state_13599__$1 = state_13599;
var statearr_13610_13645 = state_13599__$1;
(statearr_13610_13645[(2)] = inst_13575);

(statearr_13610_13645[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13600 === (6))){
var inst_13562 = (state_13599[(2)]);
var inst_13563 = fluree.db.util.async.throw_err.call(null,inst_13562);
var inst_13564 = inst_13563;
var state_13599__$1 = (function (){var statearr_13611 = state_13599;
(statearr_13611[(7)] = inst_13564);

return statearr_13611;
})();
var statearr_13612_13646 = state_13599__$1;
(statearr_13612_13646[(2)] = null);

(statearr_13612_13646[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13600 === (17))){
var inst_13581 = (state_13599[(8)]);
var inst_13583 = fluree.db.dbproto._lookup_leaf.call(null,root_node,inst_13581);
var state_13599__$1 = state_13599;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13599__$1,(20),inst_13583);
} else {
if((state_val_13600 === (3))){
var inst_13597 = (state_13599[(2)]);
var state_13599__$1 = state_13599;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13599__$1,inst_13597);
} else {
if((state_val_13600 === (12))){
var _ = (function (){var statearr_13614 = state_13599;
(statearr_13614[(4)] = cljs.core.rest.call(null,(state_13599[(4)])));

return statearr_13614;
})();
var state_13599__$1 = state_13599;
var ex13613 = (state_13599__$1[(2)]);
var statearr_13615_13647 = state_13599__$1;
(statearr_13615_13647[(5)] = ex13613);


if((ex13613 instanceof java.lang.Exception)){
var statearr_13616_13648 = state_13599__$1;
(statearr_13616_13648[(1)] = (11));

(statearr_13616_13648[(5)] = null);

} else {
throw ex13613;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13600 === (2))){
var _ = (function (){var statearr_13617 = state_13599;
(statearr_13617[(4)] = cljs.core.cons.call(null,(5),(state_13599[(4)])));

return statearr_13617;
})();
var inst_13560 = fluree.db.dbproto._lookup_leaf.call(null,root_node,rhs);
var state_13599__$1 = state_13599;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13599__$1,(6),inst_13560);
} else {
if((state_val_13600 === (19))){
var inst_13590 = (state_13599[(2)]);
var state_13599__$1 = state_13599;
var statearr_13618_13649 = state_13599__$1;
(statearr_13618_13649[(2)] = inst_13590);

(statearr_13618_13649[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13600 === (11))){
var inst_13566 = (state_13599[(2)]);
var state_13599__$1 = (function (){var statearr_13620 = state_13599;
(statearr_13620[(9)] = inst_13566);

return statearr_13620;
})();
var statearr_13621_13650 = state_13599__$1;
(statearr_13621_13650[(2)] = null);

(statearr_13621_13650[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13600 === (9))){
var inst_13564 = (state_13599[(7)]);
var _ = (function (){var statearr_13622 = state_13599;
(statearr_13622[(4)] = cljs.core.cons.call(null,(12),(state_13599[(4)])));

return statearr_13622;
})();
var inst_13572 = fluree.db.dbproto._resolve_to_t.call(null,inst_13564,t,novelty,fast_forward_db_QMARK_);
var state_13599__$1 = state_13599;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13599__$1,(13),inst_13572);
} else {
if((state_val_13600 === (5))){
var _ = (function (){var statearr_13623 = state_13599;
(statearr_13623[(4)] = cljs.core.rest.call(null,(state_13599[(4)])));

return statearr_13623;
})();
var state_13599__$1 = state_13599;
var ex13619 = (state_13599__$1[(2)]);
var statearr_13624_13651 = state_13599__$1;
(statearr_13624_13651[(5)] = ex13619);


if((ex13619 instanceof Error)){
var statearr_13625_13652 = state_13599__$1;
(statearr_13625_13652[(1)] = (4));

(statearr_13625_13652[(5)] = null);

} else {
throw ex13619;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13600 === (14))){
var inst_13578 = (state_13599[(10)]);
var state_13599__$1 = state_13599;
var statearr_13626_13653 = state_13599__$1;
(statearr_13626_13653[(2)] = inst_13578);

(statearr_13626_13653[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13600 === (16))){
var inst_13592 = (state_13599[(2)]);
var state_13599__$1 = state_13599;
var statearr_13627_13654 = state_13599__$1;
(statearr_13627_13654[(2)] = inst_13592);

(statearr_13627_13654[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13600 === (10))){
var inst_13578 = (state_13599[(10)]);
var inst_13578__$1 = (state_13599[(2)]);
var state_13599__$1 = (function (){var statearr_13628 = state_13599;
(statearr_13628[(10)] = inst_13578__$1);

return statearr_13628;
})();
if(cljs.core.truth_(inst_13578__$1)){
var statearr_13629_13655 = state_13599__$1;
(statearr_13629_13655[(1)] = (14));

} else {
var statearr_13630_13656 = state_13599__$1;
(statearr_13630_13656[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13600 === (18))){
var state_13599__$1 = state_13599;
var statearr_13631_13657 = state_13599__$1;
(statearr_13631_13657[(2)] = null);

(statearr_13631_13657[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13600 === (8))){
var inst_13594 = (state_13599[(2)]);
var _ = (function (){var statearr_13632 = state_13599;
(statearr_13632[(4)] = cljs.core.rest.call(null,(state_13599[(4)])));

return statearr_13632;
})();
var state_13599__$1 = state_13599;
var statearr_13633_13658 = state_13599__$1;
(statearr_13633_13658[(2)] = inst_13594);

(statearr_13633_13658[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__2468__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__2468__auto____0 = (function (){
var statearr_13634 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_13634[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__2468__auto__);

(statearr_13634[(1)] = (1));

return statearr_13634;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__2468__auto____1 = (function (state_13599){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_13599);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e13635){var ex__2471__auto__ = e13635;
var statearr_13636_13659 = state_13599;
(statearr_13636_13659[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_13599[(4)]))){
var statearr_13637_13660 = state_13599;
(statearr_13637_13660[(1)] = cljs.core.first.call(null,(state_13599[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13661 = state_13599;
state_13599 = G__13661;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__2468__auto__ = function(state_13599){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__2468__auto____1.call(this,state_13599);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__2468__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__2468__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_13638 = f__2491__auto__.call(null);
(statearr_13638[(6)] = c__2490__auto__);

return statearr_13638;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__13668 = arguments.length;
switch (G__13668) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.call(null,db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.call(null,db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.call(null,db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__13669 = (function (){var pred__13672 = cljs.core.identical_QMARK_;
var expr__13673 = test;
if(cljs.core.truth_(pred__13672.call(null,cljs.core._EQ_,expr__13673))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__13672.call(null,cljs.core._LT_,expr__13673))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_(pred__13672.call(null,cljs.core._LT__EQ_,expr__13673))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__13672.call(null,cljs.core._GT_,expr__13673))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
if(cljs.core.truth_(pred__13672.call(null,cljs.core._GT__EQ_,expr__13673))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__13673)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.call(null,vec__13669,(0),null);
var start_match = cljs.core.nth.call(null,vec__13669,(1),null);
var end_test = cljs.core.nth.call(null,vec__13669,(2),null);
var end_match = cljs.core.nth.call(null,vec__13669,(3),null);
return fluree.db.query.range.index_range.call(null,db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.call(null,db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_14071){
var state_val_14072 = (state_14071[(1)]);
if((state_val_14072 === (121))){
var inst_13932 = (state_14071[(7)]);
var state_14071__$1 = state_14071;
var statearr_14073_14276 = state_14071__$1;
(statearr_14073_14276[(2)] = inst_13932);

(statearr_14073_14276[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (65))){
var state_14071__$1 = state_14071;
var statearr_14074_14277 = state_14071__$1;
(statearr_14074_14277[(2)] = fluree.db.util.core.min_integer);

(statearr_14074_14277[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (70))){
var state_14071__$1 = state_14071;
var statearr_14075_14278 = state_14071__$1;
(statearr_14075_14278[(2)] = true);

(statearr_14075_14278[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (62))){
var inst_13834 = (cljs.core._LT__EQ_ === end_test);
var state_14071__$1 = state_14071;
if(cljs.core.truth_(inst_13834)){
var statearr_14076_14279 = state_14071__$1;
(statearr_14076_14279[(1)] = (64));

} else {
var statearr_14077_14280 = state_14071__$1;
(statearr_14077_14280[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (74))){
var inst_13843 = (state_14071[(8)]);
var state_14071__$1 = state_14071;
var statearr_14078_14281 = state_14071__$1;
(statearr_14078_14281[(2)] = inst_13843);

(statearr_14078_14281[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (110))){
var inst_13965 = (state_14071[(9)]);
var inst_13973 = (state_14071[(10)]);
var inst_13975 = (state_14071[(11)]);
var inst_13974 = (state_14071[(12)]);
var inst_13898 = (state_14071[(13)]);
var inst_13871 = (state_14071[(14)]);
var inst_13973__$1 = cljs.core.count.call(null,inst_13965);
var inst_13974__$1 = (inst_13898 + inst_13973__$1);
var inst_13975__$1 = (inst_13974__$1 - inst_13871);
var inst_13976 = cljs.core.pos_int_QMARK_.call(null,inst_13975__$1);
var state_14071__$1 = (function (){var statearr_14079 = state_14071;
(statearr_14079[(10)] = inst_13973__$1);

(statearr_14079[(11)] = inst_13975__$1);

(statearr_14079[(12)] = inst_13974__$1);

return statearr_14079;
})();
if(inst_13976){
var statearr_14080_14282 = state_14071__$1;
(statearr_14080_14282[(1)] = (113));

} else {
var statearr_14081_14283 = state_14071__$1;
(statearr_14081_14283[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (130))){
var inst_14034 = (state_14071[(15)]);
var state_14071__$1 = state_14071;
var statearr_14082_14284 = state_14071__$1;
(statearr_14082_14284[(2)] = inst_14034);

(statearr_14082_14284[(1)] = (132));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (128))){
var inst_14043 = (state_14071[(16)]);
var state_14071__$1 = state_14071;
var statearr_14083_14285 = state_14071__$1;
(statearr_14083_14285[(2)] = inst_14043);

(statearr_14083_14285[(1)] = (129));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (7))){
var state_14071__$1 = state_14071;
var statearr_14084_14286 = state_14071__$1;
(statearr_14084_14286[(2)] = false);

(statearr_14084_14286[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (59))){
var state_14071__$1 = state_14071;
var statearr_14085_14287 = state_14071__$1;
(statearr_14085_14287[(2)] = (2147483647));

(statearr_14085_14287[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (86))){
var inst_13695 = (state_14071[(17)]);
var inst_13888 = (state_14071[(18)]);
var inst_13702 = (state_14071[(19)]);
var inst_13883 = (state_14071[(20)]);
var inst_13706 = (state_14071[(21)]);
var inst_13795 = (state_14071[(22)]);
var inst_13905 = (state_14071[(23)]);
var inst_13899 = (state_14071[(24)]);
var inst_13882 = (state_14071[(25)]);
var inst_13742 = (state_14071[(26)]);
var inst_13782 = (state_14071[(27)]);
var inst_13731 = (state_14071[(28)]);
var inst_13751 = (state_14071[(29)]);
var inst_13872 = (state_14071[(30)]);
var inst_13897 = (state_14071[(31)]);
var inst_13841 = (state_14071[(32)]);
var inst_13864 = (state_14071[(33)]);
var inst_13892 = (state_14071[(34)]);
var inst_13700 = (state_14071[(35)]);
var inst_13786 = (state_14071[(36)]);
var inst_13783 = (state_14071[(37)]);
var inst_13804 = (state_14071[(38)]);
var inst_13699 = (state_14071[(39)]);
var inst_13730 = (state_14071[(40)]);
var inst_13831 = (state_14071[(41)]);
var inst_13896 = (state_14071[(42)]);
var inst_13877 = (state_14071[(43)]);
var inst_13813 = (state_14071[(44)]);
var inst_13865 = (state_14071[(45)]);
var inst_13822 = (state_14071[(46)]);
var inst_13878 = (state_14071[(47)]);
var inst_13873 = (state_14071[(48)]);
var inst_13707 = (state_14071[(49)]);
var inst_13732 = (state_14071[(50)]);
var inst_13895 = (state_14071[(51)]);
var inst_13840 = (state_14071[(52)]);
var inst_13898 = (state_14071[(13)]);
var inst_13871 = (state_14071[(14)]);
var inst_13842 = (state_14071[(53)]);
var inst_13909 = (function (){var no_filter_QMARK_ = true;
var map__13687 = inst_13730;
var t = inst_13878;
var max_limit_QMARK_ = inst_13872;
var next_node = inst_13895;
var fast_forward_db_QMARK_ = inst_13883;
var s1 = inst_13742;
var o2 = inst_13804;
var t1 = inst_13699;
var predicate_fn = inst_13732;
var i = inst_13897;
var m1 = inst_13831;
var root_node = inst_13888;
var s2 = inst_13751;
var map__13694 = inst_13864;
var p2 = inst_13822;
var vec__13691 = inst_13783;
var permissions = inst_13873;
var G__13906 = inst_13905;
var limit = inst_13871;
var start_flake = inst_13841;
var flake_limit = inst_13865;
var offset = inst_13896;
var vec__13688 = inst_13782;
var acc = inst_13899;
var vec__13681 = inst_13695;
var t2 = inst_13706;
var vec__13684 = inst_13702;
var op1 = inst_13700;
var o1 = inst_13795;
var end_flake = inst_13842;
var base_result = inst_13905;
var s = inst_13898;
var node_start = inst_13892;
var p1 = inst_13813;
var subject_fn = inst_13731;
var object_fn = inst_13786;
var idx_compare = inst_13877;
var op2 = inst_13707;
var m2 = inst_13840;
var novelty = inst_13882;
return (function (p1__13662_SHARP_){
return cljs.core._EQ_.call(null,p1__13662_SHARP_.o,start_flake.o);
});
})();
var inst_13910 = cljs.core.filter.call(null,inst_13909,inst_13905);
var state_14071__$1 = state_14071;
var statearr_14086_14288 = state_14071__$1;
(statearr_14086_14288[(2)] = inst_13910);

(statearr_14086_14288[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (20))){
var inst_13703 = (state_14071[(54)]);
var state_14071__$1 = state_14071;
var statearr_14087_14289 = state_14071__$1;
(statearr_14087_14289[(2)] = inst_13703);

(statearr_14087_14289[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (72))){
var inst_13856 = (state_14071[(2)]);
var state_14071__$1 = state_14071;
var statearr_14088_14290 = state_14071__$1;
(statearr_14088_14290[(2)] = inst_13856);

(statearr_14088_14290[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (58))){
var state_14071__$1 = state_14071;
var statearr_14089_14291 = state_14071__$1;
(statearr_14089_14291[(2)] = fluree.db.util.core.min_integer);

(statearr_14089_14291[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (60))){
var inst_13829 = (state_14071[(2)]);
var state_14071__$1 = state_14071;
var statearr_14090_14292 = state_14071__$1;
(statearr_14090_14292[(2)] = inst_13829);

(statearr_14090_14292[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (27))){
var state_14071__$1 = state_14071;
var statearr_14091_14293 = state_14071__$1;
(statearr_14091_14293[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (1))){
var state_14071__$1 = state_14071;
var statearr_14093_14294 = state_14071__$1;
(statearr_14093_14294[(2)] = null);

(statearr_14093_14294[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (69))){
var inst_13859 = (state_14071[(2)]);
var state_14071__$1 = state_14071;
if(cljs.core.truth_(inst_13859)){
var statearr_14094_14295 = state_14071__$1;
(statearr_14094_14295[(1)] = (73));

} else {
var statearr_14095_14296 = state_14071__$1;
(statearr_14095_14296[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (101))){
var state_14071__$1 = state_14071;
var statearr_14096_14297 = state_14071__$1;
(statearr_14096_14297[(2)] = true);

(statearr_14096_14297[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (24))){
var inst_13705 = (state_14071[(55)]);
var inst_13755 = cljs.core.boolean_QMARK_.call(null,inst_13705);
var state_14071__$1 = state_14071;
if(inst_13755){
var statearr_14097_14298 = state_14071__$1;
(statearr_14097_14298[(1)] = (26));

} else {
var statearr_14098_14299 = state_14071__$1;
(statearr_14098_14299[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (102))){
var state_14071__$1 = state_14071;
var statearr_14099_14300 = state_14071__$1;
(statearr_14099_14300[(2)] = false);

(statearr_14099_14300[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (55))){
var inst_13701 = (state_14071[(56)]);
var state_14071__$1 = state_14071;
var statearr_14100_14301 = state_14071__$1;
(statearr_14100_14301[(2)] = inst_13701);

(statearr_14100_14301[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (85))){
var inst_14063 = (state_14071[(2)]);
var state_14071__$1 = state_14071;
var statearr_14101_14302 = state_14071__$1;
(statearr_14101_14302[(2)] = inst_14063);

(statearr_14101_14302[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (39))){
var inst_13785 = (state_14071[(57)]);
var inst_13798 = fluree.db.dbproto._subid.call(null,db,inst_13785);
var state_14071__$1 = state_14071;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14071__$1,(42),inst_13798);
} else {
if((state_val_14072 === (88))){
var inst_13731 = (state_14071[(28)]);
var inst_13913 = (state_14071[(2)]);
var state_14071__$1 = (function (){var statearr_14102 = state_14071;
(statearr_14102[(58)] = inst_13913);

return statearr_14102;
})();
if(cljs.core.truth_(inst_13731)){
var statearr_14103_14303 = state_14071__$1;
(statearr_14103_14303[(1)] = (89));

} else {
var statearr_14104_14304 = state_14071__$1;
(statearr_14104_14304[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (46))){
var state_14071__$1 = state_14071;
var statearr_14105_14305 = state_14071__$1;
(statearr_14105_14305[(2)] = (-1));

(statearr_14105_14305[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (4))){
var inst_13675 = (state_14071[(2)]);
var state_14071__$1 = state_14071;
var statearr_14106_14306 = state_14071__$1;
(statearr_14106_14306[(2)] = inst_13675);

(statearr_14106_14306[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (77))){
var state_14071__$1 = state_14071;
var statearr_14107_14307 = state_14071__$1;
(statearr_14107_14307[(2)] = fluree.db.util.core.max_long);

(statearr_14107_14307[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (106))){
var inst_13932 = (state_14071[(7)]);
var inst_14030 = (state_14071[(2)]);
var inst_14031 = cljs.core.nth.call(null,inst_14030,(0),null);
var inst_14032 = cljs.core.nth.call(null,inst_14030,(1),null);
var inst_14033 = cljs.core.nth.call(null,inst_14030,(2),null);
var inst_14034 = cljs.core.nth.call(null,inst_14030,(3),null);
var state_14071__$1 = (function (){var statearr_14108 = state_14071;
(statearr_14108[(59)] = inst_14031);

(statearr_14108[(15)] = inst_14034);

(statearr_14108[(60)] = inst_14032);

(statearr_14108[(61)] = inst_14033);

return statearr_14108;
})();
if(cljs.core.truth_(inst_13932)){
var statearr_14109_14308 = state_14071__$1;
(statearr_14109_14308[(1)] = (120));

} else {
var statearr_14110_14309 = state_14071__$1;
(statearr_14110_14309[(1)] = (121));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (119))){
var inst_14016 = (state_14071[(2)]);
var inst_14017 = fluree.db.util.async.throw_err.call(null,inst_14016);
var state_14071__$1 = state_14071;
var statearr_14111_14310 = state_14071__$1;
(statearr_14111_14310[(2)] = inst_14017);

(statearr_14111_14310[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (95))){
var inst_13695 = (state_14071[(17)]);
var inst_13888 = (state_14071[(18)]);
var inst_13702 = (state_14071[(19)]);
var inst_13883 = (state_14071[(20)]);
var inst_13706 = (state_14071[(21)]);
var inst_13795 = (state_14071[(22)]);
var inst_13905 = (state_14071[(23)]);
var inst_13899 = (state_14071[(24)]);
var inst_13882 = (state_14071[(25)]);
var inst_13742 = (state_14071[(26)]);
var inst_13782 = (state_14071[(27)]);
var inst_13731 = (state_14071[(28)]);
var inst_13751 = (state_14071[(29)]);
var inst_13872 = (state_14071[(30)]);
var inst_13897 = (state_14071[(31)]);
var inst_13841 = (state_14071[(32)]);
var inst_13864 = (state_14071[(33)]);
var inst_13892 = (state_14071[(34)]);
var inst_13700 = (state_14071[(35)]);
var inst_13786 = (state_14071[(36)]);
var inst_13783 = (state_14071[(37)]);
var inst_13804 = (state_14071[(38)]);
var inst_13699 = (state_14071[(39)]);
var inst_13730 = (state_14071[(40)]);
var inst_13831 = (state_14071[(41)]);
var inst_13896 = (state_14071[(42)]);
var inst_13877 = (state_14071[(43)]);
var inst_13813 = (state_14071[(44)]);
var inst_13865 = (state_14071[(45)]);
var inst_13822 = (state_14071[(46)]);
var inst_13925 = (state_14071[(62)]);
var inst_13878 = (state_14071[(47)]);
var inst_13873 = (state_14071[(48)]);
var inst_13707 = (state_14071[(49)]);
var inst_13732 = (state_14071[(50)]);
var inst_13895 = (state_14071[(51)]);
var inst_13840 = (state_14071[(52)]);
var inst_13898 = (state_14071[(13)]);
var inst_13871 = (state_14071[(14)]);
var inst_13842 = (state_14071[(53)]);
var inst_13927 = (function (){var no_filter_QMARK_ = true;
var map__13687 = inst_13730;
var t = inst_13878;
var max_limit_QMARK_ = inst_13872;
var next_node = inst_13895;
var fast_forward_db_QMARK_ = inst_13883;
var s1 = inst_13742;
var o2 = inst_13804;
var t1 = inst_13699;
var predicate_fn = inst_13732;
var i = inst_13897;
var m1 = inst_13831;
var root_node = inst_13888;
var s2 = inst_13751;
var map__13694 = inst_13864;
var p2 = inst_13822;
var vec__13691 = inst_13783;
var permissions = inst_13873;
var G__13906 = inst_13925;
var limit = inst_13871;
var start_flake = inst_13841;
var flake_limit = inst_13865;
var offset = inst_13896;
var vec__13688 = inst_13782;
var acc = inst_13899;
var vec__13681 = inst_13695;
var t2 = inst_13706;
var vec__13684 = inst_13702;
var op1 = inst_13700;
var o1 = inst_13795;
var end_flake = inst_13842;
var base_result = inst_13905;
var s = inst_13898;
var node_start = inst_13892;
var p1 = inst_13813;
var subject_fn = inst_13731;
var object_fn = inst_13786;
var idx_compare = inst_13877;
var op2 = inst_13707;
var m2 = inst_13840;
var novelty = inst_13882;
return (function (p1__13665_SHARP_){
return object_fn.call(null,p1__13665_SHARP_.o);
});
})();
var inst_13928 = cljs.core.filter.call(null,inst_13927,inst_13925);
var state_14071__$1 = state_14071;
var statearr_14112_14311 = state_14071__$1;
(statearr_14112_14311[(2)] = inst_13928);

(statearr_14112_14311[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (54))){
var inst_13701 = (state_14071[(56)]);
var inst_13822 = (state_14071[(2)]);
var state_14071__$1 = (function (){var statearr_14113 = state_14071;
(statearr_14113[(46)] = inst_13822);

return statearr_14113;
})();
if(cljs.core.truth_(inst_13701)){
var statearr_14114_14312 = state_14071__$1;
(statearr_14114_14312[(1)] = (55));

} else {
var statearr_14115_14313 = state_14071__$1;
(statearr_14115_14313[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (92))){
var inst_13695 = (state_14071[(17)]);
var inst_13888 = (state_14071[(18)]);
var inst_13702 = (state_14071[(19)]);
var inst_13883 = (state_14071[(20)]);
var inst_13706 = (state_14071[(21)]);
var inst_13795 = (state_14071[(22)]);
var inst_13905 = (state_14071[(23)]);
var inst_13899 = (state_14071[(24)]);
var inst_13882 = (state_14071[(25)]);
var inst_13742 = (state_14071[(26)]);
var inst_13782 = (state_14071[(27)]);
var inst_13731 = (state_14071[(28)]);
var inst_13751 = (state_14071[(29)]);
var inst_13872 = (state_14071[(30)]);
var inst_13919 = (state_14071[(63)]);
var inst_13897 = (state_14071[(31)]);
var inst_13841 = (state_14071[(32)]);
var inst_13864 = (state_14071[(33)]);
var inst_13892 = (state_14071[(34)]);
var inst_13700 = (state_14071[(35)]);
var inst_13786 = (state_14071[(36)]);
var inst_13783 = (state_14071[(37)]);
var inst_13804 = (state_14071[(38)]);
var inst_13699 = (state_14071[(39)]);
var inst_13730 = (state_14071[(40)]);
var inst_13831 = (state_14071[(41)]);
var inst_13896 = (state_14071[(42)]);
var inst_13877 = (state_14071[(43)]);
var inst_13813 = (state_14071[(44)]);
var inst_13865 = (state_14071[(45)]);
var inst_13822 = (state_14071[(46)]);
var inst_13878 = (state_14071[(47)]);
var inst_13873 = (state_14071[(48)]);
var inst_13707 = (state_14071[(49)]);
var inst_13732 = (state_14071[(50)]);
var inst_13895 = (state_14071[(51)]);
var inst_13840 = (state_14071[(52)]);
var inst_13898 = (state_14071[(13)]);
var inst_13871 = (state_14071[(14)]);
var inst_13842 = (state_14071[(53)]);
var inst_13921 = (function (){var no_filter_QMARK_ = true;
var map__13687 = inst_13730;
var t = inst_13878;
var max_limit_QMARK_ = inst_13872;
var next_node = inst_13895;
var fast_forward_db_QMARK_ = inst_13883;
var s1 = inst_13742;
var o2 = inst_13804;
var t1 = inst_13699;
var predicate_fn = inst_13732;
var i = inst_13897;
var m1 = inst_13831;
var root_node = inst_13888;
var s2 = inst_13751;
var map__13694 = inst_13864;
var p2 = inst_13822;
var vec__13691 = inst_13783;
var permissions = inst_13873;
var G__13906 = inst_13919;
var limit = inst_13871;
var start_flake = inst_13841;
var flake_limit = inst_13865;
var offset = inst_13896;
var vec__13688 = inst_13782;
var acc = inst_13899;
var vec__13681 = inst_13695;
var t2 = inst_13706;
var vec__13684 = inst_13702;
var op1 = inst_13700;
var o1 = inst_13795;
var end_flake = inst_13842;
var base_result = inst_13905;
var s = inst_13898;
var node_start = inst_13892;
var p1 = inst_13813;
var subject_fn = inst_13731;
var object_fn = inst_13786;
var idx_compare = inst_13877;
var op2 = inst_13707;
var m2 = inst_13840;
var novelty = inst_13882;
return (function (p1__13664_SHARP_){
return predicate_fn.call(null,p1__13664_SHARP_.p);
});
})();
var inst_13922 = cljs.core.filter.call(null,inst_13921,inst_13919);
var state_14071__$1 = state_14071;
var statearr_14116_14314 = state_14071__$1;
(statearr_14116_14314[(2)] = inst_13922);

(statearr_14116_14314[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (104))){
var inst_13931 = (state_14071[(64)]);
var inst_13899 = (state_14071[(24)]);
var inst_13897 = (state_14071[(31)]);
var inst_13865 = (state_14071[(45)]);
var inst_13898 = (state_14071[(13)]);
var inst_13943 = cljs.core.count.call(null,inst_13931);
var inst_13944 = (inst_13865 - inst_13897);
var inst_13945 = cljs.core.take.call(null,inst_13944,inst_13931);
var inst_13946 = cljs.core.into.call(null,inst_13899,inst_13945);
var inst_13947 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13948 = (inst_13897 + inst_13943);
var inst_13949 = [(0),inst_13948,inst_13898,inst_13946];
var inst_13950 = (new cljs.core.PersistentVector(null,4,(5),inst_13947,inst_13949,null));
var state_14071__$1 = state_14071;
var statearr_14117_14315 = state_14071__$1;
(statearr_14117_14315[(2)] = inst_13950);

(statearr_14117_14315[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (15))){
var inst_13696 = (state_14071[(65)]);
var inst_13736 = fluree.db.dbproto._subid.call(null,db,inst_13696);
var state_14071__$1 = state_14071;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14071__$1,(18),inst_13736);
} else {
if((state_val_14072 === (48))){
var inst_13704 = (state_14071[(66)]);
var inst_13813 = (state_14071[(2)]);
var inst_13814 = (inst_13704 == null);
var state_14071__$1 = (function (){var statearr_14118 = state_14071;
(statearr_14118[(44)] = inst_13813);

return statearr_14118;
})();
if(cljs.core.truth_(inst_13814)){
var statearr_14119_14316 = state_14071__$1;
(statearr_14119_14316[(1)] = (49));

} else {
var statearr_14120_14317 = state_14071__$1;
(statearr_14120_14317[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (50))){
var state_14071__$1 = state_14071;
var statearr_14121_14318 = state_14071__$1;
(statearr_14121_14318[(2)] = false);

(statearr_14121_14318[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (116))){
var inst_13992 = (state_14071[(67)]);
var inst_13993 = (state_14071[(68)]);
var inst_13991 = (state_14071[(69)]);
var inst_13865 = (state_14071[(45)]);
var inst_13996 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13997 = (inst_13993 - inst_13865);
var inst_13998 = (inst_13992 - inst_13997);
var inst_13999 = cljs.core.take.call(null,inst_13998,inst_13991);
var inst_14000 = [inst_13865,inst_13999];
var inst_14001 = (new cljs.core.PersistentVector(null,2,(5),inst_13996,inst_14000,null));
var state_14071__$1 = state_14071;
var statearr_14122_14319 = state_14071__$1;
(statearr_14122_14319[(2)] = inst_14001);

(statearr_14122_14319[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (75))){
var inst_13866 = (state_14071[(70)]);
var inst_13864 = (state_14071[(33)]);
var inst_13864__$1 = (state_14071[(2)]);
var inst_13865 = cljs.core.get.call(null,inst_13864__$1,new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961),fluree.db.util.core.max_long);
var inst_13866__$1 = cljs.core.get.call(null,inst_13864__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_13867 = cljs.core.get.call(null,inst_13864__$1,new cljs.core.Keyword(null,"offset","offset",296498311),(0));
var state_14071__$1 = (function (){var statearr_14123 = state_14071;
(statearr_14123[(70)] = inst_13866__$1);

(statearr_14123[(71)] = inst_13867);

(statearr_14123[(33)] = inst_13864__$1);

(statearr_14123[(45)] = inst_13865);

return statearr_14123;
})();
if(cljs.core.truth_(inst_13866__$1)){
var statearr_14124_14320 = state_14071__$1;
(statearr_14124_14320[(1)] = (76));

} else {
var statearr_14125_14321 = state_14071__$1;
(statearr_14125_14321[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (99))){
var inst_13872 = (state_14071[(30)]);
var state_14071__$1 = state_14071;
var statearr_14126_14322 = state_14071__$1;
(statearr_14126_14322[(2)] = inst_13872);

(statearr_14126_14322[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (21))){
var inst_13698 = (state_14071[(72)]);
var inst_13751 = (state_14071[(2)]);
var inst_13752 = cljs.core.boolean_QMARK_.call(null,inst_13698);
var state_14071__$1 = (function (){var statearr_14127 = state_14071;
(statearr_14127[(29)] = inst_13751);

return statearr_14127;
})();
if(inst_13752){
var statearr_14128_14323 = state_14071__$1;
(statearr_14128_14323[(1)] = (23));

} else {
var statearr_14129_14324 = state_14071__$1;
(statearr_14129_14324[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (31))){
var inst_13761 = (state_14071[(2)]);
var state_14071__$1 = state_14071;
var statearr_14130_14325 = state_14071__$1;
(statearr_14130_14325[(2)] = inst_13761);

(statearr_14130_14325[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (113))){
var inst_13973 = (state_14071[(10)]);
var inst_13975 = (state_14071[(11)]);
var inst_13871 = (state_14071[(14)]);
var inst_13978 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13979 = (inst_13973 - inst_13975);
var inst_13980 = [inst_13871,inst_13979];
var inst_13981 = (new cljs.core.PersistentVector(null,2,(5),inst_13978,inst_13980,null));
var state_14071__$1 = state_14071;
var statearr_14131_14326 = state_14071__$1;
(statearr_14131_14326[(2)] = inst_13981);

(statearr_14131_14326[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (32))){
var inst_13695 = (state_14071[(17)]);
var inst_13702 = (state_14071[(19)]);
var inst_13765 = (state_14071[(73)]);
var inst_13708 = (state_14071[(74)]);
var inst_13706 = (state_14071[(21)]);
var inst_13698 = (state_14071[(72)]);
var inst_13742 = (state_14071[(26)]);
var inst_13733 = (state_14071[(75)]);
var inst_13731 = (state_14071[(28)]);
var inst_13751 = (state_14071[(29)]);
var inst_13705 = (state_14071[(55)]);
var inst_13700 = (state_14071[(35)]);
var inst_13697 = (state_14071[(76)]);
var inst_13701 = (state_14071[(56)]);
var inst_13699 = (state_14071[(39)]);
var inst_13730 = (state_14071[(40)]);
var inst_13707 = (state_14071[(49)]);
var inst_13732 = (state_14071[(50)]);
var inst_13704 = (state_14071[(66)]);
var inst_13767 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13768 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13769 = [null,null];
var inst_13770 = (new cljs.core.PersistentVector(null,2,(5),inst_13768,inst_13769,null));
var inst_13771 = (function (){var bool = inst_13765;
var map__13687 = inst_13730;
var temp__5733__auto__ = inst_13765;
var s1 = inst_13742;
var o2 = inst_13705;
var t1 = inst_13699;
var predicate_fn = inst_13732;
var m1 = inst_13701;
var s2 = inst_13751;
var p2 = inst_13704;
var vec__13681 = inst_13695;
var t2 = inst_13706;
var vec__13684 = inst_13702;
var op1 = inst_13700;
var o1 = inst_13698;
var p1 = inst_13697;
var subject_fn = inst_13731;
var object_fn = inst_13733;
var op2 = inst_13707;
var m2 = inst_13708;
return (function (o){
return cljs.core._EQ_.call(null,o,bool);
});
})();
var inst_13772 = [inst_13770,inst_13771];
var inst_13773 = (new cljs.core.PersistentVector(null,2,(5),inst_13767,inst_13772,null));
var state_14071__$1 = state_14071;
var statearr_14132_14327 = state_14071__$1;
(statearr_14132_14327[(2)] = inst_13773);

(statearr_14132_14327[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (40))){
var inst_13785 = (state_14071[(57)]);
var state_14071__$1 = state_14071;
var statearr_14133_14328 = state_14071__$1;
(statearr_14133_14328[(2)] = inst_13785);

(statearr_14133_14328[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (129))){
var inst_14055 = (state_14071[(2)]);
var inst_14056 = cljs.core.not.call(null,inst_14055);
var state_14071__$1 = state_14071;
if(inst_14056){
var statearr_14134_14329 = state_14071__$1;
(statearr_14134_14329[(1)] = (130));

} else {
var statearr_14135_14330 = state_14071__$1;
(statearr_14135_14330[(1)] = (131));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (91))){
var inst_13732 = (state_14071[(50)]);
var inst_13919 = (state_14071[(2)]);
var state_14071__$1 = (function (){var statearr_14136 = state_14071;
(statearr_14136[(63)] = inst_13919);

return statearr_14136;
})();
if(cljs.core.truth_(inst_13732)){
var statearr_14137_14331 = state_14071__$1;
(statearr_14137_14331[(1)] = (92));

} else {
var statearr_14138_14332 = state_14071__$1;
(statearr_14138_14332[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (117))){
var inst_13993 = (state_14071[(68)]);
var inst_13991 = (state_14071[(69)]);
var inst_14003 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14004 = [inst_13993,inst_13991];
var inst_14005 = (new cljs.core.PersistentVector(null,2,(5),inst_14003,inst_14004,null));
var state_14071__$1 = state_14071;
var statearr_14139_14333 = state_14071__$1;
(statearr_14139_14333[(2)] = inst_14005);

(statearr_14139_14333[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (108))){
var inst_13953 = (state_14071[(77)]);
var inst_13896 = (state_14071[(42)]);
var inst_13965 = cljs.core.drop.call(null,inst_13896,inst_13953);
var state_14071__$1 = (function (){var statearr_14140 = state_14071;
(statearr_14140[(9)] = inst_13965);

return statearr_14140;
})();
var statearr_14141_14334 = state_14071__$1;
(statearr_14141_14334[(1)] = (110));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (56))){
var inst_13825 = (cljs.core._GT__EQ_ === start_test);
var state_14071__$1 = state_14071;
if(cljs.core.truth_(inst_13825)){
var statearr_14143_14335 = state_14071__$1;
(statearr_14143_14335[(1)] = (58));

} else {
var statearr_14144_14336 = state_14071__$1;
(statearr_14144_14336[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (33))){
var inst_13698 = (state_14071[(72)]);
var inst_13733 = (state_14071[(75)]);
var inst_13705 = (state_14071[(55)]);
var inst_13775 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13776 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13777 = [inst_13698,inst_13705];
var inst_13778 = (new cljs.core.PersistentVector(null,2,(5),inst_13776,inst_13777,null));
var inst_13779 = [inst_13778,inst_13733];
var inst_13780 = (new cljs.core.PersistentVector(null,2,(5),inst_13775,inst_13779,null));
var state_14071__$1 = state_14071;
var statearr_14145_14337 = state_14071__$1;
(statearr_14145_14337[(2)] = inst_13780);

(statearr_14145_14337[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (13))){
var inst_13709 = (state_14071[(78)]);
var state_14071__$1 = state_14071;
var statearr_14146_14338 = state_14071__$1;
(statearr_14146_14338[(2)] = inst_13709);

(statearr_14146_14338[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (22))){
var inst_13747 = (state_14071[(2)]);
var inst_13748 = fluree.db.util.async.throw_err.call(null,inst_13747);
var state_14071__$1 = state_14071;
var statearr_14147_14339 = state_14071__$1;
(statearr_14147_14339[(2)] = inst_13748);

(statearr_14147_14339[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (90))){
var inst_13913 = (state_14071[(58)]);
var state_14071__$1 = state_14071;
var statearr_14148_14340 = state_14071__$1;
(statearr_14148_14340[(2)] = inst_13913);

(statearr_14148_14340[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (109))){
var inst_14028 = (state_14071[(2)]);
var state_14071__$1 = state_14071;
var statearr_14149_14341 = state_14071__$1;
(statearr_14149_14341[(2)] = inst_14028);

(statearr_14149_14341[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (36))){
var inst_13784 = (state_14071[(79)]);
var state_14071__$1 = state_14071;
var statearr_14150_14342 = state_14071__$1;
(statearr_14150_14342[(2)] = inst_13784);

(statearr_14150_14342[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (41))){
var inst_13697 = (state_14071[(76)]);
var inst_13804 = (state_14071[(2)]);
var inst_13805 = (inst_13697 == null);
var state_14071__$1 = (function (){var statearr_14151 = state_14071;
(statearr_14151[(38)] = inst_13804);

return statearr_14151;
})();
if(cljs.core.truth_(inst_13805)){
var statearr_14152_14343 = state_14071__$1;
(statearr_14152_14343[(1)] = (43));

} else {
var statearr_14153_14344 = state_14071__$1;
(statearr_14153_14344[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (118))){
var inst_13988 = (state_14071[(80)]);
var inst_14007 = (state_14071[(2)]);
var inst_14008 = cljs.core.nth.call(null,inst_14007,(0),null);
var inst_14009 = cljs.core.nth.call(null,inst_14007,(1),null);
var inst_14010 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14011 = [inst_14008,inst_13988,inst_14009];
var inst_14012 = (new cljs.core.PersistentVector(null,3,(5),inst_14010,inst_14011,null));
var state_14071__$1 = state_14071;
var statearr_14154_14345 = state_14071__$1;
(statearr_14154_14345[(2)] = inst_14012);

(statearr_14154_14345[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (89))){
var inst_13695 = (state_14071[(17)]);
var inst_13888 = (state_14071[(18)]);
var inst_13702 = (state_14071[(19)]);
var inst_13883 = (state_14071[(20)]);
var inst_13706 = (state_14071[(21)]);
var inst_13795 = (state_14071[(22)]);
var inst_13905 = (state_14071[(23)]);
var inst_13899 = (state_14071[(24)]);
var inst_13882 = (state_14071[(25)]);
var inst_13742 = (state_14071[(26)]);
var inst_13782 = (state_14071[(27)]);
var inst_13731 = (state_14071[(28)]);
var inst_13751 = (state_14071[(29)]);
var inst_13872 = (state_14071[(30)]);
var inst_13897 = (state_14071[(31)]);
var inst_13841 = (state_14071[(32)]);
var inst_13864 = (state_14071[(33)]);
var inst_13892 = (state_14071[(34)]);
var inst_13700 = (state_14071[(35)]);
var inst_13786 = (state_14071[(36)]);
var inst_13783 = (state_14071[(37)]);
var inst_13804 = (state_14071[(38)]);
var inst_13699 = (state_14071[(39)]);
var inst_13730 = (state_14071[(40)]);
var inst_13831 = (state_14071[(41)]);
var inst_13896 = (state_14071[(42)]);
var inst_13877 = (state_14071[(43)]);
var inst_13813 = (state_14071[(44)]);
var inst_13865 = (state_14071[(45)]);
var inst_13822 = (state_14071[(46)]);
var inst_13878 = (state_14071[(47)]);
var inst_13873 = (state_14071[(48)]);
var inst_13707 = (state_14071[(49)]);
var inst_13732 = (state_14071[(50)]);
var inst_13895 = (state_14071[(51)]);
var inst_13840 = (state_14071[(52)]);
var inst_13913 = (state_14071[(58)]);
var inst_13898 = (state_14071[(13)]);
var inst_13871 = (state_14071[(14)]);
var inst_13842 = (state_14071[(53)]);
var inst_13915 = (function (){var no_filter_QMARK_ = true;
var map__13687 = inst_13730;
var t = inst_13878;
var max_limit_QMARK_ = inst_13872;
var next_node = inst_13895;
var fast_forward_db_QMARK_ = inst_13883;
var s1 = inst_13742;
var o2 = inst_13804;
var t1 = inst_13699;
var predicate_fn = inst_13732;
var i = inst_13897;
var m1 = inst_13831;
var root_node = inst_13888;
var s2 = inst_13751;
var map__13694 = inst_13864;
var p2 = inst_13822;
var vec__13691 = inst_13783;
var permissions = inst_13873;
var G__13906 = inst_13913;
var limit = inst_13871;
var start_flake = inst_13841;
var flake_limit = inst_13865;
var offset = inst_13896;
var vec__13688 = inst_13782;
var acc = inst_13899;
var vec__13681 = inst_13695;
var t2 = inst_13706;
var vec__13684 = inst_13702;
var op1 = inst_13700;
var o1 = inst_13795;
var end_flake = inst_13842;
var base_result = inst_13905;
var s = inst_13898;
var node_start = inst_13892;
var p1 = inst_13813;
var subject_fn = inst_13731;
var object_fn = inst_13786;
var idx_compare = inst_13877;
var op2 = inst_13707;
var m2 = inst_13840;
var novelty = inst_13882;
return (function (p1__13663_SHARP_){
return subject_fn.call(null,p1__13663_SHARP_.s);
});
})();
var inst_13916 = cljs.core.filter.call(null,inst_13915,inst_13913);
var state_14071__$1 = state_14071;
var statearr_14155_14346 = state_14071__$1;
(statearr_14155_14346[(2)] = inst_13916);

(statearr_14155_14346[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (100))){
var inst_13941 = (state_14071[(2)]);
var state_14071__$1 = state_14071;
if(cljs.core.truth_(inst_13941)){
var statearr_14156_14347 = state_14071__$1;
(statearr_14156_14347[(1)] = (104));

} else {
var statearr_14157_14348 = state_14071__$1;
(statearr_14157_14348[(1)] = (105));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (131))){
var inst_14031 = (state_14071[(59)]);
var inst_14034 = (state_14071[(15)]);
var inst_14051 = (state_14071[(81)]);
var inst_14032 = (state_14071[(60)]);
var inst_14033 = (state_14071[(61)]);
var inst_13895 = inst_14051;
var inst_13896 = inst_14031;
var inst_13897 = inst_14032;
var inst_13898 = inst_14033;
var inst_13899 = inst_14034;
var state_14071__$1 = (function (){var statearr_14158 = state_14071;
(statearr_14158[(24)] = inst_13899);

(statearr_14158[(31)] = inst_13897);

(statearr_14158[(42)] = inst_13896);

(statearr_14158[(51)] = inst_13895);

(statearr_14158[(13)] = inst_13898);

return statearr_14158;
})();
var statearr_14159_14349 = state_14071__$1;
(statearr_14159_14349[(2)] = null);

(statearr_14159_14349[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (122))){
var inst_14043 = (state_14071[(16)]);
var inst_14043__$1 = (state_14071[(2)]);
var state_14071__$1 = (function (){var statearr_14160 = state_14071;
(statearr_14160[(16)] = inst_14043__$1);

return statearr_14160;
})();
if(cljs.core.truth_(inst_14043__$1)){
var statearr_14161_14350 = state_14071__$1;
(statearr_14161_14350[(1)] = (123));

} else {
var statearr_14162_14351 = state_14071__$1;
(statearr_14162_14351[(1)] = (124));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (43))){
var inst_13795 = (state_14071[(22)]);
var state_14071__$1 = state_14071;
var statearr_14163_14352 = state_14071__$1;
(statearr_14163_14352[(2)] = inst_13795);

(statearr_14163_14352[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (61))){
var inst_13708 = (state_14071[(74)]);
var state_14071__$1 = state_14071;
var statearr_14164_14353 = state_14071__$1;
(statearr_14164_14353[(2)] = inst_13708);

(statearr_14164_14353[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (29))){
var state_14071__$1 = state_14071;
var statearr_14165_14354 = state_14071__$1;
(statearr_14165_14354[(2)] = null);

(statearr_14165_14354[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (44))){
var state_14071__$1 = state_14071;
var statearr_14166_14355 = state_14071__$1;
(statearr_14166_14355[(2)] = false);

(statearr_14166_14355[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (93))){
var inst_13919 = (state_14071[(63)]);
var state_14071__$1 = state_14071;
var statearr_14167_14356 = state_14071__$1;
(statearr_14167_14356[(2)] = inst_13919);

(statearr_14167_14356[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (6))){
var inst_13709 = (state_14071[(78)]);
var inst_13714 = inst_13709.cljs$lang$protocol_mask$partition0$;
var inst_13715 = (inst_13714 & (64));
var inst_13716 = inst_13709.cljs$core$ISeq$;
var inst_13717 = (cljs.core.PROTOCOL_SENTINEL === inst_13716);
var inst_13718 = ((inst_13715) || (inst_13717));
var state_14071__$1 = state_14071;
if(cljs.core.truth_(inst_13718)){
var statearr_14168_14357 = state_14071__$1;
(statearr_14168_14357[(1)] = (9));

} else {
var statearr_14169_14358 = state_14071__$1;
(statearr_14169_14358[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (111))){
var inst_13965 = (state_14071[(9)]);
var inst_13897 = (state_14071[(31)]);
var inst_13865 = (state_14071[(45)]);
var inst_13898 = (state_14071[(13)]);
var inst_13871 = (state_14071[(14)]);
var inst_14014 = fluree.db.query.range.subject_groups__GT_allow_flakes.call(null,db,inst_13965,inst_13897,inst_13898,inst_13865,inst_13871);
var state_14071__$1 = state_14071;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14071__$1,(119),inst_14014);
} else {
if((state_val_14072 === (28))){
var inst_13763 = (state_14071[(2)]);
var state_14071__$1 = state_14071;
var statearr_14170_14359 = state_14071__$1;
(statearr_14170_14359[(2)] = inst_13763);

(statearr_14170_14359[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (64))){
var state_14071__$1 = state_14071;
var statearr_14171_14360 = state_14071__$1;
(statearr_14171_14360[(2)] = (2147483647));

(statearr_14171_14360[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (103))){
var inst_13938 = (state_14071[(2)]);
var state_14071__$1 = state_14071;
var statearr_14172_14361 = state_14071__$1;
(statearr_14172_14361[(2)] = inst_13938);

(statearr_14172_14361[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (51))){
var inst_13818 = (state_14071[(2)]);
var state_14071__$1 = state_14071;
if(cljs.core.truth_(inst_13818)){
var statearr_14173_14362 = state_14071__$1;
(statearr_14173_14362[(1)] = (52));

} else {
var statearr_14174_14363 = state_14071__$1;
(statearr_14174_14363[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (25))){
var inst_13765 = (state_14071[(73)]);
var inst_13765__$1 = (state_14071[(2)]);
var state_14071__$1 = (function (){var statearr_14175 = state_14071;
(statearr_14175[(73)] = inst_13765__$1);

return statearr_14175;
})();
if(cljs.core.truth_(inst_13765__$1)){
var statearr_14176_14364 = state_14071__$1;
(statearr_14176_14364[(1)] = (32));

} else {
var statearr_14177_14365 = state_14071__$1;
(statearr_14177_14365[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (34))){
var inst_13782 = (state_14071[(27)]);
var inst_13783 = (state_14071[(37)]);
var inst_13784 = (state_14071[(79)]);
var inst_13782__$1 = (state_14071[(2)]);
var inst_13783__$1 = cljs.core.nth.call(null,inst_13782__$1,(0),null);
var inst_13784__$1 = cljs.core.nth.call(null,inst_13783__$1,(0),null);
var inst_13785 = cljs.core.nth.call(null,inst_13783__$1,(1),null);
var inst_13786 = cljs.core.nth.call(null,inst_13782__$1,(1),null);
var inst_13787 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_13784__$1);
var state_14071__$1 = (function (){var statearr_14178 = state_14071;
(statearr_14178[(27)] = inst_13782__$1);

(statearr_14178[(57)] = inst_13785);

(statearr_14178[(36)] = inst_13786);

(statearr_14178[(37)] = inst_13783__$1);

(statearr_14178[(79)] = inst_13784__$1);

return statearr_14178;
})();
if(inst_13787){
var statearr_14179_14366 = state_14071__$1;
(statearr_14179_14366[(1)] = (35));

} else {
var statearr_14180_14367 = state_14071__$1;
(statearr_14180_14367[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (125))){
var inst_14043 = (state_14071[(16)]);
var inst_14051 = (state_14071[(2)]);
var state_14071__$1 = (function (){var statearr_14181 = state_14071;
(statearr_14181[(81)] = inst_14051);

return statearr_14181;
})();
if(cljs.core.truth_(inst_14043)){
var statearr_14182_14368 = state_14071__$1;
(statearr_14182_14368[(1)] = (127));

} else {
var statearr_14183_14369 = state_14071__$1;
(statearr_14183_14369[(1)] = (128));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (17))){
var inst_13703 = (state_14071[(54)]);
var inst_13742 = (state_14071[(2)]);
var inst_13743 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_13703);
var state_14071__$1 = (function (){var statearr_14184 = state_14071;
(statearr_14184[(26)] = inst_13742);

return statearr_14184;
})();
if(inst_13743){
var statearr_14185_14370 = state_14071__$1;
(statearr_14185_14370[(1)] = (19));

} else {
var statearr_14186_14371 = state_14071__$1;
(statearr_14186_14371[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (3))){
var inst_14069 = (state_14071[(2)]);
var state_14071__$1 = state_14071;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14071__$1,inst_14069);
} else {
if((state_val_14072 === (12))){
var inst_13709 = (state_14071[(78)]);
var inst_13727 = cljs.core.apply.call(null,cljs.core.hash_map,inst_13709);
var state_14071__$1 = state_14071;
var statearr_14187_14372 = state_14071__$1;
(statearr_14187_14372[(2)] = inst_13727);

(statearr_14187_14372[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (2))){
var inst_13695 = (state_14071[(17)]);
var inst_13702 = (state_14071[(19)]);
var inst_13709 = (state_14071[(78)]);
var _ = (function (){var statearr_14188 = state_14071;
(statearr_14188[(4)] = cljs.core.cons.call(null,(5),(state_14071[(4)])));

return statearr_14188;
})();
var inst_13695__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,start_match);
var inst_13696 = cljs.core.nth.call(null,inst_13695__$1,(0),null);
var inst_13697 = cljs.core.nth.call(null,inst_13695__$1,(1),null);
var inst_13698 = cljs.core.nth.call(null,inst_13695__$1,(2),null);
var inst_13699 = cljs.core.nth.call(null,inst_13695__$1,(3),null);
var inst_13700 = cljs.core.nth.call(null,inst_13695__$1,(4),null);
var inst_13701 = cljs.core.nth.call(null,inst_13695__$1,(5),null);
var inst_13702__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,end_match);
var inst_13703 = cljs.core.nth.call(null,inst_13702__$1,(0),null);
var inst_13704 = cljs.core.nth.call(null,inst_13702__$1,(1),null);
var inst_13705 = cljs.core.nth.call(null,inst_13702__$1,(2),null);
var inst_13706 = cljs.core.nth.call(null,inst_13702__$1,(3),null);
var inst_13707 = cljs.core.nth.call(null,inst_13702__$1,(4),null);
var inst_13708 = cljs.core.nth.call(null,inst_13702__$1,(5),null);
var inst_13709__$1 = opts;
var inst_13711 = (inst_13709__$1 == null);
var inst_13712 = cljs.core.not.call(null,inst_13711);
var state_14071__$1 = (function (){var statearr_14189 = state_14071;
(statearr_14189[(17)] = inst_13695__$1);

(statearr_14189[(19)] = inst_13702__$1);

(statearr_14189[(74)] = inst_13708);

(statearr_14189[(21)] = inst_13706);

(statearr_14189[(72)] = inst_13698);

(statearr_14189[(55)] = inst_13705);

(statearr_14189[(78)] = inst_13709__$1);

(statearr_14189[(35)] = inst_13700);

(statearr_14189[(76)] = inst_13697);

(statearr_14189[(56)] = inst_13701);

(statearr_14189[(39)] = inst_13699);

(statearr_14189[(54)] = inst_13703);

(statearr_14189[(49)] = inst_13707);

(statearr_14189[(66)] = inst_13704);

(statearr_14189[(65)] = inst_13696);

return statearr_14189;
})();
if(inst_13712){
var statearr_14190_14373 = state_14071__$1;
(statearr_14190_14373[(1)] = (6));

} else {
var statearr_14191_14374 = state_14071__$1;
(statearr_14191_14374[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (66))){
var inst_13838 = (state_14071[(2)]);
var state_14071__$1 = state_14071;
var statearr_14192_14375 = state_14071__$1;
(statearr_14192_14375[(2)] = inst_13838);

(statearr_14192_14375[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (107))){
var inst_13899 = (state_14071[(24)]);
var inst_13954 = (state_14071[(82)]);
var inst_13897 = (state_14071[(31)]);
var inst_13896 = (state_14071[(42)]);
var inst_13898 = (state_14071[(13)]);
var inst_13957 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13958 = (inst_13896 - inst_13954);
var inst_13959 = [inst_13958,inst_13897,inst_13898,inst_13899];
var inst_13960 = (new cljs.core.PersistentVector(null,4,(5),inst_13957,inst_13959,null));
var state_14071__$1 = state_14071;
var statearr_14193_14376 = state_14071__$1;
(statearr_14193_14376[(2)] = inst_13960);

(statearr_14193_14376[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (23))){
var inst_13698 = (state_14071[(72)]);
var state_14071__$1 = state_14071;
var statearr_14194_14377 = state_14071__$1;
(statearr_14194_14377[(2)] = inst_13698);

(statearr_14194_14377[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (47))){
var inst_13697 = (state_14071[(76)]);
var state_14071__$1 = state_14071;
var statearr_14195_14378 = state_14071__$1;
(statearr_14195_14378[(2)] = inst_13697);

(statearr_14195_14378[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (35))){
var inst_13784 = (state_14071[(79)]);
var inst_13789 = fluree.db.dbproto._subid.call(null,db,inst_13784);
var state_14071__$1 = state_14071;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14071__$1,(38),inst_13789);
} else {
if((state_val_14072 === (127))){
var inst_14051 = (state_14071[(81)]);
var state_14071__$1 = state_14071;
var statearr_14196_14379 = state_14071__$1;
(statearr_14196_14379[(2)] = inst_14051);

(statearr_14196_14379[(1)] = (129));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (82))){
var state_14071__$1 = state_14071;
var statearr_14197_14380 = state_14071__$1;
(statearr_14197_14380[(2)] = null);

(statearr_14197_14380[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (76))){
var inst_13866 = (state_14071[(70)]);
var state_14071__$1 = state_14071;
var statearr_14198_14381 = state_14071__$1;
(statearr_14198_14381[(2)] = inst_13866);

(statearr_14198_14381[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (97))){
var inst_13872 = (state_14071[(30)]);
var inst_13895 = (state_14071[(51)]);
var inst_13931 = (state_14071[(2)]);
var inst_13932 = fluree.db.dbproto._rhs.call(null,inst_13895);
var state_14071__$1 = (function (){var statearr_14199 = state_14071;
(statearr_14199[(7)] = inst_13932);

(statearr_14199[(64)] = inst_13931);

return statearr_14199;
})();
if(cljs.core.truth_(inst_13872)){
var statearr_14200_14382 = state_14071__$1;
(statearr_14200_14382[(1)] = (98));

} else {
var statearr_14201_14383 = state_14071__$1;
(statearr_14201_14383[(1)] = (99));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (19))){
var inst_13703 = (state_14071[(54)]);
var inst_13745 = fluree.db.dbproto._subid.call(null,db,inst_13703);
var state_14071__$1 = state_14071;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14071__$1,(22),inst_13745);
} else {
if((state_val_14072 === (57))){
var inst_13708 = (state_14071[(74)]);
var inst_13831 = (state_14071[(2)]);
var state_14071__$1 = (function (){var statearr_14202 = state_14071;
(statearr_14202[(41)] = inst_13831);

return statearr_14202;
})();
if(cljs.core.truth_(inst_13708)){
var statearr_14203_14384 = state_14071__$1;
(statearr_14203_14384[(1)] = (61));

} else {
var statearr_14204_14385 = state_14071__$1;
(statearr_14204_14385[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (68))){
var state_14071__$1 = state_14071;
var statearr_14205_14386 = state_14071__$1;
(statearr_14205_14386[(2)] = false);

(statearr_14205_14386[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (11))){
var inst_13722 = (state_14071[(2)]);
var state_14071__$1 = state_14071;
var statearr_14206_14387 = state_14071__$1;
(statearr_14206_14387[(2)] = inst_13722);

(statearr_14206_14387[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (115))){
var inst_13965 = (state_14071[(9)]);
var inst_13897 = (state_14071[(31)]);
var inst_13992 = (state_14071[(67)]);
var inst_13993 = (state_14071[(68)]);
var inst_13991 = (state_14071[(69)]);
var inst_13865 = (state_14071[(45)]);
var inst_13987 = (state_14071[(2)]);
var inst_13988 = cljs.core.nth.call(null,inst_13987,(0),null);
var inst_13989 = cljs.core.nth.call(null,inst_13987,(1),null);
var inst_13990 = cljs.core.take.call(null,inst_13989,inst_13965);
var inst_13991__$1 = cljs.core.apply.call(null,cljs.core.concat,inst_13990);
var inst_13992__$1 = cljs.core.count.call(null,inst_13991__$1);
var inst_13993__$1 = (inst_13897 + inst_13992__$1);
var inst_13994 = (inst_13993__$1 > inst_13865);
var state_14071__$1 = (function (){var statearr_14208 = state_14071;
(statearr_14208[(67)] = inst_13992__$1);

(statearr_14208[(68)] = inst_13993__$1);

(statearr_14208[(69)] = inst_13991__$1);

(statearr_14208[(80)] = inst_13988);

return statearr_14208;
})();
if(cljs.core.truth_(inst_13994)){
var statearr_14209_14388 = state_14071__$1;
(statearr_14209_14388[(1)] = (116));

} else {
var statearr_14210_14389 = state_14071__$1;
(statearr_14210_14389[(1)] = (117));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (9))){
var state_14071__$1 = state_14071;
var statearr_14211_14390 = state_14071__$1;
(statearr_14211_14390[(2)] = true);

(statearr_14211_14390[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (5))){
var _ = (function (){var statearr_14212 = state_14071;
(statearr_14212[(4)] = cljs.core.rest.call(null,(state_14071[(4)])));

return statearr_14212;
})();
var state_14071__$1 = state_14071;
var ex14207 = (state_14071__$1[(2)]);
var statearr_14213_14391 = state_14071__$1;
(statearr_14213_14391[(5)] = ex14207);


if((ex14207 instanceof Error)){
var statearr_14214_14392 = state_14071__$1;
(statearr_14214_14392[(1)] = (4));

(statearr_14214_14392[(5)] = null);

} else {
throw ex14207;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (112))){
var inst_13899 = (state_14071[(24)]);
var inst_14019 = (state_14071[(2)]);
var inst_14020 = cljs.core.nth.call(null,inst_14019,(0),null);
var inst_14021 = cljs.core.nth.call(null,inst_14019,(1),null);
var inst_14022 = cljs.core.nth.call(null,inst_14019,(2),null);
var inst_14023 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14024 = cljs.core.into.call(null,inst_13899,inst_14022);
var inst_14025 = [(0),inst_14020,inst_14021,inst_14024];
var inst_14026 = (new cljs.core.PersistentVector(null,4,(5),inst_14023,inst_14025,null));
var state_14071__$1 = state_14071;
var statearr_14215_14393 = state_14071__$1;
(statearr_14215_14393[(2)] = inst_14026);

(statearr_14215_14393[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (83))){
var inst_14066 = (state_14071[(2)]);
var _ = (function (){var statearr_14216 = state_14071;
(statearr_14216[(4)] = cljs.core.rest.call(null,(state_14071[(4)])));

return statearr_14216;
})();
var state_14071__$1 = state_14071;
var statearr_14217_14394 = state_14071__$1;
(statearr_14217_14394[(2)] = inst_14066);

(statearr_14217_14394[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (14))){
var inst_13730 = (state_14071[(40)]);
var inst_13696 = (state_14071[(65)]);
var inst_13730__$1 = (state_14071[(2)]);
var inst_13731 = cljs.core.get.call(null,inst_13730__$1,new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441));
var inst_13732 = cljs.core.get.call(null,inst_13730__$1,new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845));
var inst_13733 = cljs.core.get.call(null,inst_13730__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var inst_13734 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_13696);
var state_14071__$1 = (function (){var statearr_14218 = state_14071;
(statearr_14218[(75)] = inst_13733);

(statearr_14218[(28)] = inst_13731);

(statearr_14218[(40)] = inst_13730__$1);

(statearr_14218[(50)] = inst_13732);

return statearr_14218;
})();
if(inst_13734){
var statearr_14219_14395 = state_14071__$1;
(statearr_14219_14395[(1)] = (15));

} else {
var statearr_14220_14396 = state_14071__$1;
(statearr_14220_14396[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (45))){
var inst_13809 = (state_14071[(2)]);
var state_14071__$1 = state_14071;
if(cljs.core.truth_(inst_13809)){
var statearr_14221_14397 = state_14071__$1;
(statearr_14221_14397[(1)] = (46));

} else {
var statearr_14222_14398 = state_14071__$1;
(statearr_14222_14398[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (53))){
var inst_13704 = (state_14071[(66)]);
var state_14071__$1 = state_14071;
var statearr_14223_14399 = state_14071__$1;
(statearr_14223_14399[(2)] = inst_13704);

(statearr_14223_14399[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (78))){
var inst_13871 = (state_14071[(14)]);
var inst_13871__$1 = (state_14071[(2)]);
var inst_13872 = cljs.core._EQ_.call(null,inst_13871__$1,fluree.db.util.core.max_long);
var inst_13873 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_13874 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13875 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_13876 = (new cljs.core.PersistentVector(null,3,(5),inst_13874,inst_13875,null));
var inst_13877 = cljs.core.get_in.call(null,db,inst_13876);
var inst_13878 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_13879 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13880 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_13881 = (new cljs.core.PersistentVector(null,2,(5),inst_13879,inst_13880,null));
var inst_13882 = cljs.core.get_in.call(null,db,inst_13881);
var inst_13883 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db);
var inst_13884 = cljs.core.get.call(null,db,idx);
var inst_13885 = fluree.db.dbproto._resolve.call(null,inst_13884);
var state_14071__$1 = (function (){var statearr_14224 = state_14071;
(statearr_14224[(20)] = inst_13883);

(statearr_14224[(25)] = inst_13882);

(statearr_14224[(30)] = inst_13872);

(statearr_14224[(43)] = inst_13877);

(statearr_14224[(47)] = inst_13878);

(statearr_14224[(48)] = inst_13873);

(statearr_14224[(14)] = inst_13871__$1);

return statearr_14224;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14071__$1,(79),inst_13885);
} else {
if((state_val_14072 === (132))){
var inst_14061 = (state_14071[(2)]);
var state_14071__$1 = state_14071;
var statearr_14225_14400 = state_14071__$1;
(statearr_14225_14400[(2)] = inst_14061);

(statearr_14225_14400[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (26))){
var inst_13705 = (state_14071[(55)]);
var state_14071__$1 = state_14071;
var statearr_14226_14401 = state_14071__$1;
(statearr_14226_14401[(2)] = inst_13705);

(statearr_14226_14401[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (123))){
var inst_13932 = (state_14071[(7)]);
var inst_13888 = (state_14071[(18)]);
var inst_13883 = (state_14071[(20)]);
var inst_13882 = (state_14071[(25)]);
var inst_13878 = (state_14071[(47)]);
var inst_14045 = fluree.db.query.range.find_next_valid_node.call(null,inst_13888,inst_13932,inst_13878,inst_13882,inst_13883);
var state_14071__$1 = state_14071;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14071__$1,(126),inst_14045);
} else {
if((state_val_14072 === (16))){
var inst_13696 = (state_14071[(65)]);
var state_14071__$1 = state_14071;
var statearr_14227_14402 = state_14071__$1;
(statearr_14227_14402[(2)] = inst_13696);

(statearr_14227_14402[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (81))){
var inst_13867 = (state_14071[(71)]);
var inst_13892 = (state_14071[(34)]);
var inst_13894 = cljs.core.PersistentVector.EMPTY;
var inst_13895 = inst_13892;
var inst_13896 = inst_13867;
var inst_13897 = (0);
var inst_13898 = (0);
var inst_13899 = inst_13894;
var state_14071__$1 = (function (){var statearr_14228 = state_14071;
(statearr_14228[(24)] = inst_13899);

(statearr_14228[(31)] = inst_13897);

(statearr_14228[(42)] = inst_13896);

(statearr_14228[(51)] = inst_13895);

(statearr_14228[(13)] = inst_13898);

return statearr_14228;
})();
var statearr_14229_14403 = state_14071__$1;
(statearr_14229_14403[(2)] = null);

(statearr_14229_14403[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (120))){
var inst_13932 = (state_14071[(7)]);
var inst_14032 = (state_14071[(60)]);
var inst_13877 = (state_14071[(43)]);
var inst_13865 = (state_14071[(45)]);
var inst_13871 = (state_14071[(14)]);
var inst_14033 = (state_14071[(61)]);
var inst_13842 = (state_14071[(53)]);
var inst_14036 = inst_13877.call(null,inst_13932,inst_13842);
var inst_14037 = (inst_14036 < (0));
var inst_14038 = (inst_14032 < inst_13865);
var inst_14039 = (inst_14033 < inst_13871);
var inst_14040 = ((inst_14037) && (inst_14038) && (inst_14039));
var state_14071__$1 = state_14071;
var statearr_14230_14404 = state_14071__$1;
(statearr_14230_14404[(2)] = inst_14040);

(statearr_14230_14404[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (79))){
var inst_13888 = (state_14071[(18)]);
var inst_13883 = (state_14071[(20)]);
var inst_13882 = (state_14071[(25)]);
var inst_13841 = (state_14071[(32)]);
var inst_13878 = (state_14071[(47)]);
var inst_13887 = (state_14071[(2)]);
var inst_13888__$1 = fluree.db.util.async.throw_err.call(null,inst_13887);
var inst_13889 = fluree.db.query.range.find_next_valid_node.call(null,inst_13888__$1,inst_13841,inst_13878,inst_13882,inst_13883);
var state_14071__$1 = (function (){var statearr_14231 = state_14071;
(statearr_14231[(18)] = inst_13888__$1);

return statearr_14231;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14071__$1,(80),inst_13889);
} else {
if((state_val_14072 === (38))){
var inst_13791 = (state_14071[(2)]);
var inst_13792 = fluree.db.util.async.throw_err.call(null,inst_13791);
var state_14071__$1 = state_14071;
var statearr_14232_14405 = state_14071__$1;
(statearr_14232_14405[(2)] = inst_13792);

(statearr_14232_14405[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (126))){
var inst_14047 = (state_14071[(2)]);
var inst_14048 = fluree.db.util.async.throw_err.call(null,inst_14047);
var state_14071__$1 = state_14071;
var statearr_14233_14406 = state_14071__$1;
(statearr_14233_14406[(2)] = inst_14048);

(statearr_14233_14406[(1)] = (125));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (98))){
var inst_13896 = (state_14071[(42)]);
var inst_13934 = cljs.core._EQ_.call(null,(0),inst_13896);
var state_14071__$1 = state_14071;
if(inst_13934){
var statearr_14234_14407 = state_14071__$1;
(statearr_14234_14407[(1)] = (101));

} else {
var statearr_14235_14408 = state_14071__$1;
(statearr_14235_14408[(1)] = (102));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (124))){
var state_14071__$1 = state_14071;
var statearr_14236_14409 = state_14071__$1;
(statearr_14236_14409[(2)] = null);

(statearr_14236_14409[(1)] = (125));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (87))){
var inst_13905 = (state_14071[(23)]);
var state_14071__$1 = state_14071;
var statearr_14237_14410 = state_14071__$1;
(statearr_14237_14410[(2)] = inst_13905);

(statearr_14237_14410[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (30))){
var state_14071__$1 = state_14071;
var statearr_14238_14411 = state_14071__$1;
(statearr_14238_14411[(2)] = null);

(statearr_14238_14411[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (73))){
var inst_13843 = (state_14071[(8)]);
var inst_13861 = cljs.core.apply.call(null,cljs.core.hash_map,inst_13843);
var state_14071__$1 = state_14071;
var statearr_14239_14412 = state_14071__$1;
(statearr_14239_14412[(2)] = inst_13861);

(statearr_14239_14412[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (96))){
var inst_13925 = (state_14071[(62)]);
var state_14071__$1 = state_14071;
var statearr_14240_14413 = state_14071__$1;
(statearr_14240_14413[(2)] = inst_13925);

(statearr_14240_14413[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (10))){
var state_14071__$1 = state_14071;
var statearr_14241_14414 = state_14071__$1;
(statearr_14241_14414[(2)] = false);

(statearr_14241_14414[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (18))){
var inst_13738 = (state_14071[(2)]);
var inst_13739 = fluree.db.util.async.throw_err.call(null,inst_13738);
var state_14071__$1 = state_14071;
var statearr_14242_14415 = state_14071__$1;
(statearr_14242_14415[(2)] = inst_13739);

(statearr_14242_14415[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (105))){
var inst_13932 = (state_14071[(7)]);
var inst_13695 = (state_14071[(17)]);
var inst_13888 = (state_14071[(18)]);
var inst_13702 = (state_14071[(19)]);
var inst_13883 = (state_14071[(20)]);
var inst_13953 = (state_14071[(77)]);
var inst_13706 = (state_14071[(21)]);
var inst_13931 = (state_14071[(64)]);
var inst_13795 = (state_14071[(22)]);
var inst_13905 = (state_14071[(23)]);
var inst_13899 = (state_14071[(24)]);
var inst_13882 = (state_14071[(25)]);
var inst_13742 = (state_14071[(26)]);
var inst_13782 = (state_14071[(27)]);
var inst_13731 = (state_14071[(28)]);
var inst_13751 = (state_14071[(29)]);
var inst_13872 = (state_14071[(30)]);
var inst_13954 = (state_14071[(82)]);
var inst_13897 = (state_14071[(31)]);
var inst_13841 = (state_14071[(32)]);
var inst_13864 = (state_14071[(33)]);
var inst_13892 = (state_14071[(34)]);
var inst_13700 = (state_14071[(35)]);
var inst_13786 = (state_14071[(36)]);
var inst_13783 = (state_14071[(37)]);
var inst_13804 = (state_14071[(38)]);
var inst_13699 = (state_14071[(39)]);
var inst_13730 = (state_14071[(40)]);
var inst_13831 = (state_14071[(41)]);
var inst_13896 = (state_14071[(42)]);
var inst_13877 = (state_14071[(43)]);
var inst_13813 = (state_14071[(44)]);
var inst_13865 = (state_14071[(45)]);
var inst_13822 = (state_14071[(46)]);
var inst_13878 = (state_14071[(47)]);
var inst_13873 = (state_14071[(48)]);
var inst_13707 = (state_14071[(49)]);
var inst_13732 = (state_14071[(50)]);
var inst_13895 = (state_14071[(51)]);
var inst_13840 = (state_14071[(52)]);
var inst_13898 = (state_14071[(13)]);
var inst_13871 = (state_14071[(14)]);
var inst_13842 = (state_14071[(53)]);
var inst_13952 = (function (){var no_filter_QMARK_ = true;
var map__13687 = inst_13730;
var base_result_SINGLEQUOTE_ = inst_13931;
var t = inst_13878;
var max_limit_QMARK_ = inst_13872;
var next_node = inst_13895;
var fast_forward_db_QMARK_ = inst_13883;
var s1 = inst_13742;
var o2 = inst_13804;
var t1 = inst_13699;
var predicate_fn = inst_13732;
var i = inst_13897;
var rhs = inst_13932;
var m1 = inst_13831;
var root_node = inst_13888;
var s2 = inst_13751;
var map__13694 = inst_13864;
var p2 = inst_13822;
var vec__13691 = inst_13783;
var permissions = inst_13873;
var limit = inst_13871;
var start_flake = inst_13841;
var flake_limit = inst_13865;
var offset = inst_13896;
var vec__13688 = inst_13782;
var acc = inst_13899;
var vec__13681 = inst_13695;
var t2 = inst_13706;
var vec__13684 = inst_13702;
var op1 = inst_13700;
var o1 = inst_13795;
var end_flake = inst_13842;
var base_result = inst_13905;
var s = inst_13898;
var node_start = inst_13892;
var p1 = inst_13813;
var subject_fn = inst_13731;
var object_fn = inst_13786;
var idx_compare = inst_13877;
var op2 = inst_13707;
var m2 = inst_13840;
var novelty = inst_13882;
return (function (p1__13666_SHARP_){
return p1__13666_SHARP_.s;
});
})();
var inst_13953__$1 = cljs.core.partition_by.call(null,inst_13952,inst_13931);
var inst_13954__$1 = cljs.core.count.call(null,inst_13953__$1);
var inst_13955 = (inst_13896 > inst_13954__$1);
var state_14071__$1 = (function (){var statearr_14243 = state_14071;
(statearr_14243[(77)] = inst_13953__$1);

(statearr_14243[(82)] = inst_13954__$1);

return statearr_14243;
})();
if(cljs.core.truth_(inst_13955)){
var statearr_14244_14416 = state_14071__$1;
(statearr_14244_14416[(1)] = (107));

} else {
var statearr_14245_14417 = state_14071__$1;
(statearr_14245_14417[(1)] = (108));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (52))){
var state_14071__$1 = state_14071;
var statearr_14246_14418 = state_14071__$1;
(statearr_14246_14418[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_14246_14418[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (114))){
var inst_13974 = (state_14071[(12)]);
var inst_13983 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13984 = [inst_13974,inst_13974];
var inst_13985 = (new cljs.core.PersistentVector(null,2,(5),inst_13983,inst_13984,null));
var state_14071__$1 = state_14071;
var statearr_14247_14419 = state_14071__$1;
(statearr_14247_14419[(2)] = inst_13985);

(statearr_14247_14419[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (67))){
var inst_13843 = (state_14071[(8)]);
var inst_13848 = inst_13843.cljs$lang$protocol_mask$partition0$;
var inst_13849 = (inst_13848 & (64));
var inst_13850 = inst_13843.cljs$core$ISeq$;
var inst_13851 = (cljs.core.PROTOCOL_SENTINEL === inst_13850);
var inst_13852 = ((inst_13849) || (inst_13851));
var state_14071__$1 = state_14071;
if(cljs.core.truth_(inst_13852)){
var statearr_14248_14420 = state_14071__$1;
(statearr_14248_14420[(1)] = (70));

} else {
var statearr_14249_14421 = state_14071__$1;
(statearr_14249_14421[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (71))){
var state_14071__$1 = state_14071;
var statearr_14250_14422 = state_14071__$1;
(statearr_14250_14422[(2)] = false);

(statearr_14250_14422[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (42))){
var inst_13800 = (state_14071[(2)]);
var inst_13801 = fluree.db.util.async.throw_err.call(null,inst_13800);
var state_14071__$1 = state_14071;
var statearr_14251_14423 = state_14071__$1;
(statearr_14251_14423[(2)] = inst_13801);

(statearr_14251_14423[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (80))){
var inst_13892 = (state_14071[(34)]);
var inst_13891 = (state_14071[(2)]);
var inst_13892__$1 = fluree.db.util.async.throw_err.call(null,inst_13891);
var state_14071__$1 = (function (){var statearr_14252 = state_14071;
(statearr_14252[(34)] = inst_13892__$1);

return statearr_14252;
})();
if(cljs.core.truth_(inst_13892__$1)){
var statearr_14253_14424 = state_14071__$1;
(statearr_14253_14424[(1)] = (81));

} else {
var statearr_14254_14425 = state_14071__$1;
(statearr_14254_14425[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (37))){
var inst_13785 = (state_14071[(57)]);
var inst_13795 = (state_14071[(2)]);
var inst_13796 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_13785);
var state_14071__$1 = (function (){var statearr_14255 = state_14071;
(statearr_14255[(22)] = inst_13795);

return statearr_14255;
})();
if(inst_13796){
var statearr_14256_14426 = state_14071__$1;
(statearr_14256_14426[(1)] = (39));

} else {
var statearr_14257_14427 = state_14071__$1;
(statearr_14257_14427[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (63))){
var inst_13706 = (state_14071[(21)]);
var inst_13795 = (state_14071[(22)]);
var inst_13742 = (state_14071[(26)]);
var inst_13751 = (state_14071[(29)]);
var inst_13700 = (state_14071[(35)]);
var inst_13804 = (state_14071[(38)]);
var inst_13699 = (state_14071[(39)]);
var inst_13831 = (state_14071[(41)]);
var inst_13813 = (state_14071[(44)]);
var inst_13822 = (state_14071[(46)]);
var inst_13707 = (state_14071[(49)]);
var inst_13840 = (state_14071[(52)]);
var inst_13843 = (state_14071[(8)]);
var inst_13840__$1 = (state_14071[(2)]);
var inst_13841 = fluree.db.flake.__GT_Flake.call(null,inst_13742,inst_13813,inst_13795,inst_13699,inst_13700,inst_13831);
var inst_13842 = fluree.db.flake.__GT_Flake.call(null,inst_13751,inst_13822,inst_13804,inst_13706,inst_13707,inst_13840__$1);
var inst_13843__$1 = opts;
var inst_13845 = (inst_13843__$1 == null);
var inst_13846 = cljs.core.not.call(null,inst_13845);
var state_14071__$1 = (function (){var statearr_14258 = state_14071;
(statearr_14258[(32)] = inst_13841);

(statearr_14258[(52)] = inst_13840__$1);

(statearr_14258[(8)] = inst_13843__$1);

(statearr_14258[(53)] = inst_13842);

return statearr_14258;
})();
if(inst_13846){
var statearr_14259_14428 = state_14071__$1;
(statearr_14259_14428[(1)] = (67));

} else {
var statearr_14260_14429 = state_14071__$1;
(statearr_14260_14429[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (94))){
var inst_13786 = (state_14071[(36)]);
var inst_13925 = (state_14071[(2)]);
var state_14071__$1 = (function (){var statearr_14261 = state_14071;
(statearr_14261[(62)] = inst_13925);

return statearr_14261;
})();
if(cljs.core.truth_(inst_13786)){
var statearr_14262_14430 = state_14071__$1;
(statearr_14262_14430[(1)] = (95));

} else {
var statearr_14263_14431 = state_14071__$1;
(statearr_14263_14431[(1)] = (96));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (8))){
var inst_13725 = (state_14071[(2)]);
var state_14071__$1 = state_14071;
if(cljs.core.truth_(inst_13725)){
var statearr_14264_14432 = state_14071__$1;
(statearr_14264_14432[(1)] = (12));

} else {
var statearr_14265_14433 = state_14071__$1;
(statearr_14265_14433[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (49))){
var inst_13804 = (state_14071[(38)]);
var state_14071__$1 = state_14071;
var statearr_14266_14434 = state_14071__$1;
(statearr_14266_14434[(2)] = inst_13804);

(statearr_14266_14434[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14072 === (84))){
var inst_13841 = (state_14071[(32)]);
var inst_13895 = (state_14071[(51)]);
var inst_13842 = (state_14071[(53)]);
var inst_13904 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_13895);
var inst_13905 = fluree.db.flake.subrange.call(null,inst_13904,start_test,inst_13841,end_test,inst_13842);
var inst_13907 = fluree.db.query.range.value_with_nil_pred.call(null,idx,inst_13841,inst_13842);
var state_14071__$1 = (function (){var statearr_14267 = state_14071;
(statearr_14267[(23)] = inst_13905);

return statearr_14267;
})();
if(inst_13907){
var statearr_14268_14435 = state_14071__$1;
(statearr_14268_14435[(1)] = (86));

} else {
var statearr_14269_14436 = state_14071__$1;
(statearr_14269_14436[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2468__auto__ = null;
var fluree$db$query$range$state_machine__2468__auto____0 = (function (){
var statearr_14270 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14270[(0)] = fluree$db$query$range$state_machine__2468__auto__);

(statearr_14270[(1)] = (1));

return statearr_14270;
});
var fluree$db$query$range$state_machine__2468__auto____1 = (function (state_14071){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_14071);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e14271){var ex__2471__auto__ = e14271;
var statearr_14272_14437 = state_14071;
(statearr_14272_14437[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_14071[(4)]))){
var statearr_14273_14438 = state_14071;
(statearr_14273_14438[(1)] = cljs.core.first.call(null,(state_14071[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14439 = state_14071;
state_14071 = G__14439;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2468__auto__ = function(state_14071){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2468__auto____1.call(this,state_14071);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2468__auto____0;
fluree$db$query$range$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2468__auto____1;
return fluree$db$query$range$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_14274 = f__2491__auto__.call(null);
(statearr_14274[(6)] = c__2490__auto__);

return statearr_14274;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_.call(null,o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find.call(null,/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id.call(null,(3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id.call(null,(3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_14495){
var state_val_14496 = (state_14495[(1)]);
if((state_val_14496 === (7))){
var inst_14459 = (state_14495[(7)]);
var inst_14469 = (state_14495[(8)]);
var inst_14467 = fluree.db.flake.Flake__GT_parts.call(null,inst_14459);
var inst_14468 = cljs.core.nth.call(null,inst_14467,(0),null);
var inst_14469__$1 = cljs.core.nth.call(null,inst_14467,(1),null);
var inst_14470 = cljs.core.nth.call(null,inst_14467,(2),null);
var inst_14471 = cljs.core.nth.call(null,inst_14467,(3),null);
var inst_14472 = cljs.core.nth.call(null,inst_14467,(4),null);
var inst_14473 = cljs.core.nth.call(null,inst_14467,(5),null);
var inst_14474 = fluree.db.dbproto._tag.call(null,db,inst_14470,inst_14469__$1);
var state_14495__$1 = (function (){var statearr_14497 = state_14495;
(statearr_14497[(9)] = inst_14471);

(statearr_14497[(10)] = inst_14473);

(statearr_14497[(8)] = inst_14469__$1);

(statearr_14497[(11)] = inst_14472);

(statearr_14497[(12)] = inst_14468);

return statearr_14497;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14495__$1,(10),inst_14474);
} else {
if((state_val_14496 === (1))){
var inst_14447 = flakes;
var inst_14448 = cljs.core.seq.call(null,inst_14447);
var inst_14449 = cljs.core.first.call(null,inst_14448);
var inst_14450 = cljs.core.next.call(null,inst_14448);
var inst_14451 = cljs.core.PersistentVector.EMPTY;
var inst_14452 = inst_14447;
var inst_14453 = inst_14451;
var state_14495__$1 = (function (){var statearr_14498 = state_14495;
(statearr_14498[(13)] = inst_14450);

(statearr_14498[(14)] = inst_14449);

(statearr_14498[(15)] = inst_14452);

(statearr_14498[(16)] = inst_14453);

return statearr_14498;
})();
var statearr_14499_14517 = state_14495__$1;
(statearr_14499_14517[(2)] = null);

(statearr_14499_14517[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14496 === (4))){
var inst_14459 = (state_14495[(7)]);
var inst_14462 = fluree.db.query.range.is_tag_flake_QMARK_.call(null,inst_14459);
var state_14495__$1 = state_14495;
if(inst_14462){
var statearr_14500_14518 = state_14495__$1;
(statearr_14500_14518[(1)] = (7));

} else {
var statearr_14501_14519 = state_14495__$1;
(statearr_14501_14519[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14496 === (6))){
var inst_14491 = (state_14495[(2)]);
var state_14495__$1 = state_14495;
var statearr_14502_14520 = state_14495__$1;
(statearr_14502_14520[(2)] = inst_14491);

(statearr_14502_14520[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14496 === (3))){
var inst_14493 = (state_14495[(2)]);
var state_14495__$1 = state_14495;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14495__$1,inst_14493);
} else {
if((state_val_14496 === (2))){
var inst_14459 = (state_14495[(7)]);
var inst_14452 = (state_14495[(15)]);
var inst_14458 = cljs.core.seq.call(null,inst_14452);
var inst_14459__$1 = cljs.core.first.call(null,inst_14458);
var inst_14460 = cljs.core.next.call(null,inst_14458);
var state_14495__$1 = (function (){var statearr_14503 = state_14495;
(statearr_14503[(7)] = inst_14459__$1);

(statearr_14503[(17)] = inst_14460);

return statearr_14503;
})();
if(cljs.core.truth_(inst_14459__$1)){
var statearr_14504_14521 = state_14495__$1;
(statearr_14504_14521[(1)] = (4));

} else {
var statearr_14505_14522 = state_14495__$1;
(statearr_14505_14522[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14496 === (9))){
var inst_14488 = (state_14495[(2)]);
var state_14495__$1 = state_14495;
var statearr_14506_14523 = state_14495__$1;
(statearr_14506_14523[(2)] = inst_14488);

(statearr_14506_14523[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14496 === (5))){
var inst_14453 = (state_14495[(16)]);
var state_14495__$1 = state_14495;
var statearr_14507_14524 = state_14495__$1;
(statearr_14507_14524[(2)] = inst_14453);

(statearr_14507_14524[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14496 === (10))){
var inst_14471 = (state_14495[(9)]);
var inst_14473 = (state_14495[(10)]);
var inst_14460 = (state_14495[(17)]);
var inst_14469 = (state_14495[(8)]);
var inst_14472 = (state_14495[(11)]);
var inst_14453 = (state_14495[(16)]);
var inst_14468 = (state_14495[(12)]);
var inst_14476 = (state_14495[(2)]);
var inst_14477 = fluree.db.util.async.throw_err.call(null,inst_14476);
var inst_14478 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14479 = [inst_14468,inst_14469,inst_14477,inst_14471,inst_14472,inst_14473];
var inst_14480 = (new cljs.core.PersistentVector(null,6,(5),inst_14478,inst_14479,null));
var inst_14481 = fluree.db.flake.parts__GT_Flake.call(null,inst_14480);
var inst_14482 = cljs.core.conj.call(null,inst_14453,inst_14481);
var inst_14452 = inst_14460;
var inst_14453__$1 = inst_14482;
var state_14495__$1 = (function (){var statearr_14508 = state_14495;
(statearr_14508[(15)] = inst_14452);

(statearr_14508[(16)] = inst_14453__$1);

return statearr_14508;
})();
var statearr_14509_14525 = state_14495__$1;
(statearr_14509_14525[(2)] = null);

(statearr_14509_14525[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14496 === (8))){
var inst_14459 = (state_14495[(7)]);
var inst_14460 = (state_14495[(17)]);
var inst_14453 = (state_14495[(16)]);
var inst_14485 = cljs.core.conj.call(null,inst_14453,inst_14459);
var inst_14452 = inst_14460;
var inst_14453__$1 = inst_14485;
var state_14495__$1 = (function (){var statearr_14510 = state_14495;
(statearr_14510[(15)] = inst_14452);

(statearr_14510[(16)] = inst_14453__$1);

return statearr_14510;
})();
var statearr_14511_14526 = state_14495__$1;
(statearr_14511_14526[(2)] = null);

(statearr_14511_14526[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2468__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2468__auto____0 = (function (){
var statearr_14512 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14512[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2468__auto__);

(statearr_14512[(1)] = (1));

return statearr_14512;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2468__auto____1 = (function (state_14495){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_14495);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e14513){var ex__2471__auto__ = e14513;
var statearr_14514_14527 = state_14495;
(statearr_14514_14527[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_14495[(4)]))){
var statearr_14515_14528 = state_14495;
(statearr_14515_14528[(1)] = cljs.core.first.call(null,(state_14495[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14529 = state_14495;
state_14495 = G__14529;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2468__auto__ = function(state_14495){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2468__auto____1.call(this,state_14495);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2468__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2468__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_14516 = f__2491__auto__.call(null);
(statearr_14516[(6)] = c__2490__auto__);

return statearr_14516;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__14531 = arguments.length;
switch (G__14531) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.call(null,db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_14682){
var state_val_14683 = (state_14682[(1)]);
if((state_val_14683 === (62))){
var inst_14669 = (state_14682[(7)]);
var state_14682__$1 = state_14682;
var statearr_14684_14773 = state_14682__$1;
(statearr_14684_14773[(2)] = inst_14669);

(statearr_14684_14773[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (7))){
var state_14682__$1 = state_14682;
var statearr_14685_14774 = state_14682__$1;
(statearr_14685_14774[(2)] = false);

(statearr_14685_14774[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (59))){
var inst_14661 = (state_14682[(2)]);
var state_14682__$1 = state_14682;
var statearr_14686_14775 = state_14682__$1;
(statearr_14686_14775[(2)] = inst_14661);

(statearr_14686_14775[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (20))){
var state_14682__$1 = state_14682;
var statearr_14687_14776 = state_14682__$1;
(statearr_14687_14776[(2)] = null);

(statearr_14687_14776[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (58))){
var state_14682__$1 = state_14682;
var statearr_14688_14777 = state_14682__$1;
(statearr_14688_14777[(2)] = null);

(statearr_14688_14777[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (60))){
var inst_14657 = (state_14682[(2)]);
var inst_14658 = fluree.db.util.async.throw_err.call(null,inst_14657);
var state_14682__$1 = state_14682;
var statearr_14689_14778 = state_14682__$1;
(statearr_14689_14778[(2)] = inst_14658);

(statearr_14689_14778[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (27))){
var inst_14582 = (state_14682[(8)]);
var inst_14593 = fluree.db.query.range.non_nil_non_boolean_QMARK_.call(null,inst_14582);
var state_14682__$1 = state_14682;
if(inst_14593){
var statearr_14690_14779 = state_14682__$1;
(statearr_14690_14779[(1)] = (30));

} else {
var statearr_14691_14780 = state_14682__$1;
(statearr_14691_14780[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (1))){
var state_14682__$1 = state_14682;
var statearr_14692_14781 = state_14682__$1;
(statearr_14692_14781[(2)] = null);

(statearr_14692_14781[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (24))){
var inst_14543 = (state_14682[(9)]);
var state_14682__$1 = state_14682;
if(cljs.core.truth_(inst_14543)){
var statearr_14693_14782 = state_14682__$1;
(statearr_14693_14782[(1)] = (27));

} else {
var statearr_14694_14783 = state_14682__$1;
(statearr_14694_14783[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (55))){
var inst_14663 = (state_14682[(2)]);
var state_14682__$1 = state_14682;
var statearr_14695_14784 = state_14682__$1;
(statearr_14695_14784[(2)] = inst_14663);

(statearr_14695_14784[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (39))){
var inst_14613 = (state_14682[(2)]);
var inst_14614 = fluree.db.util.async.throw_err.call(null,inst_14613);
var state_14682__$1 = state_14682;
var statearr_14696_14785 = state_14682__$1;
(statearr_14696_14785[(2)] = inst_14614);

(statearr_14696_14785[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (46))){
var inst_14626 = (state_14682[(10)]);
var inst_14626__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(opts);
var state_14682__$1 = (function (){var statearr_14697 = state_14682;
(statearr_14697[(10)] = inst_14626__$1);

return statearr_14697;
})();
if(cljs.core.truth_(inst_14626__$1)){
var statearr_14698_14786 = state_14682__$1;
(statearr_14698_14786[(1)] = (49));

} else {
var statearr_14699_14787 = state_14682__$1;
(statearr_14699_14787[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (4))){
var inst_14532 = (state_14682[(2)]);
var state_14682__$1 = state_14682;
var statearr_14700_14788 = state_14682__$1;
(statearr_14700_14788[(2)] = inst_14532);

(statearr_14700_14788[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (54))){
var inst_14582 = (state_14682[(8)]);
var state_14682__$1 = state_14682;
if(cljs.core.truth_(inst_14582)){
var statearr_14701_14789 = state_14682__$1;
(statearr_14701_14789[(1)] = (57));

} else {
var statearr_14702_14790 = state_14682__$1;
(statearr_14702_14790[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (15))){
var inst_14544 = (state_14682[(11)]);
var inst_14563 = fluree.db.dbproto._tag_id.call(null,db,inst_14544);
var state_14682__$1 = state_14682;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14682__$1,(18),inst_14563);
} else {
if((state_val_14683 === (48))){
var inst_14665 = (state_14682[(2)]);
var state_14682__$1 = state_14682;
var statearr_14703_14791 = state_14682__$1;
(statearr_14703_14791[(2)] = inst_14665);

(statearr_14703_14791[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (50))){
var inst_14545 = (state_14682[(12)]);
var inst_14626 = (state_14682[(10)]);
var inst_14557 = (state_14682[(13)]);
var inst_14542 = (state_14682[(14)]);
var inst_14552 = (state_14682[(15)]);
var inst_14543 = (state_14682[(9)]);
var inst_14546 = (state_14682[(16)]);
var inst_14582 = (state_14682[(8)]);
var inst_14541 = (state_14682[(17)]);
var inst_14630 = (function (){var t = inst_14545;
var temp__5733__auto__ = inst_14626;
var p = inst_14543;
var idx_predicate_QMARK_ = inst_14546;
var vec__14538 = inst_14541;
var o = inst_14582;
var tag_predicate_QMARK_ = inst_14552;
var s = inst_14542;
var o_coerce_QMARK_ = inst_14557;
return (function (x){
return cljs.core._EQ_.call(null,x,o);
});
})();
var state_14682__$1 = state_14682;
var statearr_14704_14792 = state_14682__$1;
(statearr_14704_14792[(2)] = inst_14630);

(statearr_14704_14792[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (21))){
var inst_14578 = (state_14682[(2)]);
var state_14682__$1 = state_14682;
var statearr_14705_14793 = state_14682__$1;
(statearr_14705_14793[(2)] = inst_14578);

(statearr_14705_14793[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (31))){
var state_14682__$1 = state_14682;
var statearr_14706_14794 = state_14682__$1;
(statearr_14706_14794[(2)] = false);

(statearr_14706_14794[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (32))){
var inst_14603 = (state_14682[(2)]);
var state_14682__$1 = state_14682;
var statearr_14707_14795 = state_14682__$1;
(statearr_14707_14795[(2)] = inst_14603);

(statearr_14707_14795[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (40))){
var inst_14546 = (state_14682[(16)]);
var inst_14617 = cljs.core.not.call(null,inst_14546);
var state_14682__$1 = state_14682;
if(inst_14617){
var statearr_14708_14796 = state_14682__$1;
(statearr_14708_14796[(1)] = (43));

} else {
var statearr_14709_14797 = state_14682__$1;
(statearr_14709_14797[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (56))){
var inst_14648 = (state_14682[(2)]);
var inst_14649 = fluree.db.util.async.throw_err.call(null,inst_14648);
var state_14682__$1 = state_14682;
var statearr_14710_14798 = state_14682__$1;
(statearr_14710_14798[(2)] = inst_14649);

(statearr_14710_14798[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (33))){
var inst_14582 = (state_14682[(8)]);
var inst_14596 = cljs.core.fn_QMARK_.call(null,inst_14582);
var inst_14597 = (!(inst_14596));
var state_14682__$1 = state_14682;
var statearr_14711_14799 = state_14682__$1;
(statearr_14711_14799[(2)] = inst_14597);

(statearr_14711_14799[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (13))){
var inst_14544 = (state_14682[(11)]);
var inst_14561 = fluree.db.query.range.tag_string_QMARK_.call(null,inst_14544);
var state_14682__$1 = state_14682;
if(cljs.core.truth_(inst_14561)){
var statearr_14712_14800 = state_14682__$1;
(statearr_14712_14800[(1)] = (15));

} else {
var statearr_14713_14801 = state_14682__$1;
(statearr_14713_14801[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (22))){
var inst_14574 = (state_14682[(2)]);
var inst_14575 = fluree.db.util.async.throw_err.call(null,inst_14574);
var state_14682__$1 = state_14682;
var statearr_14714_14802 = state_14682__$1;
(statearr_14714_14802[(2)] = inst_14575);

(statearr_14714_14802[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (36))){
var inst_14545 = (state_14682[(12)]);
var inst_14542 = (state_14682[(14)]);
var inst_14543 = (state_14682[(9)]);
var inst_14582 = (state_14682[(8)]);
var inst_14608 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14609 = [inst_14543,inst_14582,inst_14542,inst_14545];
var inst_14610 = (new cljs.core.PersistentVector(null,4,(5),inst_14608,inst_14609,null));
var inst_14611 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_14610,opts);
var state_14682__$1 = state_14682;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14682__$1,(39),inst_14611);
} else {
if((state_val_14683 === (41))){
var inst_14543 = (state_14682[(9)]);
var state_14682__$1 = state_14682;
var statearr_14715_14803 = state_14682__$1;
(statearr_14715_14803[(2)] = inst_14543);

(statearr_14715_14803[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (43))){
var inst_14582 = (state_14682[(8)]);
var state_14682__$1 = state_14682;
var statearr_14716_14804 = state_14682__$1;
(statearr_14716_14804[(2)] = inst_14582);

(statearr_14716_14804[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (61))){
var inst_14669 = (state_14682[(7)]);
var inst_14671 = fluree.db.query.range.coerce_tag_flakes.call(null,db,inst_14669);
var state_14682__$1 = state_14682;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14682__$1,(64),inst_14671);
} else {
if((state_val_14683 === (29))){
var inst_14606 = (state_14682[(2)]);
var state_14682__$1 = state_14682;
if(cljs.core.truth_(inst_14606)){
var statearr_14717_14805 = state_14682__$1;
(statearr_14717_14805[(1)] = (36));

} else {
var statearr_14718_14806 = state_14682__$1;
(statearr_14718_14806[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (44))){
var state_14682__$1 = state_14682;
var statearr_14719_14807 = state_14682__$1;
(statearr_14719_14807[(2)] = false);

(statearr_14719_14807[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (6))){
var inst_14543 = (state_14682[(9)]);
var inst_14548 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"type","type",1174270348),inst_14543);
var inst_14549 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223),inst_14548);
var state_14682__$1 = state_14682;
var statearr_14720_14808 = state_14682__$1;
(statearr_14720_14808[(2)] = inst_14549);

(statearr_14720_14808[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (28))){
var inst_14543 = (state_14682[(9)]);
var state_14682__$1 = state_14682;
var statearr_14721_14809 = state_14682__$1;
(statearr_14721_14809[(2)] = inst_14543);

(statearr_14721_14809[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (64))){
var inst_14673 = (state_14682[(2)]);
var inst_14674 = fluree.db.util.async.throw_err.call(null,inst_14673);
var state_14682__$1 = state_14682;
var statearr_14722_14810 = state_14682__$1;
(statearr_14722_14810[(2)] = inst_14674);

(statearr_14722_14810[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (51))){
var inst_14545 = (state_14682[(12)]);
var inst_14542 = (state_14682[(14)]);
var inst_14543 = (state_14682[(9)]);
var inst_14632 = (state_14682[(2)]);
var inst_14633 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14634 = [inst_14543,inst_14542,null,inst_14545];
var inst_14635 = (new cljs.core.PersistentVector(null,4,(5),inst_14633,inst_14634,null));
var inst_14636 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),inst_14632);
var inst_14637 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_14635,inst_14636);
var state_14682__$1 = state_14682;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14682__$1,(52),inst_14637);
} else {
if((state_val_14683 === (25))){
var inst_14552 = (state_14682[(15)]);
var inst_14669 = (state_14682[(2)]);
var state_14682__$1 = (function (){var statearr_14723 = state_14682;
(statearr_14723[(7)] = inst_14669);

return statearr_14723;
})();
if(cljs.core.truth_(inst_14552)){
var statearr_14724_14811 = state_14682__$1;
(statearr_14724_14811[(1)] = (61));

} else {
var statearr_14725_14812 = state_14682__$1;
(statearr_14725_14812[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (34))){
var inst_14546 = (state_14682[(16)]);
var state_14682__$1 = state_14682;
var statearr_14726_14813 = state_14682__$1;
(statearr_14726_14813[(2)] = inst_14546);

(statearr_14726_14813[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (17))){
var inst_14580 = (state_14682[(2)]);
var state_14682__$1 = state_14682;
var statearr_14727_14814 = state_14682__$1;
(statearr_14727_14814[(2)] = inst_14580);

(statearr_14727_14814[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (3))){
var inst_14680 = (state_14682[(2)]);
var state_14682__$1 = state_14682;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14682__$1,inst_14680);
} else {
if((state_val_14683 === (12))){
var inst_14544 = (state_14682[(11)]);
var state_14682__$1 = state_14682;
var statearr_14728_14815 = state_14682__$1;
(statearr_14728_14815[(2)] = inst_14544);

(statearr_14728_14815[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (2))){
var inst_14543 = (state_14682[(9)]);
var inst_14541 = (state_14682[(17)]);
var _ = (function (){var statearr_14729 = state_14682;
(statearr_14729[(4)] = cljs.core.cons.call(null,(5),(state_14682[(4)])));

return statearr_14729;
})();
var inst_14541__$1 = fparts;
var inst_14542 = cljs.core.nth.call(null,inst_14541__$1,(0),null);
var inst_14543__$1 = cljs.core.nth.call(null,inst_14541__$1,(1),null);
var inst_14544 = cljs.core.nth.call(null,inst_14541__$1,(2),null);
var inst_14545 = cljs.core.nth.call(null,inst_14541__$1,(3),null);
var inst_14546 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),inst_14543__$1);
var state_14682__$1 = (function (){var statearr_14730 = state_14682;
(statearr_14730[(12)] = inst_14545);

(statearr_14730[(14)] = inst_14542);

(statearr_14730[(11)] = inst_14544);

(statearr_14730[(9)] = inst_14543__$1);

(statearr_14730[(16)] = inst_14546);

(statearr_14730[(17)] = inst_14541__$1);

return statearr_14730;
})();
if(cljs.core.truth_(inst_14543__$1)){
var statearr_14731_14816 = state_14682__$1;
(statearr_14731_14816[(1)] = (6));

} else {
var statearr_14732_14817 = state_14682__$1;
(statearr_14732_14817[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (23))){
var inst_14545 = (state_14682[(12)]);
var inst_14542 = (state_14682[(14)]);
var inst_14543 = (state_14682[(9)]);
var inst_14582 = (state_14682[(8)]);
var inst_14584 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14585 = [inst_14542,inst_14543,inst_14582,inst_14545];
var inst_14586 = (new cljs.core.PersistentVector(null,4,(5),inst_14584,inst_14585,null));
var inst_14587 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_14586,opts);
var state_14682__$1 = state_14682;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14682__$1,(26),inst_14587);
} else {
if((state_val_14683 === (47))){
var inst_14543 = (state_14682[(9)]);
var state_14682__$1 = state_14682;
if(cljs.core.truth_(inst_14543)){
var statearr_14733_14818 = state_14682__$1;
(statearr_14733_14818[(1)] = (53));

} else {
var statearr_14734_14819 = state_14682__$1;
(statearr_14734_14819[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (35))){
var inst_14600 = (state_14682[(2)]);
var state_14682__$1 = state_14682;
var statearr_14735_14820 = state_14682__$1;
(statearr_14735_14820[(2)] = inst_14600);

(statearr_14735_14820[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (19))){
var inst_14544 = (state_14682[(11)]);
var inst_14543 = (state_14682[(9)]);
var inst_14570 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_14543);
var inst_14571 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_14570),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_14544)].join('');
var inst_14572 = fluree.db.dbproto._tag_id.call(null,db,inst_14571);
var state_14682__$1 = state_14682;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14682__$1,(22),inst_14572);
} else {
if((state_val_14683 === (57))){
var inst_14545 = (state_14682[(12)]);
var inst_14542 = (state_14682[(14)]);
var inst_14543 = (state_14682[(9)]);
var inst_14582 = (state_14682[(8)]);
var inst_14652 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14653 = [inst_14582,inst_14543,inst_14542,inst_14545];
var inst_14654 = (new cljs.core.PersistentVector(null,4,(5),inst_14652,inst_14653,null));
var inst_14655 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_14654,opts);
var state_14682__$1 = state_14682;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14682__$1,(60),inst_14655);
} else {
if((state_val_14683 === (11))){
var inst_14557 = (state_14682[(13)]);
var inst_14557__$1 = (state_14682[(2)]);
var inst_14558 = cljs.core.not.call(null,inst_14557__$1);
var state_14682__$1 = (function (){var statearr_14737 = state_14682;
(statearr_14737[(13)] = inst_14557__$1);

return statearr_14737;
})();
if(inst_14558){
var statearr_14738_14821 = state_14682__$1;
(statearr_14738_14821[(1)] = (12));

} else {
var statearr_14739_14822 = state_14682__$1;
(statearr_14739_14822[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (9))){
var inst_14544 = (state_14682[(11)]);
var inst_14554 = typeof inst_14544 === 'string';
var state_14682__$1 = state_14682;
var statearr_14740_14823 = state_14682__$1;
(statearr_14740_14823[(2)] = inst_14554);

(statearr_14740_14823[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (5))){
var _ = (function (){var statearr_14741 = state_14682;
(statearr_14741[(4)] = cljs.core.rest.call(null,(state_14682[(4)])));

return statearr_14741;
})();
var state_14682__$1 = state_14682;
var ex14736 = (state_14682__$1[(2)]);
var statearr_14742_14824 = state_14682__$1;
(statearr_14742_14824[(5)] = ex14736);


if((ex14736 instanceof Error)){
var statearr_14743_14825 = state_14682__$1;
(statearr_14743_14825[(1)] = (4));

(statearr_14743_14825[(5)] = null);

} else {
throw ex14736;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (14))){
var inst_14542 = (state_14682[(14)]);
var inst_14582 = (state_14682[(2)]);
var state_14682__$1 = (function (){var statearr_14744 = state_14682;
(statearr_14744[(8)] = inst_14582);

return statearr_14744;
})();
if(cljs.core.truth_(inst_14542)){
var statearr_14745_14826 = state_14682__$1;
(statearr_14745_14826[(1)] = (23));

} else {
var statearr_14746_14827 = state_14682__$1;
(statearr_14746_14827[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (45))){
var inst_14621 = (state_14682[(2)]);
var state_14682__$1 = state_14682;
var statearr_14747_14828 = state_14682__$1;
(statearr_14747_14828[(2)] = inst_14621);

(statearr_14747_14828[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (53))){
var inst_14545 = (state_14682[(12)]);
var inst_14542 = (state_14682[(14)]);
var inst_14543 = (state_14682[(9)]);
var inst_14582 = (state_14682[(8)]);
var inst_14643 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14644 = [inst_14543,inst_14542,inst_14582,inst_14545];
var inst_14645 = (new cljs.core.PersistentVector(null,4,(5),inst_14643,inst_14644,null));
var inst_14646 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_14645,opts);
var state_14682__$1 = state_14682;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14682__$1,(56),inst_14646);
} else {
if((state_val_14683 === (26))){
var inst_14589 = (state_14682[(2)]);
var inst_14590 = fluree.db.util.async.throw_err.call(null,inst_14589);
var state_14682__$1 = state_14682;
var statearr_14748_14829 = state_14682__$1;
(statearr_14748_14829[(2)] = inst_14590);

(statearr_14748_14829[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (16))){
var inst_14544 = (state_14682[(11)]);
var inst_14568 = typeof inst_14544 === 'string';
var state_14682__$1 = state_14682;
if(cljs.core.truth_(inst_14568)){
var statearr_14749_14830 = state_14682__$1;
(statearr_14749_14830[(1)] = (19));

} else {
var statearr_14750_14831 = state_14682__$1;
(statearr_14750_14831[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (38))){
var inst_14667 = (state_14682[(2)]);
var state_14682__$1 = state_14682;
var statearr_14751_14832 = state_14682__$1;
(statearr_14751_14832[(2)] = inst_14667);

(statearr_14751_14832[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (30))){
var inst_14546 = (state_14682[(16)]);
var state_14682__$1 = state_14682;
if(cljs.core.truth_(inst_14546)){
var statearr_14752_14833 = state_14682__$1;
(statearr_14752_14833[(1)] = (33));

} else {
var statearr_14753_14834 = state_14682__$1;
(statearr_14753_14834[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (10))){
var inst_14552 = (state_14682[(15)]);
var state_14682__$1 = state_14682;
var statearr_14754_14835 = state_14682__$1;
(statearr_14754_14835[(2)] = inst_14552);

(statearr_14754_14835[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (18))){
var inst_14565 = (state_14682[(2)]);
var inst_14566 = fluree.db.util.async.throw_err.call(null,inst_14565);
var state_14682__$1 = state_14682;
var statearr_14755_14836 = state_14682__$1;
(statearr_14755_14836[(2)] = inst_14566);

(statearr_14755_14836[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (52))){
var inst_14639 = (state_14682[(2)]);
var inst_14640 = fluree.db.util.async.throw_err.call(null,inst_14639);
var state_14682__$1 = state_14682;
var statearr_14756_14837 = state_14682__$1;
(statearr_14756_14837[(2)] = inst_14640);

(statearr_14756_14837[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (42))){
var inst_14624 = (state_14682[(2)]);
var state_14682__$1 = state_14682;
if(cljs.core.truth_(inst_14624)){
var statearr_14757_14838 = state_14682__$1;
(statearr_14757_14838[(1)] = (46));

} else {
var statearr_14758_14839 = state_14682__$1;
(statearr_14758_14839[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (37))){
var inst_14543 = (state_14682[(9)]);
var state_14682__$1 = state_14682;
if(cljs.core.truth_(inst_14543)){
var statearr_14759_14840 = state_14682__$1;
(statearr_14759_14840[(1)] = (40));

} else {
var statearr_14760_14841 = state_14682__$1;
(statearr_14760_14841[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (63))){
var inst_14677 = (state_14682[(2)]);
var _ = (function (){var statearr_14761 = state_14682;
(statearr_14761[(4)] = cljs.core.rest.call(null,(state_14682[(4)])));

return statearr_14761;
})();
var state_14682__$1 = state_14682;
var statearr_14762_14842 = state_14682__$1;
(statearr_14762_14842[(2)] = inst_14677);

(statearr_14762_14842[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (8))){
var inst_14552 = (state_14682[(15)]);
var inst_14552__$1 = (state_14682[(2)]);
var state_14682__$1 = (function (){var statearr_14763 = state_14682;
(statearr_14763[(15)] = inst_14552__$1);

return statearr_14763;
})();
if(cljs.core.truth_(inst_14552__$1)){
var statearr_14764_14843 = state_14682__$1;
(statearr_14764_14843[(1)] = (9));

} else {
var statearr_14765_14844 = state_14682__$1;
(statearr_14765_14844[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14683 === (49))){
var inst_14545 = (state_14682[(12)]);
var inst_14626 = (state_14682[(10)]);
var inst_14557 = (state_14682[(13)]);
var inst_14542 = (state_14682[(14)]);
var inst_14552 = (state_14682[(15)]);
var inst_14543 = (state_14682[(9)]);
var inst_14546 = (state_14682[(16)]);
var inst_14582 = (state_14682[(8)]);
var inst_14541 = (state_14682[(17)]);
var inst_14628 = (function (){var obj_fn = inst_14626;
var t = inst_14545;
var temp__5733__auto__ = inst_14626;
var p = inst_14543;
var idx_predicate_QMARK_ = inst_14546;
var vec__14538 = inst_14541;
var o = inst_14582;
var tag_predicate_QMARK_ = inst_14552;
var s = inst_14542;
var o_coerce_QMARK_ = inst_14557;
return (function (x){
var and__4115__auto__ = obj_fn.call(null,x);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.call(null,x,o);
} else {
return and__4115__auto__;
}
});
})();
var state_14682__$1 = state_14682;
var statearr_14766_14845 = state_14682__$1;
(statearr_14766_14845[(2)] = inst_14628);

(statearr_14766_14845[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2468__auto__ = null;
var fluree$db$query$range$state_machine__2468__auto____0 = (function (){
var statearr_14767 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14767[(0)] = fluree$db$query$range$state_machine__2468__auto__);

(statearr_14767[(1)] = (1));

return statearr_14767;
});
var fluree$db$query$range$state_machine__2468__auto____1 = (function (state_14682){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_14682);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e14768){var ex__2471__auto__ = e14768;
var statearr_14769_14846 = state_14682;
(statearr_14769_14846[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_14682[(4)]))){
var statearr_14770_14847 = state_14682;
(statearr_14770_14847[(1)] = cljs.core.first.call(null,(state_14682[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14848 = state_14682;
state_14682 = G__14848;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2468__auto__ = function(state_14682){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2468__auto____1.call(this,state_14682);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2468__auto____0;
fluree$db$query$range$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2468__auto____1;
return fluree$db$query$range$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_14771 = f__2491__auto__.call(null);
(statearr_14771[(6)] = c__2490__auto__);

return statearr_14771;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__14850 = arguments.length;
switch (G__14850) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.call(null,db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_14885){
var state_val_14886 = (state_14885[(1)]);
if((state_val_14886 === (7))){
var inst_14872 = cljs.core.pr_str.call(null,name);
var inst_14873 = ["Invalid collection name: ",inst_14872].join('');
var inst_14874 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_14875 = [(400),new cljs.core.Keyword("db","invalid-collection","db/invalid-collection",1742380218)];
var inst_14876 = cljs.core.PersistentHashMap.fromArrays(inst_14874,inst_14875);
var inst_14877 = cljs.core.ex_info.call(null,inst_14873,inst_14876);
var inst_14878 = (function(){throw inst_14877})();
var state_14885__$1 = state_14885;
var statearr_14887_14907 = state_14885__$1;
(statearr_14887_14907[(2)] = inst_14878);

(statearr_14887_14907[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14886 === (1))){
var state_14885__$1 = state_14885;
var statearr_14888_14908 = state_14885__$1;
(statearr_14888_14908[(2)] = null);

(statearr_14888_14908[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14886 === (4))){
var inst_14851 = (state_14885[(2)]);
var state_14885__$1 = state_14885;
var statearr_14889_14909 = state_14885__$1;
(statearr_14889_14909[(2)] = inst_14851);

(statearr_14889_14909[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14886 === (6))){
var inst_14857 = (state_14885[(7)]);
var inst_14859 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14860 = fluree.db.flake.max_subject_id.call(null,inst_14857);
var inst_14861 = [inst_14860];
var inst_14862 = (new cljs.core.PersistentVector(null,1,(5),inst_14859,inst_14861,null));
var inst_14863 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14864 = fluree.db.flake.min_subject_id.call(null,inst_14857);
var inst_14865 = [inst_14864];
var inst_14866 = (new cljs.core.PersistentVector(null,1,(5),inst_14863,inst_14865,null));
var inst_14867 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_14862,cljs.core._LT__EQ_,inst_14866,opts);
var state_14885__$1 = state_14885;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14885__$1,(9),inst_14867);
} else {
if((state_val_14886 === (3))){
var inst_14883 = (state_14885[(2)]);
var state_14885__$1 = state_14885;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14885__$1,inst_14883);
} else {
if((state_val_14886 === (2))){
var inst_14857 = (state_14885[(7)]);
var _ = (function (){var statearr_14891 = state_14885;
(statearr_14891[(4)] = cljs.core.cons.call(null,(5),(state_14885[(4)])));

return statearr_14891;
})();
var inst_14857__$1 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),name);
var state_14885__$1 = (function (){var statearr_14892 = state_14885;
(statearr_14892[(7)] = inst_14857__$1);

return statearr_14892;
})();
if(cljs.core.truth_(inst_14857__$1)){
var statearr_14893_14910 = state_14885__$1;
(statearr_14893_14910[(1)] = (6));

} else {
var statearr_14894_14911 = state_14885__$1;
(statearr_14894_14911[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14886 === (9))){
var inst_14869 = (state_14885[(2)]);
var inst_14870 = fluree.db.util.async.throw_err.call(null,inst_14869);
var state_14885__$1 = state_14885;
var statearr_14895_14912 = state_14885__$1;
(statearr_14895_14912[(2)] = inst_14870);

(statearr_14895_14912[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14886 === (5))){
var _ = (function (){var statearr_14896 = state_14885;
(statearr_14896[(4)] = cljs.core.rest.call(null,(state_14885[(4)])));

return statearr_14896;
})();
var state_14885__$1 = state_14885;
var ex14890 = (state_14885__$1[(2)]);
var statearr_14897_14913 = state_14885__$1;
(statearr_14897_14913[(5)] = ex14890);


if((ex14890 instanceof java.lang.Exception)){
var statearr_14898_14914 = state_14885__$1;
(statearr_14898_14914[(1)] = (4));

(statearr_14898_14914[(5)] = null);

} else {
throw ex14890;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14886 === (8))){
var inst_14880 = (state_14885[(2)]);
var _ = (function (){var statearr_14899 = state_14885;
(statearr_14899[(4)] = cljs.core.rest.call(null,(state_14885[(4)])));

return statearr_14899;
})();
var state_14885__$1 = state_14885;
var statearr_14900_14915 = state_14885__$1;
(statearr_14900_14915[(2)] = inst_14880);

(statearr_14900_14915[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2468__auto__ = null;
var fluree$db$query$range$state_machine__2468__auto____0 = (function (){
var statearr_14901 = [null,null,null,null,null,null,null,null];
(statearr_14901[(0)] = fluree$db$query$range$state_machine__2468__auto__);

(statearr_14901[(1)] = (1));

return statearr_14901;
});
var fluree$db$query$range$state_machine__2468__auto____1 = (function (state_14885){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_14885);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e14902){var ex__2471__auto__ = e14902;
var statearr_14903_14916 = state_14885;
(statearr_14903_14916[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_14885[(4)]))){
var statearr_14904_14917 = state_14885;
(statearr_14904_14917[(1)] = cljs.core.first.call(null,(state_14885[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14918 = state_14885;
state_14885 = G__14918;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2468__auto__ = function(state_14885){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2468__auto____1.call(this,state_14885);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2468__auto____0;
fluree$db$query$range$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2468__auto____1;
return fluree$db$query$range$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_14905 = f__2491__auto__.call(null);
(statearr_14905[(6)] = c__2490__auto__);

return statearr_14905;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__14922 = flakes;
var vec__14923 = G__14922;
var seq__14924 = cljs.core.seq.call(null,vec__14923);
var first__14925 = cljs.core.first.call(null,seq__14924);
var seq__14924__$1 = cljs.core.next.call(null,seq__14924);
var flake_SINGLEQUOTE_ = first__14925;
var r = seq__14924__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__14922__$1 = G__14922;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__14932 = G__14922__$1;
var seq__14933 = cljs.core.seq.call(null,vec__14932);
var first__14934 = cljs.core.first.call(null,seq__14933);
var seq__14933__$1 = cljs.core.next.call(null,seq__14933);
var flake_SINGLEQUOTE___$1 = first__14934;
var r__$1 = seq__14933__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse.call(null,obj);
}catch (e14936){if((e14936 instanceof java.lang.Exception)){
var e = e14936;
return null;
} else {
throw e14936;

}
}})();
var map__14935 = cmd_map;
var map__14935__$1 = (((((!((map__14935 == null))))?(((((map__14935.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14935.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14935):map__14935);
var type = cljs.core.get.call(null,map__14935__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var db = cljs.core.get.call(null,map__14935__$1,new cljs.core.Keyword(null,"db","db",993250759));
var tx = cljs.core.get.call(null,map__14935__$1,new cljs.core.Keyword(null,"tx","tx",466630418));
var nonce = cljs.core.get.call(null,map__14935__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var auth = cljs.core.get.call(null,map__14935__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__14935__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var G__14938 = r__$1;
var G__14939 = ((cljs.core._EQ_.call(null,type,"tx"))?cljs.core.conj.call(null,result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"tx","tx",466630418),tx,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"expire","expire",-70657108),expire], null)):result_STAR___$2);
G__14922__$1 = G__14938;
result_STAR___$1 = G__14939;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__14948 = blocks;
var vec__14949 = G__14948;
var seq__14950 = cljs.core.seq.call(null,vec__14949);
var first__14951 = cljs.core.first.call(null,seq__14950);
var seq__14950__$1 = cljs.core.next.call(null,seq__14950);
var block_SINGLEQUOTE_ = first__14951;
var r = seq__14950__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__14948__$1 = G__14948;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__14957 = G__14948__$1;
var seq__14958 = cljs.core.seq.call(null,vec__14957);
var first__14959 = cljs.core.first.call(null,seq__14958);
var seq__14958__$1 = cljs.core.next.call(null,seq__14958);
var block_SINGLEQUOTE___$1 = first__14959;
var r__$1 = seq__14958__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__14960 = block_SINGLEQUOTE___$1;
var map__14960__$1 = (((((!((map__14960 == null))))?(((((map__14960.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14960.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14960):map__14960);
var block = cljs.core.get.call(null,map__14960__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__14960__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.call(null,map__14960__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var prev_hash = cljs.core.some.call(null,((function (G__14948__$1,result_STAR___$1,map__14960,map__14960__$1,block,t,flakes,vec__14957,seq__14958,first__14959,seq__14958__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__14948,vec__14949,seq__14950,first__14951,seq__14950__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__14940_SHARP_){
if(cljs.core._EQ_.call(null,p1__14940_SHARP_.p,(2))){
return p1__14940_SHARP_.o;
} else {
return null;
}
});})(G__14948__$1,result_STAR___$1,map__14960,map__14960__$1,block,t,flakes,vec__14957,seq__14958,first__14959,seq__14958__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__14948,vec__14949,seq__14950,first__14951,seq__14950__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some.call(null,((function (G__14948__$1,result_STAR___$1,map__14960,map__14960__$1,block,t,flakes,prev_hash,vec__14957,seq__14958,first__14959,seq__14958__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__14948,vec__14949,seq__14950,first__14951,seq__14950__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__14941_SHARP_){
if(cljs.core._EQ_.call(null,p1__14941_SHARP_.p,(1))){
return p1__14941_SHARP_.o;
} else {
return null;
}
});})(G__14948__$1,result_STAR___$1,map__14960,map__14960__$1,block,t,flakes,prev_hash,vec__14957,seq__14958,first__14959,seq__14958__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__14948,vec__14949,seq__14950,first__14951,seq__14950__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some.call(null,((function (G__14948__$1,result_STAR___$1,map__14960,map__14960__$1,block,t,flakes,prev_hash,hash,vec__14957,seq__14958,first__14959,seq__14958__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__14948,vec__14949,seq__14950,first__14951,seq__14950__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__14942_SHARP_){
if(cljs.core._EQ_.call(null,p1__14942_SHARP_.p,(5))){
return p1__14942_SHARP_.o;
} else {
return null;
}
});})(G__14948__$1,result_STAR___$1,map__14960,map__14960__$1,block,t,flakes,prev_hash,hash,vec__14957,seq__14958,first__14959,seq__14958__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__14948,vec__14949,seq__14950,first__14951,seq__14950__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some.call(null,((function (G__14948__$1,result_STAR___$1,map__14960,map__14960__$1,block,t,flakes,prev_hash,hash,instant,vec__14957,seq__14958,first__14959,seq__14958__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__14948,vec__14949,seq__14950,first__14951,seq__14950__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__14943_SHARP_){
if(cljs.core._EQ_.call(null,p1__14943_SHARP_.p,(7))){
return p1__14943_SHARP_.o;
} else {
return null;
}
});})(G__14948__$1,result_STAR___$1,map__14960,map__14960__$1,block,t,flakes,prev_hash,hash,instant,vec__14957,seq__14958,first__14959,seq__14958__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__14948,vec__14949,seq__14950,first__14951,seq__14950__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.call(null,((function (G__14948__$1,result_STAR___$1,map__14960,map__14960__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__14957,seq__14958,first__14959,seq__14958__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__14948,vec__14949,seq__14950,first__14951,seq__14950__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__14944_SHARP_){
return cljs.core._EQ_.call(null,p1__14944_SHARP_.p,(106));
});})(G__14948__$1,result_STAR___$1,map__14960,map__14960__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__14957,seq__14958,first__14959,seq__14958__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__14948,vec__14949,seq__14950,first__14951,seq__14950__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes.call(null,txn_flakes);
var G__14962 = r__$1;
var G__14963 = cljs.core.conj.call(null,result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"prev-hash","prev-hash",209337330),prev_hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"sigs","sigs",-1653119622),sigs,new cljs.core.Keyword(null,"flakes","flakes",1977895739),flakes,new cljs.core.Keyword(null,"txn","txn",-469204789),txn_flakes_SINGLEQUOTE_], null));
G__14948__$1 = G__14962;
result_STAR___$1 = G__14963;
continue;
}
break;
}
});

//# sourceMappingURL=range.js.map
