// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"?")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"#")) && (cljs.core._EQ_.call(null,cljs.core.second.call(null,cljs.core.name.call(null,form)),"(")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"\"")) && (cljs.core._EQ_.call(null,cljs.core.last.call(null,cljs.core.name.call(null,form)),"\"")));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.call(null,string);
}catch (e19326){var e = e19326;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some.call(null,(function (p1__19327_SHARP_){
var or__4126__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,p1__19327_SHARP_);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.coll_QMARK_.call(null,p1__19327_SHARP_)){
return fluree.db.query.analytical.get_vars.call(null,p1__19327_SHARP_);
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv.call(null,(function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_.call(null,key);
var static_value = cljs.core.get.call(null,interm_vars,key_as_var);
if(((cljs.core._EQ_.call(null,idx,(1))) && (cljs.core.not.call(null,key_as_var)) && (cljs.core.not.call(null,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.re_find.call(null,/[_a-zA-Z0-9\/]*/,key)))))){
throw cljs.core.ex_info.call(null,["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__19328_SHARP_){
return cljs.core.conj.call(null,p1__19328_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__19329_SHARP_){
return cljs.core.conj.call(null,p1__19329_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = fluree.db.query.analytical.internal_filter_QMARK_.call(null,key);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.call(null,idx,(2));
} else {
return and__4115__auto__;
}
})())){
var filter_code = cljs.reader.read_string.call(null,cljs.core.subs.call(null,key,(1)));
var var$ = (function (){var or__4126__auto__ = fluree.db.query.analytical.get_vars.call(null,filter_code);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.call(null,["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__19334 = fluree.db.query.analytical_filter.valid_filter_QMARK_.call(null,filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.call(null,vec__19334,(0),null);
var _ = cljs.core.nth.call(null,vec__19334,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn.call(null,var$,fun);
return cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__19330_SHARP_){
return cljs.core.conj.call(null,p1__19330_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),var$], null),idx);
} else {
if(cljs.core.truth_(((cljs.core._EQ_.call(null,idx,(1)))?cljs.core.re_find.call(null,/\+/,key):false))){
var vec__19337 = clojure.string.split.call(null,key,/\+/);
var pred = cljs.core.nth.call(null,vec__19337,(0),null);
var recur_amt = cljs.core.nth.call(null,vec__19337,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__4126__auto__ = fluree.db.query.analytical.safe_read_string.call(null,recur_amt);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__19331_SHARP_){
return cljs.core.conj.call(null,p1__19331_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"recur","recur",-437573268)], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_.call(null,key)){
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__19332_SHARP_){
return cljs.core.conj.call(null,p1__19332_SHARP_,fluree.db.query.analytical.safe_read_string.call(null,key));
}));
} else {
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__19333_SHARP_){
return cljs.core.conj.call(null,p1__19333_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"search","search",1564939822),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"rel","rel",1378823488),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.call(null,(function (array){
return cljs.core.map.call(null,(function (p1__19340_SHARP_){
return cljs.core.nth.call(null,array,p1__19340_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.call(null,(function (acc,var$){
var temp__5733__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,var$);
if(cljs.core.truth_(temp__5733__auto__)){
var var$__$1 = temp__5733__auto__;
return cljs.core.conj.call(null,acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys.call(null,clause);
return cljs.core.reduce.call(null,(function (acc,key){
if(cljs.core.truth_(rel_keys.call(null,key))){
return cljs.core.conj.call(null,acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.call(null,(function (acc,key){
if(cljs.core.truth_(a_keys.call(null,key))){
return cljs.core.conj.call(null,acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.call(null,(function (acc,var_smt){
var temp__5733__auto__ = (function (){var or__4126__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,var_smt);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var var$ = temp__5733__auto__;
return cljs.core.conj.call(null,acc,fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays.call(null,ns,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (add_amount > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = fuel;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.volatile_QMARK_.call(null,fuel);
} else {
return and__4115__auto__;
}
})())){
return cljs.core._vreset_BANG_.call(null,fuel,(cljs.core._deref.call(null,fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.call(null,(function (clause){
return cljs.core.mapv.call(null,(function (clause_item){
var temp__5733__auto__ = intersecting_vars.call(null,cljs.core.symbol.call(null,clause_item));
if(cljs.core.truth_(temp__5733__auto__)){
var key_replace = temp__5733__auto__;
var replacement = cljs.core.get.call(null,vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.call(null,replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__19343,optional_QMARK_,fuel,max_fuel){
var map__19344 = p__19343;
var map__19344__$1 = (((((!((map__19344 == null))))?(((((map__19344.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19344.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19344):map__19344);
var res = map__19344__$1;
var vars = cljs.core.get.call(null,map__19344__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_19411){
var state_val_19412 = (state_19411[(1)]);
if((state_val_19412 === (7))){
var inst_19400 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19401 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses.call(null,r);
var inst_19402 = cljs.core.conj.call(null,inst_19401,clause);
var inst_19403 = [null,inst_19402];
var inst_19404 = (new cljs.core.PersistentVector(null,2,(5),inst_19400,inst_19403,null));
var state_19411__$1 = state_19411;
var statearr_19413_19441 = state_19411__$1;
(statearr_19413_19441[(2)] = inst_19404);

(statearr_19413_19441[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19412 === (1))){
var state_19411__$1 = state_19411;
var statearr_19414_19442 = state_19411__$1;
(statearr_19414_19442[(2)] = null);

(statearr_19414_19442[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19412 === (4))){
var inst_19346 = (state_19411[(2)]);
var state_19411__$1 = state_19411;
var statearr_19415_19443 = state_19411__$1;
(statearr_19415_19443[(2)] = inst_19346);

(statearr_19415_19443[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19412 === (15))){
var inst_19389 = (state_19411[(2)]);
var inst_19390 = fluree.db.util.async.throw_err.call(null,inst_19389);
var inst_19391 = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(inst_19390);
var inst_19392 = cljs.core.count.call(null,inst_19391);
var inst_19393 = fluree.db.query.analytical.add_fuel.call(null,inst_19392,fuel,max_fuel);
var inst_19394 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19395 = [inst_19390,r];
var inst_19396 = (new cljs.core.PersistentVector(null,2,(5),inst_19394,inst_19395,null));
var state_19411__$1 = (function (){var statearr_19416 = state_19411;
(statearr_19416[(7)] = inst_19393);

return statearr_19416;
})();
var statearr_19417_19444 = state_19411__$1;
(statearr_19417_19444[(2)] = inst_19396);

(statearr_19417_19444[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19412 === (13))){
var inst_19355 = (state_19411[(8)]);
var inst_19368 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_19369 = fluree.db.query.analytical_wikidata.get_all_wd_clauses.call(null,inst_19368);
var inst_19370 = cljs.core.map.call(null,fluree.db.query.analytical.clause__GT_keys,inst_19355);
var inst_19371 = cljs.core.apply.call(null,cljs.core.concat,inst_19370);
var inst_19372 = cljs.core.set.call(null,inst_19371);
var inst_19373 = cljs.core.map.call(null,fluree.db.query.analytical.clause__GT_keys,inst_19369);
var inst_19374 = cljs.core.apply.call(null,cljs.core.concat,inst_19373);
var inst_19375 = cljs.core.into.call(null,inst_19372,inst_19374);
var inst_19376 = (function (){var all_wd = inst_19355;
var optional = inst_19369;
var all_wd_vars = inst_19372;
var all_vars = inst_19375;
return (function (p1__19341_SHARP_){
return all_vars.call(null,p1__19341_SHARP_);
});
})();
var inst_19377 = cljs.core.keys.call(null,vars);
var inst_19378 = cljs.core.map.call(null,inst_19376,inst_19377);
var inst_19379 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_19378);
var inst_19380 = cljs.core.set.call(null,inst_19379);
var inst_19381 = (function (){var all_wd = inst_19355;
var optional = inst_19369;
var all_wd_vars = inst_19372;
var all_vars = inst_19375;
var intersecting_vars = inst_19380;
return (function (p1__19342_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause.call(null,res,p1__19342_SHARP_);
});
})();
var inst_19382 = cljs.core.map.call(null,inst_19381,inst_19355);
var inst_19383 = cljs.core.apply.call(null,cljs.core.concat,inst_19382);
var inst_19384 = fluree.db.query.analytical.select_from_tuples.call(null,inst_19383,res);
var inst_19385 = fluree.db.query.analytical.replace_vars_wikidata.call(null,inst_19355,inst_19380,vars);
var inst_19386 = cljs.core.remove.call(null,inst_19380,inst_19375);
var inst_19387 = fluree.db.query.analytical_wikidata.get_wikidata_tuples.call(null,q_map,inst_19385,inst_19383,inst_19384,inst_19386,inst_19369);
var state_19411__$1 = state_19411;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19411__$1,(15),inst_19387);
} else {
if((state_val_19412 === (6))){
var inst_19356 = (state_19411[(9)]);
var inst_19354 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_19355 = fluree.db.query.analytical_wikidata.get_all_wd_clauses.call(null,inst_19354);
var inst_19356__$1 = optional_QMARK_;
var state_19411__$1 = (function (){var statearr_19418 = state_19411;
(statearr_19418[(8)] = inst_19355);

(statearr_19418[(9)] = inst_19356__$1);

return statearr_19418;
})();
if(cljs.core.truth_(inst_19356__$1)){
var statearr_19419_19445 = state_19411__$1;
(statearr_19419_19445[(1)] = (9));

} else {
var statearr_19420_19446 = state_19411__$1;
(statearr_19420_19446[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19412 === (3))){
var inst_19409 = (state_19411[(2)]);
var state_19411__$1 = state_19411;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19411__$1,inst_19409);
} else {
if((state_val_19412 === (12))){
var inst_19364 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19365 = [null,r];
var inst_19366 = (new cljs.core.PersistentVector(null,2,(5),inst_19364,inst_19365,null));
var state_19411__$1 = state_19411;
var statearr_19421_19447 = state_19411__$1;
(statearr_19421_19447[(2)] = inst_19366);

(statearr_19421_19447[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19412 === (2))){
var _ = (function (){var statearr_19422 = state_19411;
(statearr_19422[(4)] = cljs.core.cons.call(null,(5),(state_19411[(4)])));

return statearr_19422;
})();
var inst_19352 = (r == null);
var state_19411__$1 = state_19411;
if(cljs.core.truth_(inst_19352)){
var statearr_19423_19448 = state_19411__$1;
(statearr_19423_19448[(1)] = (6));

} else {
var statearr_19424_19449 = state_19411__$1;
(statearr_19424_19449[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19412 === (11))){
var inst_19362 = (state_19411[(2)]);
var state_19411__$1 = state_19411;
if(cljs.core.truth_(inst_19362)){
var statearr_19426_19450 = state_19411__$1;
(statearr_19426_19450[(1)] = (12));

} else {
var statearr_19427_19451 = state_19411__$1;
(statearr_19427_19451[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19412 === (9))){
var inst_19355 = (state_19411[(8)]);
var inst_19358 = cljs.core.empty_QMARK_.call(null,inst_19355);
var inst_19359 = (!(inst_19358));
var state_19411__$1 = state_19411;
var statearr_19428_19452 = state_19411__$1;
(statearr_19428_19452[(2)] = inst_19359);

(statearr_19428_19452[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19412 === (5))){
var _ = (function (){var statearr_19429 = state_19411;
(statearr_19429[(4)] = cljs.core.rest.call(null,(state_19411[(4)])));

return statearr_19429;
})();
var state_19411__$1 = state_19411;
var ex19425 = (state_19411__$1[(2)]);
var statearr_19430_19453 = state_19411__$1;
(statearr_19430_19453[(5)] = ex19425);


if((ex19425 instanceof Error)){
var statearr_19431_19454 = state_19411__$1;
(statearr_19431_19454[(1)] = (4));

(statearr_19431_19454[(5)] = null);

} else {
throw ex19425;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19412 === (14))){
var inst_19398 = (state_19411[(2)]);
var state_19411__$1 = state_19411;
var statearr_19432_19455 = state_19411__$1;
(statearr_19432_19455[(2)] = inst_19398);

(statearr_19432_19455[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19412 === (10))){
var inst_19356 = (state_19411[(9)]);
var state_19411__$1 = state_19411;
var statearr_19433_19456 = state_19411__$1;
(statearr_19433_19456[(2)] = inst_19356);

(statearr_19433_19456[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19412 === (8))){
var inst_19406 = (state_19411[(2)]);
var _ = (function (){var statearr_19434 = state_19411;
(statearr_19434[(4)] = cljs.core.rest.call(null,(state_19411[(4)])));

return statearr_19434;
})();
var state_19411__$1 = state_19411;
var statearr_19435_19457 = state_19411__$1;
(statearr_19435_19457[(2)] = inst_19406);

(statearr_19435_19457[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2468__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2468__auto____0 = (function (){
var statearr_19436 = [null,null,null,null,null,null,null,null,null,null];
(statearr_19436[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2468__auto__);

(statearr_19436[(1)] = (1));

return statearr_19436;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2468__auto____1 = (function (state_19411){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_19411);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e19437){var ex__2471__auto__ = e19437;
var statearr_19438_19458 = state_19411;
(statearr_19438_19458[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_19411[(4)]))){
var statearr_19439_19459 = state_19411;
(statearr_19439_19459[(1)] = cljs.core.first.call(null,(state_19411[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19460 = state_19411;
state_19411 = G__19460;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2468__auto__ = function(state_19411){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2468__auto____1.call(this,state_19411);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2468__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2468__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_19440 = f__2491__auto__.call(null);
(statearr_19440[(6)] = c__2490__auto__);

return statearr_19440;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string.call(null,block);
if(cljs.core.int_QMARK_.call(null,block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find.call(null,/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find.call(null,/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__19462 = arguments.length;
switch (G__19462) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.call(null,db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_19556){
var state_val_19557 = (state_19556[(1)]);
if((state_val_19557 === (7))){
var inst_19469 = (state_19556[(7)]);
var inst_19479 = clojure.string.starts_with_QMARK_.call(null,inst_19469,"$fdb");
var state_19556__$1 = state_19556;
if(inst_19479){
var statearr_19558_19607 = state_19556__$1;
(statearr_19558_19607[(1)] = (9));

} else {
var statearr_19559_19608 = state_19556__$1;
(statearr_19559_19608[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (20))){
var state_19556__$1 = state_19556;
var statearr_19560_19609 = state_19556__$1;
(statearr_19560_19609[(2)] = null);

(statearr_19560_19609[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (27))){
var inst_19519 = (state_19556[(8)]);
var state_19556__$1 = state_19556;
var statearr_19561_19610 = state_19556__$1;
(statearr_19561_19610[(2)] = inst_19519);

(statearr_19561_19610[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (1))){
var state_19556__$1 = state_19556;
var statearr_19562_19611 = state_19556__$1;
(statearr_19562_19611[(2)] = null);

(statearr_19562_19611[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (24))){
var inst_19542 = (state_19556[(2)]);
var state_19556__$1 = state_19556;
var statearr_19563_19612 = state_19556__$1;
(statearr_19563_19612[(2)] = inst_19542);

(statearr_19563_19612[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (4))){
var inst_19463 = (state_19556[(2)]);
var state_19556__$1 = state_19556;
var statearr_19564_19613 = state_19556__$1;
(statearr_19564_19613[(2)] = inst_19463);

(statearr_19564_19613[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (15))){
var inst_19486 = (state_19556[(9)]);
var inst_19492 = (state_19556[(2)]);
var inst_19493 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19494 = cljs.core.PersistentVector.EMPTY;
var inst_19495 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_19496 = cljs.core.into.call(null,inst_19494,inst_19495);
var inst_19497 = [inst_19486,inst_19496];
var inst_19498 = (new cljs.core.PersistentVector(null,2,(5),inst_19493,inst_19497,null));
var state_19556__$1 = (function (){var statearr_19565 = state_19556;
(statearr_19565[(10)] = inst_19492);

return statearr_19565;
})();
var statearr_19566_19614 = state_19556__$1;
(statearr_19566_19614[(2)] = inst_19498);

(statearr_19566_19614[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (21))){
var inst_19545 = (state_19556[(2)]);
var state_19556__$1 = state_19556;
var statearr_19567_19615 = state_19556__$1;
(statearr_19567_19615[(2)] = inst_19545);

(statearr_19567_19615[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (13))){
var inst_19486 = (state_19556[(9)]);
var inst_19489 = (function(){throw inst_19486})();
var state_19556__$1 = state_19556;
var statearr_19568_19616 = state_19556__$1;
(statearr_19568_19616[(2)] = inst_19489);

(statearr_19568_19616[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (22))){
var inst_19510 = (state_19556[(11)]);
var inst_19508 = (state_19556[(12)]);
var inst_19512 = fluree.db.query.analytical.parse_block_from_source.call(null,inst_19508);
var inst_19513 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19514 = [new cljs.core.Keyword(null,"sources","sources",-321166424),inst_19510];
var inst_19515 = (new cljs.core.PersistentVector(null,2,(5),inst_19513,inst_19514,null));
var inst_19516 = cljs.core.get_in.call(null,opts,inst_19515);
var state_19556__$1 = (function (){var statearr_19569 = state_19556;
(statearr_19569[(13)] = inst_19512);

return statearr_19569;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19556__$1,(25),inst_19516);
} else {
if((state_val_19557 === (29))){
var inst_19523 = (state_19556[(2)]);
var inst_19524 = fluree.db.util.async.throw_err.call(null,inst_19523);
var state_19556__$1 = state_19556;
var statearr_19570_19617 = state_19556__$1;
(statearr_19570_19617[(2)] = inst_19524);

(statearr_19570_19617[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (6))){
var inst_19472 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19473 = cljs.core.PersistentVector.EMPTY;
var inst_19474 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_19475 = cljs.core.into.call(null,inst_19473,inst_19474);
var inst_19476 = [db,inst_19475];
var inst_19477 = (new cljs.core.PersistentVector(null,2,(5),inst_19472,inst_19476,null));
var state_19556__$1 = state_19556;
var statearr_19571_19618 = state_19556__$1;
(statearr_19571_19618[(2)] = inst_19477);

(statearr_19571_19618[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (28))){
var inst_19527 = (state_19556[(2)]);
var inst_19528 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19529 = cljs.core.PersistentVector.EMPTY;
var inst_19530 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_19531 = cljs.core.into.call(null,inst_19529,inst_19530);
var inst_19532 = [inst_19527,inst_19531];
var inst_19533 = (new cljs.core.PersistentVector(null,2,(5),inst_19528,inst_19532,null));
var state_19556__$1 = state_19556;
var statearr_19572_19619 = state_19556__$1;
(statearr_19572_19619[(2)] = inst_19533);

(statearr_19572_19619[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (25))){
var inst_19512 = (state_19556[(13)]);
var inst_19518 = (state_19556[(2)]);
var inst_19519 = fluree.db.util.async.throw_err.call(null,inst_19518);
var state_19556__$1 = (function (){var statearr_19573 = state_19556;
(statearr_19573[(8)] = inst_19519);

return statearr_19573;
})();
if(cljs.core.truth_(inst_19512)){
var statearr_19574_19620 = state_19556__$1;
(statearr_19574_19620[(1)] = (26));

} else {
var statearr_19575_19621 = state_19556__$1;
(statearr_19575_19621[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (17))){
var state_19556__$1 = state_19556;
var statearr_19576_19622 = state_19556__$1;
(statearr_19576_19622[(1)] = (19));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (3))){
var inst_19554 = (state_19556[(2)]);
var state_19556__$1 = state_19556;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19556__$1,inst_19554);
} else {
if((state_val_19557 === (12))){
var inst_19486 = (state_19556[(9)]);
var inst_19485 = (state_19556[(2)]);
var inst_19486__$1 = fluree.db.util.async.throw_err.call(null,inst_19485);
var inst_19487 = fluree.db.util.core.exception_QMARK_.call(null,inst_19486__$1);
var state_19556__$1 = (function (){var statearr_19578 = state_19556;
(statearr_19578[(9)] = inst_19486__$1);

return statearr_19578;
})();
if(inst_19487){
var statearr_19579_19623 = state_19556__$1;
(statearr_19579_19623[(1)] = (13));

} else {
var statearr_19580_19624 = state_19556__$1;
(statearr_19580_19624[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (2))){
var inst_19469 = (state_19556[(7)]);
var _ = (function (){var statearr_19581 = state_19556;
(statearr_19581[(4)] = cljs.core.cons.call(null,(5),(state_19556[(4)])));

return statearr_19581;
})();
var inst_19469__$1 = cljs.core.first.call(null,clause);
var inst_19470 = cljs.core._EQ_.call(null,"$fdb",inst_19469__$1);
var state_19556__$1 = (function (){var statearr_19582 = state_19556;
(statearr_19582[(7)] = inst_19469__$1);

return statearr_19582;
})();
if(inst_19470){
var statearr_19583_19625 = state_19556__$1;
(statearr_19583_19625[(1)] = (6));

} else {
var statearr_19584_19626 = state_19556__$1;
(statearr_19584_19626[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (23))){
var inst_19469 = (state_19556[(7)]);
var inst_19535 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_19469)," is not supported in Fluree"].join('');
var inst_19536 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19537 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_19538 = cljs.core.PersistentHashMap.fromArrays(inst_19536,inst_19537);
var inst_19539 = cljs.core.ex_info.call(null,inst_19535,inst_19538);
var inst_19540 = (function(){throw inst_19539})();
var state_19556__$1 = state_19556;
var statearr_19585_19627 = state_19556__$1;
(statearr_19585_19627[(2)] = inst_19540);

(statearr_19585_19627[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (19))){
var inst_19510 = (state_19556[(11)]);
var inst_19469 = (state_19556[(7)]);
var inst_19507 = fluree.db.query.analytical.isolate_source_name.call(null,inst_19469);
var inst_19508 = fluree.db.query.analytical.isolate_source_block.call(null,inst_19469);
var inst_19509 = cljs.core.keyword.call(null,inst_19507);
var inst_19510__$1 = cljs.core.get.call(null,prefixes,inst_19509);
var state_19556__$1 = (function (){var statearr_19586 = state_19556;
(statearr_19586[(11)] = inst_19510__$1);

(statearr_19586[(12)] = inst_19508);

return statearr_19586;
})();
if(cljs.core.truth_(inst_19510__$1)){
var statearr_19587_19628 = state_19556__$1;
(statearr_19587_19628[(1)] = (22));

} else {
var statearr_19588_19629 = state_19556__$1;
(statearr_19588_19629[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (11))){
var inst_19549 = (state_19556[(2)]);
var state_19556__$1 = state_19556;
var statearr_19590_19630 = state_19556__$1;
(statearr_19590_19630[(2)] = inst_19549);

(statearr_19590_19630[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (9))){
var inst_19469 = (state_19556[(7)]);
var inst_19481 = cljs.core.subs.call(null,inst_19469,(4));
var inst_19482 = fluree.db.query.analytical.parse_block_from_source.call(null,inst_19481);
var inst_19483 = fluree.db.time_travel.as_of_block.call(null,db,inst_19482);
var state_19556__$1 = state_19556;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19556__$1,(12),inst_19483);
} else {
if((state_val_19557 === (5))){
var _ = (function (){var statearr_19591 = state_19556;
(statearr_19591[(4)] = cljs.core.rest.call(null,(state_19556[(4)])));

return statearr_19591;
})();
var state_19556__$1 = state_19556;
var ex19589 = (state_19556__$1[(2)]);
var statearr_19592_19631 = state_19556__$1;
(statearr_19592_19631[(5)] = ex19589);


if((ex19589 instanceof Error)){
var statearr_19593_19632 = state_19556__$1;
(statearr_19593_19632[(1)] = (4));

(statearr_19593_19632[(5)] = null);

} else {
throw ex19589;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (14))){
var state_19556__$1 = state_19556;
var statearr_19594_19633 = state_19556__$1;
(statearr_19594_19633[(2)] = null);

(statearr_19594_19633[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (26))){
var inst_19519 = (state_19556[(8)]);
var inst_19512 = (state_19556[(13)]);
var inst_19521 = fluree.db.time_travel.as_of_block.call(null,inst_19519,inst_19512);
var state_19556__$1 = state_19556;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19556__$1,(29),inst_19521);
} else {
if((state_val_19557 === (16))){
var inst_19502 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19503 = ["$wd",clause];
var inst_19504 = (new cljs.core.PersistentVector(null,2,(5),inst_19502,inst_19503,null));
var state_19556__$1 = state_19556;
var statearr_19595_19634 = state_19556__$1;
(statearr_19595_19634[(2)] = inst_19504);

(statearr_19595_19634[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (10))){
var inst_19469 = (state_19556[(7)]);
var inst_19500 = cljs.core._EQ_.call(null,"$wd",inst_19469);
var state_19556__$1 = state_19556;
if(inst_19500){
var statearr_19596_19635 = state_19556__$1;
(statearr_19596_19635[(1)] = (16));

} else {
var statearr_19597_19636 = state_19556__$1;
(statearr_19597_19636[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (18))){
var inst_19547 = (state_19556[(2)]);
var state_19556__$1 = state_19556;
var statearr_19598_19637 = state_19556__$1;
(statearr_19598_19637[(2)] = inst_19547);

(statearr_19598_19637[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (8))){
var inst_19551 = (state_19556[(2)]);
var _ = (function (){var statearr_19599 = state_19556;
(statearr_19599[(4)] = cljs.core.rest.call(null,(state_19556[(4)])));

return statearr_19599;
})();
var state_19556__$1 = state_19556;
var statearr_19600_19638 = state_19556__$1;
(statearr_19600_19638[(2)] = inst_19551);

(statearr_19600_19638[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2468__auto__ = null;
var fluree$db$query$analytical$state_machine__2468__auto____0 = (function (){
var statearr_19601 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19601[(0)] = fluree$db$query$analytical$state_machine__2468__auto__);

(statearr_19601[(1)] = (1));

return statearr_19601;
});
var fluree$db$query$analytical$state_machine__2468__auto____1 = (function (state_19556){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_19556);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e19602){var ex__2471__auto__ = e19602;
var statearr_19603_19639 = state_19556;
(statearr_19603_19639[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_19556[(4)]))){
var statearr_19604_19640 = state_19556;
(statearr_19604_19640[(1)] = cljs.core.first.call(null,(state_19556[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19641 = state_19556;
state_19556 = G__19641;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2468__auto__ = function(state_19556){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2468__auto____1.call(this,state_19556);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2468__auto____0;
fluree$db$query$analytical$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2468__auto____1;
return fluree$db$query$analytical$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_19605 = f__2491__auto__.call(null);
(statearr_19605[(6)] = c__2490__auto__);

return statearr_19605;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.call(null,(function (acc,p__19642){
var vec__19643 = p__19642;
var sub = cljs.core.nth.call(null,vec__19643,(0),null);
var obj = cljs.core.nth.call(null,vec__19643,(1),null);
return cljs.core.update.call(null,acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap.call(null,cljs.core.keys.call(null,tuple_map),cljs.core.map.call(null,(function (p1__19646_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"done","done",-889844188),new cljs.core.Keyword(null,"followed","followed",821961472),new cljs.core.Keyword(null,"all","all",892129742)],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set.call(null,p1__19646_SHARP_)]);
}),cljs.core.vals.call(null,tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map.call(null,tuple_map);
var G__19650 = subjects;
var vec__19651 = G__19650;
var seq__19652 = cljs.core.seq.call(null,vec__19651);
var first__19653 = cljs.core.first.call(null,seq__19652);
var seq__19652__$1 = cljs.core.next.call(null,seq__19652);
var subject = first__19653;
var r = seq__19652__$1;
var acc = expanded_map;
var G__19650__$1 = G__19650;
var acc__$1 = acc;
while(true){
var vec__19657 = G__19650__$1;
var seq__19658 = cljs.core.seq.call(null,vec__19657);
var first__19659 = cljs.core.first.call(null,seq__19658);
var seq__19658__$1 = cljs.core.next.call(null,seq__19658);
var subject__$1 = first__19659;
var r__$1 = seq__19658__$1;
var acc__$2 = acc__$1;
if(cljs.core.not.call(null,subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
var G__19660 = r__$1;
var G__19661 = acc__$2;
G__19650__$1 = G__19660;
acc__$1 = G__19661;
continue;
} else {
var subject_all = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_followed = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subjects_to_follow = clojure.set.difference.call(null,subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.call(null,((function (G__19650__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__19657,seq__19658,first__19659,seq__19658__$1,subject__$1,r__$1,acc__$2,G__19650,vec__19651,seq__19652,first__19653,seq__19652__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.call(null,acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var self_QMARK_ = cljs.core._EQ_.call(null,subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:all_followed.call(null,subject_to_follow));
var acc_SINGLEQUOTE_ = cljs.core.update_in.call(null,acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__4126__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.call(null,acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"all","all",892129742)], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.call(null,acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null),((function (G__19650__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__19657,seq__19658,first__19659,seq__19658__$1,subject__$1,r__$1,acc__$2,G__19650,vec__19651,seq__19652,first__19653,seq__19652__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.call(null,cljs.core.conj,existing,subject_to_follow_all);
});})(G__19650__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__19657,seq__19658,first__19659,seq__19658__$1,subject__$1,r__$1,acc__$2,G__19650,vec__19651,seq__19652,first__19653,seq__19652__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.call(null,acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
return cljs.core.update_in.call(null,acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),((function (G__19650__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__19657,seq__19658,first__19659,seq__19658__$1,subject__$1,r__$1,acc__$2,G__19650,vec__19651,seq__19652,first__19653,seq__19652__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.call(null,cljs.core.conj,existing,subject_to_follow_all);
});})(G__19650__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__19657,seq__19658,first__19659,seq__19658__$1,subject__$1,r__$1,acc__$2,G__19650,vec__19651,seq__19652,first__19653,seq__19652__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__19650__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__19657,seq__19658,first__19659,seq__19658__$1,subject__$1,r__$1,acc__$2,G__19650,vec__19651,seq__19652,first__19653,seq__19652__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subject_all_count = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_done_QMARK_ = cljs.core._EQ_.call(null,subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__19662 = r__$1;
var G__19663 = cljs.core.assoc_in.call(null,acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null),true);
G__19650__$1 = G__19662;
acc__$1 = G__19663;
continue;
} else {
var G__19664 = subjects;
var G__19665 = acc_STAR_;
G__19650__$1 = G__19664;
acc__$1 = G__19665;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.call(null,(function (acc,subject){
var subject_vals = cljs.core.get_in.call(null,recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
return cljs.core.concat.call(null,acc,cljs.core.map.call(null,(function (p1__19666_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__19666_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_19757){
var state_val_19758 = (state_19757[(1)]);
if((state_val_19758 === (7))){
var state_19757__$1 = state_19757;
var statearr_19759_19805 = state_19757__$1;
(statearr_19759_19805[(2)] = (100));

(statearr_19759_19805[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19758 === (20))){
var inst_19706 = (state_19757[(7)]);
var state_19757__$1 = state_19757;
var statearr_19760_19806 = state_19757__$1;
(statearr_19760_19806[(2)] = inst_19706);

(statearr_19760_19806[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19758 === (1))){
var state_19757__$1 = state_19757;
var statearr_19761_19807 = state_19757__$1;
(statearr_19761_19807[(2)] = null);

(statearr_19761_19807[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19758 === (24))){
var inst_19745 = (state_19757[(8)]);
var inst_19744 = (state_19757[(9)]);
var inst_19678 = (state_19757[(10)]);
var inst_19743 = (state_19757[(11)]);
var inst_19748 = (function (){var max_depth = inst_19678;
var recur_map__$1 = inst_19744;
var subjects = inst_19743;
var tuples = inst_19745;
return (function (p1__19667_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second.call(null,p1__19667_SHARP_)],null));
});
})();
var inst_19749 = cljs.core.map.call(null,inst_19748,inst_19745);
var inst_19750 = cljs.core.distinct.call(null,inst_19749);
var state_19757__$1 = state_19757;
var statearr_19762_19808 = state_19757__$1;
(statearr_19762_19808[(2)] = inst_19750);

(statearr_19762_19808[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19758 === (4))){
var inst_19668 = (state_19757[(2)]);
var state_19757__$1 = state_19757;
var statearr_19763_19809 = state_19757__$1;
(statearr_19763_19809[(2)] = inst_19668);

(statearr_19763_19809[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19758 === (15))){
var inst_19691 = (state_19757[(12)]);
var inst_19702 = cljs.core.PersistentVector.EMPTY;
var inst_19703 = cljs.core.seq.call(null,inst_19691);
var inst_19704 = cljs.core.first.call(null,inst_19703);
var inst_19705 = cljs.core.next.call(null,inst_19703);
var inst_19706 = inst_19702;
var inst_19707 = inst_19691;
var state_19757__$1 = (function (){var statearr_19764 = state_19757;
(statearr_19764[(13)] = inst_19705);

(statearr_19764[(14)] = inst_19704);

(statearr_19764[(7)] = inst_19706);

(statearr_19764[(15)] = inst_19707);

return statearr_19764;
})();
var statearr_19765_19810 = state_19757__$1;
(statearr_19765_19810[(2)] = null);

(statearr_19765_19810[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19758 === (21))){
var inst_19727 = (state_19757[(2)]);
var state_19757__$1 = state_19757;
var statearr_19766_19811 = state_19757__$1;
(statearr_19766_19811[(2)] = inst_19727);

(statearr_19766_19811[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19758 === (13))){
var inst_19740 = (state_19757[(2)]);
var state_19757__$1 = state_19757;
var statearr_19767_19812 = state_19757__$1;
(statearr_19767_19812[(2)] = inst_19740);

(statearr_19767_19812[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19758 === (22))){
var inst_19706 = (state_19757[(7)]);
var inst_19714 = (state_19757[(16)]);
var inst_19721 = (state_19757[(2)]);
var inst_19722 = fluree.db.util.async.throw_err.call(null,inst_19721);
var inst_19723 = cljs.core.concat.call(null,inst_19706,inst_19722);
var inst_19706__$1 = inst_19723;
var inst_19707 = inst_19714;
var state_19757__$1 = (function (){var statearr_19768 = state_19757;
(statearr_19768[(7)] = inst_19706__$1);

(statearr_19768[(15)] = inst_19707);

return statearr_19768;
})();
var statearr_19769_19813 = state_19757__$1;
(statearr_19769_19813[(2)] = null);

(statearr_19769_19813[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19758 === (6))){
var inst_19674 = (state_19757[(17)]);
var state_19757__$1 = state_19757;
var statearr_19770_19814 = state_19757__$1;
(statearr_19770_19814[(2)] = inst_19674);

(statearr_19770_19814[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19758 === (25))){
var inst_19752 = (state_19757[(2)]);
var _ = (function (){var statearr_19771 = state_19757;
(statearr_19771[(4)] = cljs.core.rest.call(null,(state_19757[(4)])));

return statearr_19771;
})();
var state_19757__$1 = state_19757;
var statearr_19772_19815 = state_19757__$1;
(statearr_19772_19815[(2)] = inst_19752);

(statearr_19772_19815[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19758 === (17))){
var inst_19713 = (state_19757[(18)]);
var inst_19707 = (state_19757[(15)]);
var inst_19712 = cljs.core.seq.call(null,inst_19707);
var inst_19713__$1 = cljs.core.first.call(null,inst_19712);
var inst_19714 = cljs.core.next.call(null,inst_19712);
var state_19757__$1 = (function (){var statearr_19773 = state_19757;
(statearr_19773[(18)] = inst_19713__$1);

(statearr_19773[(16)] = inst_19714);

return statearr_19773;
})();
if(cljs.core.truth_(inst_19713__$1)){
var statearr_19774_19816 = state_19757__$1;
(statearr_19774_19816[(1)] = (19));

} else {
var statearr_19775_19817 = state_19757__$1;
(statearr_19775_19817[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19758 === (3))){
var inst_19755 = (state_19757[(2)]);
var state_19757__$1 = state_19757;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19757__$1,inst_19755);
} else {
if((state_val_19758 === (12))){
var inst_19680 = (state_19757[(19)]);
var inst_19691 = (state_19757[(12)]);
var inst_19686 = cljs.core.vals.call(null,inst_19680);
var inst_19687 = cljs.core.flatten.call(null,inst_19686);
var inst_19688 = cljs.core.set.call(null,inst_19687);
var inst_19689 = cljs.core.keys.call(null,inst_19680);
var inst_19690 = cljs.core.set.call(null,inst_19689);
var inst_19691__$1 = clojure.set.difference.call(null,inst_19688,inst_19690);
var inst_19692 = cljs.core.empty_QMARK_.call(null,inst_19691__$1);
var state_19757__$1 = (function (){var statearr_19776 = state_19757;
(statearr_19776[(12)] = inst_19691__$1);

return statearr_19776;
})();
if(inst_19692){
var statearr_19777_19818 = state_19757__$1;
(statearr_19777_19818[(1)] = (14));

} else {
var statearr_19778_19819 = state_19757__$1;
(statearr_19778_19819[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19758 === (2))){
var inst_19674 = (state_19757[(17)]);
var _ = (function (){var statearr_19779 = state_19757;
(statearr_19779[(4)] = cljs.core.cons.call(null,(5),(state_19757[(4)])));

return statearr_19779;
})();
var inst_19674__$1 = depth;
var state_19757__$1 = (function (){var statearr_19780 = state_19757;
(statearr_19780[(17)] = inst_19674__$1);

return statearr_19780;
})();
if(cljs.core.truth_(inst_19674__$1)){
var statearr_19781_19820 = state_19757__$1;
(statearr_19781_19820[(1)] = (6));

} else {
var statearr_19782_19821 = state_19757__$1;
(statearr_19782_19821[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19758 === (23))){
var inst_19745 = (state_19757[(8)]);
var state_19757__$1 = state_19757;
var statearr_19783_19822 = state_19757__$1;
(statearr_19783_19822[(2)] = inst_19745);

(statearr_19783_19822[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19758 === (19))){
var inst_19713 = (state_19757[(18)]);
var inst_19716 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19717 = [inst_19713,predicate];
var inst_19718 = (new cljs.core.PersistentVector(null,2,(5),inst_19716,inst_19717,null));
var inst_19719 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_19718);
var state_19757__$1 = state_19757;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19757__$1,(22),inst_19719);
} else {
if((state_val_19758 === (11))){
var inst_19680 = (state_19757[(19)]);
var state_19757__$1 = state_19757;
var statearr_19785_19823 = state_19757__$1;
(statearr_19785_19823[(2)] = inst_19680);

(statearr_19785_19823[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19758 === (9))){
var inst_19678 = (state_19757[(10)]);
var inst_19681 = (state_19757[(20)]);
var inst_19683 = (inst_19681 >= inst_19678);
var state_19757__$1 = state_19757;
if(cljs.core.truth_(inst_19683)){
var statearr_19786_19824 = state_19757__$1;
(statearr_19786_19824[(1)] = (11));

} else {
var statearr_19787_19825 = state_19757__$1;
(statearr_19787_19825[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19758 === (5))){
var _ = (function (){var statearr_19788 = state_19757;
(statearr_19788[(4)] = cljs.core.rest.call(null,(state_19757[(4)])));

return statearr_19788;
})();
var state_19757__$1 = state_19757;
var ex19784 = (state_19757__$1[(2)]);
var statearr_19789_19826 = state_19757__$1;
(statearr_19789_19826[(5)] = ex19784);


if((ex19784 instanceof Error)){
var statearr_19790_19827 = state_19757__$1;
(statearr_19790_19827[(1)] = (4));

(statearr_19790_19827[(5)] = null);

} else {
throw ex19784;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19758 === (14))){
var inst_19680 = (state_19757[(19)]);
var state_19757__$1 = state_19757;
var statearr_19791_19828 = state_19757__$1;
(statearr_19791_19828[(2)] = inst_19680);

(statearr_19791_19828[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19758 === (16))){
var inst_19738 = (state_19757[(2)]);
var state_19757__$1 = state_19757;
var statearr_19792_19829 = state_19757__$1;
(statearr_19792_19829[(2)] = inst_19738);

(statearr_19792_19829[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19758 === (10))){
var inst_19744 = (state_19757[(9)]);
var inst_19743 = (state_19757[(11)]);
var inst_19742 = (state_19757[(2)]);
var inst_19743__$1 = cljs.core.keys.call(null,inst_19742);
var inst_19744__$1 = fluree.db.query.analytical.follow_all_original_subject_paths.call(null,inst_19743__$1,inst_19742);
var inst_19745 = fluree.db.query.analytical.recur_map__GT_tuples.call(null,inst_19743__$1,inst_19744__$1);
var state_19757__$1 = (function (){var statearr_19793 = state_19757;
(statearr_19793[(8)] = inst_19745);

(statearr_19793[(9)] = inst_19744__$1);

(statearr_19793[(11)] = inst_19743__$1);

return statearr_19793;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_19794_19830 = state_19757__$1;
(statearr_19794_19830[(1)] = (23));

} else {
var statearr_19795_19831 = state_19757__$1;
(statearr_19795_19831[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19758 === (18))){
var inst_19680 = (state_19757[(19)]);
var inst_19681 = (state_19757[(20)]);
var inst_19729 = (state_19757[(2)]);
var inst_19730 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19731 = [(0),(2)];
var inst_19732 = (new cljs.core.PersistentVector(null,2,(5),inst_19730,inst_19731,null));
var inst_19733 = fluree.db.query.analytical.get_ns_arrays.call(null,inst_19732,inst_19729);
var inst_19734 = fluree.db.query.analytical.tuples__GT_map.call(null,inst_19680,inst_19733);
var inst_19735 = (inst_19681 + (1));
var inst_19680__$1 = inst_19734;
var inst_19681__$1 = inst_19735;
var state_19757__$1 = (function (){var statearr_19796 = state_19757;
(statearr_19796[(19)] = inst_19680__$1);

(statearr_19796[(20)] = inst_19681__$1);

return statearr_19796;
})();
var statearr_19797_19832 = state_19757__$1;
(statearr_19797_19832[(2)] = null);

(statearr_19797_19832[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19758 === (8))){
var inst_19678 = (state_19757[(2)]);
var inst_19679 = recur_map;
var inst_19680 = inst_19679;
var inst_19681 = (1);
var state_19757__$1 = (function (){var statearr_19798 = state_19757;
(statearr_19798[(10)] = inst_19678);

(statearr_19798[(19)] = inst_19680);

(statearr_19798[(20)] = inst_19681);

return statearr_19798;
})();
var statearr_19799_19833 = state_19757__$1;
(statearr_19799_19833[(2)] = null);

(statearr_19799_19833[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2468__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2468__auto____0 = (function (){
var statearr_19800 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19800[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2468__auto__);

(statearr_19800[(1)] = (1));

return statearr_19800;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2468__auto____1 = (function (state_19757){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_19757);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e19801){var ex__2471__auto__ = e19801;
var statearr_19802_19834 = state_19757;
(statearr_19802_19834[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_19757[(4)]))){
var statearr_19803_19835 = state_19757;
(statearr_19803_19835[(1)] = cljs.core.first.call(null,(state_19757[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19836 = state_19757;
state_19757 = G__19836;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2468__auto__ = function(state_19757){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2468__auto____1.call(this,state_19757);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2468__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2468__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_19804 = f__2491__auto__.call(null);
(statearr_19804[(6)] = c__2490__auto__);

return statearr_19804;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__19837,clause,fuel,max_fuel){
var map__19838 = p__19837;
var map__19838__$1 = (((((!((map__19838 == null))))?(((((map__19838.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19838.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19838):map__19838);
var res = map__19838__$1;
var headers = cljs.core.get.call(null,map__19838__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__19838__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vars = cljs.core.get.call(null,map__19838__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_19970){
var state_val_19971 = (state_19970[(1)]);
if((state_val_19971 === (7))){
var state_19970__$1 = state_19970;
var statearr_19972_20038 = state_19970__$1;
(statearr_19972_20038[(2)] = false);

(statearr_19972_20038[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19971 === (20))){
var inst_19902 = (state_19970[(7)]);
var state_19970__$1 = state_19970;
var statearr_19973_20039 = state_19970__$1;
(statearr_19973_20039[(2)] = inst_19902);

(statearr_19973_20039[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19971 === (27))){
var inst_19906 = (state_19970[(8)]);
var inst_19930 = (state_19970[(2)]);
var state_19970__$1 = (function (){var statearr_19974 = state_19970;
(statearr_19974[(9)] = inst_19930);

return statearr_19974;
})();
if(cljs.core.truth_(inst_19906)){
var statearr_19975_20040 = state_19970__$1;
(statearr_19975_20040[(1)] = (28));

} else {
var statearr_19976_20041 = state_19970__$1;
(statearr_19976_20041[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19971 === (1))){
var state_19970__$1 = state_19970;
var statearr_19977_20042 = state_19970__$1;
(statearr_19977_20042[(2)] = null);

(statearr_19977_20042[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19971 === (24))){
var inst_19918 = (state_19970[(2)]);
var inst_19919 = cljs.core.nth.call(null,clause,(2));
var inst_19920 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_19919);
var state_19970__$1 = (function (){var statearr_19978 = state_19970;
(statearr_19978[(10)] = inst_19918);

return statearr_19978;
})();
if(cljs.core.truth_(inst_19920)){
var statearr_19979_20043 = state_19970__$1;
(statearr_19979_20043[(1)] = (25));

} else {
var statearr_19980_20044 = state_19970__$1;
(statearr_19980_20044[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19971 === (4))){
var inst_19840 = (state_19970[(2)]);
var state_19970__$1 = state_19970;
var statearr_19981_20045 = state_19970__$1;
(statearr_19981_20045[(2)] = inst_19840);

(statearr_19981_20045[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19971 === (15))){
var inst_19888 = (state_19970[(11)]);
var state_19970__$1 = state_19970;
var statearr_19982_20046 = state_19970__$1;
(statearr_19982_20046[(2)] = inst_19888);

(statearr_19982_20046[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19971 === (21))){
var inst_19873 = (state_19970[(12)]);
var inst_19961 = (state_19970[(2)]);
var inst_19962 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_19963 = cljs.core.keys.call(null,inst_19873);
var inst_19964 = [inst_19963,vars,inst_19961];
var inst_19965 = cljs.core.PersistentHashMap.fromArrays(inst_19962,inst_19964);
var _ = (function (){var statearr_19983 = state_19970;
(statearr_19983[(4)] = cljs.core.rest.call(null,(state_19970[(4)])));

return statearr_19983;
})();
var state_19970__$1 = state_19970;
var statearr_19984_20047 = state_19970__$1;
(statearr_19984_20047[(2)] = inst_19965);

(statearr_19984_20047[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19971 === (31))){
var inst_19902 = (state_19970[(7)]);
var inst_19904 = (state_19970[(13)]);
var inst_19937 = cljs.core.PersistentHashMap.EMPTY;
var inst_19938 = cljs.core.flatten.call(null,inst_19902);
var inst_19939 = cljs.core.assoc.call(null,inst_19937,inst_19904,inst_19938);
var state_19970__$1 = state_19970;
var statearr_19985_20048 = state_19970__$1;
(statearr_19985_20048[(2)] = inst_19939);

(statearr_19985_20048[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19971 === (32))){
var inst_19904 = (state_19970[(13)]);
var inst_19941 = cljs.core.coll_QMARK_.call(null,inst_19904);
var state_19970__$1 = state_19970;
if(inst_19941){
var statearr_19986_20049 = state_19970__$1;
(statearr_19986_20049[(1)] = (34));

} else {
var statearr_19987_20050 = state_19970__$1;
(statearr_19987_20050[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19971 === (33))){
var inst_19952 = (state_19970[(2)]);
var state_19970__$1 = state_19970;
var statearr_19988_20051 = state_19970__$1;
(statearr_19988_20051[(2)] = inst_19952);

(statearr_19988_20051[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19971 === (13))){
var inst_19850 = (state_19970[(14)]);
var state_19970__$1 = state_19970;
var statearr_19989_20052 = state_19970__$1;
(statearr_19989_20052[(2)] = inst_19850);

(statearr_19989_20052[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19971 === (22))){
var inst_19886 = (state_19970[(15)]);
var inst_19910 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_19886)].join('');
var inst_19911 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19912 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_19913 = cljs.core.PersistentHashMap.fromArrays(inst_19911,inst_19912);
var inst_19914 = cljs.core.ex_info.call(null,inst_19910,inst_19913);
var inst_19915 = (function(){throw inst_19914})();
var state_19970__$1 = state_19970;
var statearr_19990_20053 = state_19970__$1;
(statearr_19990_20053[(2)] = inst_19915);

(statearr_19990_20053[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19971 === (36))){
var inst_19950 = (state_19970[(2)]);
var state_19970__$1 = state_19970;
var statearr_19991_20054 = state_19970__$1;
(statearr_19991_20054[(2)] = inst_19950);

(statearr_19991_20054[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19971 === (29))){
var inst_19904 = (state_19970[(13)]);
var inst_19935 = typeof inst_19904 === 'number';
var state_19970__$1 = state_19970;
if(cljs.core.truth_(inst_19935)){
var statearr_19992_20055 = state_19970__$1;
(statearr_19992_20055[(1)] = (31));

} else {
var statearr_19993_20056 = state_19970__$1;
(statearr_19993_20056[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19971 === (6))){
var inst_19850 = (state_19970[(14)]);
var inst_19855 = inst_19850.cljs$lang$protocol_mask$partition0$;
var inst_19856 = (inst_19855 & (64));
var inst_19857 = inst_19850.cljs$core$ISeq$;
var inst_19858 = (cljs.core.PROTOCOL_SENTINEL === inst_19857);
var inst_19859 = ((inst_19856) || (inst_19858));
var state_19970__$1 = state_19970;
if(cljs.core.truth_(inst_19859)){
var statearr_19994_20057 = state_19970__$1;
(statearr_19994_20057[(1)] = (9));

} else {
var statearr_19995_20058 = state_19970__$1;
(statearr_19995_20058[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19971 === (28))){
var inst_19902 = (state_19970[(7)]);
var inst_19932 = cljs.core.PersistentHashMap.EMPTY;
var inst_19933 = fluree.db.query.analytical.tuples__GT_map.call(null,inst_19932,inst_19902);
var state_19970__$1 = state_19970;
var statearr_19996_20059 = state_19970__$1;
(statearr_19996_20059[(2)] = inst_19933);

(statearr_19996_20059[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19971 === (25))){
var state_19970__$1 = state_19970;
var statearr_19997_20060 = state_19970__$1;
(statearr_19997_20060[(2)] = null);

(statearr_19997_20060[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19971 === (34))){
var inst_19898 = (state_19970[(16)]);
var inst_19902 = (state_19970[(7)]);
var inst_19943 = cljs.core.PersistentHashMap.EMPTY;
var inst_19944 = cljs.core.first.call(null,inst_19898);
var inst_19945 = cljs.core.first.call(null,inst_19944);
var inst_19946 = cljs.core.flatten.call(null,inst_19902);
var inst_19947 = cljs.core.assoc.call(null,inst_19943,inst_19945,inst_19946);
var state_19970__$1 = state_19970;
var statearr_19998_20061 = state_19970__$1;
(statearr_19998_20061[(2)] = inst_19947);

(statearr_19998_20061[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19971 === (17))){
var inst_19887 = (state_19970[(17)]);
var inst_19886 = (state_19970[(15)]);
var inst_19892 = (state_19970[(2)]);
var inst_19893 = [inst_19892];
var inst_19894 = cljs.core.PersistentHashMap.fromArrays(inst_19887,inst_19893);
var inst_19895 = fluree.db.query.range.search.call(null,db,inst_19886,inst_19894);
var state_19970__$1 = state_19970;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19970__$1,(18),inst_19895);
} else {
if((state_val_19971 === (3))){
var inst_19968 = (state_19970[(2)]);
var state_19970__$1 = state_19970;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19970__$1,inst_19968);
} else {
if((state_val_19971 === (12))){
var inst_19850 = (state_19970[(14)]);
var inst_19868 = cljs.core.apply.call(null,cljs.core.hash_map,inst_19850);
var state_19970__$1 = state_19970;
var statearr_19999_20062 = state_19970__$1;
(statearr_19999_20062[(2)] = inst_19868);

(statearr_19999_20062[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19971 === (2))){
var inst_19850 = (state_19970[(14)]);
var _ = (function (){var statearr_20000 = state_19970;
(statearr_20000[(4)] = cljs.core.cons.call(null,(5),(state_19970[(4)])));

return statearr_20000;
})();
var inst_19850__$1 = fluree.db.query.analytical.clause__GT_rel.call(null,db,vars,clause);
var inst_19852 = (inst_19850__$1 == null);
var inst_19853 = cljs.core.not.call(null,inst_19852);
var state_19970__$1 = (function (){var statearr_20001 = state_19970;
(statearr_20001[(14)] = inst_19850__$1);

return statearr_20001;
})();
if(inst_19853){
var statearr_20002_20063 = state_19970__$1;
(statearr_20002_20063[(1)] = (6));

} else {
var statearr_20003_20064 = state_19970__$1;
(statearr_20003_20064[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19971 === (23))){
var state_19970__$1 = state_19970;
var statearr_20004_20065 = state_19970__$1;
(statearr_20004_20065[(2)] = null);

(statearr_20004_20065[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19971 === (35))){
var state_19970__$1 = state_19970;
var statearr_20005_20066 = state_19970__$1;
(statearr_20005_20066[(2)] = null);

(statearr_20005_20066[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19971 === (19))){
var inst_19886 = (state_19970[(15)]);
var inst_19907 = (state_19970[(18)]);
var inst_19904 = cljs.core.first.call(null,inst_19886);
var inst_19905 = cljs.core.first.call(null,clause);
var inst_19906 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_19905);
var inst_19907__$1 = cljs.core.nth.call(null,inst_19886,(1));
var inst_19908 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_19907__$1);
var state_19970__$1 = (function (){var statearr_20006 = state_19970;
(statearr_20006[(8)] = inst_19906);

(statearr_20006[(13)] = inst_19904);

(statearr_20006[(18)] = inst_19907__$1);

return statearr_20006;
})();
if(cljs.core.truth_(inst_19908)){
var statearr_20007_20067 = state_19970__$1;
(statearr_20007_20067[(1)] = (22));

} else {
var statearr_20008_20068 = state_19970__$1;
(statearr_20008_20068[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19971 === (11))){
var inst_19863 = (state_19970[(2)]);
var state_19970__$1 = state_19970;
var statearr_20010_20069 = state_19970__$1;
(statearr_20010_20069[(2)] = inst_19863);

(statearr_20010_20069[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19971 === (9))){
var state_19970__$1 = state_19970;
var statearr_20011_20070 = state_19970__$1;
(statearr_20011_20070[(2)] = true);

(statearr_20011_20070[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19971 === (5))){
var _ = (function (){var statearr_20012 = state_19970;
(statearr_20012[(4)] = cljs.core.rest.call(null,(state_19970[(4)])));

return statearr_20012;
})();
var state_19970__$1 = state_19970;
var ex20009 = (state_19970__$1[(2)]);
var statearr_20013_20071 = state_19970__$1;
(statearr_20013_20071[(5)] = ex20009);


if((ex20009 instanceof Error)){
var statearr_20014_20072 = state_19970__$1;
(statearr_20014_20072[(1)] = (4));

(statearr_20014_20072[(5)] = null);

} else {
throw ex20009;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19971 === (14))){
var inst_19873 = (state_19970[(12)]);
var inst_19888 = (state_19970[(11)]);
var inst_19876 = (state_19970[(19)]);
var inst_19877 = (state_19970[(20)]);
var inst_19871 = (state_19970[(2)]);
var inst_19872 = cljs.core.get.call(null,inst_19871,new cljs.core.Keyword(null,"search","search",1564939822));
var inst_19873__$1 = cljs.core.get.call(null,inst_19871,new cljs.core.Keyword(null,"rel","rel",1378823488));
var inst_19874 = cljs.core.get.call(null,inst_19871,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_19875 = fluree.db.query.analytical.intersecting_keys_tuples_clause.call(null,res,clause);
var inst_19876__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_19874);
var inst_19877__$1 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_19874);
var inst_19879 = (function (){var map__19846 = inst_19871;
var search = inst_19872;
var rel = inst_19873__$1;
var opts = inst_19874;
var common_keys = inst_19875;
var object_fn = inst_19876__$1;
var recur_depth = inst_19877__$1;
return (function (p__19878,common_key){
var vec__20015 = p__19878;
var acc = cljs.core.nth.call(null,vec__20015,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__20015,(1),null);
var idx_of = fluree.db.util.core.index_of.call(null,clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__20018 = cljs.core._EQ_;
var expr__20019 = idx_of;
if(cljs.core.truth_(pred__20018.call(null,(0),expr__20019))){
return new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441);
} else {
if(cljs.core.truth_(pred__20018.call(null,(1),expr__20019))){
return new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845);
} else {
if(cljs.core.truth_(pred__20018.call(null,(2),expr__20019))){
return new cljs.core.Keyword(null,"object-fn","object-fn",1425858481);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__20019)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of.call(null,headers,common_key);
var v = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,cljs.core.first,fluree.db.query.analytical.get_ns_arrays.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,v));
var v__$1 = (cljs.core.truth_((((!(single_v_QMARK_)))?(function (){var and__4115__auto__ = object_fn;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.call(null,k,object_fn);
} else {
return and__4115__auto__;
}
})():false))?cljs.core.comp.call(null,v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.call(null,clause_SINGLEQUOTE_,idx_of,cljs.core.first.call(null,v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_19880 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19881 = cljs.core.PersistentHashMap.EMPTY;
var inst_19882 = [inst_19881,inst_19872];
var inst_19883 = (new cljs.core.PersistentVector(null,2,(5),inst_19880,inst_19882,null));
var inst_19884 = cljs.core.reduce.call(null,inst_19879,inst_19883,inst_19875);
var inst_19885 = cljs.core.nth.call(null,inst_19884,(0),null);
var inst_19886 = cljs.core.nth.call(null,inst_19884,(1),null);
var inst_19887 = [new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)];
var inst_19888__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_19885);
var state_19970__$1 = (function (){var statearr_20021 = state_19970;
(statearr_20021[(17)] = inst_19887);

(statearr_20021[(12)] = inst_19873__$1);

(statearr_20021[(15)] = inst_19886);

(statearr_20021[(11)] = inst_19888__$1);

(statearr_20021[(19)] = inst_19876__$1);

(statearr_20021[(20)] = inst_19877__$1);

return statearr_20021;
})();
if(cljs.core.truth_(inst_19888__$1)){
var statearr_20022_20073 = state_19970__$1;
(statearr_20022_20073[(1)] = (15));

} else {
var statearr_20023_20074 = state_19970__$1;
(statearr_20023_20074[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19971 === (26))){
var inst_19886 = (state_19970[(15)]);
var inst_19923 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_19886)].join('');
var inst_19924 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19925 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_19926 = cljs.core.PersistentHashMap.fromArrays(inst_19924,inst_19925);
var inst_19927 = cljs.core.ex_info.call(null,inst_19923,inst_19926);
var inst_19928 = (function(){throw inst_19927})();
var state_19970__$1 = state_19970;
var statearr_20024_20075 = state_19970__$1;
(statearr_20024_20075[(2)] = inst_19928);

(statearr_20024_20075[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19971 === (16))){
var inst_19876 = (state_19970[(19)]);
var state_19970__$1 = state_19970;
var statearr_20025_20076 = state_19970__$1;
(statearr_20025_20076[(2)] = inst_19876);

(statearr_20025_20076[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19971 === (30))){
var inst_19906 = (state_19970[(8)]);
var inst_19877 = (state_19970[(20)]);
var inst_19907 = (state_19970[(18)]);
var inst_19954 = (state_19970[(2)]);
var inst_19955 = fluree.db.query.analytical.tuples__GT_recur.call(null,db,inst_19907,inst_19954,inst_19877,inst_19906);
var state_19970__$1 = state_19970;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19970__$1,(37),inst_19955);
} else {
if((state_val_19971 === (10))){
var state_19970__$1 = state_19970;
var statearr_20026_20077 = state_19970__$1;
(statearr_20026_20077[(2)] = false);

(statearr_20026_20077[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19971 === (18))){
var inst_19898 = (state_19970[(16)]);
var inst_19873 = (state_19970[(12)]);
var inst_19877 = (state_19970[(20)]);
var inst_19897 = (state_19970[(2)]);
var inst_19898__$1 = fluree.db.util.async.throw_err.call(null,inst_19897);
var inst_19899 = cljs.core.count.call(null,inst_19898__$1);
var inst_19900 = fluree.db.query.analytical.add_fuel.call(null,inst_19899,fuel,max_fuel);
var inst_19901 = cljs.core.vals.call(null,inst_19873);
var inst_19902 = fluree.db.query.analytical.get_ns_arrays.call(null,inst_19901,inst_19898__$1);
var state_19970__$1 = (function (){var statearr_20027 = state_19970;
(statearr_20027[(16)] = inst_19898__$1);

(statearr_20027[(7)] = inst_19902);

(statearr_20027[(21)] = inst_19900);

return statearr_20027;
})();
if(cljs.core.truth_(inst_19877)){
var statearr_20028_20078 = state_19970__$1;
(statearr_20028_20078[(1)] = (19));

} else {
var statearr_20029_20079 = state_19970__$1;
(statearr_20029_20079[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19971 === (37))){
var inst_19957 = (state_19970[(2)]);
var inst_19958 = fluree.db.util.async.throw_err.call(null,inst_19957);
var state_19970__$1 = state_19970;
var statearr_20030_20080 = state_19970__$1;
(statearr_20030_20080[(2)] = inst_19958);

(statearr_20030_20080[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19971 === (8))){
var inst_19866 = (state_19970[(2)]);
var state_19970__$1 = state_19970;
if(cljs.core.truth_(inst_19866)){
var statearr_20031_20081 = state_19970__$1;
(statearr_20031_20081[(1)] = (12));

} else {
var statearr_20032_20082 = state_19970__$1;
(statearr_20032_20082[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2468__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2468__auto____0 = (function (){
var statearr_20033 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20033[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2468__auto__);

(statearr_20033[(1)] = (1));

return statearr_20033;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2468__auto____1 = (function (state_19970){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_19970);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e20034){var ex__2471__auto__ = e20034;
var statearr_20035_20083 = state_19970;
(statearr_20035_20083[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_19970[(4)]))){
var statearr_20036_20084 = state_19970;
(statearr_20036_20084[(1)] = cljs.core.first.call(null,(state_19970[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20085 = state_19970;
state_19970 = G__20085;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2468__auto__ = function(state_19970){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2468__auto____1.call(this,state_19970);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2468__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2468__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_20037 = f__2491__auto__.call(null);
(statearr_20037[(6)] = c__2490__auto__);

return statearr_20037;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(db,res,clause){
throw cljs.core.ex_info.call(null,"Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_20184){
var state_val_20185 = (state_20184[(1)]);
if((state_val_20185 === (7))){
var inst_20095 = (state_20184[(7)]);
var state_20184__$1 = state_20184;
var statearr_20186_20226 = state_20184__$1;
(statearr_20186_20226[(2)] = inst_20095);

(statearr_20186_20226[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20185 === (20))){
var inst_20175 = (state_20184[(2)]);
var state_20184__$1 = state_20184;
var statearr_20187_20227 = state_20184__$1;
(statearr_20187_20227[(2)] = inst_20175);

(statearr_20187_20227[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20185 === (1))){
var state_20184__$1 = state_20184;
var statearr_20188_20228 = state_20184__$1;
(statearr_20188_20228[(2)] = null);

(statearr_20188_20228[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20185 === (24))){
var inst_20154 = (state_20184[(2)]);
var inst_20155 = fluree.db.util.async.throw_err.call(null,inst_20154);
var state_20184__$1 = state_20184;
var statearr_20189_20229 = state_20184__$1;
(statearr_20189_20229[(2)] = inst_20155);

(statearr_20189_20229[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20185 === (4))){
var inst_20088 = (state_20184[(2)]);
var state_20184__$1 = state_20184;
var statearr_20190_20230 = state_20184__$1;
(statearr_20190_20230[(2)] = inst_20088);

(statearr_20190_20230[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20185 === (15))){
var inst_20097 = (state_20184[(8)]);
var inst_20095 = (state_20184[(7)]);
var inst_20116 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_20117 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20118 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20119 = [inst_20095];
var inst_20120 = (new cljs.core.PersistentVector(null,1,(5),inst_20118,inst_20119,null));
var inst_20121 = (function (){var subject_var = inst_20095;
var object_var = inst_20097;
var min_sid = inst_20116;
var max_sid = (0);
return (function (p1__20086_SHARP_){
return cljs.core.conj.call(null,cljs.core.PersistentVector.EMPTY,p1__20086_SHARP_);
});
})();
var inst_20122 = cljs.core.range.call(null,inst_20116,(0));
var inst_20123 = cljs.core.map.call(null,inst_20121,inst_20122);
var inst_20124 = cljs.core.PersistentHashMap.EMPTY;
var inst_20125 = [inst_20120,inst_20123,inst_20124];
var inst_20126 = cljs.core.PersistentHashMap.fromArrays(inst_20117,inst_20125);
var state_20184__$1 = state_20184;
var statearr_20191_20231 = state_20184__$1;
(statearr_20191_20231[(2)] = inst_20126);

(statearr_20191_20231[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20185 === (21))){
var inst_20148 = (state_20184[(9)]);
var state_20184__$1 = state_20184;
var statearr_20192_20232 = state_20184__$1;
(statearr_20192_20232[(2)] = inst_20148);

(statearr_20192_20232[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20185 === (13))){
var inst_20097 = (state_20184[(8)]);
var state_20184__$1 = state_20184;
if(cljs.core.truth_(inst_20097)){
var statearr_20193_20233 = state_20184__$1;
(statearr_20193_20233[(1)] = (18));

} else {
var statearr_20194_20234 = state_20184__$1;
(statearr_20194_20234[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20185 === (22))){
var inst_20148 = (state_20184[(9)]);
var inst_20152 = fluree.db.dbproto._subid.call(null,db,inst_20148);
var state_20184__$1 = state_20184;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20184__$1,(24),inst_20152);
} else {
if((state_val_20185 === (6))){
var inst_20097 = (state_20184[(8)]);
var state_20184__$1 = state_20184;
var statearr_20195_20235 = state_20184__$1;
(statearr_20195_20235[(2)] = inst_20097);

(statearr_20195_20235[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20185 === (17))){
var inst_20145 = (state_20184[(2)]);
var state_20184__$1 = state_20184;
var statearr_20196_20236 = state_20184__$1;
(statearr_20196_20236[(2)] = inst_20145);

(statearr_20196_20236[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20185 === (3))){
var inst_20182 = (state_20184[(2)]);
var state_20184__$1 = state_20184;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20184__$1,inst_20182);
} else {
if((state_val_20185 === (12))){
var inst_20110 = ["_tx",null,"_block",null];
var inst_20111 = (new cljs.core.PersistentArrayMap(null,2,inst_20110,null));
var inst_20112 = (new cljs.core.PersistentHashSet(null,inst_20111,null));
var inst_20113 = cljs.core.last.call(null,clause);
var inst_20114 = inst_20112.call(null,inst_20113);
var state_20184__$1 = state_20184;
if(cljs.core.truth_(inst_20114)){
var statearr_20197_20237 = state_20184__$1;
(statearr_20197_20237[(1)] = (15));

} else {
var statearr_20198_20238 = state_20184__$1;
(statearr_20198_20238[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20185 === (2))){
var inst_20095 = (state_20184[(7)]);
var _ = (function (){var statearr_20199 = state_20184;
(statearr_20199[(4)] = cljs.core.cons.call(null,(5),(state_20184[(4)])));

return statearr_20199;
})();
var inst_20094 = cljs.core.first.call(null,clause);
var inst_20095__$1 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_20094);
var inst_20096 = cljs.core.last.call(null,clause);
var inst_20097 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_20096);
var state_20184__$1 = (function (){var statearr_20200 = state_20184;
(statearr_20200[(8)] = inst_20097);

(statearr_20200[(7)] = inst_20095__$1);

return statearr_20200;
})();
if(cljs.core.truth_(inst_20095__$1)){
var statearr_20201_20239 = state_20184__$1;
(statearr_20201_20239[(1)] = (6));

} else {
var statearr_20202_20240 = state_20184__$1;
(statearr_20202_20240[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20185 === (23))){
var inst_20097 = (state_20184[(8)]);
var inst_20157 = (state_20184[(2)]);
var inst_20158 = fluree.db.flake.sid__GT_cid.call(null,inst_20157);
var inst_20159 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_20158);
var inst_20160 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20161 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20162 = [inst_20097];
var inst_20163 = (new cljs.core.PersistentVector(null,1,(5),inst_20161,inst_20162,null));
var inst_20164 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20165 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20166 = [inst_20159];
var inst_20167 = (new cljs.core.PersistentVector(null,1,(5),inst_20165,inst_20166,null));
var inst_20168 = [inst_20167];
var inst_20169 = (new cljs.core.PersistentVector(null,1,(5),inst_20164,inst_20168,null));
var inst_20170 = cljs.core.PersistentHashMap.EMPTY;
var inst_20171 = [inst_20163,inst_20169,inst_20170];
var inst_20172 = cljs.core.PersistentHashMap.fromArrays(inst_20160,inst_20171);
var state_20184__$1 = state_20184;
var statearr_20203_20241 = state_20184__$1;
(statearr_20203_20241[(2)] = inst_20172);

(statearr_20203_20241[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20185 === (19))){
var state_20184__$1 = state_20184;
var statearr_20204_20242 = state_20184__$1;
(statearr_20204_20242[(2)] = null);

(statearr_20204_20242[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20185 === (11))){
var inst_20179 = (state_20184[(2)]);
var _ = (function (){var statearr_20206 = state_20184;
(statearr_20206[(4)] = cljs.core.rest.call(null,(state_20184[(4)])));

return statearr_20206;
})();
var state_20184__$1 = state_20184;
var statearr_20207_20243 = state_20184__$1;
(statearr_20207_20243[(2)] = inst_20179);

(statearr_20207_20243[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20185 === (9))){
var inst_20103 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20104 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20105 = cljs.core.PersistentHashMap.fromArrays(inst_20103,inst_20104);
var inst_20106 = cljs.core.ex_info.call(null,"When using rdf:type, either a subject or a type (collection) must be specified.",inst_20105);
var inst_20107 = (function(){throw inst_20106})();
var state_20184__$1 = state_20184;
var statearr_20208_20244 = state_20184__$1;
(statearr_20208_20244[(2)] = inst_20107);

(statearr_20208_20244[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20185 === (5))){
var _ = (function (){var statearr_20209 = state_20184;
(statearr_20209[(4)] = cljs.core.rest.call(null,(state_20184[(4)])));

return statearr_20209;
})();
var state_20184__$1 = state_20184;
var ex20205 = (state_20184__$1[(2)]);
var statearr_20210_20245 = state_20184__$1;
(statearr_20210_20245[(5)] = ex20205);


if((ex20205 instanceof Error)){
var statearr_20211_20246 = state_20184__$1;
(statearr_20211_20246[(1)] = (4));

(statearr_20211_20246[(5)] = null);

} else {
throw ex20205;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20185 === (14))){
var inst_20177 = (state_20184[(2)]);
var state_20184__$1 = state_20184;
var statearr_20212_20247 = state_20184__$1;
(statearr_20212_20247[(2)] = inst_20177);

(statearr_20212_20247[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20185 === (16))){
var inst_20097 = (state_20184[(8)]);
var inst_20095 = (state_20184[(7)]);
var inst_20128 = cljs.core.last.call(null,clause);
var inst_20129 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_20128);
var inst_20130 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_20131 = cljs.core.get.call(null,inst_20130,inst_20129);
var inst_20132 = fluree.db.flake.min_subject_id.call(null,inst_20129);
var inst_20133 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20134 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20135 = [inst_20095];
var inst_20136 = (new cljs.core.PersistentVector(null,1,(5),inst_20134,inst_20135,null));
var inst_20137 = (function (){var subject_var = inst_20095;
var object_var = inst_20097;
var cid = inst_20129;
var max_sid = inst_20131;
var min_sid = inst_20132;
return (function (p1__20087_SHARP_){
return cljs.core.conj.call(null,cljs.core.PersistentVector.EMPTY,p1__20087_SHARP_);
});
})();
var inst_20138 = (inst_20131 + (1));
var inst_20139 = cljs.core.range.call(null,inst_20132,inst_20138);
var inst_20140 = cljs.core.map.call(null,inst_20137,inst_20139);
var inst_20141 = cljs.core.PersistentHashMap.EMPTY;
var inst_20142 = [inst_20136,inst_20140,inst_20141];
var inst_20143 = cljs.core.PersistentHashMap.fromArrays(inst_20133,inst_20142);
var state_20184__$1 = state_20184;
var statearr_20213_20248 = state_20184__$1;
(statearr_20213_20248[(2)] = inst_20143);

(statearr_20213_20248[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20185 === (10))){
var inst_20095 = (state_20184[(7)]);
var state_20184__$1 = state_20184;
if(cljs.core.truth_(inst_20095)){
var statearr_20214_20249 = state_20184__$1;
(statearr_20214_20249[(1)] = (12));

} else {
var statearr_20215_20250 = state_20184__$1;
(statearr_20215_20250[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20185 === (18))){
var inst_20148 = (state_20184[(9)]);
var inst_20148__$1 = cljs.core.first.call(null,clause);
var inst_20149 = typeof inst_20148__$1 === 'number';
var state_20184__$1 = (function (){var statearr_20216 = state_20184;
(statearr_20216[(9)] = inst_20148__$1);

return statearr_20216;
})();
if(cljs.core.truth_(inst_20149)){
var statearr_20217_20251 = state_20184__$1;
(statearr_20217_20251[(1)] = (21));

} else {
var statearr_20218_20252 = state_20184__$1;
(statearr_20218_20252[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20185 === (8))){
var inst_20101 = (state_20184[(2)]);
var state_20184__$1 = state_20184;
if(cljs.core.truth_(inst_20101)){
var statearr_20219_20253 = state_20184__$1;
(statearr_20219_20253[(1)] = (9));

} else {
var statearr_20220_20254 = state_20184__$1;
(statearr_20220_20254[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2468__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2468__auto____0 = (function (){
var statearr_20221 = [null,null,null,null,null,null,null,null,null,null];
(statearr_20221[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2468__auto__);

(statearr_20221[(1)] = (1));

return statearr_20221;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2468__auto____1 = (function (state_20184){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_20184);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e20222){var ex__2471__auto__ = e20222;
var statearr_20223_20255 = state_20184;
(statearr_20223_20255[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_20184[(4)]))){
var statearr_20224_20256 = state_20184;
(statearr_20224_20256[(1)] = cljs.core.first.call(null,(state_20184[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20257 = state_20184;
state_20184 = G__20257;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2468__auto__ = function(state_20184){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2468__auto____1.call(this,state_20184);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2468__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2468__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_20225 = f__2491__auto__.call(null);
(statearr_20225[(6)] = c__2490__auto__);

return statearr_20225;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.call(null,cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum.call(null,coll) / cljs.core.count.call(null,coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.call(null,coll);
var size = cljs.core.count.call(null,coll);
var med = (size >> (1));
var G__20263 = cljs.core.nth.call(null,terms,med);
if(cljs.core.even_QMARK_.call(null,size)){
return ((G__20263 + cljs.core.nth.call(null,terms,(med - (1)))) / (2));
} else {
return G__20263;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg.call(null,coll);
var sum__$1 = sum.call(null,(function (){var iter__4529__auto__ = (function fluree$db$query$analytical$variance_$_iter__20264(s__20265){
return (new cljs.core.LazySeq(null,(function (){
var s__20265__$1 = s__20265;
while(true){
var temp__5735__auto__ = cljs.core.seq.call(null,s__20265__$1);
if(temp__5735__auto__){
var s__20265__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20265__$2)){
var c__4527__auto__ = cljs.core.chunk_first.call(null,s__20265__$2);
var size__4528__auto__ = cljs.core.count.call(null,c__4527__auto__);
var b__20267 = cljs.core.chunk_buffer.call(null,size__4528__auto__);
if((function (){var i__20266 = (0);
while(true){
if((i__20266 < size__4528__auto__)){
var x = cljs.core._nth.call(null,c__4527__auto__,i__20266);
var delta = (x - mean);
cljs.core.chunk_append.call(null,b__20267,(delta * delta));

var G__20268 = (i__20266 + (1));
i__20266 = G__20268;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20267),fluree$db$query$analytical$variance_$_iter__20264.call(null,cljs.core.chunk_rest.call(null,s__20265__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20267),null);
}
} else {
var x = cljs.core.first.call(null,s__20265__$2);
var delta = (x - mean);
return cljs.core.cons.call(null,(delta * delta),fluree$db$query$analytical$variance_$_iter__20264.call(null,cljs.core.rest.call(null,s__20265__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__.call(null,coll);
})());
return (sum__$1 / cljs.core.count.call(null,coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
return Math.sqrt(variance.call(null,coll));
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"groupconcat","groupconcat",-736310912,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"abs","abs",1394505050,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4214__auto__ = n;
var y__4215__auto__ = (- n);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
}),(function() {
var G__20269 = null;
var G__20269__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__20269__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.last.call(null,acc)) < (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.butlast.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__20269 = function(n,coll){
switch(arguments.length){
case 1:
return G__20269__1.call(this,n);
case 2:
return G__20269__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__20269.cljs$core$IFn$_invoke$arity$1 = G__20269__1;
G__20269.cljs$core$IFn$_invoke$arity$2 = G__20269__2;
return G__20269;
})()
,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__20270 = null;
var G__20270__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__20270__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.first.call(null,acc)) > (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.next.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__20270 = function(n,coll){
switch(arguments.length){
case 1:
return G__20270__1.call(this,n);
case 2:
return G__20270__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__20270.cljs$core$IFn$_invoke$arity$1 = G__20270__1;
G__20270.cljs$core$IFn$_invoke$arity$2 = G__20270__2;
return G__20270;
})()
,(function (coll){
return cljs.core.count.call(null,cljs.core.distinct.call(null,coll));
}),avg,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__20271 = null;
var G__20271__1 = (function (coll){
return cljs.core.rand_nth.call(null,coll);
});
var G__20271__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.repeatedly.call(null,n,(function (){
return cljs.core.rand_nth.call(null,coll);
})));
});
G__20271 = function(n,coll){
switch(arguments.length){
case 1:
return G__20271__1.call(this,n);
case 2:
return G__20271__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__20271.cljs$core$IFn$_invoke$arity$1 = G__20271__1;
G__20271.cljs$core$IFn$_invoke$arity$2 = G__20271__2;
return G__20271;
})()
,(function (n,coll){
return cljs.core.vec.call(null,cljs.core.take.call(null,n,cljs.core.shuffle.call(null,coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
if(typeof x === 'string'){
return cljs.core.re_matches.call(null,/^\(.+\)$/,x);
} else {
return false;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
if(typeof x === 'string'){
return cljs.core.re_matches.call(null,/^#\(.+\)$/,x);
} else {
return false;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.call(null,x);
var as_QMARK_ = cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"as","as",-1505746128,null),cljs.core.first.call(null,list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.call(null,["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,list_agg))].join('')):cljs.core.symbol.call(null,["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second.call(null,list_agg);
if(cljs.core.coll_QMARK_.call(null,func_list)){
return func_list;
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})():list_agg);
var list_count = cljs.core.count.call(null,func_list);
var vec__20272 = ((cljs.core._EQ_.call(null,(3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,func_list),cljs.core.second.call(null,func_list),cljs.core.last.call(null,func_list)], null):((((cljs.core._EQ_.call(null,(2),list_count)) && (cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"sample","sample",1719555128,null),cljs.core.first.call(null,func_list)))))?(function(){throw cljs.core.ex_info.call(null,["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():((cljs.core._EQ_.call(null,(2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,func_list),null,cljs.core.last.call(null,func_list)], null):(function(){throw cljs.core.ex_info.call(null,["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var fun = cljs.core.nth.call(null,vec__20272,(0),null);
var arg = cljs.core.nth.call(null,vec__20272,(1),null);
var var$ = cljs.core.nth.call(null,vec__20272,(2),null);
var agg_fn = (function (){var temp__5733__auto__ = fluree.db.query.analytical.built_in_aggregates.call(null,fun);
if(cljs.core.truth_(temp__5733__auto__)){
var agg_fn = temp__5733__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return agg_fn.call(null,arg,coll);
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__20275 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_.call(null,var$)) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,var$),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null))));
var variable = ((distinct_QMARK_)?cljs.core.second.call(null,var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
return agg_fn.call(null,cljs.core.distinct.call(null,coll));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.call(null,vec__20275,(0),null);
var variable = cljs.core.nth.call(null,vec__20275,(1),null);
var _ = (cljs.core.truth_(valid_var.call(null,variable))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"as","as",1148689641),as,new cljs.core.Keyword(null,"code","code",1586293142),agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__20278 = agg;
var map__20278__$1 = (((((!((map__20278 == null))))?(((((map__20278.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20278.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20278):map__20278);
var variable = cljs.core.get.call(null,map__20278__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var as = cljs.core.get.call(null,map__20278__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var code = cljs.core.get.call(null,map__20278__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var agg_params = cljs.core.flatten.call(null,fluree.db.query.analytical.select_from_tuples.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = code.call(null,agg_params);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.call(null,(function (res__$1,agg){
var vec__20281 = fluree.db.query.analytical.calculate_aggregate.call(null,res__$1,agg);
var as = cljs.core.nth.call(null,vec__20281,(0),null);
var agg_result = cljs.core.nth.call(null,vec__20281,(1),null);
var map__20284 = res__$1;
var map__20284__$1 = (((((!((map__20284 == null))))?(((((map__20284.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20284.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20284):map__20284);
var headers = cljs.core.get.call(null,map__20284__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__20284__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var tuples_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__20280_SHARP_){
return cljs.core.conj.call(null,cljs.core.vec.call(null,p1__20280_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.call(null,cljs.core.vec.call(null,headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.call(null,cljs.core.symbol,cljs.core.keys.call(null,q_map));
var vals = cljs.core.vals.call(null,q_map);
return cljs.core.zipmap.call(null,keys,vals);
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 */
fluree.db.query.analytical.find_match = (function fluree$db$query$analytical$find_match(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.call(null,(function (p1__20286_SHARP_){
return cljs.core.nth.call(null,a_tuple,p1__20286_SHARP_);
}),a_idxs);
return cljs.core.reduce.call(null,(function (acc,b_tuple){
if(cljs.core._EQ_.call(null,a_tuple_part,cljs.core.map.call(null,(function (p1__20287_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__20287_SHARP_);
}),b_idxs))){
return cljs.core.conj.call(null,(function (){var or__4126__auto__ = acc;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.call(null,a_tuple,cljs.core.map.call(null,(function (p1__20288_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__20288_SHARP_);
}),b_not_idxs)));
} else {
return acc;
}
}),null,b_tuples);
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.call(null,(function (p1__20289_SHARP_){
return cljs.core.nth.call(null,a_tuple,p1__20289_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv.call(null,(function (p__20292,row,b_tuple){
var vec__20293 = p__20292;
var acc = cljs.core.nth.call(null,vec__20293,(0),null);
var b_rows = cljs.core.nth.call(null,vec__20293,(1),null);
if(cljs.core._EQ_.call(null,a_tuple_part,cljs.core.map.call(null,(function (p1__20290_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__20290_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,(function (){var or__4126__auto__ = acc;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.call(null,a_tuple,cljs.core.map.call(null,(function (p1__20291_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__20291_SHARP_);
}),b_not_idxs))),cljs.core.conj.call(null,b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_res,b_res);
var a_idxs = cljs.core.map.call(null,(function (p1__20296_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),p1__20296_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__20297_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__20297_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__20299_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__20299_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__20298_SHARP_){
return cljs.core.range.call(null,(0),p1__20298_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res)))),cljs.core.set.call(null,b_idxs)));
var c_tuples = cljs.core.apply.call(null,cljs.core.concat,cljs.core.map.call(null,(function (a_tuple){
return fluree.db.query.analytical.find_match.call(null,a_tuple,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_res),b_idxs,b_not_idxs);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_res)));
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.call(null,(function (p1__20300_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__20300_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_res),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_res)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_tuples,b_tuples);
var a_idxs = cljs.core.map.call(null,(function (p1__20301_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__20301_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__20302_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__20302_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__20304_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__20304_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__20303_SHARP_){
return cljs.core.range.call(null,(0),p1__20303_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples)))),cljs.core.set.call(null,b_idxs)));
var c_tuples = cljs.core.apply.call(null,cljs.core.concat,cljs.core.map.call(null,(function (a_tuple){
var matches = fluree.db.query.analytical.find_match.call(null,a_tuple,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_idxs,b_not_idxs);
var or__4126__auto__ = matches;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.call(null,a_tuple,cljs.core.repeat.call(null,cljs.core.count.call(null,b_not_idxs),null))], null);
}
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples)));
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.call(null,(function (p1__20305_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__20305_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * UNION clause takes a left-hand side, which is inner-joined, and a right-hand side, which is inner-joined.
 *   Any tuples unbound by the other set are included.
 */
fluree.db.query.analytical.outer_union = (function fluree$db$query$analytical$outer_union(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_tuples,b_tuples);
var a_idxs = cljs.core.map.call(null,(function (p1__20306_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__20306_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__20307_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__20307_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__20309_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__20309_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__20308_SHARP_){
return cljs.core.range.call(null,(0),p1__20308_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples)))),cljs.core.set.call(null,b_idxs)));
var vec__20312 = cljs.core.reduce.call(null,(function (p__20315,a_tuple){
var vec__20316 = p__20315;
var c_tuples = cljs.core.nth.call(null,vec__20316,(0),null);
var b_matched_rows = cljs.core.nth.call(null,vec__20316,(1),null);
var vec__20319 = fluree.db.query.analytical.find_match_PLUS_row_nums.call(null,a_tuple,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_idxs,b_not_idxs);
var matches = cljs.core.nth.call(null,vec__20319,(0),null);
var matched_rows = cljs.core.nth.call(null,vec__20319,(1),null);
var matches__$1 = (function (){var or__4126__auto__ = matches;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.call(null,a_tuple,cljs.core.repeat.call(null,cljs.core.count.call(null,b_not_idxs),null))], null);
}
})();
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.call(null,c_tuples,matches__$1),clojure.set.union.call(null,b_matched_rows,matched_rows)], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,cljs.core.PersistentHashSet.EMPTY], null),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples));
var c_tuples = cljs.core.nth.call(null,vec__20312,(0),null);
var b_matched_rows = cljs.core.nth.call(null,vec__20312,(1),null);
var b_unmatched_rows = cljs.core.remove.call(null,b_matched_rows,cljs.core.range.call(null,(0),cljs.core.count.call(null,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples))));
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.call(null,(function (p1__20310_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__20310_SHARP_);
}),b_not_idxs));
var b_idxs__GT_c_idxs = cljs.core.map.call(null,(function (p1__20311_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__20311_SHARP_);
}),c_headers);
var c_from_unmatched_b_tuples = cljs.core.map.call(null,(function (b_row){
var b_tuple = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.nth.call(null,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_row));
return cljs.core.map.call(null,(function (c_idx){
if((c_idx == null)){
return null;
} else {
return cljs.core.get.call(null,b_tuple,c_idx);
}
}),b_idxs__GT_c_idxs);
}),b_unmatched_rows);
var c_tuples__$1 = cljs.core.concat.call(null,c_tuples,c_from_unmatched_b_tuples);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples__$1], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.call(null," ",filter_code_req),")"].join('');
var vec__20323 = (function (){var or__4126__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.call(null,filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.call(null,vec__20323,(0),null);
var _ = cljs.core.nth.call(null,vec__20323,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.call(null,(function (p1__20322_SHARP_){
return fluree.db.query.analytical_filter.filter_row.call(null,headers,p1__20322_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.call(null,(function (tuples__$1,filt){
var var_atom = cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY);
var vec__20328 = (function (){var or__4126__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.call(null,filt,valid_vars,var_atom);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filt_STAR_ = cljs.core.nth.call(null,vec__20328,(0),null);
var filt_vars = cljs.core.nth.call(null,vec__20328,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.call(null,(function (p1__20326_SHARP_){
return fluree.db.util.core.index_of.call(null,headers,p1__20326_SHARP_);
}),cljs.core.deref.call(null,filt_vars));
var filtered_tuples = cljs.core.reduce.call(null,(function (acc,clause){
if(cljs.core.every_QMARK_.call(null,(function (p1__20327_SHARP_){
return cljs.core.nth.call(null,clause,p1__20327_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row.call(null,headers,clause,filt_str))){
return cljs.core.conj.call(null,acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.call(null,acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__20331,filters,optional_QMARK_){
var map__20332 = p__20331;
var map__20332__$1 = (((((!((map__20332 == null))))?(((((map__20332.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20332.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20332):map__20332);
var tuple_map = map__20332__$1;
var headers = cljs.core.get.call(null,map__20332__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__20332__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var tuples = cljs.core.get.call(null,map__20332__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var valid_vars = cljs.core.set.call(null,headers);
var header_vec = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.call(null,["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),fluree.db.query.analytical.tuples__GT_filter_optional.call(null,header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters.call(null,filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty.call(null,filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required.call(null,header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters.call(null,filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty.call(null,filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional.call(null,header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__20334 = clause;
var k = cljs.core.nth.call(null,vec__20334,(0),null);
var v = cljs.core.nth.call(null,vec__20334,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_.call(null,k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.call(null,["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var map__20337 = res;
var map__20337__$1 = (((((!((map__20337 == null))))?(((((map__20337.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20337.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20337):map__20337);
var headers = cljs.core.get.call(null,map__20337__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__20337__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_.call(null,v))?cljs.core.second.call(null,fluree.db.query.analytical.calculate_aggregate.call(null,res,fluree.db.query.analytical.parse_aggregate.call(null,cljs.core.subs.call(null,v,(1)),cljs.core.set.call(null,(function (){var temp__5733__auto__ = cljs.core.keys.call(null,vars);
if(cljs.core.truth_(temp__5733__auto__)){
var valid_var = temp__5733__auto__;
return cljs.core.conj.call(null,headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_20394){
var state_val_20395 = (state_20394[(1)]);
if((state_val_20395 === (7))){
var inst_20368 = (state_20394[(7)]);
var inst_20366 = (state_20394[(2)]);
var inst_20367 = fluree.db.util.async.throw_err.call(null,inst_20366);
var inst_20368__$1 = cljs.core.nth.call(null,inst_20367,(0),null);
var inst_20369 = cljs.core.nth.call(null,inst_20367,(1),null);
var inst_20370 = (inst_20368__$1 == null);
var state_20394__$1 = (function (){var statearr_20396 = state_20394;
(statearr_20396[(8)] = inst_20369);

(statearr_20396[(7)] = inst_20368__$1);

return statearr_20396;
})();
if(cljs.core.truth_(inst_20370)){
var statearr_20397_20426 = state_20394__$1;
(statearr_20397_20426[(1)] = (8));

} else {
var statearr_20398_20427 = state_20394__$1;
(statearr_20398_20427[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20395 === (1))){
var inst_20346 = optional_clauses;
var inst_20347 = cljs.core.seq.call(null,inst_20346);
var inst_20348 = cljs.core.first.call(null,inst_20347);
var inst_20349 = cljs.core.next.call(null,inst_20347);
var inst_20350 = where_tuples;
var inst_20351 = inst_20346;
var inst_20352 = inst_20350;
var state_20394__$1 = (function (){var statearr_20399 = state_20394;
(statearr_20399[(9)] = inst_20348);

(statearr_20399[(10)] = inst_20349);

(statearr_20399[(11)] = inst_20351);

(statearr_20399[(12)] = inst_20352);

return statearr_20399;
})();
var statearr_20400_20428 = state_20394__$1;
(statearr_20400_20428[(2)] = null);

(statearr_20400_20428[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20395 === (4))){
var inst_20358 = (state_20394[(13)]);
var inst_20359 = (state_20394[(14)]);
var inst_20352 = (state_20394[(12)]);
var inst_20364 = fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_20352,inst_20358,inst_20359,true,fuel,max_fuel,opts);
var state_20394__$1 = state_20394;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20394__$1,(7),inst_20364);
} else {
if((state_val_20395 === (15))){
var state_20394__$1 = state_20394;
var statearr_20401_20429 = state_20394__$1;
(statearr_20401_20429[(2)] = null);

(statearr_20401_20429[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20395 === (13))){
var inst_20385 = (state_20394[(2)]);
var state_20394__$1 = state_20394;
var statearr_20402_20430 = state_20394__$1;
(statearr_20402_20430[(2)] = inst_20385);

(statearr_20402_20430[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20395 === (6))){
var inst_20390 = (state_20394[(2)]);
var state_20394__$1 = state_20394;
var statearr_20403_20431 = state_20394__$1;
(statearr_20403_20431[(2)] = inst_20390);

(statearr_20403_20431[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20395 === (3))){
var inst_20392 = (state_20394[(2)]);
var state_20394__$1 = state_20394;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20394__$1,inst_20392);
} else {
if((state_val_20395 === (12))){
var state_20394__$1 = state_20394;
var statearr_20404_20432 = state_20394__$1;
(statearr_20404_20432[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20395 === (2))){
var inst_20358 = (state_20394[(13)]);
var inst_20351 = (state_20394[(11)]);
var inst_20357 = cljs.core.seq.call(null,inst_20351);
var inst_20358__$1 = cljs.core.first.call(null,inst_20357);
var inst_20359 = cljs.core.next.call(null,inst_20357);
var state_20394__$1 = (function (){var statearr_20406 = state_20394;
(statearr_20406[(13)] = inst_20358__$1);

(statearr_20406[(14)] = inst_20359);

return statearr_20406;
})();
if(cljs.core.truth_(inst_20358__$1)){
var statearr_20407_20433 = state_20394__$1;
(statearr_20407_20433[(1)] = (4));

} else {
var statearr_20408_20434 = state_20394__$1;
(statearr_20408_20434[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20395 === (11))){
var inst_20369 = (state_20394[(8)]);
var inst_20368 = (state_20394[(7)]);
var inst_20351 = inst_20369;
var inst_20352 = inst_20368;
var state_20394__$1 = (function (){var statearr_20409 = state_20394;
(statearr_20409[(11)] = inst_20351);

(statearr_20409[(12)] = inst_20352);

return statearr_20409;
})();
var statearr_20410_20435 = state_20394__$1;
(statearr_20410_20435[(2)] = null);

(statearr_20410_20435[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20395 === (9))){
var inst_20358 = (state_20394[(13)]);
var inst_20374 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(inst_20358);
var state_20394__$1 = state_20394;
if(cljs.core.truth_(inst_20374)){
var statearr_20411_20436 = state_20394__$1;
(statearr_20411_20436[(1)] = (11));

} else {
var statearr_20412_20437 = state_20394__$1;
(statearr_20412_20437[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20395 === (5))){
var inst_20352 = (state_20394[(12)]);
var state_20394__$1 = state_20394;
var statearr_20413_20438 = state_20394__$1;
(statearr_20413_20438[(2)] = inst_20352);

(statearr_20413_20438[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20395 === (14))){
var inst_20369 = (state_20394[(8)]);
var inst_20368 = (state_20394[(7)]);
var inst_20352 = (state_20394[(12)]);
var inst_20379 = fluree.db.query.analytical.left_outer_join.call(null,inst_20352,inst_20368);
var inst_20351 = inst_20369;
var inst_20352__$1 = inst_20379;
var state_20394__$1 = (function (){var statearr_20414 = state_20394;
(statearr_20414[(11)] = inst_20351);

(statearr_20414[(12)] = inst_20352__$1);

return statearr_20414;
})();
var statearr_20415_20439 = state_20394__$1;
(statearr_20415_20439[(2)] = null);

(statearr_20415_20439[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20395 === (16))){
var inst_20383 = (state_20394[(2)]);
var state_20394__$1 = state_20394;
var statearr_20417_20440 = state_20394__$1;
(statearr_20417_20440[(2)] = inst_20383);

(statearr_20417_20440[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20395 === (10))){
var inst_20387 = (state_20394[(2)]);
var state_20394__$1 = state_20394;
var statearr_20418_20441 = state_20394__$1;
(statearr_20418_20441[(2)] = inst_20387);

(statearr_20418_20441[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20395 === (8))){
var inst_20369 = (state_20394[(8)]);
var inst_20352 = (state_20394[(12)]);
var tmp20416 = inst_20352;
var inst_20351 = inst_20369;
var inst_20352__$1 = tmp20416;
var state_20394__$1 = (function (){var statearr_20419 = state_20394;
(statearr_20419[(11)] = inst_20351);

(statearr_20419[(12)] = inst_20352__$1);

return statearr_20419;
})();
var statearr_20420_20442 = state_20394__$1;
(statearr_20420_20442[(2)] = null);

(statearr_20420_20442[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2468__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2468__auto____0 = (function (){
var statearr_20421 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20421[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2468__auto__);

(statearr_20421[(1)] = (1));

return statearr_20421;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2468__auto____1 = (function (state_20394){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_20394);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e20422){var ex__2471__auto__ = e20422;
var statearr_20423_20443 = state_20394;
(statearr_20423_20443[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_20394[(4)]))){
var statearr_20424_20444 = state_20394;
(statearr_20424_20444[(1)] = cljs.core.first.call(null,(state_20394[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20445 = state_20394;
state_20394 = G__20445;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2468__auto__ = function(state_20394){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2468__auto____1.call(this,state_20394);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2468__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2468__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_20425 = f__2491__auto__.call(null);
(statearr_20425[(6)] = c__2490__auto__);

return statearr_20425;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.call(null,(function (acc,p__20447){
var vec__20448 = p__20447;
var var_name = cljs.core.nth.call(null,vec__20448,(0),null);
var var_val = cljs.core.nth.call(null,vec__20448,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__20446_SHARP_){
return cljs.core.conj.call(null,p1__20446_SHARP_,var_val);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_,new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_], null);
}),res,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__20452,p__20453,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__20454 = p__20452;
var map__20454__$1 = (((((!((map__20454 == null))))?(((((map__20454.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20454.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20454):map__20454);
var q_map = map__20454__$1;
var prefixes = cljs.core.get.call(null,map__20454__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var map__20455 = p__20453;
var map__20455__$1 = (((((!((map__20455 == null))))?(((((map__20455.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20455.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20455):map__20455);
var res = map__20455__$1;
var vars = cljs.core.get.call(null,map__20455__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_20664){
var state_val_20665 = (state_20664[(1)]);
if((state_val_20665 === (7))){
var inst_20562 = cljs.core.count.call(null,clause);
var inst_20563 = cljs.core._EQ_.call(null,(3),inst_20562);
var inst_20564 = cljs.core.second.call(null,clause);
var inst_20565 = clojure.string.starts_with_QMARK_.call(null,inst_20564,"fullText:");
var inst_20566 = ((inst_20563) && (inst_20565));
var state_20664__$1 = state_20664;
if(cljs.core.truth_(inst_20566)){
var statearr_20666_20753 = state_20664__$1;
(statearr_20666_20753[(1)] = (31));

} else {
var statearr_20667_20754 = state_20664__$1;
(statearr_20667_20754[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (59))){
var inst_20633 = (state_20664[(7)]);
var inst_20636 = (state_20664[(2)]);
var inst_20637 = fluree.db.util.async.throw_err.call(null,inst_20636);
var inst_20638 = [inst_20637,r];
var inst_20639 = (new cljs.core.PersistentVector(null,2,(5),inst_20633,inst_20638,null));
var state_20664__$1 = state_20664;
var statearr_20668_20755 = state_20664__$1;
(statearr_20668_20755[(2)] = inst_20639);

(statearr_20668_20755[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (20))){
var inst_20526 = (state_20664[(2)]);
var state_20664__$1 = state_20664;
var statearr_20669_20756 = state_20664__$1;
(statearr_20669_20756[(2)] = inst_20526);

(statearr_20669_20756[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (58))){
var inst_20642 = (state_20664[(2)]);
var state_20664__$1 = state_20664;
var statearr_20670_20757 = state_20664__$1;
(statearr_20670_20757[(2)] = inst_20642);

(statearr_20670_20757[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (27))){
var inst_20556 = (state_20664[(2)]);
var state_20664__$1 = state_20664;
var statearr_20671_20758 = state_20664__$1;
(statearr_20671_20758[(2)] = inst_20556);

(statearr_20671_20758[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (1))){
var state_20664__$1 = state_20664;
var statearr_20672_20759 = state_20664__$1;
(statearr_20672_20759[(2)] = null);

(statearr_20672_20759[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (24))){
var inst_20520 = (state_20664[(2)]);
var state_20664__$1 = state_20664;
var statearr_20673_20760 = state_20664__$1;
(statearr_20673_20760[(2)] = inst_20520);

(statearr_20673_20760[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (55))){
var inst_20644 = (state_20664[(2)]);
var state_20664__$1 = state_20664;
var statearr_20674_20761 = state_20664__$1;
(statearr_20674_20761[(2)] = inst_20644);

(statearr_20674_20761[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (39))){
var inst_20598 = cljs.core.count.call(null,clause);
var inst_20599 = cljs.core._EQ_.call(null,(2),inst_20598);
var state_20664__$1 = state_20664;
if(inst_20599){
var statearr_20675_20762 = state_20664__$1;
(statearr_20675_20762[(1)] = (42));

} else {
var statearr_20676_20763 = state_20664__$1;
(statearr_20676_20763[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (46))){
var state_20664__$1 = state_20664;
var statearr_20677_20764 = state_20664__$1;
(statearr_20677_20764[(2)] = null);

(statearr_20677_20764[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (4))){
var inst_20458 = (state_20664[(2)]);
var state_20664__$1 = state_20664;
var statearr_20678_20765 = state_20664__$1;
(statearr_20678_20765[(2)] = inst_20458);

(statearr_20678_20765[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (54))){
var state_20664__$1 = state_20664;
var statearr_20679_20766 = state_20664__$1;
(statearr_20679_20766[(1)] = (56));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (15))){
var inst_20558 = (state_20664[(2)]);
var state_20664__$1 = state_20664;
var statearr_20681_20767 = state_20664__$1;
(statearr_20681_20767[(2)] = inst_20558);

(statearr_20681_20767[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (48))){
var inst_20615 = (state_20664[(8)]);
var inst_20613 = (state_20664[(2)]);
var inst_20614 = fluree.db.util.async.throw_err.call(null,inst_20613);
var inst_20615__$1 = cljs.core.nth.call(null,inst_20614,(0),null);
var inst_20616 = cljs.core.nth.call(null,inst_20614,(1),null);
var inst_20617 = cljs.core._EQ_.call(null,"$wd",inst_20615__$1);
var state_20664__$1 = (function (){var statearr_20682 = state_20664;
(statearr_20682[(9)] = inst_20616);

(statearr_20682[(8)] = inst_20615__$1);

return statearr_20682;
})();
if(inst_20617){
var statearr_20683_20768 = state_20664__$1;
(statearr_20683_20768[(1)] = (49));

} else {
var statearr_20684_20769 = state_20664__$1;
(statearr_20684_20769[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (50))){
var inst_20616 = (state_20664[(9)]);
var inst_20624 = cljs.core.second.call(null,inst_20616);
var inst_20625 = clojure.string.starts_with_QMARK_.call(null,inst_20624,"fullText:");
var state_20664__$1 = state_20664;
if(inst_20625){
var statearr_20685_20770 = state_20664__$1;
(statearr_20685_20770[(1)] = (53));

} else {
var statearr_20686_20771 = state_20664__$1;
(statearr_20686_20771[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (21))){
var inst_20497 = (state_20664[(10)]);
var inst_20492 = (state_20664[(11)]);
var inst_20496 = (state_20664[(12)]);
var inst_20471 = (state_20664[(13)]);
var inst_20494 = (state_20664[(14)]);
var inst_20504 = (state_20664[(15)]);
var inst_20503 = (state_20664[(16)]);
var inst_20495 = (state_20664[(17)]);
var inst_20467 = (state_20664[(18)]);
var inst_20508 = (state_20664[(2)]);
var inst_20509 = fluree.db.util.async.throw_err.call(null,inst_20508);
var inst_20510 = (function (){var G__20488 = inst_20496;
var new_res = inst_20509;
var seq__20490 = inst_20495;
var rest = inst_20504;
var vec__20499 = inst_20496;
var tuples = inst_20497;
var vec__20489 = inst_20492;
var first__20491 = inst_20494;
var pred__20468 = inst_20471;
var seq__20500 = inst_20504;
var segment_type = inst_20467;
var clause_group = inst_20503;
var first__20501 = inst_20503;
var expr__20469 = inst_20467;
return (function (res__$1,var$){
return cljs.core.update.call(null,new_res,new cljs.core.Keyword(null,"var","var",-769682797),cljs.core.dissoc,var$);
});
})();
var inst_20511 = cljs.core.keys.call(null,vars);
var inst_20512 = cljs.core.reduce.call(null,inst_20510,inst_20509,inst_20511);
var inst_20513 = fluree.db.query.analytical.res_absorb_vars.call(null,inst_20512);
var state_20664__$1 = (function (){var statearr_20687 = state_20664;
(statearr_20687[(19)] = inst_20513);

return statearr_20687;
})();
if(cljs.core.truth_(inst_20497)){
var statearr_20688_20772 = state_20664__$1;
(statearr_20688_20772[(1)] = (22));

} else {
var statearr_20689_20773 = state_20664__$1;
(statearr_20689_20773[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (31))){
var inst_20568 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20569 = fluree.db.query.analytical.full_text__GT_tuples.call(null,db,res,clause);
var inst_20570 = [inst_20569,r];
var inst_20571 = (new cljs.core.PersistentVector(null,2,(5),inst_20568,inst_20570,null));
var state_20664__$1 = state_20664;
var statearr_20690_20774 = state_20664__$1;
(statearr_20690_20774[(2)] = inst_20571);

(statearr_20690_20774[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (32))){
var inst_20573 = cljs.core.count.call(null,clause);
var inst_20574 = cljs.core._EQ_.call(null,(3),inst_20573);
var inst_20575 = cljs.core.second.call(null,clause);
var inst_20576 = cljs.core._EQ_.call(null,inst_20575,"rdf:type");
var inst_20577 = ((inst_20574) && (inst_20576));
var state_20664__$1 = state_20664;
if(cljs.core.truth_(inst_20577)){
var statearr_20691_20775 = state_20664__$1;
(statearr_20691_20775[(1)] = (34));

} else {
var statearr_20692_20776 = state_20664__$1;
(statearr_20692_20776[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (40))){
var inst_20653 = (state_20664[(2)]);
var state_20664__$1 = state_20664;
var statearr_20693_20777 = state_20664__$1;
(statearr_20693_20777[(2)] = inst_20653);

(statearr_20693_20777[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (56))){
var inst_20616 = (state_20664[(9)]);
var inst_20615 = (state_20664[(8)]);
var inst_20633 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20634 = fluree.db.query.analytical.fdb_clause__GT_tuples.call(null,inst_20615,res,inst_20616,fuel,max_fuel);
var state_20664__$1 = (function (){var statearr_20694 = state_20664;
(statearr_20694[(7)] = inst_20633);

return statearr_20694;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20664__$1,(59),inst_20634);
} else {
if((state_val_20665 === (33))){
var inst_20657 = (state_20664[(2)]);
var state_20664__$1 = state_20664;
var statearr_20695_20778 = state_20664__$1;
(statearr_20695_20778[(2)] = inst_20657);

(statearr_20695_20778[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (13))){
var inst_20492 = (state_20664[(11)]);
var inst_20492__$1 = new cljs.core.Keyword(null,"union","union",2142937499).cljs$core$IFn$_invoke$arity$1(clause);
var inst_20493 = cljs.core.seq.call(null,inst_20492__$1);
var inst_20494 = cljs.core.first.call(null,inst_20493);
var inst_20495 = cljs.core.next.call(null,inst_20493);
var inst_20496 = inst_20492__$1;
var inst_20497 = null;
var state_20664__$1 = (function (){var statearr_20696 = state_20664;
(statearr_20696[(10)] = inst_20497);

(statearr_20696[(11)] = inst_20492__$1);

(statearr_20696[(12)] = inst_20496);

(statearr_20696[(14)] = inst_20494);

(statearr_20696[(17)] = inst_20495);

return statearr_20696;
})();
var statearr_20697_20779 = state_20664__$1;
(statearr_20697_20779[(2)] = null);

(statearr_20697_20779[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (22))){
var inst_20497 = (state_20664[(10)]);
var inst_20513 = (state_20664[(19)]);
var inst_20504 = (state_20664[(15)]);
var inst_20515 = fluree.db.query.analytical.outer_union.call(null,inst_20497,inst_20513);
var inst_20496 = inst_20504;
var inst_20497__$1 = inst_20515;
var state_20664__$1 = (function (){var statearr_20698 = state_20664;
(statearr_20698[(10)] = inst_20497__$1);

(statearr_20698[(12)] = inst_20496);

return statearr_20698;
})();
var statearr_20699_20780 = state_20664__$1;
(statearr_20699_20780[(2)] = null);

(statearr_20699_20780[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (36))){
var inst_20655 = (state_20664[(2)]);
var state_20664__$1 = state_20664;
var statearr_20700_20781 = state_20664__$1;
(statearr_20700_20781[(2)] = inst_20655);

(statearr_20700_20781[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (41))){
var inst_20590 = (state_20664[(20)]);
var inst_20593 = (state_20664[(2)]);
var inst_20594 = fluree.db.util.async.throw_err.call(null,inst_20593);
var inst_20595 = [inst_20594,r];
var inst_20596 = (new cljs.core.PersistentVector(null,2,(5),inst_20590,inst_20595,null));
var state_20664__$1 = state_20664;
var statearr_20701_20782 = state_20664__$1;
(statearr_20701_20782[(2)] = inst_20596);

(statearr_20701_20782[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (43))){
var state_20664__$1 = state_20664;
var statearr_20702_20783 = state_20664__$1;
(statearr_20702_20783[(1)] = (45));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (29))){
var inst_20467 = (state_20664[(18)]);
var inst_20550 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20467)].join('');
var inst_20551 = (new Error(inst_20550));
var inst_20552 = (function(){throw inst_20551})();
var state_20664__$1 = state_20664;
var statearr_20704_20784 = state_20664__$1;
(statearr_20704_20784[(2)] = inst_20552);

(statearr_20704_20784[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (44))){
var inst_20651 = (state_20664[(2)]);
var state_20664__$1 = state_20664;
var statearr_20705_20785 = state_20664__$1;
(statearr_20705_20785[(2)] = inst_20651);

(statearr_20705_20785[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (6))){
var inst_20471 = (state_20664[(13)]);
var inst_20467 = (state_20664[(18)]);
var inst_20466 = cljs.core.keys.call(null,clause);
var inst_20467__$1 = cljs.core.first.call(null,inst_20466);
var inst_20471__$1 = cljs.core._EQ_;
var inst_20472 = inst_20471__$1.call(null,new cljs.core.Keyword(null,"optional","optional",2053951509),inst_20467__$1);
var state_20664__$1 = (function (){var statearr_20706 = state_20664;
(statearr_20706[(13)] = inst_20471__$1);

(statearr_20706[(18)] = inst_20467__$1);

return statearr_20706;
})();
if(cljs.core.truth_(inst_20472)){
var statearr_20707_20786 = state_20664__$1;
(statearr_20707_20786[(1)] = (9));

} else {
var statearr_20708_20787 = state_20664__$1;
(statearr_20708_20787[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (28))){
var inst_20544 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20545 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(clause);
var inst_20546 = fluree.db.query.analytical.tuples__GT_filtered.call(null,res,inst_20545,optional_QMARK_);
var inst_20547 = [inst_20546,r];
var inst_20548 = (new cljs.core.PersistentVector(null,2,(5),inst_20544,inst_20547,null));
var state_20664__$1 = state_20664;
var statearr_20709_20788 = state_20664__$1;
(statearr_20709_20788[(2)] = inst_20548);

(statearr_20709_20788[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (51))){
var inst_20646 = (state_20664[(2)]);
var state_20664__$1 = state_20664;
var statearr_20710_20789 = state_20664__$1;
(statearr_20710_20789[(2)] = inst_20646);

(statearr_20710_20789[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (25))){
var inst_20471 = (state_20664[(13)]);
var inst_20467 = (state_20664[(18)]);
var inst_20532 = new cljs.core.Keyword(null,"bind","bind",-113428417).cljs$core$IFn$_invoke$arity$1(clause);
var inst_20533 = (function (){var segment_type = inst_20467;
var pred__20468 = inst_20471;
var expr__20469 = inst_20467;
var bindings = inst_20532;
return (function (p1__20451_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars.call(null,res,p1__20451_SHARP_);
});
})();
var inst_20534 = cljs.core.map.call(null,inst_20533,inst_20532);
var inst_20535 = cljs.core.PersistentHashMap.EMPTY;
var inst_20536 = cljs.core.into.call(null,inst_20535,inst_20534);
var inst_20537 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20538 = cljs.core.update.call(null,res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_20536);
var inst_20539 = [inst_20538,r];
var inst_20540 = (new cljs.core.PersistentVector(null,2,(5),inst_20537,inst_20539,null));
var state_20664__$1 = state_20664;
var statearr_20711_20790 = state_20664__$1;
(statearr_20711_20790[(2)] = inst_20540);

(statearr_20711_20790[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (34))){
var inst_20579 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20580 = fluree.db.query.analytical.collection__GT_tuples.call(null,db,res,clause);
var state_20664__$1 = (function (){var statearr_20712 = state_20664;
(statearr_20712[(21)] = inst_20579);

return statearr_20712;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20664__$1,(37),inst_20580);
} else {
if((state_val_20665 === (17))){
var inst_20528 = (state_20664[(2)]);
var state_20664__$1 = state_20664;
var statearr_20713_20791 = state_20664__$1;
(statearr_20713_20791[(2)] = inst_20528);

(statearr_20713_20791[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (3))){
var inst_20662 = (state_20664[(2)]);
var state_20664__$1 = state_20664;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20664__$1,inst_20662);
} else {
if((state_val_20665 === (12))){
var inst_20474 = (state_20664[(22)]);
var inst_20478 = (state_20664[(2)]);
var inst_20479 = fluree.db.util.async.throw_err.call(null,inst_20478);
var inst_20480 = [inst_20479,r];
var inst_20481 = (new cljs.core.PersistentVector(null,2,(5),inst_20474,inst_20480,null));
var state_20664__$1 = state_20664;
var statearr_20714_20792 = state_20664__$1;
(statearr_20714_20792[(2)] = inst_20481);

(statearr_20714_20792[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (2))){
var _ = (function (){var statearr_20715 = state_20664;
(statearr_20715[(4)] = cljs.core.cons.call(null,(5),(state_20664[(4)])));

return statearr_20715;
})();
var inst_20464 = cljs.core.map_QMARK_.call(null,clause);
var state_20664__$1 = state_20664;
if(inst_20464){
var statearr_20716_20793 = state_20664__$1;
(statearr_20716_20793[(1)] = (6));

} else {
var statearr_20717_20794 = state_20664__$1;
(statearr_20717_20794[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (23))){
var inst_20513 = (state_20664[(19)]);
var inst_20504 = (state_20664[(15)]);
var inst_20496 = inst_20504;
var inst_20497 = inst_20513;
var state_20664__$1 = (function (){var statearr_20718 = state_20664;
(statearr_20718[(10)] = inst_20497);

(statearr_20718[(12)] = inst_20496);

return statearr_20718;
})();
var statearr_20719_20795 = state_20664__$1;
(statearr_20719_20795[(2)] = null);

(statearr_20719_20795[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (47))){
var inst_20649 = (state_20664[(2)]);
var state_20664__$1 = state_20664;
var statearr_20720_20796 = state_20664__$1;
(statearr_20720_20796[(2)] = inst_20649);

(statearr_20720_20796[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (35))){
var inst_20587 = cljs.core.count.call(null,clause);
var inst_20588 = cljs.core._EQ_.call(null,(3),inst_20587);
var state_20664__$1 = state_20664;
if(inst_20588){
var statearr_20721_20797 = state_20664__$1;
(statearr_20721_20797[(1)] = (38));

} else {
var statearr_20722_20798 = state_20664__$1;
(statearr_20722_20798[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (19))){
var inst_20497 = (state_20664[(10)]);
var inst_20522 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20523 = [inst_20497,r];
var inst_20524 = (new cljs.core.PersistentVector(null,2,(5),inst_20522,inst_20523,null));
var state_20664__$1 = state_20664;
var statearr_20723_20799 = state_20664__$1;
(statearr_20723_20799[(2)] = inst_20524);

(statearr_20723_20799[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (57))){
var state_20664__$1 = state_20664;
var statearr_20724_20800 = state_20664__$1;
(statearr_20724_20800[(2)] = null);

(statearr_20724_20800[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (11))){
var inst_20560 = (state_20664[(2)]);
var state_20664__$1 = state_20664;
var statearr_20726_20801 = state_20664__$1;
(statearr_20726_20801[(2)] = inst_20560);

(statearr_20726_20801[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (9))){
var inst_20474 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20475 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(clause);
var inst_20476 = fluree.db.query.analytical.optional__GT_left_outer_joins.call(null,db,q_map,inst_20475,res,fuel,max_fuel,opts);
var state_20664__$1 = (function (){var statearr_20727 = state_20664;
(statearr_20727[(22)] = inst_20474);

return statearr_20727;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20664__$1,(12),inst_20476);
} else {
if((state_val_20665 === (5))){
var _ = (function (){var statearr_20728 = state_20664;
(statearr_20728[(4)] = cljs.core.rest.call(null,(state_20664[(4)])));

return statearr_20728;
})();
var state_20664__$1 = state_20664;
var ex20725 = (state_20664__$1[(2)]);
var statearr_20729_20802 = state_20664__$1;
(statearr_20729_20802[(5)] = ex20725);


if((ex20725 instanceof Error)){
var statearr_20730_20803 = state_20664__$1;
(statearr_20730_20803[(1)] = (4));

(statearr_20730_20803[(5)] = null);

} else {
throw ex20725;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (14))){
var inst_20471 = (state_20664[(13)]);
var inst_20467 = (state_20664[(18)]);
var inst_20530 = inst_20471.call(null,new cljs.core.Keyword(null,"bind","bind",-113428417),inst_20467);
var state_20664__$1 = state_20664;
if(cljs.core.truth_(inst_20530)){
var statearr_20731_20804 = state_20664__$1;
(statearr_20731_20804[(1)] = (25));

} else {
var statearr_20732_20805 = state_20664__$1;
(statearr_20732_20805[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (45))){
var inst_20611 = fluree.db.query.analytical.get_source_clause.call(null,db,clause,prefixes,opts);
var state_20664__$1 = state_20664;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20664__$1,(48),inst_20611);
} else {
if((state_val_20665 === (53))){
var inst_20616 = (state_20664[(9)]);
var inst_20615 = (state_20664[(8)]);
var inst_20627 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20628 = fluree.db.query.analytical.full_text__GT_tuples.call(null,inst_20615,res,inst_20616);
var inst_20629 = [inst_20628,r];
var inst_20630 = (new cljs.core.PersistentVector(null,2,(5),inst_20627,inst_20629,null));
var state_20664__$1 = state_20664;
var statearr_20733_20806 = state_20664__$1;
(statearr_20733_20806[(2)] = inst_20630);

(statearr_20733_20806[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (26))){
var inst_20471 = (state_20664[(13)]);
var inst_20467 = (state_20664[(18)]);
var inst_20542 = inst_20471.call(null,new cljs.core.Keyword(null,"filter","filter",-948537934),inst_20467);
var state_20664__$1 = state_20664;
if(cljs.core.truth_(inst_20542)){
var statearr_20734_20807 = state_20664__$1;
(statearr_20734_20807[(1)] = (28));

} else {
var statearr_20735_20808 = state_20664__$1;
(statearr_20735_20808[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (16))){
var inst_20496 = (state_20664[(12)]);
var inst_20503 = (state_20664[(16)]);
var inst_20502 = cljs.core.seq.call(null,inst_20496);
var inst_20503__$1 = cljs.core.first.call(null,inst_20502);
var inst_20504 = cljs.core.next.call(null,inst_20502);
var state_20664__$1 = (function (){var statearr_20736 = state_20664;
(statearr_20736[(15)] = inst_20504);

(statearr_20736[(16)] = inst_20503__$1);

return statearr_20736;
})();
if(cljs.core.truth_(inst_20503__$1)){
var statearr_20737_20809 = state_20664__$1;
(statearr_20737_20809[(1)] = (18));

} else {
var statearr_20738_20810 = state_20664__$1;
(statearr_20738_20810[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (38))){
var inst_20590 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20591 = fluree.db.query.analytical.fdb_clause__GT_tuples.call(null,db,res,clause,fuel,max_fuel);
var state_20664__$1 = (function (){var statearr_20739 = state_20664;
(statearr_20739[(20)] = inst_20590);

return statearr_20739;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20664__$1,(41),inst_20591);
} else {
if((state_val_20665 === (30))){
var inst_20554 = (state_20664[(2)]);
var state_20664__$1 = state_20664;
var statearr_20740_20811 = state_20664__$1;
(statearr_20740_20811[(2)] = inst_20554);

(statearr_20740_20811[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (10))){
var inst_20471 = (state_20664[(13)]);
var inst_20467 = (state_20664[(18)]);
var inst_20483 = inst_20471.call(null,new cljs.core.Keyword(null,"union","union",2142937499),inst_20467);
var state_20664__$1 = state_20664;
if(cljs.core.truth_(inst_20483)){
var statearr_20741_20812 = state_20664__$1;
(statearr_20741_20812[(1)] = (13));

} else {
var statearr_20742_20813 = state_20664__$1;
(statearr_20742_20813[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (18))){
var inst_20503 = (state_20664[(16)]);
var inst_20506 = fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_20503,q_map,vars,fuel,max_fuel,opts);
var state_20664__$1 = state_20664;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20664__$1,(21),inst_20506);
} else {
if((state_val_20665 === (52))){
var inst_20621 = (state_20664[(2)]);
var inst_20622 = fluree.db.util.async.throw_err.call(null,inst_20621);
var state_20664__$1 = state_20664;
var statearr_20743_20814 = state_20664__$1;
(statearr_20743_20814[(2)] = inst_20622);

(statearr_20743_20814[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (42))){
var inst_20601 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20602 = fluree.db.query.analytical.bind_clause__GT_vars.call(null,res,clause);
var inst_20603 = cljs.core.update.call(null,res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_20602);
var inst_20604 = [inst_20603,r];
var inst_20605 = (new cljs.core.PersistentVector(null,2,(5),inst_20601,inst_20604,null));
var state_20664__$1 = state_20664;
var statearr_20744_20815 = state_20664__$1;
(statearr_20744_20815[(2)] = inst_20605);

(statearr_20744_20815[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (37))){
var inst_20579 = (state_20664[(21)]);
var inst_20582 = (state_20664[(2)]);
var inst_20583 = fluree.db.util.async.throw_err.call(null,inst_20582);
var inst_20584 = [inst_20583,r];
var inst_20585 = (new cljs.core.PersistentVector(null,2,(5),inst_20579,inst_20584,null));
var state_20664__$1 = state_20664;
var statearr_20745_20816 = state_20664__$1;
(statearr_20745_20816[(2)] = inst_20585);

(statearr_20745_20816[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (8))){
var inst_20659 = (state_20664[(2)]);
var _ = (function (){var statearr_20746 = state_20664;
(statearr_20746[(4)] = cljs.core.rest.call(null,(state_20664[(4)])));

return statearr_20746;
})();
var state_20664__$1 = state_20664;
var statearr_20747_20817 = state_20664__$1;
(statearr_20747_20817[(2)] = inst_20659);

(statearr_20747_20817[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20665 === (49))){
var inst_20616 = (state_20664[(9)]);
var inst_20619 = fluree.db.query.analytical.wikidata__GT_tuples.call(null,q_map,inst_20616,r,res,optional_QMARK_,fuel,max_fuel);
var state_20664__$1 = state_20664;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20664__$1,(52),inst_20619);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2468__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2468__auto____0 = (function (){
var statearr_20748 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20748[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2468__auto__);

(statearr_20748[(1)] = (1));

return statearr_20748;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2468__auto____1 = (function (state_20664){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_20664);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e20749){var ex__2471__auto__ = e20749;
var statearr_20750_20818 = state_20664;
(statearr_20750_20818[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_20664[(4)]))){
var statearr_20751_20819 = state_20664;
(statearr_20751_20819[(1)] = cljs.core.first.call(null,(state_20664[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20820 = state_20664;
state_20664 = G__20820;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2468__auto__ = function(state_20664){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2468__auto____1.call(this,state_20664);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2468__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2468__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_20752 = f__2491__auto__.call(null);
(statearr_20752[(6)] = c__2490__auto__);

return statearr_20752;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__20822 = arguments.length;
switch (G__20822) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.call(null,db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_20902){
var state_val_20903 = (state_20902[(1)]);
if((state_val_20903 === (7))){
var inst_20897 = (state_20902[(2)]);
var _ = (function (){var statearr_20904 = state_20902;
(statearr_20904[(4)] = cljs.core.rest.call(null,(state_20902[(4)])));

return statearr_20904;
})();
var state_20902__$1 = state_20902;
var statearr_20905_20953 = state_20902__$1;
(statearr_20905_20953[(2)] = inst_20897);

(statearr_20905_20953[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20903 === (20))){
var inst_20862 = (state_20902[(7)]);
var inst_20874 = (state_20902[(2)]);
var inst_20844 = inst_20862;
var inst_20845 = inst_20874;
var state_20902__$1 = (function (){var statearr_20906 = state_20902;
(statearr_20906[(8)] = inst_20844);

(statearr_20906[(9)] = inst_20845);

return statearr_20906;
})();
var statearr_20907_20954 = state_20902__$1;
(statearr_20907_20954[(2)] = null);

(statearr_20907_20954[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20903 === (1))){
var state_20902__$1 = state_20902;
var statearr_20908_20955 = state_20902__$1;
(statearr_20908_20955[(2)] = null);

(statearr_20908_20955[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20903 === (24))){
var inst_20862 = (state_20902[(7)]);
var inst_20861 = (state_20902[(10)]);
var inst_20845 = (state_20902[(9)]);
var inst_20882 = fluree.db.query.analytical.inner_join.call(null,inst_20845,inst_20861);
var inst_20844 = inst_20862;
var inst_20845__$1 = inst_20882;
var state_20902__$1 = (function (){var statearr_20909 = state_20902;
(statearr_20909[(8)] = inst_20844);

(statearr_20909[(9)] = inst_20845__$1);

return statearr_20909;
})();
var statearr_20910_20956 = state_20902__$1;
(statearr_20910_20956[(2)] = null);

(statearr_20910_20956[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20903 === (4))){
var inst_20823 = (state_20902[(2)]);
var state_20902__$1 = state_20902;
var statearr_20912_20957 = state_20902__$1;
(statearr_20912_20957[(2)] = inst_20823);

(statearr_20912_20957[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20903 === (15))){
var inst_20861 = (state_20902[(10)]);
var state_20902__$1 = state_20902;
if(cljs.core.truth_(inst_20861)){
var statearr_20913_20958 = state_20902__$1;
(statearr_20913_20958[(1)] = (18));

} else {
var statearr_20914_20959 = state_20902__$1;
(statearr_20914_20959[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20903 === (21))){
var inst_20862 = (state_20902[(7)]);
var inst_20845 = (state_20902[(9)]);
var tmp20911 = inst_20845;
var inst_20844 = inst_20862;
var inst_20845__$1 = tmp20911;
var state_20902__$1 = (function (){var statearr_20915 = state_20902;
(statearr_20915[(8)] = inst_20844);

(statearr_20915[(9)] = inst_20845__$1);

return statearr_20915;
})();
var statearr_20916_20960 = state_20902__$1;
(statearr_20916_20960[(2)] = null);

(statearr_20916_20960[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20903 === (13))){
var inst_20845 = (state_20902[(9)]);
var inst_20868 = cljs.core.dissoc.call(null,inst_20845,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_20869 = cljs.core.empty_QMARK_.call(null,inst_20868);
var state_20902__$1 = state_20902;
if(inst_20869){
var statearr_20917_20961 = state_20902__$1;
(statearr_20917_20961[(1)] = (15));

} else {
var statearr_20918_20962 = state_20902__$1;
(statearr_20918_20962[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20903 === (22))){
var state_20902__$1 = state_20902;
var statearr_20919_20963 = state_20902__$1;
(statearr_20919_20963[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20903 === (6))){
var inst_20844 = (state_20902[(8)]);
var inst_20851 = (state_20902[(11)]);
var inst_20850 = cljs.core.seq.call(null,inst_20844);
var inst_20851__$1 = cljs.core.first.call(null,inst_20850);
var inst_20852 = cljs.core.next.call(null,inst_20850);
var state_20902__$1 = (function (){var statearr_20921 = state_20902;
(statearr_20921[(11)] = inst_20851__$1);

(statearr_20921[(12)] = inst_20852);

return statearr_20921;
})();
if(cljs.core.truth_(inst_20851__$1)){
var statearr_20922_20964 = state_20902__$1;
(statearr_20922_20964[(1)] = (8));

} else {
var statearr_20923_20965 = state_20902__$1;
(statearr_20923_20965[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20903 === (25))){
var state_20902__$1 = state_20902;
var statearr_20924_20966 = state_20902__$1;
(statearr_20924_20966[(2)] = null);

(statearr_20924_20966[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20903 === (17))){
var inst_20890 = (state_20902[(2)]);
var state_20902__$1 = state_20902;
var statearr_20925_20967 = state_20902__$1;
(statearr_20925_20967[(2)] = inst_20890);

(statearr_20925_20967[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20903 === (3))){
var inst_20900 = (state_20902[(2)]);
var state_20902__$1 = state_20902;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20902__$1,inst_20900);
} else {
if((state_val_20903 === (12))){
var inst_20862 = (state_20902[(7)]);
var inst_20861 = (state_20902[(10)]);
var inst_20844 = inst_20862;
var inst_20845 = inst_20861;
var state_20902__$1 = (function (){var statearr_20926 = state_20902;
(statearr_20926[(8)] = inst_20844);

(statearr_20926[(9)] = inst_20845);

return statearr_20926;
})();
var statearr_20927_20968 = state_20902__$1;
(statearr_20927_20968[(2)] = null);

(statearr_20927_20968[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20903 === (2))){
var _ = (function (){var statearr_20928 = state_20902;
(statearr_20928[(4)] = cljs.core.cons.call(null,(5),(state_20902[(4)])));

return statearr_20928;
})();
var inst_20836 = where;
var inst_20837 = cljs.core.seq.call(null,inst_20836);
var inst_20838 = cljs.core.first.call(null,inst_20837);
var inst_20839 = cljs.core.next.call(null,inst_20837);
var inst_20840 = [new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20841 = fluree.db.query.analytical.symbolize_keys.call(null,vars);
var inst_20842 = [inst_20841];
var inst_20843 = cljs.core.PersistentHashMap.fromArrays(inst_20840,inst_20842);
var inst_20844 = inst_20836;
var inst_20845 = inst_20843;
var state_20902__$1 = (function (){var statearr_20929 = state_20902;
(statearr_20929[(8)] = inst_20844);

(statearr_20929[(13)] = inst_20839);

(statearr_20929[(14)] = inst_20838);

(statearr_20929[(9)] = inst_20845);

return statearr_20929;
})();
var statearr_20930_20969 = state_20902__$1;
(statearr_20930_20969[(2)] = null);

(statearr_20930_20969[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20903 === (23))){
var inst_20888 = (state_20902[(2)]);
var state_20902__$1 = state_20902;
var statearr_20931_20970 = state_20902__$1;
(statearr_20931_20970[(2)] = inst_20888);

(statearr_20931_20970[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20903 === (19))){
var inst_20845 = (state_20902[(9)]);
var state_20902__$1 = state_20902;
var statearr_20932_20971 = state_20902__$1;
(statearr_20932_20971[(2)] = inst_20845);

(statearr_20932_20971[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20903 === (11))){
var inst_20851 = (state_20902[(11)]);
var inst_20859 = (state_20902[(2)]);
var inst_20860 = fluree.db.util.async.throw_err.call(null,inst_20859);
var inst_20861 = cljs.core.nth.call(null,inst_20860,(0),null);
var inst_20862 = cljs.core.nth.call(null,inst_20860,(1),null);
var inst_20863 = cljs.core.count.call(null,inst_20851);
var inst_20864 = cljs.core._EQ_.call(null,(2),inst_20863);
var state_20902__$1 = (function (){var statearr_20934 = state_20902;
(statearr_20934[(7)] = inst_20862);

(statearr_20934[(10)] = inst_20861);

return statearr_20934;
})();
if(inst_20864){
var statearr_20935_20972 = state_20902__$1;
(statearr_20935_20972[(1)] = (12));

} else {
var statearr_20936_20973 = state_20902__$1;
(statearr_20936_20973[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20903 === (9))){
var inst_20845 = (state_20902[(9)]);
var state_20902__$1 = state_20902;
var statearr_20937_20974 = state_20902__$1;
(statearr_20937_20974[(2)] = inst_20845);

(statearr_20937_20974[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20903 === (5))){
var _ = (function (){var statearr_20938 = state_20902;
(statearr_20938[(4)] = cljs.core.rest.call(null,(state_20902[(4)])));

return statearr_20938;
})();
var state_20902__$1 = state_20902;
var ex20933 = (state_20902__$1[(2)]);
var statearr_20939_20975 = state_20902__$1;
(statearr_20939_20975[(5)] = ex20933);


if((ex20933 instanceof Error)){
var statearr_20940_20976 = state_20902__$1;
(statearr_20940_20976[(1)] = (4));

(statearr_20940_20976[(5)] = null);

} else {
throw ex20933;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20903 === (14))){
var inst_20892 = (state_20902[(2)]);
var state_20902__$1 = state_20902;
var statearr_20941_20977 = state_20902__$1;
(statearr_20941_20977[(2)] = inst_20892);

(statearr_20941_20977[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20903 === (26))){
var inst_20886 = (state_20902[(2)]);
var state_20902__$1 = state_20902;
var statearr_20942_20978 = state_20902__$1;
(statearr_20942_20978[(2)] = inst_20886);

(statearr_20942_20978[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20903 === (16))){
var inst_20861 = (state_20902[(10)]);
var inst_20877 = (inst_20861 == null);
var state_20902__$1 = state_20902;
if(cljs.core.truth_(inst_20877)){
var statearr_20943_20979 = state_20902__$1;
(statearr_20943_20979[(1)] = (21));

} else {
var statearr_20944_20980 = state_20902__$1;
(statearr_20944_20980[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20903 === (10))){
var inst_20895 = (state_20902[(2)]);
var state_20902__$1 = state_20902;
var statearr_20945_20981 = state_20902__$1;
(statearr_20945_20981[(2)] = inst_20895);

(statearr_20945_20981[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20903 === (18))){
var inst_20861 = (state_20902[(10)]);
var state_20902__$1 = state_20902;
var statearr_20946_20982 = state_20902__$1;
(statearr_20946_20982[(2)] = inst_20861);

(statearr_20946_20982[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20903 === (8))){
var inst_20851 = (state_20902[(11)]);
var inst_20852 = (state_20902[(12)]);
var inst_20845 = (state_20902[(9)]);
var inst_20857 = fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_20845,inst_20851,inst_20852,false,fuel,max_fuel,opts);
var state_20902__$1 = state_20902;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20902__$1,(11),inst_20857);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2468__auto__ = null;
var fluree$db$query$analytical$state_machine__2468__auto____0 = (function (){
var statearr_20947 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20947[(0)] = fluree$db$query$analytical$state_machine__2468__auto__);

(statearr_20947[(1)] = (1));

return statearr_20947;
});
var fluree$db$query$analytical$state_machine__2468__auto____1 = (function (state_20902){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_20902);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e20948){var ex__2471__auto__ = e20948;
var statearr_20949_20983 = state_20902;
(statearr_20949_20983[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_20902[(4)]))){
var statearr_20950_20984 = state_20902;
(statearr_20950_20984[(1)] = cljs.core.first.call(null,(state_20902[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20985 = state_20902;
state_20902 = G__20985;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2468__auto__ = function(state_20902){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2468__auto____1.call(this,state_20902);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2468__auto____0;
fluree$db$query$analytical$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2468__auto____1;
return fluree$db$query$analytical$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_20951 = f__2491__auto__.call(null);
(statearr_20951[(6)] = c__2490__auto__);

return statearr_20951;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_21046){
var state_val_21047 = (state_21046[(1)]);
if((state_val_21047 === (7))){
var state_21046__$1 = state_21046;
var statearr_21048_21088 = state_21046__$1;
(statearr_21048_21088[(2)] = false);

(statearr_21048_21088[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21047 === (20))){
var inst_21033 = (state_21046[(7)]);
var inst_21018 = (state_21046[(8)]);
var inst_21035 = cljs.core.pr_str.call(null,q_map);
var inst_21036 = ["The query key: filter should be included in the 'where' array. The top-level 'filter' is being deprecated. Provided: ",inst_21035].join('');
var inst_21037 = fluree.db.util.log.warn.call(null,inst_21036);
var inst_21038 = fluree.db.query.analytical.tuples__GT_filtered.call(null,inst_21033,inst_21018,null);
var state_21046__$1 = (function (){var statearr_21049 = state_21046;
(statearr_21049[(9)] = inst_21037);

return statearr_21049;
})();
var statearr_21050_21089 = state_21046__$1;
(statearr_21050_21089[(2)] = inst_21038);

(statearr_21050_21089[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21047 === (1))){
var state_21046__$1 = state_21046;
var statearr_21051_21090 = state_21046__$1;
(statearr_21051_21090[(2)] = null);

(statearr_21051_21090[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21047 === (4))){
var inst_20986 = (state_21046[(2)]);
var state_21046__$1 = state_21046;
var statearr_21052_21091 = state_21046__$1;
(statearr_21052_21091[(2)] = inst_20986);

(statearr_21052_21091[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21047 === (15))){
var inst_21017 = (state_21046[(10)]);
var inst_21021 = (state_21046[(2)]);
var inst_21022 = fluree.db.util.async.throw_err.call(null,inst_21021);
var state_21046__$1 = (function (){var statearr_21053 = state_21046;
(statearr_21053[(11)] = inst_21022);

return statearr_21053;
})();
if(cljs.core.truth_(inst_21017)){
var statearr_21054_21092 = state_21046__$1;
(statearr_21054_21092[(1)] = (16));

} else {
var statearr_21055_21093 = state_21046__$1;
(statearr_21055_21093[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21047 === (21))){
var inst_21033 = (state_21046[(7)]);
var state_21046__$1 = state_21046;
var statearr_21056_21094 = state_21046__$1;
(statearr_21056_21094[(2)] = inst_21033);

(statearr_21056_21094[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21047 === (13))){
var inst_20993 = (state_21046[(12)]);
var state_21046__$1 = state_21046;
var statearr_21057_21095 = state_21046__$1;
(statearr_21057_21095[(2)] = inst_20993);

(statearr_21057_21095[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21047 === (22))){
var inst_21041 = (state_21046[(2)]);
var _ = (function (){var statearr_21058 = state_21046;
(statearr_21058[(4)] = cljs.core.rest.call(null,(state_21046[(4)])));

return statearr_21058;
})();
var state_21046__$1 = state_21046;
var statearr_21059_21096 = state_21046__$1;
(statearr_21059_21096[(2)] = inst_21041);

(statearr_21059_21096[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21047 === (6))){
var inst_20993 = (state_21046[(12)]);
var inst_20998 = inst_20993.cljs$lang$protocol_mask$partition0$;
var inst_20999 = (inst_20998 & (64));
var inst_21000 = inst_20993.cljs$core$ISeq$;
var inst_21001 = (cljs.core.PROTOCOL_SENTINEL === inst_21000);
var inst_21002 = ((inst_20999) || (inst_21001));
var state_21046__$1 = state_21046;
if(cljs.core.truth_(inst_21002)){
var statearr_21060_21097 = state_21046__$1;
(statearr_21060_21097[(1)] = (9));

} else {
var statearr_21061_21098 = state_21046__$1;
(statearr_21061_21098[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21047 === (17))){
var inst_21022 = (state_21046[(11)]);
var state_21046__$1 = state_21046;
var statearr_21062_21099 = state_21046__$1;
(statearr_21062_21099[(2)] = inst_21022);

(statearr_21062_21099[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21047 === (3))){
var inst_21044 = (state_21046[(2)]);
var state_21046__$1 = state_21046;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21046__$1,inst_21044);
} else {
if((state_val_21047 === (12))){
var inst_20993 = (state_21046[(12)]);
var inst_21011 = cljs.core.apply.call(null,cljs.core.hash_map,inst_20993);
var state_21046__$1 = state_21046;
var statearr_21063_21100 = state_21046__$1;
(statearr_21063_21100[(2)] = inst_21011);

(statearr_21063_21100[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21047 === (2))){
var inst_20993 = (state_21046[(12)]);
var _ = (function (){var statearr_21064 = state_21046;
(statearr_21064[(4)] = cljs.core.cons.call(null,(5),(state_21046[(4)])));

return statearr_21064;
})();
var inst_20993__$1 = q_map;
var inst_20995 = (inst_20993__$1 == null);
var inst_20996 = cljs.core.not.call(null,inst_20995);
var state_21046__$1 = (function (){var statearr_21065 = state_21046;
(statearr_21065[(12)] = inst_20993__$1);

return statearr_21065;
})();
if(inst_20996){
var statearr_21066_21101 = state_21046__$1;
(statearr_21066_21101[(1)] = (6));

} else {
var statearr_21067_21102 = state_21046__$1;
(statearr_21067_21102[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21047 === (19))){
var inst_21029 = (state_21046[(2)]);
var inst_21030 = fluree.db.util.async.throw_err.call(null,inst_21029);
var state_21046__$1 = state_21046;
var statearr_21068_21103 = state_21046__$1;
(statearr_21068_21103[(2)] = inst_21030);

(statearr_21068_21103[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21047 === (11))){
var inst_21006 = (state_21046[(2)]);
var state_21046__$1 = state_21046;
var statearr_21070_21104 = state_21046__$1;
(statearr_21070_21104[(2)] = inst_21006);

(statearr_21070_21104[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21047 === (9))){
var state_21046__$1 = state_21046;
var statearr_21071_21105 = state_21046__$1;
(statearr_21071_21105[(2)] = true);

(statearr_21071_21105[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21047 === (5))){
var _ = (function (){var statearr_21072 = state_21046;
(statearr_21072[(4)] = cljs.core.rest.call(null,(state_21046[(4)])));

return statearr_21072;
})();
var state_21046__$1 = state_21046;
var ex21069 = (state_21046__$1[(2)]);
var statearr_21073_21106 = state_21046__$1;
(statearr_21073_21106[(5)] = ex21069);


if((ex21069 instanceof Error)){
var statearr_21074_21107 = state_21046__$1;
(statearr_21074_21107[(1)] = (4));

(statearr_21074_21107[(5)] = null);

} else {
throw ex21069;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21047 === (14))){
var inst_21014 = (state_21046[(2)]);
var inst_21015 = cljs.core.get.call(null,inst_21014,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_21016 = cljs.core.get.call(null,inst_21014,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_21017 = cljs.core.get.call(null,inst_21014,new cljs.core.Keyword(null,"optional","optional",2053951509));
var inst_21018 = cljs.core.get.call(null,inst_21014,new cljs.core.Keyword(null,"filter","filter",-948537934));
var inst_21019 = fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_21016,q_map,inst_21015,fuel,max_fuel,opts);
var state_21046__$1 = (function (){var statearr_21075 = state_21046;
(statearr_21075[(10)] = inst_21017);

(statearr_21075[(8)] = inst_21018);

return statearr_21075;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21046__$1,(15),inst_21019);
} else {
if((state_val_21047 === (16))){
var inst_21017 = (state_21046[(10)]);
var inst_21022 = (state_21046[(11)]);
var inst_21024 = cljs.core.pr_str.call(null,q_map);
var inst_21025 = ["The query key: optional should be included in the 'where' array. The top-level 'optional' is being deprecated. Provided: ",inst_21024].join('');
var inst_21026 = fluree.db.util.log.warn.call(null,inst_21025);
var inst_21027 = fluree.db.query.analytical.optional__GT_left_outer_joins.call(null,db,q_map,inst_21017,inst_21022,fuel,max_fuel,opts);
var state_21046__$1 = (function (){var statearr_21076 = state_21046;
(statearr_21076[(13)] = inst_21026);

return statearr_21076;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21046__$1,(19),inst_21027);
} else {
if((state_val_21047 === (10))){
var state_21046__$1 = state_21046;
var statearr_21077_21108 = state_21046__$1;
(statearr_21077_21108[(2)] = false);

(statearr_21077_21108[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21047 === (18))){
var inst_21018 = (state_21046[(8)]);
var inst_21033 = (state_21046[(2)]);
var state_21046__$1 = (function (){var statearr_21078 = state_21046;
(statearr_21078[(7)] = inst_21033);

return statearr_21078;
})();
if(cljs.core.truth_(inst_21018)){
var statearr_21079_21109 = state_21046__$1;
(statearr_21079_21109[(1)] = (20));

} else {
var statearr_21080_21110 = state_21046__$1;
(statearr_21080_21110[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21047 === (8))){
var inst_21009 = (state_21046[(2)]);
var state_21046__$1 = state_21046;
if(cljs.core.truth_(inst_21009)){
var statearr_21081_21111 = state_21046__$1;
(statearr_21081_21111[(1)] = (12));

} else {
var statearr_21082_21112 = state_21046__$1;
(statearr_21082_21112[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__2468__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__2468__auto____0 = (function (){
var statearr_21083 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21083[(0)] = fluree$db$query$analytical$q_$_state_machine__2468__auto__);

(statearr_21083[(1)] = (1));

return statearr_21083;
});
var fluree$db$query$analytical$q_$_state_machine__2468__auto____1 = (function (state_21046){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_21046);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e21084){var ex__2471__auto__ = e21084;
var statearr_21085_21113 = state_21046;
(statearr_21085_21113[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_21046[(4)]))){
var statearr_21086_21114 = state_21046;
(statearr_21086_21114[(1)] = cljs.core.first.call(null,(state_21046[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21115 = state_21046;
state_21046 = G__21115;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__2468__auto__ = function(state_21046){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__2468__auto____1.call(this,state_21046);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__2468__auto____0;
fluree$db$query$analytical$q_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__2468__auto____1;
return fluree$db$query$analytical$q_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_21087 = f__2491__auto__.call(null);
(statearr_21087[(6)] = c__2490__auto__);

return statearr_21087;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});

//# sourceMappingURL=analytical.js.map
