// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('cljs.compiler');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.tools.reader');
goog.require('cljs.env');
goog.require('cljs.analyzer');
goog.require('cljs.source_map');
goog.require('goog.string.StringBuffer');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.call(null,cljs.core.mapcat.call(null,(function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.call(null,clojure.string.replace.call(null,cljs.core.name.call(null,lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ecmascript5","ecmascript5",342717552),new cljs.core.Keyword(null,"ecmascript5-strict","ecmascript5-strict",888234811),new cljs.core.Keyword(null,"ecmascript6","ecmascript6",723864898),new cljs.core.Keyword(null,"ecmascript6-strict","ecmascript6-strict",-786049555),new cljs.core.Keyword(null,"ecmascript-2015","ecmascript-2015",-902254444),new cljs.core.Keyword(null,"ecmascript6-typed","ecmascript6-typed",-1978203054),new cljs.core.Keyword(null,"ecmascript-2016","ecmascript-2016",471574729),new cljs.core.Keyword(null,"ecmascript-2017","ecmascript-2017",620145058),new cljs.core.Keyword(null,"ecmascript-next","ecmascript-next",-1935155962)], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.call(null,ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv.call(null,(function (xs,ns,_){
if(cljs.core._EQ_.call(null,needle,cljs.compiler.get_first_ns_segment.call(null,ns))){
return cljs.core.reduced.call(null,needle);
} else {
return null;
}
}),null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__3545 = s;
var map__3545__$1 = (((((!((map__3545 == null))))?(((((map__3545.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3545.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3545):map__3545);
var name = cljs.core.get.call(null,map__3545__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.call(null,map__3545__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var d = (0);
var G__3548 = info;
var map__3549 = G__3548;
var map__3549__$1 = (((((!((map__3549 == null))))?(((((map__3549.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3549.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3549):map__3549);
var shadow = cljs.core.get.call(null,map__3549__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
var d__$1 = d;
var G__3548__$1 = G__3548;
while(true){
var d__$2 = d__$1;
var map__3553 = G__3548__$1;
var map__3553__$1 = (((((!((map__3553 == null))))?(((((map__3553.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3553.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3553):map__3553);
var shadow__$1 = cljs.core.get.call(null,map__3553__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
if(cljs.core.truth_(shadow__$1)){
var G__3555 = (d__$2 + (1));
var G__3556 = shadow__$1;
d__$1 = G__3555;
G__3548__$1 = G__3556;
continue;
} else {
if(cljs.core.truth_(cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine.call(null,cljs.core._hash.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s)),cljs.compiler.shadow_depth.call(null,s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__3557){
var map__3558 = p__3557;
var map__3558__$1 = (((((!((map__3558 == null))))?(((((map__3558.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3558.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3558):map__3558);
var name_var = map__3558__$1;
var name = cljs.core.get.call(null,map__3558__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.call(null,map__3558__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var name__$1 = clojure.string.replace.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__3560 = info;
var map__3560__$1 = (((((!((map__3560 == null))))?(((((map__3560.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3560.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3560):map__3560);
var ns = cljs.core.get.call(null,map__3560__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var fn_scope = cljs.core.get.call(null,map__3560__$1,new cljs.core.Keyword(null,"fn-scope","fn-scope",-865664859));
var scoped_name = cljs.core.apply.call(null,cljs.core.str,cljs.core.interpose.call(null,"_$_",cljs.core.concat.call(null,cljs.core.map.call(null,cljs.core.comp.call(null,cljs.core.str,new cljs.core.Keyword(null,"name","name",1843675177)),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.call(null,cljs.compiler.munge.call(null,[clojure.string.replace.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('')));
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.call(null,reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__3563 = arguments.length;
switch (G__3563) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.call(null,s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.cljs_map_QMARK_.call(null,s)){
var name_var = s;
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(name_var);
var field = new cljs.core.Keyword(null,"field","field",-1302436500).cljs$core$IFn$_invoke$arity$1(name_var);
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(name_var);
if((!((new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531).cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name.call(null,s);
} else {
var depth = cljs.compiler.shadow_depth.call(null,s);
var code = cljs.compiler.hash_scope.call(null,s);
var renamed = cljs.core.get.call(null,cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.call(null,name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace.call(null,ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved.call(null,reserved);
var ss__$2 = cljs.core.map.call(null,rf,clojure.string.split.call(null,ss__$1,/\./));
var ss__$3 = clojure.string.join.call(null,".",ss__$2);
var ms = new cljs.core.Var(function(){return cljs.core.munge_str;},new cljs.core.Symbol("cljs.core","munge-str","cljs.core/munge-str",-301346665,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[true,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"munge-str","munge-str",-2042069652,null),"cljs/core.cljs",(25),(1),(11501),(11501),new cljs.core.Symbol(null,"string","string",-349010059,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null)], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)])).call(null,ss__$3);
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.call(null,ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.call(null,",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__3565 = cp;
switch (G__3565) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.call(null,"0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__3567_3571 = cljs.core.seq.call(null,s);
var chunk__3568_3572 = null;
var count__3569_3573 = (0);
var i__3570_3574 = (0);
while(true){
if((i__3570_3574 < count__3569_3573)){
var c_3575 = cljs.core._nth.call(null,chunk__3568_3572,i__3570_3574);
sb.append(cljs.compiler.escape_char.call(null,c_3575));


var G__3576 = seq__3567_3571;
var G__3577 = chunk__3568_3572;
var G__3578 = count__3569_3573;
var G__3579 = (i__3570_3574 + (1));
seq__3567_3571 = G__3576;
chunk__3568_3572 = G__3577;
count__3569_3573 = G__3578;
i__3570_3574 = G__3579;
continue;
} else {
var temp__5735__auto___3580 = cljs.core.seq.call(null,seq__3567_3571);
if(temp__5735__auto___3580){
var seq__3567_3581__$1 = temp__5735__auto___3580;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__3567_3581__$1)){
var c__4556__auto___3582 = cljs.core.chunk_first.call(null,seq__3567_3581__$1);
var G__3583 = cljs.core.chunk_rest.call(null,seq__3567_3581__$1);
var G__3584 = c__4556__auto___3582;
var G__3585 = cljs.core.count.call(null,c__4556__auto___3582);
var G__3586 = (0);
seq__3567_3571 = G__3583;
chunk__3568_3572 = G__3584;
count__3569_3573 = G__3585;
i__3570_3574 = G__3586;
continue;
} else {
var c_3587 = cljs.core.first.call(null,seq__3567_3581__$1);
sb.append(cljs.compiler.escape_char.call(null,c_3587));


var G__3588 = cljs.core.next.call(null,seq__3567_3581__$1);
var G__3589 = null;
var G__3590 = (0);
var G__3591 = (0);
seq__3567_3571 = G__3588;
chunk__3568_3572 = G__3589;
count__3569_3573 = G__3590;
i__3570_3574 = G__3591;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__4619__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4620__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4621__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4622__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4623__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"cljs.compiler","emit*"),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4623__auto__,method_table__4619__auto__,prefer_table__4620__auto__,method_cache__4621__auto__,cached_hierarchy__4622__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__3592_3597 = ast;
var map__3592_3598__$1 = (((((!((map__3592_3597 == null))))?(((((map__3592_3597.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3592_3597.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3592_3597):map__3592_3597);
var env_3599 = cljs.core.get.call(null,map__3592_3598__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.truth_(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(env_3599))){
var map__3594_3600 = env_3599;
var map__3594_3601__$1 = (((((!((map__3594_3600 == null))))?(((((map__3594_3600.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3594_3600.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3594_3600):map__3594_3600);
var line_3602 = cljs.core.get.call(null,map__3594_3601__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_3603 = cljs.core.get.call(null,map__3594_3601__$1,new cljs.core.Keyword(null,"column","column",2078222095));
cljs.core.swap_BANG_.call(null,cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__3596 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gcol","gcol",309250807),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"gline","gline",-1086242431),new cljs.core.Keyword(null,"gen-line","gen-line",589592125).cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"binding","binding",539932593),null,new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null).call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(ast)))){
return cljs.core.assoc.call(null,G__3596,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__3596;
}
})();
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"source-map","source-map",1706252311),(line_3602 - (1))], null),cljs.core.fnil.call(null,(function (line__$1){
return cljs.core.update_in.call(null,line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_3603)?(column_3603 - (1)):(0))], null),cljs.core.fnil.call(null,(function (column__$1){
return cljs.core.conj.call(null,column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map.call(null)));
}));
} else {
}
} else {
}

return cljs.compiler.emit_STAR_.call(null,ast);
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__3612 = arguments.length;
switch (G__3612) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4757__auto__ = [];
var len__4736__auto___3619 = arguments.length;
var i__4737__auto___3620 = (0);
while(true){
if((i__4737__auto___3620 < len__4736__auto___3619)){
args_arr__4757__auto__.push((arguments[i__4737__auto___3620]));

var G__3621 = (i__4737__auto___3620 + (1));
i__4737__auto___3620 = G__3621;
continue;
} else {
}
break;
}

var argseq__4758__auto__ = (new cljs.core.IndexedSeq(args_arr__4757__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4758__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.cljs_map_QMARK_.call(null,a)){
cljs.compiler.emit.call(null,a);
} else {
if(cljs.analyzer.cljs_seq_QMARK_.call(null,a)){
cljs.core.apply.call(null,cljs.compiler.emits,a);
} else {
if(goog.isFunction(a)){
a.call(null);
} else {
var s_3622 = (function (){var G__3613 = a;
if((!(typeof a === 'string'))){
return G__3613.toString();
} else {
return G__3613;
}
})();
var temp__5739__auto___3623 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5739__auto___3623 == null)){
} else {
var sm_data_3624 = temp__5739__auto___3623;
cljs.core.swap_BANG_.call(null,sm_data_3624,cljs.core.update,new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(function (p1__3604_SHARP_){
return (p1__3604_SHARP_ + s_3622.length);
}));
}

cljs.core.print.call(null,s_3622);

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.call(null,a);

return cljs.compiler.emits.call(null,b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

return cljs.compiler.emits.call(null,c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

return cljs.compiler.emits.call(null,d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

return cljs.compiler.emits.call(null,e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

cljs.compiler.emits.call(null,e);

var seq__3614 = cljs.core.seq.call(null,xs);
var chunk__3615 = null;
var count__3616 = (0);
var i__3617 = (0);
while(true){
if((i__3617 < count__3616)){
var x = cljs.core._nth.call(null,chunk__3615,i__3617);
cljs.compiler.emits.call(null,x);


var G__3625 = seq__3614;
var G__3626 = chunk__3615;
var G__3627 = count__3616;
var G__3628 = (i__3617 + (1));
seq__3614 = G__3625;
chunk__3615 = G__3626;
count__3616 = G__3627;
i__3617 = G__3628;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__3614);
if(temp__5735__auto__){
var seq__3614__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__3614__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__3614__$1);
var G__3629 = cljs.core.chunk_rest.call(null,seq__3614__$1);
var G__3630 = c__4556__auto__;
var G__3631 = cljs.core.count.call(null,c__4556__auto__);
var G__3632 = (0);
seq__3614 = G__3629;
chunk__3615 = G__3630;
count__3616 = G__3631;
i__3617 = G__3632;
continue;
} else {
var x = cljs.core.first.call(null,seq__3614__$1);
cljs.compiler.emits.call(null,x);


var G__3633 = cljs.core.next.call(null,seq__3614__$1);
var G__3634 = null;
var G__3635 = (0);
var G__3636 = (0);
seq__3614 = G__3633;
chunk__3615 = G__3634;
count__3616 = G__3635;
i__3617 = G__3636;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq3606){
var G__3607 = cljs.core.first.call(null,seq3606);
var seq3606__$1 = cljs.core.next.call(null,seq3606);
var G__3608 = cljs.core.first.call(null,seq3606__$1);
var seq3606__$2 = cljs.core.next.call(null,seq3606__$1);
var G__3609 = cljs.core.first.call(null,seq3606__$2);
var seq3606__$3 = cljs.core.next.call(null,seq3606__$2);
var G__3610 = cljs.core.first.call(null,seq3606__$3);
var seq3606__$4 = cljs.core.next.call(null,seq3606__$3);
var G__3611 = cljs.core.first.call(null,seq3606__$4);
var seq3606__$5 = cljs.core.next.call(null,seq3606__$4);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3607,G__3608,G__3609,G__3610,G__3611,seq3606__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.call(null);

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.call(null,cljs.compiler._STAR_source_map_data_STAR_,(function (p__3637){
var map__3638 = p__3637;
var map__3638__$1 = (((((!((map__3638 == null))))?(((((map__3638.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3638.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3638):map__3638);
var m = map__3638__$1;
var gen_line = cljs.core.get.call(null,map__3638__$1,new cljs.core.Keyword(null,"gen-line","gen-line",589592125));
return cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"gen-line","gen-line",589592125),(gen_line + (1)),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__3647 = arguments.length;
switch (G__3647) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4757__auto__ = [];
var len__4736__auto___3653 = arguments.length;
var i__4737__auto___3654 = (0);
while(true){
if((i__4737__auto___3654 < len__4736__auto___3653)){
args_arr__4757__auto__.push((arguments[i__4737__auto___3654]));

var G__3655 = (i__4737__auto___3654 + (1));
i__4737__auto___3654 = G__3655;
continue;
} else {
}
break;
}

var argseq__4758__auto__ = (new cljs.core.IndexedSeq(args_arr__4757__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4758__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.call(null,a);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

cljs.compiler.emits.call(null,e);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

cljs.compiler.emits.call(null,e);

var seq__3648_3656 = cljs.core.seq.call(null,xs);
var chunk__3649_3657 = null;
var count__3650_3658 = (0);
var i__3651_3659 = (0);
while(true){
if((i__3651_3659 < count__3650_3658)){
var x_3660 = cljs.core._nth.call(null,chunk__3649_3657,i__3651_3659);
cljs.compiler.emits.call(null,x_3660);


var G__3661 = seq__3648_3656;
var G__3662 = chunk__3649_3657;
var G__3663 = count__3650_3658;
var G__3664 = (i__3651_3659 + (1));
seq__3648_3656 = G__3661;
chunk__3649_3657 = G__3662;
count__3650_3658 = G__3663;
i__3651_3659 = G__3664;
continue;
} else {
var temp__5735__auto___3665 = cljs.core.seq.call(null,seq__3648_3656);
if(temp__5735__auto___3665){
var seq__3648_3666__$1 = temp__5735__auto___3665;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__3648_3666__$1)){
var c__4556__auto___3667 = cljs.core.chunk_first.call(null,seq__3648_3666__$1);
var G__3668 = cljs.core.chunk_rest.call(null,seq__3648_3666__$1);
var G__3669 = c__4556__auto___3667;
var G__3670 = cljs.core.count.call(null,c__4556__auto___3667);
var G__3671 = (0);
seq__3648_3656 = G__3668;
chunk__3649_3657 = G__3669;
count__3650_3658 = G__3670;
i__3651_3659 = G__3671;
continue;
} else {
var x_3672 = cljs.core.first.call(null,seq__3648_3666__$1);
cljs.compiler.emits.call(null,x_3672);


var G__3673 = cljs.core.next.call(null,seq__3648_3666__$1);
var G__3674 = null;
var G__3675 = (0);
var G__3676 = (0);
seq__3648_3656 = G__3673;
chunk__3649_3657 = G__3674;
count__3650_3658 = G__3675;
i__3651_3659 = G__3676;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln.call(null);
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq3641){
var G__3642 = cljs.core.first.call(null,seq3641);
var seq3641__$1 = cljs.core.next.call(null,seq3641);
var G__3643 = cljs.core.first.call(null,seq3641__$1);
var seq3641__$2 = cljs.core.next.call(null,seq3641__$1);
var G__3644 = cljs.core.first.call(null,seq3641__$2);
var seq3641__$3 = cljs.core.next.call(null,seq3641__$2);
var G__3645 = cljs.core.first.call(null,seq3641__$3);
var seq3641__$4 = cljs.core.next.call(null,seq3641__$3);
var G__3646 = cljs.core.first.call(null,seq3641__$4);
var seq3641__$5 = cljs.core.next.call(null,seq3641__$4);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3642,G__3643,G__3644,G__3645,G__3646,seq3641__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__4667__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__3677_3681 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__3678_3682 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__3679_3683 = true;
var _STAR_print_fn_STAR__temp_val__3680_3684 = (function (x__4668__auto__){
return sb__4667__auto__.append(x__4668__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__3679_3683);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__3680_3684);

try{cljs.compiler.emit.call(null,expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__3678_3682);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__3677_3681);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4667__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__4619__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4620__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4621__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4622__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4623__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"cljs.compiler","emit-constant*"),cljs.core.type,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4623__auto__,method_table__4619__auto__,prefer_table__4620__auto__,method_cache__4621__auto__,cached_hierarchy__4622__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.call(null,cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.cljs_seq_QMARK_.call(null,x)){
return cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep);
} else {
if(cljs.core.record_QMARK_.call(null,x)){
var vec__3685 = cljs.analyzer.record_ns_PLUS_name.call(null,x);
var ns = cljs.core.nth.call(null,vec__3685,(0),null);
var name = cljs.core.nth.call(null,vec__3685,(1),null);
return cljs.compiler.emit_record_value.call(null,ns,name,(function (){
return cljs.compiler.emit_constant.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,x));
}));
} else {
if(cljs.analyzer.cljs_map_QMARK_.call(null,x)){
return cljs.compiler.emit_map.call(null,cljs.core.keys.call(null,x),cljs.core.vals.call(null,x),cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_);
} else {
if(cljs.analyzer.cljs_vector_QMARK_.call(null,x)){
return cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep);
} else {
if(cljs.analyzer.cljs_set_QMARK_.call(null,x)){
return cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_);
} else {
return cljs.compiler.emit_constant_STAR_.call(null,x);

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta.call(null,cljs.core.meta.call(null,v));
if((!((cljs.core.seq.call(null,m) == null)))){
return cljs.compiler.emit_with_meta.call(null,(function (){
return cljs.compiler.emit_constant_no_meta.call(null,v);
}),(function (){
return cljs.compiler.emit_constant_no_meta.call(null,m);
}));
} else {
return cljs.compiler.emit_constant_no_meta.call(null,v);
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,new cljs.core.Keyword(null,"default","default",-1987822328),(function (x){
throw cljs.core.ex_info.call(null,["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.call(null,cljs.core.type.call(null,x))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"constant","constant",-379609303),x,new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.type.call(null,x),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,null,(function (x){
return cljs.compiler.emits.call(null,"null");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.call(null,"NaN");
} else {
if(cljs.core.not.call(null,isFinite(x))){
return cljs.compiler.emits.call(null,(((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.call(null,"(",x,")");

}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,String,(function (x){
return cljs.compiler.emits.call(null,cljs.compiler.wrap_in_double_quotes.call(null,cljs.compiler.escape_string.call(null,x)));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,Boolean,(function (x){
return cljs.compiler.emits.call(null,(cljs.core.truth_(x)?"true":"false"));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,RegExp,(function (x){
if(cljs.core._EQ_.call(null,"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.call(null,"(new RegExp(\"\"))");
} else {
var vec__3688 = cljs.core.re_find.call(null,/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.call(null,vec__3688,(0),null);
var flags = cljs.core.nth.call(null,vec__3688,(1),null);
var pattern = cljs.core.nth.call(null,vec__3688,(2),null);
return cljs.compiler.emits.call(null,pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace.call(null,kw);
var name = cljs.core.name.call(null,kw);
cljs.compiler.emits.call(null,"new cljs.core.Keyword(");

cljs.compiler.emit_constant.call(null,ns);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,name);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,(cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,cljs.core.hash.call(null,kw));

return cljs.compiler.emits.call(null,")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace.call(null,sym);
var name = cljs.core.name.call(null,sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.call(null,"new cljs.core.Symbol(");

cljs.compiler.emit_constant.call(null,ns);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,name);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,symstr);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,cljs.core.hash.call(null,sym));

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,null);

return cljs.compiler.emits.call(null,")");
});
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,cljs.core.Keyword,(function (x){
var temp__5733__auto__ = (function (){var and__4115__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4115__auto__)){
return x.call(null,new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.call(null,"cljs.core.",value);
} else {
return cljs.compiler.emits_keyword.call(null,x);
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,cljs.core.Symbol,(function (x){
var temp__5733__auto__ = (function (){var and__4115__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4115__auto__)){
return x.call(null,new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.call(null,"cljs.core.",value);
} else {
return cljs.compiler.emits_symbol.call(null,x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.call(null,cljs.core.map_indexed.call(null,(function (i,m){
if(cljs.core.even_QMARK_.call(null,i)){
return cljs.compiler.emit_constant.call(null,m);
} else {
return cljs.compiler.emits.call(null,m);
}
}),cljs.compiler.comma_sep.call(null,cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,Date,(function (date){
return cljs.compiler.emits.call(null,"new Date(",date.getTime(),")");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.call(null,"new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash.call(null,uuid_str),")");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_.call(null,items)){
return cljs.compiler.emit_js_object.call(null,items,(function (p1__3691_SHARP_){
return (function (){
return cljs.compiler.emit_constant.call(null,p1__3691_SHARP_);
});
}));
} else {
return cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep);
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"no-op","no-op",-93046065),(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__3693){
var map__3694 = p__3693;
var map__3694__$1 = (((((!((map__3694 == null))))?(((((map__3694.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3694.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3694):map__3694);
var ast = map__3694__$1;
var info = cljs.core.get.call(null,map__3694__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var env = cljs.core.get.call(null,map__3694__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var form = cljs.core.get.call(null,map__3694__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var temp__5733__auto__ = new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292).cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5733__auto__)){
var const_expr = temp__5733__auto__;
return cljs.compiler.emit.call(null,cljs.core.assoc.call(null,const_expr,new cljs.core.Keyword(null,"env","env",-1815813235),env));
} else {
var map__3696 = cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_);
var map__3696__$1 = (((((!((map__3696 == null))))?(((((map__3696.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3696.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3696):map__3696);
var cenv = map__3696__$1;
var options = cljs.core.get.call(null,map__3696__$1,new cljs.core.Keyword(null,"options","options",99638489));
var var_name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.call(null,cljs.core.namespace.call(null,var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.call(null,cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-module-index","js-module-index",2072061931),cljs.core.name.call(null,var_name),new cljs.core.Keyword(null,"name","name",1843675177)], null));
var or__4126__auto__ = js_module_name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.name.call(null,var_name);
}
})():info);
if(cljs.core.truth_(new cljs.core.Keyword(null,"binding-form?","binding-form?",1728940169).cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,ast));
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__3698 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.compiler.es5_GT__EQ_.call(null,new cljs.core.Keyword(null,"language-out","language-out",334619882).cljs$core$IFn$_invoke$arity$1(options));
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.namespace.call(null,var_name) == null)));
} else {
return and__4115__auto__;
}
})())){
return clojure.set.difference.call(null,G__3698,cljs.analyzer.es5_allowed);
} else {
return G__3698;
}
})();
var js_module = cljs.core.get_in.call(null,cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-namespaces","js-namespaces",-471353612),(function (){var or__4126__auto__ = cljs.core.namespace.call(null,var_name);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.name.call(null,var_name);
}
})()], null));
var info__$2 = (function (){var G__3699 = info__$1;
if(cljs.core.not_EQ_.call(null,form,new cljs.core.Symbol("js","-Infinity","js/-Infinity",958706333,null))){
return cljs.compiler.munge.call(null,G__3699,reserved);
} else {
return G__3699;
}
})();
var env__3537__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3537__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

var G__3700_3701 = new cljs.core.Keyword(null,"module-type","module-type",1392760304).cljs$core$IFn$_invoke$arity$1(js_module);
var G__3700_3702__$1 = (((G__3700_3701 instanceof cljs.core.Keyword))?G__3700_3701.fqn:null);
switch (G__3700_3702__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace.call(null,var_name))){
cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,cljs.core.namespace.call(null,var_name),reserved),"[\"default\"].",cljs.compiler.munge.call(null,cljs.core.name.call(null,var_name),reserved));
} else {
cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,cljs.core.name.call(null,var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.core.namespace.call(null,var_name);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.call(null,"default",cljs.core.name.call(null,var_name));
} else {
return and__4115__auto__;
}
})())){
cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,cljs.core.namespace.call(null,var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.call(null,info__$2);
}

break;
default:
cljs.compiler.emits.call(null,info__$2);

}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3537__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"var","var",-769682797),(function (expr){
return cljs.compiler.emit_var.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"binding","binding",539932593),(function (expr){
return cljs.compiler.emit_var.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),(function (expr){
return cljs.compiler.emit_var.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"local","local",-1497766724),(function (expr){
return cljs.compiler.emit_var.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"the-var","the-var",1428415613),(function (p__3704){
var map__3705 = p__3704;
var map__3705__$1 = (((((!((map__3705 == null))))?(((((map__3705.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3705.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3705):map__3705);
var arg = map__3705__$1;
var env = cljs.core.get.call(null,map__3705__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var var$ = cljs.core.get.call(null,map__3705__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var sym = cljs.core.get.call(null,map__3705__$1,new cljs.core.Keyword(null,"sym","sym",-1444860305));
var meta = cljs.core.get.call(null,map__3705__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
if(cljs.analyzer.ast_QMARK_.call(null,sym)){
} else {
throw (new Error("Assert failed: (ana/ast? sym)"));
}

if(cljs.analyzer.ast_QMARK_.call(null,meta)){
} else {
throw (new Error("Assert failed: (ana/ast? meta)"));
}

var map__3707 = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(var$);
var map__3707__$1 = (((((!((map__3707 == null))))?(((((map__3707.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3707.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3707):map__3707);
var name = cljs.core.get.call(null,map__3707__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env__3537__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3537__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"new cljs.core.Var(function(){return ",cljs.compiler.munge.call(null,name),";},",sym,",",meta,")");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3537__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.call(null,"cljs.core.with_meta(",expr,",",meta,")");
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"with-meta","with-meta",-1566856820),(function (p__3709){
var map__3710 = p__3709;
var map__3710__$1 = (((((!((map__3710 == null))))?(((((map__3710.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3710.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3710):map__3710);
var expr = cljs.core.get.call(null,map__3710__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var meta = cljs.core.get.call(null,map__3710__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var env = cljs.core.get.call(null,map__3710__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__3537__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3537__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_with_meta.call(null,expr,meta);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3537__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.call(null,cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_.call(null,(function (p1__3712_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__3712_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),keys__$1)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count.call(null,keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count.call(null,keys) === (0))){
return cljs.compiler.emits.call(null,"cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count.call(null,keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_(distinct_keys_QMARK_.call(null,keys))){
return cljs.compiler.emits.call(null,"new cljs.core.PersistentArrayMap(null, ",cljs.core.count.call(null,keys),", [",comma_sep.call(null,cljs.core.interleave.call(null,keys,vals)),"], null)");
} else {
return cljs.compiler.emits.call(null,"cljs.core.PersistentArrayMap.createAsIfByAssoc([",comma_sep.call(null,cljs.core.interleave.call(null,keys,vals)),"])");
}
} else {
return cljs.compiler.emits.call(null,"cljs.core.PersistentHashMap.fromArrays([",comma_sep.call(null,keys),"],[",comma_sep.call(null,vals),"])");

}
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"map","map",1371690461),(function (p__3713){
var map__3714 = p__3713;
var map__3714__$1 = (((((!((map__3714 == null))))?(((((map__3714.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3714.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3714):map__3714);
var env = cljs.core.get.call(null,map__3714__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var keys = cljs.core.get.call(null,map__3714__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.call(null,map__3714__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env__3537__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3537__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_map.call(null,keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3537__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_.call(null,items)){
return cljs.compiler.emits.call(null,"cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.call(null,"cljs.core.list(",comma_sep.call(null,items),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_.call(null,items)){
return cljs.compiler.emits.call(null,"cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count.call(null,items);
if((cnt < (32))){
return cljs.compiler.emits.call(null,"new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",comma_sep.call(null,items),"], null)");
} else {
return cljs.compiler.emits.call(null,"cljs.core.PersistentVector.fromArray([",comma_sep.call(null,items),"], true)");
}
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"vector","vector",1902966158),(function (p__3716){
var map__3717 = p__3716;
var map__3717__$1 = (((((!((map__3717 == null))))?(((((map__3717.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3717.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3717):map__3717);
var items = cljs.core.get.call(null,map__3717__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__3717__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__3537__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3537__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_vector.call(null,items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3537__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.call(null,cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_.call(null,(function (p1__3719_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__3719_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),items__$1)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count.call(null,items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_.call(null,items)){
return cljs.compiler.emits.call(null,"cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_(distinct_constants_QMARK_.call(null,items))){
return cljs.compiler.emits.call(null,"new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count.call(null,items),", [",comma_sep.call(null,cljs.core.interleave.call(null,items,cljs.core.repeat.call(null,"null"))),"], null), null)");
} else {
return cljs.compiler.emits.call(null,"cljs.core.PersistentHashSet.createAsIfByAssoc([",comma_sep.call(null,items),"])");

}
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"set","set",304602554),(function (p__3720){
var map__3721 = p__3720;
var map__3721__$1 = (((((!((map__3721 == null))))?(((((map__3721.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3721.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3721):map__3721);
var items = cljs.core.get.call(null,map__3721__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__3721__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__3537__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3537__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_set.call(null,items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3537__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.call(null,"({");

var temp__5735__auto___3745 = cljs.core.seq.call(null,items);
if(temp__5735__auto___3745){
var items_3746__$1 = temp__5735__auto___3745;
var vec__3723_3747 = items_3746__$1;
var seq__3724_3748 = cljs.core.seq.call(null,vec__3723_3747);
var first__3725_3749 = cljs.core.first.call(null,seq__3724_3748);
var seq__3724_3750__$1 = cljs.core.next.call(null,seq__3724_3748);
var vec__3726_3751 = first__3725_3749;
var k_3752 = cljs.core.nth.call(null,vec__3726_3751,(0),null);
var v_3753 = cljs.core.nth.call(null,vec__3726_3751,(1),null);
var r_3754 = seq__3724_3750__$1;
cljs.compiler.emits.call(null,"\"",cljs.core.name.call(null,k_3752),"\": ",emit_js_object_val.call(null,v_3753));

var seq__3729_3755 = cljs.core.seq.call(null,r_3754);
var chunk__3730_3756 = null;
var count__3731_3757 = (0);
var i__3732_3758 = (0);
while(true){
if((i__3732_3758 < count__3731_3757)){
var vec__3739_3759 = cljs.core._nth.call(null,chunk__3730_3756,i__3732_3758);
var k_3760__$1 = cljs.core.nth.call(null,vec__3739_3759,(0),null);
var v_3761__$1 = cljs.core.nth.call(null,vec__3739_3759,(1),null);
cljs.compiler.emits.call(null,", \"",cljs.core.name.call(null,k_3760__$1),"\": ",emit_js_object_val.call(null,v_3761__$1));


var G__3762 = seq__3729_3755;
var G__3763 = chunk__3730_3756;
var G__3764 = count__3731_3757;
var G__3765 = (i__3732_3758 + (1));
seq__3729_3755 = G__3762;
chunk__3730_3756 = G__3763;
count__3731_3757 = G__3764;
i__3732_3758 = G__3765;
continue;
} else {
var temp__5735__auto___3766__$1 = cljs.core.seq.call(null,seq__3729_3755);
if(temp__5735__auto___3766__$1){
var seq__3729_3767__$1 = temp__5735__auto___3766__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__3729_3767__$1)){
var c__4556__auto___3768 = cljs.core.chunk_first.call(null,seq__3729_3767__$1);
var G__3769 = cljs.core.chunk_rest.call(null,seq__3729_3767__$1);
var G__3770 = c__4556__auto___3768;
var G__3771 = cljs.core.count.call(null,c__4556__auto___3768);
var G__3772 = (0);
seq__3729_3755 = G__3769;
chunk__3730_3756 = G__3770;
count__3731_3757 = G__3771;
i__3732_3758 = G__3772;
continue;
} else {
var vec__3742_3773 = cljs.core.first.call(null,seq__3729_3767__$1);
var k_3774__$1 = cljs.core.nth.call(null,vec__3742_3773,(0),null);
var v_3775__$1 = cljs.core.nth.call(null,vec__3742_3773,(1),null);
cljs.compiler.emits.call(null,", \"",cljs.core.name.call(null,k_3774__$1),"\": ",emit_js_object_val.call(null,v_3775__$1));


var G__3776 = cljs.core.next.call(null,seq__3729_3767__$1);
var G__3777 = null;
var G__3778 = (0);
var G__3779 = (0);
seq__3729_3755 = G__3776;
chunk__3730_3756 = G__3777;
count__3731_3757 = G__3778;
i__3732_3758 = G__3779;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.call(null,"})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.call(null,"[",comma_sep.call(null,items),"]");
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js-object","js-object",1830199158),(function (p__3780){
var map__3781 = p__3780;
var map__3781__$1 = (((((!((map__3781 == null))))?(((((map__3781.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3781.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3781):map__3781);
var keys = cljs.core.get.call(null,map__3781__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.call(null,map__3781__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env = cljs.core.get.call(null,map__3781__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__3537__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3537__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_js_object.call(null,cljs.core.map.call(null,cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3537__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js-array","js-array",-1210185421),(function (p__3783){
var map__3784 = p__3783;
var map__3784__$1 = (((((!((map__3784 == null))))?(((((map__3784.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3784.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3784):map__3784);
var items = cljs.core.get.call(null,map__3784__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__3784__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__3537__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3537__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_js_array.call(null,items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3537__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.call(null,ns,".map__GT_",name,"(",items,")");
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"quote","quote",-262615245),(function (p__3786){
var map__3787 = p__3786;
var map__3787__$1 = (((((!((map__3787 == null))))?(((((map__3787.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3787.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3787):map__3787);
var expr = cljs.core.get.call(null,map__3787__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
return cljs.compiler.emit.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"const","const",1709929842),(function (p__3789){
var map__3790 = p__3789;
var map__3790__$1 = (((((!((map__3790 == null))))?(((((map__3790.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3790.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3790):map__3790);
var form = cljs.core.get.call(null,map__3790__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var env = cljs.core.get.call(null,map__3790__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__3537__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3537__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_constant.call(null,form);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3537__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__3792 = cljs.analyzer.unwrap_quote.call(null,expr);
var map__3792__$1 = (((((!((map__3792 == null))))?(((((map__3792.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3792.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3792):map__3792);
var op = cljs.core.get.call(null,map__3792__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.call(null,map__3792__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.call(null,map__3792__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4126__auto__ = ((cljs.core._EQ_.call(null,op,new cljs.core.Keyword(null,"const","const",1709929842)))?(function (){var and__4115__auto__ = form;
if(cljs.core.truth_(and__4115__auto__)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.call(null,form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__4115__auto__;
}
})():false);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if((!((const_expr == null)))){
return cljs.compiler.truthy_constant_QMARK_.call(null,const_expr);
} else {
return false;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__3794 = cljs.analyzer.unwrap_quote.call(null,expr);
var map__3794__$1 = (((((!((map__3794 == null))))?(((((map__3794.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3794.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3794):map__3794);
var op = cljs.core.get.call(null,map__3794__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.call(null,map__3794__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.call(null,map__3794__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4126__auto__ = ((cljs.core._EQ_.call(null,op,new cljs.core.Keyword(null,"const","const",1709929842))) && (((form === false) || ((form == null)))));
if(or__4126__auto__){
return or__4126__auto__;
} else {
if((!((const_expr == null)))){
return cljs.compiler.falsey_constant_QMARK_.call(null,const_expr);
} else {
return false;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag.call(null,env,e);
var or__4126__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null], null), null).call(null,tag);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_.call(null,e);
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"if","if",-458814265),(function (p__3796){
var map__3797 = p__3796;
var map__3797__$1 = (((((!((map__3797 == null))))?(((((map__3797.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3797.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3797):map__3797);
var test = cljs.core.get.call(null,map__3797__$1,new cljs.core.Keyword(null,"test","test",577538877));
var then = cljs.core.get.call(null,map__3797__$1,new cljs.core.Keyword(null,"then","then",460598070));
var else$ = cljs.core.get.call(null,map__3797__$1,new cljs.core.Keyword(null,"else","else",-1508377146));
var env = cljs.core.get.call(null,map__3797__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var unchecked = cljs.core.get.call(null,map__3797__$1,new cljs.core.Keyword(null,"unchecked","unchecked",924418378));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not.call(null,(function (){var or__4126__auto__ = unchecked;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.compiler.safe_test_QMARK_.call(null,env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_.call(null,test))){
return cljs.compiler.emitln.call(null,then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_.call(null,test))){
return cljs.compiler.emitln.call(null,else$);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"(",((checked)?"cljs.core.truth_":null),"(",test,")?",then,":",else$,")");
} else {
if(checked){
cljs.compiler.emitln.call(null,"if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.call(null,"if(",test,"){");
}

cljs.compiler.emitln.call(null,then,"} else {");

return cljs.compiler.emitln.call(null,else$,"}");
}

}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"case","case",1143702196),(function (p__3799){
var map__3800 = p__3799;
var map__3800__$1 = (((((!((map__3800 == null))))?(((((map__3800.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3800.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3800):map__3800);
var v = cljs.core.get.call(null,map__3800__$1,new cljs.core.Keyword(null,"test","test",577538877));
var nodes = cljs.core.get.call(null,map__3800__$1,new cljs.core.Keyword(null,"nodes","nodes",-2099585805));
var default$ = cljs.core.get.call(null,map__3800__$1,new cljs.core.Keyword(null,"default","default",-1987822328));
var env = cljs.core.get.call(null,map__3800__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env),new cljs.core.Keyword(null,"expr","expr",745722291))){
cljs.compiler.emitln.call(null,"(function(){");
} else {
}

var gs = cljs.core.gensym.call(null,"caseval__");
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"var ",gs,";");
} else {
}

cljs.compiler.emitln.call(null,"switch (",v,") {");

var seq__3802_3838 = cljs.core.seq.call(null,nodes);
var chunk__3803_3839 = null;
var count__3804_3840 = (0);
var i__3805_3841 = (0);
while(true){
if((i__3805_3841 < count__3804_3840)){
var map__3822_3842 = cljs.core._nth.call(null,chunk__3803_3839,i__3805_3841);
var map__3822_3843__$1 = (((((!((map__3822_3842 == null))))?(((((map__3822_3842.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3822_3842.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3822_3842):map__3822_3842);
var ts_3844 = cljs.core.get.call(null,map__3822_3843__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__3823_3845 = cljs.core.get.call(null,map__3822_3843__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__3823_3846__$1 = (((((!((map__3823_3845 == null))))?(((((map__3823_3845.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3823_3845.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3823_3845):map__3823_3845);
var then_3847 = cljs.core.get.call(null,map__3823_3846__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__3826_3848 = cljs.core.seq.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"test","test",577538877),ts_3844));
var chunk__3827_3849 = null;
var count__3828_3850 = (0);
var i__3829_3851 = (0);
while(true){
if((i__3829_3851 < count__3828_3850)){
var test_3852 = cljs.core._nth.call(null,chunk__3827_3849,i__3829_3851);
cljs.compiler.emitln.call(null,"case ",test_3852,":");


var G__3853 = seq__3826_3848;
var G__3854 = chunk__3827_3849;
var G__3855 = count__3828_3850;
var G__3856 = (i__3829_3851 + (1));
seq__3826_3848 = G__3853;
chunk__3827_3849 = G__3854;
count__3828_3850 = G__3855;
i__3829_3851 = G__3856;
continue;
} else {
var temp__5735__auto___3857 = cljs.core.seq.call(null,seq__3826_3848);
if(temp__5735__auto___3857){
var seq__3826_3858__$1 = temp__5735__auto___3857;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__3826_3858__$1)){
var c__4556__auto___3859 = cljs.core.chunk_first.call(null,seq__3826_3858__$1);
var G__3860 = cljs.core.chunk_rest.call(null,seq__3826_3858__$1);
var G__3861 = c__4556__auto___3859;
var G__3862 = cljs.core.count.call(null,c__4556__auto___3859);
var G__3863 = (0);
seq__3826_3848 = G__3860;
chunk__3827_3849 = G__3861;
count__3828_3850 = G__3862;
i__3829_3851 = G__3863;
continue;
} else {
var test_3864 = cljs.core.first.call(null,seq__3826_3858__$1);
cljs.compiler.emitln.call(null,"case ",test_3864,":");


var G__3865 = cljs.core.next.call(null,seq__3826_3858__$1);
var G__3866 = null;
var G__3867 = (0);
var G__3868 = (0);
seq__3826_3848 = G__3865;
chunk__3827_3849 = G__3866;
count__3828_3850 = G__3867;
i__3829_3851 = G__3868;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",then_3847);
} else {
cljs.compiler.emitln.call(null,then_3847);
}

cljs.compiler.emitln.call(null,"break;");


var G__3869 = seq__3802_3838;
var G__3870 = chunk__3803_3839;
var G__3871 = count__3804_3840;
var G__3872 = (i__3805_3841 + (1));
seq__3802_3838 = G__3869;
chunk__3803_3839 = G__3870;
count__3804_3840 = G__3871;
i__3805_3841 = G__3872;
continue;
} else {
var temp__5735__auto___3873 = cljs.core.seq.call(null,seq__3802_3838);
if(temp__5735__auto___3873){
var seq__3802_3874__$1 = temp__5735__auto___3873;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__3802_3874__$1)){
var c__4556__auto___3875 = cljs.core.chunk_first.call(null,seq__3802_3874__$1);
var G__3876 = cljs.core.chunk_rest.call(null,seq__3802_3874__$1);
var G__3877 = c__4556__auto___3875;
var G__3878 = cljs.core.count.call(null,c__4556__auto___3875);
var G__3879 = (0);
seq__3802_3838 = G__3876;
chunk__3803_3839 = G__3877;
count__3804_3840 = G__3878;
i__3805_3841 = G__3879;
continue;
} else {
var map__3830_3880 = cljs.core.first.call(null,seq__3802_3874__$1);
var map__3830_3881__$1 = (((((!((map__3830_3880 == null))))?(((((map__3830_3880.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3830_3880.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3830_3880):map__3830_3880);
var ts_3882 = cljs.core.get.call(null,map__3830_3881__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__3831_3883 = cljs.core.get.call(null,map__3830_3881__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__3831_3884__$1 = (((((!((map__3831_3883 == null))))?(((((map__3831_3883.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3831_3883.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3831_3883):map__3831_3883);
var then_3885 = cljs.core.get.call(null,map__3831_3884__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__3834_3886 = cljs.core.seq.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"test","test",577538877),ts_3882));
var chunk__3835_3887 = null;
var count__3836_3888 = (0);
var i__3837_3889 = (0);
while(true){
if((i__3837_3889 < count__3836_3888)){
var test_3890 = cljs.core._nth.call(null,chunk__3835_3887,i__3837_3889);
cljs.compiler.emitln.call(null,"case ",test_3890,":");


var G__3891 = seq__3834_3886;
var G__3892 = chunk__3835_3887;
var G__3893 = count__3836_3888;
var G__3894 = (i__3837_3889 + (1));
seq__3834_3886 = G__3891;
chunk__3835_3887 = G__3892;
count__3836_3888 = G__3893;
i__3837_3889 = G__3894;
continue;
} else {
var temp__5735__auto___3895__$1 = cljs.core.seq.call(null,seq__3834_3886);
if(temp__5735__auto___3895__$1){
var seq__3834_3896__$1 = temp__5735__auto___3895__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__3834_3896__$1)){
var c__4556__auto___3897 = cljs.core.chunk_first.call(null,seq__3834_3896__$1);
var G__3898 = cljs.core.chunk_rest.call(null,seq__3834_3896__$1);
var G__3899 = c__4556__auto___3897;
var G__3900 = cljs.core.count.call(null,c__4556__auto___3897);
var G__3901 = (0);
seq__3834_3886 = G__3898;
chunk__3835_3887 = G__3899;
count__3836_3888 = G__3900;
i__3837_3889 = G__3901;
continue;
} else {
var test_3902 = cljs.core.first.call(null,seq__3834_3896__$1);
cljs.compiler.emitln.call(null,"case ",test_3902,":");


var G__3903 = cljs.core.next.call(null,seq__3834_3896__$1);
var G__3904 = null;
var G__3905 = (0);
var G__3906 = (0);
seq__3834_3886 = G__3903;
chunk__3835_3887 = G__3904;
count__3836_3888 = G__3905;
i__3837_3889 = G__3906;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",then_3885);
} else {
cljs.compiler.emitln.call(null,then_3885);
}

cljs.compiler.emitln.call(null,"break;");


var G__3907 = cljs.core.next.call(null,seq__3802_3874__$1);
var G__3908 = null;
var G__3909 = (0);
var G__3910 = (0);
seq__3802_3838 = G__3907;
chunk__3803_3839 = G__3908;
count__3804_3840 = G__3909;
i__3805_3841 = G__3910;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.call(null,"default:");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",default$);
} else {
cljs.compiler.emitln.call(null,default$);
}
} else {
}

cljs.compiler.emitln.call(null,"}");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.call(null,"return ",gs,";})()");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"throw","throw",-1044625833),(function (p__3911){
var map__3912 = p__3911;
var map__3912__$1 = (((((!((map__3912 == null))))?(((((map__3912.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3912.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3912):map__3912);
var throw$ = cljs.core.get.call(null,map__3912__$1,new cljs.core.Keyword(null,"exception","exception",-335277064));
var env = cljs.core.get.call(null,map__3912__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.call(null,"(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.call(null,"throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.call(null,cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.call(null,cljs.compiler.mapped_types,t))){
return cljs.core.get.call(null,cljs.compiler.mapped_types,t);
} else {
if(goog.string.startsWith(t,"!")){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.resolve_type.call(null,env,cljs.core.subs.call(null,t,(1))))].join('');
} else {
if(goog.string.startsWith(t,"{")){
return t;
} else {
if(goog.string.startsWith(t,"function")){
var idx = t.lastIndexOf(":");
var vec__3915 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.call(null,t,(0),idx),cljs.core.subs.call(null,t,(idx + (1)),cljs.core.count.call(null,t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.call(null,vec__3915,(0),null);
var rstr = cljs.core.nth.call(null,vec__3915,(1),null);
var ret_t = (cljs.core.truth_(rstr)?cljs.compiler.resolve_type.call(null,env,rstr):null);
var axstr = cljs.core.subs.call(null,fstr,(9),(cljs.core.count.call(null,fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_.call(null,axstr))?null:cljs.core.map.call(null,cljs.core.comp.call(null,(function (p1__3914_SHARP_){
return cljs.compiler.resolve_type.call(null,env,p1__3914_SHARP_);
}),clojure.string.trim),clojure.string.split.call(null,axstr,/,/)));
var G__3918 = ["function(",clojure.string.join.call(null,",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__3918,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__3918;
}
} else {
if(goog.string.endsWith(t,"=")){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.resolve_type.call(null,env,cljs.core.subs.call(null,t,(0),(cljs.core.count.call(null,t) - (1))))),"="].join('');
} else {
return cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.call(null,env,cljs.core.symbol.call(null,t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.call(null,clojure.string.trim.call(null,ts),(1),(cljs.core.count.call(null,ts) - (1)));
var xs = clojure.string.split.call(null,ts__$1,/\|/);
return ["{",clojure.string.join.call(null,"|",cljs.core.map.call(null,(function (p1__3919_SHARP_){
return cljs.compiler.resolve_type.call(null,env,p1__3919_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find.call(null,/@param/,line))){
var vec__3920 = cljs.core.map.call(null,clojure.string.trim,clojure.string.split.call(null,clojure.string.trim.call(null,line),/ /));
var seq__3921 = cljs.core.seq.call(null,vec__3920);
var first__3922 = cljs.core.first.call(null,seq__3921);
var seq__3921__$1 = cljs.core.next.call(null,seq__3921);
var p = first__3922;
var first__3922__$1 = cljs.core.first.call(null,seq__3921__$1);
var seq__3921__$2 = cljs.core.next.call(null,seq__3921__$1);
var ts = first__3922__$1;
var first__3922__$2 = cljs.core.first.call(null,seq__3921__$2);
var seq__3921__$3 = cljs.core.next.call(null,seq__3921__$2);
var n = first__3922__$2;
var xs = seq__3921__$3;
if(cljs.core.truth_(((cljs.core._EQ_.call(null,"@param",p))?(function (){var and__4115__auto__ = ts;
if(cljs.core.truth_(and__4115__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4115__auto__;
}
})():false))){
return clojure.string.join.call(null," ",cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types.call(null,env,ts),cljs.compiler.munge.call(null,n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find.call(null,/@return/,line))){
var vec__3923 = cljs.core.map.call(null,clojure.string.trim,clojure.string.split.call(null,clojure.string.trim.call(null,line),/ /));
var seq__3924 = cljs.core.seq.call(null,vec__3923);
var first__3925 = cljs.core.first.call(null,seq__3924);
var seq__3924__$1 = cljs.core.next.call(null,seq__3924);
var p = first__3925;
var first__3925__$1 = cljs.core.first.call(null,seq__3924__$1);
var seq__3924__$2 = cljs.core.next.call(null,seq__3924__$1);
var ts = first__3925__$1;
var xs = seq__3924__$2;
if(cljs.core.truth_(((cljs.core._EQ_.call(null,"@return",p))?(function (){var and__4115__auto__ = ts;
if(cljs.core.truth_(and__4115__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4115__auto__;
}
})():false))){
return clojure.string.join.call(null," ",cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types.call(null,env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"warning","warning",-1685650671),null,new cljs.core.Keyword(null,"error","error",-978969032),null], null), null).call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"closure-warnings","closure-warnings",1362834211),new cljs.core.Keyword(null,"check-types","check-types",-833794607)], null)));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__3928 = arguments.length;
switch (G__3928) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.call(null,null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.call(null,docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__3936 = cljs.core.map.call(null,(function (p1__3926_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_.call(null))){
return cljs.compiler.munge_param_return.call(null,env,p1__3926_SHARP_);
} else {
return p1__3926_SHARP_;
}
}),clojure.string.split_lines.call(null,e));
var seq__3937 = cljs.core.seq.call(null,vec__3936);
var first__3938 = cljs.core.first.call(null,seq__3937);
var seq__3937__$1 = cljs.core.next.call(null,seq__3937);
var x = first__3938;
var ys = seq__3937__$1;
cljs.compiler.emitln.call(null," * ",clojure.string.replace.call(null,x,"*/","* /"));

var seq__3939 = cljs.core.seq.call(null,ys);
var chunk__3940 = null;
var count__3941 = (0);
var i__3942 = (0);
while(true){
if((i__3942 < count__3941)){
var next_line = cljs.core._nth.call(null,chunk__3940,i__3942);
cljs.compiler.emitln.call(null," * ",clojure.string.replace.call(null,clojure.string.replace.call(null,next_line,/^   /,""),"*/","* /"));


var G__3948 = seq__3939;
var G__3949 = chunk__3940;
var G__3950 = count__3941;
var G__3951 = (i__3942 + (1));
seq__3939 = G__3948;
chunk__3940 = G__3949;
count__3941 = G__3950;
i__3942 = G__3951;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__3939);
if(temp__5735__auto__){
var seq__3939__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__3939__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__3939__$1);
var G__3952 = cljs.core.chunk_rest.call(null,seq__3939__$1);
var G__3953 = c__4556__auto__;
var G__3954 = cljs.core.count.call(null,c__4556__auto__);
var G__3955 = (0);
seq__3939 = G__3952;
chunk__3940 = G__3953;
count__3941 = G__3954;
i__3942 = G__3955;
continue;
} else {
var next_line = cljs.core.first.call(null,seq__3939__$1);
cljs.compiler.emitln.call(null," * ",clojure.string.replace.call(null,clojure.string.replace.call(null,next_line,/^   /,""),"*/","* /"));


var G__3956 = cljs.core.next.call(null,seq__3939__$1);
var G__3957 = null;
var G__3958 = (0);
var G__3959 = (0);
seq__3939 = G__3956;
chunk__3940 = G__3957;
count__3941 = G__3958;
i__3942 = G__3959;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq.call(null,docs__$2)){
cljs.compiler.emitln.call(null,"/**");

var seq__3943_3960 = cljs.core.seq.call(null,docs__$2);
var chunk__3944_3961 = null;
var count__3945_3962 = (0);
var i__3946_3963 = (0);
while(true){
if((i__3946_3963 < count__3945_3962)){
var e_3964 = cljs.core._nth.call(null,chunk__3944_3961,i__3946_3963);
if(cljs.core.truth_(e_3964)){
print_comment_lines.call(null,e_3964);
} else {
}


var G__3965 = seq__3943_3960;
var G__3966 = chunk__3944_3961;
var G__3967 = count__3945_3962;
var G__3968 = (i__3946_3963 + (1));
seq__3943_3960 = G__3965;
chunk__3944_3961 = G__3966;
count__3945_3962 = G__3967;
i__3946_3963 = G__3968;
continue;
} else {
var temp__5735__auto___3969 = cljs.core.seq.call(null,seq__3943_3960);
if(temp__5735__auto___3969){
var seq__3943_3970__$1 = temp__5735__auto___3969;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__3943_3970__$1)){
var c__4556__auto___3971 = cljs.core.chunk_first.call(null,seq__3943_3970__$1);
var G__3972 = cljs.core.chunk_rest.call(null,seq__3943_3970__$1);
var G__3973 = c__4556__auto___3971;
var G__3974 = cljs.core.count.call(null,c__4556__auto___3971);
var G__3975 = (0);
seq__3943_3960 = G__3972;
chunk__3944_3961 = G__3973;
count__3945_3962 = G__3974;
i__3946_3963 = G__3975;
continue;
} else {
var e_3976 = cljs.core.first.call(null,seq__3943_3970__$1);
if(cljs.core.truth_(e_3976)){
print_comment_lines.call(null,e_3976);
} else {
}


var G__3977 = cljs.core.next.call(null,seq__3943_3970__$1);
var G__3978 = null;
var G__3979 = (0);
var G__3980 = (0);
seq__3943_3960 = G__3977;
chunk__3944_3961 = G__3978;
count__3945_3962 = G__3979;
i__3946_3963 = G__3980;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.call(null," */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (x === true) || (x === false) || (typeof x === 'number'));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.call(null,cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_),new cljs.core.Keyword(null,"options","options",99638489));
var and__4115__auto__ = cljs.core.some.call(null,(function (p1__3982_SHARP_){
return goog.string.startsWith(p1__3982_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__4115__auto__)){
var and__4115__auto____$1 = opts;
if(cljs.core.truth_(and__4115__auto____$1)){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"none","none",1333468478))){
var define = cljs.core.get_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"closure-defines","closure-defines",-1213856476),cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_.call(null,define)){
return cljs.core.pr_str.call(null,define);
} else {
return null;
}
} else {
return false;
}
} else {
return and__4115__auto____$1;
}
} else {
return and__4115__auto__;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"def","def",-1043430536),(function (p__3983){
var map__3984 = p__3983;
var map__3984__$1 = (((((!((map__3984 == null))))?(((((map__3984.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3984.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3984):map__3984);
var doc = cljs.core.get.call(null,map__3984__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var jsdoc = cljs.core.get.call(null,map__3984__$1,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516));
var test = cljs.core.get.call(null,map__3984__$1,new cljs.core.Keyword(null,"test","test",577538877));
var goog_define = cljs.core.get.call(null,map__3984__$1,new cljs.core.Keyword(null,"goog-define","goog-define",-1048305441));
var init = cljs.core.get.call(null,map__3984__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
var name = cljs.core.get.call(null,map__3984__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.call(null,map__3984__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var export$ = cljs.core.get.call(null,map__3984__$1,new cljs.core.Keyword(null,"export","export",214356590));
var var$ = cljs.core.get.call(null,map__3984__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var var_ast = cljs.core.get.call(null,map__3984__$1,new cljs.core.Keyword(null,"var-ast","var-ast",1200379319));
if(cljs.core.truth_((function (){var or__4126__auto__ = init;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.call(null,name);
cljs.compiler.emit_comment.call(null,env,doc,cljs.core.concat.call(null,(cljs.core.truth_(goog_define)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["@define {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog_define),"}"].join('')], null):null),jsdoc,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516).cljs$core$IFn$_invoke$arity$1(init)));

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"return (");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"(function (){");
} else {
}

cljs.compiler.emits.call(null,var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.call(null," = ",(function (){var temp__5733__auto__ = cljs.compiler.get_define.call(null,mname,jsdoc);
if(cljs.core.truth_(temp__5733__auto__)){
var define = temp__5733__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"; return (");

cljs.compiler.emits.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"the-var","the-var",1428415613),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.assoc.call(null,env,new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291))], null),var_ast));

cljs.compiler.emitln.call(null,");})()");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,")");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.call(null,";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.call(null,"goog.exportSymbol('",cljs.compiler.munge.call(null,export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__4115__auto__)){
return test;
} else {
return and__4115__auto__;
}
})())){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,";");
} else {
}

return cljs.compiler.emitln.call(null,var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__3986){
var map__3987 = p__3986;
var map__3987__$1 = (((((!((map__3987 == null))))?(((((map__3987.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3987.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3987):map__3987);
var name = cljs.core.get.call(null,map__3987__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.call(null,map__3987__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.call(null,map__3987__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var arglist = cljs.core.gensym.call(null,"arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,name)),"__delegate"].join('');
cljs.compiler.emitln.call(null,"(function (",arglist,"){");

var seq__3989_4013 = cljs.core.seq.call(null,cljs.core.map_indexed.call(null,cljs.core.vector,cljs.core.drop_last.call(null,(2),params)));
var chunk__3990_4014 = null;
var count__3991_4015 = (0);
var i__3992_4016 = (0);
while(true){
if((i__3992_4016 < count__3991_4015)){
var vec__3999_4017 = cljs.core._nth.call(null,chunk__3990_4014,i__3992_4016);
var i_4018 = cljs.core.nth.call(null,vec__3999_4017,(0),null);
var param_4019 = cljs.core.nth.call(null,vec__3999_4017,(1),null);
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,param_4019);

cljs.compiler.emits.call(null," = cljs.core.first(");

cljs.compiler.emitln.call(null,arglist,");");

cljs.compiler.emitln.call(null,arglist," = cljs.core.next(",arglist,");");


var G__4020 = seq__3989_4013;
var G__4021 = chunk__3990_4014;
var G__4022 = count__3991_4015;
var G__4023 = (i__3992_4016 + (1));
seq__3989_4013 = G__4020;
chunk__3990_4014 = G__4021;
count__3991_4015 = G__4022;
i__3992_4016 = G__4023;
continue;
} else {
var temp__5735__auto___4024 = cljs.core.seq.call(null,seq__3989_4013);
if(temp__5735__auto___4024){
var seq__3989_4025__$1 = temp__5735__auto___4024;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__3989_4025__$1)){
var c__4556__auto___4026 = cljs.core.chunk_first.call(null,seq__3989_4025__$1);
var G__4027 = cljs.core.chunk_rest.call(null,seq__3989_4025__$1);
var G__4028 = c__4556__auto___4026;
var G__4029 = cljs.core.count.call(null,c__4556__auto___4026);
var G__4030 = (0);
seq__3989_4013 = G__4027;
chunk__3990_4014 = G__4028;
count__3991_4015 = G__4029;
i__3992_4016 = G__4030;
continue;
} else {
var vec__4002_4031 = cljs.core.first.call(null,seq__3989_4025__$1);
var i_4032 = cljs.core.nth.call(null,vec__4002_4031,(0),null);
var param_4033 = cljs.core.nth.call(null,vec__4002_4031,(1),null);
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,param_4033);

cljs.compiler.emits.call(null," = cljs.core.first(");

cljs.compiler.emitln.call(null,arglist,");");

cljs.compiler.emitln.call(null,arglist," = cljs.core.next(",arglist,");");


var G__4034 = cljs.core.next.call(null,seq__3989_4025__$1);
var G__4035 = null;
var G__4036 = (0);
var G__4037 = (0);
seq__3989_4013 = G__4034;
chunk__3990_4014 = G__4035;
count__3991_4015 = G__4036;
i__3992_4016 = G__4037;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count.call(null,params))){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,cljs.core.butlast.call(null,params)));

cljs.compiler.emitln.call(null," = cljs.core.first(",arglist,");");

cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = cljs.core.rest(",arglist,");");

cljs.compiler.emits.call(null,"return ",delegate_name,"(");

var seq__4005_4038 = cljs.core.seq.call(null,params);
var chunk__4006_4039 = null;
var count__4007_4040 = (0);
var i__4008_4041 = (0);
while(true){
if((i__4008_4041 < count__4007_4040)){
var param_4042 = cljs.core._nth.call(null,chunk__4006_4039,i__4008_4041);
cljs.compiler.emit.call(null,param_4042);

if(cljs.core._EQ_.call(null,param_4042,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__4043 = seq__4005_4038;
var G__4044 = chunk__4006_4039;
var G__4045 = count__4007_4040;
var G__4046 = (i__4008_4041 + (1));
seq__4005_4038 = G__4043;
chunk__4006_4039 = G__4044;
count__4007_4040 = G__4045;
i__4008_4041 = G__4046;
continue;
} else {
var temp__5735__auto___4047 = cljs.core.seq.call(null,seq__4005_4038);
if(temp__5735__auto___4047){
var seq__4005_4048__$1 = temp__5735__auto___4047;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__4005_4048__$1)){
var c__4556__auto___4049 = cljs.core.chunk_first.call(null,seq__4005_4048__$1);
var G__4050 = cljs.core.chunk_rest.call(null,seq__4005_4048__$1);
var G__4051 = c__4556__auto___4049;
var G__4052 = cljs.core.count.call(null,c__4556__auto___4049);
var G__4053 = (0);
seq__4005_4038 = G__4050;
chunk__4006_4039 = G__4051;
count__4007_4040 = G__4052;
i__4008_4041 = G__4053;
continue;
} else {
var param_4054 = cljs.core.first.call(null,seq__4005_4048__$1);
cljs.compiler.emit.call(null,param_4054);

if(cljs.core._EQ_.call(null,param_4054,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__4055 = cljs.core.next.call(null,seq__4005_4048__$1);
var G__4056 = null;
var G__4057 = (0);
var G__4058 = (0);
seq__4005_4038 = G__4055;
chunk__4006_4039 = G__4056;
count__4007_4040 = G__4057;
i__4008_4041 = G__4058;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,");");
} else {
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = cljs.core.seq(",arglist,");");

cljs.compiler.emits.call(null,"return ",delegate_name,"(");

var seq__4009_4059 = cljs.core.seq.call(null,params);
var chunk__4010_4060 = null;
var count__4011_4061 = (0);
var i__4012_4062 = (0);
while(true){
if((i__4012_4062 < count__4011_4061)){
var param_4063 = cljs.core._nth.call(null,chunk__4010_4060,i__4012_4062);
cljs.compiler.emit.call(null,param_4063);

if(cljs.core._EQ_.call(null,param_4063,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__4064 = seq__4009_4059;
var G__4065 = chunk__4010_4060;
var G__4066 = count__4011_4061;
var G__4067 = (i__4012_4062 + (1));
seq__4009_4059 = G__4064;
chunk__4010_4060 = G__4065;
count__4011_4061 = G__4066;
i__4012_4062 = G__4067;
continue;
} else {
var temp__5735__auto___4068 = cljs.core.seq.call(null,seq__4009_4059);
if(temp__5735__auto___4068){
var seq__4009_4069__$1 = temp__5735__auto___4068;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__4009_4069__$1)){
var c__4556__auto___4070 = cljs.core.chunk_first.call(null,seq__4009_4069__$1);
var G__4071 = cljs.core.chunk_rest.call(null,seq__4009_4069__$1);
var G__4072 = c__4556__auto___4070;
var G__4073 = cljs.core.count.call(null,c__4556__auto___4070);
var G__4074 = (0);
seq__4009_4059 = G__4071;
chunk__4010_4060 = G__4072;
count__4011_4061 = G__4073;
i__4012_4062 = G__4074;
continue;
} else {
var param_4075 = cljs.core.first.call(null,seq__4009_4069__$1);
cljs.compiler.emit.call(null,param_4075);

if(cljs.core._EQ_.call(null,param_4075,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__4076 = cljs.core.next.call(null,seq__4009_4069__$1);
var G__4077 = null;
var G__4078 = (0);
var G__4079 = (0);
seq__4009_4059 = G__4076;
chunk__4010_4060 = G__4077;
count__4011_4061 = G__4078;
i__4012_4062 = G__4079;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,");");
}

return cljs.compiler.emits.call(null,"})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__4080 = cljs.core.seq.call(null,params);
var chunk__4081 = null;
var count__4082 = (0);
var i__4083 = (0);
while(true){
if((i__4083 < count__4082)){
var param = cljs.core._nth.call(null,chunk__4081,i__4083);
cljs.compiler.emit.call(null,param);

if(cljs.core._EQ_.call(null,param,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__4084 = seq__4080;
var G__4085 = chunk__4081;
var G__4086 = count__4082;
var G__4087 = (i__4083 + (1));
seq__4080 = G__4084;
chunk__4081 = G__4085;
count__4082 = G__4086;
i__4083 = G__4087;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__4080);
if(temp__5735__auto__){
var seq__4080__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__4080__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__4080__$1);
var G__4088 = cljs.core.chunk_rest.call(null,seq__4080__$1);
var G__4089 = c__4556__auto__;
var G__4090 = cljs.core.count.call(null,c__4556__auto__);
var G__4091 = (0);
seq__4080 = G__4088;
chunk__4081 = G__4089;
count__4082 = G__4090;
i__4083 = G__4091;
continue;
} else {
var param = cljs.core.first.call(null,seq__4080__$1);
cljs.compiler.emit.call(null,param);

if(cljs.core._EQ_.call(null,param,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__4092 = cljs.core.next.call(null,seq__4080__$1);
var G__4093 = null;
var G__4094 = (0);
var G__4095 = (0);
seq__4080 = G__4092;
chunk__4081 = G__4093;
count__4082 = G__4094;
i__4083 = G__4095;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__4096){
var map__4097 = p__4096;
var map__4097__$1 = (((((!((map__4097 == null))))?(((((map__4097.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4097.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__4097):map__4097);
var expr = cljs.core.get.call(null,map__4097__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var type = cljs.core.get.call(null,map__4097__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.call(null,map__4097__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.call(null,map__4097__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.call(null,map__4097__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.call(null,map__4097__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__3537__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3537__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"(function ",cljs.compiler.munge.call(null,name),"(");

cljs.compiler.emit_fn_params.call(null,params);

cljs.compiler.emitln.call(null,"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}

cljs.compiler.emits.call(null,"})");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3537__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if((((startslice >= (0))) && (cljs.core.integer_QMARK_.call(null,startslice)))){
} else {
throw (new Error("Assert failed: (and (>= startslice 0) (integer? startslice))"));
}

var mname = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.call(null,"var ",i," = 0, ",a," = new Array(arguments.length -  ",startslice,");");

cljs.compiler.emitln.call(null,"while (",i," < ",a,".length) {",a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}");

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__4099){
var map__4100 = p__4099;
var map__4100__$1 = (((((!((map__4100 == null))))?(((((map__4100.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4100.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__4100):map__4100);
var f = map__4100__$1;
var expr = cljs.core.get.call(null,map__4100__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var max_fixed_arity = cljs.core.get.call(null,map__4100__$1,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869));
var variadic = cljs.core.get.call(null,map__4100__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var type = cljs.core.get.call(null,map__4100__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.call(null,map__4100__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.call(null,map__4100__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.call(null,map__4100__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.call(null,map__4100__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__3537__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3537__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

var name_4110__$1 = (function (){var or__4126__auto__ = name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.gensym.call(null);
}
})();
var mname_4111 = cljs.compiler.munge.call(null,name_4110__$1);
var delegate_name_4112 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_4111),"__delegate"].join('');
cljs.compiler.emitln.call(null,"(function() { ");

cljs.compiler.emits.call(null,"var ",delegate_name_4112," = function (");

var seq__4102_4113 = cljs.core.seq.call(null,params);
var chunk__4103_4114 = null;
var count__4104_4115 = (0);
var i__4105_4116 = (0);
while(true){
if((i__4105_4116 < count__4104_4115)){
var param_4117 = cljs.core._nth.call(null,chunk__4103_4114,i__4105_4116);
cljs.compiler.emit.call(null,param_4117);

if(cljs.core._EQ_.call(null,param_4117,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__4118 = seq__4102_4113;
var G__4119 = chunk__4103_4114;
var G__4120 = count__4104_4115;
var G__4121 = (i__4105_4116 + (1));
seq__4102_4113 = G__4118;
chunk__4103_4114 = G__4119;
count__4104_4115 = G__4120;
i__4105_4116 = G__4121;
continue;
} else {
var temp__5735__auto___4122 = cljs.core.seq.call(null,seq__4102_4113);
if(temp__5735__auto___4122){
var seq__4102_4123__$1 = temp__5735__auto___4122;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__4102_4123__$1)){
var c__4556__auto___4124 = cljs.core.chunk_first.call(null,seq__4102_4123__$1);
var G__4125 = cljs.core.chunk_rest.call(null,seq__4102_4123__$1);
var G__4126 = c__4556__auto___4124;
var G__4127 = cljs.core.count.call(null,c__4556__auto___4124);
var G__4128 = (0);
seq__4102_4113 = G__4125;
chunk__4103_4114 = G__4126;
count__4104_4115 = G__4127;
i__4105_4116 = G__4128;
continue;
} else {
var param_4129 = cljs.core.first.call(null,seq__4102_4123__$1);
cljs.compiler.emit.call(null,param_4129);

if(cljs.core._EQ_.call(null,param_4129,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__4130 = cljs.core.next.call(null,seq__4102_4123__$1);
var G__4131 = null;
var G__4132 = (0);
var G__4133 = (0);
seq__4102_4113 = G__4130;
chunk__4103_4114 = G__4131;
count__4104_4115 = G__4132;
i__4105_4116 = G__4133;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}

cljs.compiler.emitln.call(null,"};");

cljs.compiler.emitln.call(null,"var ",mname_4111," = function (",cljs.compiler.comma_sep.call(null,(cljs.core.truth_(variadic)?cljs.core.concat.call(null,cljs.core.butlast.call(null,params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",(cljs.core.count.call(null,params) - (1)),") {");

var a_4134 = cljs.compiler.emit_arguments_to_array.call(null,(cljs.core.count.call(null,params) - (1)));
cljs.compiler.emitln.call(null,"  ",cljs.core.last.call(null,params)," = new cljs.core.IndexedSeq(",a_4134,",0,null);");

cljs.compiler.emitln.call(null,"} ");
} else {
}

cljs.compiler.emits.call(null,"return ",delegate_name_4112,".call(this,");

var seq__4106_4135 = cljs.core.seq.call(null,params);
var chunk__4107_4136 = null;
var count__4108_4137 = (0);
var i__4109_4138 = (0);
while(true){
if((i__4109_4138 < count__4108_4137)){
var param_4139 = cljs.core._nth.call(null,chunk__4107_4136,i__4109_4138);
cljs.compiler.emit.call(null,param_4139);

if(cljs.core._EQ_.call(null,param_4139,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__4140 = seq__4106_4135;
var G__4141 = chunk__4107_4136;
var G__4142 = count__4108_4137;
var G__4143 = (i__4109_4138 + (1));
seq__4106_4135 = G__4140;
chunk__4107_4136 = G__4141;
count__4108_4137 = G__4142;
i__4109_4138 = G__4143;
continue;
} else {
var temp__5735__auto___4144 = cljs.core.seq.call(null,seq__4106_4135);
if(temp__5735__auto___4144){
var seq__4106_4145__$1 = temp__5735__auto___4144;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__4106_4145__$1)){
var c__4556__auto___4146 = cljs.core.chunk_first.call(null,seq__4106_4145__$1);
var G__4147 = cljs.core.chunk_rest.call(null,seq__4106_4145__$1);
var G__4148 = c__4556__auto___4146;
var G__4149 = cljs.core.count.call(null,c__4556__auto___4146);
var G__4150 = (0);
seq__4106_4135 = G__4147;
chunk__4107_4136 = G__4148;
count__4108_4137 = G__4149;
i__4109_4138 = G__4150;
continue;
} else {
var param_4151 = cljs.core.first.call(null,seq__4106_4145__$1);
cljs.compiler.emit.call(null,param_4151);

if(cljs.core._EQ_.call(null,param_4151,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__4152 = cljs.core.next.call(null,seq__4106_4145__$1);
var G__4153 = null;
var G__4154 = (0);
var G__4155 = (0);
seq__4106_4135 = G__4152;
chunk__4107_4136 = G__4153;
count__4108_4137 = G__4154;
i__4109_4138 = G__4155;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.call(null,");");

cljs.compiler.emitln.call(null,"};");

cljs.compiler.emitln.call(null,mname_4111,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.call(null,mname_4111,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to.call(null,cljs.core.assoc.call(null,f,new cljs.core.Keyword(null,"name","name",1843675177),name_4110__$1));

cljs.compiler.emitln.call(null,";");

cljs.compiler.emitln.call(null,mname_4111,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_4112,";");

cljs.compiler.emitln.call(null,"return ",mname_4111,";");

cljs.compiler.emitln.call(null,"})()");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3537__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (p__4159){
var map__4160 = p__4159;
var map__4160__$1 = (((((!((map__4160 == null))))?(((((map__4160.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4160.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__4160):map__4160);
var variadic = cljs.core.get.call(null,map__4160__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var name = cljs.core.get.call(null,map__4160__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.call(null,map__4160__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var methods$ = cljs.core.get.call(null,map__4160__$1,new cljs.core.Keyword(null,"methods","methods",453930866));
var max_fixed_arity = cljs.core.get.call(null,map__4160__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var recur_frames = cljs.core.get.call(null,map__4160__$1,new cljs.core.Keyword(null,"recur-frames","recur-frames",-307205196));
var in_loop = cljs.core.get.call(null,map__4160__$1,new cljs.core.Keyword(null,"in-loop","in-loop",-187298246));
var loop_lets = cljs.core.get.call(null,map__4160__$1,new cljs.core.Keyword(null,"loop-lets","loop-lets",2036794185));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.call(null,new cljs.core.Keyword(null,"params","params",710516235),cljs.core.filter.call(null,(function (p1__4156_SHARP_){
var and__4115__auto__ = p1__4156_SHARP_;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.deref.call(null,new cljs.core.Keyword(null,"flag","flag",1088647881).cljs$core$IFn$_invoke$arity$1(p1__4156_SHARP_));
} else {
return and__4115__auto__;
}
}),recur_frames));
var loop_locals = cljs.core.seq.call(null,cljs.core.map.call(null,cljs.compiler.munge,cljs.core.concat.call(null,recur_params,(cljs.core.truth_((function (){var or__4126__auto__ = in_loop;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.seq.call(null,recur_params);
}
})())?cljs.core.mapcat.call(null,new cljs.core.Keyword(null,"params","params",710516235),loop_lets):null))));
if(loop_locals){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emitln.call(null,"((function (",cljs.compiler.comma_sep.call(null,cljs.core.map.call(null,cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.call(null,"return ");
}
} else {
}

if(cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method.call(null,cljs.core.assoc.call(null,cljs.core.first.call(null,methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
} else {
cljs.compiler.emit_fn_method.call(null,cljs.core.assoc.call(null,cljs.core.first.call(null,methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
}
} else {
var name_4213__$1 = (function (){var or__4126__auto__ = name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.gensym.call(null);
}
})();
var mname_4214 = cljs.compiler.munge.call(null,name_4213__$1);
var maxparams_4215 = cljs.core.apply.call(null,cljs.core.max_key,cljs.core.count,cljs.core.map.call(null,new cljs.core.Keyword(null,"params","params",710516235),methods$));
var mmap_4216 = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,(function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.call(null,cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_4214),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_4217 = cljs.core.sort_by.call(null,(function (p1__4157_SHARP_){
return cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,p1__4157_SHARP_)));
}),cljs.core.seq.call(null,mmap_4216));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emitln.call(null,"(function() {");

cljs.compiler.emitln.call(null,"var ",mname_4214," = null;");

var seq__4162_4218 = cljs.core.seq.call(null,ms_4217);
var chunk__4163_4219 = null;
var count__4164_4220 = (0);
var i__4165_4221 = (0);
while(true){
if((i__4165_4221 < count__4164_4220)){
var vec__4172_4222 = cljs.core._nth.call(null,chunk__4163_4219,i__4165_4221);
var n_4223 = cljs.core.nth.call(null,vec__4172_4222,(0),null);
var meth_4224 = cljs.core.nth.call(null,vec__4172_4222,(1),null);
cljs.compiler.emits.call(null,"var ",n_4223," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_4224))){
cljs.compiler.emit_variadic_fn_method.call(null,meth_4224);
} else {
cljs.compiler.emit_fn_method.call(null,meth_4224);
}

cljs.compiler.emitln.call(null,";");


var G__4225 = seq__4162_4218;
var G__4226 = chunk__4163_4219;
var G__4227 = count__4164_4220;
var G__4228 = (i__4165_4221 + (1));
seq__4162_4218 = G__4225;
chunk__4163_4219 = G__4226;
count__4164_4220 = G__4227;
i__4165_4221 = G__4228;
continue;
} else {
var temp__5735__auto___4229 = cljs.core.seq.call(null,seq__4162_4218);
if(temp__5735__auto___4229){
var seq__4162_4230__$1 = temp__5735__auto___4229;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__4162_4230__$1)){
var c__4556__auto___4231 = cljs.core.chunk_first.call(null,seq__4162_4230__$1);
var G__4232 = cljs.core.chunk_rest.call(null,seq__4162_4230__$1);
var G__4233 = c__4556__auto___4231;
var G__4234 = cljs.core.count.call(null,c__4556__auto___4231);
var G__4235 = (0);
seq__4162_4218 = G__4232;
chunk__4163_4219 = G__4233;
count__4164_4220 = G__4234;
i__4165_4221 = G__4235;
continue;
} else {
var vec__4175_4236 = cljs.core.first.call(null,seq__4162_4230__$1);
var n_4237 = cljs.core.nth.call(null,vec__4175_4236,(0),null);
var meth_4238 = cljs.core.nth.call(null,vec__4175_4236,(1),null);
cljs.compiler.emits.call(null,"var ",n_4237," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_4238))){
cljs.compiler.emit_variadic_fn_method.call(null,meth_4238);
} else {
cljs.compiler.emit_fn_method.call(null,meth_4238);
}

cljs.compiler.emitln.call(null,";");


var G__4239 = cljs.core.next.call(null,seq__4162_4230__$1);
var G__4240 = null;
var G__4241 = (0);
var G__4242 = (0);
seq__4162_4218 = G__4239;
chunk__4163_4219 = G__4240;
count__4164_4220 = G__4241;
i__4165_4221 = G__4242;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,mname_4214," = function(",cljs.compiler.comma_sep.call(null,(cljs.core.truth_(variadic)?cljs.core.concat.call(null,cljs.core.butlast.call(null,maxparams_4215),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):maxparams_4215)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,maxparams_4215));

cljs.compiler.emitln.call(null," = var_args;");
} else {
}

cljs.compiler.emitln.call(null,"switch(arguments.length){");

var seq__4178_4243 = cljs.core.seq.call(null,ms_4217);
var chunk__4179_4244 = null;
var count__4180_4245 = (0);
var i__4181_4246 = (0);
while(true){
if((i__4181_4246 < count__4180_4245)){
var vec__4188_4247 = cljs.core._nth.call(null,chunk__4179_4244,i__4181_4246);
var n_4248 = cljs.core.nth.call(null,vec__4188_4247,(0),null);
var meth_4249 = cljs.core.nth.call(null,vec__4188_4247,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_4249))){
cljs.compiler.emitln.call(null,"default:");

var restarg_4250 = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
cljs.compiler.emitln.call(null,"var ",restarg_4250," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",max_fixed_arity,") {");

var a_4251 = cljs.compiler.emit_arguments_to_array.call(null,max_fixed_arity);
cljs.compiler.emitln.call(null,restarg_4250," = new cljs.core.IndexedSeq(",a_4251,",0,null);");

cljs.compiler.emitln.call(null,"}");

cljs.compiler.emitln.call(null,"return ",n_4248,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep.call(null,cljs.core.butlast.call(null,maxparams_4215)),(((cljs.core.count.call(null,maxparams_4215) > (1)))?", ":null),restarg_4250,");");
} else {
var pcnt_4252 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_4249));
cljs.compiler.emitln.call(null,"case ",pcnt_4252,":");

cljs.compiler.emitln.call(null,"return ",n_4248,".call(this",(((pcnt_4252 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,pcnt_4252,maxparams_4215)),null,(1),null)),(2),null))),");");
}


var G__4253 = seq__4178_4243;
var G__4254 = chunk__4179_4244;
var G__4255 = count__4180_4245;
var G__4256 = (i__4181_4246 + (1));
seq__4178_4243 = G__4253;
chunk__4179_4244 = G__4254;
count__4180_4245 = G__4255;
i__4181_4246 = G__4256;
continue;
} else {
var temp__5735__auto___4257 = cljs.core.seq.call(null,seq__4178_4243);
if(temp__5735__auto___4257){
var seq__4178_4258__$1 = temp__5735__auto___4257;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__4178_4258__$1)){
var c__4556__auto___4259 = cljs.core.chunk_first.call(null,seq__4178_4258__$1);
var G__4260 = cljs.core.chunk_rest.call(null,seq__4178_4258__$1);
var G__4261 = c__4556__auto___4259;
var G__4262 = cljs.core.count.call(null,c__4556__auto___4259);
var G__4263 = (0);
seq__4178_4243 = G__4260;
chunk__4179_4244 = G__4261;
count__4180_4245 = G__4262;
i__4181_4246 = G__4263;
continue;
} else {
var vec__4191_4264 = cljs.core.first.call(null,seq__4178_4258__$1);
var n_4265 = cljs.core.nth.call(null,vec__4191_4264,(0),null);
var meth_4266 = cljs.core.nth.call(null,vec__4191_4264,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_4266))){
cljs.compiler.emitln.call(null,"default:");

var restarg_4267 = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
cljs.compiler.emitln.call(null,"var ",restarg_4267," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",max_fixed_arity,") {");

var a_4268 = cljs.compiler.emit_arguments_to_array.call(null,max_fixed_arity);
cljs.compiler.emitln.call(null,restarg_4267," = new cljs.core.IndexedSeq(",a_4268,",0,null);");

cljs.compiler.emitln.call(null,"}");

cljs.compiler.emitln.call(null,"return ",n_4265,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep.call(null,cljs.core.butlast.call(null,maxparams_4215)),(((cljs.core.count.call(null,maxparams_4215) > (1)))?", ":null),restarg_4267,");");
} else {
var pcnt_4269 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_4266));
cljs.compiler.emitln.call(null,"case ",pcnt_4269,":");

cljs.compiler.emitln.call(null,"return ",n_4265,".call(this",(((pcnt_4269 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,pcnt_4269,maxparams_4215)),null,(1),null)),(2),null))),");");
}


var G__4270 = cljs.core.next.call(null,seq__4178_4258__$1);
var G__4271 = null;
var G__4272 = (0);
var G__4273 = (0);
seq__4178_4243 = G__4270;
chunk__4179_4244 = G__4271;
count__4180_4245 = G__4272;
i__4181_4246 = G__4273;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"}");

var arg_count_js_4274 = ((cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"self__","self__",-153190816,null),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,cljs.core.first.call(null,ms_4217)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.call(null,"throw(new Error('Invalid arity: ' + ",arg_count_js_4274,"));");

cljs.compiler.emitln.call(null,"};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.call(null,mname_4214,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.call(null,mname_4214,".cljs$lang$applyTo = ",cljs.core.some.call(null,(function (p1__4158_SHARP_){
var vec__4194 = p1__4158_SHARP_;
var n = cljs.core.nth.call(null,vec__4194,(0),null);
var m = cljs.core.nth.call(null,vec__4194,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_4217),".cljs$lang$applyTo;");
} else {
}

var seq__4197_4275 = cljs.core.seq.call(null,ms_4217);
var chunk__4198_4276 = null;
var count__4199_4277 = (0);
var i__4200_4278 = (0);
while(true){
if((i__4200_4278 < count__4199_4277)){
var vec__4207_4279 = cljs.core._nth.call(null,chunk__4198_4276,i__4200_4278);
var n_4280 = cljs.core.nth.call(null,vec__4207_4279,(0),null);
var meth_4281 = cljs.core.nth.call(null,vec__4207_4279,(1),null);
var c_4282 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_4281));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_4281))){
cljs.compiler.emitln.call(null,mname_4214,".cljs$core$IFn$_invoke$arity$variadic = ",n_4280,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.call(null,mname_4214,".cljs$core$IFn$_invoke$arity$",c_4282," = ",n_4280,";");
}


var G__4283 = seq__4197_4275;
var G__4284 = chunk__4198_4276;
var G__4285 = count__4199_4277;
var G__4286 = (i__4200_4278 + (1));
seq__4197_4275 = G__4283;
chunk__4198_4276 = G__4284;
count__4199_4277 = G__4285;
i__4200_4278 = G__4286;
continue;
} else {
var temp__5735__auto___4287 = cljs.core.seq.call(null,seq__4197_4275);
if(temp__5735__auto___4287){
var seq__4197_4288__$1 = temp__5735__auto___4287;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__4197_4288__$1)){
var c__4556__auto___4289 = cljs.core.chunk_first.call(null,seq__4197_4288__$1);
var G__4290 = cljs.core.chunk_rest.call(null,seq__4197_4288__$1);
var G__4291 = c__4556__auto___4289;
var G__4292 = cljs.core.count.call(null,c__4556__auto___4289);
var G__4293 = (0);
seq__4197_4275 = G__4290;
chunk__4198_4276 = G__4291;
count__4199_4277 = G__4292;
i__4200_4278 = G__4293;
continue;
} else {
var vec__4210_4294 = cljs.core.first.call(null,seq__4197_4288__$1);
var n_4295 = cljs.core.nth.call(null,vec__4210_4294,(0),null);
var meth_4296 = cljs.core.nth.call(null,vec__4210_4294,(1),null);
var c_4297 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_4296));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_4296))){
cljs.compiler.emitln.call(null,mname_4214,".cljs$core$IFn$_invoke$arity$variadic = ",n_4295,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.call(null,mname_4214,".cljs$core$IFn$_invoke$arity$",c_4297," = ",n_4295,";");
}


var G__4298 = cljs.core.next.call(null,seq__4197_4288__$1);
var G__4299 = null;
var G__4300 = (0);
var G__4301 = (0);
seq__4197_4275 = G__4298;
chunk__4198_4276 = G__4299;
count__4199_4277 = G__4300;
i__4200_4278 = G__4301;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"return ",mname_4214,";");

cljs.compiler.emitln.call(null,"})()");
}

if(loop_locals){
return cljs.compiler.emitln.call(null,";})(",cljs.compiler.comma_sep.call(null,loop_locals),"))");
} else {
return null;
}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"do","do",46310725),(function (p__4302){
var map__4303 = p__4302;
var map__4303__$1 = (((((!((map__4303 == null))))?(((((map__4303.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4303.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__4303):map__4303);
var statements = cljs.core.get.call(null,map__4303__$1,new cljs.core.Keyword(null,"statements","statements",600349855));
var ret = cljs.core.get.call(null,map__4303__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
var env = cljs.core.get.call(null,map__4303__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq.call(null,statements)) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
cljs.compiler.emitln.call(null,"(function (){");
} else {
}

var seq__4305_4309 = cljs.core.seq.call(null,statements);
var chunk__4306_4310 = null;
var count__4307_4311 = (0);
var i__4308_4312 = (0);
while(true){
if((i__4308_4312 < count__4307_4311)){
var s_4313 = cljs.core._nth.call(null,chunk__4306_4310,i__4308_4312);
cljs.compiler.emitln.call(null,s_4313);


var G__4314 = seq__4305_4309;
var G__4315 = chunk__4306_4310;
var G__4316 = count__4307_4311;
var G__4317 = (i__4308_4312 + (1));
seq__4305_4309 = G__4314;
chunk__4306_4310 = G__4315;
count__4307_4311 = G__4316;
i__4308_4312 = G__4317;
continue;
} else {
var temp__5735__auto___4318 = cljs.core.seq.call(null,seq__4305_4309);
if(temp__5735__auto___4318){
var seq__4305_4319__$1 = temp__5735__auto___4318;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__4305_4319__$1)){
var c__4556__auto___4320 = cljs.core.chunk_first.call(null,seq__4305_4319__$1);
var G__4321 = cljs.core.chunk_rest.call(null,seq__4305_4319__$1);
var G__4322 = c__4556__auto___4320;
var G__4323 = cljs.core.count.call(null,c__4556__auto___4320);
var G__4324 = (0);
seq__4305_4309 = G__4321;
chunk__4306_4310 = G__4322;
count__4307_4311 = G__4323;
i__4308_4312 = G__4324;
continue;
} else {
var s_4325 = cljs.core.first.call(null,seq__4305_4319__$1);
cljs.compiler.emitln.call(null,s_4325);


var G__4326 = cljs.core.next.call(null,seq__4305_4319__$1);
var G__4327 = null;
var G__4328 = (0);
var G__4329 = (0);
seq__4305_4309 = G__4326;
chunk__4306_4310 = G__4327;
count__4307_4311 = G__4328;
i__4308_4312 = G__4329;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit.call(null,ret);

if(((cljs.core.seq.call(null,statements)) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
return cljs.compiler.emitln.call(null,"})()");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"try","try",1380742522),(function (p__4330){
var map__4331 = p__4330;
var map__4331__$1 = (((((!((map__4331 == null))))?(((((map__4331.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4331.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__4331):map__4331);
var try$ = cljs.core.get.call(null,map__4331__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var env = cljs.core.get.call(null,map__4331__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var catch$ = cljs.core.get.call(null,map__4331__$1,new cljs.core.Keyword(null,"catch","catch",1038065524));
var name = cljs.core.get.call(null,map__4331__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var finally$ = cljs.core.get.call(null,map__4331__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__4126__auto__ = name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

cljs.compiler.emits.call(null,"try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.call(null,"catch (",cljs.compiler.munge.call(null,name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"const","const",1709929842),new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.unwrap_quote.call(null,finally$)))){
} else {
throw (new Error(["Assert failed: ","finally block cannot contain constant","\n","(not= :const (:op (ana/unwrap-quote finally)))"].join('')));
}

cljs.compiler.emits.call(null,"finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.call(null,try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__4333,is_loop){
var map__4334 = p__4333;
var map__4334__$1 = (((((!((map__4334 == null))))?(((((map__4334.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4334.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__4334):map__4334);
var expr = cljs.core.get.call(null,map__4334__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.call(null,map__4334__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.call(null,map__4334__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__4336_4350 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__4337_4351 = cljs.core.into.call(null,cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),context))?cljs.core.map.call(null,(function (binding){
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope.call(null,binding),cljs.core.gensym.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__4337_4351);

try{var seq__4338_4352 = cljs.core.seq.call(null,bindings);
var chunk__4339_4353 = null;
var count__4340_4354 = (0);
var i__4341_4355 = (0);
while(true){
if((i__4341_4355 < count__4340_4354)){
var map__4346_4356 = cljs.core._nth.call(null,chunk__4339_4353,i__4341_4355);
var map__4346_4357__$1 = (((((!((map__4346_4356 == null))))?(((((map__4346_4356.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4346_4356.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__4346_4356):map__4346_4356);
var binding_4358 = map__4346_4357__$1;
var init_4359 = cljs.core.get.call(null,map__4346_4357__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,binding_4358);

cljs.compiler.emitln.call(null," = ",init_4359,";");


var G__4360 = seq__4338_4352;
var G__4361 = chunk__4339_4353;
var G__4362 = count__4340_4354;
var G__4363 = (i__4341_4355 + (1));
seq__4338_4352 = G__4360;
chunk__4339_4353 = G__4361;
count__4340_4354 = G__4362;
i__4341_4355 = G__4363;
continue;
} else {
var temp__5735__auto___4364 = cljs.core.seq.call(null,seq__4338_4352);
if(temp__5735__auto___4364){
var seq__4338_4365__$1 = temp__5735__auto___4364;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__4338_4365__$1)){
var c__4556__auto___4366 = cljs.core.chunk_first.call(null,seq__4338_4365__$1);
var G__4367 = cljs.core.chunk_rest.call(null,seq__4338_4365__$1);
var G__4368 = c__4556__auto___4366;
var G__4369 = cljs.core.count.call(null,c__4556__auto___4366);
var G__4370 = (0);
seq__4338_4352 = G__4367;
chunk__4339_4353 = G__4368;
count__4340_4354 = G__4369;
i__4341_4355 = G__4370;
continue;
} else {
var map__4348_4371 = cljs.core.first.call(null,seq__4338_4365__$1);
var map__4348_4372__$1 = (((((!((map__4348_4371 == null))))?(((((map__4348_4371.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4348_4371.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__4348_4371):map__4348_4371);
var binding_4373 = map__4348_4372__$1;
var init_4374 = cljs.core.get.call(null,map__4348_4372__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,binding_4373);

cljs.compiler.emitln.call(null," = ",init_4374,";");


var G__4375 = cljs.core.next.call(null,seq__4338_4365__$1);
var G__4376 = null;
var G__4377 = (0);
var G__4378 = (0);
seq__4338_4352 = G__4375;
chunk__4339_4353 = G__4376;
count__4340_4354 = G__4377;
i__4341_4355 = G__4378;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__4336_4350);
}
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"let","let",-1282412701),(function (ast){
return cljs.compiler.emit_let.call(null,ast,false);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"loop","loop",-395552849),(function (ast){
return cljs.compiler.emit_let.call(null,ast,true);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"recur","recur",-437573268),(function (p__4379){
var map__4380 = p__4379;
var map__4380__$1 = (((((!((map__4380 == null))))?(((((map__4380.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4380.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__4380):map__4380);
var frame = cljs.core.get.call(null,map__4380__$1,new cljs.core.Keyword(null,"frame","frame",-1711082588));
var exprs = cljs.core.get.call(null,map__4380__$1,new cljs.core.Keyword(null,"exprs","exprs",1795829094));
var env = cljs.core.get.call(null,map__4380__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var temps = cljs.core.vec.call(null,cljs.core.take.call(null,cljs.core.count.call(null,exprs),cljs.core.repeatedly.call(null,cljs.core.gensym)));
var params = new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(frame);
var n__4613__auto___4382 = cljs.core.count.call(null,exprs);
var i_4383 = (0);
while(true){
if((i_4383 < n__4613__auto___4382)){
cljs.compiler.emitln.call(null,"var ",temps.call(null,i_4383)," = ",exprs.call(null,i_4383),";");

var G__4384 = (i_4383 + (1));
i_4383 = G__4384;
continue;
} else {
}
break;
}

var n__4613__auto___4385 = cljs.core.count.call(null,exprs);
var i_4386 = (0);
while(true){
if((i_4386 < n__4613__auto___4385)){
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,params.call(null,i_4386))," = ",temps.call(null,i_4386),";");

var G__4387 = (i_4386 + (1));
i_4386 = G__4387;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.call(null,"continue;");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"letfn","letfn",-2121022354),(function (p__4388){
var map__4389 = p__4388;
var map__4389__$1 = (((((!((map__4389 == null))))?(((((map__4389.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4389.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__4389):map__4389);
var expr = cljs.core.get.call(null,map__4389__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.call(null,map__4389__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.call(null,map__4389__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

var seq__4391_4403 = cljs.core.seq.call(null,bindings);
var chunk__4392_4404 = null;
var count__4393_4405 = (0);
var i__4394_4406 = (0);
while(true){
if((i__4394_4406 < count__4393_4405)){
var map__4399_4407 = cljs.core._nth.call(null,chunk__4392_4404,i__4394_4406);
var map__4399_4408__$1 = (((((!((map__4399_4407 == null))))?(((((map__4399_4407.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4399_4407.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__4399_4407):map__4399_4407);
var binding_4409 = map__4399_4408__$1;
var init_4410 = cljs.core.get.call(null,map__4399_4408__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.call(null,"var ",cljs.compiler.munge.call(null,binding_4409)," = ",init_4410,";");


var G__4411 = seq__4391_4403;
var G__4412 = chunk__4392_4404;
var G__4413 = count__4393_4405;
var G__4414 = (i__4394_4406 + (1));
seq__4391_4403 = G__4411;
chunk__4392_4404 = G__4412;
count__4393_4405 = G__4413;
i__4394_4406 = G__4414;
continue;
} else {
var temp__5735__auto___4415 = cljs.core.seq.call(null,seq__4391_4403);
if(temp__5735__auto___4415){
var seq__4391_4416__$1 = temp__5735__auto___4415;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__4391_4416__$1)){
var c__4556__auto___4417 = cljs.core.chunk_first.call(null,seq__4391_4416__$1);
var G__4418 = cljs.core.chunk_rest.call(null,seq__4391_4416__$1);
var G__4419 = c__4556__auto___4417;
var G__4420 = cljs.core.count.call(null,c__4556__auto___4417);
var G__4421 = (0);
seq__4391_4403 = G__4418;
chunk__4392_4404 = G__4419;
count__4393_4405 = G__4420;
i__4394_4406 = G__4421;
continue;
} else {
var map__4401_4422 = cljs.core.first.call(null,seq__4391_4416__$1);
var map__4401_4423__$1 = (((((!((map__4401_4422 == null))))?(((((map__4401_4422.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4401_4422.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__4401_4422):map__4401_4422);
var binding_4424 = map__4401_4423__$1;
var init_4425 = cljs.core.get.call(null,map__4401_4423__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.call(null,"var ",cljs.compiler.munge.call(null,binding_4424)," = ",init_4425,";");


var G__4426 = cljs.core.next.call(null,seq__4391_4416__$1);
var G__4427 = null;
var G__4428 = (0);
var G__4429 = (0);
seq__4391_4403 = G__4426;
chunk__4392_4404 = G__4427;
count__4393_4405 = G__4428;
i__4394_4406 = G__4429;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.call(null,expr);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"invoke","invoke",1145927159),(function (p__4432){
var map__4433 = p__4432;
var map__4433__$1 = (((((!((map__4433 == null))))?(((((map__4433.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4433.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__4433):map__4433);
var expr = map__4433__$1;
var f = cljs.core.get.call(null,map__4433__$1,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var args = cljs.core.get.call(null,map__4433__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__4433__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__4115__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4115__auto__)){
if(cljs.core.not.call(null,new cljs.core.Keyword(null,"dynamic","dynamic",704819571).cljs$core$IFn$_invoke$arity$1(info))){
return new cljs.core.Keyword(null,"fn-var","fn-var",1086204730).cljs$core$IFn$_invoke$arity$1(info);
} else {
return false;
}
} else {
return and__4115__auto__;
}
})();
var protocol = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag.call(null,env,cljs.core.first.call(null,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__4115__auto__ = protocol;
if(cljs.core.truth_(and__4115__auto__)){
var and__4115__auto____$1 = tag;
if(cljs.core.truth_(and__4115__auto____$1)){
var or__4126__auto__ = (function (){var and__4115__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4115__auto____$2)){
var and__4115__auto____$3 = protocol;
if(cljs.core.truth_(and__4115__auto____$3)){
return cljs.core._EQ_.call(null,tag,new cljs.core.Symbol(null,"not-native","not-native",-236392494,null));
} else {
return and__4115__auto____$3;
}
} else {
return and__4115__auto____$2;
}
})();
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var and__4115__auto____$2 = (function (){var or__4126__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556).cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__4115__auto____$2)){
var or__4126__auto____$1 = cljs.core._EQ_.call(null,protocol,tag);
if(or__4126__auto____$1){
return or__4126__auto____$1;
} else {
if((!(cljs.core.set_QMARK_.call(null,tag)))){
if(cljs.core.not.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Symbol(null,"clj","clj",980036099,null),"null",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"null",new cljs.core.Symbol(null,"object","object",-1179821820,null),"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null",new cljs.core.Symbol(null,"js","js",-886355190,null),"null",new cljs.core.Symbol(null,"number","number",-1084057331,null),"null",new cljs.core.Symbol(null,"clj-or-nil","clj-or-nil",-2008798668,null),"null",new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null",new cljs.core.Symbol(null,"function","function",-486723946,null),"null",new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),"null"], null), null).call(null,tag))){
var temp__5735__auto__ = new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var.call(null,env,cljs.core.vary_meta.call(null,tag,cljs.core.assoc,new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true)));
if(cljs.core.truth_(temp__5735__auto__)){
var ps = temp__5735__auto__;
return ps.call(null,protocol);
} else {
return null;
}
} else {
return false;
}
} else {
return false;
}
}
} else {
return and__4115__auto____$2;
}
}
} else {
return and__4115__auto____$1;
}
} else {
return and__4115__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag.call(null,env,cljs.core.first.call(null,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null))) && (cljs.core._EQ_.call(null,first_arg_tag,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null))));
var opt_count_QMARK_ = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null))) && (cljs.core.boolean$.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null"], null), null).call(null,first_arg_tag))));
var ns = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag.call(null,env,f);
var js_QMARK_ = (function (){var or__4126__auto__ = cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"js","js",-886355190,null));
if(or__4126__auto__){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"Math","Math",2033287572,null));
if(or__4126__auto____$1){
return or__4126__auto____$1;
} else {
return new cljs.core.Keyword(null,"foreign","foreign",990521149).cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__4126__auto__ = cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"goog","goog",-70603925,null));
if(or__4126__auto__){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = (function (){var temp__5735__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5735__auto__)){
var ns_str = temp__5735__auto__;
return cljs.core._EQ_.call(null,cljs.core.get.call(null,clojure.string.split.call(null,ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_.call(null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__4126__auto__ = cljs.core._EQ_.call(null,new cljs.core.Symbol("cljs.core","Keyword","cljs.core/Keyword",-451434488,null),ftag);
if(or__4126__auto__){
return or__4126__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote.call(null,f);
return ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1),new cljs.core.Keyword(null,"const","const",1709929842))) && ((new cljs.core.Keyword(null,"form","form",-1624062471).cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__4435 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count.call(null,args);
var variadic_QMARK_ = new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(info);
var mps = new cljs.core.Keyword(null,"method-params","method-params",-980792179).cljs$core$IFn$_invoke$arity$1(info);
var mfa = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not.call(null,variadic_QMARK_)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return (arity > mfa);
} else {
return and__4115__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.call(null,f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.call(null,cljs.core.assoc.call(null,info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__4430_SHARP_){
return cljs.core.dissoc.call(null,cljs.core.dissoc.call(null,p1__4430_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),mfa], null)], null);
} else {
var arities = cljs.core.map.call(null,cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.call(null,f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.call(null,cljs.core.assoc.call(null,info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__4431_SHARP_){
return cljs.core.dissoc.call(null,cljs.core.dissoc.call(null,p1__4431_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.call(null,vec__4435,(0),null);
var variadic_invoke = cljs.core.nth.call(null,vec__4435,(1),null);
var env__3537__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3537__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.call(null,"(!(",cljs.core.first.call(null,args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.call(null,"((",cljs.core.first.call(null,args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_4438 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,cljs.compiler.protocol_prefix.call(null,protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,cljs.core.name.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,args))].join('');
cljs.compiler.emits.call(null,cljs.core.first.call(null,args),".",pimpl_4438,"(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",cljs.core.rest.call(null,args))),")");
} else {
if(keyword_QMARK_){
cljs.compiler.emits.call(null,f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count.call(null,args),"(",cljs.compiler.comma_sep.call(null,args),")");
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_4439 = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.call(null,f__$1,"(",cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,mfa_4439,args)),(((mfa_4439 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.compiler.comma_sep.call(null,cljs.core.drop.call(null,mfa_4439,args)),"], 0))");
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.call(null,f__$1,"(",cljs.compiler.comma_sep.call(null,args),")");
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4115__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null).call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1));
} else {
return and__4115__auto__;
}
})())){
var fprop_4440 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.call(null,"(",f__$1,fprop_4440," ? ",f__$1,fprop_4440,"(",cljs.compiler.comma_sep.call(null,args),") : ",f__$1,"(",cljs.compiler.comma_sep.call(null,args),"))");
} else {
cljs.compiler.emits.call(null,"(",f__$1,fprop_4440," ? ",f__$1,fprop_4440,"(",cljs.compiler.comma_sep.call(null,args),") : ",f__$1,".call(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",args)),"))");
}
} else {
cljs.compiler.emits.call(null,f__$1,".call(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3537__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"new","new",-2085437848),(function (p__4441){
var map__4442 = p__4441;
var map__4442__$1 = (((((!((map__4442 == null))))?(((((map__4442.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4442.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__4442):map__4442);
var ctor = cljs.core.get.call(null,map__4442__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var args = cljs.core.get.call(null,map__4442__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__4442__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__3537__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3537__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"(new ",ctor,"(",cljs.compiler.comma_sep.call(null,args),"))");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3537__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"set!","set!",-1389817006),(function (p__4444){
var map__4445 = p__4444;
var map__4445__$1 = (((((!((map__4445 == null))))?(((((map__4445.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4445.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__4445):map__4445);
var target = cljs.core.get.call(null,map__4445__$1,new cljs.core.Keyword(null,"target","target",253001721));
var val = cljs.core.get.call(null,map__4445__$1,new cljs.core.Keyword(null,"val","val",128701612));
var env = cljs.core.get.call(null,map__4445__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__3537__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3537__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"(",target," = ",val,")");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3537__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
return cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_global_export.call(null,lib)," = goog.global",cljs.core.apply.call(null,cljs.core.str,cljs.core.map.call(null,(function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.call(null,cljs.core.name.call(null,(function (){var or__4126__auto__ = cljs.core.get.call(null,global_exports,cljs.core.symbol.call(null,lib));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.call(null,global_exports,cljs.core.name.call(null,lib));
}
})()),/\./))),";");
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__4447 = cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_);
var map__4447__$1 = (((((!((map__4447 == null))))?(((((map__4447.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4447.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__4447):map__4447);
var options = cljs.core.get.call(null,map__4447__$1,new cljs.core.Keyword(null,"options","options",99638489));
var js_dependency_index = cljs.core.get.call(null,map__4447__$1,new cljs.core.Keyword(null,"js-dependency-index","js-dependency-index",-1887042131));
var map__4448 = options;
var map__4448__$1 = (((((!((map__4448 == null))))?(((((map__4448.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4448.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__4448):map__4448);
var target = cljs.core.get.call(null,map__4448__$1,new cljs.core.Keyword(null,"target","target",253001721));
var nodejs_rt = cljs.core.get.call(null,map__4448__$1,new cljs.core.Keyword(null,"nodejs-rt","nodejs-rt",-512437071));
var optimizations = cljs.core.get.call(null,map__4448__$1,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854));
var loaded_libs = cljs.compiler.munge.call(null,new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null));
var loaded_libs_temp = cljs.compiler.munge.call(null,cljs.core.gensym.call(null,new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null)));
var vec__4449 = (function (){var libs__$1 = cljs.core.remove.call(null,cljs.core.set.call(null,cljs.core.vals.call(null,seen)),cljs.core.filter.call(null,cljs.core.set.call(null,cljs.core.vals.call(null,libs)),deps));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"nodejs","nodejs",321212524),target)){
var map__4454 = cljs.core.group_by.call(null,cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__4454__$1 = (((((!((map__4454 == null))))?(((((map__4454.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4454.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__4454):map__4454);
var node_libs = cljs.core.get.call(null,map__4454__$1,true);
var libs_to_load = cljs.core.get.call(null,map__4454__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.call(null,vec__4449,(0),null);
var libs_to_load = cljs.core.nth.call(null,vec__4449,(1),null);
var global_exports_libs = cljs.core.filter.call(null,cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load);
if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs)))){
cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__4456_4476 = cljs.core.seq.call(null,libs_to_load);
var chunk__4457_4477 = null;
var count__4458_4478 = (0);
var i__4459_4479 = (0);
while(true){
if((i__4459_4479 < count__4458_4478)){
var lib_4480 = cljs.core._nth.call(null,chunk__4457_4477,i__4459_4479);
if(((cljs.analyzer.foreign_dep_QMARK_.call(null,lib_4480)) && ((!(cljs.core.keyword_identical_QMARK_.call(null,optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_4480),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_4480),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_4480),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_4480),"', 'reload-all');");
} else {
if(cljs.core._EQ_.call(null,lib_4480,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_4480),"');");
}

}
}
}


var G__4481 = seq__4456_4476;
var G__4482 = chunk__4457_4477;
var G__4483 = count__4458_4478;
var G__4484 = (i__4459_4479 + (1));
seq__4456_4476 = G__4481;
chunk__4457_4477 = G__4482;
count__4458_4478 = G__4483;
i__4459_4479 = G__4484;
continue;
} else {
var temp__5735__auto___4485 = cljs.core.seq.call(null,seq__4456_4476);
if(temp__5735__auto___4485){
var seq__4456_4486__$1 = temp__5735__auto___4485;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__4456_4486__$1)){
var c__4556__auto___4487 = cljs.core.chunk_first.call(null,seq__4456_4486__$1);
var G__4488 = cljs.core.chunk_rest.call(null,seq__4456_4486__$1);
var G__4489 = c__4556__auto___4487;
var G__4490 = cljs.core.count.call(null,c__4556__auto___4487);
var G__4491 = (0);
seq__4456_4476 = G__4488;
chunk__4457_4477 = G__4489;
count__4458_4478 = G__4490;
i__4459_4479 = G__4491;
continue;
} else {
var lib_4492 = cljs.core.first.call(null,seq__4456_4486__$1);
if(((cljs.analyzer.foreign_dep_QMARK_.call(null,lib_4492)) && ((!(cljs.core.keyword_identical_QMARK_.call(null,optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_4492),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_4492),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_4492),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_4492),"', 'reload-all');");
} else {
if(cljs.core._EQ_.call(null,lib_4492,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_4492),"');");
}

}
}
}


var G__4493 = cljs.core.next.call(null,seq__4456_4486__$1);
var G__4494 = null;
var G__4495 = (0);
var G__4496 = (0);
seq__4456_4476 = G__4493;
chunk__4457_4477 = G__4494;
count__4458_4478 = G__4495;
i__4459_4479 = G__4496;
continue;
}
} else {
}
}
break;
}

var seq__4460_4497 = cljs.core.seq.call(null,node_libs);
var chunk__4461_4498 = null;
var count__4462_4499 = (0);
var i__4463_4500 = (0);
while(true){
if((i__4463_4500 < count__4462_4499)){
var lib_4501 = cljs.core._nth.call(null,chunk__4461_4498,i__4463_4500);
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_node_lib.call(null,lib_4501)," = require('",lib_4501,"');");


var G__4502 = seq__4460_4497;
var G__4503 = chunk__4461_4498;
var G__4504 = count__4462_4499;
var G__4505 = (i__4463_4500 + (1));
seq__4460_4497 = G__4502;
chunk__4461_4498 = G__4503;
count__4462_4499 = G__4504;
i__4463_4500 = G__4505;
continue;
} else {
var temp__5735__auto___4506 = cljs.core.seq.call(null,seq__4460_4497);
if(temp__5735__auto___4506){
var seq__4460_4507__$1 = temp__5735__auto___4506;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__4460_4507__$1)){
var c__4556__auto___4508 = cljs.core.chunk_first.call(null,seq__4460_4507__$1);
var G__4509 = cljs.core.chunk_rest.call(null,seq__4460_4507__$1);
var G__4510 = c__4556__auto___4508;
var G__4511 = cljs.core.count.call(null,c__4556__auto___4508);
var G__4512 = (0);
seq__4460_4497 = G__4509;
chunk__4461_4498 = G__4510;
count__4462_4499 = G__4511;
i__4463_4500 = G__4512;
continue;
} else {
var lib_4513 = cljs.core.first.call(null,seq__4460_4507__$1);
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_node_lib.call(null,lib_4513)," = require('",lib_4513,"');");


var G__4514 = cljs.core.next.call(null,seq__4460_4507__$1);
var G__4515 = null;
var G__4516 = (0);
var G__4517 = (0);
seq__4460_4497 = G__4514;
chunk__4461_4498 = G__4515;
count__4462_4499 = G__4516;
i__4463_4500 = G__4517;
continue;
}
} else {
}
}
break;
}

var seq__4464_4518 = cljs.core.seq.call(null,global_exports_libs);
var chunk__4465_4519 = null;
var count__4466_4520 = (0);
var i__4467_4521 = (0);
while(true){
if((i__4467_4521 < count__4466_4520)){
var lib_4522 = cljs.core._nth.call(null,chunk__4465_4519,i__4467_4521);
var map__4472_4523 = cljs.core.get.call(null,js_dependency_index,cljs.core.name.call(null,lib_4522));
var map__4472_4524__$1 = (((((!((map__4472_4523 == null))))?(((((map__4472_4523.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4472_4523.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__4472_4523):map__4472_4523);
var global_exports_4525 = cljs.core.get.call(null,map__4472_4524__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export.call(null,ns_name,global_exports_4525,lib_4522);


var G__4526 = seq__4464_4518;
var G__4527 = chunk__4465_4519;
var G__4528 = count__4466_4520;
var G__4529 = (i__4467_4521 + (1));
seq__4464_4518 = G__4526;
chunk__4465_4519 = G__4527;
count__4466_4520 = G__4528;
i__4467_4521 = G__4529;
continue;
} else {
var temp__5735__auto___4530 = cljs.core.seq.call(null,seq__4464_4518);
if(temp__5735__auto___4530){
var seq__4464_4531__$1 = temp__5735__auto___4530;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__4464_4531__$1)){
var c__4556__auto___4532 = cljs.core.chunk_first.call(null,seq__4464_4531__$1);
var G__4533 = cljs.core.chunk_rest.call(null,seq__4464_4531__$1);
var G__4534 = c__4556__auto___4532;
var G__4535 = cljs.core.count.call(null,c__4556__auto___4532);
var G__4536 = (0);
seq__4464_4518 = G__4533;
chunk__4465_4519 = G__4534;
count__4466_4520 = G__4535;
i__4467_4521 = G__4536;
continue;
} else {
var lib_4537 = cljs.core.first.call(null,seq__4464_4531__$1);
var map__4474_4538 = cljs.core.get.call(null,js_dependency_index,cljs.core.name.call(null,lib_4537));
var map__4474_4539__$1 = (((((!((map__4474_4538 == null))))?(((((map__4474_4538.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4474_4538.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__4474_4538):map__4474_4538);
var global_exports_4540 = cljs.core.get.call(null,map__4474_4539__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export.call(null,ns_name,global_exports_4540,lib_4537);


var G__4541 = cljs.core.next.call(null,seq__4464_4531__$1);
var G__4542 = null;
var G__4543 = (0);
var G__4544 = (0);
seq__4464_4518 = G__4541;
chunk__4465_4519 = G__4542;
count__4466_4520 = G__4543;
i__4467_4521 = G__4544;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs)))){
return cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",loaded_libs,");");
} else {
return null;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"ns*","ns*",200417856),(function (p__4545){
var map__4546 = p__4545;
var map__4546__$1 = (((((!((map__4546 == null))))?(((((map__4546.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4546.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__4546):map__4546);
var name = cljs.core.get.call(null,map__4546__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.call(null,map__4546__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.call(null,map__4546__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.call(null,map__4546__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.call(null,map__4546__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.call(null,map__4546__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.call(null,map__4546__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.load_libs.call(null,requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs.call(null,uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-env","repl-env",-1976503928).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.call(null,"'nil';");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"ns","ns",441598760),(function (p__4548){
var map__4549 = p__4548;
var map__4549__$1 = (((((!((map__4549 == null))))?(((((map__4549.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4549.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__4549):map__4549);
var name = cljs.core.get.call(null,map__4549__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.call(null,map__4549__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.call(null,map__4549__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.call(null,map__4549__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.call(null,map__4549__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.call(null,map__4549__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.call(null,map__4549__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.emitln.call(null,"goog.provide('",cljs.compiler.munge.call(null,name),"');");

if(cljs.core._EQ_.call(null,name,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null))){
} else {
cljs.compiler.emitln.call(null,"goog.require('cljs.core');");

if(cljs.core.truth_(new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs.call(null,requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs.call(null,uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"deftype","deftype",340294561),(function (p__4551){
var map__4552 = p__4551;
var map__4552__$1 = (((((!((map__4552 == null))))?(((((map__4552.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4552.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__4552):map__4552);
var t = cljs.core.get.call(null,map__4552__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.call(null,map__4552__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.call(null,map__4552__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.call(null,map__4552__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.call(null,map__4552__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.map.call(null,cljs.compiler.munge,fields);
cljs.compiler.emitln.call(null,"");

cljs.compiler.emitln.call(null,"/**");

cljs.compiler.emitln.call(null,"* @constructor");

var seq__4554_4578 = cljs.core.seq.call(null,protocols);
var chunk__4555_4579 = null;
var count__4556_4580 = (0);
var i__4557_4581 = (0);
while(true){
if((i__4557_4581 < count__4556_4580)){
var protocol_4582 = cljs.core._nth.call(null,chunk__4555_4579,i__4557_4581);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_4582)),"}");


var G__4583 = seq__4554_4578;
var G__4584 = chunk__4555_4579;
var G__4585 = count__4556_4580;
var G__4586 = (i__4557_4581 + (1));
seq__4554_4578 = G__4583;
chunk__4555_4579 = G__4584;
count__4556_4580 = G__4585;
i__4557_4581 = G__4586;
continue;
} else {
var temp__5735__auto___4587 = cljs.core.seq.call(null,seq__4554_4578);
if(temp__5735__auto___4587){
var seq__4554_4588__$1 = temp__5735__auto___4587;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__4554_4588__$1)){
var c__4556__auto___4589 = cljs.core.chunk_first.call(null,seq__4554_4588__$1);
var G__4590 = cljs.core.chunk_rest.call(null,seq__4554_4588__$1);
var G__4591 = c__4556__auto___4589;
var G__4592 = cljs.core.count.call(null,c__4556__auto___4589);
var G__4593 = (0);
seq__4554_4578 = G__4590;
chunk__4555_4579 = G__4591;
count__4556_4580 = G__4592;
i__4557_4581 = G__4593;
continue;
} else {
var protocol_4594 = cljs.core.first.call(null,seq__4554_4588__$1);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_4594)),"}");


var G__4595 = cljs.core.next.call(null,seq__4554_4588__$1);
var G__4596 = null;
var G__4597 = (0);
var G__4598 = (0);
seq__4554_4578 = G__4595;
chunk__4555_4579 = G__4596;
count__4556_4580 = G__4597;
i__4557_4581 = G__4598;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"*/");

cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,t)," = (function (",cljs.compiler.comma_sep.call(null,fields__$1),"){");

var seq__4558_4599 = cljs.core.seq.call(null,fields__$1);
var chunk__4559_4600 = null;
var count__4560_4601 = (0);
var i__4561_4602 = (0);
while(true){
if((i__4561_4602 < count__4560_4601)){
var fld_4603 = cljs.core._nth.call(null,chunk__4559_4600,i__4561_4602);
cljs.compiler.emitln.call(null,"this.",fld_4603," = ",fld_4603,";");


var G__4604 = seq__4558_4599;
var G__4605 = chunk__4559_4600;
var G__4606 = count__4560_4601;
var G__4607 = (i__4561_4602 + (1));
seq__4558_4599 = G__4604;
chunk__4559_4600 = G__4605;
count__4560_4601 = G__4606;
i__4561_4602 = G__4607;
continue;
} else {
var temp__5735__auto___4608 = cljs.core.seq.call(null,seq__4558_4599);
if(temp__5735__auto___4608){
var seq__4558_4609__$1 = temp__5735__auto___4608;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__4558_4609__$1)){
var c__4556__auto___4610 = cljs.core.chunk_first.call(null,seq__4558_4609__$1);
var G__4611 = cljs.core.chunk_rest.call(null,seq__4558_4609__$1);
var G__4612 = c__4556__auto___4610;
var G__4613 = cljs.core.count.call(null,c__4556__auto___4610);
var G__4614 = (0);
seq__4558_4599 = G__4611;
chunk__4559_4600 = G__4612;
count__4560_4601 = G__4613;
i__4561_4602 = G__4614;
continue;
} else {
var fld_4615 = cljs.core.first.call(null,seq__4558_4609__$1);
cljs.compiler.emitln.call(null,"this.",fld_4615," = ",fld_4615,";");


var G__4616 = cljs.core.next.call(null,seq__4558_4609__$1);
var G__4617 = null;
var G__4618 = (0);
var G__4619 = (0);
seq__4558_4599 = G__4616;
chunk__4559_4600 = G__4617;
count__4560_4601 = G__4618;
i__4561_4602 = G__4619;
continue;
}
} else {
}
}
break;
}

var seq__4562_4620 = cljs.core.seq.call(null,pmasks);
var chunk__4563_4621 = null;
var count__4564_4622 = (0);
var i__4565_4623 = (0);
while(true){
if((i__4565_4623 < count__4564_4622)){
var vec__4572_4624 = cljs.core._nth.call(null,chunk__4563_4621,i__4565_4623);
var pno_4625 = cljs.core.nth.call(null,vec__4572_4624,(0),null);
var pmask_4626 = cljs.core.nth.call(null,vec__4572_4624,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_4625,"$ = ",pmask_4626,";");


var G__4627 = seq__4562_4620;
var G__4628 = chunk__4563_4621;
var G__4629 = count__4564_4622;
var G__4630 = (i__4565_4623 + (1));
seq__4562_4620 = G__4627;
chunk__4563_4621 = G__4628;
count__4564_4622 = G__4629;
i__4565_4623 = G__4630;
continue;
} else {
var temp__5735__auto___4631 = cljs.core.seq.call(null,seq__4562_4620);
if(temp__5735__auto___4631){
var seq__4562_4632__$1 = temp__5735__auto___4631;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__4562_4632__$1)){
var c__4556__auto___4633 = cljs.core.chunk_first.call(null,seq__4562_4632__$1);
var G__4634 = cljs.core.chunk_rest.call(null,seq__4562_4632__$1);
var G__4635 = c__4556__auto___4633;
var G__4636 = cljs.core.count.call(null,c__4556__auto___4633);
var G__4637 = (0);
seq__4562_4620 = G__4634;
chunk__4563_4621 = G__4635;
count__4564_4622 = G__4636;
i__4565_4623 = G__4637;
continue;
} else {
var vec__4575_4638 = cljs.core.first.call(null,seq__4562_4632__$1);
var pno_4639 = cljs.core.nth.call(null,vec__4575_4638,(0),null);
var pmask_4640 = cljs.core.nth.call(null,vec__4575_4638,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_4639,"$ = ",pmask_4640,";");


var G__4641 = cljs.core.next.call(null,seq__4562_4632__$1);
var G__4642 = null;
var G__4643 = (0);
var G__4644 = (0);
seq__4562_4620 = G__4641;
chunk__4563_4621 = G__4642;
count__4564_4622 = G__4643;
i__4565_4623 = G__4644;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"});");

return cljs.compiler.emit.call(null,body);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"defrecord","defrecord",-1367493418),(function (p__4645){
var map__4646 = p__4645;
var map__4646__$1 = (((((!((map__4646 == null))))?(((((map__4646.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4646.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__4646):map__4646);
var t = cljs.core.get.call(null,map__4646__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.call(null,map__4646__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.call(null,map__4646__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.call(null,map__4646__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.call(null,map__4646__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.concat.call(null,cljs.core.map.call(null,cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null));
cljs.compiler.emitln.call(null,"");

cljs.compiler.emitln.call(null,"/**");

cljs.compiler.emitln.call(null,"* @constructor");

var seq__4648_4672 = cljs.core.seq.call(null,protocols);
var chunk__4649_4673 = null;
var count__4650_4674 = (0);
var i__4651_4675 = (0);
while(true){
if((i__4651_4675 < count__4650_4674)){
var protocol_4676 = cljs.core._nth.call(null,chunk__4649_4673,i__4651_4675);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_4676)),"}");


var G__4677 = seq__4648_4672;
var G__4678 = chunk__4649_4673;
var G__4679 = count__4650_4674;
var G__4680 = (i__4651_4675 + (1));
seq__4648_4672 = G__4677;
chunk__4649_4673 = G__4678;
count__4650_4674 = G__4679;
i__4651_4675 = G__4680;
continue;
} else {
var temp__5735__auto___4681 = cljs.core.seq.call(null,seq__4648_4672);
if(temp__5735__auto___4681){
var seq__4648_4682__$1 = temp__5735__auto___4681;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__4648_4682__$1)){
var c__4556__auto___4683 = cljs.core.chunk_first.call(null,seq__4648_4682__$1);
var G__4684 = cljs.core.chunk_rest.call(null,seq__4648_4682__$1);
var G__4685 = c__4556__auto___4683;
var G__4686 = cljs.core.count.call(null,c__4556__auto___4683);
var G__4687 = (0);
seq__4648_4672 = G__4684;
chunk__4649_4673 = G__4685;
count__4650_4674 = G__4686;
i__4651_4675 = G__4687;
continue;
} else {
var protocol_4688 = cljs.core.first.call(null,seq__4648_4682__$1);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_4688)),"}");


var G__4689 = cljs.core.next.call(null,seq__4648_4682__$1);
var G__4690 = null;
var G__4691 = (0);
var G__4692 = (0);
seq__4648_4672 = G__4689;
chunk__4649_4673 = G__4690;
count__4650_4674 = G__4691;
i__4651_4675 = G__4692;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"*/");

cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,t)," = (function (",cljs.compiler.comma_sep.call(null,fields__$1),"){");

var seq__4652_4693 = cljs.core.seq.call(null,fields__$1);
var chunk__4653_4694 = null;
var count__4654_4695 = (0);
var i__4655_4696 = (0);
while(true){
if((i__4655_4696 < count__4654_4695)){
var fld_4697 = cljs.core._nth.call(null,chunk__4653_4694,i__4655_4696);
cljs.compiler.emitln.call(null,"this.",fld_4697," = ",fld_4697,";");


var G__4698 = seq__4652_4693;
var G__4699 = chunk__4653_4694;
var G__4700 = count__4654_4695;
var G__4701 = (i__4655_4696 + (1));
seq__4652_4693 = G__4698;
chunk__4653_4694 = G__4699;
count__4654_4695 = G__4700;
i__4655_4696 = G__4701;
continue;
} else {
var temp__5735__auto___4702 = cljs.core.seq.call(null,seq__4652_4693);
if(temp__5735__auto___4702){
var seq__4652_4703__$1 = temp__5735__auto___4702;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__4652_4703__$1)){
var c__4556__auto___4704 = cljs.core.chunk_first.call(null,seq__4652_4703__$1);
var G__4705 = cljs.core.chunk_rest.call(null,seq__4652_4703__$1);
var G__4706 = c__4556__auto___4704;
var G__4707 = cljs.core.count.call(null,c__4556__auto___4704);
var G__4708 = (0);
seq__4652_4693 = G__4705;
chunk__4653_4694 = G__4706;
count__4654_4695 = G__4707;
i__4655_4696 = G__4708;
continue;
} else {
var fld_4709 = cljs.core.first.call(null,seq__4652_4703__$1);
cljs.compiler.emitln.call(null,"this.",fld_4709," = ",fld_4709,";");


var G__4710 = cljs.core.next.call(null,seq__4652_4703__$1);
var G__4711 = null;
var G__4712 = (0);
var G__4713 = (0);
seq__4652_4693 = G__4710;
chunk__4653_4694 = G__4711;
count__4654_4695 = G__4712;
i__4655_4696 = G__4713;
continue;
}
} else {
}
}
break;
}

var seq__4656_4714 = cljs.core.seq.call(null,pmasks);
var chunk__4657_4715 = null;
var count__4658_4716 = (0);
var i__4659_4717 = (0);
while(true){
if((i__4659_4717 < count__4658_4716)){
var vec__4666_4718 = cljs.core._nth.call(null,chunk__4657_4715,i__4659_4717);
var pno_4719 = cljs.core.nth.call(null,vec__4666_4718,(0),null);
var pmask_4720 = cljs.core.nth.call(null,vec__4666_4718,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_4719,"$ = ",pmask_4720,";");


var G__4721 = seq__4656_4714;
var G__4722 = chunk__4657_4715;
var G__4723 = count__4658_4716;
var G__4724 = (i__4659_4717 + (1));
seq__4656_4714 = G__4721;
chunk__4657_4715 = G__4722;
count__4658_4716 = G__4723;
i__4659_4717 = G__4724;
continue;
} else {
var temp__5735__auto___4725 = cljs.core.seq.call(null,seq__4656_4714);
if(temp__5735__auto___4725){
var seq__4656_4726__$1 = temp__5735__auto___4725;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__4656_4726__$1)){
var c__4556__auto___4727 = cljs.core.chunk_first.call(null,seq__4656_4726__$1);
var G__4728 = cljs.core.chunk_rest.call(null,seq__4656_4726__$1);
var G__4729 = c__4556__auto___4727;
var G__4730 = cljs.core.count.call(null,c__4556__auto___4727);
var G__4731 = (0);
seq__4656_4714 = G__4728;
chunk__4657_4715 = G__4729;
count__4658_4716 = G__4730;
i__4659_4717 = G__4731;
continue;
} else {
var vec__4669_4732 = cljs.core.first.call(null,seq__4656_4726__$1);
var pno_4733 = cljs.core.nth.call(null,vec__4669_4732,(0),null);
var pmask_4734 = cljs.core.nth.call(null,vec__4669_4732,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_4733,"$ = ",pmask_4734,";");


var G__4735 = cljs.core.next.call(null,seq__4656_4726__$1);
var G__4736 = null;
var G__4737 = (0);
var G__4738 = (0);
seq__4656_4714 = G__4735;
chunk__4657_4715 = G__4736;
count__4658_4716 = G__4737;
i__4659_4717 = G__4738;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"});");

return cljs.compiler.emit.call(null,body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__4739){
var map__4740 = p__4739;
var map__4740__$1 = (((((!((map__4740 == null))))?(((((map__4740.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4740.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__4740):map__4740);
var target = cljs.core.get.call(null,map__4740__$1,new cljs.core.Keyword(null,"target","target",253001721));
var field = cljs.core.get.call(null,map__4740__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var method = cljs.core.get.call(null,map__4740__$1,new cljs.core.Keyword(null,"method","method",55703592));
var args = cljs.core.get.call(null,map__4740__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__4740__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__3537__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3537__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.call(null,target,".",cljs.compiler.munge.call(null,field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.call(null,target,".",cljs.compiler.munge.call(null,method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep.call(null,args),")");
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3537__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"host-field","host-field",-72662140),(function (ast){
return cljs.compiler.emit_dot.call(null,ast);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"host-call","host-call",1059629755),(function (ast){
return cljs.compiler.emit_dot.call(null,ast);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js","js",1768080579),(function (p__4742){
var map__4743 = p__4742;
var map__4743__$1 = (((((!((map__4743 == null))))?(((((map__4743.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4743.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__4743):map__4743);
var op = cljs.core.get.call(null,map__4743__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var env = cljs.core.get.call(null,map__4743__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var code = cljs.core.get.call(null,map__4743__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var segs = cljs.core.get.call(null,map__4743__$1,new cljs.core.Keyword(null,"segs","segs",-1940299576));
var args = cljs.core.get.call(null,map__4743__$1,new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.truth_((function (){var and__4115__auto__ = code;
if(cljs.core.truth_(and__4115__auto__)){
return goog.string.startsWith(clojure.string.trim.call(null,code),"/*");
} else {
return and__4115__auto__;
}
})())){
return cljs.compiler.emits.call(null,code);
} else {
var env__3537__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3537__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.call(null,code);
} else {
cljs.compiler.emits.call(null,cljs.core.interleave.call(null,cljs.core.concat.call(null,segs,cljs.core.repeat.call(null,null)),cljs.core.concat.call(null,args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3537__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.call(null,"goog.provide('",cljs.compiler.munge.call(null,cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.call(null,"goog.require('cljs.core');");

var seq__4749 = cljs.core.seq.call(null,table);
var chunk__4750 = null;
var count__4751 = (0);
var i__4752 = (0);
while(true){
if((i__4752 < count__4751)){
var vec__4759 = cljs.core._nth.call(null,chunk__4750,i__4752);
var sym = cljs.core.nth.call(null,vec__4759,(0),null);
var value = cljs.core.nth.call(null,vec__4759,(1),null);
var ns_4765 = cljs.core.namespace.call(null,sym);
var name_4766 = cljs.core.name.call(null,sym);
cljs.compiler.emits.call(null,"cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword.call(null,sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol.call(null,sym);
} else {
throw cljs.core.ex_info.call(null,["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type.call(null,sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.call(null,";\n");


var G__4767 = seq__4749;
var G__4768 = chunk__4750;
var G__4769 = count__4751;
var G__4770 = (i__4752 + (1));
seq__4749 = G__4767;
chunk__4750 = G__4768;
count__4751 = G__4769;
i__4752 = G__4770;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__4749);
if(temp__5735__auto__){
var seq__4749__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__4749__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__4749__$1);
var G__4771 = cljs.core.chunk_rest.call(null,seq__4749__$1);
var G__4772 = c__4556__auto__;
var G__4773 = cljs.core.count.call(null,c__4556__auto__);
var G__4774 = (0);
seq__4749 = G__4771;
chunk__4750 = G__4772;
count__4751 = G__4773;
i__4752 = G__4774;
continue;
} else {
var vec__4762 = cljs.core.first.call(null,seq__4749__$1);
var sym = cljs.core.nth.call(null,vec__4762,(0),null);
var value = cljs.core.nth.call(null,vec__4762,(1),null);
var ns_4775 = cljs.core.namespace.call(null,sym);
var name_4776 = cljs.core.name.call(null,sym);
cljs.compiler.emits.call(null,"cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword.call(null,sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol.call(null,sym);
} else {
throw cljs.core.ex_info.call(null,["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type.call(null,sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.call(null,";\n");


var G__4777 = cljs.core.next.call(null,seq__4749__$1);
var G__4778 = null;
var G__4779 = (0);
var G__4780 = (0);
seq__4749 = G__4777;
chunk__4750 = G__4778;
count__4751 = G__4779;
i__4752 = G__4780;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__4782 = arguments.length;
switch (G__4782) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.call(null,cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?cljs.analyzer.get_externs.call(null):null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq.call(null,cljs.core.keys.call(null,externs));
while(true){
if(ks){
var k_4787 = cljs.core.first.call(null,ks);
var vec__4783_4788 = cljs.core.conj.call(null,prefix,k_4787);
var top_4789 = cljs.core.nth.call(null,vec__4783_4788,(0),null);
var prefix_SINGLEQUOTE__4790 = vec__4783_4788;
if(((cljs.core.not_EQ_.call(null,new cljs.core.Symbol(null,"prototype","prototype",519166522,null),k_4787)) && ((cljs.core.get_in.call(null,known_externs,prefix_SINGLEQUOTE__4790) == null)))){
if((!(((cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,top_level),top_4789)) || (cljs.core.contains_QMARK_.call(null,known_externs,top_4789)))))){
cljs.compiler.emitln.call(null,"var ",clojure.string.join.call(null,".",cljs.core.map.call(null,cljs.compiler.munge,prefix_SINGLEQUOTE__4790)),";");

cljs.core.swap_BANG_.call(null,top_level,cljs.core.conj,top_4789);
} else {
cljs.compiler.emitln.call(null,clojure.string.join.call(null,".",cljs.core.map.call(null,cljs.compiler.munge,prefix_SINGLEQUOTE__4790)),";");
}
} else {
}

var m_4791 = cljs.core.get.call(null,externs,k_4787);
if(cljs.core.empty_QMARK_.call(null,m_4791)){
} else {
cljs.compiler.emit_externs.call(null,prefix_SINGLEQUOTE__4790,m_4791,top_level,known_externs);
}

var G__4792 = cljs.core.next.call(null,ks);
ks = G__4792;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=compiler.js.map
