// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"#")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.second(cljs.core.name(form)),"(")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"\"")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.last(cljs.core.name(form)),"\"")));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(string);
}catch (e105394){var e = e105394;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some((function (p1__105395_SHARP_){
var or__4131__auto__ = fluree.db.query.analytical.variable_QMARK_(p1__105395_SHARP_);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
if(cljs.core.coll_QMARK_(p1__105395_SHARP_)){
return (fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1(p1__105395_SHARP_) : fluree.db.query.analytical.get_vars.call(null,p1__105395_SHARP_));
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv((function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_(key);
var static_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(interm_vars,key_as_var);
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1))) && (cljs.core.not(key_as_var)) && (cljs.core.not(fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,cljs.core.re_find(/[_a-zA-Z0-9\/]*/,key)))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,((function (key_as_var,static_value){
return (function (p1__105396_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__105396_SHARP_,static_value);
});})(key_as_var,static_value))
);
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,((function (key_as_var,static_value){
return (function (p1__105397_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__105397_SHARP_,null);
});})(key_as_var,static_value))
),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rel,key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4120__auto__ = fluree.db.query.analytical.internal_filter_QMARK_(key);
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(2));
} else {
return and__4120__auto__;
}
})())){
var filter_code = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(key,(1)));
var var$ = (function (){var or__4131__auto__ = fluree.db.query.analytical.get_vars(filter_code);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vec__105402 = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__105402,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__105402,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn(var$,fun);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,((function (filter_code,var$,vec__105402,fun,_,filter_fn,key_as_var,static_value){
return (function (p1__105398_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__105398_SHARP_,null);
});})(filter_code,var$,vec__105402,fun,_,filter_fn,key_as_var,static_value))
),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$object_DASH_fn], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rel,var$], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4120__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1));
if(and__4120__auto__){
return cljs.core.re_find(/\+/,key);
} else {
return and__4120__auto__;
}
})())){
var vec__105405 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(key,/\+/);
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__105405,(0),null);
var recur_amt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__105405,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__4131__auto__ = fluree.db.query.analytical.safe_read_string(recur_amt);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,((function (vec__105405,pred,recur_amt,recur_amt__$1,key_as_var,static_value){
return (function (p1__105399_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__105399_SHARP_,pred);
});})(vec__105405,pred,recur_amt,recur_amt__$1,key_as_var,static_value))
),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$recur], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_(key)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,((function (key_as_var,static_value){
return (function (p1__105400_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__105400_SHARP_,fluree.db.query.analytical.safe_read_string(key));
});})(key_as_var,static_value))
);
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,((function (key_as_var,static_value){
return (function (p1__105401_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__105401_SHARP_,key);
});})(key_as_var,static_value))
);

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$search,cljs.core.PersistentVector.EMPTY,cljs.core.cst$kw$rel,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$opts,cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__105408_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(array,p1__105408_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var$){
var temp__5733__auto__ = fluree.db.query.analytical.variable_QMARK_(var$);
if(cljs.core.truth_(temp__5733__auto__)){
var var$__$1 = temp__5733__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys(clause);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (rel_keys,clause_keys){
return (function (acc,key){
if(cljs.core.truth_((rel_keys.cljs$core$IFn$_invoke$arity$1 ? rel_keys.cljs$core$IFn$_invoke$arity$1(key) : rel_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
});})(rel_keys,clause_keys))
,cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (a_keys,b_keys){
return (function (acc,key){
if(cljs.core.truth_((a_keys.cljs$core$IFn$_invoke$arity$1 ? a_keys.cljs$core$IFn$_invoke$arity$1(key) : a_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
});})(a_keys,b_keys))
,cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var_smt){
var temp__5733__auto__ = (function (){var or__4131__auto__ = fluree.db.query.analytical.variable_QMARK_(var_smt);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var var$ = temp__5733__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays(ns,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__4120__auto__ = max_fuel;
if(cljs.core.truth_(and__4120__auto__)){
return (add_amount > max_fuel);
} else {
return and__4120__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
if(cljs.core.truth_((function (){var and__4120__auto__ = fuel;
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.volatile_QMARK_(fuel);
} else {
return and__4120__auto__;
}
})())){
return cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause_item){
var temp__5733__auto__ = (function (){var G__105409 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(clause_item);
return (intersecting_vars.cljs$core$IFn$_invoke$arity$1 ? intersecting_vars.cljs$core$IFn$_invoke$arity$1(G__105409) : intersecting_vars.call(null,G__105409));
})();
if(cljs.core.truth_(temp__5733__auto__)){
var key_replace = temp__5733__auto__;
var replacement = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__105412,optional_QMARK_,fuel,max_fuel){
var map__105413 = p__105412;
var map__105413__$1 = (((((!((map__105413 == null))))?(((((map__105413.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105413.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105413):map__105413);
var res = map__105413__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105413__$1,cljs.core.cst$kw$vars);
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__,map__105413,map__105413__$1,res,vars){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__,map__105413,map__105413__$1,res,vars){
return (function (state_105476){
var state_val_105477 = (state_105476[(1)]);
if((state_val_105477 === (7))){
var inst_105472 = (state_105476[(2)]);
var state_105476__$1 = state_105476;
var statearr_105478_105499 = state_105476__$1;
(statearr_105478_105499[(2)] = inst_105472);


cljs.core.async.impl.ioc_helpers.process_exception(state_105476__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_105477 === (1))){
var state_105476__$1 = state_105476;
var statearr_105479_105500 = state_105476__$1;
(statearr_105479_105500[(2)] = null);

(statearr_105479_105500[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105477 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_105476,(3),Error,null,(2));
var inst_105419 = (r == null);
var state_105476__$1 = state_105476;
if(cljs.core.truth_(inst_105419)){
var statearr_105480_105501 = state_105476__$1;
(statearr_105480_105501[(1)] = (5));

} else {
var statearr_105481_105502 = state_105476__$1;
(statearr_105481_105502[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105477 === (13))){
var inst_105464 = (state_105476[(2)]);
var state_105476__$1 = state_105476;
var statearr_105482_105503 = state_105476__$1;
(statearr_105482_105503[(2)] = inst_105464);

(statearr_105482_105503[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105477 === (6))){
var inst_105466 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_105467 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses(r);
var inst_105468 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_105467,clause);
var inst_105469 = [null,inst_105468];
var inst_105470 = (new cljs.core.PersistentVector(null,2,(5),inst_105466,inst_105469,null));
var state_105476__$1 = state_105476;
var statearr_105483_105504 = state_105476__$1;
(statearr_105483_105504[(2)] = inst_105470);

(statearr_105483_105504[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105477 === (3))){
var inst_105415 = (state_105476[(2)]);
var state_105476__$1 = state_105476;
var statearr_105484_105505 = state_105476__$1;
(statearr_105484_105505[(2)] = inst_105415);


cljs.core.async.impl.ioc_helpers.process_exception(state_105476__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_105477 === (12))){
var inst_105422 = (state_105476[(7)]);
var inst_105434 = cljs.core.cst$kw$optional.cljs$core$IFn$_invoke$arity$1(q_map);
var inst_105435 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_105434);
var inst_105436 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_105422);
var inst_105437 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_105436);
var inst_105438 = cljs.core.set(inst_105437);
var inst_105439 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_105435);
var inst_105440 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_105439);
var inst_105441 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_105438,inst_105440);
var inst_105442 = (function (){var all_wd = inst_105422;
var optional = inst_105435;
var all_wd_vars = inst_105438;
var all_vars = inst_105441;
return ((function (all_wd,optional,all_wd_vars,all_vars,inst_105422,inst_105434,inst_105435,inst_105436,inst_105437,inst_105438,inst_105439,inst_105440,inst_105441,state_val_105477,c__99059__auto__,map__105413,map__105413__$1,res,vars){
return (function (p1__105410_SHARP_){
return (all_vars.cljs$core$IFn$_invoke$arity$1 ? all_vars.cljs$core$IFn$_invoke$arity$1(p1__105410_SHARP_) : all_vars.call(null,p1__105410_SHARP_));
});
;})(all_wd,optional,all_wd_vars,all_vars,inst_105422,inst_105434,inst_105435,inst_105436,inst_105437,inst_105438,inst_105439,inst_105440,inst_105441,state_val_105477,c__99059__auto__,map__105413,map__105413__$1,res,vars))
})();
var inst_105443 = cljs.core.keys(vars);
var inst_105444 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_105442,inst_105443);
var inst_105445 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_105444);
var inst_105446 = cljs.core.set(inst_105445);
var inst_105447 = (function (){var all_wd = inst_105422;
var optional = inst_105435;
var all_wd_vars = inst_105438;
var all_vars = inst_105441;
var intersecting_vars = inst_105446;
return ((function (all_wd,optional,all_wd_vars,all_vars,intersecting_vars,inst_105422,inst_105434,inst_105435,inst_105436,inst_105437,inst_105438,inst_105439,inst_105440,inst_105441,inst_105442,inst_105443,inst_105444,inst_105445,inst_105446,state_val_105477,c__99059__auto__,map__105413,map__105413__$1,res,vars){
return (function (p1__105411_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause(res,p1__105411_SHARP_);
});
;})(all_wd,optional,all_wd_vars,all_vars,intersecting_vars,inst_105422,inst_105434,inst_105435,inst_105436,inst_105437,inst_105438,inst_105439,inst_105440,inst_105441,inst_105442,inst_105443,inst_105444,inst_105445,inst_105446,state_val_105477,c__99059__auto__,map__105413,map__105413__$1,res,vars))
})();
var inst_105448 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_105447,inst_105422);
var inst_105449 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_105448);
var inst_105450 = fluree.db.query.analytical.select_from_tuples(inst_105449,res);
var inst_105451 = fluree.db.query.analytical.replace_vars_wikidata(inst_105422,inst_105446,vars);
var inst_105452 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(inst_105446,inst_105441);
var inst_105453 = fluree.db.query.analytical_wikidata.get_wikidata_tuples(q_map,inst_105451,inst_105449,inst_105450,inst_105452,inst_105435);
var state_105476__$1 = state_105476;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_105476__$1,(14),inst_105453);
} else {
if((state_val_105477 === (2))){
var inst_105474 = (state_105476[(2)]);
var state_105476__$1 = state_105476;
return cljs.core.async.impl.ioc_helpers.return_chan(state_105476__$1,inst_105474);
} else {
if((state_val_105477 === (11))){
var inst_105430 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_105431 = [null,r];
var inst_105432 = (new cljs.core.PersistentVector(null,2,(5),inst_105430,inst_105431,null));
var state_105476__$1 = state_105476;
var statearr_105485_105506 = state_105476__$1;
(statearr_105485_105506[(2)] = inst_105432);

(statearr_105485_105506[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105477 === (9))){
var state_105476__$1 = state_105476;
var statearr_105486_105507 = state_105476__$1;
(statearr_105486_105507[(2)] = optional_QMARK_);

(statearr_105486_105507[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105477 === (5))){
var inst_105421 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(q_map);
var inst_105422 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_105421);
var state_105476__$1 = (function (){var statearr_105487 = state_105476;
(statearr_105487[(7)] = inst_105422);

return statearr_105487;
})();
if(cljs.core.truth_(optional_QMARK_)){
var statearr_105488_105508 = state_105476__$1;
(statearr_105488_105508[(1)] = (8));

} else {
var statearr_105489_105509 = state_105476__$1;
(statearr_105489_105509[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105477 === (14))){
var inst_105455 = (state_105476[(2)]);
var inst_105456 = fluree.db.util.async.throw_err(inst_105455);
var inst_105457 = cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(inst_105456);
var inst_105458 = cljs.core.count(inst_105457);
var inst_105459 = fluree.db.query.analytical.add_fuel(inst_105458,fuel,max_fuel);
var inst_105460 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_105461 = [inst_105456,r];
var inst_105462 = (new cljs.core.PersistentVector(null,2,(5),inst_105460,inst_105461,null));
var state_105476__$1 = (function (){var statearr_105490 = state_105476;
(statearr_105490[(8)] = inst_105459);

return statearr_105490;
})();
var statearr_105491_105510 = state_105476__$1;
(statearr_105491_105510[(2)] = inst_105462);

(statearr_105491_105510[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105477 === (10))){
var inst_105428 = (state_105476[(2)]);
var state_105476__$1 = state_105476;
if(cljs.core.truth_(inst_105428)){
var statearr_105492_105511 = state_105476__$1;
(statearr_105492_105511[(1)] = (11));

} else {
var statearr_105493_105512 = state_105476__$1;
(statearr_105493_105512[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105477 === (8))){
var inst_105422 = (state_105476[(7)]);
var inst_105424 = cljs.core.empty_QMARK_(inst_105422);
var inst_105425 = (!(inst_105424));
var state_105476__$1 = state_105476;
var statearr_105494_105513 = state_105476__$1;
(statearr_105494_105513[(2)] = inst_105425);

(statearr_105494_105513[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__,map__105413,map__105413__$1,res,vars))
;
return ((function (switch__99036__auto__,c__99059__auto__,map__105413,map__105413__$1,res,vars){
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__99037__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__99037__auto____0 = (function (){
var statearr_105495 = [null,null,null,null,null,null,null,null,null];
(statearr_105495[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__99037__auto__);

(statearr_105495[(1)] = (1));

return statearr_105495;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__99037__auto____1 = (function (state_105476){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_105476);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e105496){if((e105496 instanceof Object)){
var ex__99040__auto__ = e105496;
var statearr_105497_105514 = state_105476;
(statearr_105497_105514[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_105476);

return cljs.core.cst$kw$recur;
} else {
throw e105496;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__105515 = state_105476;
state_105476 = G__105515;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__99037__auto__ = function(state_105476){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__99037__auto____1.call(this,state_105476);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__99037__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__99037__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__,map__105413,map__105413__$1,res,vars))
})();
var state__99061__auto__ = (function (){var statearr_105498 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_105498[(6)] = c__99059__auto__);

return statearr_105498;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__,map__105413,map__105413__$1,res,vars))
);

return c__99059__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string(block);
if(cljs.core.int_QMARK_(block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find(/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find(/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__105517 = arguments.length;
switch (G__105517) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
});

fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_105608){
var state_val_105609 = (state_105608[(1)]);
if((state_val_105609 === (7))){
var inst_105604 = (state_105608[(2)]);
var state_105608__$1 = state_105608;
var statearr_105610_105652 = state_105608__$1;
(statearr_105610_105652[(2)] = inst_105604);


cljs.core.async.impl.ioc_helpers.process_exception(state_105608__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_105609 === (20))){
var inst_105598 = (state_105608[(2)]);
var state_105608__$1 = state_105608;
var statearr_105611_105653 = state_105608__$1;
(statearr_105611_105653[(2)] = inst_105598);

(statearr_105611_105653[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105609 === (27))){
var inst_105580 = (state_105608[(2)]);
var inst_105581 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_105582 = cljs.core.PersistentVector.EMPTY;
var inst_105583 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_105584 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_105582,inst_105583);
var inst_105585 = [inst_105580,inst_105584];
var inst_105586 = (new cljs.core.PersistentVector(null,2,(5),inst_105581,inst_105585,null));
var state_105608__$1 = state_105608;
var statearr_105612_105654 = state_105608__$1;
(statearr_105612_105654[(2)] = inst_105586);

(statearr_105612_105654[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105609 === (1))){
var state_105608__$1 = state_105608;
var statearr_105613_105655 = state_105608__$1;
(statearr_105613_105655[(2)] = null);

(statearr_105613_105655[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105609 === (24))){
var inst_105565 = (state_105608[(7)]);
var inst_105571 = (state_105608[(2)]);
var inst_105572 = fluree.db.util.async.throw_err(inst_105571);
var state_105608__$1 = (function (){var statearr_105614 = state_105608;
(statearr_105614[(8)] = inst_105572);

return statearr_105614;
})();
if(cljs.core.truth_(inst_105565)){
var statearr_105615_105656 = state_105608__$1;
(statearr_105615_105656[(1)] = (25));

} else {
var statearr_105616_105657 = state_105608__$1;
(statearr_105616_105657[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105609 === (4))){
var inst_105522 = (state_105608[(9)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_105608,(3),Error,null,(2));
var inst_105522__$1 = cljs.core.first(clause);
var inst_105523 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$fdb",inst_105522__$1);
var state_105608__$1 = (function (){var statearr_105617 = state_105608;
(statearr_105617[(9)] = inst_105522__$1);

return statearr_105617;
})();
if(inst_105523){
var statearr_105618_105658 = state_105608__$1;
(statearr_105618_105658[(1)] = (5));

} else {
var statearr_105619_105659 = state_105608__$1;
(statearr_105619_105659[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105609 === (15))){
var inst_105555 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_105556 = ["$wd",clause];
var inst_105557 = (new cljs.core.PersistentVector(null,2,(5),inst_105555,inst_105556,null));
var state_105608__$1 = state_105608;
var statearr_105620_105660 = state_105608__$1;
(statearr_105620_105660[(2)] = inst_105557);

(statearr_105620_105660[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105609 === (21))){
var inst_105563 = (state_105608[(10)]);
var inst_105561 = (state_105608[(11)]);
var inst_105565 = fluree.db.query.analytical.parse_block_from_source(inst_105561);
var inst_105566 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_105567 = [cljs.core.cst$kw$sources,inst_105563];
var inst_105568 = (new cljs.core.PersistentVector(null,2,(5),inst_105566,inst_105567,null));
var inst_105569 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,inst_105568);
var state_105608__$1 = (function (){var statearr_105621 = state_105608;
(statearr_105621[(7)] = inst_105565);

return statearr_105621;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_105608__$1,(24),inst_105569);
} else {
if((state_val_105609 === (13))){
var state_105608__$1 = state_105608;
var statearr_105622_105661 = state_105608__$1;
(statearr_105622_105661[(2)] = null);

(statearr_105622_105661[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105609 === (22))){
var inst_105522 = (state_105608[(9)]);
var inst_105588 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_105522)," is not supported in Fluree"].join('');
var inst_105589 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_105590 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_105591 = cljs.core.PersistentHashMap.fromArrays(inst_105589,inst_105590);
var inst_105592 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_105588,inst_105591);
var inst_105593 = (function(){throw inst_105592})();
var state_105608__$1 = state_105608;
var statearr_105623_105662 = state_105608__$1;
(statearr_105623_105662[(2)] = inst_105593);

(statearr_105623_105662[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105609 === (6))){
var inst_105522 = (state_105608[(9)]);
var inst_105532 = clojure.string.starts_with_QMARK_(inst_105522,"$fdb");
var state_105608__$1 = state_105608;
if(inst_105532){
var statearr_105624_105663 = state_105608__$1;
(statearr_105624_105663[(1)] = (8));

} else {
var statearr_105625_105664 = state_105608__$1;
(statearr_105625_105664[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105609 === (28))){
var inst_105576 = (state_105608[(2)]);
var inst_105577 = fluree.db.util.async.throw_err(inst_105576);
var state_105608__$1 = state_105608;
var statearr_105626_105665 = state_105608__$1;
(statearr_105626_105665[(2)] = inst_105577);

(statearr_105626_105665[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105609 === (25))){
var inst_105565 = (state_105608[(7)]);
var inst_105572 = (state_105608[(8)]);
var inst_105574 = fluree.db.time_travel.as_of_block(inst_105572,inst_105565);
var state_105608__$1 = state_105608;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_105608__$1,(28),inst_105574);
} else {
if((state_val_105609 === (17))){
var inst_105600 = (state_105608[(2)]);
var state_105608__$1 = state_105608;
var statearr_105627_105666 = state_105608__$1;
(statearr_105627_105666[(2)] = inst_105600);

(statearr_105627_105666[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105609 === (3))){
var inst_105518 = (state_105608[(2)]);
var state_105608__$1 = state_105608;
var statearr_105628_105667 = state_105608__$1;
(statearr_105628_105667[(2)] = inst_105518);


cljs.core.async.impl.ioc_helpers.process_exception(state_105608__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_105609 === (12))){
var inst_105539 = (state_105608[(12)]);
var inst_105542 = (function(){throw inst_105539})();
var state_105608__$1 = state_105608;
var statearr_105629_105668 = state_105608__$1;
(statearr_105629_105668[(2)] = inst_105542);

(statearr_105629_105668[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105609 === (2))){
var inst_105606 = (state_105608[(2)]);
var state_105608__$1 = state_105608;
return cljs.core.async.impl.ioc_helpers.return_chan(state_105608__$1,inst_105606);
} else {
if((state_val_105609 === (23))){
var inst_105595 = (state_105608[(2)]);
var state_105608__$1 = state_105608;
var statearr_105630_105669 = state_105608__$1;
(statearr_105630_105669[(2)] = inst_105595);

(statearr_105630_105669[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105609 === (19))){
var state_105608__$1 = state_105608;
var statearr_105631_105670 = state_105608__$1;
(statearr_105631_105670[(2)] = null);

(statearr_105631_105670[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105609 === (11))){
var inst_105539 = (state_105608[(12)]);
var inst_105538 = (state_105608[(2)]);
var inst_105539__$1 = fluree.db.util.async.throw_err(inst_105538);
var inst_105540 = fluree.db.util.core.exception_QMARK_(inst_105539__$1);
var state_105608__$1 = (function (){var statearr_105632 = state_105608;
(statearr_105632[(12)] = inst_105539__$1);

return statearr_105632;
})();
if(inst_105540){
var statearr_105633_105671 = state_105608__$1;
(statearr_105633_105671[(1)] = (12));

} else {
var statearr_105634_105672 = state_105608__$1;
(statearr_105634_105672[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105609 === (9))){
var inst_105522 = (state_105608[(9)]);
var inst_105553 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_105522);
var state_105608__$1 = state_105608;
if(inst_105553){
var statearr_105635_105673 = state_105608__$1;
(statearr_105635_105673[(1)] = (15));

} else {
var statearr_105636_105674 = state_105608__$1;
(statearr_105636_105674[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105609 === (5))){
var inst_105525 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_105526 = cljs.core.PersistentVector.EMPTY;
var inst_105527 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_105528 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_105526,inst_105527);
var inst_105529 = [db,inst_105528];
var inst_105530 = (new cljs.core.PersistentVector(null,2,(5),inst_105525,inst_105529,null));
var state_105608__$1 = state_105608;
var statearr_105637_105675 = state_105608__$1;
(statearr_105637_105675[(2)] = inst_105530);

(statearr_105637_105675[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105609 === (14))){
var inst_105539 = (state_105608[(12)]);
var inst_105545 = (state_105608[(2)]);
var inst_105546 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_105547 = cljs.core.PersistentVector.EMPTY;
var inst_105548 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_105549 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_105547,inst_105548);
var inst_105550 = [inst_105539,inst_105549];
var inst_105551 = (new cljs.core.PersistentVector(null,2,(5),inst_105546,inst_105550,null));
var state_105608__$1 = (function (){var statearr_105638 = state_105608;
(statearr_105638[(13)] = inst_105545);

return statearr_105638;
})();
var statearr_105639_105676 = state_105608__$1;
(statearr_105639_105676[(2)] = inst_105551);

(statearr_105639_105676[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105609 === (26))){
var inst_105572 = (state_105608[(8)]);
var state_105608__$1 = state_105608;
var statearr_105640_105677 = state_105608__$1;
(statearr_105640_105677[(2)] = inst_105572);

(statearr_105640_105677[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105609 === (16))){
var state_105608__$1 = state_105608;
var statearr_105641_105678 = state_105608__$1;
(statearr_105641_105678[(1)] = (18));



return cljs.core.cst$kw$recur;
} else {
if((state_val_105609 === (10))){
var inst_105602 = (state_105608[(2)]);
var state_105608__$1 = state_105608;
var statearr_105643_105679 = state_105608__$1;
(statearr_105643_105679[(2)] = inst_105602);

(statearr_105643_105679[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105609 === (18))){
var inst_105563 = (state_105608[(10)]);
var inst_105522 = (state_105608[(9)]);
var inst_105560 = fluree.db.query.analytical.isolate_source_name(inst_105522);
var inst_105561 = fluree.db.query.analytical.isolate_source_block(inst_105522);
var inst_105562 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_105560);
var inst_105563__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(prefixes,inst_105562);
var state_105608__$1 = (function (){var statearr_105644 = state_105608;
(statearr_105644[(10)] = inst_105563__$1);

(statearr_105644[(11)] = inst_105561);

return statearr_105644;
})();
if(cljs.core.truth_(inst_105563__$1)){
var statearr_105645_105680 = state_105608__$1;
(statearr_105645_105680[(1)] = (21));

} else {
var statearr_105646_105681 = state_105608__$1;
(statearr_105646_105681[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105609 === (8))){
var inst_105522 = (state_105608[(9)]);
var inst_105534 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_105522,(4));
var inst_105535 = fluree.db.query.analytical.parse_block_from_source(inst_105534);
var inst_105536 = fluree.db.time_travel.as_of_block(db,inst_105535);
var state_105608__$1 = state_105608;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_105608__$1,(11),inst_105536);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$query$analytical$state_machine__99037__auto__ = null;
var fluree$db$query$analytical$state_machine__99037__auto____0 = (function (){
var statearr_105647 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_105647[(0)] = fluree$db$query$analytical$state_machine__99037__auto__);

(statearr_105647[(1)] = (1));

return statearr_105647;
});
var fluree$db$query$analytical$state_machine__99037__auto____1 = (function (state_105608){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_105608);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e105648){if((e105648 instanceof Object)){
var ex__99040__auto__ = e105648;
var statearr_105649_105682 = state_105608;
(statearr_105649_105682[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_105608);

return cljs.core.cst$kw$recur;
} else {
throw e105648;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__105683 = state_105608;
state_105608 = G__105683;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__99037__auto__ = function(state_105608){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__99037__auto____1.call(this,state_105608);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__99037__auto____0;
fluree$db$query$analytical$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__99037__auto____1;
return fluree$db$query$analytical$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_105650 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_105650[(6)] = c__99059__auto__);

return statearr_105650;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4;

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__105684){
var vec__105685 = p__105684;
var sub = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__105685,(0),null);
var obj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__105685,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap(cljs.core.keys(tuple_map),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__105688_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$done,cljs.core.cst$kw$followed,cljs.core.cst$kw$all],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set(p1__105688_SHARP_)]);
}),cljs.core.vals(tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map(tuple_map);
var G__105692 = subjects;
var vec__105693 = G__105692;
var seq__105694 = cljs.core.seq(vec__105693);
var first__105695 = cljs.core.first(seq__105694);
var seq__105694__$1 = cljs.core.next(seq__105694);
var subject = first__105695;
var r = seq__105694__$1;
var acc = expanded_map;
var G__105692__$1 = G__105692;
var acc__$1 = acc;
while(true){
var vec__105699 = G__105692__$1;
var seq__105700 = cljs.core.seq(vec__105699);
var first__105701 = cljs.core.first(seq__105700);
var seq__105700__$1 = cljs.core.next(seq__105700);
var subject__$1 = first__105701;
var r__$1 = seq__105700__$1;
var acc__$2 = acc__$1;
if(cljs.core.not(subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$done], null)))){
var G__105702 = r__$1;
var G__105703 = acc__$2;
G__105692__$1 = G__105702;
acc__$1 = G__105703;
continue;
} else {
var subject_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null));
var subject_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var subjects_to_follow = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__105692__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__105699,seq__105700,first__105701,seq__105700__$1,subject__$1,r__$1,acc__$2,G__105692,vec__105693,seq__105694,first__105695,seq__105694__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var self_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:(all_followed.cljs$core$IFn$_invoke$arity$1 ? all_followed.cljs$core$IFn$_invoke$arity$1(subject_to_follow) : all_followed.call(null,subject_to_follow)));
var acc_SINGLEQUOTE_ = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__4131__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,cljs.core.cst$kw$all], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null),((function (G__105692__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__105699,seq__105700,first__105701,seq__105700__$1,subject__$1,r__$1,acc__$2,G__105692,vec__105693,seq__105694,first__105695,seq__105694__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__105692__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__105699,seq__105700,first__105701,seq__105700__$1,subject__$1,r__$1,acc__$2,G__105692,vec__105693,seq__105694,first__105695,seq__105694__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,cljs.core.cst$kw$done], null)))){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null),((function (G__105692__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__105699,seq__105700,first__105701,seq__105700__$1,subject__$1,r__$1,acc__$2,G__105692,vec__105693,seq__105694,first__105695,seq__105694__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__105692__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__105699,seq__105700,first__105701,seq__105700__$1,subject__$1,r__$1,acc__$2,G__105692,vec__105693,seq__105694,first__105695,seq__105694__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__105692__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__105699,seq__105700,first__105701,seq__105700__$1,subject__$1,r__$1,acc__$2,G__105692,vec__105693,seq__105694,first__105695,seq__105694__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var subject_all_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null));
var subject_done_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__105704 = r__$1;
var G__105705 = cljs.core.assoc_in(acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$done], null),true);
G__105692__$1 = G__105704;
acc__$1 = G__105705;
continue;
} else {
var G__105706 = subjects;
var G__105707 = acc_STAR_;
G__105692__$1 = G__105706;
acc__$1 = G__105707;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,subject){
var subject_vals = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,cljs.core.cst$kw$followed], null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (subject_vals){
return (function (p1__105708_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__105708_SHARP_],null));
});})(subject_vals))
,subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_105794){
var state_val_105795 = (state_105794[(1)]);
if((state_val_105795 === (7))){
var inst_105717 = (state_105794[(2)]);
var inst_105718 = recur_map;
var inst_105719 = (1);
var state_105794__$1 = (function (){var statearr_105796 = state_105794;
(statearr_105796[(7)] = inst_105718);

(statearr_105796[(8)] = inst_105717);

(statearr_105796[(9)] = inst_105719);

return statearr_105796;
})();
var statearr_105797_105834 = state_105794__$1;
(statearr_105797_105834[(2)] = null);

(statearr_105797_105834[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105795 === (20))){
var inst_105765 = (state_105794[(2)]);
var state_105794__$1 = state_105794;
var statearr_105798_105835 = state_105794__$1;
(statearr_105798_105835[(2)] = inst_105765);

(statearr_105798_105835[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105795 === (1))){
var state_105794__$1 = state_105794;
var statearr_105799_105836 = state_105794__$1;
(statearr_105799_105836[(2)] = null);

(statearr_105799_105836[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105795 === (24))){
var inst_105790 = (state_105794[(2)]);
var state_105794__$1 = state_105794;
var statearr_105800_105837 = state_105794__$1;
(statearr_105800_105837[(2)] = inst_105790);


cljs.core.async.impl.ioc_helpers.process_exception(state_105794__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_105795 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_105794,(3),Error,null,(2));
var state_105794__$1 = state_105794;
if(cljs.core.truth_(depth)){
var statearr_105801_105838 = state_105794__$1;
(statearr_105801_105838[(1)] = (5));

} else {
var statearr_105802_105839 = state_105794__$1;
(statearr_105802_105839[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105795 === (15))){
var inst_105776 = (state_105794[(2)]);
var state_105794__$1 = state_105794;
var statearr_105803_105840 = state_105794__$1;
(statearr_105803_105840[(2)] = inst_105776);

(statearr_105803_105840[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105795 === (21))){
var inst_105752 = (state_105794[(10)]);
var inst_105744 = (state_105794[(11)]);
var inst_105759 = (state_105794[(2)]);
var inst_105760 = fluree.db.util.async.throw_err(inst_105759);
var inst_105761 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_105744,inst_105760);
var inst_105744__$1 = inst_105761;
var inst_105745 = inst_105752;
var state_105794__$1 = (function (){var statearr_105804 = state_105794;
(statearr_105804[(12)] = inst_105745);

(statearr_105804[(11)] = inst_105744__$1);

return statearr_105804;
})();
var statearr_105805_105841 = state_105794__$1;
(statearr_105805_105841[(2)] = null);

(statearr_105805_105841[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105795 === (13))){
var inst_105718 = (state_105794[(7)]);
var state_105794__$1 = state_105794;
var statearr_105806_105842 = state_105794__$1;
(statearr_105806_105842[(2)] = inst_105718);

(statearr_105806_105842[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105795 === (22))){
var inst_105783 = (state_105794[(13)]);
var state_105794__$1 = state_105794;
var statearr_105807_105843 = state_105794__$1;
(statearr_105807_105843[(2)] = inst_105783);

(statearr_105807_105843[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105795 === (6))){
var state_105794__$1 = state_105794;
var statearr_105808_105844 = state_105794__$1;
(statearr_105808_105844[(2)] = (100));

(statearr_105808_105844[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105795 === (17))){
var inst_105718 = (state_105794[(7)]);
var inst_105719 = (state_105794[(9)]);
var inst_105767 = (state_105794[(2)]);
var inst_105768 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_105769 = [(0),(2)];
var inst_105770 = (new cljs.core.PersistentVector(null,2,(5),inst_105768,inst_105769,null));
var inst_105771 = fluree.db.query.analytical.get_ns_arrays(inst_105770,inst_105767);
var inst_105772 = fluree.db.query.analytical.tuples__GT_map(inst_105718,inst_105771);
var inst_105773 = (inst_105719 + (1));
var inst_105718__$1 = inst_105772;
var inst_105719__$1 = inst_105773;
var state_105794__$1 = (function (){var statearr_105809 = state_105794;
(statearr_105809[(7)] = inst_105718__$1);

(statearr_105809[(9)] = inst_105719__$1);

return statearr_105809;
})();
var statearr_105810_105845 = state_105794__$1;
(statearr_105810_105845[(2)] = null);

(statearr_105810_105845[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105795 === (3))){
var inst_105710 = (state_105794[(2)]);
var state_105794__$1 = state_105794;
var statearr_105811_105846 = state_105794__$1;
(statearr_105811_105846[(2)] = inst_105710);


cljs.core.async.impl.ioc_helpers.process_exception(state_105794__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_105795 === (12))){
var inst_105778 = (state_105794[(2)]);
var state_105794__$1 = state_105794;
var statearr_105812_105847 = state_105794__$1;
(statearr_105812_105847[(2)] = inst_105778);

(statearr_105812_105847[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105795 === (2))){
var inst_105792 = (state_105794[(2)]);
var state_105794__$1 = state_105794;
return cljs.core.async.impl.ioc_helpers.return_chan(state_105794__$1,inst_105792);
} else {
if((state_val_105795 === (23))){
var inst_105717 = (state_105794[(8)]);
var inst_105783 = (state_105794[(13)]);
var inst_105781 = (state_105794[(14)]);
var inst_105782 = (state_105794[(15)]);
var inst_105786 = (function (){var max_depth = inst_105717;
var recur_map__$1 = inst_105782;
var subjects = inst_105781;
var tuples = inst_105783;
return ((function (max_depth,recur_map__$1,subjects,tuples,inst_105717,inst_105783,inst_105781,inst_105782,state_val_105795,c__99059__auto__){
return (function (p1__105709_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second(p1__105709_SHARP_)],null));
});
;})(max_depth,recur_map__$1,subjects,tuples,inst_105717,inst_105783,inst_105781,inst_105782,state_val_105795,c__99059__auto__))
})();
var inst_105787 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_105786,inst_105783);
var inst_105788 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_105787);
var state_105794__$1 = state_105794;
var statearr_105813_105848 = state_105794__$1;
(statearr_105813_105848[(2)] = inst_105788);

(statearr_105813_105848[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105795 === (19))){
var inst_105744 = (state_105794[(11)]);
var state_105794__$1 = state_105794;
var statearr_105814_105849 = state_105794__$1;
(statearr_105814_105849[(2)] = inst_105744);

(statearr_105814_105849[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105795 === (11))){
var inst_105718 = (state_105794[(7)]);
var inst_105729 = (state_105794[(16)]);
var inst_105724 = cljs.core.vals(inst_105718);
var inst_105725 = cljs.core.flatten(inst_105724);
var inst_105726 = cljs.core.set(inst_105725);
var inst_105727 = cljs.core.keys(inst_105718);
var inst_105728 = cljs.core.set(inst_105727);
var inst_105729__$1 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(inst_105726,inst_105728);
var inst_105730 = cljs.core.empty_QMARK_(inst_105729__$1);
var state_105794__$1 = (function (){var statearr_105815 = state_105794;
(statearr_105815[(16)] = inst_105729__$1);

return statearr_105815;
})();
if(inst_105730){
var statearr_105816_105850 = state_105794__$1;
(statearr_105816_105850[(1)] = (13));

} else {
var statearr_105817_105851 = state_105794__$1;
(statearr_105817_105851[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105795 === (9))){
var inst_105781 = (state_105794[(14)]);
var inst_105782 = (state_105794[(15)]);
var inst_105780 = (state_105794[(2)]);
var inst_105781__$1 = cljs.core.keys(inst_105780);
var inst_105782__$1 = fluree.db.query.analytical.follow_all_original_subject_paths(inst_105781__$1,inst_105780);
var inst_105783 = fluree.db.query.analytical.recur_map__GT_tuples(inst_105781__$1,inst_105782__$1);
var state_105794__$1 = (function (){var statearr_105818 = state_105794;
(statearr_105818[(13)] = inst_105783);

(statearr_105818[(14)] = inst_105781__$1);

(statearr_105818[(15)] = inst_105782__$1);

return statearr_105818;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_105819_105852 = state_105794__$1;
(statearr_105819_105852[(1)] = (22));

} else {
var statearr_105820_105853 = state_105794__$1;
(statearr_105820_105853[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105795 === (5))){
var state_105794__$1 = state_105794;
var statearr_105821_105854 = state_105794__$1;
(statearr_105821_105854[(2)] = depth);

(statearr_105821_105854[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105795 === (14))){
var inst_105729 = (state_105794[(16)]);
var inst_105740 = cljs.core.PersistentVector.EMPTY;
var inst_105741 = cljs.core.seq(inst_105729);
var inst_105742 = cljs.core.first(inst_105741);
var inst_105743 = cljs.core.next(inst_105741);
var inst_105744 = inst_105740;
var inst_105745 = inst_105729;
var state_105794__$1 = (function (){var statearr_105822 = state_105794;
(statearr_105822[(12)] = inst_105745);

(statearr_105822[(17)] = inst_105742);

(statearr_105822[(11)] = inst_105744);

(statearr_105822[(18)] = inst_105743);

return statearr_105822;
})();
var statearr_105823_105855 = state_105794__$1;
(statearr_105823_105855[(2)] = null);

(statearr_105823_105855[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105795 === (16))){
var inst_105751 = (state_105794[(19)]);
var inst_105745 = (state_105794[(12)]);
var inst_105750 = cljs.core.seq(inst_105745);
var inst_105751__$1 = cljs.core.first(inst_105750);
var inst_105752 = cljs.core.next(inst_105750);
var state_105794__$1 = (function (){var statearr_105824 = state_105794;
(statearr_105824[(19)] = inst_105751__$1);

(statearr_105824[(10)] = inst_105752);

return statearr_105824;
})();
if(cljs.core.truth_(inst_105751__$1)){
var statearr_105825_105856 = state_105794__$1;
(statearr_105825_105856[(1)] = (18));

} else {
var statearr_105826_105857 = state_105794__$1;
(statearr_105826_105857[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105795 === (10))){
var inst_105718 = (state_105794[(7)]);
var state_105794__$1 = state_105794;
var statearr_105827_105858 = state_105794__$1;
(statearr_105827_105858[(2)] = inst_105718);

(statearr_105827_105858[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105795 === (18))){
var inst_105751 = (state_105794[(19)]);
var inst_105754 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_105755 = [inst_105751,predicate];
var inst_105756 = (new cljs.core.PersistentVector(null,2,(5),inst_105754,inst_105755,null));
var inst_105757 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_105756);
var state_105794__$1 = state_105794;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_105794__$1,(21),inst_105757);
} else {
if((state_val_105795 === (8))){
var inst_105717 = (state_105794[(8)]);
var inst_105719 = (state_105794[(9)]);
var inst_105721 = (inst_105719 >= inst_105717);
var state_105794__$1 = state_105794;
if(cljs.core.truth_(inst_105721)){
var statearr_105828_105859 = state_105794__$1;
(statearr_105828_105859[(1)] = (10));

} else {
var statearr_105829_105860 = state_105794__$1;
(statearr_105829_105860[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__99037__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__99037__auto____0 = (function (){
var statearr_105830 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_105830[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__99037__auto__);

(statearr_105830[(1)] = (1));

return statearr_105830;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__99037__auto____1 = (function (state_105794){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_105794);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e105831){if((e105831 instanceof Object)){
var ex__99040__auto__ = e105831;
var statearr_105832_105861 = state_105794;
(statearr_105832_105861[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_105794);

return cljs.core.cst$kw$recur;
} else {
throw e105831;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__105862 = state_105794;
state_105794 = G__105862;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__99037__auto__ = function(state_105794){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__99037__auto____1.call(this,state_105794);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__99037__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__99037__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_105833 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_105833[(6)] = c__99059__auto__);

return statearr_105833;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__105863,clause,fuel,max_fuel){
var map__105864 = p__105863;
var map__105864__$1 = (((((!((map__105864 == null))))?(((((map__105864.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105864.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105864):map__105864);
var res = map__105864__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105864__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105864__$1,cljs.core.cst$kw$tuples);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105864__$1,cljs.core.cst$kw$vars);
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__,map__105864,map__105864__$1,res,headers,tuples,vars){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__,map__105864,map__105864__$1,res,headers,tuples,vars){
return (function (state_105993){
var state_val_105994 = (state_105993[(1)]);
if((state_val_105994 === (7))){
var inst_105890 = (state_105993[(2)]);
var state_105993__$1 = state_105993;
if(cljs.core.truth_(inst_105890)){
var statearr_105995_106054 = state_105993__$1;
(statearr_105995_106054[(1)] = (11));

} else {
var statearr_105996_106055 = state_105993__$1;
(statearr_105996_106055[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105994 === (20))){
var inst_105897 = (state_105993[(7)]);
var inst_105985 = (state_105993[(2)]);
var inst_105986 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_105987 = cljs.core.keys(inst_105897);
var inst_105988 = [inst_105987,vars,inst_105985];
var inst_105989 = cljs.core.PersistentHashMap.fromArrays(inst_105986,inst_105988);
var state_105993__$1 = state_105993;
var statearr_105997_106056 = state_105993__$1;
(statearr_105997_106056[(2)] = inst_105989);


cljs.core.async.impl.ioc_helpers.process_exception(state_105993__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_105994 === (27))){
var inst_105926 = (state_105993[(8)]);
var inst_105956 = cljs.core.PersistentHashMap.EMPTY;
var inst_105957 = fluree.db.query.analytical.tuples__GT_map(inst_105956,inst_105926);
var state_105993__$1 = state_105993;
var statearr_105998_106057 = state_105993__$1;
(statearr_105998_106057[(2)] = inst_105957);

(statearr_105998_106057[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105994 === (1))){
var state_105993__$1 = state_105993;
var statearr_105999_106058 = state_105993__$1;
(statearr_105999_106058[(2)] = null);

(statearr_105999_106058[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105994 === (24))){
var state_105993__$1 = state_105993;
var statearr_106000_106059 = state_105993__$1;
(statearr_106000_106059[(2)] = null);

(statearr_106000_106059[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105994 === (4))){
var inst_105874 = (state_105993[(9)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_105993,(3),Error,null,(2));
var inst_105874__$1 = fluree.db.query.analytical.clause__GT_rel(db,vars,clause);
var inst_105876 = (inst_105874__$1 == null);
var inst_105877 = cljs.core.not(inst_105876);
var state_105993__$1 = (function (){var statearr_106001 = state_105993;
(statearr_106001[(9)] = inst_105874__$1);

return statearr_106001;
})();
if(inst_105877){
var statearr_106002_106060 = state_105993__$1;
(statearr_106002_106060[(1)] = (5));

} else {
var statearr_106003_106061 = state_105993__$1;
(statearr_106003_106061[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105994 === (15))){
var inst_105900 = (state_105993[(10)]);
var state_105993__$1 = state_105993;
var statearr_106004_106062 = state_105993__$1;
(statearr_106004_106062[(2)] = inst_105900);

(statearr_106004_106062[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105994 === (21))){
var inst_105910 = (state_105993[(11)]);
var inst_105934 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_105910)].join('');
var inst_105935 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_105936 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_105937 = cljs.core.PersistentHashMap.fromArrays(inst_105935,inst_105936);
var inst_105938 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_105934,inst_105937);
var inst_105939 = (function(){throw inst_105938})();
var state_105993__$1 = state_105993;
var statearr_106005_106063 = state_105993__$1;
(statearr_106005_106063[(2)] = inst_105939);

(statearr_106005_106063[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105994 === (31))){
var inst_105928 = (state_105993[(12)]);
var inst_105965 = cljs.core.coll_QMARK_(inst_105928);
var state_105993__$1 = state_105993;
if(inst_105965){
var statearr_106006_106064 = state_105993__$1;
(statearr_106006_106064[(1)] = (33));

} else {
var statearr_106007_106065 = state_105993__$1;
(statearr_106007_106065[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105994 === (32))){
var inst_105976 = (state_105993[(2)]);
var state_105993__$1 = state_105993;
var statearr_106008_106066 = state_105993__$1;
(statearr_106008_106066[(2)] = inst_105976);

(statearr_106008_106066[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105994 === (33))){
var inst_105922 = (state_105993[(13)]);
var inst_105926 = (state_105993[(8)]);
var inst_105967 = cljs.core.PersistentHashMap.EMPTY;
var inst_105968 = cljs.core.first(inst_105922);
var inst_105969 = cljs.core.first(inst_105968);
var inst_105970 = cljs.core.flatten(inst_105926);
var inst_105971 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_105967,inst_105969,inst_105970);
var state_105993__$1 = state_105993;
var statearr_106009_106067 = state_105993__$1;
(statearr_106009_106067[(2)] = inst_105971);

(statearr_106009_106067[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105994 === (13))){
var inst_105897 = (state_105993[(7)]);
var inst_105912 = (state_105993[(14)]);
var inst_105901 = (state_105993[(15)]);
var inst_105900 = (state_105993[(10)]);
var inst_105895 = (state_105993[(2)]);
var inst_105896 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_105895,cljs.core.cst$kw$search);
var inst_105897__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_105895,cljs.core.cst$kw$rel);
var inst_105898 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_105895,cljs.core.cst$kw$opts);
var inst_105899 = fluree.db.query.analytical.intersecting_keys_tuples_clause(res,clause);
var inst_105900__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(inst_105898);
var inst_105901__$1 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_105898);
var inst_105903 = (function (){var map__105870 = inst_105895;
var search = inst_105896;
var rel = inst_105897__$1;
var opts = inst_105898;
var common_keys = inst_105899;
var object_fn = inst_105900__$1;
var recur_depth = inst_105901__$1;
return ((function (map__105870,search,rel,opts,common_keys,object_fn,recur_depth,inst_105897,inst_105912,inst_105901,inst_105900,inst_105895,inst_105896,inst_105897__$1,inst_105898,inst_105899,inst_105900__$1,inst_105901__$1,state_val_105994,c__99059__auto__,map__105864,map__105864__$1,res,headers,tuples,vars){
return (function (p__105902,common_key){
var vec__106010 = p__105902;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106010,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106010,(1),null);
var idx_of = fluree.db.util.core.index_of(clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__106013 = cljs.core._EQ_;
var expr__106014 = idx_of;
if(cljs.core.truth_((pred__106013.cljs$core$IFn$_invoke$arity$2 ? pred__106013.cljs$core$IFn$_invoke$arity$2((0),expr__106014) : pred__106013.call(null,(0),expr__106014)))){
return cljs.core.cst$kw$subject_DASH_fn;
} else {
if(cljs.core.truth_((pred__106013.cljs$core$IFn$_invoke$arity$2 ? pred__106013.cljs$core$IFn$_invoke$arity$2((1),expr__106014) : pred__106013.call(null,(1),expr__106014)))){
return cljs.core.cst$kw$predicate_DASH_fn;
} else {
if(cljs.core.truth_((pred__106013.cljs$core$IFn$_invoke$arity$2 ? pred__106013.cljs$core$IFn$_invoke$arity$2((2),expr__106014) : pred__106013.call(null,(2),expr__106014)))){
return cljs.core.cst$kw$object_DASH_fn;
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__106014)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of(headers,common_key);
var v = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,fluree.db.query.analytical.get_ns_arrays(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(v));
var v__$1 = (cljs.core.truth_((function (){var and__4120__auto__ = (!(single_v_QMARK_));
if(and__4120__auto__){
var and__4120__auto____$1 = object_fn;
if(cljs.core.truth_(and__4120__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,object_fn);
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
})())?cljs.core.comp.cljs$core$IFn$_invoke$arity$2(v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(clause_SINGLEQUOTE_,idx_of,cljs.core.first(v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
;})(map__105870,search,rel,opts,common_keys,object_fn,recur_depth,inst_105897,inst_105912,inst_105901,inst_105900,inst_105895,inst_105896,inst_105897__$1,inst_105898,inst_105899,inst_105900__$1,inst_105901__$1,state_val_105994,c__99059__auto__,map__105864,map__105864__$1,res,headers,tuples,vars))
})();
var inst_105904 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_105905 = cljs.core.PersistentHashMap.EMPTY;
var inst_105906 = [inst_105905,inst_105896];
var inst_105907 = (new cljs.core.PersistentVector(null,2,(5),inst_105904,inst_105906,null));
var inst_105908 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_105903,inst_105907,inst_105899);
var inst_105909 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_105908,(0),null);
var inst_105910 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_105908,(1),null);
var inst_105911 = [cljs.core.cst$kw$object_DASH_fn];
var inst_105912__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(inst_105909);
var state_105993__$1 = (function (){var statearr_106016 = state_105993;
(statearr_106016[(11)] = inst_105910);

(statearr_106016[(16)] = inst_105911);

(statearr_106016[(7)] = inst_105897__$1);

(statearr_106016[(14)] = inst_105912__$1);

(statearr_106016[(15)] = inst_105901__$1);

(statearr_106016[(10)] = inst_105900__$1);

return statearr_106016;
})();
if(cljs.core.truth_(inst_105912__$1)){
var statearr_106017_106068 = state_105993__$1;
(statearr_106017_106068[(1)] = (14));

} else {
var statearr_106018_106069 = state_105993__$1;
(statearr_106018_106069[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105994 === (22))){
var state_105993__$1 = state_105993;
var statearr_106019_106070 = state_105993__$1;
(statearr_106019_106070[(2)] = null);

(statearr_106019_106070[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105994 === (36))){
var inst_105981 = (state_105993[(2)]);
var inst_105982 = fluree.db.util.async.throw_err(inst_105981);
var state_105993__$1 = state_105993;
var statearr_106020_106071 = state_105993__$1;
(statearr_106020_106071[(2)] = inst_105982);

(statearr_106020_106071[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105994 === (29))){
var inst_105931 = (state_105993[(17)]);
var inst_105930 = (state_105993[(18)]);
var inst_105901 = (state_105993[(15)]);
var inst_105978 = (state_105993[(2)]);
var inst_105979 = fluree.db.query.analytical.tuples__GT_recur(db,inst_105931,inst_105978,inst_105901,inst_105930);
var state_105993__$1 = state_105993;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_105993__$1,(36),inst_105979);
} else {
if((state_val_105994 === (6))){
var state_105993__$1 = state_105993;
var statearr_106021_106072 = state_105993__$1;
(statearr_106021_106072[(2)] = false);

(statearr_106021_106072[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105994 === (28))){
var inst_105928 = (state_105993[(12)]);
var inst_105959 = typeof inst_105928 === 'number';
var state_105993__$1 = state_105993;
if(cljs.core.truth_(inst_105959)){
var statearr_106022_106073 = state_105993__$1;
(statearr_106022_106073[(1)] = (30));

} else {
var statearr_106023_106074 = state_105993__$1;
(statearr_106023_106074[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105994 === (25))){
var inst_105910 = (state_105993[(11)]);
var inst_105947 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_105910)].join('');
var inst_105948 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_105949 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_105950 = cljs.core.PersistentHashMap.fromArrays(inst_105948,inst_105949);
var inst_105951 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_105947,inst_105950);
var inst_105952 = (function(){throw inst_105951})();
var state_105993__$1 = state_105993;
var statearr_106024_106075 = state_105993__$1;
(statearr_106024_106075[(2)] = inst_105952);

(statearr_106024_106075[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105994 === (34))){
var state_105993__$1 = state_105993;
var statearr_106025_106076 = state_105993__$1;
(statearr_106025_106076[(2)] = null);

(statearr_106025_106076[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105994 === (17))){
var inst_105922 = (state_105993[(13)]);
var inst_105897 = (state_105993[(7)]);
var inst_105901 = (state_105993[(15)]);
var inst_105921 = (state_105993[(2)]);
var inst_105922__$1 = fluree.db.util.async.throw_err(inst_105921);
var inst_105923 = cljs.core.count(inst_105922__$1);
var inst_105924 = fluree.db.query.analytical.add_fuel(inst_105923,fuel,max_fuel);
var inst_105925 = cljs.core.vals(inst_105897);
var inst_105926 = fluree.db.query.analytical.get_ns_arrays(inst_105925,inst_105922__$1);
var state_105993__$1 = (function (){var statearr_106026 = state_105993;
(statearr_106026[(13)] = inst_105922__$1);

(statearr_106026[(8)] = inst_105926);

(statearr_106026[(19)] = inst_105924);

return statearr_106026;
})();
if(cljs.core.truth_(inst_105901)){
var statearr_106027_106077 = state_105993__$1;
(statearr_106027_106077[(1)] = (18));

} else {
var statearr_106028_106078 = state_105993__$1;
(statearr_106028_106078[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105994 === (3))){
var inst_105866 = (state_105993[(2)]);
var state_105993__$1 = state_105993;
var statearr_106029_106079 = state_105993__$1;
(statearr_106029_106079[(2)] = inst_105866);


cljs.core.async.impl.ioc_helpers.process_exception(state_105993__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_105994 === (12))){
var inst_105874 = (state_105993[(9)]);
var state_105993__$1 = state_105993;
var statearr_106030_106080 = state_105993__$1;
(statearr_106030_106080[(2)] = inst_105874);

(statearr_106030_106080[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105994 === (2))){
var inst_105991 = (state_105993[(2)]);
var state_105993__$1 = state_105993;
return cljs.core.async.impl.ioc_helpers.return_chan(state_105993__$1,inst_105991);
} else {
if((state_val_105994 === (23))){
var inst_105942 = (state_105993[(2)]);
var inst_105943 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,(2));
var inst_105944 = fluree.db.query.analytical.variable_QMARK_(inst_105943);
var state_105993__$1 = (function (){var statearr_106031 = state_105993;
(statearr_106031[(20)] = inst_105942);

return statearr_106031;
})();
if(cljs.core.truth_(inst_105944)){
var statearr_106032_106081 = state_105993__$1;
(statearr_106032_106081[(1)] = (24));

} else {
var statearr_106033_106082 = state_105993__$1;
(statearr_106033_106082[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105994 === (35))){
var inst_105974 = (state_105993[(2)]);
var state_105993__$1 = state_105993;
var statearr_106034_106083 = state_105993__$1;
(statearr_106034_106083[(2)] = inst_105974);

(statearr_106034_106083[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105994 === (19))){
var inst_105926 = (state_105993[(8)]);
var state_105993__$1 = state_105993;
var statearr_106035_106084 = state_105993__$1;
(statearr_106035_106084[(2)] = inst_105926);

(statearr_106035_106084[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105994 === (11))){
var inst_105874 = (state_105993[(9)]);
var inst_105892 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_105874);
var state_105993__$1 = state_105993;
var statearr_106036_106085 = state_105993__$1;
(statearr_106036_106085[(2)] = inst_105892);

(statearr_106036_106085[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105994 === (9))){
var state_105993__$1 = state_105993;
var statearr_106037_106086 = state_105993__$1;
(statearr_106037_106086[(2)] = false);

(statearr_106037_106086[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105994 === (5))){
var inst_105874 = (state_105993[(9)]);
var inst_105879 = inst_105874.cljs$lang$protocol_mask$partition0$;
var inst_105880 = (inst_105879 & (64));
var inst_105881 = inst_105874.cljs$core$ISeq$;
var inst_105882 = (cljs.core.PROTOCOL_SENTINEL === inst_105881);
var inst_105883 = ((inst_105880) || (inst_105882));
var state_105993__$1 = state_105993;
if(cljs.core.truth_(inst_105883)){
var statearr_106038_106087 = state_105993__$1;
(statearr_106038_106087[(1)] = (8));

} else {
var statearr_106039_106088 = state_105993__$1;
(statearr_106039_106088[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105994 === (14))){
var inst_105912 = (state_105993[(14)]);
var state_105993__$1 = state_105993;
var statearr_106040_106089 = state_105993__$1;
(statearr_106040_106089[(2)] = inst_105912);

(statearr_106040_106089[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105994 === (26))){
var inst_105930 = (state_105993[(18)]);
var inst_105954 = (state_105993[(2)]);
var state_105993__$1 = (function (){var statearr_106041 = state_105993;
(statearr_106041[(21)] = inst_105954);

return statearr_106041;
})();
if(cljs.core.truth_(inst_105930)){
var statearr_106042_106090 = state_105993__$1;
(statearr_106042_106090[(1)] = (27));

} else {
var statearr_106043_106091 = state_105993__$1;
(statearr_106043_106091[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105994 === (16))){
var inst_105910 = (state_105993[(11)]);
var inst_105911 = (state_105993[(16)]);
var inst_105916 = (state_105993[(2)]);
var inst_105917 = [inst_105916];
var inst_105918 = cljs.core.PersistentHashMap.fromArrays(inst_105911,inst_105917);
var inst_105919 = fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,inst_105910,inst_105918);
var state_105993__$1 = state_105993;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_105993__$1,(17),inst_105919);
} else {
if((state_val_105994 === (30))){
var inst_105926 = (state_105993[(8)]);
var inst_105928 = (state_105993[(12)]);
var inst_105961 = cljs.core.PersistentHashMap.EMPTY;
var inst_105962 = cljs.core.flatten(inst_105926);
var inst_105963 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_105961,inst_105928,inst_105962);
var state_105993__$1 = state_105993;
var statearr_106044_106092 = state_105993__$1;
(statearr_106044_106092[(2)] = inst_105963);

(statearr_106044_106092[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105994 === (10))){
var inst_105887 = (state_105993[(2)]);
var state_105993__$1 = state_105993;
var statearr_106045_106093 = state_105993__$1;
(statearr_106045_106093[(2)] = inst_105887);

(statearr_106045_106093[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105994 === (18))){
var inst_105931 = (state_105993[(17)]);
var inst_105910 = (state_105993[(11)]);
var inst_105928 = cljs.core.first(inst_105910);
var inst_105929 = cljs.core.first(clause);
var inst_105930 = fluree.db.query.analytical.variable_QMARK_(inst_105929);
var inst_105931__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(inst_105910,(1));
var inst_105932 = fluree.db.query.analytical.variable_QMARK_(inst_105931__$1);
var state_105993__$1 = (function (){var statearr_106046 = state_105993;
(statearr_106046[(17)] = inst_105931__$1);

(statearr_106046[(12)] = inst_105928);

(statearr_106046[(18)] = inst_105930);

return statearr_106046;
})();
if(cljs.core.truth_(inst_105932)){
var statearr_106047_106094 = state_105993__$1;
(statearr_106047_106094[(1)] = (21));

} else {
var statearr_106048_106095 = state_105993__$1;
(statearr_106048_106095[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105994 === (8))){
var state_105993__$1 = state_105993;
var statearr_106049_106096 = state_105993__$1;
(statearr_106049_106096[(2)] = true);

(statearr_106049_106096[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__,map__105864,map__105864__$1,res,headers,tuples,vars))
;
return ((function (switch__99036__auto__,c__99059__auto__,map__105864,map__105864__$1,res,headers,tuples,vars){
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__99037__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__99037__auto____0 = (function (){
var statearr_106050 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_106050[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__99037__auto__);

(statearr_106050[(1)] = (1));

return statearr_106050;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__99037__auto____1 = (function (state_105993){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_105993);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e106051){if((e106051 instanceof Object)){
var ex__99040__auto__ = e106051;
var statearr_106052_106097 = state_105993;
(statearr_106052_106097[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_105993);

return cljs.core.cst$kw$recur;
} else {
throw e106051;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__106098 = state_105993;
state_105993 = G__106098;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__99037__auto__ = function(state_105993){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__99037__auto____1.call(this,state_105993);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__99037__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__99037__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__,map__105864,map__105864__$1,res,headers,tuples,vars))
})();
var state__99061__auto__ = (function (){var statearr_106053 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_106053[(6)] = c__99059__auto__);

return statearr_106053;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__,map__105864,map__105864__$1,res,headers,tuples,vars))
);

return c__99059__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(db,res,clause){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_106194){
var state_val_106195 = (state_106194[(1)]);
if((state_val_106195 === (7))){
var inst_106112 = (state_106194[(2)]);
var state_106194__$1 = state_106194;
if(cljs.core.truth_(inst_106112)){
var statearr_106196_106229 = state_106194__$1;
(statearr_106196_106229[(1)] = (8));

} else {
var statearr_106197_106230 = state_106194__$1;
(statearr_106197_106230[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_106195 === (20))){
var inst_106159 = (state_106194[(7)]);
var state_106194__$1 = state_106194;
var statearr_106198_106231 = state_106194__$1;
(statearr_106198_106231[(2)] = inst_106159);

(statearr_106198_106231[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106195 === (1))){
var state_106194__$1 = state_106194;
var statearr_106199_106232 = state_106194__$1;
(statearr_106199_106232[(2)] = null);

(statearr_106199_106232[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106195 === (4))){
var inst_106106 = (state_106194[(8)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_106194,(3),Error,null,(2));
var inst_106105 = cljs.core.first(clause);
var inst_106106__$1 = fluree.db.query.analytical.variable_QMARK_(inst_106105);
var inst_106107 = cljs.core.last(clause);
var inst_106108 = fluree.db.query.analytical.variable_QMARK_(inst_106107);
var state_106194__$1 = (function (){var statearr_106200 = state_106194;
(statearr_106200[(8)] = inst_106106__$1);

(statearr_106200[(9)] = inst_106108);

return statearr_106200;
})();
if(cljs.core.truth_(inst_106106__$1)){
var statearr_106201_106233 = state_106194__$1;
(statearr_106201_106233[(1)] = (5));

} else {
var statearr_106202_106234 = state_106194__$1;
(statearr_106202_106234[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_106195 === (15))){
var inst_106106 = (state_106194[(8)]);
var inst_106108 = (state_106194[(9)]);
var inst_106139 = cljs.core.last(clause);
var inst_106140 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$id,inst_106139);
var inst_106141 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_106142 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_106141,inst_106140);
var inst_106143 = fluree.db.flake.min_subject_id(inst_106140);
var inst_106144 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_106145 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_106146 = [inst_106106];
var inst_106147 = (new cljs.core.PersistentVector(null,1,(5),inst_106145,inst_106146,null));
var inst_106148 = (function (){var subject_var = inst_106106;
var object_var = inst_106108;
var cid = inst_106140;
var max_sid = inst_106142;
var min_sid = inst_106143;
return ((function (subject_var,object_var,cid,max_sid,min_sid,inst_106106,inst_106108,inst_106139,inst_106140,inst_106141,inst_106142,inst_106143,inst_106144,inst_106145,inst_106146,inst_106147,state_val_106195,c__99059__auto__){
return (function (p1__106100_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__106100_SHARP_);
});
;})(subject_var,object_var,cid,max_sid,min_sid,inst_106106,inst_106108,inst_106139,inst_106140,inst_106141,inst_106142,inst_106143,inst_106144,inst_106145,inst_106146,inst_106147,state_val_106195,c__99059__auto__))
})();
var inst_106149 = (inst_106142 + (1));
var inst_106150 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_106143,inst_106149);
var inst_106151 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_106148,inst_106150);
var inst_106152 = cljs.core.PersistentHashMap.EMPTY;
var inst_106153 = [inst_106147,inst_106151,inst_106152];
var inst_106154 = cljs.core.PersistentHashMap.fromArrays(inst_106144,inst_106153);
var state_106194__$1 = state_106194;
var statearr_106203_106235 = state_106194__$1;
(statearr_106203_106235[(2)] = inst_106154);

(statearr_106203_106235[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106195 === (21))){
var inst_106159 = (state_106194[(7)]);
var inst_106163 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_106159);
var state_106194__$1 = state_106194;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_106194__$1,(23),inst_106163);
} else {
if((state_val_106195 === (13))){
var inst_106188 = (state_106194[(2)]);
var state_106194__$1 = state_106194;
var statearr_106204_106236 = state_106194__$1;
(statearr_106204_106236[(2)] = inst_106188);

(statearr_106204_106236[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106195 === (22))){
var inst_106108 = (state_106194[(9)]);
var inst_106168 = (state_106194[(2)]);
var inst_106169 = fluree.db.flake.sid__GT_cid(inst_106168);
var inst_106170 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$name,inst_106169);
var inst_106171 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_106172 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_106173 = [inst_106108];
var inst_106174 = (new cljs.core.PersistentVector(null,1,(5),inst_106172,inst_106173,null));
var inst_106175 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_106176 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_106177 = [inst_106170];
var inst_106178 = (new cljs.core.PersistentVector(null,1,(5),inst_106176,inst_106177,null));
var inst_106179 = [inst_106178];
var inst_106180 = (new cljs.core.PersistentVector(null,1,(5),inst_106175,inst_106179,null));
var inst_106181 = cljs.core.PersistentHashMap.EMPTY;
var inst_106182 = [inst_106174,inst_106180,inst_106181];
var inst_106183 = cljs.core.PersistentHashMap.fromArrays(inst_106171,inst_106182);
var state_106194__$1 = state_106194;
var statearr_106205_106237 = state_106194__$1;
(statearr_106205_106237[(2)] = inst_106183);

(statearr_106205_106237[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106195 === (6))){
var inst_106106 = (state_106194[(8)]);
var state_106194__$1 = state_106194;
var statearr_106206_106238 = state_106194__$1;
(statearr_106206_106238[(2)] = inst_106106);

(statearr_106206_106238[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106195 === (17))){
var inst_106159 = (state_106194[(7)]);
var inst_106159__$1 = cljs.core.first(clause);
var inst_106160 = typeof inst_106159__$1 === 'number';
var state_106194__$1 = (function (){var statearr_106207 = state_106194;
(statearr_106207[(7)] = inst_106159__$1);

return statearr_106207;
})();
if(cljs.core.truth_(inst_106160)){
var statearr_106208_106239 = state_106194__$1;
(statearr_106208_106239[(1)] = (20));

} else {
var statearr_106209_106240 = state_106194__$1;
(statearr_106209_106240[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_106195 === (3))){
var inst_106101 = (state_106194[(2)]);
var state_106194__$1 = state_106194;
var statearr_106210_106241 = state_106194__$1;
(statearr_106210_106241[(2)] = inst_106101);


cljs.core.async.impl.ioc_helpers.process_exception(state_106194__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_106195 === (12))){
var inst_106108 = (state_106194[(9)]);
var state_106194__$1 = state_106194;
if(cljs.core.truth_(inst_106108)){
var statearr_106211_106242 = state_106194__$1;
(statearr_106211_106242[(1)] = (17));

} else {
var statearr_106212_106243 = state_106194__$1;
(statearr_106212_106243[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_106195 === (2))){
var inst_106192 = (state_106194[(2)]);
var state_106194__$1 = state_106194;
return cljs.core.async.impl.ioc_helpers.return_chan(state_106194__$1,inst_106192);
} else {
if((state_val_106195 === (23))){
var inst_106165 = (state_106194[(2)]);
var inst_106166 = fluree.db.util.async.throw_err(inst_106165);
var state_106194__$1 = state_106194;
var statearr_106213_106244 = state_106194__$1;
(statearr_106213_106244[(2)] = inst_106166);

(statearr_106213_106244[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106195 === (19))){
var inst_106186 = (state_106194[(2)]);
var state_106194__$1 = state_106194;
var statearr_106214_106245 = state_106194__$1;
(statearr_106214_106245[(2)] = inst_106186);

(statearr_106214_106245[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106195 === (11))){
var inst_106121 = ["_tx",null,"_block",null];
var inst_106122 = (new cljs.core.PersistentArrayMap(null,2,inst_106121,null));
var inst_106123 = (new cljs.core.PersistentHashSet(null,inst_106122,null));
var inst_106124 = cljs.core.last(clause);
var inst_106125 = (inst_106123.cljs$core$IFn$_invoke$arity$1 ? inst_106123.cljs$core$IFn$_invoke$arity$1(inst_106124) : inst_106123.call(null,inst_106124));
var state_106194__$1 = state_106194;
if(cljs.core.truth_(inst_106125)){
var statearr_106215_106246 = state_106194__$1;
(statearr_106215_106246[(1)] = (14));

} else {
var statearr_106216_106247 = state_106194__$1;
(statearr_106216_106247[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_106195 === (9))){
var inst_106106 = (state_106194[(8)]);
var state_106194__$1 = state_106194;
if(cljs.core.truth_(inst_106106)){
var statearr_106217_106248 = state_106194__$1;
(statearr_106217_106248[(1)] = (11));

} else {
var statearr_106218_106249 = state_106194__$1;
(statearr_106218_106249[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_106195 === (5))){
var inst_106108 = (state_106194[(9)]);
var state_106194__$1 = state_106194;
var statearr_106219_106250 = state_106194__$1;
(statearr_106219_106250[(2)] = inst_106108);

(statearr_106219_106250[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106195 === (14))){
var inst_106106 = (state_106194[(8)]);
var inst_106108 = (state_106194[(9)]);
var inst_106127 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_106128 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_106129 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_106130 = [inst_106106];
var inst_106131 = (new cljs.core.PersistentVector(null,1,(5),inst_106129,inst_106130,null));
var inst_106132 = (function (){var subject_var = inst_106106;
var object_var = inst_106108;
var min_sid = inst_106127;
var max_sid = (0);
return ((function (subject_var,object_var,min_sid,max_sid,inst_106106,inst_106108,inst_106127,inst_106128,inst_106129,inst_106130,inst_106131,state_val_106195,c__99059__auto__){
return (function (p1__106099_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__106099_SHARP_);
});
;})(subject_var,object_var,min_sid,max_sid,inst_106106,inst_106108,inst_106127,inst_106128,inst_106129,inst_106130,inst_106131,state_val_106195,c__99059__auto__))
})();
var inst_106133 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_106127,(0));
var inst_106134 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_106132,inst_106133);
var inst_106135 = cljs.core.PersistentHashMap.EMPTY;
var inst_106136 = [inst_106131,inst_106134,inst_106135];
var inst_106137 = cljs.core.PersistentHashMap.fromArrays(inst_106128,inst_106136);
var state_106194__$1 = state_106194;
var statearr_106220_106251 = state_106194__$1;
(statearr_106220_106251[(2)] = inst_106137);

(statearr_106220_106251[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106195 === (16))){
var inst_106156 = (state_106194[(2)]);
var state_106194__$1 = state_106194;
var statearr_106221_106252 = state_106194__$1;
(statearr_106221_106252[(2)] = inst_106156);

(statearr_106221_106252[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106195 === (10))){
var inst_106190 = (state_106194[(2)]);
var state_106194__$1 = state_106194;
var statearr_106222_106253 = state_106194__$1;
(statearr_106222_106253[(2)] = inst_106190);


cljs.core.async.impl.ioc_helpers.process_exception(state_106194__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_106195 === (18))){
var state_106194__$1 = state_106194;
var statearr_106223_106254 = state_106194__$1;
(statearr_106223_106254[(2)] = null);

(statearr_106223_106254[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106195 === (8))){
var inst_106114 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_106115 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_106116 = cljs.core.PersistentHashMap.fromArrays(inst_106114,inst_106115);
var inst_106117 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When using rdf:type, either a subject or a type (collection) must be specified.",inst_106116);
var inst_106118 = (function(){throw inst_106117})();
var state_106194__$1 = state_106194;
var statearr_106224_106255 = state_106194__$1;
(statearr_106224_106255[(2)] = inst_106118);

(statearr_106224_106255[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__99037__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__99037__auto____0 = (function (){
var statearr_106225 = [null,null,null,null,null,null,null,null,null,null];
(statearr_106225[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__99037__auto__);

(statearr_106225[(1)] = (1));

return statearr_106225;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__99037__auto____1 = (function (state_106194){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_106194);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e106226){if((e106226 instanceof Object)){
var ex__99040__auto__ = e106226;
var statearr_106227_106256 = state_106194;
(statearr_106227_106256[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_106194);

return cljs.core.cst$kw$recur;
} else {
throw e106226;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__106257 = state_106194;
state_106194 = G__106257;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__99037__auto__ = function(state_106194){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__99037__auto____1.call(this,state_106194);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__99037__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__99037__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_106228 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_106228[(6)] = c__99059__auto__);

return statearr_106228;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum(coll) / cljs.core.count(coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(coll);
var size = cljs.core.count(coll);
var med = (size >> (1));
var G__106264 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,med);
if(cljs.core.even_QMARK_(size)){
return ((G__106264 + cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,(med - (1)))) / (2));
} else {
return G__106264;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg(coll);
var sum__$1 = sum((function (){var iter__4523__auto__ = ((function (mean){
return (function fluree$db$query$analytical$variance_$_iter__106265(s__106266){
return (new cljs.core.LazySeq(null,((function (mean){
return (function (){
var s__106266__$1 = s__106266;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__106266__$1);
if(temp__5735__auto__){
var s__106266__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__106266__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__106266__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__106268 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__106267 = (0);
while(true){
if((i__106267 < size__4522__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__106267);
var delta = (x - mean);
cljs.core.chunk_append(b__106268,(delta * delta));

var G__106270 = (i__106267 + (1));
i__106267 = G__106270;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__106268),fluree$db$query$analytical$variance_$_iter__106265(cljs.core.chunk_rest(s__106266__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__106268),null);
}
} else {
var x = cljs.core.first(s__106266__$2);
var delta = (x - mean);
return cljs.core.cons((delta * delta),fluree$db$query$analytical$variance_$_iter__106265(cljs.core.rest(s__106266__$2)));
}
} else {
return null;
}
break;
}
});})(mean))
,null,null));
});})(mean))
;
return iter__4523__auto__(coll);
})());
return (sum__$1 / cljs.core.count(coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
var G__106269 = variance(coll);
return Math.sqrt(G__106269);
});
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$sym$variance,cljs.core.cst$sym$count,cljs.core.cst$sym$median,cljs.core.cst$sym$groupconcat,cljs.core.cst$sym$sum,cljs.core.cst$sym$abs,cljs.core.cst$sym$min,cljs.core.cst$sym$ceil,cljs.core.cst$sym$max,cljs.core.cst$sym$count_DASH_distinct,cljs.core.cst$sym$avg,cljs.core.cst$sym$floor,cljs.core.cst$sym$str,cljs.core.cst$sym$stddev,cljs.core.cst$sym$rand,cljs.core.cst$sym$sample],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4219__auto__ = n;
var y__4220__auto__ = (- n);
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
}),(function() {
var G__106271 = null;
var G__106271__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__106271__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.last(acc)) < (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__106271 = function(n,coll){
switch(arguments.length){
case 1:
return G__106271__1.call(this,n);
case 2:
return G__106271__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__106271.cljs$core$IFn$_invoke$arity$1 = G__106271__1;
G__106271.cljs$core$IFn$_invoke$arity$2 = G__106271__2;
return G__106271;
})()
,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__106272 = null;
var G__106272__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__106272__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.first(acc)) > (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.next(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__106272 = function(n,coll){
switch(arguments.length){
case 1:
return G__106272__1.call(this,n);
case 2:
return G__106272__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__106272.cljs$core$IFn$_invoke$arity$1 = G__106272__1;
G__106272.cljs$core$IFn$_invoke$arity$2 = G__106272__2;
return G__106272;
})()
,(function (coll){
return cljs.core.count(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll));
}),avg,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__106273 = null;
var G__106273__1 = (function (coll){
return cljs.core.rand_nth(coll);
});
var G__106273__2 = (function (n,coll){
return cljs.core.vec(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(n,(function (){
return cljs.core.rand_nth(coll);
})));
});
G__106273 = function(n,coll){
switch(arguments.length){
case 1:
return G__106273__1.call(this,n);
case 2:
return G__106273__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__106273.cljs$core$IFn$_invoke$arity$1 = G__106273__1;
G__106273.cljs$core$IFn$_invoke$arity$2 = G__106273__2;
return G__106273;
})()
,(function (n,coll){
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.shuffle(coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
var and__4120__auto__ = typeof x === 'string';
if(and__4120__auto__){
return cljs.core.re_matches(/^\(.+\)$/,x);
} else {
return and__4120__auto__;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
var and__4120__auto__ = typeof x === 'string';
if(and__4120__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,x);
} else {
return and__4120__auto__;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(x);
var as_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$as,cljs.core.first(list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last(list_agg))].join('')):cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second(list_agg);
if(cljs.core.coll_QMARK_(func_list)){
return func_list;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})():list_agg);
var list_count = cljs.core.count(func_list);
var vec__106274 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),cljs.core.second(func_list),cljs.core.last(func_list)], null):((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$sample,cljs.core.first(func_list)))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),null,cljs.core.last(func_list)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
)));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106274,(0),null);
var arg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106274,(1),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106274,(2),null);
var agg_fn = (function (){var temp__5733__auto__ = (fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1(fun) : fluree.db.query.analytical.built_in_aggregates.call(null,fun));
if(cljs.core.truth_(temp__5733__auto__)){
var agg_fn = temp__5733__auto__;
if(cljs.core.truth_(arg)){
return ((function (agg_fn,temp__5733__auto__,list_agg,as_QMARK_,as,func_list,list_count,vec__106274,fun,arg,var$){
return (function (coll){
return (agg_fn.cljs$core$IFn$_invoke$arity$2 ? agg_fn.cljs$core$IFn$_invoke$arity$2(arg,coll) : agg_fn.call(null,arg,coll));
});
;})(agg_fn,temp__5733__auto__,list_agg,as_QMARK_,as,func_list,list_count,vec__106274,fun,arg,var$))
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vec__106277 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_(var$)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(var$),cljs.core.cst$sym$distinct)));
var variable = ((distinct_QMARK_)?cljs.core.second(var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?((function (distinct_QMARK_,variable,list_agg,as_QMARK_,as,func_list,list_count,vec__106274,fun,arg,var$,agg_fn){
return (function (coll){
var G__106280 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll);
return (agg_fn.cljs$core$IFn$_invoke$arity$1 ? agg_fn.cljs$core$IFn$_invoke$arity$1(G__106280) : agg_fn.call(null,G__106280));
});})(distinct_QMARK_,variable,list_agg,as_QMARK_,as,func_list,list_count,vec__106274,fun,arg,var$,agg_fn))
:agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106277,(0),null);
var variable = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106277,(1),null);
var _ = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(variable) : valid_var.call(null,variable)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$variable,variable,cljs.core.cst$kw$as,as,cljs.core.cst$kw$code,agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__106281 = agg;
var map__106281__$1 = (((((!((map__106281 == null))))?(((((map__106281.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106281.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__106281):map__106281);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106281__$1,cljs.core.cst$kw$variable);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106281__$1,cljs.core.cst$kw$as);
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106281__$1,cljs.core.cst$kw$code);
var agg_params = cljs.core.flatten(fluree.db.query.analytical.select_from_tuples(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = (code.cljs$core$IFn$_invoke$arity$1 ? code.cljs$core$IFn$_invoke$arity$1(agg_params) : code.call(null,agg_params));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,agg){
var vec__106284 = fluree.db.query.analytical.calculate_aggregate(res__$1,agg);
var as = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106284,(0),null);
var agg_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106284,(1),null);
var map__106287 = res__$1;
var map__106287__$1 = (((((!((map__106287 == null))))?(((((map__106287.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106287.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__106287):map__106287);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106287__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106287__$1,cljs.core.cst$kw$tuples);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (vec__106284,as,agg_result,map__106287,map__106287__$1,headers,tuples){
return (function (p1__106283_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__106283_SHARP_),agg_result);
});})(vec__106284,as,agg_result,map__106287,map__106287__$1,headers,tuples))
,tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$headers,headers_SINGLEQUOTE_,cljs.core.cst$kw$tuples,tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,cljs.core.keys(q_map));
var vals = cljs.core.vals(q_map);
return cljs.core.zipmap(keys,vals);
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 */
fluree.db.query.analytical.find_match = (function fluree$db$query$analytical$find_match(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__106289_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__106289_SHARP_);
}),a_idxs);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (a_tuple_part){
return (function (acc,b_tuple){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (a_tuple_part){
return (function (p1__106290_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__106290_SHARP_);
});})(a_tuple_part))
,b_idxs))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4131__auto__ = acc;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (a_tuple_part){
return (function (p1__106291_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__106291_SHARP_);
});})(a_tuple_part))
,b_not_idxs)));
} else {
return acc;
}
});})(a_tuple_part))
,null,b_tuples);
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__106292_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__106292_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv(((function (a_tuple_part){
return (function (p__106295,row,b_tuple){
var vec__106296 = p__106295;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106296,(0),null);
var b_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106296,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (vec__106296,acc,b_rows,a_tuple_part){
return (function (p1__106293_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__106293_SHARP_);
});})(vec__106296,acc,b_rows,a_tuple_part))
,b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4131__auto__ = acc;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (vec__106296,acc,b_rows,a_tuple_part){
return (function (p1__106294_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__106294_SHARP_);
});})(vec__106296,acc,b_rows,a_tuple_part))
,b_not_idxs))),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
});})(a_tuple_part))
,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_res,b_res);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (common_keys){
return (function (p1__106299_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_res),p1__106299_SHARP_);
});})(common_keys))
,common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (common_keys,a_idxs){
return (function (p1__106300_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res),p1__106300_SHARP_);
});})(common_keys,a_idxs))
,common_keys);
var b_not_idxs = (function (){var G__106305 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__106307 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res));
var fexpr__106306 = ((function (G__106307,common_keys,a_idxs,b_idxs){
return (function (p1__106301_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__106301_SHARP_);
});})(G__106307,common_keys,a_idxs,b_idxs))
;
return fexpr__106306(G__106307);
})()),cljs.core.set(b_idxs));
var fexpr__106304 = ((function (G__106305,common_keys,a_idxs,b_idxs){
return (function (p1__106302_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__106302_SHARP_);
});})(G__106305,common_keys,a_idxs,b_idxs))
;
return fexpr__106304(G__106305);
})();
var c_tuples = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (common_keys,a_idxs,b_idxs,b_not_idxs){
return (function (a_tuple){
return fluree.db.query.analytical.find_match(a_tuple,a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_res),b_idxs,b_not_idxs);
});})(common_keys,a_idxs,b_idxs,b_not_idxs))
,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_res)));
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (common_keys,a_idxs,b_idxs,b_not_idxs,c_tuples){
return (function (p1__106303_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res),p1__106303_SHARP_);
});})(common_keys,a_idxs,b_idxs,b_not_idxs,c_tuples))
,b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_res)], 0)),cljs.core.cst$kw$tuples,c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (common_keys){
return (function (p1__106308_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),p1__106308_SHARP_);
});})(common_keys))
,common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (common_keys,a_idxs){
return (function (p1__106309_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__106309_SHARP_);
});})(common_keys,a_idxs))
,common_keys);
var b_not_idxs = (function (){var G__106314 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__106316 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__106315 = ((function (G__106316,common_keys,a_idxs,b_idxs){
return (function (p1__106310_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__106310_SHARP_);
});})(G__106316,common_keys,a_idxs,b_idxs))
;
return fexpr__106315(G__106316);
})()),cljs.core.set(b_idxs));
var fexpr__106313 = ((function (G__106314,common_keys,a_idxs,b_idxs){
return (function (p1__106311_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__106311_SHARP_);
});})(G__106314,common_keys,a_idxs,b_idxs))
;
return fexpr__106313(G__106314);
})();
var c_tuples = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (common_keys,a_idxs,b_idxs,b_not_idxs){
return (function (a_tuple){
var matches = fluree.db.query.analytical.find_match(a_tuple,a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_idxs,b_not_idxs);
var or__4131__auto__ = matches;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null))], null);
}
});})(common_keys,a_idxs,b_idxs,b_not_idxs))
,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_tuples)));
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (common_keys,a_idxs,b_idxs,b_not_idxs,c_tuples){
return (function (p1__106312_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__106312_SHARP_);
});})(common_keys,a_idxs,b_idxs,b_not_idxs,c_tuples))
,b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),cljs.core.cst$kw$tuples,c_tuples], null);
});
/**
 * UNION clause takes a left-hand side, which is inner-joined, and a right-hand side, which is inner-joined.
 *   Any tuples unbound by the other set are included.
 */
fluree.db.query.analytical.outer_union = (function fluree$db$query$analytical$outer_union(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (common_keys){
return (function (p1__106317_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),p1__106317_SHARP_);
});})(common_keys))
,common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (common_keys,a_idxs){
return (function (p1__106318_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__106318_SHARP_);
});})(common_keys,a_idxs))
,common_keys);
var b_not_idxs = (function (){var G__106327 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__106329 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__106328 = ((function (G__106329,common_keys,a_idxs,b_idxs){
return (function (p1__106319_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__106319_SHARP_);
});})(G__106329,common_keys,a_idxs,b_idxs))
;
return fexpr__106328(G__106329);
})()),cljs.core.set(b_idxs));
var fexpr__106326 = ((function (G__106327,common_keys,a_idxs,b_idxs){
return (function (p1__106320_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__106320_SHARP_);
});})(G__106327,common_keys,a_idxs,b_idxs))
;
return fexpr__106326(G__106327);
})();
var vec__106323 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (common_keys,a_idxs,b_idxs,b_not_idxs){
return (function (p__106330,a_tuple){
var vec__106331 = p__106330;
var c_tuples = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106331,(0),null);
var b_matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106331,(1),null);
var vec__106334 = fluree.db.query.analytical.find_match_PLUS_row_nums(a_tuple,a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_idxs,b_not_idxs);
var matches = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106334,(0),null);
var matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106334,(1),null);
var matches__$1 = (function (){var or__4131__auto__ = matches;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null))], null);
}
})();
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.cljs$core$IFn$_invoke$arity$2(c_tuples,matches__$1),clojure.set.union.cljs$core$IFn$_invoke$arity$2(b_matched_rows,matched_rows)], null);
});})(common_keys,a_idxs,b_idxs,b_not_idxs))
,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_tuples));
var c_tuples = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106323,(0),null);
var b_matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106323,(1),null);
var b_unmatched_rows = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(b_matched_rows,cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),cljs.core.count(cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples))));
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (common_keys,a_idxs,b_idxs,b_not_idxs,vec__106323,c_tuples,b_matched_rows,b_unmatched_rows){
return (function (p1__106321_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__106321_SHARP_);
});})(common_keys,a_idxs,b_idxs,b_not_idxs,vec__106323,c_tuples,b_matched_rows,b_unmatched_rows))
,b_not_idxs));
var b_idxs__GT_c_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (common_keys,a_idxs,b_idxs,b_not_idxs,vec__106323,c_tuples,b_matched_rows,b_unmatched_rows,c_headers){
return (function (p1__106322_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__106322_SHARP_);
});})(common_keys,a_idxs,b_idxs,b_not_idxs,vec__106323,c_tuples,b_matched_rows,b_unmatched_rows,c_headers))
,c_headers);
var c_from_unmatched_b_tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (common_keys,a_idxs,b_idxs,b_not_idxs,vec__106323,c_tuples,b_matched_rows,b_unmatched_rows,c_headers,b_idxs__GT_c_idxs){
return (function (b_row){
var b_tuple = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_row));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (b_tuple,common_keys,a_idxs,b_idxs,b_not_idxs,vec__106323,c_tuples,b_matched_rows,b_unmatched_rows,c_headers,b_idxs__GT_c_idxs){
return (function (c_idx){
if((c_idx == null)){
return null;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_tuple,c_idx);
}
});})(b_tuple,common_keys,a_idxs,b_idxs,b_not_idxs,vec__106323,c_tuples,b_matched_rows,b_unmatched_rows,c_headers,b_idxs__GT_c_idxs))
,b_idxs__GT_c_idxs);
});})(common_keys,a_idxs,b_idxs,b_not_idxs,vec__106323,c_tuples,b_matched_rows,b_unmatched_rows,c_headers,b_idxs__GT_c_idxs))
,b_unmatched_rows);
var c_tuples__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(c_tuples,c_from_unmatched_b_tuples);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),cljs.core.cst$kw$tuples,c_tuples__$1], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",filter_code_req)),")"].join('');
var vec__106338 = (function (){var or__4131__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106338,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106338,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (filter_code_req_str,vec__106338,filter_code_req_STAR_,_,filter_code_req_str_STAR_){
return (function (p1__106337_SHARP_){
return fluree.db.query.analytical_filter.filter_row(headers,p1__106337_SHARP_,filter_code_req_str_STAR_);
});})(filter_code_req_str,vec__106338,filter_code_req_STAR_,_,filter_code_req_str_STAR_))
,tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (tuples__$1,filt){
var var_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY);
var vec__106343 = (function (){var or__4131__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$3(filt,valid_vars,var_atom);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var filt_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106343,(0),null);
var filt_vars = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106343,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (var_atom,vec__106343,filt_STAR_,filt_vars,filt_str){
return (function (p1__106341_SHARP_){
return fluree.db.util.core.index_of(headers,p1__106341_SHARP_);
});})(var_atom,vec__106343,filt_STAR_,filt_vars,filt_str))
,cljs.core.deref(filt_vars));
var filtered_tuples = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (var_atom,vec__106343,filt_STAR_,filt_vars,filt_str,filt_vars_idxs){
return (function (acc,clause){
if(cljs.core.every_QMARK_(((function (var_atom,vec__106343,filt_STAR_,filt_vars,filt_str,filt_vars_idxs){
return (function (p1__106342_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,p1__106342_SHARP_);
});})(var_atom,vec__106343,filt_STAR_,filt_vars,filt_str,filt_vars_idxs))
,filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row(headers,clause,filt_str))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
}
});})(var_atom,vec__106343,filt_STAR_,filt_vars,filt_str,filt_vars_idxs))
,cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__106346,filters,optional_QMARK_){
var map__106347 = p__106346;
var map__106347__$1 = (((((!((map__106347 == null))))?(((((map__106347.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106347.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__106347):map__106347);
var tuple_map = map__106347__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106347__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106347__$1,cljs.core.cst$kw$vars);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106347__$1,cljs.core.cst$kw$tuples);
var valid_vars = cljs.core.set(headers);
var header_vec = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,vars,cljs.core.cst$kw$tuples,fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters(filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty(filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required(header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters(filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty(filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,vars,cljs.core.cst$kw$tuples,tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__106349 = clause;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106349,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106349,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_(k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
var map__106352 = res;
var map__106352__$1 = (((((!((map__106352 == null))))?(((((map__106352.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106352.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__106352):map__106352);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106352__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106352__$1,cljs.core.cst$kw$vars);
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_(v))?cljs.core.second(fluree.db.query.analytical.calculate_aggregate(res,fluree.db.query.analytical.parse_aggregate(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(v,(1)),cljs.core.set((function (){var temp__5733__auto__ = cljs.core.keys(vars);
if(cljs.core.truth_(temp__5733__auto__)){
var valid_var = temp__5733__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_106407){
var state_val_106408 = (state_106407[(1)]);
if((state_val_106408 === (7))){
var inst_106381 = (state_106407[(7)]);
var inst_106379 = (state_106407[(2)]);
var inst_106380 = fluree.db.util.async.throw_err(inst_106379);
var inst_106381__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_106380,(0),null);
var inst_106382 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_106380,(1),null);
var inst_106383 = (inst_106381__$1 == null);
var state_106407__$1 = (function (){var statearr_106409 = state_106407;
(statearr_106409[(8)] = inst_106382);

(statearr_106409[(7)] = inst_106381__$1);

return statearr_106409;
})();
if(cljs.core.truth_(inst_106383)){
var statearr_106410_106438 = state_106407__$1;
(statearr_106410_106438[(1)] = (8));

} else {
var statearr_106411_106439 = state_106407__$1;
(statearr_106411_106439[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_106408 === (1))){
var inst_106361 = cljs.core.seq(optional_clauses);
var inst_106362 = cljs.core.first(inst_106361);
var inst_106363 = cljs.core.next(inst_106361);
var inst_106364 = optional_clauses;
var inst_106365 = where_tuples;
var state_106407__$1 = (function (){var statearr_106412 = state_106407;
(statearr_106412[(9)] = inst_106365);

(statearr_106412[(10)] = inst_106362);

(statearr_106412[(11)] = inst_106364);

(statearr_106412[(12)] = inst_106363);

return statearr_106412;
})();
var statearr_106413_106440 = state_106407__$1;
(statearr_106413_106440[(2)] = null);

(statearr_106413_106440[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106408 === (4))){
var inst_106365 = (state_106407[(9)]);
var inst_106372 = (state_106407[(13)]);
var inst_106371 = (state_106407[(14)]);
var inst_106377 = (fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9 ? fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9(db,q_map,inst_106365,inst_106371,inst_106372,true,fuel,max_fuel,opts) : fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_106365,inst_106371,inst_106372,true,fuel,max_fuel,opts));
var state_106407__$1 = state_106407;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_106407__$1,(7),inst_106377);
} else {
if((state_val_106408 === (15))){
var state_106407__$1 = state_106407;
var statearr_106414_106441 = state_106407__$1;
(statearr_106414_106441[(2)] = null);

(statearr_106414_106441[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106408 === (13))){
var inst_106398 = (state_106407[(2)]);
var state_106407__$1 = state_106407;
var statearr_106415_106442 = state_106407__$1;
(statearr_106415_106442[(2)] = inst_106398);

(statearr_106415_106442[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106408 === (6))){
var inst_106403 = (state_106407[(2)]);
var state_106407__$1 = state_106407;
var statearr_106416_106443 = state_106407__$1;
(statearr_106416_106443[(2)] = inst_106403);

(statearr_106416_106443[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106408 === (3))){
var inst_106405 = (state_106407[(2)]);
var state_106407__$1 = state_106407;
return cljs.core.async.impl.ioc_helpers.return_chan(state_106407__$1,inst_106405);
} else {
if((state_val_106408 === (12))){
var state_106407__$1 = state_106407;
var statearr_106417_106444 = state_106407__$1;
(statearr_106417_106444[(1)] = (14));



return cljs.core.cst$kw$recur;
} else {
if((state_val_106408 === (2))){
var inst_106364 = (state_106407[(11)]);
var inst_106371 = (state_106407[(14)]);
var inst_106370 = cljs.core.seq(inst_106364);
var inst_106371__$1 = cljs.core.first(inst_106370);
var inst_106372 = cljs.core.next(inst_106370);
var state_106407__$1 = (function (){var statearr_106419 = state_106407;
(statearr_106419[(13)] = inst_106372);

(statearr_106419[(14)] = inst_106371__$1);

return statearr_106419;
})();
if(cljs.core.truth_(inst_106371__$1)){
var statearr_106420_106445 = state_106407__$1;
(statearr_106420_106445[(1)] = (4));

} else {
var statearr_106421_106446 = state_106407__$1;
(statearr_106421_106446[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_106408 === (11))){
var inst_106382 = (state_106407[(8)]);
var inst_106381 = (state_106407[(7)]);
var inst_106364 = inst_106382;
var inst_106365 = inst_106381;
var state_106407__$1 = (function (){var statearr_106422 = state_106407;
(statearr_106422[(9)] = inst_106365);

(statearr_106422[(11)] = inst_106364);

return statearr_106422;
})();
var statearr_106423_106447 = state_106407__$1;
(statearr_106423_106447[(2)] = null);

(statearr_106423_106447[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106408 === (9))){
var inst_106371 = (state_106407[(14)]);
var inst_106387 = cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(inst_106371);
var state_106407__$1 = state_106407;
if(cljs.core.truth_(inst_106387)){
var statearr_106424_106448 = state_106407__$1;
(statearr_106424_106448[(1)] = (11));

} else {
var statearr_106425_106449 = state_106407__$1;
(statearr_106425_106449[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_106408 === (5))){
var inst_106365 = (state_106407[(9)]);
var state_106407__$1 = state_106407;
var statearr_106426_106450 = state_106407__$1;
(statearr_106426_106450[(2)] = inst_106365);

(statearr_106426_106450[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106408 === (14))){
var inst_106365 = (state_106407[(9)]);
var inst_106382 = (state_106407[(8)]);
var inst_106381 = (state_106407[(7)]);
var inst_106392 = fluree.db.query.analytical.left_outer_join(inst_106365,inst_106381);
var inst_106364 = inst_106382;
var inst_106365__$1 = inst_106392;
var state_106407__$1 = (function (){var statearr_106427 = state_106407;
(statearr_106427[(9)] = inst_106365__$1);

(statearr_106427[(11)] = inst_106364);

return statearr_106427;
})();
var statearr_106428_106451 = state_106407__$1;
(statearr_106428_106451[(2)] = null);

(statearr_106428_106451[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106408 === (16))){
var inst_106396 = (state_106407[(2)]);
var state_106407__$1 = state_106407;
var statearr_106430_106452 = state_106407__$1;
(statearr_106430_106452[(2)] = inst_106396);

(statearr_106430_106452[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106408 === (10))){
var inst_106400 = (state_106407[(2)]);
var state_106407__$1 = state_106407;
var statearr_106431_106453 = state_106407__$1;
(statearr_106431_106453[(2)] = inst_106400);

(statearr_106431_106453[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106408 === (8))){
var inst_106365 = (state_106407[(9)]);
var inst_106382 = (state_106407[(8)]);
var tmp106429 = inst_106365;
var inst_106364 = inst_106382;
var inst_106365__$1 = tmp106429;
var state_106407__$1 = (function (){var statearr_106432 = state_106407;
(statearr_106432[(9)] = inst_106365__$1);

(statearr_106432[(11)] = inst_106364);

return statearr_106432;
})();
var statearr_106433_106454 = state_106407__$1;
(statearr_106433_106454[(2)] = null);

(statearr_106433_106454[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__99037__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__99037__auto____0 = (function (){
var statearr_106434 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_106434[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__99037__auto__);

(statearr_106434[(1)] = (1));

return statearr_106434;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__99037__auto____1 = (function (state_106407){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_106407);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e106435){if((e106435 instanceof Object)){
var ex__99040__auto__ = e106435;
var statearr_106436_106455 = state_106407;
(statearr_106436_106455[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_106407);

return cljs.core.cst$kw$recur;
} else {
throw e106435;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__106456 = state_106407;
state_106407 = G__106456;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__99037__auto__ = function(state_106407){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__99037__auto____1.call(this,state_106407);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__99037__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__99037__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_106437 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_106437[(6)] = c__99059__auto__);

return statearr_106437;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__106458){
var vec__106459 = p__106458;
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106459,(0),null);
var var_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106459,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (vec__106459,var_name,var_val){
return (function (p1__106457_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__106457_SHARP_,var_val);
});})(vec__106459,var_name,var_val))
,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tuples,tuples_SINGLEQUOTE_,cljs.core.cst$kw$headers,headers_SINGLEQUOTE_], null);
}),res,cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__106463,p__106464,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__106465 = p__106463;
var map__106465__$1 = (((((!((map__106465 == null))))?(((((map__106465.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106465.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__106465):map__106465);
var q_map = map__106465__$1;
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106465__$1,cljs.core.cst$kw$prefixes);
var map__106466 = p__106464;
var map__106466__$1 = (((((!((map__106466 == null))))?(((((map__106466.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106466.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__106466):map__106466);
var res = map__106466__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106466__$1,cljs.core.cst$kw$vars);
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__,map__106465,map__106465__$1,q_map,prefixes,map__106466,map__106466__$1,res,vars){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__,map__106465,map__106465__$1,q_map,prefixes,map__106466,map__106466__$1,res,vars){
return (function (state_106671){
var state_val_106672 = (state_106671[(1)]);
if((state_val_106672 === (7))){
var inst_106667 = (state_106671[(2)]);
var state_106671__$1 = state_106671;
var statearr_106673_106753 = state_106671__$1;
(statearr_106673_106753[(2)] = inst_106667);


cljs.core.async.impl.ioc_helpers.process_exception(state_106671__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (20))){
var inst_106476 = (state_106671[(7)]);
var inst_106505 = (state_106671[(8)]);
var inst_106500 = (state_106671[(9)]);
var inst_106502 = (state_106671[(10)]);
var inst_106512 = (state_106671[(11)]);
var inst_106504 = (state_106671[(12)]);
var inst_106511 = (state_106671[(13)]);
var inst_106503 = (state_106671[(14)]);
var inst_106516 = (state_106671[(2)]);
var inst_106517 = fluree.db.util.async.throw_err(inst_106516);
var inst_106518 = (function (){var pred__106477 = cljs.core._EQ_;
var new_res = inst_106517;
var rest = inst_106512;
var tuples = inst_106505;
var first__106499 = inst_106502;
var seq__106498 = inst_106503;
var vec__106507 = inst_106504;
var seq__106508 = inst_106512;
var vec__106497 = inst_106500;
var expr__106478 = inst_106476;
var segment_type = inst_106476;
var G__106496 = inst_106504;
var clause_group = inst_106511;
var first__106509 = inst_106511;
return ((function (pred__106477,new_res,rest,tuples,first__106499,seq__106498,vec__106507,seq__106508,vec__106497,expr__106478,segment_type,G__106496,clause_group,first__106509,inst_106476,inst_106505,inst_106500,inst_106502,inst_106512,inst_106504,inst_106511,inst_106503,inst_106516,inst_106517,state_val_106672,c__99059__auto__,map__106465,map__106465__$1,q_map,prefixes,map__106466,map__106466__$1,res,vars){
return (function (res__$1,var$){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(new_res,cljs.core.cst$kw$var,cljs.core.dissoc,var$);
});
;})(pred__106477,new_res,rest,tuples,first__106499,seq__106498,vec__106507,seq__106508,vec__106497,expr__106478,segment_type,G__106496,clause_group,first__106509,inst_106476,inst_106505,inst_106500,inst_106502,inst_106512,inst_106504,inst_106511,inst_106503,inst_106516,inst_106517,state_val_106672,c__99059__auto__,map__106465,map__106465__$1,q_map,prefixes,map__106466,map__106466__$1,res,vars))
})();
var inst_106519 = cljs.core.keys(vars);
var inst_106520 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_106518,inst_106517,inst_106519);
var inst_106521 = fluree.db.query.analytical.res_absorb_vars(inst_106520);
var state_106671__$1 = (function (){var statearr_106674 = state_106671;
(statearr_106674[(15)] = inst_106521);

return statearr_106674;
})();
if(cljs.core.truth_(inst_106505)){
var statearr_106675_106754 = state_106671__$1;
(statearr_106675_106754[(1)] = (21));

} else {
var statearr_106676_106755 = state_106671__$1;
(statearr_106676_106755[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (58))){
var inst_106641 = (state_106671[(16)]);
var inst_106644 = (state_106671[(2)]);
var inst_106645 = fluree.db.util.async.throw_err(inst_106644);
var inst_106646 = [inst_106645,r];
var inst_106647 = (new cljs.core.PersistentVector(null,2,(5),inst_106641,inst_106646,null));
var state_106671__$1 = state_106671;
var statearr_106677_106756 = state_106671__$1;
(statearr_106677_106756[(2)] = inst_106647);

(statearr_106677_106756[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (27))){
var inst_106552 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_106553 = cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(clause);
var inst_106554 = fluree.db.query.analytical.tuples__GT_filtered(res,inst_106553,optional_QMARK_);
var inst_106555 = [inst_106554,r];
var inst_106556 = (new cljs.core.PersistentVector(null,2,(5),inst_106552,inst_106555,null));
var state_106671__$1 = state_106671;
var statearr_106678_106757 = state_106671__$1;
(statearr_106678_106757[(2)] = inst_106556);

(statearr_106678_106757[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (1))){
var state_106671__$1 = state_106671;
var statearr_106679_106758 = state_106671__$1;
(statearr_106679_106758[(2)] = null);

(statearr_106679_106758[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (24))){
var inst_106476 = (state_106671[(7)]);
var inst_106540 = cljs.core.cst$kw$bind.cljs$core$IFn$_invoke$arity$1(clause);
var inst_106541 = (function (){var segment_type = inst_106476;
var pred__106477 = cljs.core._EQ_;
var expr__106478 = inst_106476;
var bindings = inst_106540;
return ((function (segment_type,pred__106477,expr__106478,bindings,inst_106476,inst_106540,state_val_106672,c__99059__auto__,map__106465,map__106465__$1,q_map,prefixes,map__106466,map__106466__$1,res,vars){
return (function (p1__106462_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars(res,p1__106462_SHARP_);
});
;})(segment_type,pred__106477,expr__106478,bindings,inst_106476,inst_106540,state_val_106672,c__99059__auto__,map__106465,map__106465__$1,q_map,prefixes,map__106466,map__106466__$1,res,vars))
})();
var inst_106542 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_106541,inst_106540);
var inst_106543 = cljs.core.PersistentHashMap.EMPTY;
var inst_106544 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_106543,inst_106542);
var inst_106545 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_106546 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,cljs.core.cst$kw$vars,cljs.core.merge,inst_106544);
var inst_106547 = [inst_106546,r];
var inst_106548 = (new cljs.core.PersistentVector(null,2,(5),inst_106545,inst_106547,null));
var state_106671__$1 = state_106671;
var statearr_106680_106759 = state_106671__$1;
(statearr_106680_106759[(2)] = inst_106548);

(statearr_106680_106759[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (55))){
var inst_106623 = (state_106671[(17)]);
var inst_106624 = (state_106671[(18)]);
var inst_106641 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_106642 = fluree.db.query.analytical.fdb_clause__GT_tuples(inst_106623,res,inst_106624,fuel,max_fuel);
var state_106671__$1 = (function (){var statearr_106681 = state_106671;
(statearr_106681[(16)] = inst_106641);

return statearr_106681;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_106671__$1,(58),inst_106642);
} else {
if((state_val_106672 === (39))){
var inst_106661 = (state_106671[(2)]);
var state_106671__$1 = state_106671;
var statearr_106682_106760 = state_106671__$1;
(statearr_106682_106760[(2)] = inst_106661);

(statearr_106682_106760[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (46))){
var inst_106657 = (state_106671[(2)]);
var state_106671__$1 = state_106671;
var statearr_106683_106761 = state_106671__$1;
(statearr_106683_106761[(2)] = inst_106657);

(statearr_106683_106761[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_106671,(3),Error,null,(2));
var inst_106473 = cljs.core.map_QMARK_(clause);
var state_106671__$1 = state_106671;
if(inst_106473){
var statearr_106684_106762 = state_106671__$1;
(statearr_106684_106762[(1)] = (5));

} else {
var statearr_106685_106763 = state_106671__$1;
(statearr_106685_106763[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (54))){
var inst_106652 = (state_106671[(2)]);
var state_106671__$1 = state_106671;
var statearr_106686_106764 = state_106671__$1;
(statearr_106686_106764[(2)] = inst_106652);

(statearr_106686_106764[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (15))){
var inst_106504 = (state_106671[(12)]);
var inst_106511 = (state_106671[(13)]);
var inst_106510 = cljs.core.seq(inst_106504);
var inst_106511__$1 = cljs.core.first(inst_106510);
var inst_106512 = cljs.core.next(inst_106510);
var state_106671__$1 = (function (){var statearr_106687 = state_106671;
(statearr_106687[(11)] = inst_106512);

(statearr_106687[(13)] = inst_106511__$1);

return statearr_106687;
})();
if(cljs.core.truth_(inst_106511__$1)){
var statearr_106688_106765 = state_106671__$1;
(statearr_106688_106765[(1)] = (17));

} else {
var statearr_106689_106766 = state_106671__$1;
(statearr_106689_106766[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (48))){
var inst_106624 = (state_106671[(18)]);
var inst_106627 = fluree.db.query.analytical.wikidata__GT_tuples(q_map,inst_106624,r,res,optional_QMARK_,fuel,max_fuel);
var state_106671__$1 = state_106671;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_106671__$1,(51),inst_106627);
} else {
if((state_val_106672 === (50))){
var inst_106654 = (state_106671[(2)]);
var state_106671__$1 = state_106671;
var statearr_106690_106767 = state_106671__$1;
(statearr_106690_106767[(2)] = inst_106654);

(statearr_106690_106767[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (21))){
var inst_106505 = (state_106671[(8)]);
var inst_106512 = (state_106671[(11)]);
var inst_106521 = (state_106671[(15)]);
var inst_106523 = fluree.db.query.analytical.outer_union(inst_106505,inst_106521);
var inst_106504 = inst_106512;
var inst_106505__$1 = inst_106523;
var state_106671__$1 = (function (){var statearr_106691 = state_106671;
(statearr_106691[(8)] = inst_106505__$1);

(statearr_106691[(12)] = inst_106504);

return statearr_106691;
})();
var statearr_106692_106768 = state_106671__$1;
(statearr_106692_106768[(2)] = null);

(statearr_106692_106768[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (31))){
var inst_106581 = cljs.core.count(clause);
var inst_106582 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_106581);
var inst_106583 = cljs.core.second(clause);
var inst_106584 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_106583,"rdf:type");
var inst_106585 = ((inst_106582) && (inst_106584));
var state_106671__$1 = state_106671;
if(cljs.core.truth_(inst_106585)){
var statearr_106693_106769 = state_106671__$1;
(statearr_106693_106769[(1)] = (33));

} else {
var statearr_106694_106770 = state_106671__$1;
(statearr_106694_106770[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (32))){
var inst_106665 = (state_106671[(2)]);
var state_106671__$1 = state_106671;
var statearr_106695_106771 = state_106671__$1;
(statearr_106695_106771[(2)] = inst_106665);

(statearr_106695_106771[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (40))){
var inst_106598 = (state_106671[(19)]);
var inst_106601 = (state_106671[(2)]);
var inst_106602 = fluree.db.util.async.throw_err(inst_106601);
var inst_106603 = [inst_106602,r];
var inst_106604 = (new cljs.core.PersistentVector(null,2,(5),inst_106598,inst_106603,null));
var state_106671__$1 = state_106671;
var statearr_106696_106772 = state_106671__$1;
(statearr_106696_106772[(2)] = inst_106604);

(statearr_106696_106772[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (56))){
var state_106671__$1 = state_106671;
var statearr_106697_106773 = state_106671__$1;
(statearr_106697_106773[(2)] = null);

(statearr_106697_106773[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (33))){
var inst_106587 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_106588 = fluree.db.query.analytical.collection__GT_tuples(db,res,clause);
var state_106671__$1 = (function (){var statearr_106698 = state_106671;
(statearr_106698[(20)] = inst_106587);

return statearr_106698;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_106671__$1,(36),inst_106588);
} else {
if((state_val_106672 === (13))){
var inst_106476 = (state_106671[(7)]);
var inst_106538 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$bind,inst_106476);
var state_106671__$1 = state_106671;
if(inst_106538){
var statearr_106699_106774 = state_106671__$1;
(statearr_106699_106774[(1)] = (24));

} else {
var statearr_106700_106775 = state_106671__$1;
(statearr_106700_106775[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (22))){
var inst_106512 = (state_106671[(11)]);
var inst_106521 = (state_106671[(15)]);
var inst_106504 = inst_106512;
var inst_106505 = inst_106521;
var state_106671__$1 = (function (){var statearr_106701 = state_106671;
(statearr_106701[(8)] = inst_106505);

(statearr_106701[(12)] = inst_106504);

return statearr_106701;
})();
var statearr_106702_106776 = state_106671__$1;
(statearr_106702_106776[(2)] = null);

(statearr_106702_106776[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (36))){
var inst_106587 = (state_106671[(20)]);
var inst_106590 = (state_106671[(2)]);
var inst_106591 = fluree.db.util.async.throw_err(inst_106590);
var inst_106592 = [inst_106591,r];
var inst_106593 = (new cljs.core.PersistentVector(null,2,(5),inst_106587,inst_106592,null));
var state_106671__$1 = state_106671;
var statearr_106703_106777 = state_106671__$1;
(statearr_106703_106777[(2)] = inst_106593);

(statearr_106703_106777[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (41))){
var inst_106609 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_106610 = fluree.db.query.analytical.bind_clause__GT_vars(res,clause);
var inst_106611 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,cljs.core.cst$kw$vars,cljs.core.merge,inst_106610);
var inst_106612 = [inst_106611,r];
var inst_106613 = (new cljs.core.PersistentVector(null,2,(5),inst_106609,inst_106612,null));
var state_106671__$1 = state_106671;
var statearr_106704_106778 = state_106671__$1;
(statearr_106704_106778[(2)] = inst_106613);

(statearr_106704_106778[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (43))){
var inst_106659 = (state_106671[(2)]);
var state_106671__$1 = state_106671;
var statearr_106705_106779 = state_106671__$1;
(statearr_106705_106779[(2)] = inst_106659);

(statearr_106705_106779[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (29))){
var inst_106562 = (state_106671[(2)]);
var state_106671__$1 = state_106671;
var statearr_106706_106780 = state_106671__$1;
(statearr_106706_106780[(2)] = inst_106562);

(statearr_106706_106780[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (44))){
var inst_106619 = fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,prefixes,opts);
var state_106671__$1 = state_106671;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_106671__$1,(47),inst_106619);
} else {
if((state_val_106672 === (6))){
var inst_106570 = cljs.core.count(clause);
var inst_106571 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_106570);
var inst_106572 = cljs.core.second(clause);
var inst_106573 = clojure.string.starts_with_QMARK_(inst_106572,"fullText:");
var inst_106574 = ((inst_106571) && (inst_106573));
var state_106671__$1 = state_106671;
if(cljs.core.truth_(inst_106574)){
var statearr_106707_106781 = state_106671__$1;
(statearr_106707_106781[(1)] = (30));

} else {
var statearr_106708_106782 = state_106671__$1;
(statearr_106708_106782[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (28))){
var inst_106476 = (state_106671[(7)]);
var inst_106558 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_106476)].join('');
var inst_106559 = (new Error(inst_106558));
var inst_106560 = (function(){throw inst_106559})();
var state_106671__$1 = state_106671;
var statearr_106709_106783 = state_106671__$1;
(statearr_106709_106783[(2)] = inst_106560);

(statearr_106709_106783[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (51))){
var inst_106629 = (state_106671[(2)]);
var inst_106630 = fluree.db.util.async.throw_err(inst_106629);
var state_106671__$1 = state_106671;
var statearr_106710_106784 = state_106671__$1;
(statearr_106710_106784[(2)] = inst_106630);

(statearr_106710_106784[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (25))){
var inst_106476 = (state_106671[(7)]);
var inst_106550 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$filter,inst_106476);
var state_106671__$1 = state_106671;
if(inst_106550){
var statearr_106711_106785 = state_106671__$1;
(statearr_106711_106785[(1)] = (27));

} else {
var statearr_106712_106786 = state_106671__$1;
(statearr_106712_106786[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (34))){
var inst_106595 = cljs.core.count(clause);
var inst_106596 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_106595);
var state_106671__$1 = state_106671;
if(inst_106596){
var statearr_106713_106787 = state_106671__$1;
(statearr_106713_106787[(1)] = (37));

} else {
var statearr_106714_106788 = state_106671__$1;
(statearr_106714_106788[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (17))){
var inst_106511 = (state_106671[(13)]);
var inst_106514 = (fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 ? fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_106511,q_map,vars,fuel,max_fuel,opts) : fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_106511,q_map,vars,fuel,max_fuel,opts));
var state_106671__$1 = state_106671;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_106671__$1,(20),inst_106514);
} else {
if((state_val_106672 === (3))){
var inst_106469 = (state_106671[(2)]);
var state_106671__$1 = state_106671;
var statearr_106715_106789 = state_106671__$1;
(statearr_106715_106789[(2)] = inst_106469);


cljs.core.async.impl.ioc_helpers.process_exception(state_106671__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (12))){
var inst_106500 = (state_106671[(9)]);
var inst_106500__$1 = cljs.core.cst$kw$union.cljs$core$IFn$_invoke$arity$1(clause);
var inst_106501 = cljs.core.seq(inst_106500__$1);
var inst_106502 = cljs.core.first(inst_106501);
var inst_106503 = cljs.core.next(inst_106501);
var inst_106504 = inst_106500__$1;
var inst_106505 = null;
var state_106671__$1 = (function (){var statearr_106716 = state_106671;
(statearr_106716[(8)] = inst_106505);

(statearr_106716[(9)] = inst_106500__$1);

(statearr_106716[(10)] = inst_106502);

(statearr_106716[(12)] = inst_106504);

(statearr_106716[(14)] = inst_106503);

return statearr_106716;
})();
var statearr_106717_106790 = state_106671__$1;
(statearr_106717_106790[(2)] = null);

(statearr_106717_106790[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (2))){
var inst_106669 = (state_106671[(2)]);
var state_106671__$1 = state_106671;
return cljs.core.async.impl.ioc_helpers.return_chan(state_106671__$1,inst_106669);
} else {
if((state_val_106672 === (23))){
var inst_106528 = (state_106671[(2)]);
var state_106671__$1 = state_106671;
var statearr_106718_106791 = state_106671__$1;
(statearr_106718_106791[(2)] = inst_106528);

(statearr_106718_106791[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (47))){
var inst_106623 = (state_106671[(17)]);
var inst_106621 = (state_106671[(2)]);
var inst_106622 = fluree.db.util.async.throw_err(inst_106621);
var inst_106623__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_106622,(0),null);
var inst_106624 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_106622,(1),null);
var inst_106625 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_106623__$1);
var state_106671__$1 = (function (){var statearr_106719 = state_106671;
(statearr_106719[(17)] = inst_106623__$1);

(statearr_106719[(18)] = inst_106624);

return statearr_106719;
})();
if(inst_106625){
var statearr_106720_106792 = state_106671__$1;
(statearr_106720_106792[(1)] = (48));

} else {
var statearr_106721_106793 = state_106671__$1;
(statearr_106721_106793[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (35))){
var inst_106663 = (state_106671[(2)]);
var state_106671__$1 = state_106671;
var statearr_106722_106794 = state_106671__$1;
(statearr_106722_106794[(2)] = inst_106663);

(statearr_106722_106794[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (19))){
var inst_106534 = (state_106671[(2)]);
var state_106671__$1 = state_106671;
var statearr_106723_106795 = state_106671__$1;
(statearr_106723_106795[(2)] = inst_106534);

(statearr_106723_106795[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (57))){
var inst_106650 = (state_106671[(2)]);
var state_106671__$1 = state_106671;
var statearr_106724_106796 = state_106671__$1;
(statearr_106724_106796[(2)] = inst_106650);

(statearr_106724_106796[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (11))){
var inst_106482 = (state_106671[(21)]);
var inst_106486 = (state_106671[(2)]);
var inst_106487 = fluree.db.util.async.throw_err(inst_106486);
var inst_106488 = [inst_106487,r];
var inst_106489 = (new cljs.core.PersistentVector(null,2,(5),inst_106482,inst_106488,null));
var state_106671__$1 = state_106671;
var statearr_106725_106797 = state_106671__$1;
(statearr_106725_106797[(2)] = inst_106489);

(statearr_106725_106797[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (9))){
var inst_106476 = (state_106671[(7)]);
var inst_106491 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$union,inst_106476);
var state_106671__$1 = state_106671;
if(inst_106491){
var statearr_106726_106798 = state_106671__$1;
(statearr_106726_106798[(1)] = (12));

} else {
var statearr_106727_106799 = state_106671__$1;
(statearr_106727_106799[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (5))){
var inst_106476 = (state_106671[(7)]);
var inst_106475 = cljs.core.keys(clause);
var inst_106476__$1 = cljs.core.first(inst_106475);
var inst_106480 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$optional,inst_106476__$1);
var state_106671__$1 = (function (){var statearr_106728 = state_106671;
(statearr_106728[(7)] = inst_106476__$1);

return statearr_106728;
})();
if(inst_106480){
var statearr_106729_106800 = state_106671__$1;
(statearr_106729_106800[(1)] = (8));

} else {
var statearr_106730_106801 = state_106671__$1;
(statearr_106730_106801[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (14))){
var inst_106566 = (state_106671[(2)]);
var state_106671__$1 = state_106671;
var statearr_106731_106802 = state_106671__$1;
(statearr_106731_106802[(2)] = inst_106566);

(statearr_106731_106802[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (45))){
var state_106671__$1 = state_106671;
var statearr_106732_106803 = state_106671__$1;
(statearr_106732_106803[(2)] = null);

(statearr_106732_106803[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (53))){
var state_106671__$1 = state_106671;
var statearr_106733_106804 = state_106671__$1;
(statearr_106733_106804[(1)] = (55));



return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (26))){
var inst_106564 = (state_106671[(2)]);
var state_106671__$1 = state_106671;
var statearr_106735_106805 = state_106671__$1;
(statearr_106735_106805[(2)] = inst_106564);

(statearr_106735_106805[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (16))){
var inst_106536 = (state_106671[(2)]);
var state_106671__$1 = state_106671;
var statearr_106736_106806 = state_106671__$1;
(statearr_106736_106806[(2)] = inst_106536);

(statearr_106736_106806[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (38))){
var inst_106606 = cljs.core.count(clause);
var inst_106607 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_106606);
var state_106671__$1 = state_106671;
if(inst_106607){
var statearr_106737_106807 = state_106671__$1;
(statearr_106737_106807[(1)] = (41));

} else {
var statearr_106738_106808 = state_106671__$1;
(statearr_106738_106808[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (30))){
var inst_106576 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_106577 = fluree.db.query.analytical.full_text__GT_tuples(db,res,clause);
var inst_106578 = [inst_106577,r];
var inst_106579 = (new cljs.core.PersistentVector(null,2,(5),inst_106576,inst_106578,null));
var state_106671__$1 = state_106671;
var statearr_106739_106809 = state_106671__$1;
(statearr_106739_106809[(2)] = inst_106579);

(statearr_106739_106809[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (10))){
var inst_106568 = (state_106671[(2)]);
var state_106671__$1 = state_106671;
var statearr_106740_106810 = state_106671__$1;
(statearr_106740_106810[(2)] = inst_106568);

(statearr_106740_106810[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (18))){
var inst_106505 = (state_106671[(8)]);
var inst_106530 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_106531 = [inst_106505,r];
var inst_106532 = (new cljs.core.PersistentVector(null,2,(5),inst_106530,inst_106531,null));
var state_106671__$1 = state_106671;
var statearr_106741_106811 = state_106671__$1;
(statearr_106741_106811[(2)] = inst_106532);

(statearr_106741_106811[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (52))){
var inst_106623 = (state_106671[(17)]);
var inst_106624 = (state_106671[(18)]);
var inst_106635 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_106636 = fluree.db.query.analytical.full_text__GT_tuples(inst_106623,res,inst_106624);
var inst_106637 = [inst_106636,r];
var inst_106638 = (new cljs.core.PersistentVector(null,2,(5),inst_106635,inst_106637,null));
var state_106671__$1 = state_106671;
var statearr_106742_106812 = state_106671__$1;
(statearr_106742_106812[(2)] = inst_106638);

(statearr_106742_106812[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (42))){
var state_106671__$1 = state_106671;
var statearr_106743_106813 = state_106671__$1;
(statearr_106743_106813[(1)] = (44));



return cljs.core.cst$kw$recur;
} else {
if((state_val_106672 === (37))){
var inst_106598 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_106599 = fluree.db.query.analytical.fdb_clause__GT_tuples(db,res,clause,fuel,max_fuel);
var state_106671__$1 = (function (){var statearr_106745 = state_106671;
(statearr_106745[(19)] = inst_106598);

return statearr_106745;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_106671__$1,(40),inst_106599);
} else {
if((state_val_106672 === (8))){
var inst_106482 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_106483 = cljs.core.cst$kw$optional.cljs$core$IFn$_invoke$arity$1(clause);
var inst_106484 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_106483,res,fuel,max_fuel,opts);
var state_106671__$1 = (function (){var statearr_106746 = state_106671;
(statearr_106746[(21)] = inst_106482);

return statearr_106746;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_106671__$1,(11),inst_106484);
} else {
if((state_val_106672 === (49))){
var inst_106624 = (state_106671[(18)]);
var inst_106632 = cljs.core.second(inst_106624);
var inst_106633 = clojure.string.starts_with_QMARK_(inst_106632,"fullText:");
var state_106671__$1 = state_106671;
if(inst_106633){
var statearr_106747_106814 = state_106671__$1;
(statearr_106747_106814[(1)] = (52));

} else {
var statearr_106748_106815 = state_106671__$1;
(statearr_106748_106815[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__,map__106465,map__106465__$1,q_map,prefixes,map__106466,map__106466__$1,res,vars))
;
return ((function (switch__99036__auto__,c__99059__auto__,map__106465,map__106465__$1,q_map,prefixes,map__106466,map__106466__$1,res,vars){
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__99037__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__99037__auto____0 = (function (){
var statearr_106749 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_106749[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__99037__auto__);

(statearr_106749[(1)] = (1));

return statearr_106749;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__99037__auto____1 = (function (state_106671){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_106671);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e106750){if((e106750 instanceof Object)){
var ex__99040__auto__ = e106750;
var statearr_106751_106816 = state_106671;
(statearr_106751_106816[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_106671);

return cljs.core.cst$kw$recur;
} else {
throw e106750;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__106817 = state_106671;
state_106671 = G__106817;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__99037__auto__ = function(state_106671){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__99037__auto____1.call(this,state_106671);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__99037__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__99037__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__,map__106465,map__106465__$1,q_map,prefixes,map__106466,map__106466__$1,res,vars))
})();
var state__99061__auto__ = (function (){var statearr_106752 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_106752[(6)] = c__99059__auto__);

return statearr_106752;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__,map__106465,map__106465__$1,q_map,prefixes,map__106466,map__106466__$1,res,vars))
);

return c__99059__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__106819 = arguments.length;
switch (G__106819) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
});

fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_106895){
var state_val_106896 = (state_106895[(1)]);
if((state_val_106896 === (7))){
var inst_106845 = (state_106895[(7)]);
var inst_106846 = (state_106895[(8)]);
var inst_106839 = (state_106895[(9)]);
var inst_106851 = fluree.db.query.analytical.clause__GT_tuples(db,q_map,inst_106839,inst_106845,inst_106846,false,fuel,max_fuel,opts);
var state_106895__$1 = state_106895;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_106895__$1,(10),inst_106851);
} else {
if((state_val_106896 === (20))){
var inst_106856 = (state_106895[(10)]);
var inst_106839 = (state_106895[(9)]);
var tmp106897 = inst_106839;
var inst_106838 = inst_106856;
var inst_106839__$1 = tmp106897;
var state_106895__$1 = (function (){var statearr_106898 = state_106895;
(statearr_106898[(11)] = inst_106838);

(statearr_106898[(9)] = inst_106839__$1);

return statearr_106898;
})();
var statearr_106899_106939 = state_106895__$1;
(statearr_106899_106939[(2)] = null);

(statearr_106899_106939[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106896 === (1))){
var state_106895__$1 = state_106895;
var statearr_106900_106940 = state_106895__$1;
(statearr_106900_106940[(2)] = null);

(statearr_106900_106940[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106896 === (24))){
var state_106895__$1 = state_106895;
var statearr_106901_106941 = state_106895__$1;
(statearr_106901_106941[(2)] = null);

(statearr_106901_106941[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106896 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_106895,(3),Error,null,(2));
var inst_106831 = cljs.core.seq(where);
var inst_106832 = cljs.core.first(inst_106831);
var inst_106833 = cljs.core.next(inst_106831);
var inst_106834 = [cljs.core.cst$kw$vars];
var inst_106835 = fluree.db.query.analytical.symbolize_keys(vars);
var inst_106836 = [inst_106835];
var inst_106837 = cljs.core.PersistentHashMap.fromArrays(inst_106834,inst_106836);
var inst_106838 = where;
var inst_106839 = inst_106837;
var state_106895__$1 = (function (){var statearr_106902 = state_106895;
(statearr_106902[(12)] = inst_106832);

(statearr_106902[(11)] = inst_106838);

(statearr_106902[(13)] = inst_106833);

(statearr_106902[(9)] = inst_106839);

return statearr_106902;
})();
var statearr_106903_106942 = state_106895__$1;
(statearr_106903_106942[(2)] = null);

(statearr_106903_106942[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106896 === (15))){
var inst_106855 = (state_106895[(14)]);
var inst_106871 = (inst_106855 == null);
var state_106895__$1 = state_106895;
if(cljs.core.truth_(inst_106871)){
var statearr_106904_106943 = state_106895__$1;
(statearr_106904_106943[(1)] = (20));

} else {
var statearr_106905_106944 = state_106895__$1;
(statearr_106905_106944[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_106896 === (21))){
var state_106895__$1 = state_106895;
var statearr_106906_106945 = state_106895__$1;
(statearr_106906_106945[(1)] = (23));



return cljs.core.cst$kw$recur;
} else {
if((state_val_106896 === (13))){
var inst_106886 = (state_106895[(2)]);
var state_106895__$1 = state_106895;
var statearr_106908_106946 = state_106895__$1;
(statearr_106908_106946[(2)] = inst_106886);

(statearr_106908_106946[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106896 === (22))){
var inst_106882 = (state_106895[(2)]);
var state_106895__$1 = state_106895;
var statearr_106909_106947 = state_106895__$1;
(statearr_106909_106947[(2)] = inst_106882);

(statearr_106909_106947[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106896 === (6))){
var inst_106891 = (state_106895[(2)]);
var state_106895__$1 = state_106895;
var statearr_106910_106948 = state_106895__$1;
(statearr_106910_106948[(2)] = inst_106891);


cljs.core.async.impl.ioc_helpers.process_exception(state_106895__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_106896 === (25))){
var inst_106880 = (state_106895[(2)]);
var state_106895__$1 = state_106895;
var statearr_106911_106949 = state_106895__$1;
(statearr_106911_106949[(2)] = inst_106880);

(statearr_106911_106949[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106896 === (17))){
var inst_106855 = (state_106895[(14)]);
var state_106895__$1 = state_106895;
var statearr_106912_106950 = state_106895__$1;
(statearr_106912_106950[(2)] = inst_106855);

(statearr_106912_106950[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106896 === (3))){
var inst_106820 = (state_106895[(2)]);
var state_106895__$1 = state_106895;
var statearr_106913_106951 = state_106895__$1;
(statearr_106913_106951[(2)] = inst_106820);


cljs.core.async.impl.ioc_helpers.process_exception(state_106895__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_106896 === (12))){
var inst_106839 = (state_106895[(9)]);
var inst_106862 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_106839,cljs.core.cst$kw$vars);
var inst_106863 = cljs.core.empty_QMARK_(inst_106862);
var state_106895__$1 = state_106895;
if(inst_106863){
var statearr_106914_106952 = state_106895__$1;
(statearr_106914_106952[(1)] = (14));

} else {
var statearr_106915_106953 = state_106895__$1;
(statearr_106915_106953[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_106896 === (2))){
var inst_106893 = (state_106895[(2)]);
var state_106895__$1 = state_106895;
return cljs.core.async.impl.ioc_helpers.return_chan(state_106895__$1,inst_106893);
} else {
if((state_val_106896 === (23))){
var inst_106855 = (state_106895[(14)]);
var inst_106856 = (state_106895[(10)]);
var inst_106839 = (state_106895[(9)]);
var inst_106876 = fluree.db.query.analytical.inner_join(inst_106839,inst_106855);
var inst_106838 = inst_106856;
var inst_106839__$1 = inst_106876;
var state_106895__$1 = (function (){var statearr_106916 = state_106895;
(statearr_106916[(11)] = inst_106838);

(statearr_106916[(9)] = inst_106839__$1);

return statearr_106916;
})();
var statearr_106917_106954 = state_106895__$1;
(statearr_106917_106954[(2)] = null);

(statearr_106917_106954[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106896 === (19))){
var inst_106856 = (state_106895[(10)]);
var inst_106868 = (state_106895[(2)]);
var inst_106838 = inst_106856;
var inst_106839 = inst_106868;
var state_106895__$1 = (function (){var statearr_106918 = state_106895;
(statearr_106918[(11)] = inst_106838);

(statearr_106918[(9)] = inst_106839);

return statearr_106918;
})();
var statearr_106919_106955 = state_106895__$1;
(statearr_106919_106955[(2)] = null);

(statearr_106919_106955[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106896 === (11))){
var inst_106855 = (state_106895[(14)]);
var inst_106856 = (state_106895[(10)]);
var inst_106838 = inst_106856;
var inst_106839 = inst_106855;
var state_106895__$1 = (function (){var statearr_106920 = state_106895;
(statearr_106920[(11)] = inst_106838);

(statearr_106920[(9)] = inst_106839);

return statearr_106920;
})();
var statearr_106921_106956 = state_106895__$1;
(statearr_106921_106956[(2)] = null);

(statearr_106921_106956[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106896 === (9))){
var inst_106889 = (state_106895[(2)]);
var state_106895__$1 = state_106895;
var statearr_106922_106957 = state_106895__$1;
(statearr_106922_106957[(2)] = inst_106889);

(statearr_106922_106957[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106896 === (5))){
var inst_106838 = (state_106895[(11)]);
var inst_106845 = (state_106895[(7)]);
var inst_106844 = cljs.core.seq(inst_106838);
var inst_106845__$1 = cljs.core.first(inst_106844);
var inst_106846 = cljs.core.next(inst_106844);
var state_106895__$1 = (function (){var statearr_106923 = state_106895;
(statearr_106923[(7)] = inst_106845__$1);

(statearr_106923[(8)] = inst_106846);

return statearr_106923;
})();
if(cljs.core.truth_(inst_106845__$1)){
var statearr_106924_106958 = state_106895__$1;
(statearr_106924_106958[(1)] = (7));

} else {
var statearr_106925_106959 = state_106895__$1;
(statearr_106925_106959[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_106896 === (14))){
var inst_106855 = (state_106895[(14)]);
var state_106895__$1 = state_106895;
if(cljs.core.truth_(inst_106855)){
var statearr_106926_106960 = state_106895__$1;
(statearr_106926_106960[(1)] = (17));

} else {
var statearr_106927_106961 = state_106895__$1;
(statearr_106927_106961[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_106896 === (16))){
var inst_106884 = (state_106895[(2)]);
var state_106895__$1 = state_106895;
var statearr_106928_106962 = state_106895__$1;
(statearr_106928_106962[(2)] = inst_106884);

(statearr_106928_106962[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106896 === (10))){
var inst_106845 = (state_106895[(7)]);
var inst_106853 = (state_106895[(2)]);
var inst_106854 = fluree.db.util.async.throw_err(inst_106853);
var inst_106855 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_106854,(0),null);
var inst_106856 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_106854,(1),null);
var inst_106857 = cljs.core.count(inst_106845);
var inst_106858 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_106857);
var state_106895__$1 = (function (){var statearr_106929 = state_106895;
(statearr_106929[(14)] = inst_106855);

(statearr_106929[(10)] = inst_106856);

return statearr_106929;
})();
if(inst_106858){
var statearr_106930_106963 = state_106895__$1;
(statearr_106930_106963[(1)] = (11));

} else {
var statearr_106931_106964 = state_106895__$1;
(statearr_106931_106964[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_106896 === (18))){
var inst_106839 = (state_106895[(9)]);
var state_106895__$1 = state_106895;
var statearr_106932_106965 = state_106895__$1;
(statearr_106932_106965[(2)] = inst_106839);

(statearr_106932_106965[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106896 === (8))){
var inst_106839 = (state_106895[(9)]);
var state_106895__$1 = state_106895;
var statearr_106933_106966 = state_106895__$1;
(statearr_106933_106966[(2)] = inst_106839);

(statearr_106933_106966[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$query$analytical$state_machine__99037__auto__ = null;
var fluree$db$query$analytical$state_machine__99037__auto____0 = (function (){
var statearr_106934 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_106934[(0)] = fluree$db$query$analytical$state_machine__99037__auto__);

(statearr_106934[(1)] = (1));

return statearr_106934;
});
var fluree$db$query$analytical$state_machine__99037__auto____1 = (function (state_106895){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_106895);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e106935){if((e106935 instanceof Object)){
var ex__99040__auto__ = e106935;
var statearr_106936_106967 = state_106895;
(statearr_106936_106967[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_106895);

return cljs.core.cst$kw$recur;
} else {
throw e106935;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__106968 = state_106895;
state_106895 = G__106968;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__99037__auto__ = function(state_106895){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__99037__auto____1.call(this,state_106895);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__99037__auto____0;
fluree$db$query$analytical$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__99037__auto____1;
return fluree$db$query$analytical$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_106937 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_106937[(6)] = c__99059__auto__);

return statearr_106937;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7;

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_107025){
var state_val_107026 = (state_107025[(1)]);
if((state_val_107026 === (7))){
var inst_106989 = (state_107025[(2)]);
var state_107025__$1 = state_107025;
if(cljs.core.truth_(inst_106989)){
var statearr_107027_107059 = state_107025__$1;
(statearr_107027_107059[(1)] = (11));

} else {
var statearr_107028_107060 = state_107025__$1;
(statearr_107028_107060[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107026 === (20))){
var inst_107013 = (state_107025[(7)]);
var state_107025__$1 = state_107025;
var statearr_107029_107061 = state_107025__$1;
(statearr_107029_107061[(2)] = inst_107013);

(statearr_107029_107061[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107026 === (1))){
var state_107025__$1 = state_107025;
var statearr_107030_107062 = state_107025__$1;
(statearr_107030_107062[(2)] = null);

(statearr_107030_107062[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107026 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_107025,(3),Error,null,(2));
var inst_106975 = (q_map == null);
var inst_106976 = cljs.core.not(inst_106975);
var state_107025__$1 = state_107025;
if(inst_106976){
var statearr_107031_107063 = state_107025__$1;
(statearr_107031_107063[(1)] = (5));

} else {
var statearr_107032_107064 = state_107025__$1;
(statearr_107032_107064[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107026 === (15))){
var inst_107002 = (state_107025[(8)]);
var inst_106997 = (state_107025[(9)]);
var inst_107004 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([q_map], 0));
var inst_107005 = ["The query key: optional should be included in the 'where' array. The top-level 'optional' is being deprecated. Provided: ",inst_107004].join('');
var inst_107006 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_107005], 0));
var inst_107007 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_106997,inst_107002,fuel,max_fuel,opts);
var state_107025__$1 = (function (){var statearr_107033 = state_107025;
(statearr_107033[(10)] = inst_107006);

return statearr_107033;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_107025__$1,(18),inst_107007);
} else {
if((state_val_107026 === (21))){
var inst_107021 = (state_107025[(2)]);
var state_107025__$1 = state_107025;
var statearr_107034_107065 = state_107025__$1;
(statearr_107034_107065[(2)] = inst_107021);


cljs.core.async.impl.ioc_helpers.process_exception(state_107025__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_107026 === (13))){
var inst_106994 = (state_107025[(2)]);
var inst_106995 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_106994,cljs.core.cst$kw$vars);
var inst_106996 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_106994,cljs.core.cst$kw$where);
var inst_106997 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_106994,cljs.core.cst$kw$optional);
var inst_106998 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_106994,cljs.core.cst$kw$filter);
var inst_106999 = fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_106996,q_map,inst_106995,fuel,max_fuel,opts);
var state_107025__$1 = (function (){var statearr_107035 = state_107025;
(statearr_107035[(11)] = inst_106998);

(statearr_107035[(9)] = inst_106997);

return statearr_107035;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_107025__$1,(14),inst_106999);
} else {
if((state_val_107026 === (6))){
var state_107025__$1 = state_107025;
var statearr_107036_107066 = state_107025__$1;
(statearr_107036_107066[(2)] = false);

(statearr_107036_107066[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107026 === (17))){
var inst_106998 = (state_107025[(11)]);
var inst_107013 = (state_107025[(2)]);
var state_107025__$1 = (function (){var statearr_107037 = state_107025;
(statearr_107037[(7)] = inst_107013);

return statearr_107037;
})();
if(cljs.core.truth_(inst_106998)){
var statearr_107038_107067 = state_107025__$1;
(statearr_107038_107067[(1)] = (19));

} else {
var statearr_107039_107068 = state_107025__$1;
(statearr_107039_107068[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107026 === (3))){
var inst_106969 = (state_107025[(2)]);
var state_107025__$1 = state_107025;
var statearr_107040_107069 = state_107025__$1;
(statearr_107040_107069[(2)] = inst_106969);


cljs.core.async.impl.ioc_helpers.process_exception(state_107025__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_107026 === (12))){
var state_107025__$1 = state_107025;
var statearr_107041_107070 = state_107025__$1;
(statearr_107041_107070[(2)] = q_map);

(statearr_107041_107070[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107026 === (2))){
var inst_107023 = (state_107025[(2)]);
var state_107025__$1 = state_107025;
return cljs.core.async.impl.ioc_helpers.return_chan(state_107025__$1,inst_107023);
} else {
if((state_val_107026 === (19))){
var inst_106998 = (state_107025[(11)]);
var inst_107013 = (state_107025[(7)]);
var inst_107015 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([q_map], 0));
var inst_107016 = ["The query key: filter should be included in the 'where' array. The top-level 'filter' is being deprecated. Provided: ",inst_107015].join('');
var inst_107017 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_107016], 0));
var inst_107018 = fluree.db.query.analytical.tuples__GT_filtered(inst_107013,inst_106998,null);
var state_107025__$1 = (function (){var statearr_107042 = state_107025;
(statearr_107042[(12)] = inst_107017);

return statearr_107042;
})();
var statearr_107043_107071 = state_107025__$1;
(statearr_107043_107071[(2)] = inst_107018);

(statearr_107043_107071[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107026 === (11))){
var inst_106991 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,q_map);
var state_107025__$1 = state_107025;
var statearr_107044_107072 = state_107025__$1;
(statearr_107044_107072[(2)] = inst_106991);

(statearr_107044_107072[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107026 === (9))){
var state_107025__$1 = state_107025;
var statearr_107045_107073 = state_107025__$1;
(statearr_107045_107073[(2)] = false);

(statearr_107045_107073[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107026 === (5))){
var inst_106978 = q_map.cljs$lang$protocol_mask$partition0$;
var inst_106979 = (inst_106978 & (64));
var inst_106980 = q_map.cljs$core$ISeq$;
var inst_106981 = (cljs.core.PROTOCOL_SENTINEL === inst_106980);
var inst_106982 = ((inst_106979) || (inst_106981));
var state_107025__$1 = state_107025;
if(cljs.core.truth_(inst_106982)){
var statearr_107046_107074 = state_107025__$1;
(statearr_107046_107074[(1)] = (8));

} else {
var statearr_107047_107075 = state_107025__$1;
(statearr_107047_107075[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107026 === (14))){
var inst_106997 = (state_107025[(9)]);
var inst_107001 = (state_107025[(2)]);
var inst_107002 = fluree.db.util.async.throw_err(inst_107001);
var state_107025__$1 = (function (){var statearr_107048 = state_107025;
(statearr_107048[(8)] = inst_107002);

return statearr_107048;
})();
if(cljs.core.truth_(inst_106997)){
var statearr_107049_107076 = state_107025__$1;
(statearr_107049_107076[(1)] = (15));

} else {
var statearr_107050_107077 = state_107025__$1;
(statearr_107050_107077[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107026 === (16))){
var inst_107002 = (state_107025[(8)]);
var state_107025__$1 = state_107025;
var statearr_107051_107078 = state_107025__$1;
(statearr_107051_107078[(2)] = inst_107002);

(statearr_107051_107078[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107026 === (10))){
var inst_106986 = (state_107025[(2)]);
var state_107025__$1 = state_107025;
var statearr_107052_107079 = state_107025__$1;
(statearr_107052_107079[(2)] = inst_106986);

(statearr_107052_107079[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107026 === (18))){
var inst_107009 = (state_107025[(2)]);
var inst_107010 = fluree.db.util.async.throw_err(inst_107009);
var state_107025__$1 = state_107025;
var statearr_107053_107080 = state_107025__$1;
(statearr_107053_107080[(2)] = inst_107010);

(statearr_107053_107080[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107026 === (8))){
var state_107025__$1 = state_107025;
var statearr_107054_107081 = state_107025__$1;
(statearr_107054_107081[(2)] = true);

(statearr_107054_107081[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$query$analytical$q_$_state_machine__99037__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__99037__auto____0 = (function (){
var statearr_107055 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_107055[(0)] = fluree$db$query$analytical$q_$_state_machine__99037__auto__);

(statearr_107055[(1)] = (1));

return statearr_107055;
});
var fluree$db$query$analytical$q_$_state_machine__99037__auto____1 = (function (state_107025){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_107025);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e107056){if((e107056 instanceof Object)){
var ex__99040__auto__ = e107056;
var statearr_107057_107082 = state_107025;
(statearr_107057_107082[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_107025);

return cljs.core.cst$kw$recur;
} else {
throw e107056;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__107083 = state_107025;
state_107025 = G__107083;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__99037__auto__ = function(state_107025){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__99037__auto____1.call(this,state_107025);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__99037__auto____0;
fluree$db$query$analytical$q_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__99037__auto____1;
return fluree$db$query$analytical$q_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_107058 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_107058[(6)] = c__99059__auto__);

return statearr_107058;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

//# sourceMappingURL=analytical.js.map?rel=1593118618143
