// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.dbfunctions.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.tools.reader.edn');
goog.require('cljs.cache');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbfunctions.fns');
goog.require('clojure.string');
fluree.db.dbfunctions.core.db_fn_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$threshold,(500)], 0)));
fluree.db.dbfunctions.core.clear_db_fn_cache = (function fluree$db$dbfunctions$core$clear_db_fn_cache(){
return cljs.core.reset_BANG_(fluree.db.dbfunctions.core.db_fn_cache,cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$threshold,(500)], 0)));
});
/**
 * Returns true if this value is a transaction function.
 */
fluree.db.dbfunctions.core.tx_fn_QMARK_ = (function fluree$db$dbfunctions$core$tx_fn_QMARK_(value){
var and__4120__auto__ = typeof value === 'string';
if(and__4120__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,value);
} else {
return and__4120__auto__;
}
});
fluree.db.dbfunctions.core.default_fn_map = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$sym$_QMARK_pO,cljs.core.cst$sym$_QMARK_auth_id,cljs.core.cst$sym$and,cljs.core.cst$sym$upper_DASH_case,cljs.core.cst$sym$max_DASH_pred_DASH_val,cljs.core.cst$sym$_GT__EQ_,cljs.core.cst$sym$lower_DASH_case,cljs.core.cst$sym$_GT_,cljs.core.cst$sym$count,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$objT,cljs.core.cst$sym$inc,cljs.core.cst$sym$_SLASH_,cljs.core.cst$sym$quot,cljs.core.cst$sym$flakes,cljs.core.cst$sym$not,cljs.core.cst$sym$_QMARK_sid,cljs.core.cst$sym$uuid,cljs.core.cst$sym$_QMARK_user_id,cljs.core.cst$sym$_LT__EQ_,cljs.core.cst$sym$min,cljs.core.cst$sym$ceil,cljs.core.cst$sym$if_DASH_else,cljs.core.cst$sym$_QMARK_pid,cljs.core.cst$sym$_PLUS_,cljs.core.cst$sym$_EQ__EQ_,cljs.core.cst$sym$boolean,cljs.core.cst$sym$max,cljs.core.cst$sym$empty_QMARK_,cljs.core.cst$sym$_STAR_,cljs.core.cst$sym$relationship_QMARK_,cljs.core.cst$sym$get_DASH_in,cljs.core.cst$sym$now,cljs.core.cst$sym$dec,cljs.core.cst$sym$get_DASH_all,cljs.core.cst$sym$floor,cljs.core.cst$sym$get,cljs.core.cst$sym$str,cljs.core.cst$sym$_LT_,cljs.core.cst$sym$_DASH_,cljs.core.cst$sym$rand,cljs.core.cst$sym$contains_QMARK_,cljs.core.cst$sym$hash_DASH_set,cljs.core.cst$sym$valid_DASH_email_QMARK_,cljs.core.cst$sym$_QMARK_p,cljs.core.cst$sym$nth,cljs.core.cst$sym$mod,cljs.core.cst$sym$_QMARK_s,cljs.core.cst$sym$rem,cljs.core.cst$sym$query,cljs.core.cst$sym$_QMARK_o,cljs.core.cst$sym$objF,cljs.core.cst$sym$follow,cljs.core.cst$sym$or,cljs.core.cst$sym$re_DASH_find],[(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_pO !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_pO;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_pO,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_pO,"src/fluree/db/dbfunctions/fns.cljc",10,1,291,null,291,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the most recent object of an predicate, as of the previous block",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pO)?fluree.db.dbfunctions.fns._QMARK_pO.cljs$lang$test:null),"10 plus fuel cost"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_auth_id !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_auth_id;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_auth_id,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_auth_id,"src/fluree/db/dbfunctions/fns.cljc",15,1,699,null,699,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current auth _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_auth_id)?fluree.db.dbfunctions.fns._QMARK_auth_id.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.and !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.and;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_and,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$and,"src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,221,null,221,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns true if all in a sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.and)?fluree.db.dbfunctions.fns.and.cljs$lang$test:null),"Count of objects in and"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.upper_case !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.upper_case;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_upper_DASH_case,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$upper_DASH_case,"src/fluree/db/dbfunctions/fns.cljc",17,1,147,null,147,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$str], null)),"Makes string upper-case",(cljs.core.truth_(fluree.db.dbfunctions.fns.upper_case)?fluree.db.dbfunctions.fns.upper_case.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.max_pred_val !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.max_pred_val;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_max_DASH_pred_DASH_val,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$max_DASH_pred_DASH_val,"src/fluree/db/dbfunctions/fns.cljc",19,1,503,null,503,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$pred_DASH_name], null)),"Finds the maximum predicate value.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max_pred_val)?fluree.db.dbfunctions.fns.max_pred_val.cljs$lang$test:null),"10, plus fuel cost."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._GT__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._GT__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__GT__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_GT__EQ_,"src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,421,null,421,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT__EQ_)?fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$test:null),"9 + count of numbers in <="]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.lower_case !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.lower_case;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_lower_DASH_case,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$lower_DASH_case,"src/fluree/db/dbfunctions/fns.cljc",17,1,135,null,135,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$str], null)),"Makes string lower case",(cljs.core.truth_(fluree.db.dbfunctions.fns.lower_case)?fluree.db.dbfunctions.fns.lower_case.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._GT_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._GT_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__GT_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_GT_,"src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,382,null,382,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT_)?fluree.db.dbfunctions.fns._GT_.cljs$lang$test:null),"9 + count of numbers in >"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.count !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.count;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_count,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$count,"src/fluree/db/dbfunctions/fns.cljc",12,1,247,null,247,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$coll], null)),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps",(cljs.core.truth_(fluree.db.dbfunctions.fns.count)?fluree.db.dbfunctions.fns.count.cljs$lang$test:null),"9 + count of objects in count"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.nil_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.nil_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_nil_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$nil_QMARK_,"src/fluree/db/dbfunctions/fns.cljc",11,1,88,null,88,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$arg], null)),"True if nil, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.nil_QMARK_)?fluree.db.dbfunctions.fns.nil_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.objT !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.objT;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_objT,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$objT,"src/fluree/db/dbfunctions/fns.cljc",11,1,711,null,711,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the summed object of all true flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objT)?fluree.db.dbfunctions.fns.objT.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.inc !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.inc;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_inc,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$inc,"src/fluree/db/dbfunctions/fns.cljc",10,1,515,null,515,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n], null)),"Increments any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.inc)?fluree.db.dbfunctions.fns.inc.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._SLASH_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__SLASH_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_SLASH_,"src/fluree/db/dbfunctions/fns.cljc",new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,591,null,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence",(cljs.core.truth_(fluree.db.dbfunctions.fns._SLASH_)?fluree.db.dbfunctions.fns._SLASH_.cljs$lang$test:null),"9 + count of numbers in /"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.quot !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.quot;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_quot,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$quot,"src/fluree/db/dbfunctions/fns.cljc",11,1,605,null,605,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n,cljs.core.cst$sym$d], null)),"Quot[ient] of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.quot)?fluree.db.dbfunctions.fns.quot.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.flakes !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.flakes;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_flakes,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$flakes,"src/fluree/db/dbfunctions/fns.cljc",13,1,735,null,735,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the flakes from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.flakes)?fluree.db.dbfunctions.fns.flakes.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.not !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.not;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_not,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$not,"src/fluree/db/dbfunctions/fns.cljc",10,1,100,null,100,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$arg], null)),"Takes a boolean, true returns false, false returns true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.not)?fluree.db.dbfunctions.fns.not.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_sid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_sid;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_sid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_sid,"src/fluree/db/dbfunctions/fns.cljc",11,1,159,null,159,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current subject id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_sid)?fluree.db.dbfunctions.fns._QMARK_sid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.uuid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.uuid;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_uuid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$uuid,"src/fluree/db/dbfunctions/fns.cljc",11,1,762,null,762,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.uuid)?fluree.db.dbfunctions.fns.uuid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_user_id !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_user_id;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_user_id,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_user_id,"src/fluree/db/dbfunctions/fns.cljc",15,1,681,null,681,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current user _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_user_id)?fluree.db.dbfunctions.fns._QMARK_user_id.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._LT__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._LT__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__LT__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_LT__EQ_,"src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,408,null,408,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT__EQ_)?fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$test:null),"9 + count of numbers in <="]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.min !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.min;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_min,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$min,"src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,447,null,447,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Gets min value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.min)?fluree.db.dbfunctions.fns.min.cljs$lang$test:null),"Count of numbers in min"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.ceil !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.ceil;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_ceil,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$ceil,"src/fluree/db/dbfunctions/fns.cljc",11,1,772,null,772,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$num], null)),"Takes the ceiling of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.ceil)?fluree.db.dbfunctions.fns.ceil.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.if_else !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.if_else;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_if_DASH_else,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$if_DASH_else,"src/fluree/db/dbfunctions/fns.cljc",14,1,75,null,75,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$test,cljs.core.cst$sym$t,cljs.core.cst$sym$f], null)),"Evaluates test.",(cljs.core.truth_(fluree.db.dbfunctions.fns.if_else)?fluree.db.dbfunctions.fns.if_else.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_pid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_pid;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_pid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_pid,"src/fluree/db/dbfunctions/fns.cljc",11,1,179,null,179,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current predicate id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pid)?fluree.db.dbfunctions.fns._QMARK_pid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._PLUS_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._PLUS_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__PLUS_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_PLUS_,"src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,550,null,550,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns sum of each argument.",(cljs.core.truth_(fluree.db.dbfunctions.fns._PLUS_)?fluree.db.dbfunctions.fns._PLUS_.cljs$lang$test:null),"9 + count of numbers in +"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._EQ__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._EQ__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__EQ__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_EQ__EQ_,"src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,368,null,368,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Return true if arguments in sequence equal each other.",(cljs.core.truth_(fluree.db.dbfunctions.fns._EQ__EQ_)?fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$test:null),"9 + count of objects in =="]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.boolean$ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.boolean$;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_boolean,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$boolean,"src/fluree/db/dbfunctions/fns.cljc",14,1,644,null,644,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$x], null)),"Coerce to boolean. Everything except false and nil is true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.boolean$)?fluree.db.dbfunctions.fns.boolean$.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.max !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.max;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_max,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$max,"src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,434,null,434,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Gets max value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max)?fluree.db.dbfunctions.fns.max.cljs$lang$test:null),"9 + count of numbers in max"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.empty_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.empty_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_empty_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$empty_QMARK_,"src/fluree/db/dbfunctions/fns.cljc",13,1,111,null,111,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$arg], null)),"True if empty or #{nil}, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.empty_QMARK_)?fluree.db.dbfunctions.fns.empty_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._STAR_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._STAR_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__STAR_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_STAR_,"src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,578,null,578,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns product of all the numbers in the sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns._STAR_)?fluree.db.dbfunctions.fns._STAR_.cljs$lang$test:null),"9 + count of numbers in *"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.relationship_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.relationship_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_relationship_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$relationship_QMARK_,"src/fluree/db/dbfunctions/fns.cljc",20,1,487,null,487,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$startSubject,cljs.core.cst$sym$path,cljs.core.cst$sym$endSubject], null)),"Determines whether there is a relationship between two subjects",(cljs.core.truth_(fluree.db.dbfunctions.fns.relationship_QMARK_)?fluree.db.dbfunctions.fns.relationship_QMARK_.cljs$lang$test:null),"10, plus fuel cost"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_in !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_in;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get_DASH_in,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get_DASH_in,"src/fluree/db/dbfunctions/fns.cljc",13,1,323,323,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$path], null)),null,(cljs.core.truth_(fluree.db.dbfunctions.fns.get_in)?fluree.db.dbfunctions.fns.get_in.cljs$lang$test:null)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.now !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.now;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_now,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$now,"src/fluree/db/dbfunctions/fns.cljc",10,1,540,null,540,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Returns current epoch milliseconds on the executing machine.",(cljs.core.truth_(fluree.db.dbfunctions.fns.now)?fluree.db.dbfunctions.fns.now.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.dec !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.dec;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_dec,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$dec,"src/fluree/db/dbfunctions/fns.cljc",10,1,527,null,527,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n], null)),"Decrements any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.dec)?fluree.db.dbfunctions.fns.dec.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_all !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_all;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get_DASH_all,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get_DASH_all,"src/fluree/db/dbfunctions/fns.cljc",14,1,304,null,304,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$path], null)),"Follows an subject down the provided path and returns a set of all matching subjects.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_all)?fluree.db.dbfunctions.fns.get_all.cljs$lang$test:null),"9 + length of path"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.floor !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.floor;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_floor,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$floor,"src/fluree/db/dbfunctions/fns.cljc",12,1,785,null,785,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$num], null)),"Takes the floor of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.floor)?fluree.db.dbfunctions.fns.floor.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get,"src/fluree/db/dbfunctions/fns.cljc",10,1,261,null,261,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$pred], null)),"Gets a value from an subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get)?fluree.db.dbfunctions.fns.get.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.str !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.str;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_str,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$str,"src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,123,null,123,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Concatenates all in sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.str)?fluree.db.dbfunctions.fns.str.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._LT_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._LT_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__LT_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_LT_,"src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,395,null,395,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically increasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT_)?fluree.db.dbfunctions.fns._LT_.cljs$lang$test:null),"9 + count of numbers in <"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__DASH_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_DASH_,"src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,563,null,563,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns difference of all the numbers in the sequence with the first number as the minuend.",(cljs.core.truth_(fluree.db.dbfunctions.fns._)?fluree.db.dbfunctions.fns._.cljs$lang$test:null),"9 + count of numbers in -"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.rand !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.rand;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_rand,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$rand,"src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,3,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,3,cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max,cljs.core.cst$sym$seed], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max,cljs.core.cst$sym$seed], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,747,null,747,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max,cljs.core.cst$sym$seed], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.rand)?fluree.db.dbfunctions.fns.rand.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.contains_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.contains_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_contains_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$contains_QMARK_,"src/fluree/db/dbfunctions/fns.cljc",16,1,340,340,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$coll,cljs.core.cst$sym$key], null)),null,(cljs.core.truth_(fluree.db.dbfunctions.fns.contains_QMARK_)?fluree.db.dbfunctions.fns.contains_QMARK_.cljs$lang$test:null)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.hash_set !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.hash_set;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_hash_DASH_set,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$hash_DASH_set,"src/fluree/db/dbfunctions/fns.cljc",15,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,354,354,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),null,(cljs.core.truth_(fluree.db.dbfunctions.fns.hash_set)?fluree.db.dbfunctions.fns.hash_set.cljs$lang$test:null)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.valid_email_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.valid_email_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_valid_DASH_email_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$valid_DASH_email_QMARK_,"src/fluree/db/dbfunctions/fns.cljc",19,1,669,null,669,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$email], null)),"Determines whether an email is valid, based on its pattern",(cljs.core.truth_(fluree.db.dbfunctions.fns.valid_email_QMARK_)?fluree.db.dbfunctions.fns.valid_email_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_p !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_p;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_p,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_p,"src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,205,null,205,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),"Gets current predicate predicates",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_p)?fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.nth !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.nth;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_nth,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$nth,"src/fluree/db/dbfunctions/fns.cljc",10,1,59,null,59,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$coll,cljs.core.cst$sym$key], null)),"Returns the nth item in a collection",(cljs.core.truth_(fluree.db.dbfunctions.fns.nth)?fluree.db.dbfunctions.fns.nth.cljs$lang$test:null),"9 + count of objects in collection"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.mod !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.mod;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_mod,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$mod,"src/fluree/db/dbfunctions/fns.cljc",10,1,618,null,618,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n,cljs.core.cst$sym$d], null)),"Modulus of num and div. Truncates toward negative infinity.",(cljs.core.truth_(fluree.db.dbfunctions.fns.mod)?fluree.db.dbfunctions.fns.mod.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_s !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_s;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_s,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_s,"src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,192,null,192,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),"Gets current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_s)?fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.rem !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.rem;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_rem,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$rem,"src/fluree/db/dbfunctions/fns.cljc",10,1,631,null,631,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n,cljs.core.cst$sym$d], null)),"Remainder of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.rem)?fluree.db.dbfunctions.fns.rem.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.query !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.query;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_query,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$query,"src/fluree/db/dbfunctions/fns.cljc",12,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,6,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,6,cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$query_DASH_map], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$select,cljs.core.cst$sym$from,cljs.core.cst$sym$where,cljs.core.cst$sym$block,cljs.core.cst$sym$limit], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$query_DASH_map], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$select,cljs.core.cst$sym$from,cljs.core.cst$sym$where,cljs.core.cst$sym$block,cljs.core.cst$sym$limit], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,460,null,460,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$query_DASH_map], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$select,cljs.core.cst$sym$from,cljs.core.cst$sym$where,cljs.core.cst$sym$block,cljs.core.cst$sym$limit], null)),"Executes a query",(cljs.core.truth_(fluree.db.dbfunctions.fns.query)?fluree.db.dbfunctions.fns.query.cljs$lang$test:null),"Fuel required for query"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_o !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_o;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_o,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_o,"src/fluree/db/dbfunctions/fns.cljc",9,1,279,null,279,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the object of an predicate from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_o)?fluree.db.dbfunctions.fns._QMARK_o.cljs$lang$test:null),(1)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.objF !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.objF;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_objF,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$objF,"src/fluree/db/dbfunctions/fns.cljc",11,1,723,null,723,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the summed object of all false flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objF)?fluree.db.dbfunctions.fns.objF.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_all !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_all;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get_DASH_all,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get_DASH_all,"src/fluree/db/dbfunctions/fns.cljc",14,1,304,null,304,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$path], null)),"Follows an subject down the provided path and returns a set of all matching subjects.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_all)?fluree.db.dbfunctions.fns.get_all.cljs$lang$test:null),"9 + length of path"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.or !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.or;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_or,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$or,"src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,234,null,234,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns true if any in the sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.or)?fluree.db.dbfunctions.fns.or.cljs$lang$test:null),"Count of objects in or"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.re_find !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.re_find;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_re_DASH_find,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$re_DASH_find,"src/fluree/db/dbfunctions/fns.cljc",14,1,656,null,656,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$pattern,cljs.core.cst$sym$string], null)),"Execute a re-find operation of regex pattern on provided string.",(cljs.core.truth_(fluree.db.dbfunctions.fns.re_find)?fluree.db.dbfunctions.fns.re_find.cljs$lang$test:null),(10)]))):null)]);
fluree.db.dbfunctions.core.resolve_local_fn = (function fluree$db$dbfunctions$core$resolve_local_fn(f){
var map__117217 = cljs.core.meta(f);
var map__117217__$1 = (((((!((map__117217 == null))))?(((((map__117217.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__117217.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__117217):map__117217);
var spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__117217__$1,cljs.core.cst$kw$fdb_SLASH_spec);
var arglists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__117217__$1,cljs.core.cst$kw$arglists);
var arglist = cljs.core.first(arglists);
var _AMPERSAND_args_QMARK_ = (function (){var and__4120__auto__ = (function (){var G__117222 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("&");
var fexpr__117221 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,arglist);
return (fexpr__117221.cljs$core$IFn$_invoke$arity$1 ? fexpr__117221.cljs$core$IFn$_invoke$arity$1(G__117222) : fexpr__117221.call(null,G__117222));
})();
if(cljs.core.truth_(and__4120__auto__)){
var G__117224 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("args");
var fexpr__117223 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,arglist);
return (fexpr__117223.cljs$core$IFn$_invoke$arity$1 ? fexpr__117223.cljs$core$IFn$_invoke$arity$1(G__117224) : fexpr__117223.call(null,G__117224));
} else {
return and__4120__auto__;
}
})();
var arity = ((cljs.core.not(_AMPERSAND_args_QMARK_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__117217,map__117217__$1,spec,arglists,arglist,_AMPERSAND_args_QMARK_){
return (function (p1__117216_SHARP_){
return (cljs.core.count(p1__117216_SHARP_) - (1));
});})(map__117217,map__117217__$1,spec,arglists,arglist,_AMPERSAND_args_QMARK_))
,arglists)):null);
return new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$f,f,cljs.core.cst$kw$params,arglists,cljs.core.cst$kw$arity,arity,cljs.core.cst$kw$_AMPERSAND_args_QMARK_,_AMPERSAND_args_QMARK_,cljs.core.cst$kw$spec,spec,cljs.core.cst$kw$code,null], null);
});
fluree.db.dbfunctions.core.find_fn = (function fluree$db$dbfunctions$core$find_fn(var_args){
var G__117226 = arguments.length;
switch (G__117226) {
case 2:
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$2 = (function (db,fn_name){
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3(db,fn_name,null);
});

fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_name,funType){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("DB functions not yet supported in javascript!",cljs.core.PersistentArrayMap.EMPTY);
});

fluree.db.dbfunctions.core.find_fn.cljs$lang$maxFixedArity = 3;

/**
 * Given a collection of function strings, returns a combined function using the and function
 */
fluree.db.dbfunctions.core.combine_fns = (function fluree$db$dbfunctions$core$combine_fns(fn_str_coll){
if((cljs.core.count(fn_str_coll) > (1))){
return ["(and ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",fn_str_coll)),")"].join('');
} else {
return cljs.core.first(fn_str_coll);
}
});
fluree.db.dbfunctions.core.symbol_whitelist = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, [cljs.core.cst$sym$_QMARK_pO,null,cljs.core.cst$sym$_QMARK_auth_id,null,cljs.core.cst$sym$sid,null,cljs.core.cst$sym$_QMARK_user_id,null,cljs.core.cst$sym$_QMARK_pid,null,cljs.core.cst$sym$_QMARK_a,null,cljs.core.cst$sym$_QMARK_db,null,cljs.core.cst$sym$_QMARK_s,null,cljs.core.cst$sym$_QMARK_o,null], null), null);
/**
 * Ensures contents of vector are allowed
 */
fluree.db.dbfunctions.core.parse_vector = (function fluree$db$dbfunctions$core$parse_vector(var_args){
var G__117230 = arguments.length;
switch (G__117230) {
case 2:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$2 = (function (db,vec){
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,vec,null,null);
});

fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$3 = (function (db,vec,funType){
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,vec,funType,null);
});

fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4 = (function (db,vec,funType,params){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_117349){
var state_val_117350 = (state_117349[(1)]);
if((state_val_117350 === (7))){
var inst_117247 = (state_117349[(7)]);
var state_117349__$1 = state_117349;
var statearr_117351_117415 = state_117349__$1;
(statearr_117351_117415[(2)] = inst_117247);

(statearr_117351_117415[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (20))){
var inst_117243 = (state_117349[(8)]);
var inst_117244 = (state_117349[(9)]);
var inst_117266 = (state_117349[(10)]);
var inst_117253 = (state_117349[(11)]);
var inst_117273 = (state_117349[(12)]);
var inst_117246 = (state_117349[(13)]);
var inst_117247 = (state_117349[(7)]);
var inst_117254 = (state_117349[(14)]);
var inst_117269 = [inst_117253];
var inst_117270 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_117269);
var inst_117271 = (function (){var x = inst_117253;
var seq__117250 = inst_117254;
var r = inst_117254;
var vec__117249 = inst_117246;
var first__117241 = inst_117243;
var acc = inst_117247;
var first__117251 = inst_117253;
var seq__117240 = inst_117244;
var G__117238 = inst_117246;
var vec__117239 = vec;
var or__4131__auto__ = inst_117266;
return ((function (x,seq__117250,r,vec__117249,first__117241,acc,first__117251,seq__117240,G__117238,vec__117239,or__4131__auto__,inst_117243,inst_117244,inst_117266,inst_117253,inst_117273,inst_117246,inst_117247,inst_117254,inst_117269,inst_117270,state_val_117350,c__99059__auto__){
return (function (p1__117228_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(p1__117228_SHARP_);
});
;})(x,seq__117250,r,vec__117249,first__117241,acc,first__117251,seq__117240,G__117238,vec__117239,or__4131__auto__,inst_117243,inst_117244,inst_117266,inst_117253,inst_117273,inst_117246,inst_117247,inst_117254,inst_117269,inst_117270,state_val_117350,c__99059__auto__))
})();
var inst_117272 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_117271,params);
var inst_117273__$1 = cljs.core.some(inst_117270,inst_117272);
var state_117349__$1 = (function (){var statearr_117352 = state_117349;
(statearr_117352[(12)] = inst_117273__$1);

return statearr_117352;
})();
if(cljs.core.truth_(inst_117273__$1)){
var statearr_117353_117416 = state_117349__$1;
(statearr_117353_117416[(1)] = (22));

} else {
var statearr_117354_117417 = state_117349__$1;
(statearr_117354_117417[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (27))){
var inst_117287 = (state_117349[(2)]);
var state_117349__$1 = state_117349;
var statearr_117355_117418 = state_117349__$1;
(statearr_117355_117418[(2)] = inst_117287);

(statearr_117355_117418[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (1))){
var state_117349__$1 = state_117349;
var statearr_117356_117419 = state_117349__$1;
(statearr_117356_117419[(2)] = null);

(statearr_117356_117419[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (24))){
var inst_117289 = (state_117349[(2)]);
var state_117349__$1 = state_117349;
var statearr_117357_117420 = state_117349__$1;
(statearr_117357_117420[(2)] = inst_117289);

(statearr_117357_117420[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (39))){
var state_117349__$1 = state_117349;
var statearr_117358_117421 = state_117349__$1;
(statearr_117358_117421[(1)] = (42));



return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_117349,(3),Error,null,(2));
var inst_117242 = cljs.core.seq(vec);
var inst_117243 = cljs.core.first(inst_117242);
var inst_117244 = cljs.core.next(inst_117242);
var inst_117245 = cljs.core.PersistentVector.EMPTY;
var inst_117246 = vec;
var inst_117247 = inst_117245;
var state_117349__$1 = (function (){var statearr_117360 = state_117349;
(statearr_117360[(8)] = inst_117243);

(statearr_117360[(9)] = inst_117244);

(statearr_117360[(13)] = inst_117246);

(statearr_117360[(7)] = inst_117247);

return statearr_117360;
})();
var statearr_117361_117422 = state_117349__$1;
(statearr_117361_117422[(2)] = null);

(statearr_117361_117422[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (15))){
var inst_117337 = (state_117349[(2)]);
var state_117349__$1 = state_117349;
var statearr_117362_117423 = state_117349__$1;
(statearr_117362_117423[(2)] = inst_117337);

(statearr_117362_117423[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (21))){
var inst_117291 = (state_117349[(2)]);
var state_117349__$1 = state_117349;
var statearr_117363_117424 = state_117349__$1;
(statearr_117363_117424[(2)] = inst_117291);

(statearr_117363_117424[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (31))){
var inst_117253 = (state_117349[(11)]);
var inst_117301 = fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,inst_117253,funType,params);
var state_117349__$1 = state_117349;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_117349__$1,(34),inst_117301);
} else {
if((state_val_117350 === (32))){
var inst_117253 = (state_117349[(11)]);
var inst_117306 = (inst_117253 == null);
var state_117349__$1 = state_117349;
if(cljs.core.truth_(inst_117306)){
var statearr_117364_117425 = state_117349__$1;
(statearr_117364_117425[(1)] = (35));

} else {
var statearr_117365_117426 = state_117349__$1;
(statearr_117365_117426[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (40))){
var inst_117327 = (state_117349[(2)]);
var state_117349__$1 = state_117349;
var statearr_117366_117427 = state_117349__$1;
(statearr_117366_117427[(2)] = inst_117327);

(statearr_117366_117427[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (33))){
var inst_117331 = (state_117349[(2)]);
var state_117349__$1 = state_117349;
var statearr_117367_117428 = state_117349__$1;
(statearr_117367_117428[(2)] = inst_117331);

(statearr_117367_117428[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (13))){
var inst_117253 = (state_117349[(11)]);
var state_117349__$1 = state_117349;
var statearr_117368_117429 = state_117349__$1;
(statearr_117368_117429[(2)] = inst_117253);

(statearr_117368_117429[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (22))){
var inst_117273 = (state_117349[(12)]);
var state_117349__$1 = state_117349;
var statearr_117369_117430 = state_117349__$1;
(statearr_117369_117430[(2)] = inst_117273);

(statearr_117369_117430[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (36))){
var inst_117253 = (state_117349[(11)]);
var inst_117309 = cljs.core.list_QMARK_(inst_117253);
var state_117349__$1 = state_117349;
if(inst_117309){
var statearr_117370_117431 = state_117349__$1;
(statearr_117370_117431[(1)] = (38));

} else {
var statearr_117371_117432 = state_117349__$1;
(statearr_117371_117432[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (41))){
var inst_117313 = (state_117349[(2)]);
var inst_117314 = fluree.db.util.async.throw_err(inst_117313);
var state_117349__$1 = state_117349;
var statearr_117372_117433 = state_117349__$1;
(statearr_117372_117433[(2)] = inst_117314);

(statearr_117372_117433[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (43))){
var state_117349__$1 = state_117349;
var statearr_117373_117434 = state_117349__$1;
(statearr_117373_117434[(2)] = null);

(statearr_117373_117434[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (29))){
var inst_117253 = (state_117349[(11)]);
var inst_117299 = cljs.core.vector_QMARK_(inst_117253);
var state_117349__$1 = state_117349;
if(inst_117299){
var statearr_117374_117435 = state_117349__$1;
(statearr_117374_117435[(1)] = (31));

} else {
var statearr_117375_117436 = state_117349__$1;
(statearr_117375_117436[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (44))){
var inst_117325 = (state_117349[(2)]);
var state_117349__$1 = state_117349;
var statearr_117376_117437 = state_117349__$1;
(statearr_117376_117437[(2)] = inst_117325);

(statearr_117376_117437[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (6))){
var inst_117345 = (state_117349[(2)]);
var state_117349__$1 = state_117349;
var statearr_117377_117438 = state_117349__$1;
(statearr_117377_117438[(2)] = inst_117345);


cljs.core.async.impl.ioc_helpers.process_exception(state_117349__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (28))){
var inst_117253 = (state_117349[(11)]);
var state_117349__$1 = state_117349;
var statearr_117378_117439 = state_117349__$1;
(statearr_117378_117439[(2)] = inst_117253);

(statearr_117378_117439[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (25))){
var inst_117276 = (state_117349[(15)]);
var state_117349__$1 = state_117349;
var statearr_117379_117440 = state_117349__$1;
(statearr_117379_117440[(2)] = inst_117276);

(statearr_117379_117440[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (34))){
var inst_117303 = (state_117349[(2)]);
var inst_117304 = fluree.db.util.async.throw_err(inst_117303);
var state_117349__$1 = state_117349;
var statearr_117380_117441 = state_117349__$1;
(statearr_117380_117441[(2)] = inst_117304);

(statearr_117380_117441[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (17))){
var inst_117253 = (state_117349[(11)]);
var inst_117293 = inst_117253 === true;
var inst_117294 = inst_117253 === false;
var inst_117295 = (inst_117253 == null);
var inst_117296 = ((inst_117293) || (inst_117294) || (inst_117295));
var state_117349__$1 = state_117349;
if(cljs.core.truth_(inst_117296)){
var statearr_117381_117442 = state_117349__$1;
(statearr_117381_117442[(1)] = (28));

} else {
var statearr_117382_117443 = state_117349__$1;
(statearr_117382_117443[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (3))){
var inst_117231 = (state_117349[(2)]);
var state_117349__$1 = state_117349;
var statearr_117383_117444 = state_117349__$1;
(statearr_117383_117444[(2)] = inst_117231);


cljs.core.async.impl.ioc_helpers.process_exception(state_117349__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (12))){
var inst_117247 = (state_117349[(7)]);
var inst_117254 = (state_117349[(14)]);
var inst_117339 = (state_117349[(2)]);
var inst_117340 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_117247,inst_117339);
var inst_117246 = inst_117254;
var inst_117247__$1 = inst_117340;
var state_117349__$1 = (function (){var statearr_117384 = state_117349;
(statearr_117384[(13)] = inst_117246);

(statearr_117384[(7)] = inst_117247__$1);

return statearr_117384;
})();
var statearr_117385_117445 = state_117349__$1;
(statearr_117385_117445[(2)] = null);

(statearr_117385_117445[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (2))){
var inst_117347 = (state_117349[(2)]);
var state_117349__$1 = state_117349;
return cljs.core.async.impl.ioc_helpers.return_chan(state_117349__$1,inst_117347);
} else {
if((state_val_117350 === (23))){
var inst_117276 = (state_117349[(15)]);
var inst_117276__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(funType,"functionDec");
var state_117349__$1 = (function (){var statearr_117386 = state_117349;
(statearr_117386[(15)] = inst_117276__$1);

return statearr_117386;
})();
if(inst_117276__$1){
var statearr_117387_117446 = state_117349__$1;
(statearr_117387_117446[(1)] = (25));

} else {
var statearr_117388_117447 = state_117349__$1;
(statearr_117388_117447[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (35))){
var inst_117253 = (state_117349[(11)]);
var state_117349__$1 = state_117349;
var statearr_117389_117448 = state_117349__$1;
(statearr_117389_117448[(2)] = inst_117253);

(statearr_117389_117448[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (19))){
var inst_117266 = (state_117349[(10)]);
var state_117349__$1 = state_117349;
var statearr_117390_117449 = state_117349__$1;
(statearr_117390_117449[(2)] = inst_117266);

(statearr_117390_117449[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (11))){
var inst_117253 = (state_117349[(11)]);
var inst_117261 = typeof inst_117253 === 'number';
var state_117349__$1 = state_117349;
if(cljs.core.truth_(inst_117261)){
var statearr_117391_117450 = state_117349__$1;
(statearr_117391_117450[(1)] = (13));

} else {
var statearr_117392_117451 = state_117349__$1;
(statearr_117392_117451[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (9))){
var inst_117343 = (state_117349[(2)]);
var state_117349__$1 = state_117349;
var statearr_117393_117452 = state_117349__$1;
(statearr_117393_117452[(2)] = inst_117343);

(statearr_117393_117452[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (5))){
var inst_117253 = (state_117349[(11)]);
var inst_117246 = (state_117349[(13)]);
var inst_117252 = cljs.core.seq(inst_117246);
var inst_117253__$1 = cljs.core.first(inst_117252);
var inst_117254 = cljs.core.next(inst_117252);
var inst_117255 = (inst_117253__$1 == null);
var state_117349__$1 = (function (){var statearr_117394 = state_117349;
(statearr_117394[(11)] = inst_117253__$1);

(statearr_117394[(14)] = inst_117254);

return statearr_117394;
})();
if(cljs.core.truth_(inst_117255)){
var statearr_117395_117453 = state_117349__$1;
(statearr_117395_117453[(1)] = (7));

} else {
var statearr_117396_117454 = state_117349__$1;
(statearr_117396_117454[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (14))){
var inst_117253 = (state_117349[(11)]);
var inst_117264 = (inst_117253 instanceof cljs.core.Symbol);
var state_117349__$1 = state_117349;
if(cljs.core.truth_(inst_117264)){
var statearr_117397_117455 = state_117349__$1;
(statearr_117397_117455[(1)] = (16));

} else {
var statearr_117398_117456 = state_117349__$1;
(statearr_117398_117456[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (26))){
var inst_117253 = (state_117349[(11)]);
var inst_117279 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([vec], 0));
var inst_117280 = ["Invalid symbol: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_117253)," used in function.",inst_117279].join('');
var inst_117281 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_117282 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_117283 = cljs.core.PersistentHashMap.fromArrays(inst_117281,inst_117282);
var inst_117284 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_117280,inst_117283);
var inst_117285 = (function(){throw inst_117284})();
var state_117349__$1 = state_117349;
var statearr_117399_117457 = state_117349__$1;
(statearr_117399_117457[(2)] = inst_117285);

(statearr_117399_117457[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (16))){
var inst_117266 = (state_117349[(10)]);
var inst_117253 = (state_117349[(11)]);
var inst_117266__$1 = (fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1(inst_117253) : fluree.db.dbfunctions.core.symbol_whitelist.call(null,inst_117253));
var state_117349__$1 = (function (){var statearr_117400 = state_117349;
(statearr_117400[(10)] = inst_117266__$1);

return statearr_117400;
})();
if(cljs.core.truth_(inst_117266__$1)){
var statearr_117401_117458 = state_117349__$1;
(statearr_117401_117458[(1)] = (19));

} else {
var statearr_117402_117459 = state_117349__$1;
(statearr_117402_117459[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (38))){
var inst_117253 = (state_117349[(11)]);
var inst_117311 = (fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 ? fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_117253,funType,params) : fluree.db.dbfunctions.core.resolve_fn.call(null,db,inst_117253,funType,params));
var state_117349__$1 = state_117349;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_117349__$1,(41),inst_117311);
} else {
if((state_val_117350 === (30))){
var inst_117333 = (state_117349[(2)]);
var state_117349__$1 = state_117349;
var statearr_117403_117460 = state_117349__$1;
(statearr_117403_117460[(2)] = inst_117333);

(statearr_117403_117460[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (10))){
var inst_117253 = (state_117349[(11)]);
var state_117349__$1 = state_117349;
var statearr_117404_117461 = state_117349__$1;
(statearr_117404_117461[(2)] = inst_117253);

(statearr_117404_117461[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (18))){
var inst_117335 = (state_117349[(2)]);
var state_117349__$1 = state_117349;
var statearr_117405_117462 = state_117349__$1;
(statearr_117405_117462[(2)] = inst_117335);

(statearr_117405_117462[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (42))){
var inst_117253 = (state_117349[(11)]);
var inst_117317 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_117253], 0));
var inst_117318 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([vec], 0));
var inst_117319 = ["Illegal element (",inst_117317,") in vector: ",inst_117318,"."].join('');
var inst_117320 = cljs.core.PersistentHashMap.EMPTY;
var inst_117321 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_117319,inst_117320);
var inst_117322 = (function(){throw inst_117321})();
var state_117349__$1 = state_117349;
var statearr_117406_117463 = state_117349__$1;
(statearr_117406_117463[(2)] = inst_117322);

(statearr_117406_117463[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (37))){
var inst_117329 = (state_117349[(2)]);
var state_117349__$1 = state_117349;
var statearr_117407_117464 = state_117349__$1;
(statearr_117407_117464[(2)] = inst_117329);

(statearr_117407_117464[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (8))){
var inst_117253 = (state_117349[(11)]);
var inst_117258 = typeof inst_117253 === 'string';
var state_117349__$1 = state_117349;
if(cljs.core.truth_(inst_117258)){
var statearr_117408_117465 = state_117349__$1;
(statearr_117408_117465[(1)] = (10));

} else {
var statearr_117409_117466 = state_117349__$1;
(statearr_117409_117466[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$core$state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__99037__auto____0 = (function (){
var statearr_117410 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_117410[(0)] = fluree$db$dbfunctions$core$state_machine__99037__auto__);

(statearr_117410[(1)] = (1));

return statearr_117410;
});
var fluree$db$dbfunctions$core$state_machine__99037__auto____1 = (function (state_117349){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_117349);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e117411){if((e117411 instanceof Object)){
var ex__99040__auto__ = e117411;
var statearr_117412_117467 = state_117349;
(statearr_117412_117467[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_117349);

return cljs.core.cst$kw$recur;
} else {
throw e117411;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__117468 = state_117349;
state_117349 = G__117468;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__99037__auto__ = function(state_117349){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__99037__auto____1.call(this,state_117349);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__99037__auto____0;
fluree$db$dbfunctions$core$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__99037__auto____1;
return fluree$db$dbfunctions$core$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_117413 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_117413[(6)] = c__99059__auto__);

return statearr_117413;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

fluree.db.dbfunctions.core.parse_vector.cljs$lang$maxFixedArity = 4;

/**
 * Resolves a full code form expression.
 */
fluree.db.dbfunctions.core.resolve_fn = (function fluree$db$dbfunctions$core$resolve_fn(var_args){
var G__117471 = arguments.length;
switch (G__117471) {
case 2:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$2 = (function (db,form){
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,form,null,null);
});

fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,form,type){
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,form,type,null);
});

fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 = (function (db,form,type,params){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_117645){
var state_val_117646 = (state_117645[(1)]);
if((state_val_117646 === (62))){
var state_117645__$1 = state_117645;
var statearr_117647_117738 = state_117645__$1;
(statearr_117647_117738[(2)] = null);

(statearr_117647_117738[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (7))){
var state_117645__$1 = state_117645;
var statearr_117648_117739 = state_117645__$1;
(statearr_117648_117739[(2)] = false);

(statearr_117648_117739[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (59))){
var state_117645__$1 = state_117645;
var statearr_117649_117740 = state_117645__$1;
(statearr_117649_117740[(1)] = (61));



return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (20))){
var inst_117478 = (state_117645[(7)]);
var inst_117522 = (state_117645[(2)]);
var inst_117530 = cljs.core.seq(inst_117478);
var inst_117531 = cljs.core.first(inst_117530);
var inst_117532 = cljs.core.next(inst_117530);
var inst_117533 = cljs.core.PersistentVector.EMPTY;
var inst_117534 = inst_117478;
var inst_117535 = inst_117533;
var state_117645__$1 = (function (){var statearr_117651 = state_117645;
(statearr_117651[(8)] = inst_117531);

(statearr_117651[(9)] = inst_117535);

(statearr_117651[(10)] = inst_117532);

(statearr_117651[(11)] = inst_117534);

(statearr_117651[(12)] = inst_117522);

return statearr_117651;
})();
var statearr_117652_117741 = state_117645__$1;
(statearr_117652_117741[(2)] = null);

(statearr_117652_117741[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (58))){
var inst_117541 = (state_117645[(13)]);
var state_117645__$1 = state_117645;
var statearr_117653_117742 = state_117645__$1;
(statearr_117653_117742[(2)] = inst_117541);

(statearr_117653_117742[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (60))){
var inst_117619 = (state_117645[(2)]);
var state_117645__$1 = state_117645;
var statearr_117654_117743 = state_117645__$1;
(statearr_117654_117743[(2)] = inst_117619);

(statearr_117654_117743[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (27))){
var inst_117535 = (state_117645[(9)]);
var state_117645__$1 = state_117645;
var statearr_117655_117744 = state_117645__$1;
(statearr_117655_117744[(2)] = inst_117535);

(statearr_117655_117744[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (1))){
var state_117645__$1 = state_117645;
var statearr_117656_117745 = state_117645__$1;
(statearr_117656_117745[(2)] = null);

(statearr_117656_117745[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (24))){
var inst_117541 = (state_117645[(13)]);
var inst_117545 = inst_117541 === false;
var state_117645__$1 = state_117645;
var statearr_117657_117746 = state_117645__$1;
(statearr_117657_117746[(2)] = inst_117545);

(statearr_117657_117746[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (55))){
var inst_117541 = (state_117645[(13)]);
var inst_117604 = (inst_117541 == null);
var state_117645__$1 = state_117645;
if(cljs.core.truth_(inst_117604)){
var statearr_117658_117747 = state_117645__$1;
(statearr_117658_117747[(1)] = (58));

} else {
var statearr_117659_117748 = state_117645__$1;
(statearr_117659_117748[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (39))){
var inst_117564 = (state_117645[(14)]);
var inst_117541 = (state_117645[(13)]);
var inst_117564__$1 = (fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1(inst_117541) : fluree.db.dbfunctions.core.symbol_whitelist.call(null,inst_117541));
var state_117645__$1 = (function (){var statearr_117660 = state_117645;
(statearr_117660[(14)] = inst_117564__$1);

return statearr_117660;
})();
if(cljs.core.truth_(inst_117564__$1)){
var statearr_117661_117749 = state_117645__$1;
(statearr_117661_117749[(1)] = (42));

} else {
var statearr_117662_117750 = state_117645__$1;
(statearr_117662_117750[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (46))){
var inst_117574 = (state_117645[(15)]);
var inst_117574__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"functionDec");
var state_117645__$1 = (function (){var statearr_117663 = state_117645;
(statearr_117663[(15)] = inst_117574__$1);

return statearr_117663;
})();
if(inst_117574__$1){
var statearr_117664_117751 = state_117645__$1;
(statearr_117664_117751[(1)] = (48));

} else {
var statearr_117665_117752 = state_117645__$1;
(statearr_117665_117752[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (4))){
var inst_117478 = (state_117645[(7)]);
var inst_117477 = (state_117645[(16)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_117645,(3),Error,null,(2));
var inst_117477__$1 = cljs.core.first(form);
var inst_117478__$1 = cljs.core.rest(form);
var inst_117479 = cljs.core.count(inst_117478__$1);
var inst_117480 = fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3(db,inst_117477__$1,type);
var state_117645__$1 = (function (){var statearr_117666 = state_117645;
(statearr_117666[(7)] = inst_117478__$1);

(statearr_117666[(17)] = inst_117479);

(statearr_117666[(16)] = inst_117477__$1);

return statearr_117666;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_117645__$1,(5),inst_117480);
} else {
if((state_val_117646 === (54))){
var inst_117541 = (state_117645[(13)]);
var inst_117599 = fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,inst_117541,type,params);
var state_117645__$1 = state_117645;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_117645__$1,(57),inst_117599);
} else {
if((state_val_117646 === (15))){
var inst_117508 = (state_117645[(18)]);
var state_117645__$1 = state_117645;
var statearr_117667_117753 = state_117645__$1;
(statearr_117667_117753[(2)] = inst_117508);

(statearr_117667_117753[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (48))){
var inst_117574 = (state_117645[(15)]);
var state_117645__$1 = state_117645;
var statearr_117668_117754 = state_117645__$1;
(statearr_117668_117754[(2)] = inst_117574);

(statearr_117668_117754[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (50))){
var inst_117585 = (state_117645[(2)]);
var state_117645__$1 = state_117645;
var statearr_117669_117755 = state_117645__$1;
(statearr_117669_117755[(2)] = inst_117585);

(statearr_117669_117755[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (21))){
var inst_117541 = (state_117645[(13)]);
var inst_117534 = (state_117645[(11)]);
var inst_117540 = cljs.core.seq(inst_117534);
var inst_117541__$1 = cljs.core.first(inst_117540);
var inst_117542 = cljs.core.next(inst_117540);
var state_117645__$1 = (function (){var statearr_117670 = state_117645;
(statearr_117670[(13)] = inst_117541__$1);

(statearr_117670[(19)] = inst_117542);

return statearr_117670;
})();
if(cljs.core.truth_(inst_117541__$1)){
var statearr_117671_117756 = state_117645__$1;
(statearr_117671_117756[(1)] = (23));

} else {
var statearr_117672_117757 = state_117645__$1;
(statearr_117672_117757[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (31))){
var inst_117535 = (state_117645[(9)]);
var inst_117542 = (state_117645[(19)]);
var inst_117631 = (state_117645[(2)]);
var inst_117632 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_117535,inst_117631);
var inst_117534 = inst_117542;
var inst_117535__$1 = inst_117632;
var state_117645__$1 = (function (){var statearr_117673 = state_117645;
(statearr_117673[(9)] = inst_117535__$1);

(statearr_117673[(11)] = inst_117534);

return statearr_117673;
})();
var statearr_117674_117758 = state_117645__$1;
(statearr_117674_117758[(2)] = null);

(statearr_117674_117758[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (32))){
var inst_117553 = (state_117645[(2)]);
var inst_117554 = fluree.db.util.async.throw_err(inst_117553);
var state_117645__$1 = state_117645;
var statearr_117675_117759 = state_117645__$1;
(statearr_117675_117759[(2)] = inst_117554);

(statearr_117675_117759[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (40))){
var inst_117541 = (state_117645[(13)]);
var inst_117591 = inst_117541 === true;
var inst_117592 = inst_117541 === false;
var inst_117593 = (inst_117541 == null);
var inst_117594 = ((inst_117591) || (inst_117592) || (inst_117593));
var state_117645__$1 = state_117645;
if(cljs.core.truth_(inst_117594)){
var statearr_117676_117760 = state_117645__$1;
(statearr_117676_117760[(1)] = (51));

} else {
var statearr_117677_117761 = state_117645__$1;
(statearr_117677_117761[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (56))){
var inst_117621 = (state_117645[(2)]);
var state_117645__$1 = state_117645;
var statearr_117678_117762 = state_117645__$1;
(statearr_117678_117762[(2)] = inst_117621);

(statearr_117678_117762[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (33))){
var inst_117541 = (state_117645[(13)]);
var state_117645__$1 = state_117645;
var statearr_117679_117763 = state_117645__$1;
(statearr_117679_117763[(2)] = inst_117541);

(statearr_117679_117763[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (13))){
var inst_117483 = (state_117645[(20)]);
var state_117645__$1 = state_117645;
var statearr_117680_117764 = state_117645__$1;
(statearr_117680_117764[(2)] = inst_117483);

(statearr_117680_117764[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (22))){
var inst_117505 = (state_117645[(21)]);
var inst_117638 = (state_117645[(2)]);
var inst_117639 = cljs.core.cst$sym$_QMARK_ctx;
var inst_117640 = cljs.core.cons(inst_117639,inst_117638);
var inst_117641 = cljs.core.cons(inst_117505,inst_117640);
var state_117645__$1 = state_117645;
var statearr_117681_117765 = state_117645__$1;
(statearr_117681_117765[(2)] = inst_117641);


cljs.core.async.impl.ioc_helpers.process_exception(state_117645__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (36))){
var inst_117541 = (state_117645[(13)]);
var state_117645__$1 = state_117645;
var statearr_117682_117766 = state_117645__$1;
(statearr_117682_117766[(2)] = inst_117541);

(statearr_117682_117766[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (41))){
var inst_117625 = (state_117645[(2)]);
var state_117645__$1 = state_117645;
var statearr_117683_117767 = state_117645__$1;
(statearr_117683_117767[(2)] = inst_117625);

(statearr_117683_117767[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (43))){
var inst_117564 = (state_117645[(14)]);
var inst_117478 = (state_117645[(7)]);
var inst_117504 = (state_117645[(22)]);
var inst_117531 = (state_117645[(8)]);
var inst_117541 = (state_117645[(13)]);
var inst_117571 = (state_117645[(23)]);
var inst_117535 = (state_117645[(9)]);
var inst_117532 = (state_117645[(10)]);
var inst_117508 = (state_117645[(18)]);
var inst_117534 = (state_117645[(11)]);
var inst_117483 = (state_117645[(20)]);
var inst_117522 = (state_117645[(12)]);
var inst_117507 = (state_117645[(24)]);
var inst_117506 = (state_117645[(25)]);
var inst_117479 = (state_117645[(17)]);
var inst_117542 = (state_117645[(19)]);
var inst_117477 = (state_117645[(16)]);
var inst_117505 = (state_117645[(21)]);
var inst_117567 = [inst_117541];
var inst_117568 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_117567);
var inst_117569 = (function (){var seq__117528 = inst_117532;
var arity = inst_117506;
var args_n = inst_117479;
var fn_map = inst_117483;
var vec__117527 = inst_117478;
var args = inst_117478;
var seq__117538 = inst_117542;
var r = inst_117542;
var first__117539 = inst_117541;
var _ = inst_117522;
var vec__117537 = inst_117534;
var acc = inst_117535;
var arglist = inst_117507;
var fn_name = inst_117477;
var _AMPERSAND_args_QMARK_ = inst_117508;
var map__117476 = inst_117504;
var arg = inst_117541;
var first__117529 = inst_117531;
var or__4131__auto__ = inst_117564;
var G__117526 = inst_117534;
var f = inst_117505;
return ((function (seq__117528,arity,args_n,fn_map,vec__117527,args,seq__117538,r,first__117539,_,vec__117537,acc,arglist,fn_name,_AMPERSAND_args_QMARK_,map__117476,arg,first__117529,or__4131__auto__,G__117526,f,inst_117564,inst_117478,inst_117504,inst_117531,inst_117541,inst_117571,inst_117535,inst_117532,inst_117508,inst_117534,inst_117483,inst_117522,inst_117507,inst_117506,inst_117479,inst_117542,inst_117477,inst_117505,inst_117567,inst_117568,state_val_117646,c__99059__auto__){
return (function (p1__117469_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(p1__117469_SHARP_);
});
;})(seq__117528,arity,args_n,fn_map,vec__117527,args,seq__117538,r,first__117539,_,vec__117537,acc,arglist,fn_name,_AMPERSAND_args_QMARK_,map__117476,arg,first__117529,or__4131__auto__,G__117526,f,inst_117564,inst_117478,inst_117504,inst_117531,inst_117541,inst_117571,inst_117535,inst_117532,inst_117508,inst_117534,inst_117483,inst_117522,inst_117507,inst_117506,inst_117479,inst_117542,inst_117477,inst_117505,inst_117567,inst_117568,state_val_117646,c__99059__auto__))
})();
var inst_117570 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_117569,params);
var inst_117571__$1 = cljs.core.some(inst_117568,inst_117570);
var state_117645__$1 = (function (){var statearr_117684 = state_117645;
(statearr_117684[(23)] = inst_117571__$1);

return statearr_117684;
})();
if(cljs.core.truth_(inst_117571__$1)){
var statearr_117685_117768 = state_117645__$1;
(statearr_117685_117768[(1)] = (45));

} else {
var statearr_117686_117769 = state_117645__$1;
(statearr_117686_117769[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (61))){
var inst_117541 = (state_117645[(13)]);
var inst_117608 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_117541], 0));
var inst_117609 = (type.cljs$core$IFn$_invoke$arity$1 ? type.cljs$core$IFn$_invoke$arity$1(inst_117541) : type.call(null,inst_117541));
var inst_117610 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([form], 0));
var inst_117611 = ["Illegal element (",inst_117608,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_117609),") in function argument: ",inst_117610,"."].join('');
var inst_117612 = cljs.core.PersistentHashMap.EMPTY;
var inst_117613 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_117611,inst_117612);
var inst_117614 = (function(){throw inst_117613})();
var state_117645__$1 = state_117645;
var statearr_117687_117770 = state_117645__$1;
(statearr_117687_117770[(2)] = inst_117614);

(statearr_117687_117770[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (29))){
var inst_117541 = (state_117645[(13)]);
var inst_117551 = fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_117541,type,params);
var state_117645__$1 = state_117645;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_117645__$1,(32),inst_117551);
} else {
if((state_val_117646 === (44))){
var inst_117589 = (state_117645[(2)]);
var state_117645__$1 = state_117645;
var statearr_117688_117771 = state_117645__$1;
(statearr_117688_117771[(2)] = inst_117589);

(statearr_117688_117771[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (6))){
var inst_117483 = (state_117645[(20)]);
var inst_117488 = inst_117483.cljs$lang$protocol_mask$partition0$;
var inst_117489 = (inst_117488 & (64));
var inst_117490 = inst_117483.cljs$core$ISeq$;
var inst_117491 = (cljs.core.PROTOCOL_SENTINEL === inst_117490);
var inst_117492 = ((inst_117489) || (inst_117491));
var state_117645__$1 = state_117645;
if(cljs.core.truth_(inst_117492)){
var statearr_117689_117772 = state_117645__$1;
(statearr_117689_117772[(1)] = (9));

} else {
var statearr_117690_117773 = state_117645__$1;
(statearr_117690_117773[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (28))){
var inst_117636 = (state_117645[(2)]);
var state_117645__$1 = state_117645;
var statearr_117691_117774 = state_117645__$1;
(statearr_117691_117774[(2)] = inst_117636);

(statearr_117691_117774[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (51))){
var inst_117541 = (state_117645[(13)]);
var state_117645__$1 = state_117645;
var statearr_117692_117775 = state_117645__$1;
(statearr_117692_117775[(2)] = inst_117541);

(statearr_117692_117775[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (25))){
var inst_117547 = (state_117645[(2)]);
var state_117645__$1 = state_117645;
if(cljs.core.truth_(inst_117547)){
var statearr_117693_117776 = state_117645__$1;
(statearr_117693_117776[(1)] = (26));

} else {
var statearr_117694_117777 = state_117645__$1;
(statearr_117694_117777[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (34))){
var inst_117541 = (state_117645[(13)]);
var inst_117559 = typeof inst_117541 === 'number';
var state_117645__$1 = state_117645;
if(cljs.core.truth_(inst_117559)){
var statearr_117695_117778 = state_117645__$1;
(statearr_117695_117778[(1)] = (36));

} else {
var statearr_117696_117779 = state_117645__$1;
(statearr_117696_117779[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (17))){
var inst_117513 = (state_117645[(2)]);
var inst_117514 = cljs.core.not(inst_117513);
var state_117645__$1 = state_117645;
if(inst_117514){
var statearr_117697_117780 = state_117645__$1;
(statearr_117697_117780[(1)] = (18));

} else {
var statearr_117698_117781 = state_117645__$1;
(statearr_117698_117781[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (3))){
var inst_117472 = (state_117645[(2)]);
var state_117645__$1 = state_117645;
var statearr_117699_117782 = state_117645__$1;
(statearr_117699_117782[(2)] = inst_117472);


cljs.core.async.impl.ioc_helpers.process_exception(state_117645__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (12))){
var inst_117483 = (state_117645[(20)]);
var inst_117501 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_117483);
var state_117645__$1 = state_117645;
var statearr_117700_117783 = state_117645__$1;
(statearr_117700_117783[(2)] = inst_117501);

(statearr_117700_117783[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (2))){
var inst_117643 = (state_117645[(2)]);
var state_117645__$1 = state_117645;
return cljs.core.async.impl.ioc_helpers.return_chan(state_117645__$1,inst_117643);
} else {
if((state_val_117646 === (23))){
var inst_117541 = (state_117645[(13)]);
var state_117645__$1 = state_117645;
var statearr_117701_117784 = state_117645__$1;
(statearr_117701_117784[(2)] = inst_117541);

(statearr_117701_117784[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (47))){
var inst_117587 = (state_117645[(2)]);
var state_117645__$1 = state_117645;
var statearr_117702_117785 = state_117645__$1;
(statearr_117702_117785[(2)] = inst_117587);

(statearr_117702_117785[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (35))){
var inst_117629 = (state_117645[(2)]);
var state_117645__$1 = state_117645;
var statearr_117703_117786 = state_117645__$1;
(statearr_117703_117786[(2)] = inst_117629);

(statearr_117703_117786[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (19))){
var state_117645__$1 = state_117645;
var statearr_117704_117787 = state_117645__$1;
(statearr_117704_117787[(2)] = null);

(statearr_117704_117787[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (57))){
var inst_117601 = (state_117645[(2)]);
var inst_117602 = fluree.db.util.async.throw_err(inst_117601);
var state_117645__$1 = state_117645;
var statearr_117705_117788 = state_117645__$1;
(statearr_117705_117788[(2)] = inst_117602);

(statearr_117705_117788[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (11))){
var inst_117496 = (state_117645[(2)]);
var state_117645__$1 = state_117645;
var statearr_117706_117789 = state_117645__$1;
(statearr_117706_117789[(2)] = inst_117496);

(statearr_117706_117789[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (9))){
var state_117645__$1 = state_117645;
var statearr_117707_117790 = state_117645__$1;
(statearr_117707_117790[(2)] = true);

(statearr_117707_117790[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (5))){
var inst_117483 = (state_117645[(20)]);
var inst_117482 = (state_117645[(2)]);
var inst_117483__$1 = fluree.db.util.async.throw_err(inst_117482);
var inst_117485 = (inst_117483__$1 == null);
var inst_117486 = cljs.core.not(inst_117485);
var state_117645__$1 = (function (){var statearr_117708 = state_117645;
(statearr_117708[(20)] = inst_117483__$1);

return statearr_117708;
})();
if(inst_117486){
var statearr_117709_117791 = state_117645__$1;
(statearr_117709_117791[(1)] = (6));

} else {
var statearr_117710_117792 = state_117645__$1;
(statearr_117710_117792[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (14))){
var inst_117504 = (state_117645[(22)]);
var inst_117508 = (state_117645[(18)]);
var inst_117504__$1 = (state_117645[(2)]);
var inst_117505 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_117504__$1,cljs.core.cst$kw$f);
var inst_117506 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_117504__$1,cljs.core.cst$kw$arity);
var inst_117507 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_117504__$1,cljs.core.cst$kw$arglist);
var inst_117508__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_117504__$1,cljs.core.cst$kw$_AMPERSAND_args_QMARK_);
var state_117645__$1 = (function (){var statearr_117711 = state_117645;
(statearr_117711[(22)] = inst_117504__$1);

(statearr_117711[(18)] = inst_117508__$1);

(statearr_117711[(24)] = inst_117507);

(statearr_117711[(25)] = inst_117506);

(statearr_117711[(21)] = inst_117505);

return statearr_117711;
})();
if(cljs.core.truth_(inst_117508__$1)){
var statearr_117712_117793 = state_117645__$1;
(statearr_117712_117793[(1)] = (15));

} else {
var statearr_117713_117794 = state_117645__$1;
(statearr_117713_117794[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (45))){
var inst_117571 = (state_117645[(23)]);
var state_117645__$1 = state_117645;
var statearr_117714_117795 = state_117645__$1;
(statearr_117714_117795[(2)] = inst_117571);

(statearr_117714_117795[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (53))){
var inst_117623 = (state_117645[(2)]);
var state_117645__$1 = state_117645;
var statearr_117715_117796 = state_117645__$1;
(statearr_117715_117796[(2)] = inst_117623);

(statearr_117715_117796[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (26))){
var inst_117541 = (state_117645[(13)]);
var inst_117549 = cljs.core.list_QMARK_(inst_117541);
var state_117645__$1 = state_117645;
if(inst_117549){
var statearr_117716_117797 = state_117645__$1;
(statearr_117716_117797[(1)] = (29));

} else {
var statearr_117717_117798 = state_117645__$1;
(statearr_117717_117798[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (16))){
var inst_117506 = (state_117645[(25)]);
var inst_117479 = (state_117645[(17)]);
var inst_117511 = (inst_117506.cljs$core$IFn$_invoke$arity$1 ? inst_117506.cljs$core$IFn$_invoke$arity$1(inst_117479) : inst_117506.call(null,inst_117479));
var state_117645__$1 = state_117645;
var statearr_117718_117799 = state_117645__$1;
(statearr_117718_117799[(2)] = inst_117511);

(statearr_117718_117799[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (38))){
var inst_117627 = (state_117645[(2)]);
var state_117645__$1 = state_117645;
var statearr_117719_117800 = state_117645__$1;
(statearr_117719_117800[(2)] = inst_117627);

(statearr_117719_117800[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (30))){
var inst_117541 = (state_117645[(13)]);
var inst_117556 = typeof inst_117541 === 'string';
var state_117645__$1 = state_117645;
if(cljs.core.truth_(inst_117556)){
var statearr_117720_117801 = state_117645__$1;
(statearr_117720_117801[(1)] = (33));

} else {
var statearr_117721_117802 = state_117645__$1;
(statearr_117721_117802[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (10))){
var state_117645__$1 = state_117645;
var statearr_117722_117803 = state_117645__$1;
(statearr_117722_117803[(2)] = false);

(statearr_117722_117803[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (18))){
var inst_117506 = (state_117645[(25)]);
var inst_117479 = (state_117645[(17)]);
var inst_117477 = (state_117645[(16)]);
var inst_117516 = ["Incorrect arity for function ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_117477),". Expected ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_117506),", provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_117479),"."].join('');
var inst_117517 = cljs.core.PersistentHashMap.EMPTY;
var inst_117518 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_117516,inst_117517);
var inst_117519 = (function(){throw inst_117518})();
var state_117645__$1 = state_117645;
var statearr_117723_117804 = state_117645__$1;
(statearr_117723_117804[(2)] = inst_117519);

(statearr_117723_117804[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (52))){
var inst_117541 = (state_117645[(13)]);
var inst_117597 = cljs.core.vector_QMARK_(inst_117541);
var state_117645__$1 = state_117645;
if(inst_117597){
var statearr_117724_117805 = state_117645__$1;
(statearr_117724_117805[(1)] = (54));

} else {
var statearr_117725_117806 = state_117645__$1;
(statearr_117725_117806[(1)] = (55));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (42))){
var inst_117564 = (state_117645[(14)]);
var state_117645__$1 = state_117645;
var statearr_117726_117807 = state_117645__$1;
(statearr_117726_117807[(2)] = inst_117564);

(statearr_117726_117807[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (37))){
var inst_117541 = (state_117645[(13)]);
var inst_117562 = (inst_117541 instanceof cljs.core.Symbol);
var state_117645__$1 = state_117645;
if(cljs.core.truth_(inst_117562)){
var statearr_117727_117808 = state_117645__$1;
(statearr_117727_117808[(1)] = (39));

} else {
var statearr_117728_117809 = state_117645__$1;
(statearr_117728_117809[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (63))){
var inst_117617 = (state_117645[(2)]);
var state_117645__$1 = state_117645;
var statearr_117729_117810 = state_117645__$1;
(statearr_117729_117810[(2)] = inst_117617);

(statearr_117729_117810[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (8))){
var inst_117499 = (state_117645[(2)]);
var state_117645__$1 = state_117645;
if(cljs.core.truth_(inst_117499)){
var statearr_117730_117811 = state_117645__$1;
(statearr_117730_117811[(1)] = (12));

} else {
var statearr_117731_117812 = state_117645__$1;
(statearr_117731_117812[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117646 === (49))){
var inst_117541 = (state_117645[(13)]);
var inst_117577 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([form], 0));
var inst_117578 = ["Invalid symbol: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_117541)," used in function argument: ",inst_117577].join('');
var inst_117579 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_117580 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_117581 = cljs.core.PersistentHashMap.fromArrays(inst_117579,inst_117580);
var inst_117582 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_117578,inst_117581);
var inst_117583 = (function(){throw inst_117582})();
var state_117645__$1 = state_117645;
var statearr_117732_117813 = state_117645__$1;
(statearr_117732_117813[(2)] = inst_117583);

(statearr_117732_117813[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$core$state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__99037__auto____0 = (function (){
var statearr_117733 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_117733[(0)] = fluree$db$dbfunctions$core$state_machine__99037__auto__);

(statearr_117733[(1)] = (1));

return statearr_117733;
});
var fluree$db$dbfunctions$core$state_machine__99037__auto____1 = (function (state_117645){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_117645);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e117734){if((e117734 instanceof Object)){
var ex__99040__auto__ = e117734;
var statearr_117735_117814 = state_117645;
(statearr_117735_117814[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_117645);

return cljs.core.cst$kw$recur;
} else {
throw e117734;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__117815 = state_117645;
state_117645 = G__117815;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__99037__auto__ = function(state_117645){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__99037__auto____1.call(this,state_117645);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__99037__auto____0;
fluree$db$dbfunctions$core$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__99037__auto____1;
return fluree$db$dbfunctions$core$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_117736 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_117736[(6)] = c__99059__auto__);

return statearr_117736;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

fluree.db.dbfunctions.core.resolve_fn.cljs$lang$maxFixedArity = 4;

fluree.db.dbfunctions.core.parse_fn = (function fluree$db$dbfunctions$core$parse_fn(var_args){
var G__117817 = arguments.length;
switch (G__117817) {
case 3:
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_str,type){
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4(db,fn_str,type,null);
});

fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4 = (function (db,fn_str,type,params){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_117889){
var state_val_117890 = (state_117889[(1)]);
if((state_val_117890 === (7))){
var inst_117885 = (state_117889[(2)]);
var state_117889__$1 = state_117889;
var statearr_117891_117921 = state_117889__$1;
(statearr_117891_117921[(2)] = inst_117885);


cljs.core.async.impl.ioc_helpers.process_exception(state_117889__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117890 === (20))){
var inst_117877 = (state_117889[(2)]);
var inst_117878 = [cljs.core.cst$kw$fnstr];
var inst_117879 = [fn_str];
var inst_117880 = cljs.core.PersistentHashMap.fromArrays(inst_117878,inst_117879);
var inst_117881 = cljs.core.with_meta(inst_117877,inst_117880);
var state_117889__$1 = state_117889;
var statearr_117892_117922 = state_117889__$1;
(statearr_117892_117922[(2)] = inst_117881);


cljs.core.async.impl.ioc_helpers.process_exception(state_117889__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117890 === (1))){
var state_117889__$1 = state_117889;
var statearr_117893_117923 = state_117889__$1;
(statearr_117893_117923[(2)] = null);

(statearr_117893_117923[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117890 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_117889,(3),Error,null,(2));
var inst_117822 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fn_str,"true");
var inst_117823 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fn_str,"false");
var inst_117824 = ((inst_117822) || (inst_117823));
var state_117889__$1 = state_117889;
if(cljs.core.truth_(inst_117824)){
var statearr_117894_117924 = state_117889__$1;
(statearr_117894_117924[(1)] = (5));

} else {
var statearr_117895_117925 = state_117889__$1;
(statearr_117895_117925[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117890 === (15))){
var inst_117869 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"functionDec");
var state_117889__$1 = state_117889;
var statearr_117896_117926 = state_117889__$1;
(statearr_117896_117926[(2)] = inst_117869);

(statearr_117896_117926[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117890 === (13))){
var inst_117849 = (state_117889[(2)]);
var inst_117850 = cljs.tools.reader.edn.read_string.cljs$core$IFn$_invoke$arity$1(fn_str);
var inst_117851 = fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_117850,type,params);
var state_117889__$1 = (function (){var statearr_117897 = state_117889;
(statearr_117897[(7)] = inst_117849);

return statearr_117897;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_117889__$1,(14),inst_117851);
} else {
if((state_val_117890 === (6))){
var state_117889__$1 = state_117889;
var statearr_117898_117927 = state_117889__$1;
(statearr_117898_117927[(2)] = null);

(statearr_117898_117927[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117890 === (17))){
var inst_117872 = (state_117889[(2)]);
var state_117889__$1 = state_117889;
if(cljs.core.truth_(inst_117872)){
var statearr_117899_117928 = state_117889__$1;
(statearr_117899_117928[(1)] = (18));

} else {
var statearr_117900_117929 = state_117889__$1;
(statearr_117900_117929[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117890 === (3))){
var inst_117818 = (state_117889[(2)]);
var state_117889__$1 = state_117889;
var statearr_117901_117930 = state_117889__$1;
(statearr_117901_117930[(2)] = inst_117818);


cljs.core.async.impl.ioc_helpers.process_exception(state_117889__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117890 === (12))){
var inst_117843 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_117844 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_117845 = cljs.core.PersistentHashMap.fromArrays(inst_117843,inst_117844);
var inst_117846 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Bad function",inst_117845);
var inst_117847 = (function(){throw inst_117846})();
var state_117889__$1 = state_117889;
var statearr_117902_117931 = state_117889__$1;
(statearr_117902_117931[(2)] = inst_117847);

(statearr_117902_117931[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117890 === (2))){
var inst_117887 = (state_117889[(2)]);
var state_117889__$1 = state_117889;
return cljs.core.async.impl.ioc_helpers.return_chan(state_117889__$1,inst_117887);
} else {
if((state_val_117890 === (19))){
var inst_117867 = (state_117889[(8)]);
var inst_117875 = cljs.core.eval(inst_117867);
var state_117889__$1 = state_117889;
var statearr_117903_117932 = state_117889__$1;
(statearr_117903_117932[(2)] = inst_117875);

(statearr_117903_117932[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117890 === (11))){
var state_117889__$1 = state_117889;
var statearr_117904_117933 = state_117889__$1;
(statearr_117904_117933[(2)] = null);

(statearr_117904_117933[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117890 === (9))){
var inst_117829 = (state_117889[(2)]);
var inst_117830 = (function(){throw inst_117829})();
var inst_117831 = ["Error parsing function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_str)].join('');
var inst_117832 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_117833 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_117834 = cljs.core.PersistentHashMap.fromArrays(inst_117832,inst_117833);
var inst_117835 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_117831,inst_117834);
var inst_117836 = (function(){throw inst_117835})();
var state_117889__$1 = (function (){var statearr_117905 = state_117889;
(statearr_117905[(9)] = inst_117830);

return statearr_117905;
})();
var statearr_117906_117934 = state_117889__$1;
(statearr_117906_117934[(2)] = inst_117836);


cljs.core.async.impl.ioc_helpers.process_exception(state_117889__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117890 === (5))){
var inst_117826 = (function (){return ((function (state_val_117890,c__99059__auto__){
return (function (n){
return cljs.tools.reader.edn.read_string.cljs$core$IFn$_invoke$arity$1(fn_str);
});
;})(state_val_117890,c__99059__auto__))
})();
var inst_117827 = fluree.db.dbfunctions.core.true_or_false = inst_117826;
var state_117889__$1 = state_117889;
var statearr_117907_117935 = state_117889__$1;
(statearr_117907_117935[(2)] = inst_117827);

(statearr_117907_117935[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117890 === (14))){
var inst_117853 = (state_117889[(2)]);
var inst_117854 = fluree.db.util.async.throw_err(inst_117853);
var inst_117855 = cljs.core.cst$sym$cljs$core_SLASH_fn;
var inst_117856 = (new cljs.core.List(null,inst_117855,null,(1),null));
var inst_117857 = cljs.core.cst$sym$_QMARK_ctx;
var inst_117858 = (new cljs.core.List(null,inst_117857,null,(1),null));
var inst_117859 = cljs.core.concat.cljs$core$IFn$_invoke$arity$1(inst_117858);
var inst_117860 = cljs.core.seq(inst_117859);
var inst_117861 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(inst_117860);
var inst_117862 = cljs.core.vec(inst_117861);
var inst_117863 = (new cljs.core.List(null,inst_117862,null,(1),null));
var inst_117864 = (new cljs.core.List(null,inst_117854,null,(1),null));
var inst_117865 = cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(inst_117856,inst_117863,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_117864], 0));
var inst_117866 = cljs.core.seq(inst_117865);
var inst_117867 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(inst_117866);
var state_117889__$1 = (function (){var statearr_117908 = state_117889;
(statearr_117908[(8)] = inst_117867);

return statearr_117908;
})();
if(cljs.core.truth_(params)){
var statearr_117909_117936 = state_117889__$1;
(statearr_117909_117936[(1)] = (15));

} else {
var statearr_117910_117937 = state_117889__$1;
(statearr_117910_117937[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117890 === (16))){
var state_117889__$1 = state_117889;
var statearr_117911_117938 = state_117889__$1;
(statearr_117911_117938[(2)] = params);

(statearr_117911_117938[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117890 === (10))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_117889,(9),java.lang.Exception,null,(8));
var inst_117840 = cljs.core.re_matches(/(^\(.+\)$)/,fn_str);
var state_117889__$1 = state_117889;
if(cljs.core.truth_(inst_117840)){
var statearr_117912_117939 = state_117889__$1;
(statearr_117912_117939[(1)] = (11));

} else {
var statearr_117913_117940 = state_117889__$1;
(statearr_117913_117940[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117890 === (18))){
var inst_117867 = (state_117889[(8)]);
var state_117889__$1 = state_117889;
var statearr_117914_117941 = state_117889__$1;
(statearr_117914_117941[(2)] = inst_117867);

(statearr_117914_117941[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117890 === (8))){
var inst_117883 = (state_117889[(2)]);
var state_117889__$1 = state_117889;
var statearr_117915_117942 = state_117889__$1;
(statearr_117915_117942[(2)] = inst_117883);

(statearr_117915_117942[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$core$state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__99037__auto____0 = (function (){
var statearr_117916 = [null,null,null,null,null,null,null,null,null,null];
(statearr_117916[(0)] = fluree$db$dbfunctions$core$state_machine__99037__auto__);

(statearr_117916[(1)] = (1));

return statearr_117916;
});
var fluree$db$dbfunctions$core$state_machine__99037__auto____1 = (function (state_117889){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_117889);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e117917){if((e117917 instanceof Object)){
var ex__99040__auto__ = e117917;
var statearr_117918_117943 = state_117889;
(statearr_117918_117943[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_117889);

return cljs.core.cst$kw$recur;
} else {
throw e117917;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__117944 = state_117889;
state_117889 = G__117944;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__99037__auto__ = function(state_117889){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__99037__auto____1.call(this,state_117889);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__99037__auto____0;
fluree$db$dbfunctions$core$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__99037__auto____1;
return fluree$db$dbfunctions$core$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_117919 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_117919[(6)] = c__99059__auto__);

return statearr_117919;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

fluree.db.dbfunctions.core.parse_fn.cljs$lang$maxFixedArity = 4;

/**
 * Executes a transaction function
 */
fluree.db.dbfunctions.core.execute_tx_fn = (function fluree$db$dbfunctions$core$execute_tx_fn(db,auth_id,credits,s,p,o,fuel,block_instant){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_117969){
var state_val_117970 = (state_117969[(1)]);
if((state_val_117970 === (7))){
var inst_117957 = (state_117969[(7)]);
var state_117969__$1 = state_117969;
var statearr_117971_117984 = state_117969__$1;
(statearr_117971_117984[(2)] = inst_117957);

(statearr_117971_117984[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117970 === (1))){
var state_117969__$1 = state_117969;
var statearr_117972_117985 = state_117969__$1;
(statearr_117972_117985[(2)] = null);

(statearr_117972_117985[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117970 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_117969,(3),Error,null,(2));
var inst_117949 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(o,(1));
var inst_117950 = [cljs.core.cst$kw$db,cljs.core.cst$kw$instant,cljs.core.cst$kw$sid,cljs.core.cst$kw$pid,cljs.core.cst$kw$auth_id,cljs.core.cst$kw$state];
var inst_117951 = [db,block_instant,s,p,auth_id,fuel];
var inst_117952 = cljs.core.PersistentHashMap.fromArrays(inst_117950,inst_117951);
var inst_117953 = fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4(db,inst_117949,"txn",null);
var state_117969__$1 = (function (){var statearr_117973 = state_117969;
(statearr_117973[(8)] = inst_117952);

return statearr_117973;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_117969__$1,(5),inst_117953);
} else {
if((state_val_117970 === (6))){
var inst_117957 = (state_117969[(7)]);
var state_117969__$1 = state_117969;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_117969__$1,(9),inst_117957);
} else {
if((state_val_117970 === (3))){
var inst_117945 = (state_117969[(2)]);
var state_117969__$1 = state_117969;
var statearr_117974_117986 = state_117969__$1;
(statearr_117974_117986[(2)] = inst_117945);


cljs.core.async.impl.ioc_helpers.process_exception(state_117969__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117970 === (2))){
var inst_117967 = (state_117969[(2)]);
var state_117969__$1 = state_117969;
return cljs.core.async.impl.ioc_helpers.return_chan(state_117969__$1,inst_117967);
} else {
if((state_val_117970 === (9))){
var inst_117961 = (state_117969[(2)]);
var inst_117962 = fluree.db.util.async.throw_err(inst_117961);
var state_117969__$1 = state_117969;
var statearr_117975_117987 = state_117969__$1;
(statearr_117975_117987[(2)] = inst_117962);

(statearr_117975_117987[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117970 === (5))){
var inst_117957 = (state_117969[(7)]);
var inst_117952 = (state_117969[(8)]);
var inst_117955 = (state_117969[(2)]);
var inst_117956 = fluree.db.util.async.throw_err(inst_117955);
var inst_117957__$1 = (inst_117956.cljs$core$IFn$_invoke$arity$1 ? inst_117956.cljs$core$IFn$_invoke$arity$1(inst_117952) : inst_117956.call(null,inst_117952));
var inst_117958 = fluree.db.util.async.channel_QMARK_(inst_117957__$1);
var state_117969__$1 = (function (){var statearr_117976 = state_117969;
(statearr_117976[(7)] = inst_117957__$1);

return statearr_117976;
})();
if(inst_117958){
var statearr_117977_117988 = state_117969__$1;
(statearr_117977_117988[(1)] = (6));

} else {
var statearr_117978_117989 = state_117969__$1;
(statearr_117978_117989[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117970 === (8))){
var inst_117965 = (state_117969[(2)]);
var state_117969__$1 = state_117969;
var statearr_117979_117990 = state_117969__$1;
(statearr_117979_117990[(2)] = inst_117965);


cljs.core.async.impl.ioc_helpers.process_exception(state_117969__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__99037__auto____0 = (function (){
var statearr_117980 = [null,null,null,null,null,null,null,null,null];
(statearr_117980[(0)] = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__99037__auto__);

(statearr_117980[(1)] = (1));

return statearr_117980;
});
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__99037__auto____1 = (function (state_117969){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_117969);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e117981){if((e117981 instanceof Object)){
var ex__99040__auto__ = e117981;
var statearr_117982_117991 = state_117969;
(statearr_117982_117991[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_117969);

return cljs.core.cst$kw$recur;
} else {
throw e117981;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__117992 = state_117969;
state_117969 = G__117992;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__99037__auto__ = function(state_117969){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__99037__auto____1.call(this,state_117969);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__99037__auto____0;
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__99037__auto____1;
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_117983 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_117983[(6)] = c__99059__auto__);

return statearr_117983;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

//# sourceMappingURL=core.js.map?rel=1593118621680
