// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.api.query');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.block');
goog.require('fluree.db.session');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.log');

/**
 * Returns keyword of query type by inspecting flureeQL query.
 * 
 *   Query types are:
 *  :standard - basic or analytical query
 *  :multi - multi-query
 *  :block - block query
 *  :history - history query
 */
fluree.db.api.query.query_type = (function fluree$db$api$query$query_type(flureeQL){
if(cljs.core.truth_(cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(flureeQL))){
return cljs.core.cst$kw$standard;
} else {
if(cljs.core.truth_(cljs.core.cst$kw$selectOne.cljs$core$IFn$_invoke$arity$1(flureeQL))){
return cljs.core.cst$kw$standard;
} else {
if(cljs.core.truth_(cljs.core.cst$kw$history.cljs$core$IFn$_invoke$arity$1(flureeQL))){
return cljs.core.cst$kw$history;
} else {
if(cljs.core.truth_(cljs.core.cst$kw$selectDistinct.cljs$core$IFn$_invoke$arity$1(flureeQL))){
return cljs.core.cst$kw$standard;
} else {
if(cljs.core.truth_(cljs.core.cst$kw$selectReduced.cljs$core$IFn$_invoke$arity$1(flureeQL))){
return cljs.core.cst$kw$standard;
} else {
if(cljs.core.truth_(cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(flureeQL))){
return cljs.core.cst$kw$block;
} else {
return cljs.core.cst$kw$multi;

}
}
}
}
}
}
});
fluree.db.api.query.db_ident_QMARK_ = (function fluree$db$api$query$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.api.query.isolate_ledger_id = (function fluree$db$api$query$isolate_ledger_id(dbid){
return cljs.core.re_find(/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Returns a queryable database as a promise channel from the connection for the specified ledger.
 */
fluree.db.api.query.db = (function fluree$db$api$query$db(var_args){
var G__119094 = arguments.length;
switch (G__119094) {
case 2:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
});

fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__99059__auto___119264 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto___119264,pc){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto___119264,pc){
return (function (state_119197){
var state_val_119198 = (state_119197[(1)]);
if((state_val_119198 === (7))){
var state_119197__$1 = state_119197;
var statearr_119199_119265 = state_119197__$1;
(statearr_119199_119265[(2)] = false);

(statearr_119199_119265[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119198 === (20))){
var inst_119127 = (state_119197[(7)]);
var inst_119153 = (state_119197[(2)]);
var state_119197__$1 = (function (){var statearr_119200 = state_119197;
(statearr_119200[(8)] = inst_119153);

return statearr_119200;
})();
if(cljs.core.truth_(inst_119127)){
var statearr_119201_119266 = state_119197__$1;
(statearr_119201_119266[(1)] = (25));

} else {
var statearr_119202_119267 = state_119197__$1;
(statearr_119202_119267[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119198 === (27))){
var inst_119165 = (state_119197[(9)]);
var inst_119165__$1 = (state_119197[(2)]);
var state_119197__$1 = (function (){var statearr_119203 = state_119197;
(statearr_119203[(9)] = inst_119165__$1);

return statearr_119203;
})();
if(cljs.core.truth_(inst_119165__$1)){
var statearr_119204_119268 = state_119197__$1;
(statearr_119204_119268[(1)] = (32));

} else {
var statearr_119205_119269 = state_119197__$1;
(statearr_119205_119269[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119198 === (1))){
var state_119197__$1 = state_119197;
var statearr_119206_119270 = state_119197__$1;
(statearr_119206_119270[(2)] = null);

(statearr_119206_119270[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119198 === (24))){
var inst_119150 = (state_119197[(2)]);
var state_119197__$1 = state_119197;
var statearr_119207_119271 = state_119197__$1;
(statearr_119207_119271[(2)] = inst_119150);

(statearr_119207_119271[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119198 === (39))){
var inst_119129 = (state_119197[(10)]);
var inst_119179 = (state_119197[(11)]);
var inst_119181 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_119179,cljs.core.cst$kw$auth,inst_119129);
var state_119197__$1 = state_119197;
var statearr_119208_119272 = state_119197__$1;
(statearr_119208_119272[(2)] = inst_119181);

(statearr_119208_119272[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119198 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_119197,(3),java.lang.Exception,null,(2));
var inst_119102 = fluree.db.session.db(conn,ledger,null);
var state_119197__$1 = state_119197;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_119197__$1,(5),inst_119102);
} else {
if((state_val_119198 === (15))){
var inst_119129 = (state_119197[(10)]);
var inst_119132 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_119129);
var state_119197__$1 = state_119197;
var statearr_119209_119273 = state_119197__$1;
(statearr_119209_119273[(2)] = inst_119132);

(statearr_119209_119273[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119198 === (21))){
var inst_119140 = (state_119197[(12)]);
var inst_119139 = (state_119197[(2)]);
var inst_119140__$1 = fluree.db.util.async.throw_err(inst_119139);
var state_119197__$1 = (function (){var statearr_119210 = state_119197;
(statearr_119210[(12)] = inst_119140__$1);

return statearr_119210;
})();
if(cljs.core.truth_(inst_119140__$1)){
var statearr_119211_119274 = state_119197__$1;
(statearr_119211_119274[(1)] = (22));

} else {
var statearr_119212_119275 = state_119197__$1;
(statearr_119212_119275[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119198 === (31))){
var inst_119159 = (state_119197[(2)]);
var inst_119160 = fluree.db.util.async.throw_err(inst_119159);
var state_119197__$1 = state_119197;
var statearr_119213_119276 = state_119197__$1;
(statearr_119213_119276[(2)] = inst_119160);

(statearr_119213_119276[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119198 === (32))){
var inst_119165 = (state_119197[(9)]);
var inst_119105 = (state_119197[(13)]);
var inst_119167 = fluree.db.permissions.permission_map(inst_119105,inst_119165,cljs.core.cst$kw$query);
var state_119197__$1 = state_119197;
var statearr_119214_119277 = state_119197__$1;
(statearr_119214_119277[(2)] = inst_119167);

(statearr_119214_119277[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119198 === (40))){
var inst_119179 = (state_119197[(11)]);
var state_119197__$1 = state_119197;
var statearr_119215_119278 = state_119197__$1;
(statearr_119215_119278[(2)] = inst_119179);

(statearr_119215_119278[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119198 === (33))){
var state_119197__$1 = state_119197;
var statearr_119216_119279 = state_119197__$1;
(statearr_119216_119279[(2)] = null);

(statearr_119216_119279[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119198 === (13))){
var state_119197__$1 = state_119197;
var statearr_119217_119280 = state_119197__$1;
(statearr_119217_119280[(2)] = opts);

(statearr_119217_119280[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119198 === (22))){
var inst_119140 = (state_119197[(12)]);
var state_119197__$1 = state_119197;
var statearr_119218_119281 = state_119197__$1;
(statearr_119218_119281[(2)] = inst_119140);

(statearr_119218_119281[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119198 === (36))){
var inst_119105 = (state_119197[(13)]);
var state_119197__$1 = state_119197;
var statearr_119219_119282 = state_119197__$1;
(statearr_119219_119282[(2)] = inst_119105);

(statearr_119219_119282[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119198 === (41))){
var inst_119165 = (state_119197[(9)]);
var inst_119184 = (state_119197[(2)]);
var state_119197__$1 = (function (){var statearr_119220 = state_119197;
(statearr_119220[(14)] = inst_119184);

return statearr_119220;
})();
if(cljs.core.truth_(inst_119165)){
var statearr_119221_119283 = state_119197__$1;
(statearr_119221_119283[(1)] = (42));

} else {
var statearr_119222_119284 = state_119197__$1;
(statearr_119222_119284[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119198 === (43))){
var inst_119184 = (state_119197[(14)]);
var state_119197__$1 = state_119197;
var statearr_119223_119285 = state_119197__$1;
(statearr_119223_119285[(2)] = inst_119184);

(statearr_119223_119285[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119198 === (29))){
var state_119197__$1 = state_119197;
var statearr_119224_119286 = state_119197__$1;
(statearr_119224_119286[(2)] = null);

(statearr_119224_119286[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119198 === (44))){
var inst_119192 = (state_119197[(2)]);
var inst_119193 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_119192);
var state_119197__$1 = state_119197;
var statearr_119225_119287 = state_119197__$1;
(statearr_119225_119287[(2)] = inst_119193);


cljs.core.async.impl.ioc_helpers.process_exception(state_119197__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_119198 === (6))){
var inst_119110 = opts.cljs$lang$protocol_mask$partition0$;
var inst_119111 = (inst_119110 & (64));
var inst_119112 = opts.cljs$core$ISeq$;
var inst_119113 = (cljs.core.PROTOCOL_SENTINEL === inst_119112);
var inst_119114 = ((inst_119111) || (inst_119113));
var state_119197__$1 = state_119197;
if(cljs.core.truth_(inst_119114)){
var statearr_119226_119288 = state_119197__$1;
(statearr_119226_119288[(1)] = (9));

} else {
var statearr_119227_119289 = state_119197__$1;
(statearr_119227_119289[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119198 === (28))){
var inst_119105 = (state_119197[(13)]);
var inst_119153 = (state_119197[(8)]);
var inst_119157 = fluree.db.auth.roles(inst_119105,inst_119153);
var state_119197__$1 = state_119197;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_119197__$1,(31),inst_119157);
} else {
if((state_val_119198 === (25))){
var inst_119127 = (state_119197[(7)]);
var state_119197__$1 = state_119197;
var statearr_119228_119290 = state_119197__$1;
(statearr_119228_119290[(2)] = inst_119127);

(statearr_119228_119290[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119198 === (34))){
var inst_119130 = (state_119197[(15)]);
var inst_119170 = (state_119197[(2)]);
var state_119197__$1 = (function (){var statearr_119229 = state_119197;
(statearr_119229[(16)] = inst_119170);

return statearr_119229;
})();
if(cljs.core.truth_(inst_119130)){
var statearr_119230_119291 = state_119197__$1;
(statearr_119230_119291[(1)] = (35));

} else {
var statearr_119231_119292 = state_119197__$1;
(statearr_119231_119292[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119198 === (17))){
var inst_119135 = (state_119197[(2)]);
var state_119197__$1 = state_119197;
if(cljs.core.truth_(inst_119135)){
var statearr_119232_119293 = state_119197__$1;
(statearr_119232_119293[(1)] = (18));

} else {
var statearr_119233_119294 = state_119197__$1;
(statearr_119233_119294[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119198 === (3))){
var inst_119095 = (state_119197[(2)]);
var inst_119096 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_119095);
var inst_119097 = cljs.core.async.close_BANG_(pc);
var state_119197__$1 = (function (){var statearr_119234 = state_119197;
(statearr_119234[(17)] = inst_119096);

return statearr_119234;
})();
var statearr_119235_119295 = state_119197__$1;
(statearr_119235_119295[(2)] = inst_119097);


cljs.core.async.impl.ioc_helpers.process_exception(state_119197__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_119198 === (12))){
var inst_119123 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,opts);
var state_119197__$1 = state_119197;
var statearr_119236_119296 = state_119197__$1;
(statearr_119236_119296[(2)] = inst_119123);

(statearr_119236_119296[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119198 === (2))){
var inst_119195 = (state_119197[(2)]);
var state_119197__$1 = state_119197;
return cljs.core.async.impl.ioc_helpers.return_chan(state_119197__$1,inst_119195);
} else {
if((state_val_119198 === (23))){
var inst_119129 = (state_119197[(10)]);
var inst_119143 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_119129)," unknown."].join('');
var inst_119144 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_119145 = [(401),cljs.core.cst$kw$db_SLASH_invalid_DASH_auth];
var inst_119146 = cljs.core.PersistentHashMap.fromArrays(inst_119144,inst_119145);
var inst_119147 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_119143,inst_119146);
var inst_119148 = (function(){throw inst_119147})();
var state_119197__$1 = state_119197;
var statearr_119237_119297 = state_119197__$1;
(statearr_119237_119297[(2)] = inst_119148);

(statearr_119237_119297[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119198 === (35))){
var inst_119105 = (state_119197[(13)]);
var inst_119172 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(opts);
var inst_119173 = fluree.db.time_travel.as_of_block(inst_119105,inst_119172);
var state_119197__$1 = state_119197;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_119197__$1,(38),inst_119173);
} else {
if((state_val_119198 === (19))){
var state_119197__$1 = state_119197;
var statearr_119238_119298 = state_119197__$1;
(statearr_119238_119298[(2)] = null);

(statearr_119238_119298[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119198 === (11))){
var inst_119118 = (state_119197[(2)]);
var state_119197__$1 = state_119197;
var statearr_119239_119299 = state_119197__$1;
(statearr_119239_119299[(2)] = inst_119118);

(statearr_119239_119299[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119198 === (9))){
var state_119197__$1 = state_119197;
var statearr_119240_119300 = state_119197__$1;
(statearr_119240_119300[(2)] = true);

(statearr_119240_119300[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119198 === (5))){
var inst_119104 = (state_119197[(2)]);
var inst_119105 = fluree.db.util.async.throw_err(inst_119104);
var inst_119107 = (opts == null);
var inst_119108 = cljs.core.not(inst_119107);
var state_119197__$1 = (function (){var statearr_119241 = state_119197;
(statearr_119241[(13)] = inst_119105);

return statearr_119241;
})();
if(inst_119108){
var statearr_119242_119301 = state_119197__$1;
(statearr_119242_119301[(1)] = (6));

} else {
var statearr_119243_119302 = state_119197__$1;
(statearr_119243_119302[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119198 === (14))){
var inst_119129 = (state_119197[(10)]);
var inst_119126 = (state_119197[(2)]);
var inst_119127 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_119126,cljs.core.cst$kw$roles);
var inst_119128 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_119126,cljs.core.cst$kw$user);
var inst_119129__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_119126,cljs.core.cst$kw$auth);
var inst_119130 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_119126,cljs.core.cst$kw$block);
var state_119197__$1 = (function (){var statearr_119244 = state_119197;
(statearr_119244[(15)] = inst_119130);

(statearr_119244[(10)] = inst_119129__$1);

(statearr_119244[(7)] = inst_119127);

(statearr_119244[(18)] = inst_119128);

return statearr_119244;
})();
if(cljs.core.truth_(inst_119129__$1)){
var statearr_119245_119303 = state_119197__$1;
(statearr_119245_119303[(1)] = (15));

} else {
var statearr_119246_119304 = state_119197__$1;
(statearr_119246_119304[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119198 === (45))){
var inst_119184 = (state_119197[(14)]);
var inst_119187 = (state_119197[(2)]);
var inst_119188 = fluree.db.util.async.throw_err(inst_119187);
var inst_119189 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_119184,cljs.core.cst$kw$permissions,inst_119188);
var state_119197__$1 = state_119197;
var statearr_119247_119305 = state_119197__$1;
(statearr_119247_119305[(2)] = inst_119189);

(statearr_119247_119305[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119198 === (26))){
var inst_119153 = (state_119197[(8)]);
var state_119197__$1 = state_119197;
if(cljs.core.truth_(inst_119153)){
var statearr_119248_119306 = state_119197__$1;
(statearr_119248_119306[(1)] = (28));

} else {
var statearr_119249_119307 = state_119197__$1;
(statearr_119249_119307[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119198 === (16))){
var inst_119129 = (state_119197[(10)]);
var state_119197__$1 = state_119197;
var statearr_119250_119308 = state_119197__$1;
(statearr_119250_119308[(2)] = inst_119129);

(statearr_119250_119308[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119198 === (38))){
var inst_119175 = (state_119197[(2)]);
var inst_119176 = fluree.db.util.async.throw_err(inst_119175);
var state_119197__$1 = state_119197;
var statearr_119251_119309 = state_119197__$1;
(statearr_119251_119309[(2)] = inst_119176);

(statearr_119251_119309[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119198 === (30))){
var inst_119163 = (state_119197[(2)]);
var state_119197__$1 = state_119197;
var statearr_119252_119310 = state_119197__$1;
(statearr_119252_119310[(2)] = inst_119163);

(statearr_119252_119310[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119198 === (10))){
var state_119197__$1 = state_119197;
var statearr_119253_119311 = state_119197__$1;
(statearr_119253_119311[(2)] = false);

(statearr_119253_119311[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119198 === (18))){
var inst_119129 = (state_119197[(10)]);
var inst_119105 = (state_119197[(13)]);
var inst_119137 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_119105,inst_119129);
var state_119197__$1 = state_119197;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_119197__$1,(21),inst_119137);
} else {
if((state_val_119198 === (42))){
var inst_119170 = (state_119197[(16)]);
var state_119197__$1 = state_119197;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_119197__$1,(45),inst_119170);
} else {
if((state_val_119198 === (37))){
var inst_119129 = (state_119197[(10)]);
var inst_119179 = (state_119197[(2)]);
var state_119197__$1 = (function (){var statearr_119254 = state_119197;
(statearr_119254[(11)] = inst_119179);

return statearr_119254;
})();
if(cljs.core.truth_(inst_119129)){
var statearr_119255_119312 = state_119197__$1;
(statearr_119255_119312[(1)] = (39));

} else {
var statearr_119256_119313 = state_119197__$1;
(statearr_119256_119313[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119198 === (8))){
var inst_119121 = (state_119197[(2)]);
var state_119197__$1 = state_119197;
if(cljs.core.truth_(inst_119121)){
var statearr_119257_119314 = state_119197__$1;
(statearr_119257_119314[(1)] = (12));

} else {
var statearr_119258_119315 = state_119197__$1;
(statearr_119258_119315[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto___119264,pc))
;
return ((function (switch__99036__auto__,c__99059__auto___119264,pc){
return (function() {
var fluree$db$api$query$state_machine__99037__auto__ = null;
var fluree$db$api$query$state_machine__99037__auto____0 = (function (){
var statearr_119259 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_119259[(0)] = fluree$db$api$query$state_machine__99037__auto__);

(statearr_119259[(1)] = (1));

return statearr_119259;
});
var fluree$db$api$query$state_machine__99037__auto____1 = (function (state_119197){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_119197);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e119260){if((e119260 instanceof Object)){
var ex__99040__auto__ = e119260;
var statearr_119261_119316 = state_119197;
(statearr_119261_119316[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_119197);

return cljs.core.cst$kw$recur;
} else {
throw e119260;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__119317 = state_119197;
state_119197 = G__119317;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$api$query$state_machine__99037__auto__ = function(state_119197){
switch(arguments.length){
case 0:
return fluree$db$api$query$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$api$query$state_machine__99037__auto____1.call(this,state_119197);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$state_machine__99037__auto____0;
fluree$db$api$query$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$state_machine__99037__auto____1;
return fluree$db$api$query$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto___119264,pc))
})();
var state__99061__auto__ = (function (){var statearr_119262 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_119262[(6)] = c__99059__auto___119264);

return statearr_119262;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto___119264,pc))
);


return pc;
});

fluree.db.api.query.db.cljs$lang$maxFixedArity = 3;

fluree.db.api.query.get_sources = (function fluree$db$api$query$get_sources(conn,network,auth,prefixes){
return cljs.core.reduce_kv((function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches(/[a-z]+/,fluree.db.util.core.keyword__GT_str(key)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Source name must be only lowercase letters. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.keyword__GT_str(key))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}

var db_ident_QMARK_ = fluree.db.api.query.db_ident_QMARK_(val);
if(db_ident_QMARK_){
var ledger = fluree.db.api.query.isolate_ledger_id(val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$auth,auth], null):cljs.core.PersistentArrayMap.EMPTY);
var db = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,db);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
fluree.db.api.query.resolve_block_range = (function fluree$db$api$query$resolve_block_range(db,query_map){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_119452){
var state_val_119453 = (state_119452[(1)]);
if((state_val_119453 === (7))){
var inst_119342 = (state_119452[(7)]);
var inst_119342__$1 = (state_119452[(2)]);
var inst_119343 = cljs.core.some(cljs.core.string_QMARK_,inst_119342__$1);
var state_119452__$1 = (function (){var statearr_119454 = state_119452;
(statearr_119454[(7)] = inst_119342__$1);

return statearr_119454;
})();
if(cljs.core.truth_(inst_119343)){
var statearr_119455_119513 = state_119452__$1;
(statearr_119455_119513[(1)] = (8));

} else {
var statearr_119456_119514 = state_119452__$1;
(statearr_119456_119514[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119453 === (20))){
var inst_119365 = (state_119452[(8)]);
var state_119452__$1 = state_119452;
var statearr_119457_119515 = state_119452__$1;
(statearr_119457_119515[(2)] = inst_119365);

(statearr_119457_119515[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119453 === (27))){
var inst_119408 = (state_119452[(2)]);
var state_119452__$1 = state_119452;
var statearr_119458_119516 = state_119452__$1;
(statearr_119458_119516[(2)] = inst_119408);

(statearr_119458_119516[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119453 === (1))){
var state_119452__$1 = state_119452;
var statearr_119459_119517 = state_119452__$1;
(statearr_119459_119517[(2)] = null);

(statearr_119459_119517[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119453 === (24))){
var inst_119411 = (state_119452[(9)]);
var inst_119412 = (state_119452[(10)]);
var inst_119410 = (state_119452[(2)]);
var inst_119411__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_119410,(0),null);
var inst_119412__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_119410,(1),null);
var inst_119413 = cljs.core.pos_int_QMARK_(inst_119411__$1);
var inst_119414 = cljs.core.pos_int_QMARK_(inst_119412__$1);
var inst_119415 = ((inst_119413) && (inst_119414));
var inst_119416 = cljs.core.not(inst_119415);
var state_119452__$1 = (function (){var statearr_119460 = state_119452;
(statearr_119460[(9)] = inst_119411__$1);

(statearr_119460[(10)] = inst_119412__$1);

return statearr_119460;
})();
if(inst_119416){
var statearr_119461_119518 = state_119452__$1;
(statearr_119461_119518[(1)] = (31));

} else {
var statearr_119462_119519 = state_119452__$1;
(statearr_119462_119519[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119453 === (39))){
var inst_119439 = (state_119452[(11)]);
var inst_119445 = (state_119452[(2)]);
var inst_119446 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_119447 = [inst_119439,inst_119445];
var inst_119448 = (new cljs.core.PersistentVector(null,2,(5),inst_119446,inst_119447,null));
var state_119452__$1 = state_119452;
var statearr_119463_119520 = state_119452__$1;
(statearr_119463_119520[(2)] = inst_119448);


cljs.core.async.impl.ioc_helpers.process_exception(state_119452__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_119453 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_119452,(3),Error,null,(2));
var inst_119331 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(query_map);
var inst_119332 = cljs.core.sequential_QMARK_(inst_119331);
var state_119452__$1 = state_119452;
if(inst_119332){
var statearr_119464_119521 = state_119452__$1;
(statearr_119464_119521[(1)] = (5));

} else {
var statearr_119465_119522 = state_119452__$1;
(statearr_119465_119522[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119453 === (15))){
var inst_119355 = (state_119452[(2)]);
var inst_119356 = fluree.db.util.async.throw_err(inst_119355);
var state_119452__$1 = state_119452;
var statearr_119466_119523 = state_119452__$1;
(statearr_119466_119523[(2)] = inst_119356);

(statearr_119466_119523[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119453 === (21))){
var inst_119384 = (state_119452[(2)]);
var state_119452__$1 = state_119452;
if(cljs.core.truth_(inst_119384)){
var statearr_119467_119524 = state_119452__$1;
(statearr_119467_119524[(1)] = (22));

} else {
var statearr_119468_119525 = state_119452__$1;
(statearr_119468_119525[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119453 === (31))){
var inst_119342 = (state_119452[(7)]);
var inst_119418 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_119342], 0));
var inst_119419 = ["Invalid block range provided: ",inst_119418].join('');
var inst_119420 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_119421 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_119422 = cljs.core.PersistentHashMap.fromArrays(inst_119420,inst_119421);
var inst_119423 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_119419,inst_119422);
var inst_119424 = (function(){throw inst_119423})();
var state_119452__$1 = state_119452;
var statearr_119469_119526 = state_119452__$1;
(statearr_119469_119526[(2)] = inst_119424);

(statearr_119469_119526[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119453 === (32))){
var state_119452__$1 = state_119452;
var statearr_119470_119527 = state_119452__$1;
(statearr_119470_119527[(2)] = null);

(statearr_119470_119527[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119453 === (33))){
var inst_119411 = (state_119452[(9)]);
var inst_119412 = (state_119452[(10)]);
var inst_119427 = (state_119452[(2)]);
var inst_119428 = (inst_119412 < inst_119411);
var state_119452__$1 = (function (){var statearr_119471 = state_119452;
(statearr_119471[(12)] = inst_119427);

return statearr_119471;
})();
if(cljs.core.truth_(inst_119428)){
var statearr_119472_119528 = state_119452__$1;
(statearr_119472_119528[(1)] = (34));

} else {
var statearr_119473_119529 = state_119452__$1;
(statearr_119473_119529[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119453 === (13))){
var state_119452__$1 = state_119452;
var statearr_119474_119530 = state_119452__$1;
(statearr_119474_119530[(2)] = null);

(statearr_119474_119530[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119453 === (22))){
var inst_119365 = (state_119452[(8)]);
var inst_119366 = (state_119452[(13)]);
var inst_119386 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_119387 = [inst_119365,inst_119366];
var inst_119388 = (new cljs.core.PersistentVector(null,2,(5),inst_119386,inst_119387,null));
var state_119452__$1 = state_119452;
var statearr_119475_119531 = state_119452__$1;
(statearr_119475_119531[(2)] = inst_119388);

(statearr_119475_119531[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119453 === (36))){
var inst_119440 = (state_119452[(14)]);
var inst_119367 = (state_119452[(15)]);
var inst_119438 = (state_119452[(2)]);
var inst_119439 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_119438,(0),null);
var inst_119440__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_119438,(1),null);
var inst_119441 = (inst_119440__$1 > inst_119367);
var state_119452__$1 = (function (){var statearr_119476 = state_119452;
(statearr_119476[(11)] = inst_119439);

(statearr_119476[(14)] = inst_119440__$1);

return statearr_119476;
})();
if(cljs.core.truth_(inst_119441)){
var statearr_119477_119532 = state_119452__$1;
(statearr_119477_119532[(1)] = (37));

} else {
var statearr_119478_119533 = state_119452__$1;
(statearr_119478_119533[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119453 === (29))){
var state_119452__$1 = state_119452;
var statearr_119479_119534 = state_119452__$1;
(statearr_119479_119534[(2)] = null);

(statearr_119479_119534[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119453 === (6))){
var inst_119336 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_119337 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(query_map);
var inst_119338 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(query_map);
var inst_119339 = [inst_119337,inst_119338];
var inst_119340 = (new cljs.core.PersistentVector(null,2,(5),inst_119336,inst_119339,null));
var state_119452__$1 = state_119452;
var statearr_119480_119535 = state_119452__$1;
(statearr_119480_119535[(2)] = inst_119340);

(statearr_119480_119535[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119453 === (28))){
var inst_119342 = (state_119452[(7)]);
var inst_119397 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_119342], 0));
var inst_119398 = ["Invalid block range provided: ",inst_119397].join('');
var inst_119399 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_119400 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_119401 = cljs.core.PersistentHashMap.fromArrays(inst_119399,inst_119400);
var inst_119402 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_119398,inst_119401);
var inst_119403 = (function(){throw inst_119402})();
var state_119452__$1 = state_119452;
var statearr_119481_119536 = state_119452__$1;
(statearr_119481_119536[(2)] = inst_119403);

(statearr_119481_119536[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119453 === (25))){
var inst_119365 = (state_119452[(8)]);
var inst_119391 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_119392 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(db);
var inst_119393 = [inst_119365,inst_119392];
var inst_119394 = (new cljs.core.PersistentVector(null,2,(5),inst_119391,inst_119393,null));
var state_119452__$1 = state_119452;
var statearr_119482_119537 = state_119452__$1;
(statearr_119482_119537[(2)] = inst_119394);

(statearr_119482_119537[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119453 === (34))){
var inst_119411 = (state_119452[(9)]);
var inst_119412 = (state_119452[(10)]);
var inst_119430 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_119431 = [inst_119412,inst_119411];
var inst_119432 = (new cljs.core.PersistentVector(null,2,(5),inst_119430,inst_119431,null));
var state_119452__$1 = state_119452;
var statearr_119483_119538 = state_119452__$1;
(statearr_119483_119538[(2)] = inst_119432);

(statearr_119483_119538[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119453 === (17))){
var state_119452__$1 = state_119452;
var statearr_119484_119539 = state_119452__$1;
(statearr_119484_119539[(2)] = null);

(statearr_119484_119539[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119453 === (3))){
var inst_119318 = (state_119452[(2)]);
var state_119452__$1 = state_119452;
var statearr_119485_119540 = state_119452__$1;
(statearr_119485_119540[(2)] = inst_119318);


cljs.core.async.impl.ioc_helpers.process_exception(state_119452__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_119453 === (12))){
var inst_119351 = (state_119452[(16)]);
var inst_119353 = fluree.db.time_travel.block_to_int_format(db,inst_119351);
var state_119452__$1 = state_119452;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_119452__$1,(15),inst_119353);
} else {
if((state_val_119453 === (2))){
var inst_119450 = (state_119452[(2)]);
var state_119452__$1 = state_119452;
return cljs.core.async.impl.ioc_helpers.return_chan(state_119452__$1,inst_119450);
} else {
if((state_val_119453 === (23))){
var inst_119365 = (state_119452[(8)]);
var state_119452__$1 = state_119452;
if(cljs.core.truth_(inst_119365)){
var statearr_119486_119541 = state_119452__$1;
(statearr_119486_119541[(1)] = (25));

} else {
var statearr_119487_119542 = state_119452__$1;
(statearr_119487_119542[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119453 === (35))){
var inst_119411 = (state_119452[(9)]);
var inst_119412 = (state_119452[(10)]);
var inst_119434 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_119435 = [inst_119411,inst_119412];
var inst_119436 = (new cljs.core.PersistentVector(null,2,(5),inst_119434,inst_119435,null));
var state_119452__$1 = state_119452;
var statearr_119488_119543 = state_119452__$1;
(statearr_119488_119543[(2)] = inst_119436);

(statearr_119488_119543[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119453 === (19))){
var inst_119366 = (state_119452[(13)]);
var state_119452__$1 = state_119452;
var statearr_119489_119544 = state_119452__$1;
(statearr_119489_119544[(2)] = inst_119366);

(statearr_119489_119544[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119453 === (11))){
var inst_119351 = (state_119452[(16)]);
var inst_119342 = (state_119452[(7)]);
var inst_119349 = (state_119452[(2)]);
var inst_119350 = fluree.db.util.async.throw_err(inst_119349);
var inst_119351__$1 = cljs.core.second(inst_119342);
var state_119452__$1 = (function (){var statearr_119490 = state_119452;
(statearr_119490[(17)] = inst_119350);

(statearr_119490[(16)] = inst_119351__$1);

return statearr_119490;
})();
if(cljs.core.truth_(inst_119351__$1)){
var statearr_119491_119545 = state_119452__$1;
(statearr_119491_119545[(1)] = (12));

} else {
var statearr_119492_119546 = state_119452__$1;
(statearr_119492_119546[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119453 === (9))){
var inst_119342 = (state_119452[(7)]);
var state_119452__$1 = state_119452;
var statearr_119493_119547 = state_119452__$1;
(statearr_119493_119547[(2)] = inst_119342);

(statearr_119493_119547[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119453 === (5))){
var inst_119334 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(query_map);
var state_119452__$1 = state_119452;
var statearr_119494_119548 = state_119452__$1;
(statearr_119494_119548[(2)] = inst_119334);

(statearr_119494_119548[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119453 === (14))){
var inst_119345 = (state_119452[(18)]);
var inst_119350 = (state_119452[(17)]);
var inst_119359 = (state_119452[(2)]);
var inst_119360 = [inst_119350,inst_119359];
var inst_119361 = (new cljs.core.PersistentVector(null,2,(5),inst_119345,inst_119360,null));
var state_119452__$1 = state_119452;
var statearr_119495_119549 = state_119452__$1;
(statearr_119495_119549[(2)] = inst_119361);

(statearr_119495_119549[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119453 === (26))){
var state_119452__$1 = state_119452;
var statearr_119496_119550 = state_119452__$1;
(statearr_119496_119550[(1)] = (28));



return cljs.core.cst$kw$recur;
} else {
if((state_val_119453 === (16))){
var inst_119365 = (state_119452[(8)]);
var inst_119367 = (state_119452[(15)]);
var inst_119370 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_119365], 0));
var inst_119371 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_119367], 0));
var inst_119372 = ["Start block is out of range for this ledger. Start block provided: ",inst_119370,". Database block: ",inst_119371].join('');
var inst_119373 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_119374 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_119375 = cljs.core.PersistentHashMap.fromArrays(inst_119373,inst_119374);
var inst_119376 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_119372,inst_119375);
var inst_119377 = (function(){throw inst_119376})();
var state_119452__$1 = state_119452;
var statearr_119498_119551 = state_119452__$1;
(statearr_119498_119551[(2)] = inst_119377);

(statearr_119498_119551[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119453 === (38))){
var inst_119440 = (state_119452[(14)]);
var state_119452__$1 = state_119452;
var statearr_119499_119552 = state_119452__$1;
(statearr_119499_119552[(2)] = inst_119440);

(statearr_119499_119552[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119453 === (30))){
var inst_119406 = (state_119452[(2)]);
var state_119452__$1 = state_119452;
var statearr_119500_119553 = state_119452__$1;
(statearr_119500_119553[(2)] = inst_119406);

(statearr_119500_119553[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119453 === (10))){
var inst_119365 = (state_119452[(8)]);
var inst_119367 = (state_119452[(15)]);
var inst_119364 = (state_119452[(2)]);
var inst_119365__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_119364,(0),null);
var inst_119366 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_119364,(1),null);
var inst_119367__$1 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(db);
var inst_119368 = (inst_119365__$1 > inst_119367__$1);
var state_119452__$1 = (function (){var statearr_119501 = state_119452;
(statearr_119501[(8)] = inst_119365__$1);

(statearr_119501[(13)] = inst_119366);

(statearr_119501[(15)] = inst_119367__$1);

return statearr_119501;
})();
if(cljs.core.truth_(inst_119368)){
var statearr_119502_119554 = state_119452__$1;
(statearr_119502_119554[(1)] = (16));

} else {
var statearr_119503_119555 = state_119452__$1;
(statearr_119503_119555[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119453 === (18))){
var inst_119365 = (state_119452[(8)]);
var inst_119380 = (state_119452[(2)]);
var state_119452__$1 = (function (){var statearr_119504 = state_119452;
(statearr_119504[(19)] = inst_119380);

return statearr_119504;
})();
if(cljs.core.truth_(inst_119365)){
var statearr_119505_119556 = state_119452__$1;
(statearr_119505_119556[(1)] = (19));

} else {
var statearr_119506_119557 = state_119452__$1;
(statearr_119506_119557[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119453 === (37))){
var inst_119367 = (state_119452[(15)]);
var state_119452__$1 = state_119452;
var statearr_119507_119558 = state_119452__$1;
(statearr_119507_119558[(2)] = inst_119367);

(statearr_119507_119558[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119453 === (8))){
var inst_119342 = (state_119452[(7)]);
var inst_119345 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_119346 = cljs.core.first(inst_119342);
var inst_119347 = fluree.db.time_travel.block_to_int_format(db,inst_119346);
var state_119452__$1 = (function (){var statearr_119508 = state_119452;
(statearr_119508[(18)] = inst_119345);

return statearr_119508;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_119452__$1,(11),inst_119347);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$api$query$resolve_block_range_$_state_machine__99037__auto__ = null;
var fluree$db$api$query$resolve_block_range_$_state_machine__99037__auto____0 = (function (){
var statearr_119509 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_119509[(0)] = fluree$db$api$query$resolve_block_range_$_state_machine__99037__auto__);

(statearr_119509[(1)] = (1));

return statearr_119509;
});
var fluree$db$api$query$resolve_block_range_$_state_machine__99037__auto____1 = (function (state_119452){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_119452);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e119510){if((e119510 instanceof Object)){
var ex__99040__auto__ = e119510;
var statearr_119511_119559 = state_119452;
(statearr_119511_119559[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_119452);

return cljs.core.cst$kw$recur;
} else {
throw e119510;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__119560 = state_119452;
state_119452 = G__119560;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$api$query$resolve_block_range_$_state_machine__99037__auto__ = function(state_119452){
switch(arguments.length){
case 0:
return fluree$db$api$query$resolve_block_range_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$api$query$resolve_block_range_$_state_machine__99037__auto____1.call(this,state_119452);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$resolve_block_range_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$resolve_block_range_$_state_machine__99037__auto____0;
fluree$db$api$query$resolve_block_range_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$resolve_block_range_$_state_machine__99037__auto____1;
return fluree$db$api$query$resolve_block_range_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_119512 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_119512[(6)] = c__99059__auto__);

return statearr_119512;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
fluree.db.api.query.format_block_resp_pretty = (function fluree$db$api$query$format_block_resp_pretty(db,curr_block,cache,fuel){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_119707){
var state_val_119708 = (state_119707[(1)]);
if((state_val_119708 === (7))){
var inst_119585 = (state_119707[(7)]);
var inst_119584 = (state_119707[(8)]);
var inst_119595 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_119596 = [inst_119584,inst_119585];
var inst_119597 = (new cljs.core.PersistentVector(null,2,(5),inst_119595,inst_119596,null));
var state_119707__$1 = state_119707;
var statearr_119709_119756 = state_119707__$1;
(statearr_119709_119756[(2)] = inst_119597);

(statearr_119709_119756[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119708 === (20))){
var inst_119658 = (state_119707[(2)]);
var state_119707__$1 = state_119707;
var statearr_119710_119757 = state_119707__$1;
(statearr_119710_119757[(2)] = inst_119658);

(statearr_119710_119757[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119708 === (27))){
var inst_119674 = (state_119707[(9)]);
var inst_119681 = (state_119707[(10)]);
var inst_119691 = (state_119707[(2)]);
var inst_119692 = fluree.db.util.async.throw_err(inst_119691);
var inst_119693 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_119674,inst_119692);
var inst_119673 = inst_119681;
var inst_119674__$1 = inst_119693;
var state_119707__$1 = (function (){var statearr_119711 = state_119707;
(statearr_119711[(9)] = inst_119674__$1);

(statearr_119711[(11)] = inst_119673);

return statearr_119711;
})();
var statearr_119712_119758 = state_119707__$1;
(statearr_119712_119758[(2)] = null);

(statearr_119712_119758[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119708 === (1))){
var state_119707__$1 = state_119707;
var statearr_119713_119759 = state_119707__$1;
(statearr_119713_119759[(2)] = null);

(statearr_119713_119759[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119708 === (24))){
var inst_119674 = (state_119707[(9)]);
var state_119707__$1 = state_119707;
var statearr_119714_119760 = state_119707__$1;
(statearr_119714_119760[(2)] = inst_119674);

(statearr_119714_119760[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119708 === (4))){
var inst_119577 = (state_119707[(12)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_119707,(3),Error,null,(2));
var inst_119577__$1 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_119578 = cljs.core.seq(inst_119577__$1);
var inst_119579 = cljs.core.first(inst_119578);
var inst_119580 = cljs.core.next(inst_119578);
var inst_119581 = cljs.core.PersistentHashMap.EMPTY;
var inst_119582 = cljs.core.PersistentHashMap.EMPTY;
var inst_119583 = inst_119577__$1;
var inst_119584 = inst_119581;
var inst_119585 = inst_119582;
var state_119707__$1 = (function (){var statearr_119715 = state_119707;
(statearr_119715[(7)] = inst_119585);

(statearr_119715[(13)] = inst_119579);

(statearr_119715[(14)] = inst_119583);

(statearr_119715[(8)] = inst_119584);

(statearr_119715[(15)] = inst_119580);

(statearr_119715[(12)] = inst_119577__$1);

return statearr_119715;
})();
var statearr_119716_119761 = state_119707__$1;
(statearr_119716_119761[(2)] = null);

(statearr_119716_119761[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119708 === (15))){
var inst_119616 = (state_119707[(2)]);
var state_119707__$1 = state_119707;
var statearr_119718_119762 = state_119707__$1;
(statearr_119718_119762[(2)] = inst_119616);

(statearr_119718_119762[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119708 === (21))){
var inst_119636 = (state_119707[(16)]);
var inst_119643 = (state_119707[(17)]);
var inst_119653 = (state_119707[(2)]);
var inst_119654 = fluree.db.util.async.throw_err(inst_119653);
var inst_119655 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_119636,inst_119654);
var inst_119635 = inst_119643;
var inst_119636__$1 = inst_119655;
var state_119707__$1 = (function (){var statearr_119719 = state_119707;
(statearr_119719[(16)] = inst_119636__$1);

(statearr_119719[(18)] = inst_119635);

return statearr_119719;
})();
var statearr_119720_119763 = state_119707__$1;
(statearr_119720_119763[(2)] = null);

(statearr_119720_119763[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119708 === (13))){
var inst_119601 = (state_119707[(19)]);
var inst_119599 = (state_119707[(20)]);
var inst_119585 = (state_119707[(7)]);
var inst_119579 = (state_119707[(13)]);
var inst_119583 = (state_119707[(14)]);
var inst_119591 = (state_119707[(21)]);
var inst_119606 = (state_119707[(22)]);
var inst_119592 = (state_119707[(23)]);
var inst_119584 = (state_119707[(8)]);
var inst_119580 = (state_119707[(15)]);
var inst_119577 = (state_119707[(12)]);
var inst_119608 = (function (){var seq__119575 = inst_119580;
var subject = inst_119599;
var flake = inst_119591;
var vec__119574 = inst_119577;
var r = inst_119592;
var first__119589 = inst_119591;
var asserted_subjects = inst_119584;
var G__119573 = inst_119583;
var flake_SINGLEQUOTE_ = inst_119606;
var retracted_subjects = inst_119585;
var first__119576 = inst_119579;
var seq__119588 = inst_119592;
var asserted_QMARK_ = inst_119601;
var vec__119587 = inst_119583;
return ((function (seq__119575,subject,flake,vec__119574,r,first__119589,asserted_subjects,G__119573,flake_SINGLEQUOTE_,retracted_subjects,first__119576,seq__119588,asserted_QMARK_,vec__119587,inst_119601,inst_119599,inst_119585,inst_119579,inst_119583,inst_119591,inst_119606,inst_119592,inst_119584,inst_119580,inst_119577,state_val_119708,c__99059__auto__){
return (function (p1__119561_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__119561_SHARP_,flake_SINGLEQUOTE_));
});
;})(seq__119575,subject,flake,vec__119574,r,first__119589,asserted_subjects,G__119573,flake_SINGLEQUOTE_,retracted_subjects,first__119576,seq__119588,asserted_QMARK_,vec__119587,inst_119601,inst_119599,inst_119585,inst_119579,inst_119583,inst_119591,inst_119606,inst_119592,inst_119584,inst_119580,inst_119577,state_val_119708,c__99059__auto__))
})();
var inst_119609 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_119584,inst_119599,inst_119608);
var tmp119717 = inst_119585;
var inst_119583__$1 = inst_119592;
var inst_119584__$1 = inst_119609;
var inst_119585__$1 = tmp119717;
var state_119707__$1 = (function (){var statearr_119721 = state_119707;
(statearr_119721[(7)] = inst_119585__$1);

(statearr_119721[(14)] = inst_119583__$1);

(statearr_119721[(8)] = inst_119584__$1);

return statearr_119721;
})();
var statearr_119722_119764 = state_119707__$1;
(statearr_119722_119764[(2)] = null);

(statearr_119722_119764[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119708 === (22))){
var inst_119680 = (state_119707[(24)]);
var inst_119673 = (state_119707[(11)]);
var inst_119679 = cljs.core.seq(inst_119673);
var inst_119680__$1 = cljs.core.first(inst_119679);
var inst_119681 = cljs.core.next(inst_119679);
var inst_119682 = cljs.core.not(inst_119680__$1);
var state_119707__$1 = (function (){var statearr_119723 = state_119707;
(statearr_119723[(24)] = inst_119680__$1);

(statearr_119723[(10)] = inst_119681);

return statearr_119723;
})();
if(inst_119682){
var statearr_119724_119765 = state_119707__$1;
(statearr_119724_119765[(1)] = (24));

} else {
var statearr_119725_119766 = state_119707__$1;
(statearr_119725_119766[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119708 === (6))){
var inst_119620 = (state_119707[(2)]);
var inst_119621 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_119620,(0),null);
var inst_119622 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_119620,(1),null);
var inst_119630 = cljs.core.vals(inst_119622);
var inst_119631 = cljs.core.seq(inst_119630);
var inst_119632 = cljs.core.first(inst_119631);
var inst_119633 = cljs.core.next(inst_119631);
var inst_119634 = cljs.core.PersistentVector.EMPTY;
var inst_119635 = inst_119630;
var inst_119636 = inst_119634;
var state_119707__$1 = (function (){var statearr_119726 = state_119707;
(statearr_119726[(16)] = inst_119636);

(statearr_119726[(25)] = inst_119632);

(statearr_119726[(18)] = inst_119635);

(statearr_119726[(26)] = inst_119633);

(statearr_119726[(27)] = inst_119621);

return statearr_119726;
})();
var statearr_119727_119767 = state_119707__$1;
(statearr_119727_119767[(2)] = null);

(statearr_119727_119767[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119708 === (25))){
var inst_119680 = (state_119707[(24)]);
var inst_119685 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$select];
var inst_119686 = cljs.core.PersistentHashMap.EMPTY;
var inst_119687 = [true,inst_119686];
var inst_119688 = cljs.core.PersistentHashMap.fromArrays(inst_119685,inst_119687);
var inst_119689 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_119688,inst_119680);
var state_119707__$1 = state_119707;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_119707__$1,(27),inst_119689);
} else {
if((state_val_119708 === (17))){
var inst_119621 = (state_119707[(27)]);
var inst_119660 = (state_119707[(2)]);
var inst_119668 = cljs.core.vals(inst_119621);
var inst_119669 = cljs.core.seq(inst_119668);
var inst_119670 = cljs.core.first(inst_119669);
var inst_119671 = cljs.core.next(inst_119669);
var inst_119672 = cljs.core.PersistentVector.EMPTY;
var inst_119673 = inst_119668;
var inst_119674 = inst_119672;
var state_119707__$1 = (function (){var statearr_119728 = state_119707;
(statearr_119728[(28)] = inst_119671);

(statearr_119728[(9)] = inst_119674);

(statearr_119728[(29)] = inst_119670);

(statearr_119728[(30)] = inst_119660);

(statearr_119728[(11)] = inst_119673);

return statearr_119728;
})();
var statearr_119729_119768 = state_119707__$1;
(statearr_119729_119768[(2)] = null);

(statearr_119729_119768[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119708 === (3))){
var inst_119563 = (state_119707[(2)]);
var state_119707__$1 = state_119707;
var statearr_119730_119769 = state_119707__$1;
(statearr_119730_119769[(2)] = inst_119563);


cljs.core.async.impl.ioc_helpers.process_exception(state_119707__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_119708 === (12))){
var inst_119601 = (state_119707[(19)]);
var inst_119606 = (state_119707[(2)]);
var state_119707__$1 = (function (){var statearr_119731 = state_119707;
(statearr_119731[(22)] = inst_119606);

return statearr_119731;
})();
if(cljs.core.truth_(inst_119601)){
var statearr_119732_119770 = state_119707__$1;
(statearr_119732_119770[(1)] = (13));

} else {
var statearr_119733_119771 = state_119707__$1;
(statearr_119733_119771[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119708 === (2))){
var inst_119705 = (state_119707[(2)]);
var state_119707__$1 = state_119707;
return cljs.core.async.impl.ioc_helpers.return_chan(state_119707__$1,inst_119705);
} else {
if((state_val_119708 === (23))){
var inst_119660 = (state_119707[(30)]);
var inst_119698 = (state_119707[(2)]);
var inst_119699 = [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$retracted,cljs.core.cst$kw$asserted];
var inst_119700 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_119701 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_119702 = [inst_119700,inst_119701,inst_119660,inst_119698];
var inst_119703 = cljs.core.PersistentHashMap.fromArrays(inst_119699,inst_119702);
var state_119707__$1 = state_119707;
var statearr_119734_119772 = state_119707__$1;
(statearr_119734_119772[(2)] = inst_119703);


cljs.core.async.impl.ioc_helpers.process_exception(state_119707__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_119708 === (19))){
var inst_119642 = (state_119707[(31)]);
var inst_119647 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$select];
var inst_119648 = cljs.core.PersistentHashMap.EMPTY;
var inst_119649 = [true,inst_119648];
var inst_119650 = cljs.core.PersistentHashMap.fromArrays(inst_119647,inst_119649);
var inst_119651 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_119650,inst_119642);
var state_119707__$1 = state_119707;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_119707__$1,(21),inst_119651);
} else {
if((state_val_119708 === (11))){
var inst_119591 = (state_119707[(21)]);
var inst_119604 = fluree.db.flake.flip_flake.cljs$core$IFn$_invoke$arity$1(inst_119591);
var state_119707__$1 = state_119707;
var statearr_119735_119773 = state_119707__$1;
(statearr_119735_119773[(2)] = inst_119604);

(statearr_119735_119773[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119708 === (9))){
var inst_119618 = (state_119707[(2)]);
var state_119707__$1 = state_119707;
var statearr_119737_119774 = state_119707__$1;
(statearr_119737_119774[(2)] = inst_119618);

(statearr_119737_119774[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119708 === (5))){
var inst_119583 = (state_119707[(14)]);
var inst_119591 = (state_119707[(21)]);
var inst_119590 = cljs.core.seq(inst_119583);
var inst_119591__$1 = cljs.core.first(inst_119590);
var inst_119592 = cljs.core.next(inst_119590);
var inst_119593 = cljs.core.not(inst_119591__$1);
var state_119707__$1 = (function (){var statearr_119738 = state_119707;
(statearr_119738[(21)] = inst_119591__$1);

(statearr_119738[(23)] = inst_119592);

return statearr_119738;
})();
if(inst_119593){
var statearr_119739_119775 = state_119707__$1;
(statearr_119739_119775[(1)] = (7));

} else {
var statearr_119740_119776 = state_119707__$1;
(statearr_119740_119776[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119708 === (14))){
var inst_119601 = (state_119707[(19)]);
var inst_119599 = (state_119707[(20)]);
var inst_119585 = (state_119707[(7)]);
var inst_119579 = (state_119707[(13)]);
var inst_119583 = (state_119707[(14)]);
var inst_119591 = (state_119707[(21)]);
var inst_119606 = (state_119707[(22)]);
var inst_119592 = (state_119707[(23)]);
var inst_119584 = (state_119707[(8)]);
var inst_119580 = (state_119707[(15)]);
var inst_119577 = (state_119707[(12)]);
var inst_119612 = (function (){var seq__119575 = inst_119580;
var subject = inst_119599;
var flake = inst_119591;
var vec__119574 = inst_119577;
var r = inst_119592;
var first__119589 = inst_119591;
var asserted_subjects = inst_119584;
var G__119573 = inst_119583;
var flake_SINGLEQUOTE_ = inst_119606;
var retracted_subjects = inst_119585;
var first__119576 = inst_119579;
var seq__119588 = inst_119592;
var asserted_QMARK_ = inst_119601;
var vec__119587 = inst_119583;
return ((function (seq__119575,subject,flake,vec__119574,r,first__119589,asserted_subjects,G__119573,flake_SINGLEQUOTE_,retracted_subjects,first__119576,seq__119588,asserted_QMARK_,vec__119587,inst_119601,inst_119599,inst_119585,inst_119579,inst_119583,inst_119591,inst_119606,inst_119592,inst_119584,inst_119580,inst_119577,state_val_119708,c__99059__auto__){
return (function (p1__119562_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__119562_SHARP_,flake_SINGLEQUOTE_));
});
;})(seq__119575,subject,flake,vec__119574,r,first__119589,asserted_subjects,G__119573,flake_SINGLEQUOTE_,retracted_subjects,first__119576,seq__119588,asserted_QMARK_,vec__119587,inst_119601,inst_119599,inst_119585,inst_119579,inst_119583,inst_119591,inst_119606,inst_119592,inst_119584,inst_119580,inst_119577,state_val_119708,c__99059__auto__))
})();
var inst_119613 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_119585,inst_119599,inst_119612);
var tmp119736 = inst_119584;
var inst_119583__$1 = inst_119592;
var inst_119584__$1 = tmp119736;
var inst_119585__$1 = inst_119613;
var state_119707__$1 = (function (){var statearr_119741 = state_119707;
(statearr_119741[(7)] = inst_119585__$1);

(statearr_119741[(14)] = inst_119583__$1);

(statearr_119741[(8)] = inst_119584__$1);

return statearr_119741;
})();
var statearr_119742_119777 = state_119707__$1;
(statearr_119742_119777[(2)] = null);

(statearr_119742_119777[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119708 === (26))){
var inst_119696 = (state_119707[(2)]);
var state_119707__$1 = state_119707;
var statearr_119743_119778 = state_119707__$1;
(statearr_119743_119778[(2)] = inst_119696);

(statearr_119743_119778[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119708 === (16))){
var inst_119642 = (state_119707[(31)]);
var inst_119635 = (state_119707[(18)]);
var inst_119641 = cljs.core.seq(inst_119635);
var inst_119642__$1 = cljs.core.first(inst_119641);
var inst_119643 = cljs.core.next(inst_119641);
var inst_119644 = cljs.core.not(inst_119642__$1);
var state_119707__$1 = (function (){var statearr_119744 = state_119707;
(statearr_119744[(17)] = inst_119643);

(statearr_119744[(31)] = inst_119642__$1);

return statearr_119744;
})();
if(inst_119644){
var statearr_119745_119779 = state_119707__$1;
(statearr_119745_119779[(1)] = (18));

} else {
var statearr_119746_119780 = state_119707__$1;
(statearr_119746_119780[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119708 === (10))){
var inst_119591 = (state_119707[(21)]);
var state_119707__$1 = state_119707;
var statearr_119747_119781 = state_119707__$1;
(statearr_119747_119781[(2)] = inst_119591);

(statearr_119747_119781[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119708 === (18))){
var inst_119636 = (state_119707[(16)]);
var state_119707__$1 = state_119707;
var statearr_119748_119782 = state_119707__$1;
(statearr_119748_119782[(2)] = inst_119636);

(statearr_119748_119782[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119708 === (8))){
var inst_119601 = (state_119707[(19)]);
var inst_119591 = (state_119707[(21)]);
var inst_119599 = inst_119591.s;
var inst_119600 = inst_119591.op;
var inst_119601__$1 = inst_119600 === true;
var state_119707__$1 = (function (){var statearr_119749 = state_119707;
(statearr_119749[(19)] = inst_119601__$1);

(statearr_119749[(20)] = inst_119599);

return statearr_119749;
})();
if(cljs.core.truth_(inst_119601__$1)){
var statearr_119750_119783 = state_119707__$1;
(statearr_119750_119783[(1)] = (10));

} else {
var statearr_119751_119784 = state_119707__$1;
(statearr_119751_119784[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__99037__auto__ = null;
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__99037__auto____0 = (function (){
var statearr_119752 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_119752[(0)] = fluree$db$api$query$format_block_resp_pretty_$_state_machine__99037__auto__);

(statearr_119752[(1)] = (1));

return statearr_119752;
});
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__99037__auto____1 = (function (state_119707){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_119707);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e119753){if((e119753 instanceof Object)){
var ex__99040__auto__ = e119753;
var statearr_119754_119785 = state_119707;
(statearr_119754_119785[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_119707);

return cljs.core.cst$kw$recur;
} else {
throw e119753;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__119786 = state_119707;
state_119707 = G__119786;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$api$query$format_block_resp_pretty_$_state_machine__99037__auto__ = function(state_119707){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__99037__auto____1.call(this,state_119707);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_block_resp_pretty_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__99037__auto____0;
fluree$db$api$query$format_block_resp_pretty_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__99037__auto____1;
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_119755 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_119755[(6)] = c__99059__auto__);

return statearr_119755;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
fluree.db.api.query.format_blocks_resp_pretty = (function fluree$db$api$query$format_blocks_resp_pretty(db,resp){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_119818){
var state_val_119819 = (state_119818[(1)]);
if((state_val_119819 === (1))){
var inst_119787 = cljs.core.volatile_BANG_((0));
var inst_119788 = cljs.core.PersistentHashMap.EMPTY;
var inst_119789 = cljs.core.volatile_BANG_(inst_119788);
var inst_119790 = cljs.core.first(resp);
var inst_119791 = cljs.core.rest(resp);
var inst_119792 = cljs.core.PersistentVector.EMPTY;
var inst_119793 = inst_119787;
var inst_119794 = inst_119789;
var inst_119795 = inst_119790;
var inst_119796 = inst_119791;
var inst_119797 = inst_119792;
var state_119818__$1 = (function (){var statearr_119820 = state_119818;
(statearr_119820[(7)] = inst_119795);

(statearr_119820[(8)] = inst_119793);

(statearr_119820[(9)] = inst_119794);

(statearr_119820[(10)] = inst_119797);

(statearr_119820[(11)] = inst_119796);

return statearr_119820;
})();
var statearr_119821_119835 = state_119818__$1;
(statearr_119821_119835[(2)] = null);

(statearr_119821_119835[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119819 === (2))){
var inst_119795 = (state_119818[(7)]);
var inst_119793 = (state_119818[(8)]);
var inst_119794 = (state_119818[(9)]);
var inst_119799 = fluree.db.api.query.format_block_resp_pretty(db,inst_119795,inst_119794,inst_119793);
var state_119818__$1 = state_119818;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_119818__$1,(4),inst_119799);
} else {
if((state_val_119819 === (3))){
var inst_119816 = (state_119818[(2)]);
var state_119818__$1 = state_119818;
return cljs.core.async.impl.ioc_helpers.return_chan(state_119818__$1,inst_119816);
} else {
if((state_val_119819 === (4))){
var inst_119797 = (state_119818[(10)]);
var inst_119796 = (state_119818[(11)]);
var inst_119801 = (state_119818[(2)]);
var inst_119802 = fluree.db.util.async.throw_err(inst_119801);
var inst_119803 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_119804 = [inst_119802];
var inst_119805 = (new cljs.core.PersistentVector(null,1,(5),inst_119803,inst_119804,null));
var inst_119806 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_119797,inst_119805);
var inst_119807 = cljs.core.first(inst_119796);
var state_119818__$1 = (function (){var statearr_119824 = state_119818;
(statearr_119824[(12)] = inst_119806);

return statearr_119824;
})();
if(cljs.core.truth_(inst_119807)){
var statearr_119825_119836 = state_119818__$1;
(statearr_119825_119836[(1)] = (5));

} else {
var statearr_119826_119837 = state_119818__$1;
(statearr_119826_119837[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119819 === (5))){
var inst_119793 = (state_119818[(8)]);
var inst_119806 = (state_119818[(12)]);
var inst_119794 = (state_119818[(9)]);
var inst_119796 = (state_119818[(11)]);
var inst_119809 = cljs.core.first(inst_119796);
var inst_119810 = cljs.core.rest(inst_119796);
var tmp119822 = inst_119793;
var tmp119823 = inst_119794;
var inst_119793__$1 = tmp119822;
var inst_119794__$1 = tmp119823;
var inst_119795 = inst_119809;
var inst_119796__$1 = inst_119810;
var inst_119797 = inst_119806;
var state_119818__$1 = (function (){var statearr_119827 = state_119818;
(statearr_119827[(7)] = inst_119795);

(statearr_119827[(8)] = inst_119793__$1);

(statearr_119827[(9)] = inst_119794__$1);

(statearr_119827[(10)] = inst_119797);

(statearr_119827[(11)] = inst_119796__$1);

return statearr_119827;
})();
var statearr_119828_119838 = state_119818__$1;
(statearr_119828_119838[(2)] = null);

(statearr_119828_119838[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119819 === (6))){
var inst_119806 = (state_119818[(12)]);
var state_119818__$1 = state_119818;
var statearr_119829_119839 = state_119818__$1;
(statearr_119829_119839[(2)] = inst_119806);

(statearr_119829_119839[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119819 === (7))){
var inst_119814 = (state_119818[(2)]);
var state_119818__$1 = state_119818;
var statearr_119830_119840 = state_119818__$1;
(statearr_119830_119840[(2)] = inst_119814);

(statearr_119830_119840[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__99037__auto__ = null;
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__99037__auto____0 = (function (){
var statearr_119831 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_119831[(0)] = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__99037__auto__);

(statearr_119831[(1)] = (1));

return statearr_119831;
});
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__99037__auto____1 = (function (state_119818){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_119818);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e119832){if((e119832 instanceof Object)){
var ex__99040__auto__ = e119832;
var statearr_119833_119841 = state_119818;
(statearr_119833_119841[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_119818);

return cljs.core.cst$kw$recur;
} else {
throw e119832;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__119842 = state_119818;
state_119818 = G__119842;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__99037__auto__ = function(state_119818){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__99037__auto____1.call(this,state_119818);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__99037__auto____0;
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__99037__auto____1;
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_119834 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_119834[(6)] = c__99059__auto__);

return statearr_119834;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Returns response time, formatted as string. Must provide start time of request
 * for clj as (System/nanoTime), or for cljs epoch milliseconds
 */
fluree.db.api.query.response_time_formatted = (function fluree$db$api$query$response_time_formatted(start_time){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((fluree.db.util.core.current_time_millis() - start_time)),"ms"].join('');
});
/**
 * Returns a core async channel of blocks from start block (inclusive) to end if provided (exclusive).
 *   Each block is a separate map, containing keys :block, :t and :flakes.
 *   Channel is lazy, continue to take! values as needed.
 */
fluree.db.api.query.block_range = (function fluree$db$api$query$block_range(var_args){
var G__119845 = arguments.length;
switch (G__119845) {
case 2:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,null,null);
});

fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,end,null);
});

fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return fluree.db.query.block.block_range(db,start,end,opts);
});

fluree.db.api.query.block_range.cljs$lang$maxFixedArity = 4;

fluree.db.api.query.block_query_async = (function fluree$db$api$query$block_query_async(conn,ledger,query_map){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_119958){
var state_val_119959 = (state_119958[(1)]);
if((state_val_119959 === (7))){
var inst_119870 = (state_119958[(2)]);
var state_119958__$1 = state_119958;
if(cljs.core.truth_(inst_119870)){
var statearr_119960_120014 = state_119958__$1;
(statearr_119960_120014[(1)] = (11));

} else {
var statearr_119961_120015 = state_119958__$1;
(statearr_119961_120015[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119959 === (20))){
var inst_119909 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_119910 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_119909].join('');
var inst_119911 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_119912 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_119913 = cljs.core.PersistentHashMap.fromArrays(inst_119911,inst_119912);
var inst_119914 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_119910,inst_119913);
var inst_119915 = (function(){throw inst_119914})();
var state_119958__$1 = state_119958;
var statearr_119962_120016 = state_119958__$1;
(statearr_119962_120016[(2)] = inst_119915);

(statearr_119962_120016[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119959 === (27))){
var inst_119929 = cljs.core.cst$kw$pretty_DASH_print.cljs$core$IFn$_invoke$arity$1(query_map);
var state_119958__$1 = state_119958;
var statearr_119963_120017 = state_119958__$1;
(statearr_119963_120017[(2)] = inst_119929);

(statearr_119963_120017[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119959 === (1))){
var state_119958__$1 = state_119958;
var statearr_119964_120018 = state_119958__$1;
(statearr_119964_120018[(2)] = null);

(statearr_119964_120018[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119959 === (24))){
var state_119958__$1 = state_119958;
var statearr_119965_120019 = state_119958__$1;
(statearr_119965_120019[(2)] = null);

(statearr_119965_120019[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119959 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_119958,(3),Error,null,(2));
var inst_119856 = (query_map == null);
var inst_119857 = cljs.core.not(inst_119856);
var state_119958__$1 = state_119958;
if(inst_119857){
var statearr_119966_120020 = state_119958__$1;
(statearr_119966_120020[(1)] = (5));

} else {
var statearr_119967_120021 = state_119958__$1;
(statearr_119967_120021[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119959 === (15))){
var inst_119877 = (state_119958[(7)]);
var inst_119881 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_119882 = ["_auth/id",inst_119877];
var inst_119883 = (new cljs.core.PersistentVector(null,2,(5),inst_119881,inst_119882,null));
var state_119958__$1 = state_119958;
var statearr_119968_120022 = state_119958__$1;
(statearr_119968_120022[(2)] = inst_119883);

(statearr_119968_120022[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119959 === (21))){
var inst_119917 = (state_119958[(2)]);
var inst_119918 = cljs.core.cst$kw$pretty_DASH_print.cljs$core$IFn$_invoke$arity$1(query_map);
var state_119958__$1 = (function (){var statearr_119969 = state_119958;
(statearr_119969[(8)] = inst_119917);

return statearr_119969;
})();
if(cljs.core.truth_(inst_119918)){
var statearr_119970_120023 = state_119958__$1;
(statearr_119970_120023[(1)] = (23));

} else {
var statearr_119971_120024 = state_119958__$1;
(statearr_119971_120024[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119959 === (31))){
var inst_119876 = (state_119958[(9)]);
var inst_119939 = (state_119958[(2)]);
var inst_119940 = cljs.core.cst$kw$meta.cljs$core$IFn$_invoke$arity$1(inst_119876);
var state_119958__$1 = (function (){var statearr_119972 = state_119958;
(statearr_119972[(10)] = inst_119939);

return statearr_119972;
})();
if(cljs.core.truth_(inst_119940)){
var statearr_119973_120025 = state_119958__$1;
(statearr_119973_120025[(1)] = (33));

} else {
var statearr_119974_120026 = state_119958__$1;
(statearr_119974_120026[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119959 === (32))){
var inst_119935 = (state_119958[(2)]);
var inst_119936 = fluree.db.util.async.throw_err(inst_119935);
var state_119958__$1 = state_119958;
var statearr_119975_120027 = state_119958__$1;
(statearr_119975_120027[(2)] = inst_119936);

(statearr_119975_120027[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119959 === (33))){
var inst_119939 = (state_119958[(10)]);
var inst_119942 = [cljs.core.cst$kw$status,cljs.core.cst$kw$result,cljs.core.cst$kw$fuel,cljs.core.cst$kw$time];
var inst_119943 = cljs.core.sequential_QMARK_(inst_119939);
var state_119958__$1 = (function (){var statearr_119976 = state_119958;
(statearr_119976[(11)] = inst_119942);

return statearr_119976;
})();
if(inst_119943){
var statearr_119977_120028 = state_119958__$1;
(statearr_119977_120028[(1)] = (36));

} else {
var statearr_119978_120029 = state_119958__$1;
(statearr_119978_120029[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119959 === (13))){
var inst_119876 = (state_119958[(9)]);
var inst_119877 = (state_119958[(7)]);
var inst_119875 = (state_119958[(2)]);
var inst_119876__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_119875,cljs.core.cst$kw$opts);
var inst_119877__$1 = cljs.core.cst$kw$auth.cljs$core$IFn$_invoke$arity$1(inst_119876__$1);
var inst_119878 = fluree.db.util.core.current_time_millis();
var inst_119879 = [cljs.core.cst$kw$auth];
var state_119958__$1 = (function (){var statearr_119979 = state_119958;
(statearr_119979[(9)] = inst_119876__$1);

(statearr_119979[(12)] = inst_119879);

(statearr_119979[(7)] = inst_119877__$1);

(statearr_119979[(13)] = inst_119878);

return statearr_119979;
})();
if(cljs.core.truth_(inst_119877__$1)){
var statearr_119980_120030 = state_119958__$1;
(statearr_119980_120030[(1)] = (15));

} else {
var statearr_119981_120031 = state_119958__$1;
(statearr_119981_120031[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119959 === (22))){
var inst_119906 = (state_119958[(2)]);
var inst_119907 = fluree.db.util.async.throw_err(inst_119906);
var state_119958__$1 = state_119958;
var statearr_119982_120032 = state_119958__$1;
(statearr_119982_120032[(2)] = inst_119907);

(statearr_119982_120032[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119959 === (36))){
var inst_119939 = (state_119958[(10)]);
var inst_119945 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_119939);
var state_119958__$1 = state_119958;
var statearr_119983_120033 = state_119958__$1;
(statearr_119983_120033[(2)] = inst_119945);

(statearr_119983_120033[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119959 === (29))){
var inst_119917 = (state_119958[(8)]);
var inst_119892 = (state_119958[(14)]);
var inst_119933 = fluree.db.api.query.format_blocks_resp_pretty(inst_119892,inst_119917);
var state_119958__$1 = state_119958;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_119958__$1,(32),inst_119933);
} else {
if((state_val_119959 === (6))){
var state_119958__$1 = state_119958;
var statearr_119984_120034 = state_119958__$1;
(statearr_119984_120034[(2)] = false);

(statearr_119984_120034[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119959 === (28))){
var inst_119931 = (state_119958[(2)]);
var state_119958__$1 = state_119958;
if(cljs.core.truth_(inst_119931)){
var statearr_119985_120035 = state_119958__$1;
(statearr_119985_120035[(1)] = (29));

} else {
var statearr_119986_120036 = state_119958__$1;
(statearr_119986_120036[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119959 === (25))){
var inst_119926 = (state_119958[(15)]);
var inst_119925 = (state_119958[(2)]);
var inst_119926__$1 = cljs.core.cst$kw$prettyPrint.cljs$core$IFn$_invoke$arity$1(query_map);
var state_119958__$1 = (function (){var statearr_119987 = state_119958;
(statearr_119987[(16)] = inst_119925);

(statearr_119987[(15)] = inst_119926__$1);

return statearr_119987;
})();
if(cljs.core.truth_(inst_119926__$1)){
var statearr_119988_120037 = state_119958__$1;
(statearr_119988_120037[(1)] = (26));

} else {
var statearr_119989_120038 = state_119958__$1;
(statearr_119989_120038[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119959 === (34))){
var inst_119939 = (state_119958[(10)]);
var state_119958__$1 = state_119958;
var statearr_119990_120039 = state_119958__$1;
(statearr_119990_120039[(2)] = inst_119939);

(statearr_119990_120039[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119959 === (17))){
var inst_119879 = (state_119958[(12)]);
var inst_119886 = (state_119958[(2)]);
var inst_119887 = [inst_119886];
var inst_119888 = cljs.core.PersistentHashMap.fromArrays(inst_119879,inst_119887);
var inst_119889 = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,inst_119888);
var state_119958__$1 = state_119958;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_119958__$1,(14),inst_119889);
} else {
if((state_val_119959 === (3))){
var inst_119847 = (state_119958[(2)]);
var state_119958__$1 = state_119958;
var statearr_119991_120040 = state_119958__$1;
(statearr_119991_120040[(2)] = inst_119847);


cljs.core.async.impl.ioc_helpers.process_exception(state_119958__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_119959 === (12))){
var state_119958__$1 = state_119958;
var statearr_119992_120041 = state_119958__$1;
(statearr_119992_120041[(2)] = query_map);

(statearr_119992_120041[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119959 === (2))){
var inst_119956 = (state_119958[(2)]);
var state_119958__$1 = state_119958;
return cljs.core.async.impl.ioc_helpers.return_chan(state_119958__$1,inst_119956);
} else {
if((state_val_119959 === (23))){
var inst_119920 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_119921 = ["The pretty-print key should be rename `prettyPrint`. `pretty-print` is being deprecated. Provided: ",inst_119920].join('');
var inst_119922 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_119921], 0));
var state_119958__$1 = state_119958;
var statearr_119993_120042 = state_119958__$1;
(statearr_119993_120042[(2)] = inst_119922);

(statearr_119993_120042[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119959 === (35))){
var inst_119954 = (state_119958[(2)]);
var state_119958__$1 = state_119958;
var statearr_119994_120043 = state_119958__$1;
(statearr_119994_120043[(2)] = inst_119954);


cljs.core.async.impl.ioc_helpers.process_exception(state_119958__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_119959 === (19))){
var inst_119897 = (state_119958[(17)]);
var inst_119876 = (state_119958[(9)]);
var inst_119898 = (state_119958[(18)]);
var inst_119892 = (state_119958[(14)]);
var inst_119904 = fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(inst_119892,inst_119897,inst_119898,inst_119876);
var state_119958__$1 = state_119958;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_119958__$1,(22),inst_119904);
} else {
if((state_val_119959 === (11))){
var inst_119872 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,query_map);
var state_119958__$1 = state_119958;
var statearr_119995_120044 = state_119958__$1;
(statearr_119995_120044[(2)] = inst_119872);

(statearr_119995_120044[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119959 === (9))){
var state_119958__$1 = state_119958;
var statearr_119996_120045 = state_119958__$1;
(statearr_119996_120045[(2)] = false);

(statearr_119996_120045[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119959 === (5))){
var inst_119859 = query_map.cljs$lang$protocol_mask$partition0$;
var inst_119860 = (inst_119859 & (64));
var inst_119861 = query_map.cljs$core$ISeq$;
var inst_119862 = (cljs.core.PROTOCOL_SENTINEL === inst_119861);
var inst_119863 = ((inst_119860) || (inst_119862));
var state_119958__$1 = state_119958;
if(cljs.core.truth_(inst_119863)){
var statearr_119997_120046 = state_119958__$1;
(statearr_119997_120046[(1)] = (8));

} else {
var statearr_119998_120047 = state_119958__$1;
(statearr_119998_120047[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119959 === (14))){
var inst_119892 = (state_119958[(14)]);
var inst_119891 = (state_119958[(2)]);
var inst_119892__$1 = fluree.db.util.async.throw_err(inst_119891);
var inst_119893 = fluree.db.api.query.resolve_block_range(inst_119892__$1,query_map);
var state_119958__$1 = (function (){var statearr_119999 = state_119958;
(statearr_119999[(14)] = inst_119892__$1);

return statearr_119999;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_119958__$1,(18),inst_119893);
} else {
if((state_val_119959 === (26))){
var inst_119926 = (state_119958[(15)]);
var state_119958__$1 = state_119958;
var statearr_120000_120048 = state_119958__$1;
(statearr_120000_120048[(2)] = inst_119926);

(statearr_120000_120048[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119959 === (16))){
var state_119958__$1 = state_119958;
var statearr_120001_120049 = state_119958__$1;
(statearr_120001_120049[(2)] = null);

(statearr_120001_120049[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119959 === (38))){
var inst_119942 = (state_119958[(11)]);
var inst_119878 = (state_119958[(13)]);
var inst_119948 = (state_119958[(2)]);
var inst_119949 = fluree.db.api.query.response_time_formatted(inst_119878);
var inst_119950 = [(200),inst_119948,(100),inst_119949];
var inst_119951 = cljs.core.PersistentHashMap.fromArrays(inst_119942,inst_119950);
var state_119958__$1 = state_119958;
var statearr_120002_120050 = state_119958__$1;
(statearr_120002_120050[(2)] = inst_119951);

(statearr_120002_120050[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119959 === (30))){
var inst_119917 = (state_119958[(8)]);
var state_119958__$1 = state_119958;
var statearr_120003_120051 = state_119958__$1;
(statearr_120003_120051[(2)] = inst_119917);

(statearr_120003_120051[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119959 === (10))){
var inst_119867 = (state_119958[(2)]);
var state_119958__$1 = state_119958;
var statearr_120004_120052 = state_119958__$1;
(statearr_120004_120052[(2)] = inst_119867);

(statearr_120004_120052[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119959 === (18))){
var inst_119895 = (state_119958[(2)]);
var inst_119896 = fluree.db.util.async.throw_err(inst_119895);
var inst_119897 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_119896,(0),null);
var inst_119898 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_119896,(1),null);
var inst_119899 = cljs.core.list(cljs.core.cst$kw$block);
var inst_119900 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query_map,cljs.core.cst$kw$pretty_DASH_print);
var inst_119901 = cljs.core.keys(inst_119900);
var inst_119902 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_119899,inst_119901);
var state_119958__$1 = (function (){var statearr_120005 = state_119958;
(statearr_120005[(17)] = inst_119897);

(statearr_120005[(18)] = inst_119898);

return statearr_120005;
})();
if(inst_119902){
var statearr_120006_120053 = state_119958__$1;
(statearr_120006_120053[(1)] = (19));

} else {
var statearr_120007_120054 = state_119958__$1;
(statearr_120007_120054[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119959 === (37))){
var inst_119939 = (state_119958[(10)]);
var state_119958__$1 = state_119958;
var statearr_120008_120055 = state_119958__$1;
(statearr_120008_120055[(2)] = inst_119939);

(statearr_120008_120055[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119959 === (8))){
var state_119958__$1 = state_119958;
var statearr_120009_120056 = state_119958__$1;
(statearr_120009_120056[(2)] = true);

(statearr_120009_120056[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$api$query$block_query_async_$_state_machine__99037__auto__ = null;
var fluree$db$api$query$block_query_async_$_state_machine__99037__auto____0 = (function (){
var statearr_120010 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_120010[(0)] = fluree$db$api$query$block_query_async_$_state_machine__99037__auto__);

(statearr_120010[(1)] = (1));

return statearr_120010;
});
var fluree$db$api$query$block_query_async_$_state_machine__99037__auto____1 = (function (state_119958){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_119958);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e120011){if((e120011 instanceof Object)){
var ex__99040__auto__ = e120011;
var statearr_120012_120057 = state_119958;
(statearr_120012_120057[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_119958);

return cljs.core.cst$kw$recur;
} else {
throw e120011;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__120058 = state_119958;
state_119958 = G__120058;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$api$query$block_query_async_$_state_machine__99037__auto__ = function(state_119958){
switch(arguments.length){
case 0:
return fluree$db$api$query$block_query_async_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$api$query$block_query_async_$_state_machine__99037__auto____1.call(this,state_119958);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$block_query_async_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$block_query_async_$_state_machine__99037__auto____0;
fluree$db$api$query$block_query_async_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$block_query_async_$_state_machine__99037__auto____1;
return fluree$db$api$query$block_query_async_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_120013 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_120013[(6)] = c__99059__auto__);

return statearr_120013;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
fluree.db.api.query.get_history_pattern = (function fluree$db$api$query$get_history_pattern(history){
var subject = ((fluree.db.util.core.subj_ident_QMARK_(history))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [history], null):((cljs.core.sequential_QMARK_(history))?((cljs.core.empty_QMARK_(history))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():history):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
));
var vec__120059 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(0)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(1)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(2)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(3))], null);
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__120059,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__120059,(1),null);
var o = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__120059,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__120059,(3),null);
var vec__120062 = (((!((s == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,cljs.core.cst$kw$spot], null):(((((s == null)) && ((!((p == null)))) && ((o == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,s,o,t], null),cljs.core.cst$kw$psot], null):(((((s == null)) && ((!((p == null)))) && ((!((o == null))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,o,s,t], null),cljs.core.cst$kw$post], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
)));
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__120062,(0),null);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__120062,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pattern,idx], null);
});
fluree.db.api.query.auth_match = (function fluree$db$api$query$auth_match(auth_set,t_map,flake){
var vec__120065 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(t_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [flake.t,cljs.core.cst$kw$auth], null));
var auth = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__120065,(0),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__120065,(1),null);
var or__4131__auto__ = (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(auth) : auth_set.call(null,auth));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(id) : auth_set.call(null,id));
}
});
fluree.db.api.query.min_safe = (function fluree$db$api$query$min_safe(var_args){
var args__4736__auto__ = [];
var len__4730__auto___120069 = arguments.length;
var i__4731__auto___120070 = (0);
while(true){
if((i__4731__auto___120070 < len__4730__auto___120069)){
args__4736__auto__.push((arguments[i__4731__auto___120070]));

var G__120071 = (i__4731__auto___120070 + (1));
i__4731__auto___120070 = G__120071;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,args));
});

fluree.db.api.query.min_safe.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fluree.db.api.query.min_safe.cljs$lang$applyTo = (function (seq120068){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq120068));
});

fluree.db.api.query.format_history_resp = (function fluree$db$api$query$format_history_resp(db,resp,auth,show_auth){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_120277){
var state_val_120278 = (state_120277[(1)]);
if((state_val_120278 === (7))){
var inst_120272 = (state_120277[(2)]);
var inst_120273 = cljs.core.vals(inst_120272);
var state_120277__$1 = state_120277;
var statearr_120279_120377 = state_120277__$1;
(statearr_120279_120377[(2)] = inst_120273);


cljs.core.async.impl.ioc_helpers.process_exception(state_120277__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_120278 === (20))){
var inst_120204 = (state_120277[(7)]);
var inst_120209 = inst_120204.cljs$lang$protocol_mask$partition0$;
var inst_120210 = (inst_120209 & (64));
var inst_120211 = inst_120204.cljs$core$ISeq$;
var inst_120212 = (cljs.core.PROTOCOL_SENTINEL === inst_120211);
var inst_120213 = ((inst_120210) || (inst_120212));
var state_120277__$1 = state_120277;
if(cljs.core.truth_(inst_120213)){
var statearr_120280_120378 = state_120277__$1;
(statearr_120280_120378[(1)] = (23));

} else {
var statearr_120281_120379 = state_120277__$1;
(statearr_120281_120379[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120278 === (27))){
var inst_120204 = (state_120277[(7)]);
var state_120277__$1 = state_120277;
var statearr_120282_120380 = state_120277__$1;
(statearr_120282_120380[(2)] = inst_120204);

(statearr_120282_120380[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120278 === (1))){
var state_120277__$1 = state_120277;
var statearr_120283_120381 = state_120277__$1;
(statearr_120283_120381[(2)] = null);

(statearr_120283_120381[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120278 === (24))){
var state_120277__$1 = state_120277;
var statearr_120284_120382 = state_120277__$1;
(statearr_120284_120382[(2)] = false);

(statearr_120284_120382[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120278 === (39))){
var inst_120252 = (state_120277[(8)]);
var state_120277__$1 = state_120277;
var statearr_120285_120383 = state_120277__$1;
(statearr_120285_120383[(2)] = inst_120252);

(statearr_120285_120383[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120278 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_120277,(3),Error,null,(2));
var inst_120077 = (function (){return ((function (_,state_val_120278,c__99059__auto__){
return (function (p1__120072_SHARP_){
return p1__120072_SHARP_.t;
});
;})(_,state_val_120278,c__99059__auto__))
})();
var inst_120078 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_120077,resp);
var inst_120079 = cljs.core.set(inst_120078);
var inst_120162 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_120163 = (function (){var ts = inst_120079;
var c__99059__auto____$1 = inst_120162;
return ((function (ts,c__99059__auto____$1,_,inst_120077,inst_120078,inst_120079,inst_120162,state_val_120278,c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (ts,c__99059__auto____$1,_,inst_120077,inst_120078,inst_120079,inst_120162,state_val_120278,c__99059__auto__){
return (function (state_120160){
var state_val_120161 = (state_120160[(1)]);
if((state_val_120161 === (7))){
var inst_120104 = (state_120160[(7)]);
var inst_120098 = (state_120160[(8)]);
var inst_120092 = (state_120160[(9)]);
var inst_120103 = (state_120160[(2)]);
var inst_120104__$1 = fluree.db.util.async.throw_err(inst_120103);
var inst_120106 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_120107 = [inst_120098,cljs.core.cst$kw$block];
var inst_120108 = (new cljs.core.PersistentVector(null,2,(5),inst_120106,inst_120107,null));
var inst_120109 = cljs.core.assoc_in(inst_120092,inst_120108,inst_120104__$1);
var state_120160__$1 = (function (){var statearr_120286 = state_120160;
(statearr_120286[(7)] = inst_120104__$1);

(statearr_120286[(10)] = inst_120109);

return statearr_120286;
})();
if(cljs.core.truth_(auth)){
var statearr_120287_120384 = state_120160__$1;
(statearr_120287_120384[(1)] = (8));

} else {
var statearr_120288_120385 = state_120160__$1;
(statearr_120288_120385[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120161 === (1))){
var inst_120087 = cljs.core.seq(ts);
var inst_120088 = cljs.core.first(inst_120087);
var inst_120089 = cljs.core.next(inst_120087);
var inst_120090 = cljs.core.PersistentHashMap.EMPTY;
var inst_120091 = ts;
var inst_120092 = inst_120090;
var state_120160__$1 = (function (){var statearr_120289 = state_120160;
(statearr_120289[(11)] = inst_120091);

(statearr_120289[(9)] = inst_120092);

(statearr_120289[(12)] = inst_120089);

(statearr_120289[(13)] = inst_120088);

return statearr_120289;
})();
var statearr_120290_120386 = state_120160__$1;
(statearr_120290_120386[(2)] = null);

(statearr_120290_120386[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120161 === (4))){
var inst_120098 = (state_120160[(8)]);
var inst_120101 = fluree.db.time_travel.non_border_t_to_block(db,inst_120098);
var state_120160__$1 = state_120160;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_120160__$1,(7),inst_120101);
} else {
if((state_val_120161 === (13))){
var inst_120099 = (state_120160[(14)]);
var inst_120152 = (state_120160[(2)]);
var inst_120091 = inst_120099;
var inst_120092 = inst_120152;
var state_120160__$1 = (function (){var statearr_120291 = state_120160;
(statearr_120291[(11)] = inst_120091);

(statearr_120291[(9)] = inst_120092);

return statearr_120291;
})();
var statearr_120292_120387 = state_120160__$1;
(statearr_120292_120387[(2)] = null);

(statearr_120292_120387[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120161 === (6))){
var inst_120156 = (state_120160[(2)]);
var state_120160__$1 = state_120160;
var statearr_120293_120388 = state_120160__$1;
(statearr_120293_120388[(2)] = inst_120156);

(statearr_120293_120388[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120161 === (3))){
var inst_120158 = (state_120160[(2)]);
var state_120160__$1 = state_120160;
return cljs.core.async.impl.ioc_helpers.return_chan(state_120160__$1,inst_120158);
} else {
if((state_val_120161 === (12))){
var inst_120109 = (state_120160[(10)]);
var state_120160__$1 = state_120160;
var statearr_120294_120389 = state_120160__$1;
(statearr_120294_120389[(2)] = inst_120109);

(statearr_120294_120389[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120161 === (2))){
var inst_120091 = (state_120160[(11)]);
var inst_120098 = (state_120160[(8)]);
var inst_120097 = cljs.core.seq(inst_120091);
var inst_120098__$1 = cljs.core.first(inst_120097);
var inst_120099 = cljs.core.next(inst_120097);
var state_120160__$1 = (function (){var statearr_120295 = state_120160;
(statearr_120295[(14)] = inst_120099);

(statearr_120295[(8)] = inst_120098__$1);

return statearr_120295;
})();
if(cljs.core.truth_(inst_120098__$1)){
var statearr_120296_120390 = state_120160__$1;
(statearr_120296_120390[(1)] = (4));

} else {
var statearr_120297_120391 = state_120160__$1;
(statearr_120297_120391[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120161 === (11))){
var inst_120099 = (state_120160[(14)]);
var inst_120104 = (state_120160[(7)]);
var inst_120091 = (state_120160[(11)]);
var inst_120109 = (state_120160[(10)]);
var inst_120098 = (state_120160[(8)]);
var inst_120092 = (state_120160[(9)]);
var inst_120089 = (state_120160[(12)]);
var inst_120088 = (state_120160[(13)]);
var inst_120115 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_120116 = [inst_120098,cljs.core.cst$kw$auth];
var inst_120117 = (new cljs.core.PersistentVector(null,2,(5),inst_120115,inst_120116,null));
var inst_120127 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_120128 = (function (){var first__120096 = inst_120098;
var t = inst_120098;
var seq__120095 = inst_120099;
var block = inst_120104;
var r = inst_120099;
var first__120086 = inst_120088;
var vec__120094 = inst_120091;
var acc = inst_120092;
var vec__120084 = ts;
var c__99059__auto____$2 = inst_120127;
var G__120105 = inst_120109;
var G__120083 = inst_120091;
var seq__120085 = inst_120089;
return ((function (first__120096,t,seq__120095,block,r,first__120086,vec__120094,acc,vec__120084,c__99059__auto____$2,G__120105,G__120083,seq__120085,inst_120099,inst_120104,inst_120091,inst_120109,inst_120098,inst_120092,inst_120089,inst_120088,inst_120115,inst_120116,inst_120117,inst_120127,state_val_120161,ts,c__99059__auto____$1,_,inst_120077,inst_120078,inst_120079,inst_120162,state_val_120278,c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (first__120096,t,seq__120095,block,r,first__120086,vec__120094,acc,vec__120084,c__99059__auto____$2,G__120105,G__120083,seq__120085,inst_120099,inst_120104,inst_120091,inst_120109,inst_120098,inst_120092,inst_120089,inst_120088,inst_120115,inst_120116,inst_120117,inst_120127,state_val_120161,ts,c__99059__auto____$1,_,inst_120077,inst_120078,inst_120079,inst_120162,state_val_120278,c__99059__auto__){
return (function (state_120125){
var state_val_120126 = (state_120125[(1)]);
if((state_val_120126 === (1))){
var state_120125__$1 = state_120125;
var statearr_120298_120392 = state_120125__$1;
(statearr_120298_120392[(2)] = null);

(statearr_120298_120392[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120126 === (2))){
var inst_120123 = (state_120125[(2)]);
var state_120125__$1 = state_120125;
return cljs.core.async.impl.ioc_helpers.return_chan(state_120125__$1,inst_120123);
} else {
if((state_val_120126 === (3))){
var inst_120118 = (state_120125[(2)]);
var state_120125__$1 = state_120125;
var statearr_120299_120393 = state_120125__$1;
(statearr_120299_120393[(2)] = inst_120118);


cljs.core.async.impl.ioc_helpers.process_exception(state_120125__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_120126 === (4))){
var ___$1 = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_120125,(3),Error,null,(2));
var state_120125__$1 = state_120125;
var statearr_120300_120394 = state_120125__$1;
(statearr_120300_120394[(2)] = db);


cljs.core.async.impl.ioc_helpers.process_exception(state_120125__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
});})(first__120096,t,seq__120095,block,r,first__120086,vec__120094,acc,vec__120084,c__99059__auto____$2,G__120105,G__120083,seq__120085,inst_120099,inst_120104,inst_120091,inst_120109,inst_120098,inst_120092,inst_120089,inst_120088,inst_120115,inst_120116,inst_120117,inst_120127,state_val_120161,ts,c__99059__auto____$1,_,inst_120077,inst_120078,inst_120079,inst_120162,state_val_120278,c__99059__auto__))
;
return ((function (switch__99036__auto__,first__120096,t,seq__120095,block,r,first__120086,vec__120094,acc,vec__120084,c__99059__auto____$2,G__120105,G__120083,seq__120085,inst_120099,inst_120104,inst_120091,inst_120109,inst_120098,inst_120092,inst_120089,inst_120088,inst_120115,inst_120116,inst_120117,inst_120127,state_val_120161,ts,c__99059__auto____$1,_,inst_120077,inst_120078,inst_120079,inst_120162,state_val_120278,c__99059__auto__){
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__99037__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__99037__auto____0 = (function (){
var statearr_120301 = [null,null,null,null,null,null,null];
(statearr_120301[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__99037__auto__);

(statearr_120301[(1)] = (1));

return statearr_120301;
});
var fluree$db$api$query$format_history_resp_$_state_machine__99037__auto____1 = (function (state_120125){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_120125);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e120302){if((e120302 instanceof Object)){
var ex__99040__auto__ = e120302;
var statearr_120303_120395 = state_120125;
(statearr_120303_120395[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_120125);

return cljs.core.cst$kw$recur;
} else {
throw e120302;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__120396 = state_120125;
state_120125 = G__120396;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__99037__auto__ = function(state_120125){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__99037__auto____1.call(this,state_120125);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__99037__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__99037__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,first__120096,t,seq__120095,block,r,first__120086,vec__120094,acc,vec__120084,c__99059__auto____$2,G__120105,G__120083,seq__120085,inst_120099,inst_120104,inst_120091,inst_120109,inst_120098,inst_120092,inst_120089,inst_120088,inst_120115,inst_120116,inst_120117,inst_120127,state_val_120161,ts,c__99059__auto____$1,_,inst_120077,inst_120078,inst_120079,inst_120162,state_val_120278,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_120304 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_120304[(6)] = c__99059__auto____$2);

return statearr_120304;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});
;})(first__120096,t,seq__120095,block,r,first__120086,vec__120094,acc,vec__120084,c__99059__auto____$2,G__120105,G__120083,seq__120085,inst_120099,inst_120104,inst_120091,inst_120109,inst_120098,inst_120092,inst_120089,inst_120088,inst_120115,inst_120116,inst_120117,inst_120127,state_val_120161,ts,c__99059__auto____$1,_,inst_120077,inst_120078,inst_120079,inst_120162,state_val_120278,c__99059__auto__))
})();
var inst_120129 = cljs.core.async.impl.dispatch.run(inst_120128);
var inst_120130 = [cljs.core.cst$kw$selectOne,cljs.core.cst$kw$where];
var inst_120131 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_120132 = ["?auth","?id"];
var inst_120133 = (new cljs.core.PersistentVector(null,2,(5),inst_120131,inst_120132,null));
var inst_120134 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_120135 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_120136 = [inst_120098,"_tx/auth","?auth"];
var inst_120137 = (new cljs.core.PersistentVector(null,3,(5),inst_120135,inst_120136,null));
var inst_120138 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_120139 = ["?auth","_auth/id","?id"];
var inst_120140 = (new cljs.core.PersistentVector(null,3,(5),inst_120138,inst_120139,null));
var inst_120141 = [inst_120137,inst_120140];
var inst_120142 = (new cljs.core.PersistentVector(null,2,(5),inst_120134,inst_120141,null));
var inst_120143 = [inst_120133,inst_120142];
var inst_120144 = cljs.core.PersistentHashMap.fromArrays(inst_120130,inst_120143);
var inst_120145 = (fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2(inst_120127,inst_120144) : fluree.db.api.query.query_async.call(null,inst_120127,inst_120144));
var state_120160__$1 = (function (){var statearr_120305 = state_120160;
(statearr_120305[(15)] = inst_120129);

(statearr_120305[(16)] = inst_120117);

return statearr_120305;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_120160__$1,(14),inst_120145);
} else {
if((state_val_120161 === (9))){
var state_120160__$1 = state_120160;
var statearr_120306_120397 = state_120160__$1;
(statearr_120306_120397[(2)] = show_auth);

(statearr_120306_120397[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120161 === (5))){
var inst_120092 = (state_120160[(9)]);
var state_120160__$1 = state_120160;
var statearr_120307_120398 = state_120160__$1;
(statearr_120307_120398[(2)] = inst_120092);

(statearr_120307_120398[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120161 === (14))){
var inst_120109 = (state_120160[(10)]);
var inst_120117 = (state_120160[(16)]);
var inst_120147 = (state_120160[(2)]);
var inst_120148 = fluree.db.util.async.throw_err(inst_120147);
var inst_120149 = cljs.core.assoc_in(inst_120109,inst_120117,inst_120148);
var state_120160__$1 = state_120160;
var statearr_120308_120399 = state_120160__$1;
(statearr_120308_120399[(2)] = inst_120149);

(statearr_120308_120399[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120161 === (10))){
var inst_120113 = (state_120160[(2)]);
var state_120160__$1 = state_120160;
if(cljs.core.truth_(inst_120113)){
var statearr_120309_120400 = state_120160__$1;
(statearr_120309_120400[(1)] = (11));

} else {
var statearr_120310_120401 = state_120160__$1;
(statearr_120310_120401[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120161 === (8))){
var state_120160__$1 = state_120160;
var statearr_120311_120402 = state_120160__$1;
(statearr_120311_120402[(2)] = auth);

(statearr_120311_120402[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(ts,c__99059__auto____$1,_,inst_120077,inst_120078,inst_120079,inst_120162,state_val_120278,c__99059__auto__))
;
return ((function (switch__99036__auto__,ts,c__99059__auto____$1,_,inst_120077,inst_120078,inst_120079,inst_120162,state_val_120278,c__99059__auto__){
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__99037__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__99037__auto____0 = (function (){
var statearr_120312 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_120312[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__99037__auto__);

(statearr_120312[(1)] = (1));

return statearr_120312;
});
var fluree$db$api$query$format_history_resp_$_state_machine__99037__auto____1 = (function (state_120160){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_120160);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e120313){if((e120313 instanceof Object)){
var ex__99040__auto__ = e120313;
var statearr_120314_120403 = state_120160;
(statearr_120314_120403[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_120160);

return cljs.core.cst$kw$recur;
} else {
throw e120313;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__120404 = state_120160;
state_120160 = G__120404;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__99037__auto__ = function(state_120160){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__99037__auto____1.call(this,state_120160);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__99037__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__99037__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,ts,c__99059__auto____$1,_,inst_120077,inst_120078,inst_120079,inst_120162,state_val_120278,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_120315 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_120315[(6)] = c__99059__auto____$1);

return statearr_120315;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});
;})(ts,c__99059__auto____$1,_,inst_120077,inst_120078,inst_120079,inst_120162,state_val_120278,c__99059__auto__))
})();
var inst_120164 = cljs.core.async.impl.dispatch.run(inst_120163);
var state_120277__$1 = (function (){var statearr_120316 = state_120277;
(statearr_120316[(9)] = inst_120164);

return statearr_120316;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_120277__$1,(5),inst_120162);
} else {
if((state_val_120278 === (15))){
var inst_120186 = (state_120277[(10)]);
var state_120277__$1 = state_120277;
if(cljs.core.truth_(inst_120186)){
var statearr_120317_120405 = state_120277__$1;
(statearr_120317_120405[(1)] = (17));

} else {
var statearr_120318_120406 = state_120277__$1;
(statearr_120318_120406[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120278 === (21))){
var state_120277__$1 = state_120277;
var statearr_120319_120407 = state_120277__$1;
(statearr_120319_120407[(2)] = false);

(statearr_120319_120407[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120278 === (31))){
var inst_120236 = (state_120277[(2)]);
var state_120277__$1 = (function (){var statearr_120320 = state_120277;
(statearr_120320[(11)] = inst_120236);

return statearr_120320;
})();
var statearr_120321_120408 = state_120277__$1;
(statearr_120321_120408[(1)] = (32));



return cljs.core.cst$kw$recur;
} else {
if((state_val_120278 === (32))){
var inst_120186 = (state_120277[(10)]);
var inst_120236 = (state_120277[(11)]);
var inst_120226 = (state_120277[(12)]);
var inst_120238 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_120239 = [inst_120226,cljs.core.cst$kw$flakes];
var inst_120240 = (new cljs.core.PersistentVector(null,2,(5),inst_120238,inst_120239,null));
var inst_120241 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_120236,inst_120240,cljs.core.conj,inst_120186);
var state_120277__$1 = state_120277;
var statearr_120323_120409 = state_120277__$1;
(statearr_120323_120409[(2)] = inst_120241);

(statearr_120323_120409[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120278 === (40))){
var inst_120187 = (state_120277[(13)]);
var inst_120260 = (state_120277[(2)]);
var inst_120179 = inst_120187;
var inst_120180 = inst_120260;
var state_120277__$1 = (function (){var statearr_120324 = state_120277;
(statearr_120324[(14)] = inst_120180);

(statearr_120324[(15)] = inst_120179);

return statearr_120324;
})();
var statearr_120325_120410 = state_120277__$1;
(statearr_120325_120410[(2)] = null);

(statearr_120325_120410[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120278 === (33))){
var inst_120236 = (state_120277[(11)]);
var state_120277__$1 = state_120277;
var statearr_120326_120411 = state_120277__$1;
(statearr_120326_120411[(2)] = inst_120236);

(statearr_120326_120411[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120278 === (13))){
var inst_120194 = (state_120277[(2)]);
var state_120277__$1 = state_120277;
var statearr_120327_120412 = state_120277__$1;
(statearr_120327_120412[(2)] = inst_120194);

(statearr_120327_120412[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120278 === (22))){
var inst_120220 = (state_120277[(2)]);
var state_120277__$1 = state_120277;
if(cljs.core.truth_(inst_120220)){
var statearr_120328_120413 = state_120277__$1;
(statearr_120328_120413[(1)] = (26));

} else {
var statearr_120329_120414 = state_120277__$1;
(statearr_120329_120414[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120278 === (36))){
var inst_120244 = (state_120277[(16)]);
var state_120277__$1 = state_120277;
var statearr_120330_120415 = state_120277__$1;
(statearr_120330_120415[(2)] = inst_120244);

(statearr_120330_120415[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120278 === (41))){
var inst_120180 = (state_120277[(14)]);
var state_120277__$1 = state_120277;
var statearr_120331_120416 = state_120277__$1;
(statearr_120331_120416[(2)] = inst_120180);

(statearr_120331_120416[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120278 === (43))){
var inst_120266 = (state_120277[(2)]);
var state_120277__$1 = state_120277;
var statearr_120332_120417 = state_120277__$1;
(statearr_120332_120417[(2)] = inst_120266);

(statearr_120332_120417[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120278 === (29))){
var inst_120180 = (state_120277[(14)]);
var inst_120226 = (state_120277[(12)]);
var inst_120230 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_120231 = [inst_120226,cljs.core.cst$kw$block];
var inst_120232 = (new cljs.core.PersistentVector(null,2,(5),inst_120230,inst_120231,null));
var inst_120233 = cljs.core.assoc_in(inst_120180,inst_120232,inst_120226);
var state_120277__$1 = state_120277;
var statearr_120333_120418 = state_120277__$1;
(statearr_120333_120418[(2)] = inst_120233);

(statearr_120333_120418[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120278 === (6))){
var inst_120186 = (state_120277[(10)]);
var inst_120179 = (state_120277[(15)]);
var inst_120185 = cljs.core.seq(inst_120179);
var inst_120186__$1 = cljs.core.first(inst_120185);
var inst_120187 = cljs.core.next(inst_120185);
var state_120277__$1 = (function (){var statearr_120334 = state_120277;
(statearr_120334[(10)] = inst_120186__$1);

(statearr_120334[(13)] = inst_120187);

return statearr_120334;
})();
if(cljs.core.truth_(inst_120186__$1)){
var statearr_120335_120419 = state_120277__$1;
(statearr_120335_120419[(1)] = (8));

} else {
var statearr_120336_120420 = state_120277__$1;
(statearr_120336_120420[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120278 === (28))){
var inst_120225 = (state_120277[(2)]);
var inst_120226 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_120225,cljs.core.cst$kw$block);
var inst_120227 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_120225,cljs.core.cst$kw$auth);
var state_120277__$1 = (function (){var statearr_120337 = state_120277;
(statearr_120337[(17)] = inst_120227);

(statearr_120337[(12)] = inst_120226);

return statearr_120337;
})();
var statearr_120338_120421 = state_120277__$1;
(statearr_120338_120421[(1)] = (29));



return cljs.core.cst$kw$recur;
} else {
if((state_val_120278 === (25))){
var inst_120217 = (state_120277[(2)]);
var state_120277__$1 = state_120277;
var statearr_120340_120422 = state_120277__$1;
(statearr_120340_120422[(2)] = inst_120217);

(statearr_120340_120422[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120278 === (34))){
var inst_120244 = (state_120277[(2)]);
var state_120277__$1 = (function (){var statearr_120341 = state_120277;
(statearr_120341[(16)] = inst_120244);

return statearr_120341;
})();
var statearr_120342_120423 = state_120277__$1;
(statearr_120342_120423[(1)] = (35));



return cljs.core.cst$kw$recur;
} else {
if((state_val_120278 === (17))){
var inst_120186 = (state_120277[(10)]);
var inst_120204 = (state_120277[(7)]);
var inst_120203 = (state_120277[(18)]);
var inst_120167 = (state_120277[(19)]);
var inst_120203__$1 = inst_120186.t;
var inst_120204__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_120167,inst_120203__$1);
var inst_120206 = (inst_120204__$1 == null);
var inst_120207 = cljs.core.not(inst_120206);
var state_120277__$1 = (function (){var statearr_120344 = state_120277;
(statearr_120344[(7)] = inst_120204__$1);

(statearr_120344[(18)] = inst_120203__$1);

return statearr_120344;
})();
if(inst_120207){
var statearr_120345_120424 = state_120277__$1;
(statearr_120345_120424[(1)] = (20));

} else {
var statearr_120346_120425 = state_120277__$1;
(statearr_120346_120425[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120278 === (3))){
var inst_120073 = (state_120277[(2)]);
var state_120277__$1 = state_120277;
var statearr_120347_120426 = state_120277__$1;
(statearr_120347_120426[(2)] = inst_120073);


cljs.core.async.impl.ioc_helpers.process_exception(state_120277__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_120278 === (12))){
var state_120277__$1 = state_120277;
var statearr_120348_120427 = state_120277__$1;
(statearr_120348_120427[(2)] = auth);

(statearr_120348_120427[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120278 === (2))){
var inst_120275 = (state_120277[(2)]);
var state_120277__$1 = state_120277;
return cljs.core.async.impl.ioc_helpers.return_chan(state_120277__$1,inst_120275);
} else {
if((state_val_120278 === (23))){
var state_120277__$1 = state_120277;
var statearr_120349_120428 = state_120277__$1;
(statearr_120349_120428[(2)] = true);

(statearr_120349_120428[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120278 === (35))){
var inst_120244 = (state_120277[(16)]);
var inst_120203 = (state_120277[(18)]);
var inst_120226 = (state_120277[(12)]);
var inst_120246 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_120247 = [inst_120226,cljs.core.cst$kw$t];
var inst_120248 = (new cljs.core.PersistentVector(null,2,(5),inst_120246,inst_120247,null));
var inst_120249 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_120244,inst_120248,fluree.db.api.query.min_safe,inst_120203);
var state_120277__$1 = state_120277;
var statearr_120350_120429 = state_120277__$1;
(statearr_120350_120429[(2)] = inst_120249);

(statearr_120350_120429[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120278 === (19))){
var inst_120268 = (state_120277[(2)]);
var state_120277__$1 = state_120277;
var statearr_120351_120430 = state_120277__$1;
(statearr_120351_120430[(2)] = inst_120268);

(statearr_120351_120430[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120278 === (11))){
var inst_120186 = (state_120277[(10)]);
var inst_120167 = (state_120277[(19)]);
var inst_120190 = fluree.db.api.query.auth_match(auth,inst_120167,inst_120186);
var inst_120191 = cljs.core.not(inst_120190);
var state_120277__$1 = state_120277;
var statearr_120352_120431 = state_120277__$1;
(statearr_120352_120431[(2)] = inst_120191);

(statearr_120352_120431[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120278 === (9))){
var inst_120186 = (state_120277[(10)]);
var state_120277__$1 = state_120277;
var statearr_120354_120432 = state_120277__$1;
(statearr_120354_120432[(2)] = inst_120186);

(statearr_120354_120432[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120278 === (5))){
var inst_120166 = (state_120277[(2)]);
var inst_120167 = fluree.db.util.async.throw_err(inst_120166);
var inst_120175 = cljs.core.seq(resp);
var inst_120176 = cljs.core.first(inst_120175);
var inst_120177 = cljs.core.next(inst_120175);
var inst_120178 = cljs.core.PersistentHashMap.EMPTY;
var inst_120179 = resp;
var inst_120180 = inst_120178;
var state_120277__$1 = (function (){var statearr_120355 = state_120277;
(statearr_120355[(20)] = inst_120176);

(statearr_120355[(14)] = inst_120180);

(statearr_120355[(21)] = inst_120177);

(statearr_120355[(19)] = inst_120167);

(statearr_120355[(15)] = inst_120179);

return statearr_120355;
})();
var statearr_120356_120433 = state_120277__$1;
(statearr_120356_120433[(2)] = null);

(statearr_120356_120433[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120278 === (14))){
var inst_120180 = (state_120277[(14)]);
var inst_120187 = (state_120277[(13)]);
var tmp120353 = inst_120180;
var inst_120179 = inst_120187;
var inst_120180__$1 = tmp120353;
var state_120277__$1 = (function (){var statearr_120357 = state_120277;
(statearr_120357[(14)] = inst_120180__$1);

(statearr_120357[(15)] = inst_120179);

return statearr_120357;
})();
var statearr_120358_120434 = state_120277__$1;
(statearr_120358_120434[(2)] = null);

(statearr_120358_120434[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120278 === (26))){
var inst_120204 = (state_120277[(7)]);
var inst_120222 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_120204);
var state_120277__$1 = state_120277;
var statearr_120359_120435 = state_120277__$1;
(statearr_120359_120435[(2)] = inst_120222);

(statearr_120359_120435[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120278 === (16))){
var inst_120270 = (state_120277[(2)]);
var state_120277__$1 = state_120277;
var statearr_120360_120436 = state_120277__$1;
(statearr_120360_120436[(2)] = inst_120270);

(statearr_120360_120436[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120278 === (38))){
var inst_120252 = (state_120277[(8)]);
var inst_120227 = (state_120277[(17)]);
var inst_120226 = (state_120277[(12)]);
var inst_120254 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_120255 = [inst_120226,cljs.core.cst$kw$auth];
var inst_120256 = (new cljs.core.PersistentVector(null,2,(5),inst_120254,inst_120255,null));
var inst_120257 = cljs.core.assoc_in(inst_120252,inst_120256,inst_120227);
var state_120277__$1 = state_120277;
var statearr_120361_120437 = state_120277__$1;
(statearr_120361_120437[(2)] = inst_120257);

(statearr_120361_120437[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120278 === (30))){
var inst_120180 = (state_120277[(14)]);
var state_120277__$1 = state_120277;
var statearr_120362_120438 = state_120277__$1;
(statearr_120362_120438[(2)] = inst_120180);

(statearr_120362_120438[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120278 === (10))){
var inst_120197 = (state_120277[(2)]);
var state_120277__$1 = state_120277;
if(cljs.core.truth_(inst_120197)){
var statearr_120363_120439 = state_120277__$1;
(statearr_120363_120439[(1)] = (14));

} else {
var statearr_120364_120440 = state_120277__$1;
(statearr_120364_120440[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120278 === (18))){
var state_120277__$1 = state_120277;
var statearr_120365_120441 = state_120277__$1;
(statearr_120365_120441[(1)] = (41));



return cljs.core.cst$kw$recur;
} else {
if((state_val_120278 === (42))){
var state_120277__$1 = state_120277;
var statearr_120367_120442 = state_120277__$1;
(statearr_120367_120442[(2)] = null);

(statearr_120367_120442[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120278 === (37))){
var inst_120252 = (state_120277[(2)]);
var state_120277__$1 = (function (){var statearr_120368 = state_120277;
(statearr_120368[(8)] = inst_120252);

return statearr_120368;
})();
if(cljs.core.truth_(show_auth)){
var statearr_120369_120443 = state_120277__$1;
(statearr_120369_120443[(1)] = (38));

} else {
var statearr_120370_120444 = state_120277__$1;
(statearr_120370_120444[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120278 === (8))){
var state_120277__$1 = state_120277;
if(cljs.core.truth_(auth)){
var statearr_120371_120445 = state_120277__$1;
(statearr_120371_120445[(1)] = (11));

} else {
var statearr_120372_120446 = state_120277__$1;
(statearr_120372_120446[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__99037__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__99037__auto____0 = (function (){
var statearr_120373 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_120373[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__99037__auto__);

(statearr_120373[(1)] = (1));

return statearr_120373;
});
var fluree$db$api$query$format_history_resp_$_state_machine__99037__auto____1 = (function (state_120277){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_120277);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e120374){if((e120374 instanceof Object)){
var ex__99040__auto__ = e120374;
var statearr_120375_120447 = state_120277;
(statearr_120375_120447[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_120277);

return cljs.core.cst$kw$recur;
} else {
throw e120374;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__120448 = state_120277;
state_120277 = G__120448;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__99037__auto__ = function(state_120277){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__99037__auto____1.call(this,state_120277);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__99037__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__99037__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_120376 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_120376[(6)] = c__99059__auto__);

return statearr_120376;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
fluree.db.api.query.history_query_async = (function fluree$db$api$query$history_query_async(sources,query_map){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_120604){
var state_val_120605 = (state_120604[(1)]);
if((state_val_120605 === (7))){
var inst_120472 = (state_120604[(2)]);
var state_120604__$1 = state_120604;
if(cljs.core.truth_(inst_120472)){
var statearr_120606_120684 = state_120604__$1;
(statearr_120606_120684[(1)] = (11));

} else {
var statearr_120607_120685 = state_120604__$1;
(statearr_120607_120685[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (20))){
var inst_120478 = (state_120604[(7)]);
var inst_120502 = (state_120604[(2)]);
var state_120604__$1 = (function (){var statearr_120608 = state_120604;
(statearr_120608[(8)] = inst_120502);

return statearr_120608;
})();
if(cljs.core.truth_(inst_120478)){
var statearr_120609_120686 = state_120604__$1;
(statearr_120609_120686[(1)] = (21));

} else {
var statearr_120610_120687 = state_120604__$1;
(statearr_120610_120687[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (27))){
var inst_120600 = (state_120604[(2)]);
var state_120604__$1 = state_120604;
var statearr_120611_120688 = state_120604__$1;
(statearr_120611_120688[(2)] = inst_120600);


cljs.core.async.impl.ioc_helpers.process_exception(state_120604__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (1))){
var state_120604__$1 = state_120604;
var statearr_120612_120689 = state_120604__$1;
(statearr_120612_120689[(2)] = null);

(statearr_120612_120689[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (24))){
var inst_120506 = (state_120604[(2)]);
var inst_120507 = fluree.db.util.async.throw_err(inst_120506);
var state_120604__$1 = state_120604;
var statearr_120613_120690 = state_120604__$1;
(statearr_120613_120690[(2)] = inst_120507);

(statearr_120613_120690[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (55))){
var inst_120582 = (state_120604[(9)]);
var state_120604__$1 = state_120604;
var statearr_120614_120691 = state_120604__$1;
(statearr_120614_120691[(2)] = inst_120582);

(statearr_120614_120691[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (39))){
var inst_120484 = (state_120604[(10)]);
var inst_120556 = (state_120604[(2)]);
var inst_120557 = fluree.db.util.async.throw_err(inst_120556);
var state_120604__$1 = (function (){var statearr_120615 = state_120604;
(statearr_120615[(11)] = inst_120557);

return statearr_120615;
})();
if(cljs.core.truth_(inst_120484)){
var statearr_120616_120692 = state_120604__$1;
(statearr_120616_120692[(1)] = (40));

} else {
var statearr_120617_120693 = state_120604__$1;
(statearr_120617_120693[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (46))){
var inst_120562 = (state_120604[(12)]);
var inst_120488 = (state_120604[(13)]);
var inst_120557 = (state_120604[(11)]);
var inst_120566 = (state_120604[(2)]);
var inst_120567 = fluree.db.api.query.format_history_resp(inst_120488,inst_120557,inst_120562,inst_120566);
var state_120604__$1 = state_120604;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_120604__$1,(43),inst_120567);
} else {
if((state_val_120605 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_120604,(3),Error,null,(2));
var inst_120458 = (query_map == null);
var inst_120459 = cljs.core.not(inst_120458);
var state_120604__$1 = state_120604;
if(inst_120459){
var statearr_120618_120694 = state_120604__$1;
(statearr_120618_120694[(1)] = (5));

} else {
var statearr_120619_120695 = state_120604__$1;
(statearr_120619_120695[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (54))){
var inst_120582 = (state_120604[(9)]);
var inst_120557 = (state_120604[(11)]);
var inst_120584 = [cljs.core.cst$kw$result,cljs.core.cst$kw$fuel,cljs.core.cst$kw$status];
var inst_120585 = cljs.core.count(inst_120557);
var inst_120586 = [inst_120582,inst_120585,(200)];
var inst_120587 = cljs.core.PersistentHashMap.fromArrays(inst_120584,inst_120586);
var state_120604__$1 = state_120604;
var statearr_120620_120696 = state_120604__$1;
(statearr_120620_120696[(2)] = inst_120587);

(statearr_120620_120696[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (15))){
var inst_120490 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_120491 = ["The pretty-print key should be rename `prettyPrint`. `pretty-print` is being deprecated. Provided: ",inst_120490].join('');
var inst_120492 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_120491], 0));
var state_120604__$1 = state_120604;
var statearr_120621_120697 = state_120604__$1;
(statearr_120621_120697[(2)] = inst_120492);

(statearr_120621_120697[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (48))){
var inst_120480 = (state_120604[(14)]);
var state_120604__$1 = state_120604;
var statearr_120622_120698 = state_120604__$1;
(statearr_120622_120698[(2)] = inst_120480);

(statearr_120622_120698[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (50))){
var inst_120488 = (state_120604[(13)]);
var inst_120570 = (state_120604[(15)]);
var inst_120576 = fluree.db.api.query.format_blocks_resp_pretty(inst_120488,inst_120570);
var state_120604__$1 = state_120604;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_120604__$1,(53),inst_120576);
} else {
if((state_val_120605 === (21))){
var inst_120488 = (state_120604[(13)]);
var inst_120504 = fluree.db.api.query.resolve_block_range(inst_120488,query_map);
var state_120604__$1 = state_120604;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_120604__$1,(24),inst_120504);
} else {
if((state_val_120605 === (31))){
var inst_120488 = (state_120604[(13)]);
var inst_120511 = (state_120604[(16)]);
var inst_120528 = (inst_120511 - (1));
var inst_120529 = fluree.db.time_travel.as_of_block(inst_120488,inst_120528);
var state_120604__$1 = state_120604;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_120604__$1,(34),inst_120529);
} else {
if((state_val_120605 === (32))){
var state_120604__$1 = state_120604;
var statearr_120623_120699 = state_120604__$1;
(statearr_120623_120699[(2)] = (-1));

(statearr_120623_120699[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (40))){
var inst_120484 = (state_120604[(10)]);
var inst_120559 = cljs.core.set(inst_120484);
var state_120604__$1 = state_120604;
var statearr_120624_120700 = state_120604__$1;
(statearr_120624_120700[(2)] = inst_120559);

(statearr_120624_120700[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (56))){
var inst_120590 = (state_120604[(2)]);
var state_120604__$1 = state_120604;
var statearr_120625_120701 = state_120604__$1;
(statearr_120625_120701[(2)] = inst_120590);

(statearr_120625_120701[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (33))){
var inst_120512 = (state_120604[(17)]);
var inst_120537 = (state_120604[(2)]);
var state_120604__$1 = (function (){var statearr_120626 = state_120604;
(statearr_120626[(18)] = inst_120537);

return statearr_120626;
})();
if(cljs.core.truth_(inst_120512)){
var statearr_120627_120702 = state_120604__$1;
(statearr_120627_120702[(1)] = (35));

} else {
var statearr_120628_120703 = state_120604__$1;
(statearr_120628_120703[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (13))){
var inst_120477 = (state_120604[(2)]);
var inst_120478 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_120477,cljs.core.cst$kw$block);
var inst_120479 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_120477,cljs.core.cst$kw$history);
var inst_120480 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_120477,cljs.core.cst$kw$pretty_DASH_print);
var inst_120481 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_120477,cljs.core.cst$kw$prettyPrint);
var inst_120482 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_120477,cljs.core.cst$kw$show_DASH_auth);
var inst_120483 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_120477,cljs.core.cst$kw$showAuth);
var inst_120484 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_120477,cljs.core.cst$kw$auth);
var inst_120485 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_120477,cljs.core.cst$kw$opts);
var state_120604__$1 = (function (){var statearr_120629 = state_120604;
(statearr_120629[(14)] = inst_120480);

(statearr_120629[(19)] = inst_120483);

(statearr_120629[(20)] = inst_120482);

(statearr_120629[(21)] = inst_120485);

(statearr_120629[(22)] = inst_120481);

(statearr_120629[(7)] = inst_120478);

(statearr_120629[(23)] = inst_120479);

(statearr_120629[(10)] = inst_120484);

return statearr_120629;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_120604__$1,(14),sources);
} else {
if((state_val_120605 === (22))){
var state_120604__$1 = state_120604;
var statearr_120630_120704 = state_120604__$1;
(statearr_120630_120704[(2)] = null);

(statearr_120630_120704[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (36))){
var inst_120488 = (state_120604[(13)]);
var inst_120545 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_120488);
var state_120604__$1 = state_120604;
var statearr_120631_120705 = state_120604__$1;
(statearr_120631_120705[(2)] = inst_120545);

(statearr_120631_120705[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (41))){
var state_120604__$1 = state_120604;
var statearr_120632_120706 = state_120604__$1;
(statearr_120632_120706[(2)] = null);

(statearr_120632_120706[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (43))){
var inst_120481 = (state_120604[(22)]);
var inst_120569 = (state_120604[(2)]);
var inst_120570 = fluree.db.util.async.throw_err(inst_120569);
var state_120604__$1 = (function (){var statearr_120633 = state_120604;
(statearr_120633[(15)] = inst_120570);

return statearr_120633;
})();
if(cljs.core.truth_(inst_120481)){
var statearr_120634_120707 = state_120604__$1;
(statearr_120634_120707[(1)] = (47));

} else {
var statearr_120635_120708 = state_120604__$1;
(statearr_120635_120708[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (29))){
var inst_120511 = (state_120604[(16)]);
var state_120604__$1 = state_120604;
var statearr_120636_120709 = state_120604__$1;
(statearr_120636_120709[(2)] = inst_120511);

(statearr_120636_120709[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (44))){
var inst_120483 = (state_120604[(19)]);
var state_120604__$1 = state_120604;
var statearr_120637_120710 = state_120604__$1;
(statearr_120637_120710[(2)] = inst_120483);

(statearr_120637_120710[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (6))){
var state_120604__$1 = state_120604;
var statearr_120638_120711 = state_120604__$1;
(statearr_120638_120711[(2)] = false);

(statearr_120638_120711[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (28))){
var inst_120511 = (state_120604[(16)]);
var inst_120523 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_120511);
var state_120604__$1 = state_120604;
var statearr_120639_120712 = state_120604__$1;
(statearr_120639_120712[(2)] = inst_120523);

(statearr_120639_120712[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (51))){
var inst_120570 = (state_120604[(15)]);
var state_120604__$1 = state_120604;
var statearr_120640_120713 = state_120604__$1;
(statearr_120640_120713[(2)] = inst_120570);

(statearr_120640_120713[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (25))){
var inst_120485 = (state_120604[(21)]);
var inst_120511 = (state_120604[(16)]);
var inst_120521 = cljs.core.cst$kw$meta.cljs$core$IFn$_invoke$arity$1(inst_120485);
var state_120604__$1 = (function (){var statearr_120641 = state_120604;
(statearr_120641[(24)] = inst_120521);

return statearr_120641;
})();
if(cljs.core.truth_(inst_120511)){
var statearr_120642_120714 = state_120604__$1;
(statearr_120642_120714[(1)] = (28));

} else {
var statearr_120643_120715 = state_120604__$1;
(statearr_120643_120715[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (34))){
var inst_120531 = (state_120604[(2)]);
var inst_120532 = fluree.db.util.async.throw_err(inst_120531);
var inst_120533 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_120532);
var inst_120534 = (inst_120533 - (1));
var state_120604__$1 = state_120604;
var statearr_120644_120716 = state_120604__$1;
(statearr_120644_120716[(2)] = inst_120534);

(statearr_120644_120716[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (17))){
var inst_120482 = (state_120604[(20)]);
var inst_120495 = (state_120604[(2)]);
var state_120604__$1 = (function (){var statearr_120645 = state_120604;
(statearr_120645[(25)] = inst_120495);

return statearr_120645;
})();
if(cljs.core.truth_(inst_120482)){
var statearr_120646_120717 = state_120604__$1;
(statearr_120646_120717[(1)] = (18));

} else {
var statearr_120647_120718 = state_120604__$1;
(statearr_120647_120718[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (3))){
var inst_120449 = (state_120604[(2)]);
var state_120604__$1 = state_120604;
var statearr_120648_120719 = state_120604__$1;
(statearr_120648_120719[(2)] = inst_120449);


cljs.core.async.impl.ioc_helpers.process_exception(state_120604__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (12))){
var state_120604__$1 = state_120604;
var statearr_120649_120720 = state_120604__$1;
(statearr_120649_120720[(2)] = query_map);

(statearr_120649_120720[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (2))){
var inst_120602 = (state_120604[(2)]);
var state_120604__$1 = state_120604;
return cljs.core.async.impl.ioc_helpers.return_chan(state_120604__$1,inst_120602);
} else {
if((state_val_120605 === (23))){
var inst_120510 = (state_120604[(2)]);
var inst_120511 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_120510,(0),null);
var inst_120512 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_120510,(1),null);
var inst_120513 = cljs.core.list(cljs.core.cst$kw$history);
var inst_120514 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.cst$kw$block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$pretty_DASH_print,cljs.core.cst$kw$prettyPrint,cljs.core.cst$kw$auth,cljs.core.cst$kw$show_DASH_auth,cljs.core.cst$kw$showAuth,cljs.core.cst$kw$opts], 0));
var inst_120515 = cljs.core.keys(inst_120514);
var inst_120516 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_120513,inst_120515);
var state_120604__$1 = (function (){var statearr_120650 = state_120604;
(statearr_120650[(16)] = inst_120511);

(statearr_120650[(17)] = inst_120512);

return statearr_120650;
})();
if(inst_120516){
var statearr_120651_120721 = state_120604__$1;
(statearr_120651_120721[(1)] = (25));

} else {
var statearr_120652_120722 = state_120604__$1;
(statearr_120652_120722[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (47))){
var inst_120481 = (state_120604[(22)]);
var state_120604__$1 = state_120604;
var statearr_120653_120723 = state_120604__$1;
(statearr_120653_120723[(2)] = inst_120481);

(statearr_120653_120723[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (35))){
var inst_120488 = (state_120604[(13)]);
var inst_120512 = (state_120604[(17)]);
var inst_120539 = fluree.db.time_travel.as_of_block(inst_120488,inst_120512);
var state_120604__$1 = state_120604;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_120604__$1,(38),inst_120539);
} else {
if((state_val_120605 === (19))){
var state_120604__$1 = state_120604;
var statearr_120654_120724 = state_120604__$1;
(statearr_120654_120724[(2)] = null);

(statearr_120654_120724[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (11))){
var inst_120474 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,query_map);
var state_120604__$1 = state_120604;
var statearr_120655_120725 = state_120604__$1;
(statearr_120655_120725[(2)] = inst_120474);

(statearr_120655_120725[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (9))){
var state_120604__$1 = state_120604;
var statearr_120656_120726 = state_120604__$1;
(statearr_120656_120726[(2)] = false);

(statearr_120656_120726[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (5))){
var inst_120461 = query_map.cljs$lang$protocol_mask$partition0$;
var inst_120462 = (inst_120461 & (64));
var inst_120463 = query_map.cljs$core$ISeq$;
var inst_120464 = (cljs.core.PROTOCOL_SENTINEL === inst_120463);
var inst_120465 = ((inst_120462) || (inst_120464));
var state_120604__$1 = state_120604;
if(cljs.core.truth_(inst_120465)){
var statearr_120657_120727 = state_120604__$1;
(statearr_120657_120727[(1)] = (8));

} else {
var statearr_120658_120728 = state_120604__$1;
(statearr_120658_120728[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (14))){
var inst_120480 = (state_120604[(14)]);
var inst_120487 = (state_120604[(2)]);
var inst_120488 = fluree.db.util.async.throw_err(inst_120487);
var state_120604__$1 = (function (){var statearr_120659 = state_120604;
(statearr_120659[(13)] = inst_120488);

return statearr_120659;
})();
if(cljs.core.truth_(inst_120480)){
var statearr_120660_120729 = state_120604__$1;
(statearr_120660_120729[(1)] = (15));

} else {
var statearr_120661_120730 = state_120604__$1;
(statearr_120661_120730[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (45))){
var inst_120482 = (state_120604[(20)]);
var state_120604__$1 = state_120604;
var statearr_120662_120731 = state_120604__$1;
(statearr_120662_120731[(2)] = inst_120482);

(statearr_120662_120731[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (53))){
var inst_120578 = (state_120604[(2)]);
var inst_120579 = fluree.db.util.async.throw_err(inst_120578);
var state_120604__$1 = state_120604;
var statearr_120663_120732 = state_120604__$1;
(statearr_120663_120732[(2)] = inst_120579);

(statearr_120663_120732[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (26))){
var inst_120592 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_120593 = ["History query not properly formatted. Provided ",inst_120592].join('');
var inst_120594 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_120595 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_120596 = cljs.core.PersistentHashMap.fromArrays(inst_120594,inst_120595);
var inst_120597 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_120593,inst_120596);
var inst_120598 = (function(){throw inst_120597})();
var state_120604__$1 = state_120604;
var statearr_120664_120733 = state_120604__$1;
(statearr_120664_120733[(2)] = inst_120598);

(statearr_120664_120733[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (16))){
var state_120604__$1 = state_120604;
var statearr_120665_120734 = state_120604__$1;
(statearr_120665_120734[(2)] = null);

(statearr_120665_120734[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (38))){
var inst_120541 = (state_120604[(2)]);
var inst_120542 = fluree.db.util.async.throw_err(inst_120541);
var inst_120543 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_120542);
var state_120604__$1 = state_120604;
var statearr_120666_120735 = state_120604__$1;
(statearr_120666_120735[(2)] = inst_120543);

(statearr_120666_120735[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (30))){
var inst_120526 = (state_120604[(2)]);
var state_120604__$1 = state_120604;
if(cljs.core.truth_(inst_120526)){
var statearr_120667_120736 = state_120604__$1;
(statearr_120667_120736[(1)] = (31));

} else {
var statearr_120668_120737 = state_120604__$1;
(statearr_120668_120737[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (10))){
var inst_120469 = (state_120604[(2)]);
var state_120604__$1 = state_120604;
var statearr_120669_120738 = state_120604__$1;
(statearr_120669_120738[(2)] = inst_120469);

(statearr_120669_120738[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (18))){
var inst_120497 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_120498 = ["The show-auth key should be rename `showAuth`. `pretty-print` is being deprecated. Provided: ",inst_120497].join('');
var inst_120499 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_120498], 0));
var state_120604__$1 = state_120604;
var statearr_120670_120739 = state_120604__$1;
(statearr_120670_120739[(2)] = inst_120499);

(statearr_120670_120739[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (52))){
var inst_120521 = (state_120604[(24)]);
var inst_120582 = (state_120604[(2)]);
var state_120604__$1 = (function (){var statearr_120671 = state_120604;
(statearr_120671[(9)] = inst_120582);

return statearr_120671;
})();
if(cljs.core.truth_(inst_120521)){
var statearr_120672_120740 = state_120604__$1;
(statearr_120672_120740[(1)] = (54));

} else {
var statearr_120673_120741 = state_120604__$1;
(statearr_120673_120741[(1)] = (55));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (42))){
var inst_120483 = (state_120604[(19)]);
var inst_120562 = (state_120604[(2)]);
var state_120604__$1 = (function (){var statearr_120674 = state_120604;
(statearr_120674[(12)] = inst_120562);

return statearr_120674;
})();
if(cljs.core.truth_(inst_120483)){
var statearr_120675_120742 = state_120604__$1;
(statearr_120675_120742[(1)] = (44));

} else {
var statearr_120676_120743 = state_120604__$1;
(statearr_120676_120743[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (37))){
var inst_120488 = (state_120604[(13)]);
var inst_120537 = (state_120604[(18)]);
var inst_120479 = (state_120604[(23)]);
var inst_120547 = (state_120604[(2)]);
var inst_120548 = fluree.db.api.query.get_history_pattern(inst_120479);
var inst_120549 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_120548,(0),null);
var inst_120550 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_120548,(1),null);
var inst_120551 = [cljs.core.cst$kw$from_DASH_t,cljs.core.cst$kw$to_DASH_t];
var inst_120552 = [inst_120537,inst_120547];
var inst_120553 = cljs.core.PersistentHashMap.fromArrays(inst_120551,inst_120552);
var inst_120554 = fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(inst_120488,inst_120550,cljs.core._EQ_,inst_120549,inst_120553);
var state_120604__$1 = state_120604;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_120604__$1,(39),inst_120554);
} else {
if((state_val_120605 === (8))){
var state_120604__$1 = state_120604;
var statearr_120677_120744 = state_120604__$1;
(statearr_120677_120744[(2)] = true);

(statearr_120677_120744[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120605 === (49))){
var inst_120574 = (state_120604[(2)]);
var state_120604__$1 = state_120604;
if(cljs.core.truth_(inst_120574)){
var statearr_120678_120745 = state_120604__$1;
(statearr_120678_120745[(1)] = (50));

} else {
var statearr_120679_120746 = state_120604__$1;
(statearr_120679_120746[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$api$query$history_query_async_$_state_machine__99037__auto__ = null;
var fluree$db$api$query$history_query_async_$_state_machine__99037__auto____0 = (function (){
var statearr_120680 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_120680[(0)] = fluree$db$api$query$history_query_async_$_state_machine__99037__auto__);

(statearr_120680[(1)] = (1));

return statearr_120680;
});
var fluree$db$api$query$history_query_async_$_state_machine__99037__auto____1 = (function (state_120604){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_120604);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e120681){if((e120681 instanceof Object)){
var ex__99040__auto__ = e120681;
var statearr_120682_120747 = state_120604;
(statearr_120682_120747[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_120604);

return cljs.core.cst$kw$recur;
} else {
throw e120681;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__120748 = state_120604;
state_120604 = G__120748;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$api$query$history_query_async_$_state_machine__99037__auto__ = function(state_120604){
switch(arguments.length){
case 0:
return fluree$db$api$query$history_query_async_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$api$query$history_query_async_$_state_machine__99037__auto____1.call(this,state_120604);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$history_query_async_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$history_query_async_$_state_machine__99037__auto____0;
fluree$db$api$query$history_query_async_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$history_query_async_$_state_machine__99037__auto____1;
return fluree$db$api$query$history_query_async_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_120683 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_120683[(6)] = c__99059__auto__);

return statearr_120683;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns core async channel containing result.
 */
fluree.db.api.query.query_async = (function fluree$db$api$query$query_async(sources,flureeQL){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_120896){
var state_val_120897 = (state_120896[(1)]);
if((state_val_120897 === (7))){
var inst_120770 = (state_120896[(2)]);
var state_120896__$1 = state_120896;
if(cljs.core.truth_(inst_120770)){
var statearr_120898_120982 = state_120896__$1;
(statearr_120898_120982[(1)] = (11));

} else {
var statearr_120899_120983 = state_120896__$1;
(statearr_120899_120983[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (59))){
var inst_120892 = (state_120896[(2)]);
var state_120896__$1 = state_120896;
var statearr_120900_120984 = state_120896__$1;
(statearr_120900_120984[(2)] = inst_120892);


cljs.core.async.impl.ioc_helpers.process_exception(state_120896__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (20))){
var inst_120810 = (state_120896[(2)]);
var inst_120811 = fluree.db.util.async.throw_err(inst_120810);
var state_120896__$1 = state_120896;
var statearr_120901_120985 = state_120896__$1;
(statearr_120901_120985[(2)] = inst_120811);

(statearr_120901_120985[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (58))){
var inst_120882 = (state_120896[(7)]);
var state_120896__$1 = state_120896;
var statearr_120902_120986 = state_120896__$1;
(statearr_120902_120986[(2)] = inst_120882);

(statearr_120902_120986[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (27))){
var inst_120827 = (state_120896[(8)]);
var state_120896__$1 = state_120896;
var statearr_120903_120987 = state_120896__$1;
(statearr_120903_120987[(2)] = inst_120827);

(statearr_120903_120987[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (1))){
var state_120896__$1 = state_120896;
var statearr_120904_120988 = state_120896__$1;
(statearr_120904_120988[(2)] = null);

(statearr_120904_120988[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (24))){
var inst_120824 = cljs.core.PersistentHashMap.EMPTY;
var state_120896__$1 = state_120896;
var statearr_120905_120989 = state_120896__$1;
(statearr_120905_120989[(2)] = inst_120824);

(statearr_120905_120989[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (55))){
var inst_120817 = (state_120896[(9)]);
var inst_120843 = (state_120896[(10)]);
var inst_120876 = (state_120896[(2)]);
var inst_120877 = fluree.db.util.core.current_time_millis();
var inst_120878 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(flureeQL,cljs.core.cst$kw$opts,inst_120843);
var inst_120879 = fluree.db.query.fql.query(inst_120817,inst_120878);
var state_120896__$1 = (function (){var statearr_120906 = state_120896;
(statearr_120906[(11)] = inst_120877);

(statearr_120906[(12)] = inst_120876);

return statearr_120906;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_120896__$1,(56),inst_120879);
} else {
if((state_val_120897 === (39))){
var inst_120781 = (state_120896[(13)]);
var state_120896__$1 = state_120896;
if(cljs.core.truth_(inst_120781)){
var statearr_120907_120990 = state_120896__$1;
(statearr_120907_120990[(1)] = (41));

} else {
var statearr_120908_120991 = state_120896__$1;
(statearr_120908_120991[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (46))){
var inst_120853 = (state_120896[(2)]);
var state_120896__$1 = state_120896;
var statearr_120909_120992 = state_120896__$1;
(statearr_120909_120992[(2)] = inst_120853);

(statearr_120909_120992[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_120896,(3),Error,null,(2));
var inst_120756 = (flureeQL == null);
var inst_120757 = cljs.core.not(inst_120756);
var state_120896__$1 = state_120896;
if(inst_120757){
var statearr_120910_120993 = state_120896__$1;
(statearr_120910_120993[(1)] = (5));

} else {
var statearr_120911_120994 = state_120896__$1;
(statearr_120911_120994[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (54))){
var inst_120870 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_120871 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_120872 = cljs.core.PersistentHashMap.fromArrays(inst_120870,inst_120871);
var inst_120873 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Invalid query.",inst_120872);
var inst_120874 = (function(){throw inst_120873})();
var state_120896__$1 = state_120896;
var statearr_120912_120995 = state_120896__$1;
(statearr_120912_120995[(2)] = inst_120874);

(statearr_120912_120995[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (15))){
var inst_120795 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flureeQL], 0));
var inst_120796 = ["Only one type of select-key (select, selectOne, selectDistinct, selectReduced) allowed. Provided: ",inst_120795].join('');
var inst_120797 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_120798 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_120799 = cljs.core.PersistentHashMap.fromArrays(inst_120797,inst_120798);
var inst_120800 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_120796,inst_120799);
var inst_120801 = (function(){throw inst_120800})();
var state_120896__$1 = state_120896;
var statearr_120913_120996 = state_120896__$1;
(statearr_120913_120996[(2)] = inst_120801);

(statearr_120913_120996[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (48))){
var inst_120859 = (state_120896[(14)]);
var state_120896__$1 = state_120896;
var statearr_120914_120997 = state_120896__$1;
(statearr_120914_120997[(2)] = inst_120859);

(statearr_120914_120997[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (50))){
var inst_120783 = (state_120896[(15)]);
var state_120896__$1 = state_120896;
var statearr_120915_120998 = state_120896__$1;
(statearr_120915_120998[(2)] = inst_120783);

(statearr_120915_120998[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (21))){
var inst_120778 = (state_120896[(16)]);
var inst_120806 = (state_120896[(2)]);
var inst_120807 = fluree.db.util.async.throw_err(inst_120806);
var inst_120808 = fluree.db.time_travel.as_of_block(inst_120807,inst_120778);
var state_120896__$1 = state_120896;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_120896__$1,(20),inst_120808);
} else {
if((state_val_120897 === (31))){
var inst_120838 = (state_120896[(17)]);
var inst_120784 = (state_120896[(18)]);
var inst_120837 = (state_120896[(2)]);
var inst_120838__$1 = cljs.core.cst$kw$fuel.cljs$core$IFn$_invoke$arity$1(inst_120784);
var state_120896__$1 = (function (){var statearr_120916 = state_120896;
(statearr_120916[(19)] = inst_120837);

(statearr_120916[(17)] = inst_120838__$1);

return statearr_120916;
})();
if(cljs.core.truth_(inst_120838__$1)){
var statearr_120917_120999 = state_120896__$1;
(statearr_120917_120999[(1)] = (32));

} else {
var statearr_120918_121000 = state_120896__$1;
(statearr_120918_121000[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (32))){
var inst_120838 = (state_120896[(17)]);
var state_120896__$1 = state_120896;
var statearr_120919_121001 = state_120896__$1;
(statearr_120919_121001[(2)] = inst_120838);

(statearr_120919_121001[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (40))){
var inst_120857 = (state_120896[(2)]);
var state_120896__$1 = state_120896;
var statearr_120920_121002 = state_120896__$1;
(statearr_120920_121002[(2)] = inst_120857);

(statearr_120920_121002[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (56))){
var inst_120827 = (state_120896[(8)]);
var inst_120881 = (state_120896[(2)]);
var inst_120882 = fluree.db.util.async.throw_err(inst_120881);
var state_120896__$1 = (function (){var statearr_120921 = state_120896;
(statearr_120921[(7)] = inst_120882);

return statearr_120921;
})();
if(cljs.core.truth_(inst_120827)){
var statearr_120922_121003 = state_120896__$1;
(statearr_120922_121003[(1)] = (57));

} else {
var statearr_120923_121004 = state_120896__$1;
(statearr_120923_121004[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (33))){
var state_120896__$1 = state_120896;
var statearr_120924_121005 = state_120896__$1;
(statearr_120924_121005[(2)] = (1000000));

(statearr_120924_121005[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (13))){
var inst_120779 = (state_120896[(20)]);
var inst_120777 = (state_120896[(21)]);
var inst_120785 = (state_120896[(22)]);
var inst_120776 = (state_120896[(23)]);
var inst_120781 = (state_120896[(13)]);
var inst_120784 = (state_120896[(18)]);
var inst_120783 = (state_120896[(15)]);
var inst_120778 = (state_120896[(16)]);
var inst_120780 = (state_120896[(24)]);
var inst_120782 = (state_120896[(25)]);
var inst_120775 = (state_120896[(2)]);
var inst_120776__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_120775,cljs.core.cst$kw$construct);
var inst_120777__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_120775,cljs.core.cst$kw$select);
var inst_120778__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_120775,cljs.core.cst$kw$block);
var inst_120779__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_120775,cljs.core.cst$kw$where);
var inst_120780__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_120775,cljs.core.cst$kw$prefixes);
var inst_120781__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_120775,cljs.core.cst$kw$selectDistinct);
var inst_120782__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_120775,cljs.core.cst$kw$selectOne);
var inst_120783__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_120775,cljs.core.cst$kw$from);
var inst_120784__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_120775,cljs.core.cst$kw$opts);
var inst_120785__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_120775,cljs.core.cst$kw$selectReduced);
var inst_120786 = (function (){var construct = inst_120776__$1;
var select = inst_120777__$1;
var block = inst_120778__$1;
var where = inst_120779__$1;
var prefixes = inst_120780__$1;
var selectDistinct = inst_120781__$1;
var map__120754 = inst_120775;
var selectOne = inst_120782__$1;
var from = inst_120783__$1;
var opts = inst_120784__$1;
var selectReduced = inst_120785__$1;
return ((function (construct,select,block,where,prefixes,selectDistinct,map__120754,selectOne,from,opts,selectReduced,inst_120779,inst_120777,inst_120785,inst_120776,inst_120781,inst_120784,inst_120783,inst_120778,inst_120780,inst_120782,inst_120775,inst_120776__$1,inst_120777__$1,inst_120778__$1,inst_120779__$1,inst_120780__$1,inst_120781__$1,inst_120782__$1,inst_120783__$1,inst_120784__$1,inst_120785__$1,state_val_120897,c__99059__auto__){
return (function (p1__120749_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__120749_SHARP_);
});
;})(construct,select,block,where,prefixes,selectDistinct,map__120754,selectOne,from,opts,selectReduced,inst_120779,inst_120777,inst_120785,inst_120776,inst_120781,inst_120784,inst_120783,inst_120778,inst_120780,inst_120782,inst_120775,inst_120776__$1,inst_120777__$1,inst_120778__$1,inst_120779__$1,inst_120780__$1,inst_120781__$1,inst_120782__$1,inst_120783__$1,inst_120784__$1,inst_120785__$1,state_val_120897,c__99059__auto__))
})();
var inst_120787 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_120788 = [inst_120777__$1,inst_120782__$1,inst_120781__$1,inst_120785__$1];
var inst_120789 = (new cljs.core.PersistentVector(null,4,(5),inst_120787,inst_120788,null));
var inst_120790 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_120789);
var inst_120791 = cljs.core.count(inst_120790);
var inst_120792 = (inst_120786.cljs$core$IFn$_invoke$arity$1 ? inst_120786.cljs$core$IFn$_invoke$arity$1(inst_120791) : inst_120786.call(null,inst_120791));
var state_120896__$1 = (function (){var statearr_120925 = state_120896;
(statearr_120925[(20)] = inst_120779__$1);

(statearr_120925[(21)] = inst_120777__$1);

(statearr_120925[(22)] = inst_120785__$1);

(statearr_120925[(23)] = inst_120776__$1);

(statearr_120925[(13)] = inst_120781__$1);

(statearr_120925[(18)] = inst_120784__$1);

(statearr_120925[(15)] = inst_120783__$1);

(statearr_120925[(16)] = inst_120778__$1);

(statearr_120925[(24)] = inst_120780__$1);

(statearr_120925[(25)] = inst_120782__$1);

return statearr_120925;
})();
if(cljs.core.truth_(inst_120792)){
var statearr_120926_121006 = state_120896__$1;
(statearr_120926_121006[(1)] = (14));

} else {
var statearr_120927_121007 = state_120896__$1;
(statearr_120927_121007[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (22))){
var inst_120814 = (state_120896[(2)]);
var inst_120815 = fluree.db.util.async.throw_err(inst_120814);
var state_120896__$1 = state_120896;
var statearr_120928_121008 = state_120896__$1;
(statearr_120928_121008[(2)] = inst_120815);

(statearr_120928_121008[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (36))){
var inst_120782 = (state_120896[(25)]);
var state_120896__$1 = state_120896;
if(cljs.core.truth_(inst_120782)){
var statearr_120929_121009 = state_120896__$1;
(statearr_120929_121009[(1)] = (38));

} else {
var statearr_120930_121010 = state_120896__$1;
(statearr_120930_121010[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (41))){
var inst_120781 = (state_120896[(13)]);
var state_120896__$1 = state_120896;
var statearr_120931_121011 = state_120896__$1;
(statearr_120931_121011[(2)] = inst_120781);

(statearr_120931_121011[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (43))){
var inst_120855 = (state_120896[(2)]);
var state_120896__$1 = state_120896;
var statearr_120932_121012 = state_120896__$1;
(statearr_120932_121012[(2)] = inst_120855);

(statearr_120932_121012[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (29))){
var inst_120834 = cljs.core.volatile_BANG_((0));
var state_120896__$1 = state_120896;
var statearr_120933_121013 = state_120896__$1;
(statearr_120933_121013[(2)] = inst_120834);

(statearr_120933_121013[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (44))){
var inst_120785 = (state_120896[(22)]);
var state_120896__$1 = state_120896;
var statearr_120934_121014 = state_120896__$1;
(statearr_120934_121014[(2)] = inst_120785);

(statearr_120934_121014[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (6))){
var state_120896__$1 = state_120896;
var statearr_120935_121015 = state_120896__$1;
(statearr_120935_121015[(2)] = false);

(statearr_120935_121015[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (28))){
var inst_120832 = (state_120896[(2)]);
var state_120896__$1 = state_120896;
if(cljs.core.truth_(inst_120832)){
var statearr_120936_121016 = state_120896__$1;
(statearr_120936_121016[(1)] = (29));

} else {
var statearr_120937_121017 = state_120896__$1;
(statearr_120937_121017[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (51))){
var inst_120779 = (state_120896[(20)]);
var state_120896__$1 = state_120896;
var statearr_120938_121018 = state_120896__$1;
(statearr_120938_121018[(2)] = inst_120779);

(statearr_120938_121018[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (25))){
var inst_120828 = (state_120896[(26)]);
var inst_120784 = (state_120896[(18)]);
var inst_120826 = (state_120896[(2)]);
var inst_120827 = cljs.core.cst$kw$meta.cljs$core$IFn$_invoke$arity$1(inst_120784);
var inst_120828__$1 = cljs.core.cst$kw$fuel.cljs$core$IFn$_invoke$arity$1(inst_120784);
var state_120896__$1 = (function (){var statearr_120939 = state_120896;
(statearr_120939[(26)] = inst_120828__$1);

(statearr_120939[(27)] = inst_120826);

(statearr_120939[(8)] = inst_120827);

return statearr_120939;
})();
if(cljs.core.truth_(inst_120828__$1)){
var statearr_120940_121019 = state_120896__$1;
(statearr_120940_121019[(1)] = (26));

} else {
var statearr_120941_121020 = state_120896__$1;
(statearr_120941_121020[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (34))){
var inst_120837 = (state_120896[(19)]);
var inst_120777 = (state_120896[(21)]);
var inst_120826 = (state_120896[(27)]);
var inst_120784 = (state_120896[(18)]);
var inst_120842 = (state_120896[(2)]);
var inst_120843 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_120784,cljs.core.cst$kw$sources,inst_120826,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$max_DASH_fuel,inst_120842,cljs.core.cst$kw$fuel,inst_120837], 0));
var state_120896__$1 = (function (){var statearr_120942 = state_120896;
(statearr_120942[(10)] = inst_120843);

return statearr_120942;
})();
if(cljs.core.truth_(inst_120777)){
var statearr_120943_121021 = state_120896__$1;
(statearr_120943_121021[(1)] = (35));

} else {
var statearr_120944_121022 = state_120896__$1;
(statearr_120944_121022[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (17))){
var state_120896__$1 = state_120896;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_120896__$1,(21),sources);
} else {
if((state_val_120897 === (3))){
var inst_120750 = (state_120896[(2)]);
var state_120896__$1 = state_120896;
var statearr_120945_121023 = state_120896__$1;
(statearr_120945_121023[(2)] = inst_120750);


cljs.core.async.impl.ioc_helpers.process_exception(state_120896__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (12))){
var state_120896__$1 = state_120896;
var statearr_120946_121024 = state_120896__$1;
(statearr_120946_121024[(2)] = flureeQL);

(statearr_120946_121024[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (2))){
var inst_120894 = (state_120896[(2)]);
var state_120896__$1 = state_120896;
return cljs.core.async.impl.ioc_helpers.return_chan(state_120896__$1,inst_120894);
} else {
if((state_val_120897 === (23))){
var inst_120817 = (state_120896[(9)]);
var inst_120780 = (state_120896[(24)]);
var inst_120819 = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(inst_120817);
var inst_120820 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(inst_120817);
var inst_120821 = cljs.core.cst$kw$auth.cljs$core$IFn$_invoke$arity$1(inst_120817);
var inst_120822 = fluree.db.api.query.get_sources(inst_120819,inst_120820,inst_120821,inst_120780);
var state_120896__$1 = state_120896;
var statearr_120947_121025 = state_120896__$1;
(statearr_120947_121025[(2)] = inst_120822);

(statearr_120947_121025[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (47))){
var inst_120783 = (state_120896[(15)]);
var state_120896__$1 = state_120896;
if(cljs.core.truth_(inst_120783)){
var statearr_120948_121026 = state_120896__$1;
(statearr_120948_121026[(1)] = (50));

} else {
var statearr_120949_121027 = state_120896__$1;
(statearr_120949_121027[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (35))){
var inst_120777 = (state_120896[(21)]);
var state_120896__$1 = state_120896;
var statearr_120950_121028 = state_120896__$1;
(statearr_120950_121028[(2)] = inst_120777);

(statearr_120950_121028[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (19))){
var inst_120780 = (state_120896[(24)]);
var inst_120817 = (state_120896[(2)]);
var state_120896__$1 = (function (){var statearr_120951 = state_120896;
(statearr_120951[(9)] = inst_120817);

return statearr_120951;
})();
if(cljs.core.truth_(inst_120780)){
var statearr_120952_121029 = state_120896__$1;
(statearr_120952_121029[(1)] = (23));

} else {
var statearr_120953_121030 = state_120896__$1;
(statearr_120953_121030[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (57))){
var inst_120837 = (state_120896[(19)]);
var inst_120817 = (state_120896[(9)]);
var inst_120877 = (state_120896[(11)]);
var inst_120882 = (state_120896[(7)]);
var inst_120884 = [cljs.core.cst$kw$status,cljs.core.cst$kw$result,cljs.core.cst$kw$fuel,cljs.core.cst$kw$time,cljs.core.cst$kw$block];
var inst_120885 = cljs.core.deref(inst_120837);
var inst_120886 = fluree.db.api.query.response_time_formatted(inst_120877);
var inst_120887 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_120817);
var inst_120888 = [(200),inst_120882,inst_120885,inst_120886,inst_120887];
var inst_120889 = cljs.core.PersistentHashMap.fromArrays(inst_120884,inst_120888);
var state_120896__$1 = state_120896;
var statearr_120954_121031 = state_120896__$1;
(statearr_120954_121031[(2)] = inst_120889);

(statearr_120954_121031[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (11))){
var inst_120772 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,flureeQL);
var state_120896__$1 = state_120896;
var statearr_120955_121032 = state_120896__$1;
(statearr_120955_121032[(2)] = inst_120772);

(statearr_120955_121032[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (9))){
var state_120896__$1 = state_120896;
var statearr_120956_121033 = state_120896__$1;
(statearr_120956_121033[(2)] = false);

(statearr_120956_121033[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (5))){
var inst_120759 = flureeQL.cljs$lang$protocol_mask$partition0$;
var inst_120760 = (inst_120759 & (64));
var inst_120761 = flureeQL.cljs$core$ISeq$;
var inst_120762 = (cljs.core.PROTOCOL_SENTINEL === inst_120761);
var inst_120763 = ((inst_120760) || (inst_120762));
var state_120896__$1 = state_120896;
if(cljs.core.truth_(inst_120763)){
var statearr_120957_121034 = state_120896__$1;
(statearr_120957_121034[(1)] = (8));

} else {
var statearr_120958_121035 = state_120896__$1;
(statearr_120958_121035[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (14))){
var state_120896__$1 = state_120896;
var statearr_120959_121036 = state_120896__$1;
(statearr_120959_121036[(2)] = null);

(statearr_120959_121036[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (45))){
var inst_120776 = (state_120896[(23)]);
var state_120896__$1 = state_120896;
var statearr_120960_121037 = state_120896__$1;
(statearr_120960_121037[(2)] = inst_120776);

(statearr_120960_121037[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (53))){
var state_120896__$1 = state_120896;
var statearr_120961_121038 = state_120896__$1;
(statearr_120961_121038[(2)] = null);

(statearr_120961_121038[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (26))){
var inst_120828 = (state_120896[(26)]);
var state_120896__$1 = state_120896;
var statearr_120962_121039 = state_120896__$1;
(statearr_120962_121039[(2)] = inst_120828);

(statearr_120962_121039[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (16))){
var inst_120778 = (state_120896[(16)]);
var inst_120803 = (state_120896[(2)]);
var state_120896__$1 = (function (){var statearr_120963 = state_120896;
(statearr_120963[(28)] = inst_120803);

return statearr_120963;
})();
if(cljs.core.truth_(inst_120778)){
var statearr_120964_121040 = state_120896__$1;
(statearr_120964_121040[(1)] = (17));

} else {
var statearr_120965_121041 = state_120896__$1;
(statearr_120965_121041[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (38))){
var inst_120782 = (state_120896[(25)]);
var state_120896__$1 = state_120896;
var statearr_120966_121042 = state_120896__$1;
(statearr_120966_121042[(2)] = inst_120782);

(statearr_120966_121042[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (30))){
var state_120896__$1 = state_120896;
var statearr_120967_121043 = state_120896__$1;
(statearr_120967_121043[(2)] = null);

(statearr_120967_121043[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (10))){
var inst_120767 = (state_120896[(2)]);
var state_120896__$1 = state_120896;
var statearr_120968_121044 = state_120896__$1;
(statearr_120968_121044[(2)] = inst_120767);

(statearr_120968_121044[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (18))){
var state_120896__$1 = state_120896;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_120896__$1,(22),sources);
} else {
if((state_val_120897 === (52))){
var inst_120864 = (state_120896[(2)]);
var state_120896__$1 = state_120896;
var statearr_120969_121045 = state_120896__$1;
(statearr_120969_121045[(2)] = inst_120864);

(statearr_120969_121045[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (42))){
var inst_120785 = (state_120896[(22)]);
var state_120896__$1 = state_120896;
if(cljs.core.truth_(inst_120785)){
var statearr_120970_121046 = state_120896__$1;
(statearr_120970_121046[(1)] = (44));

} else {
var statearr_120971_121047 = state_120896__$1;
(statearr_120971_121047[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (37))){
var inst_120859 = (state_120896[(14)]);
var inst_120859__$1 = (state_120896[(2)]);
var state_120896__$1 = (function (){var statearr_120972 = state_120896;
(statearr_120972[(14)] = inst_120859__$1);

return statearr_120972;
})();
if(cljs.core.truth_(inst_120859__$1)){
var statearr_120973_121048 = state_120896__$1;
(statearr_120973_121048[(1)] = (47));

} else {
var statearr_120974_121049 = state_120896__$1;
(statearr_120974_121049[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (8))){
var state_120896__$1 = state_120896;
var statearr_120975_121050 = state_120896__$1;
(statearr_120975_121050[(2)] = true);

(statearr_120975_121050[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120897 === (49))){
var inst_120867 = (state_120896[(2)]);
var state_120896__$1 = state_120896;
if(cljs.core.truth_(inst_120867)){
var statearr_120976_121051 = state_120896__$1;
(statearr_120976_121051[(1)] = (53));

} else {
var statearr_120977_121052 = state_120896__$1;
(statearr_120977_121052[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$api$query$query_async_$_state_machine__99037__auto__ = null;
var fluree$db$api$query$query_async_$_state_machine__99037__auto____0 = (function (){
var statearr_120978 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_120978[(0)] = fluree$db$api$query$query_async_$_state_machine__99037__auto__);

(statearr_120978[(1)] = (1));

return statearr_120978;
});
var fluree$db$api$query$query_async_$_state_machine__99037__auto____1 = (function (state_120896){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_120896);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e120979){if((e120979 instanceof Object)){
var ex__99040__auto__ = e120979;
var statearr_120980_121053 = state_120896;
(statearr_120980_121053[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_120896);

return cljs.core.cst$kw$recur;
} else {
throw e120979;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__121054 = state_120896;
state_120896 = G__121054;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$api$query$query_async_$_state_machine__99037__auto__ = function(state_120896){
switch(arguments.length){
case 0:
return fluree$db$api$query$query_async_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$api$query$query_async_$_state_machine__99037__auto____1.call(this,state_120896);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$query_async_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$query_async_$_state_machine__99037__auto____0;
fluree$db$api$query$query_async_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$query_async_$_state_machine__99037__auto____1;
return fluree$db$api$query$query_async_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_120981 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_120981[(6)] = c__99059__auto__);

return statearr_120981;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Performs multiple queries in a map, with the key being the alias for the query
 *   and the value being the query itself - standard, history, and block queries are all supported.
 *   Each query result will be in a response map with its respective alias as the key.
 * 
 *   If a :block is specified at the top level, it will be used as a default for all queries
 * 
 *   If any errors occur, an :errors key will be present with a map of each alias to its error
 *   information. Check for the presence of this key if detection of an error is important.
 * 
 *   An optional :opts key contains options, which for now is limited to:
 * - meta: true or false - If false, will just report out the result as a map.
 *         If true will roll up all status and fuel consumption. Response map will contain keys:
 *         - status - aggregate status (200 all good, 207 some good, or 400+ for differing errors
 *         - fuel   - aggregate fuel for all queries
 *         - result - query result
 *         - errors - map of query alias to their respective error
 */
fluree.db.api.query.multi_query_async = (function fluree$db$api$query$multi_query_async(source,flureeQL){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_121205){
var state_val_121206 = (state_121205[(1)]);
if((state_val_121206 === (7))){
var inst_121063 = (state_121205[(7)]);
var state_121205__$1 = state_121205;
if(cljs.core.truth_(inst_121063)){
var statearr_121207_121280 = state_121205__$1;
(statearr_121207_121280[(1)] = (10));

} else {
var statearr_121208_121281 = state_121205__$1;
(statearr_121208_121281[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (20))){
var inst_121122 = (state_121205[(8)]);
var state_121205__$1 = state_121205;
var statearr_121209_121282 = state_121205__$1;
(statearr_121209_121282[(2)] = inst_121122);

(statearr_121209_121282[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (27))){
var inst_121092 = (state_121205[(9)]);
var inst_121150 = (state_121205[(10)]);
var inst_121154 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_121092,inst_121150);
var state_121205__$1 = state_121205;
if(inst_121154){
var statearr_121210_121283 = state_121205__$1;
(statearr_121210_121283[(1)] = (29));

} else {
var statearr_121211_121284 = state_121205__$1;
(statearr_121211_121284[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (1))){
var state_121205__$1 = state_121205;
var statearr_121212_121285 = state_121205__$1;
(statearr_121212_121285[(2)] = null);

(statearr_121212_121285[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (24))){
var state_121205__$1 = state_121205;
var statearr_121213_121286 = state_121205__$1;
(statearr_121213_121286[(2)] = null);

(statearr_121213_121286[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (39))){
var state_121205__$1 = state_121205;
var statearr_121214_121287 = state_121205__$1;
(statearr_121214_121287[(2)] = null);

(statearr_121214_121287[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (46))){
var inst_121105 = (state_121205[(11)]);
var inst_121094 = (state_121205[(12)]);
var inst_121193 = (state_121205[(2)]);
var inst_121194 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_121094,inst_121105,inst_121193);
var state_121205__$1 = state_121205;
var statearr_121215_121288 = state_121205__$1;
(statearr_121215_121288[(2)] = inst_121194);

(statearr_121215_121288[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (4))){
var inst_121063 = (state_121205[(7)]);
var inst_121067 = (state_121205[(13)]);
var inst_121068 = (state_121205[(14)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_121205,(3),java.lang.Exception,null,(2));
var inst_121059 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(flureeQL);
var inst_121060 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_121061 = [cljs.core.cst$kw$opts,cljs.core.cst$kw$meta];
var inst_121062 = (new cljs.core.PersistentVector(null,2,(5),inst_121060,inst_121061,null));
var inst_121063__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(flureeQL,inst_121062);
var inst_121064 = (function (){var global_block = inst_121059;
var global_meta_QMARK_ = inst_121063__$1;
return ((function (global_block,global_meta_QMARK_,inst_121063,inst_121067,inst_121068,_,inst_121059,inst_121060,inst_121061,inst_121062,inst_121063__$1,state_val_121206,c__99059__auto__){
return (function (acc,alias,query){
var query_meta_QMARK_ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$meta], null));
var meta_QMARK_ = (function (){var or__4131__auto__ = global_meta_QMARK_;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return query_meta_QMARK_;
}
})();
var remove_meta_QMARK_ = (function (){var and__4120__auto__ = meta_QMARK_;
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.not(query_meta_QMARK_);
} else {
return and__4120__auto__;
}
})();
var opts_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$opts.cljs$core$IFn$_invoke$arity$1(query),cljs.core.cst$kw$meta,meta_QMARK_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$_remove_DASH_meta_QMARK_,remove_meta_QMARK_], 0));
var query_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(query,cljs.core.cst$kw$opts,opts_STAR_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$block,(function (){var or__4131__auto__ = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return global_block;
}
})()], 0));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,alias,query_STAR_);
});
;})(global_block,global_meta_QMARK_,inst_121063,inst_121067,inst_121068,_,inst_121059,inst_121060,inst_121061,inst_121062,inst_121063__$1,state_val_121206,c__99059__auto__))
})();
var inst_121065 = cljs.core.PersistentHashMap.EMPTY;
var inst_121066 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(flureeQL,cljs.core.cst$kw$opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$block], 0));
var inst_121067__$1 = cljs.core.reduce_kv(inst_121064,inst_121065,inst_121066);
var inst_121068__$1 = fluree.db.util.core.current_time_millis();
var inst_121070 = (function (){var global_block = inst_121059;
var global_meta_QMARK_ = inst_121063__$1;
var queries = inst_121067__$1;
var start_time = inst_121068__$1;
return ((function (global_block,global_meta_QMARK_,queries,start_time,inst_121063,inst_121067,inst_121068,_,inst_121059,inst_121060,inst_121061,inst_121062,inst_121063__$1,inst_121064,inst_121065,inst_121066,inst_121067__$1,inst_121068__$1,state_val_121206,c__99059__auto__){
return (function (p__121069){
var vec__121216 = p__121069;
var alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__121216,(0),null);
var q = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__121216,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,(fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2(source,q) : fluree.db.api.query.query.call(null,source,q))], null);
});
;})(global_block,global_meta_QMARK_,queries,start_time,inst_121063,inst_121067,inst_121068,_,inst_121059,inst_121060,inst_121061,inst_121062,inst_121063__$1,inst_121064,inst_121065,inst_121066,inst_121067__$1,inst_121068__$1,state_val_121206,c__99059__auto__))
})();
var inst_121071 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_121070,inst_121067__$1);
var inst_121085 = cljs.core.seq(inst_121071);
var inst_121086 = cljs.core.first(inst_121085);
var inst_121087 = cljs.core.next(inst_121085);
var inst_121088 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_121086,(0),null);
var inst_121089 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_121086,(1),null);
var inst_121090 = cljs.core.PersistentHashMap.EMPTY;
var inst_121091 = inst_121071;
var inst_121092 = null;
var inst_121093 = (0);
var inst_121094 = inst_121090;
var state_121205__$1 = (function (){var statearr_121219 = state_121205;
(statearr_121219[(15)] = inst_121088);

(statearr_121219[(7)] = inst_121063__$1);

(statearr_121219[(13)] = inst_121067__$1);

(statearr_121219[(16)] = inst_121087);

(statearr_121219[(17)] = inst_121089);

(statearr_121219[(14)] = inst_121068__$1);

(statearr_121219[(12)] = inst_121094);

(statearr_121219[(18)] = inst_121091);

(statearr_121219[(9)] = inst_121092);

(statearr_121219[(19)] = inst_121093);

return statearr_121219;
})();
var statearr_121220_121289 = state_121205__$1;
(statearr_121220_121289[(2)] = null);

(statearr_121220_121289[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (15))){
var inst_121138 = (state_121205[(2)]);
var state_121205__$1 = state_121205;
if(cljs.core.truth_(inst_121138)){
var statearr_121221_121290 = state_121205__$1;
(statearr_121221_121290[(1)] = (19));

} else {
var statearr_121222_121291 = state_121205__$1;
(statearr_121222_121291[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (21))){
var inst_121106 = (state_121205[(20)]);
var inst_121143 = (state_121205[(2)]);
var inst_121144 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_121143,cljs.core.cst$kw$meta);
var inst_121145 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_121143,cljs.core.cst$kw$_remove_DASH_meta_QMARK_);
var state_121205__$1 = (function (){var statearr_121223 = state_121205;
(statearr_121223[(21)] = inst_121144);

(statearr_121223[(22)] = inst_121145);

return statearr_121223;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_121205__$1,(22),inst_121106);
} else {
if((state_val_121206 === (31))){
var inst_121171 = (state_121205[(2)]);
var state_121205__$1 = state_121205;
var statearr_121224_121292 = state_121205__$1;
(statearr_121224_121292[(2)] = inst_121171);

(statearr_121224_121292[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (32))){
var state_121205__$1 = state_121205;
var statearr_121225_121293 = state_121205__$1;
(statearr_121225_121293[(2)] = (207));

(statearr_121225_121293[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (40))){
var inst_121148 = (state_121205[(23)]);
var inst_121182 = (state_121205[(2)]);
var state_121205__$1 = (function (){var statearr_121226 = state_121205;
(statearr_121226[(24)] = inst_121182);

return statearr_121226;
})();
if(cljs.core.truth_(inst_121148)){
var statearr_121227_121294 = state_121205__$1;
(statearr_121227_121294[(1)] = (41));

} else {
var statearr_121228_121295 = state_121205__$1;
(statearr_121228_121295[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (33))){
var state_121205__$1 = state_121205;
var statearr_121229_121296 = state_121205__$1;
(statearr_121229_121296[(1)] = (35));



return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (13))){
var inst_121122 = (state_121205[(8)]);
var inst_121127 = inst_121122.cljs$lang$protocol_mask$partition0$;
var inst_121128 = (inst_121127 & (64));
var inst_121129 = inst_121122.cljs$core$ISeq$;
var inst_121130 = (cljs.core.PROTOCOL_SENTINEL === inst_121129);
var inst_121131 = ((inst_121128) || (inst_121130));
var state_121205__$1 = state_121205;
if(cljs.core.truth_(inst_121131)){
var statearr_121231_121297 = state_121205__$1;
(statearr_121231_121297[(1)] = (16));

} else {
var statearr_121232_121298 = state_121205__$1;
(statearr_121232_121298[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (22))){
var inst_121144 = (state_121205[(21)]);
var inst_121147 = (state_121205[(25)]);
var inst_121147__$1 = (state_121205[(2)]);
var inst_121148 = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(inst_121147__$1);
var state_121205__$1 = (function (){var statearr_121233 = state_121205;
(statearr_121233[(23)] = inst_121148);

(statearr_121233[(25)] = inst_121147__$1);

return statearr_121233;
})();
if(cljs.core.truth_(inst_121144)){
var statearr_121234_121299 = state_121205__$1;
(statearr_121234_121299[(1)] = (23));

} else {
var statearr_121235_121300 = state_121205__$1;
(statearr_121235_121300[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (36))){
var state_121205__$1 = state_121205;
var statearr_121236_121301 = state_121205__$1;
(statearr_121236_121301[(2)] = null);

(statearr_121236_121301[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (41))){
var inst_121147 = (state_121205[(25)]);
var inst_121105 = (state_121205[(11)]);
var inst_121094 = (state_121205[(12)]);
var inst_121184 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_121185 = [cljs.core.cst$kw$errors,inst_121105];
var inst_121186 = (new cljs.core.PersistentVector(null,2,(5),inst_121184,inst_121185,null));
var inst_121187 = cljs.core.assoc_in(inst_121094,inst_121186,inst_121147);
var state_121205__$1 = state_121205;
var statearr_121237_121302 = state_121205__$1;
(statearr_121237_121302[(2)] = inst_121187);

(statearr_121237_121302[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (43))){
var inst_121176 = (state_121205[(26)]);
var inst_121104 = (state_121205[(27)]);
var inst_121182 = (state_121205[(24)]);
var inst_121196 = (state_121205[(2)]);
var inst_121091 = inst_121104;
var inst_121092 = inst_121176;
var inst_121093 = inst_121182;
var inst_121094 = inst_121196;
var state_121205__$1 = (function (){var statearr_121238 = state_121205;
(statearr_121238[(12)] = inst_121094);

(statearr_121238[(18)] = inst_121091);

(statearr_121238[(9)] = inst_121092);

(statearr_121238[(19)] = inst_121093);

return statearr_121238;
})();
var statearr_121239_121303 = state_121205__$1;
(statearr_121239_121303[(2)] = null);

(statearr_121239_121303[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (29))){
var inst_121150 = (state_121205[(10)]);
var state_121205__$1 = state_121205;
var statearr_121240_121304 = state_121205__$1;
(statearr_121240_121304[(2)] = inst_121150);

(statearr_121240_121304[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (44))){
var inst_121147 = (state_121205[(25)]);
var inst_121190 = cljs.core.cst$kw$result.cljs$core$IFn$_invoke$arity$1(inst_121147);
var state_121205__$1 = state_121205;
var statearr_121241_121305 = state_121205__$1;
(statearr_121241_121305[(2)] = inst_121190);

(statearr_121241_121305[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (6))){
var inst_121201 = (state_121205[(2)]);
var state_121205__$1 = state_121205;
var statearr_121242_121306 = state_121205__$1;
(statearr_121242_121306[(2)] = inst_121201);


cljs.core.async.impl.ioc_helpers.process_exception(state_121205__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (28))){
var inst_121173 = (state_121205[(2)]);
var state_121205__$1 = state_121205;
var statearr_121243_121307 = state_121205__$1;
(statearr_121243_121307[(2)] = inst_121173);

(statearr_121243_121307[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (25))){
var inst_121144 = (state_121205[(21)]);
var inst_121176 = (state_121205[(2)]);
var state_121205__$1 = (function (){var statearr_121244 = state_121205;
(statearr_121244[(26)] = inst_121176);

return statearr_121244;
})();
if(cljs.core.truth_(inst_121144)){
var statearr_121245_121308 = state_121205__$1;
(statearr_121245_121308[(1)] = (38));

} else {
var statearr_121246_121309 = state_121205__$1;
(statearr_121246_121309[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (34))){
var inst_121169 = (state_121205[(2)]);
var state_121205__$1 = state_121205;
var statearr_121247_121310 = state_121205__$1;
(statearr_121247_121310[(2)] = inst_121169);

(statearr_121247_121310[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (17))){
var state_121205__$1 = state_121205;
var statearr_121248_121311 = state_121205__$1;
(statearr_121248_121311[(2)] = false);

(statearr_121248_121311[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (3))){
var inst_121055 = (state_121205[(2)]);
var state_121205__$1 = state_121205;
var statearr_121249_121312 = state_121205__$1;
(statearr_121249_121312[(2)] = inst_121055);


cljs.core.async.impl.ioc_helpers.process_exception(state_121205__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (12))){
var inst_121116 = (state_121205[(2)]);
var state_121205__$1 = state_121205;
var statearr_121250_121313 = state_121205__$1;
(statearr_121250_121313[(2)] = inst_121116);

(statearr_121250_121313[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (2))){
var inst_121203 = (state_121205[(2)]);
var state_121205__$1 = state_121205;
return cljs.core.async.impl.ioc_helpers.return_chan(state_121205__$1,inst_121203);
} else {
if((state_val_121206 === (23))){
var inst_121147 = (state_121205[(25)]);
var inst_121092 = (state_121205[(9)]);
var inst_121150 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_121147);
var inst_121151 = (inst_121092 == null);
var state_121205__$1 = (function (){var statearr_121251 = state_121205;
(statearr_121251[(10)] = inst_121150);

return statearr_121251;
})();
if(cljs.core.truth_(inst_121151)){
var statearr_121252_121314 = state_121205__$1;
(statearr_121252_121314[(1)] = (26));

} else {
var statearr_121253_121315 = state_121205__$1;
(statearr_121253_121315[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (35))){
var inst_121092 = (state_121205[(9)]);
var inst_121150 = (state_121205[(10)]);
var inst_121164 = ((inst_121150 > inst_121092) ? inst_121150 : inst_121092);
var state_121205__$1 = state_121205;
var statearr_121254_121316 = state_121205__$1;
(statearr_121254_121316[(2)] = inst_121164);

(statearr_121254_121316[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (19))){
var inst_121122 = (state_121205[(8)]);
var inst_121140 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_121122);
var state_121205__$1 = state_121205;
var statearr_121255_121317 = state_121205__$1;
(statearr_121255_121317[(2)] = inst_121140);

(statearr_121255_121317[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (11))){
var inst_121094 = (state_121205[(12)]);
var state_121205__$1 = state_121205;
var statearr_121256_121318 = state_121205__$1;
(statearr_121256_121318[(2)] = inst_121094);

(statearr_121256_121318[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (9))){
var inst_121199 = (state_121205[(2)]);
var state_121205__$1 = state_121205;
var statearr_121257_121319 = state_121205__$1;
(statearr_121257_121319[(2)] = inst_121199);

(statearr_121257_121319[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (5))){
var inst_121106 = (state_121205[(20)]);
var inst_121091 = (state_121205[(18)]);
var inst_121102 = cljs.core.seq(inst_121091);
var inst_121103 = cljs.core.first(inst_121102);
var inst_121104 = cljs.core.next(inst_121102);
var inst_121105 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_121103,(0),null);
var inst_121106__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_121103,(1),null);
var inst_121107 = (inst_121106__$1 == null);
var state_121205__$1 = (function (){var statearr_121258 = state_121205;
(statearr_121258[(20)] = inst_121106__$1);

(statearr_121258[(11)] = inst_121105);

(statearr_121258[(27)] = inst_121104);

return statearr_121258;
})();
if(cljs.core.truth_(inst_121107)){
var statearr_121259_121320 = state_121205__$1;
(statearr_121259_121320[(1)] = (7));

} else {
var statearr_121260_121321 = state_121205__$1;
(statearr_121260_121321[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (14))){
var state_121205__$1 = state_121205;
var statearr_121261_121322 = state_121205__$1;
(statearr_121261_121322[(2)] = false);

(statearr_121261_121322[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (45))){
var inst_121147 = (state_121205[(25)]);
var state_121205__$1 = state_121205;
var statearr_121262_121323 = state_121205__$1;
(statearr_121262_121323[(2)] = inst_121147);

(statearr_121262_121323[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (26))){
var inst_121150 = (state_121205[(10)]);
var state_121205__$1 = state_121205;
var statearr_121263_121324 = state_121205__$1;
(statearr_121263_121324[(2)] = inst_121150);

(statearr_121263_121324[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (16))){
var state_121205__$1 = state_121205;
var statearr_121264_121325 = state_121205__$1;
(statearr_121264_121325[(2)] = true);

(statearr_121264_121325[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (38))){
var inst_121147 = (state_121205[(25)]);
var inst_121093 = (state_121205[(19)]);
var inst_121178 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_121147,cljs.core.cst$kw$fuel,(0));
var inst_121179 = (inst_121093 + inst_121178);
var state_121205__$1 = state_121205;
var statearr_121265_121326 = state_121205__$1;
(statearr_121265_121326[(2)] = inst_121179);

(statearr_121265_121326[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (30))){
var inst_121092 = (state_121205[(9)]);
var inst_121150 = (state_121205[(10)]);
var inst_121157 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_121150);
var inst_121158 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_121092);
var inst_121159 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((207),inst_121092);
var inst_121160 = ((inst_121157) || (inst_121158) || (inst_121159));
var state_121205__$1 = state_121205;
if(cljs.core.truth_(inst_121160)){
var statearr_121266_121327 = state_121205__$1;
(statearr_121266_121327[(1)] = (32));

} else {
var statearr_121267_121328 = state_121205__$1;
(statearr_121267_121328[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (10))){
var inst_121068 = (state_121205[(14)]);
var inst_121094 = (state_121205[(12)]);
var inst_121092 = (state_121205[(9)]);
var inst_121093 = (state_121205[(19)]);
var inst_121110 = [cljs.core.cst$kw$result,cljs.core.cst$kw$fuel,cljs.core.cst$kw$status,cljs.core.cst$kw$time];
var inst_121111 = fluree.db.api.query.response_time_formatted(inst_121068);
var inst_121112 = [inst_121094,inst_121093,inst_121092,inst_121111];
var inst_121113 = cljs.core.PersistentHashMap.fromArrays(inst_121110,inst_121112);
var state_121205__$1 = state_121205;
var statearr_121268_121329 = state_121205__$1;
(statearr_121268_121329[(2)] = inst_121113);

(statearr_121268_121329[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (18))){
var inst_121135 = (state_121205[(2)]);
var state_121205__$1 = state_121205;
var statearr_121269_121330 = state_121205__$1;
(statearr_121269_121330[(2)] = inst_121135);

(statearr_121269_121330[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (42))){
var inst_121145 = (state_121205[(22)]);
var state_121205__$1 = state_121205;
if(cljs.core.truth_(inst_121145)){
var statearr_121270_121331 = state_121205__$1;
(statearr_121270_121331[(1)] = (44));

} else {
var statearr_121271_121332 = state_121205__$1;
(statearr_121271_121332[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (37))){
var inst_121167 = (state_121205[(2)]);
var state_121205__$1 = state_121205;
var statearr_121272_121333 = state_121205__$1;
(statearr_121272_121333[(2)] = inst_121167);

(statearr_121272_121333[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121206 === (8))){
var inst_121067 = (state_121205[(13)]);
var inst_121122 = (state_121205[(8)]);
var inst_121105 = (state_121205[(11)]);
var inst_121119 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_121120 = [inst_121105,cljs.core.cst$kw$opts];
var inst_121121 = (new cljs.core.PersistentVector(null,2,(5),inst_121119,inst_121120,null));
var inst_121122__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_121067,inst_121121);
var inst_121124 = (inst_121122__$1 == null);
var inst_121125 = cljs.core.not(inst_121124);
var state_121205__$1 = (function (){var statearr_121273 = state_121205;
(statearr_121273[(8)] = inst_121122__$1);

return statearr_121273;
})();
if(inst_121125){
var statearr_121274_121334 = state_121205__$1;
(statearr_121274_121334[(1)] = (13));

} else {
var statearr_121275_121335 = state_121205__$1;
(statearr_121275_121335[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$api$query$multi_query_async_$_state_machine__99037__auto__ = null;
var fluree$db$api$query$multi_query_async_$_state_machine__99037__auto____0 = (function (){
var statearr_121276 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_121276[(0)] = fluree$db$api$query$multi_query_async_$_state_machine__99037__auto__);

(statearr_121276[(1)] = (1));

return statearr_121276;
});
var fluree$db$api$query$multi_query_async_$_state_machine__99037__auto____1 = (function (state_121205){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_121205);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e121277){if((e121277 instanceof Object)){
var ex__99040__auto__ = e121277;
var statearr_121278_121336 = state_121205;
(statearr_121278_121336[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_121205);

return cljs.core.cst$kw$recur;
} else {
throw e121277;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__121337 = state_121205;
state_121205 = G__121337;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$api$query$multi_query_async_$_state_machine__99037__auto__ = function(state_121205){
switch(arguments.length){
case 0:
return fluree$db$api$query$multi_query_async_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$api$query$multi_query_async_$_state_machine__99037__auto____1.call(this,state_121205);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$multi_query_async_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$multi_query_async_$_state_machine__99037__auto____0;
fluree$db$api$query$multi_query_async_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$multi_query_async_$_state_machine__99037__auto____1;
return fluree$db$api$query$multi_query_async_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_121279 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_121279[(6)] = c__99059__auto__);

return statearr_121279;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Generic query interface. Will determine if multi-query, standard query, block or history
 *   and dispatch appropriately.
 * 
 *   For now, sources is expected to be just a db. In the case of a block query, which requires
 *   a conn + ledger, those will be extracted from the db.
 */
fluree.db.api.query.query = (function fluree$db$api$query$query(source,flureeQL){
var query_type = fluree.db.api.query.query_type(flureeQL);
var G__121338 = query_type;
var G__121338__$1 = (((G__121338 instanceof cljs.core.Keyword))?G__121338.fqn:null);
switch (G__121338__$1) {
case "standard":
return fluree.db.api.query.query_async(source,flureeQL);

break;
case "history":
return fluree.db.api.query.history_query_async(source,flureeQL);

break;
case "block":
var conn = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(source);
var ledger = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(source),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(source));
return fluree.db.api.query.block_query_async(conn,ledger,flureeQL);

break;
case "multi":
return fluree.db.api.query.multi_query_async(source,flureeQL);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__121338__$1)].join('')));

}
});

//# sourceMappingURL=query.js.map?rel=1593118622542
