// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__99492){
var vec__99493 = p__99492;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99493,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99493,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return ((function (sources__$1){
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
;})(sources__$1))
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__99496 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99496,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99496,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99496,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99496,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99496,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$gcol,gcol,cljs.core.cst$kw$source,(goog.object.get(source_map,"sources")[source]),cljs.core.cst$kw$line,line,cljs.core.cst$kw$col,col,cljs.core.cst$kw$name,(function (){var temp__5735__auto__ = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5735__auto__)){
var name__$1 = temp__5735__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__99499 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99499,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99499,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99499,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99499,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99499,(4),null);
var vec__99502 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99502,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99502,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99502,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99502,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99502,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4131__auto__ = source;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4131__auto__ = line;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4131__auto__ = col;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4131__auto__ = name;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$name,(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__99505 = segmap;
var map__99505__$1 = (((((!((map__99505 == null))))?(((((map__99505.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__99505.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__99505):map__99505);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__99505__$1,cljs.core.cst$kw$gcol);
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__99505__$1,cljs.core.cst$kw$source);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__99505__$1,cljs.core.cst$kw$line);
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__99505__$1,cljs.core.cst$kw$col);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__99505__$1,cljs.core.cst$kw$name);
var d = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$gline,gline,cljs.core.cst$kw$gcol,gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,cljs.core.cst$kw$name,name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (map__99505,map__99505__$1,gcol,source,line,col,name,d,d__$1){
return (function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (map__99505,map__99505__$1,gcol,source,line,col,name,d,d__$1){
return (function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (map__99505,map__99505__$1,gcol,source,line,col,name,d,d__$1){
return (function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
});})(map__99505,map__99505__$1,gcol,source,line,col,name,d,d__$1))
,cljs.core.PersistentVector.EMPTY));
});})(map__99505,map__99505__$1,gcol,source,line,col,name,d,d__$1))
,cljs.core.sorted_map()));
});})(map__99505,map__99505__$1,gcol,source,line,col,name,d,d__$1))
,cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__99508 = arguments.length;
switch (G__99508) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
});

cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__99512 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__99516 = cljs.core.next(segs__$1);
var G__99517 = nrelseg;
var G__99518 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__99516;
relseg__$1 = G__99517;
result__$1 = G__99518;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99512,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99512,(1),null);
var G__99519 = (gline + (1));
var G__99520 = cljs.core.next(lines__$1);
var G__99521 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__99522 = result__$1;
gline = G__99519;
lines__$1 = G__99520;
relseg = G__99521;
result = G__99522;
continue;
} else {
return result;
}
break;
}
});

cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2;

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__99524 = segmap;
var map__99524__$1 = (((((!((map__99524 == null))))?(((((map__99524.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__99524.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__99524):map__99524);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__99524__$1,cljs.core.cst$kw$gcol);
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__99524__$1,cljs.core.cst$kw$source);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__99524__$1,cljs.core.cst$kw$line);
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__99524__$1,cljs.core.cst$kw$col);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__99524__$1,cljs.core.cst$kw$name);
var d = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line,cljs.core.cst$kw$col,col,cljs.core.cst$kw$source,source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,cljs.core.cst$kw$name,name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (map__99524,map__99524__$1,gcol,source,line,col,name,d,d__$1){
return (function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (map__99524,map__99524__$1,gcol,source,line,col,name,d,d__$1){
return (function (p1__99523_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__99523_SHARP_,d__$1);
});})(map__99524,map__99524__$1,gcol,source,line,col,name,d,d__$1))
,cljs.core.PersistentVector.EMPTY));
});})(map__99524,map__99524__$1,gcol,source,line,col,name,d,d__$1))
,cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__99527 = arguments.length;
switch (G__99527) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
});

cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__99531 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__99535 = cljs.core.next(segs__$1);
var G__99536 = nrelseg;
var G__99537 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__99535;
relseg__$1 = G__99536;
result__$1 = G__99537;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99531,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99531,(1),null);
var G__99538 = (gline + (1));
var G__99539 = cljs.core.next(lines__$1);
var G__99540 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__99541 = result__$1;
gline = G__99538;
lines__$1 = G__99539;
relseg = G__99540;
result = G__99541;
continue;
} else {
return result;
}
break;
}
});

cljs.source_map.decode.cljs$lang$maxFixedArity = 2;

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (relseg){
return (function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,((function (relseg){
return (function (p__99542){
var vec__99543 = p__99542;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99543,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99543,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99543,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99543,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99543,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
});})(relseg))
);

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (relseg){
return (function (cols__$1,p__99546){
var vec__99547 = p__99546;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99547,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99547,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99547,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99547,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99547,(4),null);
var seg = vec__99547;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,((function (offset,vec__99547,gcol,sidx,line,col,name,seg,relseg){
return (function (p__99550){
var vec__99551 = p__99550;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99551,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99551,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99551,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99551,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99551,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4131__auto__ = name;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return lname;
}
})()], null);
});})(offset,vec__99547,gcol,sidx,line,col,name,seg,relseg))
);

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
});})(relseg))
,cljs.core.PersistentVector.EMPTY,cols));
});})(relseg))
,cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4131__auto__ = cljs.core.cst$kw$preamble_DASH_line_DASH_count.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = ((function (lines,names__GT_idx,name_idx,preamble_lines){
return (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$gcol.cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5733__auto__ = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5733__auto__)){
var name = temp__5733__auto__;
var idx = (function (){var temp__5733__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5733__auto____$1)){
var idx = temp__5733__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});})(lines,names__GT_idx,name_idx,preamble_lines))
;
var encode_cols = ((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (infos,source_idx,line,col){
var seq__99557 = cljs.core.seq(infos);
var chunk__99558 = null;
var count__99559 = (0);
var i__99560 = (0);
while(true){
if((i__99560 < count__99559)){
var info = chunk__99558.cljs$core$IIndexed$_nth$arity$2(null,i__99560);
var segv_99914 = info__GT_segv(info,source_idx,line,col);
var gline_99915 = cljs.core.cst$kw$gline.cljs$core$IFn$_invoke$arity$1(info);
var lc_99916 = cljs.core.count(cljs.core.deref(lines));
if((gline_99915 > (lc_99916 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__99557,chunk__99558,count__99559,i__99560,segv_99914,gline_99915,lc_99916,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_99915 - (lc_99916 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_99914], null));
});})(seq__99557,chunk__99558,count__99559,i__99560,segv_99914,gline_99915,lc_99916,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__99557,chunk__99558,count__99559,i__99560,segv_99914,gline_99915,lc_99916,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_99915], null),cljs.core.conj,segv_99914);
});})(seq__99557,chunk__99558,count__99559,i__99560,segv_99914,gline_99915,lc_99916,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__99917 = seq__99557;
var G__99918 = chunk__99558;
var G__99919 = count__99559;
var G__99920 = (i__99560 + (1));
seq__99557 = G__99917;
chunk__99558 = G__99918;
count__99559 = G__99919;
i__99560 = G__99920;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__99557);
if(temp__5735__auto__){
var seq__99557__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__99557__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__99557__$1);
var G__99921 = cljs.core.chunk_rest(seq__99557__$1);
var G__99922 = c__4550__auto__;
var G__99923 = cljs.core.count(c__4550__auto__);
var G__99924 = (0);
seq__99557 = G__99921;
chunk__99558 = G__99922;
count__99559 = G__99923;
i__99560 = G__99924;
continue;
} else {
var info = cljs.core.first(seq__99557__$1);
var segv_99925 = info__GT_segv(info,source_idx,line,col);
var gline_99926 = cljs.core.cst$kw$gline.cljs$core$IFn$_invoke$arity$1(info);
var lc_99927 = cljs.core.count(cljs.core.deref(lines));
if((gline_99926 > (lc_99927 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__99557,chunk__99558,count__99559,i__99560,segv_99925,gline_99926,lc_99927,info,seq__99557__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_99926 - (lc_99927 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_99925], null));
});})(seq__99557,chunk__99558,count__99559,i__99560,segv_99925,gline_99926,lc_99927,info,seq__99557__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__99557,chunk__99558,count__99559,i__99560,segv_99925,gline_99926,lc_99927,info,seq__99557__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_99926], null),cljs.core.conj,segv_99925);
});})(seq__99557,chunk__99558,count__99559,i__99560,segv_99925,gline_99926,lc_99927,info,seq__99557__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__99928 = cljs.core.next(seq__99557__$1);
var G__99929 = null;
var G__99930 = (0);
var G__99931 = (0);
seq__99557 = G__99928;
chunk__99558 = G__99929;
count__99559 = G__99930;
i__99560 = G__99931;
continue;
}
} else {
return null;
}
}
break;
}
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
;
var seq__99561_99932 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__99562_99933 = null;
var count__99563_99934 = (0);
var i__99564_99935 = (0);
while(true){
if((i__99564_99935 < count__99563_99934)){
var vec__99737_99936 = chunk__99562_99933.cljs$core$IIndexed$_nth$arity$2(null,i__99564_99935);
var source_idx_99937 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99737_99936,(0),null);
var vec__99740_99938 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99737_99936,(1),null);
var __99939 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99740_99938,(0),null);
var lines_99940__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99740_99938,(1),null);
var seq__99743_99941 = cljs.core.seq(lines_99940__$1);
var chunk__99744_99942 = null;
var count__99745_99943 = (0);
var i__99746_99944 = (0);
while(true){
if((i__99746_99944 < count__99745_99943)){
var vec__99785_99945 = chunk__99744_99942.cljs$core$IIndexed$_nth$arity$2(null,i__99746_99944);
var line_99946 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99785_99945,(0),null);
var cols_99947 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99785_99945,(1),null);
var seq__99788_99948 = cljs.core.seq(cols_99947);
var chunk__99789_99949 = null;
var count__99790_99950 = (0);
var i__99791_99951 = (0);
while(true){
if((i__99791_99951 < count__99790_99950)){
var vec__99798_99952 = chunk__99789_99949.cljs$core$IIndexed$_nth$arity$2(null,i__99791_99951);
var col_99953 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99798_99952,(0),null);
var infos_99954 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99798_99952,(1),null);
encode_cols(infos_99954,source_idx_99937,line_99946,col_99953);


var G__99955 = seq__99788_99948;
var G__99956 = chunk__99789_99949;
var G__99957 = count__99790_99950;
var G__99958 = (i__99791_99951 + (1));
seq__99788_99948 = G__99955;
chunk__99789_99949 = G__99956;
count__99790_99950 = G__99957;
i__99791_99951 = G__99958;
continue;
} else {
var temp__5735__auto___99959 = cljs.core.seq(seq__99788_99948);
if(temp__5735__auto___99959){
var seq__99788_99960__$1 = temp__5735__auto___99959;
if(cljs.core.chunked_seq_QMARK_(seq__99788_99960__$1)){
var c__4550__auto___99961 = cljs.core.chunk_first(seq__99788_99960__$1);
var G__99962 = cljs.core.chunk_rest(seq__99788_99960__$1);
var G__99963 = c__4550__auto___99961;
var G__99964 = cljs.core.count(c__4550__auto___99961);
var G__99965 = (0);
seq__99788_99948 = G__99962;
chunk__99789_99949 = G__99963;
count__99790_99950 = G__99964;
i__99791_99951 = G__99965;
continue;
} else {
var vec__99801_99966 = cljs.core.first(seq__99788_99960__$1);
var col_99967 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99801_99966,(0),null);
var infos_99968 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99801_99966,(1),null);
encode_cols(infos_99968,source_idx_99937,line_99946,col_99967);


var G__99969 = cljs.core.next(seq__99788_99960__$1);
var G__99970 = null;
var G__99971 = (0);
var G__99972 = (0);
seq__99788_99948 = G__99969;
chunk__99789_99949 = G__99970;
count__99790_99950 = G__99971;
i__99791_99951 = G__99972;
continue;
}
} else {
}
}
break;
}


var G__99973 = seq__99743_99941;
var G__99974 = chunk__99744_99942;
var G__99975 = count__99745_99943;
var G__99976 = (i__99746_99944 + (1));
seq__99743_99941 = G__99973;
chunk__99744_99942 = G__99974;
count__99745_99943 = G__99975;
i__99746_99944 = G__99976;
continue;
} else {
var temp__5735__auto___99977 = cljs.core.seq(seq__99743_99941);
if(temp__5735__auto___99977){
var seq__99743_99978__$1 = temp__5735__auto___99977;
if(cljs.core.chunked_seq_QMARK_(seq__99743_99978__$1)){
var c__4550__auto___99979 = cljs.core.chunk_first(seq__99743_99978__$1);
var G__99980 = cljs.core.chunk_rest(seq__99743_99978__$1);
var G__99981 = c__4550__auto___99979;
var G__99982 = cljs.core.count(c__4550__auto___99979);
var G__99983 = (0);
seq__99743_99941 = G__99980;
chunk__99744_99942 = G__99981;
count__99745_99943 = G__99982;
i__99746_99944 = G__99983;
continue;
} else {
var vec__99804_99984 = cljs.core.first(seq__99743_99978__$1);
var line_99985 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99804_99984,(0),null);
var cols_99986 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99804_99984,(1),null);
var seq__99807_99987 = cljs.core.seq(cols_99986);
var chunk__99808_99988 = null;
var count__99809_99989 = (0);
var i__99810_99990 = (0);
while(true){
if((i__99810_99990 < count__99809_99989)){
var vec__99817_99991 = chunk__99808_99988.cljs$core$IIndexed$_nth$arity$2(null,i__99810_99990);
var col_99992 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99817_99991,(0),null);
var infos_99993 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99817_99991,(1),null);
encode_cols(infos_99993,source_idx_99937,line_99985,col_99992);


var G__99994 = seq__99807_99987;
var G__99995 = chunk__99808_99988;
var G__99996 = count__99809_99989;
var G__99997 = (i__99810_99990 + (1));
seq__99807_99987 = G__99994;
chunk__99808_99988 = G__99995;
count__99809_99989 = G__99996;
i__99810_99990 = G__99997;
continue;
} else {
var temp__5735__auto___99998__$1 = cljs.core.seq(seq__99807_99987);
if(temp__5735__auto___99998__$1){
var seq__99807_99999__$1 = temp__5735__auto___99998__$1;
if(cljs.core.chunked_seq_QMARK_(seq__99807_99999__$1)){
var c__4550__auto___100000 = cljs.core.chunk_first(seq__99807_99999__$1);
var G__100001 = cljs.core.chunk_rest(seq__99807_99999__$1);
var G__100002 = c__4550__auto___100000;
var G__100003 = cljs.core.count(c__4550__auto___100000);
var G__100004 = (0);
seq__99807_99987 = G__100001;
chunk__99808_99988 = G__100002;
count__99809_99989 = G__100003;
i__99810_99990 = G__100004;
continue;
} else {
var vec__99820_100005 = cljs.core.first(seq__99807_99999__$1);
var col_100006 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99820_100005,(0),null);
var infos_100007 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99820_100005,(1),null);
encode_cols(infos_100007,source_idx_99937,line_99985,col_100006);


var G__100008 = cljs.core.next(seq__99807_99999__$1);
var G__100009 = null;
var G__100010 = (0);
var G__100011 = (0);
seq__99807_99987 = G__100008;
chunk__99808_99988 = G__100009;
count__99809_99989 = G__100010;
i__99810_99990 = G__100011;
continue;
}
} else {
}
}
break;
}


var G__100012 = cljs.core.next(seq__99743_99978__$1);
var G__100013 = null;
var G__100014 = (0);
var G__100015 = (0);
seq__99743_99941 = G__100012;
chunk__99744_99942 = G__100013;
count__99745_99943 = G__100014;
i__99746_99944 = G__100015;
continue;
}
} else {
}
}
break;
}


var G__100016 = seq__99561_99932;
var G__100017 = chunk__99562_99933;
var G__100018 = count__99563_99934;
var G__100019 = (i__99564_99935 + (1));
seq__99561_99932 = G__100016;
chunk__99562_99933 = G__100017;
count__99563_99934 = G__100018;
i__99564_99935 = G__100019;
continue;
} else {
var temp__5735__auto___100020 = cljs.core.seq(seq__99561_99932);
if(temp__5735__auto___100020){
var seq__99561_100021__$1 = temp__5735__auto___100020;
if(cljs.core.chunked_seq_QMARK_(seq__99561_100021__$1)){
var c__4550__auto___100022 = cljs.core.chunk_first(seq__99561_100021__$1);
var G__100023 = cljs.core.chunk_rest(seq__99561_100021__$1);
var G__100024 = c__4550__auto___100022;
var G__100025 = cljs.core.count(c__4550__auto___100022);
var G__100026 = (0);
seq__99561_99932 = G__100023;
chunk__99562_99933 = G__100024;
count__99563_99934 = G__100025;
i__99564_99935 = G__100026;
continue;
} else {
var vec__99823_100027 = cljs.core.first(seq__99561_100021__$1);
var source_idx_100028 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99823_100027,(0),null);
var vec__99826_100029 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99823_100027,(1),null);
var __100030 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99826_100029,(0),null);
var lines_100031__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99826_100029,(1),null);
var seq__99829_100032 = cljs.core.seq(lines_100031__$1);
var chunk__99830_100033 = null;
var count__99831_100034 = (0);
var i__99832_100035 = (0);
while(true){
if((i__99832_100035 < count__99831_100034)){
var vec__99871_100036 = chunk__99830_100033.cljs$core$IIndexed$_nth$arity$2(null,i__99832_100035);
var line_100037 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99871_100036,(0),null);
var cols_100038 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99871_100036,(1),null);
var seq__99874_100039 = cljs.core.seq(cols_100038);
var chunk__99875_100040 = null;
var count__99876_100041 = (0);
var i__99877_100042 = (0);
while(true){
if((i__99877_100042 < count__99876_100041)){
var vec__99884_100043 = chunk__99875_100040.cljs$core$IIndexed$_nth$arity$2(null,i__99877_100042);
var col_100044 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99884_100043,(0),null);
var infos_100045 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99884_100043,(1),null);
encode_cols(infos_100045,source_idx_100028,line_100037,col_100044);


var G__100046 = seq__99874_100039;
var G__100047 = chunk__99875_100040;
var G__100048 = count__99876_100041;
var G__100049 = (i__99877_100042 + (1));
seq__99874_100039 = G__100046;
chunk__99875_100040 = G__100047;
count__99876_100041 = G__100048;
i__99877_100042 = G__100049;
continue;
} else {
var temp__5735__auto___100050__$1 = cljs.core.seq(seq__99874_100039);
if(temp__5735__auto___100050__$1){
var seq__99874_100051__$1 = temp__5735__auto___100050__$1;
if(cljs.core.chunked_seq_QMARK_(seq__99874_100051__$1)){
var c__4550__auto___100052 = cljs.core.chunk_first(seq__99874_100051__$1);
var G__100053 = cljs.core.chunk_rest(seq__99874_100051__$1);
var G__100054 = c__4550__auto___100052;
var G__100055 = cljs.core.count(c__4550__auto___100052);
var G__100056 = (0);
seq__99874_100039 = G__100053;
chunk__99875_100040 = G__100054;
count__99876_100041 = G__100055;
i__99877_100042 = G__100056;
continue;
} else {
var vec__99887_100057 = cljs.core.first(seq__99874_100051__$1);
var col_100058 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99887_100057,(0),null);
var infos_100059 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99887_100057,(1),null);
encode_cols(infos_100059,source_idx_100028,line_100037,col_100058);


var G__100060 = cljs.core.next(seq__99874_100051__$1);
var G__100061 = null;
var G__100062 = (0);
var G__100063 = (0);
seq__99874_100039 = G__100060;
chunk__99875_100040 = G__100061;
count__99876_100041 = G__100062;
i__99877_100042 = G__100063;
continue;
}
} else {
}
}
break;
}


var G__100064 = seq__99829_100032;
var G__100065 = chunk__99830_100033;
var G__100066 = count__99831_100034;
var G__100067 = (i__99832_100035 + (1));
seq__99829_100032 = G__100064;
chunk__99830_100033 = G__100065;
count__99831_100034 = G__100066;
i__99832_100035 = G__100067;
continue;
} else {
var temp__5735__auto___100068__$1 = cljs.core.seq(seq__99829_100032);
if(temp__5735__auto___100068__$1){
var seq__99829_100069__$1 = temp__5735__auto___100068__$1;
if(cljs.core.chunked_seq_QMARK_(seq__99829_100069__$1)){
var c__4550__auto___100070 = cljs.core.chunk_first(seq__99829_100069__$1);
var G__100071 = cljs.core.chunk_rest(seq__99829_100069__$1);
var G__100072 = c__4550__auto___100070;
var G__100073 = cljs.core.count(c__4550__auto___100070);
var G__100074 = (0);
seq__99829_100032 = G__100071;
chunk__99830_100033 = G__100072;
count__99831_100034 = G__100073;
i__99832_100035 = G__100074;
continue;
} else {
var vec__99890_100075 = cljs.core.first(seq__99829_100069__$1);
var line_100076 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99890_100075,(0),null);
var cols_100077 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99890_100075,(1),null);
var seq__99893_100078 = cljs.core.seq(cols_100077);
var chunk__99894_100079 = null;
var count__99895_100080 = (0);
var i__99896_100081 = (0);
while(true){
if((i__99896_100081 < count__99895_100080)){
var vec__99903_100082 = chunk__99894_100079.cljs$core$IIndexed$_nth$arity$2(null,i__99896_100081);
var col_100083 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99903_100082,(0),null);
var infos_100084 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99903_100082,(1),null);
encode_cols(infos_100084,source_idx_100028,line_100076,col_100083);


var G__100085 = seq__99893_100078;
var G__100086 = chunk__99894_100079;
var G__100087 = count__99895_100080;
var G__100088 = (i__99896_100081 + (1));
seq__99893_100078 = G__100085;
chunk__99894_100079 = G__100086;
count__99895_100080 = G__100087;
i__99896_100081 = G__100088;
continue;
} else {
var temp__5735__auto___100089__$2 = cljs.core.seq(seq__99893_100078);
if(temp__5735__auto___100089__$2){
var seq__99893_100090__$1 = temp__5735__auto___100089__$2;
if(cljs.core.chunked_seq_QMARK_(seq__99893_100090__$1)){
var c__4550__auto___100091 = cljs.core.chunk_first(seq__99893_100090__$1);
var G__100092 = cljs.core.chunk_rest(seq__99893_100090__$1);
var G__100093 = c__4550__auto___100091;
var G__100094 = cljs.core.count(c__4550__auto___100091);
var G__100095 = (0);
seq__99893_100078 = G__100092;
chunk__99894_100079 = G__100093;
count__99895_100080 = G__100094;
i__99896_100081 = G__100095;
continue;
} else {
var vec__99906_100096 = cljs.core.first(seq__99893_100090__$1);
var col_100097 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99906_100096,(0),null);
var infos_100098 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99906_100096,(1),null);
encode_cols(infos_100098,source_idx_100028,line_100076,col_100097);


var G__100099 = cljs.core.next(seq__99893_100090__$1);
var G__100100 = null;
var G__100101 = (0);
var G__100102 = (0);
seq__99893_100078 = G__100099;
chunk__99894_100079 = G__100100;
count__99895_100080 = G__100101;
i__99896_100081 = G__100102;
continue;
}
} else {
}
}
break;
}


var G__100103 = cljs.core.next(seq__99829_100069__$1);
var G__100104 = null;
var G__100105 = (0);
var G__100106 = (0);
seq__99829_100032 = G__100103;
chunk__99830_100033 = G__100104;
count__99831_100034 = G__100105;
i__99832_100035 = G__100106;
continue;
}
} else {
}
}
break;
}


var G__100107 = cljs.core.next(seq__99561_100021__$1);
var G__100108 = null;
var G__100109 = (0);
var G__100110 = (0);
seq__99561_99932 = G__100107;
chunk__99562_99933 = G__100108;
count__99563_99934 = G__100109;
i__99564_99935 = G__100110;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__99909 = ({"version": (3), "file": cljs.core.cst$kw$file.cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((cljs.core.cst$kw$source_DASH_map_DASH_timestamp.cljs$core$IFn$_invoke$arity$1(opts) === true)?((function (paths,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (p1__99554_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__99554_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
});})(paths,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
:cljs.core.identity),((function (paths,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (p1__99555_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__99555_SHARP_,/\//));
});})(paths,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
);
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": cljs.core.cst$kw$lines.cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (p1__99556_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__99556_SHARP_);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(cljs.core.cst$kw$sources_DASH_content.cljs$core$IFn$_invoke$arity$1(opts))){
var G__99910 = G__99909;
var G__99911_100111 = G__99910;
var G__99912_100112 = "sourcesContent";
var G__99913_100113 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$sources_DASH_content.cljs$core$IFn$_invoke$arity$1(opts));
goog.object.set(G__99911_100111,G__99912_100112,G__99913_100113);

return G__99910;
} else {
return G__99909;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__100114 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__100114,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__100114,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__100117 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__100117,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__100117,(1),null);
var G__100123 = cljs.core.next(col_map_seq);
var G__100124 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__100117,col,infos,vec__100114,line,col_map){
return (function (v,p__100120){
var map__100121 = p__100120;
var map__100121__$1 = (((((!((map__100121 == null))))?(((((map__100121.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100121.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__100121):map__100121);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100121__$1,cljs.core.cst$kw$gline);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100121__$1,cljs.core.cst$kw$gcol);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__100117,col,infos,vec__100114,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__100123;
new_cols = G__100124;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__100125 = cljs.core.next(line_map_seq);
var G__100126 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__100125;
new_lines = G__100126;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__100127_100399 = cljs.core.seq(reverse_map);
var chunk__100128_100400 = null;
var count__100129_100401 = (0);
var i__100130_100402 = (0);
while(true){
if((i__100130_100402 < count__100129_100401)){
var vec__100265_100403 = chunk__100128_100400.cljs$core$IIndexed$_nth$arity$2(null,i__100130_100402);
var line_100404 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__100265_100403,(0),null);
var columns_100405 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__100265_100403,(1),null);
var seq__100268_100406 = cljs.core.seq(columns_100405);
var chunk__100269_100407 = null;
var count__100270_100408 = (0);
var i__100271_100409 = (0);
while(true){
if((i__100271_100409 < count__100270_100408)){
var vec__100302_100410 = chunk__100269_100407.cljs$core$IIndexed$_nth$arity$2(null,i__100271_100409);
var column_100411 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__100302_100410,(0),null);
var column_info_100412 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__100302_100410,(1),null);
var seq__100305_100413 = cljs.core.seq(column_info_100412);
var chunk__100306_100414 = null;
var count__100307_100415 = (0);
var i__100308_100416 = (0);
while(true){
if((i__100308_100416 < count__100307_100415)){
var map__100313_100417 = chunk__100306_100414.cljs$core$IIndexed$_nth$arity$2(null,i__100308_100416);
var map__100313_100418__$1 = (((((!((map__100313_100417 == null))))?(((((map__100313_100417.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100313_100417.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__100313_100417):map__100313_100417);
var gline_100419 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100313_100418__$1,cljs.core.cst$kw$gline);
var gcol_100420 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100313_100418__$1,cljs.core.cst$kw$gcol);
var name_100421 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100313_100418__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_100419], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__100305_100413,chunk__100306_100414,count__100307_100415,i__100308_100416,seq__100268_100406,chunk__100269_100407,count__100270_100408,i__100271_100409,seq__100127_100399,chunk__100128_100400,count__100129_100401,i__100130_100402,map__100313_100417,map__100313_100418__$1,gline_100419,gcol_100420,name_100421,vec__100302_100410,column_100411,column_info_100412,vec__100265_100403,line_100404,columns_100405,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_100420], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_100404,cljs.core.cst$kw$col,column_100411,cljs.core.cst$kw$name,name_100421], null));
});})(seq__100305_100413,chunk__100306_100414,count__100307_100415,i__100308_100416,seq__100268_100406,chunk__100269_100407,count__100270_100408,i__100271_100409,seq__100127_100399,chunk__100128_100400,count__100129_100401,i__100130_100402,map__100313_100417,map__100313_100418__$1,gline_100419,gcol_100420,name_100421,vec__100302_100410,column_100411,column_info_100412,vec__100265_100403,line_100404,columns_100405,inverted))
,cljs.core.sorted_map()));


var G__100422 = seq__100305_100413;
var G__100423 = chunk__100306_100414;
var G__100424 = count__100307_100415;
var G__100425 = (i__100308_100416 + (1));
seq__100305_100413 = G__100422;
chunk__100306_100414 = G__100423;
count__100307_100415 = G__100424;
i__100308_100416 = G__100425;
continue;
} else {
var temp__5735__auto___100426 = cljs.core.seq(seq__100305_100413);
if(temp__5735__auto___100426){
var seq__100305_100427__$1 = temp__5735__auto___100426;
if(cljs.core.chunked_seq_QMARK_(seq__100305_100427__$1)){
var c__4550__auto___100428 = cljs.core.chunk_first(seq__100305_100427__$1);
var G__100429 = cljs.core.chunk_rest(seq__100305_100427__$1);
var G__100430 = c__4550__auto___100428;
var G__100431 = cljs.core.count(c__4550__auto___100428);
var G__100432 = (0);
seq__100305_100413 = G__100429;
chunk__100306_100414 = G__100430;
count__100307_100415 = G__100431;
i__100308_100416 = G__100432;
continue;
} else {
var map__100315_100433 = cljs.core.first(seq__100305_100427__$1);
var map__100315_100434__$1 = (((((!((map__100315_100433 == null))))?(((((map__100315_100433.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100315_100433.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__100315_100433):map__100315_100433);
var gline_100435 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100315_100434__$1,cljs.core.cst$kw$gline);
var gcol_100436 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100315_100434__$1,cljs.core.cst$kw$gcol);
var name_100437 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100315_100434__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_100435], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__100305_100413,chunk__100306_100414,count__100307_100415,i__100308_100416,seq__100268_100406,chunk__100269_100407,count__100270_100408,i__100271_100409,seq__100127_100399,chunk__100128_100400,count__100129_100401,i__100130_100402,map__100315_100433,map__100315_100434__$1,gline_100435,gcol_100436,name_100437,seq__100305_100427__$1,temp__5735__auto___100426,vec__100302_100410,column_100411,column_info_100412,vec__100265_100403,line_100404,columns_100405,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_100436], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_100404,cljs.core.cst$kw$col,column_100411,cljs.core.cst$kw$name,name_100437], null));
});})(seq__100305_100413,chunk__100306_100414,count__100307_100415,i__100308_100416,seq__100268_100406,chunk__100269_100407,count__100270_100408,i__100271_100409,seq__100127_100399,chunk__100128_100400,count__100129_100401,i__100130_100402,map__100315_100433,map__100315_100434__$1,gline_100435,gcol_100436,name_100437,seq__100305_100427__$1,temp__5735__auto___100426,vec__100302_100410,column_100411,column_info_100412,vec__100265_100403,line_100404,columns_100405,inverted))
,cljs.core.sorted_map()));


var G__100438 = cljs.core.next(seq__100305_100427__$1);
var G__100439 = null;
var G__100440 = (0);
var G__100441 = (0);
seq__100305_100413 = G__100438;
chunk__100306_100414 = G__100439;
count__100307_100415 = G__100440;
i__100308_100416 = G__100441;
continue;
}
} else {
}
}
break;
}


var G__100442 = seq__100268_100406;
var G__100443 = chunk__100269_100407;
var G__100444 = count__100270_100408;
var G__100445 = (i__100271_100409 + (1));
seq__100268_100406 = G__100442;
chunk__100269_100407 = G__100443;
count__100270_100408 = G__100444;
i__100271_100409 = G__100445;
continue;
} else {
var temp__5735__auto___100446 = cljs.core.seq(seq__100268_100406);
if(temp__5735__auto___100446){
var seq__100268_100447__$1 = temp__5735__auto___100446;
if(cljs.core.chunked_seq_QMARK_(seq__100268_100447__$1)){
var c__4550__auto___100448 = cljs.core.chunk_first(seq__100268_100447__$1);
var G__100449 = cljs.core.chunk_rest(seq__100268_100447__$1);
var G__100450 = c__4550__auto___100448;
var G__100451 = cljs.core.count(c__4550__auto___100448);
var G__100452 = (0);
seq__100268_100406 = G__100449;
chunk__100269_100407 = G__100450;
count__100270_100408 = G__100451;
i__100271_100409 = G__100452;
continue;
} else {
var vec__100317_100453 = cljs.core.first(seq__100268_100447__$1);
var column_100454 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__100317_100453,(0),null);
var column_info_100455 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__100317_100453,(1),null);
var seq__100320_100456 = cljs.core.seq(column_info_100455);
var chunk__100321_100457 = null;
var count__100322_100458 = (0);
var i__100323_100459 = (0);
while(true){
if((i__100323_100459 < count__100322_100458)){
var map__100328_100460 = chunk__100321_100457.cljs$core$IIndexed$_nth$arity$2(null,i__100323_100459);
var map__100328_100461__$1 = (((((!((map__100328_100460 == null))))?(((((map__100328_100460.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100328_100460.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__100328_100460):map__100328_100460);
var gline_100462 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100328_100461__$1,cljs.core.cst$kw$gline);
var gcol_100463 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100328_100461__$1,cljs.core.cst$kw$gcol);
var name_100464 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100328_100461__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_100462], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__100320_100456,chunk__100321_100457,count__100322_100458,i__100323_100459,seq__100268_100406,chunk__100269_100407,count__100270_100408,i__100271_100409,seq__100127_100399,chunk__100128_100400,count__100129_100401,i__100130_100402,map__100328_100460,map__100328_100461__$1,gline_100462,gcol_100463,name_100464,vec__100317_100453,column_100454,column_info_100455,seq__100268_100447__$1,temp__5735__auto___100446,vec__100265_100403,line_100404,columns_100405,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_100463], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_100404,cljs.core.cst$kw$col,column_100454,cljs.core.cst$kw$name,name_100464], null));
});})(seq__100320_100456,chunk__100321_100457,count__100322_100458,i__100323_100459,seq__100268_100406,chunk__100269_100407,count__100270_100408,i__100271_100409,seq__100127_100399,chunk__100128_100400,count__100129_100401,i__100130_100402,map__100328_100460,map__100328_100461__$1,gline_100462,gcol_100463,name_100464,vec__100317_100453,column_100454,column_info_100455,seq__100268_100447__$1,temp__5735__auto___100446,vec__100265_100403,line_100404,columns_100405,inverted))
,cljs.core.sorted_map()));


var G__100465 = seq__100320_100456;
var G__100466 = chunk__100321_100457;
var G__100467 = count__100322_100458;
var G__100468 = (i__100323_100459 + (1));
seq__100320_100456 = G__100465;
chunk__100321_100457 = G__100466;
count__100322_100458 = G__100467;
i__100323_100459 = G__100468;
continue;
} else {
var temp__5735__auto___100469__$1 = cljs.core.seq(seq__100320_100456);
if(temp__5735__auto___100469__$1){
var seq__100320_100470__$1 = temp__5735__auto___100469__$1;
if(cljs.core.chunked_seq_QMARK_(seq__100320_100470__$1)){
var c__4550__auto___100471 = cljs.core.chunk_first(seq__100320_100470__$1);
var G__100472 = cljs.core.chunk_rest(seq__100320_100470__$1);
var G__100473 = c__4550__auto___100471;
var G__100474 = cljs.core.count(c__4550__auto___100471);
var G__100475 = (0);
seq__100320_100456 = G__100472;
chunk__100321_100457 = G__100473;
count__100322_100458 = G__100474;
i__100323_100459 = G__100475;
continue;
} else {
var map__100330_100476 = cljs.core.first(seq__100320_100470__$1);
var map__100330_100477__$1 = (((((!((map__100330_100476 == null))))?(((((map__100330_100476.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100330_100476.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__100330_100476):map__100330_100476);
var gline_100478 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100330_100477__$1,cljs.core.cst$kw$gline);
var gcol_100479 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100330_100477__$1,cljs.core.cst$kw$gcol);
var name_100480 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100330_100477__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_100478], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__100320_100456,chunk__100321_100457,count__100322_100458,i__100323_100459,seq__100268_100406,chunk__100269_100407,count__100270_100408,i__100271_100409,seq__100127_100399,chunk__100128_100400,count__100129_100401,i__100130_100402,map__100330_100476,map__100330_100477__$1,gline_100478,gcol_100479,name_100480,seq__100320_100470__$1,temp__5735__auto___100469__$1,vec__100317_100453,column_100454,column_info_100455,seq__100268_100447__$1,temp__5735__auto___100446,vec__100265_100403,line_100404,columns_100405,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_100479], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_100404,cljs.core.cst$kw$col,column_100454,cljs.core.cst$kw$name,name_100480], null));
});})(seq__100320_100456,chunk__100321_100457,count__100322_100458,i__100323_100459,seq__100268_100406,chunk__100269_100407,count__100270_100408,i__100271_100409,seq__100127_100399,chunk__100128_100400,count__100129_100401,i__100130_100402,map__100330_100476,map__100330_100477__$1,gline_100478,gcol_100479,name_100480,seq__100320_100470__$1,temp__5735__auto___100469__$1,vec__100317_100453,column_100454,column_info_100455,seq__100268_100447__$1,temp__5735__auto___100446,vec__100265_100403,line_100404,columns_100405,inverted))
,cljs.core.sorted_map()));


var G__100481 = cljs.core.next(seq__100320_100470__$1);
var G__100482 = null;
var G__100483 = (0);
var G__100484 = (0);
seq__100320_100456 = G__100481;
chunk__100321_100457 = G__100482;
count__100322_100458 = G__100483;
i__100323_100459 = G__100484;
continue;
}
} else {
}
}
break;
}


var G__100485 = cljs.core.next(seq__100268_100447__$1);
var G__100486 = null;
var G__100487 = (0);
var G__100488 = (0);
seq__100268_100406 = G__100485;
chunk__100269_100407 = G__100486;
count__100270_100408 = G__100487;
i__100271_100409 = G__100488;
continue;
}
} else {
}
}
break;
}


var G__100489 = seq__100127_100399;
var G__100490 = chunk__100128_100400;
var G__100491 = count__100129_100401;
var G__100492 = (i__100130_100402 + (1));
seq__100127_100399 = G__100489;
chunk__100128_100400 = G__100490;
count__100129_100401 = G__100491;
i__100130_100402 = G__100492;
continue;
} else {
var temp__5735__auto___100493 = cljs.core.seq(seq__100127_100399);
if(temp__5735__auto___100493){
var seq__100127_100494__$1 = temp__5735__auto___100493;
if(cljs.core.chunked_seq_QMARK_(seq__100127_100494__$1)){
var c__4550__auto___100495 = cljs.core.chunk_first(seq__100127_100494__$1);
var G__100496 = cljs.core.chunk_rest(seq__100127_100494__$1);
var G__100497 = c__4550__auto___100495;
var G__100498 = cljs.core.count(c__4550__auto___100495);
var G__100499 = (0);
seq__100127_100399 = G__100496;
chunk__100128_100400 = G__100497;
count__100129_100401 = G__100498;
i__100130_100402 = G__100499;
continue;
} else {
var vec__100332_100500 = cljs.core.first(seq__100127_100494__$1);
var line_100501 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__100332_100500,(0),null);
var columns_100502 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__100332_100500,(1),null);
var seq__100335_100503 = cljs.core.seq(columns_100502);
var chunk__100336_100504 = null;
var count__100337_100505 = (0);
var i__100338_100506 = (0);
while(true){
if((i__100338_100506 < count__100337_100505)){
var vec__100369_100507 = chunk__100336_100504.cljs$core$IIndexed$_nth$arity$2(null,i__100338_100506);
var column_100508 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__100369_100507,(0),null);
var column_info_100509 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__100369_100507,(1),null);
var seq__100372_100510 = cljs.core.seq(column_info_100509);
var chunk__100373_100511 = null;
var count__100374_100512 = (0);
var i__100375_100513 = (0);
while(true){
if((i__100375_100513 < count__100374_100512)){
var map__100380_100514 = chunk__100373_100511.cljs$core$IIndexed$_nth$arity$2(null,i__100375_100513);
var map__100380_100515__$1 = (((((!((map__100380_100514 == null))))?(((((map__100380_100514.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100380_100514.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__100380_100514):map__100380_100514);
var gline_100516 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100380_100515__$1,cljs.core.cst$kw$gline);
var gcol_100517 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100380_100515__$1,cljs.core.cst$kw$gcol);
var name_100518 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100380_100515__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_100516], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__100372_100510,chunk__100373_100511,count__100374_100512,i__100375_100513,seq__100335_100503,chunk__100336_100504,count__100337_100505,i__100338_100506,seq__100127_100399,chunk__100128_100400,count__100129_100401,i__100130_100402,map__100380_100514,map__100380_100515__$1,gline_100516,gcol_100517,name_100518,vec__100369_100507,column_100508,column_info_100509,vec__100332_100500,line_100501,columns_100502,seq__100127_100494__$1,temp__5735__auto___100493,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_100517], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_100501,cljs.core.cst$kw$col,column_100508,cljs.core.cst$kw$name,name_100518], null));
});})(seq__100372_100510,chunk__100373_100511,count__100374_100512,i__100375_100513,seq__100335_100503,chunk__100336_100504,count__100337_100505,i__100338_100506,seq__100127_100399,chunk__100128_100400,count__100129_100401,i__100130_100402,map__100380_100514,map__100380_100515__$1,gline_100516,gcol_100517,name_100518,vec__100369_100507,column_100508,column_info_100509,vec__100332_100500,line_100501,columns_100502,seq__100127_100494__$1,temp__5735__auto___100493,inverted))
,cljs.core.sorted_map()));


var G__100519 = seq__100372_100510;
var G__100520 = chunk__100373_100511;
var G__100521 = count__100374_100512;
var G__100522 = (i__100375_100513 + (1));
seq__100372_100510 = G__100519;
chunk__100373_100511 = G__100520;
count__100374_100512 = G__100521;
i__100375_100513 = G__100522;
continue;
} else {
var temp__5735__auto___100523__$1 = cljs.core.seq(seq__100372_100510);
if(temp__5735__auto___100523__$1){
var seq__100372_100524__$1 = temp__5735__auto___100523__$1;
if(cljs.core.chunked_seq_QMARK_(seq__100372_100524__$1)){
var c__4550__auto___100525 = cljs.core.chunk_first(seq__100372_100524__$1);
var G__100526 = cljs.core.chunk_rest(seq__100372_100524__$1);
var G__100527 = c__4550__auto___100525;
var G__100528 = cljs.core.count(c__4550__auto___100525);
var G__100529 = (0);
seq__100372_100510 = G__100526;
chunk__100373_100511 = G__100527;
count__100374_100512 = G__100528;
i__100375_100513 = G__100529;
continue;
} else {
var map__100382_100530 = cljs.core.first(seq__100372_100524__$1);
var map__100382_100531__$1 = (((((!((map__100382_100530 == null))))?(((((map__100382_100530.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100382_100530.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__100382_100530):map__100382_100530);
var gline_100532 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100382_100531__$1,cljs.core.cst$kw$gline);
var gcol_100533 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100382_100531__$1,cljs.core.cst$kw$gcol);
var name_100534 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100382_100531__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_100532], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__100372_100510,chunk__100373_100511,count__100374_100512,i__100375_100513,seq__100335_100503,chunk__100336_100504,count__100337_100505,i__100338_100506,seq__100127_100399,chunk__100128_100400,count__100129_100401,i__100130_100402,map__100382_100530,map__100382_100531__$1,gline_100532,gcol_100533,name_100534,seq__100372_100524__$1,temp__5735__auto___100523__$1,vec__100369_100507,column_100508,column_info_100509,vec__100332_100500,line_100501,columns_100502,seq__100127_100494__$1,temp__5735__auto___100493,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_100533], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_100501,cljs.core.cst$kw$col,column_100508,cljs.core.cst$kw$name,name_100534], null));
});})(seq__100372_100510,chunk__100373_100511,count__100374_100512,i__100375_100513,seq__100335_100503,chunk__100336_100504,count__100337_100505,i__100338_100506,seq__100127_100399,chunk__100128_100400,count__100129_100401,i__100130_100402,map__100382_100530,map__100382_100531__$1,gline_100532,gcol_100533,name_100534,seq__100372_100524__$1,temp__5735__auto___100523__$1,vec__100369_100507,column_100508,column_info_100509,vec__100332_100500,line_100501,columns_100502,seq__100127_100494__$1,temp__5735__auto___100493,inverted))
,cljs.core.sorted_map()));


var G__100535 = cljs.core.next(seq__100372_100524__$1);
var G__100536 = null;
var G__100537 = (0);
var G__100538 = (0);
seq__100372_100510 = G__100535;
chunk__100373_100511 = G__100536;
count__100374_100512 = G__100537;
i__100375_100513 = G__100538;
continue;
}
} else {
}
}
break;
}


var G__100539 = seq__100335_100503;
var G__100540 = chunk__100336_100504;
var G__100541 = count__100337_100505;
var G__100542 = (i__100338_100506 + (1));
seq__100335_100503 = G__100539;
chunk__100336_100504 = G__100540;
count__100337_100505 = G__100541;
i__100338_100506 = G__100542;
continue;
} else {
var temp__5735__auto___100543__$1 = cljs.core.seq(seq__100335_100503);
if(temp__5735__auto___100543__$1){
var seq__100335_100544__$1 = temp__5735__auto___100543__$1;
if(cljs.core.chunked_seq_QMARK_(seq__100335_100544__$1)){
var c__4550__auto___100545 = cljs.core.chunk_first(seq__100335_100544__$1);
var G__100546 = cljs.core.chunk_rest(seq__100335_100544__$1);
var G__100547 = c__4550__auto___100545;
var G__100548 = cljs.core.count(c__4550__auto___100545);
var G__100549 = (0);
seq__100335_100503 = G__100546;
chunk__100336_100504 = G__100547;
count__100337_100505 = G__100548;
i__100338_100506 = G__100549;
continue;
} else {
var vec__100384_100550 = cljs.core.first(seq__100335_100544__$1);
var column_100551 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__100384_100550,(0),null);
var column_info_100552 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__100384_100550,(1),null);
var seq__100387_100553 = cljs.core.seq(column_info_100552);
var chunk__100388_100554 = null;
var count__100389_100555 = (0);
var i__100390_100556 = (0);
while(true){
if((i__100390_100556 < count__100389_100555)){
var map__100395_100557 = chunk__100388_100554.cljs$core$IIndexed$_nth$arity$2(null,i__100390_100556);
var map__100395_100558__$1 = (((((!((map__100395_100557 == null))))?(((((map__100395_100557.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100395_100557.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__100395_100557):map__100395_100557);
var gline_100559 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100395_100558__$1,cljs.core.cst$kw$gline);
var gcol_100560 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100395_100558__$1,cljs.core.cst$kw$gcol);
var name_100561 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100395_100558__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_100559], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__100387_100553,chunk__100388_100554,count__100389_100555,i__100390_100556,seq__100335_100503,chunk__100336_100504,count__100337_100505,i__100338_100506,seq__100127_100399,chunk__100128_100400,count__100129_100401,i__100130_100402,map__100395_100557,map__100395_100558__$1,gline_100559,gcol_100560,name_100561,vec__100384_100550,column_100551,column_info_100552,seq__100335_100544__$1,temp__5735__auto___100543__$1,vec__100332_100500,line_100501,columns_100502,seq__100127_100494__$1,temp__5735__auto___100493,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_100560], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_100501,cljs.core.cst$kw$col,column_100551,cljs.core.cst$kw$name,name_100561], null));
});})(seq__100387_100553,chunk__100388_100554,count__100389_100555,i__100390_100556,seq__100335_100503,chunk__100336_100504,count__100337_100505,i__100338_100506,seq__100127_100399,chunk__100128_100400,count__100129_100401,i__100130_100402,map__100395_100557,map__100395_100558__$1,gline_100559,gcol_100560,name_100561,vec__100384_100550,column_100551,column_info_100552,seq__100335_100544__$1,temp__5735__auto___100543__$1,vec__100332_100500,line_100501,columns_100502,seq__100127_100494__$1,temp__5735__auto___100493,inverted))
,cljs.core.sorted_map()));


var G__100562 = seq__100387_100553;
var G__100563 = chunk__100388_100554;
var G__100564 = count__100389_100555;
var G__100565 = (i__100390_100556 + (1));
seq__100387_100553 = G__100562;
chunk__100388_100554 = G__100563;
count__100389_100555 = G__100564;
i__100390_100556 = G__100565;
continue;
} else {
var temp__5735__auto___100566__$2 = cljs.core.seq(seq__100387_100553);
if(temp__5735__auto___100566__$2){
var seq__100387_100567__$1 = temp__5735__auto___100566__$2;
if(cljs.core.chunked_seq_QMARK_(seq__100387_100567__$1)){
var c__4550__auto___100568 = cljs.core.chunk_first(seq__100387_100567__$1);
var G__100569 = cljs.core.chunk_rest(seq__100387_100567__$1);
var G__100570 = c__4550__auto___100568;
var G__100571 = cljs.core.count(c__4550__auto___100568);
var G__100572 = (0);
seq__100387_100553 = G__100569;
chunk__100388_100554 = G__100570;
count__100389_100555 = G__100571;
i__100390_100556 = G__100572;
continue;
} else {
var map__100397_100573 = cljs.core.first(seq__100387_100567__$1);
var map__100397_100574__$1 = (((((!((map__100397_100573 == null))))?(((((map__100397_100573.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100397_100573.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__100397_100573):map__100397_100573);
var gline_100575 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100397_100574__$1,cljs.core.cst$kw$gline);
var gcol_100576 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100397_100574__$1,cljs.core.cst$kw$gcol);
var name_100577 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100397_100574__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_100575], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__100387_100553,chunk__100388_100554,count__100389_100555,i__100390_100556,seq__100335_100503,chunk__100336_100504,count__100337_100505,i__100338_100506,seq__100127_100399,chunk__100128_100400,count__100129_100401,i__100130_100402,map__100397_100573,map__100397_100574__$1,gline_100575,gcol_100576,name_100577,seq__100387_100567__$1,temp__5735__auto___100566__$2,vec__100384_100550,column_100551,column_info_100552,seq__100335_100544__$1,temp__5735__auto___100543__$1,vec__100332_100500,line_100501,columns_100502,seq__100127_100494__$1,temp__5735__auto___100493,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_100576], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_100501,cljs.core.cst$kw$col,column_100551,cljs.core.cst$kw$name,name_100577], null));
});})(seq__100387_100553,chunk__100388_100554,count__100389_100555,i__100390_100556,seq__100335_100503,chunk__100336_100504,count__100337_100505,i__100338_100506,seq__100127_100399,chunk__100128_100400,count__100129_100401,i__100130_100402,map__100397_100573,map__100397_100574__$1,gline_100575,gcol_100576,name_100577,seq__100387_100567__$1,temp__5735__auto___100566__$2,vec__100384_100550,column_100551,column_info_100552,seq__100335_100544__$1,temp__5735__auto___100543__$1,vec__100332_100500,line_100501,columns_100502,seq__100127_100494__$1,temp__5735__auto___100493,inverted))
,cljs.core.sorted_map()));


var G__100578 = cljs.core.next(seq__100387_100567__$1);
var G__100579 = null;
var G__100580 = (0);
var G__100581 = (0);
seq__100387_100553 = G__100578;
chunk__100388_100554 = G__100579;
count__100389_100555 = G__100580;
i__100390_100556 = G__100581;
continue;
}
} else {
}
}
break;
}


var G__100582 = cljs.core.next(seq__100335_100544__$1);
var G__100583 = null;
var G__100584 = (0);
var G__100585 = (0);
seq__100335_100503 = G__100582;
chunk__100336_100504 = G__100583;
count__100337_100505 = G__100584;
i__100338_100506 = G__100585;
continue;
}
} else {
}
}
break;
}


var G__100586 = cljs.core.next(seq__100127_100494__$1);
var G__100587 = null;
var G__100588 = (0);
var G__100589 = (0);
seq__100127_100399 = G__100586;
chunk__100128_100400 = G__100587;
count__100129_100401 = G__100588;
i__100130_100402 = G__100589;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});

//# sourceMappingURL=source_map.js.map?rel=1593113244590
