// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * Can sit in a flake pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__21292 = null;
var G__21292__0 = (function (){
return xf.call(null);
});
var G__21292__1 = (function (result){
return xf.call(null,result);
});
var G__21292__2 = (function (result,flake){
cljs.core._vreset_BANG_.call(null,fuel,(cljs.core._deref.call(null,fuel) + (1)));

if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return xf.call(null,result,flake);
});
G__21292 = function(result,flake){
switch(arguments.length){
case 0:
return G__21292__0.call(this);
case 1:
return G__21292__1.call(this,result);
case 2:
return G__21292__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21292.cljs$core$IFn$_invoke$arity$0 = G__21292__0;
G__21292.cljs$core$IFn$_invoke$arity$1 = G__21292__1;
G__21292.cljs$core$IFn$_invoke$arity$2 = G__21292__2;
return G__21292;
})()
});
});
/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__21293 = null;
var G__21293__0 = (function (){
return xf.call(null);
});
var G__21293__1 = (function (result){
return xf.call(null,result);
});
var G__21293__2 = (function (result,flakes){
cljs.core._vreset_BANG_.call(null,fuel,(cljs.core._deref.call(null,fuel) + cljs.core.count.call(null,flakes)));

return xf.call(null,result,flakes);
});
G__21293 = function(result,flakes){
switch(arguments.length){
case 0:
return G__21293__0.call(this);
case 1:
return G__21293__1.call(this,result);
case 2:
return G__21293__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21293.cljs$core$IFn$_invoke$arity$0 = G__21293__0;
G__21293.cljs$core$IFn$_invoke$arity$1 = G__21293__1;
G__21293.cljs$core$IFn$_invoke$arity$2 = G__21293__2;
return G__21293;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
cljs.core._vreset_BANG_.call(null,fuel,(cljs.core._deref.call(null,fuel) + n));

if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4126__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config.call(null,db,p,compact_QMARK_);
cljs.core._vreset_BANG_.call(null,cache,cljs.core.assoc_in.call(null,cljs.core._deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map));

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare.call(null,clojure.string.upper_case.call(null,a),clojure.string.upper_case.call(null,b));
if(cljs.core._EQ_.call(null,res,(0))){
return ((-1) * cljs.core.compare.call(null,a,b));
} else {
return res;
}
} else {
return cljs.core.compare.call(null,a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_.call(null,res)){
var G__21295 = res;
var G__21295__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.call(null,(function (p1__21294_SHARP_){
return cljs.core.get.call(null,p1__21294_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__21295):G__21295);
var G__21295__$2 = ((cljs.core._EQ_.call(null,"DESC",sortOrder))?cljs.core.reverse.call(null,G__21295__$1):G__21295__$1);
var G__21295__$3 = (cljs.core.truth_(offset)?cljs.core.drop.call(null,offset,G__21295__$2):G__21295__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.call(null,limit,G__21295__$3);
} else {
return G__21295__$3;
}
} else {
return res;
}
});
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__21297 = arguments.length;
switch (G__21297) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_21600){
var state_val_21601 = (state_21600[(1)]);
if((state_val_21601 === (65))){
var inst_21327 = (state_21600[(7)]);
var inst_21458 = (state_21600[(8)]);
var inst_21451 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21452 = cljs.core.deref.call(null,cache);
var inst_21453 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21454 = flake.o;
var inst_21455 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_21327);
var inst_21456 = [inst_21454,inst_21455];
var inst_21457 = (new cljs.core.PersistentVector(null,2,(5),inst_21453,inst_21456,null));
var inst_21458__$1 = cljs.core.get.call(null,inst_21452,inst_21457);
var state_21600__$1 = (function (){var statearr_21602 = state_21600;
(statearr_21602[(8)] = inst_21458__$1);

(statearr_21602[(9)] = inst_21451);

return statearr_21602;
})();
if(cljs.core.truth_(inst_21458__$1)){
var statearr_21603_21763 = state_21600__$1;
(statearr_21603_21763[(1)] = (68));

} else {
var statearr_21604_21764 = state_21600__$1;
(statearr_21604_21764[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (70))){
var inst_21451 = (state_21600[(9)]);
var inst_21476 = (state_21600[(2)]);
var inst_21477 = [inst_21476,offset_map];
var inst_21478 = (new cljs.core.PersistentVector(null,2,(5),inst_21451,inst_21477,null));
var state_21600__$1 = state_21600;
var statearr_21605_21765 = state_21600__$1;
(statearr_21605_21765[(2)] = inst_21478);

(statearr_21605_21765[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (62))){
var inst_21359 = (state_21600[(10)]);
var inst_21364 = (state_21600[(11)]);
var inst_21363 = (state_21600[(12)]);
var inst_21327 = (state_21600[(7)]);
var inst_21321 = (state_21600[(13)]);
var inst_21420 = (state_21600[(14)]);
var inst_21338 = (state_21600[(15)]);
var inst_21365 = (state_21600[(16)]);
var inst_21360 = (state_21600[(17)]);
var inst_21436 = (state_21600[(18)]);
var inst_21361 = (state_21600[(19)]);
var inst_21362 = (state_21600[(20)]);
var inst_21438 = (function (){var p = inst_21365;
var pred_spec__$1 = inst_21321;
var orderBy = inst_21363;
var nested_select_spec = inst_21420;
var multi_QMARK_ = inst_21360;
var limit = inst_21362;
var offset = inst_21364;
var G__21422 = inst_21436;
var map__21304 = inst_21359;
var k = inst_21338;
var pred_spec_SINGLEQUOTE_ = inst_21327;
var ref_QMARK_ = inst_21361;
return (function (n){
return fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,nested_select_spec,n);
});
})();
var inst_21439 = inst_21438.call(null,inst_21436);
var state_21600__$1 = state_21600;
var statearr_21606_21766 = state_21600__$1;
(statearr_21606_21766[(2)] = inst_21439);

(statearr_21606_21766[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (74))){
var inst_21485 = (state_21600[(2)]);
var state_21600__$1 = state_21600;
if(cljs.core.truth_(inst_21485)){
var statearr_21607_21767 = state_21600__$1;
(statearr_21607_21767[(1)] = (75));

} else {
var statearr_21608_21768 = state_21600__$1;
(statearr_21608_21768[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (7))){
var inst_21308 = (state_21600[(21)]);
var state_21600__$1 = state_21600;
var statearr_21609_21769 = state_21600__$1;
(statearr_21609_21769[(2)] = inst_21308);

(statearr_21609_21769[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (59))){
var inst_21430 = (state_21600[(22)]);
var inst_21432 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_21433 = cljs.core.sequence.call(null,inst_21432,inst_21430);
var state_21600__$1 = state_21600;
var statearr_21610_21770 = state_21600__$1;
(statearr_21610_21770[(2)] = inst_21433);

(statearr_21610_21770[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (86))){
var inst_21359 = (state_21600[(10)]);
var inst_21364 = (state_21600[(11)]);
var inst_21363 = (state_21600[(12)]);
var inst_21327 = (state_21600[(7)]);
var inst_21321 = (state_21600[(13)]);
var inst_21516 = (state_21600[(23)]);
var inst_21338 = (state_21600[(15)]);
var inst_21365 = (state_21600[(16)]);
var inst_21360 = (state_21600[(17)]);
var inst_21361 = (state_21600[(19)]);
var inst_21498 = (state_21600[(24)]);
var inst_21362 = (state_21600[(20)]);
var inst_21518 = (function (){var p = inst_21365;
var pred_spec__$1 = inst_21321;
var orderBy = inst_21363;
var children = inst_21498;
var multi_QMARK_ = inst_21360;
var limit = inst_21362;
var offset = inst_21364;
var G__21510 = inst_21516;
var map__21304 = inst_21359;
var k = inst_21338;
var pred_spec_SINGLEQUOTE_ = inst_21327;
var ref_QMARK_ = inst_21361;
return (function (n){
return fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),true], null),n);
});
})();
var inst_21519 = inst_21518.call(null,inst_21516);
var state_21600__$1 = state_21600;
var statearr_21611_21771 = state_21600__$1;
(statearr_21611_21771[(2)] = inst_21519);

(statearr_21611_21771[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (20))){
var inst_21336 = (state_21600[(2)]);
var state_21600__$1 = state_21600;
var statearr_21612_21772 = state_21600__$1;
(statearr_21612_21772[(2)] = inst_21336);

(statearr_21612_21772[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (72))){
var inst_21327 = (state_21600[(7)]);
var inst_21482 = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(inst_21327);
var state_21600__$1 = state_21600;
var statearr_21613_21773 = state_21600__$1;
(statearr_21613_21773[(2)] = inst_21482);

(statearr_21613_21773[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (58))){
var inst_21429 = (state_21600[(2)]);
var inst_21430 = fluree.db.util.async.throw_err.call(null,inst_21429);
var state_21600__$1 = (function (){var statearr_21614 = state_21600;
(statearr_21614[(22)] = inst_21430);

return statearr_21614;
})();
if(cljs.core.truth_(fuel)){
var statearr_21615_21774 = state_21600__$1;
(statearr_21615_21774[(1)] = (59));

} else {
var statearr_21616_21775 = state_21600__$1;
(statearr_21616_21775[(1)] = (60));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (60))){
var inst_21430 = (state_21600[(22)]);
var state_21600__$1 = state_21600;
var statearr_21617_21776 = state_21600__$1;
(statearr_21617_21776[(2)] = inst_21430);

(statearr_21617_21776[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (27))){
var inst_21327 = (state_21600[(7)]);
var inst_21356 = cljs.core.apply.call(null,cljs.core.hash_map,inst_21327);
var state_21600__$1 = state_21600;
var statearr_21618_21777 = state_21600__$1;
(statearr_21618_21777[(2)] = inst_21356);

(statearr_21618_21777[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (1))){
var state_21600__$1 = state_21600;
var statearr_21619_21778 = state_21600__$1;
(statearr_21619_21778[(2)] = null);

(statearr_21619_21778[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (69))){
var inst_21327 = (state_21600[(7)]);
var inst_21461 = flake.o;
var inst_21462 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_21327);
var inst_21463 = fluree.db.dbproto._tag.call(null,db,inst_21461,inst_21462);
var state_21600__$1 = state_21600;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21600__$1,(71),inst_21463);
} else {
if((state_val_21601 === (101))){
var inst_21560 = (state_21600[(25)]);
var inst_21338 = (state_21600[(15)]);
var inst_21561 = (state_21600[(26)]);
var inst_21580 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21581 = cljs.core.assoc.call(null,acc,inst_21338,inst_21560);
var inst_21582 = [inst_21581,inst_21561];
var inst_21583 = (new cljs.core.PersistentVector(null,2,(5),inst_21580,inst_21582,null));
var state_21600__$1 = state_21600;
var statearr_21620_21779 = state_21600__$1;
(statearr_21620_21779[(2)] = inst_21583);

(statearr_21620_21779[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (24))){
var state_21600__$1 = state_21600;
var statearr_21621_21780 = state_21600__$1;
(statearr_21621_21780[(2)] = true);

(statearr_21621_21780[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (102))){
var state_21600__$1 = state_21600;
var statearr_21622_21781 = state_21600__$1;
(statearr_21622_21781[(1)] = (104));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (55))){
var inst_21327 = (state_21600[(7)]);
var inst_21449 = new cljs.core.Keyword(null,"tag?","tag?",1714008252).cljs$core$IFn$_invoke$arity$1(inst_21327);
var state_21600__$1 = state_21600;
if(cljs.core.truth_(inst_21449)){
var statearr_21624_21782 = state_21600__$1;
(statearr_21624_21782[(1)] = (65));

} else {
var statearr_21625_21783 = state_21600__$1;
(statearr_21625_21783[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (85))){
var inst_21516 = (state_21600[(2)]);
var state_21600__$1 = (function (){var statearr_21626 = state_21600;
(statearr_21626[(23)] = inst_21516);

return statearr_21626;
})();
var statearr_21627_21784 = state_21600__$1;
(statearr_21627_21784[(1)] = (86));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (39))){
var inst_21365 = (state_21600[(16)]);
var inst_21382 = cljs.core.update.call(null,offset_map,inst_21365,cljs.core.dec);
var state_21600__$1 = state_21600;
var statearr_21629_21785 = state_21600__$1;
(statearr_21629_21785[(2)] = inst_21382);

(statearr_21629_21785[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (88))){
var inst_21522 = (state_21600[(2)]);
var state_21600__$1 = state_21600;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21600__$1,(82),inst_21522);
} else {
if((state_val_21601 === (46))){
var inst_21405 = cljs.core.not.call(null,recur_QMARK_);
var state_21600__$1 = state_21600;
if(inst_21405){
var statearr_21630_21786 = state_21600__$1;
(statearr_21630_21786[(1)] = (48));

} else {
var statearr_21631_21787 = state_21600__$1;
(statearr_21631_21787[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (4))){
var inst_21298 = (state_21600[(2)]);
var state_21600__$1 = state_21600;
var statearr_21632_21788 = state_21600__$1;
(statearr_21632_21788[(2)] = inst_21298);

(statearr_21632_21788[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (77))){
var inst_21551 = (state_21600[(2)]);
var state_21600__$1 = state_21600;
var statearr_21633_21789 = state_21600__$1;
(statearr_21633_21789[(2)] = inst_21551);

(statearr_21633_21789[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (106))){
var inst_21591 = (state_21600[(2)]);
var state_21600__$1 = state_21600;
var statearr_21634_21790 = state_21600__$1;
(statearr_21634_21790[(2)] = inst_21591);

(statearr_21634_21790[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (95))){
var inst_21360 = (state_21600[(17)]);
var state_21600__$1 = state_21600;
var statearr_21635_21791 = state_21600__$1;
(statearr_21635_21791[(2)] = inst_21360);

(statearr_21635_21791[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (54))){
var inst_21327 = (state_21600[(7)]);
var inst_21417 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21418 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_21419 = (new cljs.core.PersistentVector(null,3,(5),inst_21417,inst_21418,null));
var inst_21420 = cljs.core.select_keys.call(null,inst_21327,inst_21419);
var inst_21421 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21423 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21424 = flake.o;
var inst_21425 = [inst_21424];
var inst_21426 = (new cljs.core.PersistentVector(null,1,(5),inst_21423,inst_21425,null));
var inst_21427 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_21426);
var state_21600__$1 = (function (){var statearr_21636 = state_21600;
(statearr_21636[(14)] = inst_21420);

(statearr_21636[(27)] = inst_21421);

return statearr_21636;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21600__$1,(58),inst_21427);
} else {
if((state_val_21601 === (92))){
var inst_21541 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21542 = flake.o;
var inst_21543 = [inst_21542,offset_map];
var inst_21544 = (new cljs.core.PersistentVector(null,2,(5),inst_21541,inst_21543,null));
var state_21600__$1 = state_21600;
var statearr_21637_21792 = state_21600__$1;
(statearr_21637_21792[(2)] = inst_21544);

(statearr_21637_21792[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (104))){
var inst_21561 = (state_21600[(26)]);
var inst_21586 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21587 = [acc,inst_21561];
var inst_21588 = (new cljs.core.PersistentVector(null,2,(5),inst_21586,inst_21587,null));
var state_21600__$1 = state_21600;
var statearr_21638_21793 = state_21600__$1;
(statearr_21638_21793[(2)] = inst_21588);

(statearr_21638_21793[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (15))){
var inst_21328 = (state_21600[(28)]);
var state_21600__$1 = state_21600;
var statearr_21639_21794 = state_21600__$1;
(statearr_21639_21794[(2)] = inst_21328);

(statearr_21639_21794[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (48))){
var inst_21327 = (state_21600[(7)]);
var inst_21407 = (state_21600[(29)]);
var inst_21407__$1 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_21327);
var state_21600__$1 = (function (){var statearr_21640 = state_21600;
(statearr_21640[(29)] = inst_21407__$1);

return statearr_21640;
})();
if(cljs.core.truth_(inst_21407__$1)){
var statearr_21641_21795 = state_21600__$1;
(statearr_21641_21795[(1)] = (51));

} else {
var statearr_21642_21796 = state_21600__$1;
(statearr_21642_21796[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (50))){
var inst_21415 = (state_21600[(2)]);
var state_21600__$1 = state_21600;
if(cljs.core.truth_(inst_21415)){
var statearr_21643_21797 = state_21600__$1;
(statearr_21643_21797[(1)] = (54));

} else {
var statearr_21644_21798 = state_21600__$1;
(statearr_21644_21798[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (75))){
var inst_21327 = (state_21600[(7)]);
var inst_21487 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21488 = flake.o;
var inst_21489 = [inst_21488];
var inst_21490 = (new cljs.core.PersistentVector(null,1,(5),inst_21487,inst_21489,null));
var inst_21491 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_21492 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(inst_21327);
var inst_21493 = [inst_21492];
var inst_21494 = cljs.core.PersistentHashMap.fromArrays(inst_21491,inst_21493);
var inst_21495 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_21490,inst_21494);
var state_21600__$1 = state_21600;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21600__$1,(78),inst_21495);
} else {
if((state_val_21601 === (99))){
var inst_21560 = (state_21600[(25)]);
var inst_21577 = (inst_21560 == null);
var inst_21578 = cljs.core.not.call(null,inst_21577);
var state_21600__$1 = state_21600;
if(inst_21578){
var statearr_21645_21799 = state_21600__$1;
(statearr_21645_21799[(1)] = (101));

} else {
var statearr_21646_21800 = state_21600__$1;
(statearr_21646_21800[(1)] = (102));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (21))){
var inst_21327 = (state_21600[(7)]);
var inst_21343 = inst_21327.cljs$lang$protocol_mask$partition0$;
var inst_21344 = (inst_21343 & (64));
var inst_21345 = inst_21327.cljs$core$ISeq$;
var inst_21346 = (cljs.core.PROTOCOL_SENTINEL === inst_21345);
var inst_21347 = ((inst_21344) || (inst_21346));
var state_21600__$1 = state_21600;
if(cljs.core.truth_(inst_21347)){
var statearr_21647_21801 = state_21600__$1;
(statearr_21647_21801[(1)] = (24));

} else {
var statearr_21648_21802 = state_21600__$1;
(statearr_21648_21802[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (31))){
var inst_21360 = (state_21600[(17)]);
var state_21600__$1 = state_21600;
var statearr_21649_21803 = state_21600__$1;
(statearr_21649_21803[(2)] = inst_21360);

(statearr_21649_21803[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (32))){
var inst_21377 = (state_21600[(2)]);
var state_21600__$1 = state_21600;
if(cljs.core.truth_(inst_21377)){
var statearr_21650_21804 = state_21600__$1;
(statearr_21650_21804[(1)] = (36));

} else {
var statearr_21651_21805 = state_21600__$1;
(statearr_21651_21805[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (40))){
var inst_21364 = (state_21600[(11)]);
var inst_21365 = (state_21600[(16)]);
var inst_21384 = (inst_21364 - (1));
var inst_21385 = cljs.core.assoc.call(null,offset_map,inst_21365,inst_21384);
var state_21600__$1 = state_21600;
var statearr_21652_21806 = state_21600__$1;
(statearr_21652_21806[(2)] = inst_21385);

(statearr_21652_21806[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (91))){
var inst_21549 = (state_21600[(2)]);
var state_21600__$1 = state_21600;
var statearr_21653_21807 = state_21600__$1;
(statearr_21653_21807[(2)] = inst_21549);

(statearr_21653_21807[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (56))){
var inst_21555 = (state_21600[(2)]);
var state_21600__$1 = state_21600;
var statearr_21654_21808 = state_21600__$1;
(statearr_21654_21808[(2)] = inst_21555);

(statearr_21654_21808[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (33))){
var inst_21364 = (state_21600[(11)]);
var inst_21365 = (state_21600[(16)]);
var inst_21368 = cljs.core.not_EQ_.call(null,(0),inst_21364);
var inst_21369 = cljs.core.get.call(null,offset_map,inst_21365);
var inst_21370 = cljs.core.not_EQ_.call(null,(0),inst_21369);
var inst_21371 = ((inst_21368) && (inst_21370));
var state_21600__$1 = state_21600;
var statearr_21655_21809 = state_21600__$1;
(statearr_21655_21809[(2)] = inst_21371);

(statearr_21655_21809[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (13))){
var inst_21321 = (state_21600[(13)]);
var inst_21325 = cljs.core.assoc.call(null,inst_21321,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),componentFollow_QMARK_);
var state_21600__$1 = state_21600;
var statearr_21656_21810 = state_21600__$1;
(statearr_21656_21810[(2)] = inst_21325);

(statearr_21656_21810[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (22))){
var state_21600__$1 = state_21600;
var statearr_21657_21811 = state_21600__$1;
(statearr_21657_21811[(2)] = false);

(statearr_21657_21811[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (90))){
var state_21600__$1 = state_21600;
var statearr_21658_21812 = state_21600__$1;
(statearr_21658_21812[(1)] = (92));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (36))){
var inst_21365 = (state_21600[(16)]);
var inst_21379 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21380 = cljs.core.get.call(null,offset_map,inst_21365);
var state_21600__$1 = (function (){var statearr_21660 = state_21600;
(statearr_21660[(30)] = inst_21379);

return statearr_21660;
})();
if(cljs.core.truth_(inst_21380)){
var statearr_21661_21813 = state_21600__$1;
(statearr_21661_21813[(1)] = (39));

} else {
var statearr_21662_21814 = state_21600__$1;
(statearr_21662_21814[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (41))){
var inst_21379 = (state_21600[(30)]);
var inst_21387 = (state_21600[(2)]);
var inst_21388 = [null,inst_21387];
var inst_21389 = (new cljs.core.PersistentVector(null,2,(5),inst_21379,inst_21388,null));
var state_21600__$1 = state_21600;
var statearr_21663_21815 = state_21600__$1;
(statearr_21663_21815[(2)] = inst_21389);

(statearr_21663_21815[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (89))){
var inst_21532 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21533 = ["_id"];
var inst_21534 = flake.o;
var inst_21535 = [inst_21534];
var inst_21536 = cljs.core.PersistentHashMap.fromArrays(inst_21533,inst_21535);
var inst_21537 = [inst_21536,offset_map];
var inst_21538 = (new cljs.core.PersistentVector(null,2,(5),inst_21532,inst_21537,null));
var state_21600__$1 = state_21600;
var statearr_21664_21816 = state_21600__$1;
(statearr_21664_21816[(2)] = inst_21538);

(statearr_21664_21816[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (100))){
var inst_21595 = (state_21600[(2)]);
var _ = (function (){var statearr_21665 = state_21600;
(statearr_21665[(4)] = cljs.core.rest.call(null,(state_21600[(4)])));

return statearr_21665;
})();
var state_21600__$1 = state_21600;
var statearr_21666_21817 = state_21600__$1;
(statearr_21666_21817[(2)] = inst_21595);

(statearr_21666_21817[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (43))){
var inst_21360 = (state_21600[(17)]);
var state_21600__$1 = state_21600;
var statearr_21667_21818 = state_21600__$1;
(statearr_21667_21818[(2)] = inst_21360);

(statearr_21667_21818[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (61))){
var inst_21436 = (state_21600[(2)]);
var state_21600__$1 = (function (){var statearr_21668 = state_21600;
(statearr_21668[(18)] = inst_21436);

return statearr_21668;
})();
var statearr_21669_21819 = state_21600__$1;
(statearr_21669_21819[(1)] = (62));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (29))){
var inst_21359 = (state_21600[(10)]);
var inst_21360 = (state_21600[(17)]);
var inst_21359__$1 = (state_21600[(2)]);
var inst_21360__$1 = cljs.core.get.call(null,inst_21359__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_21361 = cljs.core.get.call(null,inst_21359__$1,new cljs.core.Keyword(null,"ref?","ref?",1932693720));
var inst_21362 = cljs.core.get.call(null,inst_21359__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_21363 = cljs.core.get.call(null,inst_21359__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_21364 = cljs.core.get.call(null,inst_21359__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_21365 = cljs.core.get.call(null,inst_21359__$1,new cljs.core.Keyword(null,"p","p",151049309));
var state_21600__$1 = (function (){var statearr_21671 = state_21600;
(statearr_21671[(10)] = inst_21359__$1);

(statearr_21671[(11)] = inst_21364);

(statearr_21671[(12)] = inst_21363);

(statearr_21671[(16)] = inst_21365);

(statearr_21671[(17)] = inst_21360__$1);

(statearr_21671[(19)] = inst_21361);

(statearr_21671[(20)] = inst_21362);

return statearr_21671;
})();
if(cljs.core.truth_(inst_21360__$1)){
var statearr_21672_21820 = state_21600__$1;
(statearr_21672_21820[(1)] = (30));

} else {
var statearr_21673_21821 = state_21600__$1;
(statearr_21673_21821[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (44))){
var inst_21399 = (state_21600[(2)]);
var state_21600__$1 = state_21600;
if(cljs.core.truth_(inst_21399)){
var statearr_21674_21822 = state_21600__$1;
(statearr_21674_21822[(1)] = (45));

} else {
var statearr_21675_21823 = state_21600__$1;
(statearr_21675_21823[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (93))){
var state_21600__$1 = state_21600;
var statearr_21676_21824 = state_21600__$1;
(statearr_21676_21824[(2)] = null);

(statearr_21676_21824[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (6))){
var inst_21310 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_21311 = (inst_21310 == null);
var state_21600__$1 = state_21600;
var statearr_21677_21825 = state_21600__$1;
(statearr_21677_21825[(2)] = inst_21311);

(statearr_21677_21825[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (28))){
var inst_21327 = (state_21600[(7)]);
var state_21600__$1 = state_21600;
var statearr_21678_21826 = state_21600__$1;
(statearr_21678_21826[(2)] = inst_21327);

(statearr_21678_21826[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (64))){
var inst_21442 = (state_21600[(2)]);
var state_21600__$1 = state_21600;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21600__$1,(57),inst_21442);
} else {
if((state_val_21601 === (103))){
var inst_21593 = (state_21600[(2)]);
var state_21600__$1 = state_21600;
var statearr_21679_21827 = state_21600__$1;
(statearr_21679_21827[(2)] = inst_21593);

(statearr_21679_21827[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (51))){
var inst_21407 = (state_21600[(29)]);
var state_21600__$1 = state_21600;
var statearr_21680_21828 = state_21600__$1;
(statearr_21680_21828[(2)] = inst_21407);

(statearr_21680_21828[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (25))){
var state_21600__$1 = state_21600;
var statearr_21681_21829 = state_21600__$1;
(statearr_21681_21829[(2)] = false);

(statearr_21681_21829[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (34))){
var inst_21364 = (state_21600[(11)]);
var state_21600__$1 = state_21600;
var statearr_21682_21830 = state_21600__$1;
(statearr_21682_21830[(2)] = inst_21364);

(statearr_21682_21830[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (17))){
var inst_21327 = (state_21600[(7)]);
var inst_21338 = (state_21600[(2)]);
var inst_21340 = (inst_21327 == null);
var inst_21341 = cljs.core.not.call(null,inst_21340);
var state_21600__$1 = (function (){var statearr_21683 = state_21600;
(statearr_21683[(15)] = inst_21338);

return statearr_21683;
})();
if(inst_21341){
var statearr_21684_21831 = state_21600__$1;
(statearr_21684_21831[(1)] = (21));

} else {
var statearr_21685_21832 = state_21600__$1;
(statearr_21685_21832[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (3))){
var inst_21598 = (state_21600[(2)]);
var state_21600__$1 = state_21600;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21600__$1,inst_21598);
} else {
if((state_val_21601 === (12))){
var inst_21321 = (state_21600[(13)]);
var state_21600__$1 = state_21600;
var statearr_21686_21833 = state_21600__$1;
(statearr_21686_21833[(2)] = inst_21321);

(statearr_21686_21833[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (2))){
var inst_21308 = (state_21600[(21)]);
var _ = (function (){var statearr_21687 = state_21600;
(statearr_21687[(4)] = cljs.core.cons.call(null,(5),(state_21600[(4)])));

return statearr_21687;
})();
var inst_21308__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_21600__$1 = (function (){var statearr_21688 = state_21600;
(statearr_21688[(21)] = inst_21308__$1);

return statearr_21688;
})();
if(cljs.core.truth_(inst_21308__$1)){
var statearr_21689_21834 = state_21600__$1;
(statearr_21689_21834[(1)] = (6));

} else {
var statearr_21690_21835 = state_21600__$1;
(statearr_21690_21835[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (66))){
var inst_21480 = (state_21600[(31)]);
var inst_21480__$1 = componentFollow_QMARK_;
var state_21600__$1 = (function (){var statearr_21691 = state_21600;
(statearr_21691[(31)] = inst_21480__$1);

return statearr_21691;
})();
if(cljs.core.truth_(inst_21480__$1)){
var statearr_21692_21836 = state_21600__$1;
(statearr_21692_21836[(1)] = (72));

} else {
var statearr_21693_21837 = state_21600__$1;
(statearr_21693_21837[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (23))){
var inst_21354 = (state_21600[(2)]);
var state_21600__$1 = state_21600;
if(cljs.core.truth_(inst_21354)){
var statearr_21694_21838 = state_21600__$1;
(statearr_21694_21838[(1)] = (27));

} else {
var statearr_21695_21839 = state_21600__$1;
(statearr_21695_21839[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (47))){
var inst_21557 = (state_21600[(2)]);
var state_21600__$1 = state_21600;
var statearr_21696_21840 = state_21600__$1;
(statearr_21696_21840[(2)] = inst_21557);

(statearr_21696_21840[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (35))){
var inst_21374 = (state_21600[(2)]);
var state_21600__$1 = state_21600;
var statearr_21697_21841 = state_21600__$1;
(statearr_21697_21841[(2)] = inst_21374);

(statearr_21697_21841[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (82))){
var inst_21509 = (state_21600[(32)]);
var inst_21524 = (state_21600[(2)]);
var inst_21525 = fluree.db.util.async.throw_err.call(null,inst_21524);
var inst_21526 = [inst_21525,offset_map];
var inst_21527 = (new cljs.core.PersistentVector(null,2,(5),inst_21509,inst_21526,null));
var state_21600__$1 = state_21600;
var statearr_21698_21842 = state_21600__$1;
(statearr_21698_21842[(2)] = inst_21527);

(statearr_21698_21842[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (76))){
var inst_21361 = (state_21600[(19)]);
var state_21600__$1 = state_21600;
if(cljs.core.truth_(inst_21361)){
var statearr_21699_21843 = state_21600__$1;
(statearr_21699_21843[(1)] = (89));

} else {
var statearr_21700_21844 = state_21600__$1;
(statearr_21700_21844[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (97))){
var inst_21567 = (state_21600[(2)]);
var state_21600__$1 = state_21600;
if(cljs.core.truth_(inst_21567)){
var statearr_21701_21845 = state_21600__$1;
(statearr_21701_21845[(1)] = (98));

} else {
var statearr_21702_21846 = state_21600__$1;
(statearr_21702_21846[(1)] = (99));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (19))){
var inst_21327 = (state_21600[(7)]);
var inst_21334 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_21327);
var state_21600__$1 = state_21600;
var statearr_21703_21847 = state_21600__$1;
(statearr_21703_21847[(2)] = inst_21334);

(statearr_21703_21847[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (57))){
var inst_21421 = (state_21600[(27)]);
var inst_21444 = (state_21600[(2)]);
var inst_21445 = fluree.db.util.async.throw_err.call(null,inst_21444);
var inst_21446 = [inst_21445,offset_map];
var inst_21447 = (new cljs.core.PersistentVector(null,2,(5),inst_21421,inst_21446,null));
var state_21600__$1 = state_21600;
var statearr_21704_21848 = state_21600__$1;
(statearr_21704_21848[(2)] = inst_21447);

(statearr_21704_21848[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (68))){
var inst_21458 = (state_21600[(8)]);
var state_21600__$1 = state_21600;
var statearr_21705_21849 = state_21600__$1;
(statearr_21705_21849[(2)] = inst_21458);

(statearr_21705_21849[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (11))){
var inst_21321 = (state_21600[(13)]);
var inst_21321__$1 = (state_21600[(2)]);
var inst_21322 = cljs.core.contains_QMARK_.call(null,inst_21321__$1,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651));
var state_21600__$1 = (function (){var statearr_21707 = state_21600;
(statearr_21707[(13)] = inst_21321__$1);

return statearr_21707;
})();
if(inst_21322){
var statearr_21708_21850 = state_21600__$1;
(statearr_21708_21850[(1)] = (12));

} else {
var statearr_21709_21851 = state_21600__$1;
(statearr_21709_21851[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (9))){
var inst_21316 = flake.p;
var inst_21317 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_21318 = fluree.db.query.fql.wildcard_pred_spec.call(null,db,cache,inst_21316,inst_21317);
var state_21600__$1 = state_21600;
var statearr_21710_21852 = state_21600__$1;
(statearr_21710_21852[(2)] = inst_21318);

(statearr_21710_21852[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (5))){
var _ = (function (){var statearr_21711 = state_21600;
(statearr_21711[(4)] = cljs.core.rest.call(null,(state_21600[(4)])));

return statearr_21711;
})();
var state_21600__$1 = state_21600;
var ex21706 = (state_21600__$1[(2)]);
var statearr_21712_21853 = state_21600__$1;
(statearr_21712_21853[(5)] = ex21706);


if((ex21706 instanceof Error)){
var statearr_21713_21854 = state_21600__$1;
(statearr_21713_21854[(1)] = (4));

(statearr_21713_21854[(5)] = null);

} else {
throw ex21706;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (83))){
var inst_21498 = (state_21600[(24)]);
var inst_21512 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_21513 = cljs.core.sequence.call(null,inst_21512,inst_21498);
var state_21600__$1 = state_21600;
var statearr_21714_21855 = state_21600__$1;
(statearr_21714_21855[(2)] = inst_21513);

(statearr_21714_21855[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (14))){
var inst_21328 = (state_21600[(28)]);
var inst_21327 = (state_21600[(7)]);
var inst_21327__$1 = (state_21600[(2)]);
var inst_21328__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_21327__$1);
var state_21600__$1 = (function (){var statearr_21715 = state_21600;
(statearr_21715[(28)] = inst_21328__$1);

(statearr_21715[(7)] = inst_21327__$1);

return statearr_21715;
})();
if(cljs.core.truth_(inst_21328__$1)){
var statearr_21716_21856 = state_21600__$1;
(statearr_21716_21856[(1)] = (15));

} else {
var statearr_21717_21857 = state_21600__$1;
(statearr_21717_21857[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (45))){
var inst_21401 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21402 = [null,offset_map];
var inst_21403 = (new cljs.core.PersistentVector(null,2,(5),inst_21401,inst_21402,null));
var state_21600__$1 = state_21600;
var statearr_21718_21858 = state_21600__$1;
(statearr_21718_21858[(2)] = inst_21403);

(statearr_21718_21858[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (53))){
var inst_21412 = (state_21600[(2)]);
var state_21600__$1 = state_21600;
var statearr_21719_21859 = state_21600__$1;
(statearr_21719_21859[(2)] = inst_21412);

(statearr_21719_21859[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (78))){
var inst_21498 = (state_21600[(24)]);
var inst_21497 = (state_21600[(2)]);
var inst_21498__$1 = fluree.db.util.async.throw_err.call(null,inst_21497);
var inst_21499 = cljs.core.empty_QMARK_.call(null,inst_21498__$1);
var state_21600__$1 = (function (){var statearr_21720 = state_21600;
(statearr_21720[(24)] = inst_21498__$1);

return statearr_21720;
})();
if(inst_21499){
var statearr_21721_21860 = state_21600__$1;
(statearr_21721_21860[(1)] = (79));

} else {
var statearr_21722_21861 = state_21600__$1;
(statearr_21722_21861[(1)] = (80));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (26))){
var inst_21351 = (state_21600[(2)]);
var state_21600__$1 = state_21600;
var statearr_21723_21862 = state_21600__$1;
(statearr_21723_21862[(2)] = inst_21351);

(statearr_21723_21862[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (16))){
var inst_21327 = (state_21600[(7)]);
var inst_21331 = (state_21600[(33)]);
var inst_21331__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_21327);
var state_21600__$1 = (function (){var statearr_21724 = state_21600;
(statearr_21724[(33)] = inst_21331__$1);

return statearr_21724;
})();
if(cljs.core.truth_(inst_21331__$1)){
var statearr_21725_21863 = state_21600__$1;
(statearr_21725_21863[(1)] = (18));

} else {
var statearr_21726_21864 = state_21600__$1;
(statearr_21726_21864[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (81))){
var inst_21529 = (state_21600[(2)]);
var state_21600__$1 = state_21600;
var statearr_21727_21865 = state_21600__$1;
(statearr_21727_21865[(2)] = inst_21529);

(statearr_21727_21865[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (79))){
var inst_21501 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21502 = ["_id"];
var inst_21503 = flake.o;
var inst_21504 = [inst_21503];
var inst_21505 = cljs.core.PersistentHashMap.fromArrays(inst_21502,inst_21504);
var inst_21506 = [inst_21505,offset_map];
var inst_21507 = (new cljs.core.PersistentVector(null,2,(5),inst_21501,inst_21506,null));
var state_21600__$1 = state_21600;
var statearr_21728_21866 = state_21600__$1;
(statearr_21728_21866[(2)] = inst_21507);

(statearr_21728_21866[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (38))){
var inst_21560 = (state_21600[(25)]);
var inst_21559 = (state_21600[(2)]);
var inst_21560__$1 = cljs.core.nth.call(null,inst_21559,(0),null);
var inst_21561 = cljs.core.nth.call(null,inst_21559,(1),null);
var inst_21562 = (inst_21560__$1 == null);
var inst_21563 = cljs.core.not.call(null,inst_21562);
var state_21600__$1 = (function (){var statearr_21729 = state_21600;
(statearr_21729[(25)] = inst_21560__$1);

(statearr_21729[(26)] = inst_21561);

return statearr_21729;
})();
if(inst_21563){
var statearr_21730_21867 = state_21600__$1;
(statearr_21730_21867[(1)] = (95));

} else {
var statearr_21731_21868 = state_21600__$1;
(statearr_21731_21868[(1)] = (96));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (98))){
var inst_21560 = (state_21600[(25)]);
var inst_21338 = (state_21600[(15)]);
var inst_21561 = (state_21600[(26)]);
var inst_21569 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21570 = cljs.core.PersistentVector.EMPTY;
var inst_21571 = cljs.core.get.call(null,acc,inst_21338,inst_21570);
var inst_21572 = cljs.core.conj.call(null,inst_21571,inst_21560);
var inst_21573 = cljs.core.assoc.call(null,acc,inst_21338,inst_21572);
var inst_21574 = [inst_21573,inst_21561];
var inst_21575 = (new cljs.core.PersistentVector(null,2,(5),inst_21569,inst_21574,null));
var state_21600__$1 = state_21600;
var statearr_21732_21869 = state_21600__$1;
(statearr_21732_21869[(2)] = inst_21575);

(statearr_21732_21869[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (87))){
var inst_21516 = (state_21600[(23)]);
var state_21600__$1 = state_21600;
var statearr_21733_21870 = state_21600__$1;
(statearr_21733_21870[(2)] = inst_21516);

(statearr_21733_21870[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (30))){
var inst_21364 = (state_21600[(11)]);
var state_21600__$1 = state_21600;
if(cljs.core.truth_(inst_21364)){
var statearr_21734_21871 = state_21600__$1;
(statearr_21734_21871[(1)] = (33));

} else {
var statearr_21735_21872 = state_21600__$1;
(statearr_21735_21872[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (73))){
var inst_21480 = (state_21600[(31)]);
var state_21600__$1 = state_21600;
var statearr_21736_21873 = state_21600__$1;
(statearr_21736_21873[(2)] = inst_21480);

(statearr_21736_21873[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (96))){
var state_21600__$1 = state_21600;
var statearr_21737_21874 = state_21600__$1;
(statearr_21737_21874[(2)] = false);

(statearr_21737_21874[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (10))){
var state_21600__$1 = state_21600;
var statearr_21738_21875 = state_21600__$1;
(statearr_21738_21875[(2)] = pred_spec);

(statearr_21738_21875[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (18))){
var inst_21331 = (state_21600[(33)]);
var state_21600__$1 = state_21600;
var statearr_21739_21876 = state_21600__$1;
(statearr_21739_21876[(2)] = inst_21331);

(statearr_21739_21876[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (105))){
var state_21600__$1 = state_21600;
var statearr_21740_21877 = state_21600__$1;
(statearr_21740_21877[(2)] = null);

(statearr_21740_21877[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (52))){
var inst_21327 = (state_21600[(7)]);
var inst_21410 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_21327);
var state_21600__$1 = state_21600;
var statearr_21741_21878 = state_21600__$1;
(statearr_21741_21878[(2)] = inst_21410);

(statearr_21741_21878[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (67))){
var inst_21553 = (state_21600[(2)]);
var state_21600__$1 = state_21600;
var statearr_21742_21879 = state_21600__$1;
(statearr_21742_21879[(2)] = inst_21553);

(statearr_21742_21879[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (71))){
var inst_21327 = (state_21600[(7)]);
var inst_21465 = (state_21600[(2)]);
var inst_21466 = fluree.db.util.async.throw_err.call(null,inst_21465);
var inst_21467 = cljs.core._deref.call(null,cache);
var inst_21468 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21469 = flake.o;
var inst_21470 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_21327);
var inst_21471 = [inst_21469,inst_21470];
var inst_21472 = (new cljs.core.PersistentVector(null,2,(5),inst_21468,inst_21471,null));
var inst_21473 = cljs.core.assoc.call(null,inst_21467,inst_21472,inst_21466);
var inst_21474 = cljs.core._vreset_BANG_.call(null,cache,inst_21473);
var state_21600__$1 = (function (){var statearr_21743 = state_21600;
(statearr_21743[(34)] = inst_21474);

return statearr_21743;
})();
var statearr_21744_21880 = state_21600__$1;
(statearr_21744_21880[(2)] = inst_21466);

(statearr_21744_21880[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (42))){
var inst_21363 = (state_21600[(12)]);
var inst_21338 = (state_21600[(15)]);
var inst_21362 = (state_21600[(20)]);
var inst_21392 = cljs.core.not.call(null,inst_21363);
var inst_21393 = cljs.core.get.call(null,acc,inst_21338);
var inst_21394 = cljs.core.count.call(null,inst_21393);
var inst_21395 = (inst_21394 >= inst_21362);
var inst_21396 = ((inst_21392) && (inst_21395));
var state_21600__$1 = state_21600;
var statearr_21745_21881 = state_21600__$1;
(statearr_21745_21881[(2)] = inst_21396);

(statearr_21745_21881[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (80))){
var inst_21509 = cljs.core.PersistentVector.EMPTY_NODE;
var state_21600__$1 = (function (){var statearr_21746 = state_21600;
(statearr_21746[(32)] = inst_21509);

return statearr_21746;
})();
if(cljs.core.truth_(fuel)){
var statearr_21747_21882 = state_21600__$1;
(statearr_21747_21882[(1)] = (83));

} else {
var statearr_21748_21883 = state_21600__$1;
(statearr_21748_21883[(1)] = (84));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (37))){
var inst_21360 = (state_21600[(17)]);
var state_21600__$1 = state_21600;
if(cljs.core.truth_(inst_21360)){
var statearr_21749_21884 = state_21600__$1;
(statearr_21749_21884[(1)] = (42));

} else {
var statearr_21750_21885 = state_21600__$1;
(statearr_21750_21885[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (63))){
var inst_21436 = (state_21600[(18)]);
var state_21600__$1 = state_21600;
var statearr_21751_21886 = state_21600__$1;
(statearr_21751_21886[(2)] = inst_21436);

(statearr_21751_21886[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (94))){
var inst_21547 = (state_21600[(2)]);
var state_21600__$1 = state_21600;
var statearr_21752_21887 = state_21600__$1;
(statearr_21752_21887[(2)] = inst_21547);

(statearr_21752_21887[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (8))){
var inst_21314 = (state_21600[(2)]);
var state_21600__$1 = state_21600;
if(cljs.core.truth_(inst_21314)){
var statearr_21753_21888 = state_21600__$1;
(statearr_21753_21888[(1)] = (9));

} else {
var statearr_21754_21889 = state_21600__$1;
(statearr_21754_21889[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (49))){
var state_21600__$1 = state_21600;
var statearr_21755_21890 = state_21600__$1;
(statearr_21755_21890[(2)] = false);

(statearr_21755_21890[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21601 === (84))){
var inst_21498 = (state_21600[(24)]);
var state_21600__$1 = state_21600;
var statearr_21756_21891 = state_21600__$1;
(statearr_21756_21891[(2)] = inst_21498);

(statearr_21756_21891[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2468__auto__ = null;
var fluree$db$query$fql$state_machine__2468__auto____0 = (function (){
var statearr_21757 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21757[(0)] = fluree$db$query$fql$state_machine__2468__auto__);

(statearr_21757[(1)] = (1));

return statearr_21757;
});
var fluree$db$query$fql$state_machine__2468__auto____1 = (function (state_21600){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_21600);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e21758){var ex__2471__auto__ = e21758;
var statearr_21759_21892 = state_21600;
(statearr_21759_21892[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_21600[(4)]))){
var statearr_21760_21893 = state_21600;
(statearr_21760_21893[(1)] = cljs.core.first.call(null,(state_21600[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21894 = state_21600;
state_21600 = G__21894;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2468__auto__ = function(state_21600){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2468__auto____1.call(this,state_21600);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2468__auto____0;
fluree$db$query$fql$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2468__auto____1;
return fluree$db$query$fql$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_21761 = f__2491__auto__.call(null);
(statearr_21761[(6)] = c__2490__auto__);

return statearr_21761;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid.call(null,subject_id);
var or__4126__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec.call(null,db,coll_id,cljs.core.get_in.call(null,base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null)));
var updated_spec = cljs.core.update.call(null,base_pred_spec,new cljs.core.Keyword(null,"select","select",1147833503),(function (sel){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,sel,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),cljs.core.merge.call(null,lookup_specs,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(sel))),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767));
}));
cljs.core._vreset_BANG_.call(null,cache,cljs.core.assoc.call(null,cljs.core._deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec));

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_22074){
var state_val_22075 = (state_22074[(1)]);
if((state_val_22075 === (7))){
var inst_22069 = (state_22074[(2)]);
var _ = (function (){var statearr_22076 = state_22074;
(statearr_22076[(4)] = cljs.core.rest.call(null,(state_22074[(4)])));

return statearr_22076;
})();
var state_22074__$1 = state_22074;
var statearr_22077_22172 = state_22074__$1;
(statearr_22077_22172[(2)] = inst_22069);

(statearr_22077_22172[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (59))){
var inst_21955 = (state_22074[(7)]);
var state_22074__$1 = state_22074;
var statearr_22078_22173 = state_22074__$1;
(statearr_22078_22173[(2)] = inst_21955);

(statearr_22078_22173[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (20))){
var inst_21964 = (state_22074[(8)]);
var inst_21961 = (state_22074[(2)]);
var inst_21962 = fluree.db.util.async.throw_err.call(null,inst_21961);
var inst_21963 = cljs.core.map.call(null,fluree.db.query.fql.s,inst_21962);
var inst_21964__$1 = cljs.core.not_empty.call(null,inst_21963);
var state_22074__$1 = (function (){var statearr_22079 = state_22074;
(statearr_22079[(8)] = inst_21964__$1);

return statearr_22079;
})();
if(cljs.core.truth_(inst_21964__$1)){
var statearr_22080_22174 = state_22074__$1;
(statearr_22080_22174[(1)] = (21));

} else {
var statearr_22081_22175 = state_22074__$1;
(statearr_22081_22175[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (58))){
var inst_21954 = (state_22074[(9)]);
var state_22074__$1 = state_22074;
var statearr_22082_22176 = state_22074__$1;
(statearr_22082_22176[(2)] = inst_21954);

(statearr_22082_22176[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (60))){
var inst_22061 = (state_22074[(2)]);
var state_22074__$1 = state_22074;
var statearr_22083_22177 = state_22074__$1;
(statearr_22083_22177[(2)] = inst_22061);

(statearr_22083_22177[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (27))){
var inst_21996 = (state_22074[(10)]);
var inst_21986 = (state_22074[(11)]);
var inst_21994 = (state_22074[(12)]);
var inst_21993 = cljs.core.seq.call(null,inst_21986);
var inst_21994__$1 = cljs.core.first.call(null,inst_21993);
var inst_21995 = cljs.core.next.call(null,inst_21993);
var inst_21996__$1 = cljs.core.not.call(null,inst_21994__$1);
var state_22074__$1 = (function (){var statearr_22084 = state_22074;
(statearr_22084[(10)] = inst_21996__$1);

(statearr_22084[(12)] = inst_21994__$1);

(statearr_22084[(13)] = inst_21995);

return statearr_22084;
})();
if(inst_21996__$1){
var statearr_22085_22178 = state_22074__$1;
(statearr_22085_22178[(1)] = (29));

} else {
var statearr_22086_22179 = state_22074__$1;
(statearr_22086_22179[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (1))){
var state_22074__$1 = state_22074;
var statearr_22087_22180 = state_22074__$1;
(statearr_22087_22180[(2)] = null);

(statearr_22087_22180[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (24))){
var inst_21964 = (state_22074[(8)]);
var inst_21970 = cljs.core.count.call(null,inst_21964);
var inst_21971 = fluree.db.query.fql.add_fuel.call(null,fuel,inst_21970,max_fuel);
var state_22074__$1 = state_22074;
var statearr_22088_22181 = state_22074__$1;
(statearr_22088_22181[(2)] = inst_21971);

(statearr_22088_22181[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (55))){
var inst_21953 = (state_22074[(14)]);
var state_22074__$1 = state_22074;
var statearr_22089_22182 = state_22074__$1;
(statearr_22089_22182[(2)] = inst_21953);

(statearr_22089_22182[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (39))){
var inst_21951 = (state_22074[(15)]);
var state_22074__$1 = state_22074;
var statearr_22090_22183 = state_22074__$1;
(statearr_22090_22183[(2)] = inst_21951);

(statearr_22090_22183[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (46))){
var inst_22049 = (state_22074[(2)]);
var state_22074__$1 = state_22074;
var statearr_22091_22184 = state_22074__$1;
(statearr_22091_22184[(2)] = inst_22049);

(statearr_22091_22184[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (4))){
var inst_21895 = (state_22074[(2)]);
var state_22074__$1 = state_22074;
var statearr_22092_22185 = state_22074__$1;
(statearr_22092_22185[(2)] = inst_21895);

(statearr_22092_22185[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (54))){
var inst_21988 = (state_22074[(16)]);
var inst_22040 = (state_22074[(2)]);
var inst_22041 = fluree.db.util.async.throw_err.call(null,inst_22040);
var inst_22042 = cljs.core.conj.call(null,inst_21988,inst_22041);
var state_22074__$1 = state_22074;
var statearr_22093_22186 = state_22074__$1;
(statearr_22093_22186[(2)] = inst_22042);

(statearr_22093_22186[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (15))){
var state_22074__$1 = state_22074;
var statearr_22094_22187 = state_22074__$1;
(statearr_22094_22187[(2)] = false);

(statearr_22094_22187[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (48))){
var inst_21988 = (state_22074[(16)]);
var state_22074__$1 = state_22074;
var statearr_22095_22188 = state_22074__$1;
(statearr_22095_22188[(2)] = inst_21988);

(statearr_22095_22188[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (50))){
var inst_21987 = (state_22074[(17)]);
var inst_21995 = (state_22074[(13)]);
var inst_22044 = (state_22074[(2)]);
var inst_22045 = (inst_21987 + (1));
var inst_21986 = inst_21995;
var inst_21987__$1 = inst_22045;
var inst_21988 = inst_22044;
var state_22074__$1 = (function (){var statearr_22096 = state_22074;
(statearr_22096[(11)] = inst_21986);

(statearr_22096[(17)] = inst_21987__$1);

(statearr_22096[(16)] = inst_21988);

return statearr_22096;
})();
var statearr_22097_22189 = state_22074__$1;
(statearr_22097_22189[(2)] = null);

(statearr_22097_22189[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (21))){
var state_22074__$1 = state_22074;
var statearr_22098_22190 = state_22074__$1;
(statearr_22098_22190[(2)] = fuel);

(statearr_22098_22190[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (31))){
var inst_22005 = (state_22074[(2)]);
var state_22074__$1 = state_22074;
if(cljs.core.truth_(inst_22005)){
var statearr_22099_22191 = state_22074__$1;
(statearr_22099_22191[(1)] = (35));

} else {
var statearr_22100_22192 = state_22074__$1;
(statearr_22100_22192[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (32))){
var inst_21952 = (state_22074[(18)]);
var inst_21987 = (state_22074[(17)]);
var inst_22000 = (inst_21987 >= inst_21952);
var state_22074__$1 = state_22074;
var statearr_22101_22193 = state_22074__$1;
(statearr_22101_22193[(2)] = inst_22000);

(statearr_22101_22193[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (40))){
var inst_22012 = (state_22074[(2)]);
var state_22074__$1 = state_22074;
if(cljs.core.truth_(inst_22012)){
var statearr_22102_22194 = state_22074__$1;
(statearr_22102_22194[(1)] = (41));

} else {
var statearr_22103_22195 = state_22074__$1;
(statearr_22103_22195[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (56))){
var inst_21954 = (state_22074[(9)]);
var state_22074__$1 = state_22074;
if(cljs.core.truth_(inst_21954)){
var statearr_22104_22196 = state_22074__$1;
(statearr_22104_22196[(1)] = (58));

} else {
var statearr_22105_22197 = state_22074__$1;
(statearr_22105_22197[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (33))){
var inst_21952 = (state_22074[(18)]);
var state_22074__$1 = state_22074;
var statearr_22106_22198 = state_22074__$1;
(statearr_22106_22198[(2)] = inst_21952);

(statearr_22106_22198[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (13))){
var inst_21945 = (state_22074[(2)]);
var state_22074__$1 = state_22074;
if(cljs.core.truth_(inst_21945)){
var statearr_22107_22199 = state_22074__$1;
(statearr_22107_22199[(1)] = (17));

} else {
var statearr_22108_22200 = state_22074__$1;
(statearr_22108_22200[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (22))){
var inst_21964 = (state_22074[(8)]);
var state_22074__$1 = state_22074;
var statearr_22110_22201 = state_22074__$1;
(statearr_22110_22201[(2)] = inst_21964);

(statearr_22110_22201[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (36))){
var inst_21951 = (state_22074[(15)]);
var state_22074__$1 = state_22074;
if(cljs.core.truth_(inst_21951)){
var statearr_22111_22202 = state_22074__$1;
(statearr_22111_22202[(1)] = (38));

} else {
var statearr_22112_22203 = state_22074__$1;
(statearr_22112_22203[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (41))){
var inst_21987 = (state_22074[(17)]);
var inst_21988 = (state_22074[(16)]);
var inst_21995 = (state_22074[(13)]);
var inst_22014 = (inst_21987 + (1));
var tmp22109 = inst_21988;
var inst_21986 = inst_21995;
var inst_21987__$1 = inst_22014;
var inst_21988__$1 = tmp22109;
var state_22074__$1 = (function (){var statearr_22113 = state_22074;
(statearr_22113[(11)] = inst_21986);

(statearr_22113[(17)] = inst_21987__$1);

(statearr_22113[(16)] = inst_21988__$1);

return statearr_22113;
})();
var statearr_22114_22204 = state_22074__$1;
(statearr_22114_22204[(2)] = null);

(statearr_22114_22204[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (43))){
var inst_22051 = (state_22074[(2)]);
var state_22074__$1 = state_22074;
var statearr_22115_22205 = state_22074__$1;
(statearr_22115_22205[(2)] = inst_22051);

(statearr_22115_22205[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (29))){
var inst_21996 = (state_22074[(10)]);
var state_22074__$1 = state_22074;
var statearr_22116_22206 = state_22074__$1;
(statearr_22116_22206[(2)] = inst_21996);

(statearr_22116_22206[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (44))){
var inst_21994 = (state_22074[(12)]);
var inst_22018 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22019 = [inst_21994];
var inst_22020 = (new cljs.core.PersistentVector(null,1,(5),inst_22018,inst_22019,null));
var inst_22021 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22020);
var state_22074__$1 = state_22074;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22074__$1,(47),inst_22021);
} else {
if((state_val_22075 === (6))){
var inst_21912 = (state_22074[(19)]);
var inst_21919 = (state_22074[(20)]);
var inst_21918 = cljs.core.seq.call(null,inst_21912);
var inst_21919__$1 = cljs.core.first.call(null,inst_21918);
var inst_21920 = cljs.core.next.call(null,inst_21918);
var inst_21921 = cljs.core.not.call(null,inst_21919__$1);
var state_22074__$1 = (function (){var statearr_22117 = state_22074;
(statearr_22117[(21)] = inst_21920);

(statearr_22117[(20)] = inst_21919__$1);

return statearr_22117;
})();
if(inst_21921){
var statearr_22118_22207 = state_22074__$1;
(statearr_22118_22207[(1)] = (8));

} else {
var statearr_22119_22208 = state_22074__$1;
(statearr_22119_22208[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (28))){
var inst_21953 = (state_22074[(14)]);
var inst_22055 = (state_22074[(2)]);
var state_22074__$1 = (function (){var statearr_22120 = state_22074;
(statearr_22120[(22)] = inst_22055);

return statearr_22120;
})();
if(cljs.core.truth_(inst_21953)){
var statearr_22121_22209 = state_22074__$1;
(statearr_22121_22209[(1)] = (55));

} else {
var statearr_22122_22210 = state_22074__$1;
(statearr_22122_22210[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (51))){
var inst_22024 = (state_22074[(23)]);
var inst_22033 = cljs.core.count.call(null,inst_22024);
var inst_22034 = fluree.db.query.fql.add_fuel.call(null,fuel,inst_22033,max_fuel);
var state_22074__$1 = state_22074;
var statearr_22123_22211 = state_22074__$1;
(statearr_22123_22211[(2)] = inst_22034);

(statearr_22123_22211[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (25))){
var state_22074__$1 = state_22074;
var statearr_22124_22212 = state_22074__$1;
(statearr_22124_22212[(2)] = null);

(statearr_22124_22212[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (34))){
var inst_22003 = (state_22074[(2)]);
var state_22074__$1 = state_22074;
var statearr_22125_22213 = state_22074__$1;
(statearr_22125_22213[(2)] = inst_22003);

(statearr_22125_22213[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (17))){
var inst_21929 = (state_22074[(24)]);
var inst_21947 = cljs.core.apply.call(null,cljs.core.hash_map,inst_21929);
var state_22074__$1 = state_22074;
var statearr_22126_22214 = state_22074__$1;
(statearr_22126_22214[(2)] = inst_21947);

(statearr_22126_22214[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (3))){
var inst_22072 = (state_22074[(2)]);
var state_22074__$1 = state_22074;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22074__$1,inst_22072);
} else {
if((state_val_22075 === (12))){
var state_22074__$1 = state_22074;
var statearr_22127_22215 = state_22074__$1;
(statearr_22127_22215[(2)] = false);

(statearr_22127_22215[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (2))){
var _ = (function (){var statearr_22128 = state_22074;
(statearr_22128[(4)] = cljs.core.cons.call(null,(5),(state_22074[(4)])));

return statearr_22128;
})();
var inst_21908 = reverse_refs_specs;
var inst_21909 = cljs.core.seq.call(null,inst_21908);
var inst_21910 = cljs.core.first.call(null,inst_21909);
var inst_21911 = cljs.core.next.call(null,inst_21909);
var inst_21912 = inst_21908;
var inst_21913 = null;
var state_22074__$1 = (function (){var statearr_22129 = state_22074;
(statearr_22129[(25)] = inst_21910);

(statearr_22129[(26)] = inst_21913);

(statearr_22129[(27)] = inst_21911);

(statearr_22129[(19)] = inst_21912);

return statearr_22129;
})();
var statearr_22130_22216 = state_22074__$1;
(statearr_22130_22216[(2)] = null);

(statearr_22130_22216[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (23))){
var inst_21968 = (state_22074[(2)]);
var state_22074__$1 = state_22074;
if(cljs.core.truth_(inst_21968)){
var statearr_22131_22217 = state_22074__$1;
(statearr_22131_22217[(1)] = (24));

} else {
var statearr_22132_22218 = state_22074__$1;
(statearr_22132_22218[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (47))){
var inst_21929 = (state_22074[(24)]);
var inst_22024 = (state_22074[(23)]);
var inst_22023 = (state_22074[(2)]);
var inst_22024__$1 = fluree.db.util.async.throw_err.call(null,inst_22023);
var inst_22025 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22026 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_22027 = (new cljs.core.PersistentVector(null,4,(5),inst_22025,inst_22026,null));
var inst_22028 = cljs.core.select_keys.call(null,inst_21929,inst_22027);
var inst_22029 = cljs.core.empty_QMARK_.call(null,inst_22024__$1);
var state_22074__$1 = (function (){var statearr_22133 = state_22074;
(statearr_22133[(28)] = inst_22028);

(statearr_22133[(23)] = inst_22024__$1);

return statearr_22133;
})();
if(inst_22029){
var statearr_22134_22219 = state_22074__$1;
(statearr_22134_22219[(1)] = (48));

} else {
var statearr_22135_22220 = state_22074__$1;
(statearr_22135_22220[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (35))){
var inst_21988 = (state_22074[(16)]);
var state_22074__$1 = state_22074;
var statearr_22136_22221 = state_22074__$1;
(statearr_22136_22221[(2)] = inst_21988);

(statearr_22136_22221[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (19))){
var inst_21928 = (state_22074[(29)]);
var inst_21950 = (state_22074[(2)]);
var inst_21951 = cljs.core.get.call(null,inst_21950,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_21952 = cljs.core.get.call(null,inst_21950,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_21953 = cljs.core.get.call(null,inst_21950,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_21954 = cljs.core.get.call(null,inst_21950,new cljs.core.Keyword(null,"name","name",1843675177));
var inst_21955 = cljs.core.get.call(null,inst_21950,new cljs.core.Keyword(null,"p","p",151049309));
var inst_21956 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21957 = [subject_id,inst_21928];
var inst_21958 = (new cljs.core.PersistentVector(null,2,(5),inst_21956,inst_21957,null));
var inst_21959 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_21958);
var state_22074__$1 = (function (){var statearr_22137 = state_22074;
(statearr_22137[(18)] = inst_21952);

(statearr_22137[(9)] = inst_21954);

(statearr_22137[(15)] = inst_21951);

(statearr_22137[(7)] = inst_21955);

(statearr_22137[(14)] = inst_21953);

return statearr_22137;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22074__$1,(20),inst_21959);
} else {
if((state_val_22075 === (57))){
var inst_21920 = (state_22074[(21)]);
var inst_21913 = (state_22074[(26)]);
var inst_22055 = (state_22074[(22)]);
var inst_22063 = (state_22074[(2)]);
var inst_22064 = cljs.core.assoc.call(null,inst_21913,inst_22063,inst_22055);
var inst_21912 = inst_21920;
var inst_21913__$1 = inst_22064;
var state_22074__$1 = (function (){var statearr_22138 = state_22074;
(statearr_22138[(26)] = inst_21913__$1);

(statearr_22138[(19)] = inst_21912);

return statearr_22138;
})();
var statearr_22139_22222 = state_22074__$1;
(statearr_22139_22222[(2)] = null);

(statearr_22139_22222[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (11))){
var inst_21929 = (state_22074[(24)]);
var inst_21934 = inst_21929.cljs$lang$protocol_mask$partition0$;
var inst_21935 = (inst_21934 & (64));
var inst_21936 = inst_21929.cljs$core$ISeq$;
var inst_21937 = (cljs.core.PROTOCOL_SENTINEL === inst_21936);
var inst_21938 = ((inst_21935) || (inst_21937));
var state_22074__$1 = state_22074;
if(cljs.core.truth_(inst_21938)){
var statearr_22141_22223 = state_22074__$1;
(statearr_22141_22223[(1)] = (14));

} else {
var statearr_22142_22224 = state_22074__$1;
(statearr_22142_22224[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (9))){
var inst_21929 = (state_22074[(24)]);
var inst_21919 = (state_22074[(20)]);
var inst_21928 = cljs.core.nth.call(null,inst_21919,(0),null);
var inst_21929__$1 = cljs.core.nth.call(null,inst_21919,(1),null);
var inst_21931 = (inst_21929__$1 == null);
var inst_21932 = cljs.core.not.call(null,inst_21931);
var state_22074__$1 = (function (){var statearr_22143 = state_22074;
(statearr_22143[(24)] = inst_21929__$1);

(statearr_22143[(29)] = inst_21928);

return statearr_22143;
})();
if(inst_21932){
var statearr_22144_22225 = state_22074__$1;
(statearr_22144_22225[(1)] = (11));

} else {
var statearr_22145_22226 = state_22074__$1;
(statearr_22145_22226[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (5))){
var _ = (function (){var statearr_22146 = state_22074;
(statearr_22146[(4)] = cljs.core.rest.call(null,(state_22074[(4)])));

return statearr_22146;
})();
var state_22074__$1 = state_22074;
var ex22140 = (state_22074__$1[(2)]);
var statearr_22147_22227 = state_22074__$1;
(statearr_22147_22227[(5)] = ex22140);


if((ex22140 instanceof Error)){
var statearr_22148_22228 = state_22074__$1;
(statearr_22148_22228[(1)] = (4));

(statearr_22148_22228[(5)] = null);

} else {
throw ex22140;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (14))){
var state_22074__$1 = state_22074;
var statearr_22149_22229 = state_22074__$1;
(statearr_22149_22229[(2)] = true);

(statearr_22149_22229[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (45))){
var state_22074__$1 = state_22074;
var statearr_22150_22230 = state_22074__$1;
(statearr_22150_22230[(2)] = null);

(statearr_22150_22230[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (53))){
var inst_22028 = (state_22074[(28)]);
var inst_22024 = (state_22074[(23)]);
var inst_22037 = (state_22074[(2)]);
var inst_22038 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22028,inst_22024);
var state_22074__$1 = (function (){var statearr_22151 = state_22074;
(statearr_22151[(30)] = inst_22037);

return statearr_22151;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22074__$1,(54),inst_22038);
} else {
if((state_val_22075 === (26))){
var inst_21964 = (state_22074[(8)]);
var inst_21974 = (state_22074[(2)]);
var inst_21982 = cljs.core.seq.call(null,inst_21964);
var inst_21983 = cljs.core.first.call(null,inst_21982);
var inst_21984 = cljs.core.next.call(null,inst_21982);
var inst_21985 = cljs.core.PersistentVector.EMPTY;
var inst_21986 = inst_21964;
var inst_21987 = (0);
var inst_21988 = inst_21985;
var state_22074__$1 = (function (){var statearr_22152 = state_22074;
(statearr_22152[(31)] = inst_21984);

(statearr_22152[(32)] = inst_21983);

(statearr_22152[(11)] = inst_21986);

(statearr_22152[(33)] = inst_21974);

(statearr_22152[(17)] = inst_21987);

(statearr_22152[(16)] = inst_21988);

return statearr_22152;
})();
var statearr_22153_22231 = state_22074__$1;
(statearr_22153_22231[(2)] = null);

(statearr_22153_22231[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (16))){
var inst_21942 = (state_22074[(2)]);
var state_22074__$1 = state_22074;
var statearr_22154_22232 = state_22074__$1;
(statearr_22154_22232[(2)] = inst_21942);

(statearr_22154_22232[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (38))){
var inst_21951 = (state_22074[(15)]);
var inst_21987 = (state_22074[(17)]);
var inst_22009 = (inst_21987 < inst_21951);
var state_22074__$1 = state_22074;
var statearr_22155_22233 = state_22074__$1;
(statearr_22155_22233[(2)] = inst_22009);

(statearr_22155_22233[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (30))){
var inst_21952 = (state_22074[(18)]);
var state_22074__$1 = state_22074;
if(cljs.core.truth_(inst_21952)){
var statearr_22156_22234 = state_22074__$1;
(statearr_22156_22234[(1)] = (32));

} else {
var statearr_22157_22235 = state_22074__$1;
(statearr_22157_22235[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (10))){
var inst_22067 = (state_22074[(2)]);
var state_22074__$1 = state_22074;
var statearr_22158_22236 = state_22074__$1;
(statearr_22158_22236[(2)] = inst_22067);

(statearr_22158_22236[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (18))){
var inst_21929 = (state_22074[(24)]);
var state_22074__$1 = state_22074;
var statearr_22159_22237 = state_22074__$1;
(statearr_22159_22237[(2)] = inst_21929);

(statearr_22159_22237[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (52))){
var state_22074__$1 = state_22074;
var statearr_22160_22238 = state_22074__$1;
(statearr_22160_22238[(2)] = null);

(statearr_22160_22238[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (42))){
var state_22074__$1 = state_22074;
var statearr_22161_22239 = state_22074__$1;
(statearr_22161_22239[(1)] = (44));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (37))){
var inst_22053 = (state_22074[(2)]);
var state_22074__$1 = state_22074;
var statearr_22163_22240 = state_22074__$1;
(statearr_22163_22240[(2)] = inst_22053);

(statearr_22163_22240[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (8))){
var inst_21913 = (state_22074[(26)]);
var state_22074__$1 = state_22074;
var statearr_22164_22241 = state_22074__$1;
(statearr_22164_22241[(2)] = inst_21913);

(statearr_22164_22241[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (49))){
var state_22074__$1 = state_22074;
if(cljs.core.truth_(fuel)){
var statearr_22165_22242 = state_22074__$1;
(statearr_22165_22242[(1)] = (51));

} else {
var statearr_22166_22243 = state_22074__$1;
(statearr_22166_22243[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2468__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2468__auto____0 = (function (){
var statearr_22167 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22167[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2468__auto__);

(statearr_22167[(1)] = (1));

return statearr_22167;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2468__auto____1 = (function (state_22074){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_22074);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e22168){var ex__2471__auto__ = e22168;
var statearr_22169_22244 = state_22074;
(statearr_22169_22244[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_22074[(4)]))){
var statearr_22170_22245 = state_22074;
(statearr_22170_22245[(1)] = cljs.core.first.call(null,(state_22074[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22246 = state_22074;
state_22074 = G__22246;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2468__auto__ = function(state_22074){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2468__auto____1.call(this,state_22074);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2468__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2468__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_22171 = f__2491__auto__.call(null);
(statearr_22171[(6)] = c__2490__auto__);

return statearr_22171;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_.call(null,pred_spec,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.call(null,(function (acc,spec){
var key_spec = cljs.core.key.call(null,spec);
var val_spec = (((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,spec)) == null))?cljs.core.assoc.call(null,cljs.core.val.call(null,spec),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val.call(null,spec));
return cljs.core.assoc.call(null,acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)], null)));
});
fluree.db.query.fql.get_recursion_map_multi = (function fluree$db$query$fql$get_recursion_map_multi(recursion_map,k,f,full_select_spec,seen_QMARK_){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.query.fql.o.call(null,f)], null)], null),cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,recursion_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,fluree.db.query.fql.o.call(null,f)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.query.fql.o.call(null,f)], null)], null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,new cljs.core.Keyword(null,"depth","depth",1768663640)], null),(0)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred-ids","pred-ids",-1902141555),k], null),f.p),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select-specs","select-specs",-681748023),f.p], null),full_select_spec),true], null);
});
fluree.db.query.fql.add_in_multi_flakes = (function fluree$db$query$fql$add_in_multi_flakes(acc,new_child_paths,k,f,db,cache,fuel,max_fuel,pred_spec,component_follow_QMARK_,parent_exists){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_22365){
var state_val_22366 = (state_22365[(1)]);
if((state_val_22366 === (7))){
var inst_22360 = (state_22365[(2)]);
var _ = (function (){var statearr_22367 = state_22365;
(statearr_22367[(4)] = cljs.core.rest.call(null,(state_22365[(4)])));

return statearr_22367;
})();
var state_22365__$1 = state_22365;
var statearr_22368_22423 = state_22365__$1;
(statearr_22368_22423[(2)] = inst_22360);

(statearr_22368_22423[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22366 === (20))){
var inst_22302 = (state_22365[(7)]);
var state_22365__$1 = state_22365;
var statearr_22369_22424 = state_22365__$1;
(statearr_22369_22424[(2)] = inst_22302);

(statearr_22369_22424[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22366 === (27))){
var inst_22267 = (state_22365[(8)]);
var inst_22323 = (state_22365[(9)]);
var inst_22342 = (state_22365[(2)]);
var inst_22343 = cljs.core.nth.call(null,inst_22342,(0),null);
var inst_22344 = cljs.core.nth.call(null,inst_22342,(1),null);
var inst_22345 = new cljs.core.Keyword(null,"_id","_id",-789960287).cljs$core$IFn$_invoke$arity$1(inst_22267);
var inst_22346 = fluree.db.query.fql.s.call(null,f);
var inst_22347 = cljs.core._EQ_.call(null,inst_22345,inst_22346);
var inst_22348 = cljs.core.empty_QMARK_.call(null,inst_22323);
var inst_22349 = ((inst_22347) || (inst_22348));
var state_22365__$1 = (function (){var statearr_22370 = state_22365;
(statearr_22370[(10)] = inst_22344);

(statearr_22370[(11)] = inst_22343);

return statearr_22370;
})();
if(cljs.core.truth_(inst_22349)){
var statearr_22371_22425 = state_22365__$1;
(statearr_22371_22425[(1)] = (30));

} else {
var statearr_22372_22426 = state_22365__$1;
(statearr_22372_22426[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22366 === (1))){
var state_22365__$1 = state_22365;
var statearr_22373_22427 = state_22365__$1;
(statearr_22373_22427[(2)] = null);

(statearr_22373_22427[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22366 === (24))){
var inst_22267 = (state_22365[(8)]);
var inst_22323 = (state_22365[(9)]);
var inst_22323__$1 = (state_22365[(2)]);
var inst_22324 = cljs.core.get_in.call(null,inst_22267,inst_22323__$1);
var inst_22328 = new cljs.core.Keyword(null,"_id","_id",-789960287).cljs$core$IFn$_invoke$arity$1(inst_22267);
var inst_22329 = fluree.db.query.fql.s.call(null,f);
var inst_22330 = cljs.core._EQ_.call(null,inst_22328,inst_22329);
var state_22365__$1 = (function (){var statearr_22374 = state_22365;
(statearr_22374[(12)] = inst_22324);

(statearr_22374[(9)] = inst_22323__$1);

return statearr_22374;
})();
if(inst_22330){
var statearr_22375_22428 = state_22365__$1;
(statearr_22375_22428[(1)] = (25));

} else {
var statearr_22376_22429 = state_22365__$1;
(statearr_22376_22429[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22366 === (4))){
var inst_22248 = (state_22365[(2)]);
var state_22365__$1 = state_22365;
var statearr_22377_22430 = state_22365__$1;
(statearr_22377_22430[(2)] = inst_22248);

(statearr_22377_22430[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22366 === (15))){
var inst_22285 = (state_22365[(13)]);
var state_22365__$1 = state_22365;
var statearr_22378_22431 = state_22365__$1;
(statearr_22378_22431[(2)] = inst_22285);

(statearr_22378_22431[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22366 === (21))){
var inst_22311 = (state_22365[(2)]);
var state_22365__$1 = state_22365;
var statearr_22379_22432 = state_22365__$1;
(statearr_22379_22432[(2)] = inst_22311);

(statearr_22379_22432[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22366 === (31))){
var inst_22267 = (state_22365[(8)]);
var inst_22343 = (state_22365[(11)]);
var inst_22323 = (state_22365[(9)]);
var inst_22352 = cljs.core.assoc_in.call(null,inst_22267,inst_22323,inst_22343);
var state_22365__$1 = state_22365;
var statearr_22380_22433 = state_22365__$1;
(statearr_22380_22433[(2)] = inst_22352);

(statearr_22380_22433[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22366 === (32))){
var inst_22267 = (state_22365[(8)]);
var inst_22274 = (state_22365[(14)]);
var inst_22354 = (state_22365[(2)]);
var inst_22355 = cljs.core.conj.call(null,inst_22267,inst_22354);
var inst_22266 = inst_22274;
var inst_22267__$1 = inst_22355;
var state_22365__$1 = (function (){var statearr_22381 = state_22365;
(statearr_22381[(8)] = inst_22267__$1);

(statearr_22381[(15)] = inst_22266);

return statearr_22381;
})();
var statearr_22382_22434 = state_22365__$1;
(statearr_22382_22434[(2)] = null);

(statearr_22382_22434[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22366 === (13))){
var inst_22267 = (state_22365[(8)]);
var inst_22282 = (state_22365[(16)]);
var inst_22282__$1 = (state_22365[(2)]);
var inst_22283 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22284 = [k];
var inst_22285 = (new cljs.core.PersistentVector(null,1,(5),inst_22283,inst_22284,null));
var inst_22286 = new cljs.core.Keyword(null,"_id","_id",-789960287).cljs$core$IFn$_invoke$arity$1(inst_22267);
var inst_22287 = fluree.db.query.fql.s.call(null,f);
var inst_22288 = cljs.core.not_EQ_.call(null,inst_22286,inst_22287);
var inst_22289 = cljs.core.empty_QMARK_.call(null,inst_22282__$1);
var inst_22290 = (!(inst_22289));
var inst_22291 = ((inst_22288) && (inst_22290));
var state_22365__$1 = (function (){var statearr_22383 = state_22365;
(statearr_22383[(13)] = inst_22285);

(statearr_22383[(16)] = inst_22282__$1);

return statearr_22383;
})();
if(cljs.core.truth_(inst_22291)){
var statearr_22384_22435 = state_22365__$1;
(statearr_22384_22435[(1)] = (14));

} else {
var statearr_22385_22436 = state_22365__$1;
(statearr_22385_22436[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22366 === (22))){
var inst_22316 = (state_22365[(17)]);
var inst_22320 = cljs.core.drop_last.call(null,inst_22316);
var state_22365__$1 = state_22365;
var statearr_22386_22437 = state_22365__$1;
(statearr_22386_22437[(2)] = inst_22320);

(statearr_22386_22437[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22366 === (29))){
var inst_22339 = (state_22365[(2)]);
var inst_22340 = fluree.db.util.async.throw_err.call(null,inst_22339);
var state_22365__$1 = state_22365;
var statearr_22387_22438 = state_22365__$1;
(statearr_22387_22438[(2)] = inst_22340);

(statearr_22387_22438[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22366 === (6))){
var inst_22273 = (state_22365[(18)]);
var inst_22266 = (state_22365[(15)]);
var inst_22272 = cljs.core.seq.call(null,inst_22266);
var inst_22273__$1 = cljs.core.first.call(null,inst_22272);
var inst_22274 = cljs.core.next.call(null,inst_22272);
var inst_22275 = cljs.core.not.call(null,inst_22273__$1);
var state_22365__$1 = (function (){var statearr_22388 = state_22365;
(statearr_22388[(14)] = inst_22274);

(statearr_22388[(18)] = inst_22273__$1);

return statearr_22388;
})();
if(inst_22275){
var statearr_22389_22439 = state_22365__$1;
(statearr_22389_22439[(1)] = (8));

} else {
var statearr_22390_22440 = state_22365__$1;
(statearr_22390_22440[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22366 === (28))){
var inst_22334 = (state_22365[(2)]);
var inst_22335 = fluree.db.util.async.throw_err.call(null,inst_22334);
var state_22365__$1 = state_22365;
var statearr_22391_22441 = state_22365__$1;
(statearr_22391_22441[(2)] = inst_22335);

(statearr_22391_22441[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22366 === (25))){
var inst_22267 = (state_22365[(8)]);
var inst_22332 = fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,inst_22267,pred_spec,f,component_follow_QMARK_,true);
var state_22365__$1 = state_22365;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22365__$1,(28),inst_22332);
} else {
if((state_val_22366 === (17))){
var inst_22267 = (state_22365[(8)]);
var inst_22261 = (state_22365[(19)]);
var inst_22274 = (state_22365[(14)]);
var inst_22293 = (state_22365[(20)]);
var inst_22264 = (state_22365[(21)]);
var inst_22263 = (state_22365[(22)]);
var inst_22273 = (state_22365[(18)]);
var inst_22294 = (state_22365[(23)]);
var inst_22266 = (state_22365[(15)]);
var inst_22296 = cljs.core.get_in.call(null,inst_22267,inst_22294);
var inst_22297 = (function (){var G__22257 = inst_22266;
var seq__22259 = inst_22264;
var first__22271 = inst_22273;
var keys_SINGLEQUOTE_ = inst_22294;
var r = inst_22274;
var child_path = inst_22293;
var acc__$1 = inst_22267;
var value = inst_22296;
var first__22260 = inst_22263;
var vec__22258 = inst_22261;
var vec__22269 = inst_22266;
var seq__22270 = inst_22274;
return (function (p1__22247_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"_id","_id",-789960287).cljs$core$IFn$_invoke$arity$1(p1__22247_SHARP_),cljs.core.first.call(null,child_path));
});
})();
var inst_22298 = cljs.core.filter.call(null,inst_22297,inst_22296);
var inst_22299 = cljs.core.first.call(null,inst_22298);
var inst_22300 = inst_22296.indexOf(inst_22299);
var inst_22301 = cljs.core.conj.call(null,inst_22294,inst_22300);
var inst_22302 = cljs.core.conj.call(null,inst_22301,k);
var inst_22303 = cljs.core.rest.call(null,inst_22293);
var inst_22304 = cljs.core.count.call(null,inst_22303);
var inst_22305 = (inst_22304 > (0));
var state_22365__$1 = (function (){var statearr_22392 = state_22365;
(statearr_22392[(7)] = inst_22302);

return statearr_22392;
})();
if(cljs.core.truth_(inst_22305)){
var statearr_22393_22442 = state_22365__$1;
(statearr_22393_22442[(1)] = (19));

} else {
var statearr_22394_22443 = state_22365__$1;
(statearr_22394_22443[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22366 === (3))){
var inst_22363 = (state_22365[(2)]);
var state_22365__$1 = state_22365;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22365__$1,inst_22363);
} else {
if((state_val_22366 === (12))){
var inst_22273 = (state_22365[(18)]);
var inst_22280 = cljs.core.drop_last.call(null,inst_22273);
var state_22365__$1 = state_22365;
var statearr_22395_22444 = state_22365__$1;
(statearr_22395_22444[(2)] = inst_22280);

(statearr_22395_22444[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22366 === (2))){
var inst_22261 = (state_22365[(19)]);
var _ = (function (){var statearr_22396 = state_22365;
(statearr_22396[(4)] = cljs.core.cons.call(null,(5),(state_22365[(4)])));

return statearr_22396;
})();
var inst_22261__$1 = new_child_paths;
var inst_22262 = cljs.core.seq.call(null,inst_22261__$1);
var inst_22263 = cljs.core.first.call(null,inst_22262);
var inst_22264 = cljs.core.next.call(null,inst_22262);
var inst_22265 = acc;
var inst_22266 = inst_22261__$1;
var inst_22267 = inst_22265;
var state_22365__$1 = (function (){var statearr_22397 = state_22365;
(statearr_22397[(8)] = inst_22267);

(statearr_22397[(19)] = inst_22261__$1);

(statearr_22397[(21)] = inst_22264);

(statearr_22397[(22)] = inst_22263);

(statearr_22397[(15)] = inst_22266);

return statearr_22397;
})();
var statearr_22398_22445 = state_22365__$1;
(statearr_22398_22445[(2)] = null);

(statearr_22398_22445[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22366 === (23))){
var inst_22316 = (state_22365[(17)]);
var state_22365__$1 = state_22365;
var statearr_22399_22446 = state_22365__$1;
(statearr_22399_22446[(2)] = inst_22316);

(statearr_22399_22446[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22366 === (19))){
var inst_22302 = (state_22365[(7)]);
var inst_22293 = (state_22365[(20)]);
var inst_22307 = cljs.core.rest.call(null,inst_22293);
var inst_22293__$1 = inst_22307;
var inst_22294 = inst_22302;
var state_22365__$1 = (function (){var statearr_22400 = state_22365;
(statearr_22400[(20)] = inst_22293__$1);

(statearr_22400[(23)] = inst_22294);

return statearr_22400;
})();
var statearr_22401_22447 = state_22365__$1;
(statearr_22401_22447[(2)] = null);

(statearr_22401_22447[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22366 === (11))){
var inst_22273 = (state_22365[(18)]);
var state_22365__$1 = state_22365;
var statearr_22403_22448 = state_22365__$1;
(statearr_22403_22448[(2)] = inst_22273);

(statearr_22403_22448[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22366 === (9))){
var state_22365__$1 = state_22365;
if(cljs.core.truth_(parent_exists)){
var statearr_22404_22449 = state_22365__$1;
(statearr_22404_22449[(1)] = (11));

} else {
var statearr_22405_22450 = state_22365__$1;
(statearr_22405_22450[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22366 === (5))){
var _ = (function (){var statearr_22406 = state_22365;
(statearr_22406[(4)] = cljs.core.rest.call(null,(state_22365[(4)])));

return statearr_22406;
})();
var state_22365__$1 = state_22365;
var ex22402 = (state_22365__$1[(2)]);
var statearr_22407_22451 = state_22365__$1;
(statearr_22407_22451[(5)] = ex22402);


if((ex22402 instanceof Error)){
var statearr_22408_22452 = state_22365__$1;
(statearr_22408_22452[(1)] = (4));

(statearr_22408_22452[(5)] = null);

} else {
throw ex22402;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22366 === (14))){
var inst_22285 = (state_22365[(13)]);
var inst_22282 = (state_22365[(16)]);
var inst_22293 = inst_22282;
var inst_22294 = inst_22285;
var state_22365__$1 = (function (){var statearr_22409 = state_22365;
(statearr_22409[(20)] = inst_22293);

(statearr_22409[(23)] = inst_22294);

return statearr_22409;
})();
var statearr_22410_22453 = state_22365__$1;
(statearr_22410_22453[(2)] = null);

(statearr_22410_22453[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22366 === (26))){
var inst_22324 = (state_22365[(12)]);
var inst_22337 = fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,inst_22324,pred_spec,f,component_follow_QMARK_,true);
var state_22365__$1 = state_22365;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22365__$1,(29),inst_22337);
} else {
if((state_val_22366 === (16))){
var inst_22316 = (state_22365[(17)]);
var inst_22316__$1 = (state_22365[(2)]);
var inst_22317 = cljs.core.count.call(null,inst_22316__$1);
var inst_22318 = (inst_22317 > (1));
var state_22365__$1 = (function (){var statearr_22411 = state_22365;
(statearr_22411[(17)] = inst_22316__$1);

return statearr_22411;
})();
if(cljs.core.truth_(inst_22318)){
var statearr_22412_22454 = state_22365__$1;
(statearr_22412_22454[(1)] = (22));

} else {
var statearr_22413_22455 = state_22365__$1;
(statearr_22413_22455[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22366 === (30))){
var inst_22343 = (state_22365[(11)]);
var state_22365__$1 = state_22365;
var statearr_22414_22456 = state_22365__$1;
(statearr_22414_22456[(2)] = inst_22343);

(statearr_22414_22456[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22366 === (10))){
var inst_22358 = (state_22365[(2)]);
var state_22365__$1 = state_22365;
var statearr_22415_22457 = state_22365__$1;
(statearr_22415_22457[(2)] = inst_22358);

(statearr_22415_22457[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22366 === (18))){
var inst_22313 = (state_22365[(2)]);
var state_22365__$1 = state_22365;
var statearr_22416_22458 = state_22365__$1;
(statearr_22416_22458[(2)] = inst_22313);

(statearr_22416_22458[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22366 === (8))){
var inst_22267 = (state_22365[(8)]);
var state_22365__$1 = state_22365;
var statearr_22417_22459 = state_22365__$1;
(statearr_22417_22459[(2)] = inst_22267);

(statearr_22417_22459[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$add_in_multi_flakes_$_state_machine__2468__auto__ = null;
var fluree$db$query$fql$add_in_multi_flakes_$_state_machine__2468__auto____0 = (function (){
var statearr_22418 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22418[(0)] = fluree$db$query$fql$add_in_multi_flakes_$_state_machine__2468__auto__);

(statearr_22418[(1)] = (1));

return statearr_22418;
});
var fluree$db$query$fql$add_in_multi_flakes_$_state_machine__2468__auto____1 = (function (state_22365){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_22365);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e22419){var ex__2471__auto__ = e22419;
var statearr_22420_22460 = state_22365;
(statearr_22420_22460[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_22365[(4)]))){
var statearr_22421_22461 = state_22365;
(statearr_22421_22461[(1)] = cljs.core.first.call(null,(state_22365[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22462 = state_22365;
state_22365 = G__22462;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$fql$add_in_multi_flakes_$_state_machine__2468__auto__ = function(state_22365){
switch(arguments.length){
case 0:
return fluree$db$query$fql$add_in_multi_flakes_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$fql$add_in_multi_flakes_$_state_machine__2468__auto____1.call(this,state_22365);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$add_in_multi_flakes_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$add_in_multi_flakes_$_state_machine__2468__auto____0;
fluree$db$query$fql$add_in_multi_flakes_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$add_in_multi_flakes_$_state_machine__2468__auto____1;
return fluree$db$query$fql$add_in_multi_flakes_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_22422 = f__2491__auto__.call(null);
(statearr_22422[(6)] = c__2490__auto__);

return statearr_22422;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
fluree.db.query.fql.flake__GT_recur_multi = (function fluree$db$query$fql$flake__GT_recur_multi(db,f,pred_spec,recursion_map,flakes,acc,fuel,max_fuel,select_spec,cache,component_follow_QMARK_){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_22575){
var state_val_22576 = (state_22575[(1)]);
if((state_val_22576 === (7))){
var inst_22478 = (state_22575[(7)]);
var inst_22478__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_22575__$1 = (function (){var statearr_22577 = state_22575;
(statearr_22577[(7)] = inst_22478__$1);

return statearr_22577;
})();
if(cljs.core.truth_(inst_22478__$1)){
var statearr_22578_22644 = state_22575__$1;
(statearr_22578_22644[(1)] = (9));

} else {
var statearr_22579_22645 = state_22575__$1;
(statearr_22579_22645[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22576 === (20))){
var inst_22485 = (state_22575[(8)]);
var inst_22473 = (state_22575[(9)]);
var inst_22495 = (state_22575[(10)]);
var inst_22527 = (state_22575[(2)]);
var inst_22528 = fluree.db.query.fql.add_in_multi_flakes.call(null,inst_22473,inst_22495,inst_22485,f,db,cache,fuel,max_fuel,pred_spec,component_follow_QMARK_,false);
var state_22575__$1 = (function (){var statearr_22580 = state_22575;
(statearr_22580[(11)] = inst_22527);

return statearr_22580;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22575__$1,(25),inst_22528);
} else {
if((state_val_22576 === (27))){
var inst_22497 = (state_22575[(12)]);
var inst_22534 = cljs.core.not.call(null,inst_22497);
var state_22575__$1 = state_22575;
var statearr_22581_22646 = state_22575__$1;
(statearr_22581_22646[(2)] = inst_22534);

(statearr_22581_22646[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22576 === (1))){
var state_22575__$1 = state_22575;
var statearr_22582_22647 = state_22575__$1;
(statearr_22582_22647[(2)] = null);

(statearr_22582_22647[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22576 === (24))){
var inst_22521 = (state_22575[(2)]);
var inst_22522 = fluree.db.util.async.throw_err.call(null,inst_22521);
var state_22575__$1 = state_22575;
var statearr_22583_22648 = state_22575__$1;
(statearr_22583_22648[(2)] = inst_22522);

(statearr_22583_22648[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22576 === (39))){
var inst_22553 = (state_22575[(13)]);
var inst_22555 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_22556 = cljs.core.sequence.call(null,inst_22555,inst_22553);
var state_22575__$1 = state_22575;
var statearr_22584_22649 = state_22575__$1;
(statearr_22584_22649[(2)] = inst_22556);

(statearr_22584_22649[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22576 === (4))){
var inst_22463 = (state_22575[(2)]);
var state_22575__$1 = state_22575;
var statearr_22585_22650 = state_22575__$1;
(statearr_22585_22650[(2)] = inst_22463);

(statearr_22585_22650[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22576 === (15))){
var inst_22503 = (state_22575[(14)]);
var state_22575__$1 = state_22575;
var statearr_22586_22651 = state_22575__$1;
(statearr_22586_22651[(2)] = inst_22503);

(statearr_22586_22651[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22576 === (21))){
var inst_22516 = (state_22575[(15)]);
var inst_22518 = f.o;
var inst_22519 = fluree.db.query.fql.resolve_reverse_refs.call(null,db,cache,fuel,max_fuel,inst_22518,inst_22516);
var state_22575__$1 = state_22575;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22575__$1,(24),inst_22519);
} else {
if((state_val_22576 === (31))){
var inst_22531 = (state_22575[(16)]);
var inst_22496 = (state_22575[(17)]);
var inst_22567 = (state_22575[(2)]);
var inst_22568 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22569 = [inst_22531,inst_22567,inst_22496];
var inst_22570 = (new cljs.core.PersistentVector(null,3,(5),inst_22568,inst_22569,null));
var _ = (function (){var statearr_22587 = state_22575;
(statearr_22587[(4)] = cljs.core.rest.call(null,(state_22575[(4)])));

return statearr_22587;
})();
var state_22575__$1 = state_22575;
var statearr_22588_22652 = state_22575__$1;
(statearr_22588_22652[(2)] = inst_22570);

(statearr_22588_22652[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22576 === (32))){
var inst_22527 = (state_22575[(11)]);
var inst_22541 = cljs.core.rest.call(null,flakes);
var inst_22542 = cljs.core.concat.call(null,inst_22541,inst_22527);
var state_22575__$1 = state_22575;
var statearr_22589_22653 = state_22575__$1;
(statearr_22589_22653[(2)] = inst_22542);

(statearr_22589_22653[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22576 === (40))){
var inst_22553 = (state_22575[(13)]);
var state_22575__$1 = state_22575;
var statearr_22590_22654 = state_22575__$1;
(statearr_22590_22654[(2)] = inst_22553);

(statearr_22590_22654[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22576 === (33))){
var state_22575__$1 = state_22575;
var statearr_22591_22655 = state_22575__$1;
(statearr_22591_22655[(1)] = (35));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22576 === (13))){
var state_22575__$1 = state_22575;
var statearr_22593_22656 = state_22575__$1;
(statearr_22593_22656[(2)] = false);

(statearr_22593_22656[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22576 === (22))){
var state_22575__$1 = state_22575;
var statearr_22594_22657 = state_22575__$1;
(statearr_22594_22657[(2)] = null);

(statearr_22594_22657[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22576 === (36))){
var state_22575__$1 = state_22575;
var statearr_22595_22658 = state_22575__$1;
(statearr_22595_22658[(2)] = null);

(statearr_22595_22658[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22576 === (41))){
var inst_22545 = (state_22575[(18)]);
var inst_22559 = (state_22575[(2)]);
var inst_22560 = cljs.core.concat.call(null,inst_22545,inst_22559);
var state_22575__$1 = state_22575;
var statearr_22596_22659 = state_22575__$1;
(statearr_22596_22659[(2)] = inst_22560);

(statearr_22596_22659[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22576 === (29))){
var inst_22538 = cljs.core.rest.call(null,flakes);
var state_22575__$1 = state_22575;
var statearr_22597_22660 = state_22575__$1;
(statearr_22597_22660[(2)] = inst_22538);

(statearr_22597_22660[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22576 === (6))){
var inst_22475 = (state_22575[(19)]);
var state_22575__$1 = state_22575;
var statearr_22598_22661 = state_22575__$1;
(statearr_22598_22661[(2)] = inst_22475);

(statearr_22598_22661[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22576 === (28))){
var inst_22536 = (state_22575[(2)]);
var state_22575__$1 = state_22575;
if(cljs.core.truth_(inst_22536)){
var statearr_22599_22662 = state_22575__$1;
(statearr_22599_22662[(1)] = (29));

} else {
var statearr_22600_22663 = state_22575__$1;
(statearr_22600_22663[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22576 === (25))){
var inst_22503 = (state_22575[(14)]);
var inst_22530 = (state_22575[(2)]);
var inst_22531 = fluree.db.util.async.throw_err.call(null,inst_22530);
var state_22575__$1 = (function (){var statearr_22601 = state_22575;
(statearr_22601[(16)] = inst_22531);

return statearr_22601;
})();
if(cljs.core.truth_(inst_22503)){
var statearr_22602_22664 = state_22575__$1;
(statearr_22602_22664[(1)] = (26));

} else {
var statearr_22603_22665 = state_22575__$1;
(statearr_22603_22665[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22576 === (34))){
var inst_22565 = (state_22575[(2)]);
var state_22575__$1 = state_22575;
var statearr_22604_22666 = state_22575__$1;
(statearr_22604_22666[(2)] = inst_22565);

(statearr_22604_22666[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22576 === (17))){
var inst_22508 = (state_22575[(2)]);
var state_22575__$1 = state_22575;
if(cljs.core.truth_(inst_22508)){
var statearr_22605_22667 = state_22575__$1;
(statearr_22605_22667[(1)] = (18));

} else {
var statearr_22606_22668 = state_22575__$1;
(statearr_22606_22668[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22576 === (3))){
var inst_22573 = (state_22575[(2)]);
var state_22575__$1 = state_22575;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22575__$1,inst_22573);
} else {
if((state_val_22576 === (12))){
var inst_22489 = (state_22575[(20)]);
var state_22575__$1 = state_22575;
var statearr_22607_22669 = state_22575__$1;
(statearr_22607_22669[(2)] = inst_22489);

(statearr_22607_22669[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22576 === (2))){
var inst_22475 = (state_22575[(19)]);
var _ = (function (){var statearr_22608 = state_22575;
(statearr_22608[(4)] = cljs.core.cons.call(null,(5),(state_22575[(4)])));

return statearr_22608;
})();
var inst_22472 = fluree.db.query.fql.s.call(null,f);
var inst_22473 = cljs.core.assoc.call(null,acc,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_22472);
var inst_22474 = fluree.db.query.fql.o.call(null,f);
var inst_22475__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_22575__$1 = (function (){var statearr_22609 = state_22575;
(statearr_22609[(21)] = inst_22474);

(statearr_22609[(9)] = inst_22473);

(statearr_22609[(19)] = inst_22475__$1);

return statearr_22609;
})();
if(cljs.core.truth_(inst_22475__$1)){
var statearr_22610_22670 = state_22575__$1;
(statearr_22610_22670[(1)] = (6));

} else {
var statearr_22611_22671 = state_22575__$1;
(statearr_22611_22671[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22576 === (23))){
var inst_22525 = (state_22575[(2)]);
var state_22575__$1 = state_22575;
var statearr_22612_22672 = state_22575__$1;
(statearr_22612_22672[(2)] = inst_22525);

(statearr_22612_22672[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22576 === (35))){
var inst_22474 = (state_22575[(21)]);
var inst_22545 = cljs.core.rest.call(null,flakes);
var inst_22547 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22548 = [inst_22474];
var inst_22549 = (new cljs.core.PersistentVector(null,1,(5),inst_22547,inst_22548,null));
var inst_22550 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22549);
var state_22575__$1 = (function (){var statearr_22613 = state_22575;
(statearr_22613[(18)] = inst_22545);

return statearr_22613;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22575__$1,(38),inst_22550);
} else {
if((state_val_22576 === (19))){
var inst_22496 = (state_22575[(17)]);
var inst_22516 = (state_22575[(15)]);
var inst_22511 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22512 = f.p;
var inst_22513 = [new cljs.core.Keyword(null,"select-specs","select-specs",-681748023),inst_22512];
var inst_22514 = (new cljs.core.PersistentVector(null,2,(5),inst_22511,inst_22513,null));
var inst_22515 = cljs.core.get_in.call(null,inst_22496,inst_22514);
var inst_22516__$1 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs.call(null,inst_22515);
var state_22575__$1 = (function (){var statearr_22614 = state_22575;
(statearr_22614[(15)] = inst_22516__$1);

return statearr_22614;
})();
if(cljs.core.truth_(inst_22516__$1)){
var statearr_22615_22673 = state_22575__$1;
(statearr_22615_22673[(1)] = (21));

} else {
var statearr_22616_22674 = state_22575__$1;
(statearr_22616_22674[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22576 === (11))){
var inst_22483 = (state_22575[(2)]);
var state_22575__$1 = state_22575;
var statearr_22618_22675 = state_22575__$1;
(statearr_22618_22675[(2)] = inst_22483);

(statearr_22618_22675[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22576 === (9))){
var inst_22478 = (state_22575[(7)]);
var state_22575__$1 = state_22575;
var statearr_22619_22676 = state_22575__$1;
(statearr_22619_22676[(2)] = inst_22478);

(statearr_22619_22676[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22576 === (5))){
var _ = (function (){var statearr_22620 = state_22575;
(statearr_22620[(4)] = cljs.core.rest.call(null,(state_22575[(4)])));

return statearr_22620;
})();
var state_22575__$1 = state_22575;
var ex22617 = (state_22575__$1[(2)]);
var statearr_22621_22677 = state_22575__$1;
(statearr_22621_22677[(5)] = ex22617);


if((ex22617 instanceof Error)){
var statearr_22622_22678 = state_22575__$1;
(statearr_22622_22678[(1)] = (4));

(statearr_22622_22678[(5)] = null);

} else {
throw ex22617;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22576 === (14))){
var inst_22496 = (state_22575[(17)]);
var inst_22485 = (state_22575[(8)]);
var inst_22503 = (state_22575[(14)]);
var inst_22493 = (state_22575[(2)]);
var inst_22494 = fluree.db.query.fql.get_recursion_map_multi.call(null,recursion_map,inst_22485,f,select_spec,inst_22493);
var inst_22495 = cljs.core.nth.call(null,inst_22494,(0),null);
var inst_22496__$1 = cljs.core.nth.call(null,inst_22494,(1),null);
var inst_22497 = cljs.core.nth.call(null,inst_22494,(2),null);
var inst_22498 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22499 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22500 = [inst_22485,new cljs.core.Keyword(null,"depth","depth",1768663640)];
var inst_22501 = (new cljs.core.PersistentVector(null,2,(5),inst_22499,inst_22500,null));
var inst_22502 = cljs.core.get_in.call(null,inst_22496__$1,inst_22501);
var inst_22503__$1 = (inst_22498 < inst_22502);
var state_22575__$1 = (function (){var statearr_22623 = state_22575;
(statearr_22623[(17)] = inst_22496__$1);

(statearr_22623[(12)] = inst_22497);

(statearr_22623[(10)] = inst_22495);

(statearr_22623[(14)] = inst_22503__$1);

return statearr_22623;
})();
if(cljs.core.truth_(inst_22503__$1)){
var statearr_22624_22679 = state_22575__$1;
(statearr_22624_22679[(1)] = (15));

} else {
var statearr_22625_22680 = state_22575__$1;
(statearr_22625_22680[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22576 === (26))){
var inst_22503 = (state_22575[(14)]);
var state_22575__$1 = state_22575;
var statearr_22626_22681 = state_22575__$1;
(statearr_22626_22681[(2)] = inst_22503);

(statearr_22626_22681[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22576 === (16))){
var inst_22497 = (state_22575[(12)]);
var inst_22506 = cljs.core.not.call(null,inst_22497);
var state_22575__$1 = state_22575;
var statearr_22627_22682 = state_22575__$1;
(statearr_22627_22682[(2)] = inst_22506);

(statearr_22627_22682[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22576 === (38))){
var inst_22552 = (state_22575[(2)]);
var inst_22553 = fluree.db.util.async.throw_err.call(null,inst_22552);
var state_22575__$1 = (function (){var statearr_22628 = state_22575;
(statearr_22628[(13)] = inst_22553);

return statearr_22628;
})();
if(cljs.core.truth_(fuel)){
var statearr_22629_22683 = state_22575__$1;
(statearr_22629_22683[(1)] = (39));

} else {
var statearr_22630_22684 = state_22575__$1;
(statearr_22630_22684[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22576 === (30))){
var inst_22527 = (state_22575[(11)]);
var state_22575__$1 = state_22575;
if(cljs.core.truth_(inst_22527)){
var statearr_22631_22685 = state_22575__$1;
(statearr_22631_22685[(1)] = (32));

} else {
var statearr_22632_22686 = state_22575__$1;
(statearr_22632_22686[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22576 === (10))){
var inst_22481 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_22575__$1 = state_22575;
var statearr_22633_22687 = state_22575__$1;
(statearr_22633_22687[(2)] = inst_22481);

(statearr_22633_22687[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22576 === (18))){
var state_22575__$1 = state_22575;
var statearr_22634_22688 = state_22575__$1;
(statearr_22634_22688[(2)] = null);

(statearr_22634_22688[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22576 === (37))){
var inst_22563 = (state_22575[(2)]);
var state_22575__$1 = state_22575;
var statearr_22635_22689 = state_22575__$1;
(statearr_22635_22689[(2)] = inst_22563);

(statearr_22635_22689[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22576 === (8))){
var inst_22489 = (state_22575[(20)]);
var inst_22474 = (state_22575[(21)]);
var inst_22485 = (state_22575[(8)]);
var inst_22485__$1 = (state_22575[(2)]);
var inst_22486 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22487 = [inst_22485__$1,inst_22474];
var inst_22488 = (new cljs.core.PersistentVector(null,2,(5),inst_22486,inst_22487,null));
var inst_22489__$1 = cljs.core.get_in.call(null,recursion_map,inst_22488);
var state_22575__$1 = (function (){var statearr_22636 = state_22575;
(statearr_22636[(20)] = inst_22489__$1);

(statearr_22636[(8)] = inst_22485__$1);

return statearr_22636;
})();
if(cljs.core.truth_(inst_22489__$1)){
var statearr_22637_22690 = state_22575__$1;
(statearr_22637_22690[(1)] = (12));

} else {
var statearr_22638_22691 = state_22575__$1;
(statearr_22638_22691[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__2468__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__2468__auto____0 = (function (){
var statearr_22639 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22639[(0)] = fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__2468__auto__);

(statearr_22639[(1)] = (1));

return statearr_22639;
});
var fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__2468__auto____1 = (function (state_22575){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_22575);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e22640){var ex__2471__auto__ = e22640;
var statearr_22641_22692 = state_22575;
(statearr_22641_22692[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_22575[(4)]))){
var statearr_22642_22693 = state_22575;
(statearr_22642_22693[(1)] = cljs.core.first.call(null,(state_22575[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22694 = state_22575;
state_22575 = G__22694;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__2468__auto__ = function(state_22575){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__2468__auto____1.call(this,state_22575);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__2468__auto____0;
fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__2468__auto____1;
return fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_22643 = f__2491__auto__.call(null);
(statearr_22643[(6)] = c__2490__auto__);

return statearr_22643;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
fluree.db.query.fql.get_recursion_map = (function fluree$db$query$fql$get_recursion_map(db,recursion_map,select_spec,cache,k,f){
var select_spec__$1 = cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),f.p], null));
var full_select_spec = (cljs.core.truth_(fluree.db.query.fql.has_ns_lookups_QMARK_.call(null,select_spec__$1))?fluree.db.query.fql.full_select_spec.call(null,db,cache,select_spec__$1,fluree.db.query.fql.s.call(null,f)):select_spec__$1);
return cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,recursion_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,fluree.db.query.fql.s.call(null,f)], null),(0)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred-ids","pred-ids",-1902141555),k], null),f.p),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select-specs","select-specs",-681748023),f.p], null),full_select_spec);
});
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,f,pred_spec,recursion_map,flakes,acc,fuel,max_fuel,select_spec,cache){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_22857){
var state_val_22858 = (state_22857[(1)]);
if((state_val_22858 === (7))){
var inst_22706 = (state_22857[(7)]);
var inst_22706__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_22857__$1 = (function (){var statearr_22859 = state_22857;
(statearr_22859[(7)] = inst_22706__$1);

return statearr_22859;
})();
if(cljs.core.truth_(inst_22706__$1)){
var statearr_22860_22958 = state_22857__$1;
(statearr_22860_22958[(1)] = (9));

} else {
var statearr_22861_22959 = state_22857__$1;
(statearr_22861_22959[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (59))){
var inst_22838 = (state_22857[(8)]);
var inst_22840 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_22841 = cljs.core.sequence.call(null,inst_22840,inst_22838);
var state_22857__$1 = state_22857;
var statearr_22862_22960 = state_22857__$1;
(statearr_22862_22960[(2)] = inst_22841);

(statearr_22862_22960[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (20))){
var inst_22713 = (state_22857[(9)]);
var inst_22745 = (state_22857[(10)]);
var inst_22740 = (state_22857[(11)]);
var inst_22740__$1 = (state_22857[(2)]);
var inst_22741 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22742 = cljs.core.get.call(null,inst_22740__$1,inst_22713);
var inst_22743 = cljs.core.vals.call(null,inst_22742);
var inst_22744 = cljs.core.apply.call(null,cljs.core.max,inst_22743);
var inst_22745__$1 = (inst_22741 < inst_22744);
var state_22857__$1 = (function (){var statearr_22863 = state_22857;
(statearr_22863[(10)] = inst_22745__$1);

(statearr_22863[(11)] = inst_22740__$1);

return statearr_22863;
})();
if(cljs.core.truth_(inst_22745__$1)){
var statearr_22864_22961 = state_22857__$1;
(statearr_22864_22961[(1)] = (21));

} else {
var statearr_22865_22962 = state_22857__$1;
(statearr_22865_22962[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (58))){
var inst_22837 = (state_22857[(2)]);
var inst_22838 = fluree.db.util.async.throw_err.call(null,inst_22837);
var state_22857__$1 = (function (){var statearr_22866 = state_22857;
(statearr_22866[(8)] = inst_22838);

return statearr_22866;
})();
if(cljs.core.truth_(fuel)){
var statearr_22867_22963 = state_22857__$1;
(statearr_22867_22963[(1)] = (59));

} else {
var statearr_22868_22964 = state_22857__$1;
(statearr_22868_22964[(1)] = (60));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (60))){
var inst_22838 = (state_22857[(8)]);
var state_22857__$1 = state_22857;
var statearr_22869_22965 = state_22857__$1;
(statearr_22869_22965[(2)] = inst_22838);

(statearr_22869_22965[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (27))){
var inst_22757 = (state_22857[(12)]);
var inst_22759 = f.o;
var inst_22760 = fluree.db.query.fql.resolve_reverse_refs.call(null,db,cache,fuel,max_fuel,inst_22759,inst_22757);
var state_22857__$1 = state_22857;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22857__$1,(30),inst_22760);
} else {
if((state_val_22858 === (1))){
var state_22857__$1 = state_22857;
var statearr_22870_22966 = state_22857__$1;
(statearr_22870_22966[(2)] = null);

(statearr_22870_22966[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (24))){
var state_22857__$1 = state_22857;
var statearr_22871_22967 = state_22857__$1;
(statearr_22871_22967[(2)] = null);

(statearr_22871_22967[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (55))){
var inst_22828 = cljs.core.rest.call(null,flakes);
var state_22857__$1 = state_22857;
var statearr_22872_22968 = state_22857__$1;
(statearr_22872_22968[(2)] = inst_22828);

(statearr_22872_22968[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (39))){
var inst_22768 = (state_22857[(13)]);
var inst_22798 = (state_22857[(2)]);
var state_22857__$1 = (function (){var statearr_22873 = state_22857;
(statearr_22873[(14)] = inst_22798);

return statearr_22873;
})();
if(cljs.core.truth_(inst_22768)){
var statearr_22874_22969 = state_22857__$1;
(statearr_22874_22969[(1)] = (40));

} else {
var statearr_22875_22970 = state_22857__$1;
(statearr_22875_22970[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (46))){
var state_22857__$1 = state_22857;
var statearr_22876_22971 = state_22857__$1;
(statearr_22876_22971[(2)] = acc);

(statearr_22876_22971[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (4))){
var inst_22695 = (state_22857[(2)]);
var state_22857__$1 = state_22857;
var statearr_22877_22972 = state_22857__$1;
(statearr_22877_22972[(2)] = inst_22695);

(statearr_22877_22972[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (54))){
var inst_22826 = (state_22857[(2)]);
var state_22857__$1 = state_22857;
if(cljs.core.truth_(inst_22826)){
var statearr_22878_22973 = state_22857__$1;
(statearr_22878_22973[(1)] = (55));

} else {
var statearr_22879_22974 = state_22857__$1;
(statearr_22879_22974[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (15))){
var inst_22713 = (state_22857[(9)]);
var inst_22728 = fluree.db.query.fql.get_recursion_map.call(null,db,recursion_map,select_spec,cache,inst_22713,f);
var state_22857__$1 = state_22857;
var statearr_22880_22975 = state_22857__$1;
(statearr_22880_22975[(2)] = inst_22728);

(statearr_22880_22975[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (48))){
var inst_22820 = (state_22857[(2)]);
var state_22857__$1 = state_22857;
var statearr_22881_22976 = state_22857__$1;
(statearr_22881_22976[(2)] = inst_22820);

(statearr_22881_22976[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (50))){
var state_22857__$1 = state_22857;
var statearr_22882_22977 = state_22857__$1;
(statearr_22882_22977[(2)] = null);

(statearr_22882_22977[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (21))){
var inst_22745 = (state_22857[(10)]);
var state_22857__$1 = state_22857;
var statearr_22883_22978 = state_22857__$1;
(statearr_22883_22978[(2)] = inst_22745);

(statearr_22883_22978[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (31))){
var inst_22717 = (state_22857[(15)]);
var inst_22713 = (state_22857[(9)]);
var inst_22770 = cljs.core.get.call(null,inst_22717,inst_22713);
var inst_22771 = cljs.core.count.call(null,inst_22770);
var inst_22772 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22773 = (inst_22771 > inst_22772);
var state_22857__$1 = state_22857;
var statearr_22884_22979 = state_22857__$1;
(statearr_22884_22979[(2)] = inst_22773);

(statearr_22884_22979[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (32))){
var inst_22702 = (state_22857[(16)]);
var state_22857__$1 = state_22857;
var statearr_22885_22980 = state_22857__$1;
(statearr_22885_22980[(2)] = inst_22702);

(statearr_22885_22980[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (40))){
var inst_22713 = (state_22857[(9)]);
var inst_22798 = (state_22857[(14)]);
var inst_22768 = (state_22857[(13)]);
var inst_22800 = cljs.core.get.call(null,inst_22798,inst_22713);
var inst_22801 = cljs.core.merge.call(null,inst_22800,inst_22768);
var inst_22802 = cljs.core.assoc.call(null,inst_22798,inst_22713,inst_22801);
var state_22857__$1 = state_22857;
var statearr_22886_22981 = state_22857__$1;
(statearr_22886_22981[(2)] = inst_22802);

(statearr_22886_22981[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (56))){
var inst_22701 = (state_22857[(17)]);
var inst_22830 = cljs.core.rest.call(null,flakes);
var inst_22832 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22833 = [inst_22701];
var inst_22834 = (new cljs.core.PersistentVector(null,1,(5),inst_22832,inst_22833,null));
var inst_22835 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22834);
var state_22857__$1 = (function (){var statearr_22887 = state_22857;
(statearr_22887[(18)] = inst_22830);

return statearr_22887;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22857__$1,(58),inst_22835);
} else {
if((state_val_22858 === (33))){
var inst_22776 = (state_22857[(2)]);
var state_22857__$1 = state_22857;
if(cljs.core.truth_(inst_22776)){
var statearr_22888_22982 = state_22857__$1;
(statearr_22888_22982[(1)] = (34));

} else {
var statearr_22889_22983 = state_22857__$1;
(statearr_22889_22983[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (13))){
var state_22857__$1 = state_22857;
var statearr_22890_22984 = state_22857__$1;
(statearr_22890_22984[(2)] = false);

(statearr_22890_22984[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (22))){
var inst_22725 = (state_22857[(19)]);
var state_22857__$1 = state_22857;
var statearr_22891_22985 = state_22857__$1;
(statearr_22891_22985[(2)] = inst_22725);

(statearr_22891_22985[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (36))){
var inst_22852 = (state_22857[(2)]);
var _ = (function (){var statearr_22892 = state_22857;
(statearr_22892[(4)] = cljs.core.rest.call(null,(state_22857[(4)])));

return statearr_22892;
})();
var state_22857__$1 = state_22857;
var statearr_22893_22986 = state_22857__$1;
(statearr_22893_22986[(2)] = inst_22852);

(statearr_22893_22986[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (41))){
var inst_22798 = (state_22857[(14)]);
var state_22857__$1 = state_22857;
var statearr_22894_22987 = state_22857__$1;
(statearr_22894_22987[(2)] = inst_22798);

(statearr_22894_22987[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (43))){
var inst_22805 = (state_22857[(20)]);
var state_22857__$1 = state_22857;
var statearr_22895_22988 = state_22857__$1;
(statearr_22895_22988[(2)] = inst_22805);

(statearr_22895_22988[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (61))){
var inst_22830 = (state_22857[(18)]);
var inst_22844 = (state_22857[(2)]);
var inst_22845 = cljs.core.concat.call(null,inst_22830,inst_22844);
var state_22857__$1 = state_22857;
var statearr_22896_22989 = state_22857__$1;
(statearr_22896_22989[(2)] = inst_22845);

(statearr_22896_22989[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (29))){
var inst_22766 = (state_22857[(2)]);
var state_22857__$1 = state_22857;
var statearr_22897_22990 = state_22857__$1;
(statearr_22897_22990[(2)] = inst_22766);

(statearr_22897_22990[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (44))){
var inst_22725 = (state_22857[(19)]);
var state_22857__$1 = state_22857;
if(cljs.core.truth_(inst_22725)){
var statearr_22898_22991 = state_22857__$1;
(statearr_22898_22991[(1)] = (46));

} else {
var statearr_22899_22992 = state_22857__$1;
(statearr_22899_22992[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (6))){
var inst_22703 = (state_22857[(21)]);
var state_22857__$1 = state_22857;
var statearr_22900_22993 = state_22857__$1;
(statearr_22900_22993[(2)] = inst_22703);

(statearr_22900_22993[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (28))){
var state_22857__$1 = state_22857;
var statearr_22901_22994 = state_22857__$1;
(statearr_22901_22994[(2)] = null);

(statearr_22901_22994[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (51))){
var inst_22818 = (state_22857[(2)]);
var state_22857__$1 = state_22857;
var statearr_22902_22995 = state_22857__$1;
(statearr_22902_22995[(2)] = inst_22818);

(statearr_22902_22995[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (25))){
var inst_22740 = (state_22857[(11)]);
var inst_22757 = (state_22857[(12)]);
var inst_22752 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22753 = f.p;
var inst_22754 = [new cljs.core.Keyword(null,"select-specs","select-specs",-681748023),inst_22753];
var inst_22755 = (new cljs.core.PersistentVector(null,2,(5),inst_22752,inst_22754,null));
var inst_22756 = cljs.core.get_in.call(null,inst_22740,inst_22755);
var inst_22757__$1 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs.call(null,inst_22756);
var state_22857__$1 = (function (){var statearr_22903 = state_22857;
(statearr_22903[(12)] = inst_22757__$1);

return statearr_22903;
})();
if(cljs.core.truth_(inst_22757__$1)){
var statearr_22904_22996 = state_22857__$1;
(statearr_22904_22996[(1)] = (27));

} else {
var statearr_22905_22997 = state_22857__$1;
(statearr_22905_22997[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (34))){
var inst_22740 = (state_22857[(11)]);
var inst_22778 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22779 = cljs.core.rest.call(null,flakes);
var inst_22780 = [acc,inst_22779,inst_22740];
var inst_22781 = (new cljs.core.PersistentVector(null,3,(5),inst_22778,inst_22780,null));
var state_22857__$1 = state_22857;
var statearr_22906_22998 = state_22857__$1;
(statearr_22906_22998[(2)] = inst_22781);

(statearr_22906_22998[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (17))){
var inst_22725 = (state_22857[(19)]);
var inst_22731 = (state_22857[(2)]);
var state_22857__$1 = (function (){var statearr_22907 = state_22857;
(statearr_22907[(22)] = inst_22731);

return statearr_22907;
})();
if(cljs.core.truth_(inst_22725)){
var statearr_22908_22999 = state_22857__$1;
(statearr_22908_22999[(1)] = (18));

} else {
var statearr_22909_23000 = state_22857__$1;
(statearr_22909_23000[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (3))){
var inst_22855 = (state_22857[(2)]);
var state_22857__$1 = state_22857;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22857__$1,inst_22855);
} else {
if((state_val_22858 === (12))){
var inst_22721 = (state_22857[(23)]);
var state_22857__$1 = state_22857;
var statearr_22910_23001 = state_22857__$1;
(statearr_22910_23001[(2)] = inst_22721);

(statearr_22910_23001[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (2))){
var inst_22703 = (state_22857[(21)]);
var _ = (function (){var statearr_22911 = state_22857;
(statearr_22911[(4)] = cljs.core.cons.call(null,(5),(state_22857[(4)])));

return statearr_22911;
})();
var inst_22701 = f.o;
var inst_22702 = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22703__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_22857__$1 = (function (){var statearr_22912 = state_22857;
(statearr_22912[(16)] = inst_22702);

(statearr_22912[(21)] = inst_22703__$1);

(statearr_22912[(17)] = inst_22701);

return statearr_22912;
})();
if(cljs.core.truth_(inst_22703__$1)){
var statearr_22913_23002 = state_22857__$1;
(statearr_22913_23002[(1)] = (6));

} else {
var statearr_22914_23003 = state_22857__$1;
(statearr_22914_23003[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (23))){
var inst_22749 = (state_22857[(2)]);
var state_22857__$1 = state_22857;
if(cljs.core.truth_(inst_22749)){
var statearr_22915_23004 = state_22857__$1;
(statearr_22915_23004[(1)] = (24));

} else {
var statearr_22916_23005 = state_22857__$1;
(statearr_22916_23005[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (47))){
var state_22857__$1 = state_22857;
var statearr_22917_23006 = state_22857__$1;
(statearr_22917_23006[(1)] = (49));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (35))){
var inst_22702 = (state_22857[(16)]);
var state_22857__$1 = state_22857;
if(cljs.core.truth_(inst_22702)){
var statearr_22919_23007 = state_22857__$1;
(statearr_22919_23007[(1)] = (37));

} else {
var statearr_22920_23008 = state_22857__$1;
(statearr_22920_23008[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (19))){
var inst_22713 = (state_22857[(9)]);
var inst_22701 = (state_22857[(17)]);
var inst_22731 = (state_22857[(22)]);
var inst_22734 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22735 = [inst_22713,inst_22701];
var inst_22736 = (new cljs.core.PersistentVector(null,2,(5),inst_22734,inst_22735,null));
var inst_22737 = ((0) + (1));
var inst_22738 = cljs.core.assoc_in.call(null,inst_22731,inst_22736,inst_22737);
var state_22857__$1 = state_22857;
var statearr_22921_23009 = state_22857__$1;
(statearr_22921_23009[(2)] = inst_22738);

(statearr_22921_23009[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (57))){
var inst_22740 = (state_22857[(11)]);
var inst_22822 = (state_22857[(24)]);
var inst_22847 = (state_22857[(2)]);
var inst_22848 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22849 = [inst_22822,inst_22847,inst_22740];
var inst_22850 = (new cljs.core.PersistentVector(null,3,(5),inst_22848,inst_22849,null));
var state_22857__$1 = state_22857;
var statearr_22922_23010 = state_22857__$1;
(statearr_22922_23010[(2)] = inst_22850);

(statearr_22922_23010[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (11))){
var inst_22711 = (state_22857[(2)]);
var state_22857__$1 = state_22857;
var statearr_22924_23011 = state_22857__$1;
(statearr_22924_23011[(2)] = inst_22711);

(statearr_22924_23011[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (9))){
var inst_22706 = (state_22857[(7)]);
var state_22857__$1 = state_22857;
var statearr_22925_23012 = state_22857__$1;
(statearr_22925_23012[(2)] = inst_22706);

(statearr_22925_23012[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (5))){
var _ = (function (){var statearr_22926 = state_22857;
(statearr_22926[(4)] = cljs.core.rest.call(null,(state_22857[(4)])));

return statearr_22926;
})();
var state_22857__$1 = state_22857;
var ex22923 = (state_22857__$1[(2)]);
var statearr_22927_23013 = state_22857__$1;
(statearr_22927_23013[(5)] = ex22923);


if((ex22923 instanceof Error)){
var statearr_22928_23014 = state_22857__$1;
(statearr_22928_23014[(1)] = (4));

(statearr_22928_23014[(5)] = null);

} else {
throw ex22923;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (14))){
var inst_22725 = (state_22857[(19)]);
var inst_22725__$1 = (state_22857[(2)]);
var inst_22726 = cljs.core.not.call(null,inst_22725__$1);
var state_22857__$1 = (function (){var statearr_22929 = state_22857;
(statearr_22929[(19)] = inst_22725__$1);

return statearr_22929;
})();
if(inst_22726){
var statearr_22930_23015 = state_22857__$1;
(statearr_22930_23015[(1)] = (15));

} else {
var statearr_22931_23016 = state_22857__$1;
(statearr_22931_23016[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (45))){
var inst_22745 = (state_22857[(10)]);
var inst_22822 = (state_22857[(2)]);
var state_22857__$1 = (function (){var statearr_22932 = state_22857;
(statearr_22932[(24)] = inst_22822);

return statearr_22932;
})();
if(cljs.core.truth_(inst_22745)){
var statearr_22933_23017 = state_22857__$1;
(statearr_22933_23017[(1)] = (52));

} else {
var statearr_22934_23018 = state_22857__$1;
(statearr_22934_23018[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (53))){
var inst_22725 = (state_22857[(19)]);
var state_22857__$1 = state_22857;
var statearr_22935_23019 = state_22857__$1;
(statearr_22935_23019[(2)] = inst_22725);

(statearr_22935_23019[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (26))){
var inst_22702 = (state_22857[(16)]);
var inst_22768 = (state_22857[(2)]);
var state_22857__$1 = (function (){var statearr_22936 = state_22857;
(statearr_22936[(13)] = inst_22768);

return statearr_22936;
})();
if(cljs.core.truth_(inst_22702)){
var statearr_22937_23020 = state_22857__$1;
(statearr_22937_23020[(1)] = (31));

} else {
var statearr_22938_23021 = state_22857__$1;
(statearr_22938_23021[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (16))){
var state_22857__$1 = state_22857;
var statearr_22939_23022 = state_22857__$1;
(statearr_22939_23022[(2)] = recursion_map);

(statearr_22939_23022[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (38))){
var inst_22717 = (state_22857[(15)]);
var inst_22713 = (state_22857[(9)]);
var inst_22701 = (state_22857[(17)]);
var inst_22793 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22794 = [inst_22713,new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_22795 = (new cljs.core.PersistentVector(null,2,(5),inst_22793,inst_22794,null));
var inst_22796 = cljs.core.assoc_in.call(null,inst_22717,inst_22795,inst_22701);
var state_22857__$1 = state_22857;
var statearr_22940_23023 = state_22857__$1;
(statearr_22940_23023[(2)] = inst_22796);

(statearr_22940_23023[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (30))){
var inst_22762 = (state_22857[(2)]);
var inst_22763 = fluree.db.util.async.throw_err.call(null,inst_22762);
var state_22857__$1 = state_22857;
var statearr_22941_23024 = state_22857__$1;
(statearr_22941_23024[(2)] = inst_22763);

(statearr_22941_23024[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (10))){
var inst_22709 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_22857__$1 = state_22857;
var statearr_22942_23025 = state_22857__$1;
(statearr_22942_23025[(2)] = inst_22709);

(statearr_22942_23025[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (18))){
var inst_22731 = (state_22857[(22)]);
var state_22857__$1 = state_22857;
var statearr_22943_23026 = state_22857__$1;
(statearr_22943_23026[(2)] = inst_22731);

(statearr_22943_23026[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (52))){
var inst_22745 = (state_22857[(10)]);
var state_22857__$1 = state_22857;
var statearr_22944_23027 = state_22857__$1;
(statearr_22944_23027[(2)] = inst_22745);

(statearr_22944_23027[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (42))){
var inst_22725 = (state_22857[(19)]);
var inst_22805 = (state_22857[(2)]);
var inst_22806 = cljs.core.not.call(null,inst_22725);
var state_22857__$1 = (function (){var statearr_22945 = state_22857;
(statearr_22945[(20)] = inst_22805);

return statearr_22945;
})();
if(inst_22806){
var statearr_22946_23028 = state_22857__$1;
(statearr_22946_23028[(1)] = (43));

} else {
var statearr_22947_23029 = state_22857__$1;
(statearr_22947_23029[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (37))){
var inst_22717 = (state_22857[(15)]);
var inst_22713 = (state_22857[(9)]);
var inst_22701 = (state_22857[(17)]);
var inst_22784 = cljs.core.PersistentVector.EMPTY;
var inst_22785 = cljs.core.get.call(null,inst_22717,inst_22713);
var inst_22786 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_22787 = [inst_22701];
var inst_22788 = cljs.core.PersistentHashMap.fromArrays(inst_22786,inst_22787);
var inst_22789 = cljs.core.conj.call(null,inst_22785,inst_22788);
var inst_22790 = cljs.core.into.call(null,inst_22784,inst_22789);
var inst_22791 = cljs.core.assoc.call(null,inst_22717,inst_22713,inst_22790);
var state_22857__$1 = state_22857;
var statearr_22948_23030 = state_22857__$1;
(statearr_22948_23030[(2)] = inst_22791);

(statearr_22948_23030[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (8))){
var inst_22721 = (state_22857[(23)]);
var inst_22713 = (state_22857[(9)]);
var inst_22701 = (state_22857[(17)]);
var inst_22713__$1 = (state_22857[(2)]);
var inst_22714 = cljs.core.PersistentVector.EMPTY;
var inst_22715 = cljs.core.repeat.call(null,(0),inst_22713__$1);
var inst_22716 = cljs.core.into.call(null,inst_22714,inst_22715);
var inst_22717 = cljs.core.get_in.call(null,acc,inst_22716);
var inst_22718 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22719 = [inst_22713__$1,inst_22701];
var inst_22720 = (new cljs.core.PersistentVector(null,2,(5),inst_22718,inst_22719,null));
var inst_22721__$1 = cljs.core.get_in.call(null,recursion_map,inst_22720);
var state_22857__$1 = (function (){var statearr_22949 = state_22857;
(statearr_22949[(23)] = inst_22721__$1);

(statearr_22949[(15)] = inst_22717);

(statearr_22949[(9)] = inst_22713__$1);

return statearr_22949;
})();
if(cljs.core.truth_(inst_22721__$1)){
var statearr_22950_23031 = state_22857__$1;
(statearr_22950_23031[(1)] = (12));

} else {
var statearr_22951_23032 = state_22857__$1;
(statearr_22951_23032[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22858 === (49))){
var inst_22805 = (state_22857[(20)]);
var inst_22713 = (state_22857[(9)]);
var inst_22812 = cljs.core.PersistentVector.EMPTY;
var inst_22813 = cljs.core.repeat.call(null,(0),inst_22713);
var inst_22814 = cljs.core.into.call(null,inst_22812,inst_22813);
var inst_22815 = cljs.core.assoc_in.call(null,acc,inst_22814,inst_22805);
var state_22857__$1 = state_22857;
var statearr_22952_23033 = state_22857__$1;
(statearr_22952_23033[(2)] = inst_22815);

(statearr_22952_23033[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2468__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2468__auto____0 = (function (){
var statearr_22953 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22953[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__2468__auto__);

(statearr_22953[(1)] = (1));

return statearr_22953;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2468__auto____1 = (function (state_22857){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_22857);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e22954){var ex__2471__auto__ = e22954;
var statearr_22955_23034 = state_22857;
(statearr_22955_23034[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_22857[(4)]))){
var statearr_22956_23035 = state_22857;
(statearr_22956_23035[(1)] = cljs.core.first.call(null,(state_22857[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23036 = state_22857;
state_22857 = G__23036;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__2468__auto__ = function(state_22857){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2468__auto____1.call(this,state_22857);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__2468__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__2468__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_22957 = f__2491__auto__.call(null);
(statearr_22957[(6)] = c__2490__auto__);

return statearr_22957;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_23227){
var state_val_23228 = (state_23227[(1)]);
if((state_val_23228 === (7))){
var state_23227__$1 = state_23227;
var statearr_23229_23321 = state_23227__$1;
(statearr_23229_23321[(2)] = null);

(statearr_23229_23321[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (20))){
var inst_23075 = cljs.core.PersistentHashMap.EMPTY;
var state_23227__$1 = state_23227;
var statearr_23230_23322 = state_23227__$1;
(statearr_23230_23322[(2)] = inst_23075);

(statearr_23230_23322[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (58))){
var inst_23185 = (state_23227[(2)]);
var state_23227__$1 = state_23227;
var statearr_23231_23323 = state_23227__$1;
(statearr_23231_23323[(2)] = inst_23185);

(statearr_23231_23323[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (27))){
var inst_23057 = (state_23227[(7)]);
var inst_23093 = (state_23227[(8)]);
var inst_23063 = (state_23227[(9)]);
var inst_23077 = (state_23227[(10)]);
var inst_23206 = (state_23227[(2)]);
var inst_23207 = (function (){var top_level_subject = inst_23057;
var select_spec = inst_23063;
var base_acc = inst_23077;
var acc_PLUS_refs = inst_23093;
var result = inst_23206;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4126__auto__ = (function (){var and__4115__auto__ = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4115__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var and__4115__auto__ = new cljs.core.Keyword(null,"reverse?","reverse?",-1672868474).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4115__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4115__auto__;
}
}
})())){
return cljs.core.conj.call(null,acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(spec),new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"predicate","predicate",-1742501860).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_23208 = cljs.core.PersistentVector.EMPTY;
var inst_23209 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23063);
var inst_23210 = new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(inst_23209);
var inst_23211 = cljs.core.vals.call(null,inst_23210);
var inst_23212 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23063);
var inst_23213 = new cljs.core.Keyword(null,"reverse","reverse",-888455266).cljs$core$IFn$_invoke$arity$1(inst_23212);
var inst_23214 = cljs.core.vals.call(null,inst_23213);
var inst_23215 = cljs.core.concat.call(null,inst_23211,inst_23214);
var inst_23216 = cljs.core.reduce.call(null,inst_23207,inst_23208,inst_23215);
var inst_23218 = (function (){var top_level_subject = inst_23057;
var select_spec = inst_23063;
var base_acc = inst_23077;
var acc_PLUS_refs = inst_23093;
var result = inst_23206;
var sort_preds = inst_23216;
return (function (acc,p__23217){
var vec__23232 = p__23217;
var selectPred = cljs.core.nth.call(null,vec__23232,(0),null);
var sortOrder = cljs.core.nth.call(null,vec__23232,(1),null);
var sortPred = cljs.core.nth.call(null,vec__23232,(2),null);
var limit = cljs.core.nth.call(null,vec__23232,(3),null);
return cljs.core.assoc.call(null,acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res.call(null,sortPred,sortOrder,(0),limit,cljs.core.get.call(null,acc,selectPred)));
});
})();
var inst_23219 = cljs.core.reduce.call(null,inst_23218,inst_23206,inst_23216);
var state_23227__$1 = state_23227;
var statearr_23235_23324 = state_23227__$1;
(statearr_23235_23324[(2)] = inst_23219);

(statearr_23235_23324[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (1))){
var state_23227__$1 = state_23227;
var statearr_23236_23325 = state_23227__$1;
(statearr_23236_23325[(2)] = null);

(statearr_23236_23325[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (24))){
var inst_23093 = (state_23227[(8)]);
var inst_23093__$1 = (state_23227[(2)]);
var inst_23094 = flakes;
var inst_23095 = cljs.core.PersistentHashMap.EMPTY;
var inst_23096 = cljs.core.PersistentHashMap.EMPTY;
var inst_23097 = inst_23094;
var inst_23098 = inst_23093__$1;
var inst_23099 = inst_23095;
var inst_23100 = inst_23096;
var state_23227__$1 = (function (){var statearr_23237 = state_23227;
(statearr_23237[(11)] = inst_23099);

(statearr_23237[(8)] = inst_23093__$1);

(statearr_23237[(12)] = inst_23097);

(statearr_23237[(13)] = inst_23100);

(statearr_23237[(14)] = inst_23098);

return statearr_23237;
})();
var statearr_23238_23326 = state_23227__$1;
(statearr_23238_23326[(2)] = null);

(statearr_23238_23326[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (55))){
var inst_23187 = (state_23227[(2)]);
var state_23227__$1 = state_23227;
var statearr_23239_23327 = state_23227__$1;
(statearr_23239_23327[(2)] = inst_23187);

(statearr_23239_23327[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (39))){
var inst_23113 = (state_23227[(15)]);
var state_23227__$1 = state_23227;
if(cljs.core.truth_(inst_23113)){
var statearr_23240_23328 = state_23227__$1;
(statearr_23240_23328[(1)] = (42));

} else {
var statearr_23241_23329 = state_23227__$1;
(statearr_23241_23329[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (46))){
var inst_23108 = (state_23227[(16)]);
var inst_23063 = (state_23227[(9)]);
var inst_23098 = (state_23227[(14)]);
var inst_23114 = (state_23227[(17)]);
var inst_23151 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23152 = fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,inst_23098,inst_23063,inst_23108,inst_23114,false);
var state_23227__$1 = (function (){var statearr_23242 = state_23227;
(statearr_23242[(18)] = inst_23151);

return statearr_23242;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23227__$1,(49),inst_23152);
} else {
if((state_val_23228 === (4))){
var inst_23037 = (state_23227[(2)]);
var state_23227__$1 = state_23227;
var statearr_23243_23330 = state_23227__$1;
(statearr_23243_23330[(2)] = inst_23037);

(statearr_23243_23330[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (54))){
var state_23227__$1 = state_23227;
var statearr_23244_23331 = state_23227__$1;
(statearr_23244_23331[(1)] = (56));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (15))){
var inst_23064 = (state_23227[(19)]);
var inst_23063 = (state_23227[(9)]);
var inst_23063__$1 = (state_23227[(2)]);
var inst_23064__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_23063__$1);
var state_23227__$1 = (function (){var statearr_23246 = state_23227;
(statearr_23246[(19)] = inst_23064__$1);

(statearr_23246[(9)] = inst_23063__$1);

return statearr_23246;
})();
if(cljs.core.truth_(inst_23064__$1)){
var statearr_23247_23332 = state_23227__$1;
(statearr_23247_23332[(1)] = (16));

} else {
var statearr_23248_23333 = state_23227__$1;
(statearr_23248_23333[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (48))){
var inst_23189 = (state_23227[(2)]);
var state_23227__$1 = state_23227;
var statearr_23249_23334 = state_23227__$1;
(statearr_23249_23334[(2)] = inst_23189);

(statearr_23249_23334[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (50))){
var inst_23063 = (state_23227[(9)]);
var inst_23164 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_23063);
var state_23227__$1 = state_23227;
var statearr_23250_23335 = state_23227__$1;
(statearr_23250_23335[(2)] = inst_23164);

(statearr_23250_23335[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (21))){
var inst_23063 = (state_23227[(9)]);
var inst_23077 = (state_23227[(2)]);
var inst_23078 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23079 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)];
var inst_23080 = (new cljs.core.PersistentVector(null,2,(5),inst_23078,inst_23079,null));
var inst_23081 = cljs.core.get_in.call(null,inst_23063,inst_23080);
var state_23227__$1 = (function (){var statearr_23251 = state_23227;
(statearr_23251[(10)] = inst_23077);

return statearr_23251;
})();
if(cljs.core.truth_(inst_23081)){
var statearr_23252_23336 = state_23227__$1;
(statearr_23252_23336[(1)] = (22));

} else {
var statearr_23253_23337 = state_23227__$1;
(statearr_23253_23337[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (31))){
var inst_23113 = (state_23227[(15)]);
var inst_23117 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_23113);
var state_23227__$1 = state_23227;
var statearr_23254_23338 = state_23227__$1;
(statearr_23254_23338[(2)] = inst_23117);

(statearr_23254_23338[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (32))){
var inst_23115 = (state_23227[(20)]);
var state_23227__$1 = state_23227;
var statearr_23255_23339 = state_23227__$1;
(statearr_23255_23339[(2)] = inst_23115);

(statearr_23255_23339[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (40))){
var inst_23193 = (state_23227[(2)]);
var state_23227__$1 = state_23227;
var statearr_23256_23340 = state_23227__$1;
(statearr_23256_23340[(2)] = inst_23193);

(statearr_23256_23340[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (56))){
var inst_23099 = (state_23227[(11)]);
var inst_23097 = (state_23227[(12)]);
var inst_23100 = (state_23227[(13)]);
var inst_23098 = (state_23227[(14)]);
var inst_23179 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23180 = cljs.core.rest.call(null,inst_23097);
var inst_23181 = [inst_23098,inst_23180,inst_23099,inst_23100];
var inst_23182 = (new cljs.core.PersistentVector(null,4,(5),inst_23179,inst_23181,null));
var state_23227__$1 = state_23227;
var statearr_23257_23341 = state_23227__$1;
(statearr_23257_23341[(2)] = inst_23182);

(statearr_23257_23341[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (33))){
var inst_23120 = (state_23227[(2)]);
var state_23227__$1 = state_23227;
if(cljs.core.truth_(inst_23120)){
var statearr_23258_23342 = state_23227__$1;
(statearr_23258_23342[(1)] = (34));

} else {
var statearr_23259_23343 = state_23227__$1;
(statearr_23259_23343[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (13))){
var inst_23057 = (state_23227[(7)]);
var inst_23060 = fluree.db.query.fql.full_select_spec.call(null,db,cache,base_select_spec,inst_23057);
var state_23227__$1 = state_23227;
var statearr_23260_23344 = state_23227__$1;
(statearr_23260_23344[(2)] = inst_23060);

(statearr_23260_23344[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (22))){
var inst_23063 = (state_23227[(9)]);
var inst_23083 = cljs.core.first.call(null,flakes);
var inst_23084 = fluree.db.query.fql.s.call(null,inst_23083);
var inst_23085 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs.call(null,inst_23063);
var inst_23086 = fluree.db.query.fql.resolve_reverse_refs.call(null,db,cache,fuel,max_fuel,inst_23084,inst_23085);
var state_23227__$1 = state_23227;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23227__$1,(25),inst_23086);
} else {
if((state_val_23228 === (36))){
var inst_23108 = (state_23227[(16)]);
var inst_23195 = (state_23227[(2)]);
var inst_23196 = cljs.core.nth.call(null,inst_23195,(0),null);
var inst_23197 = cljs.core.nth.call(null,inst_23195,(1),null);
var inst_23198 = cljs.core.nth.call(null,inst_23195,(2),null);
var inst_23199 = cljs.core.nth.call(null,inst_23195,(3),null);
var inst_23200 = inst_23108.s;
var inst_23201 = cljs.core.assoc.call(null,inst_23196,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_23200);
var inst_23097 = inst_23197;
var inst_23098 = inst_23201;
var inst_23099 = inst_23198;
var inst_23100 = inst_23199;
var state_23227__$1 = (function (){var statearr_23261 = state_23227;
(statearr_23261[(11)] = inst_23099);

(statearr_23261[(12)] = inst_23097);

(statearr_23261[(13)] = inst_23100);

(statearr_23261[(14)] = inst_23098);

return statearr_23261;
})();
var statearr_23262_23345 = state_23227__$1;
(statearr_23262_23345[(2)] = null);

(statearr_23262_23345[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (41))){
var inst_23131 = (state_23227[(2)]);
var inst_23132 = fluree.db.util.async.throw_err.call(null,inst_23131);
var state_23227__$1 = state_23227;
var statearr_23263_23346 = state_23227__$1;
(statearr_23263_23346[(2)] = inst_23132);

(statearr_23263_23346[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (43))){
var inst_23063 = (state_23227[(9)]);
var inst_23149 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_23063);
var state_23227__$1 = state_23227;
if(cljs.core.truth_(inst_23149)){
var statearr_23264_23347 = state_23227__$1;
(statearr_23264_23347[(1)] = (46));

} else {
var statearr_23265_23348 = state_23227__$1;
(statearr_23265_23348[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (29))){
var inst_23113 = (state_23227[(15)]);
var inst_23108 = (state_23227[(16)]);
var inst_23115 = (state_23227[(20)]);
var inst_23063 = (state_23227[(9)]);
var inst_23097 = (state_23227[(12)]);
var inst_23108__$1 = cljs.core.first.call(null,inst_23097);
var inst_23109 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23110 = inst_23108__$1.p;
var inst_23111 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),inst_23110];
var inst_23112 = (new cljs.core.PersistentVector(null,3,(5),inst_23109,inst_23111,null));
var inst_23113__$1 = cljs.core.get_in.call(null,inst_23063,inst_23112);
var inst_23114 = fluree.db.query.fql.component_follow_QMARK_.call(null,inst_23113__$1,inst_23063);
var inst_23115__$1 = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(inst_23113__$1);
var state_23227__$1 = (function (){var statearr_23266 = state_23227;
(statearr_23266[(15)] = inst_23113__$1);

(statearr_23266[(16)] = inst_23108__$1);

(statearr_23266[(20)] = inst_23115__$1);

(statearr_23266[(17)] = inst_23114);

return statearr_23266;
})();
if(cljs.core.truth_(inst_23115__$1)){
var statearr_23267_23349 = state_23227__$1;
(statearr_23267_23349[(1)] = (31));

} else {
var statearr_23268_23350 = state_23227__$1;
(statearr_23268_23350[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (44))){
var inst_23191 = (state_23227[(2)]);
var state_23227__$1 = state_23227;
var statearr_23269_23351 = state_23227__$1;
(statearr_23269_23351[(2)] = inst_23191);

(statearr_23269_23351[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (6))){
var state_23227__$1 = state_23227;
var statearr_23270_23352 = state_23227__$1;
(statearr_23270_23352[(2)] = null);

(statearr_23270_23352[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (28))){
var inst_23098 = (state_23227[(14)]);
var state_23227__$1 = state_23227;
var statearr_23271_23353 = state_23227__$1;
(statearr_23271_23353[(2)] = inst_23098);

(statearr_23271_23353[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (51))){
var state_23227__$1 = state_23227;
var statearr_23272_23354 = state_23227__$1;
(statearr_23272_23354[(2)] = false);

(statearr_23272_23354[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (25))){
var inst_23077 = (state_23227[(10)]);
var inst_23088 = (state_23227[(2)]);
var inst_23089 = fluree.db.util.async.throw_err.call(null,inst_23088);
var inst_23090 = cljs.core.merge.call(null,inst_23077,inst_23089);
var state_23227__$1 = state_23227;
var statearr_23273_23355 = state_23227__$1;
(statearr_23273_23355[(2)] = inst_23090);

(statearr_23273_23355[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (34))){
var inst_23099 = (state_23227[(11)]);
var inst_23113 = (state_23227[(15)]);
var inst_23108 = (state_23227[(16)]);
var inst_23063 = (state_23227[(9)]);
var inst_23097 = (state_23227[(12)]);
var inst_23098 = (state_23227[(14)]);
var inst_23122 = fluree.db.query.fql.flake__GT_recur_multi.call(null,db,inst_23108,inst_23113,inst_23099,inst_23097,inst_23098,fuel,max_fuel,inst_23063,cache,fluree.db.query.fql.component_follow_QMARK_);
var state_23227__$1 = state_23227;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23227__$1,(37),inst_23122);
} else {
if((state_val_23228 === (17))){
var inst_23063 = (state_23227[(9)]);
var inst_23067 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_23063);
var state_23227__$1 = state_23227;
var statearr_23275_23356 = state_23227__$1;
(statearr_23275_23356[(2)] = inst_23067);

(statearr_23275_23356[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (3))){
var inst_23225 = (state_23227[(2)]);
var state_23227__$1 = state_23227;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23227__$1,inst_23225);
} else {
if((state_val_23228 === (12))){
var _ = (function (){var statearr_23276 = state_23227;
(statearr_23276[(4)] = cljs.core.rest.call(null,(state_23227[(4)])));

return statearr_23276;
})();
var state_23227__$1 = state_23227;
var ex23274 = (state_23227__$1[(2)]);
var statearr_23277_23357 = state_23227__$1;
(statearr_23277_23357[(5)] = ex23274);


if((ex23274 instanceof java.lang.Exception)){
var statearr_23278_23358 = state_23227__$1;
(statearr_23278_23358[(1)] = (11));

(statearr_23278_23358[(5)] = null);

} else {
throw ex23274;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (2))){
var _ = (function (){var statearr_23279 = state_23227;
(statearr_23279[(4)] = cljs.core.cons.call(null,(5),(state_23227[(4)])));

return statearr_23279;
})();
var inst_23043 = cljs.core.not_empty.call(null,flakes);
var state_23227__$1 = state_23227;
if(cljs.core.truth_(inst_23043)){
var statearr_23280_23359 = state_23227__$1;
(statearr_23280_23359[(1)] = (6));

} else {
var statearr_23281_23360 = state_23227__$1;
(statearr_23281_23360[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (23))){
var inst_23077 = (state_23227[(10)]);
var state_23227__$1 = state_23227;
var statearr_23282_23361 = state_23227__$1;
(statearr_23282_23361[(2)] = inst_23077);

(statearr_23282_23361[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (47))){
var inst_23063 = (state_23227[(9)]);
var inst_23161 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23063);
var inst_23162 = cljs.core.empty_QMARK_.call(null,inst_23161);
var state_23227__$1 = state_23227;
if(inst_23162){
var statearr_23283_23362 = state_23227__$1;
(statearr_23283_23362[(1)] = (50));

} else {
var statearr_23284_23363 = state_23227__$1;
(statearr_23284_23363[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (35))){
var inst_23113 = (state_23227[(15)]);
var inst_23127 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_23113);
var state_23227__$1 = state_23227;
if(cljs.core.truth_(inst_23127)){
var statearr_23285_23364 = state_23227__$1;
(statearr_23285_23364[(1)] = (38));

} else {
var statearr_23286_23365 = state_23227__$1;
(statearr_23286_23365[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (19))){
var inst_23057 = (state_23227[(7)]);
var inst_23071 = ["_id"];
var inst_23072 = [inst_23057];
var inst_23073 = cljs.core.PersistentHashMap.fromArrays(inst_23071,inst_23072);
var state_23227__$1 = state_23227;
var statearr_23287_23366 = state_23227__$1;
(statearr_23287_23366[(2)] = inst_23073);

(statearr_23287_23366[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (57))){
var state_23227__$1 = state_23227;
var statearr_23288_23367 = state_23227__$1;
(statearr_23288_23367[(2)] = null);

(statearr_23288_23367[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (11))){
var inst_23045 = (state_23227[(2)]);
var inst_23046 = fluree.db.util.log.error.call(null,inst_23045);
var inst_23047 = (function(){throw inst_23045})();
var state_23227__$1 = (function (){var statearr_23290 = state_23227;
(statearr_23290[(21)] = inst_23046);

return statearr_23290;
})();
var statearr_23291_23368 = state_23227__$1;
(statearr_23291_23368[(2)] = inst_23047);

(statearr_23291_23368[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (9))){
var _ = (function (){var statearr_23292 = state_23227;
(statearr_23292[(4)] = cljs.core.cons.call(null,(12),(state_23227[(4)])));

return statearr_23292;
})();
var inst_23053 = cljs.core.first.call(null,flakes);
var inst_23054 = fluree.db.query.fql.s.call(null,inst_23053);
var ___$1 = (function (){var statearr_23293 = state_23227;
(statearr_23293[(4)] = cljs.core.rest.call(null,(state_23227[(4)])));

return statearr_23293;
})();
var state_23227__$1 = state_23227;
var statearr_23294_23369 = state_23227__$1;
(statearr_23294_23369[(2)] = inst_23054);

(statearr_23294_23369[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (5))){
var _ = (function (){var statearr_23295 = state_23227;
(statearr_23295[(4)] = cljs.core.rest.call(null,(state_23227[(4)])));

return statearr_23295;
})();
var state_23227__$1 = state_23227;
var ex23289 = (state_23227__$1[(2)]);
var statearr_23296_23370 = state_23227__$1;
(statearr_23296_23370[(5)] = ex23289);


if((ex23289 instanceof Error)){
var statearr_23297_23371 = state_23227__$1;
(statearr_23297_23371[(1)] = (4));

(statearr_23297_23371[(5)] = null);

} else {
throw ex23289;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (14))){
var state_23227__$1 = state_23227;
var statearr_23298_23372 = state_23227__$1;
(statearr_23298_23372[(2)] = base_select_spec);

(statearr_23298_23372[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (45))){
var inst_23099 = (state_23227[(11)]);
var inst_23097 = (state_23227[(12)]);
var inst_23140 = (state_23227[(2)]);
var inst_23141 = fluree.db.util.async.throw_err.call(null,inst_23140);
var inst_23142 = cljs.core.nth.call(null,inst_23141,(0),null);
var inst_23143 = cljs.core.nth.call(null,inst_23141,(1),null);
var inst_23144 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23145 = cljs.core.rest.call(null,inst_23097);
var inst_23146 = [inst_23142,inst_23145,inst_23099,inst_23143];
var inst_23147 = (new cljs.core.PersistentVector(null,4,(5),inst_23144,inst_23146,null));
var state_23227__$1 = state_23227;
var statearr_23299_23373 = state_23227__$1;
(statearr_23299_23373[(2)] = inst_23147);

(statearr_23299_23373[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (53))){
var inst_23099 = (state_23227[(11)]);
var inst_23108 = (state_23227[(16)]);
var inst_23097 = (state_23227[(12)]);
var inst_23100 = (state_23227[(13)]);
var inst_23169 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23170 = ["_id"];
var inst_23171 = inst_23108.s;
var inst_23172 = [inst_23171];
var inst_23173 = cljs.core.PersistentHashMap.fromArrays(inst_23170,inst_23172);
var inst_23174 = cljs.core.rest.call(null,inst_23097);
var inst_23175 = [inst_23173,inst_23174,inst_23099,inst_23100];
var inst_23176 = (new cljs.core.PersistentVector(null,4,(5),inst_23169,inst_23175,null));
var state_23227__$1 = state_23227;
var statearr_23300_23374 = state_23227__$1;
(statearr_23300_23374[(2)] = inst_23176);

(statearr_23300_23374[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (26))){
var inst_23097 = (state_23227[(12)]);
var inst_23102 = cljs.core.empty_QMARK_.call(null,inst_23097);
var state_23227__$1 = state_23227;
if(inst_23102){
var statearr_23301_23375 = state_23227__$1;
(statearr_23301_23375[(1)] = (28));

} else {
var statearr_23302_23376 = state_23227__$1;
(statearr_23302_23376[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (16))){
var inst_23064 = (state_23227[(19)]);
var state_23227__$1 = state_23227;
var statearr_23303_23377 = state_23227__$1;
(statearr_23303_23377[(2)] = inst_23064);

(statearr_23303_23377[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (38))){
var inst_23099 = (state_23227[(11)]);
var inst_23113 = (state_23227[(15)]);
var inst_23108 = (state_23227[(16)]);
var inst_23063 = (state_23227[(9)]);
var inst_23097 = (state_23227[(12)]);
var inst_23098 = (state_23227[(14)]);
var inst_23129 = fluree.db.query.fql.flake__GT_recur.call(null,db,inst_23108,inst_23113,inst_23099,inst_23097,inst_23098,fuel,max_fuel,inst_23063,cache);
var state_23227__$1 = state_23227;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23227__$1,(41),inst_23129);
} else {
if((state_val_23228 === (30))){
var inst_23204 = (state_23227[(2)]);
var state_23227__$1 = state_23227;
var statearr_23304_23378 = state_23227__$1;
(statearr_23304_23378[(2)] = inst_23204);

(statearr_23304_23378[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (10))){
var inst_23057 = (state_23227[(2)]);
var inst_23058 = fluree.db.query.fql.has_ns_lookups_QMARK_.call(null,base_select_spec);
var state_23227__$1 = (function (){var statearr_23305 = state_23227;
(statearr_23305[(7)] = inst_23057);

return statearr_23305;
})();
if(cljs.core.truth_(inst_23058)){
var statearr_23306_23379 = state_23227__$1;
(statearr_23306_23379[(1)] = (13));

} else {
var statearr_23307_23380 = state_23227__$1;
(statearr_23307_23380[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (18))){
var inst_23069 = (state_23227[(2)]);
var state_23227__$1 = state_23227;
if(cljs.core.truth_(inst_23069)){
var statearr_23308_23381 = state_23227__$1;
(statearr_23308_23381[(1)] = (19));

} else {
var statearr_23309_23382 = state_23227__$1;
(statearr_23309_23382[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (52))){
var inst_23167 = (state_23227[(2)]);
var state_23227__$1 = state_23227;
if(cljs.core.truth_(inst_23167)){
var statearr_23310_23383 = state_23227__$1;
(statearr_23310_23383[(1)] = (53));

} else {
var statearr_23311_23384 = state_23227__$1;
(statearr_23311_23384[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (42))){
var inst_23113 = (state_23227[(15)]);
var inst_23108 = (state_23227[(16)]);
var inst_23100 = (state_23227[(13)]);
var inst_23098 = (state_23227[(14)]);
var inst_23114 = (state_23227[(17)]);
var inst_23138 = fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,inst_23098,inst_23113,inst_23108,inst_23114,false,inst_23100);
var state_23227__$1 = state_23227;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23227__$1,(45),inst_23138);
} else {
if((state_val_23228 === (37))){
var inst_23124 = (state_23227[(2)]);
var inst_23125 = fluree.db.util.async.throw_err.call(null,inst_23124);
var state_23227__$1 = state_23227;
var statearr_23312_23385 = state_23227__$1;
(statearr_23312_23385[(2)] = inst_23125);

(statearr_23312_23385[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (8))){
var inst_23222 = (state_23227[(2)]);
var _ = (function (){var statearr_23313 = state_23227;
(statearr_23313[(4)] = cljs.core.rest.call(null,(state_23227[(4)])));

return statearr_23313;
})();
var state_23227__$1 = state_23227;
var statearr_23314_23386 = state_23227__$1;
(statearr_23314_23386[(2)] = inst_23222);

(statearr_23314_23386[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23228 === (49))){
var inst_23099 = (state_23227[(11)]);
var inst_23097 = (state_23227[(12)]);
var inst_23100 = (state_23227[(13)]);
var inst_23151 = (state_23227[(18)]);
var inst_23154 = (state_23227[(2)]);
var inst_23155 = fluree.db.util.async.throw_err.call(null,inst_23154);
var inst_23156 = cljs.core.first.call(null,inst_23155);
var inst_23157 = cljs.core.rest.call(null,inst_23097);
var inst_23158 = [inst_23156,inst_23157,inst_23099,inst_23100];
var inst_23159 = (new cljs.core.PersistentVector(null,4,(5),inst_23151,inst_23158,null));
var state_23227__$1 = state_23227;
var statearr_23315_23387 = state_23227__$1;
(statearr_23315_23387[(2)] = inst_23159);

(statearr_23315_23387[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2468__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2468__auto____0 = (function (){
var statearr_23316 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23316[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__2468__auto__);

(statearr_23316[(1)] = (1));

return statearr_23316;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2468__auto____1 = (function (state_23227){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_23227);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e23317){var ex__2471__auto__ = e23317;
var statearr_23318_23388 = state_23227;
(statearr_23318_23388[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_23227[(4)]))){
var statearr_23319_23389 = state_23227;
(statearr_23319_23389[(1)] = cljs.core.first.call(null,(state_23227[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23390 = state_23227;
state_23227 = G__23390;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__2468__auto__ = function(state_23227){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2468__auto____1.call(this,state_23227);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__2468__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__2468__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_23320 = f__2491__auto__.call(null);
(statearr_23320[(6)] = c__2490__auto__);

return statearr_23320;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__23393 = arguments.length;
switch (G__23393) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.call(null,db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.call(null,db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_23435){
var state_val_23436 = (state_23435[(1)]);
if((state_val_23436 === (7))){
var inst_23401 = (state_23435[(7)]);
var state_23435__$1 = state_23435;
var statearr_23437_23467 = state_23435__$1;
(statearr_23437_23467[(2)] = inst_23401);

(statearr_23437_23467[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (1))){
var state_23435__$1 = state_23435;
var statearr_23438_23468 = state_23435__$1;
(statearr_23438_23468[(2)] = null);

(statearr_23438_23468[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (4))){
var inst_23394 = (state_23435[(2)]);
var state_23435__$1 = state_23435;
var statearr_23439_23469 = state_23435__$1;
(statearr_23439_23469[(2)] = inst_23394);

(statearr_23439_23469[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (15))){
var inst_23429 = (state_23435[(2)]);
var inst_23430 = fluree.db.util.async.throw_err.call(null,inst_23429);
var _ = (function (){var statearr_23440 = state_23435;
(statearr_23440[(4)] = cljs.core.rest.call(null,(state_23435[(4)])));

return statearr_23440;
})();
var state_23435__$1 = state_23435;
var statearr_23441_23470 = state_23435__$1;
(statearr_23441_23470[(2)] = inst_23430);

(statearr_23441_23470[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (13))){
var inst_23413 = (state_23435[(8)]);
var state_23435__$1 = state_23435;
var statearr_23442_23471 = state_23435__$1;
(statearr_23442_23471[(2)] = inst_23413);

(statearr_23442_23471[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (6))){
var inst_23401 = (state_23435[(7)]);
var inst_23403 = fluree.db.query.fql.fuel_flakes_transducer.call(null,fuel,max_fuel);
var inst_23404 = cljs.core.comp.call(null,inst_23401,inst_23403);
var state_23435__$1 = state_23435;
var statearr_23443_23472 = state_23435__$1;
(statearr_23443_23472[(2)] = inst_23404);

(statearr_23443_23472[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (3))){
var inst_23433 = (state_23435[(2)]);
var state_23435__$1 = state_23435;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23435__$1,inst_23433);
} else {
if((state_val_23436 === (12))){
var inst_23413 = (state_23435[(8)]);
var inst_23415 = cljs.core.take.call(null,limit);
var inst_23416 = cljs.core.comp.call(null,inst_23413,inst_23415);
var state_23435__$1 = state_23435;
var statearr_23444_23473 = state_23435__$1;
(statearr_23444_23473[(2)] = inst_23416);

(statearr_23444_23473[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (2))){
var _ = (function (){var statearr_23445 = state_23435;
(statearr_23445[(4)] = cljs.core.cons.call(null,(5),(state_23435[(4)])));

return statearr_23445;
})();
var inst_23401 = cljs.core.partition_by.call(null,fluree.db.query.fql.s);
var state_23435__$1 = (function (){var statearr_23446 = state_23435;
(statearr_23446[(7)] = inst_23401);

return statearr_23446;
})();
if(cljs.core.truth_(fuel)){
var statearr_23447_23474 = state_23435__$1;
(statearr_23447_23474[(1)] = (6));

} else {
var statearr_23448_23475 = state_23435__$1;
(statearr_23448_23475[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (11))){
var inst_23413 = (state_23435[(2)]);
var state_23435__$1 = (function (){var statearr_23450 = state_23435;
(statearr_23450[(8)] = inst_23413);

return statearr_23450;
})();
if(cljs.core.truth_(limit)){
var statearr_23451_23476 = state_23435__$1;
(statearr_23451_23476[(1)] = (12));

} else {
var statearr_23452_23477 = state_23435__$1;
(statearr_23452_23477[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (9))){
var inst_23407 = (state_23435[(9)]);
var inst_23409 = cljs.core.drop.call(null,offset);
var inst_23410 = cljs.core.comp.call(null,inst_23407,inst_23409);
var state_23435__$1 = state_23435;
var statearr_23453_23478 = state_23435__$1;
(statearr_23453_23478[(2)] = inst_23410);

(statearr_23453_23478[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (5))){
var _ = (function (){var statearr_23454 = state_23435;
(statearr_23454[(4)] = cljs.core.rest.call(null,(state_23435[(4)])));

return statearr_23454;
})();
var state_23435__$1 = state_23435;
var ex23449 = (state_23435__$1[(2)]);
var statearr_23455_23479 = state_23435__$1;
(statearr_23455_23479[(5)] = ex23449);


if((ex23449 instanceof Error)){
var statearr_23456_23480 = state_23435__$1;
(statearr_23456_23480[(1)] = (4));

(statearr_23456_23480[(5)] = null);

} else {
throw ex23449;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (14))){
var inst_23419 = (state_23435[(2)]);
var inst_23420 = (function (){return (function (x){
var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.deref.call(null,fuel) >= max_fuel);
} else {
return and__4115__auto__;
}
});
})();
var inst_23421 = cljs.core.halt_when.call(null,inst_23420);
var inst_23422 = cljs.core.comp.call(null,inst_23419,inst_23421);
var inst_23423 = cljs.core.sequence.call(null,inst_23422,flakes);
var inst_23424 = cljs.core.PersistentVector.EMPTY;
var inst_23425 = (function (){var xf = inst_23422;
var flakes_by_sub = inst_23423;
return (function (p1__23391_SHARP_){
return fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,select_spec,p1__23391_SHARP_);
});
})();
var inst_23426 = cljs.core.map.call(null,inst_23425,inst_23423);
var inst_23427 = fluree.db.util.async.merge_into_QMARK_.call(null,inst_23424,inst_23426);
var state_23435__$1 = state_23435;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23435__$1,(15),inst_23427);
} else {
if((state_val_23436 === (10))){
var inst_23407 = (state_23435[(9)]);
var state_23435__$1 = state_23435;
var statearr_23457_23481 = state_23435__$1;
(statearr_23457_23481[(2)] = inst_23407);

(statearr_23457_23481[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (8))){
var inst_23407 = (state_23435[(2)]);
var state_23435__$1 = (function (){var statearr_23458 = state_23435;
(statearr_23458[(9)] = inst_23407);

return statearr_23458;
})();
if(cljs.core.truth_(offset)){
var statearr_23459_23482 = state_23435__$1;
(statearr_23459_23482[(1)] = (9));

} else {
var statearr_23460_23483 = state_23435__$1;
(statearr_23460_23483[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2468__auto__ = null;
var fluree$db$query$fql$state_machine__2468__auto____0 = (function (){
var statearr_23461 = [null,null,null,null,null,null,null,null,null,null];
(statearr_23461[(0)] = fluree$db$query$fql$state_machine__2468__auto__);

(statearr_23461[(1)] = (1));

return statearr_23461;
});
var fluree$db$query$fql$state_machine__2468__auto____1 = (function (state_23435){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_23435);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e23462){var ex__2471__auto__ = e23462;
var statearr_23463_23484 = state_23435;
(statearr_23463_23484[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_23435[(4)]))){
var statearr_23464_23485 = state_23435;
(statearr_23464_23485[(1)] = cljs.core.first.call(null,(state_23435[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23486 = state_23435;
state_23435 = G__23486;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2468__auto__ = function(state_23435){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2468__auto____1.call(this,state_23435);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2468__auto____0;
fluree$db$query$fql$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2468__auto____1;
return fluree$db$query$fql$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_23465 = f__2491__auto__.call(null);
(statearr_23465[(6)] = c__2490__auto__);

return statearr_23465;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__23488 = arguments.length;
switch (G__23488) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.call(null,db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.call(null,db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_23572){
var state_val_23573 = (state_23572[(1)]);
if((state_val_23573 === (7))){
var inst_23567 = (state_23572[(2)]);
var _ = (function (){var statearr_23575 = state_23572;
(statearr_23575[(4)] = cljs.core.rest.call(null,(state_23572[(4)])));

return statearr_23575;
})();
var state_23572__$1 = state_23572;
var statearr_23576_23623 = state_23572__$1;
(statearr_23576_23623[(2)] = inst_23567);

(statearr_23576_23623[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23573 === (20))){
var inst_23509 = (state_23572[(7)]);
var inst_23516 = (state_23572[(8)]);
var inst_23508 = (state_23572[(9)]);
var inst_23537 = (inst_23508 + (1));
var tmp23574 = inst_23509;
var inst_23507 = inst_23516;
var inst_23508__$1 = inst_23537;
var inst_23509__$1 = tmp23574;
var state_23572__$1 = (function (){var statearr_23577 = state_23572;
(statearr_23577[(10)] = inst_23507);

(statearr_23577[(7)] = inst_23509__$1);

(statearr_23577[(9)] = inst_23508__$1);

return statearr_23577;
})();
var statearr_23578_23624 = state_23572__$1;
(statearr_23578_23624[(2)] = null);

(statearr_23578_23624[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23573 === (27))){
var inst_23542 = (state_23572[(11)]);
var inst_23551 = (state_23572[(2)]);
var inst_23552 = fluree.db.util.async.throw_err.call(null,inst_23551);
var inst_23553 = inst_23542.call(null,inst_23552);
var state_23572__$1 = state_23572;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23572__$1,(26),inst_23553);
} else {
if((state_val_23573 === (1))){
var state_23572__$1 = state_23572;
var statearr_23579_23625 = state_23572__$1;
(statearr_23579_23625[(2)] = null);

(statearr_23579_23625[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23573 === (24))){
var state_23572__$1 = state_23572;
var statearr_23580_23626 = state_23572__$1;
(statearr_23580_23626[(2)] = null);

(statearr_23580_23626[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23573 === (4))){
var inst_23489 = (state_23572[(2)]);
var state_23572__$1 = state_23572;
var statearr_23581_23627 = state_23572__$1;
(statearr_23581_23627[(2)] = inst_23489);

(statearr_23581_23627[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23573 === (15))){
var inst_23530 = (state_23572[(12)]);
var inst_23530__$1 = offset;
var state_23572__$1 = (function (){var statearr_23582 = state_23572;
(statearr_23582[(12)] = inst_23530__$1);

return statearr_23582;
})();
if(cljs.core.truth_(inst_23530__$1)){
var statearr_23583_23628 = state_23572__$1;
(statearr_23583_23628[(1)] = (17));

} else {
var statearr_23584_23629 = state_23572__$1;
(statearr_23584_23629[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23573 === (21))){
var state_23572__$1 = state_23572;
var statearr_23585_23630 = state_23572__$1;
(statearr_23585_23630[(1)] = (23));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23573 === (13))){
var inst_23525 = (state_23572[(2)]);
var state_23572__$1 = state_23572;
var statearr_23587_23631 = state_23572__$1;
(statearr_23587_23631[(2)] = inst_23525);

(statearr_23587_23631[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23573 === (22))){
var inst_23563 = (state_23572[(2)]);
var state_23572__$1 = state_23572;
var statearr_23588_23632 = state_23572__$1;
(statearr_23588_23632[(2)] = inst_23563);

(statearr_23588_23632[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23573 === (6))){
var inst_23507 = (state_23572[(10)]);
var inst_23515 = (state_23572[(13)]);
var inst_23517 = (state_23572[(14)]);
var inst_23514 = cljs.core.seq.call(null,inst_23507);
var inst_23515__$1 = cljs.core.first.call(null,inst_23514);
var inst_23516 = cljs.core.next.call(null,inst_23514);
var inst_23517__$1 = (inst_23515__$1 == null);
var state_23572__$1 = (function (){var statearr_23589 = state_23572;
(statearr_23589[(8)] = inst_23516);

(statearr_23589[(13)] = inst_23515__$1);

(statearr_23589[(14)] = inst_23517__$1);

return statearr_23589;
})();
if(cljs.core.truth_(inst_23517__$1)){
var statearr_23590_23633 = state_23572__$1;
(statearr_23590_23633[(1)] = (8));

} else {
var statearr_23591_23634 = state_23572__$1;
(statearr_23591_23634[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23573 === (25))){
var inst_23561 = (state_23572[(2)]);
var state_23572__$1 = state_23572;
var statearr_23592_23635 = state_23572__$1;
(statearr_23592_23635[(2)] = inst_23561);

(statearr_23592_23635[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23573 === (17))){
var inst_23508 = (state_23572[(9)]);
var inst_23532 = (inst_23508 < offset);
var state_23572__$1 = state_23572;
var statearr_23593_23636 = state_23572__$1;
(statearr_23593_23636[(2)] = inst_23532);

(statearr_23593_23636[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23573 === (3))){
var inst_23570 = (state_23572[(2)]);
var state_23572__$1 = state_23572;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23572__$1,inst_23570);
} else {
if((state_val_23573 === (12))){
var inst_23520 = (state_23572[(15)]);
var state_23572__$1 = state_23572;
var statearr_23594_23637 = state_23572__$1;
(statearr_23594_23637[(2)] = inst_23520);

(statearr_23594_23637[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23573 === (2))){
var inst_23502 = (state_23572[(16)]);
var _ = (function (){var statearr_23595 = state_23572;
(statearr_23595[(4)] = cljs.core.cons.call(null,(5),(state_23572[(4)])));

return statearr_23595;
})();
var inst_23502__$1 = subjects;
var inst_23503 = cljs.core.seq.call(null,inst_23502__$1);
var inst_23504 = cljs.core.first.call(null,inst_23503);
var inst_23505 = cljs.core.next.call(null,inst_23503);
var inst_23506 = cljs.core.PersistentVector.EMPTY;
var inst_23507 = inst_23502__$1;
var inst_23508 = (0);
var inst_23509 = inst_23506;
var state_23572__$1 = (function (){var statearr_23596 = state_23572;
(statearr_23596[(10)] = inst_23507);

(statearr_23596[(7)] = inst_23509);

(statearr_23596[(16)] = inst_23502__$1);

(statearr_23596[(17)] = inst_23505);

(statearr_23596[(9)] = inst_23508);

(statearr_23596[(18)] = inst_23504);

return statearr_23596;
})();
var statearr_23597_23638 = state_23572__$1;
(statearr_23597_23638[(2)] = null);

(statearr_23597_23638[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23573 === (23))){
var inst_23507 = (state_23572[(10)]);
var inst_23509 = (state_23572[(7)]);
var inst_23502 = (state_23572[(16)]);
var inst_23516 = (state_23572[(8)]);
var inst_23505 = (state_23572[(17)]);
var inst_23508 = (state_23572[(9)]);
var inst_23515 = (state_23572[(13)]);
var inst_23504 = (state_23572[(18)]);
var inst_23541 = (inst_23508 + (1));
var inst_23542 = (function (){var vec__23499 = inst_23502;
var r = inst_23516;
var G__23498 = inst_23507;
var acc = inst_23509;
var n = inst_23508;
var first__23513 = inst_23515;
var seq__23500 = inst_23505;
var seq__23512 = inst_23516;
var s = inst_23515;
var vec__23511 = inst_23507;
var first__23501 = inst_23504;
return (function (n__$1){
return fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,select_spec,n__$1);
});
})();
var inst_23543 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23544 = [inst_23515];
var inst_23545 = (new cljs.core.PersistentVector(null,1,(5),inst_23543,inst_23544,null));
var inst_23546 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_23547 = [limit];
var inst_23548 = cljs.core.PersistentHashMap.fromArrays(inst_23546,inst_23547);
var inst_23549 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23545,inst_23548);
var state_23572__$1 = (function (){var statearr_23598 = state_23572;
(statearr_23598[(19)] = inst_23541);

(statearr_23598[(11)] = inst_23542);

return statearr_23598;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23572__$1,(27),inst_23549);
} else {
if((state_val_23573 === (19))){
var inst_23535 = (state_23572[(2)]);
var state_23572__$1 = state_23572;
if(cljs.core.truth_(inst_23535)){
var statearr_23599_23639 = state_23572__$1;
(statearr_23599_23639[(1)] = (20));

} else {
var statearr_23600_23640 = state_23572__$1;
(statearr_23600_23640[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23573 === (11))){
var inst_23508 = (state_23572[(9)]);
var inst_23522 = (inst_23508 > limit);
var state_23572__$1 = state_23572;
var statearr_23602_23641 = state_23572__$1;
(statearr_23602_23641[(2)] = inst_23522);

(statearr_23602_23641[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23573 === (9))){
var inst_23520 = (state_23572[(15)]);
var inst_23520__$1 = limit;
var state_23572__$1 = (function (){var statearr_23603 = state_23572;
(statearr_23603[(15)] = inst_23520__$1);

return statearr_23603;
})();
if(cljs.core.truth_(inst_23520__$1)){
var statearr_23604_23642 = state_23572__$1;
(statearr_23604_23642[(1)] = (11));

} else {
var statearr_23605_23643 = state_23572__$1;
(statearr_23605_23643[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23573 === (5))){
var _ = (function (){var statearr_23606 = state_23572;
(statearr_23606[(4)] = cljs.core.rest.call(null,(state_23572[(4)])));

return statearr_23606;
})();
var state_23572__$1 = state_23572;
var ex23601 = (state_23572__$1[(2)]);
var statearr_23607_23644 = state_23572__$1;
(statearr_23607_23644[(5)] = ex23601);


if((ex23601 instanceof Error)){
var statearr_23608_23645 = state_23572__$1;
(statearr_23608_23645[(1)] = (4));

(statearr_23608_23645[(5)] = null);

} else {
throw ex23601;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23573 === (14))){
var inst_23509 = (state_23572[(7)]);
var state_23572__$1 = state_23572;
var statearr_23609_23646 = state_23572__$1;
(statearr_23609_23646[(2)] = inst_23509);

(statearr_23609_23646[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23573 === (26))){
var inst_23541 = (state_23572[(19)]);
var inst_23509 = (state_23572[(7)]);
var inst_23516 = (state_23572[(8)]);
var inst_23555 = (state_23572[(2)]);
var inst_23556 = fluree.db.util.async.throw_err.call(null,inst_23555);
var inst_23557 = cljs.core.conj.call(null,inst_23509,inst_23556);
var inst_23507 = inst_23516;
var inst_23508 = inst_23541;
var inst_23509__$1 = inst_23557;
var state_23572__$1 = (function (){var statearr_23610 = state_23572;
(statearr_23610[(10)] = inst_23507);

(statearr_23610[(7)] = inst_23509__$1);

(statearr_23610[(9)] = inst_23508);

return statearr_23610;
})();
var statearr_23611_23647 = state_23572__$1;
(statearr_23611_23647[(2)] = null);

(statearr_23611_23647[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23573 === (16))){
var inst_23565 = (state_23572[(2)]);
var state_23572__$1 = state_23572;
var statearr_23612_23648 = state_23572__$1;
(statearr_23612_23648[(2)] = inst_23565);

(statearr_23612_23648[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23573 === (10))){
var inst_23527 = (state_23572[(2)]);
var state_23572__$1 = state_23572;
if(cljs.core.truth_(inst_23527)){
var statearr_23613_23649 = state_23572__$1;
(statearr_23613_23649[(1)] = (14));

} else {
var statearr_23614_23650 = state_23572__$1;
(statearr_23614_23650[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23573 === (18))){
var inst_23530 = (state_23572[(12)]);
var state_23572__$1 = state_23572;
var statearr_23615_23651 = state_23572__$1;
(statearr_23615_23651[(2)] = inst_23530);

(statearr_23615_23651[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23573 === (8))){
var inst_23517 = (state_23572[(14)]);
var state_23572__$1 = state_23572;
var statearr_23616_23652 = state_23572__$1;
(statearr_23616_23652[(2)] = inst_23517);

(statearr_23616_23652[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2468__auto__ = null;
var fluree$db$query$fql$state_machine__2468__auto____0 = (function (){
var statearr_23617 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23617[(0)] = fluree$db$query$fql$state_machine__2468__auto__);

(statearr_23617[(1)] = (1));

return statearr_23617;
});
var fluree$db$query$fql$state_machine__2468__auto____1 = (function (state_23572){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_23572);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e23618){var ex__2471__auto__ = e23618;
var statearr_23619_23653 = state_23572;
(statearr_23619_23653[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_23572[(4)]))){
var statearr_23620_23654 = state_23572;
(statearr_23620_23654[(1)] = cljs.core.first.call(null,(state_23572[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23655 = state_23572;
state_23572 = G__23655;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2468__auto__ = function(state_23572){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2468__auto____1.call(this,state_23572);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2468__auto____0;
fluree$db$query$fql$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2468__auto____1;
return fluree$db$query$fql$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_23621 = f__2491__auto__.call(null);
(statearr_23621[(6)] = c__2490__auto__);

return statearr_23621;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__4126__auto__ = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p);
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223),fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"type","type",1174270348),p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__23657 = arguments.length;
switch (G__23657) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.call(null,db,where_clause,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3 = (function (db,where_clause,default_collection){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_23845){
var state_val_23846 = (state_23845[(1)]);
if((state_val_23846 === (7))){
var state_23845__$1 = state_23845;
var statearr_23847_23918 = state_23845__$1;
(statearr_23847_23918[(2)] = null);

(statearr_23847_23918[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (20))){
var inst_23700 = (state_23845[(7)]);
var inst_23698 = (state_23845[(8)]);
var inst_23728 = (state_23845[(2)]);
var inst_23729 = fluree.db.util.async.throw_err.call(null,inst_23728);
var inst_23730 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23731 = [inst_23698];
var inst_23732 = (new cljs.core.PersistentVector(null,1,(5),inst_23730,inst_23731,null));
var inst_23733 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23734 = [inst_23698,inst_23700];
var inst_23735 = (new cljs.core.PersistentVector(null,2,(5),inst_23733,inst_23734,null));
var inst_23736 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_23732,cljs.core._LT_,inst_23735);
var state_23845__$1 = (function (){var statearr_23848 = state_23845;
(statearr_23848[(9)] = inst_23729);

return statearr_23848;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23845__$1,(21),inst_23736);
} else {
if((state_val_23846 === (27))){
var inst_23717 = (state_23845[(10)]);
var inst_23699 = (state_23845[(11)]);
var inst_23765 = inst_23717.call(null,cljs.core._GT__EQ_,inst_23699);
var state_23845__$1 = state_23845;
if(cljs.core.truth_(inst_23765)){
var statearr_23849_23919 = state_23845__$1;
(statearr_23849_23919[(1)] = (30));

} else {
var statearr_23850_23920 = state_23845__$1;
(statearr_23850_23920[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (1))){
var state_23845__$1 = state_23845;
var statearr_23851_23921 = state_23845__$1;
(statearr_23851_23921[(2)] = null);

(statearr_23851_23921[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (24))){
var inst_23814 = (state_23845[(2)]);
var state_23845__$1 = state_23845;
var statearr_23852_23922 = state_23845__$1;
(statearr_23852_23922[(2)] = inst_23814);

(statearr_23852_23922[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (39))){
var inst_23804 = null;
var state_23845__$1 = state_23845;
var statearr_23853_23923 = state_23845__$1;
(statearr_23853_23923[(2)] = inst_23804);

(statearr_23853_23923[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (46))){
var inst_23691 = (state_23845[(12)]);
var inst_23825 = (state_23845[(13)]);
var inst_23683 = inst_23691;
var inst_23684 = inst_23825;
var state_23845__$1 = (function (){var statearr_23854 = state_23845;
(statearr_23854[(14)] = inst_23684);

(statearr_23854[(15)] = inst_23683);

return statearr_23854;
})();
var statearr_23855_23924 = state_23845__$1;
(statearr_23855_23924[(2)] = null);

(statearr_23855_23924[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (4))){
var inst_23658 = (state_23845[(2)]);
var state_23845__$1 = state_23845;
var statearr_23856_23925 = state_23845__$1;
(statearr_23856_23925[(2)] = inst_23658);

(statearr_23856_23925[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (15))){
var state_23845__$1 = state_23845;
var statearr_23857_23926 = state_23845__$1;
(statearr_23857_23926[(2)] = null);

(statearr_23857_23926[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (21))){
var inst_23729 = (state_23845[(9)]);
var inst_23738 = (state_23845[(2)]);
var inst_23739 = fluree.db.util.async.throw_err.call(null,inst_23738);
var inst_23740 = cljs.core.concat.call(null,inst_23729,inst_23739);
var state_23845__$1 = state_23845;
var statearr_23858_23927 = state_23845__$1;
(statearr_23858_23927[(2)] = inst_23740);

(statearr_23858_23927[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (31))){
var inst_23717 = (state_23845[(10)]);
var inst_23699 = (state_23845[(11)]);
var inst_23778 = inst_23717.call(null,cljs.core._LT_,inst_23699);
var state_23845__$1 = state_23845;
if(cljs.core.truth_(inst_23778)){
var statearr_23859_23928 = state_23845__$1;
(statearr_23859_23928[(1)] = (34));

} else {
var statearr_23860_23929 = state_23845__$1;
(statearr_23860_23929[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (32))){
var inst_23810 = (state_23845[(2)]);
var state_23845__$1 = state_23845;
var statearr_23861_23930 = state_23845__$1;
(statearr_23861_23930[(2)] = inst_23810);

(statearr_23861_23930[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (40))){
var inst_23806 = (state_23845[(2)]);
var state_23845__$1 = state_23845;
var statearr_23862_23931 = state_23845__$1;
(statearr_23862_23931[(2)] = inst_23806);

(statearr_23862_23931[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (33))){
var inst_23775 = (state_23845[(2)]);
var inst_23776 = fluree.db.util.async.throw_err.call(null,inst_23775);
var state_23845__$1 = state_23845;
var statearr_23863_23932 = state_23845__$1;
(statearr_23863_23932[(2)] = inst_23776);

(statearr_23863_23932[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (13))){
var inst_23835 = (state_23845[(2)]);
var state_23845__$1 = state_23845;
var statearr_23864_23933 = state_23845__$1;
(statearr_23864_23933[(2)] = inst_23835);

(statearr_23864_23933[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (22))){
var inst_23700 = (state_23845[(7)]);
var inst_23698 = (state_23845[(8)]);
var inst_23744 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23745 = [inst_23698,inst_23700];
var inst_23746 = (new cljs.core.PersistentVector(null,2,(5),inst_23744,inst_23745,null));
var inst_23747 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_23746);
var state_23845__$1 = state_23845;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23845__$1,(25),inst_23747);
} else {
if((state_val_23846 === (36))){
var inst_23808 = (state_23845[(2)]);
var state_23845__$1 = state_23845;
var statearr_23865_23934 = state_23845__$1;
(statearr_23865_23934[(2)] = inst_23808);

(statearr_23865_23934[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (41))){
var inst_23801 = (state_23845[(2)]);
var inst_23802 = fluree.db.util.async.throw_err.call(null,inst_23801);
var state_23845__$1 = state_23845;
var statearr_23866_23935 = state_23845__$1;
(statearr_23866_23935[(2)] = inst_23802);

(statearr_23866_23935[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (43))){
var inst_23684 = (state_23845[(14)]);
var inst_23817 = (state_23845[(16)]);
var inst_23818 = cljs.core.into.call(null,inst_23684,inst_23817);
var state_23845__$1 = state_23845;
var statearr_23867_23936 = state_23845__$1;
(statearr_23867_23936[(2)] = inst_23818);

(statearr_23867_23936[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (29))){
var inst_23762 = (state_23845[(2)]);
var inst_23763 = fluree.db.util.async.throw_err.call(null,inst_23762);
var state_23845__$1 = state_23845;
var statearr_23868_23937 = state_23845__$1;
(statearr_23868_23937[(2)] = inst_23763);

(statearr_23868_23937[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (44))){
var inst_23684 = (state_23845[(14)]);
var inst_23817 = (state_23845[(16)]);
var inst_23820 = cljs.core.PersistentHashSet.EMPTY;
var inst_23821 = cljs.core.into.call(null,inst_23820,inst_23817);
var inst_23822 = clojure.set.intersection.call(null,inst_23684,inst_23821);
var state_23845__$1 = state_23845;
var statearr_23869_23938 = state_23845__$1;
(statearr_23869_23938[(2)] = inst_23822);

(statearr_23869_23938[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (6))){
var inst_23669 = (state_23845[(17)]);
var inst_23679 = cljs.core.seq.call(null,inst_23669);
var inst_23680 = cljs.core.first.call(null,inst_23679);
var inst_23681 = cljs.core.next.call(null,inst_23679);
var inst_23682 = cljs.core.PersistentHashSet.EMPTY;
var inst_23683 = inst_23669;
var inst_23684 = inst_23682;
var state_23845__$1 = (function (){var statearr_23870 = state_23845;
(statearr_23870[(14)] = inst_23684);

(statearr_23870[(18)] = inst_23681);

(statearr_23870[(19)] = inst_23680);

(statearr_23870[(15)] = inst_23683);

return statearr_23870;
})();
var statearr_23871_23939 = state_23845__$1;
(statearr_23871_23939[(2)] = null);

(statearr_23871_23939[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (28))){
var inst_23812 = (state_23845[(2)]);
var state_23845__$1 = state_23845;
var statearr_23872_23940 = state_23845__$1;
(statearr_23872_23940[(2)] = inst_23812);

(statearr_23872_23940[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (25))){
var inst_23749 = (state_23845[(2)]);
var inst_23750 = fluree.db.util.async.throw_err.call(null,inst_23749);
var state_23845__$1 = state_23845;
var statearr_23873_23941 = state_23845__$1;
(statearr_23873_23941[(2)] = inst_23750);

(statearr_23873_23941[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (34))){
var inst_23700 = (state_23845[(7)]);
var inst_23698 = (state_23845[(8)]);
var inst_23780 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23781 = [inst_23698];
var inst_23782 = (new cljs.core.PersistentVector(null,1,(5),inst_23780,inst_23781,null));
var inst_23783 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23784 = [inst_23698,inst_23700];
var inst_23785 = (new cljs.core.PersistentVector(null,2,(5),inst_23783,inst_23784,null));
var inst_23786 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_23782,cljs.core._LT_,inst_23785);
var state_23845__$1 = state_23845;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23845__$1,(37),inst_23786);
} else {
if((state_val_23846 === (17))){
var inst_23700 = (state_23845[(7)]);
var inst_23698 = (state_23845[(8)]);
var inst_23720 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23721 = [inst_23698,inst_23700];
var inst_23722 = (new cljs.core.PersistentVector(null,2,(5),inst_23720,inst_23721,null));
var inst_23723 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23724 = [inst_23698];
var inst_23725 = (new cljs.core.PersistentVector(null,1,(5),inst_23723,inst_23724,null));
var inst_23726 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_23722,cljs.core._LT__EQ_,inst_23725);
var state_23845__$1 = state_23845;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23845__$1,(20),inst_23726);
} else {
if((state_val_23846 === (3))){
var inst_23843 = (state_23845[(2)]);
var state_23845__$1 = state_23845;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23845__$1,inst_23843);
} else {
if((state_val_23846 === (12))){
var inst_23690 = (state_23845[(20)]);
var inst_23698 = (state_23845[(8)]);
var inst_23698__$1 = cljs.core.nth.call(null,inst_23690,(0),null);
var inst_23699 = cljs.core.nth.call(null,inst_23690,(1),null);
var inst_23700 = cljs.core.nth.call(null,inst_23690,(2),null);
var inst_23701 = fluree.db.query.fql.valid_where_predicate_QMARK_.call(null,db,inst_23698__$1);
var inst_23702 = cljs.core.not.call(null,inst_23701);
var state_23845__$1 = (function (){var statearr_23874 = state_23845;
(statearr_23874[(7)] = inst_23700);

(statearr_23874[(11)] = inst_23699);

(statearr_23874[(8)] = inst_23698__$1);

return statearr_23874;
})();
if(inst_23702){
var statearr_23875_23942 = state_23845__$1;
(statearr_23875_23942[(1)] = (14));

} else {
var statearr_23876_23943 = state_23845__$1;
(statearr_23876_23943[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (2))){
var inst_23669 = (state_23845[(17)]);
var _ = (function (){var statearr_23877 = state_23845;
(statearr_23877[(4)] = cljs.core.cons.call(null,(5),(state_23845[(4)])));

return statearr_23877;
})();
var inst_23667 = fluree.db.query.fql_parser.parse_where.call(null,db,where_clause,default_collection);
var inst_23668 = cljs.core.nth.call(null,inst_23667,(0),null);
var inst_23669__$1 = cljs.core.nth.call(null,inst_23667,(1),null);
var inst_23670 = cljs.core.not_empty.call(null,inst_23669__$1);
var state_23845__$1 = (function (){var statearr_23878 = state_23845;
(statearr_23878[(17)] = inst_23669__$1);

(statearr_23878[(21)] = inst_23668);

return statearr_23878;
})();
if(cljs.core.truth_(inst_23670)){
var statearr_23879_23944 = state_23845__$1;
(statearr_23879_23944[(1)] = (6));

} else {
var statearr_23880_23945 = state_23845__$1;
(statearr_23880_23945[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (23))){
var inst_23717 = (state_23845[(10)]);
var inst_23699 = (state_23845[(11)]);
var inst_23752 = inst_23717.call(null,cljs.core._GT_,inst_23699);
var state_23845__$1 = state_23845;
if(cljs.core.truth_(inst_23752)){
var statearr_23881_23946 = state_23845__$1;
(statearr_23881_23946[(1)] = (26));

} else {
var statearr_23882_23947 = state_23845__$1;
(statearr_23882_23947[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (47))){
var inst_23833 = (state_23845[(2)]);
var state_23845__$1 = state_23845;
var statearr_23883_23948 = state_23845__$1;
(statearr_23883_23948[(2)] = inst_23833);

(statearr_23883_23948[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (35))){
var inst_23717 = (state_23845[(10)]);
var inst_23699 = (state_23845[(11)]);
var inst_23791 = inst_23717.call(null,cljs.core._LT__EQ_,inst_23699);
var state_23845__$1 = state_23845;
if(cljs.core.truth_(inst_23791)){
var statearr_23884_23949 = state_23845__$1;
(statearr_23884_23949[(1)] = (38));

} else {
var statearr_23885_23950 = state_23845__$1;
(statearr_23885_23950[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (19))){
var inst_23668 = (state_23845[(21)]);
var inst_23816 = (state_23845[(2)]);
var inst_23817 = cljs.core.map.call(null,fluree.db.query.fql.s,inst_23816);
var state_23845__$1 = (function (){var statearr_23886 = state_23845;
(statearr_23886[(16)] = inst_23817);

return statearr_23886;
})();
var G__23887_23951 = inst_23668;
var G__23887_23952__$1 = (((G__23887_23951 instanceof cljs.core.Keyword))?G__23887_23951.fqn:null);
switch (G__23887_23952__$1) {
case "or":
var statearr_23888_23954 = state_23845__$1;
(statearr_23888_23954[(1)] = (43));


break;
case "and":
var statearr_23889_23955 = state_23845__$1;
(statearr_23889_23955[(1)] = (44));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__23887_23952__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (11))){
var inst_23684 = (state_23845[(14)]);
var state_23845__$1 = state_23845;
var statearr_23891_23956 = state_23845__$1;
(statearr_23891_23956[(2)] = inst_23684);

(statearr_23891_23956[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (9))){
var inst_23690 = (state_23845[(20)]);
var inst_23683 = (state_23845[(15)]);
var inst_23689 = cljs.core.seq.call(null,inst_23683);
var inst_23690__$1 = cljs.core.first.call(null,inst_23689);
var inst_23691 = cljs.core.next.call(null,inst_23689);
var inst_23692 = cljs.core.not.call(null,inst_23690__$1);
var state_23845__$1 = (function (){var statearr_23892 = state_23845;
(statearr_23892[(12)] = inst_23691);

(statearr_23892[(20)] = inst_23690__$1);

return statearr_23892;
})();
if(inst_23692){
var statearr_23893_23957 = state_23845__$1;
(statearr_23893_23957[(1)] = (11));

} else {
var statearr_23894_23958 = state_23845__$1;
(statearr_23894_23958[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (5))){
var _ = (function (){var statearr_23895 = state_23845;
(statearr_23895[(4)] = cljs.core.rest.call(null,(state_23845[(4)])));

return statearr_23895;
})();
var state_23845__$1 = state_23845;
var ex23890 = (state_23845__$1[(2)]);
var statearr_23896_23959 = state_23845__$1;
(statearr_23896_23959[(5)] = ex23890);


if((ex23890 instanceof Error)){
var statearr_23897_23960 = state_23845__$1;
(statearr_23897_23960[(1)] = (4));

(statearr_23897_23960[(5)] = null);

} else {
throw ex23890;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (14))){
var inst_23698 = (state_23845[(8)]);
var inst_23704 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_23698);
var inst_23705 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_23704)].join('');
var inst_23706 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_23707 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_23708 = cljs.core.PersistentHashMap.fromArrays(inst_23706,inst_23707);
var inst_23709 = cljs.core.ex_info.call(null,inst_23705,inst_23708);
var inst_23710 = (function(){throw inst_23709})();
var state_23845__$1 = state_23845;
var statearr_23898_23961 = state_23845__$1;
(statearr_23898_23961[(2)] = inst_23710);

(statearr_23898_23961[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (45))){
var inst_23825 = (state_23845[(13)]);
var state_23845__$1 = state_23845;
var statearr_23899_23962 = state_23845__$1;
(statearr_23899_23962[(2)] = inst_23825);

(statearr_23899_23962[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (26))){
var inst_23700 = (state_23845[(7)]);
var inst_23698 = (state_23845[(8)]);
var inst_23754 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23755 = [inst_23698,inst_23700];
var inst_23756 = (new cljs.core.PersistentVector(null,2,(5),inst_23754,inst_23755,null));
var inst_23757 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23758 = [inst_23698];
var inst_23759 = (new cljs.core.PersistentVector(null,1,(5),inst_23757,inst_23758,null));
var inst_23760 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_23756,cljs.core._LT__EQ_,inst_23759);
var state_23845__$1 = state_23845;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23845__$1,(29),inst_23760);
} else {
if((state_val_23846 === (16))){
var inst_23717 = (state_23845[(10)]);
var inst_23699 = (state_23845[(11)]);
var inst_23713 = (state_23845[(2)]);
var inst_23717__$1 = cljs.core.identical_QMARK_;
var inst_23718 = inst_23717__$1.call(null,cljs.core.not_EQ_,inst_23699);
var state_23845__$1 = (function (){var statearr_23900 = state_23845;
(statearr_23900[(10)] = inst_23717__$1);

(statearr_23900[(22)] = inst_23713);

return statearr_23900;
})();
if(cljs.core.truth_(inst_23718)){
var statearr_23901_23963 = state_23845__$1;
(statearr_23901_23963[(1)] = (17));

} else {
var statearr_23902_23964 = state_23845__$1;
(statearr_23902_23964[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (38))){
var inst_23700 = (state_23845[(7)]);
var inst_23698 = (state_23845[(8)]);
var inst_23793 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23794 = [inst_23698];
var inst_23795 = (new cljs.core.PersistentVector(null,1,(5),inst_23793,inst_23794,null));
var inst_23796 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23797 = [inst_23698,inst_23700];
var inst_23798 = (new cljs.core.PersistentVector(null,2,(5),inst_23796,inst_23797,null));
var inst_23799 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_23795,cljs.core._LT__EQ_,inst_23798);
var state_23845__$1 = state_23845;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23845__$1,(41),inst_23799);
} else {
if((state_val_23846 === (30))){
var inst_23700 = (state_23845[(7)]);
var inst_23698 = (state_23845[(8)]);
var inst_23767 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23768 = [inst_23698,inst_23700];
var inst_23769 = (new cljs.core.PersistentVector(null,2,(5),inst_23767,inst_23768,null));
var inst_23770 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23771 = [inst_23698];
var inst_23772 = (new cljs.core.PersistentVector(null,1,(5),inst_23770,inst_23771,null));
var inst_23773 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_23769,cljs.core._LT__EQ_,inst_23772);
var state_23845__$1 = state_23845;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23845__$1,(33),inst_23773);
} else {
if((state_val_23846 === (10))){
var inst_23837 = (state_23845[(2)]);
var state_23845__$1 = state_23845;
var statearr_23903_23965 = state_23845__$1;
(statearr_23903_23965[(2)] = inst_23837);

(statearr_23903_23965[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (18))){
var inst_23717 = (state_23845[(10)]);
var inst_23699 = (state_23845[(11)]);
var inst_23742 = inst_23717.call(null,cljs.core._EQ_,inst_23699);
var state_23845__$1 = state_23845;
if(cljs.core.truth_(inst_23742)){
var statearr_23904_23966 = state_23845__$1;
(statearr_23904_23966[(1)] = (22));

} else {
var statearr_23905_23967 = state_23845__$1;
(statearr_23905_23967[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (42))){
var inst_23825 = (state_23845[(13)]);
var inst_23668 = (state_23845[(21)]);
var inst_23825__$1 = (state_23845[(2)]);
var inst_23826 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"and","and",-971899817),inst_23668);
var inst_23827 = cljs.core.empty_QMARK_.call(null,inst_23825__$1);
var inst_23828 = ((inst_23826) && (inst_23827));
var state_23845__$1 = (function (){var statearr_23906 = state_23845;
(statearr_23906[(13)] = inst_23825__$1);

return statearr_23906;
})();
if(cljs.core.truth_(inst_23828)){
var statearr_23907_23968 = state_23845__$1;
(statearr_23907_23968[(1)] = (45));

} else {
var statearr_23908_23969 = state_23845__$1;
(statearr_23908_23969[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (37))){
var inst_23788 = (state_23845[(2)]);
var inst_23789 = fluree.db.util.async.throw_err.call(null,inst_23788);
var state_23845__$1 = state_23845;
var statearr_23909_23970 = state_23845__$1;
(statearr_23909_23970[(2)] = inst_23789);

(statearr_23909_23970[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (8))){
var inst_23840 = (state_23845[(2)]);
var _ = (function (){var statearr_23910 = state_23845;
(statearr_23910[(4)] = cljs.core.rest.call(null,(state_23845[(4)])));

return statearr_23910;
})();
var state_23845__$1 = state_23845;
var statearr_23911_23971 = state_23845__$1;
(statearr_23911_23971[(2)] = inst_23840);

(statearr_23911_23971[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2468__auto__ = null;
var fluree$db$query$fql$state_machine__2468__auto____0 = (function (){
var statearr_23912 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23912[(0)] = fluree$db$query$fql$state_machine__2468__auto__);

(statearr_23912[(1)] = (1));

return statearr_23912;
});
var fluree$db$query$fql$state_machine__2468__auto____1 = (function (state_23845){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_23845);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e23913){var ex__2471__auto__ = e23913;
var statearr_23914_23972 = state_23845;
(statearr_23914_23972[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_23845[(4)]))){
var statearr_23915_23973 = state_23845;
(statearr_23915_23973[(1)] = cljs.core.first.call(null,(state_23845[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23974 = state_23845;
state_23845 = G__23974;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2468__auto__ = function(state_23845){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2468__auto____1.call(this,state_23845);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2468__auto____0;
fluree$db$query$fql$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2468__auto____1;
return fluree$db$query$fql$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_23916 = f__2491__auto__.call(null);
(statearr_23916[(6)] = c__2490__auto__);

return statearr_23916;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 3);

/**
 * Order By can be:
 *  - Single variable, ?favNums
 *  - Two-tuple,  [ASC, ?favNums]
 */
fluree.db.query.fql.order_offset_and_limit_results = (function fluree$db$query$fql$order_offset_and_limit_results(orderBy,p__23976,offset,limit){
var map__23977 = p__23976;
var map__23977__$1 = (((((!((map__23977 == null))))?(((((map__23977.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23977.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23977):map__23977);
var res = map__23977__$1;
var headers = cljs.core.get.call(null,map__23977__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__23977__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__23979 = orderBy;
var order = cljs.core.nth.call(null,vec__23979,(0),null);
var var$ = cljs.core.nth.call(null,vec__23979,(1),null);
var indexOfFind = (function (){var or__4126__auto__ = fluree.db.util.core.index_of.call(null,headers,cljs.core.symbol.call(null,var$));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (-1);
}
})();
var tuples__$1 = ((((0) <= indexOfFind))?(function (){var G__23982 = cljs.core.sort_by.call(null,(function (p1__23975_SHARP_){
return cljs.core.nth.call(null,p1__23975_SHARP_,indexOfFind);
}),fluree.db.query.fql.compare_fn,tuples);
var G__23982__$1 = ((cljs.core._EQ_.call(null,"DESC",order))?cljs.core.reverse.call(null,G__23982):G__23982);
var G__23982__$2 = (cljs.core.truth_(offset)?cljs.core.drop.call(null,offset,G__23982__$1):G__23982__$1);
if(cljs.core.truth_(limit)){
return cljs.core.take.call(null,limit,G__23982__$2);
} else {
return G__23982__$2;
}
})():tuples);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$1], null);
});
fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,cljs.core.keys.call(null,x))))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var var_as_symbol = cljs.core.symbol.call(null,cljs.core.first.call(null,cljs.core.keys.call(null,x)));
var ___$1 = (cljs.core.truth_(valid_var.call(null,var_as_symbol))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_as_symbol,new cljs.core.Keyword(null,"selection","selection",975998651),cljs.core.first.call(null,cljs.core.vals.call(null,x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__4126__auto__ = cljs.core.every_QMARK_.call(null,(function (p1__23983_SHARP_){
return ((typeof p1__23983_SHARP_ === 'string') || (cljs.core.map_QMARK_.call(null,p1__23983_SHARP_)));
}),select_smt);
if(or__4126__auto__){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vars__$1 = cljs.core.set.call(null,vars);
var all_vars = cljs.core.set.call(null,cljs.core.concat.call(null,vars__$1,cljs.core.keys.call(null,interim_vars)));
return cljs.core.map.call(null,(function (select){
var var_symbol = ((cljs.core.map_QMARK_.call(null,select))?null:cljs.core.symbol.call(null,select));
if(cljs.core.truth_(vars__$1.call(null,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_.call(null,select))){
return fluree.db.query.analytical.parse_aggregate.call(null,select,vars__$1);
} else {
if(cljs.core.map_QMARK_.call(null,select)){
return fluree.db.query.fql.parse_map.call(null,select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.call(null,interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.get.call(null,interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.call(null,["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.call(null,(function (select__$1){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies.call(null,vars);
if(cljs.core.every_QMARK_.call(null,(function (p1__23984_SHARP_){
return cljs.core._EQ_.call(null,(1),p1__23984_SHARP_);
}),cljs.core.vals.call(null,freqs))){
return vars;
} else {
var G__23988 = vars;
var vec__23989 = G__23988;
var seq__23990 = cljs.core.seq.call(null,vec__23989);
var first__23991 = cljs.core.first.call(null,seq__23990);
var seq__23990__$1 = cljs.core.next.call(null,seq__23990);
var var$ = first__23991;
var r = seq__23990__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__23988__$1 = G__23988;
var all_vars__$1 = all_vars;
while(true){
var vec__23995 = G__23988__$1;
var seq__23996 = cljs.core.seq.call(null,vec__23995);
var first__23997 = cljs.core.first.call(null,seq__23996);
var seq__23996__$1 = cljs.core.next.call(null,seq__23996);
var var$__$1 = first__23997;
var r__$1 = seq__23996__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not.call(null,var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_(cljs.core.set.call(null,all_vars__$2).call(null,var$__$1))){
var G__23998 = r__$1;
var G__23999 = cljs.core.conj.call(null,all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,all_vars__$2))].join(''));
G__23988__$1 = G__23998;
all_vars__$1 = G__23999;
continue;
} else {
var G__24000 = r__$1;
var G__24001 = cljs.core.conj.call(null,all_vars__$2,var$__$1);
G__23988__$1 = G__24000;
all_vars__$1 = G__24001;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_24036){
var state_val_24037 = (state_24036[(1)]);
if((state_val_24037 === (1))){
var inst_24009 = functionArray;
var inst_24010 = cljs.core.seq.call(null,inst_24009);
var inst_24011 = cljs.core.first.call(null,inst_24010);
var inst_24012 = cljs.core.next.call(null,inst_24010);
var inst_24013 = cljs.core.PersistentVector.EMPTY;
var inst_24014 = inst_24009;
var inst_24015 = inst_24013;
var state_24036__$1 = (function (){var statearr_24038 = state_24036;
(statearr_24038[(7)] = inst_24012);

(statearr_24038[(8)] = inst_24014);

(statearr_24038[(9)] = inst_24011);

(statearr_24038[(10)] = inst_24015);

return statearr_24038;
})();
var statearr_24039_24052 = state_24036__$1;
(statearr_24039_24052[(2)] = null);

(statearr_24039_24052[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24037 === (2))){
var inst_24021 = (state_24036[(11)]);
var inst_24014 = (state_24036[(8)]);
var inst_24020 = cljs.core.seq.call(null,inst_24014);
var inst_24021__$1 = cljs.core.first.call(null,inst_24020);
var inst_24022 = cljs.core.next.call(null,inst_24020);
var state_24036__$1 = (function (){var statearr_24040 = state_24036;
(statearr_24040[(11)] = inst_24021__$1);

(statearr_24040[(12)] = inst_24022);

return statearr_24040;
})();
if(cljs.core.truth_(inst_24021__$1)){
var statearr_24041_24053 = state_24036__$1;
(statearr_24041_24053[(1)] = (4));

} else {
var statearr_24042_24054 = state_24036__$1;
(statearr_24042_24054[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24037 === (3))){
var inst_24034 = (state_24036[(2)]);
var state_24036__$1 = state_24036;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24036__$1,inst_24034);
} else {
if((state_val_24037 === (4))){
var inst_24021 = (state_24036[(11)]);
var inst_24024 = inst_24021.call(null,tuple);
var state_24036__$1 = state_24036;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24036__$1,(7),inst_24024);
} else {
if((state_val_24037 === (5))){
var inst_24015 = (state_24036[(10)]);
var state_24036__$1 = state_24036;
var statearr_24043_24055 = state_24036__$1;
(statearr_24043_24055[(2)] = inst_24015);

(statearr_24043_24055[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24037 === (6))){
var inst_24032 = (state_24036[(2)]);
var state_24036__$1 = state_24036;
var statearr_24044_24056 = state_24036__$1;
(statearr_24044_24056[(2)] = inst_24032);

(statearr_24044_24056[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24037 === (7))){
var inst_24022 = (state_24036[(12)]);
var inst_24015 = (state_24036[(10)]);
var inst_24026 = (state_24036[(2)]);
var inst_24027 = fluree.db.util.async.throw_err.call(null,inst_24026);
var inst_24028 = cljs.core.conj.call(null,inst_24015,inst_24027);
var inst_24014 = inst_24022;
var inst_24015__$1 = inst_24028;
var state_24036__$1 = (function (){var statearr_24045 = state_24036;
(statearr_24045[(8)] = inst_24014);

(statearr_24045[(10)] = inst_24015__$1);

return statearr_24045;
})();
var statearr_24046_24057 = state_24036__$1;
(statearr_24046_24057[(2)] = null);

(statearr_24046_24057[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__2468__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__2468__auto____0 = (function (){
var statearr_24047 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24047[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__2468__auto__);

(statearr_24047[(1)] = (1));

return statearr_24047;
});
var fluree$db$query$fql$format_tuple_$_state_machine__2468__auto____1 = (function (state_24036){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_24036);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e24048){var ex__2471__auto__ = e24048;
var statearr_24049_24058 = state_24036;
(statearr_24049_24058[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_24036[(4)]))){
var statearr_24050_24059 = state_24036;
(statearr_24050_24059[(1)] = cljs.core.first.call(null,(state_24036[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24060 = state_24036;
state_24036 = G__24060;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__2468__auto__ = function(state_24036){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__2468__auto____1.call(this,state_24036);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__2468__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__2468__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_24051 = f__2491__auto__.call(null);
(statearr_24051[(6)] = c__2490__auto__);

return statearr_24051;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,headers,new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,cljs.core.map.call(null,cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,headers,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
fluree.db.query.fql.format_filter_tuples = (function fluree$db$query$fql$format_filter_tuples(db,tuples,p__24062,headers,vars,opts){
var map__24063 = p__24062;
var map__24063__$1 = (((((!((map__24063 == null))))?(((((map__24063.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24063.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24063):map__24063);
var select_spec = map__24063__$1;
var prettyPrint = cljs.core.get.call(null,map__24063__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var select = cljs.core.get.call(null,map__24063__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var inVector_QMARK_ = cljs.core.get.call(null,map__24063__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var expandMaps_QMARK_ = cljs.core.get.call(null,map__24063__$1,new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444));
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_24150){
var state_val_24151 = (state_24150[(1)]);
if((state_val_24151 === (7))){
var state_24150__$1 = state_24150;
var statearr_24152_24292 = state_24150__$1;
(statearr_24152_24292[(2)] = null);

(statearr_24152_24292[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24151 === (1))){
var state_24150__$1 = state_24150;
var statearr_24153_24293 = state_24150__$1;
(statearr_24153_24293[(2)] = null);

(statearr_24153_24293[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24151 === (4))){
var inst_24065 = (state_24150[(2)]);
var state_24150__$1 = state_24150;
var statearr_24154_24294 = state_24150__$1;
(statearr_24154_24294[(2)] = inst_24065);

(statearr_24154_24294[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24151 === (15))){
var inst_24139 = (state_24150[(2)]);
var inst_24140 = fluree.db.util.async.throw_err.call(null,inst_24139);
var state_24150__$1 = state_24150;
var statearr_24155_24295 = state_24150__$1;
(statearr_24155_24295[(2)] = inst_24140);

(statearr_24155_24295[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24151 === (13))){
var inst_24083 = (state_24150[(7)]);
var inst_24075 = (state_24150[(8)]);
var inst_24142 = (function (){var pp = inst_24075;
var functionArray = inst_24083;
return (function (tuple){
var tuple_res = cljs.core.map.call(null,(function (p1__24061_SHARP_){
return p1__24061_SHARP_.call(null,tuple);
}),functionArray);
if(cljs.core.truth_(pp)){
return cljs.core.zipmap.call(null,pp,tuple_res);
} else {
if(cljs.core.truth_(inVector_QMARK_)){
return tuple_res;
} else {
return cljs.core.first.call(null,tuple_res);

}
}
});
})();
var inst_24143 = cljs.core.map.call(null,inst_24142,tuples);
var state_24150__$1 = state_24150;
var statearr_24156_24296 = state_24150__$1;
(statearr_24156_24296[(2)] = inst_24143);

(statearr_24156_24296[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24151 === (6))){
var inst_24072 = fluree.db.query.fql.get_pretty_print_keys.call(null,select);
var state_24150__$1 = state_24150;
var statearr_24157_24297 = state_24150__$1;
(statearr_24157_24297[(2)] = inst_24072);

(statearr_24157_24297[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24151 === (3))){
var inst_24148 = (state_24150[(2)]);
var state_24150__$1 = state_24150;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24150__$1,inst_24148);
} else {
if((state_val_24151 === (12))){
var inst_24083 = (state_24150[(7)]);
var inst_24075 = (state_24150[(8)]);
var inst_24135 = cljs.core.async.chan.call(null,(1));
var inst_24136 = (function (){var pp = inst_24075;
var functionArray = inst_24083;
var c__2490__auto____$1 = inst_24135;
return (function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_24133){
var state_val_24134 = (state_24133[(1)]);
if((state_val_24134 === (7))){
var inst_24109 = (state_24133[(2)]);
var inst_24110 = fluree.db.util.async.throw_err.call(null,inst_24109);
var state_24133__$1 = (function (){var statearr_24158 = state_24133;
(statearr_24158[(7)] = inst_24110);

return statearr_24158;
})();
if(cljs.core.truth_(pp)){
var statearr_24159_24298 = state_24133__$1;
(statearr_24159_24298[(1)] = (8));

} else {
var statearr_24160_24299 = state_24133__$1;
(statearr_24160_24299[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24134 === (1))){
var inst_24092 = tuples;
var inst_24093 = cljs.core.seq.call(null,inst_24092);
var inst_24094 = cljs.core.first.call(null,inst_24093);
var inst_24095 = cljs.core.next.call(null,inst_24093);
var inst_24096 = cljs.core.PersistentVector.EMPTY;
var inst_24097 = inst_24092;
var inst_24098 = inst_24096;
var state_24133__$1 = (function (){var statearr_24161 = state_24133;
(statearr_24161[(8)] = inst_24095);

(statearr_24161[(9)] = inst_24094);

(statearr_24161[(10)] = inst_24097);

(statearr_24161[(11)] = inst_24098);

return statearr_24161;
})();
var statearr_24162_24300 = state_24133__$1;
(statearr_24162_24300[(2)] = null);

(statearr_24162_24300[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24134 === (4))){
var inst_24104 = (state_24133[(12)]);
var inst_24107 = fluree.db.query.fql.format_tuple.call(null,functionArray,inst_24104);
var state_24133__$1 = state_24133;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24133__$1,(7),inst_24107);
} else {
if((state_val_24134 === (15))){
var state_24133__$1 = state_24133;
var statearr_24163_24301 = state_24133__$1;
(statearr_24163_24301[(2)] = null);

(statearr_24163_24301[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24134 === (13))){
var inst_24122 = (state_24133[(2)]);
var state_24133__$1 = state_24133;
var statearr_24164_24302 = state_24133__$1;
(statearr_24164_24302[(2)] = inst_24122);

(statearr_24164_24302[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24134 === (6))){
var inst_24129 = (state_24133[(2)]);
var state_24133__$1 = state_24133;
var statearr_24165_24303 = state_24133__$1;
(statearr_24165_24303[(2)] = inst_24129);

(statearr_24165_24303[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24134 === (3))){
var inst_24131 = (state_24133[(2)]);
var state_24133__$1 = state_24133;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24133__$1,inst_24131);
} else {
if((state_val_24134 === (12))){
var state_24133__$1 = state_24133;
var statearr_24166_24304 = state_24133__$1;
(statearr_24166_24304[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24134 === (2))){
var inst_24097 = (state_24133[(10)]);
var inst_24104 = (state_24133[(12)]);
var inst_24103 = cljs.core.seq.call(null,inst_24097);
var inst_24104__$1 = cljs.core.first.call(null,inst_24103);
var inst_24105 = cljs.core.next.call(null,inst_24103);
var state_24133__$1 = (function (){var statearr_24168 = state_24133;
(statearr_24168[(13)] = inst_24105);

(statearr_24168[(12)] = inst_24104__$1);

return statearr_24168;
})();
if(cljs.core.truth_(inst_24104__$1)){
var statearr_24169_24305 = state_24133__$1;
(statearr_24169_24305[(1)] = (4));

} else {
var statearr_24170_24306 = state_24133__$1;
(statearr_24170_24306[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24134 === (11))){
var inst_24110 = (state_24133[(7)]);
var state_24133__$1 = state_24133;
var statearr_24171_24307 = state_24133__$1;
(statearr_24171_24307[(2)] = inst_24110);

(statearr_24171_24307[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24134 === (9))){
var state_24133__$1 = state_24133;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_24172_24308 = state_24133__$1;
(statearr_24172_24308[(1)] = (11));

} else {
var statearr_24173_24309 = state_24133__$1;
(statearr_24173_24309[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24134 === (5))){
var inst_24098 = (state_24133[(11)]);
var state_24133__$1 = state_24133;
var statearr_24174_24310 = state_24133__$1;
(statearr_24174_24310[(2)] = inst_24098);

(statearr_24174_24310[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24134 === (14))){
var inst_24110 = (state_24133[(7)]);
var inst_24117 = cljs.core.first.call(null,inst_24110);
var state_24133__$1 = state_24133;
var statearr_24175_24311 = state_24133__$1;
(statearr_24175_24311[(2)] = inst_24117);

(statearr_24175_24311[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24134 === (16))){
var inst_24120 = (state_24133[(2)]);
var state_24133__$1 = state_24133;
var statearr_24176_24312 = state_24133__$1;
(statearr_24176_24312[(2)] = inst_24120);

(statearr_24176_24312[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24134 === (10))){
var inst_24105 = (state_24133[(13)]);
var inst_24098 = (state_24133[(11)]);
var inst_24124 = (state_24133[(2)]);
var inst_24125 = cljs.core.conj.call(null,inst_24098,inst_24124);
var inst_24097 = inst_24105;
var inst_24098__$1 = inst_24125;
var state_24133__$1 = (function (){var statearr_24177 = state_24133;
(statearr_24177[(10)] = inst_24097);

(statearr_24177[(11)] = inst_24098__$1);

return statearr_24177;
})();
var statearr_24178_24313 = state_24133__$1;
(statearr_24178_24313[(2)] = null);

(statearr_24178_24313[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24134 === (8))){
var inst_24110 = (state_24133[(7)]);
var inst_24112 = cljs.core.zipmap.call(null,pp,inst_24110);
var state_24133__$1 = state_24133;
var statearr_24179_24314 = state_24133__$1;
(statearr_24179_24314[(2)] = inst_24112);

(statearr_24179_24314[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto____0 = (function (){
var statearr_24180 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24180[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto__);

(statearr_24180[(1)] = (1));

return statearr_24180;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto____1 = (function (state_24133){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_24133);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e24181){var ex__2471__auto__ = e24181;
var statearr_24182_24315 = state_24133;
(statearr_24182_24315[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_24133[(4)]))){
var statearr_24183_24316 = state_24133;
(statearr_24183_24316[(1)] = cljs.core.first.call(null,(state_24133[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24317 = state_24133;
state_24133 = G__24317;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto__ = function(state_24133){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto____1.call(this,state_24133);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_24184 = f__2491__auto__.call(null);
(statearr_24184[(6)] = c__2490__auto____$1);

return statearr_24184;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
});
})();
var inst_24137 = cljs.core.async.impl.dispatch.run.call(null,inst_24136);
var state_24150__$1 = (function (){var statearr_24185 = state_24150;
(statearr_24185[(9)] = inst_24137);

return statearr_24185;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24150__$1,(15),inst_24135);
} else {
if((state_val_24151 === (2))){
var _ = (function (){var statearr_24186 = state_24150;
(statearr_24186[(4)] = cljs.core.cons.call(null,(5),(state_24150[(4)])));

return statearr_24186;
})();
var state_24150__$1 = state_24150;
if(cljs.core.truth_(prettyPrint)){
var statearr_24187_24318 = state_24150__$1;
(statearr_24187_24318[(1)] = (6));

} else {
var statearr_24188_24319 = state_24150__$1;
(statearr_24188_24319[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24151 === (11))){
var inst_24083 = (state_24150[(2)]);
var state_24150__$1 = (function (){var statearr_24190 = state_24150;
(statearr_24190[(7)] = inst_24083);

return statearr_24190;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_24191_24320 = state_24150__$1;
(statearr_24191_24320[(1)] = (12));

} else {
var statearr_24192_24321 = state_24150__$1;
(statearr_24192_24321[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24151 === (9))){
var inst_24075 = (state_24150[(8)]);
var inst_24077 = (function (){var pp = inst_24075;
return (function (select__$1){
var select_val = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1);
}
})();
var idx = (cljs.core.truth_(select_val)?fluree.db.util.core.index_of.call(null,headers,select_val):null);
var select_fn = (cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.call(null,tuple,idx);
}):(cljs.core.truth_(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(select__$1))?(function (tuple){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(select__$1);
}):(cljs.core.truth_(cljs.core.get.call(null,vars,select_val))?(function (tuple){
return cljs.core.get.call(null,vars,select_val);
}):null)));
if(cljs.core.truth_(new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select__$1))){
return (function (tuple){
var c__2490__auto____$1 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_24225){
var state_val_24226 = (state_24225[(1)]);
if((state_val_24226 === (7))){
var state_24225__$1 = state_24225;
var statearr_24227_24322 = state_24225__$1;
(statearr_24227_24322[(2)] = null);

(statearr_24227_24322[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24226 === (1))){
var state_24225__$1 = state_24225;
var statearr_24228_24323 = state_24225__$1;
(statearr_24228_24323[(2)] = null);

(statearr_24228_24323[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24226 === (4))){
var inst_24193 = (state_24225[(2)]);
var state_24225__$1 = state_24225;
var statearr_24229_24324 = state_24225__$1;
(statearr_24229_24324[(2)] = inst_24193);

(statearr_24229_24324[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24226 === (6))){
var inst_24201 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_24202 = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select__$1);
var inst_24203 = select_fn.call(null,tuple);
var inst_24204 = [inst_24202,inst_24203,opts];
var inst_24205 = cljs.core.PersistentHashMap.fromArrays(inst_24201,inst_24204);
var inst_24206 = fluree.db.query.fql.query.call(null,db,inst_24205);
var state_24225__$1 = state_24225;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24225__$1,(9),inst_24206);
} else {
if((state_val_24226 === (3))){
var inst_24223 = (state_24225[(2)]);
var state_24225__$1 = state_24225;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24225__$1,inst_24223);
} else {
if((state_val_24226 === (12))){
var inst_24217 = (state_24225[(2)]);
var state_24225__$1 = state_24225;
var statearr_24230_24325 = state_24225__$1;
(statearr_24230_24325[(2)] = inst_24217);

(statearr_24230_24325[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24226 === (2))){
var _ = (function (){var statearr_24231 = state_24225;
(statearr_24231[(4)] = cljs.core.cons.call(null,(5),(state_24225[(4)])));

return statearr_24231;
})();
var inst_24199 = select_fn.call(null,tuple);
var state_24225__$1 = state_24225;
if(cljs.core.truth_(inst_24199)){
var statearr_24232_24326 = state_24225__$1;
(statearr_24232_24326[(1)] = (6));

} else {
var statearr_24233_24327 = state_24225__$1;
(statearr_24233_24327[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24226 === (11))){
var inst_24212 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_24213 = select_fn.call(null,tuple);
var inst_24214 = [inst_24213];
var inst_24215 = cljs.core.PersistentHashMap.fromArrays(inst_24212,inst_24214);
var state_24225__$1 = state_24225;
var statearr_24235_24328 = state_24225__$1;
(statearr_24235_24328[(2)] = inst_24215);

(statearr_24235_24328[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24226 === (9))){
var inst_24209 = (state_24225[(7)]);
var inst_24208 = (state_24225[(2)]);
var inst_24209__$1 = fluree.db.util.async.throw_err.call(null,inst_24208);
var state_24225__$1 = (function (){var statearr_24236 = state_24225;
(statearr_24236[(7)] = inst_24209__$1);

return statearr_24236;
})();
if(cljs.core.truth_(inst_24209__$1)){
var statearr_24237_24329 = state_24225__$1;
(statearr_24237_24329[(1)] = (10));

} else {
var statearr_24238_24330 = state_24225__$1;
(statearr_24238_24330[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24226 === (5))){
var _ = (function (){var statearr_24239 = state_24225;
(statearr_24239[(4)] = cljs.core.rest.call(null,(state_24225[(4)])));

return statearr_24239;
})();
var state_24225__$1 = state_24225;
var ex24234 = (state_24225__$1[(2)]);
var statearr_24240_24331 = state_24225__$1;
(statearr_24240_24331[(5)] = ex24234);


if((ex24234 instanceof Error)){
var statearr_24241_24332 = state_24225__$1;
(statearr_24241_24332[(1)] = (4));

(statearr_24241_24332[(5)] = null);

} else {
throw ex24234;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24226 === (10))){
var inst_24209 = (state_24225[(7)]);
var state_24225__$1 = state_24225;
var statearr_24242_24333 = state_24225__$1;
(statearr_24242_24333[(2)] = inst_24209);

(statearr_24242_24333[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24226 === (8))){
var inst_24220 = (state_24225[(2)]);
var _ = (function (){var statearr_24243 = state_24225;
(statearr_24243[(4)] = cljs.core.rest.call(null,(state_24225[(4)])));

return statearr_24243;
})();
var state_24225__$1 = state_24225;
var statearr_24244_24334 = state_24225__$1;
(statearr_24244_24334[(2)] = inst_24220);

(statearr_24244_24334[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto____0 = (function (){
var statearr_24245 = [null,null,null,null,null,null,null,null];
(statearr_24245[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto__);

(statearr_24245[(1)] = (1));

return statearr_24245;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto____1 = (function (state_24225){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_24225);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e24246){var ex__2471__auto__ = e24246;
var statearr_24247_24335 = state_24225;
(statearr_24247_24335[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_24225[(4)]))){
var statearr_24248_24336 = state_24225;
(statearr_24248_24336[(1)] = cljs.core.first.call(null,(state_24225[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24337 = state_24225;
state_24225 = G__24337;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto__ = function(state_24225){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto____1.call(this,state_24225);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_24249 = f__2491__auto__.call(null);
(statearr_24249[(6)] = c__2490__auto____$1);

return statearr_24249;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto____$1;
});
} else {
return (function (tuple){
var c__2490__auto____$1 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_24261){
var state_val_24262 = (state_24261[(1)]);
if((state_val_24262 === (1))){
var state_24261__$1 = state_24261;
var statearr_24263_24338 = state_24261__$1;
(statearr_24263_24338[(2)] = null);

(statearr_24263_24338[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24262 === (2))){
var _ = (function (){var statearr_24264 = state_24261;
(statearr_24264[(4)] = cljs.core.cons.call(null,(5),(state_24261[(4)])));

return statearr_24264;
})();
var inst_24256 = select_fn.call(null,tuple);
var ___$1 = (function (){var statearr_24265 = state_24261;
(statearr_24265[(4)] = cljs.core.rest.call(null,(state_24261[(4)])));

return statearr_24265;
})();
var state_24261__$1 = state_24261;
var statearr_24266_24339 = state_24261__$1;
(statearr_24266_24339[(2)] = inst_24256);

(statearr_24266_24339[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24262 === (3))){
var inst_24259 = (state_24261[(2)]);
var state_24261__$1 = state_24261;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24261__$1,inst_24259);
} else {
if((state_val_24262 === (4))){
var inst_24250 = (state_24261[(2)]);
var state_24261__$1 = state_24261;
var statearr_24268_24340 = state_24261__$1;
(statearr_24268_24340[(2)] = inst_24250);

(statearr_24268_24340[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24262 === (5))){
var _ = (function (){var statearr_24269 = state_24261;
(statearr_24269[(4)] = cljs.core.rest.call(null,(state_24261[(4)])));

return statearr_24269;
})();
var state_24261__$1 = state_24261;
var ex24267 = (state_24261__$1[(2)]);
var statearr_24270_24341 = state_24261__$1;
(statearr_24270_24341[(5)] = ex24267);


if((ex24267 instanceof Error)){
var statearr_24271_24342 = state_24261__$1;
(statearr_24271_24342[(1)] = (4));

(statearr_24271_24342[(5)] = null);

} else {
throw ex24267;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto____0 = (function (){
var statearr_24272 = [null,null,null,null,null,null,null];
(statearr_24272[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto__);

(statearr_24272[(1)] = (1));

return statearr_24272;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto____1 = (function (state_24261){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_24261);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e24273){var ex__2471__auto__ = e24273;
var statearr_24274_24343 = state_24261;
(statearr_24274_24343[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_24261[(4)]))){
var statearr_24275_24344 = state_24261;
(statearr_24275_24344[(1)] = cljs.core.first.call(null,(state_24261[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24345 = state_24261;
state_24261 = G__24345;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto__ = function(state_24261){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto____1.call(this,state_24261);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_24276 = f__2491__auto__.call(null);
(statearr_24276[(6)] = c__2490__auto____$1);

return statearr_24276;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto____$1;
});
}
});
})();
var inst_24078 = cljs.core.map.call(null,inst_24077,select);
var state_24150__$1 = state_24150;
var statearr_24277_24346 = state_24150__$1;
(statearr_24277_24346[(2)] = inst_24078);

(statearr_24277_24346[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24151 === (5))){
var _ = (function (){var statearr_24278 = state_24150;
(statearr_24278[(4)] = cljs.core.rest.call(null,(state_24150[(4)])));

return statearr_24278;
})();
var state_24150__$1 = state_24150;
var ex24189 = (state_24150__$1[(2)]);
var statearr_24279_24347 = state_24150__$1;
(statearr_24279_24347[(5)] = ex24189);


if((ex24189 instanceof Error)){
var statearr_24280_24348 = state_24150__$1;
(statearr_24280_24348[(1)] = (4));

(statearr_24280_24348[(5)] = null);

} else {
throw ex24189;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24151 === (14))){
var inst_24145 = (state_24150[(2)]);
var _ = (function (){var statearr_24281 = state_24150;
(statearr_24281[(4)] = cljs.core.rest.call(null,(state_24150[(4)])));

return statearr_24281;
})();
var state_24150__$1 = state_24150;
var statearr_24282_24349 = state_24150__$1;
(statearr_24282_24349[(2)] = inst_24145);

(statearr_24282_24349[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24151 === (10))){
var inst_24075 = (state_24150[(8)]);
var inst_24080 = (function (){var pp = inst_24075;
return (function (select__$1){
var temp__5733__auto__ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(select__$1);
if(cljs.core.truth_(temp__5733__auto__)){
var val = temp__5733__auto__;
return (function (x){
return val;
});
} else {
var idx = fluree.db.query.fql.get_header_idx.call(null,headers,select__$1);
return (function (tuple){
return cljs.core.nth.call(null,tuple,idx);
});
}
});
})();
var inst_24081 = cljs.core.map.call(null,inst_24080,select);
var state_24150__$1 = state_24150;
var statearr_24283_24350 = state_24150__$1;
(statearr_24283_24350[(2)] = inst_24081);

(statearr_24283_24350[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24151 === (8))){
var inst_24075 = (state_24150[(2)]);
var state_24150__$1 = (function (){var statearr_24284 = state_24150;
(statearr_24284[(8)] = inst_24075);

return statearr_24284;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_24285_24351 = state_24150__$1;
(statearr_24285_24351[(1)] = (9));

} else {
var statearr_24286_24352 = state_24150__$1;
(statearr_24286_24352[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto____0 = (function (){
var statearr_24287 = [null,null,null,null,null,null,null,null,null,null];
(statearr_24287[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto__);

(statearr_24287[(1)] = (1));

return statearr_24287;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto____1 = (function (state_24150){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_24150);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e24288){var ex__2471__auto__ = e24288;
var statearr_24289_24353 = state_24150;
(statearr_24289_24353[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_24150[(4)]))){
var statearr_24290_24354 = state_24150;
(statearr_24290_24354[(1)] = cljs.core.first.call(null,(state_24150[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24355 = state_24150;
state_24150 = G__24355;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto__ = function(state_24150){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto____1.call(this,state_24150);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_24291 = f__2491__auto__.call(null);
(statearr_24291[(6)] = c__2490__auto__);

return statearr_24291;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__24357 = arguments.length;
switch (G__24357) {
case 4:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4 = (function (db,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.call(null,db,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5 = (function (db,p__24358,p__24359,group_limit,opts){
var map__24360 = p__24358;
var map__24360__$1 = (((((!((map__24360 == null))))?(((((map__24360.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24360.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24360):map__24360);
var res = map__24360__$1;
var vars = cljs.core.get.call(null,map__24360__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__24361 = p__24359;
var map__24361__$1 = (((((!((map__24361 == null))))?(((((map__24361.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24361.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24361):map__24361);
var select_spec = map__24361__$1;
var inVector_QMARK_ = cljs.core.get.call(null,map__24361__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var select = cljs.core.get.call(null,map__24361__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.call(null,map__24361__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.call(null,map__24361__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__24361__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var aggregates = cljs.core.get.call(null,map__24361__$1,new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289));
var prettyPrint = cljs.core.get.call(null,map__24361__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectDistinct_QMARK_ = cljs.core.get.call(null,map__24361__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var groupBy = cljs.core.get.call(null,map__24361__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_24472){
var state_val_24473 = (state_24472[(1)]);
if((state_val_24473 === (7))){
var inst_24370 = (state_24472[(7)]);
var state_24472__$1 = state_24472;
var statearr_24474_24554 = state_24472__$1;
(statearr_24474_24554[(2)] = inst_24370);

(statearr_24474_24554[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (20))){
var inst_24405 = (state_24472[(2)]);
var state_24472__$1 = (function (){var statearr_24475 = state_24472;
(statearr_24475[(8)] = inst_24405);

return statearr_24475;
})();
if(cljs.core.truth_(groupBy)){
var statearr_24476_24555 = state_24472__$1;
(statearr_24476_24555[(1)] = (21));

} else {
var statearr_24477_24556 = state_24472__$1;
(statearr_24477_24556[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (27))){
var inst_24414 = (state_24472[(9)]);
var inst_24419 = inst_24414.cljs$lang$protocol_mask$partition0$;
var inst_24420 = (inst_24419 & (64));
var inst_24421 = inst_24414.cljs$core$ISeq$;
var inst_24422 = (cljs.core.PROTOCOL_SENTINEL === inst_24421);
var inst_24423 = ((inst_24420) || (inst_24422));
var state_24472__$1 = state_24472;
if(cljs.core.truth_(inst_24423)){
var statearr_24478_24557 = state_24472__$1;
(statearr_24478_24557[(1)] = (30));

} else {
var statearr_24479_24558 = state_24472__$1;
(statearr_24479_24558[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (1))){
var state_24472__$1 = state_24472;
var statearr_24480_24559 = state_24472__$1;
(statearr_24480_24559[(2)] = null);

(statearr_24480_24559[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (24))){
var inst_24409 = (state_24472[(10)]);
var inst_24405 = (state_24472[(8)]);
var inst_24411 = fluree.db.query.fql.order_offset_and_limit_results.call(null,orderBy,inst_24405,inst_24409,group_limit);
var state_24472__$1 = state_24472;
var statearr_24481_24560 = state_24472__$1;
(statearr_24481_24560[(2)] = inst_24411);

(statearr_24481_24560[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (39))){
var inst_24440 = (state_24472[(11)]);
var state_24472__$1 = state_24472;
var statearr_24482_24561 = state_24472__$1;
(statearr_24482_24561[(2)] = inst_24440);

(statearr_24482_24561[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (46))){
var inst_24457 = (state_24472[(12)]);
var inst_24459 = cljs.core.PersistentVector.EMPTY;
var inst_24460 = cljs.core.PersistentHashSet.EMPTY;
var inst_24461 = cljs.core.into.call(null,inst_24460,inst_24457);
var inst_24462 = cljs.core.into.call(null,inst_24459,inst_24461);
var state_24472__$1 = state_24472;
var statearr_24483_24562 = state_24472__$1;
(statearr_24483_24562[(2)] = inst_24462);

(statearr_24483_24562[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (4))){
var inst_24364 = (state_24472[(2)]);
var state_24472__$1 = state_24472;
var statearr_24484_24563 = state_24472__$1;
(statearr_24484_24563[(2)] = inst_24364);

(statearr_24484_24563[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (15))){
var inst_24391 = (state_24472[(13)]);
var inst_24393 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24394 = [inst_24391];
var inst_24395 = (new cljs.core.PersistentVector(null,1,(5),inst_24393,inst_24394,null));
var state_24472__$1 = state_24472;
var statearr_24485_24564 = state_24472__$1;
(statearr_24485_24564[(2)] = inst_24395);

(statearr_24485_24564[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (48))){
var inst_24465 = (state_24472[(2)]);
var state_24472__$1 = state_24472;
var statearr_24486_24565 = state_24472__$1;
(statearr_24486_24565[(2)] = inst_24465);

(statearr_24486_24565[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (21))){
var state_24472__$1 = state_24472;
var statearr_24487_24566 = state_24472__$1;
(statearr_24487_24566[(2)] = (0));

(statearr_24487_24566[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (31))){
var state_24472__$1 = state_24472;
var statearr_24488_24567 = state_24472__$1;
(statearr_24488_24567[(2)] = false);

(statearr_24488_24567[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (32))){
var inst_24427 = (state_24472[(2)]);
var state_24472__$1 = state_24472;
var statearr_24489_24568 = state_24472__$1;
(statearr_24489_24568[(2)] = inst_24427);

(statearr_24489_24568[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (40))){
var inst_24409 = (state_24472[(10)]);
var state_24472__$1 = state_24472;
var statearr_24490_24569 = state_24472__$1;
(statearr_24490_24569[(2)] = inst_24409);

(statearr_24490_24569[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (33))){
var inst_24414 = (state_24472[(9)]);
var inst_24432 = cljs.core.apply.call(null,cljs.core.hash_map,inst_24414);
var state_24472__$1 = state_24472;
var statearr_24491_24570 = state_24472__$1;
(statearr_24491_24570[(2)] = inst_24432);

(statearr_24491_24570[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (13))){
var inst_24380 = (state_24472[(14)]);
var state_24472__$1 = state_24472;
var statearr_24492_24571 = state_24472__$1;
(statearr_24492_24571[(2)] = inst_24380);

(statearr_24492_24571[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (22))){
var state_24472__$1 = state_24472;
var statearr_24493_24572 = state_24472__$1;
(statearr_24493_24572[(2)] = offset);

(statearr_24493_24572[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (36))){
var inst_24440 = (state_24472[(11)]);
var inst_24440__$1 = limit;
var state_24472__$1 = (function (){var statearr_24494 = state_24472;
(statearr_24494[(11)] = inst_24440__$1);

return statearr_24494;
})();
if(cljs.core.truth_(inst_24440__$1)){
var statearr_24495_24573 = state_24472__$1;
(statearr_24495_24573[(1)] = (39));

} else {
var statearr_24496_24574 = state_24472__$1;
(statearr_24496_24574[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (41))){
var inst_24444 = (state_24472[(2)]);
var state_24472__$1 = state_24472;
var statearr_24497_24575 = state_24472__$1;
(statearr_24497_24575[(2)] = inst_24444);

(statearr_24497_24575[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (43))){
var inst_24437 = (state_24472[(15)]);
var state_24472__$1 = state_24472;
var statearr_24498_24576 = state_24472__$1;
(statearr_24498_24576[(2)] = inst_24437);

(statearr_24498_24576[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (29))){
var inst_24430 = (state_24472[(2)]);
var state_24472__$1 = state_24472;
if(cljs.core.truth_(inst_24430)){
var statearr_24499_24577 = state_24472__$1;
(statearr_24499_24577[(1)] = (33));

} else {
var statearr_24500_24578 = state_24472__$1;
(statearr_24500_24578[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (44))){
var inst_24436 = (state_24472[(16)]);
var inst_24453 = (state_24472[(2)]);
var inst_24454 = fluree.db.query.fql.format_filter_tuples.call(null,db,inst_24453,select_spec,inst_24436,vars,opts);
var state_24472__$1 = state_24472;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24472__$1,(45),inst_24454);
} else {
if((state_val_24473 === (6))){
var inst_24372 = cljs.core.count.call(null,select);
var inst_24373 = cljs.core._EQ_.call(null,(1),inst_24372);
var state_24472__$1 = state_24472;
var statearr_24501_24579 = state_24472__$1;
(statearr_24501_24579[(2)] = inst_24373);

(statearr_24501_24579[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (28))){
var state_24472__$1 = state_24472;
var statearr_24502_24580 = state_24472__$1;
(statearr_24502_24580[(2)] = false);

(statearr_24502_24580[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (25))){
var inst_24405 = (state_24472[(8)]);
var state_24472__$1 = state_24472;
var statearr_24503_24581 = state_24472__$1;
(statearr_24503_24581[(2)] = inst_24405);

(statearr_24503_24581[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (34))){
var inst_24414 = (state_24472[(9)]);
var state_24472__$1 = state_24472;
var statearr_24504_24582 = state_24472__$1;
(statearr_24504_24582[(2)] = inst_24414);

(statearr_24504_24582[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (17))){
var inst_24398 = (state_24472[(2)]);
var state_24472__$1 = state_24472;
var statearr_24505_24583 = state_24472__$1;
(statearr_24505_24583[(2)] = inst_24398);

(statearr_24505_24583[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (3))){
var inst_24470 = (state_24472[(2)]);
var state_24472__$1 = state_24472;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24472__$1,inst_24470);
} else {
if((state_val_24473 === (12))){
var inst_24380 = (state_24472[(14)]);
var inst_24382 = cljs.core.first.call(null,select);
var inst_24383 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_24382);
var inst_24384 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_24383);
var inst_24385 = cljs.core.subs.call(null,inst_24384,(1));
var inst_24386 = [inst_24385];
var inst_24387 = [inst_24380];
var inst_24388 = cljs.core.PersistentHashMap.fromArrays(inst_24386,inst_24387);
var state_24472__$1 = state_24472;
var statearr_24506_24584 = state_24472__$1;
(statearr_24506_24584[(2)] = inst_24388);

(statearr_24506_24584[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (2))){
var inst_24370 = (state_24472[(7)]);
var _ = (function (){var statearr_24507 = state_24472;
(statearr_24507[(4)] = cljs.core.cons.call(null,(5),(state_24472[(4)])));

return statearr_24507;
})();
var inst_24370__$1 = aggregates;
var state_24472__$1 = (function (){var statearr_24508 = state_24472;
(statearr_24508[(7)] = inst_24370__$1);

return statearr_24508;
})();
if(cljs.core.truth_(inst_24370__$1)){
var statearr_24509_24585 = state_24472__$1;
(statearr_24509_24585[(1)] = (6));

} else {
var statearr_24510_24586 = state_24472__$1;
(statearr_24510_24586[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (23))){
var inst_24409 = (state_24472[(2)]);
var state_24472__$1 = (function (){var statearr_24511 = state_24472;
(statearr_24511[(10)] = inst_24409);

return statearr_24511;
})();
if(cljs.core.truth_(orderBy)){
var statearr_24512_24587 = state_24472__$1;
(statearr_24512_24587[(1)] = (24));

} else {
var statearr_24513_24588 = state_24472__$1;
(statearr_24513_24588[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (47))){
var inst_24457 = (state_24472[(12)]);
var state_24472__$1 = state_24472;
var statearr_24514_24589 = state_24472__$1;
(statearr_24514_24589[(2)] = inst_24457);

(statearr_24514_24589[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (35))){
var inst_24435 = (state_24472[(2)]);
var inst_24436 = cljs.core.get.call(null,inst_24435,new cljs.core.Keyword(null,"headers","headers",-835030129));
var inst_24437 = cljs.core.get.call(null,inst_24435,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var inst_24438 = cljs.core.not.call(null,orderBy);
var state_24472__$1 = (function (){var statearr_24515 = state_24472;
(statearr_24515[(15)] = inst_24437);

(statearr_24515[(16)] = inst_24436);

return statearr_24515;
})();
if(inst_24438){
var statearr_24516_24590 = state_24472__$1;
(statearr_24516_24590[(1)] = (36));

} else {
var statearr_24517_24591 = state_24472__$1;
(statearr_24517_24591[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (19))){
var state_24472__$1 = state_24472;
var statearr_24518_24592 = state_24472__$1;
(statearr_24518_24592[(2)] = res);

(statearr_24518_24592[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (11))){
var inst_24467 = (state_24472[(2)]);
var _ = (function (){var statearr_24520 = state_24472;
(statearr_24520[(4)] = cljs.core.rest.call(null,(state_24472[(4)])));

return statearr_24520;
})();
var state_24472__$1 = state_24472;
var statearr_24521_24593 = state_24472__$1;
(statearr_24521_24593[(2)] = inst_24467);

(statearr_24521_24593[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (9))){
var inst_24378 = cljs.core.first.call(null,aggregates);
var inst_24379 = fluree.db.query.analytical.calculate_aggregate.call(null,res,inst_24378);
var inst_24380 = cljs.core.second.call(null,inst_24379);
var state_24472__$1 = (function (){var statearr_24522 = state_24472;
(statearr_24522[(14)] = inst_24380);

return statearr_24522;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_24523_24594 = state_24472__$1;
(statearr_24523_24594[(1)] = (12));

} else {
var statearr_24524_24595 = state_24472__$1;
(statearr_24524_24595[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (5))){
var _ = (function (){var statearr_24525 = state_24472;
(statearr_24525[(4)] = cljs.core.rest.call(null,(state_24472[(4)])));

return statearr_24525;
})();
var state_24472__$1 = state_24472;
var ex24519 = (state_24472__$1[(2)]);
var statearr_24526_24596 = state_24472__$1;
(statearr_24526_24596[(5)] = ex24519);


if((ex24519 instanceof Error)){
var statearr_24527_24597 = state_24472__$1;
(statearr_24527_24597[(1)] = (4));

(statearr_24527_24597[(5)] = null);

} else {
throw ex24519;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (14))){
var inst_24391 = (state_24472[(2)]);
var state_24472__$1 = (function (){var statearr_24528 = state_24472;
(statearr_24528[(13)] = inst_24391);

return statearr_24528;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_24529_24598 = state_24472__$1;
(statearr_24529_24598[(1)] = (15));

} else {
var statearr_24530_24599 = state_24472__$1;
(statearr_24530_24599[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (45))){
var inst_24456 = (state_24472[(2)]);
var inst_24457 = fluree.db.util.async.throw_err.call(null,inst_24456);
var state_24472__$1 = (function (){var statearr_24531 = state_24472;
(statearr_24531[(12)] = inst_24457);

return statearr_24531;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_24532_24600 = state_24472__$1;
(statearr_24532_24600[(1)] = (46));

} else {
var statearr_24533_24601 = state_24472__$1;
(statearr_24533_24601[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (26))){
var inst_24414 = (state_24472[(9)]);
var inst_24414__$1 = (state_24472[(2)]);
var inst_24416 = (inst_24414__$1 == null);
var inst_24417 = cljs.core.not.call(null,inst_24416);
var state_24472__$1 = (function (){var statearr_24534 = state_24472;
(statearr_24534[(9)] = inst_24414__$1);

return statearr_24534;
})();
if(inst_24417){
var statearr_24535_24602 = state_24472__$1;
(statearr_24535_24602[(1)] = (27));

} else {
var statearr_24536_24603 = state_24472__$1;
(statearr_24536_24603[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (16))){
var inst_24391 = (state_24472[(13)]);
var state_24472__$1 = state_24472;
var statearr_24537_24604 = state_24472__$1;
(statearr_24537_24604[(2)] = inst_24391);

(statearr_24537_24604[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (38))){
var inst_24447 = (state_24472[(2)]);
var state_24472__$1 = state_24472;
if(cljs.core.truth_(inst_24447)){
var statearr_24538_24605 = state_24472__$1;
(statearr_24538_24605[(1)] = (42));

} else {
var statearr_24539_24606 = state_24472__$1;
(statearr_24539_24606[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (30))){
var state_24472__$1 = state_24472;
var statearr_24540_24607 = state_24472__$1;
(statearr_24540_24607[(2)] = true);

(statearr_24540_24607[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (10))){
var state_24472__$1 = state_24472;
if(cljs.core.truth_(aggregates)){
var statearr_24541_24608 = state_24472__$1;
(statearr_24541_24608[(1)] = (18));

} else {
var statearr_24542_24609 = state_24472__$1;
(statearr_24542_24609[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (18))){
var inst_24402 = fluree.db.query.analytical.add_aggregate_cols.call(null,res,aggregates);
var state_24472__$1 = state_24472;
var statearr_24543_24610 = state_24472__$1;
(statearr_24543_24610[(2)] = inst_24402);

(statearr_24543_24610[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (42))){
var inst_24409 = (state_24472[(10)]);
var inst_24437 = (state_24472[(15)]);
var inst_24449 = cljs.core.drop.call(null,inst_24409,inst_24437);
var inst_24450 = cljs.core.take.call(null,limit,inst_24449);
var state_24472__$1 = state_24472;
var statearr_24544_24611 = state_24472__$1;
(statearr_24544_24611[(2)] = inst_24450);

(statearr_24544_24611[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (37))){
var state_24472__$1 = state_24472;
var statearr_24545_24612 = state_24472__$1;
(statearr_24545_24612[(2)] = false);

(statearr_24545_24612[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (8))){
var inst_24376 = (state_24472[(2)]);
var state_24472__$1 = state_24472;
if(cljs.core.truth_(inst_24376)){
var statearr_24546_24613 = state_24472__$1;
(statearr_24546_24613[(1)] = (9));

} else {
var statearr_24547_24614 = state_24472__$1;
(statearr_24547_24614[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2468__auto__ = null;
var fluree$db$query$fql$state_machine__2468__auto____0 = (function (){
var statearr_24548 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24548[(0)] = fluree$db$query$fql$state_machine__2468__auto__);

(statearr_24548[(1)] = (1));

return statearr_24548;
});
var fluree$db$query$fql$state_machine__2468__auto____1 = (function (state_24472){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_24472);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e24549){var ex__2471__auto__ = e24549;
var statearr_24550_24615 = state_24472;
(statearr_24550_24615[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_24472[(4)]))){
var statearr_24551_24616 = state_24472;
(statearr_24551_24616[(1)] = cljs.core.first.call(null,(state_24472[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24617 = state_24472;
state_24472 = G__24617;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2468__auto__ = function(state_24472){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2468__auto____1.call(this,state_24472);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2468__auto____0;
fluree$db$query$fql$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2468__auto____1;
return fluree$db$query$fql$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_24552 = f__2491__auto__.call(null);
(statearr_24552[(6)] = c__2490__auto__);

return statearr_24552;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 5);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__24620,groupBy){
var map__24621 = p__24620;
var map__24621__$1 = (((((!((map__24621 == null))))?(((((map__24621.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24621.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24621):map__24621);
var res = map__24621__$1;
var headers = cljs.core.get.call(null,map__24621__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__24621__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__24623 = ((cljs.core.vector_QMARK_.call(null,groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.call(null,cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,groupBy)], null)], null):(function(){throw cljs.core.ex_info.call(null,["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var inVector_QMARK_ = cljs.core.nth.call(null,vec__24623,(0),null);
var groupBy__$1 = cljs.core.nth.call(null,vec__24623,(1),null);
var group_idxs = cljs.core.map.call(null,(function (p1__24618_SHARP_){
return fluree.db.util.core.index_of.call(null,headers,p1__24618_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some.call(null,cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.call(null,["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
return cljs.core.reduce.call(null,(function (res__$1,tuple){
var k = cljs.core.map.call(null,(function (p1__24619_SHARP_){
return cljs.core.nth.call(null,tuple,p1__24619_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,k):cljs.core.first.call(null,k));
var v = tuple;
return cljs.core.assoc.call(null,res__$1,k_SINGLEQUOTE_,cljs.core.conj.call(null,cljs.core.get.call(null,res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,p__24626,p__24627,opts){
var map__24628 = p__24626;
var map__24628__$1 = (((((!((map__24628 == null))))?(((((map__24628.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24628.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24628):map__24628);
var res = map__24628__$1;
var headers = cljs.core.get.call(null,map__24628__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__24628__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__24629 = p__24627;
var map__24629__$1 = (((((!((map__24629 == null))))?(((((map__24629.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24629.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24629):map__24629);
var select_spec = map__24629__$1;
var groupBy = cljs.core.get.call(null,map__24629__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var orderBy = cljs.core.get.call(null,map__24629__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.call(null,map__24629__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var selectOne_QMARK_ = cljs.core.get.call(null,map__24629__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var selectDistinct_QMARK_ = cljs.core.get.call(null,map__24629__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var inVector_QMARK_ = cljs.core.get.call(null,map__24629__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var offset = cljs.core.get.call(null,map__24629__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_24854){
var state_val_24855 = (state_24854[(1)]);
if((state_val_24855 === (65))){
var inst_24816 = (state_24854[(2)]);
var inst_24817 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,res,select_spec,inst_24816,opts);
var state_24854__$1 = state_24854;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24854__$1,(66),inst_24817);
} else {
if((state_val_24855 === (70))){
var inst_24820 = (state_24854[(7)]);
var inst_24825 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24826 = [inst_24820];
var inst_24827 = (new cljs.core.PersistentVector(null,1,(5),inst_24825,inst_24826,null));
var state_24854__$1 = state_24854;
var statearr_24856_24979 = state_24854__$1;
(statearr_24856_24979[(2)] = inst_24827);

(statearr_24856_24979[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (62))){
var inst_24809 = (state_24854[(2)]);
var state_24854__$1 = state_24854;
var statearr_24857_24980 = state_24854__$1;
(statearr_24857_24980[(2)] = inst_24809);

(statearr_24857_24980[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (74))){
var state_24854__$1 = state_24854;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_24858_24981 = state_24854__$1;
(statearr_24858_24981[(1)] = (76));

} else {
var statearr_24859_24982 = state_24854__$1;
(statearr_24859_24982[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (7))){
var state_24854__$1 = state_24854;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_24860_24983 = state_24854__$1;
(statearr_24860_24983[(1)] = (63));

} else {
var statearr_24861_24984 = state_24854__$1;
(statearr_24861_24984[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (59))){
var inst_24742 = (state_24854[(8)]);
var inst_24733 = (state_24854[(9)]);
var inst_24785 = (state_24854[(2)]);
var inst_24786 = fluree.db.util.async.throw_err.call(null,inst_24785);
var inst_24787 = cljs.core.assoc.call(null,inst_24733,inst_24742,inst_24786);
var state_24854__$1 = state_24854;
var statearr_24862_24985 = state_24854__$1;
(statearr_24862_24985[(2)] = inst_24787);

(statearr_24862_24985[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (20))){
var inst_24686 = (state_24854[(2)]);
var state_24854__$1 = state_24854;
var statearr_24863_24986 = state_24854__$1;
(statearr_24863_24986[(2)] = inst_24686);

(statearr_24863_24986[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (72))){
var inst_24830 = (state_24854[(2)]);
var state_24854__$1 = state_24854;
var statearr_24864_24987 = state_24854__$1;
(statearr_24864_24987[(2)] = inst_24830);

(statearr_24864_24987[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (58))){
var inst_24790 = (state_24854[(2)]);
var state_24854__$1 = state_24854;
var statearr_24865_24988 = state_24854__$1;
(statearr_24865_24988[(2)] = inst_24790);

(statearr_24865_24988[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (60))){
var inst_24688 = (state_24854[(10)]);
var inst_24803 = (state_24854[(11)]);
var inst_24805 = cljs.core.sorted_map_by.call(null,inst_24688);
var inst_24806 = cljs.core.into.call(null,inst_24805,inst_24803);
var state_24854__$1 = state_24854;
var statearr_24866_24989 = state_24854__$1;
(statearr_24866_24989[(2)] = inst_24806);

(statearr_24866_24989[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (27))){
var inst_24670 = (state_24854[(12)]);
var inst_24639 = (state_24854[(13)]);
var inst_24669 = (state_24854[(14)]);
var inst_24673 = (function (){var group_map = inst_24639;
var orderByIdx = inst_24669;
var orderDirection = inst_24670;
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn.call(null,cljs.core.nth.call(null,x,orderByIdx),cljs.core.nth.call(null,y,orderByIdx)));
});
})();
var state_24854__$1 = state_24854;
var statearr_24867_24990 = state_24854__$1;
(statearr_24867_24990[(2)] = inst_24673);

(statearr_24867_24990[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (1))){
var state_24854__$1 = state_24854;
var statearr_24868_24991 = state_24854__$1;
(statearr_24868_24991[(2)] = null);

(statearr_24868_24991[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (69))){
var inst_24847 = (state_24854[(2)]);
var state_24854__$1 = state_24854;
var statearr_24869_24992 = state_24854__$1;
(statearr_24869_24992[(2)] = inst_24847);

(statearr_24869_24992[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (24))){
var inst_24670 = (state_24854[(12)]);
var inst_24668 = cljs.core.second.call(null,orderBy);
var inst_24669 = fluree.db.util.core.index_of.call(null,groupBy,inst_24668);
var inst_24670__$1 = cljs.core.first.call(null,orderBy);
var inst_24671 = cljs.core._EQ_.call(null,"DESC",inst_24670__$1);
var state_24854__$1 = (function (){var statearr_24870 = state_24854;
(statearr_24870[(12)] = inst_24670__$1);

(statearr_24870[(14)] = inst_24669);

return statearr_24870;
})();
if(inst_24671){
var statearr_24871_24993 = state_24854__$1;
(statearr_24871_24993[(1)] = (27));

} else {
var statearr_24872_24994 = state_24854__$1;
(statearr_24872_24994[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (55))){
var inst_24742 = (state_24854[(8)]);
var inst_24733 = (state_24854[(9)]);
var inst_24774 = (state_24854[(2)]);
var inst_24775 = fluree.db.util.async.throw_err.call(null,inst_24774);
var inst_24776 = cljs.core.assoc.call(null,inst_24733,inst_24742,inst_24775);
var state_24854__$1 = state_24854;
var statearr_24873_24995 = state_24854__$1;
(statearr_24873_24995[(2)] = inst_24776);

(statearr_24873_24995[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (39))){
var inst_24733 = (state_24854[(9)]);
var state_24854__$1 = state_24854;
var statearr_24874_24996 = state_24854__$1;
(statearr_24874_24996[(2)] = inst_24733);

(statearr_24874_24996[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (46))){
var state_24854__$1 = state_24854;
var statearr_24875_24997 = state_24854__$1;
(statearr_24875_24997[(2)] = null);

(statearr_24875_24997[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (4))){
var inst_24632 = (state_24854[(2)]);
var state_24854__$1 = state_24854;
var statearr_24876_24998 = state_24854__$1;
(statearr_24876_24998[(2)] = inst_24632);

(statearr_24876_24998[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (77))){
var state_24854__$1 = state_24854;
var statearr_24877_24999 = state_24854__$1;
(statearr_24877_24999[(1)] = (79));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (54))){
var inst_24792 = (state_24854[(2)]);
var state_24854__$1 = state_24854;
var statearr_24879_25000 = state_24854__$1;
(statearr_24879_25000[(2)] = inst_24792);

(statearr_24879_25000[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (15))){
var inst_24639 = (state_24854[(13)]);
var inst_24651 = (function (){var group_map = inst_24639;
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn.call(null,x,y));
});
})();
var state_24854__$1 = state_24854;
var statearr_24880_25001 = state_24854__$1;
(statearr_24880_25001[(2)] = inst_24651);

(statearr_24880_25001[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (48))){
var inst_24760 = (state_24854[(15)]);
var inst_24763 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,inst_24760,select_spec,opts);
var state_24854__$1 = state_24854;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24854__$1,(51),inst_24763);
} else {
if((state_val_24855 === (50))){
var inst_24794 = (state_24854[(2)]);
var state_24854__$1 = state_24854;
var statearr_24881_25002 = state_24854__$1;
(statearr_24881_25002[(2)] = inst_24794);

(statearr_24881_25002[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (75))){
var inst_24845 = (state_24854[(2)]);
var state_24854__$1 = state_24854;
var statearr_24882_25003 = state_24854__$1;
(statearr_24882_25003[(2)] = inst_24845);

(statearr_24882_25003[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (21))){
var inst_24661 = cljs.core.set.call(null,groupBy);
var inst_24662 = cljs.core.second.call(null,orderBy);
var inst_24663 = inst_24661.call(null,inst_24662);
var state_24854__$1 = state_24854;
var statearr_24883_25004 = state_24854__$1;
(statearr_24883_25004[(2)] = inst_24663);

(statearr_24883_25004[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (31))){
var state_24854__$1 = state_24854;
var statearr_24884_25005 = state_24854__$1;
(statearr_24884_25005[(2)] = null);

(statearr_24884_25005[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (32))){
var inst_24682 = (state_24854[(2)]);
var state_24854__$1 = state_24854;
var statearr_24885_25006 = state_24854__$1;
(statearr_24885_25006[(2)] = inst_24682);

(statearr_24885_25006[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (40))){
var inst_24732 = (state_24854[(16)]);
var inst_24750 = (inst_24732 > (0));
var state_24854__$1 = state_24854;
if(cljs.core.truth_(inst_24750)){
var statearr_24886_25007 = state_24854__$1;
(statearr_24886_25007[(1)] = (42));

} else {
var statearr_24887_25008 = state_24854__$1;
(statearr_24887_25008[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (56))){
var inst_24745 = (state_24854[(17)]);
var inst_24757 = (state_24854[(18)]);
var inst_24760 = (state_24854[(15)]);
var inst_24780 = cljs.core.count.call(null,inst_24745);
var inst_24781 = (inst_24757 - limit);
var inst_24782 = (inst_24780 - inst_24781);
var inst_24783 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,inst_24760,select_spec,inst_24782,opts);
var state_24854__$1 = state_24854;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24854__$1,(59),inst_24783);
} else {
if((state_val_24855 === (33))){
var inst_24639 = (state_24854[(13)]);
var inst_24690 = cljs.core.keys.call(null,inst_24639);
var inst_24691 = cljs.core.first.call(null,inst_24690);
var inst_24692 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_24693 = cljs.core.vals.call(null,inst_24639);
var inst_24694 = cljs.core.first.call(null,inst_24693);
var inst_24695 = [headers,vars,inst_24694];
var inst_24696 = cljs.core.PersistentHashMap.fromArrays(inst_24692,inst_24695);
var inst_24697 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,inst_24696,select_spec,limit,opts);
var state_24854__$1 = (function (){var statearr_24888 = state_24854;
(statearr_24888[(19)] = inst_24691);

return statearr_24888;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24854__$1,(36),inst_24697);
} else {
if((state_val_24855 === (13))){
var inst_24656 = cljs.core.not.call(null,orderBy);
var state_24854__$1 = state_24854;
if(inst_24656){
var statearr_24889_25009 = state_24854__$1;
(statearr_24889_25009[(1)] = (18));

} else {
var statearr_24890_25010 = state_24854__$1;
(statearr_24890_25010[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (22))){
var inst_24659 = (state_24854[(20)]);
var state_24854__$1 = state_24854;
var statearr_24891_25011 = state_24854__$1;
(statearr_24891_25011[(2)] = inst_24659);

(statearr_24891_25011[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (36))){
var inst_24691 = (state_24854[(19)]);
var inst_24699 = (state_24854[(2)]);
var inst_24700 = fluree.db.util.async.throw_err.call(null,inst_24699);
var inst_24701 = [inst_24691];
var inst_24702 = [inst_24700];
var inst_24703 = cljs.core.PersistentHashMap.fromArrays(inst_24701,inst_24702);
var state_24854__$1 = state_24854;
var statearr_24892_25012 = state_24854__$1;
(statearr_24892_25012[(2)] = inst_24703);

(statearr_24892_25012[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (41))){
var inst_24801 = (state_24854[(2)]);
var state_24854__$1 = state_24854;
var statearr_24893_25013 = state_24854__$1;
(statearr_24893_25013[(2)] = inst_24801);

(statearr_24893_25013[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (43))){
var state_24854__$1 = state_24854;
var statearr_24894_25014 = state_24854__$1;
(statearr_24894_25014[(1)] = (45));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (61))){
var inst_24803 = (state_24854[(11)]);
var state_24854__$1 = state_24854;
var statearr_24896_25015 = state_24854__$1;
(statearr_24896_25015[(2)] = inst_24803);

(statearr_24896_25015[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (29))){
var inst_24677 = (state_24854[(2)]);
var state_24854__$1 = state_24854;
var statearr_24897_25016 = state_24854__$1;
(statearr_24897_25016[(2)] = inst_24677);

(statearr_24897_25016[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (44))){
var inst_24799 = (state_24854[(2)]);
var state_24854__$1 = state_24854;
var statearr_24898_25017 = state_24854__$1;
(statearr_24898_25017[(2)] = inst_24799);

(statearr_24898_25017[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (6))){
var inst_24640 = (state_24854[(21)]);
var inst_24639 = fluree.db.query.fql.ad_hoc_group_by.call(null,res,groupBy);
var inst_24640__$1 = orderBy;
var state_24854__$1 = (function (){var statearr_24899 = state_24854;
(statearr_24899[(21)] = inst_24640__$1);

(statearr_24899[(13)] = inst_24639);

return statearr_24899;
})();
if(cljs.core.truth_(inst_24640__$1)){
var statearr_24900_25018 = state_24854__$1;
(statearr_24900_25018[(1)] = (9));

} else {
var statearr_24901_25019 = state_24854__$1;
(statearr_24901_25019[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (28))){
var inst_24670 = (state_24854[(12)]);
var inst_24639 = (state_24854[(13)]);
var inst_24669 = (state_24854[(14)]);
var inst_24675 = (function (){var group_map = inst_24639;
var orderByIdx = inst_24669;
var orderDirection = inst_24670;
return (function (x,y){
return fluree.db.query.fql.compare_fn.call(null,cljs.core.nth.call(null,x,orderByIdx),cljs.core.nth.call(null,y,orderByIdx));
});
})();
var state_24854__$1 = state_24854;
var statearr_24903_25020 = state_24854__$1;
(statearr_24903_25020[(2)] = inst_24675);

(statearr_24903_25020[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (64))){
var state_24854__$1 = state_24854;
var statearr_24904_25021 = state_24854__$1;
(statearr_24904_25021[(2)] = limit);

(statearr_24904_25021[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (51))){
var inst_24746 = (state_24854[(22)]);
var inst_24742 = (state_24854[(8)]);
var inst_24743 = (state_24854[(23)]);
var inst_24733 = (state_24854[(9)]);
var inst_24732 = (state_24854[(16)]);
var inst_24757 = (state_24854[(18)]);
var inst_24765 = (state_24854[(2)]);
var inst_24766 = fluree.db.util.async.throw_err.call(null,inst_24765);
var inst_24767 = cljs.core.assoc.call(null,inst_24733,inst_24742,inst_24766);
var tmp24902 = inst_24732;
var inst_24729 = inst_24743;
var inst_24730 = inst_24746;
var inst_24731 = inst_24757;
var inst_24732__$1 = tmp24902;
var inst_24733__$1 = inst_24767;
var state_24854__$1 = (function (){var statearr_24905 = state_24854;
(statearr_24905[(24)] = inst_24731);

(statearr_24905[(9)] = inst_24733__$1);

(statearr_24905[(16)] = inst_24732__$1);

(statearr_24905[(25)] = inst_24730);

(statearr_24905[(26)] = inst_24729);

return statearr_24905;
})();
var statearr_24906_25022 = state_24854__$1;
(statearr_24906_25022[(2)] = null);

(statearr_24906_25022[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (25))){
var state_24854__$1 = state_24854;
var statearr_24907_25023 = state_24854__$1;
(statearr_24907_25023[(1)] = (30));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (34))){
var inst_24639 = (state_24854[(13)]);
var inst_24719 = cljs.core.keys.call(null,inst_24639);
var inst_24720 = cljs.core.seq.call(null,inst_24719);
var inst_24721 = cljs.core.first.call(null,inst_24720);
var inst_24722 = cljs.core.next.call(null,inst_24720);
var inst_24723 = cljs.core.vals.call(null,inst_24639);
var inst_24724 = cljs.core.seq.call(null,inst_24723);
var inst_24725 = cljs.core.first.call(null,inst_24724);
var inst_24726 = cljs.core.next.call(null,inst_24724);
var inst_24727 = offset;
var inst_24728 = cljs.core.PersistentHashMap.EMPTY;
var inst_24729 = inst_24719;
var inst_24730 = inst_24723;
var inst_24731 = (0);
var inst_24732 = inst_24727;
var inst_24733 = inst_24728;
var state_24854__$1 = (function (){var statearr_24909 = state_24854;
(statearr_24909[(27)] = inst_24722);

(statearr_24909[(24)] = inst_24731);

(statearr_24909[(9)] = inst_24733);

(statearr_24909[(16)] = inst_24732);

(statearr_24909[(28)] = inst_24726);

(statearr_24909[(29)] = inst_24721);

(statearr_24909[(30)] = inst_24725);

(statearr_24909[(25)] = inst_24730);

(statearr_24909[(26)] = inst_24729);

return statearr_24909;
})();
var statearr_24910_25024 = state_24854__$1;
(statearr_24910_25024[(2)] = null);

(statearr_24910_25024[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (17))){
var inst_24654 = (state_24854[(2)]);
var state_24854__$1 = state_24854;
var statearr_24911_25025 = state_24854__$1;
(statearr_24911_25025[(2)] = inst_24654);

(statearr_24911_25025[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (3))){
var inst_24852 = (state_24854[(2)]);
var state_24854__$1 = state_24854;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24854__$1,inst_24852);
} else {
if((state_val_24855 === (12))){
var inst_24648 = cljs.core.first.call(null,orderBy);
var inst_24649 = cljs.core._EQ_.call(null,inst_24648,"DESC");
var state_24854__$1 = state_24854;
if(inst_24649){
var statearr_24912_25026 = state_24854__$1;
(statearr_24912_25026[(1)] = (15));

} else {
var statearr_24913_25027 = state_24854__$1;
(statearr_24913_25027[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (2))){
var _ = (function (){var statearr_24914 = state_24854;
(statearr_24914[(4)] = cljs.core.cons.call(null,(5),(state_24854[(4)])));

return statearr_24914;
})();
var state_24854__$1 = state_24854;
if(cljs.core.truth_(groupBy)){
var statearr_24915_25028 = state_24854__$1;
(statearr_24915_25028[(1)] = (6));

} else {
var statearr_24916_25029 = state_24854__$1;
(statearr_24916_25029[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (66))){
var inst_24820 = (state_24854[(7)]);
var inst_24819 = (state_24854[(2)]);
var inst_24820__$1 = fluree.db.util.async.throw_err.call(null,inst_24819);
var inst_24821 = cljs.core.coll_QMARK_.call(null,inst_24820__$1);
var inst_24822 = (!(inst_24821));
var state_24854__$1 = (function (){var statearr_24917 = state_24854;
(statearr_24917[(7)] = inst_24820__$1);

return statearr_24917;
})();
if(inst_24822){
var statearr_24918_25030 = state_24854__$1;
(statearr_24918_25030[(1)] = (67));

} else {
var statearr_24919_25031 = state_24854__$1;
(statearr_24919_25031[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (23))){
var inst_24666 = (state_24854[(2)]);
var state_24854__$1 = state_24854;
if(cljs.core.truth_(inst_24666)){
var statearr_24920_25032 = state_24854__$1;
(statearr_24920_25032[(1)] = (24));

} else {
var statearr_24921_25033 = state_24854__$1;
(statearr_24921_25033[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (47))){
var inst_24797 = (state_24854[(2)]);
var state_24854__$1 = state_24854;
var statearr_24922_25034 = state_24854__$1;
(statearr_24922_25034[(2)] = inst_24797);

(statearr_24922_25034[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (35))){
var inst_24811 = (state_24854[(2)]);
var state_24854__$1 = state_24854;
var statearr_24923_25035 = state_24854__$1;
(statearr_24923_25035[(2)] = inst_24811);

(statearr_24923_25035[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (76))){
var inst_24820 = (state_24854[(7)]);
var inst_24836 = cljs.core.distinct.call(null,inst_24820);
var state_24854__$1 = state_24854;
var statearr_24924_25036 = state_24854__$1;
(statearr_24924_25036[(2)] = inst_24836);

(statearr_24924_25036[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (19))){
var inst_24659 = (state_24854[(20)]);
var inst_24659__$1 = orderBy;
var state_24854__$1 = (function (){var statearr_24925 = state_24854;
(statearr_24925[(20)] = inst_24659__$1);

return statearr_24925;
})();
if(cljs.core.truth_(inst_24659__$1)){
var statearr_24926_25037 = state_24854__$1;
(statearr_24926_25037[(1)] = (21));

} else {
var statearr_24927_25038 = state_24854__$1;
(statearr_24927_25038[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (57))){
var state_24854__$1 = state_24854;
var statearr_24928_25039 = state_24854__$1;
(statearr_24928_25039[(2)] = null);

(statearr_24928_25039[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (68))){
var state_24854__$1 = state_24854;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_24929_25040 = state_24854__$1;
(statearr_24929_25040[(1)] = (73));

} else {
var statearr_24930_25041 = state_24854__$1;
(statearr_24930_25041[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (11))){
var inst_24646 = (state_24854[(2)]);
var state_24854__$1 = state_24854;
if(cljs.core.truth_(inst_24646)){
var statearr_24932_25042 = state_24854__$1;
(statearr_24932_25042[(1)] = (12));

} else {
var statearr_24933_25043 = state_24854__$1;
(statearr_24933_25043[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (9))){
var inst_24642 = cljs.core.second.call(null,orderBy);
var inst_24643 = cljs.core._EQ_.call(null,inst_24642,groupBy);
var state_24854__$1 = state_24854;
var statearr_24934_25044 = state_24854__$1;
(statearr_24934_25044[(2)] = inst_24643);

(statearr_24934_25044[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (5))){
var _ = (function (){var statearr_24935 = state_24854;
(statearr_24935[(4)] = cljs.core.rest.call(null,(state_24854[(4)])));

return statearr_24935;
})();
var state_24854__$1 = state_24854;
var ex24931 = (state_24854__$1[(2)]);
var statearr_24936_25045 = state_24854__$1;
(statearr_24936_25045[(5)] = ex24931);


if((ex24931 instanceof Error)){
var statearr_24937_25046 = state_24854__$1;
(statearr_24937_25046[(1)] = (4));

(statearr_24937_25046[(5)] = null);

} else {
throw ex24931;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (14))){
var inst_24688 = (state_24854[(2)]);
var state_24854__$1 = (function (){var statearr_24938 = state_24854;
(statearr_24938[(10)] = inst_24688);

return statearr_24938;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_24939_25047 = state_24854__$1;
(statearr_24939_25047[(1)] = (33));

} else {
var statearr_24940_25048 = state_24854__$1;
(statearr_24940_25048[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (45))){
var inst_24745 = (state_24854[(17)]);
var inst_24731 = (state_24854[(24)]);
var inst_24757 = (state_24854[(18)]);
var inst_24756 = cljs.core.count.call(null,inst_24745);
var inst_24757__$1 = (inst_24731 + inst_24756);
var inst_24758 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_24759 = [headers,vars,inst_24745];
var inst_24760 = cljs.core.PersistentHashMap.fromArrays(inst_24758,inst_24759);
var inst_24761 = (limit > inst_24757__$1);
var state_24854__$1 = (function (){var statearr_24941 = state_24854;
(statearr_24941[(18)] = inst_24757__$1);

(statearr_24941[(15)] = inst_24760);

return statearr_24941;
})();
if(cljs.core.truth_(inst_24761)){
var statearr_24942_25049 = state_24854__$1;
(statearr_24942_25049[(1)] = (48));

} else {
var statearr_24943_25050 = state_24854__$1;
(statearr_24943_25050[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (53))){
var inst_24757 = (state_24854[(18)]);
var inst_24778 = (limit < inst_24757);
var state_24854__$1 = state_24854;
if(cljs.core.truth_(inst_24778)){
var statearr_24944_25051 = state_24854__$1;
(statearr_24944_25051[(1)] = (56));

} else {
var statearr_24945_25052 = state_24854__$1;
(statearr_24945_25052[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (78))){
var inst_24843 = (state_24854[(2)]);
var state_24854__$1 = state_24854;
var statearr_24946_25053 = state_24854__$1;
(statearr_24946_25053[(2)] = inst_24843);

(statearr_24946_25053[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (26))){
var inst_24684 = (state_24854[(2)]);
var state_24854__$1 = state_24854;
var statearr_24947_25054 = state_24854__$1;
(statearr_24947_25054[(2)] = inst_24684);

(statearr_24947_25054[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (16))){
var state_24854__$1 = state_24854;
var statearr_24948_25055 = state_24854__$1;
(statearr_24948_25055[(2)] = fluree.db.query.fql.compare_fn);

(statearr_24948_25055[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (81))){
var inst_24841 = (state_24854[(2)]);
var state_24854__$1 = state_24854;
var statearr_24949_25056 = state_24854__$1;
(statearr_24949_25056[(2)] = inst_24841);

(statearr_24949_25056[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (79))){
var inst_24820 = (state_24854[(7)]);
var state_24854__$1 = state_24854;
var statearr_24950_25057 = state_24854__$1;
(statearr_24950_25057[(2)] = inst_24820);

(statearr_24950_25057[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (38))){
var inst_24688 = (state_24854[(10)]);
var inst_24803 = (state_24854[(2)]);
var state_24854__$1 = (function (){var statearr_24951 = state_24854;
(statearr_24951[(11)] = inst_24803);

return statearr_24951;
})();
if(cljs.core.truth_(inst_24688)){
var statearr_24952_25058 = state_24854__$1;
(statearr_24952_25058[(1)] = (60));

} else {
var statearr_24953_25059 = state_24854__$1;
(statearr_24953_25059[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (30))){
var state_24854__$1 = state_24854;
var statearr_24954_25060 = state_24854__$1;
(statearr_24954_25060[(2)] = null);

(statearr_24954_25060[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (73))){
var inst_24820 = (state_24854[(7)]);
var inst_24833 = cljs.core.first.call(null,inst_24820);
var state_24854__$1 = state_24854;
var statearr_24955_25061 = state_24854__$1;
(statearr_24955_25061[(2)] = inst_24833);

(statearr_24955_25061[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (10))){
var inst_24640 = (state_24854[(21)]);
var state_24854__$1 = state_24854;
var statearr_24956_25062 = state_24854__$1;
(statearr_24956_25062[(2)] = inst_24640);

(statearr_24956_25062[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (18))){
var state_24854__$1 = state_24854;
var statearr_24957_25063 = state_24854__$1;
(statearr_24957_25063[(2)] = null);

(statearr_24957_25063[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (52))){
var inst_24760 = (state_24854[(15)]);
var inst_24772 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,inst_24760,select_spec,opts);
var state_24854__$1 = state_24854;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24854__$1,(55),inst_24772);
} else {
if((state_val_24855 === (67))){
var state_24854__$1 = state_24854;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_24960_25064 = state_24854__$1;
(statearr_24960_25064[(1)] = (70));

} else {
var statearr_24961_25065 = state_24854__$1;
(statearr_24961_25065[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (71))){
var inst_24820 = (state_24854[(7)]);
var state_24854__$1 = state_24854;
var statearr_24962_25066 = state_24854__$1;
(statearr_24962_25066[(2)] = inst_24820);

(statearr_24962_25066[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (42))){
var inst_24746 = (state_24854[(22)]);
var inst_24731 = (state_24854[(24)]);
var inst_24743 = (state_24854[(23)]);
var inst_24733 = (state_24854[(9)]);
var inst_24732 = (state_24854[(16)]);
var inst_24752 = (inst_24732 - (1));
var tmp24958 = inst_24731;
var tmp24959 = inst_24733;
var inst_24729 = inst_24743;
var inst_24730 = inst_24746;
var inst_24731__$1 = tmp24958;
var inst_24732__$1 = inst_24752;
var inst_24733__$1 = tmp24959;
var state_24854__$1 = (function (){var statearr_24963 = state_24854;
(statearr_24963[(24)] = inst_24731__$1);

(statearr_24963[(9)] = inst_24733__$1);

(statearr_24963[(16)] = inst_24732__$1);

(statearr_24963[(25)] = inst_24730);

(statearr_24963[(26)] = inst_24729);

return statearr_24963;
})();
var statearr_24964_25067 = state_24854__$1;
(statearr_24964_25067[(2)] = null);

(statearr_24964_25067[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (80))){
var state_24854__$1 = state_24854;
var statearr_24965_25068 = state_24854__$1;
(statearr_24965_25068[(2)] = null);

(statearr_24965_25068[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (37))){
var inst_24745 = (state_24854[(17)]);
var inst_24730 = (state_24854[(25)]);
var inst_24729 = (state_24854[(26)]);
var inst_24741 = cljs.core.seq.call(null,inst_24729);
var inst_24742 = cljs.core.first.call(null,inst_24741);
var inst_24743 = cljs.core.next.call(null,inst_24741);
var inst_24744 = cljs.core.seq.call(null,inst_24730);
var inst_24745__$1 = cljs.core.first.call(null,inst_24744);
var inst_24746 = cljs.core.next.call(null,inst_24744);
var inst_24747 = (inst_24745__$1 == null);
var state_24854__$1 = (function (){var statearr_24966 = state_24854;
(statearr_24966[(17)] = inst_24745__$1);

(statearr_24966[(22)] = inst_24746);

(statearr_24966[(8)] = inst_24742);

(statearr_24966[(23)] = inst_24743);

return statearr_24966;
})();
if(cljs.core.truth_(inst_24747)){
var statearr_24967_25069 = state_24854__$1;
(statearr_24967_25069[(1)] = (39));

} else {
var statearr_24968_25070 = state_24854__$1;
(statearr_24968_25070[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (63))){
var state_24854__$1 = state_24854;
var statearr_24969_25071 = state_24854__$1;
(statearr_24969_25071[(2)] = (1));

(statearr_24969_25071[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (8))){
var inst_24849 = (state_24854[(2)]);
var _ = (function (){var statearr_24970 = state_24854;
(statearr_24970[(4)] = cljs.core.rest.call(null,(state_24854[(4)])));

return statearr_24970;
})();
var state_24854__$1 = state_24854;
var statearr_24971_25072 = state_24854__$1;
(statearr_24971_25072[(2)] = inst_24849);

(statearr_24971_25072[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24855 === (49))){
var inst_24757 = (state_24854[(18)]);
var inst_24770 = cljs.core._EQ_.call(null,limit,inst_24757);
var state_24854__$1 = state_24854;
if(inst_24770){
var statearr_24972_25073 = state_24854__$1;
(statearr_24972_25073[(1)] = (52));

} else {
var statearr_24973_25074 = state_24854__$1;
(statearr_24973_25074[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2468__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2468__auto____0 = (function (){
var statearr_24974 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24974[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2468__auto__);

(statearr_24974[(1)] = (1));

return statearr_24974;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2468__auto____1 = (function (state_24854){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_24854);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e24975){var ex__2471__auto__ = e24975;
var statearr_24976_25075 = state_24854;
(statearr_24976_25075[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_24854[(4)]))){
var statearr_24977_25076 = state_24854;
(statearr_24977_25076[(1)] = cljs.core.first.call(null,(state_24854[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25077 = state_24854;
state_24854 = G__25077;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2468__auto__ = function(state_24854){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2468__auto____1.call(this,state_24854);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2468__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2468__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_24978 = f__2491__auto__.call(null);
(statearr_24978[(6)] = c__2490__auto__);

return statearr_24978;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__25080,opts){
var map__25081 = p__25080;
var map__25081__$1 = (((((!((map__25081 == null))))?(((((map__25081.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25081.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25081):map__25081);
var selectOne = cljs.core.get.call(null,map__25081__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var select = cljs.core.get.call(null,map__25081__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var selectDistinct = cljs.core.get.call(null,map__25081__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var selectReduced = cljs.core.get.call(null,map__25081__$1,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var select_smt = (function (){var or__4126__auto__ = selectOne;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = select;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
var or__4126__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__4126__auto____$2)){
return or__4126__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_.call(null,select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select.call(null,headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.call(null,(function (p1__25078_SHARP_){
return cljs.core.contains_QMARK_.call(null,p1__25078_SHARP_,new cljs.core.Keyword(null,"code","code",1586293142));
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some.call(null,(function (p1__25079_SHARP_){
return cljs.core.contains_QMARK_.call(null,p1__25079_SHARP_,new cljs.core.Keyword(null,"selection","selection",975998651));
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_.call(null,aggregates))?null:aggregates);
var orderBy = (function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5735__auto__)){
var orderBy = temp__5735__auto__;
if(cljs.core.truth_((function (){var or__4126__auto__ = typeof orderBy === 'string';
if(or__4126__auto__){
return or__4126__auto__;
} else {
if(cljs.core.vector_QMARK_.call(null,orderBy)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null).call(null,cljs.core.first.call(null,orderBy));
} else {
return false;
}
}
})())){
if(cljs.core.vector_QMARK_.call(null,orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.call(null,["Invalid orderBy clause, must by variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289),new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"inVector?","inVector?",1948069375)],[expandMap_QMARK_,(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (100);
}
})(),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"offset","offset",296498311).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$.call(null,selectOne),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return false;
}
})(),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667).cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$.call(null,(function (){var or__4126__auto__ = selectDistinct;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__25083,p__25084){
var map__25085 = p__25083;
var map__25085__$1 = (((((!((map__25085 == null))))?(((((map__25085.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25085.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25085):map__25085);
var query_map = map__25085__$1;
var construct = cljs.core.get.call(null,map__25085__$1,new cljs.core.Keyword(null,"construct","construct",692547932));
var map__25086 = p__25084;
var map__25086__$1 = (((((!((map__25086 == null))))?(((((map__25086.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25086.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25086):map__25086);
var where_result = map__25086__$1;
var headers = cljs.core.get.call(null,map__25086__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__25086__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__25089 = cljs.core.map.call(null,(function (construct_item){
var temp__5733__auto__ = fluree.db.util.core.index_of.call(null,headers,cljs.core.symbol.call(null,construct_item));
if(cljs.core.truth_(temp__5733__auto__)){
var index_of = temp__5733__auto__;
return (function (row){
return cljs.core.nth.call(null,row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.call(null,vec__25089,(0),null);
var fn2 = cljs.core.nth.call(null,vec__25089,(1),null);
var fn3 = cljs.core.nth.call(null,vec__25089,(2),null);
return cljs.core.map.call(null,(function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fn1.call(null,res),fn2.call(null,res),fn3.call(null,res)], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_25122){
var state_val_25123 = (state_25122[(1)]);
if((state_val_25123 === (7))){
var inst_25101 = (state_25122[(7)]);
var state_25122__$1 = state_25122;
var statearr_25124_25147 = state_25122__$1;
(statearr_25124_25147[(2)] = inst_25101);

(statearr_25124_25147[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (1))){
var state_25122__$1 = state_25122;
var statearr_25125_25148 = state_25122__$1;
(statearr_25125_25148[(2)] = null);

(statearr_25125_25148[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (4))){
var inst_25092 = (state_25122[(2)]);
var state_25122__$1 = state_25122;
var statearr_25126_25149 = state_25122__$1;
(statearr_25126_25149[(2)] = inst_25092);

(statearr_25126_25149[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (13))){
var inst_25111 = (state_25122[(2)]);
var inst_25112 = fluree.db.util.async.throw_err.call(null,inst_25111);
var state_25122__$1 = state_25122;
var statearr_25127_25150 = state_25122__$1;
(statearr_25127_25150[(2)] = inst_25112);

(statearr_25127_25150[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (6))){
var inst_25101 = (state_25122[(7)]);
var inst_25100 = (state_25122[(2)]);
var inst_25101__$1 = fluree.db.util.async.throw_err.call(null,inst_25100);
var inst_25102 = fluree.db.util.core.exception_QMARK_.call(null,inst_25101__$1);
var state_25122__$1 = (function (){var statearr_25128 = state_25122;
(statearr_25128[(7)] = inst_25101__$1);

return statearr_25128;
})();
if(inst_25102){
var statearr_25129_25151 = state_25122__$1;
(statearr_25129_25151[(1)] = (7));

} else {
var statearr_25130_25152 = state_25122__$1;
(statearr_25130_25152[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (3))){
var inst_25120 = (state_25122[(2)]);
var state_25122__$1 = state_25122;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25122__$1,inst_25120);
} else {
if((state_val_25123 === (12))){
var inst_25115 = (state_25122[(2)]);
var state_25122__$1 = state_25122;
var statearr_25131_25153 = state_25122__$1;
(statearr_25131_25153[(2)] = inst_25115);

(statearr_25131_25153[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (2))){
var _ = (function (){var statearr_25132 = state_25122;
(statearr_25132[(4)] = cljs.core.cons.call(null,(5),(state_25122[(4)])));

return statearr_25132;
})();
var inst_25098 = fluree.db.query.analytical.q.call(null,query_map,fuel,max_fuel,db,opts);
var state_25122__$1 = state_25122;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25122__$1,(6),inst_25098);
} else {
if((state_val_25123 === (11))){
var state_25122__$1 = state_25122;
var statearr_25134_25154 = state_25122__$1;
(statearr_25134_25154[(2)] = null);

(statearr_25134_25154[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (9))){
var inst_25117 = (state_25122[(2)]);
var _ = (function (){var statearr_25135 = state_25122;
(statearr_25135[(4)] = cljs.core.rest.call(null,(state_25122[(4)])));

return statearr_25135;
})();
var state_25122__$1 = state_25122;
var statearr_25136_25155 = state_25122__$1;
(statearr_25136_25155[(2)] = inst_25117);

(statearr_25136_25155[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (5))){
var _ = (function (){var statearr_25137 = state_25122;
(statearr_25137[(4)] = cljs.core.rest.call(null,(state_25122[(4)])));

return statearr_25137;
})();
var state_25122__$1 = state_25122;
var ex25133 = (state_25122__$1[(2)]);
var statearr_25138_25156 = state_25122__$1;
(statearr_25138_25156[(5)] = ex25133);


if((ex25133 instanceof Error)){
var statearr_25139_25157 = state_25122__$1;
(statearr_25139_25157[(1)] = (4));

(statearr_25139_25157[(5)] = null);

} else {
throw ex25133;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (10))){
var inst_25101 = (state_25122[(7)]);
var inst_25106 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_25101);
var inst_25107 = new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(inst_25101);
var inst_25108 = fluree.db.query.fql.get_ad_hoc_select_spec.call(null,inst_25106,inst_25107,query_map,opts);
var inst_25109 = fluree.db.query.fql.process_ad_hoc_res.call(null,db,inst_25101,inst_25108,opts);
var state_25122__$1 = state_25122;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25122__$1,(13),inst_25109);
} else {
if((state_val_25123 === (8))){
var state_25122__$1 = state_25122;
var statearr_25140_25158 = state_25122__$1;
(statearr_25140_25158[(1)] = (10));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2468__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2468__auto____0 = (function (){
var statearr_25142 = [null,null,null,null,null,null,null,null];
(statearr_25142[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__2468__auto__);

(statearr_25142[(1)] = (1));

return statearr_25142;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2468__auto____1 = (function (state_25122){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_25122);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e25143){var ex__2471__auto__ = e25143;
var statearr_25144_25159 = state_25122;
(statearr_25144_25159[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_25122[(4)]))){
var statearr_25145_25160 = state_25122;
(statearr_25145_25160[(1)] = cljs.core.first.call(null,(state_25122[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25161 = state_25122;
state_25122 = G__25161;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__2468__auto__ = function(state_25122){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2468__auto____1.call(this,state_25122);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2468__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2468__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_25146 = f__2491__auto__.call(null);
(statearr_25146[(6)] = c__2490__auto__);

return statearr_25146;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Returns core async channel with results
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
var map__25162 = query_map;
var map__25162__$1 = (((((!((map__25162 == null))))?(((((map__25162.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25162.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25162):map__25162);
var select = cljs.core.get.call(null,map__25162__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.call(null,map__25162__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var where = cljs.core.get.call(null,map__25162__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var limit = cljs.core.get.call(null,map__25162__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__25162__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var component = cljs.core.get.call(null,map__25162__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var selectDistinct = cljs.core.get.call(null,map__25162__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var prettyPrint = cljs.core.get.call(null,map__25162__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectOne = cljs.core.get.call(null,map__25162__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var from = cljs.core.get.call(null,map__25162__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var opts = cljs.core.get.call(null,map__25162__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var groupBy = cljs.core.get.call(null,map__25162__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var opts_SINGLEQUOTE_ = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"limit","limit",-1355822363),limit,new cljs.core.Keyword(null,"offset","offset",296498311),(function (){var or__4126__auto__ = offset;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})(),new cljs.core.Keyword(null,"component","component",1555936782),component,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),orderBy,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),groupBy,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),prettyPrint], null),opts);
var opts_SINGLEQUOTE__SINGLEQUOTE_ = (cljs.core.truth_(selectOne)?cljs.core.assoc.call(null,opts_SINGLEQUOTE_,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1)):opts_SINGLEQUOTE_);
var max_fuel = new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE__SINGLEQUOTE_);
var fuel = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.truth_((function (){var or__4126__auto____$1 = max_fuel;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_.call(null,(0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_.call(null,where)){
return fluree.db.query.fql.ad_hoc_query.call(null,db,fuel,max_fuel,query_map,opts_SINGLEQUOTE__SINGLEQUOTE_);
} else {
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_25523){
var state_val_25524 = (state_25523[(1)]);
if((state_val_25524 === (121))){
var inst_25505 = (state_25523[(7)]);
var inst_25504 = (state_25523[(2)]);
var inst_25505__$1 = selectOne;
var state_25523__$1 = (function (){var statearr_25525 = state_25523;
(statearr_25525[(7)] = inst_25505__$1);

(statearr_25525[(8)] = inst_25504);

return statearr_25525;
})();
if(cljs.core.truth_(inst_25505__$1)){
var statearr_25526_25707 = state_25523__$1;
(statearr_25526_25707[(1)] = (122));

} else {
var statearr_25527_25708 = state_25523__$1;
(statearr_25527_25708[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (65))){
var state_25523__$1 = state_25523;
var statearr_25528_25709 = state_25523__$1;
(statearr_25528_25709[(2)] = false);

(statearr_25528_25709[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (70))){
var inst_25351 = cljs.core.PersistentHashMap.EMPTY;
var state_25523__$1 = state_25523;
var statearr_25529_25710 = state_25523__$1;
(statearr_25529_25710[(2)] = inst_25351);

(statearr_25529_25710[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (62))){
var inst_25243 = (state_25523[(9)]);
var inst_25318 = (state_25523[(10)]);
var inst_25245 = (state_25523[(11)]);
var inst_25233 = (state_25523[(12)]);
var inst_25332 = (state_25523[(2)]);
var inst_25333 = fluree.db.util.async.throw_err.call(null,inst_25332);
var inst_25334 = cljs.core.sequence.call(null,inst_25318,inst_25333);
var inst_25335 = fluree.db.query.fql.subject_select.call(null,db,inst_25245,fuel,max_fuel,inst_25243,inst_25334,inst_25233);
var state_25523__$1 = state_25523;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25523__$1,(63),inst_25335);
} else {
if((state_val_25524 === (74))){
var inst_25364 = (state_25523[(2)]);
var inst_25365 = fluree.db.util.async.throw_err.call(null,inst_25364);
var state_25523__$1 = state_25523;
var statearr_25530_25711 = state_25523__$1;
(statearr_25530_25711[(2)] = inst_25365);

(statearr_25530_25711[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (110))){
var inst_25430 = (state_25523[(13)]);
var state_25523__$1 = state_25523;
var statearr_25531_25712 = state_25523__$1;
(statearr_25531_25712[(2)] = inst_25430);

(statearr_25531_25712[(1)] = (111));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (7))){
var inst_25193 = (state_25523[(14)]);
var inst_25193__$1 = selectOne;
var state_25523__$1 = (function (){var statearr_25532 = state_25523;
(statearr_25532[(14)] = inst_25193__$1);

return statearr_25532;
})();
if(cljs.core.truth_(inst_25193__$1)){
var statearr_25533_25713 = state_25523__$1;
(statearr_25533_25713[(1)] = (9));

} else {
var statearr_25534_25714 = state_25523__$1;
(statearr_25534_25714[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (59))){
var inst_25320 = cljs.core.PersistentHashMap.EMPTY;
var state_25523__$1 = state_25523;
var statearr_25535_25715 = state_25523__$1;
(statearr_25535_25715[(2)] = inst_25320);

(statearr_25535_25715[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (86))){
var inst_25392 = (state_25523[(15)]);
var inst_25391 = (state_25523[(2)]);
var inst_25392__$1 = fluree.db.util.async.throw_err.call(null,inst_25391);
var inst_25393 = (inst_25392__$1 == null);
var state_25523__$1 = (function (){var statearr_25536 = state_25523;
(statearr_25536[(15)] = inst_25392__$1);

return statearr_25536;
})();
if(cljs.core.truth_(inst_25393)){
var statearr_25537_25716 = state_25523__$1;
(statearr_25537_25716[(1)] = (87));

} else {
var statearr_25538_25717 = state_25523__$1;
(statearr_25538_25717[(1)] = (88));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (20))){
var inst_25223 = (state_25523[(2)]);
var state_25523__$1 = state_25523;
var statearr_25539_25718 = state_25523__$1;
(statearr_25539_25718[(2)] = inst_25223);

(statearr_25539_25718[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (72))){
var inst_25357 = (state_25523[(2)]);
var inst_25358 = fluree.db.query.range._block_or_tx_collection.call(null,db,inst_25357);
var state_25523__$1 = state_25523;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25523__$1,(73),inst_25358);
} else {
if((state_val_25524 === (58))){
var inst_25232 = (state_25523[(16)]);
var inst_25318 = (state_25523[(2)]);
var state_25523__$1 = (function (){var statearr_25540 = state_25523;
(statearr_25540[(10)] = inst_25318);

return statearr_25540;
})();
if(cljs.core.truth_(inst_25232)){
var statearr_25541_25719 = state_25523__$1;
(statearr_25541_25719[(1)] = (59));

} else {
var statearr_25542_25720 = state_25523__$1;
(statearr_25542_25720[(1)] = (60));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (60))){
var inst_25235 = (state_25523[(17)]);
var inst_25233 = (state_25523[(12)]);
var inst_25322 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_25323 = [inst_25233,inst_25235];
var inst_25324 = cljs.core.PersistentHashMap.fromArrays(inst_25322,inst_25323);
var state_25523__$1 = state_25523;
var statearr_25543_25721 = state_25523__$1;
(statearr_25543_25721[(2)] = inst_25324);

(statearr_25543_25721[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (27))){
var inst_25232 = (state_25523[(16)]);
var inst_25247 = cljs.core.vector_QMARK_.call(null,inst_25232);
var state_25523__$1 = state_25523;
if(inst_25247){
var statearr_25544_25722 = state_25523__$1;
(statearr_25544_25722[(1)] = (30));

} else {
var statearr_25545_25723 = state_25523__$1;
(statearr_25545_25723[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (1))){
var state_25523__$1 = state_25523;
var statearr_25546_25724 = state_25523__$1;
(statearr_25546_25724[(2)] = null);

(statearr_25546_25724[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (69))){
var inst_25495 = (state_25523[(2)]);
var state_25523__$1 = state_25523;
var statearr_25547_25725 = state_25523__$1;
(statearr_25547_25725[(2)] = inst_25495);

(statearr_25547_25725[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (101))){
var inst_25464 = (state_25523[(2)]);
var state_25523__$1 = state_25523;
var statearr_25548_25726 = state_25523__$1;
(statearr_25548_25726[(2)] = inst_25464);

(statearr_25548_25726[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (24))){
var inst_25234 = (state_25523[(18)]);
var inst_25236 = (state_25523[(19)]);
var inst_25240 = cljs.core.assoc.call(null,inst_25236,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),inst_25234);
var state_25523__$1 = state_25523;
var statearr_25549_25727 = state_25523__$1;
(statearr_25549_25727[(2)] = inst_25240);

(statearr_25549_25727[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (102))){
var inst_25436 = (state_25523[(20)]);
var state_25523__$1 = state_25523;
var statearr_25550_25728 = state_25523__$1;
(statearr_25550_25728[(2)] = inst_25436);

(statearr_25550_25728[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (55))){
var inst_25312 = (state_25523[(2)]);
var state_25523__$1 = (function (){var statearr_25551 = state_25523;
(statearr_25551[(21)] = inst_25312);

return statearr_25551;
})();
var statearr_25552_25729 = state_25523__$1;
(statearr_25552_25729[(1)] = (56));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (85))){
var inst_25491 = (state_25523[(2)]);
var state_25523__$1 = state_25523;
var statearr_25554_25730 = state_25523__$1;
(statearr_25554_25730[(2)] = inst_25491);

(statearr_25554_25730[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (39))){
var inst_25282 = typeof from === 'string';
var state_25523__$1 = state_25523;
if(cljs.core.truth_(inst_25282)){
var statearr_25555_25731 = state_25523__$1;
(statearr_25555_25731[(1)] = (42));

} else {
var statearr_25556_25732 = state_25523__$1;
(statearr_25556_25732[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (88))){
var inst_25392 = (state_25523[(15)]);
var inst_25396 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25397 = [inst_25392];
var inst_25398 = (new cljs.core.PersistentVector(null,1,(5),inst_25396,inst_25397,null));
var state_25523__$1 = state_25523;
var statearr_25557_25733 = state_25523__$1;
(statearr_25557_25733[(2)] = inst_25398);

(statearr_25557_25733[(1)] = (89));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (46))){
var inst_25297 = (state_25523[(2)]);
var inst_25298 = fluree.db.util.async.throw_err.call(null,inst_25297);
var state_25523__$1 = state_25523;
var statearr_25558_25734 = state_25523__$1;
(statearr_25558_25734[(2)] = inst_25298);

(statearr_25558_25734[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (4))){
var inst_25180 = (state_25523[(2)]);
var state_25523__$1 = state_25523;
var statearr_25559_25735 = state_25523__$1;
(statearr_25559_25735[(2)] = inst_25180);

(statearr_25559_25735[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (77))){
var inst_25493 = (state_25523[(2)]);
var state_25523__$1 = state_25523;
var statearr_25560_25736 = state_25523__$1;
(statearr_25560_25736[(2)] = inst_25493);

(statearr_25560_25736[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (106))){
var state_25523__$1 = state_25523;
var statearr_25561_25737 = state_25523__$1;
(statearr_25561_25737[(2)] = null);

(statearr_25561_25737[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (119))){
var inst_25279 = (state_25523[(22)]);
var inst_25499 = (state_25523[(23)]);
var inst_25235 = (state_25523[(17)]);
var inst_25278 = (state_25523[(24)]);
var inst_25233 = (state_25523[(12)]);
var inst_25501 = fluree.db.query.fql.sort_offset_and_limit_res.call(null,inst_25278,inst_25279,inst_25235,inst_25233,inst_25499);
var state_25523__$1 = state_25523;
var statearr_25562_25738 = state_25523__$1;
(statearr_25562_25738[(2)] = inst_25501);

(statearr_25562_25738[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (95))){
var state_25523__$1 = state_25523;
var statearr_25563_25739 = state_25523__$1;
(statearr_25563_25739[(1)] = (116));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (54))){
var inst_25306 = (state_25523[(25)]);
var state_25523__$1 = state_25523;
var statearr_25565_25740 = state_25523__$1;
(statearr_25565_25740[(2)] = inst_25306);

(statearr_25565_25740[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (92))){
var state_25523__$1 = state_25523;
var statearr_25566_25741 = state_25523__$1;
(statearr_25566_25741[(2)] = null);

(statearr_25566_25741[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (104))){
var inst_25456 = (state_25523[(26)]);
var inst_25456__$1 = (state_25523[(2)]);
var state_25523__$1 = (function (){var statearr_25567 = state_25523;
(statearr_25567[(26)] = inst_25456__$1);

return statearr_25567;
})();
if(cljs.core.truth_(inst_25456__$1)){
var statearr_25568_25742 = state_25523__$1;
(statearr_25568_25742[(1)] = (109));

} else {
var statearr_25569_25743 = state_25523__$1;
(statearr_25569_25743[(1)] = (110));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (15))){
var inst_25210 = (state_25523[(27)]);
var inst_25215 = inst_25210.cljs$lang$protocol_mask$partition0$;
var inst_25216 = (inst_25215 & (64));
var inst_25217 = inst_25210.cljs$core$ISeq$;
var inst_25218 = (cljs.core.PROTOCOL_SENTINEL === inst_25217);
var inst_25219 = ((inst_25216) || (inst_25218));
var state_25523__$1 = state_25523;
if(cljs.core.truth_(inst_25219)){
var statearr_25570_25744 = state_25523__$1;
(statearr_25570_25744[(1)] = (18));

} else {
var statearr_25571_25745 = state_25523__$1;
(statearr_25571_25745[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (48))){
var inst_25233 = (state_25523[(12)]);
var state_25523__$1 = state_25523;
var statearr_25572_25746 = state_25523__$1;
(statearr_25572_25746[(2)] = inst_25233);

(statearr_25572_25746[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (50))){
var inst_25306 = cljs.core.map.call(null,fluree.db.query.fql.s);
var state_25523__$1 = (function (){var statearr_25573 = state_25523;
(statearr_25573[(25)] = inst_25306);

return statearr_25573;
})();
if(cljs.core.truth_(fuel)){
var statearr_25574_25747 = state_25523__$1;
(statearr_25574_25747[(1)] = (53));

} else {
var statearr_25575_25748 = state_25523__$1;
(statearr_25575_25748[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (116))){
var inst_25479 = cljs.core.pr_str.call(null,query_map);
var inst_25480 = ["Invalid 'from' in query:",inst_25479].join('');
var inst_25481 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25482 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_25483 = cljs.core.PersistentHashMap.fromArrays(inst_25481,inst_25482);
var inst_25484 = cljs.core.ex_info.call(null,inst_25480,inst_25483);
var state_25523__$1 = state_25523;
var statearr_25576_25749 = state_25523__$1;
(statearr_25576_25749[(2)] = inst_25484);

(statearr_25576_25749[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (75))){
var inst_25232 = (state_25523[(16)]);
var state_25523__$1 = state_25523;
if(cljs.core.truth_(inst_25232)){
var statearr_25577_25750 = state_25523__$1;
(statearr_25577_25750[(1)] = (78));

} else {
var statearr_25578_25751 = state_25523__$1;
(statearr_25578_25751[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (99))){
var inst_25430 = (state_25523[(13)]);
var state_25523__$1 = state_25523;
var statearr_25579_25752 = state_25523__$1;
(statearr_25579_25752[(2)] = inst_25430);

(statearr_25579_25752[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (21))){
var inst_25210 = (state_25523[(27)]);
var inst_25228 = cljs.core.apply.call(null,cljs.core.hash_map,inst_25210);
var state_25523__$1 = state_25523;
var statearr_25580_25753 = state_25523__$1;
(statearr_25580_25753[(2)] = inst_25228);

(statearr_25580_25753[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (31))){
var inst_25232 = (state_25523[(16)]);
var inst_25255 = typeof inst_25232 === 'string';
var state_25523__$1 = state_25523;
if(cljs.core.truth_(inst_25255)){
var statearr_25581_25754 = state_25523__$1;
(statearr_25581_25754[(1)] = (33));

} else {
var statearr_25582_25755 = state_25523__$1;
(statearr_25582_25755[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (113))){
var state_25523__$1 = state_25523;
var statearr_25583_25756 = state_25523__$1;
(statearr_25583_25756[(2)] = null);

(statearr_25583_25756[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (32))){
var inst_25271 = (state_25523[(2)]);
var state_25523__$1 = state_25523;
var statearr_25584_25757 = state_25523__$1;
(statearr_25584_25757[(2)] = inst_25271);

(statearr_25584_25757[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (40))){
var inst_25300 = typeof from === 'string';
var inst_25301 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_25302 = clojure.string.includes_QMARK_.call(null,inst_25301,"/");
var inst_25303 = ((inst_25300) && (inst_25302));
var state_25523__$1 = state_25523;
if(cljs.core.truth_(inst_25303)){
var statearr_25585_25758 = state_25523__$1;
(statearr_25585_25758[(1)] = (50));

} else {
var statearr_25586_25759 = state_25523__$1;
(statearr_25586_25759[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (91))){
var inst_25406 = cljs.core._deref.call(null,fuel);
var inst_25407 = (inst_25406 + (1));
var inst_25408 = cljs.core._vreset_BANG_.call(null,fuel,inst_25407);
var state_25523__$1 = state_25523;
var statearr_25587_25760 = state_25523__$1;
(statearr_25587_25760[(2)] = inst_25408);

(statearr_25587_25760[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (117))){
var state_25523__$1 = state_25523;
var statearr_25588_25761 = state_25523__$1;
(statearr_25588_25761[(2)] = null);

(statearr_25588_25761[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (108))){
var inst_25453 = (state_25523[(2)]);
var inst_25454 = fluree.db.util.async.throw_err.call(null,inst_25453);
var state_25523__$1 = state_25523;
var statearr_25589_25762 = state_25523__$1;
(statearr_25589_25762[(2)] = inst_25454);

(statearr_25589_25762[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (56))){
var inst_25312 = (state_25523[(21)]);
var inst_25314 = cljs.core.distinct.call(null);
var inst_25315 = cljs.core.comp.call(null,inst_25312,inst_25314);
var state_25523__$1 = state_25523;
var statearr_25590_25763 = state_25523__$1;
(statearr_25590_25763[(2)] = inst_25315);

(statearr_25590_25763[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (33))){
var inst_25232 = (state_25523[(16)]);
var inst_25257 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25258 = [inst_25232,"ASC"];
var inst_25259 = (new cljs.core.PersistentVector(null,2,(5),inst_25257,inst_25258,null));
var state_25523__$1 = state_25523;
var statearr_25591_25764 = state_25523__$1;
(statearr_25591_25764[(2)] = inst_25259);

(statearr_25591_25764[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (13))){
var inst_25199 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25200 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_25201 = cljs.core.PersistentHashMap.fromArrays(inst_25199,inst_25200);
var inst_25202 = cljs.core.ex_info.call(null,"Query missing :select or :selectOne.",inst_25201);
var inst_25203 = (function(){throw inst_25202})();
var state_25523__$1 = state_25523;
var statearr_25592_25765 = state_25523__$1;
(statearr_25592_25765[(2)] = inst_25203);

(statearr_25592_25765[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (22))){
var inst_25210 = (state_25523[(27)]);
var state_25523__$1 = state_25523;
var statearr_25593_25766 = state_25523__$1;
(statearr_25593_25766[(2)] = inst_25210);

(statearr_25593_25766[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (90))){
var inst_25403 = (state_25523[(2)]);
var inst_25404 = fluree.db.util.async.throw_err.call(null,inst_25403);
var state_25523__$1 = (function (){var statearr_25594 = state_25523;
(statearr_25594[(28)] = inst_25404);

return statearr_25594;
})();
if(cljs.core.truth_(fuel)){
var statearr_25595_25767 = state_25523__$1;
(statearr_25595_25767[(1)] = (91));

} else {
var statearr_25596_25768 = state_25523__$1;
(statearr_25596_25768[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (109))){
var inst_25456 = (state_25523[(26)]);
var inst_25430 = (state_25523[(13)]);
var inst_25458 = cljs.core.conj.call(null,inst_25430,inst_25456);
var state_25523__$1 = state_25523;
var statearr_25597_25769 = state_25523__$1;
(statearr_25597_25769[(2)] = inst_25458);

(statearr_25597_25769[(1)] = (111));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (36))){
var inst_25262 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25263 = [null,null];
var inst_25264 = (new cljs.core.PersistentVector(null,2,(5),inst_25262,inst_25263,null));
var state_25523__$1 = state_25523;
var statearr_25598_25770 = state_25523__$1;
(statearr_25598_25770[(2)] = inst_25264);

(statearr_25598_25770[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (41))){
var inst_25278 = (state_25523[(24)]);
var inst_25499 = (state_25523[(2)]);
var state_25523__$1 = (function (){var statearr_25599 = state_25523;
(statearr_25599[(23)] = inst_25499);

return statearr_25599;
})();
if(cljs.core.truth_(inst_25278)){
var statearr_25600_25771 = state_25523__$1;
(statearr_25600_25771[(1)] = (119));

} else {
var statearr_25601_25772 = state_25523__$1;
(statearr_25601_25772[(1)] = (120));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (118))){
var inst_25487 = (state_25523[(2)]);
var state_25523__$1 = state_25523;
var statearr_25602_25773 = state_25523__$1;
(statearr_25602_25773[(2)] = inst_25487);

(statearr_25602_25773[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (89))){
var inst_25243 = (state_25523[(9)]);
var inst_25235 = (state_25523[(17)]);
var inst_25245 = (state_25523[(11)]);
var inst_25233 = (state_25523[(12)]);
var inst_25400 = (state_25523[(2)]);
var inst_25401 = fluree.db.query.fql.subject_select.call(null,db,inst_25245,fuel,max_fuel,inst_25243,inst_25400,inst_25233,inst_25235);
var state_25523__$1 = state_25523;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25523__$1,(90),inst_25401);
} else {
if((state_val_25524 === (100))){
var inst_25436 = (state_25523[(20)]);
var inst_25441 = cljs.core.int_QMARK_.call(null,inst_25436);
var state_25523__$1 = state_25523;
if(inst_25441){
var statearr_25603_25774 = state_25523__$1;
(statearr_25603_25774[(1)] = (102));

} else {
var statearr_25604_25775 = state_25523__$1;
(statearr_25604_25775[(1)] = (103));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (122))){
var inst_25504 = (state_25523[(8)]);
var inst_25507 = cljs.core.coll_QMARK_.call(null,inst_25504);
var inst_25508 = fluree.db.util.core.exception_QMARK_.call(null,inst_25504);
var inst_25509 = (!(inst_25508));
var inst_25510 = ((inst_25507) && (inst_25509));
var state_25523__$1 = state_25523;
var statearr_25605_25776 = state_25523__$1;
(statearr_25605_25776[(2)] = inst_25510);

(statearr_25605_25776[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (43))){
var state_25523__$1 = state_25523;
var statearr_25606_25777 = state_25523__$1;
(statearr_25606_25777[(2)] = null);

(statearr_25606_25777[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (61))){
var inst_25326 = (state_25523[(2)]);
var inst_25327 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25328 = [from];
var inst_25329 = (new cljs.core.PersistentVector(null,1,(5),inst_25327,inst_25328,null));
var inst_25330 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_25329,inst_25326);
var state_25523__$1 = state_25523;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25523__$1,(62),inst_25330);
} else {
if((state_val_25524 === (29))){
var inst_25277 = (state_25523[(2)]);
var inst_25278 = cljs.core.nth.call(null,inst_25277,(0),null);
var inst_25279 = cljs.core.nth.call(null,inst_25277,(1),null);
var inst_25280 = typeof where === 'string';
var state_25523__$1 = (function (){var statearr_25607 = state_25523;
(statearr_25607[(22)] = inst_25279);

(statearr_25607[(24)] = inst_25278);

return statearr_25607;
})();
if(cljs.core.truth_(inst_25280)){
var statearr_25608_25778 = state_25523__$1;
(statearr_25608_25778[(1)] = (39));

} else {
var statearr_25609_25779 = state_25523__$1;
(statearr_25609_25779[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (44))){
var inst_25286 = (state_25523[(2)]);
var inst_25287 = fluree.db.query.fql.where_filter.call(null,db,where,inst_25286);
var state_25523__$1 = state_25523;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25523__$1,(45),inst_25287);
} else {
if((state_val_25524 === (93))){
var inst_25404 = (state_25523[(28)]);
var inst_25411 = (state_25523[(2)]);
var state_25523__$1 = (function (){var statearr_25610 = state_25523;
(statearr_25610[(29)] = inst_25411);

return statearr_25610;
})();
var statearr_25611_25780 = state_25523__$1;
(statearr_25611_25780[(2)] = inst_25404);

(statearr_25611_25780[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (6))){
var inst_25190 = (state_25523[(30)]);
var state_25523__$1 = state_25523;
var statearr_25612_25781 = state_25523__$1;
(statearr_25612_25781[(2)] = inst_25190);

(statearr_25612_25781[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (111))){
var inst_25437 = (state_25523[(31)]);
var inst_25461 = (state_25523[(2)]);
var inst_25429 = inst_25437;
var inst_25430 = inst_25461;
var state_25523__$1 = (function (){var statearr_25613 = state_25523;
(statearr_25613[(13)] = inst_25430);

(statearr_25613[(32)] = inst_25429);

return statearr_25613;
})();
var statearr_25614_25782 = state_25523__$1;
(statearr_25614_25782[(2)] = null);

(statearr_25614_25782[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (28))){
var inst_25273 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25274 = [null,null];
var inst_25275 = (new cljs.core.PersistentVector(null,2,(5),inst_25273,inst_25274,null));
var state_25523__$1 = state_25523;
var statearr_25615_25783 = state_25523__$1;
(statearr_25615_25783[(2)] = inst_25275);

(statearr_25615_25783[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (64))){
var inst_25342 = ["_tx",null,"_block",null];
var inst_25343 = (new cljs.core.PersistentArrayMap(null,2,inst_25342,null));
var inst_25344 = (new cljs.core.PersistentHashSet(null,inst_25343,null));
var inst_25345 = inst_25344.call(null,from);
var state_25523__$1 = state_25523;
var statearr_25616_25784 = state_25523__$1;
(statearr_25616_25784[(2)] = inst_25345);

(statearr_25616_25784[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (103))){
var state_25523__$1 = state_25523;
if(cljs.core.truth_(fuel)){
var statearr_25617_25785 = state_25523__$1;
(statearr_25617_25785[(1)] = (105));

} else {
var statearr_25618_25786 = state_25523__$1;
(statearr_25618_25786[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (51))){
var inst_25340 = typeof from === 'string';
var state_25523__$1 = state_25523;
if(cljs.core.truth_(inst_25340)){
var statearr_25619_25787 = state_25523__$1;
(statearr_25619_25787[(1)] = (64));

} else {
var statearr_25620_25788 = state_25523__$1;
(statearr_25620_25788[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (25))){
var inst_25236 = (state_25523[(19)]);
var state_25523__$1 = state_25523;
var statearr_25621_25789 = state_25523__$1;
(statearr_25621_25789[(2)] = inst_25236);

(statearr_25621_25789[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (34))){
var state_25523__$1 = state_25523;
var statearr_25622_25790 = state_25523__$1;
(statearr_25622_25790[(1)] = (36));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (125))){
var inst_25504 = (state_25523[(8)]);
var inst_25515 = cljs.core.first.call(null,inst_25504);
var state_25523__$1 = state_25523;
var statearr_25624_25791 = state_25523__$1;
(statearr_25624_25791[(2)] = inst_25515);

(statearr_25624_25791[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (17))){
var inst_25226 = (state_25523[(2)]);
var state_25523__$1 = state_25523;
if(cljs.core.truth_(inst_25226)){
var statearr_25625_25792 = state_25523__$1;
(statearr_25625_25792[(1)] = (21));

} else {
var statearr_25626_25793 = state_25523__$1;
(statearr_25626_25793[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (3))){
var inst_25521 = (state_25523[(2)]);
var state_25523__$1 = state_25523;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25523__$1,inst_25521);
} else {
if((state_val_25524 === (12))){
var inst_25196 = (state_25523[(33)]);
var state_25523__$1 = state_25523;
var statearr_25627_25794 = state_25523__$1;
(statearr_25627_25794[(2)] = inst_25196);

(statearr_25627_25794[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (2))){
var inst_25190 = (state_25523[(30)]);
var _ = (function (){var statearr_25628 = state_25523;
(statearr_25628[(4)] = cljs.core.cons.call(null,(5),(state_25523[(4)])));

return statearr_25628;
})();
var inst_25190__$1 = select;
var state_25523__$1 = (function (){var statearr_25629 = state_25523;
(statearr_25629[(30)] = inst_25190__$1);

return statearr_25629;
})();
if(cljs.core.truth_(inst_25190__$1)){
var statearr_25630_25795 = state_25523__$1;
(statearr_25630_25795[(1)] = (6));

} else {
var statearr_25631_25796 = state_25523__$1;
(statearr_25631_25796[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (66))){
var inst_25348 = (state_25523[(2)]);
var state_25523__$1 = state_25523;
if(cljs.core.truth_(inst_25348)){
var statearr_25632_25797 = state_25523__$1;
(statearr_25632_25797[(1)] = (67));

} else {
var statearr_25633_25798 = state_25523__$1;
(statearr_25633_25798[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (107))){
var inst_25436 = (state_25523[(20)]);
var inst_25450 = (state_25523[(2)]);
var inst_25451 = fluree.db.dbproto._subid.call(null,db,inst_25436,false);
var state_25523__$1 = (function (){var statearr_25634 = state_25523;
(statearr_25634[(34)] = inst_25450);

return statearr_25634;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25523__$1,(108),inst_25451);
} else {
if((state_val_25524 === (23))){
var inst_25234 = (state_25523[(18)]);
var inst_25209 = (state_25523[(35)]);
var inst_25231 = (state_25523[(2)]);
var inst_25232 = cljs.core.get.call(null,inst_25231,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_25233 = cljs.core.get.call(null,inst_25231,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_25234__$1 = cljs.core.get.call(null,inst_25231,new cljs.core.Keyword(null,"component","component",1555936782));
var inst_25235 = cljs.core.get.call(null,inst_25231,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_25236 = fluree.db.query.fql_parser.parse_db.call(null,db,inst_25209,opts_SINGLEQUOTE__SINGLEQUOTE_);
var inst_25237 = (inst_25234__$1 == null);
var inst_25238 = cljs.core.not.call(null,inst_25237);
var state_25523__$1 = (function (){var statearr_25635 = state_25523;
(statearr_25635[(18)] = inst_25234__$1);

(statearr_25635[(17)] = inst_25235);

(statearr_25635[(19)] = inst_25236);

(statearr_25635[(16)] = inst_25232);

(statearr_25635[(12)] = inst_25233);

return statearr_25635;
})();
if(inst_25238){
var statearr_25636_25799 = state_25523__$1;
(statearr_25636_25799[(1)] = (24));

} else {
var statearr_25637_25800 = state_25523__$1;
(statearr_25637_25800[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (47))){
var state_25523__$1 = state_25523;
var statearr_25638_25801 = state_25523__$1;
(statearr_25638_25801[(2)] = null);

(statearr_25638_25801[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (35))){
var inst_25269 = (state_25523[(2)]);
var state_25523__$1 = state_25523;
var statearr_25639_25802 = state_25523__$1;
(statearr_25639_25802[(2)] = inst_25269);

(statearr_25639_25802[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (127))){
var inst_25518 = (state_25523[(2)]);
var _ = (function (){var statearr_25640 = state_25523;
(statearr_25640[(4)] = cljs.core.rest.call(null,(state_25523[(4)])));

return statearr_25640;
})();
var state_25523__$1 = state_25523;
var statearr_25641_25803 = state_25523__$1;
(statearr_25641_25803[(2)] = inst_25518);

(statearr_25641_25803[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (82))){
var inst_25383 = (state_25523[(2)]);
var inst_25384 = fluree.db.util.async.throw_err.call(null,inst_25383);
var state_25523__$1 = state_25523;
var statearr_25642_25804 = state_25523__$1;
(statearr_25642_25804[(2)] = inst_25384);

(statearr_25642_25804[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (76))){
var inst_25386 = fluree.db.util.core.subj_ident_QMARK_.call(null,from);
var state_25523__$1 = state_25523;
if(inst_25386){
var statearr_25643_25805 = state_25523__$1;
(statearr_25643_25805[(1)] = (83));

} else {
var statearr_25644_25806 = state_25523__$1;
(statearr_25644_25806[(1)] = (84));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (97))){
var inst_25436 = (state_25523[(20)]);
var inst_25429 = (state_25523[(32)]);
var inst_25435 = cljs.core.seq.call(null,inst_25429);
var inst_25436__$1 = cljs.core.first.call(null,inst_25435);
var inst_25437 = cljs.core.next.call(null,inst_25435);
var inst_25438 = cljs.core.not.call(null,inst_25436__$1);
var state_25523__$1 = (function (){var statearr_25645 = state_25523;
(statearr_25645[(31)] = inst_25437);

(statearr_25645[(20)] = inst_25436__$1);

return statearr_25645;
})();
if(inst_25438){
var statearr_25646_25807 = state_25523__$1;
(statearr_25646_25807[(1)] = (99));

} else {
var statearr_25647_25808 = state_25523__$1;
(statearr_25647_25808[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (19))){
var state_25523__$1 = state_25523;
var statearr_25648_25809 = state_25523__$1;
(statearr_25648_25809[(2)] = false);

(statearr_25648_25809[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (57))){
var inst_25312 = (state_25523[(21)]);
var state_25523__$1 = state_25523;
var statearr_25649_25810 = state_25523__$1;
(statearr_25649_25810[(2)] = inst_25312);

(statearr_25649_25810[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (68))){
var inst_25367 = typeof from === 'string';
var state_25523__$1 = state_25523;
if(cljs.core.truth_(inst_25367)){
var statearr_25650_25811 = state_25523__$1;
(statearr_25650_25811[(1)] = (75));

} else {
var statearr_25651_25812 = state_25523__$1;
(statearr_25651_25812[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (11))){
var inst_25207 = (state_25523[(2)]);
var state_25523__$1 = state_25523;
var statearr_25652_25813 = state_25523__$1;
(statearr_25652_25813[(2)] = inst_25207);

(statearr_25652_25813[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (115))){
var inst_25243 = (state_25523[(9)]);
var inst_25235 = (state_25523[(17)]);
var inst_25245 = (state_25523[(11)]);
var inst_25468 = (state_25523[(36)]);
var inst_25472 = (state_25523[(2)]);
var inst_25473 = fluree.db.query.fql.subject_select.call(null,db,inst_25245,fuel,max_fuel,inst_25243,inst_25468,inst_25472,inst_25235);
var state_25523__$1 = state_25523;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25523__$1,(112),inst_25473);
} else {
if((state_val_25524 === (9))){
var inst_25193 = (state_25523[(14)]);
var state_25523__$1 = state_25523;
var statearr_25654_25814 = state_25523__$1;
(statearr_25654_25814[(2)] = inst_25193);

(statearr_25654_25814[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (5))){
var _ = (function (){var statearr_25655 = state_25523;
(statearr_25655[(4)] = cljs.core.rest.call(null,(state_25523[(4)])));

return statearr_25655;
})();
var state_25523__$1 = state_25523;
var ex25653 = (state_25523__$1[(2)]);
var statearr_25656_25815 = state_25523__$1;
(statearr_25656_25815[(5)] = ex25653);


if((ex25653 instanceof Error)){
var statearr_25657_25816 = state_25523__$1;
(statearr_25657_25816[(1)] = (4));

(statearr_25657_25816[(5)] = null);

} else {
throw ex25653;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (112))){
var inst_25475 = (state_25523[(2)]);
var inst_25476 = fluree.db.util.async.throw_err.call(null,inst_25475);
var state_25523__$1 = state_25523;
var statearr_25658_25817 = state_25523__$1;
(statearr_25658_25817[(2)] = inst_25476);

(statearr_25658_25817[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (83))){
var inst_25389 = fluree.db.dbproto._subid.call(null,db,from,false);
var state_25523__$1 = state_25523;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25523__$1,(86),inst_25389);
} else {
if((state_val_25524 === (14))){
var inst_25205 = (state_25523[(2)]);
var state_25523__$1 = state_25523;
var statearr_25659_25818 = state_25523__$1;
(statearr_25659_25818[(2)] = inst_25205);

(statearr_25659_25818[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (45))){
var inst_25232 = (state_25523[(16)]);
var inst_25289 = (state_25523[(2)]);
var inst_25290 = fluree.db.util.async.throw_err.call(null,inst_25289);
var state_25523__$1 = (function (){var statearr_25660 = state_25523;
(statearr_25660[(37)] = inst_25290);

return statearr_25660;
})();
if(cljs.core.truth_(inst_25232)){
var statearr_25661_25819 = state_25523__$1;
(statearr_25661_25819[(1)] = (47));

} else {
var statearr_25662_25820 = state_25523__$1;
(statearr_25662_25820[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (53))){
var inst_25306 = (state_25523[(25)]);
var inst_25308 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_25309 = cljs.core.comp.call(null,inst_25306,inst_25308);
var state_25523__$1 = state_25523;
var statearr_25663_25821 = state_25523__$1;
(statearr_25663_25821[(2)] = inst_25309);

(statearr_25663_25821[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (78))){
var inst_25370 = cljs.core.PersistentHashMap.EMPTY;
var state_25523__$1 = state_25523;
var statearr_25664_25822 = state_25523__$1;
(statearr_25664_25822[(2)] = inst_25370);

(statearr_25664_25822[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (26))){
var inst_25232 = (state_25523[(16)]);
var inst_25243 = (state_25523[(2)]);
var inst_25244 = cljs.core.PersistentHashMap.EMPTY;
var inst_25245 = cljs.core.volatile_BANG_.call(null,inst_25244);
var state_25523__$1 = (function (){var statearr_25665 = state_25523;
(statearr_25665[(9)] = inst_25243);

(statearr_25665[(11)] = inst_25245);

return statearr_25665;
})();
if(cljs.core.truth_(inst_25232)){
var statearr_25666_25823 = state_25523__$1;
(statearr_25666_25823[(1)] = (27));

} else {
var statearr_25667_25824 = state_25523__$1;
(statearr_25667_25824[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (123))){
var inst_25505 = (state_25523[(7)]);
var state_25523__$1 = state_25523;
var statearr_25668_25825 = state_25523__$1;
(statearr_25668_25825[(2)] = inst_25505);

(statearr_25668_25825[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (16))){
var state_25523__$1 = state_25523;
var statearr_25669_25826 = state_25523__$1;
(statearr_25669_25826[(2)] = false);

(statearr_25669_25826[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (81))){
var inst_25243 = (state_25523[(9)]);
var inst_25245 = (state_25523[(11)]);
var inst_25379 = (state_25523[(2)]);
var inst_25380 = fluree.db.util.async.throw_err.call(null,inst_25379);
var inst_25381 = fluree.db.query.fql.flake_select.call(null,db,inst_25245,fuel,max_fuel,inst_25243,inst_25380);
var state_25523__$1 = state_25523;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25523__$1,(82),inst_25381);
} else {
if((state_val_25524 === (120))){
var inst_25499 = (state_25523[(23)]);
var state_25523__$1 = state_25523;
var statearr_25670_25827 = state_25523__$1;
(statearr_25670_25827[(2)] = inst_25499);

(statearr_25670_25827[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (79))){
var inst_25235 = (state_25523[(17)]);
var inst_25233 = (state_25523[(12)]);
var inst_25372 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_25373 = [inst_25233,inst_25235];
var inst_25374 = cljs.core.PersistentHashMap.fromArrays(inst_25372,inst_25373);
var state_25523__$1 = state_25523;
var statearr_25671_25828 = state_25523__$1;
(statearr_25671_25828[(2)] = inst_25374);

(statearr_25671_25828[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (38))){
var inst_25267 = (state_25523[(2)]);
var state_25523__$1 = state_25523;
var statearr_25672_25829 = state_25523__$1;
(statearr_25672_25829[(2)] = inst_25267);

(statearr_25672_25829[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (126))){
var inst_25504 = (state_25523[(8)]);
var state_25523__$1 = state_25523;
var statearr_25673_25830 = state_25523__$1;
(statearr_25673_25830[(2)] = inst_25504);

(statearr_25673_25830[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (98))){
var inst_25232 = (state_25523[(16)]);
var inst_25466 = (state_25523[(2)]);
var inst_25467 = cljs.core.PersistentVector.EMPTY;
var inst_25468 = cljs.core.into.call(null,inst_25467,inst_25466);
var state_25523__$1 = (function (){var statearr_25674 = state_25523;
(statearr_25674[(36)] = inst_25468);

return statearr_25674;
})();
if(cljs.core.truth_(inst_25232)){
var statearr_25675_25831 = state_25523__$1;
(statearr_25675_25831[(1)] = (113));

} else {
var statearr_25676_25832 = state_25523__$1;
(statearr_25676_25832[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (124))){
var inst_25513 = (state_25523[(2)]);
var state_25523__$1 = state_25523;
if(cljs.core.truth_(inst_25513)){
var statearr_25677_25833 = state_25523__$1;
(statearr_25677_25833[(1)] = (125));

} else {
var statearr_25678_25834 = state_25523__$1;
(statearr_25678_25834[(1)] = (126));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (87))){
var state_25523__$1 = state_25523;
var statearr_25679_25835 = state_25523__$1;
(statearr_25679_25835[(2)] = null);

(statearr_25679_25835[(1)] = (89));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (30))){
var inst_25232 = (state_25523[(16)]);
var inst_25249 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25250 = cljs.core.second.call(null,inst_25232);
var inst_25251 = cljs.core.first.call(null,inst_25232);
var inst_25252 = [inst_25250,inst_25251];
var inst_25253 = (new cljs.core.PersistentVector(null,2,(5),inst_25249,inst_25252,null));
var state_25523__$1 = state_25523;
var statearr_25680_25836 = state_25523__$1;
(statearr_25680_25836[(2)] = inst_25253);

(statearr_25680_25836[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (73))){
var inst_25243 = (state_25523[(9)]);
var inst_25245 = (state_25523[(11)]);
var inst_25360 = (state_25523[(2)]);
var inst_25361 = fluree.db.util.async.throw_err.call(null,inst_25360);
var inst_25362 = fluree.db.query.fql.flake_select.call(null,db,inst_25245,fuel,max_fuel,inst_25243,inst_25361);
var state_25523__$1 = state_25523;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25523__$1,(74),inst_25362);
} else {
if((state_val_25524 === (96))){
var inst_25489 = (state_25523[(2)]);
var state_25523__$1 = state_25523;
var statearr_25681_25837 = state_25523__$1;
(statearr_25681_25837[(2)] = inst_25489);

(statearr_25681_25837[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (10))){
var inst_25196 = (state_25523[(33)]);
var inst_25196__$1 = selectDistinct;
var state_25523__$1 = (function (){var statearr_25682 = state_25523;
(statearr_25682[(33)] = inst_25196__$1);

return statearr_25682;
})();
if(cljs.core.truth_(inst_25196__$1)){
var statearr_25683_25838 = state_25523__$1;
(statearr_25683_25838[(1)] = (12));

} else {
var statearr_25684_25839 = state_25523__$1;
(statearr_25684_25839[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (18))){
var state_25523__$1 = state_25523;
var statearr_25685_25840 = state_25523__$1;
(statearr_25685_25840[(2)] = true);

(statearr_25685_25840[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (105))){
var inst_25445 = cljs.core._deref.call(null,fuel);
var inst_25446 = (inst_25445 + (1));
var inst_25447 = cljs.core._vreset_BANG_.call(null,fuel,inst_25446);
var state_25523__$1 = state_25523;
var statearr_25686_25841 = state_25523__$1;
(statearr_25686_25841[(2)] = inst_25447);

(statearr_25686_25841[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (52))){
var inst_25497 = (state_25523[(2)]);
var state_25523__$1 = state_25523;
var statearr_25687_25842 = state_25523__$1;
(statearr_25687_25842[(2)] = inst_25497);

(statearr_25687_25842[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (114))){
var inst_25233 = (state_25523[(12)]);
var state_25523__$1 = state_25523;
var statearr_25688_25843 = state_25523__$1;
(statearr_25688_25843[(2)] = inst_25233);

(statearr_25688_25843[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (67))){
var inst_25232 = (state_25523[(16)]);
var state_25523__$1 = state_25523;
if(cljs.core.truth_(inst_25232)){
var statearr_25689_25844 = state_25523__$1;
(statearr_25689_25844[(1)] = (70));

} else {
var statearr_25690_25845 = state_25523__$1;
(statearr_25690_25845[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (71))){
var inst_25235 = (state_25523[(17)]);
var inst_25233 = (state_25523[(12)]);
var inst_25353 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_25354 = [inst_25233,inst_25235];
var inst_25355 = cljs.core.PersistentHashMap.fromArrays(inst_25353,inst_25354);
var state_25523__$1 = state_25523;
var statearr_25691_25846 = state_25523__$1;
(statearr_25691_25846[(2)] = inst_25355);

(statearr_25691_25846[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (42))){
var state_25523__$1 = state_25523;
var statearr_25692_25847 = state_25523__$1;
(statearr_25692_25847[(2)] = from);

(statearr_25692_25847[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (80))){
var inst_25376 = (state_25523[(2)]);
var inst_25377 = fluree.db.query.range.collection.call(null,db,from,inst_25376);
var state_25523__$1 = state_25523;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25523__$1,(81),inst_25377);
} else {
if((state_val_25524 === (37))){
var state_25523__$1 = state_25523;
var statearr_25693_25848 = state_25523__$1;
(statearr_25693_25848[(2)] = null);

(statearr_25693_25848[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (63))){
var inst_25337 = (state_25523[(2)]);
var inst_25338 = fluree.db.util.async.throw_err.call(null,inst_25337);
var state_25523__$1 = state_25523;
var statearr_25694_25849 = state_25523__$1;
(statearr_25694_25849[(2)] = inst_25338);

(statearr_25694_25849[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (94))){
var inst_25424 = from;
var inst_25425 = cljs.core.seq.call(null,inst_25424);
var inst_25426 = cljs.core.first.call(null,inst_25425);
var inst_25427 = cljs.core.next.call(null,inst_25425);
var inst_25428 = cljs.core.PersistentVector.EMPTY;
var inst_25429 = inst_25424;
var inst_25430 = inst_25428;
var state_25523__$1 = (function (){var statearr_25695 = state_25523;
(statearr_25695[(38)] = inst_25427);

(statearr_25695[(13)] = inst_25430);

(statearr_25695[(32)] = inst_25429);

(statearr_25695[(39)] = inst_25426);

return statearr_25695;
})();
var statearr_25696_25850 = state_25523__$1;
(statearr_25696_25850[(2)] = null);

(statearr_25696_25850[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (8))){
var inst_25210 = (state_25523[(27)]);
var inst_25209 = (state_25523[(2)]);
var inst_25210__$1 = opts_SINGLEQUOTE__SINGLEQUOTE_;
var inst_25212 = (inst_25210__$1 == null);
var inst_25213 = cljs.core.not.call(null,inst_25212);
var state_25523__$1 = (function (){var statearr_25697 = state_25523;
(statearr_25697[(27)] = inst_25210__$1);

(statearr_25697[(35)] = inst_25209);

return statearr_25697;
})();
if(inst_25213){
var statearr_25698_25851 = state_25523__$1;
(statearr_25698_25851[(1)] = (15));

} else {
var statearr_25699_25852 = state_25523__$1;
(statearr_25699_25852[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25524 === (49))){
var inst_25243 = (state_25523[(9)]);
var inst_25235 = (state_25523[(17)]);
var inst_25245 = (state_25523[(11)]);
var inst_25290 = (state_25523[(37)]);
var inst_25294 = (state_25523[(2)]);
var inst_25295 = fluree.db.query.fql.subject_select.call(null,db,inst_25245,fuel,max_fuel,inst_25243,inst_25290,inst_25294,inst_25235);
var state_25523__$1 = state_25523;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25523__$1,(46),inst_25295);
} else {
if((state_val_25524 === (84))){
var inst_25413 = cljs.core.sequential_QMARK_.call(null,from);
var inst_25414 = cljs.core.every_QMARK_.call(null,fluree.db.util.core.subj_ident_QMARK_,from);
var inst_25415 = ((inst_25413) && (inst_25414));
var state_25523__$1 = state_25523;
if(cljs.core.truth_(inst_25415)){
var statearr_25700_25853 = state_25523__$1;
(statearr_25700_25853[(1)] = (94));

} else {
var statearr_25701_25854 = state_25523__$1;
(statearr_25701_25854[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$query_$_state_machine__2468__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__2468__auto____0 = (function (){
var statearr_25702 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25702[(0)] = fluree$db$query$fql$query_$_state_machine__2468__auto__);

(statearr_25702[(1)] = (1));

return statearr_25702;
});
var fluree$db$query$fql$query_$_state_machine__2468__auto____1 = (function (state_25523){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_25523);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e25703){var ex__2471__auto__ = e25703;
var statearr_25704_25855 = state_25523;
(statearr_25704_25855[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_25523[(4)]))){
var statearr_25705_25856 = state_25523;
(statearr_25705_25856[(1)] = cljs.core.first.call(null,(state_25523[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25857 = state_25523;
state_25523 = G__25857;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__2468__auto__ = function(state_25523){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__2468__auto____1.call(this,state_25523);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__2468__auto____0;
fluree$db$query$fql$query_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__2468__auto____1;
return fluree$db$query$fql$query_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_25706 = f__2491__auto__.call(null);
(statearr_25706[(6)] = c__2490__auto__);

return statearr_25706;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}

});

//# sourceMappingURL=fql.js.map
