// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('tailrecursion.priority_map');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core');
goog.require('cljs.reader');

/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
tailrecursion.priority_map.PersistentPriorityMap = (function (priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
this.priority__GT_set_of_items = priority__GT_set_of_items;
this.item__GT_priority = item__GT_priority;
this.meta = meta;
this.keyfn = keyfn;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2565220111;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item);
});

tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,item,not_found){
var self__ = this;
var coll__$1 = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,not_found);
});

tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var self__ = this;
var coll__$1 = this;
var pr_pair = ((function (coll__$1){
return (function (keyval){
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,""," ","",opts,keyval);
});})(coll__$1))
;
return cljs.core.pr_sequential_writer(writer,pr_pair,"#tailrecursion.priority-map {",", ","}",opts,coll__$1);
});

tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.meta;
});

tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.count(self__.item__GT_priority);
});

tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_peek$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count(self__.item__GT_priority) === (0))){
return null;
} else {
var f = cljs.core.first(self__.priority__GT_set_of_items);
var item = cljs.core.first(cljs.core.val(f));
if(cljs.core.truth_(self__.keyfn)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,cljs.core.key(f)], null);
}
}
});

tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_pop$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count(self__.item__GT_priority) === (0))){
throw (new Error("Can't pop empty priority map"));
} else {
var f = cljs.core.first(self__.priority__GT_set_of_items);
var item_set = cljs.core.val(f);
var item = cljs.core.first(item_set);
var priority_key = cljs.core.key(f);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(item_set,item)),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
});

tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4523__auto__ = ((function (coll__$1){
return (function tailrecursion$priority_map$iter__112946(s__112947){
return (new cljs.core.LazySeq(null,((function (coll__$1){
return (function (){
var s__112947__$1 = s__112947;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__112947__$1);
if(temp__5735__auto__){
var xs__6292__auto__ = temp__5735__auto__;
var vec__112952 = cljs.core.first(xs__6292__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__112952,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__112952,(1),null);
var iterys__4519__auto__ = ((function (s__112947__$1,vec__112952,priority,item_set,xs__6292__auto__,temp__5735__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__112946_$_iter__112948(s__112949){
return (new cljs.core.LazySeq(null,((function (s__112947__$1,vec__112952,priority,item_set,xs__6292__auto__,temp__5735__auto__,coll__$1){
return (function (){
var s__112949__$1 = s__112949;
while(true){
var temp__5735__auto____$1 = cljs.core.seq(s__112949__$1);
if(temp__5735__auto____$1){
var s__112949__$2 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__112949__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__112949__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__112951 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__112950 = (0);
while(true){
if((i__112950 < size__4522__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__112950);
cljs.core.chunk_append(b__112951,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__113004 = (i__112950 + (1));
i__112950 = G__113004;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__112951),tailrecursion$priority_map$iter__112946_$_iter__112948(cljs.core.chunk_rest(s__112949__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__112951),null);
}
} else {
var item = cljs.core.first(s__112949__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__112946_$_iter__112948(cljs.core.rest(s__112949__$2)));
}
} else {
return null;
}
break;
}
});})(s__112947__$1,vec__112952,priority,item_set,xs__6292__auto__,temp__5735__auto__,coll__$1))
,null,null));
});})(s__112947__$1,vec__112952,priority,item_set,xs__6292__auto__,temp__5735__auto__,coll__$1))
;
var fs__4520__auto__ = cljs.core.seq(iterys__4519__auto__(item_set));
if(fs__4520__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4520__auto__,tailrecursion$priority_map$iter__112946(cljs.core.rest(s__112947__$1)));
} else {
var G__113005 = cljs.core.rest(s__112947__$1);
s__112947__$1 = G__113005;
continue;
}
} else {
return null;
}
break;
}
});})(coll__$1))
,null,null));
});})(coll__$1))
;
return iter__4523__auto__(cljs.core.rseq(self__.priority__GT_set_of_items));
})());
} else {
return cljs.core.seq((function (){var iter__4523__auto__ = ((function (coll__$1){
return (function tailrecursion$priority_map$iter__112955(s__112956){
return (new cljs.core.LazySeq(null,((function (coll__$1){
return (function (){
var s__112956__$1 = s__112956;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__112956__$1);
if(temp__5735__auto__){
var xs__6292__auto__ = temp__5735__auto__;
var vec__112961 = cljs.core.first(xs__6292__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__112961,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__112961,(1),null);
var iterys__4519__auto__ = ((function (s__112956__$1,vec__112961,priority,item_set,xs__6292__auto__,temp__5735__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__112955_$_iter__112957(s__112958){
return (new cljs.core.LazySeq(null,((function (s__112956__$1,vec__112961,priority,item_set,xs__6292__auto__,temp__5735__auto__,coll__$1){
return (function (){
var s__112958__$1 = s__112958;
while(true){
var temp__5735__auto____$1 = cljs.core.seq(s__112958__$1);
if(temp__5735__auto____$1){
var s__112958__$2 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__112958__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__112958__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__112960 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__112959 = (0);
while(true){
if((i__112959 < size__4522__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__112959);
cljs.core.chunk_append(b__112960,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__113006 = (i__112959 + (1));
i__112959 = G__113006;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__112960),tailrecursion$priority_map$iter__112955_$_iter__112957(cljs.core.chunk_rest(s__112958__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__112960),null);
}
} else {
var item = cljs.core.first(s__112958__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__112955_$_iter__112957(cljs.core.rest(s__112958__$2)));
}
} else {
return null;
}
break;
}
});})(s__112956__$1,vec__112961,priority,item_set,xs__6292__auto__,temp__5735__auto__,coll__$1))
,null,null));
});})(s__112956__$1,vec__112961,priority,item_set,xs__6292__auto__,temp__5735__auto__,coll__$1))
;
var fs__4520__auto__ = cljs.core.seq(iterys__4519__auto__(item_set));
if(fs__4520__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4520__auto__,tailrecursion$priority_map$iter__112955(cljs.core.rest(s__112956__$1)));
} else {
var G__113007 = cljs.core.rest(s__112956__$1);
s__112956__$1 = G__113007;
continue;
}
} else {
return null;
}
break;
}
});})(coll__$1))
,null,null));
});})(coll__$1))
;
return iter__4523__auto__(cljs.core.rseq(self__.priority__GT_set_of_items));
})());
}
});

tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = cljs.core.hash_unordered_coll(this$__$1);
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
return cljs.core._equiv(self__.item__GT_priority,other);
});

tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.with_meta(tailrecursion.priority_map.PersistentPriorityMap.EMPTY,self__.meta);
});

tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
var priority = (function (){var G__112964 = item;
var G__112965 = cljs.core.cst$kw$tailrecursion$priority_DASH_map_SLASH_not_DASH_found;
return (self__.item__GT_priority.cljs$core$IFn$_invoke$arity$2 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$2(G__112964,G__112965) : self__.item__GT_priority.call(null,G__112964,G__112965));
})();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(priority,cljs.core.cst$kw$tailrecursion$priority_DASH_map_SLASH_not_DASH_found)){
return this$__$1;
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
var item_set = (self__.priority__GT_set_of_items.cljs$core$IFn$_invoke$arity$1 ? self__.priority__GT_set_of_items.cljs$core$IFn$_invoke$arity$1(priority_key) : self__.priority__GT_set_of_items.call(null,priority_key));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(item_set,item)),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
});

tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this$,item,priority){
var self__ = this;
var this$__$1 = this;
var temp__5733__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,null);
if(cljs.core.truth_(temp__5733__auto__)){
var current_priority = temp__5733__auto__;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(current_priority,priority)){
return this$__$1;
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
var current_priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(current_priority) : self__.keyfn.call(null,current_priority));
var item_set = cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key),priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(self__.priority__GT_set_of_items,current_priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key),item),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)], 0)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
});

tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.contains_QMARK_(self__.item__GT_priority,item);
});

tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4523__auto__ = ((function (this$__$1){
return (function tailrecursion$priority_map$iter__112966(s__112967){
return (new cljs.core.LazySeq(null,((function (this$__$1){
return (function (){
var s__112967__$1 = s__112967;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__112967__$1);
if(temp__5735__auto__){
var xs__6292__auto__ = temp__5735__auto__;
var vec__112972 = cljs.core.first(xs__6292__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__112972,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__112972,(1),null);
var iterys__4519__auto__ = ((function (s__112967__$1,vec__112972,priority,item_set,xs__6292__auto__,temp__5735__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__112966_$_iter__112968(s__112969){
return (new cljs.core.LazySeq(null,((function (s__112967__$1,vec__112972,priority,item_set,xs__6292__auto__,temp__5735__auto__,this$__$1){
return (function (){
var s__112969__$1 = s__112969;
while(true){
var temp__5735__auto____$1 = cljs.core.seq(s__112969__$1);
if(temp__5735__auto____$1){
var s__112969__$2 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__112969__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__112969__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__112971 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__112970 = (0);
while(true){
if((i__112970 < size__4522__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__112970);
cljs.core.chunk_append(b__112971,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__113008 = (i__112970 + (1));
i__112970 = G__113008;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__112971),tailrecursion$priority_map$iter__112966_$_iter__112968(cljs.core.chunk_rest(s__112969__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__112971),null);
}
} else {
var item = cljs.core.first(s__112969__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__112966_$_iter__112968(cljs.core.rest(s__112969__$2)));
}
} else {
return null;
}
break;
}
});})(s__112967__$1,vec__112972,priority,item_set,xs__6292__auto__,temp__5735__auto__,this$__$1))
,null,null));
});})(s__112967__$1,vec__112972,priority,item_set,xs__6292__auto__,temp__5735__auto__,this$__$1))
;
var fs__4520__auto__ = cljs.core.seq(iterys__4519__auto__(item_set));
if(fs__4520__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4520__auto__,tailrecursion$priority_map$iter__112966(cljs.core.rest(s__112967__$1)));
} else {
var G__113009 = cljs.core.rest(s__112967__$1);
s__112967__$1 = G__113009;
continue;
}
} else {
return null;
}
break;
}
});})(this$__$1))
,null,null));
});})(this$__$1))
;
return iter__4523__auto__(self__.priority__GT_set_of_items);
})());
} else {
return cljs.core.seq((function (){var iter__4523__auto__ = ((function (this$__$1){
return (function tailrecursion$priority_map$iter__112975(s__112976){
return (new cljs.core.LazySeq(null,((function (this$__$1){
return (function (){
var s__112976__$1 = s__112976;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__112976__$1);
if(temp__5735__auto__){
var xs__6292__auto__ = temp__5735__auto__;
var vec__112981 = cljs.core.first(xs__6292__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__112981,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__112981,(1),null);
var iterys__4519__auto__ = ((function (s__112976__$1,vec__112981,priority,item_set,xs__6292__auto__,temp__5735__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__112975_$_iter__112977(s__112978){
return (new cljs.core.LazySeq(null,((function (s__112976__$1,vec__112981,priority,item_set,xs__6292__auto__,temp__5735__auto__,this$__$1){
return (function (){
var s__112978__$1 = s__112978;
while(true){
var temp__5735__auto____$1 = cljs.core.seq(s__112978__$1);
if(temp__5735__auto____$1){
var s__112978__$2 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__112978__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__112978__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__112980 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__112979 = (0);
while(true){
if((i__112979 < size__4522__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__112979);
cljs.core.chunk_append(b__112980,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__113010 = (i__112979 + (1));
i__112979 = G__113010;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__112980),tailrecursion$priority_map$iter__112975_$_iter__112977(cljs.core.chunk_rest(s__112978__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__112980),null);
}
} else {
var item = cljs.core.first(s__112978__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__112975_$_iter__112977(cljs.core.rest(s__112978__$2)));
}
} else {
return null;
}
break;
}
});})(s__112976__$1,vec__112981,priority,item_set,xs__6292__auto__,temp__5735__auto__,this$__$1))
,null,null));
});})(s__112976__$1,vec__112981,priority,item_set,xs__6292__auto__,temp__5735__auto__,this$__$1))
;
var fs__4520__auto__ = cljs.core.seq(iterys__4519__auto__(item_set));
if(fs__4520__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4520__auto__,tailrecursion$priority_map$iter__112975(cljs.core.rest(s__112976__$1)));
} else {
var G__113011 = cljs.core.rest(s__112976__$1);
s__112976__$1 = G__113011;
continue;
}
} else {
return null;
}
break;
}
});})(this$__$1))
,null,null));
});})(this$__$1))
;
return iter__4523__auto__(self__.priority__GT_set_of_items);
})());
}
});

tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this$,meta__$1){
var self__ = this;
var this$__$1 = this;
return (new tailrecursion.priority_map.PersistentPriorityMap(self__.priority__GT_set_of_items,self__.item__GT_priority,meta__$1,self__.keyfn,self__.__hash));
});

tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return this$__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this$__$1,entry);
}
});

tailrecursion.priority_map.PersistentPriorityMap.prototype.call = (function() {
var G__113012 = null;
var G__113012__2 = (function (self__,item){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return this$.cljs$core$ILookup$_lookup$arity$2(null,item);
});
var G__113012__3 = (function (self__,item,not_found){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return this$.cljs$core$ILookup$_lookup$arity$3(null,item,not_found);
});
G__113012 = function(self__,item,not_found){
switch(arguments.length){
case 2:
return G__113012__2.call(this,self__,item);
case 3:
return G__113012__3.call(this,self__,item,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__113012.cljs$core$IFn$_invoke$arity$2 = G__113012__2;
G__113012.cljs$core$IFn$_invoke$arity$3 = G__113012__3;
return G__113012;
})()
;

tailrecursion.priority_map.PersistentPriorityMap.prototype.apply = (function (self__,args112945){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args112945)));
});

tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (item){
var self__ = this;
var this$ = this;
return this$.cljs$core$ILookup$_lookup$arity$2(null,item);
});

tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (item,not_found){
var self__ = this;
var this$ = this;
return this$.cljs$core$ILookup$_lookup$arity$3(null,item,not_found);
});

tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (this$,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var fexpr__112984 = (cljs.core.truth_(ascending_QMARK_)?cljs.core.seq:cljs.core.rseq);
return (fexpr__112984.cljs$core$IFn$_invoke$arity$1 ? fexpr__112984.cljs$core$IFn$_invoke$arity$1(this$__$1) : fexpr__112984.call(null,this$__$1));
});

tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (this$,k,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var sets = (cljs.core.truth_(ascending_QMARK_)?cljs.core.subseq.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,cljs.core._GT__EQ_,k):cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,cljs.core._LT__EQ_,k));
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4523__auto__ = ((function (sets,this$__$1){
return (function tailrecursion$priority_map$iter__112985(s__112986){
return (new cljs.core.LazySeq(null,((function (sets,this$__$1){
return (function (){
var s__112986__$1 = s__112986;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__112986__$1);
if(temp__5735__auto__){
var xs__6292__auto__ = temp__5735__auto__;
var vec__112991 = cljs.core.first(xs__6292__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__112991,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__112991,(1),null);
var iterys__4519__auto__ = ((function (s__112986__$1,vec__112991,priority,item_set,xs__6292__auto__,temp__5735__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__112985_$_iter__112987(s__112988){
return (new cljs.core.LazySeq(null,((function (s__112986__$1,vec__112991,priority,item_set,xs__6292__auto__,temp__5735__auto__,sets,this$__$1){
return (function (){
var s__112988__$1 = s__112988;
while(true){
var temp__5735__auto____$1 = cljs.core.seq(s__112988__$1);
if(temp__5735__auto____$1){
var s__112988__$2 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__112988__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__112988__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__112990 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__112989 = (0);
while(true){
if((i__112989 < size__4522__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__112989);
cljs.core.chunk_append(b__112990,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__113013 = (i__112989 + (1));
i__112989 = G__113013;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__112990),tailrecursion$priority_map$iter__112985_$_iter__112987(cljs.core.chunk_rest(s__112988__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__112990),null);
}
} else {
var item = cljs.core.first(s__112988__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__112985_$_iter__112987(cljs.core.rest(s__112988__$2)));
}
} else {
return null;
}
break;
}
});})(s__112986__$1,vec__112991,priority,item_set,xs__6292__auto__,temp__5735__auto__,sets,this$__$1))
,null,null));
});})(s__112986__$1,vec__112991,priority,item_set,xs__6292__auto__,temp__5735__auto__,sets,this$__$1))
;
var fs__4520__auto__ = cljs.core.seq(iterys__4519__auto__(item_set));
if(fs__4520__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4520__auto__,tailrecursion$priority_map$iter__112985(cljs.core.rest(s__112986__$1)));
} else {
var G__113014 = cljs.core.rest(s__112986__$1);
s__112986__$1 = G__113014;
continue;
}
} else {
return null;
}
break;
}
});})(sets,this$__$1))
,null,null));
});})(sets,this$__$1))
;
return iter__4523__auto__(sets);
})());
} else {
return cljs.core.seq((function (){var iter__4523__auto__ = ((function (sets,this$__$1){
return (function tailrecursion$priority_map$iter__112994(s__112995){
return (new cljs.core.LazySeq(null,((function (sets,this$__$1){
return (function (){
var s__112995__$1 = s__112995;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__112995__$1);
if(temp__5735__auto__){
var xs__6292__auto__ = temp__5735__auto__;
var vec__113000 = cljs.core.first(xs__6292__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__113000,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__113000,(1),null);
var iterys__4519__auto__ = ((function (s__112995__$1,vec__113000,priority,item_set,xs__6292__auto__,temp__5735__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__112994_$_iter__112996(s__112997){
return (new cljs.core.LazySeq(null,((function (s__112995__$1,vec__113000,priority,item_set,xs__6292__auto__,temp__5735__auto__,sets,this$__$1){
return (function (){
var s__112997__$1 = s__112997;
while(true){
var temp__5735__auto____$1 = cljs.core.seq(s__112997__$1);
if(temp__5735__auto____$1){
var s__112997__$2 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__112997__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__112997__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__112999 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__112998 = (0);
while(true){
if((i__112998 < size__4522__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__112998);
cljs.core.chunk_append(b__112999,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__113015 = (i__112998 + (1));
i__112998 = G__113015;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__112999),tailrecursion$priority_map$iter__112994_$_iter__112996(cljs.core.chunk_rest(s__112997__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__112999),null);
}
} else {
var item = cljs.core.first(s__112997__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__112994_$_iter__112996(cljs.core.rest(s__112997__$2)));
}
} else {
return null;
}
break;
}
});})(s__112995__$1,vec__113000,priority,item_set,xs__6292__auto__,temp__5735__auto__,sets,this$__$1))
,null,null));
});})(s__112995__$1,vec__113000,priority,item_set,xs__6292__auto__,temp__5735__auto__,sets,this$__$1))
;
var fs__4520__auto__ = cljs.core.seq(iterys__4519__auto__(item_set));
if(fs__4520__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4520__auto__,tailrecursion$priority_map$iter__112994(cljs.core.rest(s__112995__$1)));
} else {
var G__113016 = cljs.core.rest(s__112995__$1);
s__112995__$1 = G__113016;
continue;
}
} else {
return null;
}
break;
}
});})(sets,this$__$1))
,null,null));
});})(sets,this$__$1))
;
return iter__4523__auto__(sets);
})());
}
});

tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
var G__113003 = cljs.core.val(entry);
return (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(G__113003) : self__.keyfn.call(null,G__113003));
});

tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.compare;
});

tailrecursion.priority_map.PersistentPriorityMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$priority_DASH__GT_set_DASH_of_DASH_items,cljs.core.cst$sym$item_DASH__GT_priority,cljs.core.cst$sym$meta,cljs.core.cst$sym$keyfn,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$type = true;

tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorStr = "tailrecursion.priority-map/PersistentPriorityMap";

tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"tailrecursion.priority-map/PersistentPriorityMap");
});

/**
 * Positional factory function for tailrecursion.priority-map/PersistentPriorityMap.
 */
tailrecursion.priority_map.__GT_PersistentPriorityMap = (function tailrecursion$priority_map$__GT_PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
return (new tailrecursion.priority_map.PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash));
});

tailrecursion.priority_map.PersistentPriorityMap.EMPTY = (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map(),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null));
tailrecursion.priority_map.pm_empty_by = (function tailrecursion$priority_map$pm_empty_by(comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by(comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null));
});
tailrecursion.priority_map.pm_empty_keyfn = (function tailrecursion$priority_map$pm_empty_keyfn(var_args){
var G__113018 = arguments.length;
switch (G__113018) {
case 1:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1 = (function (keyfn){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map(),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
});

tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by(comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
});

tailrecursion.priority_map.pm_empty_keyfn.cljs$lang$maxFixedArity = 2;

tailrecursion.priority_map.read_priority_map = (function tailrecursion$priority_map$read_priority_map(elems){
if(cljs.core.map_QMARK_(elems)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(tailrecursion.priority_map.PersistentPriorityMap.EMPTY,elems);
} else {
throw Error("Priority map literal expects a map for its elements.");
}
});
cljs.reader.register_tag_parser_BANG_("tailrecursion.priority-map",tailrecursion.priority_map.read_priority_map);
/**
 * keyval => key val
 *   Returns a new priority map with supplied mappings.
 */
tailrecursion.priority_map.priority_map = (function tailrecursion$priority_map$priority_map(var_args){
var args__4736__auto__ = [];
var len__4730__auto___113021 = arguments.length;
var i__4731__auto___113022 = (0);
while(true){
if((i__4731__auto___113022 < len__4730__auto___113021)){
args__4736__auto__.push((arguments[i__4731__auto___113022]));

var G__113023 = (i__4731__auto___113022 + (1));
i__4731__auto___113022 = G__113023;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.PersistentPriorityMap.EMPTY;
while(true){
if(in$){
var G__113024 = cljs.core.nnext(in$);
var G__113025 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__113024;
out = G__113025;
continue;
} else {
return out;
}
break;
}
});

tailrecursion.priority_map.priority_map.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
tailrecursion.priority_map.priority_map.cljs$lang$applyTo = (function (seq113020){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq113020));
});

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied comparator.
 */
tailrecursion.priority_map.priority_map_by = (function tailrecursion$priority_map$priority_map_by(var_args){
var args__4736__auto__ = [];
var len__4730__auto___113028 = arguments.length;
var i__4731__auto___113029 = (0);
while(true){
if((i__4731__auto___113029 < len__4730__auto___113028)){
args__4736__auto__.push((arguments[i__4731__auto___113029]));

var G__113030 = (i__4731__auto___113029 + (1));
i__4731__auto___113029 = G__113030;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_by(comparator);
while(true){
if(in$){
var G__113031 = cljs.core.nnext(in$);
var G__113032 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__113031;
out = G__113032;
continue;
} else {
return out;
}
break;
}
});

tailrecursion.priority_map.priority_map_by.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
tailrecursion.priority_map.priority_map_by.cljs$lang$applyTo = (function (seq113026){
var G__113027 = cljs.core.first(seq113026);
var seq113026__$1 = cljs.core.next(seq113026);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__113027,seq113026__$1);
});

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn.
 */
tailrecursion.priority_map.priority_map_keyfn = (function tailrecursion$priority_map$priority_map_keyfn(var_args){
var args__4736__auto__ = [];
var len__4730__auto___113035 = arguments.length;
var i__4731__auto___113036 = (0);
while(true){
if((i__4731__auto___113036 < len__4730__auto___113035)){
args__4736__auto__.push((arguments[i__4731__auto___113036]));

var G__113037 = (i__4731__auto___113036 + (1));
i__4731__auto___113036 = G__113037;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1(keyfn);
while(true){
if(in$){
var G__113038 = cljs.core.nnext(in$);
var G__113039 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__113038;
out = G__113039;
continue;
} else {
return out;
}
break;
}
});

tailrecursion.priority_map.priority_map_keyfn.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
tailrecursion.priority_map.priority_map_keyfn.cljs$lang$applyTo = (function (seq113033){
var G__113034 = cljs.core.first(seq113033);
var seq113033__$1 = cljs.core.next(seq113033);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__113034,seq113033__$1);
});

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn and comparator.
 */
tailrecursion.priority_map.priority_map_keyfn_by = (function tailrecursion$priority_map$priority_map_keyfn_by(var_args){
var args__4736__auto__ = [];
var len__4730__auto___113043 = arguments.length;
var i__4731__auto___113044 = (0);
while(true){
if((i__4731__auto___113044 < len__4730__auto___113043)){
args__4736__auto__.push((arguments[i__4731__auto___113044]));

var G__113045 = (i__4731__auto___113044 + (1));
i__4731__auto___113044 = G__113045;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2(keyfn,comparator);
while(true){
if(in$){
var G__113046 = cljs.core.nnext(in$);
var G__113047 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__113046;
out = G__113047;
continue;
} else {
return out;
}
break;
}
});

tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$applyTo = (function (seq113040){
var G__113041 = cljs.core.first(seq113040);
var seq113040__$1 = cljs.core.next(seq113040);
var G__113042 = cljs.core.first(seq113040__$1);
var seq113040__$2 = cljs.core.next(seq113040__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__113041,G__113042,seq113040__$2);
});


//# sourceMappingURL=priority_map.js.map?rel=1593117273948
