// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches(/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_db], null));
}
});
/**
 * Returns two-tuple of [network name-or-dbid] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__111423 = cljs.core.re_find(/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str(ledger));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__111423,(0),null);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__111423,(1),null);
var maybe_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__111423,(2),null);
if(cljs.core.truth_((function (){var and__4120__auto__ = network;
if(cljs.core.truth_(and__4120__auto__)){
return maybe_alias;
} else {
return and__4120__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_ledger_DASH_name], null));
}
});
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(106)]);
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_111517){
var state_val_111518 = (state_111517[(1)]);
if((state_val_111518 === (7))){
var state_111517__$1 = state_111517;
var statearr_111519_111558 = state_111517__$1;
(statearr_111519_111558[(2)] = false);

(statearr_111519_111558[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111518 === (20))){
var inst_111481 = (state_111517[(2)]);
var state_111517__$1 = state_111517;
var statearr_111520_111559 = state_111517__$1;
(statearr_111520_111559[(2)] = inst_111481);

(statearr_111520_111559[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111518 === (1))){
var state_111517__$1 = state_111517;
var statearr_111521_111560 = state_111517__$1;
(statearr_111521_111560[(2)] = null);

(statearr_111521_111560[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111518 === (24))){
var inst_111494 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_111495 = [cljs.core.cst$kw$error,cljs.core.cst$kw$status];
var inst_111496 = [cljs.core.cst$kw$db_SLASH_max_DASH_novelty_DASH_size,(400)];
var inst_111497 = cljs.core.PersistentHashMap.fromArrays(inst_111495,inst_111496);
var inst_111498 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_111494,inst_111497);
var inst_111499 = (function(){throw inst_111498})();
var state_111517__$1 = state_111517;
var statearr_111522_111561 = state_111517__$1;
(statearr_111522_111561[(2)] = inst_111499);

(statearr_111522_111561[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111518 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_111517,(3),Error,null,(2));
var inst_111432 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_111433 = [pred_id];
var inst_111434 = (new cljs.core.PersistentVector(null,1,(5),inst_111432,inst_111433,null));
var inst_111435 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_111434);
var state_111517__$1 = state_111517;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_111517__$1,(5),inst_111435);
} else {
if((state_val_111518 === (15))){
var inst_111468 = (state_111517[(7)]);
var inst_111473 = inst_111468.cljs$lang$protocol_mask$partition0$;
var inst_111474 = (inst_111473 & (64));
var inst_111475 = inst_111468.cljs$core$ISeq$;
var inst_111476 = (cljs.core.PROTOCOL_SENTINEL === inst_111475);
var inst_111477 = ((inst_111474) || (inst_111476));
var state_111517__$1 = state_111517;
if(cljs.core.truth_(inst_111477)){
var statearr_111523_111562 = state_111517__$1;
(statearr_111523_111562[(1)] = (18));

} else {
var statearr_111524_111563 = state_111517__$1;
(statearr_111524_111563[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111518 === (21))){
var inst_111468 = (state_111517[(7)]);
var inst_111486 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_111468);
var state_111517__$1 = state_111517;
var statearr_111525_111564 = state_111517__$1;
(statearr_111525_111564[(2)] = inst_111486);

(statearr_111525_111564[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111518 === (13))){
var inst_111439 = (state_111517[(8)]);
var state_111517__$1 = state_111517;
var statearr_111526_111565 = state_111517__$1;
(statearr_111526_111565[(2)] = inst_111439);

(statearr_111526_111565[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111518 === (22))){
var inst_111468 = (state_111517[(7)]);
var state_111517__$1 = state_111517;
var statearr_111527_111566 = state_111517__$1;
(statearr_111527_111566[(2)] = inst_111468);

(statearr_111527_111566[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111518 === (6))){
var inst_111439 = (state_111517[(8)]);
var inst_111444 = inst_111439.cljs$lang$protocol_mask$partition0$;
var inst_111445 = (inst_111444 & (64));
var inst_111446 = inst_111439.cljs$core$ISeq$;
var inst_111447 = (cljs.core.PROTOCOL_SENTINEL === inst_111446);
var inst_111448 = ((inst_111445) || (inst_111447));
var state_111517__$1 = state_111517;
if(cljs.core.truth_(inst_111448)){
var statearr_111528_111567 = state_111517__$1;
(statearr_111528_111567[(1)] = (9));

} else {
var statearr_111529_111568 = state_111517__$1;
(statearr_111529_111568[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111518 === (25))){
var state_111517__$1 = state_111517;
var statearr_111530_111569 = state_111517__$1;
(statearr_111530_111569[(2)] = null);

(statearr_111530_111569[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111518 === (17))){
var inst_111484 = (state_111517[(2)]);
var state_111517__$1 = state_111517;
if(cljs.core.truth_(inst_111484)){
var statearr_111531_111570 = state_111517__$1;
(statearr_111531_111570[(1)] = (21));

} else {
var statearr_111532_111571 = state_111517__$1;
(statearr_111532_111571[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111518 === (3))){
var inst_111426 = (state_111517[(2)]);
var state_111517__$1 = state_111517;
var statearr_111533_111572 = state_111517__$1;
(statearr_111533_111572[(2)] = inst_111426);


cljs.core.async.impl.ioc_helpers.process_exception(state_111517__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_111518 === (12))){
var inst_111439 = (state_111517[(8)]);
var inst_111457 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_111439);
var state_111517__$1 = state_111517;
var statearr_111534_111573 = state_111517__$1;
(statearr_111534_111573[(2)] = inst_111457);

(statearr_111534_111573[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111518 === (2))){
var inst_111515 = (state_111517[(2)]);
var state_111517__$1 = state_111517;
return cljs.core.async.impl.ioc_helpers.return_chan(state_111517__$1,inst_111515);
} else {
if((state_val_111518 === (23))){
var inst_111464 = (state_111517[(9)]);
var inst_111489 = (state_111517[(2)]);
var inst_111490 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_111489,cljs.core.cst$kw$novelty_DASH_min);
var inst_111491 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_111489,cljs.core.cst$kw$novelty_DASH_max);
var inst_111492 = (inst_111464 > inst_111491);
var state_111517__$1 = (function (){var statearr_111535 = state_111517;
(statearr_111535[(10)] = inst_111490);

return statearr_111535;
})();
if(cljs.core.truth_(inst_111492)){
var statearr_111536_111574 = state_111517__$1;
(statearr_111536_111574[(1)] = (24));

} else {
var statearr_111537_111575 = state_111517__$1;
(statearr_111537_111575[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111518 === (19))){
var state_111517__$1 = state_111517;
var statearr_111538_111576 = state_111517__$1;
(statearr_111538_111576[(2)] = false);

(statearr_111538_111576[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111518 === (11))){
var inst_111452 = (state_111517[(2)]);
var state_111517__$1 = state_111517;
var statearr_111539_111577 = state_111517__$1;
(statearr_111539_111577[(2)] = inst_111452);

(statearr_111539_111577[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111518 === (9))){
var state_111517__$1 = state_111517;
var statearr_111540_111578 = state_111517__$1;
(statearr_111540_111578[(2)] = true);

(statearr_111540_111578[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111518 === (5))){
var inst_111439 = (state_111517[(8)]);
var inst_111437 = (state_111517[(2)]);
var inst_111438 = fluree.db.util.async.throw_err(inst_111437);
var inst_111439__$1 = cljs.core.cst$kw$novelty.cljs$core$IFn$_invoke$arity$1(db);
var inst_111441 = (inst_111439__$1 == null);
var inst_111442 = cljs.core.not(inst_111441);
var state_111517__$1 = (function (){var statearr_111541 = state_111517;
(statearr_111541[(8)] = inst_111439__$1);

(statearr_111541[(11)] = inst_111438);

return statearr_111541;
})();
if(inst_111442){
var statearr_111542_111579 = state_111517__$1;
(statearr_111542_111579[(1)] = (6));

} else {
var statearr_111543_111580 = state_111517__$1;
(statearr_111543_111580[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111518 === (14))){
var inst_111468 = (state_111517[(7)]);
var inst_111438 = (state_111517[(11)]);
var inst_111460 = (state_111517[(2)]);
var inst_111461 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_111460,cljs.core.cst$kw$post);
var inst_111462 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_111460,cljs.core.cst$kw$size);
var inst_111463 = fluree.db.flake.size_bytes(inst_111438);
var inst_111464 = (inst_111462 + inst_111463);
var inst_111465 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_111466 = [cljs.core.cst$kw$conn,cljs.core.cst$kw$meta];
var inst_111467 = (new cljs.core.PersistentVector(null,2,(5),inst_111465,inst_111466,null));
var inst_111468__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_111467);
var inst_111470 = (inst_111468__$1 == null);
var inst_111471 = cljs.core.not(inst_111470);
var state_111517__$1 = (function (){var statearr_111544 = state_111517;
(statearr_111544[(12)] = inst_111461);

(statearr_111544[(7)] = inst_111468__$1);

(statearr_111544[(9)] = inst_111464);

return statearr_111544;
})();
if(inst_111471){
var statearr_111545_111581 = state_111517__$1;
(statearr_111545_111581[(1)] = (15));

} else {
var statearr_111546_111582 = state_111517__$1;
(statearr_111546_111582[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111518 === (26))){
var inst_111461 = (state_111517[(12)]);
var inst_111464 = (state_111517[(9)]);
var inst_111438 = (state_111517[(11)]);
var inst_111502 = (state_111517[(2)]);
var inst_111503 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_111461,inst_111438);
var inst_111504 = cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(db);
var inst_111505 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_111504,cljs.core.empty);
var inst_111506 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_111507 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$post];
var inst_111508 = (new cljs.core.PersistentVector(null,2,(5),inst_111506,inst_111507,null));
var inst_111509 = cljs.core.assoc_in(db,inst_111508,inst_111503);
var inst_111510 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_111511 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$size];
var inst_111512 = (new cljs.core.PersistentVector(null,2,(5),inst_111510,inst_111511,null));
var inst_111513 = cljs.core.assoc_in(inst_111509,inst_111512,inst_111464);
var state_111517__$1 = (function (){var statearr_111547 = state_111517;
(statearr_111547[(13)] = inst_111505);

(statearr_111547[(14)] = inst_111502);

return statearr_111547;
})();
var statearr_111548_111583 = state_111517__$1;
(statearr_111548_111583[(2)] = inst_111513);


cljs.core.async.impl.ioc_helpers.process_exception(state_111517__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_111518 === (16))){
var state_111517__$1 = state_111517;
var statearr_111549_111584 = state_111517__$1;
(statearr_111549_111584[(2)] = false);

(statearr_111549_111584[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111518 === (10))){
var state_111517__$1 = state_111517;
var statearr_111550_111585 = state_111517__$1;
(statearr_111550_111585[(2)] = false);

(statearr_111550_111585[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111518 === (18))){
var state_111517__$1 = state_111517;
var statearr_111551_111586 = state_111517__$1;
(statearr_111551_111586[(2)] = true);

(statearr_111551_111586[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111518 === (8))){
var inst_111455 = (state_111517[(2)]);
var state_111517__$1 = state_111517;
if(cljs.core.truth_(inst_111455)){
var statearr_111552_111587 = state_111517__$1;
(statearr_111552_111587[(1)] = (12));

} else {
var statearr_111553_111588 = state_111517__$1;
(statearr_111553_111588[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__99037__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__99037__auto____0 = (function (){
var statearr_111554 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_111554[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__99037__auto__);

(statearr_111554[(1)] = (1));

return statearr_111554;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__99037__auto____1 = (function (state_111517){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_111517);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e111555){if((e111555 instanceof Object)){
var ex__99040__auto__ = e111555;
var statearr_111556_111589 = state_111517;
(statearr_111556_111589[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_111517);

return cljs.core.cst$kw$recur;
} else {
throw e111555;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__111590 = state_111517;
state_111517 = G__111590;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__99037__auto__ = function(state_111517){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__99037__auto____1.call(this,state_111517);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__99037__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__99037__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_111557 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_111557[(6)] = c__99059__auto__);

return statearr_111557;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(db,flakes){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_111785){
var state_val_111786 = (state_111785[(1)]);
if((state_val_111786 === (7))){
var inst_111620 = (state_111785[(7)]);
var inst_111614 = (state_111785[(8)]);
var inst_111616 = (state_111785[(9)]);
var inst_111624 = (state_111785[(10)]);
var inst_111630 = (state_111785[(11)]);
var inst_111599 = (state_111785[(12)]);
var inst_111614__$1 = (state_111785[(2)]);
var inst_111615 = (function (){var t = inst_111599;
var _ = inst_111614__$1;
return ((function (t,_,inst_111620,inst_111614,inst_111616,inst_111624,inst_111630,inst_111599,inst_111614__$1,state_val_111786,c__99059__auto__){
return (function (p1__111591_SHARP_){
return cljs.core.not((function (){var G__111787 = p1__111591_SHARP_.p;
return (fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1(G__111787) : fluree.db.graphdb.exclude_predicates.call(null,G__111787));
})());
});
;})(t,_,inst_111620,inst_111614,inst_111616,inst_111624,inst_111630,inst_111599,inst_111614__$1,state_val_111786,c__99059__auto__))
})();
var inst_111616__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_111615,flakes);
var inst_111617 = cljs.core.PersistentHashSet.EMPTY;
var inst_111618 = (function (){var t = inst_111599;
var _ = inst_111614__$1;
var add_flakes = inst_111616__$1;
return ((function (t,_,add_flakes,inst_111620,inst_111614,inst_111616,inst_111624,inst_111630,inst_111599,inst_111614__$1,inst_111615,inst_111616__$1,inst_111617,state_val_111786,c__99059__auto__){
return (function (p1__111592_SHARP_){
return p1__111592_SHARP_.p;
});
;})(t,_,add_flakes,inst_111620,inst_111614,inst_111616,inst_111624,inst_111630,inst_111599,inst_111614__$1,inst_111615,inst_111616__$1,inst_111617,state_val_111786,c__99059__auto__))
})();
var inst_111619 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_111618,inst_111616__$1);
var inst_111620__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_111617,inst_111619);
var inst_111621 = cljs.core.PersistentHashMap.EMPTY;
var inst_111622 = (function (){var t = inst_111599;
var _ = inst_111614__$1;
var add_flakes = inst_111616__$1;
var add_preds = inst_111620__$1;
return ((function (t,_,add_flakes,add_preds,inst_111620,inst_111614,inst_111616,inst_111624,inst_111630,inst_111599,inst_111614__$1,inst_111615,inst_111616__$1,inst_111617,inst_111618,inst_111619,inst_111620__$1,inst_111621,state_val_111786,c__99059__auto__){
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,p)], null);
});
;})(t,_,add_flakes,add_preds,inst_111620,inst_111614,inst_111616,inst_111624,inst_111630,inst_111599,inst_111614__$1,inst_111615,inst_111616__$1,inst_111617,inst_111618,inst_111619,inst_111620__$1,inst_111621,state_val_111786,c__99059__auto__))
})();
var inst_111623 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_111622,inst_111620__$1);
var inst_111624__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_111621,inst_111623);
var inst_111625 = cljs.core.PersistentHashMap.EMPTY;
var inst_111626 = (function (){var t = inst_111599;
var _ = inst_111614__$1;
var add_flakes = inst_111616__$1;
var add_preds = inst_111620__$1;
var idx_QMARK__map = inst_111624__$1;
return ((function (t,_,add_flakes,add_preds,idx_QMARK__map,inst_111620,inst_111614,inst_111616,inst_111624,inst_111630,inst_111599,inst_111614__$1,inst_111615,inst_111616__$1,inst_111617,inst_111618,inst_111619,inst_111620__$1,inst_111621,inst_111622,inst_111623,inst_111624__$1,inst_111625,state_val_111786,c__99059__auto__){
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$ref_QMARK_,p)], null);
});
;})(t,_,add_flakes,add_preds,idx_QMARK__map,inst_111620,inst_111614,inst_111616,inst_111624,inst_111630,inst_111599,inst_111614__$1,inst_111615,inst_111616__$1,inst_111617,inst_111618,inst_111619,inst_111620__$1,inst_111621,inst_111622,inst_111623,inst_111624__$1,inst_111625,state_val_111786,c__99059__auto__))
})();
var inst_111627 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_111626,inst_111620__$1);
var inst_111628 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_111625,inst_111627);
var inst_111629 = fluree.db.flake.size_bytes(inst_111616__$1);
var inst_111630__$1 = fluree.db.util.schema.schema_change_QMARK_(inst_111616__$1);
var inst_111631 = fluree.db.util.schema.setting_change_QMARK_(inst_111616__$1);
var inst_111632 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_111633 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_111632,(0));
var state_111785__$1 = (function (){var statearr_111788 = state_111785;
(statearr_111788[(7)] = inst_111620__$1);

(statearr_111788[(13)] = inst_111631);

(statearr_111788[(14)] = inst_111628);

(statearr_111788[(8)] = inst_111614__$1);

(statearr_111788[(9)] = inst_111616__$1);

(statearr_111788[(15)] = inst_111633);

(statearr_111788[(10)] = inst_111624__$1);

(statearr_111788[(11)] = inst_111630__$1);

(statearr_111788[(16)] = inst_111629);

return statearr_111788;
})();
if(cljs.core.truth_(inst_111630__$1)){
var statearr_111789_111847 = state_111785__$1;
(statearr_111789_111847[(1)] = (8));

} else {
var statearr_111790_111848 = state_111785__$1;
(statearr_111790_111848[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111786 === (20))){
var inst_111709 = (state_111785[(17)]);
var inst_111679 = (state_111785[(18)]);
var inst_111620 = (state_111785[(7)]);
var inst_111631 = (state_111785[(13)]);
var inst_111628 = (state_111785[(14)]);
var inst_111614 = (state_111785[(8)]);
var inst_111616 = (state_111785[(9)]);
var inst_111719 = (state_111785[(19)]);
var inst_111633 = (state_111785[(15)]);
var inst_111708 = (state_111785[(20)]);
var inst_111718 = (state_111785[(21)]);
var inst_111688 = (state_111785[(22)]);
var inst_111711 = (state_111785[(23)]);
var inst_111710 = (state_111785[(24)]);
var inst_111624 = (state_111785[(10)]);
var inst_111639 = (state_111785[(25)]);
var inst_111630 = (state_111785[(11)]);
var inst_111689 = (state_111785[(26)]);
var inst_111629 = (state_111785[(16)]);
var inst_111599 = (state_111785[(12)]);
var inst_111712 = (state_111785[(27)]);
var inst_111707 = (state_111785[(28)]);
var inst_111757 = inst_111718.s;
var inst_111758 = fluree.db.flake.sid__GT_cid(inst_111757);
var inst_111759 = (function (){var flakes_bytes = inst_111629;
var t = inst_111599;
var vec__111714 = inst_111707;
var seq__111685 = inst_111689;
var spot = inst_111708;
var add_flakes = inst_111616;
var root_setting_change_QMARK_ = inst_111631;
var ref_QMARK__map = inst_111628;
var first__111716 = inst_111718;
var r = inst_111719;
var psot = inst_111709;
var add_pred_to_idx_QMARK_ = inst_111639;
var _ = inst_111614;
var cid = inst_111758;
var ecount = inst_111712;
var vec__111684 = inst_111616;
var pred_ecount = inst_111633;
var db_STAR_ = inst_111679;
var schema_change_QMARK_ = inst_111630;
var seq__111715 = inst_111719;
var first__111686 = inst_111688;
var add_preds = inst_111620;
var G__111683 = inst_111707;
var opst = inst_111711;
var idx_QMARK__map = inst_111624;
var post = inst_111710;
var f = inst_111718;
return ((function (flakes_bytes,t,vec__111714,seq__111685,spot,add_flakes,root_setting_change_QMARK_,ref_QMARK__map,first__111716,r,psot,add_pred_to_idx_QMARK_,_,cid,ecount,vec__111684,pred_ecount,db_STAR_,schema_change_QMARK_,seq__111715,first__111686,add_preds,G__111683,opst,idx_QMARK__map,post,f,inst_111709,inst_111679,inst_111620,inst_111631,inst_111628,inst_111614,inst_111616,inst_111719,inst_111633,inst_111708,inst_111718,inst_111688,inst_111711,inst_111710,inst_111624,inst_111639,inst_111630,inst_111689,inst_111629,inst_111599,inst_111712,inst_111707,inst_111757,inst_111758,state_val_111786,c__99059__auto__){
return (function (p1__111593_SHARP_){
if(cljs.core.truth_(p1__111593_SHARP_)){
var x__4219__auto__ = p1__111593_SHARP_;
var y__4220__auto__ = f.s;
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
} else {
return f.s;
}
});
;})(flakes_bytes,t,vec__111714,seq__111685,spot,add_flakes,root_setting_change_QMARK_,ref_QMARK__map,first__111716,r,psot,add_pred_to_idx_QMARK_,_,cid,ecount,vec__111684,pred_ecount,db_STAR_,schema_change_QMARK_,seq__111715,first__111686,add_preds,G__111683,opst,idx_QMARK__map,post,f,inst_111709,inst_111679,inst_111620,inst_111631,inst_111628,inst_111614,inst_111616,inst_111719,inst_111633,inst_111708,inst_111718,inst_111688,inst_111711,inst_111710,inst_111624,inst_111639,inst_111630,inst_111689,inst_111629,inst_111599,inst_111712,inst_111707,inst_111757,inst_111758,state_val_111786,c__99059__auto__))
})();
var inst_111760 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_111712,inst_111758,inst_111759);
var inst_111761 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_111708,inst_111718);
var inst_111762 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_111709,inst_111718);
var inst_111763 = inst_111718.p;
var inst_111764 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_111624,inst_111763);
var state_111785__$1 = (function (){var statearr_111791 = state_111785;
(statearr_111791[(29)] = inst_111760);

(statearr_111791[(30)] = inst_111762);

(statearr_111791[(31)] = inst_111761);

return statearr_111791;
})();
if(cljs.core.truth_(inst_111764)){
var statearr_111792_111849 = state_111785__$1;
(statearr_111792_111849[(1)] = (33));

} else {
var statearr_111793_111850 = state_111785__$1;
(statearr_111793_111850[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111786 === (27))){
var inst_111631 = (state_111785[(13)]);
var inst_111745 = (state_111785[(2)]);
var state_111785__$1 = (function (){var statearr_111794 = state_111785;
(statearr_111794[(32)] = inst_111745);

return statearr_111794;
})();
if(cljs.core.truth_(inst_111631)){
var statearr_111795_111851 = state_111785__$1;
(statearr_111795_111851[(1)] = (29));

} else {
var statearr_111796_111852 = state_111785__$1;
(statearr_111796_111852[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111786 === (1))){
var state_111785__$1 = state_111785;
var statearr_111797_111853 = state_111785__$1;
(statearr_111797_111853[(2)] = null);

(statearr_111797_111853[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111786 === (24))){
var inst_111736 = (state_111785[(2)]);
var state_111785__$1 = state_111785;
if(cljs.core.truth_(inst_111736)){
var statearr_111798_111854 = state_111785__$1;
(statearr_111798_111854[(1)] = (25));

} else {
var statearr_111799_111855 = state_111785__$1;
(statearr_111799_111855[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111786 === (4))){
var inst_111599 = (state_111785[(12)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_111785,(3),Error,null,(2));
var inst_111598 = cljs.core.first(flakes);
var inst_111599__$1 = inst_111598.t;
var inst_111600 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_111601 = (inst_111600 - (1));
var inst_111602 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_111599__$1,inst_111601);
var state_111785__$1 = (function (){var statearr_111800 = state_111785;
(statearr_111800[(12)] = inst_111599__$1);

return statearr_111800;
})();
if(inst_111602){
var statearr_111801_111856 = state_111785__$1;
(statearr_111801_111856[(1)] = (5));

} else {
var statearr_111802_111857 = state_111785__$1;
(statearr_111802_111857[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111786 === (15))){
var inst_111667 = (state_111785[(2)]);
var state_111785__$1 = state_111785;
var statearr_111803_111858 = state_111785__$1;
(statearr_111803_111858[(2)] = inst_111667);

(statearr_111803_111858[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111786 === (21))){
var inst_111779 = (state_111785[(2)]);
var state_111785__$1 = state_111785;
var statearr_111804_111859 = state_111785__$1;
(statearr_111804_111859[(2)] = inst_111779);

(statearr_111804_111859[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111786 === (31))){
var inst_111755 = (state_111785[(2)]);
var state_111785__$1 = state_111785;
var statearr_111805_111860 = state_111785__$1;
(statearr_111805_111860[(2)] = inst_111755);

(statearr_111805_111860[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111786 === (32))){
var inst_111745 = (state_111785[(32)]);
var inst_111750 = (state_111785[(2)]);
var inst_111751 = fluree.db.util.async.throw_err(inst_111750);
var inst_111752 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_111745,cljs.core.cst$kw$settings,inst_111751);
var state_111785__$1 = state_111785;
var statearr_111806_111861 = state_111785__$1;
(statearr_111806_111861[(2)] = inst_111752);

(statearr_111806_111861[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111786 === (33))){
var inst_111718 = (state_111785[(21)]);
var inst_111710 = (state_111785[(24)]);
var inst_111766 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_111710,inst_111718);
var state_111785__$1 = state_111785;
var statearr_111807_111862 = state_111785__$1;
(statearr_111807_111862[(2)] = inst_111766);

(statearr_111807_111862[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111786 === (13))){
var inst_111651 = (state_111785[(33)]);
var inst_111657 = (state_111785[(34)]);
var inst_111660 = fluree.db.graphdb.add_predicate_to_idx(inst_111651,inst_111657);
var state_111785__$1 = state_111785;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_111785__$1,(16),inst_111660);
} else {
if((state_val_111786 === (22))){
var inst_111630 = (state_111785[(11)]);
var state_111785__$1 = state_111785;
var statearr_111808_111863 = state_111785__$1;
(statearr_111808_111863[(2)] = inst_111630);

(statearr_111808_111863[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111786 === (36))){
var inst_111718 = (state_111785[(21)]);
var inst_111711 = (state_111785[(23)]);
var inst_111773 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_111711,inst_111718);
var state_111785__$1 = state_111785;
var statearr_111809_111864 = state_111785__$1;
(statearr_111809_111864[(2)] = inst_111773);

(statearr_111809_111864[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111786 === (29))){
var inst_111745 = (state_111785[(32)]);
var inst_111748 = fluree.db.query.schema.setting_map(inst_111745);
var state_111785__$1 = state_111785;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_111785__$1,(32),inst_111748);
} else {
if((state_val_111786 === (6))){
var state_111785__$1 = state_111785;
var statearr_111810_111865 = state_111785__$1;
(statearr_111810_111865[(2)] = null);

(statearr_111810_111865[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111786 === (28))){
var inst_111730 = (state_111785[(35)]);
var inst_111740 = (state_111785[(2)]);
var inst_111741 = fluree.db.util.async.throw_err(inst_111740);
var inst_111742 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_111730,cljs.core.cst$kw$schema,inst_111741);
var state_111785__$1 = state_111785;
var statearr_111811_111866 = state_111785__$1;
(statearr_111811_111866[(2)] = inst_111742);

(statearr_111811_111866[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111786 === (25))){
var inst_111730 = (state_111785[(35)]);
var inst_111738 = fluree.db.query.schema.schema_map(inst_111730);
var state_111785__$1 = state_111785;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_111785__$1,(28),inst_111738);
} else {
if((state_val_111786 === (34))){
var inst_111710 = (state_111785[(24)]);
var state_111785__$1 = state_111785;
var statearr_111812_111867 = state_111785__$1;
(statearr_111812_111867[(2)] = inst_111710);

(statearr_111812_111867[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111786 === (17))){
var inst_111718 = (state_111785[(21)]);
var inst_111707 = (state_111785[(28)]);
var inst_111717 = cljs.core.seq(inst_111707);
var inst_111718__$1 = cljs.core.first(inst_111717);
var inst_111719 = cljs.core.next(inst_111717);
var inst_111720 = cljs.core.not(inst_111718__$1);
var state_111785__$1 = (function (){var statearr_111813 = state_111785;
(statearr_111813[(19)] = inst_111719);

(statearr_111813[(21)] = inst_111718__$1);

return statearr_111813;
})();
if(inst_111720){
var statearr_111814_111868 = state_111785__$1;
(statearr_111814_111868[(1)] = (19));

} else {
var statearr_111815_111869 = state_111785__$1;
(statearr_111815_111869[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111786 === (3))){
var inst_111594 = (state_111785[(2)]);
var state_111785__$1 = state_111785;
var statearr_111816_111870 = state_111785__$1;
(statearr_111816_111870[(2)] = inst_111594);


cljs.core.async.impl.ioc_helpers.process_exception(state_111785__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_111786 === (12))){
var inst_111679 = (state_111785[(18)]);
var inst_111616 = (state_111785[(9)]);
var inst_111629 = (state_111785[(16)]);
var inst_111599 = (state_111785[(12)]);
var inst_111669 = (state_111785[(2)]);
var inst_111670 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_111669,cljs.core.cst$kw$t,inst_111599);
var inst_111671 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_111672 = [cljs.core.cst$kw$stats,cljs.core.cst$kw$size];
var inst_111673 = (new cljs.core.PersistentVector(null,2,(5),inst_111671,inst_111672,null));
var inst_111674 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_111670,inst_111673,cljs.core._PLUS_,inst_111629);
var inst_111675 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_111676 = [cljs.core.cst$kw$stats,cljs.core.cst$kw$flakes];
var inst_111677 = (new cljs.core.PersistentVector(null,2,(5),inst_111675,inst_111676,null));
var inst_111678 = cljs.core.count(inst_111616);
var inst_111679__$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_111674,inst_111677,cljs.core._PLUS_,inst_111678);
var inst_111687 = cljs.core.seq(inst_111616);
var inst_111688 = cljs.core.first(inst_111687);
var inst_111689 = cljs.core.next(inst_111687);
var inst_111690 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_111691 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$spot];
var inst_111692 = (new cljs.core.PersistentVector(null,2,(5),inst_111690,inst_111691,null));
var inst_111693 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_111679__$1,inst_111692);
var inst_111694 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_111695 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$psot];
var inst_111696 = (new cljs.core.PersistentVector(null,2,(5),inst_111694,inst_111695,null));
var inst_111697 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_111679__$1,inst_111696);
var inst_111698 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_111699 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$post];
var inst_111700 = (new cljs.core.PersistentVector(null,2,(5),inst_111698,inst_111699,null));
var inst_111701 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_111679__$1,inst_111700);
var inst_111702 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_111703 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$opst];
var inst_111704 = (new cljs.core.PersistentVector(null,2,(5),inst_111702,inst_111703,null));
var inst_111705 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_111679__$1,inst_111704);
var inst_111706 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_111707 = inst_111616;
var inst_111708 = inst_111693;
var inst_111709 = inst_111697;
var inst_111710 = inst_111701;
var inst_111711 = inst_111705;
var inst_111712 = inst_111706;
var state_111785__$1 = (function (){var statearr_111817 = state_111785;
(statearr_111817[(17)] = inst_111709);

(statearr_111817[(18)] = inst_111679__$1);

(statearr_111817[(20)] = inst_111708);

(statearr_111817[(22)] = inst_111688);

(statearr_111817[(23)] = inst_111711);

(statearr_111817[(24)] = inst_111710);

(statearr_111817[(26)] = inst_111689);

(statearr_111817[(27)] = inst_111712);

(statearr_111817[(28)] = inst_111707);

return statearr_111817;
})();
var statearr_111818_111871 = state_111785__$1;
(statearr_111818_111871[(2)] = null);

(statearr_111818_111871[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111786 === (2))){
var inst_111783 = (state_111785[(2)]);
var state_111785__$1 = state_111785;
return cljs.core.async.impl.ioc_helpers.return_chan(state_111785__$1,inst_111783);
} else {
if((state_val_111786 === (23))){
var inst_111730 = (state_111785[(35)]);
var inst_111733 = cljs.core.cst$kw$schema.cljs$core$IFn$_invoke$arity$1(inst_111730);
var inst_111734 = (inst_111733 == null);
var state_111785__$1 = state_111785;
var statearr_111819_111872 = state_111785__$1;
(statearr_111819_111872[(2)] = inst_111734);

(statearr_111819_111872[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111786 === (35))){
var inst_111628 = (state_111785[(14)]);
var inst_111718 = (state_111785[(21)]);
var inst_111769 = (state_111785[(2)]);
var inst_111770 = inst_111718.p;
var inst_111771 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_111628,inst_111770);
var state_111785__$1 = (function (){var statearr_111820 = state_111785;
(statearr_111820[(36)] = inst_111769);

return statearr_111820;
})();
if(cljs.core.truth_(inst_111771)){
var statearr_111821_111873 = state_111785__$1;
(statearr_111821_111873[(1)] = (36));

} else {
var statearr_111822_111874 = state_111785__$1;
(statearr_111822_111874[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111786 === (19))){
var inst_111709 = (state_111785[(17)]);
var inst_111679 = (state_111785[(18)]);
var inst_111708 = (state_111785[(20)]);
var inst_111711 = (state_111785[(23)]);
var inst_111710 = (state_111785[(24)]);
var inst_111630 = (state_111785[(11)]);
var inst_111629 = (state_111785[(16)]);
var inst_111712 = (state_111785[(27)]);
var inst_111722 = [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$size];
var inst_111723 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_111724 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$size];
var inst_111725 = (new cljs.core.PersistentVector(null,2,(5),inst_111723,inst_111724,null));
var inst_111726 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_111679,inst_111725);
var inst_111727 = (inst_111629 + inst_111726);
var inst_111728 = [inst_111708,inst_111709,inst_111710,inst_111711,inst_111727];
var inst_111729 = cljs.core.PersistentHashMap.fromArrays(inst_111722,inst_111728);
var inst_111730 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_111679,cljs.core.cst$kw$ecount,inst_111712,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$novelty,inst_111729], 0));
var state_111785__$1 = (function (){var statearr_111823 = state_111785;
(statearr_111823[(35)] = inst_111730);

return statearr_111823;
})();
if(cljs.core.truth_(inst_111630)){
var statearr_111824_111875 = state_111785__$1;
(statearr_111824_111875[(1)] = (22));

} else {
var statearr_111825_111876 = state_111785__$1;
(statearr_111825_111876[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111786 === (11))){
var inst_111650 = (state_111785[(37)]);
var inst_111657 = (state_111785[(34)]);
var inst_111656 = cljs.core.seq(inst_111650);
var inst_111657__$1 = cljs.core.first(inst_111656);
var inst_111658 = cljs.core.next(inst_111656);
var state_111785__$1 = (function (){var statearr_111826 = state_111785;
(statearr_111826[(38)] = inst_111658);

(statearr_111826[(34)] = inst_111657__$1);

return statearr_111826;
})();
if(cljs.core.truth_(inst_111657__$1)){
var statearr_111827_111877 = state_111785__$1;
(statearr_111827_111877[(1)] = (13));

} else {
var statearr_111828_111878 = state_111785__$1;
(statearr_111828_111878[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111786 === (9))){
var inst_111637 = cljs.core.PersistentVector.EMPTY;
var state_111785__$1 = state_111785;
var statearr_111829_111879 = state_111785__$1;
(statearr_111829_111879[(2)] = inst_111637);

(statearr_111829_111879[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111786 === (5))){
var inst_111599 = (state_111785[(12)]);
var inst_111604 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_111605 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_111606 = ["Invalid with called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_111604)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_111605)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_111599),"."].join('');
var inst_111607 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_111608 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_111609 = cljs.core.PersistentHashMap.fromArrays(inst_111607,inst_111608);
var inst_111610 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_111606,inst_111609);
var inst_111611 = (function(){throw inst_111610})();
var state_111785__$1 = state_111785;
var statearr_111830_111880 = state_111785__$1;
(statearr_111830_111880[(2)] = inst_111611);

(statearr_111830_111880[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111786 === (14))){
var inst_111651 = (state_111785[(33)]);
var state_111785__$1 = state_111785;
var statearr_111831_111881 = state_111785__$1;
(statearr_111831_111881[(2)] = inst_111651);

(statearr_111831_111881[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111786 === (26))){
var inst_111730 = (state_111785[(35)]);
var state_111785__$1 = state_111785;
var statearr_111832_111882 = state_111785__$1;
(statearr_111832_111882[(2)] = inst_111730);

(statearr_111832_111882[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111786 === (16))){
var inst_111658 = (state_111785[(38)]);
var inst_111662 = (state_111785[(2)]);
var inst_111663 = fluree.db.util.async.throw_err(inst_111662);
var inst_111650 = inst_111658;
var inst_111651 = inst_111663;
var state_111785__$1 = (function (){var statearr_111833 = state_111785;
(statearr_111833[(37)] = inst_111650);

(statearr_111833[(33)] = inst_111651);

return statearr_111833;
})();
var statearr_111834_111883 = state_111785__$1;
(statearr_111834_111883[(2)] = null);

(statearr_111834_111883[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111786 === (38))){
var inst_111769 = (state_111785[(36)]);
var inst_111719 = (state_111785[(19)]);
var inst_111760 = (state_111785[(29)]);
var inst_111762 = (state_111785[(30)]);
var inst_111761 = (state_111785[(31)]);
var inst_111776 = (state_111785[(2)]);
var inst_111707 = inst_111719;
var inst_111708 = inst_111761;
var inst_111709 = inst_111762;
var inst_111710 = inst_111769;
var inst_111711 = inst_111776;
var inst_111712 = inst_111760;
var state_111785__$1 = (function (){var statearr_111835 = state_111785;
(statearr_111835[(17)] = inst_111709);

(statearr_111835[(20)] = inst_111708);

(statearr_111835[(23)] = inst_111711);

(statearr_111835[(24)] = inst_111710);

(statearr_111835[(27)] = inst_111712);

(statearr_111835[(28)] = inst_111707);

return statearr_111835;
})();
var statearr_111836_111884 = state_111785__$1;
(statearr_111836_111884[(2)] = null);

(statearr_111836_111884[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111786 === (30))){
var inst_111745 = (state_111785[(32)]);
var state_111785__$1 = state_111785;
var statearr_111837_111885 = state_111785__$1;
(statearr_111837_111885[(2)] = inst_111745);

(statearr_111837_111885[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111786 === (10))){
var inst_111639 = (state_111785[(25)]);
var inst_111639__$1 = (state_111785[(2)]);
var inst_111647 = cljs.core.seq(inst_111639__$1);
var inst_111648 = cljs.core.first(inst_111647);
var inst_111649 = cljs.core.next(inst_111647);
var inst_111650 = inst_111639__$1;
var inst_111651 = db;
var state_111785__$1 = (function (){var statearr_111838 = state_111785;
(statearr_111838[(37)] = inst_111650);

(statearr_111838[(33)] = inst_111651);

(statearr_111838[(39)] = inst_111649);

(statearr_111838[(40)] = inst_111648);

(statearr_111838[(25)] = inst_111639__$1);

return statearr_111838;
})();
var statearr_111839_111886 = state_111785__$1;
(statearr_111839_111886[(2)] = null);

(statearr_111839_111886[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111786 === (18))){
var inst_111781 = (state_111785[(2)]);
var state_111785__$1 = state_111785;
var statearr_111840_111887 = state_111785__$1;
(statearr_111840_111887[(2)] = inst_111781);


cljs.core.async.impl.ioc_helpers.process_exception(state_111785__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_111786 === (37))){
var inst_111711 = (state_111785[(23)]);
var state_111785__$1 = state_111785;
var statearr_111841_111888 = state_111785__$1;
(statearr_111841_111888[(2)] = inst_111711);

(statearr_111841_111888[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111786 === (8))){
var inst_111616 = (state_111785[(9)]);
var inst_111633 = (state_111785[(15)]);
var inst_111635 = fluree.db.util.schema.add_to_post_preds_QMARK_(inst_111616,inst_111633);
var state_111785__$1 = state_111785;
var statearr_111842_111889 = state_111785__$1;
(statearr_111842_111889[(2)] = inst_111635);

(statearr_111842_111889[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$graphdb$with_t_$_state_machine__99037__auto__ = null;
var fluree$db$graphdb$with_t_$_state_machine__99037__auto____0 = (function (){
var statearr_111843 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_111843[(0)] = fluree$db$graphdb$with_t_$_state_machine__99037__auto__);

(statearr_111843[(1)] = (1));

return statearr_111843;
});
var fluree$db$graphdb$with_t_$_state_machine__99037__auto____1 = (function (state_111785){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_111785);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e111844){if((e111844 instanceof Object)){
var ex__99040__auto__ = e111844;
var statearr_111845_111890 = state_111785;
(statearr_111845_111890[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_111785);

return cljs.core.cst$kw$recur;
} else {
throw e111844;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__111891 = state_111785;
state_111785 = G__111891;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$graphdb$with_t_$_state_machine__99037__auto__ = function(state_111785){
switch(arguments.length){
case 0:
return fluree$db$graphdb$with_t_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$graphdb$with_t_$_state_machine__99037__auto____1.call(this,state_111785);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$with_t_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$with_t_$_state_machine__99037__auto____0;
fluree$db$graphdb$with_t_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$with_t_$_state_machine__99037__auto____1;
return fluree$db$graphdb$with_t_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_111846 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_111846[(6)] = c__99059__auto__);

return statearr_111846;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(db,block,flakes){
var resp_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__99059__auto___112014 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto___112014,resp_ch){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto___112014,resp_ch){
return (function (state_111976){
var state_val_111977 = (state_111976[(1)]);
if((state_val_111977 === (7))){
var inst_111911 = (state_111976[(2)]);
var inst_111912 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_block,flakes);
var inst_111920 = cljs.core.seq(inst_111912);
var inst_111921 = cljs.core.first(inst_111920);
var inst_111922 = cljs.core.next(inst_111920);
var inst_111923 = cljs.core.first(inst_111912);
var inst_111924 = inst_111923.t;
var inst_111925 = cljs.core.PersistentVector.EMPTY;
var inst_111926 = inst_111912;
var inst_111927 = inst_111924;
var inst_111928 = inst_111925;
var inst_111929 = db;
var state_111976__$1 = (function (){var statearr_111978 = state_111976;
(statearr_111978[(7)] = inst_111928);

(statearr_111978[(8)] = inst_111922);

(statearr_111978[(9)] = inst_111926);

(statearr_111978[(10)] = inst_111929);

(statearr_111978[(11)] = inst_111927);

(statearr_111978[(12)] = inst_111921);

(statearr_111978[(13)] = inst_111911);

return statearr_111978;
})();
var statearr_111979_112015 = state_111976__$1;
(statearr_111979_112015[(2)] = null);

(statearr_111979_112015[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111977 === (20))){
var inst_111953 = (state_111976[(14)]);
var inst_111956 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_111953,cljs.core.cst$kw$block,block);
var state_111976__$1 = state_111976;
var statearr_111980_112016 = state_111976__$1;
(statearr_111980_112016[(2)] = inst_111956);

(statearr_111980_112016[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111977 === (1))){
var state_111976__$1 = state_111976;
var statearr_111981_112017 = state_111976__$1;
(statearr_111981_112017[(2)] = null);

(statearr_111981_112017[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111977 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_111976,(3),java.lang.Exception,null,(2));
var inst_111897 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(db);
var inst_111898 = (inst_111897 + (1));
var inst_111899 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_111898);
var state_111976__$1 = state_111976;
if(inst_111899){
var statearr_111982_112018 = state_111976__$1;
(statearr_111982_112018[(1)] = (5));

} else {
var statearr_111983_112019 = state_111976__$1;
(statearr_111983_112019[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111977 === (15))){
var inst_111969 = (state_111976[(2)]);
var state_111976__$1 = state_111976;
var statearr_111986_112020 = state_111976__$1;
(statearr_111986_112020[(2)] = inst_111969);

(statearr_111986_112020[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111977 === (21))){
var inst_111953 = (state_111976[(14)]);
var inst_111935 = (state_111976[(15)]);
var inst_111936 = (state_111976[(16)]);
var inst_111958 = inst_111935.t;
var inst_111959 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_111960 = [inst_111935];
var inst_111961 = (new cljs.core.PersistentVector(null,1,(5),inst_111959,inst_111960,null));
var inst_111926 = inst_111936;
var inst_111927 = inst_111958;
var inst_111928 = inst_111961;
var inst_111929 = inst_111953;
var state_111976__$1 = (function (){var statearr_111987 = state_111976;
(statearr_111987[(7)] = inst_111928);

(statearr_111987[(9)] = inst_111926);

(statearr_111987[(10)] = inst_111929);

(statearr_111987[(11)] = inst_111927);

return statearr_111987;
})();
var statearr_111988_112021 = state_111976__$1;
(statearr_111988_112021[(2)] = null);

(statearr_111988_112021[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111977 === (13))){
var inst_111935 = (state_111976[(15)]);
var inst_111936 = (state_111976[(16)]);
var inst_111928 = (state_111976[(7)]);
var inst_111929 = (state_111976[(10)]);
var inst_111927 = (state_111976[(11)]);
var inst_111944 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_111928,inst_111935);
var tmp111984 = inst_111929;
var tmp111985 = inst_111927;
var inst_111926 = inst_111936;
var inst_111927__$1 = tmp111985;
var inst_111928__$1 = inst_111944;
var inst_111929__$1 = tmp111984;
var state_111976__$1 = (function (){var statearr_111989 = state_111976;
(statearr_111989[(7)] = inst_111928__$1);

(statearr_111989[(9)] = inst_111926);

(statearr_111989[(10)] = inst_111929__$1);

(statearr_111989[(11)] = inst_111927__$1);

return statearr_111989;
})();
var statearr_111990_112022 = state_111976__$1;
(statearr_111990_112022[(2)] = null);

(statearr_111990_112022[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111977 === (22))){
var inst_111964 = (state_111976[(2)]);
var state_111976__$1 = state_111976;
var statearr_111991_112023 = state_111976__$1;
(statearr_111991_112023[(2)] = inst_111964);

(statearr_111991_112023[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111977 === (6))){
var state_111976__$1 = state_111976;
var statearr_111992_112024 = state_111976__$1;
(statearr_111992_112024[(2)] = null);

(statearr_111992_112024[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111977 === (17))){
var state_111976__$1 = state_111976;
var statearr_111993_112025 = state_111976__$1;
(statearr_111993_112025[(2)] = null);

(statearr_111993_112025[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111977 === (3))){
var inst_111892 = (state_111976[(2)]);
var inst_111893 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_111892);
var state_111976__$1 = state_111976;
var statearr_111994_112026 = state_111976__$1;
(statearr_111994_112026[(2)] = inst_111893);


cljs.core.async.impl.ioc_helpers.process_exception(state_111976__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_111977 === (12))){
var inst_111942 = (state_111976[(2)]);
var state_111976__$1 = state_111976;
if(cljs.core.truth_(inst_111942)){
var statearr_111995_112027 = state_111976__$1;
(statearr_111995_112027[(1)] = (13));

} else {
var statearr_111996_112028 = state_111976__$1;
(statearr_111996_112028[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111977 === (2))){
var inst_111974 = (state_111976[(2)]);
var state_111976__$1 = state_111976;
return cljs.core.async.impl.ioc_helpers.return_chan(state_111976__$1,inst_111974);
} else {
if((state_val_111977 === (19))){
var inst_111935 = (state_111976[(15)]);
var inst_111952 = (state_111976[(2)]);
var inst_111953 = fluree.db.util.async.throw_err(inst_111952);
var inst_111954 = (inst_111935 == null);
var state_111976__$1 = (function (){var statearr_111997 = state_111976;
(statearr_111997[(14)] = inst_111953);

return statearr_111997;
})();
if(cljs.core.truth_(inst_111954)){
var statearr_111998_112029 = state_111976__$1;
(statearr_111998_112029[(1)] = (20));

} else {
var statearr_111999_112030 = state_111976__$1;
(statearr_111999_112030[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111977 === (11))){
var inst_111935 = (state_111976[(15)]);
var state_111976__$1 = state_111976;
var statearr_112000_112031 = state_111976__$1;
(statearr_112000_112031[(2)] = inst_111935);

(statearr_112000_112031[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111977 === (9))){
var inst_111971 = (state_111976[(2)]);
var inst_111972 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_111971);
var state_111976__$1 = state_111976;
var statearr_112001_112032 = state_111976__$1;
(statearr_112001_112032[(2)] = inst_111972);


cljs.core.async.impl.ioc_helpers.process_exception(state_111976__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_111977 === (5))){
var inst_111901 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_111902 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(db);
var inst_111903 = ["Invalid 'with' called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_111901)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_111902)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_111904 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_111905 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_111906 = cljs.core.PersistentHashMap.fromArrays(inst_111904,inst_111905);
var inst_111907 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_111903,inst_111906);
var inst_111908 = (function(){throw inst_111907})();
var state_111976__$1 = state_111976;
var statearr_112002_112033 = state_111976__$1;
(statearr_112002_112033[(2)] = inst_111908);

(statearr_112002_112033[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111977 === (14))){
var state_111976__$1 = state_111976;
var statearr_112003_112034 = state_111976__$1;
(statearr_112003_112034[(1)] = (16));



return cljs.core.cst$kw$recur;
} else {
if((state_val_111977 === (16))){
var inst_111928 = (state_111976[(7)]);
var inst_111929 = (state_111976[(10)]);
var inst_111927 = (state_111976[(11)]);
var inst_111948 = (inst_111927 + (1));
var inst_111949 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_111929,cljs.core.cst$kw$t,inst_111948);
var inst_111950 = fluree.db.graphdb.with_t(inst_111949,inst_111928);
var state_111976__$1 = state_111976;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_111976__$1,(19),inst_111950);
} else {
if((state_val_111977 === (10))){
var inst_111935 = (state_111976[(15)]);
var inst_111927 = (state_111976[(11)]);
var inst_111938 = inst_111935.t;
var inst_111939 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_111927,inst_111938);
var state_111976__$1 = state_111976;
var statearr_112005_112035 = state_111976__$1;
(statearr_112005_112035[(2)] = inst_111939);

(statearr_112005_112035[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111977 === (18))){
var inst_111967 = (state_111976[(2)]);
var state_111976__$1 = state_111976;
var statearr_112006_112036 = state_111976__$1;
(statearr_112006_112036[(2)] = inst_111967);

(statearr_112006_112036[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111977 === (8))){
var inst_111935 = (state_111976[(15)]);
var inst_111926 = (state_111976[(9)]);
var inst_111934 = cljs.core.seq(inst_111926);
var inst_111935__$1 = cljs.core.first(inst_111934);
var inst_111936 = cljs.core.next(inst_111934);
var state_111976__$1 = (function (){var statearr_112007 = state_111976;
(statearr_112007[(15)] = inst_111935__$1);

(statearr_112007[(16)] = inst_111936);

return statearr_112007;
})();
if(cljs.core.truth_(inst_111935__$1)){
var statearr_112008_112037 = state_111976__$1;
(statearr_112008_112037[(1)] = (10));

} else {
var statearr_112009_112038 = state_111976__$1;
(statearr_112009_112038[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto___112014,resp_ch))
;
return ((function (switch__99036__auto__,c__99059__auto___112014,resp_ch){
return (function() {
var fluree$db$graphdb$with_$_state_machine__99037__auto__ = null;
var fluree$db$graphdb$with_$_state_machine__99037__auto____0 = (function (){
var statearr_112010 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_112010[(0)] = fluree$db$graphdb$with_$_state_machine__99037__auto__);

(statearr_112010[(1)] = (1));

return statearr_112010;
});
var fluree$db$graphdb$with_$_state_machine__99037__auto____1 = (function (state_111976){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_111976);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e112011){if((e112011 instanceof Object)){
var ex__99040__auto__ = e112011;
var statearr_112012_112039 = state_111976;
(statearr_112012_112039[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_111976);

return cljs.core.cst$kw$recur;
} else {
throw e112011;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__112040 = state_111976;
state_111976 = G__112040;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$graphdb$with_$_state_machine__99037__auto__ = function(state_111976){
switch(arguments.length){
case 0:
return fluree$db$graphdb$with_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$graphdb$with_$_state_machine__99037__auto____1.call(this,state_111976);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$with_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$with_$_state_machine__99037__auto____0;
fluree$db$graphdb$with_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$with_$_state_machine__99037__auto____1;
return fluree$db$graphdb$with_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto___112014,resp_ch))
})();
var state__99061__auto__ = (function (){var statearr_112013 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_112013[(6)] = c__99059__auto___112014);

return statearr_112013;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto___112014,resp_ch))
);


return resp_ch;
});
/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_112093){
var state_val_112094 = (state_112093[(1)]);
if((state_val_112094 === (7))){
var inst_112050 = (state_112093[(2)]);
var inst_112051 = (function (){var tt_id_SINGLEQUOTE_ = inst_112050;
return ((function (tt_id_SINGLEQUOTE_,inst_112050,state_val_112094,c__99059__auto__){
return (function (db_STAR_,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db_STAR_,idx,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(db_STAR_,idx),cljs.core.cst$kw$tt_DASH_id,tt_id_SINGLEQUOTE_));
});
;})(tt_id_SINGLEQUOTE_,inst_112050,state_val_112094,c__99059__auto__))
})();
var inst_112052 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$tt_DASH_id,inst_112050);
var inst_112053 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_112054 = [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst];
var inst_112055 = (new cljs.core.PersistentVector(null,4,(5),inst_112053,inst_112054,null));
var inst_112056 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_112051,inst_112052,inst_112055);
var inst_112057 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$t,flakes);
var inst_112058 = cljs.core.reverse(inst_112057);
var inst_112059 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$t,inst_112058);
var inst_112067 = cljs.core.seq(inst_112059);
var inst_112068 = cljs.core.first(inst_112067);
var inst_112069 = cljs.core.next(inst_112067);
var inst_112070 = inst_112056;
var inst_112071 = inst_112059;
var state_112093__$1 = (function (){var statearr_112095 = state_112093;
(statearr_112095[(7)] = inst_112069);

(statearr_112095[(8)] = inst_112070);

(statearr_112095[(9)] = inst_112068);

(statearr_112095[(10)] = inst_112071);

return statearr_112095;
})();
var statearr_112096_112115 = state_112093__$1;
(statearr_112096_112115[(2)] = null);

(statearr_112096_112115[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112094 === (1))){
var state_112093__$1 = state_112093;
var statearr_112097_112116 = state_112093__$1;
(statearr_112097_112116[(2)] = null);

(statearr_112097_112116[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112094 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_112093,(3),Error,null,(2));
var inst_112045 = (tt_id == null);
var state_112093__$1 = state_112093;
if(cljs.core.truth_(inst_112045)){
var statearr_112098_112117 = state_112093__$1;
(statearr_112098_112117[(1)] = (5));

} else {
var statearr_112099_112118 = state_112093__$1;
(statearr_112099_112118[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112094 === (13))){
var inst_112078 = (state_112093[(11)]);
var inst_112082 = (state_112093[(2)]);
var inst_112083 = fluree.db.util.async.throw_err(inst_112082);
var inst_112070 = inst_112083;
var inst_112071 = inst_112078;
var state_112093__$1 = (function (){var statearr_112100 = state_112093;
(statearr_112100[(8)] = inst_112070);

(statearr_112100[(10)] = inst_112071);

return statearr_112100;
})();
var statearr_112101_112119 = state_112093__$1;
(statearr_112101_112119[(2)] = null);

(statearr_112101_112119[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112094 === (6))){
var state_112093__$1 = state_112093;
var statearr_112102_112120 = state_112093__$1;
(statearr_112102_112120[(2)] = tt_id);

(statearr_112102_112120[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112094 === (3))){
var inst_112041 = (state_112093[(2)]);
var state_112093__$1 = state_112093;
var statearr_112103_112121 = state_112093__$1;
(statearr_112103_112121[(2)] = inst_112041);


cljs.core.async.impl.ioc_helpers.process_exception(state_112093__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_112094 === (12))){
var inst_112087 = (state_112093[(2)]);
var state_112093__$1 = state_112093;
var statearr_112104_112122 = state_112093__$1;
(statearr_112104_112122[(2)] = inst_112087);

(statearr_112104_112122[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112094 === (2))){
var inst_112091 = (state_112093[(2)]);
var state_112093__$1 = state_112093;
return cljs.core.async.impl.ioc_helpers.return_chan(state_112093__$1,inst_112091);
} else {
if((state_val_112094 === (11))){
var inst_112070 = (state_112093[(8)]);
var state_112093__$1 = state_112093;
var statearr_112105_112123 = state_112093__$1;
(statearr_112105_112123[(2)] = inst_112070);

(statearr_112105_112123[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112094 === (9))){
var inst_112089 = (state_112093[(2)]);
var state_112093__$1 = state_112093;
var statearr_112106_112124 = state_112093__$1;
(statearr_112106_112124[(2)] = inst_112089);


cljs.core.async.impl.ioc_helpers.process_exception(state_112093__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_112094 === (5))){
var inst_112047 = fluree.db.util.core.random_uuid();
var state_112093__$1 = state_112093;
var statearr_112107_112125 = state_112093__$1;
(statearr_112107_112125[(2)] = inst_112047);

(statearr_112107_112125[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112094 === (10))){
var inst_112077 = (state_112093[(12)]);
var inst_112070 = (state_112093[(8)]);
var inst_112080 = fluree.db.graphdb.with_t(inst_112070,inst_112077);
var state_112093__$1 = state_112093;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_112093__$1,(13),inst_112080);
} else {
if((state_val_112094 === (8))){
var inst_112077 = (state_112093[(12)]);
var inst_112071 = (state_112093[(10)]);
var inst_112076 = cljs.core.seq(inst_112071);
var inst_112077__$1 = cljs.core.first(inst_112076);
var inst_112078 = cljs.core.next(inst_112076);
var state_112093__$1 = (function (){var statearr_112108 = state_112093;
(statearr_112108[(12)] = inst_112077__$1);

(statearr_112108[(11)] = inst_112078);

return statearr_112108;
})();
if(cljs.core.truth_(inst_112077__$1)){
var statearr_112109_112126 = state_112093__$1;
(statearr_112109_112126[(1)] = (10));

} else {
var statearr_112110_112127 = state_112093__$1;
(statearr_112110_112127[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__99037__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__99037__auto____0 = (function (){
var statearr_112111 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_112111[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__99037__auto__);

(statearr_112111[(1)] = (1));

return statearr_112111;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__99037__auto____1 = (function (state_112093){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_112093);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e112112){if((e112112 instanceof Object)){
var ex__99040__auto__ = e112112;
var statearr_112113_112128 = state_112093;
(statearr_112113_112128[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_112093);

return cljs.core.cst$kw$recur;
} else {
throw e112112;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__112129 = state_112093;
state_112093 = G__112129;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__99037__auto__ = function(state_112093){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__99037__auto____1.call(this,state_112093);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__99037__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__99037__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_112114 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_112114[(6)] = c__99059__auto__);

return statearr_112114;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__99059__auto___112298 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto___112298,return_chan){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto___112298,return_chan){
return (function (state_112241){
var state_val_112242 = (state_112241[(1)]);
if((state_val_112242 === (7))){
var inst_112212 = (state_112241[(7)]);
var inst_112212__$1 = (state_112241[(2)]);
var state_112241__$1 = (function (){var statearr_112243 = state_112241;
(statearr_112243[(7)] = inst_112212__$1);

return statearr_112243;
})();
if(cljs.core.truth_(inst_112212__$1)){
var statearr_112244_112299 = state_112241__$1;
(statearr_112244_112299[(1)] = (28));

} else {
var statearr_112245_112300 = state_112241__$1;
(statearr_112245_112300[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112242 === (20))){
var inst_112182 = (state_112241[(8)]);
var inst_112186 = cljs.core.first(inst_112182);
var state_112241__$1 = state_112241;
var statearr_112246_112301 = state_112241__$1;
(statearr_112246_112301[(2)] = inst_112186);

(statearr_112246_112301[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112242 === (27))){
var inst_112206 = (state_112241[(2)]);
var state_112241__$1 = state_112241;
var statearr_112247_112302 = state_112241__$1;
(statearr_112247_112302[(2)] = inst_112206);

(statearr_112247_112302[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112242 === (1))){
var state_112241__$1 = state_112241;
var statearr_112248_112303 = state_112241__$1;
(statearr_112248_112303[(2)] = null);

(statearr_112248_112303[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112242 === (24))){
var inst_112194 = (state_112241[(2)]);
var state_112241__$1 = state_112241;
var statearr_112249_112304 = state_112241__$1;
(statearr_112249_112304[(2)] = inst_112194);

(statearr_112249_112304[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112242 === (39))){
var inst_112233 = (state_112241[(2)]);
var state_112241__$1 = state_112241;
var statearr_112250_112305 = state_112241__$1;
(statearr_112250_112305[(2)] = inst_112233);

(statearr_112250_112305[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112242 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_112241,(3),java.lang.Exception,null,(2));
var inst_112140 = typeof ident === 'number';
var state_112241__$1 = state_112241;
if(cljs.core.truth_(inst_112140)){
var statearr_112251_112306 = state_112241__$1;
(statearr_112251_112306[(1)] = (5));

} else {
var statearr_112252_112307 = state_112241__$1;
(statearr_112252_112307[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112242 === (15))){
var inst_112173 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_112174 = cljs.core.first(ident);
var inst_112175 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,inst_112174);
var inst_112176 = cljs.core.second(ident);
var inst_112177 = [inst_112175,inst_112176];
var inst_112178 = (new cljs.core.PersistentVector(null,2,(5),inst_112173,inst_112177,null));
var inst_112179 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_112178);
var state_112241__$1 = state_112241;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_112241__$1,(18),inst_112179);
} else {
if((state_val_112242 === (21))){
var inst_112188 = (state_112241[(9)]);
var inst_112188__$1 = (state_112241[(2)]);
var inst_112189 = (inst_112188__$1 == null);
var state_112241__$1 = (function (){var statearr_112253 = state_112241;
(statearr_112253[(9)] = inst_112188__$1);

return statearr_112253;
})();
if(cljs.core.truth_(inst_112189)){
var statearr_112254_112308 = state_112241__$1;
(statearr_112254_112308[(1)] = (22));

} else {
var statearr_112255_112309 = state_112241__$1;
(statearr_112255_112309[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112242 === (31))){
var state_112241__$1 = state_112241;
var statearr_112256_112310 = state_112241__$1;
(statearr_112256_112310[(2)] = strict_QMARK_);

(statearr_112256_112310[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112242 === (32))){
var inst_112216 = (state_112241[(10)]);
var state_112241__$1 = state_112241;
var statearr_112257_112311 = state_112241__$1;
(statearr_112257_112311[(2)] = inst_112216);

(statearr_112257_112311[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112242 === (33))){
var inst_112220 = (state_112241[(2)]);
var state_112241__$1 = state_112241;
if(cljs.core.truth_(inst_112220)){
var statearr_112258_112312 = state_112241__$1;
(statearr_112258_112312[(1)] = (34));

} else {
var statearr_112259_112313 = state_112241__$1;
(statearr_112259_112313[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112242 === (13))){
var inst_112170 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_112241__$1 = state_112241;
if(inst_112170){
var statearr_112260_112314 = state_112241__$1;
(statearr_112260_112314[(1)] = (15));

} else {
var statearr_112261_112315 = state_112241__$1;
(statearr_112261_112315[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112242 === (22))){
var state_112241__$1 = state_112241;
var statearr_112262_112316 = state_112241__$1;
(statearr_112262_112316[(2)] = null);

(statearr_112262_112316[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112242 === (36))){
var inst_112235 = (state_112241[(2)]);
var state_112241__$1 = state_112241;
var statearr_112263_112317 = state_112241__$1;
(statearr_112263_112317[(2)] = inst_112235);

(statearr_112263_112317[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112242 === (29))){
var inst_112212 = (state_112241[(7)]);
var inst_112216 = (state_112241[(10)]);
var inst_112216__$1 = (inst_112212 == null);
var state_112241__$1 = (function (){var statearr_112264 = state_112241;
(statearr_112264[(10)] = inst_112216__$1);

return statearr_112264;
})();
if(cljs.core.truth_(inst_112216__$1)){
var statearr_112265_112318 = state_112241__$1;
(statearr_112265_112318[(1)] = (31));

} else {
var statearr_112266_112319 = state_112241__$1;
(statearr_112266_112319[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112242 === (6))){
var inst_112155 = fluree.db.util.core.pred_ident_QMARK_(ident);
var inst_112156 = cljs.core.first(ident);
var inst_112157 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,inst_112156);
var inst_112158 = (inst_112157 == null);
var inst_112159 = ((inst_112155) && (inst_112158));
var state_112241__$1 = state_112241;
if(cljs.core.truth_(inst_112159)){
var statearr_112267_112320 = state_112241__$1;
(statearr_112267_112320[(1)] = (12));

} else {
var statearr_112268_112321 = state_112241__$1;
(statearr_112268_112321[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112242 === (28))){
var inst_112212 = (state_112241[(7)]);
var inst_112214 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_112212);
var state_112241__$1 = state_112241;
var statearr_112269_112322 = state_112241__$1;
(statearr_112269_112322[(2)] = inst_112214);

(statearr_112269_112322[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112242 === (25))){
var inst_112197 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ident], 0));
var inst_112198 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_112197].join('');
var inst_112199 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_112200 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_ident];
var inst_112201 = cljs.core.PersistentHashMap.fromArrays(inst_112199,inst_112200);
var inst_112202 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_112198,inst_112201);
var inst_112203 = (function(){throw inst_112202})();
var state_112241__$1 = state_112241;
var statearr_112270_112323 = state_112241__$1;
(statearr_112270_112323[(2)] = inst_112203);

(statearr_112270_112323[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112242 === (34))){
var inst_112222 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_112223 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_112224 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_subject];
var inst_112225 = cljs.core.PersistentHashMap.fromArrays(inst_112223,inst_112224);
var inst_112226 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_112222,inst_112225);
var inst_112227 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_112226);
var state_112241__$1 = state_112241;
var statearr_112271_112324 = state_112241__$1;
(statearr_112271_112324[(2)] = inst_112227);

(statearr_112271_112324[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112242 === (17))){
var inst_112208 = (state_112241[(2)]);
var state_112241__$1 = state_112241;
var statearr_112272_112325 = state_112241__$1;
(statearr_112272_112325[(2)] = inst_112208);

(statearr_112272_112325[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112242 === (3))){
var inst_112130 = (state_112241[(2)]);
var inst_112131 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_112132 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_112133 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_subject];
var inst_112134 = cljs.core.PersistentHashMap.fromArrays(inst_112132,inst_112133);
var inst_112135 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(inst_112131,inst_112134,inst_112130);
var inst_112136 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_112135);
var state_112241__$1 = state_112241;
var statearr_112273_112326 = state_112241__$1;
(statearr_112273_112326[(2)] = inst_112136);


cljs.core.async.impl.ioc_helpers.process_exception(state_112241__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_112242 === (12))){
var inst_112161 = cljs.core.first(ident);
var inst_112162 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_112161], 0));
var inst_112163 = ["Subject ID lookup failed. The predicate ",inst_112162," does not exist."].join('');
var inst_112164 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_112165 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_ident];
var inst_112166 = cljs.core.PersistentHashMap.fromArrays(inst_112164,inst_112165);
var inst_112167 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_112163,inst_112166);
var inst_112168 = (function(){throw inst_112167})();
var state_112241__$1 = state_112241;
var statearr_112274_112327 = state_112241__$1;
(statearr_112274_112327[(2)] = inst_112168);

(statearr_112274_112327[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112242 === (2))){
var inst_112239 = (state_112241[(2)]);
var state_112241__$1 = state_112241;
return cljs.core.async.impl.ioc_helpers.return_chan(state_112241__$1,inst_112239);
} else {
if((state_val_112242 === (23))){
var inst_112188 = (state_112241[(9)]);
var inst_112192 = inst_112188.s;
var state_112241__$1 = state_112241;
var statearr_112275_112328 = state_112241__$1;
(statearr_112275_112328[(2)] = inst_112192);

(statearr_112275_112328[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112242 === (35))){
var state_112241__$1 = state_112241;
var statearr_112276_112329 = state_112241__$1;
(statearr_112276_112329[(1)] = (37));



return cljs.core.cst$kw$recur;
} else {
if((state_val_112242 === (19))){
var state_112241__$1 = state_112241;
var statearr_112278_112330 = state_112241__$1;
(statearr_112278_112330[(2)] = null);

(statearr_112278_112330[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112242 === (11))){
var inst_112153 = (state_112241[(2)]);
var state_112241__$1 = state_112241;
var statearr_112279_112331 = state_112241__$1;
(statearr_112279_112331[(2)] = inst_112153);

(statearr_112279_112331[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112242 === (9))){
var state_112241__$1 = state_112241;
var statearr_112280_112332 = state_112241__$1;
(statearr_112280_112332[(2)] = ident);

(statearr_112280_112332[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112242 === (5))){
var inst_112142 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_112143 = [ident];
var inst_112144 = (new cljs.core.PersistentVector(null,1,(5),inst_112142,inst_112143,null));
var inst_112145 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_112144);
var state_112241__$1 = state_112241;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_112241__$1,(8),inst_112145);
} else {
if((state_val_112242 === (14))){
var inst_112210 = (state_112241[(2)]);
var state_112241__$1 = state_112241;
var statearr_112281_112333 = state_112241__$1;
(statearr_112281_112333[(2)] = inst_112210);

(statearr_112281_112333[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112242 === (26))){
var state_112241__$1 = state_112241;
var statearr_112282_112334 = state_112241__$1;
(statearr_112282_112334[(2)] = null);

(statearr_112282_112334[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112242 === (16))){
var state_112241__$1 = state_112241;
var statearr_112283_112335 = state_112241__$1;
(statearr_112283_112335[(1)] = (25));



return cljs.core.cst$kw$recur;
} else {
if((state_val_112242 === (38))){
var state_112241__$1 = state_112241;
var statearr_112285_112336 = state_112241__$1;
(statearr_112285_112336[(2)] = null);

(statearr_112285_112336[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112242 === (30))){
var inst_112237 = (state_112241[(2)]);
var state_112241__$1 = state_112241;
var statearr_112286_112337 = state_112241__$1;
(statearr_112286_112337[(2)] = inst_112237);


cljs.core.async.impl.ioc_helpers.process_exception(state_112241__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_112242 === (10))){
var state_112241__$1 = state_112241;
var statearr_112287_112338 = state_112241__$1;
(statearr_112287_112338[(2)] = null);

(statearr_112287_112338[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112242 === (18))){
var inst_112182 = (state_112241[(8)]);
var inst_112181 = (state_112241[(2)]);
var inst_112182__$1 = fluree.db.util.async.throw_err(inst_112181);
var inst_112183 = (inst_112182__$1 == null);
var state_112241__$1 = (function (){var statearr_112288 = state_112241;
(statearr_112288[(8)] = inst_112182__$1);

return statearr_112288;
})();
if(cljs.core.truth_(inst_112183)){
var statearr_112289_112339 = state_112241__$1;
(statearr_112289_112339[(1)] = (19));

} else {
var statearr_112290_112340 = state_112241__$1;
(statearr_112290_112340[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112242 === (37))){
var inst_112230 = cljs.core.async.close_BANG_(return_chan);
var state_112241__$1 = state_112241;
var statearr_112291_112341 = state_112241__$1;
(statearr_112291_112341[(2)] = inst_112230);

(statearr_112291_112341[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112242 === (8))){
var inst_112147 = (state_112241[(2)]);
var inst_112148 = fluree.db.util.async.throw_err(inst_112147);
var inst_112149 = cljs.core.not_empty(inst_112148);
var state_112241__$1 = state_112241;
if(cljs.core.truth_(inst_112149)){
var statearr_112292_112342 = state_112241__$1;
(statearr_112292_112342[(1)] = (9));

} else {
var statearr_112293_112343 = state_112241__$1;
(statearr_112293_112343[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto___112298,return_chan))
;
return ((function (switch__99036__auto__,c__99059__auto___112298,return_chan){
return (function() {
var fluree$db$graphdb$subid_$_state_machine__99037__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__99037__auto____0 = (function (){
var statearr_112294 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_112294[(0)] = fluree$db$graphdb$subid_$_state_machine__99037__auto__);

(statearr_112294[(1)] = (1));

return statearr_112294;
});
var fluree$db$graphdb$subid_$_state_machine__99037__auto____1 = (function (state_112241){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_112241);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e112295){if((e112295 instanceof Object)){
var ex__99040__auto__ = e112295;
var statearr_112296_112344 = state_112241;
(statearr_112296_112344[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_112241);

return cljs.core.cst$kw$recur;
} else {
throw e112295;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__112345 = state_112241;
state_112241 = G__112345;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__99037__auto__ = function(state_112241){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__99037__auto____1.call(this,state_112241);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__99037__auto____0;
fluree$db$graphdb$subid_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__99037__auto____1;
return fluree$db$graphdb$subid_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto___112298,return_chan))
})();
var state__99061__auto__ = (function (){var statearr_112297 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_112297[(6)] = c__99059__auto___112298);

return statearr_112297;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto___112298,return_chan))
);


return return_chan;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.schema = schema;
this.settings = settings;
this.index_configs = index_configs;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4385__auto__,k__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
return this__4385__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4386__auto__,null);
});

fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4387__auto__,k112347,else__4388__auto__){
var self__ = this;
var this__4387__auto____$1 = this;
var G__112351 = k112347;
var G__112351__$1 = (((G__112351 instanceof cljs.core.Keyword))?G__112351.fqn:null);
switch (G__112351__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "index-configs":
return self__.index_configs;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k112347,else__4388__auto__);

}
});

fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4404__auto__,f__4405__auto__,init__4406__auto__){
var self__ = this;
var this__4404__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (this__4404__auto____$1){
return (function (ret__4407__auto__,p__112352){
var vec__112353 = p__112352;
var k__4408__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__112353,(0),null);
var v__4409__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__112353,(1),null);
return (f__4405__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4405__auto__.cljs$core$IFn$_invoke$arity$3(ret__4407__auto__,k__4408__auto__,v__4409__auto__) : f__4405__auto__.call(null,ret__4407__auto__,k__4408__auto__,v__4409__auto__));
});})(this__4404__auto____$1))
,init__4406__auto__,this__4404__auto____$1);
});

fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4399__auto__,writer__4400__auto__,opts__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
var pr_pair__4402__auto__ = ((function (this__4399__auto____$1){
return (function (keyval__4403__auto__){
return cljs.core.pr_sequential_writer(writer__4400__auto__,cljs.core.pr_writer,""," ","",opts__4401__auto__,keyval__4403__auto__);
});})(this__4399__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__4400__auto__,pr_pair__4402__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__4401__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tt_DASH_id,self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$stats,self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$spot,self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$psot,self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$post,self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$opst,self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema,self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$settings,self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$index_DASH_configs,self__.index_configs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$novelty,self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$permissions,self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$fork,self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$fork_DASH_block,self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$current_DASH_db_DASH_fn,self__.current_db_fn],null))], null),self__.__extmap));
});

fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__112346){
var self__ = this;
var G__112346__$1 = this;
return (new cljs.core.RecordIter((0),G__112346__$1,20,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$schema,cljs.core.cst$kw$settings,cljs.core.cst$kw$index_DASH_configs,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$novelty,cljs.core.cst$kw$permissions,cljs.core.cst$kw$fork,cljs.core.cst$kw$fork_DASH_block,cljs.core.cst$kw$current_DASH_db_DASH_fn], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4383__auto__){
var self__ = this;
var this__4383__auto____$1 = this;
return self__.__meta;
});

fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4380__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
});

fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4389__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
return (20 + cljs.core.count(self__.__extmap));
});

fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4381__auto__){
var self__ = this;
var this__4381__auto____$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = (function (){var fexpr__112356 = ((function (h__4243__auto__,this__4381__auto____$1){
return (function (coll__4382__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll(coll__4382__auto__));
});})(h__4243__auto__,this__4381__auto____$1))
;
return fexpr__112356(this__4381__auto____$1);
})();
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this112348,other112349){
var self__ = this;
var this112348__$1 = this;
return (((!((other112349 == null)))) && ((this112348__$1.constructor === other112349.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this112348__$1.conn,other112349.conn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this112348__$1.network,other112349.network)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this112348__$1.dbid,other112349.dbid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this112348__$1.block,other112349.block)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this112348__$1.t,other112349.t)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this112348__$1.tt_id,other112349.tt_id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this112348__$1.stats,other112349.stats)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this112348__$1.spot,other112349.spot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this112348__$1.psot,other112349.psot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this112348__$1.post,other112349.post)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this112348__$1.opst,other112349.opst)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this112348__$1.schema,other112349.schema)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this112348__$1.settings,other112349.settings)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this112348__$1.index_configs,other112349.index_configs)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this112348__$1.schema_cache,other112349.schema_cache)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this112348__$1.novelty,other112349.novelty)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this112348__$1.permissions,other112349.permissions)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this112348__$1.fork,other112349.fork)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this112348__$1.fork_block,other112349.fork_block)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this112348__$1.current_db_fn,other112349.current_db_fn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this112348__$1.__extmap,other112349.__extmap)));
});

fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4394__auto__,k__4395__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [cljs.core.cst$kw$current_DASH_db_DASH_fn,null,cljs.core.cst$kw$schema,null,cljs.core.cst$kw$block,null,cljs.core.cst$kw$psot,null,cljs.core.cst$kw$permissions,null,cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$settings,null,cljs.core.cst$kw$index_DASH_configs,null,cljs.core.cst$kw$opst,null,cljs.core.cst$kw$fork_DASH_block,null,cljs.core.cst$kw$schema_DASH_cache,null,cljs.core.cst$kw$post,null,cljs.core.cst$kw$novelty,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$fork,null,cljs.core.cst$kw$tt_DASH_id,null,cljs.core.cst$kw$stats,null,cljs.core.cst$kw$spot,null,cljs.core.cst$kw$conn,null], null), null),k__4395__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4394__auto____$1),self__.__meta),k__4395__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4395__auto__)),null));
}
});

fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4392__auto__,k__4393__auto__,G__112346){
var self__ = this;
var this__4392__auto____$1 = this;
var pred__112357 = cljs.core.keyword_identical_QMARK_;
var expr__112358 = k__4393__auto__;
if(cljs.core.truth_((function (){var G__112360 = cljs.core.cst$kw$conn;
var G__112361 = expr__112358;
return (pred__112357.cljs$core$IFn$_invoke$arity$2 ? pred__112357.cljs$core$IFn$_invoke$arity$2(G__112360,G__112361) : pred__112357.call(null,G__112360,G__112361));
})())){
return (new fluree.db.graphdb.GraphDb(G__112346,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__112362 = cljs.core.cst$kw$network;
var G__112363 = expr__112358;
return (pred__112357.cljs$core$IFn$_invoke$arity$2 ? pred__112357.cljs$core$IFn$_invoke$arity$2(G__112362,G__112363) : pred__112357.call(null,G__112362,G__112363));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__112346,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__112364 = cljs.core.cst$kw$dbid;
var G__112365 = expr__112358;
return (pred__112357.cljs$core$IFn$_invoke$arity$2 ? pred__112357.cljs$core$IFn$_invoke$arity$2(G__112364,G__112365) : pred__112357.call(null,G__112364,G__112365));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__112346,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__112366 = cljs.core.cst$kw$block;
var G__112367 = expr__112358;
return (pred__112357.cljs$core$IFn$_invoke$arity$2 ? pred__112357.cljs$core$IFn$_invoke$arity$2(G__112366,G__112367) : pred__112357.call(null,G__112366,G__112367));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,G__112346,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__112368 = cljs.core.cst$kw$t;
var G__112369 = expr__112358;
return (pred__112357.cljs$core$IFn$_invoke$arity$2 ? pred__112357.cljs$core$IFn$_invoke$arity$2(G__112368,G__112369) : pred__112357.call(null,G__112368,G__112369));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,G__112346,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__112370 = cljs.core.cst$kw$tt_DASH_id;
var G__112371 = expr__112358;
return (pred__112357.cljs$core$IFn$_invoke$arity$2 ? pred__112357.cljs$core$IFn$_invoke$arity$2(G__112370,G__112371) : pred__112357.call(null,G__112370,G__112371));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,G__112346,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__112372 = cljs.core.cst$kw$stats;
var G__112373 = expr__112358;
return (pred__112357.cljs$core$IFn$_invoke$arity$2 ? pred__112357.cljs$core$IFn$_invoke$arity$2(G__112372,G__112373) : pred__112357.call(null,G__112372,G__112373));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,G__112346,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__112374 = cljs.core.cst$kw$spot;
var G__112375 = expr__112358;
return (pred__112357.cljs$core$IFn$_invoke$arity$2 ? pred__112357.cljs$core$IFn$_invoke$arity$2(G__112374,G__112375) : pred__112357.call(null,G__112374,G__112375));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,G__112346,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__112376 = cljs.core.cst$kw$psot;
var G__112377 = expr__112358;
return (pred__112357.cljs$core$IFn$_invoke$arity$2 ? pred__112357.cljs$core$IFn$_invoke$arity$2(G__112376,G__112377) : pred__112357.call(null,G__112376,G__112377));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__112346,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__112378 = cljs.core.cst$kw$post;
var G__112379 = expr__112358;
return (pred__112357.cljs$core$IFn$_invoke$arity$2 ? pred__112357.cljs$core$IFn$_invoke$arity$2(G__112378,G__112379) : pred__112357.call(null,G__112378,G__112379));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__112346,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__112380 = cljs.core.cst$kw$opst;
var G__112381 = expr__112358;
return (pred__112357.cljs$core$IFn$_invoke$arity$2 ? pred__112357.cljs$core$IFn$_invoke$arity$2(G__112380,G__112381) : pred__112357.call(null,G__112380,G__112381));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__112346,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__112382 = cljs.core.cst$kw$schema;
var G__112383 = expr__112358;
return (pred__112357.cljs$core$IFn$_invoke$arity$2 ? pred__112357.cljs$core$IFn$_invoke$arity$2(G__112382,G__112383) : pred__112357.call(null,G__112382,G__112383));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__112346,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__112384 = cljs.core.cst$kw$settings;
var G__112385 = expr__112358;
return (pred__112357.cljs$core$IFn$_invoke$arity$2 ? pred__112357.cljs$core$IFn$_invoke$arity$2(G__112384,G__112385) : pred__112357.call(null,G__112384,G__112385));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,G__112346,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__112386 = cljs.core.cst$kw$index_DASH_configs;
var G__112387 = expr__112358;
return (pred__112357.cljs$core$IFn$_invoke$arity$2 ? pred__112357.cljs$core$IFn$_invoke$arity$2(G__112386,G__112387) : pred__112357.call(null,G__112386,G__112387));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,G__112346,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__112388 = cljs.core.cst$kw$schema_DASH_cache;
var G__112389 = expr__112358;
return (pred__112357.cljs$core$IFn$_invoke$arity$2 ? pred__112357.cljs$core$IFn$_invoke$arity$2(G__112388,G__112389) : pred__112357.call(null,G__112388,G__112389));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,G__112346,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__112390 = cljs.core.cst$kw$novelty;
var G__112391 = expr__112358;
return (pred__112357.cljs$core$IFn$_invoke$arity$2 ? pred__112357.cljs$core$IFn$_invoke$arity$2(G__112390,G__112391) : pred__112357.call(null,G__112390,G__112391));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,G__112346,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__112392 = cljs.core.cst$kw$permissions;
var G__112393 = expr__112358;
return (pred__112357.cljs$core$IFn$_invoke$arity$2 ? pred__112357.cljs$core$IFn$_invoke$arity$2(G__112392,G__112393) : pred__112357.call(null,G__112392,G__112393));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,G__112346,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__112394 = cljs.core.cst$kw$fork;
var G__112395 = expr__112358;
return (pred__112357.cljs$core$IFn$_invoke$arity$2 ? pred__112357.cljs$core$IFn$_invoke$arity$2(G__112394,G__112395) : pred__112357.call(null,G__112394,G__112395));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,G__112346,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__112396 = cljs.core.cst$kw$fork_DASH_block;
var G__112397 = expr__112358;
return (pred__112357.cljs$core$IFn$_invoke$arity$2 ? pred__112357.cljs$core$IFn$_invoke$arity$2(G__112396,G__112397) : pred__112357.call(null,G__112396,G__112397));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__112346,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__112398 = cljs.core.cst$kw$current_DASH_db_DASH_fn;
var G__112399 = expr__112358;
return (pred__112357.cljs$core$IFn$_invoke$arity$2 ? pred__112357.cljs$core$IFn$_invoke$arity$2(G__112398,G__112399) : pred__112357.call(null,G__112398,G__112399));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__112346,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4393__auto__,G__112346),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});

fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4397__auto__){
var self__ = this;
var this__4397__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tt_DASH_id,self__.tt_id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$stats,self__.stats,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$spot,self__.spot,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$psot,self__.psot,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$post,self__.post,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$opst,self__.opst,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema,self__.schema,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$settings,self__.settings,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$index_DASH_configs,self__.index_configs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$novelty,self__.novelty,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$permissions,self__.permissions,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$fork,self__.fork,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$fork_DASH_block,self__.fork_block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$current_DASH_db_DASH_fn,self__.current_db_fn,null))], null),self__.__extmap));
});

fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4384__auto__,G__112346){
var self__ = this;
var this__4384__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__112346,self__.__extmap,self__.__hash));
});

fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4390__auto__,entry__4391__auto__){
var self__ = this;
var this__4390__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4391__auto__)){
return this__4390__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4390__auto____$1,entry__4391__auto__);
}
});

fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL;

fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__,this$__$1){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__,this$__$1){
return (function (state_112412){
var state_val_112413 = (state_112412[(1)]);
if((state_val_112413 === (1))){
var state_112412__$1 = state_112412;
var statearr_112414_112632 = state_112412__$1;
(statearr_112414_112632[(2)] = null);

(statearr_112414_112632[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112413 === (2))){
var inst_112410 = (state_112412[(2)]);
var state_112412__$1 = state_112412;
return cljs.core.async.impl.ioc_helpers.return_chan(state_112412__$1,inst_112410);
} else {
if((state_val_112413 === (3))){
var inst_112400 = (state_112412[(2)]);
var state_112412__$1 = state_112412;
var statearr_112415_112633 = state_112412__$1;
(statearr_112415_112633[(2)] = inst_112400);


cljs.core.async.impl.ioc_helpers.process_exception(state_112412__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_112413 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_112412,(3),Error,null,(2));
var inst_112404 = (self__.current_db_fn.cljs$core$IFn$_invoke$arity$0 ? self__.current_db_fn.cljs$core$IFn$_invoke$arity$0() : self__.current_db_fn.call(null));
var state_112412__$1 = state_112412;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_112412__$1,(5),inst_112404);
} else {
if((state_val_112413 === (5))){
var inst_112406 = (state_112412[(2)]);
var inst_112407 = fluree.db.util.async.throw_err(inst_112406);
var inst_112408 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_112407,cljs.core.cst$kw$permissions,self__.permissions);
var state_112412__$1 = state_112412;
var statearr_112416_112634 = state_112412__$1;
(statearr_112416_112634[(2)] = inst_112408);


cljs.core.async.impl.ioc_helpers.process_exception(state_112412__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__99059__auto__,this$__$1))
;
return ((function (switch__99036__auto__,c__99059__auto__,this$__$1){
return (function() {
var fluree$db$graphdb$state_machine__99037__auto__ = null;
var fluree$db$graphdb$state_machine__99037__auto____0 = (function (){
var statearr_112417 = [null,null,null,null,null,null,null];
(statearr_112417[(0)] = fluree$db$graphdb$state_machine__99037__auto__);

(statearr_112417[(1)] = (1));

return statearr_112417;
});
var fluree$db$graphdb$state_machine__99037__auto____1 = (function (state_112412){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_112412);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e112418){if((e112418 instanceof Object)){
var ex__99040__auto__ = e112418;
var statearr_112419_112635 = state_112412;
(statearr_112419_112635[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_112412);

return cljs.core.cst$kw$recur;
} else {
throw e112418;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__112636 = state_112412;
state_112412 = G__112636;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__99037__auto__ = function(state_112412){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__99037__auto____1.call(this,state_112412);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__99037__auto____0;
fluree$db$graphdb$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__99037__auto____1;
return fluree$db$graphdb$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__,this$__$1))
})();
var state__99061__auto__ = (function (){var statearr_112420 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_112420[(6)] = c__99059__auto__);

return statearr_112420;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__,this$__$1))
);

return c__99059__auto__;
});

fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx(this$__$1,pred_id);
});

fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_((function (){var fexpr__112421 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$sid,null], null), null);
return (fexpr__112421.cljs$core$IFn$_invoke$arity$1 ? fexpr__112421.cljs$core$IFn$_invoke$arity$1(property) : fexpr__112421.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:name :id :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_(collection)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$coll,"_tx",property], null));
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$coll,collection,property], null));
}
});

fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_((function (){var fexpr__112422 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 17, [cljs.core.cst$kw$unique,null,cljs.core.cst$kw$restrictCollection,null,cljs.core.cst$kw$index,null,cljs.core.cst$kw$name,null,cljs.core.cst$kw$noHistory,null,cljs.core.cst$kw$type,null,cljs.core.cst$kw$txSpec,null,cljs.core.cst$kw$component,null,cljs.core.cst$kw$txSpecDoc,null,cljs.core.cst$kw$spec,null,cljs.core.cst$kw$multi,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$specDoc,null,cljs.core.cst$kw$idx_QMARK_,null,cljs.core.cst$kw$ref_QMARK_,null,cljs.core.cst$kw$upsert,null,cljs.core.cst$kw$restrictTag,null], null), null);
return (fexpr__112422.cljs$core$IFn$_invoke$arity$1 ? fexpr__112422.cljs$core$IFn$_invoke$arity$1(property) : fexpr__112422.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :restrictTag} property)"].join('')));
}

var G__112423 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pred,predicate,property], null));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$restrictCollection,property)){
return this$__$1.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3(null,cljs.core.cst$kw$id,G__112423);
} else {
return G__112423;
}
});

fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$(this$__$1,block__$1,flakes);
});

fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,false);
});

fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,strict_QMARK_);
});

fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2(this$__$1,fparts);
});

fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(this$__$1,cljs.core.cst$kw$permissions,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$root_QMARK_,true,cljs.core.cst$kw$collection,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null),cljs.core.cst$kw$predicate,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null)], null));
});

fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,null,flakes);
});

fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,tt_id__$1,flakes);
});

fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query(this$__$1,query_map);
});

fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t(this$__$1,flakes);
});

fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__,this$__$1){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__,this$__$1){
return (function (state_112452){
var state_val_112453 = (state_112452[(1)]);
if((state_val_112453 === (7))){
var inst_112436 = (state_112452[(7)]);
var inst_112440 = cljs.core.first(inst_112436);
var state_112452__$1 = state_112452;
var statearr_112454_112637 = state_112452__$1;
(statearr_112454_112637[(2)] = inst_112440);

(statearr_112454_112637[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112453 === (1))){
var state_112452__$1 = state_112452;
var statearr_112455_112638 = state_112452__$1;
(statearr_112455_112638[(2)] = null);

(statearr_112455_112638[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112453 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_112452,(3),Error,null,(2));
var inst_112429 = this$__$1.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1(null);
var inst_112430 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_112431 = [tag_id,(30)];
var inst_112432 = (new cljs.core.PersistentVector(null,2,(5),inst_112430,inst_112431,null));
var inst_112433 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_112429,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_112432);
var state_112452__$1 = state_112452;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_112452__$1,(5),inst_112433);
} else {
if((state_val_112453 === (6))){
var state_112452__$1 = state_112452;
var statearr_112456_112639 = state_112452__$1;
(statearr_112456_112639[(2)] = null);

(statearr_112456_112639[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112453 === (3))){
var inst_112424 = (state_112452[(2)]);
var state_112452__$1 = state_112452;
var statearr_112457_112640 = state_112452__$1;
(statearr_112457_112640[(2)] = inst_112424);


cljs.core.async.impl.ioc_helpers.process_exception(state_112452__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_112453 === (2))){
var inst_112450 = (state_112452[(2)]);
var state_112452__$1 = state_112452;
return cljs.core.async.impl.ioc_helpers.return_chan(state_112452__$1,inst_112450);
} else {
if((state_val_112453 === (11))){
var inst_112448 = (state_112452[(2)]);
var state_112452__$1 = state_112452;
var statearr_112458_112641 = state_112452__$1;
(statearr_112458_112641[(2)] = inst_112448);


cljs.core.async.impl.ioc_helpers.process_exception(state_112452__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_112453 === (9))){
var state_112452__$1 = state_112452;
var statearr_112459_112642 = state_112452__$1;
(statearr_112459_112642[(2)] = null);

(statearr_112459_112642[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112453 === (5))){
var inst_112436 = (state_112452[(7)]);
var inst_112435 = (state_112452[(2)]);
var inst_112436__$1 = fluree.db.util.async.throw_err(inst_112435);
var inst_112437 = (inst_112436__$1 == null);
var state_112452__$1 = (function (){var statearr_112460 = state_112452;
(statearr_112460[(7)] = inst_112436__$1);

return statearr_112460;
})();
if(cljs.core.truth_(inst_112437)){
var statearr_112461_112643 = state_112452__$1;
(statearr_112461_112643[(1)] = (6));

} else {
var statearr_112462_112644 = state_112452__$1;
(statearr_112462_112644[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112453 === (10))){
var inst_112442 = (state_112452[(8)]);
var inst_112446 = inst_112442.o;
var state_112452__$1 = state_112452;
var statearr_112463_112645 = state_112452__$1;
(statearr_112463_112645[(2)] = inst_112446);

(statearr_112463_112645[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112453 === (8))){
var inst_112442 = (state_112452[(8)]);
var inst_112442__$1 = (state_112452[(2)]);
var inst_112443 = (inst_112442__$1 == null);
var state_112452__$1 = (function (){var statearr_112464 = state_112452;
(statearr_112464[(8)] = inst_112442__$1);

return statearr_112464;
})();
if(cljs.core.truth_(inst_112443)){
var statearr_112465_112646 = state_112452__$1;
(statearr_112465_112646[(1)] = (9));

} else {
var statearr_112466_112647 = state_112452__$1;
(statearr_112466_112647[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__,this$__$1))
;
return ((function (switch__99036__auto__,c__99059__auto__,this$__$1){
return (function() {
var fluree$db$graphdb$state_machine__99037__auto__ = null;
var fluree$db$graphdb$state_machine__99037__auto____0 = (function (){
var statearr_112467 = [null,null,null,null,null,null,null,null,null];
(statearr_112467[(0)] = fluree$db$graphdb$state_machine__99037__auto__);

(statearr_112467[(1)] = (1));

return statearr_112467;
});
var fluree$db$graphdb$state_machine__99037__auto____1 = (function (state_112452){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_112452);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e112468){if((e112468 instanceof Object)){
var ex__99040__auto__ = e112468;
var statearr_112469_112648 = state_112452;
(statearr_112469_112648[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_112452);

return cljs.core.cst$kw$recur;
} else {
throw e112468;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__112649 = state_112452;
state_112452 = G__112649;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__99037__auto__ = function(state_112452){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__99037__auto____1.call(this,state_112452);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__99037__auto____0;
fluree$db$graphdb$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__99037__auto____1;
return fluree$db$graphdb$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__,this$__$1))
})();
var state__99061__auto__ = (function (){var statearr_112470 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_112470[(6)] = c__99059__auto__);

return statearr_112470;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__,this$__$1))
);

return c__99059__auto__;
});

fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__,this$__$1){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__,this$__$1){
return (function (state_112503){
var state_val_112504 = (state_112503[(1)]);
if((state_val_112504 === (7))){
var inst_112480 = (state_112503[(2)]);
var inst_112481 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag$arity$2(null,tag_id);
var state_112503__$1 = (function (){var statearr_112505 = state_112503;
(statearr_112505[(7)] = inst_112480);

return statearr_112505;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_112503__$1,(8),inst_112481);
} else {
if((state_val_112504 === (1))){
var state_112503__$1 = state_112503;
var statearr_112506_112650 = state_112503__$1;
(statearr_112506_112650[(2)] = null);

(statearr_112506_112650[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112504 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_112503,(3),Error,null,(2));
var inst_112475 = typeof pred === 'string';
var state_112503__$1 = state_112503;
if(cljs.core.truth_(inst_112475)){
var statearr_112507_112651 = state_112503__$1;
(statearr_112507_112651[(1)] = (5));

} else {
var statearr_112508_112652 = state_112503__$1;
(statearr_112508_112652[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112504 === (15))){
var inst_112484 = (state_112503[(8)]);
var inst_112492 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(inst_112484,/:/);
var inst_112493 = cljs.core.second(inst_112492);
var state_112503__$1 = state_112503;
var statearr_112509_112653 = state_112503__$1;
(statearr_112509_112653[(2)] = inst_112493);

(statearr_112509_112653[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112504 === (13))){
var state_112503__$1 = state_112503;
var statearr_112510_112654 = state_112503__$1;
(statearr_112510_112654[(2)] = null);

(statearr_112510_112654[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112504 === (6))){
var inst_112478 = this$__$1.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3(null,cljs.core.cst$kw$name,pred);
var state_112503__$1 = state_112503;
var statearr_112511_112655 = state_112503__$1;
(statearr_112511_112655[(2)] = inst_112478);

(statearr_112511_112655[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112504 === (17))){
var inst_112496 = (state_112503[(2)]);
var state_112503__$1 = state_112503;
var statearr_112512_112656 = state_112503__$1;
(statearr_112512_112656[(2)] = inst_112496);

(statearr_112512_112656[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112504 === (3))){
var inst_112471 = (state_112503[(2)]);
var state_112503__$1 = state_112503;
var statearr_112513_112657 = state_112503__$1;
(statearr_112513_112657[(2)] = inst_112471);


cljs.core.async.impl.ioc_helpers.process_exception(state_112503__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_112504 === (12))){
var inst_112484 = (state_112503[(8)]);
var inst_112490 = clojure.string.includes_QMARK_(inst_112484,":");
var state_112503__$1 = state_112503;
if(inst_112490){
var statearr_112514_112658 = state_112503__$1;
(statearr_112514_112658[(1)] = (15));

} else {
var statearr_112515_112659 = state_112503__$1;
(statearr_112515_112659[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112504 === (2))){
var inst_112501 = (state_112503[(2)]);
var state_112503__$1 = state_112503;
return cljs.core.async.impl.ioc_helpers.return_chan(state_112503__$1,inst_112501);
} else {
if((state_val_112504 === (11))){
var inst_112488 = (state_112503[(2)]);
var state_112503__$1 = state_112503;
if(cljs.core.truth_(inst_112488)){
var statearr_112516_112660 = state_112503__$1;
(statearr_112516_112660[(1)] = (12));

} else {
var statearr_112517_112661 = state_112503__$1;
(statearr_112517_112661[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112504 === (9))){
var inst_112484 = (state_112503[(8)]);
var state_112503__$1 = state_112503;
var statearr_112518_112662 = state_112503__$1;
(statearr_112518_112662[(2)] = inst_112484);

(statearr_112518_112662[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112504 === (5))){
var state_112503__$1 = state_112503;
var statearr_112519_112663 = state_112503__$1;
(statearr_112519_112663[(2)] = pred);

(statearr_112519_112663[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112504 === (14))){
var inst_112499 = (state_112503[(2)]);
var state_112503__$1 = state_112503;
var statearr_112520_112664 = state_112503__$1;
(statearr_112520_112664[(2)] = inst_112499);


cljs.core.async.impl.ioc_helpers.process_exception(state_112503__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_112504 === (16))){
var inst_112484 = (state_112503[(8)]);
var state_112503__$1 = state_112503;
var statearr_112521_112665 = state_112503__$1;
(statearr_112521_112665[(2)] = inst_112484);

(statearr_112521_112665[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112504 === (10))){
var inst_112480 = (state_112503[(7)]);
var state_112503__$1 = state_112503;
var statearr_112522_112666 = state_112503__$1;
(statearr_112522_112666[(2)] = inst_112480);

(statearr_112522_112666[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112504 === (8))){
var inst_112480 = (state_112503[(7)]);
var inst_112483 = (state_112503[(2)]);
var inst_112484 = fluree.db.util.async.throw_err(inst_112483);
var state_112503__$1 = (function (){var statearr_112523 = state_112503;
(statearr_112523[(8)] = inst_112484);

return statearr_112523;
})();
if(cljs.core.truth_(inst_112480)){
var statearr_112524_112667 = state_112503__$1;
(statearr_112524_112667[(1)] = (9));

} else {
var statearr_112525_112668 = state_112503__$1;
(statearr_112525_112668[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__,this$__$1))
;
return ((function (switch__99036__auto__,c__99059__auto__,this$__$1){
return (function() {
var fluree$db$graphdb$state_machine__99037__auto__ = null;
var fluree$db$graphdb$state_machine__99037__auto____0 = (function (){
var statearr_112526 = [null,null,null,null,null,null,null,null,null];
(statearr_112526[(0)] = fluree$db$graphdb$state_machine__99037__auto__);

(statearr_112526[(1)] = (1));

return statearr_112526;
});
var fluree$db$graphdb$state_machine__99037__auto____1 = (function (state_112503){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_112503);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e112527){if((e112527 instanceof Object)){
var ex__99040__auto__ = e112527;
var statearr_112528_112669 = state_112503;
(statearr_112528_112669[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_112503);

return cljs.core.cst$kw$recur;
} else {
throw e112527;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__112670 = state_112503;
state_112503 = G__112670;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__99037__auto__ = function(state_112503){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__99037__auto____1.call(this,state_112503);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__99037__auto____0;
fluree$db$graphdb$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__99037__auto____1;
return fluree$db$graphdb$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__,this$__$1))
})();
var state__99061__auto__ = (function (){var statearr_112529 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_112529[(6)] = c__99059__auto__);

return statearr_112529;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__,this$__$1))
);

return c__99059__auto__;
});

fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__,this$__$1){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__,this$__$1){
return (function (state_112558){
var state_val_112559 = (state_112558[(1)]);
if((state_val_112559 === (7))){
var inst_112542 = (state_112558[(7)]);
var inst_112546 = cljs.core.first(inst_112542);
var state_112558__$1 = state_112558;
var statearr_112560_112671 = state_112558__$1;
(statearr_112560_112671[(2)] = inst_112546);

(statearr_112560_112671[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112559 === (1))){
var state_112558__$1 = state_112558;
var statearr_112561_112672 = state_112558__$1;
(statearr_112561_112672[(2)] = null);

(statearr_112561_112672[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112559 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_112558,(3),Error,null,(2));
var inst_112535 = this$__$1.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1(null);
var inst_112536 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_112537 = [(30),tag_name];
var inst_112538 = (new cljs.core.PersistentVector(null,2,(5),inst_112536,inst_112537,null));
var inst_112539 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_112535,cljs.core.cst$kw$post,cljs.core._EQ_,inst_112538);
var state_112558__$1 = state_112558;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_112558__$1,(5),inst_112539);
} else {
if((state_val_112559 === (6))){
var state_112558__$1 = state_112558;
var statearr_112562_112673 = state_112558__$1;
(statearr_112562_112673[(2)] = null);

(statearr_112562_112673[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112559 === (3))){
var inst_112530 = (state_112558[(2)]);
var state_112558__$1 = state_112558;
var statearr_112563_112674 = state_112558__$1;
(statearr_112563_112674[(2)] = inst_112530);


cljs.core.async.impl.ioc_helpers.process_exception(state_112558__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_112559 === (2))){
var inst_112556 = (state_112558[(2)]);
var state_112558__$1 = state_112558;
return cljs.core.async.impl.ioc_helpers.return_chan(state_112558__$1,inst_112556);
} else {
if((state_val_112559 === (11))){
var inst_112554 = (state_112558[(2)]);
var state_112558__$1 = state_112558;
var statearr_112564_112675 = state_112558__$1;
(statearr_112564_112675[(2)] = inst_112554);


cljs.core.async.impl.ioc_helpers.process_exception(state_112558__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_112559 === (9))){
var state_112558__$1 = state_112558;
var statearr_112565_112676 = state_112558__$1;
(statearr_112565_112676[(2)] = null);

(statearr_112565_112676[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112559 === (5))){
var inst_112542 = (state_112558[(7)]);
var inst_112541 = (state_112558[(2)]);
var inst_112542__$1 = fluree.db.util.async.throw_err(inst_112541);
var inst_112543 = (inst_112542__$1 == null);
var state_112558__$1 = (function (){var statearr_112566 = state_112558;
(statearr_112566[(7)] = inst_112542__$1);

return statearr_112566;
})();
if(cljs.core.truth_(inst_112543)){
var statearr_112567_112677 = state_112558__$1;
(statearr_112567_112677[(1)] = (6));

} else {
var statearr_112568_112678 = state_112558__$1;
(statearr_112568_112678[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112559 === (10))){
var inst_112548 = (state_112558[(8)]);
var inst_112552 = inst_112548.s;
var state_112558__$1 = state_112558;
var statearr_112569_112679 = state_112558__$1;
(statearr_112569_112679[(2)] = inst_112552);

(statearr_112569_112679[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112559 === (8))){
var inst_112548 = (state_112558[(8)]);
var inst_112548__$1 = (state_112558[(2)]);
var inst_112549 = (inst_112548__$1 == null);
var state_112558__$1 = (function (){var statearr_112570 = state_112558;
(statearr_112570[(8)] = inst_112548__$1);

return statearr_112570;
})();
if(cljs.core.truth_(inst_112549)){
var statearr_112571_112680 = state_112558__$1;
(statearr_112571_112680[(1)] = (9));

} else {
var statearr_112572_112681 = state_112558__$1;
(statearr_112572_112681[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__,this$__$1))
;
return ((function (switch__99036__auto__,c__99059__auto__,this$__$1){
return (function() {
var fluree$db$graphdb$state_machine__99037__auto__ = null;
var fluree$db$graphdb$state_machine__99037__auto____0 = (function (){
var statearr_112573 = [null,null,null,null,null,null,null,null,null];
(statearr_112573[(0)] = fluree$db$graphdb$state_machine__99037__auto__);

(statearr_112573[(1)] = (1));

return statearr_112573;
});
var fluree$db$graphdb$state_machine__99037__auto____1 = (function (state_112558){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_112558);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e112574){if((e112574 instanceof Object)){
var ex__99040__auto__ = e112574;
var statearr_112575_112682 = state_112558;
(statearr_112575_112682[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_112558);

return cljs.core.cst$kw$recur;
} else {
throw e112574;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__112683 = state_112558;
state_112558 = G__112683;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__99037__auto__ = function(state_112558){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__99037__auto____1.call(this,state_112558);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__99037__auto____0;
fluree$db$graphdb$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__99037__auto____1;
return fluree$db$graphdb$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__,this$__$1))
})();
var state__99061__auto__ = (function (){var statearr_112576 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_112576[(6)] = c__99059__auto__);

return statearr_112576;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__,this$__$1))
);

return c__99059__auto__;
});

fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__,this$__$1){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__,this$__$1){
return (function (state_112608){
var state_val_112609 = (state_112608[(1)]);
if((state_val_112609 === (7))){
var inst_112604 = (state_112608[(2)]);
var state_112608__$1 = state_112608;
var statearr_112610_112684 = state_112608__$1;
(statearr_112610_112684[(2)] = inst_112604);


cljs.core.async.impl.ioc_helpers.process_exception(state_112608__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_112609 === (1))){
var state_112608__$1 = state_112608;
var statearr_112611_112685 = state_112608__$1;
(statearr_112611_112685[(2)] = null);

(statearr_112611_112685[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112609 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_112608,(3),Error,null,(2));
var inst_112581 = clojure.string.includes_QMARK_(tag_name,"/");
var state_112608__$1 = state_112608;
if(inst_112581){
var statearr_112612_112686 = state_112608__$1;
(statearr_112612_112686[(1)] = (5));

} else {
var statearr_112613_112687 = state_112608__$1;
(statearr_112613_112687[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112609 === (15))){
var inst_112598 = (state_112608[(2)]);
var inst_112599 = fluree.db.util.async.throw_err(inst_112598);
var state_112608__$1 = state_112608;
var statearr_112614_112688 = state_112608__$1;
(statearr_112614_112688[(2)] = inst_112599);

(statearr_112614_112688[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112609 === (13))){
var state_112608__$1 = state_112608;
var statearr_112615_112689 = state_112608__$1;
(statearr_112615_112689[(2)] = null);

(statearr_112615_112689[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112609 === (6))){
var inst_112588 = typeof pred === 'string';
var state_112608__$1 = state_112608;
if(cljs.core.truth_(inst_112588)){
var statearr_112616_112690 = state_112608__$1;
(statearr_112616_112690[(1)] = (9));

} else {
var statearr_112617_112691 = state_112608__$1;
(statearr_112617_112691[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112609 === (3))){
var inst_112577 = (state_112608[(2)]);
var state_112608__$1 = state_112608;
var statearr_112618_112692 = state_112608__$1;
(statearr_112618_112692[(2)] = inst_112577);


cljs.core.async.impl.ioc_helpers.process_exception(state_112608__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_112609 === (12))){
var inst_112593 = (state_112608[(7)]);
var inst_112595 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_112593),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_112596 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2(null,inst_112595);
var state_112608__$1 = state_112608;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_112608__$1,(15),inst_112596);
} else {
if((state_val_112609 === (2))){
var inst_112606 = (state_112608[(2)]);
var state_112608__$1 = state_112608;
return cljs.core.async.impl.ioc_helpers.return_chan(state_112608__$1,inst_112606);
} else {
if((state_val_112609 === (11))){
var inst_112593 = (state_112608[(7)]);
var inst_112593__$1 = (state_112608[(2)]);
var state_112608__$1 = (function (){var statearr_112619 = state_112608;
(statearr_112619[(7)] = inst_112593__$1);

return statearr_112619;
})();
if(cljs.core.truth_(inst_112593__$1)){
var statearr_112620_112693 = state_112608__$1;
(statearr_112620_112693[(1)] = (12));

} else {
var statearr_112621_112694 = state_112608__$1;
(statearr_112621_112694[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112609 === (9))){
var state_112608__$1 = state_112608;
var statearr_112622_112695 = state_112608__$1;
(statearr_112622_112695[(2)] = pred);

(statearr_112622_112695[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112609 === (5))){
var inst_112583 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2(null,tag_name);
var state_112608__$1 = state_112608;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_112608__$1,(8),inst_112583);
} else {
if((state_val_112609 === (14))){
var inst_112602 = (state_112608[(2)]);
var state_112608__$1 = state_112608;
var statearr_112623_112696 = state_112608__$1;
(statearr_112623_112696[(2)] = inst_112602);

(statearr_112623_112696[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112609 === (10))){
var inst_112591 = this$__$1.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3(null,cljs.core.cst$kw$name,pred);
var state_112608__$1 = state_112608;
var statearr_112624_112697 = state_112608__$1;
(statearr_112624_112697[(2)] = inst_112591);

(statearr_112624_112697[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112609 === (8))){
var inst_112585 = (state_112608[(2)]);
var inst_112586 = fluree.db.util.async.throw_err(inst_112585);
var state_112608__$1 = state_112608;
var statearr_112625_112698 = state_112608__$1;
(statearr_112625_112698[(2)] = inst_112586);

(statearr_112625_112698[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__,this$__$1))
;
return ((function (switch__99036__auto__,c__99059__auto__,this$__$1){
return (function() {
var fluree$db$graphdb$state_machine__99037__auto__ = null;
var fluree$db$graphdb$state_machine__99037__auto____0 = (function (){
var statearr_112626 = [null,null,null,null,null,null,null,null];
(statearr_112626[(0)] = fluree$db$graphdb$state_machine__99037__auto__);

(statearr_112626[(1)] = (1));

return statearr_112626;
});
var fluree$db$graphdb$state_machine__99037__auto____1 = (function (state_112608){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_112608);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e112627){if((e112627 instanceof Object)){
var ex__99040__auto__ = e112627;
var statearr_112628_112699 = state_112608;
(statearr_112628_112699[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_112608);

return cljs.core.cst$kw$recur;
} else {
throw e112627;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__112700 = state_112608;
state_112608 = G__112700;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__99037__auto__ = function(state_112608){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__99037__auto____1.call(this,state_112608);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__99037__auto____0;
fluree$db$graphdb$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__99037__auto____1;
return fluree$db$graphdb$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__,this$__$1))
})();
var state__99061__auto__ = (function (){var statearr_112629 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_112629[(6)] = c__99059__auto__);

return statearr_112629;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__,this$__$1))
);

return c__99059__auto__;
});

fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$tt_DASH_id,cljs.core.cst$sym$stats,cljs.core.cst$sym$spot,cljs.core.cst$sym$psot,cljs.core.cst$sym$post,cljs.core.cst$sym$opst,cljs.core.cst$sym$schema,cljs.core.cst$sym$settings,cljs.core.cst$sym$index_DASH_configs,cljs.core.cst$sym$schema_DASH_cache,cljs.core.cst$sym$novelty,cljs.core.cst$sym$permissions,cljs.core.cst$sym$fork,cljs.core.cst$sym$fork_DASH_block,cljs.core.cst$sym$current_DASH_db_DASH_fn], null);
});

fluree.db.graphdb.GraphDb.cljs$lang$type = true;

fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__4428__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
});

fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__){
return cljs.core._write(writer__4429__auto__,"fluree.db.graphdb/GraphDb");
});

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__112350){
var extmap__4424__auto__ = (function (){var G__112630 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__112350,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$schema,cljs.core.cst$kw$settings,cljs.core.cst$kw$index_DASH_configs,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$novelty,cljs.core.cst$kw$permissions,cljs.core.cst$kw$fork,cljs.core.cst$kw$fork_DASH_block,cljs.core.cst$kw$current_DASH_db_DASH_fn], 0));
if(cljs.core.record_QMARK_(G__112350)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__112630);
} else {
return G__112630;
}
})();
return (new fluree.db.graphdb.GraphDb(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__112350),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__112350),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__112350),cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__112350),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__112350),cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(G__112350),cljs.core.cst$kw$stats.cljs$core$IFn$_invoke$arity$1(G__112350),cljs.core.cst$kw$spot.cljs$core$IFn$_invoke$arity$1(G__112350),cljs.core.cst$kw$psot.cljs$core$IFn$_invoke$arity$1(G__112350),cljs.core.cst$kw$post.cljs$core$IFn$_invoke$arity$1(G__112350),cljs.core.cst$kw$opst.cljs$core$IFn$_invoke$arity$1(G__112350),cljs.core.cst$kw$schema.cljs$core$IFn$_invoke$arity$1(G__112350),cljs.core.cst$kw$settings.cljs$core$IFn$_invoke$arity$1(G__112350),cljs.core.cst$kw$index_DASH_configs.cljs$core$IFn$_invoke$arity$1(G__112350),cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__112350),cljs.core.cst$kw$novelty.cljs$core$IFn$_invoke$arity$1(G__112350),cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(G__112350),cljs.core.cst$kw$fork.cljs$core$IFn$_invoke$arity$1(G__112350),cljs.core.cst$kw$fork_DASH_block.cljs$core$IFn$_invoke$arity$1(G__112350),cljs.core.cst$kw$current_DASH_db_DASH_fn.cljs$core$IFn$_invoke$arity$1(G__112350),null,cljs.core.not_empty(extmap__4424__auto__),null));
});

fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL;

fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write(w,"#FlureeGraphDB ");

return cljs.core._write(w,cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$network,cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(db__$1),cljs.core.cst$kw$dbid,cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db__$1),cljs.core.cst$kw$block,cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(db__$1),cljs.core.cst$kw$t,cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db__$1),cljs.core.cst$kw$stats,cljs.core.cst$kw$stats.cljs$core$IFn$_invoke$arity$1(db__$1),cljs.core.cst$kw$permissions,cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(db__$1)], null)], 0)));
});
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(index_configs){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,idx){
var ss = clojure.data.avl.sorted_set_by(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(index_configs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,cljs.core.cst$kw$historyComparator], null)));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,idx,ss);
}),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$size,(0)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst], null));
});
fluree.db.graphdb.new_empty_index = (function fluree$db$graphdb$new_empty_index(conn,index_configs,network,dbid,idx){
var index_config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,idx);
var _ = (cljs.core.truth_(index_config)?null:(function(){throw (new Error(["Assert failed: ",["No index config found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","index-config"].join('')))})());
var comparator = cljs.core.cst$kw$historyComparator.cljs$core$IFn$_invoke$arity$1(index_config);
var ___$1 = (cljs.core.truth_(comparator)?null:(function(){throw (new Error(["Assert failed: ",["No index comparator found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","comparator"].join('')))})());
var first_flake = fluree.db.flake.__GT_Flake(fluree.db.util.core.max_long,(0),fluree.db.util.core.max_long,(0),true,null);
var child_node = fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$block,cljs.core.cst$kw$dbid,cljs.core.cst$kw$config,cljs.core.cst$kw$leaf,cljs.core.cst$kw$size,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$id,cljs.core.cst$kw$t,cljs.core.cst$kw$network,cljs.core.cst$kw$first,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$rhs,cljs.core.cst$kw$conn],[(0),dbid,index_config,true,(0),true,cljs.core.cst$kw$empty,(0),network,first_flake,null,null,conn]));
var children = clojure.data.avl.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(comparator,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([first_flake,child_node], 0));
var idx_node = fluree.db.index.__GT_IndexNode((0),(0),null,children,index_config,true);
return idx_node;
});
fluree.db.graphdb.default_index_configs = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$spot,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$spot,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_spot,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_spot_novelty], null)),cljs.core.cst$kw$psot,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$psot,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_psot,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_psot_novelty], null)),cljs.core.cst$kw$post,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$post,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_post,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_post_novelty], null)),cljs.core.cst$kw$opst,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$opst,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_opst,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_opst_novelty], null))], null);
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,dbid,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(dbid)){
} else {
throw (new Error(["Assert failed: ","No dbid provided when creating new db.","\n","dbid"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map(fluree.db.graphdb.default_index_configs);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$collection,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,false], null),cljs.core.cst$kw$predicate,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null),cljs.core.cst$kw$root_QMARK_,true], null);
var spot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$spot);
var psot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$psot);
var post = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$post);
var opst = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$opst);
var stats = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$flakes,(0),cljs.core.cst$kw$size,(0),cljs.core.cst$kw$indexed,(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb(conn,network,dbid,(0),(-1),null,stats,spot,psot,post,opst,schema,settings,fluree.db.graphdb.default_index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});

//# sourceMappingURL=graphdb.js.map?rel=1593118619765
