// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('cljs.js');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('cljs.env');
goog.require('cljs.spec.alpha');
goog.require('cljs.analyzer');
goog.require('cljs.compiler');
goog.require('cljs.tools.reader');
goog.require('cljs.tools.reader.reader_types');
goog.require('cljs.tagged_literals');
goog.require('goog.crypt.base64');
goog.require('cljs.source_map');
goog.require('goog.string.StringBuffer');
goog.require("cljs.core$macros");
cljs.js.debug_prn = (function cljs$js$debug_prn(var_args){
var args__4736__auto__ = [];
var len__4730__auto___102899 = arguments.length;
var i__4731__auto___102900 = (0);
while(true){
if((i__4731__auto___102900 < len__4730__auto___102899)){
args__4736__auto__.push((arguments[i__4731__auto___102900]));

var G__102901 = (i__4731__auto___102900 + (1));
i__4731__auto___102900 = G__102901;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return cljs.js.debug_prn.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

cljs.js.debug_prn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var _STAR_print_fn_STAR__orig_val__102897 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_fn_STAR__temp_val__102898 = cljs.core._STAR_print_err_fn_STAR_;
cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__102898;

try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.println,args);
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__102897;
}});

cljs.js.debug_prn.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
cljs.js.debug_prn.cljs$lang$applyTo = (function (seq102896){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq102896));
});

/**
 * Given a namespace as a symbol return the relative path sans extension
 */
cljs.js.ns__GT_relpath = (function cljs$js$ns__GT_relpath(ns_sym){
return clojure.string.replace(cljs.analyzer.munge_path(ns_sym),".","/");
});
cljs.js.file__GT_ns = (function cljs$js$file__GT_ns(file){
var lib_name = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(clojure.string.replace(file,"/","."),(0),(cljs.core.count(file) - (5)));
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.demunge(lib_name));
});
cljs.js.drop_macros_suffix = (function cljs$js$drop_macros_suffix(ns_name){
if(cljs.core.truth_(ns_name)){
if(clojure.string.ends_with_QMARK_(ns_name,"$macros")){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(ns_name,(0),(cljs.core.count(ns_name) - (7)));
} else {
return ns_name;
}
} else {
return null;
}
});
cljs.js.elide_macros_suffix = (function cljs$js$elide_macros_suffix(sym){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(cljs.js.drop_macros_suffix(cljs.core.namespace(sym)),cljs.core.name(sym));
});
cljs.js.resolve_symbol = (function cljs$js$resolve_symbol(sym){
if(clojure.string.starts_with_QMARK_(cljs.core.str.cljs$core$IFn$_invoke$arity$1(sym),".")){
return sym;
} else {
return cljs.js.elide_macros_suffix(cljs.analyzer.resolve_symbol(sym));
}
});
cljs.js.read = (function cljs$js$read(eof,rdr){
var _STAR_ns_STAR__orig_val__102902 = cljs.core._STAR_ns_STAR_;
var _STAR_ns_STAR__temp_val__102903 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.js.drop_macros_suffix(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core._STAR_ns_STAR_)));
cljs.core._STAR_ns_STAR_ = _STAR_ns_STAR__temp_val__102903;

try{return cljs.tools.reader.read.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$eof,eof,cljs.core.cst$kw$read_DASH_cond,cljs.core.cst$kw$allow,cljs.core.cst$kw$features,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs,null], null), null)], null),rdr);
}finally {cljs.core._STAR_ns_STAR_ = _STAR_ns_STAR__orig_val__102902;
}});
cljs.js.atom_QMARK_ = (function cljs$js$atom_QMARK_(x){
return (x instanceof cljs.core.Atom);
});
cljs.js.valid_name_QMARK_ = (function cljs$js$valid_name_QMARK_(x){
return (((x == null)) || ((x instanceof cljs.core.Symbol)) || (typeof x === 'string'));
});
cljs.js.valid_opts_QMARK_ = (function cljs$js$valid_opts_QMARK_(x){
return (((x == null)) || (cljs.core.map_QMARK_(x)));
});
if((typeof cljs !== 'undefined') && (typeof cljs.js !== 'undefined') && (typeof cljs.js._STAR_load_fn_STAR_ !== 'undefined')){
} else {
/**
 * Each runtime environment provides a different way to load a library.
 *   Whatever function *load-fn* is bound to will be passed two arguments - a
 *   map and a callback function: The map will have the following keys:
 * 
 *   :name   - the name of the library (a symbol)
 *   :macros - modifier signaling a macros namespace load
 *   :path   - munged relative library path (a string)
 * 
 *   It is up to the implementor to correctly resolve the corresponding .cljs,
 *   .cljc, or .js resource (the order must be respected). If :macros is true
 *   resolution should only consider .clj or .cljc resources (the order must be
 *   respected). Upon resolution the callback should be invoked with a map
 *   containing the following keys:
 * 
 *   :lang       - the language, :clj or :js
 *   :source     - the source of the library (a string)
 *   :file       - optional, the file path, it will be added to AST's :file keyword
 *              (but not in :meta)
 *   :cache      - optional, if a :clj namespace has been precompiled to :js, can
 *              give an analysis cache for faster loads.
 *   :source-map - optional, if a :clj namespace has been precompiled to :js, can
 *              give a V3 source map JSON
 * 
 *   If the resource could not be resolved, the callback should be invoked with
 *   nil.
 */
cljs.js._STAR_load_fn_STAR_ = (function cljs$js$_STAR_load_fn_STAR_(m,cb){
throw (new Error("No *load-fn* set"));
});
}
if((typeof cljs !== 'undefined') && (typeof cljs.js !== 'undefined') && (typeof cljs.js._STAR_eval_fn_STAR_ !== 'undefined')){
} else {
/**
 * Each runtime environment provides various ways to eval JavaScript
 *   source. Whatever function *eval-fn* is bound to will be passed a map
 *   containing the following keys:
 * 
 *   :source - the source of the library (string)
 *   :name   - used to unique identify the script (symbol)
 *   :cache  - if the source was originally ClojureScript, will be given the
 *          analysis cache.
 * 
 *   The result of evaluation should be the return value.
 */
cljs.js._STAR_eval_fn_STAR_ = (function cljs$js$_STAR_eval_fn_STAR_(m){
throw (new Error("No *eval-fn* set"));
});
}
/**
 * A default JavaScript evaluation function.
 */
cljs.js.js_eval = (function cljs$js$js_eval(p__102904){
var map__102905 = p__102904;
var map__102905__$1 = (((((!((map__102905 == null))))?(((((map__102905.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__102905.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__102905):map__102905);
var resource = map__102905__$1;
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__102905__$1,cljs.core.cst$kw$source);
return eval(source);
});
cljs.js.wrap_error = (function cljs$js$wrap_error(ex){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$error,ex], null);
});
/**
 * Construct an empty compiler state. Required to invoke analyze, compile,
 * eval and eval-str.
 */
cljs.js.empty_state = (function cljs$js$empty_state(var_args){
var G__102908 = arguments.length;
switch (G__102908) {
case 0:
return cljs.js.empty_state.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.js.empty_state.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.js.empty_state.cljs$core$IFn$_invoke$arity$0 = (function (){
var G__102909 = cljs.env.default_compiler_env.cljs$core$IFn$_invoke$arity$0();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(G__102909,((function (G__102909){
return (function (state){
return cljs.core.assoc_in(state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$cljs$analyzer_SLASH_namespaces,cljs.core.cst$sym$cljs$core], null),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$rename_DASH_macros,cljs.core.cst$kw$renames,cljs.core.cst$kw$externs,cljs.core.cst$kw$use_DASH_macros,cljs.core.cst$kw$excludes,cljs.core.cst$kw$macros,cljs.core.cst$kw$name,cljs.core.cst$kw$imports,cljs.core.cst$kw$requires,cljs.core.cst$kw$uses,cljs.core.cst$kw$defs,cljs.core.cst$kw$require_DASH_macros,cljs.core.cst$kw$cljs$analyzer_SLASH_constants,cljs.core.cst$kw$doc],[cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$sym$setTimeout,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$sym$process,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$hrtime,cljs.core.PersistentArrayMap.EMPTY], null),cljs.core.cst$sym$Java,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$type,cljs.core.PersistentArrayMap.EMPTY], null),cljs.core.cst$sym$Object,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$out,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$println,cljs.core.PersistentArrayMap.EMPTY], null),cljs.core.cst$sym$error,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$println,cljs.core.PersistentArrayMap.EMPTY], null)], null)], null),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentHashSet.EMPTY,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$sym$unsafe_DASH_bit_DASH_and,cljs.core.cst$sym$macroexpand,cljs.core.cst$sym$unchecked_DASH_remainder_DASH_int,cljs.core.cst$sym$when_DASH_first,cljs.core.cst$sym$cond_DASH__GT__GT_,cljs.core.cst$sym$bit_DASH_set,cljs.core.cst$sym$import_DASH_macros,cljs.core.cst$sym$while,cljs.core.cst$sym$satisfies_QMARK_,cljs.core.cst$sym$unchecked_DASH_subtract_DASH_int,cljs.core.cst$sym$ns_DASH_unmap,cljs.core.cst$sym$import,cljs.core.cst$sym$bit_DASH_shift_DASH_right,cljs.core.cst$sym$aget,cljs.core.cst$sym$specify,cljs.core.cst$sym$vswap_BANG_,cljs.core.cst$sym$caching_DASH_hash,cljs.core.cst$sym$bit_DASH_shift_DASH_left,cljs.core.cst$sym$coercive_DASH_not,cljs.core.cst$sym$dec,cljs.core.cst$sym$unchecked_DASH_get,cljs.core.cst$sym$return_DASH_first,cljs.core.cst$sym$ns_DASH_publics,cljs.core.cst$sym$_LT_,cljs.core.cst$sym$this_DASH_as,cljs.core.cst$sym$$$,cljs.core.cst$sym$delay,cljs.core.cst$sym$some_QMARK_,cljs.core.cst$sym$unchecked_DASH_negate,cljs.core.cst$sym$simple_DASH_benchmark,cljs.core.cst$sym$unchecked_DASH_inc_DASH_int,cljs.core.cst$sym$unchecked_DASH_set,cljs.core.cst$sym$js_DASH_str,cljs.core.cst$sym$bit_DASH_shift_DASH_right_DASH_zero_DASH_fill,cljs.core.cst$sym$implements_QMARK_,cljs.core.cst$sym$goog_DASH_define,cljs.core.cst$sym$pos_QMARK_,cljs.core.cst$sym$specify_BANG_,cljs.core.cst$sym$if_DASH_not,cljs.core.cst$sym$alength,cljs.core.cst$sym$bit_DASH_xor,cljs.core.cst$sym$doseq,cljs.core.cst$sym$unsigned_DASH_bit_DASH_shift_DASH_right,cljs.core.cst$sym$neg_QMARK_,cljs.core.cst$sym$unchecked_DASH_float,cljs.core.cst$sym$undefined_QMARK_,cljs.core.cst$sym$deftype,cljs.core.cst$sym$mask,cljs.core.cst$sym$when_DASH_let,cljs.core.cst$sym$divide,cljs.core.cst$sym$coercive_DASH_boolean,cljs.core.cst$sym$_LT__EQ_,cljs.core.cst$sym$if_DASH_some,cljs.core.cst$sym$_STAR_,cljs.core.cst$sym$min,cljs.core.cst$sym$lazy_DASH_seq,cljs.core.cst$sym$js_DASH_delete,cljs.core.cst$sym$truth_,cljs.core.cst$sym$defcurried,cljs.core.cst$sym$js_DASH_debugger,cljs.core.cst$sym$let,cljs.core.cst$sym$_DASH__GT_,cljs.core.cst$sym$coercive_DASH_not_EQ_,cljs.core.cst$sym$doto,cljs.core.cst$sym$areduce,cljs.core.cst$sym$double,cljs.core.cst$sym$bit_DASH_and_DASH_not,cljs.core.cst$sym$unchecked_DASH_add_DASH_int,cljs.core.cst$sym$fn,cljs.core.cst$sym$short,cljs.core.cst$sym$js_DASH_this,cljs.core.cst$sym$unchecked_DASH_double,cljs.core.cst$sym$string_QMARK_,cljs.core.cst$sym$js_DASH_arguments,cljs.core.cst$sym$unchecked_DASH_multiply_DASH_int,cljs.core.cst$sym$as_DASH__GT_,cljs.core.cst$sym$when_DASH_not,cljs.core.cst$sym$when,cljs.core.cst$sym$int,cljs.core.cst$sym$_GT_,cljs.core.cst$sym$keyword_QMARK_,cljs.core.cst$sym$use_DASH_macros,cljs.core.cst$sym$unchecked_DASH_multiply,cljs.core.cst$sym$gen_DASH_apply_DASH_to,cljs.core.cst$sym$some_DASH__GT__GT_,cljs.core.cst$sym$unchecked_DASH_dec,cljs.core.cst$sym$defn,cljs.core.cst$sym$float,cljs.core.cst$sym$js_DASH_in,cljs.core.cst$sym$es6_DASH_iterable,cljs.core.cst$sym$amap,cljs.core.cst$sym$use,cljs.core.cst$sym$declare,cljs.core.cst$sym$_DASH_,cljs.core.cst$sym$hash_DASH_set,cljs.core.cst$sym$or,cljs.core.cst$sym$extend_DASH_type,cljs.core.cst$sym$macroexpand_DASH_1,cljs.core.cst$sym$bit_DASH_test,cljs.core.cst$sym$defmethod,cljs.core.cst$sym$time,cljs.core.cst$sym$zero_QMARK_,cljs.core.cst$sym$require,cljs.core.cst$sym$unchecked_DASH_dec_DASH_int,cljs.core.cst$sym$memfn,cljs.core.cst$sym$js_DASH_obj,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$extend_DASH_protocol,cljs.core.cst$sym$cond_DASH__GT_,cljs.core.cst$sym$dotimes,cljs.core.cst$sym$bit_DASH_and,cljs.core.cst$sym$reify,cljs.core.cst$sym$instance_QMARK_,cljs.core.cst$sym$load_DASH_file_STAR_,cljs.core.cst$sym$defonce,cljs.core.cst$sym$unchecked_DASH_add,cljs.core.cst$sym$rfn,cljs.core.cst$sym$identical_QMARK_,cljs.core.cst$sym$unchecked_DASH_divide_DASH_int,cljs.core.cst$sym$defn_DASH_,cljs.core.cst$sym$defprotocol,cljs.core.cst$sym$ns_DASH_special_DASH_form,cljs.core.cst$sym$unchecked_DASH_subtract,cljs.core.cst$sym$assert,cljs.core.cst$sym$true_QMARK_,cljs.core.cst$sym$array,cljs.core.cst$sym$letfn,cljs.core.cst$sym$_SLASH_,cljs.core.cst$sym$bitpos,cljs.core.cst$sym$bit_DASH_or,cljs.core.cst$sym$vector,cljs.core.cst$sym$_GT__EQ_,cljs.core.cst$sym$loop,cljs.core.cst$sym$bit_DASH_flip,cljs.core.cst$sym$js_DASH_mod,cljs.core.cst$sym$with_DASH_out_DASH_str,cljs.core.cst$sym$condp,cljs.core.cst$sym$cond,cljs.core.cst$sym$some_DASH__GT_,cljs.core.cst$sym$ns_DASH_interns,cljs.core.cst$sym$for,cljs.core.cst$sym$binding,cljs.core.cst$sym$array_DASH_map,cljs.core.cst$sym$unchecked_DASH_byte,cljs.core.cst$sym$ns_DASH_imports,cljs.core.cst$sym$defmacro,cljs.core.cst$sym$unchecked_DASH_short,cljs.core.cst$sym$inc,cljs.core.cst$sym$with_DASH_redefs,cljs.core.cst$sym$bit_DASH_clear,cljs.core.cst$sym$locking,cljs.core.cst$sym$list,cljs.core.cst$sym$_PLUS_,cljs.core.cst$sym$aset,cljs.core.cst$sym$defmulti,cljs.core.cst$sym$str,cljs.core.cst$sym$coercive_DASH__EQ_,cljs.core.cst$sym$hash_DASH_map,cljs.core.cst$sym$gen_DASH_apply_DASH_to_DASH_simple,cljs.core.cst$sym$if_DASH_let,cljs.core.cst$sym$false_QMARK_,cljs.core.cst$sym$case,cljs.core.cst$sym$exists_QMARK_,cljs.core.cst$sym$bit_DASH_not,cljs.core.cst$sym$byte,cljs.core.cst$sym$max,cljs.core.cst$sym$_EQ__EQ_,cljs.core.cst$sym$lazy_DASH_cat,cljs.core.cst$sym$comment,cljs.core.cst$sym$copy_DASH_arguments,cljs.core.cst$sym$when_DASH_assert,cljs.core.cst$sym$unsafe_DASH_cast,cljs.core.cst$sym$resolve,cljs.core.cst$sym$defrecord,cljs.core.cst$sym$make_DASH_array,cljs.core.cst$sym$unchecked_DASH_negate_DASH_int,cljs.core.cst$sym$unchecked_DASH_inc,cljs.core.cst$sym$and,cljs.core.cst$sym$number_QMARK_,cljs.core.cst$sym$js_DASH_comment,cljs.core.cst$sym$symbol_QMARK_,cljs.core.cst$sym$when_DASH_some,cljs.core.cst$sym$unchecked_DASH_char,cljs.core.cst$sym$require_DASH_macros,cljs.core.cst$sym$_DASH__GT__GT_,cljs.core.cst$sym$js_DASH_inline_DASH_comment,cljs.core.cst$sym$refer_DASH_clojure],[new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$line,1207,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unsafe_DASH_bit_DASH_and,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$quoted], null)),cljs.core.cst$kw$doc,"Repeatedly calls macroexpand-1 on form until it no longer\n  represents a macro form, then returns it.  Note neither\n  macroexpand-1 nor macroexpand expand macros in subforms.",cljs.core.cst$kw$line,3054,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_macroexpand,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null)),cljs.core.cst$kw$line,1114,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_remainder_DASH_int,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$bindings,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$body], null)),cljs.core.cst$kw$doc,"bindings => x xs\n\n  Roughly the same as (when (seq xs) (let [x (first xs)] body)) but xs is evaluated only once",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,4444,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_when_DASH_first,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$expr,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$clauses], null)),cljs.core.cst$kw$doc,"Takes an expression and a set of test/form pairs. Threads expr (via ->>)\n  through each form for which the corresponding test expression\n  is true.  Note that, unlike cond branching, cond->> threading does not short circuit\n  after the first true test expression.",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,7257,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_cond_DASH__GT__GT_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null)),cljs.core.cst$kw$line,1247,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_bit_DASH_set,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ns,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$vars], null)], null)),cljs.core.cst$kw$line,64,cljs.core.cst$kw$column,4,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_import_DASH_macros,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$test,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$body], null)),cljs.core.cst$kw$doc,"Repeatedly executes body while test expression is true. Presumes\n  some side-effect will cause test to become false/nil. Returns nil",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,6087,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_while,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$psym,cljs.core.cst$sym$x], null)),cljs.core.cst$kw$doc,"Returns true if x satisfies the protocol",cljs.core.cst$kw$line,2166,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_satisfies_QMARK_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$xs], null)),cljs.core.cst$kw$line,1120,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_subtract_DASH_int,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$quoted_DASH_ns,cljs.core.cst$sym$quoted_DASH_sym], null)),cljs.core.cst$kw$doc,"Removes the mappings for the symbol from the namespace.",cljs.core.cst$kw$line,2913,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_ns_DASH_unmap,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$import_DASH_symbols_DASH_or_DASH_lists], null)),cljs.core.cst$kw$doc,"import-list => (closure-namespace constructor-name-symbols*)\n\n  For each name in constructor-name-symbols, adds a mapping from name to the\n  constructor named by closure-namespace to the current namespace. Use :import in the ns\n  macro in preference to calling this directly.",cljs.core.cst$kw$line,3017,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_import,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null)),cljs.core.cst$kw$line,1238,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_bit_DASH_shift_DASH_right,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$idxs], null)),cljs.core.cst$kw$line,1023,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_aget,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$expr,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$impls], null)),cljs.core.cst$kw$doc,"Identical to specify! but does not mutate its first argument. The first\n  argument must be an ICloneable instance.",cljs.core.cst$kw$line,1393,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_specify,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$vol,cljs.core.cst$sym$f,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$doc,"Non-atomically swaps the value of the volatile as if:\n   (apply f current-value-of-vol args). Returns the value that\n   was swapped in.",cljs.core.cst$kw$line,2925,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_vswap_BANG_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$hash_DASH_fn,cljs.core.cst$sym$hash_DASH_key], null)),cljs.core.cst$kw$line,1259,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_caching_DASH_hash,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null)),cljs.core.cst$kw$line,1235,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_bit_DASH_shift_DASH_left,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,912,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_coercive_DASH_not,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1169,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_dec,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$key], null)),cljs.core.cst$kw$doc,"INTERNAL. Compiles to JavaScript property access using bracket notation. Does\n  not distinguish between object and array types and not subject to compiler\n  static analysis.",cljs.core.cst$kw$line,1050,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_get,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$body], null)),cljs.core.cst$kw$line,727,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_return_DASH_first,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$quoted_DASH_ns], null)),cljs.core.cst$kw$doc,"Returns a map of the public intern mappings for the namespace.",cljs.core.cst$kw$line,2869,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_ns_DASH_publics,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$line,1144,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH__LT_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$body], null)),cljs.core.cst$kw$doc,"Defines a scope where JavaScript's implicit \"this\" is bound to the name provided.",cljs.core.cst$kw$line,1403,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_this_DASH_as,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$form], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$form,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$doc,"form => fieldName-symbol or (instanceMethodName-symbol args*)\n\n  Expands into a member access (.) of the first member on the first\n  argument, followed by the next member on the result, etc. For\n  instance:\n\n  (.. System (getProperties) (get \"os.name\"))\n\n  expands to:\n\n  (. (. System (getProperties)) (get \"os.name\"))\n\n  but is easier to write, read, and understand.",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,1568,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_$$,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$body], null)),cljs.core.cst$kw$doc,"Takes a body of expressions and yields a Delay object that will\n  invoke the body only the first time it is forced (with force or deref/@), and\n  will cache the result and return it on all subsequent force\n  calls.",cljs.core.cst$kw$line,2204,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_delay,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,909,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_some_QMARK_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1108,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_negate,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$bindings,cljs.core.cst$sym$expr,cljs.core.cst$sym$iterations,cljs.core.cst$sym$_AMPERSAND_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$keys,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$print_DASH_fn], null),cljs.core.cst$kw$or,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$print_DASH_fn,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.cst$sym$println)], null)], null)], null)),cljs.core.cst$kw$doc,"Runs expr iterations times in the context of a let expression with\n  the given bindings, then prints out the bindings and the expr\n  followed by number of iterations and total time. The optional\n  argument print-fn, defaulting to println, sets function used to\n  print the result. expr's string representation will be produced\n  using pr-str in any case.",cljs.core.cst$kw$line,2771,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_simple_DASH_benchmark,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1099,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_inc_DASH_int,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$key,cljs.core.cst$sym$val], null)),cljs.core.cst$kw$doc,"INTERNAL. Compiles to JavaScript property access using bracket notation. Does\n  not distinguish between object and array types and not subject to compiler\n  static analysis.",cljs.core.cst$kw$line,1057,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_set,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null)),cljs.core.cst$kw$line,2860,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_js_DASH_str,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null)),cljs.core.cst$kw$line,1241,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_bit_DASH_shift_DASH_right_DASH_zero_DASH_fill,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$psym,cljs.core.cst$sym$x], null)),cljs.core.cst$kw$doc,"EXPERIMENTAL",cljs.core.cst$kw$line,2140,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_implements_QMARK_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$sym,cljs.core.cst$sym$default], null)),cljs.core.cst$kw$doc,"Defines a var using `goog.define`. Passed default value must be\n  string, number or boolean.\n\n  Default value can be overridden at compile time using the\n  compiler option `:closure-defines`.\n\n  Example:\n    (ns your-app.core)\n    (goog-define DEBUG! false)\n    ;; can be overridden with\n    :closure-defines {\"your_app.core.DEBUG_BANG_\" true}\n    or\n    :closure-defines {'your-app.core/DEBUG! true}",cljs.core.cst$kw$line,733,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_goog_DASH_define,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1178,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_pos_QMARK_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$expr,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$impls], null)),cljs.core.cst$kw$doc,"Identical to reify but mutates its first argument.",cljs.core.cst$kw$line,1385,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_specify_BANG_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$test,cljs.core.cst$sym$then], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$test,cljs.core.cst$sym$then,cljs.core.cst$sym$else], null)),cljs.core.cst$kw$doc,"Evaluates test. If logical false, evaluates and returns then expr, \n  otherwise else expr, if supplied, else nil.",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,748,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_if_DASH_not,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a], null)),cljs.core.cst$kw$line,2652,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_alength,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$line,1218,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_bit_DASH_xor,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$seq_DASH_exprs,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$body], null)),cljs.core.cst$kw$doc,"Repeatedly executes body (presumably for side-effects) with\n  bindings and filtering as provided by \"for\".  Does not retain\n  the head of the sequence. Returns nil.",cljs.core.cst$kw$line,2486,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_doseq,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null)),cljs.core.cst$kw$line,1244,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unsigned_DASH_bit_DASH_shift_DASH_right,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1181,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_neg_QMARK_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1078,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_float,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$doc,"Return true if argument is identical to the JavaScript undefined value.",cljs.core.cst$kw$line,997,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_undefined_QMARK_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$t,cljs.core.cst$sym$fields,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$impls], null)),cljs.core.cst$kw$doc,"(deftype name [fields*]  options* specs*)\n\n  Currently there are no options.\n\n  Each spec consists of a protocol or interface name followed by zero\n  or more method bodies:\n\n  protocol-or-Object\n  (methodName [args*] body)*\n\n  The type will have the (by default, immutable) fields named by\n  fields, which can have type hints. Protocols and methods\n  are optional. The only methods that can be supplied are those\n  declared in the protocols/interfaces.  Note that method bodies are\n  not closures, the local environment includes only the named fields,\n  and those fields can be accessed directly. Fields can be qualified\n  with the metadata :mutable true at which point (set! afield aval) will be\n  supported in method bodies. Note well that mutable fields are extremely\n  difficult to use correctly, and are present only to facilitate the building\n  of higherlevel constructs, such as ClojureScript's reference types, in\n  ClojureScript itself. They are for experts only - if the semantics and\n  implications of :mutable are not immediately apparent to you, you should not\n  be using them.\n\n  Method definitions take the form:\n\n  (methodname [args*] body)\n\n  The argument and return types can be hinted on the arg and\n  methodname symbols. If not supplied, they will be inferred, so type\n  hints should be reserved for disambiguation.\n\n  Methods should be supplied for all methods of the desired\n  protocol(s). You can also define overrides for methods of Object. Note that\n  a parameter must be supplied to correspond to the target object\n  ('this' in JavaScript parlance). Note also that recur calls to the method\n  head should *not* pass the target object, it will be supplied\n  automatically and can not be substituted.\n\n  In the method bodies, the (unqualified) name can be used to name the\n  class (for calls to new, instance? etc).\n\n  One constructor will be defined, taking the designated fields.  Note\n  that the field names __meta and __extmap are currently reserved and\n  should not be used when defining your own types.\n\n  Given (deftype TypeName ...), a factory function called ->TypeName\n  will be defined, taking positional parameters for the fields",cljs.core.cst$kw$line,1731,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_deftype,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$hash,cljs.core.cst$sym$shift], null)),cljs.core.cst$kw$line,1251,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_mask,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$bindings,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$body], null)),cljs.core.cst$kw$doc,"bindings => binding-form test\n\n  When test is true, evaluates body with binding-form bound to the value of test",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,1769,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_when_DASH_let,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$line,1139,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_divide,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,921,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_coercive_DASH_boolean,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$line,1149,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH__LT__EQ_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$bindings,cljs.core.cst$sym$then], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$bindings,cljs.core.cst$sym$then,cljs.core.cst$sym$else,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$oldform], null)),cljs.core.cst$kw$doc,"bindings => binding-form test\n\n   If test is not nil, evaluates then with binding-form bound to the\n   value of test, if not, yields else",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,1784,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_if_DASH_some,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$line,1128,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH__STAR_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$line,1190,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_min,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$body], null)),cljs.core.cst$kw$doc,"Takes a body of expressions that returns an ISeq or nil, and yields\n  a ISeqable object that will invoke the body only the first time seq\n  is called, and will cache the result and return it on all subsequent\n  seq calls.",cljs.core.cst$kw$line,2196,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_lazy_DASH_seq,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$key], null)),cljs.core.cst$kw$line,933,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_js_DASH_delete,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,926,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_truth_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$private,cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$macro,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[true,cljs.core.cst$sym$cljs$core,cljs.core.cst$sym$cljs$core_SLASH_defcurried,"cljs/core.cljc",1,1277,true,cljs.core.list(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name,cljs.core.cst$sym$doc,cljs.core.cst$sym$meta,cljs.core.cst$sym$args,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$body], null)),"Builds another arity of the fn that returns a fn awaiting the last\n  param"]),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY),cljs.core.cst$kw$doc,"Emit JavaScript \"debugger;\" statement",cljs.core.cst$kw$line,939,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_js_DASH_debugger,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$bindings,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$body], null)),cljs.core.cst$kw$doc,"binding => binding-form init-expr\n\n  Evaluates the exprs in a lexical context in which the symbols in\n  the binding-forms are bound to their respective init-exprs or parts\n  therein.",cljs.core.cst$kw$line,768,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_let,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$forms], null)),cljs.core.cst$kw$doc,"Threads the expr through the forms. Inserts x as the\n  second item in the first form, making a list of it if it is not a\n  list already. If there are more forms, inserts the first form as the\n  second item in second form, etc.",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,1586,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH__DASH__GT_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)),cljs.core.cst$kw$line,915,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_coercive_DASH_not_EQ_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$forms], null)),cljs.core.cst$kw$doc,"Evaluates x then calls all of the methods and functions with the\n  value of x supplied at the front of the given arguments.  The forms\n  are evaluated in order.  Returns x.\n\n  (doto (new js/Map) (.set \"a\" 1) (.set \"b\" 2))",cljs.core.cst$kw$line,178,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_doto,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$idx,cljs.core.cst$sym$ret,cljs.core.cst$sym$init,cljs.core.cst$sym$expr], null)),cljs.core.cst$kw$doc,"Reduces an expression across an array a, using an index named idx,\n  and return value named ret, initialized to init, setting ret to the\n  evaluation of expr at each step, returning ret.",cljs.core.cst$kw$line,2673,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_areduce,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1073,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_double,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$line,1222,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_bit_DASH_and_DASH_not,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$xs], null)),cljs.core.cst$kw$line,1084,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_add_DASH_int,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$sigs], null)),cljs.core.cst$kw$doc,"params => positional-params* , or positional-params* & next-param\n  positional-param => binding-form\n  next-param => binding-form\n  name => symbol\n\n  Defines a function",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,4357,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_fn,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1071,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_short,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY),cljs.core.cst$kw$line,1400,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_js_DASH_this,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1079,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_double,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,977,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_string_QMARK_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY),cljs.core.cst$kw$line,930,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_js_DASH_arguments,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$xs], null)),cljs.core.cst$kw$line,1105,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_multiply_DASH_int,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$expr,cljs.core.cst$sym$name,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$forms], null)),cljs.core.cst$kw$doc,"Binds name to expr, evaluates the first form in the lexical context\n  of that binding, then binds name to that result, repeating for each\n  successive form, returning the result of the last form.",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,7274,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_as_DASH__GT_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$test,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$body], null)),cljs.core.cst$kw$doc,"Evaluates test. If logical false, evaluates body in an implicit do.",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,499,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_when_DASH_not,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$test,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$body], null)),cljs.core.cst$kw$doc,"Evaluates test. If logical true, evaluates body in an implicit do.",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,493,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_when,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1215,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_int,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$line,1154,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH__GT_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1020,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_keyword_QMARK_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$doc,"Similar to use but only for macros.",cljs.core.cst$kw$line,3012,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_use_DASH_macros,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$xs], null)),cljs.core.cst$kw$line,1102,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_multiply,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY),cljs.core.cst$kw$line,2802,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_gen_DASH_apply_DASH_to,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$expr,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$forms], null)),cljs.core.cst$kw$doc,"When expr is not nil, threads it into the first form (via ->>),\n  and when that result is not nil, through the next etc",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,7300,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_some_DASH__GT__GT_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1087,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_dec,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$doc,"Same as (def name (core/fn [params* ] exprs*)) or (def\n    name (core/fn ([params* ] exprs*)+)) with any doc-string or attrs added\n    to the var metadata. prepost-map defines a map with optional keys\n    :pre and :post that contain collections of pre or post conditions.",cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name,cljs.core.cst$sym$doc_DASH_string_QMARK_,cljs.core.cst$sym$attr_DASH_map_QMARK_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$params_STAR_], null),cljs.core.cst$sym$prepost_DASH_map_QMARK_,cljs.core.cst$sym$body], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name,cljs.core.cst$sym$doc_DASH_string_QMARK_,cljs.core.cst$sym$attr_DASH_map_QMARK_,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$params_STAR_], null),cljs.core.cst$sym$prepost_DASH_map_QMARK_,cljs.core.cst$sym$body),cljs.core.cst$sym$_PLUS_,cljs.core.cst$sym$attr_DASH_map_QMARK_], null)),cljs.core.cst$kw$line,3243,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_defn,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1072,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_float,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$key,cljs.core.cst$sym$obj], null)),cljs.core.cst$kw$line,936,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_js_DASH_in,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ty], null)),cljs.core.cst$kw$line,2863,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_es6_DASH_iterable,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$idx,cljs.core.cst$sym$ret,cljs.core.cst$sym$expr], null)),cljs.core.cst$kw$doc,"Maps an expression across an array a, using an index named idx, and\n  return value named ret, initialized to a clone of a, then setting\n  each element of ret to the evaluation of expr, returning the new\n  array ret.",cljs.core.cst$kw$line,2657,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_amap,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$doc,"Like require, but referring vars specified by the mandatory\n  :only option.\n\n  Example:\n\n  The following would load the library clojure.set while referring\n  the intersection var.\n\n  (use '[clojure.set :only [intersection]])",cljs.core.cst$kw$line,2999,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_use,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$names], null)),cljs.core.cst$kw$doc,"defs the supplied var names with no bindings, useful for making forward declarations.",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,2667,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_declare,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$line,1123,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH__DASH_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$xs], null)),cljs.core.cst$kw$line,2609,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_hash_DASH_set,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$next], null)),cljs.core.cst$kw$doc,"Evaluates exprs one at a time, from left to right. If a form\n  returns a logical true value, or returns that value and doesn't\n  evaluate any of the other expressions, otherwise it returns the\n  value of the last expression. (or) returns nil.",cljs.core.cst$kw$line,887,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_or,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$type_DASH_sym,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$impls], null)),cljs.core.cst$kw$doc,"Extend a type to a series of protocols. Useful when you are\n  supplying the definitions explicitly inline. Propagates the\n  type as a type hint on the first argument of all fns.\n\n  type-sym may be\n\n   * default, meaning the definitions will apply for any value,\n     unless an extend-type exists for one of the more specific\n     cases below.\n   * nil, meaning the definitions will apply for the nil value.\n   * any of object, boolean, number, string, array, or function,\n     indicating the definitions will apply for values of the\n     associated base JavaScript types. Note that, for example,\n     string should be used instead of js/String.\n   * a JavaScript type not covered by the previous list, such\n     as js/RegExp.\n   * a type defined by deftype or defrecord.\n\n  (extend-type MyType\n    ICounted\n    (-count [c] ...)\n    Foo\n    (bar [x y] ...)\n    (baz ([x] ...) ([x y] ...) ...)",cljs.core.cst$kw$line,1621,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_extend_DASH_type,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$quoted], null)),cljs.core.cst$kw$doc,"If form represents a macro form, returns its expansion,\n  else returns form.",cljs.core.cst$kw$line,3043,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_macroexpand_DASH_1,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null)),cljs.core.cst$kw$line,1232,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_bit_DASH_test,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$multifn,cljs.core.cst$sym$dispatch_DASH_val,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$fn_DASH_tail], null)),cljs.core.cst$kw$doc,"Creates and installs a new method of multimethod associated with dispatch-value. ",cljs.core.cst$kw$line,2756,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_defmethod,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$expr], null)),cljs.core.cst$kw$doc,"Evaluates expr and prints the time it took. Returns the value of expr.",cljs.core.cst$kw$line,2761,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_time,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1175,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_zero_QMARK_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$doc,"Loads libs, skipping any that are already loaded. Each argument is\n  either a libspec that identifies a lib or a flag that modifies how all the identified\n  libs are loaded. Use :require in the ns macro in preference to calling this\n  directly.\n\n  Libs\n\n  A 'lib' is a named set of resources in classpath whose contents define a\n  library of ClojureScript code. Lib names are symbols and each lib is associated\n  with a ClojureScript namespace. A lib's name also locates its root directory\n  within classpath using Java's package name to classpath-relative path mapping.\n  All resources in a lib should be contained in the directory structure under its\n  root directory. All definitions a lib makes should be in its associated namespace.\n\n  'require loads a lib by loading its root resource. The root resource path\n  is derived from the lib name in the following manner:\n  Consider a lib named by the symbol 'x.y.z; it has the root directory\n  <classpath>/x/y/, and its root resource is <classpath>/x/y/z.clj. The root\n  resource should contain code to create the lib's namespace (usually by using\n  the ns macro) and load any additional lib resources.\n\n  Libspecs\n\n  A libspec is a lib name or a vector containing a lib name followed by\n  options expressed as sequential keywords and arguments.\n\n  Recognized options:\n  :as takes a symbol as its argument and makes that symbol an alias to the\n    lib's namespace in the current namespace.\n  :refer takes a list of symbols to refer from the namespace.\n  :refer-macros takes a list of macro symbols to refer from the namespace.\n  :include-macros true causes macros from the namespace to be required.\n  :rename specifies a map from referred var names to different\n    symbols (and can be used to prevent clashes)\n\n\n  Flags\n\n  A flag is a keyword.\n  Recognized flags: :reload, :reload-all, :verbose\n  :reload forces loading of all the identified libs even if they are\n    already loaded\n  :reload-all implies :reload and also forces loading of all libs that the\n    identified libs directly or indirectly load via require or use\n  :verbose triggers printing information about each load, alias, and refer\n\n  Example:\n\n  The following would load the library clojure.string :as string.\n\n  (require '[clojure.string :as string])",cljs.core.cst$kw$line,2939,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_require,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1090,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_dec_DASH_int,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$doc,"Expands into code that creates a fn that expects to be passed an\n  object and any args and calls the named instance method on the\n  object passing the args. Use when you want to treat a JavaScript\n  method as a first-class fn.",cljs.core.cst$kw$line,378,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_memfn,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$rest], null)),cljs.core.cst$kw$line,2632,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_js_DASH_obj,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,906,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_nil_QMARK_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$specs], null)),cljs.core.cst$kw$doc,"Useful when you want to provide several implementations of the same\n  protocol all at once. Takes a single protocol and the implementation\n  of that protocol for one or more types. Expands into calls to\n  extend-type:\n\n  (extend-protocol Protocol\n    AType\n      (foo [x] ...)\n      (bar [x y] ...)\n    BType\n      (foo [x] ...)\n      (bar [x y] ...)\n    AClass\n      (foo [x] ...)\n      (bar [x y] ...)\n    nil\n      (foo [x] ...)\n      (bar [x y] ...))\n\n  expands into:\n\n  (do\n   (clojure.core/extend-type AType Protocol \n     (foo [x] ...) \n     (bar [x y] ...))\n   (clojure.core/extend-type BType Protocol \n     (foo [x] ...) \n     (bar [x y] ...))\n   (clojure.core/extend-type AClass Protocol \n     (foo [x] ...) \n     (bar [x y] ...))\n   (clojure.core/extend-type nil Protocol \n     (foo [x] ...) \n     (bar [x y] ...)))",cljs.core.cst$kw$file,"clojure/core_deftype.clj",cljs.core.cst$kw$line,831,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_extend_DASH_protocol,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$expr,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$clauses], null)),cljs.core.cst$kw$doc,"Takes an expression and a set of test/form pairs. Threads expr (via ->)\n  through each form for which the corresponding test\n  expression is true. Note that, unlike cond branching, cond-> threading does\n  not short circuit after the first true test expression.",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,7240,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_cond_DASH__GT_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$bindings,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$body], null)),cljs.core.cst$kw$doc,"bindings => name n\n\n  Repeatedly executes body (presumably for side-effects) with name\n  bound to integers from 0 through n-1.",cljs.core.cst$kw$line,2685,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_dotimes,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$line,1202,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_bit_DASH_and,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$impls], null)),cljs.core.cst$kw$doc,"reify is a macro with the following structure:\n\n (reify options* specs*)\n\n  Currently there are no options.\n\n  Each spec consists of the protocol name followed by zero\n  or more method bodies:\n\n  protocol\n  (methodName [args+] body)*\n\n  Methods should be supplied for all methods of the desired\n  protocol(s). You can also define overrides for Object methods. Note that\n  the first parameter must be supplied to correspond to the target object\n  ('this' in JavaScript parlance). Note also that recur calls\n  to the method head should *not* pass the target object, it will be supplied\n  automatically and can not be substituted.\n\n  recur works to method heads The method bodies of reify are lexical\n  closures, and can refer to the surrounding local scope:\n\n  (str (let [f \"foo\"]\n       (reify Object\n         (toString [this] f))))\n  == \"foo\"\n\n  (seq (let [f \"foo\"]\n       (reify ISeqable\n         (-seq [this] (seq f)))))\n  == (\"f\" \"o\" \"o\"))\n\n  reify always implements IMeta and IWithMeta and transfers meta\n  data of the form to the created object.\n\n  (meta ^{:k :v} (reify Object (toString [this] \"foo\")))\n  == {:k :v}",cljs.core.cst$kw$line,1325,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_reify,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$c,cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1005,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_instance_QMARK_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null)),cljs.core.cst$kw$line,3040,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_load_DASH_file_STAR_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$init], null)),cljs.core.cst$kw$doc,"defs name to have the root value of init iff the named var has no root value,\n  else init is unevaluated",cljs.core.cst$kw$line,617,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_defonce,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$xs], null)),cljs.core.cst$kw$line,1081,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_add,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$private,cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$macro,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[true,cljs.core.cst$sym$cljs$core,cljs.core.cst$sym$cljs$core_SLASH_rfn,"cljs/core.cljc",1,1294,true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f1,cljs.core.cst$sym$k], null),cljs.core.cst$sym$fkv], null)),"Builds 3-arity reducing fn given names of wrapped fn and key, and k/v impl."]),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$b], null)),cljs.core.cst$kw$line,1002,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_identical_QMARK_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$xs], null)),cljs.core.cst$kw$line,1093,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_divide_DASH_int,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$decls], null)),cljs.core.cst$kw$doc,"same as defn, yielding non-public def",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,4743,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_defn_DASH_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$psym,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$doc_PLUS_methods], null)),cljs.core.cst$kw$doc,"A protocol is a named set of named methods and their signatures:\n\n  (defprotocol AProtocolName\n    ;optional doc string\n    \"A doc string for AProtocol abstraction\"\n\n  ;method signatures\n    (bar [this a b] \"bar docs\")\n    (baz [this a] [this a b] [this a b c] \"baz docs\"))\n\n  No implementations are provided. Docs can be specified for the\n  protocol overall and for each method. The above yields a set of\n  polymorphic functions and a protocol object. All are\n  namespace-qualified by the ns enclosing the definition The resulting\n  functions dispatch on the type of their first argument, which is\n  required and corresponds to the implicit target object ('this' in\n  JavaScript parlance). defprotocol is dynamic, has no special compile-time\n  effect, and defines no new types.\n\n  (defprotocol P\n    (foo [this])\n    (bar-me [this] [this y]))\n\n  (deftype Foo [a b c]\n    P\n    (foo [this] a)\n    (bar-me [this] b)\n    (bar-me [this y] (+ c y)))\n\n  (bar-me (Foo. 1 2 3) 42)\n  => 45\n\n  (foo\n    (let [x 42]\n      (reify P\n        (foo [this] 17)\n        (bar-me [this] x)\n        (bar-me [this y] x))))\n  => 17",cljs.core.cst$kw$line,1983,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_defprotocol,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY),cljs.core.cst$kw$line,2937,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_ns_DASH_special_DASH_form,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$xs], null)),cljs.core.cst$kw$line,1117,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_subtract,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$message], null)),cljs.core.cst$kw$doc,"Evaluates expr and throws an exception if it does not evaluate to\n  logical true.",cljs.core.cst$kw$line,2386,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_assert,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,971,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_true_QMARK_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$rest], null)),cljs.core.cst$kw$line,2542,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_array,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$fnspecs,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$body], null)),cljs.core.cst$kw$doc,"fnspec ==> (fname [params*] exprs) or (fname ([params*] exprs)+)\n\n  Takes a vector of function specs and a body, and generates a set of\n  bindings of functions to their names. All of the names are available\n  in all of the definitions of the functions, as well as the body.",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,6297,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_letfn,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$line,1134,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH__SLASH_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$hash,cljs.core.cst$sym$shift], null)),cljs.core.cst$kw$line,1255,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_bitpos,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$line,1211,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_bit_DASH_or,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$xs], null)),cljs.core.cst$kw$line,2578,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_vector,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$line,1159,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH__GT__EQ_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$bindings,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$body], null)),cljs.core.cst$kw$doc,"Evaluates the exprs in a lexical context in which the symbols in\n  the binding-forms are bound to their respective init-exprs or parts\n  therein. Acts as a recur target.",cljs.core.cst$kw$line,780,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_loop,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null)),cljs.core.cst$kw$line,1229,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_bit_DASH_flip,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$num,cljs.core.cst$sym$div], null)),cljs.core.cst$kw$line,1196,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_js_DASH_mod,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$body], null)),cljs.core.cst$kw$doc,"Evaluates exprs in a context in which *print-fn* is bound to .append\n  on a fresh StringBuffer.  Returns the string created by any nested\n  printing calls.",cljs.core.cst$kw$line,2840,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_with_DASH_out_DASH_str,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$added,cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$macro,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],["1.0",cljs.core.cst$sym$cljs$core,cljs.core.cst$sym$cljs$core_SLASH_condp,"cljs/core.cljc",1,2249,true,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$expr,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$clauses], null)),"Takes a binary predicate, an expression, and a set of clauses.\n  Each clause can take the form of either:\n\n  test-expr result-expr\n\n  test-expr :>> result-fn\n\n  Note :>> is an ordinary keyword.\n\n  For each clause, (pred test-expr expr) is evaluated. If it returns\n  logical true, the clause is a match. If a binary clause matches, the\n  result-expr is returned, if a ternary clause matches, its result-fn,\n  which must be a unary function, is called with the result of the\n  predicate as its argument, the result of that call being the return\n  value of condp. A single default expression can follow the clauses,\n  and its value will be returned if no clause matches. If no default\n  expression is provided and no clause matches, an Error is thrown."]),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$clauses], null)),cljs.core.cst$kw$doc,"Takes a set of test/expr pairs. It evaluates each test one at a\n  time.  If a test returns logical true, cond evaluates and returns\n  the value of the corresponding expr and doesn't evaluate any of the\n  other tests or exprs. (cond) returns nil.",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,580,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_cond,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$expr,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$forms], null)),cljs.core.cst$kw$doc,"When expr is not nil, threads it into the first form (via ->),\n  and when that result is not nil, through the next etc",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,7286,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_some_DASH__GT_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$quoted_DASH_ns], null)),cljs.core.cst$kw$doc,"Returns a map of the intern mappings for the namespace.",cljs.core.cst$kw$line,2899,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_ns_DASH_interns,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$seq_DASH_exprs,cljs.core.cst$sym$body_DASH_expr], null)),cljs.core.cst$kw$doc,"List comprehension. Takes a vector of one or more\n   binding-form/collection-expr pairs, each followed by zero or more\n   modifiers, and yields a lazy sequence of evaluations of expr.\n   Collections are iterated in a nested fashion, rightmost fastest,\n   and nested coll-exprs can refer to bindings created in prior\n   binding-forms.  Supported modifiers are: :let [binding-form expr ...],\n   :while test, :when test.\n\n  (take 100 (for [x (range 100000000) y (range 1000000) :while (< y x)]  [x y]))",cljs.core.cst$kw$line,2399,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_for,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$bindings,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$body], null)),cljs.core.cst$kw$doc,"binding => var-symbol init-expr\n\n  Creates new bindings for the (already-existing) vars, with the\n  supplied initial values, executes the exprs in an implicit do, then\n  re-establishes the bindings that existed before.  The new bindings\n  are made in parallel (unlike let); all init-exprs are evaluated\n  before the vars are bound to their new values.",cljs.core.cst$kw$line,2236,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_binding,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$kvs], null)),cljs.core.cst$kw$line,2589,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_array_DASH_map,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1075,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_byte,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$quoted_DASH_ns], null)),cljs.core.cst$kw$doc,"Returns a map of the import mappings for the namespace.",cljs.core.cst$kw$line,2885,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_ns_DASH_imports,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name,cljs.core.cst$sym$doc_DASH_string_QMARK_,cljs.core.cst$sym$attr_DASH_map_QMARK_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$params_STAR_], null),cljs.core.cst$sym$body], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name,cljs.core.cst$sym$doc_DASH_string_QMARK_,cljs.core.cst$sym$attr_DASH_map_QMARK_,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$params_STAR_], null),cljs.core.cst$sym$body),cljs.core.cst$sym$_PLUS_,cljs.core.cst$sym$attr_DASH_map_QMARK_], null)),cljs.core.cst$kw$doc,"Like defn, but the resulting function name is declared as a\n  macro and will be used as a macro by the compiler when it is\n  called.",cljs.core.cst$kw$line,3319,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_defmacro,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1077,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_short,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1172,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_inc,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$bindings,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$body], null)),cljs.core.cst$kw$doc,"binding => var-symbol temp-value-expr\n\n  Temporarily redefines vars while executing the body.  The\n  temp-value-exprs will be evaluated and each resulting value will\n  replace in parallel the root value of its var.  After the body is\n  executed, the root values of all the vars will be set back to their\n  old values. Useful for mocking out functions during testing.",cljs.core.cst$kw$line,2212,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_with_DASH_redefs,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null)),cljs.core.cst$kw$line,1226,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_bit_DASH_clear,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$forms], null)),cljs.core.cst$kw$line,2932,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_locking,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$xs], null)),cljs.core.cst$kw$line,2569,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_list,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$line,1064,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH__PLUS_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$val], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$idx2,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$idxv], null)),cljs.core.cst$kw$line,1036,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_aset,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name,cljs.core.cst$sym$docstring_QMARK_,cljs.core.cst$sym$attr_DASH_map_QMARK_,cljs.core.cst$sym$dispatch_DASH_fn,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$options], null)),cljs.core.cst$kw$doc,"Creates a new multimethod with the associated dispatch function.\n  The docstring and attribute-map are optional.\n\n  Options are key-value pairs and may be one of:\n    :default    the default dispatch value, defaults to :default\n    :hierarchy  the isa? hierarchy to use for dispatching\n                defaults to the global hierarchy",cljs.core.cst$kw$line,2709,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_defmulti,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ys], null)),cljs.core.cst$kw$line,843,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_str,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)),cljs.core.cst$kw$line,918,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_coercive_DASH__EQ_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$kvs], null)),cljs.core.cst$kw$line,2599,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_hash_DASH_map,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$num_DASH_args,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$line,2836,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_gen_DASH_apply_DASH_to_DASH_simple,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$bindings,cljs.core.cst$sym$then], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$bindings,cljs.core.cst$sym$then,cljs.core.cst$sym$else,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$oldform], null)),cljs.core.cst$kw$doc,"bindings => binding-form test\n\n  If test is true, evaluates then with binding-form bound to the value of \n  test, if not, yields else",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,1749,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_if_DASH_let,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,974,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_false_QMARK_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$e,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$clauses], null)),cljs.core.cst$kw$doc,"Takes an expression, and a set of clauses.\n\n  Each clause can take the form of either:\n\n  test-constant result-expr\n\n  (test-constant1 ... test-constantN)  result-expr\n\n  The test-constants are not evaluated. They must be compile-time\n  literals, and need not be quoted.  If the expression is equal to a\n  test-constant, the corresponding result-expr is returned. A single\n  default expression can follow the clauses, and its value will be\n  returned if no clause matches. If no default expression is provided\n  and no clause matches, an Error is thrown.\n\n  Unlike cond and condp, case does a constant-time dispatch, the\n  clauses are not considered sequentially.  All manner of constant\n  expressions are acceptable in case, including numbers, strings,\n  symbols, keywords, and (ClojureScript) composites thereof. Note that since\n  lists are used to group multiple constants that map to the same\n  expression, a vector can be used to match a list if needed. The\n  test-constants need not be all of the same type.",cljs.core.cst$kw$line,2312,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_case,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$doc,"Return true if argument exists, analogous to usage of typeof operator\n   in JavaScript.",cljs.core.cst$kw$line,980,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_exists_QMARK_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1199,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_bit_DASH_not,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1070,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_byte,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$line,1184,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_max,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$line,1164,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH__EQ__EQ_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$colls], null)),cljs.core.cst$kw$doc,"Expands to code which yields a lazy sequence of the concatenation\n  of the supplied colls.  Each coll expr is not evaluated until it is\n  needed.\n\n  (lazy-cat xs ys zs) === (concat (lazy-seq xs) (lazy-seq ys) (lazy-seq zs))",cljs.core.cst$kw$line,2851,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_lazy_DASH_cat,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$body], null)),cljs.core.cst$kw$doc,"Ignores body, yields nil",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,4555,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_comment,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$dest], null)),cljs.core.cst$kw$line,3113,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_copy_DASH_arguments,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,2383,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_when_DASH_assert,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$t,cljs.core.cst$sym$x], null)),cljs.core.cst$kw$doc,"EXPERIMENTAL: Subject to change. Unsafely cast a value to a different type.",cljs.core.cst$kw$line,960,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unsafe_DASH_cast,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$quoted_DASH_sym], null)),cljs.core.cst$kw$doc,"Returns the var to which a symbol will be resolved in the namespace else nil.",cljs.core.cst$kw$line,3365,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_resolve,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$rsym,cljs.core.cst$sym$fields,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$impls], null)),cljs.core.cst$kw$doc,"(defrecord name [fields*]  options* specs*)\n\n  Currently there are no options.\n\n  Each spec consists of a protocol or interface name followed by zero\n  or more method bodies:\n\n  protocol-or-Object\n  (methodName [args*] body)*\n\n  The record will have the (immutable) fields named by\n  fields, which can have type hints. Protocols and methods\n  are optional. The only methods that can be supplied are those\n  declared in the protocols.  Note that method bodies are\n  not closures, the local environment includes only the named fields,\n  and those fields can be accessed directly.\n\n  Method definitions take the form:\n\n  (methodname [args*] body)\n\n  The argument and return types can be hinted on the arg and\n  methodname symbols. If not supplied, they will be inferred, so type\n  hints should be reserved for disambiguation.\n\n  Methods should be supplied for all methods of the desired\n  protocol(s). You can also define overrides for\n  methods of Object. Note that a parameter must be supplied to\n  correspond to the target object ('this' in JavaScript parlance). Note also\n  that recur calls to the method head should *not* pass the target object, it\n  will be supplied automatically and can not be substituted.\n\n  In the method bodies, the (unqualified) name can be used to name the\n  class (for calls to new, instance? etc).\n\n  The type will have implementations of several ClojureScript\n  protocol generated automatically: IMeta/IWithMeta (metadata support) and\n  IMap, etc.\n\n  In addition, defrecord will define type-and-value-based =,\n  and will define ClojureScript IHash and IEquiv.\n\n  Two constructors will be defined, one taking the designated fields\n  followed by a metadata map (nil for none) and an extension field\n  map (nil for none), and one taking only the fields (using nil for\n  meta and extension fields). Note that the field names __meta\n  and __extmap are currently reserved and should not be used when\n  defining your own records.\n\n  Given (defrecord TypeName ...), two factory functions will be\n  defined: ->TypeName, taking positional parameters for the fields,\n  and map->TypeName, taking a map of keywords to field values.",cljs.core.cst$kw$line,1914,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_defrecord,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$type,cljs.core.cst$sym$size], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$type,cljs.core.cst$sym$size,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more_DASH_sizes], null)),cljs.core.cst$kw$line,2551,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_make_DASH_array,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1111,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_negate_DASH_int,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$cljs$analyzer_SLASH_numeric,true,cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1096,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_inc,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$next], null)),cljs.core.cst$kw$doc,"Evaluates exprs one at a time, from left to right. If a form\n  returns logical false (nil or false), and returns that value and\n  doesn't evaluate any of the other expressions, otherwise it returns\n  the value of the last expr. (and) returns true.",cljs.core.cst$kw$line,868,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_and,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1014,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_number_QMARK_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$comment], null)),cljs.core.cst$kw$doc,"Emit a top-level JavaScript multi-line comment. New lines will create a\n  new comment line. Comment block will be preceded and followed by a newline",cljs.core.cst$kw$line,946,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_js_DASH_comment,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1017,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_symbol_QMARK_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$bindings,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$body], null)),cljs.core.cst$kw$doc,"bindings => binding-form test\n\n   When test is not nil, evaluates body with binding-form bound to the\n   value of test",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,1804,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_when_DASH_some,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$line,1076,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_char,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$doc,"Similar to require but only for macros.",cljs.core.cst$kw$line,2994,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_require_DASH_macros,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$forms], null)),cljs.core.cst$kw$doc,"Threads the expr through the forms. Inserts x as the\n  last item in the first form, making a list of it if it is not a\n  list already. If there are more forms, inserts the first form as the\n  last item in second form, etc.",cljs.core.cst$kw$file,"clojure/core.clj",cljs.core.cst$kw$line,1602,cljs.core.cst$kw$column,4,cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH__DASH__GT__GT_,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$comment], null)),cljs.core.cst$kw$doc,"Emit an inline JavaScript comment.",cljs.core.cst$kw$line,966,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_js_DASH_inline_DASH_comment,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$doc,"Refers to all the public vars of `cljs.core`, subject to\n  filters.\n  Filters can include at most one each of:\n\n  :exclude list-of-symbols\n  :rename map-of-fromsymbol-tosymbol\n\n  Filters can be used to select a subset, via exclusion, or to provide a mapping\n  to a symbol different from the var's name, in order to prevent clashes.",cljs.core.cst$kw$line,3026,cljs.core.cst$kw$column,1,cljs.core.cst$kw$file,"cljs/core.cljc",cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_refer_DASH_clojure,cljs.core.cst$kw$ns,cljs.core.cst$sym$cljs$core,cljs.core.cst$kw$macro,true], null)]),cljs.core.cst$sym$cljs$core,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$StringBuffer,cljs.core.cst$sym$goog$string$StringBuffer], null),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$sym$gstring,cljs.core.cst$sym$goog$string,cljs.core.cst$sym$goog$Uri,cljs.core.cst$sym$garray,cljs.core.cst$sym$goog$object,cljs.core.cst$sym$goog$math$Integer,cljs.core.cst$sym$StringBuffer,cljs.core.cst$sym$gobject,cljs.core.cst$sym$goog$array,cljs.core.cst$sym$goog$math$Long],[cljs.core.cst$sym$goog$string,cljs.core.cst$sym$goog$string,cljs.core.cst$sym$goog$Uri,cljs.core.cst$sym$goog$array,cljs.core.cst$sym$goog$object,cljs.core.cst$sym$goog$math$Integer,cljs.core.cst$sym$goog$string$StringBuffer,cljs.core.cst$sym$goog$object,cljs.core.cst$sym$goog$array,cljs.core.cst$sym$goog$math$Long]),null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$sym$_DASH__GT_PersistentHashSet,cljs.core.cst$sym$js_DASH__GT_clj,cljs.core.cst$sym$sort_DASH_by,cljs.core.cst$sym$ITransientAssociative,cljs.core.cst$sym$chunk_DASH_first,cljs.core.cst$sym$print_DASH_meta_QMARK_,cljs.core.cst$sym$m3_DASH_hash_DASH_int,cljs.core.cst$sym$pr_DASH_str_STAR_,cljs.core.cst$sym$eduction,cljs.core.cst$sym$tree_DASH_seq,cljs.core.cst$sym$unchecked_DASH_remainder_DASH_int,cljs.core.cst$sym$uuid,cljs.core.cst$sym$seq,cljs.core.cst$sym$Volatile,cljs.core.cst$sym$reduce,cljs.core.cst$sym$IUUID,cljs.core.cst$sym$INIT,cljs.core.cst$sym$find_DASH_ns,cljs.core.cst$sym$contains_QMARK_,cljs.core.cst$sym$every_QMARK_,cljs.core.cst$sym$_DASH__GT_ES6IteratorSeq,cljs.core.cst$sym$Var,cljs.core.cst$sym$keep_DASH_indexed,cljs.core.cst$sym$_DASH__GT_PersistentQueueSeq,cljs.core.cst$sym$subs,cljs.core.cst$sym$IFind,cljs.core.cst$sym$set,cljs.core.cst$sym$MODULE_URIS,cljs.core.cst$sym$compare_DASH_indexed,cljs.core.cst$sym$take_DASH_last,cljs.core.cst$sym$IndexedSeq,cljs.core.cst$sym$bit_DASH_set,cljs.core.cst$sym$string_DASH_hash_DASH_cache_DASH_count,cljs.core.cst$sym$qualified_DASH_keyword_QMARK_,cljs.core.cst$sym$_DASH__GT_Eduction,cljs.core.cst$sym$tree_DASH_map_DASH_add,cljs.core.cst$sym$_DASH__GT_ES6SetEntriesIterator,cljs.core.cst$sym$_DASH_with_DASH_meta,cljs.core.cst$sym$reset_DASH_cache,cljs.core.cst$sym$_DASH__GT_PersistentArrayMapIterator,cljs.core.cst$sym$PersistentArrayMapIterator,cljs.core.cst$sym$butlast,cljs.core.cst$sym$tail_DASH_off,cljs.core.cst$sym$unchecked_DASH_subtract_DASH_int,cljs.core.cst$sym$_DASH_iterator,cljs.core.cst$sym$_STAR_print_DASH_namespace_DASH_maps_STAR_,cljs.core.cst$sym$take_DASH_nth,cljs.core.cst$sym$first,cljs.core.cst$sym$native_DASH_satisfies_QMARK_,cljs.core.cst$sym$seq_QMARK_,cljs.core.cst$sym$_DASH_global_DASH_hierarchy,cljs.core.cst$sym$UUID,cljs.core.cst$sym$_DASH_sorted_DASH_seq_DASH_from,cljs.core.cst$sym$println_DASH_str,cljs.core.cst$sym$inst_DASH_ms,cljs.core.cst$sym$linear_DASH_traversal_DASH_nth,cljs.core.cst$sym$iterate,cljs.core.cst$sym$checked_DASH_aget_SINGLEQUOTE_,cljs.core.cst$sym$_DASH_empty,cljs.core.cst$sym$newline,cljs.core.cst$sym$ILookup,cljs.core.cst$sym$_DASH_chunked_DASH_rest,cljs.core.cst$sym$write_DASH_all,cljs.core.cst$sym$fn_QMARK_,cljs.core.cst$sym$_DASH_prefer_DASH_method,cljs.core.cst$sym$_DASH_assoc,cljs.core.cst$sym$doall,cljs.core.cst$sym$keyword_DASH_identical_QMARK_,cljs.core.cst$sym$_STAR_print_DASH_err_DASH_fn_STAR_,cljs.core.cst$sym$pv_DASH_aset,cljs.core.cst$sym$prefers,cljs.core.cst$sym$_DASH_js_DASH__GT_clj,cljs.core.cst$sym$LazySeq,cljs.core.cst$sym$dedupe,cljs.core.cst$sym$unchecked_DASH_editable_DASH_array_DASH_for,cljs.core.cst$sym$_DASH__GT_ES6Iterator,cljs.core.cst$sym$VectorNode,cljs.core.cst$sym$dissoc,cljs.core.cst$sym$atom,cljs.core.cst$sym$bit_DASH_shift_DASH_right,cljs.core.cst$sym$MapEntry,cljs.core.cst$sym$_STAR_clojurescript_DASH_version_STAR_,cljs.core.cst$sym$_DASH_first,cljs.core.cst$sym$peek,cljs.core.cst$sym$IKVReduce,cljs.core.cst$sym$iter_DASH_reduce,cljs.core.cst$sym$aget,cljs.core.cst$sym$PersistentTreeMapSeq,cljs.core.cst$sym$_DASH_write,cljs.core.cst$sym$_DASH__GT_t_cljs$core9576,cljs.core.cst$sym$iter,cljs.core.cst$sym$mk_DASH_bound_DASH_fn,cljs.core.cst$sym$last,cljs.core.cst$sym$_DASH_default_DASH_dispatch_DASH_val,cljs.core.cst$sym$pr,cljs.core.cst$sym$tree_DASH_map_DASH_seq_DASH_push,cljs.core.cst$sym$namespace,cljs.core.cst$sym$empty_DASH_unordered_DASH_hash,cljs.core.cst$sym$obj_DASH_map,cljs.core.cst$sym$Reduced,cljs.core.cst$sym$_DASH_conj,cljs.core.cst$sym$NodeSeq,cljs.core.cst$sym$_EQ_,cljs.core.cst$sym$ITransientMap,cljs.core.cst$sym$push_DASH_tail,cljs.core.cst$sym$take,cljs.core.cst$sym$vector_QMARK_,cljs.core.cst$sym$array_DASH_index_DASH_of_DASH_equiv_QMARK_,cljs.core.cst$sym$bitmap_DASH_indexed_DASH_node_DASH_index,cljs.core.cst$sym$boolean,cljs.core.cst$sym$IChunk,cljs.core.cst$sym$bit_DASH_shift_DASH_left,cljs.core.cst$sym$random_DASH_uuid,cljs.core.cst$sym$any_QMARK_,cljs.core.cst$sym$rand_DASH_int,cljs.core.cst$sym$aclone,cljs.core.cst$sym$BlackNode,cljs.core.cst$sym$vreset_BANG_,cljs.core.cst$sym$chunk,cljs.core.cst$sym$UNREALIZED_DASH_SEED,cljs.core.cst$sym$dec,cljs.core.cst$sym$_DASH__GT_TransformerIterator,cljs.core.cst$sym$APersistentVector,cljs.core.cst$sym$map,cljs.core.cst$sym$juxt,cljs.core.cst$sym$_DASH__GT_PersistentQueueIter,cljs.core.cst$sym$_LT_,cljs.core.cst$sym$_STAR_eval_STAR_,cljs.core.cst$sym$inode_DASH_kv_DASH_reduce,cljs.core.cst$sym$obj_DASH_map_DASH__GT_hash_DASH_map,cljs.core.cst$sym$test,cljs.core.cst$sym$rest,cljs.core.cst$sym$ex_DASH_data,cljs.core.cst$sym$PersistentArrayMapSeq,cljs.core.cst$sym$_DASH_drop_DASH_first,cljs.core.cst$sym$isa_QMARK_,cljs.core.cst$sym$boolean_QMARK_,cljs.core.cst$sym$_DASH_clone,cljs.core.cst$sym$munge,cljs.core.cst$sym$empty_DASH_ordered_DASH_hash,cljs.core.cst$sym$DEMUNGE_MAP,cljs.core.cst$sym$ES6IteratorSeq,cljs.core.cst$sym$_DASH__GT_NeverEquiv,cljs.core.cst$sym$re_DASH_seq,cljs.core.cst$sym$char_QMARK_,cljs.core.cst$sym$make_DASH_hierarchy,cljs.core.cst$sym$Symbol,cljs.core.cst$sym$PROTOCOL_SENTINEL,cljs.core.cst$sym$tv_DASH_push_DASH_tail,cljs.core.cst$sym$_DASH_reduce,cljs.core.cst$sym$_DASH_count,cljs.core.cst$sym$swap_DASH_vals_BANG_,cljs.core.cst$sym$keep,cljs.core.cst$sym$char,cljs.core.cst$sym$mapcat,cljs.core.cst$sym$unchecked_DASH_long,cljs.core.cst$sym$m3_DASH_seed,cljs.core.cst$sym$some_QMARK_,cljs.core.cst$sym$unchecked_DASH_negate,cljs.core.cst$sym$remove_DASH_tap,cljs.core.cst$sym$symbol_DASH_identical_QMARK_,cljs.core.cst$sym$_STAR_command_DASH_line_DASH_args_STAR_,cljs.core.cst$sym$reverse,cljs.core.cst$sym$inst_QMARK_,cljs.core.cst$sym$range,cljs.core.cst$sym$bit_DASH_count,cljs.core.cst$sym$create_DASH_node,cljs.core.cst$sym$sort,cljs.core.cst$sym$_DASH__GT_MetaFn,cljs.core.cst$sym$unchecked_DASH_inc_DASH_int,cljs.core.cst$sym$_DASH_compare,cljs.core.cst$sym$map_DASH_indexed,cljs.core.cst$sym$array_DASH_list,cljs.core.cst$sym$rand_DASH_nth,cljs.core.cst$sym$comp,cljs.core.cst$sym$array_DASH_chunk,cljs.core.cst$sym$dispatch_DASH_fn,cljs.core.cst$sym$bit_DASH_shift_DASH_right_DASH_zero_DASH_fill,cljs.core.cst$sym$js_DASH_reserved_QMARK_,cljs.core.cst$sym$_DASH_as_DASH_transient,cljs.core.cst$sym$dorun,cljs.core.cst$sym$pr_DASH_sequential_DASH_writer,cljs.core.cst$sym$simple_DASH_symbol_QMARK_,cljs.core.cst$sym$accumulating_DASH_seq_DASH_count,cljs.core.cst$sym$IIndexed,cljs.core.cst$sym$disj,cljs.core.cst$sym$MultiIterator,cljs.core.cst$sym$IPrintWithWriter,cljs.core.cst$sym$_DASH__GT_UUID,cljs.core.cst$sym$IVector,cljs.core.cst$sym$IIterable,cljs.core.cst$sym$_DASH__GT_MultiIterator,cljs.core.cst$sym$_STAR_2,cljs.core.cst$sym$eval,cljs.core.cst$sym$Eduction,cljs.core.cst$sym$pv_DASH_clone_DASH_node,cljs.core.cst$sym$cons,cljs.core.cst$sym$PersistentTreeSet,cljs.core.cst$sym$_DASH__GT_HashSetIter,cljs.core.cst$sym$ns_DASH_lookup,cljs.core.cst$sym$floats,cljs.core.cst$sym$TransientVector,cljs.core.cst$sym$pos_QMARK_,cljs.core.cst$sym$fnil,cljs.core.cst$sym$merge_DASH_with,cljs.core.cst$sym$nthrest,cljs.core.cst$sym$_STAR_warn_DASH_on_DASH_infer_STAR_,cljs.core.cst$sym$_DASH_find,cljs.core.cst$sym$sequential_QMARK_,cljs.core.cst$sym$tree_DASH_map_DASH_replace,cljs.core.cst$sym$checked_DASH_aset_SINGLEQUOTE_,cljs.core.cst$sym$m3_DASH_mix_DASH_H1,cljs.core.cst$sym$RecordIter,cljs.core.cst$sym$_DASH__GT_TransientArrayMap,cljs.core.cst$sym$re_DASH_seq_STAR_,cljs.core.cst$sym$prim_DASH_seq,cljs.core.cst$sym$_STAR_print_DASH_level_STAR_,cljs.core.cst$sym$shuffle,cljs.core.cst$sym$ChunkedSeq,cljs.core.cst$sym$hash_DASH_keyword,cljs.core.cst$sym$find,cljs.core.cst$sym$alength,cljs.core.cst$sym$bit_DASH_xor,cljs.core.cst$sym$_DASH__GT_IndexedSeq,cljs.core.cst$sym$ObjMap,cljs.core.cst$sym$unsigned_DASH_bit_DASH_shift_DASH_right,cljs.core.cst$sym$ES6SetEntriesIterator,cljs.core.cst$sym$neg_QMARK_,cljs.core.cst$sym$Cons,cljs.core.cst$sym$_DASH_remove_DASH_method,cljs.core.cst$sym$_DASH__GT_StringIter,cljs.core.cst$sym$js_DASH_invoke,cljs.core.cst$sym$_DASH__GT_List,cljs.core.cst$sym$m3_DASH_mix_DASH_K1,cljs.core.cst$sym$Iterate,cljs.core.cst$sym$unchecked_DASH_float,cljs.core.cst$sym$undefined_QMARK_,cljs.core.cst$sym$t_cljs$core11184,cljs.core.cst$sym$IMeta,cljs.core.cst$sym$reduced_QMARK_,cljs.core.cst$sym$apply_DASH_to,cljs.core.cst$sym$disj_BANG_,cljs.core.cst$sym$_DASH_lookup,cljs.core.cst$sym$float_QMARK_,cljs.core.cst$sym$ICloneable,cljs.core.cst$sym$IEncodeClojure,cljs.core.cst$sym$booleans,cljs.core.cst$sym$_DASH__GT_ArrayList,cljs.core.cst$sym$RSeq,cljs.core.cst$sym$mask,cljs.core.cst$sym$int_DASH_array,cljs.core.cst$sym$find_DASH_and_DASH_cache_DASH_best_DASH_method,cljs.core.cst$sym$set_QMARK_,cljs.core.cst$sym$iterable_QMARK_,cljs.core.cst$sym$cat,cljs.core.cst$sym$_DASH__GT_ES6EntriesIterator,cljs.core.cst$sym$divide,cljs.core.cst$sym$js_DASH_reserved_DASH_arr,cljs.core.cst$sym$_DASH_pr_DASH_writer,cljs.core.cst$sym$flush,cljs.core.cst$sym$set_DASH_from_DASH_indexed_DASH_seq,cljs.core.cst$sym$maybe_DASH_init_DASH_tapset,cljs.core.cst$sym$take_DASH_while,cljs.core.cst$sym$vary_DASH_meta,cljs.core.cst$sym$INext,cljs.core.cst$sym$is_proto_,cljs.core.cst$sym$START,cljs.core.cst$sym$ICounted,cljs.core.cst$sym$IMapEntry,cljs.core.cst$sym$pv_DASH_reduce,cljs.core.cst$sym$_LT__EQ_,cljs.core.cst$sym$MODULE_INFOS,cljs.core.cst$sym$conj_BANG_,cljs.core.cst$sym$_DASH_pop,cljs.core.cst$sym$array_DASH_index_DASH_of_DASH_identical_QMARK_,cljs.core.cst$sym$repeatedly,cljs.core.cst$sym$zipmap,cljs.core.cst$sym$reset_DASH_vals_BANG_,cljs.core.cst$sym$IStack,cljs.core.cst$sym$_DASH_remove_DASH_watch,cljs.core.cst$sym$IVolatile,cljs.core.cst$sym$remove,cljs.core.cst$sym$_DASH__GT_BitmapIndexedNode,cljs.core.cst$sym$_DASH__GT_t_cljs$core11184,cljs.core.cst$sym$_STAR_,cljs.core.cst$sym$re_DASH_pattern,cljs.core.cst$sym$min,cljs.core.cst$sym$array_DASH_index_DASH_of_DASH_nil_QMARK_,cljs.core.cst$sym$_DASH_persistent_BANG_,cljs.core.cst$sym$_DASH_nth,cljs.core.cst$sym$pop_BANG_,cljs.core.cst$sym$chunk_DASH_append,cljs.core.cst$sym$_STAR_unchecked_DASH_arrays_STAR_,cljs.core.cst$sym$prn_DASH_str,cljs.core.cst$sym$IReversible,cljs.core.cst$sym$reversible_QMARK_,cljs.core.cst$sym$_DASH_realized_QMARK_,cljs.core.cst$sym$_DASH_add_DASH_watch,cljs.core.cst$sym$_DASH_deref_DASH_with_DASH_timeout,cljs.core.cst$sym$conj,cljs.core.cst$sym$_DASH_sorted_DASH_seq,cljs.core.cst$sym$flatten1,cljs.core.cst$sym$transduce,cljs.core.cst$sym$_DASH_swap_BANG_,cljs.core.cst$sym$_STAR_print_DASH_length_STAR_,cljs.core.cst$sym$js_DASH_delete,cljs.core.cst$sym$truth_,cljs.core.cst$sym$array_DASH_index_DASH_of,cljs.core.cst$sym$_DASH__GT_MultiFn,cljs.core.cst$sym$key_DASH__GT_js,cljs.core.cst$sym$IEncodeJS,cljs.core.cst$sym$new_DASH_path,cljs.core.cst$sym$compare_DASH_and_DASH_set_BANG_,cljs.core.cst$sym$array_DASH_seq,cljs.core.cst$sym$array_DASH_copy_DASH_downward,cljs.core.cst$sym$pack_DASH_array_DASH_node,cljs.core.cst$sym$interleave,cljs.core.cst$sym$print_DASH_map,cljs.core.cst$sym$map_QMARK_,cljs.core.cst$sym$m3_DASH_C1,cljs.core.cst$sym$get,cljs.core.cst$sym$identity,cljs.core.cst$sym$into,cljs.core.cst$sym$long,cljs.core.cst$sym$double,cljs.core.cst$sym$volatile_QMARK_,cljs.core.cst$sym$ChunkBuffer,cljs.core.cst$sym$HashSetIter,cljs.core.cst$sym$_DASH_key,cljs.core.cst$sym$nfirst,cljs.core.cst$sym$StringBufferWriter,cljs.core.cst$sym$meta,cljs.core.cst$sym$tv_DASH_editable_DASH_tail,cljs.core.cst$sym$_DASH_kv_DASH_reduce,cljs.core.cst$sym$IHash,cljs.core.cst$sym$bit_DASH_and_DASH_not,cljs.core.cst$sym$var_QMARK_,cljs.core.cst$sym$_DASH_comparator,cljs.core.cst$sym$unchecked_DASH_add_DASH_int,cljs.core.cst$sym$hash_DASH_ordered_DASH_coll,cljs.core.cst$sym$extend_DASH_object_BANG_,cljs.core.cst$sym$do_DASH_assoc,cljs.core.cst$sym$reset_DASH_meta_BANG_,cljs.core.cst$sym$_DASH__GT_KeySeq,cljs.core.cst$sym$IEquiv,cljs.core.cst$sym$tree_DASH_map_DASH_kv_DASH_reduce,cljs.core.cst$sym$cycle,cljs.core.cst$sym$_DASH_deref,cljs.core.cst$sym$pr_DASH_writer_DASH_ex_DASH_info,cljs.core.cst$sym$empty_QMARK_,cljs.core.cst$sym$TaggedLiteral,cljs.core.cst$sym$short,cljs.core.cst$sym$_DASH_clj_DASH__GT_js,cljs.core.cst$sym$_DASH_chunked_DASH_first,cljs.core.cst$sym$add_DASH_tap,cljs.core.cst$sym$filterv,cljs.core.cst$sym$_DASH__GT_TaggedLiteral,cljs.core.cst$sym$tv_DASH_editable_DASH_root,cljs.core.cst$sym$hash,cljs.core.cst$sym$quot,cljs.core.cst$sym$ns_DASH_interns_STAR_,cljs.core.cst$sym$unchecked_DASH_double,cljs.core.cst$sym$_STAR_target_STAR_,cljs.core.cst$sym$_DASH__GT_ChunkedCons,cljs.core.cst$sym$ranged_DASH_iterator,cljs.core.cst$sym$ITransientVector,cljs.core.cst$sym$key,cljs.core.cst$sym$longs,cljs.core.cst$sym$not_EQ_,cljs.core.cst$sym$set_DASH_print_DASH_err_DASH_fn_BANG_,cljs.core.cst$sym$string_QMARK_,cljs.core.cst$sym$uri_QMARK_,cljs.core.cst$sym$es6_DASH_iterator,cljs.core.cst$sym$Delay,cljs.core.cst$sym$munge_DASH_str,cljs.core.cst$sym$pr_DASH_str_DASH_with_DASH_opts,cljs.core.cst$sym$_DASH__GT_RecordIter,cljs.core.cst$sym$m3_DASH_C2,cljs.core.cst$sym$_DASH__GT_Symbol,cljs.core.cst$sym$_STAR_print_DASH_newline_STAR_,cljs.core.cst$sym$unchecked_DASH_multiply_DASH_int,cljs.core.cst$sym$tapset,cljs.core.cst$sym$chunk_DASH_rest,cljs.core.cst$sym$remove_DASH_all_DASH_methods,cljs.core.cst$sym$trampoline,cljs.core.cst$sym$double_QMARK_,cljs.core.cst$sym$pr_DASH_opts,cljs.core.cst$sym$_STAR_1,cljs.core.cst$sym$vec,cljs.core.cst$sym$_DASH__GT_Cycle,cljs.core.cst$sym$_STAR_print_DASH_meta_STAR_,cljs.core.cst$sym$_DASH_notify_DASH_watches,cljs.core.cst$sym$MultiFn,cljs.core.cst$sym$NONE,cljs.core.cst$sym$int,cljs.core.cst$sym$_DASH__GT_ValSeq,cljs.core.cst$sym$map_DASH_entry_QMARK_,cljs.core.cst$sym$rand,cljs.core.cst$sym$second,cljs.core.cst$sym$find_DASH_ns_DASH_obj,cljs.core.cst$sym$IEditableCollection,cljs.core.cst$sym$hash_DASH_combine,cljs.core.cst$sym$_GT_,cljs.core.cst$sym$_DASH_name,cljs.core.cst$sym$replace,cljs.core.cst$sym$int_QMARK_,cljs.core.cst$sym$_DASH__GT_Subvec,cljs.core.cst$sym$associative_QMARK_,cljs.core.cst$sym$unchecked_DASH_int,cljs.core.cst$sym$js_DASH_keys,cljs.core.cst$sym$inst_DASH_ms_STAR_,cljs.core.cst$sym$ES6EntriesIterator,cljs.core.cst$sym$keyword_QMARK_,cljs.core.cst$sym$array_DASH_iter,cljs.core.cst$sym$force,cljs.core.cst$sym$group_DASH_by,cljs.core.cst$sym$_DASH_rseq,cljs.core.cst$sym$prn,cljs.core.cst$sym$tv_DASH_pop_DASH_tail,cljs.core.cst$sym$default_DASH_dispatch_DASH_val,cljs.core.cst$sym$RangeChunk,cljs.core.cst$sym$_DASH__GT_Atom,cljs.core.cst$sym$PersistentHashMap,cljs.core.cst$sym$unchecked_DASH_multiply,cljs.core.cst$sym$ArrayNodeSeq,cljs.core.cst$sym$even_QMARK_,cljs.core.cst$sym$es6_DASH_iterator_DASH_seq,cljs.core.cst$sym$unchecked_DASH_dec,cljs.core.cst$sym$Inst,cljs.core.cst$sym$hash_DASH_collision_DASH_node_DASH_find_DASH_index,cljs.core.cst$sym$persistent_DASH_array_DASH_map_DASH_seq,cljs.core.cst$sym$RangeIterator,cljs.core.cst$sym$tagged_DASH_literal_QMARK_,cljs.core.cst$sym$double_DASH_array,cljs.core.cst$sym$create_DASH_ns,cljs.core.cst$sym$_DASH__GT_EmptyList,cljs.core.cst$sym$seq_DASH_reduce,cljs.core.cst$sym$spread,cljs.core.cst$sym$balance_DASH_left,cljs.core.cst$sym$rseq,cljs.core.cst$sym$ex_DASH_cause,cljs.core.cst$sym$IReset,cljs.core.cst$sym$IEmptyableCollection,cljs.core.cst$sym$array_DASH_map_DASH_index_DASH_of,cljs.core.cst$sym$ex_DASH_message,cljs.core.cst$sym$_DASH__GT_NodeIterator,cljs.core.cst$sym$_STAR_print_DASH_fn_DASH_bodies_STAR_,cljs.core.cst$sym$string_DASH_print,cljs.core.cst$sym$float,cljs.core.cst$sym$IRecord,cljs.core.cst$sym$pr_DASH_str,cljs.core.cst$sym$first_DASH_array_DASH_for_DASH_longvec,cljs.core.cst$sym$es6_DASH_set_DASH_entries_DASH_iterator,cljs.core.cst$sym$concat,cljs.core.cst$sym$_DASH_methods,cljs.core.cst$sym$js_DASH_reserved,cljs.core.cst$sym$IDerefWithTimeout,cljs.core.cst$sym$symbol,cljs.core.cst$sym$to_DASH_array_DASH_2d,cljs.core.cst$sym$Subvec,cljs.core.cst$sym$ExceptionInfo,cljs.core.cst$sym$mod,cljs.core.cst$sym$ISet,cljs.core.cst$sym$pop,cljs.core.cst$sym$IPending,cljs.core.cst$sym$_DASH_entry_DASH_key,cljs.core.cst$sym$CHAR_MAP,cljs.core.cst$sym$pop_DASH_tail,cljs.core.cst$sym$dissoc_BANG_,cljs.core.cst$sym$reductions,cljs.core.cst$sym$indexed_QMARK_,cljs.core.cst$sym$_DASH_,cljs.core.cst$sym$Cycle,cljs.core.cst$sym$_DASH_equiv,cljs.core.cst$sym$_DASH__GT_RangeIterator,cljs.core.cst$sym$_DASH__GT_ArrayNode,cljs.core.cst$sym$assoc_BANG_,cljs.core.cst$sym$hash_DASH_set,cljs.core.cst$sym$reduce_DASH_kv,cljs.core.cst$sym$reset_BANG_,cljs.core.cst$sym$name,cljs.core.cst$sym$_DASH__GT_RedNode,cljs.core.cst$sym$unchecked_DASH_array_DASH_for,cljs.core.cst$sym$Fn,cljs.core.cst$sym$ffirst,cljs.core.cst$sym$_DASH__GT_ArrayNodeIterator,cljs.core.cst$sym$sorted_DASH_set,cljs.core.cst$sym$pr_DASH_with_DASH_opts,cljs.core.cst$sym$PersistentTreeMap,cljs.core.cst$sym$strip_DASH_ns,cljs.core.cst$sym$_DASH__GT_PersistentTreeMap,cljs.core.cst$sym$array_DASH_reduce,cljs.core.cst$sym$counted_QMARK_,cljs.core.cst$sym$tagged_DASH_literal,cljs.core.cst$sym$println,cljs.core.cst$sym$assoc_DASH_in,cljs.core.cst$sym$PersistentHashSet,cljs.core.cst$sym$bit_DASH_test,cljs.core.cst$sym$_DASH__GT_Namespace,cljs.core.cst$sym$TransientHashMap,cljs.core.cst$sym$_DASH__GT_PersistentHashMap,cljs.core.cst$sym$array_DASH_extend_DASH_kv,cljs.core.cst$sym$ISwap,cljs.core.cst$sym$ChunkedCons,cljs.core.cst$sym$memoize,cljs.core.cst$sym$alter_DASH_meta_BANG_,cljs.core.cst$sym$_DASH__GT_StringBufferWriter,cljs.core.cst$sym$zero_QMARK_,cljs.core.cst$sym$tv_DASH_ensure_DASH_editable,cljs.core.cst$sym$simple_DASH_keyword_QMARK_,cljs.core.cst$sym$_DASH_indexOf,cljs.core.cst$sym$_STAR_main_DASH_cli_DASH_fn_STAR_,cljs.core.cst$sym$_DASH_assoc_DASH_n,cljs.core.cst$sym$unchecked_DASH_dec_DASH_int,cljs.core.cst$sym$hash_DASH_imap,cljs.core.cst$sym$dominates,cljs.core.cst$sym$persistent_BANG_,cljs.core.cst$sym$set_DASH_print_DASH_fn_BANG_,cljs.core.cst$sym$nnext,cljs.core.cst$sym$Box,cljs.core.cst$sym$balance_DASH_right,cljs.core.cst$sym$throw_DASH_no_DASH_method_DASH_error,cljs.core.cst$sym$demunge_DASH_str,cljs.core.cst$sym$add_DASH_watch,cljs.core.cst$sym$not_DASH_every_QMARK_,cljs.core.cst$sym$rem,cljs.core.cst$sym$ifind_QMARK_,cljs.core.cst$sym$pr_DASH_sb_DASH_with_DASH_opts,cljs.core.cst$sym$_DASH__GT_HashMapIter,cljs.core.cst$sym$BitmapIndexedNode,cljs.core.cst$sym$_DASH__GT_NodeSeq,cljs.core.cst$sym$some,cljs.core.cst$sym$INamed,cljs.core.cst$sym$_DASH__GT_Box,cljs.core.cst$sym$IReduce,cljs.core.cst$sym$neg_DASH_int_QMARK_,cljs.core.cst$sym$drop,cljs.core.cst$sym$NodeIterator,cljs.core.cst$sym$js_DASH_obj,cljs.core.cst$sym$ITransientCollection,cljs.core.cst$sym$Atom,cljs.core.cst$sym$nth,cljs.core.cst$sym$sorted_QMARK_,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$split_DASH_at,cljs.core.cst$sym$TransientHashSet,cljs.core.cst$sym$_STAR_e,cljs.core.cst$sym$array_DASH_map_DASH_extend_DASH_kv,cljs.core.cst$sym$prn_DASH_str_DASH_with_DASH_opts,cljs.core.cst$sym$not_DASH_native,cljs.core.cst$sym$random_DASH_sample,cljs.core.cst$sym$select_DASH_keys,cljs.core.cst$sym$bit_DASH_and,cljs.core.cst$sym$bounded_DASH_count,cljs.core.cst$sym$update,cljs.core.cst$sym$gensym_counter,cljs.core.cst$sym$find_DASH_macros_DASH_ns,cljs.core.cst$sym$list_STAR_,cljs.core.cst$sym$array_DASH_index_DASH_of_DASH_keyword_QMARK_,cljs.core.cst$sym$_DASH__GT_Keyword,cljs.core.cst$sym$update_DASH_in,cljs.core.cst$sym$prefer_DASH_method,cljs.core.cst$sym$hash_DASH_symbol,cljs.core.cst$sym$ensure_DASH_reduced,cljs.core.cst$sym$edit_DASH_and_DASH_set,cljs.core.cst$sym$_DASH__GT_PersistentArrayMap,cljs.core.cst$sym$instance_QMARK_,cljs.core.cst$sym$mix_DASH_collection_DASH_hash,cljs.core.cst$sym$re_DASH_find,cljs.core.cst$sym$run_BANG_,cljs.core.cst$sym$char_DASH_escapes,cljs.core.cst$sym$ES6Iterator,cljs.core.cst$sym$val,cljs.core.cst$sym$unchecked_DASH_add,cljs.core.cst$sym$transformer_DASH_iterator,cljs.core.cst$sym$not,cljs.core.cst$sym$_DASH_vreset_BANG_,cljs.core.cst$sym$fn_DASH__GT_comparator,cljs.core.cst$sym$with_DASH_meta,cljs.core.cst$sym$unreduced,cljs.core.cst$sym$record_QMARK_,cljs.core.cst$sym$type,cljs.core.cst$sym$identical_QMARK_,cljs.core.cst$sym$_DASH_namespace,cljs.core.cst$sym$unchecked_DASH_divide_DASH_int,cljs.core.cst$sym$ns_DASH_name,cljs.core.cst$sym$swap_DASH_global_DASH_hierarchy_BANG_,cljs.core.cst$sym$max_DASH_key,cljs.core.cst$sym$_DASH__GT_PersistentTreeSet,cljs.core.cst$sym$_STAR_out_STAR_,cljs.core.cst$sym$_DASH__GT_ChunkBuffer,cljs.core.cst$sym$hash_DASH_string,cljs.core.cst$sym$ValSeq,cljs.core.cst$sym$_DASH_prefers,cljs.core.cst$sym$set_DASH_validator_BANG_,cljs.core.cst$sym$ident_QMARK_,cljs.core.cst$sym$_DASH_meta,cljs.core.cst$sym$RedNode,cljs.core.cst$sym$_DASH_dispatch_DASH_fn,cljs.core.cst$sym$_DASH__GT_IndexedSeqIterator,cljs.core.cst$sym$_DASH_add_DASH_method,cljs.core.cst$sym$balance_DASH_left_DASH_del,cljs.core.cst$sym$swap_BANG_,cljs.core.cst$sym$vals,cljs.core.cst$sym$Repeat,cljs.core.cst$sym$_DASH_chunked_DASH_next,cljs.core.cst$sym$Single,cljs.core.cst$sym$unchecked_DASH_subtract,cljs.core.cst$sym$tap_GT_,cljs.core.cst$sym$remove_DASH_pair,cljs.core.cst$sym$IMap,cljs.core.cst$sym$_DASH__GT_SeqIter,cljs.core.cst$sym$sorted_DASH_set_DASH_by,cljs.core.cst$sym$PersistentVector,cljs.core.cst$sym$cloneable_QMARK_,cljs.core.cst$sym$qualified_DASH_ident_QMARK_,cljs.core.cst$sym$hash_DASH_string_STAR_,cljs.core.cst$sym$key_DASH_test,cljs.core.cst$sym$_DASH_reset,cljs.core.cst$sym$true_QMARK_,cljs.core.cst$sym$find_DASH_ns_DASH_obj_STAR_,cljs.core.cst$sym$array,cljs.core.cst$sym$print,cljs.core.cst$sym$_DASH_peek,cljs.core.cst$sym$ISeq,cljs.core.cst$sym$empty,cljs.core.cst$sym$remove_DASH_method,cljs.core.cst$sym$PersistentQueueSeq,cljs.core.cst$sym$balance_DASH_right_DASH_del,cljs.core.cst$sym$volatile_BANG_,cljs.core.cst$sym$_SLASH_,cljs.core.cst$sym$bitpos,cljs.core.cst$sym$Many,cljs.core.cst$sym$bit_DASH_or,cljs.core.cst$sym$m3_DASH_fmix,cljs.core.cst$sym$vector,cljs.core.cst$sym$hash_DASH_coll,cljs.core.cst$sym$clone_DASH_and_DASH_set,cljs.core.cst$sym$array_DASH__GT_transient_DASH_hash_DASH_map,cljs.core.cst$sym$_GT__EQ_,cljs.core.cst$sym$_DASH__GT_TransientHashSet,cljs.core.cst$sym$drop_DASH_last,cljs.core.cst$sym$_DASH__GT_ArrayIter,cljs.core.cst$sym$object_QMARK_,cljs.core.cst$sym$_DASH__GT_ArrayNodeSeq,cljs.core.cst$sym$lift_DASH_ns,cljs.core.cst$sym$tree_DASH_map_DASH_append,cljs.core.cst$sym$not_DASH_empty,cljs.core.cst$sym$distinct,cljs.core.cst$sym$partition,cljs.core.cst$sym$IMultiFn,cljs.core.cst$sym$_DASH__GT_Many,cljs.core.cst$sym$DEMUNGE_PATTERN,cljs.core.cst$sym$fix,cljs.core.cst$sym$EmptyList,cljs.core.cst$sym$HashMapIter,cljs.core.cst$sym$IAssociative,cljs.core.cst$sym$_DASH__GT_Single,cljs.core.cst$sym$bit_DASH_flip,cljs.core.cst$sym$long_DASH_array,cljs.core.cst$sym$descendants,cljs.core.cst$sym$imul,cljs.core.cst$sym$_DASH__GT_Delay,cljs.core.cst$sym$array_DASH_for,cljs.core.cst$sym$merge,cljs.core.cst$sym$ISeqable,cljs.core.cst$sym$Empty,cljs.core.cst$sym$js_DASH_mod,cljs.core.cst$sym$_DASH__GT_RangeChunk,cljs.core.cst$sym$integer_QMARK_,cljs.core.cst$sym$MetaFn,cljs.core.cst$sym$NS_CACHE,cljs.core.cst$sym$mapv,cljs.core.cst$sym$infinite_QMARK_,cljs.core.cst$sym$partition_DASH_all,cljs.core.cst$sym$partition_DASH_by,cljs.core.cst$sym$ISequential,cljs.core.cst$sym$_DASH__GT_LazySeq,cljs.core.cst$sym$equiv_DASH_map,cljs.core.cst$sym$_DASH__GT_Volatile,cljs.core.cst$sym$object_DASH_array,cljs.core.cst$sym$Keyword,cljs.core.cst$sym$derive,cljs.core.cst$sym$seq_DASH_iter,cljs.core.cst$sym$_DASH__GT_Empty,cljs.core.cst$sym$IChunkedSeq,cljs.core.cst$sym$special_DASH_symbol_QMARK_,cljs.core.cst$sym$compare_DASH_keywords,cljs.core.cst$sym$ancestors,cljs.core.cst$sym$subseq,cljs.core.cst$sym$gensym,cljs.core.cst$sym$_DASH_next,cljs.core.cst$sym$_DASH__GT_HashCollisionNode,cljs.core.cst$sym$delay_QMARK_,cljs.core.cst$sym$create_DASH_inode_DASH_seq,cljs.core.cst$sym$flatten,cljs.core.cst$sym$_DASH_dissoc,cljs.core.cst$sym$doubles,cljs.core.cst$sym$halt_DASH_when,cljs.core.cst$sym$_DASH_contains_DASH_key_QMARK_,cljs.core.cst$sym$remove_DASH_watch,cljs.core.cst$sym$ex_DASH_info,cljs.core.cst$sym$ifn_QMARK_,cljs.core.cst$sym$IAtom,cljs.core.cst$sym$_DASH__GT_PersistentQueue,cljs.core.cst$sym$nat_DASH_int_QMARK_,cljs.core.cst$sym$t_cljs$core9576,cljs.core.cst$sym$IWatchable,cljs.core.cst$sym$pv_DASH_fresh_DASH_node,cljs.core.cst$sym$subvec,cljs.core.cst$sym$_DASH_pop_BANG_,cljs.core.cst$sym$partial,cljs.core.cst$sym$chunked_DASH_seq_QMARK_,cljs.core.cst$sym$replicate,cljs.core.cst$sym$PersistentQueue,cljs.core.cst$sym$min_DASH_key,cljs.core.cst$sym$hash_DASH_iset,cljs.core.cst$sym$reduced,cljs.core.cst$sym$re_DASH_matches,cljs.core.cst$sym$pr_DASH_writer_DASH_impl,cljs.core.cst$sym$array_DASH_map,cljs.core.cst$sym$ITransientSet,cljs.core.cst$sym$ITER_SYMBOL,cljs.core.cst$sym$unchecked_DASH_byte,cljs.core.cst$sym$checked_DASH_aset,cljs.core.cst$sym$ArrayNode,cljs.core.cst$sym$_DASH__GT_ChunkedSeq,cljs.core.cst$sym$every_DASH_pred,cljs.core.cst$sym$keys,cljs.core.cst$sym$missing_DASH_protocol,cljs.core.cst$sym$load_DASH_file,cljs.core.cst$sym$PersistentArrayMap,cljs.core.cst$sym$distinct_QMARK_,cljs.core.cst$sym$pos_DASH_int_QMARK_,cljs.core.cst$sym$never_DASH_equiv,cljs.core.cst$sym$unchecked_DASH_short,cljs.core.cst$sym$_DASH__GT_Range,cljs.core.cst$sym$_DASH__GT_MapEntry,cljs.core.cst$sym$apply_DASH_to_DASH_simple,cljs.core.cst$sym$methods,cljs.core.cst$sym$odd_QMARK_,cljs.core.cst$sym$_DASH__GT_ArrayChunk,cljs.core.cst$sym$ci_DASH_reduce,cljs.core.cst$sym$_STAR_3,cljs.core.cst$sym$_DASH_get_DASH_method,cljs.core.cst$sym$_DASH__GT_Var,cljs.core.cst$sym$frequencies,cljs.core.cst$sym$reduceable_QMARK_,cljs.core.cst$sym$string_DASH_hash_DASH_cache,cljs.core.cst$sym$_DASH__GT_Iterate,cljs.core.cst$sym$rsubseq,cljs.core.cst$sym$inc,cljs.core.cst$sym$type_DASH__GT_str,cljs.core.cst$sym$obj_DASH_clone,cljs.core.cst$sym$get_DASH_method,cljs.core.cst$sym$uuid_QMARK_,cljs.core.cst$sym$vector_DASH_index_DASH_out_DASH_of_DASH_bounds,cljs.core.cst$sym$es6_DASH_entries_DASH_iterator,cljs.core.cst$sym$bit_DASH_clear,cljs.core.cst$sym$Range,cljs.core.cst$sym$filter,cljs.core.cst$sym$_DASH__GT_PersistentTreeMapSeq,cljs.core.cst$sym$create_DASH_array_DASH_node_DASH_seq,cljs.core.cst$sym$_DASH_assoc_DASH_n_BANG_,cljs.core.cst$sym$IWithMeta,cljs.core.cst$sym$next_STAR_,cljs.core.cst$sym$list,cljs.core.cst$sym$_PLUS_,cljs.core.cst$sym$IndexedSeqIterator,cljs.core.cst$sym$split_DASH_with,cljs.core.cst$sym$_DASH__GT_VectorNode,cljs.core.cst$sym$aset,cljs.core.cst$sym$int_DASH_rotate_DASH_left,cljs.core.cst$sym$keyword,cljs.core.cst$sym$_DASH__GT_Cons,cljs.core.cst$sym$_STAR_ns_STAR_,cljs.core.cst$sym$_STAR_assert_STAR_,cljs.core.cst$sym$create_DASH_tree_DASH_map_DASH_seq,cljs.core.cst$sym$ICollection,cljs.core.cst$sym$chars,cljs.core.cst$sym$str,cljs.core.cst$sym$next,cljs.core.cst$sym$ASeq,cljs.core.cst$sym$pr_DASH_seq_DASH_writer,cljs.core.cst$sym$SeqIter,cljs.core.cst$sym$IFn,cljs.core.cst$sym$regexp_QMARK_,cljs.core.cst$sym$hash_DASH_map,cljs.core.cst$sym$_STAR_exec_DASH_tap_DASH_fn_STAR_,cljs.core.cst$sym$underive,cljs.core.cst$sym$array_DASH_copy,cljs.core.cst$sym$obj_DASH_map_DASH_compare_DASH_keys,cljs.core.cst$sym$_DASH_reset_BANG_,cljs.core.cst$sym$_DASH_rest,cljs.core.cst$sym$nil_DASH_iter,cljs.core.cst$sym$pr_DASH_writer,cljs.core.cst$sym$false_QMARK_,cljs.core.cst$sym$RangedIterator,cljs.core.cst$sym$_STAR_print_DASH_readably_STAR_,cljs.core.cst$sym$ints,cljs.core.cst$sym$some_DASH_fn,cljs.core.cst$sym$demunge_DASH_pattern,cljs.core.cst$sym$maybe_DASH_enable_DASH_print_BANG_,cljs.core.cst$sym$_STAR_flush_DASH_on_DASH_newline_STAR_,cljs.core.cst$sym$to_DASH_array,cljs.core.cst$sym$build_DASH_subvec,cljs.core.cst$sym$maybe_DASH_warn,cljs.core.cst$sym$Namespace,cljs.core.cst$sym$list_QMARK_,cljs.core.cst$sym$tree_DASH_map_DASH_remove,cljs.core.cst$sym$PersistentQueueIter,cljs.core.cst$sym$HashCollisionNode,cljs.core.cst$sym$array_QMARK_,cljs.core.cst$sym$prefers_STAR_,cljs.core.cst$sym$simple_DASH_ident_QMARK_,cljs.core.cst$sym$clone,cljs.core.cst$sym$scan_DASH_array,cljs.core.cst$sym$demunge,cljs.core.cst$sym$bit_DASH_not,cljs.core.cst$sym$quote_DASH_string,cljs.core.cst$sym$byte,cljs.core.cst$sym$max,cljs.core.cst$sym$_DASH__GT_Repeat,cljs.core.cst$sym$IComparable,cljs.core.cst$sym$_EQ__EQ_,cljs.core.cst$sym$parents,cljs.core.cst$sym$count,cljs.core.cst$sym$_DASH_disjoin_BANG_,cljs.core.cst$sym$_STAR_loaded_DASH_libs_STAR_,cljs.core.cst$sym$EMPTY,cljs.core.cst$sym$_DASH__GT_TransientHashMap,cljs.core.cst$sym$array_DASH_index_DASH_of_DASH_symbol_QMARK_,cljs.core.cst$sym$ArrayChunk,cljs.core.cst$sym$sorted_DASH_map_DASH_by,cljs.core.cst$sym$apply,cljs.core.cst$sym$get_DASH_global_DASH_hierarchy,cljs.core.cst$sym$add_DASH_to_DASH_string_DASH_hash_DASH_cache,cljs.core.cst$sym$clj_DASH__GT_js,cljs.core.cst$sym$TransientArrayMap,cljs.core.cst$sym$_DASH__GT_TransientVector,cljs.core.cst$sym$IChunkedNext,cljs.core.cst$sym$interpose,cljs.core.cst$sym$TransformerIterator,cljs.core.cst$sym$_DASH__GT_BlackNode,cljs.core.cst$sym$deref,cljs.core.cst$sym$pv_DASH_aget,cljs.core.cst$sym$assoc,cljs.core.cst$sym$transient,cljs.core.cst$sym$_DASH_disjoin,cljs.core.cst$sym$chunk_DASH_cons,cljs.core.cst$sym$ArrayIter,cljs.core.cst$sym$comparator,cljs.core.cst$sym$print_DASH_prefix_DASH_map,cljs.core.cst$sym$sorted_DASH_map,cljs.core.cst$sym$drop_DASH_while,cljs.core.cst$sym$IWriter,cljs.core.cst$sym$KeySeq,cljs.core.cst$sym$realized_QMARK_,cljs.core.cst$sym$_STAR_print_DASH_fn_STAR_,cljs.core.cst$sym$compare,cljs.core.cst$sym$complement,cljs.core.cst$sym$lookup_DASH_sentinel,cljs.core.cst$sym$_DASH_assoc_BANG_,cljs.core.cst$sym$_STAR_print_DASH_dup_STAR_,cljs.core.cst$sym$string_DASH_iter,cljs.core.cst$sym$_DASH_key_DASH__GT_js,cljs.core.cst$sym$IDeref,cljs.core.cst$sym$sequence,cljs.core.cst$sym$constantly,cljs.core.cst$sym$_DASH__GT_RangedIterator,cljs.core.cst$sym$chunked_DASH_seq,cljs.core.cst$sym$ISorted,cljs.core.cst$sym$make_DASH_array,cljs.core.cst$sym$checked_DASH_aget,cljs.core.cst$sym$shorts,cljs.core.cst$sym$_STAR_unchecked_DASH_if_STAR_,cljs.core.cst$sym$_DASH__GT_RSeq,cljs.core.cst$sym$enable_DASH_console_DASH_print_BANG_,cljs.core.cst$sym$_DASH_flush,cljs.core.cst$sym$_DASH_lastIndexOf,cljs.core.cst$sym$completing,cljs.core.cst$sym$unchecked_DASH_negate_DASH_int,cljs.core.cst$sym$_DASH__GT_PersistentVector,cljs.core.cst$sym$equiv_DASH_sequential,cljs.core.cst$sym$hash_DASH_unordered_DASH_coll,cljs.core.cst$sym$repeat,cljs.core.cst$sym$unchecked_DASH_inc,cljs.core.cst$sym$nthnext,cljs.core.cst$sym$preserving_DASH_reduced,cljs.core.cst$sym$get_DASH_validator,cljs.core.cst$sym$StringIter,cljs.core.cst$sym$number_QMARK_,cljs.core.cst$sym$_DASH_conj_BANG_,cljs.core.cst$sym$_DASH__GT_PersistentArrayMapSeq,cljs.core.cst$sym$chunk_DASH_next,cljs.core.cst$sym$ArrayList,cljs.core.cst$sym$print_DASH_str,cljs.core.cst$sym$not_DASH_any_QMARK_,cljs.core.cst$sym$into_DASH_array,cljs.core.cst$sym$_DASH_hash,cljs.core.cst$sym$qualified_DASH_symbol_QMARK_,cljs.core.cst$sym$_DASH_dissoc_BANG_,cljs.core.cst$sym$_DASH__GT_Reduced,cljs.core.cst$sym$chunk_DASH_buffer,cljs.core.cst$sym$seqable_QMARK_,cljs.core.cst$sym$symbol_QMARK_,cljs.core.cst$sym$m3_DASH_hash_DASH_unencoded_DASH_chars,cljs.core.cst$sym$unchecked_DASH_char,cljs.core.cst$sym$system_DASH_time,cljs.core.cst$sym$NeverEquiv,cljs.core.cst$sym$chunkIteratorSeq,cljs.core.cst$sym$_DASH_invoke,cljs.core.cst$sym$coll_QMARK_,cljs.core.cst$sym$get_DASH_in,cljs.core.cst$sym$fnext,cljs.core.cst$sym$IList,cljs.core.cst$sym$ArrayNodeIterator,cljs.core.cst$sym$List,cljs.core.cst$sym$_DASH_val,cljs.core.cst$sym$bytes,cljs.core.cst$sym$_DASH__GT_ObjMap,cljs.core.cst$sym$compare_DASH_symbols,cljs.core.cst$sym$_DASH_seq],[cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocols,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEditableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_ISet,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null),"cljs/core.cljs",(27),(10),cljs.core.cst$kw$positional,(9143),(9143),cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$hash_DASH_map,cljs.core.cst$sym$__hash], null))),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEditableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISet,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null),"Positional factory function for cljs.core/PersistentHashSet."]),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEditableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_ISet,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH__DASH__GT_PersistentHashSet,"cljs/core.cljs",(27),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$hash_DASH_map,cljs.core.cst$sym$__hash], null)),null,cljs.core.list(null,null),(1),false,cljs.core.cst$kw$positional,(9143),cljs.core.cst$sym$cljs$core_SLASH_PersistentHashSet,(9143),(3),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$hash_DASH_map,cljs.core.cst$sym$__hash], null))),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEditableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISet,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null),"Positional factory function for cljs.core/PersistentHashSet."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(10744),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(10744),cljs.core.cst$kw$end_DASH_column,(14),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$opts], null))),cljs.core.cst$kw$doc,"Recursively transforms JavaScript arrays into ClojureScript\n  vectors, and JavaScript objects into ClojureScript maps.  With\n  option ':keywordize-keys true' will convert object fields from\n  strings to keywords.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$opts], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_js_DASH__GT_clj,"cljs/core.cljs",(14),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$opts], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),null,(1),cljs.core.list(null,null),(1),true,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$any], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [null,"null",cljs.core.cst$sym$clj,"null",cljs.core.cst$sym$any,"null",cljs.core.cst$sym$cljs$core_SLASH_MapEntry,"null"], null), null)], null)], null),(10744),(10744),(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$opts], null)),"Recursively transforms JavaScript arrays into ClojureScript\n  vectors, and JavaScript objects into ClojureScript maps.  With\n  option ':keywordize-keys true' will convert object fields from\n  strings to keywords."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2447),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(2447),cljs.core.cst$kw$end_DASH_column,(14),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$keyfn,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$keyfn,cljs.core.cst$sym$comp,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a sorted sequence of the items in coll, where the sort\n   order is determined by comparing (keyfn item).  Comp can be\n   boolean-valued comparison function, or a -/0/+ valued comparator.\n   Comp defaults to compare.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$keyfn,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$keyfn,cljs.core.cst$sym$comp,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$keyfn,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$keyfn,cljs.core.cst$sym$comp,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_sort_DASH_by,"cljs/core.cljs",(14),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$keyfn,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$keyfn,cljs.core.cst$sym$comp,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$keyfn,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$keyfn,cljs.core.cst$sym$comp,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$keyfn,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$keyfn,cljs.core.cst$sym$comp,cljs.core.cst$sym$coll], null)),null,(3),cljs.core.list(null,null),(1),false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$any], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$seq,"null",cljs.core.cst$sym$cljs$core_SLASH_IList,"null"], null), null)], null)], null),(2447),(2447),(3),true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$keyfn,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$keyfn,cljs.core.cst$sym$comp,cljs.core.cst$sym$coll], null)),"Returns a sorted sequence of the items in coll, where the sort\n   order is determined by comparing (keyfn item).  Comp can be\n   boolean-valued comparison function, or a -/0/+ valued comparator.\n   Comp defaults to compare."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$impls,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[true,"cljs/core.cljs",(35),(14),(793),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$_DASH_assoc_BANG_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$key,cljs.core.cst$sym$val], null)], null)], null)], null),(793),"Protocol for adding associativity to transient collections.",cljs.core.list("@interface")]),true,cljs.core.cst$sym$cljs$core_SLASH_ITransientAssociative,"cljs/core.cljs",(35),(1),(793),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$_DASH_assoc_BANG_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$key,cljs.core.cst$sym$val], null)], null)], null)], null),null,(793),cljs.core.cst$sym$any,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$sym$cljs$core_SLASH_TransientVector,"null",cljs.core.cst$sym$cljs$core_SLASH_TransientHashMap,"null",cljs.core.cst$sym$cljs$core_SLASH_TransientArrayMap,"null"], null), null),"Protocol for adding associativity to transient collections.",cljs.core.list("@interface")]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(3628),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(3628),cljs.core.cst$kw$end_DASH_column,(18),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_chunk_DASH_first,"cljs/core.cljs",(18),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null)),null,cljs.core.list(null,null),(1),false,(3628),cljs.core.cst$sym$any,(3628),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(10081),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(10081),cljs.core.cst$kw$end_DASH_column,(18),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$opts,cljs.core.cst$sym$obj], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_print_DASH_meta_QMARK_,"cljs/core.cljs",(18),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$opts,cljs.core.cst$sym$obj], null)),null,cljs.core.list(null,null),(1),false,(10081),cljs.core.cst$sym$boolean,(10081),(2),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$opts,cljs.core.cst$sym$obj], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$tag,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(929),cljs.core.cst$kw$column,(15),cljs.core.cst$kw$end_DASH_line,(929),cljs.core.cst$kw$end_DASH_column,(26),cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$in], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_m3_DASH_hash_DASH_int,"cljs/core.cljs",(26),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$in], null)),null,cljs.core.list(null,null),(1),false,(929),cljs.core.cst$sym$number,(929),(1),cljs.core.cst$sym$number,true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$in], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(877),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(877),cljs.core.cst$kw$end_DASH_column,(14),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj], null))),cljs.core.cst$kw$doc,"Support so that collections can implement toString without\n   loading all the printing machinery."], null),cljs.core.cst$sym$cljs$core_SLASH_pr_DASH_str_STAR_,"cljs/core.cljs",(14),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj], null)),null,cljs.core.list(null,null),(1),false,(877),cljs.core.cst$sym$string,(877),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj], null))),"Support so that collections can implement toString without\n   loading all the printing machinery."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(10679),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(10679),cljs.core.cst$kw$end_DASH_column,(15),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xform_STAR_,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a reducible/iterable application of the transducers\n  to the items in coll. Transducers are applied in order as if\n  combined with comp. Note that these applications will be\n  performed every time reduce/iterator is called.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(0),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$xforms)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$xforms], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_eduction,"cljs/core.cljs",(15),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(0),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$xforms)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$xforms], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$xforms)], null),null,(0),cljs.core.list(null),(1),true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core_SLASH_Eduction], null)], null),(10679),cljs.core.cst$sym$any,(10679),(0),true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$xforms], null)),"Returns a reducible/iterable application of the transducers\n  to the items in coll. Transducers are applied in order as if\n  combined with comp. Note that these applications will be\n  performed every time reduce/iterator is called."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(5184),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(5184),cljs.core.cst$kw$end_DASH_column,(15),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$branch_QMARK_,cljs.core.cst$sym$children,cljs.core.cst$sym$root], null))),cljs.core.cst$kw$doc,"Returns a lazy sequence of the nodes in a tree, via a depth-first walk.\n  branch? must be a fn of one arg that returns true if passed a node\n  that can have children (but may not).  children must be a fn of one\n  arg that returns a sequence of the children. Will only be called on\n  nodes for which branch? returns true. Root is the root node of the\n  tree."], null),cljs.core.cst$sym$cljs$core_SLASH_tree_DASH_seq,"cljs/core.cljs",(15),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$branch_QMARK_,cljs.core.cst$sym$children,cljs.core.cst$sym$root], null)),null,cljs.core.list(null,null),(1),false,(5184),cljs.core.cst$sym$cljs$core_SLASH_LazySeq,(5184),(3),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$branch_QMARK_,cljs.core.cst$sym$children,cljs.core.cst$sym$root], null))),"Returns a lazy sequence of the nodes in a tree, via a depth-first walk.\n  branch? must be a fn of one arg that returns true if passed a node\n  that can have children (but may not).  children must be a fn of one\n  arg that returns a sequence of the children. Will only be called on\n  nodes for which branch? returns true. Root is the root node of the\n  tree."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2774),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(2774),cljs.core.cst$kw$end_DASH_column,(30),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_remainder_DASH_int,"cljs/core.cljs",(30),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null)),null,cljs.core.list(null,null),(1),false,(2774),cljs.core.cst$sym$number,(2774),(2),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(11276),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(11276),cljs.core.cst$kw$end_DASH_column,(11),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_uuid,"cljs/core.cljs",(11),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null)),null,cljs.core.list(null,null),(1),false,(11276),cljs.core.cst$sym$cljs$core_SLASH_UUID,(11276),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$tag,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(1205),cljs.core.cst$kw$column,(12),cljs.core.cst$kw$end_DASH_line,(1205),cljs.core.cst$kw$end_DASH_column,(15),cljs.core.cst$kw$tag,cljs.core.cst$sym$seq,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a seq on the collection. If the collection is\n  empty, returns nil.  (seq nil) returns nil. seq also works on\n  Strings."], null),cljs.core.cst$sym$cljs$core_SLASH_seq,"cljs/core.cljs",(15),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),null,cljs.core.list(null,null),(1),false,(1205),cljs.core.cst$sym$seq,(1205),(1),cljs.core.cst$sym$seq,true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),"Returns a seq on the collection. If the collection is\n  empty, returns nil.  (seq nil) returns nil. seq also works on\n  Strings."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$num_DASH_fields,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$type,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$record,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag],[(1),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_IVolatile,"null",cljs.core.cst$sym$cljs$core_SLASH_IDeref,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH_Volatile,"cljs/core.cljs",(18),true,(10),(4557),false,(4557),cljs.core.cst$sym$function,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_IDeref,"null"], null), null)]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2504),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(2504),cljs.core.cst$kw$end_DASH_column,(13),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$val,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"f should be a function of 2 arguments. If val is not supplied,\n  returns the result of applying f to the first 2 items in coll, then\n  applying f to that result and the 3rd item, etc. If coll contains no\n  items, f must accept no arguments as well, and reduce returns the\n  result of calling f with no arguments.  If coll has only 1 item, it\n  is returned and f is not called.  If val is supplied, returns the\n  result of applying f to val and the first item in coll, then\n  applying f to that result and the 2nd item, etc. If coll contains no\n  items, returns val and f is not called.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$val,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$val,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_reduce,"cljs/core.cljs",(13),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$val,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$val,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$val,cljs.core.cst$sym$coll], null)),null,(3),cljs.core.list(null,null),(1),false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [null,"null",cljs.core.cst$sym$any,"null"], null), null)], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [null,"null",cljs.core.cst$sym$any,"null"], null), null)], null)], null),(2504),(2504),(3),true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$val,cljs.core.cst$sym$coll], null)),"f should be a function of 2 arguments. If val is not supplied,\n  returns the result of applying f to the first 2 items in coll, then\n  applying f to that result and the 3rd item, etc. If coll contains no\n  items, f must accept no arguments as well, and reduce returns the\n  result of calling f with no arguments.  If coll has only 1 item, it\n  is returned and f is not called.  If val is supplied, returns the\n  result of applying f to val and the first item in coll, then\n  applying f to that result and the 2nd item, etc. If coll contains no\n  items, returns val and f is not called."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$impls,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[true,"cljs/core.cljs",(19),(14),(11248),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,cljs.core.PersistentArrayMap.EMPTY], null),(11248),"A marker protocol for UUIDs",cljs.core.list("@interface")]),true,cljs.core.cst$sym$cljs$core_SLASH_IUUID,"cljs/core.cljs",(19),(1),(11248),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,cljs.core.PersistentArrayMap.EMPTY], null),null,(11248),cljs.core.cst$sym$any,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_UUID,"null"], null), null),"A marker protocol for UUIDs",cljs.core.list("@interface")]),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_INIT,cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(4030),cljs.core.cst$kw$column,(1),cljs.core.cst$kw$end_DASH_line,(4030),cljs.core.cst$kw$end_DASH_column,(10),cljs.core.cst$kw$meta,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(4030),cljs.core.cst$kw$column,(6),cljs.core.cst$kw$end_DASH_line,(4030),cljs.core.cst$kw$end_DASH_column,(10)], null),cljs.core.cst$kw$tag,cljs.core.cst$sym$object], null),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(11641),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(11641),cljs.core.cst$kw$end_DASH_column,(14),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ns], null))),cljs.core.cst$kw$doc,"Returns the namespace named by the symbol or nil if it doesn't exist.\n  Bootstrap only."], null),cljs.core.cst$sym$cljs$core_SLASH_find_DASH_ns,"cljs/core.cljs",(14),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ns], null)),null,cljs.core.list(null,null),(1),false,(11641),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$sym$cljs$core_SLASH_Namespace,"null",cljs.core.cst$sym$any,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null),(11641),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ns], null))),"Returns the namespace named by the symbol or nil if it doesn't exist.\n  Bootstrap only."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2336),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(2336),cljs.core.cst$kw$end_DASH_column,(16),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$v], null))),cljs.core.cst$kw$doc,"Returns true if key is present in the given collection, otherwise\n  returns false.  Note that for numerically indexed collections like\n  vectors and arrays, this tests if the numeric key is within the\n  range of indexes. 'contains?' operates constant or logarithmic time;\n  it will not perform a linear search for a value.  See also 'some'."], null),cljs.core.cst$sym$cljs$core_SLASH_contains_QMARK_,"cljs/core.cljs",(16),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$v], null)),null,cljs.core.list(null,null),(1),false,(2336),cljs.core.cst$sym$boolean,(2336),(2),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$v], null))),"Returns true if key is present in the given collection, otherwise\n  returns false.  Note that for numerically indexed collections like\n  vectors and arrays, this tests if the numeric key is within the\n  range of indexes. 'contains?' operates constant or logarithmic time;\n  it will not perform a linear search for a value.  See also 'some'."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(4217),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(4217),cljs.core.cst$kw$end_DASH_column,(13),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns true if (pred x) is logical true for every x in coll, else\n  false."], null),cljs.core.cst$sym$cljs$core_SLASH_every_QMARK_,"cljs/core.cljs",(13),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$coll], null)),null,cljs.core.list(null,null),(1),false,(4217),cljs.core.cst$sym$boolean,(4217),(2),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$coll], null))),"Returns true if (pred x) is logical true for every x in coll, else\n  false."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocols,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null"], null), null),"cljs/core.cljs",(24),(10),cljs.core.cst$kw$positional,(1296),(1296),cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$value,cljs.core.cst$sym$iter,cljs.core.cst$sym$_rest], null))),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null"], null), null),"Positional factory function for cljs.core/ES6IteratorSeq."]),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH__DASH__GT_ES6IteratorSeq,"cljs/core.cljs",(24),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$value,cljs.core.cst$sym$iter,cljs.core.cst$sym$_rest], null)),null,cljs.core.list(null,null),(1),false,cljs.core.cst$kw$positional,(1296),cljs.core.cst$sym$cljs$core_SLASH_ES6IteratorSeq,(1296),(3),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$value,cljs.core.cst$sym$iter,cljs.core.cst$sym$_rest], null))),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null"], null), null),"Positional factory function for cljs.core/ES6IteratorSeq."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$num_DASH_fields,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$type,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$record,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag],[(3),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_Fn,"null",cljs.core.cst$sym$cljs$core_SLASH_IDeref,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH_Var,"cljs/core.cljs",(13),true,(10),(1118),false,(1118),cljs.core.cst$sym$function,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IDeref,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null)]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(4579),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(4579),cljs.core.cst$kw$end_DASH_column,(19),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a lazy sequence of the non-nil results of (f index item). Note,\n  this means false return values will be included.  f must be free of\n  side-effects.  Returns a stateful transducer when no collection is\n  provided.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_keep_DASH_indexed,"cljs/core.cljs",(19),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null)),null,(2),cljs.core.list(null,null),(1),false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$function], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false], null)], null),(4579),(4579),(2),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null)),"Returns a lazy sequence of the non-nil results of (f index item). Note,\n  this means false return values will be included.  f must be free of\n  side-effects.  Returns a stateful transducer when no collection is\n  provided."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocols,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),"cljs/core.cljs",(28),(10),cljs.core.cst$kw$positional,(6188),(6188),cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$front,cljs.core.cst$sym$rear,cljs.core.cst$sym$__hash], null))),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 10, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),"Positional factory function for cljs.core/PersistentQueueSeq."]),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH__DASH__GT_PersistentQueueSeq,"cljs/core.cljs",(28),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$front,cljs.core.cst$sym$rear,cljs.core.cst$sym$__hash], null)),null,cljs.core.list(null,null),(1),false,cljs.core.cst$kw$positional,(6188),cljs.core.cst$sym$cljs$core_SLASH_PersistentQueueSeq,(6188),(4),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$front,cljs.core.cst$sym$rear,cljs.core.cst$sym$__hash], null))),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 10, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),"Positional factory function for cljs.core/PersistentQueueSeq."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2970),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(2970),cljs.core.cst$kw$end_DASH_column,(11),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s,cljs.core.cst$sym$start], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s,cljs.core.cst$sym$start,cljs.core.cst$sym$end], null))),cljs.core.cst$kw$doc,"Returns the substring of s beginning at start inclusive, and ending\n  at end (defaults to length of string), exclusive.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s,cljs.core.cst$sym$start], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s,cljs.core.cst$sym$start,cljs.core.cst$sym$end], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s,cljs.core.cst$sym$start], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s,cljs.core.cst$sym$start,cljs.core.cst$sym$end], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_subs,"cljs/core.cljs",(11),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s,cljs.core.cst$sym$start], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s,cljs.core.cst$sym$start,cljs.core.cst$sym$end], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s,cljs.core.cst$sym$start], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s,cljs.core.cst$sym$start,cljs.core.cst$sym$end], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s,cljs.core.cst$sym$start], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s,cljs.core.cst$sym$start,cljs.core.cst$sym$end], null)),null,(3),cljs.core.list(null,null),(1),false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$any], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$any], null)], null),(2970),(2970),(3),true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s,cljs.core.cst$sym$start], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s,cljs.core.cst$sym$start,cljs.core.cst$sym$end], null)),"Returns the substring of s beginning at start inclusive, and ending\n  at end (defaults to length of string), exclusive."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$impls,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[true,"cljs/core.cljs",(19),(14),(634),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$_DASH_find,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k], null)], null)], null)], null),(634),"Protocol for implementing entry finding in collections.",cljs.core.list("@interface")]),true,cljs.core.cst$sym$cljs$core_SLASH_IFind,"cljs/core.cljs",(19),(1),(634),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$_DASH_find,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k], null)], null)], null)], null),null,(634),cljs.core.cst$sym$any,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, [cljs.core.cst$sym$cljs$core_SLASH_PersistentHashMap,"null",cljs.core.cst$sym$cljs$core_SLASH_ObjMap,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentArrayMap,"null",cljs.core.cst$sym$cljs$core_SLASH_BlackNode,"null",cljs.core.cst$sym$cljs$core_SLASH_MapEntry,"null",cljs.core.cst$sym$cljs$core_SLASH_Subvec,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentVector,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentTreeMap,"null",cljs.core.cst$sym$cljs$core_SLASH_RedNode,"null"], null), null),"Protocol for implementing entry finding in collections.",cljs.core.list("@interface")]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(9411),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(9411),cljs.core.cst$kw$end_DASH_column,(10),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a set of the distinct elements of coll."], null),cljs.core.cst$sym$cljs$core_SLASH_set,"cljs/core.cljs",(10),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),null,cljs.core.list(null,null),(1),false,(9411),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$sym$clj,"null",cljs.core.cst$sym$any,"null",cljs.core.cst$sym$cljs$core_SLASH_ISet,"null",cljs.core.cst$sym$cljs$core_SLASH_MetaFn,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null),(9411),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),"Returns a set of the distinct elements of coll."]),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_MODULE_URIS,cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(39),cljs.core.cst$kw$column,(1),cljs.core.cst$kw$end_DASH_line,(39),cljs.core.cst$kw$end_DASH_column,(17),cljs.core.cst$kw$meta,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(39),cljs.core.cst$kw$column,(6),cljs.core.cst$kw$end_DASH_line,(39),cljs.core.cst$kw$end_DASH_column,(17)], null),cljs.core.cst$kw$tag,cljs.core.cst$sym$clj_DASH_nil], null),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$private,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$private,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[true,"cljs/core.cljs",(32),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(4),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(4),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xs,cljs.core.cst$sym$ys], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xs,cljs.core.cst$sym$ys,cljs.core.cst$sym$len,cljs.core.cst$sym$n], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xs,cljs.core.cst$sym$ys], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xs,cljs.core.cst$sym$ys,cljs.core.cst$sym$len,cljs.core.cst$sym$n], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),(17),(2401),(2401),cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xs,cljs.core.cst$sym$ys], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xs,cljs.core.cst$sym$ys,cljs.core.cst$sym$len,cljs.core.cst$sym$n], null))),"Compare indexed collection."]),true,cljs.core.cst$sym$cljs$core_SLASH_compare_DASH_indexed,"cljs/core.cljs",(32),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(4),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(4),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xs,cljs.core.cst$sym$ys], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xs,cljs.core.cst$sym$ys,cljs.core.cst$sym$len,cljs.core.cst$sym$n], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xs,cljs.core.cst$sym$ys], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xs,cljs.core.cst$sym$ys,cljs.core.cst$sym$len,cljs.core.cst$sym$n], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xs,cljs.core.cst$sym$ys], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xs,cljs.core.cst$sym$ys,cljs.core.cst$sym$len,cljs.core.cst$sym$n], null)),null,(4),cljs.core.list(null,null),(1),false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$any,"null",cljs.core.cst$sym$number,"null"], null), null)], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(4),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$number], null)], null),(2401),(2401),(4),true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xs,cljs.core.cst$sym$ys], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xs,cljs.core.cst$sym$ys,cljs.core.cst$sym$len,cljs.core.cst$sym$n], null)),"Compare indexed collection."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(4797),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(4797),cljs.core.cst$kw$end_DASH_column,(16),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a seq of the last n items in coll.  Depending on the type\n  of coll may be no better than linear time.  For vectors, see also subvec."], null),cljs.core.cst$sym$cljs$core_SLASH_take_DASH_last,"cljs/core.cljs",(16),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null)),null,cljs.core.list(null,null),(1),false,(4797),cljs.core.cst$sym$seq,(4797),(2),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null))),"Returns a seq of the last n items in coll.  Depending on the type\n  of coll may be no better than linear time.  For vectors, see also subvec."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$num_DASH_fields,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$type,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$record,cljs.core.cst$kw$declared,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag],[new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(1188),cljs.core.cst$kw$column,(29),cljs.core.cst$kw$end_DASH_line,(1188),cljs.core.cst$kw$end_DASH_column,(39),cljs.core.cst$kw$declared,true], null),(3),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [cljs.core.cst$sym$cljs$core_SLASH_IIndexed,"null",cljs.core.cst$sym$cljs$core_SLASH_IReversible,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ASeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH_IndexedSeq,"cljs/core.cljs",(20),true,(10),(1571),false,true,(1571),cljs.core.cst$sym$function,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 17, [cljs.core.cst$sym$cljs$core_SLASH_IIndexed,"null",cljs.core.cst$sym$cljs$core_SLASH_IReversible,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ASeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null)]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2885),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(2885),cljs.core.cst$kw$end_DASH_column,(14),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null))),cljs.core.cst$kw$doc,"Set bit at index n"], null),cljs.core.cst$sym$cljs$core_SLASH_bit_DASH_set,"cljs/core.cljs",(14),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null)),null,cljs.core.list(null,null),(1),false,(2885),cljs.core.cst$sym$number,(2885),(2),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null))),"Set bit at index n"]),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_string_DASH_hash_DASH_cache_DASH_count,cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(956),cljs.core.cst$kw$column,(1),cljs.core.cst$kw$end_DASH_line,(956),cljs.core.cst$kw$end_DASH_column,(29),cljs.core.cst$kw$meta,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(956),cljs.core.cst$kw$column,(6),cljs.core.cst$kw$end_DASH_line,(956),cljs.core.cst$kw$end_DASH_column,(29)], null),cljs.core.cst$kw$tag,cljs.core.cst$sym$number], null),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(3384),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(3384),cljs.core.cst$kw$end_DASH_column,(25),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Return true if x is a keyword with a namespace"], null),cljs.core.cst$sym$cljs$core_SLASH_qualified_DASH_keyword_QMARK_,"cljs/core.cljs",(25),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),null,cljs.core.list(null,null),(1),false,(3384),cljs.core.cst$sym$boolean,(3384),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),"Return true if x is a keyword with a namespace"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocols,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IPrintWithWriter,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),"cljs/core.cljs",(18),(10),cljs.core.cst$kw$positional,(10649),(10649),cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xform,cljs.core.cst$sym$coll], null))),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IPrintWithWriter,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),"Positional factory function for cljs.core/Eduction."]),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IPrintWithWriter,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH__DASH__GT_Eduction,"cljs/core.cljs",(18),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xform,cljs.core.cst$sym$coll], null)),null,cljs.core.list(null,null),(1),false,cljs.core.cst$kw$positional,(10649),cljs.core.cst$sym$cljs$core_SLASH_Eduction,(10649),(2),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xform,cljs.core.cst$sym$coll], null))),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IPrintWithWriter,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),"Positional factory function for cljs.core/Eduction."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$private,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(8619),cljs.core.cst$kw$column,(8),cljs.core.cst$kw$end_DASH_line,(8619),cljs.core.cst$kw$end_DASH_column,(20),cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$comp,cljs.core.cst$sym$tree,cljs.core.cst$sym$k,cljs.core.cst$sym$v,cljs.core.cst$sym$found], null)))], null),true,cljs.core.cst$sym$cljs$core_SLASH_tree_DASH_map_DASH_add,"cljs/core.cljs",(20),cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$comp,cljs.core.cst$sym$tree,cljs.core.cst$sym$k,cljs.core.cst$sym$v,cljs.core.cst$sym$found], null)),null,cljs.core.list(null,null),(1),false,(8619),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$sym$any,"null",cljs.core.cst$sym$clj_DASH_nil,"null",cljs.core.cst$sym$cljs$core_SLASH_RedNode,"null"], null), null),(8619),(5),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$comp,cljs.core.cst$sym$tree,cljs.core.cst$sym$k,cljs.core.cst$sym$v,cljs.core.cst$sym$found], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocols,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),"cljs/core.cljs",(31),(10),cljs.core.cst$kw$positional,(6540),(6540),cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null))),null,"Positional factory function for cljs.core/ES6SetEntriesIterator."]),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH__DASH__GT_ES6SetEntriesIterator,"cljs/core.cljs",(31),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null)),null,cljs.core.list(null,null),(1),false,cljs.core.cst$kw$positional,(6540),cljs.core.cst$sym$cljs$core_SLASH_ES6SetEntriesIterator,(6540),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null))),null,"Positional factory function for cljs.core/ES6SetEntriesIterator."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$tag,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"cljs/core.cljs",(19),(9),(686),(686),cljs.core.cst$sym$clj,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$meta], null))),"Returns a new object with value of o and metadata meta added to it."]),cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,cljs.core.cst$sym$cljs$core_SLASH__DASH_with_DASH_meta,"cljs/core.cljs",(19),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$meta], null)),null,cljs.core.list(null,null),(1),false,(684),cljs.core.cst$sym$clj,(686),(2),cljs.core.cst$sym$clj,true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$meta], null))),"Returns a new object with value of o and metadata meta added to it."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$private,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(10956),cljs.core.cst$kw$column,(8),cljs.core.cst$kw$end_DASH_line,(10956),cljs.core.cst$kw$end_DASH_column,(19),cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$method_DASH_cache,cljs.core.cst$sym$method_DASH_table,cljs.core.cst$sym$cached_DASH_hierarchy,cljs.core.cst$sym$hierarchy], null)))], null),true,cljs.core.cst$sym$cljs$core_SLASH_reset_DASH_cache,"cljs/core.cljs",(19),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$method_DASH_cache,cljs.core.cst$sym$method_DASH_table,cljs.core.cst$sym$cached_DASH_hierarchy,cljs.core.cst$sym$hierarchy], null)),null,cljs.core.list(null,null),(1),false,(10956),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [null,"null",cljs.core.cst$sym$any,"null"], null), null),(10956),(4),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$method_DASH_cache,cljs.core.cst$sym$method_DASH_table,cljs.core.cst$sym$cached_DASH_hierarchy,cljs.core.cst$sym$hierarchy], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocols,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),"cljs/core.cljs",(36),(10),cljs.core.cst$kw$positional,(6802),(6802),cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$i,cljs.core.cst$sym$cnt], null))),null,"Positional factory function for cljs.core/PersistentArrayMapIterator."]),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH__DASH__GT_PersistentArrayMapIterator,"cljs/core.cljs",(36),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$i,cljs.core.cst$sym$cnt], null)),null,cljs.core.list(null,null),(1),false,cljs.core.cst$kw$positional,(6802),cljs.core.cst$sym$cljs$core_SLASH_PersistentArrayMapIterator,(6802),(3),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$i,cljs.core.cst$sym$cnt], null))),null,"Positional factory function for cljs.core/PersistentArrayMapIterator."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$num_DASH_fields,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$type,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$record,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag],[(3),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH_PersistentArrayMapIterator,"cljs/core.cljs",(36),true,(10),(6802),false,(6802),cljs.core.cst$sym$function,null]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(9491),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(9491),cljs.core.cst$kw$end_DASH_column,(14),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null))),cljs.core.cst$kw$doc,"Return a seq of all but the last item in coll, in linear time"], null),cljs.core.cst$sym$cljs$core_SLASH_butlast,"cljs/core.cljs",(14),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null)),null,cljs.core.list(null,null),(1),false,(9491),cljs.core.cst$sym$seq,(9491),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null))),"Return a seq of all but the last item in coll, in linear time"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$private,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(5357),cljs.core.cst$kw$column,(8),cljs.core.cst$kw$end_DASH_line,(5357),cljs.core.cst$kw$end_DASH_column,(16),cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pv], null)))], null),true,cljs.core.cst$sym$cljs$core_SLASH_tail_DASH_off,"cljs/core.cljs",(16),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pv], null)),null,cljs.core.list(null,null),(1),false,(5357),cljs.core.cst$sym$number,(5357),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pv], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$tag,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],["cljs/core.cljs",(37),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null),(15),(2784),(2784),cljs.core.cst$sym$number,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null))),"If no ys are supplied, returns the negation of x, else subtracts\n  the ys from x and returns the result."]),cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_subtract_DASH_int,"cljs/core.cljs",(37),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)),null,(2),cljs.core.list(null,null,null),(1),true,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$number], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$number], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [null,"null",cljs.core.cst$sym$any,"null"], null), null)], null)], null),(2784),cljs.core.cst$sym$number,(2784),(2),cljs.core.cst$sym$number,true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),"If no ys are supplied, returns the negation of x, else subtracts\n  the ys from x and returns the result."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(867),cljs.core.cst$kw$column,(4),cljs.core.cst$kw$end_DASH_line,(867),cljs.core.cst$kw$end_DASH_column,(13),cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IIterable,cljs.core.cst$kw$doc,"Returns an iterator for coll.",cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_IIterable,cljs.core.cst$sym$cljs$core_SLASH__DASH_iterator,"cljs/core.cljs",(13),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),null,cljs.core.list(null,null),(1),false,(865),cljs.core.cst$sym$any,(867),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),"Returns an iterator for coll."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$dynamic,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$doc],[new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(138),cljs.core.cst$kw$column,(3),cljs.core.cst$kw$end_DASH_line,(138),cljs.core.cst$kw$end_DASH_column,(25),cljs.core.cst$kw$dynamic,true,cljs.core.cst$kw$doc,"*print-namespace-maps* controls whether the printer will print\n  namespace map literal syntax.\n\n  Defaults to false, but the REPL binds it to true."], null),cljs.core.cst$sym$cljs$core_SLASH__STAR_print_DASH_namespace_DASH_maps_STAR_,"cljs/core.cljs",(25),(1),true,(132),(138),cljs.core.cst$sym$boolean,"*print-namespace-maps* controls whether the printer will print\n  namespace map literal syntax.\n\n  Defaults to false, but the REPL binds it to true."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(9807),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(9807),cljs.core.cst$kw$end_DASH_column,(15),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a lazy seq of every nth item in coll.  Returns a stateful\n  transducer when no collection is provided.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_take_DASH_nth,"cljs/core.cljs",(15),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null)),null,(2),cljs.core.list(null,null),(1),false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$function], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core_SLASH_LazySeq], null)], null),(9807),(9807),(2),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null)),"Returns a lazy seq of every nth item in coll.  Returns a stateful\n  transducer when no collection is provided."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(1228),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(1228),cljs.core.cst$kw$end_DASH_column,(12),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns the first item in the collection. Calls seq on its\n  argument. If coll is nil, returns nil."], null),cljs.core.cst$sym$cljs$core_SLASH_first,"cljs/core.cljs",(12),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),null,cljs.core.list(null,null),(1),false,(1228),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$any,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null),(1228),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),"Returns the first item in the collection. Calls seq on its\n  argument. If coll is nil, returns nil."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(280),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(280),cljs.core.cst$kw$end_DASH_column,(24),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Internal - do not use!"], null),cljs.core.cst$sym$cljs$core_SLASH_native_DASH_satisfies_QMARK_,"cljs/core.cljs",(24),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$x], null)),null,cljs.core.list(null,null),(1),false,(280),cljs.core.cst$sym$boolean,(280),(2),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$x], null))),"Internal - do not use!"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2230),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(2230),cljs.core.cst$kw$end_DASH_column,(11),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null))),cljs.core.cst$kw$doc,"Return true if s satisfies ISeq"], null),cljs.core.cst$sym$cljs$core_SLASH_seq_QMARK_,"cljs/core.cljs",(11),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null)),null,cljs.core.list(null,null),(1),false,(2230),cljs.core.cst$sym$boolean,(2230),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null))),"Return true if s satisfies ISeq"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$private,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$jsdoc],[new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(10846),cljs.core.cst$kw$column,(3),cljs.core.cst$kw$end_DASH_line,(10846),cljs.core.cst$kw$end_DASH_column,(20),cljs.core.cst$kw$private,true,cljs.core.cst$kw$jsdoc,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["@type {*}"], null)], null),true,cljs.core.cst$sym$cljs$core_SLASH__DASH_global_DASH_hierarchy,"cljs/core.cljs",(20),(1),(10843),(10846),cljs.core.cst$sym$clj_DASH_nil,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["@type {*}"], null)]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$num_DASH_fields,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$type,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$record,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag],[(2),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IPrintWithWriter,"null",cljs.core.cst$sym$cljs$core_SLASH_IComparable,"null",cljs.core.cst$sym$cljs$core_SLASH_IUUID,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH_UUID,"cljs/core.cljs",(14),true,(10),(11250),false,(11250),cljs.core.cst$sym$function,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IPrintWithWriter,"null",cljs.core.cst$sym$cljs$core_SLASH_IComparable,"null"], null), null)]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$tag,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[cljs.core.cst$sym$cljs$core_SLASH_ISorted,"cljs/core.cljs",(25),(9),(738),(738),cljs.core.cst$sym$clj,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k,cljs.core.cst$sym$ascending_QMARK_], null))),"Returns a sorted seq from coll in either ascending or descending order.\n     If ascending is true, the result should contain all items which are > or >=\n     than k. If ascending is false, the result should contain all items which\n     are < or <= than k, e.g.\n     (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 true) => (3 4 5)\n     (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 false) => (3 2 1)"]),cljs.core.cst$sym$cljs$core_SLASH_ISorted,cljs.core.cst$sym$cljs$core_SLASH__DASH_sorted_DASH_seq_DASH_from,"cljs/core.cljs",(25),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k,cljs.core.cst$sym$ascending_QMARK_], null)),null,cljs.core.list(null,null),(1),false,(733),cljs.core.cst$sym$clj,(738),(3),cljs.core.cst$sym$clj,true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k,cljs.core.cst$sym$ascending_QMARK_], null))),"Returns a sorted seq from coll in either ascending or descending order.\n     If ascending is true, the result should contain all items which are > or >=\n     than k. If ascending is false, the result should contain all items which\n     are < or <= than k, e.g.\n     (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 true) => (3 4 5)\n     (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 false) => (3 2 1)"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(10266),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(10266),cljs.core.cst$kw$end_DASH_column,(18),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$objs], null))),cljs.core.cst$kw$doc,"println to a string, returning it",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(0),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$objs)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$objs], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_println_DASH_str,"cljs/core.cljs",(18),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(0),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$objs)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$objs], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$objs)], null),null,(0),cljs.core.list(null),(1),true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$tag,cljs.core.cst$sym$string], null)], null),(10266),cljs.core.cst$sym$any,(10266),(0),true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$objs], null)),"println to a string, returning it"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(1387),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(1387),cljs.core.cst$kw$end_DASH_column,(14),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$inst], null))),cljs.core.cst$kw$doc,"Return the number of milliseconds since January 1, 1970, 00:00:00 GMT"], null),cljs.core.cst$sym$cljs$core_SLASH_inst_DASH_ms,"cljs/core.cljs",(14),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$inst], null)),null,cljs.core.list(null,null),(1),false,(1387),cljs.core.cst$sym$any,(1387),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$inst], null))),"Return the number of milliseconds since January 1, 1970, 00:00:00 GMT"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$private,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(1835),cljs.core.cst$kw$column,(8),cljs.core.cst$kw$end_DASH_line,(1835),cljs.core.cst$kw$end_DASH_column,(28),cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n,cljs.core.cst$sym$not_DASH_found], null))),cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n,cljs.core.cst$sym$not_DASH_found], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n,cljs.core.cst$sym$not_DASH_found], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null),true,cljs.core.cst$sym$cljs$core_SLASH_linear_DASH_traversal_DASH_nth,"cljs/core.cljs",(28),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n,cljs.core.cst$sym$not_DASH_found], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n,cljs.core.cst$sym$not_DASH_found], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n,cljs.core.cst$sym$not_DASH_found], null)),null,(3),cljs.core.list(null,null),(1),false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$any,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null)], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [null,"null",cljs.core.cst$sym$any,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null)], null)], null),(1835),(1835),(3),true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n,cljs.core.cst$sym$not_DASH_found], null))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$added,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(5080),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(5080),cljs.core.cst$kw$end_DASH_column,(14),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns a lazy sequence of x, (f x), (f (f x)) etc. f must be free of side-effects",cljs.core.cst$kw$added,"1.0"], null),"1.0",cljs.core.cst$sym$cljs$core_SLASH_iterate,"cljs/core.cljs",(14),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$x], null)),null,cljs.core.list(null,null),(1),false,(5080),cljs.core.cst$sym$cljs$core_SLASH_Iterate,(5080),(2),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$x], null))),"Returns a lazy sequence of x, (f x), (f (f x)) etc. f must be free of side-effects"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$private,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(480),cljs.core.cst$kw$column,(8),cljs.core.cst$kw$end_DASH_line,(480),cljs.core.cst$kw$end_DASH_column,(21),cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$idxs], null))),cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$idxs], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null),true,cljs.core.cst$sym$cljs$core_SLASH_checked_DASH_aget_SINGLEQUOTE_,"cljs/core.cljs",(21),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$idxs], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx], null)),null,(2),cljs.core.list(null,null),(1),true,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$any], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$tag,cljs.core.cst$sym$any], null)], null),(480),(480),(2),true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$idxs], null))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(577),cljs.core.cst$kw$column,(4),cljs.core.cst$kw$end_DASH_line,(577),cljs.core.cst$kw$end_DASH_column,(10),cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,cljs.core.cst$kw$doc,"Returns an empty collection of the same category as coll. Used\n     by cljs.core/empty.",cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,cljs.core.cst$sym$cljs$core_SLASH__DASH_empty,"cljs/core.cljs",(10),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),null,cljs.core.list(null,null),(1),false,(575),cljs.core.cst$sym$any,(577),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),"Returns an empty collection of the same category as coll. Used\n     by cljs.core/empty."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(10221),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(10221),cljs.core.cst$kw$end_DASH_column,(14),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$opts], null))),cljs.core.cst$kw$doc,"Prints a newline using *print-fn*",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$opts], null)),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$opts], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_newline,"cljs/core.cljs",(14),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$opts], null)),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$opts], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$opts], null)),null,(1),cljs.core.list(null,null),(1),false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$any], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$clj_DASH_nil], null)], null),(10221),(10221),(1),true,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$opts], null)),"Prints a newline using *print-fn*"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$impls,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[true,"cljs/core.cljs",(21),(14),(619),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$_DASH_lookup,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$k,cljs.core.cst$sym$not_DASH_found], null)], null)], null)], null),(619),"Protocol for looking up a value in a data structure.",cljs.core.list("@interface")]),true,cljs.core.cst$sym$cljs$core_SLASH_ILookup,"cljs/core.cljs",(21),(1),(619),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$_DASH_lookup,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$k,cljs.core.cst$sym$not_DASH_found], null)], null)], null)], null),null,(619),cljs.core.cst$sym$any,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [cljs.core.cst$sym$cljs$core_SLASH_PersistentHashMap,"null",cljs.core.cst$sym$cljs$core_SLASH_ObjMap,"null",cljs.core.cst$sym$cljs$core_SLASH_TransientVector,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentArrayMap,"null",cljs.core.cst$sym$cljs$core_SLASH_BlackNode,"null",cljs.core.cst$sym$cljs$core_SLASH_MapEntry,"null",cljs.core.cst$sym$cljs$core_SLASH_Subvec,"null",cljs.core.cst$sym$cljs$core_SLASH_TransientHashMap,"null",cljs.core.cst$sym$cljs$core_SLASH_TaggedLiteral,"null",cljs.core.cst$sym$cljs$tools$reader$impl$utils_SLASH_ReaderConditional,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentVector,"null",cljs.core.cst$sym$cljs$core_SLASH_TransientArrayMap,"null",cljs.core.cst$sym$cljs$spec$alpha_SLASH_t_cljs$spec$alpha102826,"null",cljs.core.cst$sym$cljs$core_SLASH_TransientHashSet,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentHashSet,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentTreeMap,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentTreeSet,"null",cljs.core.cst$sym$cljs$core_SLASH_RedNode,"null"], null), null),"Protocol for looking up a value in a data structure.",cljs.core.list("@interface")]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(831),cljs.core.cst$kw$column,(4),cljs.core.cst$kw$end_DASH_line,(831),cljs.core.cst$kw$end_DASH_column,(17),cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IChunkedSeq,cljs.core.cst$kw$doc,"Return a new collection of coll with the first chunk removed.",cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_IChunkedSeq,cljs.core.cst$sym$cljs$core_SLASH__DASH_chunked_DASH_rest,"cljs/core.cljs",(17),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),null,cljs.core.list(null,null),(1),false,(827),cljs.core.cst$sym$any,(831),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),"Return a new collection of coll with the first chunk removed."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(10049),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(10049),cljs.core.cst$kw$end_DASH_column,(16),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$writer,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ss], null))),cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$writer,cljs.core.cst$sym$ss)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$writer,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ss], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_write_DASH_all,"cljs/core.cljs",(16),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$writer,cljs.core.cst$sym$ss)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$writer,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ss], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$writer,cljs.core.cst$sym$ss)], null),null,(1),cljs.core.list(null),(1),true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$tag,cljs.core.cst$sym$clj_DASH_nil], null)], null),(10049),cljs.core.cst$sym$any,(10049),(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$writer,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ss], null))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2008),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(2008),cljs.core.cst$kw$end_DASH_column,(10),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null))),cljs.core.cst$kw$doc,"Return true if f is a JavaScript function or satisfies the Fn protocol."], null),cljs.core.cst$sym$cljs$core_SLASH_fn_QMARK_,"cljs/core.cljs",(10),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null)),null,cljs.core.list(null,null),(1),false,(2008),cljs.core.cst$sym$boolean,(2008),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null))),"Return true if f is a JavaScript function or satisfies the Fn protocol."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(11015),cljs.core.cst$kw$column,(4),cljs.core.cst$kw$end_DASH_line,(11015),cljs.core.cst$kw$end_DASH_column,(18),cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IMultiFn,cljs.core.cst$kw$doc,null,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$mf,cljs.core.cst$sym$dispatch_DASH_val,cljs.core.cst$sym$dispatch_DASH_val_DASH_y], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_IMultiFn,cljs.core.cst$sym$cljs$core_SLASH__DASH_prefer_DASH_method,"cljs/core.cljs",(18),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$mf,cljs.core.cst$sym$dispatch_DASH_val,cljs.core.cst$sym$dispatch_DASH_val_DASH_y], null)),null,cljs.core.list(null,null),(1),false,(11011),cljs.core.cst$sym$any,(11015),(3),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$mf,cljs.core.cst$sym$dispatch_DASH_val,cljs.core.cst$sym$dispatch_DASH_val_DASH_y], null))),null]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$tag,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[cljs.core.cst$sym$cljs$core_SLASH_IAssociative,"cljs/core.cljs",(15),(9),(630),(630),cljs.core.cst$sym$clj,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k,cljs.core.cst$sym$v], null))),"Returns a new collection of coll with a mapping from key k to\n     value v added to it."]),cljs.core.cst$sym$cljs$core_SLASH_IAssociative,cljs.core.cst$sym$cljs$core_SLASH__DASH_assoc,"cljs/core.cljs",(15),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k,cljs.core.cst$sym$v], null)),null,cljs.core.list(null,null),(1),false,(625),cljs.core.cst$sym$clj,(630),(3),cljs.core.cst$sym$clj,true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k,cljs.core.cst$sym$v], null))),"Returns a new collection of coll with a mapping from key k to\n     value v added to it."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(9948),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(9948),cljs.core.cst$kw$end_DASH_column,(12),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"When lazy sequences are produced via functions that have side\n  effects, any effects other than those needed to produce the first\n  element in the seq do not occur until the seq is consumed. doall can\n  be used to force any effects. Walks through the successive nexts of\n  the seq, retains the head and returns it, thus causing the entire\n  seq to reside in memory at one time.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_doall,"cljs/core.cljs",(12),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null)),null,(2),cljs.core.list(null,null),(1),false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,false], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false], null)], null),(9948),(9948),(2),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null)),"When lazy sequences are produced via functions that have side\n  effects, any effects other than those needed to produce the first\n  element in the seq do not occur until the seq is consumed. doall can\n  be used to force any effects. Walks through the successive nexts of\n  the seq, retains the head and returns it, thus causing the entire\n  seq to reside in memory at one time."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(3335),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(3335),cljs.core.cst$kw$end_DASH_column,(25),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null))),cljs.core.cst$kw$doc,"Efficient test to determine that two keywords are identical."], null),cljs.core.cst$sym$cljs$core_SLASH_keyword_DASH_identical_QMARK_,"cljs/core.cljs",(25),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)),null,cljs.core.list(null,null),(1),false,(3335),cljs.core.cst$sym$boolean,(3335),(2),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null))),"Efficient test to determine that two keywords are identical."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$dynamic,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$doc],[new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(84),cljs.core.cst$kw$column,(3),cljs.core.cst$kw$end_DASH_line,(84),cljs.core.cst$kw$end_DASH_column,(17),cljs.core.cst$kw$doc,"Each runtime environment provides a different way to print error output.\n  Whatever function *print-err-fn* is bound to will be passed any\n  Strings which should be printed.",cljs.core.cst$kw$dynamic,true], null),cljs.core.cst$sym$cljs$core_SLASH__STAR_print_DASH_err_DASH_fn_STAR_,"cljs/core.cljs",(17),(1),true,(80),(84),cljs.core.cst$sym$clj_DASH_nil,"Each runtime environment provides a different way to print error output.\n  Whatever function *print-err-fn* is bound to will be passed any\n  Strings which should be printed."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$private,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(5351),cljs.core.cst$kw$column,(8),cljs.core.cst$kw$end_DASH_line,(5351),cljs.core.cst$kw$end_DASH_column,(15),cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$node,cljs.core.cst$sym$idx,cljs.core.cst$sym$val], null)))], null),true,cljs.core.cst$sym$cljs$core_SLASH_pv_DASH_aset,"cljs/core.cljs",(15),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$node,cljs.core.cst$sym$idx,cljs.core.cst$sym$val], null)),null,cljs.core.list(null,null),(1),false,(5351),cljs.core.cst$sym$any,(5351),(3),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$node,cljs.core.cst$sym$idx,cljs.core.cst$sym$val], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(11235),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(11235),cljs.core.cst$kw$end_DASH_column,(14),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$multifn], null))),cljs.core.cst$kw$doc,"Given a multimethod, returns a map of preferred value -> set of other values"], null),cljs.core.cst$sym$cljs$core_SLASH_prefers,"cljs/core.cljs",(14),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$multifn], null)),null,cljs.core.list(null,null),(1),false,(11235),cljs.core.cst$sym$any,(11235),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$multifn], null))),"Given a multimethod, returns a map of preferred value -> set of other values"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(10742),cljs.core.cst$kw$column,(4),cljs.core.cst$kw$end_DASH_line,(10742),cljs.core.cst$kw$end_DASH_column,(12),cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IEncodeClojure,cljs.core.cst$kw$doc,"Transforms JavaScript values to Clojure",cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$options], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_IEncodeClojure,cljs.core.cst$sym$cljs$core_SLASH__DASH_js_DASH__GT_clj,"cljs/core.cljs",(12),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$options], null)),null,cljs.core.list(null,null),(1),false,(10741),cljs.core.cst$sym$any,(10742),(2),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$options], null))),"Transforms JavaScript values to Clojure"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$num_DASH_fields,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$type,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$record,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag],[(4),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IPending,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH_LazySeq,"cljs/core.cljs",(17),true,(10),(3412),false,(3412),cljs.core.cst$sym$function,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 12, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IPending,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null)]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(10622),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(10622),cljs.core.cst$kw$end_DASH_column,(13),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a lazy sequence removing consecutive duplicates in coll.\n  Returns a transducer when no collection is provided.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_dedupe,"cljs/core.cljs",(13),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),null,(1),cljs.core.list(null,null),(1),false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$function], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$clj], null)], null),(10622),(10622),(1),true,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),"Returns a lazy sequence removing consecutive duplicates in coll.\n  Returns a transducer when no collection is provided."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$private,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(6024),cljs.core.cst$kw$column,(8),cljs.core.cst$kw$end_DASH_line,(6024),cljs.core.cst$kw$end_DASH_column,(36),cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tv,cljs.core.cst$sym$i], null)))], null),true,cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_editable_DASH_array_DASH_for,"cljs/core.cljs",(36),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tv,cljs.core.cst$sym$i], null)),null,cljs.core.list(null,null),(1),false,(6024),cljs.core.cst$sym$any,(6024),(2),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tv,cljs.core.cst$sym$i], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocols,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),"cljs/core.cljs",(21),(10),cljs.core.cst$kw$positional,(1280),(1280),cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null))),null,"Positional factory function for cljs.core/ES6Iterator."]),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH__DASH__GT_ES6Iterator,"cljs/core.cljs",(21),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null)),null,cljs.core.list(null,null),(1),false,cljs.core.cst$kw$positional,(1280),cljs.core.cst$sym$cljs$core_SLASH_ES6Iterator,(1280),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null))),null,"Positional factory function for cljs.core/ES6Iterator."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$num_DASH_fields,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$type,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$record,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag],[(2),cljs.core.PersistentHashSet.EMPTY,cljs.core.cst$sym$cljs$core_SLASH_VectorNode,"cljs/core.cljs",(20),true,(10),(5343),false,(5343),cljs.core.cst$sym$function,null]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(1994),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(1994),cljs.core.cst$kw$end_DASH_column,(13),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ks], null))),cljs.core.cst$kw$doc,"dissoc[iate]. Returns a new map of the same (hashed/sorted) type,\n  that does not contain a mapping for key(s).",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ks], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_dissoc,"cljs/core.cljs",(13),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ks], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k], null)),null,(2),cljs.core.list(null,null,null),(1),true,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,false], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$clj,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null)], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$clj,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null)], null)], null),(1994),(1994),(2),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ks], null)),"dissoc[iate]. Returns a new map of the same (hashed/sorted) type,\n  that does not contain a mapping for key(s)."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(4443),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(4443),cljs.core.cst$kw$end_DASH_column,(11),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$_AMPERSAND_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$keys,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$validator], null)], null)], null))),cljs.core.cst$kw$doc,"Creates and returns an Atom with an initial value of x and zero or\n  more options (in any order):\n\n  :meta metadata-map\n\n  :validator validate-fn\n\n  If metadata-map is supplied, it will become the metadata on the\n  atom. validate-fn must be nil or a side-effect-free fn of one\n  argument, which will be passed the intended new state on any state\n  change. If the new state is unacceptable, the validate-fn should\n  return false or throw an Error.  If either of these error conditions\n  occur, then the value of the atom will not change.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$_AMPERSAND_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$keys,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$validator], null)], null)], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_atom,"cljs/core.cljs",(11),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$_AMPERSAND_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$keys,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$validator], null)], null)], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),null,(1),cljs.core.list(null,null),(1),true,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core_SLASH_Atom], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core_SLASH_Atom], null)], null),(4443),(4443),(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$_AMPERSAND_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$keys,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$validator], null)], null)], null)),"Creates and returns an Atom with an initial value of x and zero or\n  more options (in any order):\n\n  :meta metadata-map\n\n  :validator validate-fn\n\n  If metadata-map is supplied, it will become the metadata on the\n  atom. validate-fn must be nil or a side-effect-free fn of one\n  argument, which will be passed the intended new state on any state\n  change. If the new state is unacceptable, the validate-fn should\n  return false or throw an Error.  If either of these error conditions\n  occur, then the value of the atom will not change."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2899),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(2899),cljs.core.cst$kw$end_DASH_column,(22),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null))),cljs.core.cst$kw$doc,"Bitwise shift right"], null),cljs.core.cst$sym$cljs$core_SLASH_bit_DASH_shift_DASH_right,"cljs/core.cljs",(22),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null)),null,cljs.core.list(null,null),(1),false,(2899),cljs.core.cst$sym$number,(2899),(2),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null))),"Bitwise shift right"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$num_DASH_fields,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$type,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$record,cljs.core.cst$kw$declared,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag],[new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(1977),cljs.core.cst$kw$column,(47),cljs.core.cst$kw$end_DASH_line,(1977),cljs.core.cst$kw$end_DASH_column,(55),cljs.core.cst$kw$declared,true], null),(3),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [cljs.core.cst$sym$cljs$core_SLASH_IIndexed,"null",cljs.core.cst$sym$cljs$core_SLASH_IVector,"null",cljs.core.cst$sym$cljs$core_SLASH_IReversible,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IFind,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IStack,"null",cljs.core.cst$sym$cljs$core_SLASH_IMapEntry,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH_MapEntry,"cljs/core.cljs",(18),true,(10),(6631),false,true,(6631),cljs.core.cst$sym$function,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [cljs.core.cst$sym$cljs$core_SLASH_IIndexed,"null",cljs.core.cst$sym$cljs$core_SLASH_IVector,"null",cljs.core.cst$sym$cljs$core_SLASH_IReversible,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IStack,"null",cljs.core.cst$sym$cljs$core_SLASH_IMapEntry,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null)]),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH__STAR_clojurescript_DASH_version_STAR_,cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(19),cljs.core.cst$kw$column,(1),cljs.core.cst$kw$end_DASH_line,(19),cljs.core.cst$kw$end_DASH_column,(29),cljs.core.cst$kw$meta,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(19),cljs.core.cst$kw$column,(6),cljs.core.cst$kw$end_DASH_line,(19),cljs.core.cst$kw$end_DASH_column,(29)], null),cljs.core.cst$kw$tag,cljs.core.cst$sym$string], null),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(603),cljs.core.cst$kw$column,(4),cljs.core.cst$kw$end_DASH_line,(603),cljs.core.cst$kw$end_DASH_column,(10),cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_ISeq,cljs.core.cst$kw$doc,"Returns the first item in the collection coll. Used by cljs.core/first.",cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_ISeq,cljs.core.cst$sym$cljs$core_SLASH__DASH_first,"cljs/core.cljs",(10),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),null,cljs.core.list(null,null),(1),false,(601),cljs.core.cst$sym$any,(603),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),"Returns the first item in the collection coll. Used by cljs.core/first."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2082),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(2082),cljs.core.cst$kw$end_DASH_column,(11),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"For a list or queue, same as first, for a vector, same as, but much\n  more efficient than, last. If the collection is empty, returns nil."], null),cljs.core.cst$sym$cljs$core_SLASH_peek,"cljs/core.cljs",(11),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),null,cljs.core.list(null,null),(1),false,(2082),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$any,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null),(2082),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),"For a list or queue, same as first, for a vector, same as, but much\n  more efficient than, last. If the collection is empty, returns nil."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$impls,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[true,"cljs/core.cljs",(23),(14),(697),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$_DASH_kv_DASH_reduce,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f,cljs.core.cst$sym$init], null)], null)], null)], null),(697),"Protocol for associative types that can reduce themselves\n  via a function of key and val. Called by cljs.core/reduce-kv.",cljs.core.list("@interface")]),true,cljs.core.cst$sym$cljs$core_SLASH_IKVReduce,"cljs/core.cljs",(23),(1),(697),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$_DASH_kv_DASH_reduce,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f,cljs.core.cst$sym$init], null)], null)], null)], null),null,(697),cljs.core.cst$sym$any,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$sym$cljs$core_SLASH_PersistentHashMap,"null",cljs.core.cst$sym$cljs$core_SLASH_ObjMap,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentArrayMap,"null",cljs.core.cst$sym$cljs$core_SLASH_Subvec,"null",cljs.core.cst$sym$cljs$tools$reader$impl$utils_SLASH_ReaderConditional,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentVector,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentTreeMap,"null"], null), null),"Protocol for associative types that can reduce themselves\n  via a function of key and val. Called by cljs.core/reduce-kv.",cljs.core.list("@interface")]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$private,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2481),cljs.core.cst$kw$column,(8),cljs.core.cst$kw$end_DASH_line,(2481),cljs.core.cst$kw$end_DASH_column,(19),cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f,cljs.core.cst$sym$init], null))),cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f,cljs.core.cst$sym$init], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f,cljs.core.cst$sym$init], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null),true,cljs.core.cst$sym$cljs$core_SLASH_iter_DASH_reduce,"cljs/core.cljs",(19),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f,cljs.core.cst$sym$init], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f,cljs.core.cst$sym$init], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f,cljs.core.cst$sym$init], null)),null,(3),cljs.core.list(null,null),(1),false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$any], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [null,"null",cljs.core.cst$sym$any,"null"], null), null)], null)], null),(2481),(2481),(3),true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f,cljs.core.cst$sym$init], null))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(496),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(496),cljs.core.cst$kw$end_DASH_column,(11),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$idxs], null))),cljs.core.cst$kw$doc,"Returns the value at the index/indices. Works on JavaScript arrays.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$idxs], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_aget,"cljs/core.cljs",(11),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$idxs], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx], null)),null,(2),cljs.core.list(null,null),(1),true,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$any], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$tag,cljs.core.cst$sym$any], null)], null),(496),(496),(2),true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$idxs], null)),"Returns the value at the index/indices. Works on JavaScript arrays."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$num_DASH_fields,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$type,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$record,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag],[(5),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH_PersistentTreeMapSeq,"cljs/core.cljs",(30),true,(10),(8156),false,(8156),cljs.core.cst$sym$function,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 12, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null)]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(752),cljs.core.cst$kw$column,(4),cljs.core.cst$kw$end_DASH_line,(752),cljs.core.cst$kw$end_DASH_column,(10),cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IWriter,cljs.core.cst$kw$doc,"Writes s with writer and returns the result.",cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$writer,cljs.core.cst$sym$s], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_IWriter,cljs.core.cst$sym$cljs$core_SLASH__DASH_write,"cljs/core.cljs",(10),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$writer,cljs.core.cst$sym$s], null)),null,cljs.core.list(null,null),(1),false,(750),cljs.core.cst$sym$any,(752),(2),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$writer,cljs.core.cst$sym$s], null))),"Writes s with writer and returns the result."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$anonymous,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$anonymous,true,cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta9577], null))),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/t_cljs$core9576.",cljs.core.cst$kw$file,"cljs/core.cljs"], null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH__DASH__GT_t_cljs$core9576,"cljs/core.cljs",cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta9577], null)),null,cljs.core.list(null,null),true,(3),false,cljs.core.cst$kw$positional,(4000),cljs.core.cst$sym$cljs$core_SLASH_t_cljs$core9576,(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta9577], null))),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),"Positional factory function for cljs.core/t_cljs$core9576."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(4054),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(4054),cljs.core.cst$kw$end_DASH_column,(11),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_iter,"cljs/core.cljs",(11),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),null,cljs.core.list(null,null),(1),false,(4054),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$clj,"null",cljs.core.cst$sym$any,"null"], null), null),(4054),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(9599),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(9599),cljs.core.cst$kw$end_DASH_column,(18),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$sc,cljs.core.cst$sym$test,cljs.core.cst$sym$key], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_mk_DASH_bound_DASH_fn,"cljs/core.cljs",(18),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$sc,cljs.core.cst$sym$test,cljs.core.cst$sym$key], null)),null,cljs.core.list(null,null),(1),false,(9599),cljs.core.cst$sym$function,(9599),(3),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$sc,cljs.core.cst$sym$test,cljs.core.cst$sym$key], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(1768),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(1768),cljs.core.cst$kw$end_DASH_column,(11),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null))),cljs.core.cst$kw$doc,"Return the last item in coll, in linear time"], null),cljs.core.cst$sym$cljs$core_SLASH_last,"cljs/core.cljs",(11),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null)),null,cljs.core.list(null,null),(1),false,(1768),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$any,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null),(1768),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null))),"Return the last item in coll, in linear time"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(11019),cljs.core.cst$kw$column,(4),cljs.core.cst$kw$end_DASH_line,(11019),cljs.core.cst$kw$end_DASH_column,(25),cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IMultiFn,cljs.core.cst$kw$doc,null,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$mf], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_IMultiFn,cljs.core.cst$sym$cljs$core_SLASH__DASH_default_DASH_dispatch_DASH_val,"cljs/core.cljs",(25),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$mf], null)),null,cljs.core.list(null,null),(1),false,(11011),cljs.core.cst$sym$any,(11019),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$mf], null))),null]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(10239),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(10239),cljs.core.cst$kw$end_DASH_column,(9),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$objs], null))),cljs.core.cst$kw$doc,"Prints the object(s) using string-print.  Prints the\n  object(s), separated by spaces if there is more than one.\n  By default, pr and prn print in a way that objects can be\n  read by the reader",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(0),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$objs)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$objs], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_pr,"cljs/core.cljs",(9),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(0),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$objs)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$objs], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$objs)], null),null,(0),cljs.core.list(null),(1),true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$tag,cljs.core.cst$sym$clj_DASH_nil], null)], null),(10239),cljs.core.cst$sym$any,(10239),(0),true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$objs], null)),"Prints the object(s) using string-print.  Prints the\n  object(s), separated by spaces if there is more than one.\n  By default, pr and prn print in a way that objects can be\n  read by the reader"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$private,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(8149),cljs.core.cst$kw$column,(8),cljs.core.cst$kw$end_DASH_line,(8149),cljs.core.cst$kw$end_DASH_column,(25),cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$node,cljs.core.cst$sym$stack,cljs.core.cst$sym$ascending_QMARK_], null)))], null),true,cljs.core.cst$sym$cljs$core_SLASH_tree_DASH_map_DASH_seq_DASH_push,"cljs/core.cljs",(25),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$node,cljs.core.cst$sym$stack,cljs.core.cst$sym$ascending_QMARK_], null)),null,cljs.core.list(null,null),(1),false,(8149),(8149),(3),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$node,cljs.core.cst$sym$stack,cljs.core.cst$sym$ascending_QMARK_], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(3353),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(3353),cljs.core.cst$kw$end_DASH_column,(16),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns the namespace String of a symbol or keyword, or nil if not present."], null),cljs.core.cst$sym$cljs$core_SLASH_namespace,"cljs/core.cljs",(16),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),null,cljs.core.list(null,null),(1),false,(3353),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$string,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null),(3353),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),"Returns the namespace String of a symbol or keyword, or nil if not present."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$private,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag],[new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(1354),cljs.core.cst$kw$column,(16),cljs.core.cst$kw$end_DASH_line,(1354),cljs.core.cst$kw$end_DASH_column,(36),cljs.core.cst$kw$private,true], null),true,cljs.core.cst$sym$cljs$core_SLASH_empty_DASH_unordered_DASH_hash,"cljs/core.cljs",(36),(1),(1354),(1354),cljs.core.cst$sym$number]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(8901),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(8901),cljs.core.cst$kw$end_DASH_column,(14),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$keyvals], null))),cljs.core.cst$kw$doc,"keyval => key val\n  Returns a new object map with supplied mappings.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(0),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$keyvals)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$keyvals], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_obj_DASH_map,"cljs/core.cljs",(14),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(0),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$keyvals)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$keyvals], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$keyvals)], null),null,(0),cljs.core.list(null),(1),true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$tag,cljs.core.cst$sym$any], null)], null),(8901),cljs.core.cst$sym$any,(8901),(0),true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$keyvals], null)),"keyval => key val\n  Returns a new object map with supplied mappings."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$num_DASH_fields,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$type,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$record,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag],[(1),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_IDeref,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH_Reduced,"cljs/core.cljs",(17),true,(10),(1420),false,(1420),cljs.core.cst$sym$function,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_IDeref,"null"], null), null)]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$tag,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[cljs.core.cst$sym$cljs$core_SLASH_ICollection,"cljs/core.cljs",(14),(9),(583),(583),cljs.core.cst$sym$clj,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$o], null))),"Returns a new collection of coll with o added to it. The new item\n     should be added to the most efficient place, e.g.\n     (conj [1 2 3 4] 5) => [1 2 3 4 5]\n     (conj '(2 3 4 5) 1) => '(1 2 3 4 5)"]),cljs.core.cst$sym$cljs$core_SLASH_ICollection,cljs.core.cst$sym$cljs$core_SLASH__DASH_conj,"cljs/core.cljs",(14),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$o], null)),null,cljs.core.list(null,null),(1),false,(581),cljs.core.cst$sym$clj,(583),(2),cljs.core.cst$sym$clj,true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$o], null))),"Returns a new collection of coll with o added to it. The new item\n     should be added to the most efficient place, e.g.\n     (conj [1 2 3 4] 5) => [1 2 3 4 5]\n     (conj '(2 3 4 5) 1) => '(1 2 3 4 5)"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$num_DASH_fields,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$type,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$record,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag],[(5),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 12, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH_NodeSeq,"cljs/core.cljs",(17),true,(10),(7691),false,(7691),cljs.core.cst$sym$function,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null)]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$tag,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],["cljs/core.cljs",(17),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null),(16),(1261),(1261),cljs.core.cst$sym$boolean,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null))),"Equality. Returns true if x equals y, false if not. Compares\n  numbers and collections in a type-independent manner.  Clojure's immutable data\n  structures define -equiv (and thus =) as a value, not an identity,\n  comparison."]),cljs.core.cst$sym$cljs$core_SLASH__EQ_,"cljs/core.cljs",(17),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)),null,(2),cljs.core.list(null,null,null),(1),true,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean], null)], null),(1261),cljs.core.cst$sym$boolean,(1261),(2),cljs.core.cst$sym$boolean,true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),"Equality. Returns true if x equals y, false if not. Compares\n  numbers and collections in a type-independent manner.  Clojure's immutable data\n  structures define -equiv (and thus =) as a value, not an identity,\n  comparison."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$impls,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[true,"cljs/core.cljs",(27),(14),(799),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$_DASH_dissoc_BANG_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$key], null)], null)], null)], null),(799),"Protocol for adding mapping functionality to transient collections.",cljs.core.list("@interface")]),true,cljs.core.cst$sym$cljs$core_SLASH_ITransientMap,"cljs/core.cljs",(27),(1),(799),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$_DASH_dissoc_BANG_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$key], null)], null)], null)], null),null,(799),cljs.core.cst$sym$any,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_TransientHashMap,"null",cljs.core.cst$sym$cljs$core_SLASH_TransientArrayMap,"null"], null), null),"Protocol for adding mapping functionality to transient collections.",cljs.core.list("@interface")]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$private,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(5373),cljs.core.cst$kw$column,(8),cljs.core.cst$kw$end_DASH_line,(5373),cljs.core.cst$kw$end_DASH_column,(17),cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pv,cljs.core.cst$sym$level,cljs.core.cst$sym$parent,cljs.core.cst$sym$tailnode], null)))], null),true,cljs.core.cst$sym$cljs$core_SLASH_push_DASH_tail,"cljs/core.cljs",(17),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pv,cljs.core.cst$sym$level,cljs.core.cst$sym$parent,cljs.core.cst$sym$tailnode], null)),null,cljs.core.list(null,null),(1),false,(5373),cljs.core.cst$sym$cljs$core_SLASH_VectorNode,(5373),(4),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pv,cljs.core.cst$sym$level,cljs.core.cst$sym$parent,cljs.core.cst$sym$tailnode], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(4740),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(4740),cljs.core.cst$kw$end_DASH_column,(11),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a lazy sequence of the first n items in coll, or all items if\n  there are fewer than n.  Returns a stateful transducer when\n  no collection is provided.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_take,"cljs/core.cljs",(11),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null)),null,(2),cljs.core.list(null,null),(1),false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$function], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core_SLASH_LazySeq], null)], null),(4740),(4740),(2),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null)),"Returns a lazy sequence of the first n items in coll, or all items if\n  there are fewer than n.  Returns a stateful transducer when\n  no collection is provided."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2163),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(2163),cljs.core.cst$kw$end_DASH_column,(14),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Return true if x satisfies IVector"], null),cljs.core.cst$sym$cljs$core_SLASH_vector_QMARK_,"cljs/core.cljs",(14),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),null,cljs.core.list(null,null),(1),false,(2163),cljs.core.cst$sym$boolean,(2163),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),"Return true if x satisfies IVector"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$private,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(6590),cljs.core.cst$kw$column,(8),cljs.core.cst$kw$end_DASH_line,(6590),cljs.core.cst$kw$end_DASH_column,(29),cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$k], null)))], null),true,cljs.core.cst$sym$cljs$core_SLASH_array_DASH_index_DASH_of_DASH_equiv_QMARK_,"cljs/core.cljs",(29),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$k], null)),null,cljs.core.list(null,null),(1),false,(6590),cljs.core.cst$sym$number,(6590),(2),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$k], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$private,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(7153),cljs.core.cst$kw$column,(8),cljs.core.cst$kw$end_DASH_line,(7153),cljs.core.cst$kw$end_DASH_column,(33),cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$bitmap,cljs.core.cst$sym$bit], null)))], null),true,cljs.core.cst$sym$cljs$core_SLASH_bitmap_DASH_indexed_DASH_node_DASH_index,"cljs/core.cljs",(33),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$bitmap,cljs.core.cst$sym$bit], null)),null,cljs.core.list(null,null),(1),false,(7153),cljs.core.cst$sym$number,(7153),(2),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$bitmap,cljs.core.cst$sym$bit], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2246),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(2246),cljs.core.cst$kw$end_DASH_column,(14),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Coerce to boolean"], null),cljs.core.cst$sym$cljs$core_SLASH_boolean,"cljs/core.cljs",(14),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),null,cljs.core.list(null,null),(1),false,(2246),cljs.core.cst$sym$boolean,(2246),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),"Coerce to boolean"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$impls,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[true,"cljs/core.cljs",(20),(14),(822),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$_DASH_drop_DASH_first,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)], null)], null)], null),(822),"Protocol for accessing the items of a chunk.",cljs.core.list("@interface")]),true,cljs.core.cst$sym$cljs$core_SLASH_IChunk,"cljs/core.cljs",(20),(1),(822),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$_DASH_drop_DASH_first,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)], null)], null)], null),null,(822),cljs.core.cst$sym$any,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_RangeChunk,"null",cljs.core.cst$sym$cljs$core_SLASH_ArrayChunk,"null"], null), null),"Protocol for accessing the items of a chunk.",cljs.core.list("@interface")]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2895),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(2895),cljs.core.cst$kw$end_DASH_column,(21),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null))),cljs.core.cst$kw$doc,"Bitwise shift left"], null),cljs.core.cst$sym$cljs$core_SLASH_bit_DASH_shift_DASH_left,"cljs/core.cljs",(21),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null)),null,cljs.core.list(null,null),(1),false,(2895),cljs.core.cst$sym$number,(2895),(2),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null))),"Bitwise shift left"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(11280),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(11280),cljs.core.cst$kw$end_DASH_column,(18),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY))], null),cljs.core.cst$sym$cljs$core_SLASH_random_DASH_uuid,"cljs/core.cljs",(18),cljs.core.list(cljs.core.PersistentVector.EMPTY),null,cljs.core.list(null,null),(1),false,(11280),(11280),(0),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(275),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(275),cljs.core.cst$kw$end_DASH_column,(11),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true if given any argument."], null),cljs.core.cst$sym$cljs$core_SLASH_any_QMARK_,"cljs/core.cljs",(11),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),null,cljs.core.list(null,null),(1),false,(275),cljs.core.cst$sym$boolean,(275),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),"Returns true if given any argument."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(10816),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(10816),cljs.core.cst$kw$end_DASH_column,(15),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n], null))),cljs.core.cst$kw$doc,"Returns a random integer between 0 (inclusive) and n (exclusive)."], null),cljs.core.cst$sym$cljs$core_SLASH_rand_DASH_int,"cljs/core.cljs",(15),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n], null)),null,cljs.core.list(null,null),(1),false,(10816),cljs.core.cst$sym$any,(10816),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n], null))),"Returns a random integer between 0 (inclusive) and n (exclusive)."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(426),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(426),cljs.core.cst$kw$end_DASH_column,(13),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr], null))),cljs.core.cst$kw$doc,"Returns a javascript array, cloned from the passed in array"], null),cljs.core.cst$sym$cljs$core_SLASH_aclone,"cljs/core.cljs",(13),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr], null)),null,cljs.core.list(null,null),(1),false,(426),cljs.core.cst$sym$array,(426),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr], null))),"Returns a javascript array, cloned from the passed in array"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$num_DASH_fields,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$type,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$record,cljs.core.cst$kw$declared,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag],[new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(8230),cljs.core.cst$kw$column,(18),cljs.core.cst$kw$end_DASH_line,(8230),cljs.core.cst$kw$end_DASH_column,(27),cljs.core.cst$kw$declared,true], null),(5),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [cljs.core.cst$sym$cljs$core_SLASH_IIndexed,"null",cljs.core.cst$sym$cljs$core_SLASH_IVector,"null",cljs.core.cst$sym$cljs$core_SLASH_IReversible,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IFind,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IStack,"null",cljs.core.cst$sym$cljs$core_SLASH_IMapEntry,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH_BlackNode,"cljs/core.cljs",(19),true,(10),(8330),false,true,(8330),cljs.core.cst$sym$function,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [cljs.core.cst$sym$cljs$core_SLASH_IIndexed,"null",cljs.core.cst$sym$cljs$core_SLASH_IVector,"null",cljs.core.cst$sym$cljs$core_SLASH_IReversible,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IStack,"null",cljs.core.cst$sym$cljs$core_SLASH_IMapEntry,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null)]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(4574),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(4574),cljs.core.cst$kw$end_DASH_column,(14),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$vol,cljs.core.cst$sym$newval], null))),cljs.core.cst$kw$doc,"Sets the value of volatile to newval without regard for the\n   current value. Returns newval."], null),cljs.core.cst$sym$cljs$core_SLASH_vreset_BANG_,"cljs/core.cljs",(14),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$vol,cljs.core.cst$sym$newval], null)),null,cljs.core.list(null,null),(1),false,(4574),cljs.core.cst$sym$any,(4574),(2),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$vol,cljs.core.cst$sym$newval], null))),"Sets the value of volatile to newval without regard for the\n   current value. Returns newval."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(3625),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(3625),cljs.core.cst$kw$end_DASH_column,(12),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$b], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_chunk,"cljs/core.cljs",(12),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$b], null)),null,cljs.core.list(null,null),(1),false,(3625),cljs.core.cst$sym$any,(3625),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$b], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$private,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag],[new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(5019),cljs.core.cst$kw$column,(16),cljs.core.cst$kw$end_DASH_line,(5019),cljs.core.cst$kw$end_DASH_column,(31),cljs.core.cst$kw$private,true], null),true,cljs.core.cst$sym$cljs$core_SLASH_UNREALIZED_DASH_SEED,"cljs/core.cljs",(31),(1),(5019),(5019),cljs.core.cst$sym$object]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2677),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(2677),cljs.core.cst$kw$end_DASH_column,(10),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns a number one less than num."], null),cljs.core.cst$sym$cljs$core_SLASH_dec,"cljs/core.cljs",(10),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),null,cljs.core.list(null,null),(1),false,(2677),cljs.core.cst$sym$number,(2677),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),"Returns a number one less than num."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocols,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),"cljs/core.cljs",(29),(10),cljs.core.cst$kw$positional,(4136),(4136),cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$buffer,cljs.core.cst$sym$_next,cljs.core.cst$sym$completed,cljs.core.cst$sym$xf,cljs.core.cst$sym$sourceIter,cljs.core.cst$sym$multi], null))),null,"Positional factory function for cljs.core/TransformerIterator."]),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH__DASH__GT_TransformerIterator,"cljs/core.cljs",(29),cljs.core.list(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$buffer,cljs.core.cst$sym$_next,cljs.core.cst$sym$completed,cljs.core.cst$sym$xf,cljs.core.cst$sym$sourceIter,cljs.core.cst$sym$multi], null)),null,cljs.core.list(null,null),(1),false,cljs.core.cst$kw$positional,(4136),cljs.core.cst$sym$cljs$core_SLASH_TransformerIterator,(4136),(6),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$buffer,cljs.core.cst$sym$_next,cljs.core.cst$sym$completed,cljs.core.cst$sym$xf,cljs.core.cst$sym$sourceIter,cljs.core.cst$sym$multi], null))),null,"Positional factory function for cljs.core/TransformerIterator."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$impls,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[true,"cljs/core.cljs",(31),(14),(5478),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,cljs.core.PersistentArrayMap.EMPTY], null),(5478),"Marker protocol",cljs.core.list("@interface")]),true,cljs.core.cst$sym$cljs$core_SLASH_APersistentVector,"cljs/core.cljs",(31),(1),(5478),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,cljs.core.PersistentArrayMap.EMPTY], null),null,(5478),cljs.core.cst$sym$any,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_PersistentVector,"null"], null), null),"Marker protocol",cljs.core.list("@interface")]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(4693),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(4693),cljs.core.cst$kw$end_DASH_column,(10),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$c1,cljs.core.cst$sym$c2], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$c1,cljs.core.cst$sym$c2,cljs.core.cst$sym$c3], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$c1,cljs.core.cst$sym$c2,cljs.core.cst$sym$c3,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$colls], null))),cljs.core.cst$kw$doc,"Returns a lazy sequence consisting of the result of applying f to\n  the set of first items of each coll, followed by applying f to the\n  set of second items in each coll, until any one of the colls is\n  exhausted.  Any remaining items in other colls are ignored. Function\n  f should accept number-of-colls arguments. Returns a transducer when\n  no collection is provided.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(4),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(4),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$c1,cljs.core.cst$sym$c2], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$c1,cljs.core.cst$sym$c2,cljs.core.cst$sym$c3], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$c1,cljs.core.cst$sym$c2], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$c1,cljs.core.cst$sym$c2,cljs.core.cst$sym$c3], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$c1,cljs.core.cst$sym$c2,cljs.core.cst$sym$c3,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$colls], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_map,"cljs/core.cljs",(10),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(4),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(4),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$c1,cljs.core.cst$sym$c2], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$c1,cljs.core.cst$sym$c2,cljs.core.cst$sym$c3], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$c1,cljs.core.cst$sym$c2], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$c1,cljs.core.cst$sym$c2,cljs.core.cst$sym$c3], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$c1,cljs.core.cst$sym$c2,cljs.core.cst$sym$c3,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$colls], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$c1,cljs.core.cst$sym$c2], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$c1,cljs.core.cst$sym$c2,cljs.core.cst$sym$c3], null)),null,(4),cljs.core.list(null,null,null,null,null),(1),true,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$function], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core_SLASH_LazySeq], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core_SLASH_LazySeq], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(4),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core_SLASH_LazySeq], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(4),cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core_SLASH_LazySeq], null)], null),(4693),(4693),(4),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$c1,cljs.core.cst$sym$c2], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$c1,cljs.core.cst$sym$c2,cljs.core.cst$sym$c3], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$c1,cljs.core.cst$sym$c2,cljs.core.cst$sym$c3,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$colls], null)),"Returns a lazy sequence consisting of the result of applying f to\n  the set of first items of each coll, followed by applying f to the\n  set of second items in each coll, until any one of the colls is\n  exhausted.  Any remaining items in other colls are ignored. Function\n  f should accept number-of-colls arguments. Returns a transducer when\n  no collection is provided."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(9899),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(9899),cljs.core.cst$kw$end_DASH_column,(11),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$fs], null))),cljs.core.cst$kw$doc,"Takes a set of functions and returns a fn that is the juxtaposition\n  of those fns.  The returned fn takes a variable number of args, and\n  returns a vector containing the result of applying each fn to the\n  args (left-to-right).\n  ((juxt a b c) x) => [(a x) (b x) (c x)]",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$fs], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_juxt,"cljs/core.cljs",(11),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$fs], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h], null)),null,(3),cljs.core.list(null,null,null,null),(1),true,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$function], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$function], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$function], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$tag,cljs.core.cst$sym$function], null)], null),(9899),(9899),(3),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$fs], null)),"Takes a set of functions and returns a fn that is the juxtaposition\n  of those fns.  The returned fn takes a variable number of args, and\n  returns a vector containing the result of applying each fn to the\n  args (left-to-right).\n  ((juxt a b c) x) => [(a x) (b x) (c x)]"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocols,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),"cljs/core.cljs",(29),(10),cljs.core.cst$kw$positional,(6173),(6173),cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$fseq,cljs.core.cst$sym$riter], null))),null,"Positional factory function for cljs.core/PersistentQueueIter."]),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH__DASH__GT_PersistentQueueIter,"cljs/core.cljs",(29),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$fseq,cljs.core.cst$sym$riter], null)),null,cljs.core.list(null,null),(1),false,cljs.core.cst$kw$positional,(6173),cljs.core.cst$sym$cljs$core_SLASH_PersistentQueueIter,(6173),(2),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$fseq,cljs.core.cst$sym$riter], null))),null,"Positional factory function for cljs.core/PersistentQueueIter."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$tag,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],["cljs/core.cljs",(17),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null),(16),(2629),(2629),cljs.core.cst$sym$boolean,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null))),"Returns non-nil if nums are in monotonically increasing order,\n  otherwise false."]),cljs.core.cst$sym$cljs$core_SLASH__LT_,"cljs/core.cljs",(17),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)),null,(2),cljs.core.list(null,null,null),(1),true,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean], null)], null),(2629),cljs.core.cst$sym$boolean,(2629),(2),cljs.core.cst$sym$boolean,true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),"Returns non-nil if nums are in monotonically increasing order,\n  otherwise false."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$dynamic,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(11713),cljs.core.cst$kw$column,(3),cljs.core.cst$kw$end_DASH_line,(11713),cljs.core.cst$kw$end_DASH_column,(9),cljs.core.cst$kw$doc,"Runtime environments may provide a way to evaluate ClojureScript\n  forms. Whatever function *eval* is bound to will be passed any forms which\n  should be evaluated.",cljs.core.cst$kw$dynamic,true], null),cljs.core.cst$sym$cljs$core_SLASH__STAR_eval_STAR_,"cljs/core.cljs",(9),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_], null)),null,cljs.core.List.EMPTY,(1),false,true,(11709),cljs.core.cst$sym$ignore,(11713),(1),true,null,"Runtime environments may provide a way to evaluate ClojureScript\n  forms. Whatever function *eval* is bound to will be passed any forms which\n  should be evaluated."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$private,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(7170),cljs.core.cst$kw$column,(8),cljs.core.cst$kw$end_DASH_line,(7170),cljs.core.cst$kw$end_DASH_column,(23),cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$f,cljs.core.cst$sym$init], null)))], null),true,cljs.core.cst$sym$cljs$core_SLASH_inode_DASH_kv_DASH_reduce,"cljs/core.cljs",(23),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$f,cljs.core.cst$sym$init], null)),null,cljs.core.list(null,null),(1),false,(7170),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [null,"null",cljs.core.cst$sym$cljs$core_SLASH_Reduced,"null"], null), null),(7170),(3),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$f,cljs.core.cst$sym$init], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$private,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(6370),cljs.core.cst$kw$column,(8),cljs.core.cst$kw$end_DASH_line,(6370),cljs.core.cst$kw$end_DASH_column,(25),cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,cljs.core.cst$sym$k,cljs.core.cst$sym$v], null)))], null),true,cljs.core.cst$sym$cljs$core_SLASH_obj_DASH_map_DASH__GT_hash_DASH_map,"cljs/core.cljs",(25),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,cljs.core.cst$sym$k,cljs.core.cst$sym$v], null)),null,cljs.core.list(null,null),(1),false,(6370),cljs.core.cst$sym$clj,(6370),(3),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,cljs.core.cst$sym$k,cljs.core.cst$sym$v], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(11381),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(11381),cljs.core.cst$kw$end_DASH_column,(11),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$v], null))),cljs.core.cst$kw$doc,"test [v] finds fn at key :test in var metadata and calls it,\n  presuming failure will throw exception"], null),cljs.core.cst$sym$cljs$core_SLASH_test,"cljs/core.cljs",(11),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$v], null)),null,cljs.core.list(null,null),(1),false,(11381),cljs.core.cst$sym$cljs$core_SLASH_Keyword,(11381),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$v], null))),"test [v] finds fn at key :test in var metadata and calls it,\n  presuming failure will throw exception"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$tag,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(1239),cljs.core.cst$kw$column,(12),cljs.core.cst$kw$end_DASH_line,(1239),cljs.core.cst$kw$end_DASH_column,(16),cljs.core.cst$kw$tag,cljs.core.cst$sym$seq,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a possibly empty seq of the items after the first. Calls seq on its\n  argument."], null),cljs.core.cst$sym$cljs$core_SLASH_rest,"cljs/core.cljs",(16),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),null,cljs.core.list(null,null),(1),false,(1239),cljs.core.cst$sym$seq,(1239),(1),cljs.core.cst$sym$seq,true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),"Returns a possibly empty seq of the items after the first. Calls seq on its\n  argument."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(11345),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(11345),cljs.core.cst$kw$end_DASH_column,(14),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ex], null))),cljs.core.cst$kw$doc,"Returns exception data (a map) if ex is an ExceptionInfo.\n  Otherwise returns nil."], null),cljs.core.cst$sym$cljs$core_SLASH_ex_DASH_data,"cljs/core.cljs",(14),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ex], null)),null,cljs.core.list(null,null),(1),false,(11345),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$any,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null),(11345),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ex], null))),"Returns exception data (a map) if ex is an ExceptionInfo.\n  Otherwise returns nil."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$num_DASH_fields,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$type,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$record,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag],[(3),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH_PersistentArrayMapSeq,"cljs/core.cljs",(31),true,(10),(6731),false,(6731),cljs.core.cst$sym$function,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 12, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null)]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(824),cljs.core.cst$kw$column,(4),cljs.core.cst$kw$end_DASH_line,(824),cljs.core.cst$kw$end_DASH_column,(15),cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IChunk,cljs.core.cst$kw$doc,"Return a new chunk of coll with the first item removed.",cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_IChunk,cljs.core.cst$sym$cljs$core_SLASH__DASH_drop_DASH_first,"cljs/core.cljs",(15),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),null,cljs.core.list(null,null),(1),false,(822),cljs.core.cst$sym$any,(824),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),"Return a new chunk of coll with the first item removed."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$tag,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],["cljs/core.cljs",(20),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$child,cljs.core.cst$sym$parent], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$h,cljs.core.cst$sym$child,cljs.core.cst$sym$parent], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$child,cljs.core.cst$sym$parent], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$h,cljs.core.cst$sym$child,cljs.core.cst$sym$parent], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),(16),(10856),(10856),cljs.core.cst$sym$boolean,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$child,cljs.core.cst$sym$parent], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$h,cljs.core.cst$sym$child,cljs.core.cst$sym$parent], null))),"Returns true if (= child parent), or child is directly or indirectly derived from\n  parent, either via a JavaScript type inheritance relationship or a\n  relationship established via derive. h must be a hierarchy obtained\n  from make-hierarchy, if not supplied defaults to the global\n  hierarchy"]),cljs.core.cst$sym$cljs$core_SLASH_isa_QMARK_,"cljs/core.cljs",(20),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$child,cljs.core.cst$sym$parent], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$h,cljs.core.cst$sym$child,cljs.core.cst$sym$parent], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$child,cljs.core.cst$sym$parent], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$h,cljs.core.cst$sym$child,cljs.core.cst$sym$parent], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$child,cljs.core.cst$sym$parent], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$h,cljs.core.cst$sym$child,cljs.core.cst$sym$parent], null)),null,(3),cljs.core.list(null,null),(1),false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean], null)], null),(10856),cljs.core.cst$sym$boolean,(10856),(3),cljs.core.cst$sym$boolean,true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$child,cljs.core.cst$sym$parent], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$h,cljs.core.cst$sym$child,cljs.core.cst$sym$parent], null)),"Returns true if (= child parent), or child is directly or indirectly derived from\n  parent, either via a JavaScript type inheritance relationship or a\n  relationship established via derive. h must be a hierarchy obtained\n  from make-hierarchy, if not supplied defaults to the global\n  hierarchy"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2221),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(2221),cljs.core.cst$kw$end_DASH_column,(15),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Return true if x is a Boolean"], null),cljs.core.cst$sym$cljs$core_SLASH_boolean_QMARK_,"cljs/core.cljs",(15),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),null,cljs.core.list(null,null),(1),false,(2221),cljs.core.cst$sym$boolean,(2221),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),"Return true if x is a Boolean"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$tag,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"cljs/core.cljs",(15),(9),(567),(567),cljs.core.cst$sym$clj,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$value], null))),"Creates a clone of value."]),cljs.core.cst$sym$cljs$core_SLASH_ICloneable,cljs.core.cst$sym$cljs$core_SLASH__DASH_clone,"cljs/core.cljs",(15),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$value], null)),null,cljs.core.list(null,null),(1),false,(565),cljs.core.cst$sym$clj,(567),(1),cljs.core.cst$sym$clj,true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$value], null))),"Creates a clone of value."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(11490),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(11490),cljs.core.cst$kw$end_DASH_column,(12),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_munge,"cljs/core.cljs",(12),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name], null)),null,cljs.core.list(null,null),(1),false,(11490),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$sym$any,"null",cljs.core.cst$sym$string,"null",cljs.core.cst$sym$cljs$core_SLASH_Symbol,"null"], null), null),(11490),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$private,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag],[new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(1339),cljs.core.cst$kw$column,(16),cljs.core.cst$kw$end_DASH_line,(1339),cljs.core.cst$kw$end_DASH_column,(34),cljs.core.cst$kw$private,true], null),true,cljs.core.cst$sym$cljs$core_SLASH_empty_DASH_ordered_DASH_hash,"cljs/core.cljs",(34),(1),(1339),(1339),cljs.core.cst$sym$number]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$jsdoc],[new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(363),cljs.core.cst$kw$column,(3),cljs.core.cst$kw$end_DASH_line,(363),cljs.core.cst$kw$end_DASH_column,(14),cljs.core.cst$kw$jsdoc,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["@enum {string}"], null)], null),cljs.core.cst$sym$cljs$core_SLASH_DEMUNGE_MAP,"cljs/core.cljs",(14),(1),(362),(363),cljs.core.cst$sym$object,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["@enum {string}"], null)]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$num_DASH_fields,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$type,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$record,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag],[(3),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH_ES6IteratorSeq,"cljs/core.cljs",(24),true,(10),(1296),false,(1296),cljs.core.cst$sym$function,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null"], null), null)]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocols,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),"cljs/core.cljs",(20),(10),cljs.core.cst$kw$positional,(6319),(6319),cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null"], null), null),"Positional factory function for cljs.core/NeverEquiv."]),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH__DASH__GT_NeverEquiv,"cljs/core.cljs",(20),cljs.core.list(cljs.core.PersistentVector.EMPTY),null,cljs.core.list(null,null),(1),false,cljs.core.cst$kw$positional,(6319),cljs.core.cst$sym$cljs$core_SLASH_NeverEquiv,(6319),(0),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null"], null), null),"Positional factory function for cljs.core/NeverEquiv."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(10008),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(10008),cljs.core.cst$kw$end_DASH_column,(13),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$re,cljs.core.cst$sym$s], null))),cljs.core.cst$kw$doc,"Returns a lazy sequence of successive matches of re in s."], null),cljs.core.cst$sym$cljs$core_SLASH_re_DASH_seq,"cljs/core.cljs",(13),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$re,cljs.core.cst$sym$s], null)),null,cljs.core.list(null,null),(1),false,(10008),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$clj,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null),(10008),(2),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$re,cljs.core.cst$sym$s], null))),"Returns a lazy sequence of successive matches of re in s."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(270),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(270),cljs.core.cst$kw$end_DASH_column,(12),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true if x is a JavaScript string of length one."], null),cljs.core.cst$sym$cljs$core_SLASH_char_QMARK_,"cljs/core.cljs",(12),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),null,cljs.core.list(null,null),(1),false,(270),cljs.core.cst$sym$boolean,(270),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),"Returns true if x is a JavaScript string of length one."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(10839),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(10839),cljs.core.cst$kw$end_DASH_column,(21),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY)),cljs.core.cst$kw$doc,"Creates a hierarchy object for use with derive, isa? etc."], null),cljs.core.cst$sym$cljs$core_SLASH_make_DASH_hierarchy,"cljs/core.cljs",(21),cljs.core.list(cljs.core.PersistentVector.EMPTY),null,cljs.core.list(null,null),(1),false,(10839),cljs.core.cst$sym$cljs$core_SLASH_IMap,(10839),(0),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY)),"Creates a hierarchy object for use with derive, isa? etc."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$num_DASH_fields,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$type,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$record,cljs.core.cst$kw$declared,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag],[new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(952),cljs.core.cst$kw$column,(15),cljs.core.cst$kw$end_DASH_line,(952),cljs.core.cst$kw$end_DASH_column,(21),cljs.core.cst$kw$declared,true], null),(5),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_INamed,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IPrintWithWriter,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH_Symbol,"cljs/core.cljs",(16),true,(10),(1060),false,true,(1060),cljs.core.cst$sym$function,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_INamed,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IPrintWithWriter,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null)]),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_PROTOCOL_SENTINEL,cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(37),cljs.core.cst$kw$column,(1),cljs.core.cst$kw$end_DASH_line,(37),cljs.core.cst$kw$end_DASH_column,(27),cljs.core.cst$kw$meta,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(37),cljs.core.cst$kw$column,(10),cljs.core.cst$kw$end_DASH_line,(37),cljs.core.cst$kw$end_DASH_column,(27)], null),cljs.core.cst$kw$tag,cljs.core.cst$sym$object], null),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$private,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(5998),cljs.core.cst$kw$column,(8),cljs.core.cst$kw$end_DASH_line,(5998),cljs.core.cst$kw$end_DASH_column,(20),cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tv,cljs.core.cst$sym$level,cljs.core.cst$sym$parent,cljs.core.cst$sym$tail_DASH_node], null)))], null),true,cljs.core.cst$sym$cljs$core_SLASH_tv_DASH_push_DASH_tail,"cljs/core.cljs",(20),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tv,cljs.core.cst$sym$level,cljs.core.cst$sym$parent,cljs.core.cst$sym$tail_DASH_node], null)),null,cljs.core.list(null,null),(1),false,(5998),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [null,"null",cljs.core.cst$sym$cljs$core_SLASH_VectorNode,"null"], null), null),(5998),(4),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tv,cljs.core.cst$sym$level,cljs.core.cst$sym$parent,cljs.core.cst$sym$tail_DASH_node], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[cljs.core.cst$sym$cljs$core_SLASH_IReduce,"cljs/core.cljs",(11),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f,cljs.core.cst$sym$start], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f,cljs.core.cst$sym$start], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),(4),(692),(692),cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f,cljs.core.cst$sym$start], null))),"f should be a function of 2 arguments. If start is not supplied,\n     returns the result of applying f to the first 2 items in coll, then\n     applying f to that result and the 3rd item, etc."]),cljs.core.cst$sym$cljs$core_SLASH_IReduce,cljs.core.cst$sym$cljs$core_SLASH__DASH_reduce,"cljs/core.cljs",(11),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f,cljs.core.cst$sym$start], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f,cljs.core.cst$sym$start], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f,cljs.core.cst$sym$start], null)),null,(3),cljs.core.list(null,null),(1),false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$any], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$any], null)], null),(689),(692),(3),true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f,cljs.core.cst$sym$start], null)),"f should be a function of 2 arguments. If start is not supplied,\n     returns the result of applying f to the first 2 items in coll, then\n     applying f to that result and the 3rd item, etc."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$tag,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[cljs.core.cst$sym$cljs$core_SLASH_ICounted,"cljs/core.cljs",(18),(12),(572),(572),cljs.core.cst$sym$number,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),"Calculates the count of coll in constant time. Used by cljs.core/count."]),cljs.core.cst$sym$cljs$core_SLASH_ICounted,cljs.core.cst$sym$cljs$core_SLASH__DASH_count,"cljs/core.cljs",(18),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),null,cljs.core.list(null,null),(1),false,(570),cljs.core.cst$sym$number,(572),(1),cljs.core.cst$sym$number,true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),"Calculates the count of coll in constant time. Used by cljs.core/count."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$added,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$added,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],["1.9","cljs/core.cljs",(17),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(4),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(4),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null)], null),(7),(4515),(4515),cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null))),"Atomically swaps the value of atom to be:\n  (apply f current-value-of-atom args). Note that f may be called\n  multiple times, and thus should be free of side effects.\n  Returns [old new], the value of the atom before and after the swap."]),"1.9",cljs.core.cst$sym$cljs$core_SLASH_swap_DASH_vals_BANG_,"cljs/core.cljs",(17),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(4),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(4),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)),null,(4),cljs.core.list(null,null,null,null),(1),true,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core_SLASH_IVector], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core_SLASH_IVector], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(4),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core_SLASH_IVector], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(4),cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core_SLASH_IVector], null)], null),(4515),(4515),(4),true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),"Atomically swaps the value of atom to be:\n  (apply f current-value-of-atom args). Note that f may be called\n  multiple times, and thus should be free of side effects.\n  Returns [old new], the value of the atom before and after the swap."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(4380),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(4380),cljs.core.cst$kw$end_DASH_column,(11),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a lazy sequence of the non-nil results of (f item). Note,\n  this means false return values will be included.  f must be free of\n  side-effects.  Returns a transducer when no collection is provided.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_keep,"cljs/core.cljs",(11),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null)),null,(2),cljs.core.list(null,null),(1),false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$function], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core_SLASH_LazySeq], null)], null),(4380),(4380),(2),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null)),"Returns a lazy sequence of the non-nil results of (f item). Note,\n  this means false return values will be included.  f must be free of\n  side-effects.  Returns a transducer when no collection is provided."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2697),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(2697),cljs.core.cst$kw$end_DASH_column,(11),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Coerce to char"], null),cljs.core.cst$sym$cljs$core_SLASH_char,"cljs/core.cljs",(11),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),null,cljs.core.list(null,null),(1),false,(2697),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [null,"null",cljs.core.cst$sym$js_SLASH_String,"null"], null), null),(2697),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),"Coerce to char"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$added,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$static,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$added,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$static,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],["1.0","cljs/core.cljs",(13),true,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$colls], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),(7),(5137),(5137),cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$colls], null))),"Returns the result of applying concat to the result of applying map\n  to f and colls.  Thus function f should return a collection. Returns\n  a transducer when no collections are provided"]),"1.0",cljs.core.cst$sym$cljs$core_SLASH_mapcat,"cljs/core.cljs",(13),true,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$colls], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null)),null,(1),cljs.core.list(null,null),(1),true,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$function], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$tag,cljs.core.cst$sym$any], null)], null),(5137),(5137),(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$colls], null)),"Returns the result of applying concat to the result of applying map\n  to f and colls.  Thus function f should return a collection. Returns\n  a transducer when no collections are provided"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2811),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(2811),cljs.core.cst$kw$end_DASH_column,(21),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Coerce to long by stripping decimal places. Identical to `int'."], null),cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_long,"cljs/core.cljs",(21),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),null,cljs.core.list(null,null),(1),false,(2811),cljs.core.cst$sym$number,(2811),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),"Coerce to long by stripping decimal places. Identical to `int'."]),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_m3_DASH_seed,cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(910),cljs.core.cst$kw$column,(1),cljs.core.cst$kw$end_DASH_line,(910),cljs.core.cst$kw$end_DASH_column,(13),cljs.core.cst$kw$meta,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(910),cljs.core.cst$kw$column,(6),cljs.core.cst$kw$end_DASH_line,(910),cljs.core.cst$kw$end_DASH_column,(13)], null),cljs.core.cst$kw$tag,cljs.core.cst$sym$number], null),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$tag,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(254),cljs.core.cst$kw$column,(16),cljs.core.cst$kw$end_DASH_line,(254),cljs.core.cst$kw$end_DASH_column,(21),cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true if x is not nil, false otherwise."], null),cljs.core.cst$sym$cljs$core_SLASH_some_QMARK_,"cljs/core.cljs",(21),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),null,cljs.core.list(null,null),(1),false,(254),cljs.core.cst$sym$boolean,(254),(1),cljs.core.cst$sym$boolean,true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),"Returns true if x is not nil, false otherwise."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2766),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(2766),cljs.core.cst$kw$end_DASH_column,(23),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_negate,"cljs/core.cljs",(23),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),null,cljs.core.list(null,null),(1),false,(2766),cljs.core.cst$sym$number,(2766),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(11539),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(11539),cljs.core.cst$kw$end_DASH_column,(17),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null))),cljs.core.cst$kw$doc,"Remove f from the tap set."], null),cljs.core.cst$sym$cljs$core_SLASH_remove_DASH_tap,"cljs/core.cljs",(17),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null)),null,cljs.core.list(null,null),(1),false,(11539),cljs.core.cst$sym$clj_DASH_nil,(11539),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null))),"Remove f from the tap set."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(3344),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(3344),cljs.core.cst$kw$end_DASH_column,(24),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null))),cljs.core.cst$kw$doc,"Efficient test to determine that two symbols are identical."], null),cljs.core.cst$sym$cljs$core_SLASH_symbol_DASH_identical_QMARK_,"cljs/core.cljs",(24),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)),null,cljs.core.list(null,null),(1),false,(3344),cljs.core.cst$sym$boolean,(3344),(2),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null))),"Efficient test to determine that two symbols are identical."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$doc],[new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(303),cljs.core.cst$kw$column,(3),cljs.core.cst$kw$end_DASH_line,(303),cljs.core.cst$kw$end_DASH_column,(22),cljs.core.cst$kw$doc,"A sequence of the supplied command line arguments, or nil if\n  none were supplied"], null),cljs.core.cst$sym$cljs$core_SLASH__STAR_command_DASH_line_DASH_args_STAR_,"cljs/core.cljs",(22),(1),(300),(303),cljs.core.cst$sym$clj_DASH_nil,"A sequence of the supplied command line arguments, or nil if\n  none were supplied"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(3195),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(3195),cljs.core.cst$kw$end_DASH_column,(14),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a seq of the items in coll in reverse order. Not lazy."], null),cljs.core.cst$sym$cljs$core_SLASH_reverse,"cljs/core.cljs",(14),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),null,cljs.core.list(null,null),(1),false,(3195),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [null,"null",cljs.core.cst$sym$seq,"null",cljs.core.cst$sym$cljs$core_SLASH_IList,"null",cljs.core.cst$sym$any,"null"], null), null),(3195),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),"Returns a seq of the items in coll in reverse order. Not lazy."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(1392),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(1392),cljs.core.cst$kw$end_DASH_column,(12),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Return true if x satisfies Inst"], null),cljs.core.cst$sym$cljs$core_SLASH_inst_QMARK_,"cljs/core.cljs",(12),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),null,cljs.core.list(null,null),(1),false,(1392),cljs.core.cst$sym$boolean,(1392),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),"Return true if x satisfies Inst"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(9783),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(9783),cljs.core.cst$kw$end_DASH_column,(12),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$end], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$start,cljs.core.cst$sym$end], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$start,cljs.core.cst$sym$end,cljs.core.cst$sym$step], null))),cljs.core.cst$kw$doc,"Returns a lazy seq of nums from start (inclusive) to end\n   (exclusive), by step, where start defaults to 0, step to 1,\n   and end to infinity.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$end], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$start,cljs.core.cst$sym$end], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$start,cljs.core.cst$sym$end,cljs.core.cst$sym$step], null)),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$end], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$start,cljs.core.cst$sym$end], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$start,cljs.core.cst$sym$end,cljs.core.cst$sym$step], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_range,"cljs/core.cljs",(12),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$end], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$start,cljs.core.cst$sym$end], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$start,cljs.core.cst$sym$end,cljs.core.cst$sym$step], null)),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$end], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$start,cljs.core.cst$sym$end], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$start,cljs.core.cst$sym$end,cljs.core.cst$sym$step], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null)], null),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$end], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$start,cljs.core.cst$sym$end], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$start,cljs.core.cst$sym$end,cljs.core.cst$sym$step], null)),null,(3),cljs.core.list(null,null,null,null),(1),false,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$any], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$any], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$any], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$clj], null)], null),(9783),(9783),(3),true,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$end], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$start,cljs.core.cst$sym$end], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$start,cljs.core.cst$sym$end,cljs.core.cst$sym$step], null)),"Returns a lazy seq of nums from start (inclusive) to end\n   (exclusive), by step, where start defaults to 0, step to 1,\n   and end to infinity."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2911),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(2911),cljs.core.cst$kw$end_DASH_column,(16),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$v], null))),cljs.core.cst$kw$doc,"Counts the number of bits set in n"], null),cljs.core.cst$sym$cljs$core_SLASH_bit_DASH_count,"cljs/core.cljs",(16),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$v], null)),null,cljs.core.list(null,null),(1),false,(2911),cljs.core.cst$sym$number,(2911),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$v], null))),"Counts the number of bits set in n"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$private,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(7673),cljs.core.cst$kw$column,(8),cljs.core.cst$kw$end_DASH_line,(7673),cljs.core.cst$kw$end_DASH_column,(19),cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$shift,cljs.core.cst$sym$key1,cljs.core.cst$sym$val1,cljs.core.cst$sym$key2hash,cljs.core.cst$sym$key2,cljs.core.cst$sym$val2], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.cst$sym$shift,cljs.core.cst$sym$key1,cljs.core.cst$sym$val1,cljs.core.cst$sym$key2hash,cljs.core.cst$sym$key2,cljs.core.cst$sym$val2], null))),cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(7),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(7),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$shift,cljs.core.cst$sym$key1,cljs.core.cst$sym$val1,cljs.core.cst$sym$key2hash,cljs.core.cst$sym$key2,cljs.core.cst$sym$val2], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.cst$sym$shift,cljs.core.cst$sym$key1,cljs.core.cst$sym$val1,cljs.core.cst$sym$key2hash,cljs.core.cst$sym$key2,cljs.core.cst$sym$val2], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$shift,cljs.core.cst$sym$key1,cljs.core.cst$sym$val1,cljs.core.cst$sym$key2hash,cljs.core.cst$sym$key2,cljs.core.cst$sym$val2], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.cst$sym$shift,cljs.core.cst$sym$key1,cljs.core.cst$sym$val1,cljs.core.cst$sym$key2hash,cljs.core.cst$sym$key2,cljs.core.cst$sym$val2], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null),true,cljs.core.cst$sym$cljs$core_SLASH_create_DASH_node,"cljs/core.cljs",(19),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(7),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(7),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$shift,cljs.core.cst$sym$key1,cljs.core.cst$sym$val1,cljs.core.cst$sym$key2hash,cljs.core.cst$sym$key2,cljs.core.cst$sym$val2], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.cst$sym$shift,cljs.core.cst$sym$key1,cljs.core.cst$sym$val1,cljs.core.cst$sym$key2hash,cljs.core.cst$sym$key2,cljs.core.cst$sym$val2], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$shift,cljs.core.cst$sym$key1,cljs.core.cst$sym$val1,cljs.core.cst$sym$key2hash,cljs.core.cst$sym$key2,cljs.core.cst$sym$val2], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.cst$sym$shift,cljs.core.cst$sym$key1,cljs.core.cst$sym$val1,cljs.core.cst$sym$key2hash,cljs.core.cst$sym$key2,cljs.core.cst$sym$val2], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$shift,cljs.core.cst$sym$key1,cljs.core.cst$sym$val1,cljs.core.cst$sym$key2hash,cljs.core.cst$sym$key2,cljs.core.cst$sym$val2], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.cst$sym$shift,cljs.core.cst$sym$key1,cljs.core.cst$sym$val1,cljs.core.cst$sym$key2hash,cljs.core.cst$sym$key2,cljs.core.cst$sym$val2], null)),null,(7),cljs.core.list(null,null),(1),false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(6),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$any,"null",cljs.core.cst$sym$cljs$core_SLASH_HashCollisionNode,"null"], null), null)], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(7),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$any,"null",cljs.core.cst$sym$cljs$core_SLASH_HashCollisionNode,"null"], null), null)], null)], null),(7673),(7673),(7),true,cljs.core.list(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$shift,cljs.core.cst$sym$key1,cljs.core.cst$sym$val1,cljs.core.cst$sym$key2hash,cljs.core.cst$sym$key2,cljs.core.cst$sym$val2], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.cst$sym$shift,cljs.core.cst$sym$key1,cljs.core.cst$sym$val1,cljs.core.cst$sym$key2hash,cljs.core.cst$sym$key2,cljs.core.cst$sym$val2], null))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2433),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(2433),cljs.core.cst$kw$end_DASH_column,(11),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$comp,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a sorted sequence of the items in coll. Comp can be\n   boolean-valued comparison function, or a -/0/+ valued comparator.\n   Comp defaults to compare.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$comp,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$comp,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_sort,"cljs/core.cljs",(11),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$comp,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$comp,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$comp,cljs.core.cst$sym$coll], null)),null,(2),cljs.core.list(null,null),(1),false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$any], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$seq,"null",cljs.core.cst$sym$cljs$core_SLASH_IList,"null"], null), null)], null)], null),(2433),(2433),(2),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$comp,cljs.core.cst$sym$coll], null)),"Returns a sorted sequence of the items in coll. Comp can be\n   boolean-valued comparison function, or a -/0/+ valued comparator.\n   Comp defaults to compare."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocols,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_Fn,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),"cljs/core.cljs",(16),(10),cljs.core.cst$kw$positional,(2013),(2013),cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$afn,cljs.core.cst$sym$meta], null))),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),"Positional factory function for cljs.core/MetaFn."]),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_Fn,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH__DASH__GT_MetaFn,"cljs/core.cljs",(16),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$afn,cljs.core.cst$sym$meta], null)),null,cljs.core.list(null,null),(1),false,cljs.core.cst$kw$positional,(2013),cljs.core.cst$sym$cljs$core_SLASH_MetaFn,(2013),(2),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$afn,cljs.core.cst$sym$meta], null))),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),"Positional factory function for cljs.core/MetaFn."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2749),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(2749),cljs.core.cst$kw$end_DASH_column,(24),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_inc_DASH_int,"cljs/core.cljs",(24),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),null,cljs.core.list(null,null),(1),false,(2749),cljs.core.cst$sym$number,(2749),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$tag,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[cljs.core.cst$sym$cljs$core_SLASH_IComparable,"cljs/core.cljs",(20),(12),(818),(818),cljs.core.cst$sym$number,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null))),"Returns a negative number, zero, or a positive number when x is logically\n     'less than', 'equal to', or 'greater than' y."]),cljs.core.cst$sym$cljs$core_SLASH_IComparable,cljs.core.cst$sym$cljs$core_SLASH__DASH_compare,"cljs/core.cljs",(20),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)),null,cljs.core.list(null,null),(1),false,(816),cljs.core.cst$sym$number,(818),(2),cljs.core.cst$sym$number,true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null))),"Returns a negative number, zero, or a positive number when x is logically\n     'less than', 'equal to', or 'greater than' y."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(4352),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(4352),cljs.core.cst$kw$end_DASH_column,(18),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a lazy sequence consisting of the result of applying f to 0\n  and the first item of coll, followed by applying f to 1 and the second\n  item in coll, etc, until coll is exhausted. Thus function f should\n  accept 2 arguments, index and item. Returns a stateful transducer when\n  no collection is provided.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_map_DASH_indexed,"cljs/core.cljs",(18),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null)),null,(2),cljs.core.list(null,null),(1),false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$function], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false], null)], null),(4352),(4352),(2),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null)),"Returns a lazy sequence consisting of the result of applying f to 0\n  and the first item of coll, followed by applying f to 1 and the second\n  item in coll, etc, until coll is exhausted. Thus function f should\n  accept 2 arguments, index and item. Returns a stateful transducer when\n  no collection is provided."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(9546),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(9546),cljs.core.cst$kw$end_DASH_column,(17),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY))], null),cljs.core.cst$sym$cljs$core_SLASH_array_DASH_list,"cljs/core.cljs",(17),cljs.core.list(cljs.core.PersistentVector.EMPTY),null,cljs.core.list(null,null),(1),false,(9546),cljs.core.cst$sym$cljs$core_SLASH_ArrayList,(9546),(0),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(10820),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(10820),cljs.core.cst$kw$end_DASH_column,(15),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Return a random element of the (sequential) collection. Will have\n  the same performance characteristics as nth for the given\n  collection."], null),cljs.core.cst$sym$cljs$core_SLASH_rand_DASH_nth,"cljs/core.cljs",(15),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),null,cljs.core.list(null,null),(1),false,(10820),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$any,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null),(10820),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),"Return a random element of the (sequential) collection. Will have\n  the same performance characteristics as nth for the given\n  collection."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(4269),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(4269),cljs.core.cst$kw$end_DASH_column,(11),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f1,cljs.core.cst$sym$f2,cljs.core.cst$sym$f3,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$fs], null))),cljs.core.cst$kw$doc,"Takes a set of functions and returns a fn that is the composition\n  of those fns.  The returned fn takes a variable number of args,\n  applies the rightmost of fns to the args, the next\n  fn (right-to-left) to the result, etc.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h], null)),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f1,cljs.core.cst$sym$f2,cljs.core.cst$sym$f3,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$fs], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_comp,"cljs/core.cljs",(11),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h], null)),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f1,cljs.core.cst$sym$f2,cljs.core.cst$sym$f3,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$fs], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null,null)], null),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h], null)),null,(3),cljs.core.list(null,null,null,null,null),(1),true,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$variadic_QMARK_,false], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,false], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$function], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$function], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$tag,cljs.core.cst$sym$function], null)], null),(4269),(4269),(3),true,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$g,cljs.core.cst$sym$h], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f1,cljs.core.cst$sym$f2,cljs.core.cst$sym$f3,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$fs], null)),"Takes a set of functions and returns a fn that is the composition\n  of those fns.  The returned fn takes a variable number of args,\n  applies the rightmost of fns to the args, the next\n  fn (right-to-left) to the result, etc."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(3536),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(3536),cljs.core.cst$kw$end_DASH_column,(18),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$off], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$off,cljs.core.cst$sym$end], null))),cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$off], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$off,cljs.core.cst$sym$end], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$off], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$off,cljs.core.cst$sym$end], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_array_DASH_chunk,"cljs/core.cljs",(18),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$off], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$off,cljs.core.cst$sym$end], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$off], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$off,cljs.core.cst$sym$end], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$off], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$off,cljs.core.cst$sym$end], null)),null,(3),cljs.core.list(null,null,null),(1),false,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core_SLASH_ArrayChunk], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core_SLASH_ArrayChunk], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core_SLASH_ArrayChunk], null)], null),(3536),(3536),(3),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$off], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$off,cljs.core.cst$sym$end], null))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(11243),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(11243),cljs.core.cst$kw$end_DASH_column,(18),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$multifn], null))),cljs.core.cst$kw$doc,"Given a multimethod, return it's dispatch-fn."], null),cljs.core.cst$sym$cljs$core_SLASH_dispatch_DASH_fn,"cljs/core.cljs",(18),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$multifn], null)),null,cljs.core.list(null,null),(1),false,(11243),cljs.core.cst$sym$any,(11243),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$multifn], null))),"Given a multimethod, return it's dispatch-fn."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2903),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(2903),cljs.core.cst$kw$end_DASH_column,(32),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null))),cljs.core.cst$kw$doc,"DEPRECATED: Bitwise shift right with zero fill"], null),cljs.core.cst$sym$cljs$core_SLASH_bit_DASH_shift_DASH_right_DASH_zero_DASH_fill,"cljs/core.cljs",(32),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null)),null,cljs.core.list(null,null),(1),false,(2903),cljs.core.cst$sym$number,(2903),(2),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null))),"DEPRECATED: Bitwise shift right with zero fill"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$private,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(11455),cljs.core.cst$kw$column,(8),cljs.core.cst$kw$end_DASH_line,(11455),cljs.core.cst$kw$end_DASH_column,(20),cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))], null),true,cljs.core.cst$sym$cljs$core_SLASH_js_DASH_reserved_QMARK_,"cljs/core.cljs",(20),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),null,cljs.core.list(null,null),(1),false,(11455),cljs.core.cst$sym$any,(11455),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$tag,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[cljs.core.cst$sym$cljs$core_SLASH_IEditableCollection,"cljs/core.cljs",(22),(9),(783),(783),cljs.core.cst$sym$clj,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),"Returns a new, transient version of the collection, in constant time."]),cljs.core.cst$sym$cljs$core_SLASH_IEditableCollection,cljs.core.cst$sym$cljs$core_SLASH__DASH_as_DASH_transient,"cljs/core.cljs",(22),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),null,cljs.core.list(null,null),(1),false,(781),cljs.core.cst$sym$clj,(783),(1),cljs.core.cst$sym$clj,true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),"Returns a new, transient version of the collection, in constant time."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(9935),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(9935),cljs.core.cst$kw$end_DASH_column,(12),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"When lazy sequences are produced via functions that have side\n  effects, any effects other than those needed to produce the first\n  element in the seq do not occur until the seq is consumed. dorun can\n  be used to force any effects. Walks through the successive nexts of\n  the seq, does not retain the head and returns nil.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_dorun,"cljs/core.cljs",(12),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null)),null,(2),cljs.core.list(null,null),(1),false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$clj_DASH_nil], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$clj_DASH_nil], null)], null),(9935),(9935),(2),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$coll], null)),"When lazy sequences are produced via functions that have side\n  effects, any effects other than those needed to produce the first\n  element in the seq do not occur until the seq is consumed. dorun can\n  be used to force any effects. Walks through the successive nexts of\n  the seq, does not retain the head and returns nil."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(10026),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(10026),cljs.core.cst$kw$end_DASH_column,(27),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$writer,cljs.core.cst$sym$print_DASH_one,cljs.core.cst$sym$begin,cljs.core.cst$sym$sep,cljs.core.cst$sym$end,cljs.core.cst$sym$opts,cljs.core.cst$sym$coll], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_pr_DASH_sequential_DASH_writer,"cljs/core.cljs",(27),cljs.core.list(new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$writer,cljs.core.cst$sym$print_DASH_one,cljs.core.cst$sym$begin,cljs.core.cst$sym$sep,cljs.core.cst$sym$end,cljs.core.cst$sym$opts,cljs.core.cst$sym$coll], null)),null,cljs.core.list(null,null),(1),false,(10026),(10026),(7),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$writer,cljs.core.cst$sym$print_DASH_one,cljs.core.cst$sym$begin,cljs.core.cst$sym$sep,cljs.core.cst$sym$end,cljs.core.cst$sym$opts,cljs.core.cst$sym$coll], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(3372),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(3372),cljs.core.cst$kw$end_DASH_column,(21),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Return true if x is a symbol without a namespace"], null),cljs.core.cst$sym$cljs$core_SLASH_simple_DASH_symbol_QMARK_,"cljs/core.cljs",(21),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),null,cljs.core.list(null,null),(1),false,(3372),cljs.core.cst$sym$boolean,(3372),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),"Return true if x is a symbol without a namespace"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$private,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(1808),cljs.core.cst$kw$column,(8),cljs.core.cst$kw$end_DASH_line,(1808),cljs.core.cst$kw$end_DASH_column,(30),cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)))], null),true,cljs.core.cst$sym$cljs$core_SLASH_accumulating_DASH_seq_DASH_count,"cljs/core.cljs",(30),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),null,cljs.core.list(null,null),(1),false,(1808),cljs.core.cst$sym$number,(1808),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$impls,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[true,"cljs/core.cljs",(22),(14),(592),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$_DASH_nth,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n,cljs.core.cst$sym$not_DASH_found], null)], null)], null)], null),(592),"Protocol for collections to provide indexed-based access to their items.",cljs.core.list("@interface")]),true,cljs.core.cst$sym$cljs$core_SLASH_IIndexed,"cljs/core.cljs",(22),(1),(592),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$_DASH_nth,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n,cljs.core.cst$sym$not_DASH_found], null)], null)], null)], null),null,(592),cljs.core.cst$sym$any,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 10, [cljs.core.cst$sym$cljs$core_SLASH_RangeChunk,"null",cljs.core.cst$sym$cljs$core_SLASH_TransientVector,"null",cljs.core.cst$sym$cljs$core_SLASH_IndexedSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_BlackNode,"null",cljs.core.cst$sym$cljs$core_SLASH_MapEntry,"null",cljs.core.cst$sym$cljs$core_SLASH_Subvec,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentVector,"null",cljs.core.cst$sym$cljs$core_SLASH_ArrayChunk,"null",cljs.core.cst$sym$cljs$core_SLASH_Range,"null",cljs.core.cst$sym$cljs$core_SLASH_RedNode,"null"], null), null),"Protocol for collections to provide indexed-based access to their items.",cljs.core.list("@interface")]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2097),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(2097),cljs.core.cst$kw$end_DASH_column,(11),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ks], null))),cljs.core.cst$kw$doc,"disj[oin]. Returns a new set of the same (hashed/sorted) type, that\n  does not contain key(s).",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ks], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_disj,"cljs/core.cljs",(11),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ks], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k], null)),null,(2),cljs.core.list(null,null,null),(1),true,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,false], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$clj,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null)], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$clj,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null)], null)], null),(2097),(2097),(2),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$ks], null)),"disj[oin]. Returns a new set of the same (hashed/sorted) type, that\n  does not contain key(s)."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$num_DASH_fields,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$type,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$record,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag],[(1),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH_MultiIterator,"cljs/core.cljs",(23),true,(10),(4109),false,(4109),cljs.core.cst$sym$function,null]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$impls,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[true,"cljs/core.cljs",(30),(14),(757),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$_DASH_pr_DASH_writer,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$writer,cljs.core.cst$sym$opts], null)], null)], null)], null),(757),"The old IPrintable protocol's implementation consisted of building a giant\n   list of strings to concatenate.  This involved lots of concat calls,\n   intermediate vectors, and lazy-seqs, and was very slow in some older JS\n   engines.  IPrintWithWriter implements printing via the IWriter protocol, so it\n   be implemented efficiently in terms of e.g. a StringBuffer append.",cljs.core.list("@interface")]),true,cljs.core.cst$sym$cljs$core_SLASH_IPrintWithWriter,"cljs/core.cljs",(30),(1),(757),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$_DASH_pr_DASH_writer,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$writer,cljs.core.cst$sym$opts], null)], null)], null)], null),null,(757),cljs.core.cst$sym$any,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 44, [cljs.core.cst$sym$cljs$core_SLASH_PersistentHashMap,"null",cljs.core.cst$sym$cljs$core_SLASH_ObjMap,"null",cljs.core.cst$sym$cljs$core_SLASH_Cons,"null",cljs.core.cst$sym$cljs$core_SLASH_Eduction,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentArrayMap,"null",cljs.core.cst$sym$cljs$core_SLASH_NodeSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentQueue,"null",cljs.core.cst$sym$cljs$core_SLASH_IndexedSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_Volatile,"null",cljs.core.cst$sym$cljs$core_SLASH_Keyword,"null",cljs.core.cst$sym$cljs$core_SLASH_BlackNode,"null",cljs.core.cst$sym$cljs$core_SLASH_MapEntry,"null",cljs.core.cst$sym$cljs$core_SLASH_EmptyList,"null",cljs.core.cst$sym$cljs$core_SLASH_Delay,"null",cljs.core.cst$sym$cljs$core_SLASH_LazySeq,"null",cljs.core.cst$sym$cljs$core_SLASH_Subvec,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentQueueSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ExceptionInfo,"null",cljs.core.cst$sym$cljs$core_SLASH_Var,"null",cljs.core.cst$sym$cljs$core_SLASH_ArrayNodeSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ValSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_TaggedLiteral,"null",cljs.core.cst$sym$cljs$core_SLASH_Cycle,"null",cljs.core.cst$sym$cljs$tools$reader$impl$utils_SLASH_ReaderConditional,"null",cljs.core.cst$sym$cljs$core_SLASH_ES6IteratorSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentArrayMapSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentVector,"null",cljs.core.cst$sym$cljs$core_SLASH_List,"null",cljs.core.cst$sym$cljs$core_SLASH_Repeat,"null",cljs.core.cst$sym$cljs$core_SLASH_TransformerIterator,"null",cljs.core.cst$sym$cljs$core_SLASH_RSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_Iterate,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentHashSet,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentTreeMap,"null",cljs.core.cst$sym$cljs$core_SLASH_KeySeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ChunkedSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_Atom,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentTreeSet,"null",cljs.core.cst$sym$cljs$core_SLASH_ChunkedCons,"null",cljs.core.cst$sym$cljs$core_SLASH_Symbol,"null",cljs.core.cst$sym$cljs$core_SLASH_UUID,"null",cljs.core.cst$sym$cljs$core_SLASH_Range,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentTreeMapSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_RedNode,"null"], null), null),"The old IPrintable protocol's implementation consisted of building a giant\n   list of strings to concatenate.  This involved lots of concat calls,\n   intermediate vectors, and lazy-seqs, and was very slow in some older JS\n   engines.  IPrintWithWriter implements printing via the IWriter protocol, so it\n   be implemented efficiently in terms of e.g. a StringBuffer append.",cljs.core.list("@interface")]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocols,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IPrintWithWriter,"null",cljs.core.cst$sym$cljs$core_SLASH_IComparable,"null",cljs.core.cst$sym$cljs$core_SLASH_IUUID,"null"], null), null),"cljs/core.cljs",(14),(10),cljs.core.cst$kw$positional,(11250),(11250),cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$uuid,cljs.core.cst$sym$__hash], null))),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IPrintWithWriter,"null",cljs.core.cst$sym$cljs$core_SLASH_IComparable,"null"], null), null),"Positional factory function for cljs.core/UUID."]),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IPrintWithWriter,"null",cljs.core.cst$sym$cljs$core_SLASH_IComparable,"null",cljs.core.cst$sym$cljs$core_SLASH_IUUID,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH__DASH__GT_UUID,"cljs/core.cljs",(14),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$uuid,cljs.core.cst$sym$__hash], null)),null,cljs.core.list(null,null),(1),false,cljs.core.cst$kw$positional,(11250),cljs.core.cst$sym$cljs$core_SLASH_UUID,(11250),(2),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$uuid,cljs.core.cst$sym$__hash], null))),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IPrintWithWriter,"null",cljs.core.cst$sym$cljs$core_SLASH_IComparable,"null"], null), null),"Positional factory function for cljs.core/UUID."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$impls,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[true,"cljs/core.cljs",(21),(14),(666),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$_DASH_assoc_DASH_n,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n,cljs.core.cst$sym$val], null)], null)], null)], null),(666),"Protocol for adding vector functionality to collections.",cljs.core.list("@interface")]),true,cljs.core.cst$sym$cljs$core_SLASH_IVector,"cljs/core.cljs",(21),(1),(666),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$_DASH_assoc_DASH_n,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n,cljs.core.cst$sym$val], null)], null)], null)], null),null,(666),cljs.core.cst$sym$any,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$sym$cljs$core_SLASH_BlackNode,"null",cljs.core.cst$sym$cljs$core_SLASH_MapEntry,"null",cljs.core.cst$sym$cljs$core_SLASH_Subvec,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentVector,"null",cljs.core.cst$sym$cljs$core_SLASH_RedNode,"null"], null), null),"Protocol for adding vector functionality to collections.",cljs.core.list("@interface")]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$impls,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[true,"cljs/core.cljs",(23),(14),(865),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$_DASH_iterator,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)], null)], null)], null),(865),"Protocol for iterating over a collection.",cljs.core.list("@interface")]),true,cljs.core.cst$sym$cljs$core_SLASH_IIterable,"cljs/core.cljs",(23),(1),(865),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$_DASH_iterator,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)], null)], null)], null),null,(865),cljs.core.cst$sym$any,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [cljs.core.cst$sym$cljs$core_SLASH_PersistentHashMap,"null",cljs.core.cst$sym$cljs$core_SLASH_Eduction,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentArrayMap,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentQueue,"null",cljs.core.cst$sym$cljs$core_SLASH_IndexedSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_Subvec,"null",cljs.core.cst$sym$cljs$tools$reader$impl$utils_SLASH_ReaderConditional,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentVector,"null",cljs.core.cst$sym$cljs$core_SLASH_ArrayNode,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentHashSet,"null",cljs.core.cst$sym$cljs$core_SLASH_HashCollisionNode,"null",cljs.core.cst$sym$cljs$core_SLASH_Range,"null",cljs.core.cst$sym$cljs$core_SLASH_BitmapIndexedNode,"null"], null), null),"Protocol for iterating over a collection.",cljs.core.list("@interface")]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocols,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),"cljs/core.cljs",(23),(10),cljs.core.cst$kw$positional,(4109),(4109),cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$iters], null))),null,"Positional factory function for cljs.core/MultiIterator."]),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH__DASH__GT_MultiIterator,"cljs/core.cljs",(23),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$iters], null)),null,cljs.core.list(null,null),(1),false,cljs.core.cst$kw$positional,(4109),cljs.core.cst$sym$cljs$core_SLASH_MultiIterator,(4109),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$iters], null))),null,"Positional factory function for cljs.core/MultiIterator."]),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH__STAR_2,cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(203),cljs.core.cst$kw$column,(1),cljs.core.cst$kw$end_DASH_line,(205),cljs.core.cst$kw$end_DASH_column,(5),cljs.core.cst$kw$doc,"bound in a repl thread to the second most recent value printed",cljs.core.cst$kw$meta,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(205),cljs.core.cst$kw$column,(3),cljs.core.cst$kw$end_DASH_line,(205),cljs.core.cst$kw$end_DASH_column,(5),cljs.core.cst$kw$doc,"bound in a repl thread to the second most recent value printed"], null)], null),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(11717),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(11717),cljs.core.cst$kw$end_DASH_column,(11),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$form], null))),cljs.core.cst$kw$doc,"Evaluates the form data structure (not text!) and returns the result.\n  Delegates to cljs.core/*eval*. Intended for use in self-hosted ClojureScript,\n  which sets up an implementation of cljs.core/*eval* for that environment."], null),cljs.core.cst$sym$cljs$core_SLASH_eval,"cljs/core.cljs",(11),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$form], null)),null,cljs.core.list(null,null),(1),false,(11717),cljs.core.cst$sym$ignore,(11717),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$form], null))),"Evaluates the form data structure (not text!) and returns the result.\n  Delegates to cljs.core/*eval*. Intended for use in self-hosted ClojureScript,\n  which sets up an implementation of cljs.core/*eval* for that environment."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$num_DASH_fields,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$type,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$record,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag],[(2),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IPrintWithWriter,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH_Eduction,"cljs/core.cljs",(18),true,(10),(10649),false,(10649),cljs.core.cst$sym$function,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IPrintWithWriter,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null)]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$private,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(5354),cljs.core.cst$kw$column,(8),cljs.core.cst$kw$end_DASH_line,(5354),cljs.core.cst$kw$end_DASH_column,(21),cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$node], null)))], null),true,cljs.core.cst$sym$cljs$core_SLASH_pv_DASH_clone_DASH_node,"cljs/core.cljs",(21),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$node], null)),null,cljs.core.list(null,null),(1),false,(5354),cljs.core.cst$sym$cljs$core_SLASH_VectorNode,(5354),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$node], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(3279),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(3279),cljs.core.cst$kw$end_DASH_column,(11),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a new seq where x is the first element and coll is the rest."], null),cljs.core.cst$sym$cljs$core_SLASH_cons,"cljs/core.cljs",(11),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$coll], null)),null,cljs.core.list(null,null),(1),false,(3279),cljs.core.cst$sym$clj,(3279),(2),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$coll], null))),"Returns a new seq where x is the first element and coll is the rest."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$num_DASH_fields,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$type,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$record,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag],[(3),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, [cljs.core.cst$sym$cljs$core_SLASH_IReversible,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_ISet,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISorted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH_PersistentTreeSet,"cljs/core.cljs",(27),true,(10),(9304),false,(9304),cljs.core.cst$sym$function,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [cljs.core.cst$sym$cljs$core_SLASH_IReversible,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISet,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISorted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null)]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocols,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),"cljs/core.cljs",(21),(10),cljs.core.cst$kw$positional,(9133),(9133),cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$iter], null))),null,"Positional factory function for cljs.core/HashSetIter."]),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH__DASH__GT_HashSetIter,"cljs/core.cljs",(21),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$iter], null)),null,cljs.core.list(null,null),(1),false,cljs.core.cst$kw$positional,(9133),cljs.core.cst$sym$cljs$core_SLASH_HashSetIter,(9133),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$iter], null))),null,"Positional factory function for cljs.core/HashSetIter."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$private,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(11560),cljs.core.cst$kw$column,(8),cljs.core.cst$kw$end_DASH_line,(11560),cljs.core.cst$kw$end_DASH_column,(17),cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ns_DASH_obj,cljs.core.cst$sym$k], null))),cljs.core.cst$kw$doc,"Bootstrap only."], null),true,cljs.core.cst$sym$cljs$core_SLASH_ns_DASH_lookup,"cljs/core.cljs",(17),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ns_DASH_obj,cljs.core.cst$sym$k], null)),null,cljs.core.list(null,null),(1),false,(11560),cljs.core.cst$sym$function,(11560),(2),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ns_DASH_obj,cljs.core.cst$sym$k], null))),"Bootstrap only."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2821),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(2821),cljs.core.cst$kw$end_DASH_column,(13),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_floats,"cljs/core.cljs",(13),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),null,cljs.core.list(null,null),(1),false,(2821),(2821),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$num_DASH_fields,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$type,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$record,cljs.core.cst$kw$declared,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag],[new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(5475),cljs.core.cst$kw$column,(44),cljs.core.cst$kw$end_DASH_line,(5475),cljs.core.cst$kw$end_DASH_column,(59),cljs.core.cst$kw$declared,true], null),(4),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$sym$cljs$core_SLASH_IIndexed,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ITransientCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ITransientVector,"null",cljs.core.cst$sym$cljs$core_SLASH_ITransientAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH_TransientVector,"cljs/core.cljs",(25),true,(10),(6040),false,true,(6040),cljs.core.cst$sym$function,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$sym$cljs$core_SLASH_IIndexed,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ITransientCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ITransientVector,"null",cljs.core.cst$sym$cljs$core_SLASH_ITransientAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null)]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$tag,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2931),cljs.core.cst$kw$column,(16),cljs.core.cst$kw$end_DASH_line,(2931),cljs.core.cst$kw$end_DASH_column,(20),cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true if num is greater than zero, else false"], null),cljs.core.cst$sym$cljs$core_SLASH_pos_QMARK_,"cljs/core.cljs",(20),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),null,cljs.core.list(null,null),(1),false,(2931),cljs.core.cst$sym$boolean,(2931),(1),cljs.core.cst$sym$boolean,true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),"Returns true if num is greater than zero, else false"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(4327),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(4327),cljs.core.cst$kw$end_DASH_column,(11),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$z], null))),cljs.core.cst$kw$doc,"Takes a function f, and returns a function that calls f, replacing\n  a nil first argument to f with the supplied value x. Higher arity\n  versions can replace arguments in the second and third\n  positions (y, z). Note that the function f can take any number of\n  arguments, not just the one(s) being nil-patched.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(4),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(4),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$z], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$z], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_fnil,"cljs/core.cljs",(11),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(4),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(4),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$z], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$z], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$z], null)),null,(4),cljs.core.list(null,null,null),(1),false,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$function], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$function], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(4),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$function], null)], null),(4327),(4327),(4),true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$z], null)),"Takes a function f, and returns a function that calls f, replacing\n  a nil first argument to f with the supplied value x. Higher arity\n  versions can replace arguments in the second and third\n  positions (y, z). Note that the function f can take any number of\n  arguments, not just the one(s) being nil-patched."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(9099),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(9099),cljs.core.cst$kw$end_DASH_column,(17),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$maps], null))),cljs.core.cst$kw$doc,"Returns a map that consists of the rest of the maps conj-ed onto\n  the first.  If a key occurs in more than one map, the mapping(s)\n  from the latter (left-to-right) will be combined with the mapping in\n  the result by calling (f val-in-result val-in-latter).",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$f,cljs.core.cst$sym$maps)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$maps], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_merge_DASH_with,"cljs/core.cljs",(17),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$f,cljs.core.cst$sym$maps)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$maps], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$f,cljs.core.cst$sym$maps)], null),null,(1),cljs.core.list(null),(1),true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [null,"null",cljs.core.cst$sym$any,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null)], null)], null),(9099),cljs.core.cst$sym$any,(9099),(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$maps], null)),"Returns a map that consists of the rest of the maps conj-ed onto\n  the first.  If a key occurs in more than one map, the mapping(s)\n  from the latter (left-to-right) will be combined with the mapping in\n  the result by calling (f val-in-result val-in-latter)."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(1927),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(1927),cljs.core.cst$kw$end_DASH_column,(14),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n], null))),cljs.core.cst$kw$doc,"Returns the nth rest of coll, coll when n is 0."], null),cljs.core.cst$sym$cljs$core_SLASH_nthrest,"cljs/core.cljs",(14),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n], null)),null,cljs.core.list(null,null),(1),false,(1927),(1927),(2),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n], null))),"Returns the nth rest of coll, coll when n is 0."]),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH__STAR_warn_DASH_on_DASH_infer_STAR_,cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(33),cljs.core.cst$kw$column,(1),cljs.core.cst$kw$end_DASH_line,(33),cljs.core.cst$kw$end_DASH_column,(21),cljs.core.cst$kw$meta,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(33),cljs.core.cst$kw$column,(6),cljs.core.cst$kw$end_DASH_line,(33),cljs.core.cst$kw$end_DASH_column,(21)], null),cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean], null),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(636),cljs.core.cst$kw$column,(4),cljs.core.cst$kw$end_DASH_line,(636),cljs.core.cst$kw$end_DASH_column,(9),cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IFind,cljs.core.cst$kw$doc,"Returns the map entry for key, or nil if key not present.",cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_IFind,cljs.core.cst$sym$cljs$core_SLASH__DASH_find,"cljs/core.cljs",(9),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k], null)),null,cljs.core.list(null,null),(1),false,(634),cljs.core.cst$sym$any,(636),(2),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k], null))),"Returns the map entry for key, or nil if key not present."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2139),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(2139),cljs.core.cst$kw$end_DASH_column,(18),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true if coll satisfies ISequential"], null),cljs.core.cst$sym$cljs$core_SLASH_sequential_QMARK_,"cljs/core.cljs",(18),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),null,cljs.core.list(null,null),(1),false,(2139),cljs.core.cst$sym$boolean,(2139),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),"Returns true if coll satisfies ISequential"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$private,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(8717),cljs.core.cst$kw$column,(8),cljs.core.cst$kw$end_DASH_line,(8717),cljs.core.cst$kw$end_DASH_column,(24),cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$comp,cljs.core.cst$sym$tree,cljs.core.cst$sym$k,cljs.core.cst$sym$v], null)))], null),true,cljs.core.cst$sym$cljs$core_SLASH_tree_DASH_map_DASH_replace,"cljs/core.cljs",(24),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$comp,cljs.core.cst$sym$tree,cljs.core.cst$sym$k,cljs.core.cst$sym$v], null)),null,cljs.core.list(null,null),(1),false,(8717),cljs.core.cst$sym$any,(8717),(4),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$comp,cljs.core.cst$sym$tree,cljs.core.cst$sym$k,cljs.core.cst$sym$v], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$private,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(488),cljs.core.cst$kw$column,(8),cljs.core.cst$kw$end_DASH_line,(488),cljs.core.cst$kw$end_DASH_column,(21),cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$val], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$idx2,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$idxv], null))),cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$val], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$val], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$idx2,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$idxv], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null),true,cljs.core.cst$sym$cljs$core_SLASH_checked_DASH_aset_SINGLEQUOTE_,"cljs/core.cljs",(21),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$val], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$val], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$idx2,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$idxv], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$val], null)),null,(3),cljs.core.list(null,null),(1),true,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$any], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$tag,cljs.core.cst$sym$any], null)], null),(488),(488),(3),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$val], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$idx,cljs.core.cst$sym$idx2,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$idxv], null))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$tag,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(917),cljs.core.cst$kw$column,(15),cljs.core.cst$kw$end_DASH_line,(917),cljs.core.cst$kw$end_DASH_column,(24),cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$h1,cljs.core.cst$sym$k1], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_m3_DASH_mix_DASH_H1,"cljs/core.cljs",(24),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$h1,cljs.core.cst$sym$k1], null)),null,cljs.core.list(null,null),(1),false,(917),cljs.core.cst$sym$number,(917),(2),cljs.core.cst$sym$number,true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$h1,cljs.core.cst$sym$k1], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$num_DASH_fields,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$type,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$record,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag],[(5),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH_RecordIter,"cljs/core.cljs",(20),true,(10),(6514),false,(6514),cljs.core.cst$sym$function,null]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocols,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ITransientMap,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ITransientCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ITransientAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null),"cljs/core.cljs",(27),(10),cljs.core.cst$kw$positional,(7034),(7034),cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$editable_QMARK_,cljs.core.cst$sym$len,cljs.core.cst$sym$arr], null))),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ITransientMap,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ITransientCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ITransientAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null),"Positional factory function for cljs.core/TransientArrayMap."]),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ITransientMap,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ITransientCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ITransientAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH__DASH__GT_TransientArrayMap,"cljs/core.cljs",(27),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$editable_QMARK_,cljs.core.cst$sym$len,cljs.core.cst$sym$arr], null)),null,cljs.core.list(null,null),(1),false,cljs.core.cst$kw$positional,(7034),cljs.core.cst$sym$cljs$core_SLASH_TransientArrayMap,(7034),(3),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$editable_QMARK_,cljs.core.cst$sym$len,cljs.core.cst$sym$arr], null))),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ITransientMap,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ITransientCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ITransientAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null),"Positional factory function for cljs.core/TransientArrayMap."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$private,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(9995),cljs.core.cst$kw$column,(8),cljs.core.cst$kw$end_DASH_line,(9995),cljs.core.cst$kw$end_DASH_column,(15),cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$re,cljs.core.cst$sym$s], null)))], null),true,cljs.core.cst$sym$cljs$core_SLASH_re_DASH_seq_STAR_,"cljs/core.cljs",(15),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$re,cljs.core.cst$sym$s], null)),null,cljs.core.list(null,null),(1),false,(9995),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$clj,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null),(9995),(2),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$re,cljs.core.cst$sym$s], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(1661),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(1661),cljs.core.cst$kw$end_DASH_column,(15),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$prim], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$prim,cljs.core.cst$sym$i], null))),cljs.core.cst$kw$doc,"Create seq from a primitive JavaScript Array-like.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$prim], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$prim,cljs.core.cst$sym$i], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$prim], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$prim,cljs.core.cst$sym$i], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_prim_DASH_seq,"cljs/core.cljs",(15),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$prim], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$prim,cljs.core.cst$sym$i], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$prim], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$prim,cljs.core.cst$sym$i], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$prim], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$prim,cljs.core.cst$sym$i], null)),null,(2),cljs.core.list(null,null),(1),false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$any], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_IndexedSeq,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null)], null)], null),(1661),(1661),(2),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$prim], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$prim,cljs.core.cst$sym$i], null)),"Create seq from a primitive JavaScript Array-like."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$dynamic,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(163),cljs.core.cst$kw$column,(3),cljs.core.cst$kw$end_DASH_line,(163),cljs.core.cst$kw$end_DASH_column,(16),cljs.core.cst$kw$dynamic,true,cljs.core.cst$kw$doc,"*print-level* controls how many levels deep the printer will\n  print nested objects. If it is bound to logical false, there is no\n  limit. Otherwise, it must be bound to an integer indicating the maximum\n  level to print. Each argument to print is at level 0; if an argument is a\n  collection, its items are at level 1; and so on. If an object is a\n  collection and is at a level greater than or equal to the value bound to\n  *print-level*, the printer prints '#' to represent it. The root binding\n  is nil indicating no limit.",cljs.core.cst$kw$jsdoc,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["@type {null|number}"], null)], null),cljs.core.cst$sym$cljs$core_SLASH__STAR_print_DASH_level_STAR_,"cljs/core.cljs",(16),(1),true,(152),(163),cljs.core.cst$sym$clj_DASH_nil,"*print-level* controls how many levels deep the printer will\n  print nested objects. If it is bound to logical false, there is no\n  limit. Otherwise, it must be bound to an integer indicating the maximum\n  level to print. Each argument to print is at level 0; if an argument is a\n  collection, its items are at level 1; and so on. If an object is a\n  collection and is at a level greater than or equal to the value bound to\n  *print-level*, the printer prints '#' to represent it. The root binding\n  is nil indicating no limit.",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["@type {null|number}"], null)]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2474),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(2474),cljs.core.cst$kw$end_DASH_column,(14),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Return a random permutation of coll"], null),cljs.core.cst$sym$cljs$core_SLASH_shuffle,"cljs/core.cljs",(14),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),null,cljs.core.list(null,null),(1),false,(2474),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$sym$clj,"null",cljs.core.cst$sym$cljs$core_SLASH_IVector,"null",cljs.core.cst$sym$any,"null",cljs.core.cst$sym$cljs$core_SLASH_MetaFn,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null),(2474),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),"Return a random permutation of coll"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$num_DASH_fields,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$type,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$record,cljs.core.cst$kw$declared,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag],[new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2167),cljs.core.cst$kw$column,(22),cljs.core.cst$kw$end_DASH_line,(2167),cljs.core.cst$kw$end_DASH_column,(32),cljs.core.cst$kw$declared,true], null),(6),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ASeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IChunkedNext,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IChunkedSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH_ChunkedSeq,"cljs/core.cljs",(20),true,(10),(5729),false,true,(5729),cljs.core.cst$sym$function,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ASeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IChunkedNext,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IChunkedSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null)]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(3287),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(3287),cljs.core.cst$kw$end_DASH_column,(19),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_hash_DASH_keyword,"cljs/core.cljs",(19),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k], null)),null,cljs.core.list(null,null),(1),false,(3287),cljs.core.cst$sym$number,(3287),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2347),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(2347),cljs.core.cst$kw$end_DASH_column,(11),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k], null))),cljs.core.cst$kw$doc,"Returns the map entry for key, or nil if key not present."], null),cljs.core.cst$sym$cljs$core_SLASH_find,"cljs/core.cljs",(11),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k], null)),null,cljs.core.list(null,null),(1),false,(2347),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$sym$any,"null",cljs.core.cst$sym$cljs$core_SLASH_MapEntry,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null),(2347),(2),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$k], null))),"Returns the map entry for key, or nil if key not present."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$tag,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(511),cljs.core.cst$kw$column,(15),cljs.core.cst$kw$end_DASH_line,(511),cljs.core.cst$kw$end_DASH_column,(22),cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array], null))),cljs.core.cst$kw$doc,"Returns the length of the array. Works on arrays of all types."], null),cljs.core.cst$sym$cljs$core_SLASH_alength,"cljs/core.cljs",(22),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array], null)),null,cljs.core.list(null,null),(1),false,(511),cljs.core.cst$sym$number,(511),(1),cljs.core.cst$sym$number,true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array], null))),"Returns the length of the array. Works on arrays of all types."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2847),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(2847),cljs.core.cst$kw$end_DASH_column,(14),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null))),cljs.core.cst$kw$doc,"Bitwise exclusive or",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_bit_DASH_xor,"cljs/core.cljs",(14),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)),null,(2),cljs.core.list(null,null),(1),true,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$number], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [null,"null",cljs.core.cst$sym$any,"null"], null), null)], null)], null),(2847),(2847),(2),true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),"Bitwise exclusive or"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocols,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [cljs.core.cst$sym$cljs$core_SLASH_IIndexed,"null",cljs.core.cst$sym$cljs$core_SLASH_IReversible,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ASeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),"cljs/core.cljs",(20),(10),cljs.core.cst$kw$positional,(1571),(1571),cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$i,cljs.core.cst$sym$meta], null))),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 17, [cljs.core.cst$sym$cljs$core_SLASH_IIndexed,"null",cljs.core.cst$sym$cljs$core_SLASH_IReversible,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ASeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),"Positional factory function for cljs.core/IndexedSeq."]),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [cljs.core.cst$sym$cljs$core_SLASH_IIndexed,"null",cljs.core.cst$sym$cljs$core_SLASH_IReversible,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ASeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH__DASH__GT_IndexedSeq,"cljs/core.cljs",(20),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$i,cljs.core.cst$sym$meta], null)),null,cljs.core.list(null,null),(1),false,cljs.core.cst$kw$positional,(1571),cljs.core.cst$sym$cljs$core_SLASH_IndexedSeq,(1571),(3),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$i,cljs.core.cst$sym$meta], null))),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 17, [cljs.core.cst$sym$cljs$core_SLASH_IIndexed,"null",cljs.core.cst$sym$cljs$core_SLASH_IReversible,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ASeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),"Positional factory function for cljs.core/IndexedSeq."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$num_DASH_fields,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$type,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$record,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag],[(5),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 16, [cljs.core.cst$sym$cljs$core_SLASH_IKVReduce,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEditableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IFind,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_IMap,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH_ObjMap,"cljs/core.cljs",(16),true,(10),(6394),false,(6394),cljs.core.cst$sym$function,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [cljs.core.cst$sym$cljs$core_SLASH_IKVReduce,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEditableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IAssociative,"null",cljs.core.cst$sym$cljs$core_SLASH_IMap,"null",cljs.core.cst$sym$cljs$core_SLASH_ILookup,"null"], null), null)]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2907),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(2907),cljs.core.cst$kw$end_DASH_column,(31),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null))),cljs.core.cst$kw$doc,"Bitwise shift right with zero fill"], null),cljs.core.cst$sym$cljs$core_SLASH_unsigned_DASH_bit_DASH_shift_DASH_right,"cljs/core.cljs",(31),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null)),null,cljs.core.list(null,null),(1),false,(2907),cljs.core.cst$sym$number,(2907),(2),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$n], null))),"Bitwise shift right with zero fill"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$num_DASH_fields,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$type,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$record,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag],[(1),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH_ES6SetEntriesIterator,"cljs/core.cljs",(31),true,(10),(6540),false,(6540),cljs.core.cst$sym$function,null]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$tag,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2940),cljs.core.cst$kw$column,(16),cljs.core.cst$kw$end_DASH_line,(2940),cljs.core.cst$kw$end_DASH_column,(20),cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true if num is less than zero, else false"], null),cljs.core.cst$sym$cljs$core_SLASH_neg_QMARK_,"cljs/core.cljs",(20),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),null,cljs.core.list(null,null),(1),false,(2940),cljs.core.cst$sym$boolean,(2940),(1),cljs.core.cst$sym$boolean,true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),"Returns true if num is less than zero, else false"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$num_DASH_fields,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$type,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$record,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag],[(4),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, [cljs.core.cst$sym$cljs$core_SLASH_IList,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ASeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH_Cons,"cljs/core.cljs",(14),true,(10),(3219),false,(3219),cljs.core.cst$sym$function,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [cljs.core.cst$sym$cljs$core_SLASH_IList,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ASeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null)]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(11014),cljs.core.cst$kw$column,(4),cljs.core.cst$kw$end_DASH_line,(11014),cljs.core.cst$kw$end_DASH_column,(18),cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IMultiFn,cljs.core.cst$kw$doc,null,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$mf,cljs.core.cst$sym$dispatch_DASH_val], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_IMultiFn,cljs.core.cst$sym$cljs$core_SLASH__DASH_remove_DASH_method,"cljs/core.cljs",(18),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$mf,cljs.core.cst$sym$dispatch_DASH_val], null)),null,cljs.core.list(null,null),(1),false,(11011),cljs.core.cst$sym$any,(11014),(2),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$mf,cljs.core.cst$sym$dispatch_DASH_val], null))),null]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocols,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),"cljs/core.cljs",(20),(10),cljs.core.cst$kw$positional,(4006),(4006),cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s,cljs.core.cst$sym$i], null))),null,"Positional factory function for cljs.core/StringIter."]),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH__DASH__GT_StringIter,"cljs/core.cljs",(20),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s,cljs.core.cst$sym$i], null)),null,cljs.core.list(null,null),(1),false,cljs.core.cst$kw$positional,(4006),cljs.core.cst$sym$cljs$core_SLASH_StringIter,(4006),(2),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s,cljs.core.cst$sym$i], null))),null,"Positional factory function for cljs.core/StringIter."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(526),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(526),cljs.core.cst$kw$end_DASH_column,(16),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$s,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null))),cljs.core.cst$kw$doc,"Invoke JavaScript object method via string. Needed when the\n  string is not a valid unquoted property name.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$obj,cljs.core.cst$sym$s,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$s,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_js_DASH_invoke,"cljs/core.cljs",(16),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$obj,cljs.core.cst$sym$s,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$s,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$obj,cljs.core.cst$sym$s,cljs.core.cst$sym$args)], null),null,(2),cljs.core.list(null),(1),true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$tag,cljs.core.cst$sym$any], null)], null),(526),cljs.core.cst$sym$any,(526),(2),true,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$s,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Invoke JavaScript object method via string. Needed when the\n  string is not a valid unquoted property name."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocols,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 17, [cljs.core.cst$sym$cljs$core_SLASH_IList,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ASeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IStack,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),"cljs/core.cljs",(14),(10),cljs.core.cst$kw$positional,(3036),(3036),cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$first,cljs.core.cst$sym$rest,cljs.core.cst$sym$count,cljs.core.cst$sym$__hash], null))),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 16, [cljs.core.cst$sym$cljs$core_SLASH_IList,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ASeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IStack,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),"Positional factory function for cljs.core/List."]),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 17, [cljs.core.cst$sym$cljs$core_SLASH_IList,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ASeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IStack,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH__DASH__GT_List,"cljs/core.cljs",(14),cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$first,cljs.core.cst$sym$rest,cljs.core.cst$sym$count,cljs.core.cst$sym$__hash], null)),null,cljs.core.list(null,null),(1),false,cljs.core.cst$kw$positional,(3036),cljs.core.cst$sym$cljs$core_SLASH_List,(3036),(5),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$first,cljs.core.cst$sym$rest,cljs.core.cst$sym$count,cljs.core.cst$sym$__hash], null))),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 16, [cljs.core.cst$sym$cljs$core_SLASH_IList,"null",cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ASeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_IStack,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),"Positional factory function for cljs.core/List."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$tag,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(914),cljs.core.cst$kw$column,(15),cljs.core.cst$kw$end_DASH_line,(914),cljs.core.cst$kw$end_DASH_column,(24),cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k1], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_m3_DASH_mix_DASH_K1,"cljs/core.cljs",(24),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k1], null)),null,cljs.core.list(null,null),(1),false,(914),cljs.core.cst$sym$number,(914),(1),cljs.core.cst$sym$number,true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k1], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$num_DASH_fields,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$type,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$record,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag],[(5),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IPending,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH_Iterate,"cljs/core.cljs",(17),true,(10),(5021),false,(5021),cljs.core.cst$sym$function,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 10, [cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IPending,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null)]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$tag,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2712),cljs.core.cst$kw$column,(15),cljs.core.cst$kw$end_DASH_line,(2712),cljs.core.cst$kw$end_DASH_column,(30),cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_float,"cljs/core.cljs",(30),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),null,cljs.core.list(null,null),(1),false,(2712),cljs.core.cst$sym$number,(2712),(1),cljs.core.cst$sym$number,true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$tag,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2225),cljs.core.cst$kw$column,(16),cljs.core.cst$kw$end_DASH_line,(2225),cljs.core.cst$kw$end_DASH_column,(26),cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true if x identical to the JavaScript undefined value."], null),cljs.core.cst$sym$cljs$core_SLASH_undefined_QMARK_,"cljs/core.cljs",(26),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),null,cljs.core.list(null,null),(1),false,(2225),cljs.core.cst$sym$boolean,(2225),(1),cljs.core.cst$sym$boolean,true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),"Returns true if x identical to the JavaScript undefined value."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$num_DASH_fields,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$type,cljs.core.cst$kw$anonymous,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$record,cljs.core.cst$kw$tag,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag],[(1),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH_t_cljs$core11184,"cljs/core.cljs",true,true,(3),(4000),false,cljs.core.cst$sym$function,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null)]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$impls,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[true,"cljs/core.cljs",(19),(14),(679),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$_DASH_meta,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o], null)], null)], null)], null),(679),"Protocol for accessing the metadata of an object.",cljs.core.list("@interface")]),true,cljs.core.cst$sym$cljs$core_SLASH_IMeta,"cljs/core.cljs",(19),(1),(679),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$_DASH_meta,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o], null)], null)], null)], null),null,(679),cljs.core.cst$sym$any,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 51, [cljs.core.cst$sym$cljs$spec$alpha_SLASH_t_cljs$spec$alpha102819,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentHashMap,"null",cljs.core.cst$sym$cljs$core_SLASH_ObjMap,"null",cljs.core.cst$sym$cljs$spec$alpha_SLASH_t_cljs$spec$alpha102460,"null",cljs.core.cst$sym$cljs$core_SLASH_Cons,"null",cljs.core.cst$sym$cljs$spec$alpha_SLASH_t_cljs$spec$alpha102401,"null",cljs.core.cst$sym$cljs$spec$alpha_SLASH_t_cljs$spec$alpha102581,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentArrayMap,"null",cljs.core.cst$sym$cljs$core_SLASH_NodeSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_t_cljs$core11184,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentQueue,"null",cljs.core.cst$sym$cljs$core_SLASH_IndexedSeq,"null",cljs.core.cst$sym$cljs$analyzer_SLASH_t_cljs$analyzer98335,"null",cljs.core.cst$sym$cljs$core_SLASH_BlackNode,"null",cljs.core.cst$sym$cljs$core_SLASH_MapEntry,"null",cljs.core.cst$sym$cljs$core_SLASH_EmptyList,"null",cljs.core.cst$sym$cljs$core_SLASH_LazySeq,"null",cljs.core.cst$sym$cljs$core_SLASH_Subvec,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentQueueSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_Var,"null",cljs.core.cst$sym$cljs$core_SLASH_ArrayNodeSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ValSeq,"null",cljs.core.cst$sym$cljs$spec$alpha_SLASH_t_cljs$spec$alpha102497,"null",cljs.core.cst$sym$cljs$core_SLASH_Cycle,"null",cljs.core.cst$sym$cljs$tools$reader$impl$utils_SLASH_ReaderConditional,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentArrayMapSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentVector,"null",cljs.core.cst$sym$cljs$spec$alpha_SLASH_t_cljs$spec$alpha102569,"null",cljs.core.cst$sym$cljs$core_SLASH_List,"null",cljs.core.cst$sym$cljs$core_SLASH_Repeat,"null",cljs.core.cst$sym$cljs$core_SLASH_RSeq,"null",cljs.core.cst$sym$cljs$spec$alpha_SLASH_t_cljs$spec$alpha102826,"null",cljs.core.cst$sym$cljs$spec$alpha_SLASH_t_cljs$spec$alpha102488,"null",cljs.core.cst$sym$cljs$core_SLASH_Iterate,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentHashSet,"null",cljs.core.cst$sym$cljs$spec$alpha_SLASH_t_cljs$spec$alpha102851,"null",cljs.core.cst$sym$function,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentTreeMap,"null",cljs.core.cst$sym$cljs$spec$alpha_SLASH_t_cljs$spec$alpha102474,"null",cljs.core.cst$sym$cljs$core_SLASH_KeySeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ChunkedSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_Atom,"null",cljs.core.cst$sym$cljs$spec$alpha_SLASH_t_cljs$spec$alpha102555,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentTreeSet,"null",cljs.core.cst$sym$cljs$core_SLASH_ChunkedCons,"null",cljs.core.cst$sym$cljs$core_SLASH_Symbol,"null",cljs.core.cst$sym$cljs$spec$alpha_SLASH_t_cljs$spec$alpha102855,"null",cljs.core.cst$sym$cljs$core_SLASH_MetaFn,"null",cljs.core.cst$sym$cljs$core_SLASH_Range,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentTreeMapSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_RedNode,"null"], null), null),"Protocol for accessing the metadata of an object.",cljs.core.list("@interface")]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(1429),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(1429),cljs.core.cst$kw$end_DASH_column,(15),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$r], null))),cljs.core.cst$kw$doc,"Returns true if x is the result of a call to reduced"], null),cljs.core.cst$sym$cljs$core_SLASH_reduced_QMARK_,"cljs/core.cljs",(15),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$r], null)),null,cljs.core.list(null,null),(1),false,(1429),cljs.core.cst$sym$boolean,(1429),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$r], null))),"Returns true if x is the result of a call to reduced"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$argc,cljs.core.cst$sym$args], null))),cljs.core.cst$kw$file,"cljs/core.cljs"], null),cljs.core.cst$sym$cljs$core_SLASH_apply_DASH_to,"cljs/core.cljs",cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$argc,cljs.core.cst$sym$args], null)),null,cljs.core.list(null,null),(1),false,(3877),cljs.core.cst$sym$any,(3),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$argc,cljs.core.cst$sym$args], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(3862),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(3862),cljs.core.cst$kw$end_DASH_column,(12),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$val], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$val,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$vals], null))),cljs.core.cst$kw$doc,"disj[oin]. Returns a transient set of the same (hashed/sorted) type, that\n  does not contain key(s).",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$val], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$val], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$val,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$vals], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_disj_BANG_,"cljs/core.cljs",(12),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$val], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$val], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$val,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$vals], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$val], null)),null,(2),cljs.core.list(null,null),(1),true,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$clj], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$tag,cljs.core.cst$sym$clj], null)], null),(3862),(3862),(2),true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$val], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$val,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$vals], null)),"disj[oin]. Returns a transient set of the same (hashed/sorted) type, that\n  does not contain key(s)."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[cljs.core.cst$sym$cljs$core_SLASH_ILookup,"cljs/core.cljs",(11),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$k,cljs.core.cst$sym$not_DASH_found], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$k,cljs.core.cst$sym$not_DASH_found], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),(4),(621),(621),cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$k,cljs.core.cst$sym$not_DASH_found], null))),"Use k to look up a value in o. If not-found is supplied and k is not\n     a valid value that can be used for look up, not-found is returned."]),cljs.core.cst$sym$cljs$core_SLASH_ILookup,cljs.core.cst$sym$cljs$core_SLASH__DASH_lookup,"cljs/core.cljs",(11),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$k,cljs.core.cst$sym$not_DASH_found], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$k,cljs.core.cst$sym$not_DASH_found], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$k,cljs.core.cst$sym$not_DASH_found], null)),null,(3),cljs.core.list(null,null),(1),false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$any], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$any], null)], null),(619),(621),(3),true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$k,cljs.core.cst$sym$not_DASH_found], null)),"Use k to look up a value in o. If not-found is supplied and k is not\n     a valid value that can be used for look up, not-found is returned."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2320),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(2320),cljs.core.cst$kw$end_DASH_column,(13),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true for JavaScript numbers, false otherwise."], null),cljs.core.cst$sym$cljs$core_SLASH_float_QMARK_,"cljs/core.cljs",(13),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),null,cljs.core.list(null,null),(1),false,(2320),cljs.core.cst$sym$boolean,(2320),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),"Returns true for JavaScript numbers, false otherwise."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$impls,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[true,"cljs/core.cljs",(24),(14),(565),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$_DASH_clone,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$value], null)], null)], null)], null),(565),"Protocol for cloning a value.",cljs.core.list("@interface")]),true,cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"cljs/core.cljs",(24),(1),(565),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$_DASH_clone,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$value], null)], null)], null)], null),null,(565),cljs.core.cst$sym$any,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, [cljs.core.cst$sym$cljs$core_SLASH_PersistentHashMap,"null",cljs.core.cst$sym$cljs$core_SLASH_Cons,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentArrayMap,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentQueue,"null",cljs.core.cst$sym$cljs$core_SLASH_IndexedSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_EmptyList,"null",cljs.core.cst$sym$cljs$core_SLASH_Subvec,"null",cljs.core.cst$sym$cljs$tools$reader$impl$utils_SLASH_ReaderConditional,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentVector,"null",cljs.core.cst$sym$cljs$core_SLASH_List,"null",cljs.core.cst$sym$cljs$core_SLASH_RSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentHashSet,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentTreeMap,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentTreeSet,"null",cljs.core.cst$sym$cljs$core_SLASH_Range,"null"], null), null),"Protocol for cloning a value.",cljs.core.list("@interface")]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$impls,cljs.core.cst$kw$jsdoc],[new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(10741),cljs.core.cst$kw$column,(14),cljs.core.cst$kw$end_DASH_line,(10741),cljs.core.cst$kw$end_DASH_column,(28),cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$jsdoc,cljs.core.list("@interface"),cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$_DASH_js_DASH__GT_clj,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$options], null)], null)], null)], null)], null),true,cljs.core.cst$sym$cljs$core_SLASH_IEncodeClojure,"cljs/core.cljs",(28),(1),(10741),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$_DASH_js_DASH__GT_clj,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$options], null)], null)], null)], null),null,(10741),cljs.core.cst$sym$any,cljs.core.PersistentHashSet.EMPTY,cljs.core.list("@interface")]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2816),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(2816),cljs.core.cst$kw$end_DASH_column,(15),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_booleans,"cljs/core.cljs",(15),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),null,cljs.core.list(null,null),(1),false,(2816),(2816),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocols,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),"cljs/core.cljs",(19),(10),cljs.core.cst$kw$positional,(9538),(9538),cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr], null))),null,"Positional factory function for cljs.core/ArrayList."]),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH__DASH__GT_ArrayList,"cljs/core.cljs",(19),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr], null)),null,cljs.core.list(null,null),(1),false,cljs.core.cst$kw$positional,(9538),cljs.core.cst$sym$cljs$core_SLASH_ArrayList,(9538),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr], null))),null,"Positional factory function for cljs.core/ArrayList."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$num_DASH_fields,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$type,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$record,cljs.core.cst$kw$declared,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag],[new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(1518),cljs.core.cst$kw$column,(40),cljs.core.cst$kw$end_DASH_line,(1518),cljs.core.cst$kw$end_DASH_column,(44),cljs.core.cst$kw$declared,true], null),(3),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH_RSeq,"cljs/core.cljs",(14),true,(10),(1678),false,true,(1678),cljs.core.cst$sym$function,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [cljs.core.cst$sym$cljs$core_SLASH_IEquiv,"null",cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_ICollection,"null",cljs.core.cst$sym$cljs$core_SLASH_IEmptyableCollection,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeq,"null",cljs.core.cst$sym$cljs$core_SLASH_INext,"null",cljs.core.cst$sym$cljs$core_SLASH_ISeqable,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_ICloneable,"null",cljs.core.cst$sym$cljs$core_SLASH_ISequential,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IReduce,"null"], null), null)]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$private,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(7135),cljs.core.cst$kw$column,(8),cljs.core.cst$kw$end_DASH_line,(7135),cljs.core.cst$kw$end_DASH_column,(12),cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$hash,cljs.core.cst$sym$shift], null)))], null),true,cljs.core.cst$sym$cljs$core_SLASH_mask,"cljs/core.cljs",(12),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$hash,cljs.core.cst$sym$shift], null)),null,cljs.core.list(null,null),(1),false,(7135),cljs.core.cst$sym$number,(7135),(2),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$hash,cljs.core.cst$sym$shift], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(3662),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(3662),cljs.core.cst$kw$end_DASH_column,(16),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size_DASH_or_DASH_seq], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size,cljs.core.cst$sym$init_DASH_val_DASH_or_DASH_seq], null))),cljs.core.cst$kw$doc,"Creates an array of ints. Does not coerce array, provided for compatibility\n  with Clojure.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size_DASH_or_DASH_seq], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size,cljs.core.cst$sym$init_DASH_val_DASH_or_DASH_seq], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size_DASH_or_DASH_seq], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size,cljs.core.cst$sym$init_DASH_val_DASH_or_DASH_seq], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_int_DASH_array,"cljs/core.cljs",(16),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size_DASH_or_DASH_seq], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size,cljs.core.cst$sym$init_DASH_val_DASH_or_DASH_seq], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size_DASH_or_DASH_seq], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size,cljs.core.cst$sym$init_DASH_val_DASH_or_DASH_seq], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size_DASH_or_DASH_seq], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size,cljs.core.cst$sym$init_DASH_val_DASH_or_DASH_seq], null)),null,(2),cljs.core.list(null,null),(1),false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$any,"null",cljs.core.cst$sym$array,"null"], null), null)], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$array], null)], null),(3662),(3662),(2),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size_DASH_or_DASH_seq], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$size,cljs.core.cst$sym$init_DASH_val_DASH_or_DASH_seq], null)),"Creates an array of ints. Does not coerce array, provided for compatibility\n  with Clojure."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$private,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(10983),cljs.core.cst$kw$column,(8),cljs.core.cst$kw$end_DASH_line,(10983),cljs.core.cst$kw$end_DASH_column,(34),cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name,cljs.core.cst$sym$dispatch_DASH_val,cljs.core.cst$sym$hierarchy,cljs.core.cst$sym$method_DASH_table,cljs.core.cst$sym$prefer_DASH_table,cljs.core.cst$sym$method_DASH_cache,cljs.core.cst$sym$cached_DASH_hierarchy,cljs.core.cst$sym$default_DASH_dispatch_DASH_val], null)))], null),true,cljs.core.cst$sym$cljs$core_SLASH_find_DASH_and_DASH_cache_DASH_best_DASH_method,"cljs/core.cljs",(34),cljs.core.list(new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name,cljs.core.cst$sym$dispatch_DASH_val,cljs.core.cst$sym$hierarchy,cljs.core.cst$sym$method_DASH_table,cljs.core.cst$sym$prefer_DASH_table,cljs.core.cst$sym$method_DASH_cache,cljs.core.cst$sym$cached_DASH_hierarchy,cljs.core.cst$sym$default_DASH_dispatch_DASH_val], null)),null,cljs.core.list(null,null),(1),false,(10983),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$any,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null),(10983),(8),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name,cljs.core.cst$sym$dispatch_DASH_val,cljs.core.cst$sym$hierarchy,cljs.core.cst$sym$method_DASH_table,cljs.core.cst$sym$prefer_DASH_table,cljs.core.cst$sym$method_DASH_cache,cljs.core.cst$sym$cached_DASH_hierarchy,cljs.core.cst$sym$default_DASH_dispatch_DASH_val], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2124),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(2124),cljs.core.cst$kw$end_DASH_column,(11),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true if x satisfies ISet"], null),cljs.core.cst$sym$cljs$core_SLASH_set_QMARK_,"cljs/core.cljs",(11),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),null,cljs.core.list(null,null),(1),false,(2124),cljs.core.cst$sym$boolean,(2124),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),"Returns true if x satisfies ISet"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(1190),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(1190),cljs.core.cst$kw$end_DASH_column,(16),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Return true if x implements IIterable protocol."], null),cljs.core.cst$sym$cljs$core_SLASH_iterable_QMARK_,"cljs/core.cljs",(16),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),null,cljs.core.list(null,null),(1),false,(1190),cljs.core.cst$sym$boolean,(1190),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),"Return true if x implements IIterable protocol."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$added,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(10586),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(10586),cljs.core.cst$kw$end_DASH_column,(10),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$rf], null))),cljs.core.cst$kw$doc,"A transducer which concatenates the contents of each input, which must be a\n  collection, into the reduction.",cljs.core.cst$kw$added,"1.7"], null),"1.7",cljs.core.cst$sym$cljs$core_SLASH_cat,"cljs/core.cljs",(10),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$rf], null)),null,cljs.core.list(null,null),(1),false,(10586),cljs.core.cst$sym$function,(10586),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$rf], null))),"A transducer which concatenates the contents of each input, which must be a\n  collection, into the reduction."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocols,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),"cljs/core.cljs",(28),(10),cljs.core.cst$kw$positional,(6527),(6527),cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null))),null,"Positional factory function for cljs.core/ES6EntriesIterator."]),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH__DASH__GT_ES6EntriesIterator,"cljs/core.cljs",(28),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null)),null,cljs.core.list(null,null),(1),false,cljs.core.cst$kw$positional,(6527),cljs.core.cst$sym$cljs$core_SLASH_ES6EntriesIterator,(6527),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null))),null,"Positional factory function for cljs.core/ES6EntriesIterator."]),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_divide,cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2620),cljs.core.cst$kw$column,(1),cljs.core.cst$kw$end_DASH_line,(2620),cljs.core.cst$kw$end_DASH_column,(16),cljs.core.cst$kw$declared,true,cljs.core.cst$kw$meta,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2620),cljs.core.cst$kw$column,(10),cljs.core.cst$kw$end_DASH_line,(2620),cljs.core.cst$kw$end_DASH_column,(16),cljs.core.cst$kw$declared,true], null)], null),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$private,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$jsdoc],[new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(11436),cljs.core.cst$kw$column,(3),cljs.core.cst$kw$end_DASH_line,(11436),cljs.core.cst$kw$end_DASH_column,(18),cljs.core.cst$kw$private,true,cljs.core.cst$kw$jsdoc,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["@type {*}"], null)], null),true,cljs.core.cst$sym$cljs$core_SLASH_js_DASH_reserved_DASH_arr,"cljs/core.cljs",(18),(1),(11433),(11436),cljs.core.cst$sym$array,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["@type {*}"], null)]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(763),cljs.core.cst$kw$column,(4),cljs.core.cst$kw$end_DASH_line,(763),cljs.core.cst$kw$end_DASH_column,(14),cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IPrintWithWriter,cljs.core.cst$kw$doc,null,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$writer,cljs.core.cst$sym$opts], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_IPrintWithWriter,cljs.core.cst$sym$cljs$core_SLASH__DASH_pr_DASH_writer,"cljs/core.cljs",(14),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$writer,cljs.core.cst$sym$opts], null)),null,cljs.core.list(null,null),(1),false,(757),cljs.core.cst$sym$any,(763),(3),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$writer,cljs.core.cst$sym$opts], null))),null]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(10059),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(10059),cljs.core.cst$kw$end_DASH_column,(12),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY))], null),cljs.core.cst$sym$cljs$core_SLASH_flush,"cljs/core.cljs",(12),cljs.core.list(cljs.core.PersistentVector.EMPTY),null,cljs.core.list(null,null),(1),false,(10059),cljs.core.cst$sym$clj_DASH_nil,(10059),(0),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(9405),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(9405),cljs.core.cst$kw$end_DASH_column,(27),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$iseq], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_set_DASH_from_DASH_indexed_DASH_seq,"cljs/core.cljs",(27),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$iseq], null)),null,cljs.core.list(null,null),(1),false,(9405),cljs.core.cst$sym$clj,(9405),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$iseq], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$private,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(11527),cljs.core.cst$kw$column,(8),cljs.core.cst$kw$end_DASH_line,(11527),cljs.core.cst$kw$end_DASH_column,(25),cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY))], null),true,cljs.core.cst$sym$cljs$core_SLASH_maybe_DASH_init_DASH_tapset,"cljs/core.cljs",(25),cljs.core.list(cljs.core.PersistentVector.EMPTY),null,cljs.core.list(null,null),(1),false,(11527),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [null,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null),(11527),(0),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(9580),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(9580),cljs.core.cst$kw$end_DASH_column,(17),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a lazy sequence of successive items from coll while\n  (pred item) returns logical true. pred must be free of side-effects.\n  Returns a transducer when no collection is provided.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_take_DASH_while,"cljs/core.cljs",(17),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$coll], null)),null,(2),cljs.core.list(null,null),(1),false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$function], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core_SLASH_LazySeq], null)], null),(9580),(9580),(2),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$coll], null)),"Returns a lazy sequence of successive items from coll while\n  (pred item) returns logical true. pred must be free of side-effects.\n  Returns a transducer when no collection is provided."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(3972),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(3972),cljs.core.cst$kw$end_DASH_column,(16),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null))),cljs.core.cst$kw$doc,"Returns an object of the same type and value as obj, with\n  (apply f (meta obj) args) as its metadata.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(6),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(6),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null,null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_vary_DASH_meta,"cljs/core.cljs",(16),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(6),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(6),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null,null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d], null)),null,(6),cljs.core.list(null,null,null,null,null,null),(1),true,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$sym$clj,"null",cljs.core.cst$sym$cljs$core_SLASH_MetaFn,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null)], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$sym$clj,"null",cljs.core.cst$sym$cljs$core_SLASH_MetaFn,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null)], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(4),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$sym$clj,"null",cljs.core.cst$sym$cljs$core_SLASH_MetaFn,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null)], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(5),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$sym$clj,"null",cljs.core.cst$sym$cljs$core_SLASH_MetaFn,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null)], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(6),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$sym$clj,"null",cljs.core.cst$sym$cljs$core_SLASH_MetaFn,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null)], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(6),cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$sym$clj,"null",cljs.core.cst$sym$cljs$core_SLASH_MetaFn,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null)], null)], null),(3972),(3972),(6),true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$c,cljs.core.cst$sym$d,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns an object of the same type and value as obj, with\n  (apply f (meta obj) args) as its metadata."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$impls,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[true,"cljs/core.cljs",(19),(14),(611),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$_DASH_next,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)], null)], null)], null),(611),"Protocol for accessing the next items of a collection.",cljs.core.list("@interface")]),true,cljs.core.cst$sym$cljs$core_SLASH_INext,"cljs/core.cljs",(19),(1),(611),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$_DASH_next,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)], null)], null)], null),null,(611),cljs.core.cst$sym$any,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 19, [cljs.core.cst$sym$cljs$core_SLASH_Cons,"null",cljs.core.cst$sym$cljs$core_SLASH_NodeSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_IndexedSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_EmptyList,"null",cljs.core.cst$sym$cljs$core_SLASH_LazySeq,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentQueueSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ArrayNodeSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ValSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_Cycle,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentArrayMapSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_List,"null",cljs.core.cst$sym$cljs$core_SLASH_Repeat,"null",cljs.core.cst$sym$cljs$core_SLASH_RSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_Iterate,"null",cljs.core.cst$sym$cljs$core_SLASH_KeySeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ChunkedSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ChunkedCons,"null",cljs.core.cst$sym$cljs$core_SLASH_Range,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentTreeMapSeq,"null"], null), null),"Protocol for accessing the next items of a collection.",cljs.core.list("@interface")]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(290),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(290),cljs.core.cst$kw$end_DASH_column,(16),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_is_proto_,"cljs/core.cljs",(16),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),null,cljs.core.list(null,null),(1),false,(290),cljs.core.cst$sym$boolean,(290),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))]),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_START,cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(4031),cljs.core.cst$kw$column,(1),cljs.core.cst$kw$end_DASH_line,(4031),cljs.core.cst$kw$end_DASH_column,(11),cljs.core.cst$kw$meta,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(4031),cljs.core.cst$kw$column,(6),cljs.core.cst$kw$end_DASH_line,(4031),cljs.core.cst$kw$end_DASH_column,(11)], null),cljs.core.cst$kw$tag,cljs.core.cst$sym$object], null),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$impls,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[true,"cljs/core.cljs",(22),(14),(570),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$_DASH_count,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)], null)], null)], null),(570),"Protocol for adding the ability to count a collection in constant time.",cljs.core.list("@interface")]),true,cljs.core.cst$sym$cljs$core_SLASH_ICounted,"cljs/core.cljs",(22),(1),(570),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$_DASH_count,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)], null)], null)], null),null,(570),cljs.core.cst$sym$any,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 28, [null,"null",cljs.core.cst$sym$cljs$core_SLASH_RangeChunk,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentHashMap,"null",cljs.core.cst$sym$cljs$core_SLASH_ObjMap,"null",cljs.core.cst$sym$cljs$core_SLASH_TransientVector,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentArrayMap,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentQueue,"null",cljs.core.cst$sym$cljs$core_SLASH_IndexedSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_BlackNode,"null",cljs.core.cst$sym$cljs$core_SLASH_MapEntry,"null",cljs.core.cst$sym$cljs$core_SLASH_EmptyList,"null",cljs.core.cst$sym$cljs$core_SLASH_Subvec,"null",cljs.core.cst$sym$cljs$core_SLASH_TransientHashMap,"null",cljs.core.cst$sym$cljs$core_SLASH_ChunkBuffer,"null",cljs.core.cst$sym$cljs$tools$reader$impl$utils_SLASH_ReaderConditional,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentArrayMapSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentVector,"null",cljs.core.cst$sym$cljs$core_SLASH_List,"null",cljs.core.cst$sym$cljs$core_SLASH_TransientArrayMap,"null",cljs.core.cst$sym$cljs$core_SLASH_RSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_TransientHashSet,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentHashSet,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentTreeMap,"null",cljs.core.cst$sym$cljs$core_SLASH_ArrayChunk,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentTreeSet,"null",cljs.core.cst$sym$cljs$core_SLASH_Range,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentTreeMapSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_RedNode,"null"], null), null),"Protocol for adding the ability to count a collection in constant time.",cljs.core.list("@interface")]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$impls,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[true,"cljs/core.cljs",(23),(14),(644),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$_DASH_key,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)], null),cljs.core.cst$sym$_DASH_val,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)], null)], null)], null),(644),"Protocol for examining a map entry.",cljs.core.list("@interface")]),true,cljs.core.cst$sym$cljs$core_SLASH_IMapEntry,"cljs/core.cljs",(23),(1),(644),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$_DASH_key,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)], null),cljs.core.cst$sym$_DASH_val,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)], null)], null)], null),null,(644),cljs.core.cst$sym$any,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$sym$cljs$core_SLASH_BlackNode,"null",cljs.core.cst$sym$cljs$core_SLASH_MapEntry,"null",cljs.core.cst$sym$cljs$core_SLASH_RedNode,"null"], null), null),"Protocol for examining a map entry.",cljs.core.list("@interface")]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$private,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(5459),cljs.core.cst$kw$column,(8),cljs.core.cst$kw$end_DASH_line,(5459),cljs.core.cst$kw$end_DASH_column,(17),cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pv,cljs.core.cst$sym$f,cljs.core.cst$sym$start,cljs.core.cst$sym$end], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pv,cljs.core.cst$sym$f,cljs.core.cst$sym$init,cljs.core.cst$sym$start,cljs.core.cst$sym$end], null))),cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(5),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(5),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pv,cljs.core.cst$sym$f,cljs.core.cst$sym$start,cljs.core.cst$sym$end], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pv,cljs.core.cst$sym$f,cljs.core.cst$sym$init,cljs.core.cst$sym$start,cljs.core.cst$sym$end], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pv,cljs.core.cst$sym$f,cljs.core.cst$sym$start,cljs.core.cst$sym$end], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pv,cljs.core.cst$sym$f,cljs.core.cst$sym$init,cljs.core.cst$sym$start,cljs.core.cst$sym$end], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null),true,cljs.core.cst$sym$cljs$core_SLASH_pv_DASH_reduce,"cljs/core.cljs",(17),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(5),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(5),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pv,cljs.core.cst$sym$f,cljs.core.cst$sym$start,cljs.core.cst$sym$end], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pv,cljs.core.cst$sym$f,cljs.core.cst$sym$init,cljs.core.cst$sym$start,cljs.core.cst$sym$end], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pv,cljs.core.cst$sym$f,cljs.core.cst$sym$start,cljs.core.cst$sym$end], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pv,cljs.core.cst$sym$f,cljs.core.cst$sym$init,cljs.core.cst$sym$start,cljs.core.cst$sym$end], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pv,cljs.core.cst$sym$f,cljs.core.cst$sym$start,cljs.core.cst$sym$end], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pv,cljs.core.cst$sym$f,cljs.core.cst$sym$init,cljs.core.cst$sym$start,cljs.core.cst$sym$end], null)),null,(5),cljs.core.list(null,null),(1),false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(4),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$any], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(5),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [null,"null",cljs.core.cst$sym$any,"null"], null), null)], null)], null),(5459),(5459),(5),true,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pv,cljs.core.cst$sym$f,cljs.core.cst$sym$start,cljs.core.cst$sym$end], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pv,cljs.core.cst$sym$f,cljs.core.cst$sym$init,cljs.core.cst$sym$start,cljs.core.cst$sym$end], null))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$tag,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],["cljs/core.cljs",(18),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null),(16),(2641),(2641),cljs.core.cst$sym$boolean,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null))),"Returns non-nil if nums are in monotonically non-decreasing order,\n  otherwise false."]),cljs.core.cst$sym$cljs$core_SLASH__LT__EQ_,"cljs/core.cljs",(18),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)),null,(2),cljs.core.list(null,null,null),(1),true,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean], null)], null),(2641),cljs.core.cst$sym$boolean,(2641),(2),cljs.core.cst$sym$boolean,true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),"Returns non-nil if nums are in monotonically non-decreasing order,\n  otherwise false."]),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_MODULE_INFOS,cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(40),cljs.core.cst$kw$column,(1),cljs.core.cst$kw$end_DASH_line,(40),cljs.core.cst$kw$end_DASH_column,(18),cljs.core.cst$kw$meta,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(40),cljs.core.cst$kw$column,(6),cljs.core.cst$kw$end_DASH_line,(40),cljs.core.cst$kw$end_DASH_column,(18)], null),cljs.core.cst$kw$tag,cljs.core.cst$sym$clj_DASH_nil], null),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(3821),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(3821),cljs.core.cst$kw$end_DASH_column,(12),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$val], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$val,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$vals], null))),cljs.core.cst$kw$doc,"Adds val to the transient collection, and return tcoll. The 'addition'\n  may happen at different 'places' depending on the concrete type.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$val], null)),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$val], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$val,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$vals], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_conj_BANG_,"cljs/core.cljs",(12),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$val], null)),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$val], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$val,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$vals], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null)], null),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$val], null)),null,(2),cljs.core.list(null,null,null,null),(1),true,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$clj], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,false], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$clj], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$tag,cljs.core.cst$sym$clj], null)], null),(3821),(3821),(2),true,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$val], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll,cljs.core.cst$sym$val,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$vals], null)),"Adds val to the transient collection, and return tcoll. The 'addition'\n  may happen at different 'places' depending on the concrete type."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$tag,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[cljs.core.cst$sym$cljs$core_SLASH_IStack,"cljs/core.cljs",(13),(9),(662),(662),cljs.core.cst$sym$clj,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),"Returns a new stack without the item on top of the stack. Is used\n     by cljs.core/pop."]),cljs.core.cst$sym$cljs$core_SLASH_IStack,cljs.core.cst$sym$cljs$core_SLASH__DASH_pop,"cljs/core.cljs",(13),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),null,cljs.core.list(null,null),(1),false,(656),cljs.core.cst$sym$clj,(662),(1),cljs.core.cst$sym$clj,true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),"Returns a new stack without the item on top of the stack. Is used\n     by cljs.core/pop."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$private,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(6582),cljs.core.cst$kw$column,(8),cljs.core.cst$kw$end_DASH_line,(6582),cljs.core.cst$kw$end_DASH_column,(33),cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$k], null)))], null),true,cljs.core.cst$sym$cljs$core_SLASH_array_DASH_index_DASH_of_DASH_identical_QMARK_,"cljs/core.cljs",(33),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$k], null)),null,cljs.core.list(null,null),(1),false,(6582),cljs.core.cst$sym$number,(6582),(2),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$k], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(5012),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(5012),cljs.core.cst$kw$end_DASH_column,(17),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$f], null))),cljs.core.cst$kw$doc,"Takes a function of no args, presumably with side effects, and\n  returns an infinite (or length n if supplied) lazy sequence of calls\n  to it",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$f], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$f], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_repeatedly,"cljs/core.cljs",(17),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$f], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$f], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$f], null)),null,(2),cljs.core.list(null,null),(1),false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core_SLASH_LazySeq], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core_SLASH_LazySeq], null)], null),(5012),(5012),(2),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$n,cljs.core.cst$sym$f], null)),"Takes a function of no args, presumably with side effects, and\n  returns an infinite (or length n if supplied) lazy sequence of calls\n  to it"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(9508),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(9508),cljs.core.cst$kw$end_DASH_column,(13),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$keys,cljs.core.cst$sym$vals], null))),cljs.core.cst$kw$doc,"Returns a map with the keys mapped to the corresponding vals."], null),cljs.core.cst$sym$cljs$core_SLASH_zipmap,"cljs/core.cljs",(13),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$keys,cljs.core.cst$sym$vals], null)),null,cljs.core.list(null,null),(1),false,(9508),cljs.core.cst$sym$clj,(9508),(2),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$keys,cljs.core.cst$sym$vals], null))),"Returns a map with the keys mapped to the corresponding vals."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$added,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(4478),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(4478),cljs.core.cst$kw$end_DASH_column,(18),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$new_DASH_value], null))),cljs.core.cst$kw$doc,"Sets the value of atom to newval. Returns [old new], the value of the\n   atom before and after the reset.",cljs.core.cst$kw$added,"1.9"], null),"1.9",cljs.core.cst$sym$cljs$core_SLASH_reset_DASH_vals_BANG_,"cljs/core.cljs",(18),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$new_DASH_value], null)),null,cljs.core.list(null,null),(1),false,(4478),cljs.core.cst$sym$cljs$core_SLASH_IVector,(4478),(2),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$new_DASH_value], null))),"Sets the value of atom to newval. Returns [old new], the value of the\n   atom before and after the reset."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$impls,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[true,"cljs/core.cljs",(20),(14),(656),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$_DASH_peek,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)], null),cljs.core.cst$sym$_DASH_pop,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)], null)], null)], null),(656),"Protocol for collections to provide access to their items as stacks. The top\n  of the stack should be accessed in the most efficient way for the different\n  data structures.",cljs.core.list("@interface")]),true,cljs.core.cst$sym$cljs$core_SLASH_IStack,"cljs/core.cljs",(20),(1),(656),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$_DASH_peek,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)], null),cljs.core.cst$sym$_DASH_pop,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)], null)], null)], null),null,(656),cljs.core.cst$sym$any,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$sym$cljs$core_SLASH_PersistentQueue,"null",cljs.core.cst$sym$cljs$core_SLASH_BlackNode,"null",cljs.core.cst$sym$cljs$core_SLASH_MapEntry,"null",cljs.core.cst$sym$cljs$core_SLASH_EmptyList,"null",cljs.core.cst$sym$cljs$core_SLASH_Subvec,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentVector,"null",cljs.core.cst$sym$cljs$core_SLASH_List,"null",cljs.core.cst$sym$cljs$core_SLASH_RedNode,"null"], null), null),"Protocol for collections to provide access to their items as stacks. The top\n  of the stack should be accessed in the most efficient way for the different\n  data structures.",cljs.core.list("@interface")]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(778),cljs.core.cst$kw$column,(4),cljs.core.cst$kw$end_DASH_line,(778),cljs.core.cst$kw$end_DASH_column,(17),cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IWatchable,cljs.core.cst$kw$doc,"Removes watcher that corresponds to key from this.",cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$key], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_IWatchable,cljs.core.cst$sym$cljs$core_SLASH__DASH_remove_DASH_watch,"cljs/core.cljs",(17),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$key], null)),null,cljs.core.list(null,null),(1),false,(771),cljs.core.cst$sym$any,(778),(2),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$key], null))),"Removes watcher that corresponds to key from this."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$impls,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[true,"cljs/core.cljs",(23),(14),(859),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$_DASH_vreset_BANG_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$new_DASH_value], null)], null)], null)], null),(859),"Protocol for adding volatile functionality.",cljs.core.list("@interface")]),true,cljs.core.cst$sym$cljs$core_SLASH_IVolatile,"cljs/core.cljs",(23),(1),(859),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$_DASH_vreset_BANG_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$new_DASH_value], null)], null)], null)], null),null,(859),cljs.core.cst$sym$any,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Volatile,"null"], null), null),"Protocol for adding volatile functionality.",cljs.core.list("@interface")]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(5176),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(5176),cljs.core.cst$kw$end_DASH_column,(13),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns a lazy sequence of the items in coll for which\n  (pred item) returns logical false. pred must be free of side-effects.\n  Returns a transducer when no collection is provided.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_remove,"cljs/core.cljs",(13),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$coll], null)),null,(2),cljs.core.list(null,null),(1),false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$function], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core_SLASH_LazySeq], null)], null),(5176),(5176),(2),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$coll], null)),"Returns a lazy sequence of the items in coll for which\n  (pred item) returns logical false. pred must be free of side-effects.\n  Returns a transducer when no collection is provided."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocols,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null"], null), null),"cljs/core.cljs",(27),(10),cljs.core.cst$kw$positional,(7226),(7226),cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.cst$sym$bitmap,cljs.core.cst$sym$arr], null))),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null"], null), null),"Positional factory function for cljs.core/BitmapIndexedNode."]),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH__DASH__GT_BitmapIndexedNode,"cljs/core.cljs",(27),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.cst$sym$bitmap,cljs.core.cst$sym$arr], null)),null,cljs.core.list(null,null),(1),false,cljs.core.cst$kw$positional,(7226),cljs.core.cst$sym$cljs$core_SLASH_BitmapIndexedNode,(7226),(3),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.cst$sym$bitmap,cljs.core.cst$sym$arr], null))),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_IIterable,"null"], null), null),"Positional factory function for cljs.core/BitmapIndexedNode."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$anonymous,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$anonymous,true,cljs.core.cst$kw$protocols,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),cljs.core.cst$kw$factory,cljs.core.cst$kw$positional,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta11185], null))),cljs.core.cst$kw$doc,"Positional factory function for cljs.core/t_cljs$core11184.",cljs.core.cst$kw$file,"cljs/core.cljs"], null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH__DASH__GT_t_cljs$core11184,"cljs/core.cljs",cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta11185], null)),null,cljs.core.list(null,null),true,(3),false,cljs.core.cst$kw$positional,(4000),cljs.core.cst$sym$cljs$core_SLASH_t_cljs$core11184,(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta11185], null))),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_IMeta,"null",cljs.core.cst$sym$cljs$core_SLASH_IWithMeta,"null"], null), null),"Positional factory function for cljs.core/t_cljs$core11184."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$tag,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],["cljs/core.cljs",(16),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null)], null),(15),(2613),(2613),cljs.core.cst$sym$number,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null))),"Returns the product of nums. (*) returns 1."]),cljs.core.cst$sym$cljs$core_SLASH__STAR_,"cljs/core.cljs",(16),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null)], null),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)),null,(2),cljs.core.list(null,null,null,null),(1),true,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$number], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,false], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$number], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [null,"null",cljs.core.cst$sym$any,"null"], null), null)], null)], null),(2613),cljs.core.cst$sym$number,(2613),(2),cljs.core.cst$sym$number,true,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),"Returns the product of nums. (*) returns 1."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(10015),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(10015),cljs.core.cst$kw$end_DASH_column,(17),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null))),cljs.core.cst$kw$doc,"Returns an instance of RegExp which has compiled the provided string."], null),cljs.core.cst$sym$cljs$core_SLASH_re_DASH_pattern,"cljs/core.cljs",(17),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null)),null,cljs.core.list(null,null),(1),false,(10015),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [null,"null",cljs.core.cst$sym$js_SLASH_RegExp,"null"], null), null),(10015),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s], null))),"Returns an instance of RegExp which has compiled the provided string."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$tag,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],["cljs/core.cljs",(18),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null),(15),(2688),(2688),cljs.core.cst$sym$number,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null))),"Returns the least of the nums."]),cljs.core.cst$sym$cljs$core_SLASH_min,"cljs/core.cljs",(18),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)),null,(2),cljs.core.list(null,null,null),(1),true,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,false], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$any], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [null,"null",cljs.core.cst$sym$any,"null"], null), null)], null)], null),(2688),cljs.core.cst$sym$number,(2688),(2),cljs.core.cst$sym$number,true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),"Returns the least of the nums."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$private,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(6554),cljs.core.cst$kw$column,(8),cljs.core.cst$kw$end_DASH_line,(6554),cljs.core.cst$kw$end_DASH_column,(27),cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr], null)))], null),true,cljs.core.cst$sym$cljs$core_SLASH_array_DASH_index_DASH_of_DASH_nil_QMARK_,"cljs/core.cljs",(27),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr], null)),null,cljs.core.list(null,null),(1),false,(6554),cljs.core.cst$sym$number,(6554),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$tag,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[cljs.core.cst$sym$cljs$core_SLASH_ITransientCollection,"cljs/core.cljs",(21),(9),(790),(790),cljs.core.cst$sym$clj,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll], null))),"Creates a persistent data structure from tcoll and returns it."]),cljs.core.cst$sym$cljs$core_SLASH_ITransientCollection,cljs.core.cst$sym$cljs$core_SLASH__DASH_persistent_BANG_,"cljs/core.cljs",(21),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll], null)),null,cljs.core.list(null,null),(1),false,(786),cljs.core.cst$sym$clj,(790),(1),cljs.core.cst$sym$clj,true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll], null))),"Creates a persistent data structure from tcoll and returns it."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[cljs.core.cst$sym$cljs$core_SLASH_IIndexed,"cljs/core.cljs",(8),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n,cljs.core.cst$sym$not_DASH_found], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n,cljs.core.cst$sym$not_DASH_found], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),(4),(594),(594),cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n,cljs.core.cst$sym$not_DASH_found], null))),"Returns the value at the index n in the collection coll.\n     Returns not-found if index n is out of bounds and not-found is supplied."]),cljs.core.cst$sym$cljs$core_SLASH_IIndexed,cljs.core.cst$sym$cljs$core_SLASH__DASH_nth,"cljs/core.cljs",(8),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n,cljs.core.cst$sym$not_DASH_found], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n,cljs.core.cst$sym$not_DASH_found], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n,cljs.core.cst$sym$not_DASH_found], null)),null,(3),cljs.core.list(null,null),(1),false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$any], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$any], null)], null),(592),(594),(3),true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$n,cljs.core.cst$sym$not_DASH_found], null)),"Returns the value at the index n in the collection coll.\n     Returns not-found if index n is out of bounds and not-found is supplied."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(3856),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(3856),cljs.core.cst$kw$end_DASH_column,(11),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll], null))),cljs.core.cst$kw$doc,"Removes the last item from a transient vector. If\n  the collection is empty, throws an exception. Returns tcoll"], null),cljs.core.cst$sym$cljs$core_SLASH_pop_BANG_,"cljs/core.cljs",(11),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll], null)),null,cljs.core.list(null,null),(1),false,(3856),cljs.core.cst$sym$clj,(3856),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tcoll], null))),"Removes the last item from a transient vector. If\n  the collection is empty, throws an exception. Returns tcoll"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(3622),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(3622),cljs.core.cst$kw$end_DASH_column,(19),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$b,cljs.core.cst$sym$x], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_chunk_DASH_append,"cljs/core.cljs",(19),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$b,cljs.core.cst$sym$x], null)),null,cljs.core.list(null,null),(1),false,(3622),cljs.core.cst$sym$any,(3622),(2),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$b,cljs.core.cst$sym$x], null)))]),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH__STAR_unchecked_DASH_arrays_STAR_,cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(30),cljs.core.cst$kw$column,(1),cljs.core.cst$kw$end_DASH_line,(30),cljs.core.cst$kw$end_DASH_column,(24),cljs.core.cst$kw$meta,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(30),cljs.core.cst$kw$column,(6),cljs.core.cst$kw$end_DASH_line,(30),cljs.core.cst$kw$end_DASH_column,(24)], null),cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean], null),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(10234),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(10234),cljs.core.cst$kw$end_DASH_column,(14),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$objs], null))),cljs.core.cst$kw$doc,"Same as pr-str followed by (newline)",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(0),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$objs)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$objs], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_prn_DASH_str,"cljs/core.cljs",(14),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(0),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$objs)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$objs], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$objs)], null),null,(0),cljs.core.list(null),(1),true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$tag,cljs.core.cst$sym$string], null)], null),(10234),cljs.core.cst$sym$any,(10234),(0),true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$objs], null)),"Same as pr-str followed by (newline)"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$impls,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[true,"cljs/core.cljs",(25),(14),(728),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$_DASH_rseq,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)], null)], null)], null),(728),"Protocol for reversing a seq.",cljs.core.list("@interface")]),true,cljs.core.cst$sym$cljs$core_SLASH_IReversible,"cljs/core.cljs",(25),(1),(728),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$_DASH_rseq,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)], null)], null)], null),null,(728),cljs.core.cst$sym$any,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$sym$cljs$core_SLASH_IndexedSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_BlackNode,"null",cljs.core.cst$sym$cljs$core_SLASH_MapEntry,"null",cljs.core.cst$sym$cljs$core_SLASH_Subvec,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentVector,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentTreeMap,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentTreeSet,"null",cljs.core.cst$sym$cljs$core_SLASH_RedNode,"null"], null), null),"Protocol for reversing a seq.",cljs.core.list("@interface")]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(3184),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(3184),cljs.core.cst$kw$end_DASH_column,(18),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns true if coll satisfies? IReversible."], null),cljs.core.cst$sym$cljs$core_SLASH_reversible_QMARK_,"cljs/core.cljs",(18),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),null,cljs.core.list(null,null),(1),false,(3184),cljs.core.cst$sym$boolean,(3184),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),"Returns true if coll satisfies? IReversible."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$tag,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[cljs.core.cst$sym$cljs$core_SLASH_IPending,"cljs/core.cljs",(23),(13),(768),(768),cljs.core.cst$sym$boolean,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),"Returns true if a value for x has been produced, false otherwise."]),cljs.core.cst$sym$cljs$core_SLASH_IPending,cljs.core.cst$sym$cljs$core_SLASH__DASH_realized_QMARK_,"cljs/core.cljs",(23),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),null,cljs.core.list(null,null),(1),false,(765),cljs.core.cst$sym$boolean,(768),(1),cljs.core.cst$sym$boolean,true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),"Returns true if a value for x has been produced, false otherwise."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(775),cljs.core.cst$kw$column,(4),cljs.core.cst$kw$end_DASH_line,(775),cljs.core.cst$kw$end_DASH_column,(14),cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IWatchable,cljs.core.cst$kw$doc,"Adds a watcher function f to this. Keys must be unique per reference,\n     and can be used to remove the watch with -remove-watch.",cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$key,cljs.core.cst$sym$f], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_IWatchable,cljs.core.cst$sym$cljs$core_SLASH__DASH_add_DASH_watch,"cljs/core.cljs",(14),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$key,cljs.core.cst$sym$f], null)),null,cljs.core.list(null,null),(1),false,(771),cljs.core.cst$sym$any,(775),(3),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$this,cljs.core.cst$sym$key,cljs.core.cst$sym$f], null))),"Adds a watcher function f to this. Keys must be unique per reference,\n     and can be used to remove the watch with -remove-watch."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(677),cljs.core.cst$kw$column,(4),cljs.core.cst$kw$end_DASH_line,(677),cljs.core.cst$kw$end_DASH_column,(23),cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IDerefWithTimeout,cljs.core.cst$kw$doc,null,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$msec,cljs.core.cst$sym$timeout_DASH_val], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_IDerefWithTimeout,cljs.core.cst$sym$cljs$core_SLASH__DASH_deref_DASH_with_DASH_timeout,"cljs/core.cljs",(23),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$msec,cljs.core.cst$sym$timeout_DASH_val], null)),null,cljs.core.list(null,null),(1),false,(676),cljs.core.cst$sym$any,(677),(3),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$msec,cljs.core.cst$sym$timeout_DASH_val], null))),null]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(1780),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(1780),cljs.core.cst$kw$end_DASH_column,(11),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$x,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$xs], null))),cljs.core.cst$kw$doc,"conj[oin]. Returns a new collection with the xs\n  'added'. (conj nil item) returns (item).  The 'addition' may\n  happen at different 'places' depending on the concrete type.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$x], null)),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$x,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$xs], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_conj,"cljs/core.cljs",(11),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$x], null)),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$x,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$xs], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null)], null),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$x], null)),null,(2),cljs.core.list(null,null,null,null),(1),true,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core_SLASH_IVector], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,false], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$clj], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$tag,cljs.core.cst$sym$clj], null)], null),(1780),(1780),(2),true,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$x,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$xs], null)),"conj[oin]. Returns a new collection with the xs\n  'added'. (conj nil item) returns (item).  The 'addition' may\n  happen at different 'places' depending on the concrete type."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$tag,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[cljs.core.cst$sym$cljs$core_SLASH_ISorted,"cljs/core.cljs",(20),(9),(736),(736),cljs.core.cst$sym$clj,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$ascending_QMARK_], null))),"Returns a sorted seq from coll in either ascending or descending order."]),cljs.core.cst$sym$cljs$core_SLASH_ISorted,cljs.core.cst$sym$cljs$core_SLASH__DASH_sorted_DASH_seq,"cljs/core.cljs",(20),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$ascending_QMARK_], null)),null,cljs.core.list(null,null),(1),false,(733),cljs.core.cst$sym$clj,(736),(2),cljs.core.cst$sym$clj,true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$ascending_QMARK_], null))),"Returns a sorted seq from coll in either ascending or descending order."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$private,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(5123),cljs.core.cst$kw$column,(8),cljs.core.cst$kw$end_DASH_line,(5123),cljs.core.cst$kw$end_DASH_column,(16),cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$colls], null))),cljs.core.cst$kw$doc,"Take a collection of collections, and return a lazy seq\n  of items from the inner collection"], null),true,cljs.core.cst$sym$cljs$core_SLASH_flatten1,"cljs/core.cljs",(16),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$colls], null)),null,cljs.core.list(null,null),(1),false,(5123),cljs.core.cst$sym$cljs$core_SLASH_LazySeq,(5123),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$colls], null))),"Take a collection of collections, and return a lazy seq\n  of items from the inner collection"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2580),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(2580),cljs.core.cst$kw$end_DASH_column,(16),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xform,cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xform,cljs.core.cst$sym$f,cljs.core.cst$sym$init,cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"reduce with a transformation of f (xf). If init is not\n  supplied, (f) will be called to produce it. f should be a reducing\n  step function that accepts both 1 and 2 arguments, if it accepts\n  only 2 you can add the arity-1 with 'completing'. Returns the result\n  of applying (the transformed) xf to init and the first item in coll,\n  then applying xf to that result and the 2nd item, etc. If coll\n  contains no items, returns init and f is not called. Note that\n  certain transforms may inject or skip items.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(4),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(4),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xform,cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xform,cljs.core.cst$sym$f,cljs.core.cst$sym$init,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xform,cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xform,cljs.core.cst$sym$f,cljs.core.cst$sym$init,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_transduce,"cljs/core.cljs",(16),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(4),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(4),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xform,cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xform,cljs.core.cst$sym$f,cljs.core.cst$sym$init,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xform,cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xform,cljs.core.cst$sym$f,cljs.core.cst$sym$init,cljs.core.cst$sym$coll], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xform,cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xform,cljs.core.cst$sym$f,cljs.core.cst$sym$init,cljs.core.cst$sym$coll], null)),null,(4),cljs.core.list(null,null),(1),false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$any], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(4),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$any], null)], null),(2580),(2580),(4),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xform,cljs.core.cst$sym$f,cljs.core.cst$sym$coll], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xform,cljs.core.cst$sym$f,cljs.core.cst$sym$init,cljs.core.cst$sym$coll], null)),"reduce with a transformation of f (xf). If init is not\n  supplied, (f) will be called to produce it. f should be a reducing\n  step function that accepts both 1 and 2 arguments, if it accepts\n  only 2 you can add the arity-1 with 'completing'. Returns the result\n  of applying (the transformed) xf to init and the first item in coll,\n  then applying xf to that result and the 2nd item, etc. If coll\n  contains no items, returns init and f is not called. Note that\n  certain transforms may inject or skip items."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[cljs.core.cst$sym$cljs$core_SLASH_ISwap,"cljs/core.cljs",(10),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(5),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(5),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f,cljs.core.cst$sym$a], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$xs], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f,cljs.core.cst$sym$a], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$xs], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null)], null),(4),(856),(856),cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f,cljs.core.cst$sym$a], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$xs], null))),"Swaps the value of o to be (apply f current-value-of-atom args)."]),cljs.core.cst$sym$cljs$core_SLASH_ISwap,cljs.core.cst$sym$cljs$core_SLASH__DASH_swap_BANG_,"cljs/core.cljs",(10),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(5),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(5),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f,cljs.core.cst$sym$a], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$xs], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f,cljs.core.cst$sym$a], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$xs], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f,cljs.core.cst$sym$a], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$xs], null)),null,(5),cljs.core.list(null,null,null,null),(1),false,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$any], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$any], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(4),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$any], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(5),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$any], null)], null),(854),(856),(5),true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f,cljs.core.cst$sym$a], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$f,cljs.core.cst$sym$a,cljs.core.cst$sym$b,cljs.core.cst$sym$xs], null)),"Swaps the value of o to be (apply f current-value-of-atom args)."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$dynamic,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(150),cljs.core.cst$kw$column,(3),cljs.core.cst$kw$end_DASH_line,(150),cljs.core.cst$kw$end_DASH_column,(17),cljs.core.cst$kw$dynamic,true,cljs.core.cst$kw$doc,"*print-length* controls how many items of each collection the\n  printer will print. If it is bound to logical false, there is no\n  limit. Otherwise, it must be bound to an integer indicating the maximum\n  number of items of each collection to print. If a collection contains\n  more items, the printer will print items up to the limit followed by\n  '...' to represent the remaining items. The root binding is nil\n  indicating no limit.",cljs.core.cst$kw$jsdoc,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["@type {null|number}"], null)], null),cljs.core.cst$sym$cljs$core_SLASH__STAR_print_DASH_length_STAR_,"cljs/core.cljs",(17),(1),true,(140),(150),cljs.core.cst$sym$clj_DASH_nil,"*print-length* controls how many items of each collection the\n  printer will print. If it is bound to logical false, there is no\n  limit. Otherwise, it must be bound to an integer indicating the maximum\n  number of items of each collection to print. If a collection contains\n  more items, the printer will print items up to the limit followed by\n  '...' to represent the remaining items. The root binding is nil\n  indicating no limit.",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["@type {null|number}"], null)]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2187),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(2187),cljs.core.cst$kw$end_DASH_column,(16),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$key], null))),cljs.core.cst$kw$doc,"Delete a property from a JavaScript object.\n  Returns true upon success, false otherwise."], null),cljs.core.cst$sym$cljs$core_SLASH_js_DASH_delete,"cljs/core.cljs",(16),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$key], null)),null,cljs.core.list(null,null),(1),false,(2187),cljs.core.cst$sym$any,(2187),(2),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$key], null))),"Delete a property from a JavaScript object.\n  Returns true upon success, false otherwise."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(215),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(215),cljs.core.cst$kw$end_DASH_column,(13),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Internal - do not use!"], null),cljs.core.cst$sym$cljs$core_SLASH_truth_,"cljs/core.cljs",(13),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),null,cljs.core.list(null,null),(1),false,(215),cljs.core.cst$sym$any,(215),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),"Internal - do not use!"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(6598),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(6598),cljs.core.cst$kw$end_DASH_column,(21),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$k], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_array_DASH_index_DASH_of,"cljs/core.cljs",(21),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$k], null)),null,cljs.core.list(null,null),(1),false,(6598),cljs.core.cst$sym$number,(6598),(2),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$k], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocols,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$factory,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag,cljs.core.cst$kw$doc],[new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_IMultiFn,"null",cljs.core.cst$sym$cljs$core_SLASH_INamed,"null"], null), null),"cljs/core.cljs",(17),(10),cljs.core.cst$kw$positional,(11025),(11025),cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name,cljs.core.cst$sym$dispatch_DASH_fn,cljs.core.cst$sym$default_DASH_dispatch_DASH_val,cljs.core.cst$sym$hierarchy,cljs.core.cst$sym$method_DASH_table,cljs.core.cst$sym$prefer_DASH_table,cljs.core.cst$sym$method_DASH_cache,cljs.core.cst$sym$cached_DASH_hierarchy], null))),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_IMultiFn,"null",cljs.core.cst$sym$cljs$core_SLASH_INamed,"null"], null), null),"Positional factory function for cljs.core/MultiFn."]),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_IMultiFn,"null",cljs.core.cst$sym$cljs$core_SLASH_INamed,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH__DASH__GT_MultiFn,"cljs/core.cljs",(17),cljs.core.list(new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name,cljs.core.cst$sym$dispatch_DASH_fn,cljs.core.cst$sym$default_DASH_dispatch_DASH_val,cljs.core.cst$sym$hierarchy,cljs.core.cst$sym$method_DASH_table,cljs.core.cst$sym$prefer_DASH_table,cljs.core.cst$sym$method_DASH_cache,cljs.core.cst$sym$cached_DASH_hierarchy], null)),null,cljs.core.list(null,null),(1),false,cljs.core.cst$kw$positional,(11025),cljs.core.cst$sym$cljs$core_SLASH_MultiFn,(11025),(8),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name,cljs.core.cst$sym$dispatch_DASH_fn,cljs.core.cst$sym$default_DASH_dispatch_DASH_val,cljs.core.cst$sym$hierarchy,cljs.core.cst$sym$method_DASH_table,cljs.core.cst$sym$prefer_DASH_table,cljs.core.cst$sym$method_DASH_cache,cljs.core.cst$sym$cached_DASH_hierarchy], null))),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$sym$cljs$core_SLASH_IHash,"null",cljs.core.cst$sym$cljs$core_SLASH_IFn,"null",cljs.core.cst$sym$cljs$core_SLASH_IMultiFn,"null",cljs.core.cst$sym$cljs$core_SLASH_INamed,"null"], null), null),"Positional factory function for cljs.core/MultiFn."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(10702),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(10702),cljs.core.cst$kw$end_DASH_column,(14),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$primitive_DASH_fn], null))),cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$primitive_DASH_fn], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$primitive_DASH_fn], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_key_DASH__GT_js,"cljs/core.cljs",(14),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$primitive_DASH_fn], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$primitive_DASH_fn], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$primitive_DASH_fn], null)),null,(2),cljs.core.list(null,null),(1),false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$any], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$any,"null",cljs.core.cst$sym$string,"null"], null), null)], null)], null),(10702),(10702),(2),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$primitive_DASH_fn], null))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$impls,cljs.core.cst$kw$jsdoc],[new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(10695),cljs.core.cst$kw$column,(14),cljs.core.cst$kw$end_DASH_line,(10695),cljs.core.cst$kw$end_DASH_column,(23),cljs.core.cst$kw$protocol_DASH_symbol,true,cljs.core.cst$kw$jsdoc,cljs.core.list("@interface"),cljs.core.cst$kw$protocol_DASH_info,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$_DASH_clj_DASH__GT_js,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)], null),cljs.core.cst$sym$_DASH_key_DASH__GT_js,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)], null)], null)], null)], null),true,cljs.core.cst$sym$cljs$core_SLASH_IEncodeJS,"cljs/core.cljs",(23),(1),(10695),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$_DASH_clj_DASH__GT_js,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)], null),cljs.core.cst$sym$_DASH_key_DASH__GT_js,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)], null)], null)], null),null,(10695),cljs.core.cst$sym$any,cljs.core.PersistentHashSet.EMPTY,cljs.core.list("@interface")]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$private,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(5363),cljs.core.cst$kw$column,(8),cljs.core.cst$kw$end_DASH_line,(5363),cljs.core.cst$kw$end_DASH_column,(16),cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.cst$sym$level,cljs.core.cst$sym$node], null)))], null),true,cljs.core.cst$sym$cljs$core_SLASH_new_DASH_path,"cljs/core.cljs",(16),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.cst$sym$level,cljs.core.cst$sym$node], null)),null,cljs.core.list(null,null),(1),false,(5363),(5363),(3),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.cst$sym$level,cljs.core.cst$sym$node], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(4530),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(4530),cljs.core.cst$kw$end_DASH_column,(23),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$oldval,cljs.core.cst$sym$newval], null))),cljs.core.cst$kw$doc,"Atomically sets the value of atom to newval if and only if the\n  current value of the atom is equal to oldval. Returns true if\n  set happened, else false."], null),cljs.core.cst$sym$cljs$core_SLASH_compare_DASH_and_DASH_set_BANG_,"cljs/core.cljs",(23),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$oldval,cljs.core.cst$sym$newval], null)),null,cljs.core.list(null,null),(1),false,(4530),cljs.core.cst$sym$boolean,(4530),(3),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$a,cljs.core.cst$sym$oldval,cljs.core.cst$sym$newval], null))),"Atomically sets the value of atom to newval if and only if the\n  current value of the atom is equal to oldval. Returns true if\n  set happened, else false."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(1669),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(1669),cljs.core.cst$kw$end_DASH_column,(16),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$i], null))),cljs.core.cst$kw$doc,"Create a seq from a JavaScript array.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$i], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$i], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_array_DASH_seq,"cljs/core.cljs",(16),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$i], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$i], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$i], null)),null,(2),cljs.core.list(null,null),(1),false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_IndexedSeq,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null)], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_IndexedSeq,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null)], null)], null),(1669),(1669),(2),true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array,cljs.core.cst$sym$i], null)),"Create a seq from a JavaScript array."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$private,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2201),cljs.core.cst$kw$column,(8),cljs.core.cst$kw$end_DASH_line,(2201),cljs.core.cst$kw$end_DASH_column,(27),cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$from,cljs.core.cst$sym$i,cljs.core.cst$sym$to,cljs.core.cst$sym$j,cljs.core.cst$sym$len], null)))], null),true,cljs.core.cst$sym$cljs$core_SLASH_array_DASH_copy_DASH_downward,"cljs/core.cljs",(27),cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$from,cljs.core.cst$sym$i,cljs.core.cst$sym$to,cljs.core.cst$sym$j,cljs.core.cst$sym$len], null)),null,cljs.core.list(null,null),(1),false,(2201),(2201),(5),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$from,cljs.core.cst$sym$i,cljs.core.cst$sym$to,cljs.core.cst$sym$j,cljs.core.cst$sym$len], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$private,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(7428),cljs.core.cst$kw$column,(8),cljs.core.cst$kw$end_DASH_line,(7428),cljs.core.cst$kw$end_DASH_column,(23),cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array_DASH_node,cljs.core.cst$sym$edit,cljs.core.cst$sym$idx], null)))], null),true,cljs.core.cst$sym$cljs$core_SLASH_pack_DASH_array_DASH_node,"cljs/core.cljs",(23),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array_DASH_node,cljs.core.cst$sym$edit,cljs.core.cst$sym$idx], null)),null,cljs.core.list(null,null),(1),false,(7428),cljs.core.cst$sym$cljs$core_SLASH_BitmapIndexedNode,(7428),(3),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$array_DASH_node,cljs.core.cst$sym$edit,cljs.core.cst$sym$idx], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(5085),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(5085),cljs.core.cst$kw$end_DASH_column,(17),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$c1], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$c1,cljs.core.cst$sym$c2], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$c1,cljs.core.cst$sym$c2,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$colls], null))),cljs.core.cst$kw$doc,"Returns a lazy seq of the first item in each coll, then the second etc.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$c1], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$c1,cljs.core.cst$sym$c2], null)),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$c1], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$c1,cljs.core.cst$sym$c2], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$c1,cljs.core.cst$sym$c2,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$colls], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_interleave,"cljs/core.cljs",(17),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$c1], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$c1,cljs.core.cst$sym$c2], null)),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$c1], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$c1,cljs.core.cst$sym$c2], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$c1,cljs.core.cst$sym$c2,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$colls], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null)], null),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$c1], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$c1,cljs.core.cst$sym$c2], null)),null,(2),cljs.core.list(null,null,null,null),(1),true,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core_SLASH_IList], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core_SLASH_LazySeq], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core_SLASH_LazySeq], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core_SLASH_LazySeq], null)], null),(5085),(5085),(2),true,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$c1], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$c1,cljs.core.cst$sym$c2], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$c1,cljs.core.cst$sym$c2,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$colls], null)),"Returns a lazy seq of the first item in each coll, then the second etc."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(10310),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(10310),cljs.core.cst$kw$end_DASH_column,(16),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,cljs.core.cst$sym$print_DASH_one,cljs.core.cst$sym$writer,cljs.core.cst$sym$opts], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_print_DASH_map,"cljs/core.cljs",(16),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,cljs.core.cst$sym$print_DASH_one,cljs.core.cst$sym$writer,cljs.core.cst$sym$opts], null)),null,cljs.core.list(null,null),(1),false,(10310),cljs.core.cst$sym$any,(10310),(4),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m,cljs.core.cst$sym$print_DASH_one,cljs.core.cst$sym$writer,cljs.core.cst$sym$opts], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2151),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(2151),cljs.core.cst$kw$end_DASH_column,(11),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Return true if x satisfies IMap"], null),cljs.core.cst$sym$cljs$core_SLASH_map_QMARK_,"cljs/core.cljs",(11),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),null,cljs.core.list(null,null),(1),false,(2151),cljs.core.cst$sym$boolean,(2151),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),"Return true if x satisfies IMap"]),new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$name,cljs.core.cst$sym$cljs$core_SLASH_m3_DASH_C1,cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(911),cljs.core.cst$kw$column,(1),cljs.core.cst$kw$end_DASH_line,(911),cljs.core.cst$kw$end_DASH_column,(11),cljs.core.cst$kw$meta,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(911),cljs.core.cst$kw$column,(6),cljs.core.cst$kw$end_DASH_line,(911),cljs.core.cst$kw$end_DASH_column,(11)], null),cljs.core.cst$kw$tag,cljs.core.cst$sym$number], null),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(1935),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(1935),cljs.core.cst$kw$end_DASH_column,(10),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$k,cljs.core.cst$sym$not_DASH_found], null))),cljs.core.cst$kw$doc,"Returns the value mapped to key, not-found or nil if key not present.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$k,cljs.core.cst$sym$not_DASH_found], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$k,cljs.core.cst$sym$not_DASH_found], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_get,"cljs/core.cljs",(10),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$k,cljs.core.cst$sym$not_DASH_found], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$k,cljs.core.cst$sym$not_DASH_found], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$k,cljs.core.cst$sym$not_DASH_found], null)),null,(3),cljs.core.list(null,null),(1),false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$any,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null)], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [null,"null",cljs.core.cst$sym$any,"null"], null), null)], null)], null),(1935),(1935),(3),true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$k], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o,cljs.core.cst$sym$k,cljs.core.cst$sym$not_DASH_found], null)),"Returns the value mapped to key, not-found or nil if key not present."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2565),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(2565),cljs.core.cst$kw$end_DASH_column,(15),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns its argument."], null),cljs.core.cst$sym$cljs$core_SLASH_identity,"cljs/core.cljs",(15),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),null,cljs.core.list(null,null),(1),false,(2565),(2565),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),"Returns its argument."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(5207),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(5207),cljs.core.cst$kw$end_DASH_column,(11),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$to], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$to,cljs.core.cst$sym$from], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$to,cljs.core.cst$sym$xform,cljs.core.cst$sym$from], null))),cljs.core.cst$kw$doc,"Returns a new coll consisting of to-coll with all of the items of\n  from-coll conjoined. A transducer may be supplied.",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$to], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$to,cljs.core.cst$sym$from], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$to,cljs.core.cst$sym$xform,cljs.core.cst$sym$from], null)),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$to], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$to,cljs.core.cst$sym$from], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$to,cljs.core.cst$sym$xform,cljs.core.cst$sym$from], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_into,"cljs/core.cljs",(11),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(3),cljs.core.cst$kw$method_DASH_params,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$to], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$to,cljs.core.cst$sym$from], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$to,cljs.core.cst$sym$xform,cljs.core.cst$sym$from], null)),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$to], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$to,cljs.core.cst$sym$from], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$to,cljs.core.cst$sym$xform,cljs.core.cst$sym$from], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null)], null),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$to], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$to,cljs.core.cst$sym$from], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$to,cljs.core.cst$sym$xform,cljs.core.cst$sym$from], null)),null,(3),cljs.core.list(null,null,null,null),(1),false,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core_SLASH_IVector], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,false], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [null,"null",cljs.core.cst$sym$clj,"null",cljs.core.cst$sym$any,"null"], null), null)], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(3),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$clj,"null",cljs.core.cst$sym$any,"null"], null), null)], null)], null),(5207),(5207),(3),true,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$to], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$to,cljs.core.cst$sym$from], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$to,cljs.core.cst$sym$xform,cljs.core.cst$sym$from], null)),"Returns a new coll consisting of to-coll with all of the items of\n  from-coll conjoined. A transducer may be supplied."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2806),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(2806),cljs.core.cst$kw$end_DASH_column,(11),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Coerce to long by stripping decimal places. Identical to `int'."], null),cljs.core.cst$sym$cljs$core_SLASH_long,"cljs/core.cljs",(11),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),null,cljs.core.list(null,null),(1),false,(2806),cljs.core.cst$sym$number,(2806),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),"Coerce to long by stripping decimal places. Identical to `int'."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$tag,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2707),cljs.core.cst$kw$column,(15),cljs.core.cst$kw$end_DASH_line,(2707),cljs.core.cst$kw$end_DASH_column,(21),cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_double,"cljs/core.cljs",(21),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),null,cljs.core.list(null,null),(1),false,(2707),cljs.core.cst$sym$number,(2707),(1),cljs.core.cst$sym$number,true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(4570),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(4570),cljs.core.cst$kw$end_DASH_column,(16),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),cljs.core.cst$kw$doc,"Returns true if x is a volatile."], null),cljs.core.cst$sym$cljs$core_SLASH_volatile_QMARK_,"cljs/core.cljs",(16),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null)),null,cljs.core.list(null,null),(1),false,(4570),cljs.core.cst$sym$boolean,(4570),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null))),"Returns true if x is a volatile."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$num_DASH_fields,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$type,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$record,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag],[(2),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null",cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH_ChunkBuffer,"cljs/core.cljs",(21),true,(10),(3495),false,(3495),cljs.core.cst$sym$function,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_ICounted,"null"], null), null)]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$num_DASH_fields,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$type,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$record,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag],[(1),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_Object,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH_HashSetIter,"cljs/core.cljs",(21),true,(10),(9133),false,(9133),cljs.core.cst$sym$function,null]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(646),cljs.core.cst$kw$column,(4),cljs.core.cst$kw$end_DASH_line,(646),cljs.core.cst$kw$end_DASH_column,(8),cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IMapEntry,cljs.core.cst$kw$doc,"Returns the key of the map entry.",cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_IMapEntry,cljs.core.cst$sym$cljs$core_SLASH__DASH_key,"cljs/core.cljs",(8),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),null,cljs.core.list(null,null),(1),false,(644),cljs.core.cst$sym$any,(646),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),"Returns the key of the map entry."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(1753),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(1753),cljs.core.cst$kw$end_DASH_column,(13),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Same as (next (first x))"], null),cljs.core.cst$sym$cljs$core_SLASH_nfirst,"cljs/core.cljs",(13),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),null,cljs.core.list(null,null),(1),false,(1753),cljs.core.cst$sym$seq,(1753),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),"Same as (next (first x))"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$num_DASH_fields,cljs.core.cst$kw$protocols,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$type,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$record,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$skip_DASH_protocol_DASH_flag],[(1),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_IWriter,"null"], null), null),cljs.core.cst$sym$cljs$core_SLASH_StringBufferWriter,"cljs/core.cljs",(28),true,(10),(872),false,(872),cljs.core.cst$sym$function,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$cljs$core_SLASH_IWriter,"null"], null), null)]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2075),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(2075),cljs.core.cst$kw$end_DASH_column,(11),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o], null))),cljs.core.cst$kw$doc,"Returns the metadata of obj, returns nil if there is no metadata."], null),cljs.core.cst$sym$cljs$core_SLASH_meta,"cljs/core.cljs",(11),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o], null)),null,cljs.core.list(null,null),(1),false,(2075),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$clj_DASH_or_DASH_nil,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null),(2075),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o], null))),"Returns the metadata of obj, returns nil if there is no metadata."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$private,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(5993),cljs.core.cst$kw$column,(8),cljs.core.cst$kw$end_DASH_line,(5993),cljs.core.cst$kw$end_DASH_column,(24),cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tl], null)))], null),true,cljs.core.cst$sym$cljs$core_SLASH_tv_DASH_editable_DASH_tail,"cljs/core.cljs",(24),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tl], null)),null,cljs.core.list(null,null),(1),false,(5993),cljs.core.cst$sym$array,(5993),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$tl], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(700),cljs.core.cst$kw$column,(4),cljs.core.cst$kw$end_DASH_line,(700),cljs.core.cst$kw$end_DASH_column,(14),cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_IKVReduce,cljs.core.cst$kw$doc,"Reduces an associative collection and returns the result. f should be\n     a function that takes three arguments.",cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f,cljs.core.cst$sym$init], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_IKVReduce,cljs.core.cst$sym$cljs$core_SLASH__DASH_kv_DASH_reduce,"cljs/core.cljs",(14),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f,cljs.core.cst$sym$init], null)),null,cljs.core.list(null,null),(1),false,(697),cljs.core.cst$sym$any,(700),(3),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll,cljs.core.cst$sym$f,cljs.core.cst$sym$init], null))),"Reduces an associative collection and returns the result. f should be\n     a function that takes three arguments."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$impls,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_symbol,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$protocol_DASH_info,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$doc,cljs.core.cst$kw$jsdoc],[true,"cljs/core.cljs",(19),(14),(709),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$_DASH_hash,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o], null)], null)], null)], null),(709),"Protocol for adding hashing functionality to a type.",cljs.core.list("@interface")]),true,cljs.core.cst$sym$cljs$core_SLASH_IHash,"cljs/core.cljs",(19),(1),(709),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$methods,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$_DASH_hash,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$o], null)], null)], null)], null),null,(709),cljs.core.cst$sym$any,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 39, [cljs.core.cst$sym$cljs$core_SLASH_Namespace,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentHashMap,"null",cljs.core.cst$sym$cljs$core_SLASH_MultiFn,"null",cljs.core.cst$sym$cljs$core_SLASH_ObjMap,"null",cljs.core.cst$sym$cljs$core_SLASH_Cons,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentArrayMap,"null",cljs.core.cst$sym$cljs$core_SLASH_NodeSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentQueue,"null",cljs.core.cst$sym$cljs$core_SLASH_IndexedSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_Keyword,"null",cljs.core.cst$sym$cljs$core_SLASH_BlackNode,"null",cljs.core.cst$sym$cljs$core_SLASH_MapEntry,"null",cljs.core.cst$sym$cljs$core_SLASH_EmptyList,"null",cljs.core.cst$sym$cljs$core_SLASH_LazySeq,"null",cljs.core.cst$sym$cljs$core_SLASH_Subvec,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentQueueSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_Var,"null",cljs.core.cst$sym$cljs$core_SLASH_ArrayNodeSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ValSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_TaggedLiteral,"null",cljs.core.cst$sym$cljs$tools$reader$impl$utils_SLASH_ReaderConditional,"null",cljs.core.cst$sym$default,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentArrayMapSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentVector,"null",cljs.core.cst$sym$cljs$core_SLASH_List,"null",cljs.core.cst$sym$cljs$core_SLASH_Repeat,"null",cljs.core.cst$sym$cljs$core_SLASH_RSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentHashSet,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentTreeMap,"null",cljs.core.cst$sym$cljs$core_SLASH_KeySeq,"null",cljs.core.cst$sym$cljs$core_SLASH_ChunkedSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_Atom,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentTreeSet,"null",cljs.core.cst$sym$cljs$core_SLASH_ChunkedCons,"null",cljs.core.cst$sym$cljs$core_SLASH_Symbol,"null",cljs.core.cst$sym$cljs$core_SLASH_UUID,"null",cljs.core.cst$sym$cljs$core_SLASH_Range,"null",cljs.core.cst$sym$cljs$core_SLASH_PersistentTreeMapSeq,"null",cljs.core.cst$sym$cljs$core_SLASH_RedNode,"null"], null), null),"Protocol for adding hashing functionality to a type.",cljs.core.list("@interface")]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(2865),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(2865),cljs.core.cst$kw$end_DASH_column,(18),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null))),cljs.core.cst$kw$doc,"Bitwise and with complement",cljs.core.cst$kw$top_DASH_fn,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null)], null),cljs.core.cst$sym$cljs$core_SLASH_bit_DASH_and_DASH_not,"cljs/core.cljs",(18),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)),null,(2),cljs.core.list(null,null),(1),true,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$number], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [null,"null",cljs.core.cst$sym$any,"null"], null), null)], null)], null),(2865),(2865),(2),true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),"Bitwise and with complement"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(1094),cljs.core.cst$kw$column,(7),cljs.core.cst$kw$end_DASH_line,(1094),cljs.core.cst$kw$end_DASH_column,(11),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$v], null))),cljs.core.cst$kw$doc,"Returns true if v is of type cljs.core.Var"], null),cljs.core.cst$sym$cljs$core_SLASH_var_QMARK_,"cljs/core.cljs",(11),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$v], null)),null,cljs.core.list(null,null),(1),false,(1094),cljs.core.cst$sym$boolean,(1094),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$v], null))),"Returns true if v is of type cljs.core.Var"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$protocol,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(747),cljs.core.cst$kw$column,(4),cljs.core.cst$kw$end_DASH_line,(747),cljs.core.cst$kw$end_DASH_column,(15),cljs.core.cst$kw$protocol,cljs.core.cst$sym$cljs$core_SLASH_ISorted,cljs.core.cst$kw$doc,"Returns the comparator for coll.",cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)))], null),cljs.core.cst$sym$cljs$core_SLASH_ISorted,cljs.core.cst$sym$cljs$core_SLASH__DASH_comparator,"cljs/core.cljs",(15),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),null,cljs.core.list(null,null),(1),false,(733),cljs.core.cst$sym$any,(747),(1),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),"Returns the comparator for coll."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$fixed_DASH_arity,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$methods,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$tag,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],["cljs/core.cljs",(32),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null)], null),(15),(2722),(2722),cljs.core.cst$sym$number,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null))),"Returns the sum of nums. (+) returns 0."]),cljs.core.cst$sym$cljs$core_SLASH_unchecked_DASH_add_DASH_int,"cljs/core.cljs",(32),new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(2),cljs.core.cst$kw$method_DASH_params,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)),cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null,null,null)], null),cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null)),null,(2),cljs.core.list(null,null,null,null),(1),true,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(0),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$number], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$variadic_QMARK_,false], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$tag,cljs.core.cst$sym$number], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fixed_DASH_arity,(2),cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$tag,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [null,"null",cljs.core.cst$sym$any,"null"], null), null)], null)], null),(2722),cljs.core.cst$sym$number,(2722),(2),cljs.core.cst$sym$number,true,cljs.core.list(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$x,cljs.core.cst$sym$y,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$more], null)),"Returns the sum of nums. (+) returns 0."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$tag,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(1328),cljs.core.cst$kw$column,(15),cljs.core.cst$kw$end_DASH_line,(1328),cljs.core.cst$kw$end_DASH_column,(32),cljs.core.cst$kw$tag,cljs.core.cst$sym$number,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),cljs.core.cst$kw$doc,"Returns the hash code, consistent with =, for an external ordered\n   collection implementing Iterable.\n   See http://clojure.org/data_structures#hash for full algorithms."], null),cljs.core.cst$sym$cljs$core_SLASH_hash_DASH_ordered_DASH_coll,"cljs/core.cljs",(32),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null)),null,cljs.core.list(null,null),(1),false,(1328),cljs.core.cst$sym$number,(1328),(1),cljs.core.cst$sym$number,true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$coll], null))),"Returns the hash code, consistent with =, for an external ordered\n   collection implementing Iterable.\n   See http://clojure.org/data_structures#hash for full algorithms."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$private,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(3024),cljs.core.cst$kw$column,(8),cljs.core.cst$kw$end_DASH_line,(3024),cljs.core.cst$kw$end_DASH_column,(22),cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$fn_DASH_map], null))),cljs.core.cst$kw$doc,"Takes a JavaScript object and a map of names to functions and\n  attaches said functions as methods on the object.  Any references to\n  JavaScript's implicit this (via the this-as macro) will resolve to the\n  object that the function is attached."], null),true,cljs.core.cst$sym$cljs$core_SLASH_extend_DASH_object_BANG_,"cljs/core.cljs",(22),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$fn_DASH_map], null)),null,cljs.core.list(null,null),(1),false,(3024),(3024),(2),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$fn_DASH_map], null))),"Takes a JavaScript object and a map of names to functions and\n  attaches said functions as methods on the object.  Any references to\n  JavaScript's implicit this (via the this-as macro) will resolve to the\n  object that the function is attached."]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$private,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$ret_DASH_tag,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs/core.cljs",cljs.core.cst$kw$line,(5416),cljs.core.cst$kw$column,(8),cljs.core.cst$kw$end_DASH_line,(5416),cljs.core.cst$kw$end_DASH_column,(16),cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pv,cljs.core.cst$sym$level,cljs.core.cst$sym$node,cljs.core.cst$sym$i,cljs.core.cst$sym$val], null)))], null),true,cljs.core.cst$sym$cljs$core_SLASH_do_DASH_assoc,"cljs/core.cljs",(16),cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pv,cljs.core.cst$sym$level,cljs.core.cst$sym$node,cljs.core.cst$sym$i,cljs.core.cst$sym$val], null)),null,cljs.core.list(null,null),(1),false,(5416),cljs.core.cst$sym$cljs$core_SLASH_VectorNode,(5416),(5),true,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pv,cljs.core.cst$sym$level,cljs.core.cst$sym$node,cljs.core.cst$sym$i,cljs.core.cst$sym$val], null)))]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$protocol_DASH_inline,cljs.core.cst$kw$meta,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$method_DASH_params,cljs.core.cst$kw$protocol_DASH_impl,cljs.core.cst$kw$arglists_DASH_meta,cljs.core.cst$kw$column,cljs.core.cst$kw$variadic_QMARK_,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,cljs.core.cst$kw$fn_DASH_var,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc],[null,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$file,"cljs