// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');



/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k27254,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__27258 = k27254;
var G__27258__$1 = (((G__27258 instanceof cljs.core.Keyword))?G__27258.fqn:null);
switch (G__27258__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k27254,else__4383__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__27259){
var vec__27260 = p__27259;
var k__4403__auto__ = cljs.core.nth.call(null,vec__27260,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__27260,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.session.DbSession{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__27253){
var self__ = this;
var G__27253__$1 = this;
return (new cljs.core.RecordIter((0),G__27253__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (11 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
}).call(null,this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this27255,other27256){
var self__ = this;
var this27255__$1 = this;
return (((!((other27256 == null)))) && ((this27255__$1.constructor === other27256.constructor)) && (cljs.core._EQ_.call(null,this27255__$1.conn,other27256.conn)) && (cljs.core._EQ_.call(null,this27255__$1.network,other27256.network)) && (cljs.core._EQ_.call(null,this27255__$1.dbid,other27256.dbid)) && (cljs.core._EQ_.call(null,this27255__$1.db_name,other27256.db_name)) && (cljs.core._EQ_.call(null,this27255__$1.update_chan,other27256.update_chan)) && (cljs.core._EQ_.call(null,this27255__$1.transact_chan,other27256.transact_chan)) && (cljs.core._EQ_.call(null,this27255__$1.state,other27256.state)) && (cljs.core._EQ_.call(null,this27255__$1.schema_cache,other27256.schema_cache)) && (cljs.core._EQ_.call(null,this27255__$1.blank_db,other27256.blank_db)) && (cljs.core._EQ_.call(null,this27255__$1.close,other27256.close)) && (cljs.core._EQ_.call(null,this27255__$1.id,other27256.id)) && (cljs.core._EQ_.call(null,this27255__$1.__extmap,other27256.__extmap)));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__27253){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__27263 = cljs.core.keyword_identical_QMARK_;
var expr__27264 = k__4388__auto__;
if(cljs.core.truth_(pred__27263.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__27264))){
return (new fluree.db.session.DbSession(G__27253,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27263.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__27264))){
return (new fluree.db.session.DbSession(self__.conn,G__27253,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27263.call(null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),expr__27264))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__27253,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27263.call(null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),expr__27264))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,G__27253,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27263.call(null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),expr__27264))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,G__27253,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27263.call(null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),expr__27264))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,G__27253,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27263.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__27264))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,G__27253,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27263.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),expr__27264))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__27253,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27263.call(null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),expr__27264))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__27253,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27263.call(null,new cljs.core.Keyword(null,"close","close",1835149582),expr__27264))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__27253,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27263.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__27264))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__27253,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__27253),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__27253){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__27253,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4386__auto__,(0)),cljs.core._nth.call(null,entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"db-name","db-name",-1496507024,null),new cljs.core.Symbol(null,"update-chan","update-chan",776770735,null),new cljs.core.Symbol(null,"transact-chan","transact-chan",366882687,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"blank-db","blank-db",1165432993,null),new cljs.core.Symbol(null,"close","close",-819286187,null),new cljs.core.Symbol(null,"id","id",252129435,null)], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write.call(null,writer__4424__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__27257){
var extmap__4419__auto__ = (function (){var G__27266 = cljs.core.dissoc.call(null,G__27257,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092));
if(cljs.core.record_QMARK_.call(null,G__27257)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__27266);
} else {
return G__27266;
}
})();
return (new fluree.db.session.DbSession(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__27257),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__27257),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__27257),new cljs.core.Keyword(null,"db-name","db-name",1157928745).cljs$core$IFn$_invoke$arity$1(G__27257),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(G__27257),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(G__27257),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__27257),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__27257),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(G__27257),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__27257),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__27257),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.call(null,fluree.db.session.cache_factory.call(null));
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__27268 = session;
var map__27268__$1 = (((((!((map__27268 == null))))?(((((map__27268.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27268.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27268):map__27268);
var network = cljs.core.get.call(null,map__27268__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__27268__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null);
cljs.core.swap_BANG_.call(null,fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.call(null,c,cache_key))){
return c;
} else {
return cljs.core.assoc.call(null,c,cache_key,session);
}
}));

return cljs.core.get.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,dbid){
return cljs.core.get.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,dbid){
return cljs.core.swap_BANG_.call(null,fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_.call(null,fluree.db.session.session_cache,fluree.db.session.cache_factory.call(null));
});
fluree.db.session.full_load_existing_db = (function fluree$db$session$full_load_existing_db(session){
var pc = cljs.core.async.promise_chan.call(null);
var c__2490__auto___27486 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_27413){
var state_val_27414 = (state_27413[(1)]);
if((state_val_27414 === (7))){
var state_27413__$1 = state_27413;
var statearr_27415_27487 = state_27413__$1;
(statearr_27415_27487[(2)] = false);

(statearr_27415_27487[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27414 === (20))){
var inst_27302 = (state_27413[(7)]);
var inst_27303 = (state_27413[(8)]);
var inst_27310 = (state_27413[(9)]);
var inst_27319 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_27310);
var inst_27320 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27302),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27303)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27319),"."].join('');
var state_27413__$1 = state_27413;
var statearr_27416_27488 = state_27413__$1;
(statearr_27416_27488[(2)] = inst_27320);

(statearr_27416_27488[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27414 === (27))){
var inst_27394 = (state_27413[(2)]);
var state_27413__$1 = state_27413;
var statearr_27417_27489 = state_27413__$1;
(statearr_27417_27489[(2)] = inst_27394);

(statearr_27417_27489[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27414 === (1))){
var state_27413__$1 = state_27413;
var statearr_27418_27490 = state_27413__$1;
(statearr_27418_27490[(2)] = null);

(statearr_27418_27490[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27414 === (24))){
var state_27413__$1 = state_27413;
var statearr_27419_27491 = state_27413__$1;
(statearr_27419_27491[(2)] = null);

(statearr_27419_27491[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27414 === (39))){
var state_27413__$1 = state_27413;
var statearr_27420_27492 = state_27413__$1;
(statearr_27420_27492[(2)] = false);

(statearr_27420_27492[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27414 === (46))){
var inst_27402 = (state_27413[(10)]);
var inst_27405 = (state_27413[(2)]);
var inst_27406 = fluree.db.util.async.throw_err.call(null,inst_27405);
var inst_27407 = cljs.core.assoc.call(null,inst_27402,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_27406);
var inst_27408 = cljs.core.async.put_BANG_.call(null,pc,inst_27407);
var _ = (function (){var statearr_27421 = state_27413;
(statearr_27421[(4)] = cljs.core.rest.call(null,(state_27413[(4)])));

return statearr_27421;
})();
var state_27413__$1 = state_27413;
var statearr_27422_27493 = state_27413__$1;
(statearr_27422_27493[(2)] = inst_27408);

(statearr_27422_27493[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27414 === (4))){
var inst_27270 = (state_27413[(2)]);
var inst_27271 = cljs.core.async.put_BANG_.call(null,pc,inst_27270);
var state_27413__$1 = state_27413;
var statearr_27423_27494 = state_27413__$1;
(statearr_27423_27494[(2)] = inst_27271);

(statearr_27423_27494[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27414 === (15))){
var inst_27310 = (state_27413[(9)]);
var inst_27309 = (state_27413[(2)]);
var inst_27310__$1 = fluree.db.util.async.throw_err.call(null,inst_27309);
var inst_27311 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_27310__$1);
var inst_27312 = cljs.core.keyword.call(null,inst_27311);
var inst_27313 = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"ready","ready",1086465795),inst_27312);
var state_27413__$1 = (function (){var statearr_27424 = state_27413;
(statearr_27424[(9)] = inst_27310__$1);

return statearr_27424;
})();
if(inst_27313){
var statearr_27425_27495 = state_27413__$1;
(statearr_27425_27495[(1)] = (16));

} else {
var statearr_27426_27496 = state_27413__$1;
(statearr_27426_27496[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27414 === (21))){
var inst_27322 = (state_27413[(2)]);
var inst_27323 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27324 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_27325 = cljs.core.PersistentHashMap.fromArrays(inst_27323,inst_27324);
var inst_27326 = cljs.core.ex_info.call(null,inst_27322,inst_27325);
var inst_27327 = (function(){throw inst_27326})();
var state_27413__$1 = state_27413;
var statearr_27427_27497 = state_27413__$1;
(statearr_27427_27497[(2)] = inst_27327);

(statearr_27427_27497[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27414 === (31))){
var inst_27349 = (state_27413[(11)]);
var inst_27348 = (state_27413[(2)]);
var inst_27349__$1 = fluree.db.util.async.throw_err.call(null,inst_27348);
var state_27413__$1 = (function (){var statearr_27428 = state_27413;
(statearr_27428[(11)] = inst_27349__$1);

return statearr_27428;
})();
if(cljs.core.truth_(inst_27349__$1)){
var statearr_27429_27498 = state_27413__$1;
(statearr_27429_27498[(1)] = (32));

} else {
var statearr_27430_27499 = state_27413__$1;
(statearr_27430_27499[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27414 === (32))){
var inst_27349 = (state_27413[(11)]);
var inst_27353 = (inst_27349 == null);
var inst_27354 = cljs.core.not.call(null,inst_27353);
var state_27413__$1 = state_27413;
if(inst_27354){
var statearr_27431_27500 = state_27413__$1;
(statearr_27431_27500[(1)] = (35));

} else {
var statearr_27432_27501 = state_27413__$1;
(statearr_27432_27501[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27414 === (40))){
var inst_27364 = (state_27413[(2)]);
var state_27413__$1 = state_27413;
var statearr_27433_27502 = state_27413__$1;
(statearr_27433_27502[(2)] = inst_27364);

(statearr_27433_27502[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27414 === (33))){
var inst_27341 = (state_27413[(12)]);
var inst_27302 = (state_27413[(7)]);
var inst_27303 = (state_27413[(8)]);
var inst_27383 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27341)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27302),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27303),"."].join('');
var inst_27384 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27385 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_27386 = cljs.core.PersistentHashMap.fromArrays(inst_27384,inst_27385);
var inst_27387 = cljs.core.ex_info.call(null,inst_27383,inst_27386);
var inst_27388 = (function(){throw inst_27387})();
var state_27413__$1 = state_27413;
var statearr_27434_27503 = state_27413__$1;
(statearr_27434_27503[(2)] = inst_27388);

(statearr_27434_27503[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27414 === (13))){
var inst_27279 = (state_27413[(13)]);
var state_27413__$1 = state_27413;
var statearr_27435_27504 = state_27413__$1;
(statearr_27435_27504[(2)] = inst_27279);

(statearr_27435_27504[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27414 === (22))){
var inst_27335 = (state_27413[(14)]);
var inst_27310 = (state_27413[(9)]);
var inst_27334 = (state_27413[(2)]);
var inst_27335__$1 = fluree.db.util.async.throw_err.call(null,inst_27334);
var inst_27336 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27310);
var state_27413__$1 = (function (){var statearr_27436 = state_27413;
(statearr_27436[(14)] = inst_27335__$1);

(statearr_27436[(15)] = inst_27336);

return statearr_27436;
})();
if(cljs.core.truth_(inst_27335__$1)){
var statearr_27437_27505 = state_27413__$1;
(statearr_27437_27505[(1)] = (23));

} else {
var statearr_27438_27506 = state_27413__$1;
(statearr_27438_27506[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27414 === (36))){
var state_27413__$1 = state_27413;
var statearr_27439_27507 = state_27413__$1;
(statearr_27439_27507[(2)] = false);

(statearr_27439_27507[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27414 === (41))){
var inst_27349 = (state_27413[(11)]);
var inst_27369 = cljs.core.apply.call(null,cljs.core.hash_map,inst_27349);
var state_27413__$1 = state_27413;
var statearr_27440_27508 = state_27413__$1;
(statearr_27440_27508[(2)] = inst_27369);

(statearr_27440_27508[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27414 === (43))){
var inst_27340 = (state_27413[(16)]);
var inst_27372 = (state_27413[(2)]);
var inst_27373 = cljs.core.get.call(null,inst_27372,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_27374 = cljs.core.get.call(null,inst_27372,new cljs.core.Keyword(null,"block","block",664686210));
var inst_27375 = cljs.core.get.call(null,inst_27372,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_27376 = fluree.db.dbproto._with.call(null,inst_27340,inst_27374,inst_27373);
var state_27413__$1 = (function (){var statearr_27441 = state_27413;
(statearr_27441[(17)] = inst_27375);

return statearr_27441;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27413__$1,(44),inst_27376);
} else {
if((state_val_27414 === (29))){
var inst_27341 = (state_27413[(12)]);
var inst_27302 = (state_27413[(7)]);
var inst_27301 = (state_27413[(18)]);
var inst_27303 = (state_27413[(8)]);
var inst_27346 = fluree.db.storage.core.read_block.call(null,inst_27301,inst_27302,inst_27303,inst_27341);
var state_27413__$1 = state_27413;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27413__$1,(31),inst_27346);
} else {
if((state_val_27414 === (44))){
var inst_27341 = (state_27413[(12)]);
var inst_27378 = (state_27413[(2)]);
var inst_27379 = fluree.db.util.async.throw_err.call(null,inst_27378);
var inst_27380 = (inst_27341 + (1));
var inst_27340 = inst_27379;
var inst_27341__$1 = inst_27380;
var state_27413__$1 = (function (){var statearr_27442 = state_27413;
(statearr_27442[(12)] = inst_27341__$1);

(statearr_27442[(16)] = inst_27340);

return statearr_27442;
})();
var statearr_27443_27509 = state_27413__$1;
(statearr_27443_27509[(2)] = null);

(statearr_27443_27509[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27414 === (6))){
var inst_27279 = (state_27413[(13)]);
var inst_27284 = inst_27279.cljs$lang$protocol_mask$partition0$;
var inst_27285 = (inst_27284 & (64));
var inst_27286 = inst_27279.cljs$core$ISeq$;
var inst_27287 = (cljs.core.PROTOCOL_SENTINEL === inst_27286);
var inst_27288 = ((inst_27285) || (inst_27287));
var state_27413__$1 = state_27413;
if(cljs.core.truth_(inst_27288)){
var statearr_27444_27510 = state_27413__$1;
(statearr_27444_27510[(1)] = (9));

} else {
var statearr_27445_27511 = state_27413__$1;
(statearr_27445_27511[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27414 === (28))){
var inst_27340 = (state_27413[(16)]);
var state_27413__$1 = state_27413;
var statearr_27446_27512 = state_27413__$1;
(statearr_27446_27512[(2)] = inst_27340);

(statearr_27446_27512[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27414 === (25))){
var inst_27397 = (state_27413[(19)]);
var inst_27397__$1 = (state_27413[(2)]);
var inst_27398 = fluree.db.query.schema.schema_map.call(null,inst_27397__$1);
var state_27413__$1 = (function (){var statearr_27447 = state_27413;
(statearr_27447[(19)] = inst_27397__$1);

return statearr_27447;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27413__$1,(45),inst_27398);
} else {
if((state_val_27414 === (34))){
var inst_27390 = (state_27413[(2)]);
var state_27413__$1 = state_27413;
var statearr_27448_27513 = state_27413__$1;
(statearr_27448_27513[(2)] = inst_27390);

(statearr_27448_27513[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27414 === (17))){
var state_27413__$1 = state_27413;
var statearr_27449_27514 = state_27413__$1;
(statearr_27449_27514[(2)] = null);

(statearr_27449_27514[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27414 === (3))){
var inst_27411 = (state_27413[(2)]);
var state_27413__$1 = state_27413;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27413__$1,inst_27411);
} else {
if((state_val_27414 === (12))){
var inst_27279 = (state_27413[(13)]);
var inst_27297 = cljs.core.apply.call(null,cljs.core.hash_map,inst_27279);
var state_27413__$1 = state_27413;
var statearr_27450_27515 = state_27413__$1;
(statearr_27450_27515[(2)] = inst_27297);

(statearr_27450_27515[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27414 === (2))){
var inst_27279 = (state_27413[(13)]);
var _ = (function (){var statearr_27451 = state_27413;
(statearr_27451[(4)] = cljs.core.cons.call(null,(5),(state_27413[(4)])));

return statearr_27451;
})();
var inst_27278 = new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
var inst_27279__$1 = session;
var inst_27281 = (inst_27279__$1 == null);
var inst_27282 = cljs.core.not.call(null,inst_27281);
var state_27413__$1 = (function (){var statearr_27452 = state_27413;
(statearr_27452[(20)] = inst_27278);

(statearr_27452[(13)] = inst_27279__$1);

return statearr_27452;
})();
if(inst_27282){
var statearr_27453_27516 = state_27413__$1;
(statearr_27453_27516[(1)] = (6));

} else {
var statearr_27454_27517 = state_27413__$1;
(statearr_27454_27517[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27414 === (23))){
var inst_27335 = (state_27413[(14)]);
var inst_27338 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27335);
var inst_27339 = (inst_27338 + (1));
var inst_27340 = inst_27335;
var inst_27341 = inst_27339;
var state_27413__$1 = (function (){var statearr_27455 = state_27413;
(statearr_27455[(12)] = inst_27341);

(statearr_27455[(16)] = inst_27340);

return statearr_27455;
})();
var statearr_27456_27518 = state_27413__$1;
(statearr_27456_27518[(2)] = null);

(statearr_27456_27518[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27414 === (35))){
var inst_27349 = (state_27413[(11)]);
var inst_27356 = inst_27349.cljs$lang$protocol_mask$partition0$;
var inst_27357 = (inst_27356 & (64));
var inst_27358 = inst_27349.cljs$core$ISeq$;
var inst_27359 = (cljs.core.PROTOCOL_SENTINEL === inst_27358);
var inst_27360 = ((inst_27357) || (inst_27359));
var state_27413__$1 = state_27413;
if(cljs.core.truth_(inst_27360)){
var statearr_27457_27519 = state_27413__$1;
(statearr_27457_27519[(1)] = (38));

} else {
var statearr_27458_27520 = state_27413__$1;
(statearr_27458_27520[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27414 === (19))){
var inst_27302 = (state_27413[(7)]);
var inst_27303 = (state_27413[(8)]);
var inst_27317 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27302),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27303)," is not found on this ledger group."].join('');
var state_27413__$1 = state_27413;
var statearr_27459_27521 = state_27413__$1;
(statearr_27459_27521[(2)] = inst_27317);

(statearr_27459_27521[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27414 === (11))){
var inst_27292 = (state_27413[(2)]);
var state_27413__$1 = state_27413;
var statearr_27461_27522 = state_27413__$1;
(statearr_27461_27522[(2)] = inst_27292);

(statearr_27461_27522[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27414 === (9))){
var state_27413__$1 = state_27413;
var statearr_27462_27523 = state_27413__$1;
(statearr_27462_27523[(2)] = true);

(statearr_27462_27523[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27414 === (5))){
var _ = (function (){var statearr_27463 = state_27413;
(statearr_27463[(4)] = cljs.core.rest.call(null,(state_27413[(4)])));

return statearr_27463;
})();
var state_27413__$1 = state_27413;
var ex27460 = (state_27413__$1[(2)]);
var statearr_27464_27524 = state_27413__$1;
(statearr_27464_27524[(5)] = ex27460);


if((ex27460 instanceof java.lang.Exception)){
var statearr_27465_27525 = state_27413__$1;
(statearr_27465_27525[(1)] = (4));

(statearr_27465_27525[(5)] = null);

} else {
throw ex27460;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27414 === (14))){
var inst_27302 = (state_27413[(7)]);
var inst_27301 = (state_27413[(18)]);
var inst_27303 = (state_27413[(8)]);
var inst_27300 = (state_27413[(2)]);
var inst_27301__$1 = cljs.core.get.call(null,inst_27300,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_27302__$1 = cljs.core.get.call(null,inst_27300,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_27303__$1 = cljs.core.get.call(null,inst_27300,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_27304 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27305 = [inst_27302__$1,inst_27303__$1];
var inst_27306 = (new cljs.core.PersistentVector(null,2,(5),inst_27304,inst_27305,null));
var inst_27307 = fluree.db.operations.ledger_info_async.call(null,inst_27301__$1,inst_27306);
var state_27413__$1 = (function (){var statearr_27466 = state_27413;
(statearr_27466[(7)] = inst_27302__$1);

(statearr_27466[(18)] = inst_27301__$1);

(statearr_27466[(8)] = inst_27303__$1);

return statearr_27466;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27413__$1,(15),inst_27307);
} else {
if((state_val_27414 === (45))){
var inst_27397 = (state_27413[(19)]);
var inst_27402 = (state_27413[(10)]);
var inst_27400 = (state_27413[(2)]);
var inst_27401 = fluree.db.util.async.throw_err.call(null,inst_27400);
var inst_27402__$1 = cljs.core.assoc.call(null,inst_27397,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_27401);
var inst_27403 = fluree.db.query.schema.setting_map.call(null,inst_27402__$1);
var state_27413__$1 = (function (){var statearr_27467 = state_27413;
(statearr_27467[(10)] = inst_27402__$1);

return statearr_27467;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27413__$1,(46),inst_27403);
} else {
if((state_val_27414 === (26))){
var inst_27341 = (state_27413[(12)]);
var inst_27336 = (state_27413[(15)]);
var inst_27343 = (inst_27341 > inst_27336);
var state_27413__$1 = state_27413;
if(cljs.core.truth_(inst_27343)){
var statearr_27468_27526 = state_27413__$1;
(statearr_27468_27526[(1)] = (28));

} else {
var statearr_27469_27527 = state_27413__$1;
(statearr_27469_27527[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27414 === (16))){
var inst_27310 = (state_27413[(9)]);
var inst_27315 = cljs.core.empty_QMARK_.call(null,inst_27310);
var state_27413__$1 = state_27413;
if(inst_27315){
var statearr_27470_27528 = state_27413__$1;
(statearr_27470_27528[(1)] = (19));

} else {
var statearr_27471_27529 = state_27413__$1;
(statearr_27471_27529[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27414 === (38))){
var state_27413__$1 = state_27413;
var statearr_27472_27530 = state_27413__$1;
(statearr_27472_27530[(2)] = true);

(statearr_27472_27530[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27414 === (30))){
var inst_27392 = (state_27413[(2)]);
var state_27413__$1 = state_27413;
var statearr_27473_27531 = state_27413__$1;
(statearr_27473_27531[(2)] = inst_27392);

(statearr_27473_27531[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27414 === (10))){
var state_27413__$1 = state_27413;
var statearr_27474_27532 = state_27413__$1;
(statearr_27474_27532[(2)] = false);

(statearr_27474_27532[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27414 === (18))){
var inst_27302 = (state_27413[(7)]);
var inst_27278 = (state_27413[(20)]);
var inst_27301 = (state_27413[(18)]);
var inst_27303 = (state_27413[(8)]);
var inst_27310 = (state_27413[(9)]);
var inst_27330 = (state_27413[(2)]);
var inst_27331 = new cljs.core.Keyword(null,"index","index",-1531685915).cljs$core$IFn$_invoke$arity$1(inst_27310);
var inst_27332 = fluree.db.storage.core.reify_db.call(null,inst_27301,inst_27302,inst_27303,inst_27278,inst_27331);
var state_27413__$1 = (function (){var statearr_27475 = state_27413;
(statearr_27475[(21)] = inst_27330);

return statearr_27475;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27413__$1,(22),inst_27332);
} else {
if((state_val_27414 === (42))){
var inst_27349 = (state_27413[(11)]);
var state_27413__$1 = state_27413;
var statearr_27476_27533 = state_27413__$1;
(statearr_27476_27533[(2)] = inst_27349);

(statearr_27476_27533[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27414 === (37))){
var inst_27367 = (state_27413[(2)]);
var state_27413__$1 = state_27413;
if(cljs.core.truth_(inst_27367)){
var statearr_27477_27534 = state_27413__$1;
(statearr_27477_27534[(1)] = (41));

} else {
var statearr_27478_27535 = state_27413__$1;
(statearr_27478_27535[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27414 === (8))){
var inst_27295 = (state_27413[(2)]);
var state_27413__$1 = state_27413;
if(cljs.core.truth_(inst_27295)){
var statearr_27479_27536 = state_27413__$1;
(statearr_27479_27536[(1)] = (12));

} else {
var statearr_27480_27537 = state_27413__$1;
(statearr_27480_27537[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$full_load_existing_db_$_state_machine__2468__auto__ = null;
var fluree$db$session$full_load_existing_db_$_state_machine__2468__auto____0 = (function (){
var statearr_27481 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27481[(0)] = fluree$db$session$full_load_existing_db_$_state_machine__2468__auto__);

(statearr_27481[(1)] = (1));

return statearr_27481;
});
var fluree$db$session$full_load_existing_db_$_state_machine__2468__auto____1 = (function (state_27413){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_27413);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e27482){var ex__2471__auto__ = e27482;
var statearr_27483_27538 = state_27413;
(statearr_27483_27538[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_27413[(4)]))){
var statearr_27484_27539 = state_27413;
(statearr_27484_27539[(1)] = cljs.core.first.call(null,(state_27413[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27540 = state_27413;
state_27413 = G__27540;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$session$full_load_existing_db_$_state_machine__2468__auto__ = function(state_27413){
switch(arguments.length){
case 0:
return fluree$db$session$full_load_existing_db_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$session$full_load_existing_db_$_state_machine__2468__auto____1.call(this,state_27413);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$full_load_existing_db_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$full_load_existing_db_$_state_machine__2468__auto____0;
fluree$db$session$full_load_existing_db_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$full_load_existing_db_$_state_machine__2468__auto____1;
return fluree$db$session$full_load_existing_db_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_27485 = f__2491__auto__.call(null);
(statearr_27485[(6)] = c__2490__auto___27486);

return statearr_27485;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));


return pc;
});
/**
 * Performs a compare and set! to update db, but only does so if
 *   existing db promise-chan is the same as old-db-ch.
 * 
 *   Returns true if successful, false if it did not replace.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(session,old_db_ch,new_db_ch){
var new_state = cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (state){
if(cljs.core._EQ_.call(null,old_db_ch,new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(state))){
return cljs.core.assoc.call(null,state,new cljs.core.Keyword("db","db","db/db",993247817),new_db_ch);
} else {
return state;
}
}));
return cljs.core._EQ_.call(null,new_db_ch,new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(new_state));
});
/**
 * Clears db from cache, forcing a new full load next time db is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(session){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","db","db/db",993247817),null);
});
/**
 * Clears any current db that is cached and forces a db reload.
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(session){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","db","db/db",993247817),fluree.db.session.full_load_existing_db.call(null,session));
});
/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_QMARK_ = (function fluree$db$session$indexing_QMARK_(session){
return new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return new cljs.core.Keyword("db","indexed","db/indexed",390759770).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock, and if successful returns true, else false.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,block){
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
var G__27541 = s;
if((new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.call(null,G__27541,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),block);
} else {
return G__27541;
}
}));

return cljs.core._EQ_.call(null,block,fluree.db.session.indexing_QMARK_.call(null,session));
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword("db","indexed","db/indexed",390759770),block);
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.call(null,cljs.cache.lru_cache_factory.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"threshold","threshold",204221583),(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(conn,network,alias){
var or__4126__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var dbid = alias;
cljs.core.swap_BANG_.call(null,fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),dbid);

return dbid;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_.call(null,ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.call(null,ledger);
var network = cljs.core.namespace.call(null,ledger__$1);
var maybe_alias = cljs.core.name.call(null,ledger__$1);
var _ = (cljs.core.truth_((function (){var and__4115__auto__ = network;
if(cljs.core.truth_(and__4115__auto__)){
return maybe_alias;
} else {
return and__4115__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.call(null,["Invalid ledger identity: ",cljs.core.pr_str.call(null,ledger__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null))})());
if(clojure.string.starts_with_QMARK_.call(null,maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.call(null,maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id.call(null,conn,network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__4619__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4620__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4621__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4622__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4623__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4623__auto__,method_table__4619__auto__,prefer_table__4620__auto__,method_cache__4621__auto__,cached_hierarchy__4622__auto__));
})();
}
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"block","block",664686210),(function (session,event_type,p__27543){
var map__27544 = p__27543;
var map__27544__$1 = (((((!((map__27544 == null))))?(((((map__27544.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27544.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27544):map__27544);
var data = map__27544__$1;
var block = cljs.core.get.call(null,map__27544__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__27544__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.call(null,map__27544__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_27593){
var state_val_27594 = (state_27593[(1)]);
if((state_val_27594 === (7))){
var inst_27559 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27560 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_27561 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27559),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27560),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current. No-op."].join('');
var inst_27562 = fluree.db.util.log.info.call(null,inst_27561);
var state_27593__$1 = state_27593;
var statearr_27595_27625 = state_27593__$1;
(statearr_27595_27625[(2)] = inst_27562);

(statearr_27595_27625[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27594 === (1))){
var state_27593__$1 = state_27593;
var statearr_27596_27626 = state_27593__$1;
(statearr_27596_27626[(2)] = null);

(statearr_27596_27626[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27594 === (4))){
var inst_27546 = (state_27593[(2)]);
var state_27593__$1 = state_27593;
var statearr_27597_27627 = state_27593__$1;
(statearr_27597_27627[(2)] = inst_27546);

(statearr_27597_27627[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27594 === (15))){
var inst_27584 = (state_27593[(2)]);
var state_27593__$1 = state_27593;
var statearr_27598_27628 = state_27593__$1;
(statearr_27598_27628[(2)] = inst_27584);

(statearr_27598_27628[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27594 === (13))){
var inst_27556 = (state_27593[(7)]);
var inst_27577 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27578 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_27579 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27577),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27578),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27556),". Forcing a db reload."].join('');
var inst_27580 = fluree.db.util.log.info.call(null,inst_27579);
var inst_27581 = fluree.db.session.reload_db_BANG_.call(null,session);
var state_27593__$1 = (function (){var statearr_27599 = state_27593;
(statearr_27599[(8)] = inst_27580);

return statearr_27599;
})();
var statearr_27600_27629 = state_27593__$1;
(statearr_27600_27629[(2)] = inst_27581);

(statearr_27600_27629[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27594 === (6))){
var inst_27556 = (state_27593[(7)]);
var inst_27555 = (state_27593[(9)]);
var inst_27554 = (state_27593[(2)]);
var inst_27555__$1 = fluree.db.util.async.throw_err.call(null,inst_27554);
var inst_27556__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27555__$1);
var inst_27557 = (block <= inst_27556__$1);
var state_27593__$1 = (function (){var statearr_27601 = state_27593;
(statearr_27601[(7)] = inst_27556__$1);

(statearr_27601[(9)] = inst_27555__$1);

return statearr_27601;
})();
if(cljs.core.truth_(inst_27557)){
var statearr_27602_27630 = state_27593__$1;
(statearr_27602_27630[(1)] = (7));

} else {
var statearr_27603_27631 = state_27593__$1;
(statearr_27603_27631[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27594 === (3))){
var inst_27591 = (state_27593[(2)]);
var state_27593__$1 = state_27593;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27593__$1,inst_27591);
} else {
if((state_val_27594 === (12))){
var inst_27586 = (state_27593[(2)]);
var state_27593__$1 = state_27593;
var statearr_27604_27632 = state_27593__$1;
(statearr_27604_27632[(2)] = inst_27586);

(statearr_27604_27632[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27594 === (2))){
var inst_27552 = (state_27593[(10)]);
var _ = (function (){var statearr_27605 = state_27593;
(statearr_27605[(4)] = cljs.core.cons.call(null,(5),(state_27593[(4)])));

return statearr_27605;
})();
var inst_27552__$1 = fluree.db.session.current_db.call(null,session);
var state_27593__$1 = (function (){var statearr_27606 = state_27593;
(statearr_27606[(10)] = inst_27552__$1);

return statearr_27606;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27593__$1,(6),inst_27552__$1);
} else {
if((state_val_27594 === (11))){
var state_27593__$1 = state_27593;
var statearr_27608_27633 = state_27593__$1;
(statearr_27608_27633[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27594 === (9))){
var inst_27588 = (state_27593[(2)]);
var _ = (function (){var statearr_27610 = state_27593;
(statearr_27610[(4)] = cljs.core.rest.call(null,(state_27593[(4)])));

return statearr_27610;
})();
var state_27593__$1 = state_27593;
var statearr_27611_27634 = state_27593__$1;
(statearr_27611_27634[(2)] = inst_27588);

(statearr_27611_27634[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27594 === (5))){
var _ = (function (){var statearr_27612 = state_27593;
(statearr_27612[(4)] = cljs.core.rest.call(null,(state_27593[(4)])));

return statearr_27612;
})();
var state_27593__$1 = state_27593;
var ex27607 = (state_27593__$1[(2)]);
var statearr_27613_27635 = state_27593__$1;
(statearr_27613_27635[(5)] = ex27607);


if((ex27607 instanceof Error)){
var statearr_27614_27636 = state_27593__$1;
(statearr_27614_27636[(1)] = (4));

(statearr_27614_27636[(5)] = null);

} else {
throw ex27607;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27594 === (14))){
var state_27593__$1 = state_27593;
var statearr_27615_27637 = state_27593__$1;
(statearr_27615_27637[(2)] = null);

(statearr_27615_27637[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27594 === (10))){
var inst_27552 = (state_27593[(10)]);
var inst_27556 = (state_27593[(7)]);
var inst_27555 = (state_27593[(9)]);
var inst_27567 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27568 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_27569 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27567),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27568),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_27570 = fluree.db.util.log.trace.call(null,inst_27569);
var inst_27571 = (function (){var current_db_ch = inst_27552;
var current_db = inst_27555;
var current_block = inst_27556;
return (function (p1__27542_SHARP_){
if((p1__27542_SHARP_ instanceof fluree.db.flake.Flake)){
return p1__27542_SHARP_;
} else {
return fluree.db.flake.parts__GT_Flake.call(null,p1__27542_SHARP_);
}
});
})();
var inst_27572 = cljs.core.map.call(null,inst_27571,flakes);
var inst_27573 = fluree.db.dbproto._with.call(null,inst_27555,block,inst_27572);
var inst_27574 = fluree.db.session.cas_db_BANG_.call(null,session,inst_27552,inst_27573);
var state_27593__$1 = (function (){var statearr_27616 = state_27593;
(statearr_27616[(11)] = inst_27570);

return statearr_27616;
})();
var statearr_27617_27638 = state_27593__$1;
(statearr_27617_27638[(2)] = inst_27574);

(statearr_27617_27638[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27594 === (8))){
var inst_27556 = (state_27593[(7)]);
var inst_27564 = ((1) + inst_27556);
var inst_27565 = cljs.core._EQ_.call(null,block,inst_27564);
var state_27593__$1 = state_27593;
if(inst_27565){
var statearr_27618_27639 = state_27593__$1;
(statearr_27618_27639[(1)] = (10));

} else {
var statearr_27619_27640 = state_27593__$1;
(statearr_27619_27640[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2468__auto__ = null;
var fluree$db$session$state_machine__2468__auto____0 = (function (){
var statearr_27620 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27620[(0)] = fluree$db$session$state_machine__2468__auto__);

(statearr_27620[(1)] = (1));

return statearr_27620;
});
var fluree$db$session$state_machine__2468__auto____1 = (function (state_27593){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_27593);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e27621){var ex__2471__auto__ = e27621;
var statearr_27622_27641 = state_27593;
(statearr_27622_27641[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_27593[(4)]))){
var statearr_27623_27642 = state_27593;
(statearr_27623_27642[(1)] = cljs.core.first.call(null,(state_27593[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27643 = state_27593;
state_27593 = G__27643;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$session$state_machine__2468__auto__ = function(state_27593){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2468__auto____1.call(this,state_27593);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2468__auto____0;
fluree$db$session$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2468__auto____1;
return fluree$db$session$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_27624 = f__2491__auto__.call(null);
(statearr_27624[(6)] = c__2490__auto__);

return statearr_27624;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"new-index","new-index",518435631),(function (session,header,block){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_27650){
var state_val_27651 = (state_27650[(1)]);
if((state_val_27651 === (1))){
var inst_27644 = fluree.db.session.clear_db_BANG_.call(null,session);
var inst_27645 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27646 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_27647 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27645),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27646)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_27648 = fluree.db.util.log.debug.call(null,inst_27647);
var state_27650__$1 = (function (){var statearr_27652 = state_27650;
(statearr_27652[(7)] = inst_27648);

(statearr_27652[(8)] = inst_27644);

return statearr_27652;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27650__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2468__auto__ = null;
var fluree$db$session$state_machine__2468__auto____0 = (function (){
var statearr_27653 = [null,null,null,null,null,null,null,null,null];
(statearr_27653[(0)] = fluree$db$session$state_machine__2468__auto__);

(statearr_27653[(1)] = (1));

return statearr_27653;
});
var fluree$db$session$state_machine__2468__auto____1 = (function (state_27650){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_27650);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e27654){var ex__2471__auto__ = e27654;
var statearr_27655_27658 = state_27650;
(statearr_27655_27658[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_27650[(4)]))){
var statearr_27656_27659 = state_27650;
(statearr_27656_27659[(1)] = cljs.core.first.call(null,(state_27650[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27660 = state_27650;
state_27650 = G__27660;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$session$state_machine__2468__auto__ = function(state_27650){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2468__auto____1.call(this,state_27650);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2468__auto____0;
fluree$db$session$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2468__auto____1;
return fluree$db$session$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_27657 = f__2491__auto__.call(null);
(statearr_27657[(6)] = c__2490__auto__);

return statearr_27657;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return new cljs.core.Keyword(null,"closed?","closed?",-1408769040).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + dbid will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__27662 = arguments.length;
switch (G__27662) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (session){
if(cljs.core.truth_(fluree.db.session.closed_QMARK_.call(null,session))){
return false;
} else {
var map__27663 = session;
var map__27663__$1 = (((((!((map__27663 == null))))?(((((map__27663.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27663.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27663):map__27663);
var conn = cljs.core.get.call(null,map__27663__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var update_chan = cljs.core.get.call(null,map__27663__$1,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792));
var transact_chan = cljs.core.get.call(null,map__27663__$1,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840));
var state = cljs.core.get.call(null,map__27663__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var network = cljs.core.get.call(null,map__27663__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__27663__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var id = cljs.core.get.call(null,map__27663__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var closed_QMARK_ = fluree.db.session.closed_QMARK_.call(null,session);
if(cljs.core.truth_(closed_QMARK_)){
fluree.db.session.remove_cache_BANG_.call(null,network,dbid);

return false;
} else {
cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),true);

new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(conn).call(null,network,dbid,id);

cljs.core.async.close_BANG_.call(null,update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_.call(null,transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_.call(null,network,dbid);

if(cljs.core.fn_QMARK_.call(null,new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session))){
new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session).call(null);
} else {
}

return true;
}
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,dbid){
var temp__5733__auto__ = fluree.db.session.from_cache.call(null,network,dbid);
if(cljs.core.truth_(temp__5733__auto__)){
var session = temp__5733__auto__;
return fluree.db.session.close.call(null,session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_27718){
var state_val_27719 = (state_27718[(1)]);
if((state_val_27719 === (7))){
var inst_27714 = (state_27718[(2)]);
var state_27718__$1 = state_27718;
var statearr_27720_27751 = state_27718__$1;
(statearr_27720_27751[(2)] = inst_27714);

(statearr_27720_27751[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27719 === (1))){
var state_27718__$1 = state_27718;
var statearr_27721_27752 = state_27718__$1;
(statearr_27721_27752[(2)] = null);

(statearr_27721_27752[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27719 === (4))){
var inst_27669 = (state_27718[(7)]);
var inst_27668 = (state_27718[(2)]);
var inst_27669__$1 = fluree.db.util.async.throw_err.call(null,inst_27668);
var inst_27670 = fluree.db.session.from_cache.call(null,network,ledger_id);
var inst_27671 = (inst_27669__$1 == null);
var state_27718__$1 = (function (){var statearr_27722 = state_27718;
(statearr_27722[(8)] = inst_27670);

(statearr_27722[(7)] = inst_27669__$1);

return statearr_27722;
})();
if(cljs.core.truth_(inst_27671)){
var statearr_27723_27753 = state_27718__$1;
(statearr_27723_27753[(1)] = (5));

} else {
var statearr_27724_27754 = state_27718__$1;
(statearr_27724_27754[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27719 === (15))){
var inst_27706 = (state_27718[(2)]);
var state_27718__$1 = (function (){var statearr_27725 = state_27718;
(statearr_27725[(9)] = inst_27706);

return statearr_27725;
})();
var statearr_27726_27755 = state_27718__$1;
(statearr_27726_27755[(2)] = null);

(statearr_27726_27755[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27719 === (13))){
var inst_27710 = (state_27718[(2)]);
var state_27718__$1 = state_27718;
var statearr_27728_27756 = state_27718__$1;
(statearr_27728_27756[(2)] = inst_27710);

(statearr_27728_27756[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27719 === (6))){
var inst_27670 = (state_27718[(8)]);
var inst_27676 = (inst_27670 == null);
var state_27718__$1 = state_27718;
if(cljs.core.truth_(inst_27676)){
var statearr_27729_27757 = state_27718__$1;
(statearr_27729_27757[(1)] = (8));

} else {
var statearr_27730_27758 = state_27718__$1;
(statearr_27730_27758[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27719 === (17))){
var _ = (function (){var statearr_27731 = state_27718;
(statearr_27731[(4)] = cljs.core.rest.call(null,(state_27718[(4)])));

return statearr_27731;
})();
var state_27718__$1 = state_27718;
var ex27727 = (state_27718__$1[(2)]);
var statearr_27732_27759 = state_27718__$1;
(statearr_27732_27759[(5)] = ex27727);


if((ex27727 instanceof java.lang.Exception)){
var statearr_27733_27760 = state_27718__$1;
(statearr_27733_27760[(1)] = (16));

(statearr_27733_27760[(5)] = null);

} else {
throw ex27727;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27719 === (3))){
var inst_27716 = (state_27718[(2)]);
var state_27718__$1 = state_27718;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27718__$1,inst_27716);
} else {
if((state_val_27719 === (12))){
var state_27718__$1 = state_27718;
var statearr_27734_27761 = state_27718__$1;
(statearr_27734_27761[(2)] = null);

(statearr_27734_27761[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27719 === (2))){
var state_27718__$1 = state_27718;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27718__$1,(4),update_chan);
} else {
if((state_val_27719 === (11))){
var state_27718__$1 = state_27718;
var statearr_27735_27762 = state_27718__$1;
(statearr_27735_27762[(2)] = null);

(statearr_27735_27762[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27719 === (9))){
var state_27718__$1 = state_27718;
var statearr_27736_27763 = state_27718__$1;
(statearr_27736_27763[(1)] = (11));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27719 === (5))){
var inst_27673 = ["Channel closed for session updates for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_27674 = fluree.db.util.log.info.call(null,inst_27673);
var state_27718__$1 = state_27718;
var statearr_27738_27764 = state_27718__$1;
(statearr_27738_27764[(2)] = inst_27674);

(statearr_27738_27764[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27719 === (14))){
var inst_27670 = (state_27718[(8)]);
var inst_27669 = (state_27718[(7)]);
var _ = (function (){var statearr_27739 = state_27718;
(statearr_27739[(4)] = cljs.core.cons.call(null,(17),(state_27718[(4)])));

return statearr_27739;
})();
var inst_27694 = cljs.core.nth.call(null,inst_27669,(0),null);
var inst_27695 = cljs.core.nth.call(null,inst_27669,(1),null);
var inst_27696 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_27697 = cljs.core.pr_str.call(null,inst_27669);
var inst_27698 = fluree.db.util.core.trunc.call(null,inst_27697,(200));
var inst_27699 = fluree.db.util.log.trace.call(null,inst_27696,inst_27698);
var inst_27700 = fluree.db.session.process_ledger_update.call(null,inst_27670,inst_27694,inst_27695);
var state_27718__$1 = (function (){var statearr_27740 = state_27718;
(statearr_27740[(10)] = inst_27699);

return statearr_27740;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27718__$1,(18),inst_27700);
} else {
if((state_val_27719 === (16))){
var inst_27669 = (state_27718[(7)]);
var inst_27684 = (state_27718[(2)]);
var inst_27685 = fluree.db.util.log.error.call(null,inst_27684,"Exception processing ledger updates for message: ",inst_27669);
var state_27718__$1 = state_27718;
var statearr_27741_27765 = state_27718__$1;
(statearr_27741_27765[(2)] = inst_27685);

(statearr_27741_27765[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27719 === (10))){
var inst_27712 = (state_27718[(2)]);
var state_27718__$1 = state_27718;
var statearr_27742_27766 = state_27718__$1;
(statearr_27742_27766[(2)] = inst_27712);

(statearr_27742_27766[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27719 === (18))){
var inst_27702 = (state_27718[(2)]);
var inst_27703 = fluree.db.util.async.throw_err.call(null,inst_27702);
var _ = (function (){var statearr_27743 = state_27718;
(statearr_27743[(4)] = cljs.core.rest.call(null,(state_27718[(4)])));

return statearr_27743;
})();
var state_27718__$1 = state_27718;
var statearr_27744_27767 = state_27718__$1;
(statearr_27744_27767[(2)] = inst_27703);

(statearr_27744_27767[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27719 === (8))){
var inst_27669 = (state_27718[(7)]);
var inst_27678 = cljs.core.first.call(null,inst_27669);
var inst_27679 = cljs.core.pr_str.call(null,inst_27678);
var inst_27680 = ["Ledger update received for session that is no longer open: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Message: ",inst_27679].join('');
var inst_27681 = fluree.db.util.log.warn.call(null,inst_27680);
var state_27718__$1 = state_27718;
var statearr_27745_27768 = state_27718__$1;
(statearr_27745_27768[(2)] = inst_27681);

(statearr_27745_27768[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__2468__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__2468__auto____0 = (function (){
var statearr_27746 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_27746[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__2468__auto__);

(statearr_27746[(1)] = (1));

return statearr_27746;
});
var fluree$db$session$process_ledger_updates_$_state_machine__2468__auto____1 = (function (state_27718){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_27718);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e27747){var ex__2471__auto__ = e27747;
var statearr_27748_27769 = state_27718;
(statearr_27748_27769[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_27718[(4)]))){
var statearr_27749_27770 = state_27718;
(statearr_27749_27770[(1)] = cljs.core.first.call(null,(state_27718[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27771 = state_27718;
state_27718 = G__27771;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__2468__auto__ = function(state_27718){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__2468__auto____1.call(this,state_27718);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__2468__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__2468__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_27750 = f__2491__auto__.call(null);
(statearr_27750[(6)] = c__2490__auto__);

return statearr_27750;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Creates a connection without first checking if db exists. Only useful if reloading
 *   and replacing an existing DB.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__27772){
var map__27773 = p__27772;
var map__27773__$1 = (((((!((map__27773 == null))))?(((((map__27773.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27773.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27773):map__27773);
var network = cljs.core.get.call(null,map__27773__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.call(null,map__27773__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var dbid = cljs.core.get.call(null,map__27773__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var db = cljs.core.get.call(null,map__27773__$1,new cljs.core.Keyword(null,"db","db",993250759));
var transactor_QMARK_ = cljs.core.get.call(null,map__27773__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057));
var db_name = cljs.core.get.call(null,map__27773__$1,new cljs.core.Keyword(null,"db-name","db-name",1157928745));
var state = cljs.core.get.call(null,map__27773__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var close = cljs.core.get.call(null,map__27773__$1,new cljs.core.Keyword(null,"close","close",1835149582));
var id = cljs.core.get.call(null,map__27773__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var schema_cache = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var update_chan = cljs.core.async.chan.call(null);
var transact_chan = (cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.call(null):null);
var state__$1 = cljs.core.atom.call(null,cljs.core.merge.call(null,state,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword("req","sync","req/sync",-624297648),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("req","count","req/count",2145574363),(0),new cljs.core.Keyword("req","last","req/last",1105783038),null,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("db","db","db/db",993247817),(cljs.core.truth_(db)?cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),schema_cache):null),new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),false], null)));
var session = fluree.db.session.map__GT_DbSession.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"conn","conn",278309663)],[dbid,update_chan,db_name,state__$1,close,id,schema_cache,transact_chan,network,null,conn]));
var current_db_fn = (function (){
return fluree.db.session.current_db.call(null,session);
});
var blank_db = fluree.db.graphdb.blank_db.call(null,conn,network,dbid,schema_cache,current_db_fn);
return cljs.core.assoc.call(null,session,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__27778 = block_result;
var map__27778__$1 = (((((!((map__27778 == null))))?(((((map__27778.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27778.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27778):map__27778);
var block = cljs.core.get.call(null,map__27778__$1,new cljs.core.Keyword(null,"block","block",664686210));
var hash = cljs.core.get.call(null,map__27778__$1,new cljs.core.Keyword(null,"hash","hash",-13781596));
var instant = cljs.core.get.call(null,map__27778__$1,new cljs.core.Keyword(null,"instant","instant",655498374));
var txns = cljs.core.get.call(null,map__27778__$1,new cljs.core.Keyword(null,"txns","txns",-1492102421));
var flakes = cljs.core.get.call(null,map__27778__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var tx_result = (function (){var or__4126__auto__ = cljs.core.get.call(null,txns,cljs.core.keyword.call(null,txid));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.call(null,txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.call(null,["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597),new cljs.core.Keyword(null,"block","block",664686210),cljs.core.pr_str.call(null,block_result)], null))})());
var map__27779 = tx_result;
var map__27779__$1 = (((((!((map__27779 == null))))?(((((map__27779.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27779.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27779):map__27779);
var t = cljs.core.get.call(null,map__27779__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var status = cljs.core.get.call(null,map__27779__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var t_filter = (((cljs.core.first.call(null,flakes) instanceof fluree.db.flake.Flake))?(function (p1__27775_SHARP_){
return cljs.core._EQ_.call(null,t,p1__27775_SHARP_.t);
}):(function (p1__27776_SHARP_){
return cljs.core._EQ_.call(null,t,cljs.core.nth.call(null,p1__27776_SHARP_,(3)));
}));
var response = cljs.core.assoc.call(null,tx_result,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.filter.call(null,t_filter,flakes));
if((new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some.call(null,(function (p1__27777_SHARP_){
if(cljs.core._EQ_.call(null,(109),cljs.core.second.call(null,p1__27777_SHARP_))){
return cljs.core.nth.call(null,p1__27777_SHARP_,(2));
} else {
return null;
}
}),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(response));
var vec__27782 = (cljs.core.truth_(error_msg)?cljs.core.re_find.call(null,/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.call(null,vec__27782,(0),null);
var status__$1 = cljs.core.nth.call(null,vec__27782,(1),null);
var error = cljs.core.nth.call(null,vec__27782,(2),null);
var message = cljs.core.nth.call(null,vec__27782,(3),null);
return cljs.core.ex_info.call(null,(function (){var or__4126__auto__ = message;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response),new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.keyword.call(null,error),new cljs.core.Keyword(null,"meta","meta",1499536964),response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
var _ = fluree.db.util.log.trace.call(null,"Create and cache session. Opt keys: ",cljs.core.keys.call(null,opts));
var id = fluree.db.util.core.random_uuid.call(null);
var session = fluree.db.session.session_factory.call(null,cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"id","id",-1388402092),id));
var session_STAR_ = fluree.db.session.cache_BANG_.call(null,session);
var new_QMARK_ = cljs.core._EQ_.call(null,id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.call(null,session_STAR_,new cljs.core.Keyword(null,"new?","new?",777958557),true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__27786 = arguments.length;
switch (G__27786) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.call(null,conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__27787){
var map__27788 = p__27787;
var map__27788__$1 = (((((!((map__27788 == null))))?(((((map__27788.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27788.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27788):map__27788);
var state = cljs.core.get.call(null,map__27788__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var connect_QMARK_ = cljs.core.get.call(null,map__27788__$1,new cljs.core.Keyword(null,"connect?","connect?",1326309520));
var auth = cljs.core.get.call(null,map__27788__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.call(null,map__27788__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var vec__27790 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__27790,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__27790,(1),null);
var ledger_alias = cljs.core.nth.call(null,vec__27790,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
var or__4126__auto__ = fluree.db.session.from_cache.call(null,network,ledger_id);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var session = fluree.db.session.create_and_cache_session.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),ledger_id,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"state","state",-1988618099),(function (){var or__4126__auto____$1 = state;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),transactor_QMARK_], null));
var new_QMARK_ = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.call(null,session,opts);

new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(conn).call(null,network,ledger_id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session),(function (event_type,event_data){
cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"block","block",664686210),event_type)){
var temp__5735__auto__ = cljs.core.not_empty.call(null,cljs.core.get.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620)));
if(cljs.core.truth_(temp__5735__auto__)){
var tx_callbacks = temp__5735__auto__;
var tids = cljs.core.keys.call(null,new cljs.core.Keyword(null,"txns","txns",-1492102421).cljs$core$IFn$_invoke$arity$1(event_data));
var seq__27793 = cljs.core.seq.call(null,tids);
var chunk__27794 = null;
var count__27795 = (0);
var i__27796 = (0);
while(true){
if((i__27796 < count__27795)){
var tid = cljs.core._nth.call(null,chunk__27794,i__27796);
var temp__5735__auto___27909__$1 = cljs.core.get.call(null,tx_callbacks,fluree.db.util.core.keyword__GT_str.call(null,tid));
if(cljs.core.truth_(temp__5735__auto___27909__$1)){
var keyed_callbacks_27910 = temp__5735__auto___27909__$1;
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,fluree.db.util.core.keyword__GT_str.call(null,tid));

var tx_response_27911 = fluree.db.session.block_response__GT_tx_response.call(null,event_data,tid);
var seq__27837_27912 = cljs.core.seq.call(null,keyed_callbacks_27910);
var chunk__27838_27913 = null;
var count__27839_27914 = (0);
var i__27840_27915 = (0);
while(true){
if((i__27840_27915 < count__27839_27914)){
var vec__27849_27916 = cljs.core._nth.call(null,chunk__27838_27913,i__27840_27915);
var k_27917 = cljs.core.nth.call(null,vec__27849_27916,(0),null);
var f_27918 = cljs.core.nth.call(null,vec__27849_27916,(1),null);
try{f_27918.call(null,tx_response_27911);
}catch (e27852){if((e27852 instanceof java.lang.Exception)){
var e_27919 = e27852;
fluree.db.util.log.error.call(null,e_27919,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
} else {
throw e27852;

}
}

var G__27920 = seq__27837_27912;
var G__27921 = chunk__27838_27913;
var G__27922 = count__27839_27914;
var G__27923 = (i__27840_27915 + (1));
seq__27837_27912 = G__27920;
chunk__27838_27913 = G__27921;
count__27839_27914 = G__27922;
i__27840_27915 = G__27923;
continue;
} else {
var temp__5735__auto___27924__$2 = cljs.core.seq.call(null,seq__27837_27912);
if(temp__5735__auto___27924__$2){
var seq__27837_27925__$1 = temp__5735__auto___27924__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27837_27925__$1)){
var c__4556__auto___27926 = cljs.core.chunk_first.call(null,seq__27837_27925__$1);
var G__27927 = cljs.core.chunk_rest.call(null,seq__27837_27925__$1);
var G__27928 = c__4556__auto___27926;
var G__27929 = cljs.core.count.call(null,c__4556__auto___27926);
var G__27930 = (0);
seq__27837_27912 = G__27927;
chunk__27838_27913 = G__27928;
count__27839_27914 = G__27929;
i__27840_27915 = G__27930;
continue;
} else {
var vec__27853_27931 = cljs.core.first.call(null,seq__27837_27925__$1);
var k_27932 = cljs.core.nth.call(null,vec__27853_27931,(0),null);
var f_27933 = cljs.core.nth.call(null,vec__27853_27931,(1),null);
try{f_27933.call(null,tx_response_27911);
}catch (e27856){if((e27856 instanceof java.lang.Exception)){
var e_27934 = e27856;
fluree.db.util.log.error.call(null,e_27934,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
} else {
throw e27856;

}
}

var G__27935 = cljs.core.next.call(null,seq__27837_27925__$1);
var G__27936 = null;
var G__27937 = (0);
var G__27938 = (0);
seq__27837_27912 = G__27935;
chunk__27838_27913 = G__27936;
count__27839_27914 = G__27937;
i__27840_27915 = G__27938;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__27939 = seq__27793;
var G__27940 = chunk__27794;
var G__27941 = count__27795;
var G__27942 = (i__27796 + (1));
seq__27793 = G__27939;
chunk__27794 = G__27940;
count__27795 = G__27941;
i__27796 = G__27942;
continue;
} else {
var temp__5735__auto____$1 = cljs.core.seq.call(null,seq__27793);
if(temp__5735__auto____$1){
var seq__27793__$1 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27793__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__27793__$1);
var G__27943 = cljs.core.chunk_rest.call(null,seq__27793__$1);
var G__27944 = c__4556__auto__;
var G__27945 = cljs.core.count.call(null,c__4556__auto__);
var G__27946 = (0);
seq__27793 = G__27943;
chunk__27794 = G__27944;
count__27795 = G__27945;
i__27796 = G__27946;
continue;
} else {
var tid = cljs.core.first.call(null,seq__27793__$1);
var temp__5735__auto___27947__$2 = cljs.core.get.call(null,tx_callbacks,fluree.db.util.core.keyword__GT_str.call(null,tid));
if(cljs.core.truth_(temp__5735__auto___27947__$2)){
var keyed_callbacks_27948 = temp__5735__auto___27947__$2;
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,fluree.db.util.core.keyword__GT_str.call(null,tid));

var tx_response_27949 = fluree.db.session.block_response__GT_tx_response.call(null,event_data,tid);
var seq__27857_27950 = cljs.core.seq.call(null,keyed_callbacks_27948);
var chunk__27858_27951 = null;
var count__27859_27952 = (0);
var i__27860_27953 = (0);
while(true){
if((i__27860_27953 < count__27859_27952)){
var vec__27869_27954 = cljs.core._nth.call(null,chunk__27858_27951,i__27860_27953);
var k_27955 = cljs.core.nth.call(null,vec__27869_27954,(0),null);
var f_27956 = cljs.core.nth.call(null,vec__27869_27954,(1),null);
try{f_27956.call(null,tx_response_27949);
}catch (e27872){if((e27872 instanceof java.lang.Exception)){
var e_27957 = e27872;
fluree.db.util.log.error.call(null,e_27957,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
} else {
throw e27872;

}
}

var G__27958 = seq__27857_27950;
var G__27959 = chunk__27858_27951;
var G__27960 = count__27859_27952;
var G__27961 = (i__27860_27953 + (1));
seq__27857_27950 = G__27958;
chunk__27858_27951 = G__27959;
count__27859_27952 = G__27960;
i__27860_27953 = G__27961;
continue;
} else {
var temp__5735__auto___27962__$3 = cljs.core.seq.call(null,seq__27857_27950);
if(temp__5735__auto___27962__$3){
var seq__27857_27963__$1 = temp__5735__auto___27962__$3;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27857_27963__$1)){
var c__4556__auto___27964 = cljs.core.chunk_first.call(null,seq__27857_27963__$1);
var G__27965 = cljs.core.chunk_rest.call(null,seq__27857_27963__$1);
var G__27966 = c__4556__auto___27964;
var G__27967 = cljs.core.count.call(null,c__4556__auto___27964);
var G__27968 = (0);
seq__27857_27950 = G__27965;
chunk__27858_27951 = G__27966;
count__27859_27952 = G__27967;
i__27860_27953 = G__27968;
continue;
} else {
var vec__27873_27969 = cljs.core.first.call(null,seq__27857_27963__$1);
var k_27970 = cljs.core.nth.call(null,vec__27873_27969,(0),null);
var f_27971 = cljs.core.nth.call(null,vec__27873_27969,(1),null);
try{f_27971.call(null,tx_response_27949);
}catch (e27876){if((e27876 instanceof java.lang.Exception)){
var e_27972 = e27876;
fluree.db.util.log.error.call(null,e_27972,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
} else {
throw e27876;

}
}

var G__27973 = cljs.core.next.call(null,seq__27857_27963__$1);
var G__27974 = null;
var G__27975 = (0);
var G__27976 = (0);
seq__27857_27950 = G__27973;
chunk__27858_27951 = G__27974;
count__27859_27952 = G__27975;
i__27860_27953 = G__27976;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__27977 = cljs.core.next.call(null,seq__27793__$1);
var G__27978 = null;
var G__27979 = (0);
var G__27980 = (0);
seq__27793 = G__27977;
chunk__27794 = G__27978;
count__27795 = G__27979;
i__27796 = G__27980;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
}));

fluree.db.session.process_ledger_updates.call(null,conn,network,ledger_id,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_27981 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(conn);
var c__2490__auto___27982 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_27893){
var state_val_27894 = (state_27893[(1)]);
if((state_val_27894 === (1))){
var state_27893__$1 = state_27893;
var statearr_27895_27983 = state_27893__$1;
(statearr_27895_27983[(2)] = null);

(statearr_27895_27983[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27894 === (2))){
var inst_27878 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(session);
var state_27893__$1 = state_27893;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27893__$1,(4),inst_27878);
} else {
if((state_val_27894 === (3))){
var inst_27891 = (state_27893[(2)]);
var state_27893__$1 = state_27893;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27893__$1,inst_27891);
} else {
if((state_val_27894 === (4))){
var inst_27880 = (state_27893[(7)]);
var inst_27880__$1 = (state_27893[(2)]);
var inst_27881 = (inst_27880__$1 == null);
var state_27893__$1 = (function (){var statearr_27896 = state_27893;
(statearr_27896[(7)] = inst_27880__$1);

return statearr_27896;
})();
if(cljs.core.truth_(inst_27881)){
var statearr_27897_27984 = state_27893__$1;
(statearr_27897_27984[(1)] = (5));

} else {
var statearr_27898_27985 = state_27893__$1;
(statearr_27898_27985[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27894 === (5))){
var inst_27883 = ["Transactor session closing for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_27884 = fluree.db.util.log.info.call(null,inst_27883);
var state_27893__$1 = state_27893;
var statearr_27899_27986 = state_27893__$1;
(statearr_27899_27986[(2)] = inst_27884);

(statearr_27899_27986[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27894 === (6))){
var inst_27880 = (state_27893[(7)]);
var inst_27886 = transact_handler_27981.call(null,conn,inst_27880);
var state_27893__$1 = (function (){var statearr_27900 = state_27893;
(statearr_27900[(8)] = inst_27886);

return statearr_27900;
})();
var statearr_27901_27987 = state_27893__$1;
(statearr_27901_27987[(2)] = null);

(statearr_27901_27987[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27894 === (7))){
var inst_27889 = (state_27893[(2)]);
var state_27893__$1 = state_27893;
var statearr_27902_27988 = state_27893__$1;
(statearr_27902_27988[(2)] = inst_27889);

(statearr_27902_27988[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2468__auto__ = null;
var fluree$db$session$state_machine__2468__auto____0 = (function (){
var statearr_27903 = [null,null,null,null,null,null,null,null,null];
(statearr_27903[(0)] = fluree$db$session$state_machine__2468__auto__);

(statearr_27903[(1)] = (1));

return statearr_27903;
});
var fluree$db$session$state_machine__2468__auto____1 = (function (state_27893){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_27893);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e27904){var ex__2471__auto__ = e27904;
var statearr_27905_27989 = state_27893;
(statearr_27905_27989[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_27893[(4)]))){
var statearr_27906_27990 = state_27893;
(statearr_27906_27990[(1)] = cljs.core.first.call(null,(state_27893[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27991 = state_27893;
state_27893 = G__27991;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$session$state_machine__2468__auto__ = function(state_27893){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2468__auto____1.call(this,state_27893);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2468__auto____0;
fluree$db$session$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2468__auto____1;
return fluree$db$session$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_27907 = f__2491__auto__.call(null);
(statearr_27907[(6)] = c__2490__auto___27982);

return statearr_27907;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Gets the latest db from the central DB atom if available, or loads it from scratch.
 *   DB is returned as a core async promise channel.
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(session){
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (p1__27992_SHARP_){
return cljs.core.assoc.call(null,p1__27992_SHARP_,new cljs.core.Keyword("req","last","req/last",1105783038),fluree.db.util.core.current_time_millis.call(null),new cljs.core.Keyword("req","count","req/count",2145574363),(new cljs.core.Keyword("req","count","req/count",2145574363).cljs$core$IFn$_invoke$arity$1(p1__27992_SHARP_) + (1)));
}));

var db = new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
if((db == null)){
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(session),cljs.core.empty);

cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (p1__27993_SHARP_){
return cljs.core.assoc.call(null,p1__27993_SHARP_,new cljs.core.Keyword("db","db","db/db",993247817),fluree.db.session.full_load_existing_db.call(null,session));
}));

return new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
} else {
return db;
}
});
/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.call(null,conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"connect?","connect?",1326309520),false], null));
return new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.call(null,conn,ledger,opts);
return fluree.db.session.current_db.call(null,session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__27996 = arguments.length;
switch (G__27996) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.call(null,null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__27997 = cljs.core.vals.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.call(null,(function (p1__27994_SHARP_){
return cljs.core._EQ_.call(null,conn_id,cljs.core.get_in.call(null,p1__27994_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"id","id",-1388402092)], null)));
}),G__27997);
} else {
return G__27997;
}
})();
var seq__27998 = cljs.core.seq.call(null,sessions);
var chunk__27999 = null;
var count__28000 = (0);
var i__28001 = (0);
while(true){
if((i__28001 < count__28000)){
var session = cljs.core._nth.call(null,chunk__27999,i__28001);
fluree.db.session.close.call(null,session);


var G__28003 = seq__27998;
var G__28004 = chunk__27999;
var G__28005 = count__28000;
var G__28006 = (i__28001 + (1));
seq__27998 = G__28003;
chunk__27999 = G__28004;
count__28000 = G__28005;
i__28001 = G__28006;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__27998);
if(temp__5735__auto__){
var seq__27998__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27998__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__27998__$1);
var G__28007 = cljs.core.chunk_rest.call(null,seq__27998__$1);
var G__28008 = c__4556__auto__;
var G__28009 = cljs.core.count.call(null,c__4556__auto__);
var G__28010 = (0);
seq__27998 = G__28007;
chunk__27999 = G__28008;
count__28000 = G__28009;
i__28001 = G__28010;
continue;
} else {
var session = cljs.core.first.call(null,seq__27998__$1);
fluree.db.session.close.call(null,session);


var G__28011 = cljs.core.next.call(null,seq__27998__$1);
var G__28012 = null;
var G__28013 = (0);
var G__28014 = (0);
seq__27998 = G__28011;
chunk__27999 = G__28012;
count__28000 = G__28013;
i__28001 = G__28014;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.call(null,"Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null)))){
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),(function (pending_txs){
var updated = cljs.core.update.call(null,pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_.call(null,cljs.core.get.call(null,updated,tid))){
return cljs.core.dissoc.call(null,updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});

//# sourceMappingURL=session.js.map
