// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.call(null,cljs.core.re_find.call(null,/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_14981){
var state_val_14982 = (state_14981[(1)]);
if((state_val_14982 === (1))){
var state_14981__$1 = state_14981;
var statearr_14983_14997 = state_14981__$1;
(statearr_14983_14997[(2)] = null);

(statearr_14983_14997[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14982 === (2))){
var _ = (function (){var statearr_14984 = state_14981;
(statearr_14984[(4)] = cljs.core.cons.call(null,(5),(state_14981[(4)])));

return statearr_14984;
})();
var inst_14972 = fluree.db.dbproto._tag.call(null,db,type_tag_sid,"_predicate/type");
var state_14981__$1 = state_14981;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14981__$1,(6),inst_14972);
} else {
if((state_val_14982 === (3))){
var inst_14979 = (state_14981[(2)]);
var state_14981__$1 = state_14981;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14981__$1,inst_14979);
} else {
if((state_val_14982 === (4))){
var inst_14966 = (state_14981[(2)]);
var state_14981__$1 = state_14981;
var statearr_14986_14998 = state_14981__$1;
(statearr_14986_14998[(2)] = inst_14966);

(statearr_14986_14998[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14982 === (5))){
var _ = (function (){var statearr_14987 = state_14981;
(statearr_14987[(4)] = cljs.core.rest.call(null,(state_14981[(4)])));

return statearr_14987;
})();
var state_14981__$1 = state_14981;
var ex14985 = (state_14981__$1[(2)]);
var statearr_14988_14999 = state_14981__$1;
(statearr_14988_14999[(5)] = ex14985);


if((ex14985 instanceof Error)){
var statearr_14989_15000 = state_14981__$1;
(statearr_14989_15000[(1)] = (4));

(statearr_14989_15000[(5)] = null);

} else {
throw ex14985;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14982 === (6))){
var inst_14974 = (state_14981[(2)]);
var inst_14975 = fluree.db.util.async.throw_err.call(null,inst_14974);
var inst_14976 = cljs.core.keyword.call(null,inst_14975);
var _ = (function (){var statearr_14990 = state_14981;
(statearr_14990[(4)] = cljs.core.rest.call(null,(state_14981[(4)])));

return statearr_14990;
})();
var state_14981__$1 = state_14981;
var statearr_14991_15001 = state_14981__$1;
(statearr_14991_15001[(2)] = inst_14976);

(statearr_14991_15001[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2468__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2468__auto____0 = (function (){
var statearr_14992 = [null,null,null,null,null,null,null];
(statearr_14992[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2468__auto__);

(statearr_14992[(1)] = (1));

return statearr_14992;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2468__auto____1 = (function (state_14981){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_14981);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e14993){var ex__2471__auto__ = e14993;
var statearr_14994_15002 = state_14981;
(statearr_14994_15002[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_14981[(4)]))){
var statearr_14995_15003 = state_14981;
(statearr_14995_15003[(1)] = cljs.core.first.call(null,(state_14981[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15004 = state_14981;
state_14981 = G__15004;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2468__auto__ = function(state_14981){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2468__auto____1.call(this,state_14981);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2468__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2468__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_14996 = f__2491__auto__.call(null);
(statearr_14996[(6)] = c__2490__auto__);

return statearr_14996;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_15036){
var state_val_15037 = (state_15036[(1)]);
if((state_val_15037 === (7))){
var inst_15020 = (state_15036[(7)]);
var inst_15022 = cljs.core.empty_QMARK_.call(null,inst_15020);
var inst_15023 = (!(inst_15022));
var state_15036__$1 = state_15036;
var statearr_15038_15062 = state_15036__$1;
(statearr_15038_15062[(2)] = inst_15023);

(statearr_15038_15062[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15037 === (1))){
var state_15036__$1 = state_15036;
var statearr_15039_15063 = state_15036__$1;
(statearr_15039_15063[(2)] = null);

(statearr_15039_15063[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15037 === (4))){
var inst_15006 = (state_15036[(2)]);
var state_15036__$1 = state_15036;
var statearr_15040_15064 = state_15036__$1;
(statearr_15040_15064[(2)] = inst_15006);

(statearr_15040_15064[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15037 === (6))){
var inst_15020 = (state_15036[(7)]);
var inst_15012 = (state_15036[(8)]);
var inst_15018 = (state_15036[(2)]);
var inst_15019 = fluree.db.util.async.throw_err.call(null,inst_15018);
var inst_15020__$1 = cljs.core.map.call(null,inst_15012,inst_15019);
var state_15036__$1 = (function (){var statearr_15041 = state_15036;
(statearr_15041[(7)] = inst_15020__$1);

return statearr_15041;
})();
if(cljs.core.truth_(inst_15020__$1)){
var statearr_15042_15065 = state_15036__$1;
(statearr_15042_15065[(1)] = (7));

} else {
var statearr_15043_15066 = state_15036__$1;
(statearr_15043_15066[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15037 === (3))){
var inst_15034 = (state_15036[(2)]);
var state_15036__$1 = state_15036;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15036__$1,inst_15034);
} else {
if((state_val_15037 === (12))){
var inst_15031 = (state_15036[(2)]);
var _ = (function (){var statearr_15044 = state_15036;
(statearr_15044[(4)] = cljs.core.rest.call(null,(state_15036[(4)])));

return statearr_15044;
})();
var state_15036__$1 = state_15036;
var statearr_15045_15067 = state_15036__$1;
(statearr_15045_15067[(2)] = inst_15031);

(statearr_15045_15067[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15037 === (2))){
var _ = (function (){var statearr_15046 = state_15036;
(statearr_15046[(4)] = cljs.core.cons.call(null,(5),(state_15036[(4)])));

return statearr_15046;
})();
var inst_15012 = (function (){return (function (p1__15005_SHARP_){
return p1__15005_SHARP_.o;
});
})();
var inst_15013 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15014 = [pred_id];
var inst_15015 = (new cljs.core.PersistentVector(null,1,(5),inst_15013,inst_15014,null));
var inst_15016 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15015);
var state_15036__$1 = (function (){var statearr_15047 = state_15036;
(statearr_15047[(8)] = inst_15012);

return statearr_15047;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15036__$1,(6),inst_15016);
} else {
if((state_val_15037 === (11))){
var state_15036__$1 = state_15036;
var statearr_15049_15068 = state_15036__$1;
(statearr_15049_15068[(2)] = true);

(statearr_15049_15068[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15037 === (9))){
var inst_15026 = (state_15036[(2)]);
var state_15036__$1 = state_15036;
if(cljs.core.truth_(inst_15026)){
var statearr_15050_15069 = state_15036__$1;
(statearr_15050_15069[(1)] = (10));

} else {
var statearr_15051_15070 = state_15036__$1;
(statearr_15051_15070[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15037 === (5))){
var _ = (function (){var statearr_15052 = state_15036;
(statearr_15052[(4)] = cljs.core.rest.call(null,(state_15036[(4)])));

return statearr_15052;
})();
var state_15036__$1 = state_15036;
var ex15048 = (state_15036__$1[(2)]);
var statearr_15053_15071 = state_15036__$1;
(statearr_15053_15071[(5)] = ex15048);


if((ex15048 instanceof Error)){
var statearr_15054_15072 = state_15036__$1;
(statearr_15054_15072[(1)] = (4));

(statearr_15054_15072[(5)] = null);

} else {
throw ex15048;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15037 === (10))){
var inst_15020 = (state_15036[(7)]);
var inst_15028 = cljs.core.apply.call(null,cljs.core.distinct_QMARK_,inst_15020);
var state_15036__$1 = state_15036;
var statearr_15055_15073 = state_15036__$1;
(statearr_15055_15073[(2)] = inst_15028);

(statearr_15055_15073[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15037 === (8))){
var inst_15020 = (state_15036[(7)]);
var state_15036__$1 = state_15036;
var statearr_15056_15074 = state_15036__$1;
(statearr_15056_15074[(2)] = inst_15020);

(statearr_15056_15074[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2468__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2468__auto____0 = (function (){
var statearr_15057 = [null,null,null,null,null,null,null,null,null];
(statearr_15057[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2468__auto__);

(statearr_15057[(1)] = (1));

return statearr_15057;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2468__auto____1 = (function (state_15036){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_15036);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e15058){var ex__2471__auto__ = e15058;
var statearr_15059_15075 = state_15036;
(statearr_15059_15075[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_15036[(4)]))){
var statearr_15060_15076 = state_15036;
(statearr_15060_15076[(1)] = cljs.core.first.call(null,(state_15036[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15077 = state_15036;
state_15036 = G__15077;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2468__auto__ = function(state_15036){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2468__auto____1.call(this,state_15036);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2468__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2468__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_15061 = f__2491__auto__.call(null);
(statearr_15061[(6)] = c__2490__auto__);

return statearr_15061;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_15154){
var state_val_15155 = (state_15154[(1)]);
if((state_val_15155 === (7))){
var inst_15149 = (state_15154[(2)]);
var _ = (function (){var statearr_15156 = state_15154;
(statearr_15156[(4)] = cljs.core.rest.call(null,(state_15154[(4)])));

return statearr_15156;
})();
var state_15154__$1 = state_15154;
var statearr_15157_15189 = state_15154__$1;
(statearr_15157_15189[(2)] = inst_15149);

(statearr_15157_15189[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15155 === (1))){
var state_15154__$1 = state_15154;
var statearr_15158_15190 = state_15154__$1;
(statearr_15158_15190[(2)] = null);

(statearr_15158_15190[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15155 === (4))){
var inst_15080 = (state_15154[(2)]);
var state_15154__$1 = state_15154;
var statearr_15159_15191 = state_15154__$1;
(statearr_15159_15191[(2)] = inst_15080);

(statearr_15159_15191[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15155 === (15))){
var inst_15110 = (state_15154[(7)]);
var inst_15117 = (state_15154[(8)]);
var inst_15104 = (state_15154[(9)]);
var inst_15130 = (state_15154[(10)]);
var inst_15132 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15133 = inst_15110.s;
var inst_15134 = [inst_15133,inst_15117,new cljs.core.Keyword(null,"old","old",-1825222690)];
var inst_15135 = (new cljs.core.PersistentVector(null,3,(5),inst_15132,inst_15134,null));
var inst_15136 = cljs.core.assoc_in.call(null,inst_15104,inst_15135,inst_15130);
var state_15154__$1 = state_15154;
var statearr_15160_15192 = state_15154__$1;
(statearr_15160_15192[(2)] = inst_15136);

(statearr_15160_15192[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15155 === (13))){
var inst_15119 = (state_15154[(11)]);
var inst_15130 = (state_15154[(2)]);
var state_15154__$1 = (function (){var statearr_15161 = state_15154;
(statearr_15161[(10)] = inst_15130);

return statearr_15161;
})();
if(cljs.core.truth_(inst_15119)){
var statearr_15162_15193 = state_15154__$1;
(statearr_15162_15193[(1)] = (15));

} else {
var statearr_15163_15194 = state_15154__$1;
(statearr_15163_15194[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15155 === (6))){
var inst_15103 = (state_15154[(12)]);
var inst_15110 = (state_15154[(7)]);
var inst_15109 = cljs.core.seq.call(null,inst_15103);
var inst_15110__$1 = cljs.core.first.call(null,inst_15109);
var inst_15111 = cljs.core.next.call(null,inst_15109);
var inst_15112 = cljs.core.not.call(null,inst_15110__$1);
var state_15154__$1 = (function (){var statearr_15164 = state_15154;
(statearr_15164[(7)] = inst_15110__$1);

(statearr_15164[(13)] = inst_15111);

return statearr_15164;
})();
if(inst_15112){
var statearr_15165_15195 = state_15154__$1;
(statearr_15165_15195[(1)] = (8));

} else {
var statearr_15166_15196 = state_15154__$1;
(statearr_15166_15196[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15155 === (17))){
var inst_15111 = (state_15154[(13)]);
var inst_15144 = (state_15154[(2)]);
var inst_15103 = inst_15111;
var inst_15104 = inst_15144;
var state_15154__$1 = (function (){var statearr_15167 = state_15154;
(statearr_15167[(12)] = inst_15103);

(statearr_15167[(9)] = inst_15104);

return statearr_15167;
})();
var statearr_15168_15197 = state_15154__$1;
(statearr_15168_15197[(2)] = null);

(statearr_15168_15197[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15155 === (3))){
var inst_15152 = (state_15154[(2)]);
var state_15154__$1 = state_15154;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15154__$1,inst_15152);
} else {
if((state_val_15155 === (12))){
var inst_15110 = (state_15154[(7)]);
var inst_15128 = inst_15110.o;
var state_15154__$1 = state_15154;
var statearr_15169_15198 = state_15154__$1;
(statearr_15169_15198[(2)] = inst_15128);

(statearr_15169_15198[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15155 === (2))){
var _ = (function (){var statearr_15170 = state_15154;
(statearr_15170[(4)] = cljs.core.cons.call(null,(5),(state_15154[(4)])));

return statearr_15170;
})();
var inst_15086 = cljs.core.filter.call(null,fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var inst_15087 = cljs.core.PersistentHashSet.EMPTY;
var inst_15088 = cljs.core.vals.call(null,tempids);
var inst_15089 = cljs.core.into.call(null,inst_15087,inst_15088);
var inst_15090 = (function (){var pred_flakes = inst_15086;
var is_new_QMARK_ = inst_15089;
return (function (p1__15078_SHARP_,p2__15079_SHARP_){
return cljs.core.assoc_in.call(null,p1__15078_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2__15079_SHARP_.s,new cljs.core.Keyword(null,"new?","new?",777958557)], null),cljs.core.boolean$.call(null,is_new_QMARK_.call(null,p2__15079_SHARP_.s)));
});
})();
var inst_15091 = cljs.core.PersistentHashMap.EMPTY;
var inst_15092 = cljs.core.reduce.call(null,inst_15090,inst_15091,inst_15086);
var inst_15100 = cljs.core.seq.call(null,inst_15086);
var inst_15101 = cljs.core.first.call(null,inst_15100);
var inst_15102 = cljs.core.next.call(null,inst_15100);
var inst_15103 = inst_15086;
var inst_15104 = inst_15092;
var state_15154__$1 = (function (){var statearr_15171 = state_15154;
(statearr_15171[(14)] = inst_15102);

(statearr_15171[(12)] = inst_15103);

(statearr_15171[(9)] = inst_15104);

(statearr_15171[(15)] = inst_15101);

return statearr_15171;
})();
var statearr_15172_15199 = state_15154__$1;
(statearr_15172_15199[(2)] = null);

(statearr_15172_15199[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15155 === (11))){
var inst_15110 = (state_15154[(7)]);
var inst_15122 = inst_15110.o;
var inst_15123 = fluree.db.query.schema.convert_type_to_kw.call(null,inst_15122,db);
var state_15154__$1 = state_15154;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15154__$1,(14),inst_15123);
} else {
if((state_val_15155 === (9))){
var inst_15110 = (state_15154[(7)]);
var inst_15117 = (state_15154[(8)]);
var inst_15115 = inst_15110.p;
var inst_15116 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_15115);
var inst_15117__$1 = fluree.db.query.schema.pred_name__GT_keyword.call(null,inst_15116);
var inst_15118 = inst_15110.op;
var inst_15119 = inst_15118 === false;
var inst_15120 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348),inst_15117__$1);
var state_15154__$1 = (function (){var statearr_15174 = state_15154;
(statearr_15174[(11)] = inst_15119);

(statearr_15174[(8)] = inst_15117__$1);

return statearr_15174;
})();
if(inst_15120){
var statearr_15175_15200 = state_15154__$1;
(statearr_15175_15200[(1)] = (11));

} else {
var statearr_15176_15201 = state_15154__$1;
(statearr_15176_15201[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15155 === (5))){
var _ = (function (){var statearr_15177 = state_15154;
(statearr_15177[(4)] = cljs.core.rest.call(null,(state_15154[(4)])));

return statearr_15177;
})();
var state_15154__$1 = state_15154;
var ex15173 = (state_15154__$1[(2)]);
var statearr_15178_15202 = state_15154__$1;
(statearr_15178_15202[(5)] = ex15173);


if((ex15173 instanceof Error)){
var statearr_15179_15203 = state_15154__$1;
(statearr_15179_15203[(1)] = (4));

(statearr_15179_15203[(5)] = null);

} else {
throw ex15173;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15155 === (14))){
var inst_15125 = (state_15154[(2)]);
var inst_15126 = fluree.db.util.async.throw_err.call(null,inst_15125);
var state_15154__$1 = state_15154;
var statearr_15180_15204 = state_15154__$1;
(statearr_15180_15204[(2)] = inst_15126);

(statearr_15180_15204[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15155 === (16))){
var inst_15110 = (state_15154[(7)]);
var inst_15117 = (state_15154[(8)]);
var inst_15104 = (state_15154[(9)]);
var inst_15130 = (state_15154[(10)]);
var inst_15138 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15139 = inst_15110.s;
var inst_15140 = [inst_15139,inst_15117,new cljs.core.Keyword(null,"new","new",-2085437848)];
var inst_15141 = (new cljs.core.PersistentVector(null,3,(5),inst_15138,inst_15140,null));
var inst_15142 = cljs.core.assoc_in.call(null,inst_15104,inst_15141,inst_15130);
var state_15154__$1 = state_15154;
var statearr_15181_15205 = state_15154__$1;
(statearr_15181_15205[(2)] = inst_15142);

(statearr_15181_15205[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15155 === (10))){
var inst_15147 = (state_15154[(2)]);
var state_15154__$1 = state_15154;
var statearr_15182_15206 = state_15154__$1;
(statearr_15182_15206[(2)] = inst_15147);

(statearr_15182_15206[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15155 === (8))){
var inst_15104 = (state_15154[(9)]);
var state_15154__$1 = state_15154;
var statearr_15183_15207 = state_15154__$1;
(statearr_15183_15207[(2)] = inst_15104);

(statearr_15183_15207[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__2468__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__2468__auto____0 = (function (){
var statearr_15184 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15184[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__2468__auto__);

(statearr_15184[(1)] = (1));

return statearr_15184;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__2468__auto____1 = (function (state_15154){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_15154);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e15185){var ex__2471__auto__ = e15185;
var statearr_15186_15208 = state_15154;
(statearr_15186_15208[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_15154[(4)]))){
var statearr_15187_15209 = state_15154;
(statearr_15187_15209[(1)] = cljs.core.first.call(null,(state_15154[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15210 = state_15154;
state_15154 = G__15210;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__2468__auto__ = function(state_15154){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2468__auto____1.call(this,state_15154);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__2468__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__2468__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_15188 = f__2491__auto__.call(null);
(statearr_15188[(6)] = c__2490__auto__);

return statearr_15188;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__15212 = arguments.length;
switch (G__15212) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.call(null,null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name.call(null,current_type)," to ",cljs.core.name.call(null,new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.call(null,message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__15215 = arguments.length;
switch (G__15215) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.call(null,pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_15524){
var state_val_15525 = (state_15524[(1)]);
if((state_val_15525 === (65))){
var inst_15477 = (state_15524[(2)]);
var state_15524__$1 = state_15524;
var statearr_15526_15698 = state_15524__$1;
(statearr_15526_15698[(2)] = inst_15477);

(statearr_15526_15698[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (70))){
var inst_15386 = (state_15524[(7)]);
var inst_15387 = (state_15524[(8)]);
var inst_15399 = [new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_15400 = inst_15387.call(null,cljs.core.PersistentArrayMap,null,2,inst_15399,null);
var inst_15401 = inst_15387.call(null,cljs.core.PersistentHashSet,null,inst_15400,null);
var inst_15402 = inst_15401.call(null,inst_15386);
var state_15524__$1 = state_15524;
if(cljs.core.truth_(inst_15402)){
var statearr_15527_15699 = state_15524__$1;
(statearr_15527_15699[(1)] = (71));

} else {
var statearr_15528_15700 = state_15524__$1;
(statearr_15528_15700[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (62))){
var inst_15479 = (state_15524[(2)]);
var state_15524__$1 = state_15524;
var statearr_15529_15701 = state_15524__$1;
(statearr_15529_15701[(2)] = inst_15479);

(statearr_15529_15701[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (74))){
var inst_15386 = (state_15524[(7)]);
var inst_15387 = (state_15524[(8)]);
var inst_15409 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_15410 = inst_15387.call(null,cljs.core.PersistentArrayMap,null,3,inst_15409,null);
var inst_15411 = inst_15387.call(null,cljs.core.PersistentHashSet,null,inst_15410,null);
var inst_15412 = inst_15411.call(null,inst_15386);
var state_15524__$1 = state_15524;
if(cljs.core.truth_(inst_15412)){
var statearr_15530_15702 = state_15524__$1;
(statearr_15530_15702[(1)] = (75));

} else {
var statearr_15531_15703 = state_15524__$1;
(statearr_15531_15703[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (110))){
var inst_15511 = (state_15524[(2)]);
var state_15524__$1 = state_15524;
var statearr_15532_15704 = state_15524__$1;
(statearr_15532_15704[(2)] = inst_15511);

(statearr_15532_15704[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (7))){
var inst_15519 = (state_15524[(2)]);
var _ = (function (){var statearr_15533 = state_15524;
(statearr_15533[(4)] = cljs.core.rest.call(null,(state_15524[(4)])));

return statearr_15533;
})();
var state_15524__$1 = state_15524;
var statearr_15534_15705 = state_15524__$1;
(statearr_15534_15705[(2)] = inst_15519);

(statearr_15534_15705[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (59))){
var inst_15386 = (state_15524[(7)]);
var inst_15387 = (state_15524[(8)]);
var inst_15385 = (state_15524[(2)]);
var inst_15386__$1 = cljs.core.get.call(null,inst_15385,new cljs.core.Keyword(null,"old","old",-1825222690));
var inst_15387__$1 = cljs.core.get.call(null,inst_15385,new cljs.core.Keyword(null,"new","new",-2085437848));
var inst_15388 = cljs.core._EQ_.call(null,inst_15387__$1,inst_15386__$1);
var state_15524__$1 = (function (){var statearr_15535 = state_15524;
(statearr_15535[(7)] = inst_15386__$1);

(statearr_15535[(8)] = inst_15387__$1);

return statearr_15535;
})();
if(inst_15388){
var statearr_15536_15706 = state_15524__$1;
(statearr_15536_15706[(1)] = (60));

} else {
var statearr_15537_15707 = state_15524__$1;
(statearr_15537_15707[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (86))){
var inst_15386 = (state_15524[(7)]);
var inst_15387 = (state_15524[(8)]);
var inst_15439 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"double","double",884886883),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_15440 = inst_15387.call(null,cljs.core.PersistentArrayMap,null,5,inst_15439,null);
var inst_15441 = inst_15387.call(null,cljs.core.PersistentHashSet,null,inst_15440,null);
var inst_15442 = inst_15441.call(null,inst_15386);
var state_15524__$1 = state_15524;
if(cljs.core.truth_(inst_15442)){
var statearr_15538_15708 = state_15524__$1;
(statearr_15538_15708[(1)] = (87));

} else {
var statearr_15539_15709 = state_15524__$1;
(statearr_15539_15709[(1)] = (88));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (20))){
var inst_15255 = (state_15524[(9)]);
var inst_15280 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_15255);
var inst_15281 = inst_15280 === true;
var inst_15282 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_15255);
var inst_15283 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_15282);
var inst_15284 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"boolean","boolean",-1919418404),inst_15283);
var inst_15285 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_15255);
var inst_15286 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_15285);
var inst_15287 = inst_15286 === true;
var inst_15288 = ((inst_15281) && (inst_15284) && (inst_15287));
var state_15524__$1 = state_15524;
var statearr_15540_15710 = state_15524__$1;
(statearr_15540_15710[(2)] = inst_15288);

(statearr_15540_15710[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (72))){
var inst_15386 = (state_15524[(7)]);
var inst_15387 = (state_15524[(8)]);
var inst_15405 = fluree.db.query.schema.type_error.call(null,inst_15386,inst_15387,throw_QMARK_);
var state_15524__$1 = state_15524;
var statearr_15541_15711 = state_15524__$1;
(statearr_15541_15711[(2)] = inst_15405);

(statearr_15541_15711[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (58))){
var inst_15364 = (state_15524[(10)]);
var state_15524__$1 = state_15524;
var statearr_15542_15712 = state_15524__$1;
(statearr_15542_15712[(2)] = inst_15364);

(statearr_15542_15712[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (60))){
var inst_15354 = (state_15524[(11)]);
var state_15524__$1 = state_15524;
var statearr_15543_15713 = state_15524__$1;
(statearr_15543_15713[(2)] = inst_15354);

(statearr_15543_15713[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (27))){
var inst_15275 = (state_15524[(12)]);
var state_15524__$1 = state_15524;
var statearr_15544_15714 = state_15524__$1;
(statearr_15544_15714[(2)] = inst_15275);

(statearr_15544_15714[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (1))){
var state_15524__$1 = state_15524;
var statearr_15545_15715 = state_15524__$1;
(statearr_15545_15715[(2)] = null);

(statearr_15545_15715[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (69))){
var inst_15472 = (state_15524[(2)]);
var state_15524__$1 = state_15524;
var statearr_15546_15716 = state_15524__$1;
(statearr_15546_15716[(2)] = inst_15472);

(statearr_15546_15716[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (101))){
var inst_15501 = (state_15524[(2)]);
var state_15524__$1 = state_15524;
if(cljs.core.truth_(inst_15501)){
var statearr_15547_15717 = state_15524__$1;
(statearr_15547_15717[(1)] = (105));

} else {
var statearr_15548_15718 = state_15524__$1;
(statearr_15548_15718[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (24))){
var inst_15275 = (state_15524[(12)]);
var state_15524__$1 = state_15524;
var statearr_15549_15719 = state_15524__$1;
(statearr_15549_15719[(2)] = inst_15275);

(statearr_15549_15719[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (102))){
var inst_15255 = (state_15524[(9)]);
var inst_15488 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_15255);
var inst_15489 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_15488);
var inst_15490 = inst_15489 === true;
var inst_15491 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_15255);
var inst_15492 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_15491);
var inst_15493 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"ref","ref",1289896967),inst_15492);
var inst_15494 = (!(inst_15493));
var inst_15495 = ((inst_15490) && (inst_15494));
var state_15524__$1 = state_15524;
var statearr_15550_15720 = state_15524__$1;
(statearr_15550_15720[(2)] = inst_15495);

(statearr_15550_15720[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (55))){
var state_15524__$1 = state_15524;
var statearr_15551_15721 = state_15524__$1;
(statearr_15551_15721[(2)] = false);

(statearr_15551_15721[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (85))){
var inst_15437 = (state_15524[(2)]);
var state_15524__$1 = state_15524;
var statearr_15552_15722 = state_15524__$1;
(statearr_15552_15722[(2)] = inst_15437);

(statearr_15552_15722[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (39))){
var state_15524__$1 = state_15524;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_15553_15723 = state_15524__$1;
(statearr_15553_15723[(1)] = (42));

} else {
var statearr_15554_15724 = state_15524__$1;
(statearr_15554_15724[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (88))){
var inst_15386 = (state_15524[(7)]);
var inst_15387 = (state_15524[(8)]);
var inst_15445 = fluree.db.query.schema.type_error.call(null,inst_15386,inst_15387,throw_QMARK_);
var state_15524__$1 = state_15524;
var statearr_15555_15725 = state_15524__$1;
(statearr_15555_15725[(2)] = inst_15445);

(statearr_15555_15725[(1)] = (89));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (46))){
var inst_15355 = (state_15524[(13)]);
var state_15524__$1 = state_15524;
var statearr_15556_15726 = state_15524__$1;
(statearr_15556_15726[(2)] = inst_15355);

(statearr_15556_15726[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (4))){
var inst_15216 = (state_15524[(2)]);
var state_15524__$1 = state_15524;
var statearr_15557_15727 = state_15524__$1;
(statearr_15557_15727[(2)] = inst_15216);

(statearr_15557_15727[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (77))){
var inst_15417 = (state_15524[(2)]);
var state_15524__$1 = state_15524;
var statearr_15558_15728 = state_15524__$1;
(statearr_15558_15728[(2)] = inst_15417);

(statearr_15558_15728[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (106))){
var inst_15482 = (state_15524[(14)]);
var state_15524__$1 = state_15524;
var statearr_15559_15729 = state_15524__$1;
(statearr_15559_15729[(2)] = inst_15482);

(statearr_15559_15729[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (95))){
var inst_15354 = (state_15524[(11)]);
var state_15524__$1 = state_15524;
var statearr_15560_15730 = state_15524__$1;
(statearr_15560_15730[(2)] = inst_15354);

(statearr_15560_15730[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (54))){
var state_15524__$1 = state_15524;
var statearr_15561_15731 = state_15524__$1;
(statearr_15561_15731[(2)] = true);

(statearr_15561_15731[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (92))){
var inst_15386 = (state_15524[(7)]);
var inst_15387 = (state_15524[(8)]);
var inst_15455 = fluree.db.query.schema.type_error.call(null,inst_15386,inst_15387,throw_QMARK_);
var state_15524__$1 = state_15524;
var statearr_15562_15732 = state_15524__$1;
(statearr_15562_15732[(2)] = inst_15455);

(statearr_15562_15732[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (104))){
var inst_15498 = (state_15524[(2)]);
var state_15524__$1 = state_15524;
var statearr_15563_15733 = state_15524__$1;
(statearr_15563_15733[(2)] = inst_15498);

(statearr_15563_15733[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (15))){
var inst_15243 = (state_15524[(15)]);
var state_15524__$1 = state_15524;
var statearr_15564_15734 = state_15524__$1;
(statearr_15564_15734[(2)] = inst_15243);

(statearr_15564_15734[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (48))){
var inst_15255 = (state_15524[(9)]);
var inst_15364 = (state_15524[(10)]);
var inst_15364__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_15255);
var inst_15366 = (inst_15364__$1 == null);
var inst_15367 = cljs.core.not.call(null,inst_15366);
var state_15524__$1 = (function (){var statearr_15565 = state_15524;
(statearr_15565[(10)] = inst_15364__$1);

return statearr_15565;
})();
if(inst_15367){
var statearr_15566_15735 = state_15524__$1;
(statearr_15566_15735[(1)] = (51));

} else {
var statearr_15567_15736 = state_15524__$1;
(statearr_15567_15736[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (50))){
var inst_15255 = (state_15524[(9)]);
var inst_15482 = (state_15524[(2)]);
var inst_15483 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_15255);
var inst_15484 = inst_15483 === true;
var state_15524__$1 = (function (){var statearr_15568 = state_15524;
(statearr_15568[(14)] = inst_15482);

return statearr_15568;
})();
if(cljs.core.truth_(inst_15484)){
var statearr_15569_15737 = state_15524__$1;
(statearr_15569_15737[(1)] = (99));

} else {
var statearr_15570_15738 = state_15524__$1;
(statearr_15570_15738[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (75))){
var inst_15354 = (state_15524[(11)]);
var state_15524__$1 = state_15524;
var statearr_15571_15739 = state_15524__$1;
(statearr_15571_15739[(2)] = inst_15354);

(statearr_15571_15739[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (99))){
var inst_15486 = (state_15524[(16)]);
var inst_15255 = (state_15524[(9)]);
var inst_15486__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_15255);
var state_15524__$1 = (function (){var statearr_15572 = state_15524;
(statearr_15572[(16)] = inst_15486__$1);

return statearr_15572;
})();
if(cljs.core.truth_(inst_15486__$1)){
var statearr_15573_15740 = state_15524__$1;
(statearr_15573_15740[(1)] = (102));

} else {
var statearr_15574_15741 = state_15524__$1;
(statearr_15574_15741[(1)] = (103));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (21))){
var inst_15278 = (state_15524[(17)]);
var state_15524__$1 = state_15524;
var statearr_15575_15742 = state_15524__$1;
(statearr_15575_15742[(2)] = inst_15278);

(statearr_15575_15742[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (31))){
var inst_15318 = (state_15524[(2)]);
var state_15524__$1 = state_15524;
if(cljs.core.truth_(inst_15318)){
var statearr_15576_15743 = state_15524__$1;
(statearr_15576_15743[(1)] = (32));

} else {
var statearr_15577_15744 = state_15524__$1;
(statearr_15577_15744[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (32))){
var inst_15307 = (state_15524[(18)]);
var inst_15320 = fluree.db.query.schema.type_error.call(null,inst_15307,"a component","a non-component",throw_QMARK_);
var state_15524__$1 = state_15524;
var statearr_15578_15745 = state_15524__$1;
(statearr_15578_15745[(2)] = inst_15320);

(statearr_15578_15745[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (40))){
var inst_15323 = (state_15524[(19)]);
var state_15524__$1 = state_15524;
var statearr_15579_15746 = state_15524__$1;
(statearr_15579_15746[(2)] = inst_15323);

(statearr_15579_15746[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (91))){
var inst_15354 = (state_15524[(11)]);
var state_15524__$1 = state_15524;
var statearr_15580_15747 = state_15524__$1;
(statearr_15580_15747[(2)] = inst_15354);

(statearr_15580_15747[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (108))){
var inst_15504 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15505 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_15506 = cljs.core.PersistentHashMap.fromArrays(inst_15504,inst_15505);
var inst_15507 = cljs.core.ex_info.call(null,"A component _predicate must be of type \"ref.\"",inst_15506);
var inst_15508 = (function(){throw inst_15507})();
var state_15524__$1 = state_15524;
var statearr_15581_15748 = state_15524__$1;
(statearr_15581_15748[(2)] = inst_15508);

(statearr_15581_15748[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (56))){
var inst_15377 = (state_15524[(2)]);
var state_15524__$1 = state_15524;
var statearr_15582_15749 = state_15524__$1;
(statearr_15582_15749[(2)] = inst_15377);

(statearr_15582_15749[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (33))){
var inst_15307 = (state_15524[(18)]);
var state_15524__$1 = state_15524;
var statearr_15583_15750 = state_15524__$1;
(statearr_15583_15750[(2)] = inst_15307);

(statearr_15583_15750[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (13))){
var inst_15270 = (state_15524[(2)]);
var state_15524__$1 = state_15524;
if(cljs.core.truth_(inst_15270)){
var statearr_15584_15751 = state_15524__$1;
(statearr_15584_15751[(1)] = (14));

} else {
var statearr_15585_15752 = state_15524__$1;
(statearr_15585_15752[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (22))){
var inst_15291 = (state_15524[(2)]);
var state_15524__$1 = state_15524;
var statearr_15586_15753 = state_15524__$1;
(statearr_15586_15753[(2)] = inst_15291);

(statearr_15586_15753[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (90))){
var inst_15386 = (state_15524[(7)]);
var inst_15387 = (state_15524[(8)]);
var inst_15449 = [new cljs.core.Keyword(null,"geojson","geojson",-719473398),null,new cljs.core.Keyword(null,"bytes","bytes",1175866680),null,new cljs.core.Keyword(null,"uri","uri",-774711847),null,new cljs.core.Keyword(null,"uuid","uuid",-2145095719),null,new cljs.core.Keyword(null,"json","json",1279968570),null];
var inst_15450 = inst_15387.call(null,cljs.core.PersistentArrayMap,null,5,inst_15449,null);
var inst_15451 = inst_15387.call(null,cljs.core.PersistentHashSet,null,inst_15450,null);
var inst_15452 = inst_15451.call(null,inst_15386);
var state_15524__$1 = state_15524;
if(cljs.core.truth_(inst_15452)){
var statearr_15587_15754 = state_15524__$1;
(statearr_15587_15754[(1)] = (91));

} else {
var statearr_15588_15755 = state_15524__$1;
(statearr_15588_15755[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (109))){
var inst_15482 = (state_15524[(14)]);
var state_15524__$1 = state_15524;
var statearr_15589_15756 = state_15524__$1;
(statearr_15589_15756[(2)] = inst_15482);

(statearr_15589_15756[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (36))){
var inst_15324 = (state_15524[(20)]);
var state_15524__$1 = state_15524;
var statearr_15590_15757 = state_15524__$1;
(statearr_15590_15757[(2)] = inst_15324);

(statearr_15590_15757[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (41))){
var inst_15255 = (state_15524[(9)]);
var inst_15355 = (state_15524[(13)]);
var inst_15354 = (state_15524[(2)]);
var inst_15355__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_15255);
var state_15524__$1 = (function (){var statearr_15591 = state_15524;
(statearr_15591[(11)] = inst_15354);

(statearr_15591[(13)] = inst_15355__$1);

return statearr_15591;
})();
if(cljs.core.truth_(inst_15355__$1)){
var statearr_15592_15758 = state_15524__$1;
(statearr_15592_15758[(1)] = (45));

} else {
var statearr_15593_15759 = state_15524__$1;
(statearr_15593_15759[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (89))){
var inst_15447 = (state_15524[(2)]);
var state_15524__$1 = state_15524;
var statearr_15594_15760 = state_15524__$1;
(statearr_15594_15760[(2)] = inst_15447);

(statearr_15594_15760[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (100))){
var state_15524__$1 = state_15524;
var statearr_15595_15761 = state_15524__$1;
(statearr_15595_15761[(2)] = false);

(statearr_15595_15761[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (43))){
var inst_15323 = (state_15524[(19)]);
var state_15524__$1 = state_15524;
var statearr_15596_15762 = state_15524__$1;
(statearr_15596_15762[(2)] = inst_15323);

(statearr_15596_15762[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (61))){
var inst_15386 = (state_15524[(7)]);
var inst_15387 = (state_15524[(8)]);
var inst_15391 = [new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"string","string",-1989541586),null,new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),null];
var inst_15392 = inst_15387.call(null,cljs.core.PersistentArrayMap,null,3,inst_15391,null);
var inst_15393 = inst_15387.call(null,cljs.core.PersistentHashSet,null,inst_15392,null);
var inst_15394 = inst_15393.call(null,inst_15386);
var state_15524__$1 = state_15524;
if(cljs.core.truth_(inst_15394)){
var statearr_15597_15763 = state_15524__$1;
(statearr_15597_15763[(1)] = (63));

} else {
var statearr_15598_15764 = state_15524__$1;
(statearr_15598_15764[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (29))){
var inst_15255 = (state_15524[(9)]);
var inst_15310 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_15255);
var inst_15311 = cljs.core.not.call(null,inst_15310);
var inst_15312 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_15255);
var inst_15313 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_15312);
var inst_15314 = inst_15313 === true;
var inst_15315 = ((inst_15311) && (inst_15314));
var state_15524__$1 = state_15524;
var statearr_15599_15765 = state_15524__$1;
(statearr_15599_15765[(2)] = inst_15315);

(statearr_15599_15765[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (44))){
var inst_15351 = (state_15524[(2)]);
var state_15524__$1 = state_15524;
var statearr_15600_15766 = state_15524__$1;
(statearr_15600_15766[(2)] = inst_15351);

(statearr_15600_15766[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (93))){
var inst_15457 = (state_15524[(2)]);
var state_15524__$1 = state_15524;
var statearr_15601_15767 = state_15524__$1;
(statearr_15601_15767[(2)] = inst_15457);

(statearr_15601_15767[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (6))){
var inst_15254 = (state_15524[(21)]);
var inst_15242 = (state_15524[(22)]);
var inst_15251 = cljs.core.seq.call(null,inst_15242);
var inst_15252 = cljs.core.first.call(null,inst_15251);
var inst_15253 = cljs.core.next.call(null,inst_15251);
var inst_15254__$1 = cljs.core.nth.call(null,inst_15252,(0),null);
var inst_15255 = cljs.core.nth.call(null,inst_15252,(1),null);
var inst_15256 = cljs.core.not.call(null,inst_15254__$1);
var state_15524__$1 = (function (){var statearr_15602 = state_15524;
(statearr_15602[(9)] = inst_15255);

(statearr_15602[(23)] = inst_15253);

(statearr_15602[(21)] = inst_15254__$1);

return statearr_15602;
})();
if(inst_15256){
var statearr_15603_15768 = state_15524__$1;
(statearr_15603_15768[(1)] = (8));

} else {
var statearr_15604_15769 = state_15524__$1;
(statearr_15604_15769[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (28))){
var inst_15304 = (state_15524[(2)]);
var state_15524__$1 = state_15524;
var statearr_15605_15770 = state_15524__$1;
(statearr_15605_15770[(2)] = inst_15304);

(statearr_15605_15770[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (64))){
var state_15524__$1 = state_15524;
var statearr_15606_15771 = state_15524__$1;
(statearr_15606_15771[(1)] = (66));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (103))){
var inst_15486 = (state_15524[(16)]);
var state_15524__$1 = state_15524;
var statearr_15608_15772 = state_15524__$1;
(statearr_15608_15772[(2)] = inst_15486);

(statearr_15608_15772[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (51))){
var inst_15364 = (state_15524[(10)]);
var inst_15369 = inst_15364.cljs$lang$protocol_mask$partition0$;
var inst_15370 = (inst_15369 & (64));
var inst_15371 = inst_15364.cljs$core$ISeq$;
var inst_15372 = (cljs.core.PROTOCOL_SENTINEL === inst_15371);
var inst_15373 = ((inst_15370) || (inst_15372));
var state_15524__$1 = state_15524;
if(cljs.core.truth_(inst_15373)){
var statearr_15609_15773 = state_15524__$1;
(statearr_15609_15773[(1)] = (54));

} else {
var statearr_15610_15774 = state_15524__$1;
(statearr_15610_15774[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (25))){
var inst_15308 = (state_15524[(24)]);
var inst_15255 = (state_15524[(9)]);
var inst_15307 = (state_15524[(2)]);
var inst_15308__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_15255);
var state_15524__$1 = (function (){var statearr_15611 = state_15524;
(statearr_15611[(18)] = inst_15307);

(statearr_15611[(24)] = inst_15308__$1);

return statearr_15611;
})();
if(cljs.core.truth_(inst_15308__$1)){
var statearr_15612_15775 = state_15524__$1;
(statearr_15612_15775[(1)] = (29));

} else {
var statearr_15613_15776 = state_15524__$1;
(statearr_15613_15776[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (34))){
var inst_15255 = (state_15524[(9)]);
var inst_15324 = (state_15524[(20)]);
var inst_15323 = (state_15524[(2)]);
var inst_15324__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_15255);
var state_15524__$1 = (function (){var statearr_15614 = state_15524;
(statearr_15614[(19)] = inst_15323);

(statearr_15614[(20)] = inst_15324__$1);

return statearr_15614;
})();
if(cljs.core.truth_(inst_15324__$1)){
var statearr_15615_15777 = state_15524__$1;
(statearr_15615_15777[(1)] = (35));

} else {
var statearr_15616_15778 = state_15524__$1;
(statearr_15616_15778[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (17))){
var inst_15255 = (state_15524[(9)]);
var inst_15278 = (state_15524[(17)]);
var inst_15278__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_15255);
var state_15524__$1 = (function (){var statearr_15617 = state_15524;
(statearr_15617[(17)] = inst_15278__$1);

return statearr_15617;
})();
if(cljs.core.truth_(inst_15278__$1)){
var statearr_15618_15779 = state_15524__$1;
(statearr_15618_15779[(1)] = (20));

} else {
var statearr_15619_15780 = state_15524__$1;
(statearr_15619_15780[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (3))){
var inst_15522 = (state_15524[(2)]);
var state_15524__$1 = state_15524;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15524__$1,inst_15522);
} else {
if((state_val_15525 === (12))){
var inst_15259 = (state_15524[(25)]);
var state_15524__$1 = state_15524;
var statearr_15620_15781 = state_15524__$1;
(statearr_15620_15781[(2)] = inst_15259);

(statearr_15620_15781[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (2))){
var _ = (function (){var statearr_15621 = state_15524;
(statearr_15621[(4)] = cljs.core.cons.call(null,(5),(state_15524[(4)])));

return statearr_15621;
})();
var inst_15235 = pred_changes;
var inst_15236 = cljs.core.seq.call(null,inst_15235);
var inst_15237 = cljs.core.first.call(null,inst_15236);
var inst_15238 = cljs.core.next.call(null,inst_15236);
var inst_15239 = cljs.core.nth.call(null,inst_15237,(0),null);
var inst_15240 = cljs.core.nth.call(null,inst_15237,(1),null);
var inst_15241 = db;
var inst_15242 = inst_15235;
var inst_15243 = inst_15241;
var state_15524__$1 = (function (){var statearr_15622 = state_15524;
(statearr_15622[(26)] = inst_15238);

(statearr_15622[(27)] = inst_15240);

(statearr_15622[(15)] = inst_15243);

(statearr_15622[(28)] = inst_15239);

(statearr_15622[(22)] = inst_15242);

return statearr_15622;
})();
var statearr_15623_15782 = state_15524__$1;
(statearr_15623_15782[(2)] = null);

(statearr_15623_15782[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (66))){
var inst_15387 = (state_15524[(8)]);
var state_15524__$1 = state_15524;
var G__15624_15783 = inst_15387;
var G__15624_15784__$1 = (((G__15624_15783 instanceof cljs.core.Keyword))?G__15624_15783.fqn:null);
switch (G__15624_15784__$1) {
case "long":
var statearr_15625_15786 = state_15524__$1;
(statearr_15625_15786[(1)] = (70));


break;
case "bigint":
var statearr_15626_15787 = state_15524__$1;
(statearr_15626_15787[(1)] = (74));


break;
case "double":
var statearr_15627_15788 = state_15524__$1;
(statearr_15627_15788[(1)] = (78));


break;
case "float":
var statearr_15628_15789 = state_15524__$1;
(statearr_15628_15789[(1)] = (82));


break;
case "bigdec":
var statearr_15629_15790 = state_15524__$1;
(statearr_15629_15790[(1)] = (86));


break;
case "string":
var statearr_15630_15791 = state_15524__$1;
(statearr_15630_15791[(1)] = (90));


break;
case "instant":
var statearr_15631_15792 = state_15524__$1;
(statearr_15631_15792[(1)] = (94));


break;
default:
var statearr_15632_15793 = state_15524__$1;
(statearr_15632_15793[(1)] = (98));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (107))){
var inst_15253 = (state_15524[(23)]);
var inst_15514 = (state_15524[(2)]);
var inst_15242 = inst_15253;
var inst_15243 = inst_15514;
var state_15524__$1 = (function (){var statearr_15633 = state_15524;
(statearr_15633[(15)] = inst_15243);

(statearr_15633[(22)] = inst_15242);

return statearr_15633;
})();
var statearr_15634_15794 = state_15524__$1;
(statearr_15634_15794[(2)] = null);

(statearr_15634_15794[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (23))){
var state_15524__$1 = state_15524;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_15635_15795 = state_15524__$1;
(statearr_15635_15795[(1)] = (26));

} else {
var statearr_15636_15796 = state_15524__$1;
(statearr_15636_15796[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (47))){
var inst_15361 = (state_15524[(2)]);
var state_15524__$1 = state_15524;
if(cljs.core.truth_(inst_15361)){
var statearr_15637_15797 = state_15524__$1;
(statearr_15637_15797[(1)] = (48));

} else {
var statearr_15638_15798 = state_15524__$1;
(statearr_15638_15798[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (35))){
var inst_15255 = (state_15524[(9)]);
var inst_15254 = (state_15524[(21)]);
var inst_15243 = (state_15524[(15)]);
var inst_15326 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_15255);
var inst_15327 = cljs.core.not.call(null,inst_15326);
var inst_15328 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_15255);
var inst_15329 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_15328);
var inst_15330 = inst_15329 === true;
var inst_15331 = fluree.db.query.schema.pred_objects_unique_QMARK_.call(null,inst_15243,inst_15254);
var state_15524__$1 = (function (){var statearr_15639 = state_15524;
(statearr_15639[(29)] = inst_15330);

(statearr_15639[(30)] = inst_15327);

return statearr_15639;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15524__$1,(38),inst_15331);
} else {
if((state_val_15525 === (82))){
var inst_15386 = (state_15524[(7)]);
var inst_15387 = (state_15524[(8)]);
var inst_15429 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_15430 = inst_15387.call(null,cljs.core.PersistentArrayMap,null,3,inst_15429,null);
var inst_15431 = inst_15387.call(null,cljs.core.PersistentHashSet,null,inst_15430,null);
var inst_15432 = inst_15431.call(null,inst_15386);
var state_15524__$1 = state_15524;
if(cljs.core.truth_(inst_15432)){
var statearr_15640_15799 = state_15524__$1;
(statearr_15640_15799[(1)] = (83));

} else {
var statearr_15641_15800 = state_15524__$1;
(statearr_15641_15800[(1)] = (84));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (76))){
var inst_15386 = (state_15524[(7)]);
var inst_15387 = (state_15524[(8)]);
var inst_15415 = fluree.db.query.schema.type_error.call(null,inst_15386,inst_15387,throw_QMARK_);
var state_15524__$1 = state_15524;
var statearr_15642_15801 = state_15524__$1;
(statearr_15642_15801[(2)] = inst_15415);

(statearr_15642_15801[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (97))){
var inst_15467 = (state_15524[(2)]);
var state_15524__$1 = state_15524;
var statearr_15643_15802 = state_15524__$1;
(statearr_15643_15802[(2)] = inst_15467);

(statearr_15643_15802[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (19))){
var inst_15294 = (state_15524[(2)]);
var state_15524__$1 = state_15524;
if(cljs.core.truth_(inst_15294)){
var statearr_15644_15803 = state_15524__$1;
(statearr_15644_15803[(1)] = (23));

} else {
var statearr_15645_15804 = state_15524__$1;
(statearr_15645_15804[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (57))){
var inst_15364 = (state_15524[(10)]);
var inst_15382 = cljs.core.apply.call(null,cljs.core.hash_map,inst_15364);
var state_15524__$1 = state_15524;
var statearr_15646_15805 = state_15524__$1;
(statearr_15646_15805[(2)] = inst_15382);

(statearr_15646_15805[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (68))){
var inst_15475 = (state_15524[(2)]);
var state_15524__$1 = state_15524;
var statearr_15647_15806 = state_15524__$1;
(statearr_15647_15806[(2)] = inst_15475);

(statearr_15647_15806[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (11))){
var inst_15255 = (state_15524[(9)]);
var inst_15261 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_15255);
var inst_15262 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_15261);
var inst_15263 = inst_15262 === false;
var inst_15264 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_15255);
var inst_15265 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_15264);
var inst_15266 = inst_15265 === true;
var inst_15267 = ((inst_15263) && (inst_15266));
var state_15524__$1 = state_15524;
var statearr_15649_15807 = state_15524__$1;
(statearr_15649_15807[(2)] = inst_15267);

(statearr_15649_15807[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (9))){
var inst_15259 = (state_15524[(25)]);
var inst_15255 = (state_15524[(9)]);
var inst_15259__$1 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_15255);
var state_15524__$1 = (function (){var statearr_15650 = state_15524;
(statearr_15650[(25)] = inst_15259__$1);

return statearr_15650;
})();
if(cljs.core.truth_(inst_15259__$1)){
var statearr_15651_15808 = state_15524__$1;
(statearr_15651_15808[(1)] = (11));

} else {
var statearr_15652_15809 = state_15524__$1;
(statearr_15652_15809[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (5))){
var _ = (function (){var statearr_15653 = state_15524;
(statearr_15653[(4)] = cljs.core.rest.call(null,(state_15524[(4)])));

return statearr_15653;
})();
var state_15524__$1 = state_15524;
var ex15648 = (state_15524__$1[(2)]);
var statearr_15654_15810 = state_15524__$1;
(statearr_15654_15810[(5)] = ex15648);


if((ex15648 instanceof Error)){
var statearr_15655_15811 = state_15524__$1;
(statearr_15655_15811[(1)] = (4));

(statearr_15655_15811[(5)] = null);

} else {
throw ex15648;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (83))){
var inst_15354 = (state_15524[(11)]);
var state_15524__$1 = state_15524;
var statearr_15656_15812 = state_15524__$1;
(statearr_15656_15812[(2)] = inst_15354);

(statearr_15656_15812[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (14))){
var inst_15243 = (state_15524[(15)]);
var inst_15272 = fluree.db.query.schema.type_error.call(null,inst_15243,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_15524__$1 = state_15524;
var statearr_15657_15813 = state_15524__$1;
(statearr_15657_15813[(2)] = inst_15272);

(statearr_15657_15813[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (45))){
var inst_15255 = (state_15524[(9)]);
var inst_15357 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_15255);
var inst_15358 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_15357);
var state_15524__$1 = state_15524;
var statearr_15658_15814 = state_15524__$1;
(statearr_15658_15814[(2)] = inst_15358);

(statearr_15658_15814[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (53))){
var inst_15380 = (state_15524[(2)]);
var state_15524__$1 = state_15524;
if(cljs.core.truth_(inst_15380)){
var statearr_15659_15815 = state_15524__$1;
(statearr_15659_15815[(1)] = (57));

} else {
var statearr_15660_15816 = state_15524__$1;
(statearr_15660_15816[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (78))){
var inst_15386 = (state_15524[(7)]);
var inst_15387 = (state_15524[(8)]);
var inst_15419 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_15420 = inst_15387.call(null,cljs.core.PersistentArrayMap,null,3,inst_15419,null);
var inst_15421 = inst_15387.call(null,cljs.core.PersistentHashSet,null,inst_15420,null);
var inst_15422 = inst_15421.call(null,inst_15386);
var state_15524__$1 = state_15524;
if(cljs.core.truth_(inst_15422)){
var statearr_15661_15817 = state_15524__$1;
(statearr_15661_15817[(1)] = (79));

} else {
var statearr_15662_15818 = state_15524__$1;
(statearr_15662_15818[(1)] = (80));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (26))){
var inst_15297 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15298 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_15299 = cljs.core.PersistentHashMap.fromArrays(inst_15297,inst_15298);
var inst_15300 = cljs.core.ex_info.call(null,"A boolean _predicate cannot be unique.",inst_15299);
var inst_15301 = (function(){throw inst_15300})();
var state_15524__$1 = state_15524;
var statearr_15663_15819 = state_15524__$1;
(statearr_15663_15819[(2)] = inst_15301);

(statearr_15663_15819[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (16))){
var inst_15255 = (state_15524[(9)]);
var inst_15276 = (state_15524[(31)]);
var inst_15275 = (state_15524[(2)]);
var inst_15276__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_15255);
var state_15524__$1 = (function (){var statearr_15664 = state_15524;
(statearr_15664[(12)] = inst_15275);

(statearr_15664[(31)] = inst_15276__$1);

return statearr_15664;
})();
if(cljs.core.truth_(inst_15276__$1)){
var statearr_15665_15820 = state_15524__$1;
(statearr_15665_15820[(1)] = (17));

} else {
var statearr_15666_15821 = state_15524__$1;
(statearr_15666_15821[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (81))){
var inst_15427 = (state_15524[(2)]);
var state_15524__$1 = state_15524;
var statearr_15667_15822 = state_15524__$1;
(statearr_15667_15822[(2)] = inst_15427);

(statearr_15667_15822[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (79))){
var inst_15354 = (state_15524[(11)]);
var state_15524__$1 = state_15524;
var statearr_15668_15823 = state_15524__$1;
(statearr_15668_15823[(2)] = inst_15354);

(statearr_15668_15823[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (38))){
var inst_15330 = (state_15524[(29)]);
var inst_15327 = (state_15524[(30)]);
var inst_15333 = (state_15524[(2)]);
var inst_15334 = fluree.db.util.async.throw_err.call(null,inst_15333);
var inst_15335 = cljs.core.not.call(null,inst_15334);
var inst_15336 = ((inst_15327) && (inst_15330) && (inst_15335));
var state_15524__$1 = state_15524;
var statearr_15669_15824 = state_15524__$1;
(statearr_15669_15824[(2)] = inst_15336);

(statearr_15669_15824[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (98))){
var inst_15386 = (state_15524[(7)]);
var inst_15387 = (state_15524[(8)]);
var inst_15469 = fluree.db.query.schema.type_error.call(null,inst_15386,inst_15387,throw_QMARK_);
var state_15524__$1 = state_15524;
var statearr_15670_15825 = state_15524__$1;
(statearr_15670_15825[(2)] = inst_15469);

(statearr_15670_15825[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (87))){
var inst_15354 = (state_15524[(11)]);
var state_15524__$1 = state_15524;
var statearr_15671_15826 = state_15524__$1;
(statearr_15671_15826[(2)] = inst_15354);

(statearr_15671_15826[(1)] = (89));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (30))){
var inst_15308 = (state_15524[(24)]);
var state_15524__$1 = state_15524;
var statearr_15672_15827 = state_15524__$1;
(statearr_15672_15827[(2)] = inst_15308);

(statearr_15672_15827[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (73))){
var inst_15407 = (state_15524[(2)]);
var state_15524__$1 = state_15524;
var statearr_15673_15828 = state_15524__$1;
(statearr_15673_15828[(2)] = inst_15407);

(statearr_15673_15828[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (96))){
var inst_15386 = (state_15524[(7)]);
var inst_15387 = (state_15524[(8)]);
var inst_15465 = fluree.db.query.schema.type_error.call(null,inst_15386,inst_15387,throw_QMARK_);
var state_15524__$1 = state_15524;
var statearr_15674_15829 = state_15524__$1;
(statearr_15674_15829[(2)] = inst_15465);

(statearr_15674_15829[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (10))){
var inst_15517 = (state_15524[(2)]);
var state_15524__$1 = state_15524;
var statearr_15675_15830 = state_15524__$1;
(statearr_15675_15830[(2)] = inst_15517);

(statearr_15675_15830[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (18))){
var inst_15276 = (state_15524[(31)]);
var state_15524__$1 = state_15524;
var statearr_15676_15831 = state_15524__$1;
(statearr_15676_15831[(2)] = inst_15276);

(statearr_15676_15831[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (105))){
var state_15524__$1 = state_15524;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_15677_15832 = state_15524__$1;
(statearr_15677_15832[(1)] = (108));

} else {
var statearr_15678_15833 = state_15524__$1;
(statearr_15678_15833[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (52))){
var state_15524__$1 = state_15524;
var statearr_15679_15834 = state_15524__$1;
(statearr_15679_15834[(2)] = false);

(statearr_15679_15834[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (67))){
var state_15524__$1 = state_15524;
var statearr_15680_15835 = state_15524__$1;
(statearr_15680_15835[(2)] = null);

(statearr_15680_15835[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (71))){
var inst_15354 = (state_15524[(11)]);
var state_15524__$1 = state_15524;
var statearr_15681_15836 = state_15524__$1;
(statearr_15681_15836[(2)] = inst_15354);

(statearr_15681_15836[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (42))){
var inst_15254 = (state_15524[(21)]);
var inst_15243 = (state_15524[(15)]);
var inst_15342 = fluree.db.dbproto._p_prop.call(null,inst_15243,new cljs.core.Keyword(null,"name","name",1843675177),inst_15254);
var inst_15343 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_15342)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_15344 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15345 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_15346 = cljs.core.PersistentHashMap.fromArrays(inst_15344,inst_15345);
var inst_15347 = cljs.core.ex_info.call(null,inst_15343,inst_15346);
var inst_15348 = (function(){throw inst_15347})();
var state_15524__$1 = state_15524;
var statearr_15682_15837 = state_15524__$1;
(statearr_15682_15837[(2)] = inst_15348);

(statearr_15682_15837[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (80))){
var inst_15386 = (state_15524[(7)]);
var inst_15387 = (state_15524[(8)]);
var inst_15425 = fluree.db.query.schema.type_error.call(null,inst_15386,inst_15387,throw_QMARK_);
var state_15524__$1 = state_15524;
var statearr_15683_15838 = state_15524__$1;
(statearr_15683_15838[(2)] = inst_15425);

(statearr_15683_15838[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (37))){
var inst_15339 = (state_15524[(2)]);
var state_15524__$1 = state_15524;
if(cljs.core.truth_(inst_15339)){
var statearr_15684_15839 = state_15524__$1;
(statearr_15684_15839[(1)] = (39));

} else {
var statearr_15685_15840 = state_15524__$1;
(statearr_15685_15840[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (63))){
var inst_15386 = (state_15524[(7)]);
var inst_15387 = (state_15524[(8)]);
var inst_15396 = fluree.db.query.schema.type_error.call(null,inst_15386,inst_15387,throw_QMARK_);
var state_15524__$1 = state_15524;
var statearr_15686_15841 = state_15524__$1;
(statearr_15686_15841[(2)] = inst_15396);

(statearr_15686_15841[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (94))){
var inst_15386 = (state_15524[(7)]);
var inst_15387 = (state_15524[(8)]);
var inst_15459 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_15460 = inst_15387.call(null,cljs.core.PersistentArrayMap,null,2,inst_15459,null);
var inst_15461 = inst_15387.call(null,cljs.core.PersistentHashSet,null,inst_15460,null);
var inst_15462 = inst_15461.call(null,inst_15386);
var state_15524__$1 = state_15524;
if(cljs.core.truth_(inst_15462)){
var statearr_15687_15842 = state_15524__$1;
(statearr_15687_15842[(1)] = (95));

} else {
var statearr_15688_15843 = state_15524__$1;
(statearr_15688_15843[(1)] = (96));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (8))){
var inst_15243 = (state_15524[(15)]);
var state_15524__$1 = state_15524;
var statearr_15689_15844 = state_15524__$1;
(statearr_15689_15844[(2)] = inst_15243);

(statearr_15689_15844[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (49))){
var inst_15354 = (state_15524[(11)]);
var state_15524__$1 = state_15524;
var statearr_15690_15845 = state_15524__$1;
(statearr_15690_15845[(2)] = inst_15354);

(statearr_15690_15845[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15525 === (84))){
var inst_15386 = (state_15524[(7)]);
var inst_15387 = (state_15524[(8)]);
var inst_15435 = fluree.db.query.schema.type_error.call(null,inst_15386,inst_15387,throw_QMARK_);
var state_15524__$1 = state_15524;
var statearr_15691_15846 = state_15524__$1;
(statearr_15691_15846[(2)] = inst_15435);

(statearr_15691_15846[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2468__auto__ = null;
var fluree$db$query$schema$state_machine__2468__auto____0 = (function (){
var statearr_15692 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15692[(0)] = fluree$db$query$schema$state_machine__2468__auto__);

(statearr_15692[(1)] = (1));

return statearr_15692;
});
var fluree$db$query$schema$state_machine__2468__auto____1 = (function (state_15524){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_15524);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e15693){var ex__2471__auto__ = e15693;
var statearr_15694_15847 = state_15524;
(statearr_15694_15847[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_15524[(4)]))){
var statearr_15695_15848 = state_15524;
(statearr_15695_15848[(1)] = cljs.core.first.call(null,(state_15524[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15849 = state_15524;
state_15524 = G__15849;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2468__auto__ = function(state_15524){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2468__auto____1.call(this,state_15524);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2468__auto____0;
fluree$db$query$schema$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2468__auto____1;
return fluree$db$query$schema$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_15696 = f__2491__auto__.call(null);
(statearr_15696[(6)] = c__2490__auto__);

return statearr_15696;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(db,tempids,flakes){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_15873){
var state_val_15874 = (state_15873[(1)]);
if((state_val_15874 === (7))){
var state_15873__$1 = state_15873;
var statearr_15875_15894 = state_15873__$1;
(statearr_15875_15894[(2)] = db);

(statearr_15875_15894[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15874 === (1))){
var state_15873__$1 = state_15873;
var statearr_15876_15895 = state_15873__$1;
(statearr_15876_15895[(2)] = null);

(statearr_15876_15895[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15874 === (4))){
var inst_15850 = (state_15873[(2)]);
var state_15873__$1 = state_15873;
var statearr_15877_15896 = state_15873__$1;
(statearr_15877_15896[(2)] = inst_15850);

(statearr_15877_15896[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15874 === (6))){
var inst_15859 = (state_15873[(7)]);
var inst_15858 = (state_15873[(2)]);
var inst_15859__$1 = fluree.db.util.async.throw_err.call(null,inst_15858);
var inst_15860 = cljs.core.empty_QMARK_.call(null,inst_15859__$1);
var state_15873__$1 = (function (){var statearr_15878 = state_15873;
(statearr_15878[(7)] = inst_15859__$1);

return statearr_15878;
})();
if(inst_15860){
var statearr_15879_15897 = state_15873__$1;
(statearr_15879_15897[(1)] = (7));

} else {
var statearr_15880_15898 = state_15873__$1;
(statearr_15880_15898[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15874 === (3))){
var inst_15871 = (state_15873[(2)]);
var state_15873__$1 = state_15873;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15873__$1,inst_15871);
} else {
if((state_val_15874 === (2))){
var _ = (function (){var statearr_15882 = state_15873;
(statearr_15882[(4)] = cljs.core.cons.call(null,(5),(state_15873[(4)])));

return statearr_15882;
})();
var inst_15856 = fluree.db.query.schema.new_pred_changes.call(null,db,tempids,flakes);
var state_15873__$1 = state_15873;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15873__$1,(6),inst_15856);
} else {
if((state_val_15874 === (9))){
var inst_15868 = (state_15873[(2)]);
var _ = (function (){var statearr_15883 = state_15873;
(statearr_15883[(4)] = cljs.core.rest.call(null,(state_15873[(4)])));

return statearr_15883;
})();
var state_15873__$1 = state_15873;
var statearr_15884_15899 = state_15873__$1;
(statearr_15884_15899[(2)] = inst_15868);

(statearr_15884_15899[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15874 === (5))){
var _ = (function (){var statearr_15885 = state_15873;
(statearr_15885[(4)] = cljs.core.rest.call(null,(state_15873[(4)])));

return statearr_15885;
})();
var state_15873__$1 = state_15873;
var ex15881 = (state_15873__$1[(2)]);
var statearr_15886_15900 = state_15873__$1;
(statearr_15886_15900[(5)] = ex15881);


if((ex15881 instanceof Error)){
var statearr_15887_15901 = state_15873__$1;
(statearr_15887_15901[(1)] = (4));

(statearr_15887_15901[(5)] = null);

} else {
throw ex15881;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15874 === (10))){
var inst_15865 = (state_15873[(2)]);
var inst_15866 = fluree.db.util.async.throw_err.call(null,inst_15865);
var state_15873__$1 = state_15873;
var statearr_15888_15902 = state_15873__$1;
(statearr_15888_15902[(2)] = inst_15866);

(statearr_15888_15902[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15874 === (8))){
var inst_15859 = (state_15873[(7)]);
var inst_15863 = fluree.db.query.schema.predicate_change_error.call(null,inst_15859,db,true);
var state_15873__$1 = state_15873;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15873__$1,(10),inst_15863);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$validate_schema_change_$_state_machine__2468__auto__ = null;
var fluree$db$query$schema$validate_schema_change_$_state_machine__2468__auto____0 = (function (){
var statearr_15889 = [null,null,null,null,null,null,null,null];
(statearr_15889[(0)] = fluree$db$query$schema$validate_schema_change_$_state_machine__2468__auto__);

(statearr_15889[(1)] = (1));

return statearr_15889;
});
var fluree$db$query$schema$validate_schema_change_$_state_machine__2468__auto____1 = (function (state_15873){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_15873);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e15890){var ex__2471__auto__ = e15890;
var statearr_15891_15903 = state_15873;
(statearr_15891_15903[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_15873[(4)]))){
var statearr_15892_15904 = state_15873;
(statearr_15892_15904[(1)] = cljs.core.first.call(null,(state_15873[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15905 = state_15873;
state_15873 = G__15905;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$schema$validate_schema_change_$_state_machine__2468__auto__ = function(state_15873){
switch(arguments.length){
case 0:
return fluree$db$query$schema$validate_schema_change_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$schema$validate_schema_change_$_state_machine__2468__auto____1.call(this,state_15873);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$validate_schema_change_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$validate_schema_change_$_state_machine__2468__auto____0;
fluree$db$query$schema$validate_schema_change_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$validate_schema_change_$_state_machine__2468__auto____1;
return fluree$db$query$schema$validate_schema_change_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_15893 = f__2491__auto__.call(null);
(statearr_15893[(6)] = c__2490__auto__);

return statearr_15893;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__15907 = arguments.length;
switch (G__15907) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.call(null,predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$.call(null,cljs.core.re_matches.call(null,fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.call(null,["Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__15909 = cljs.core.re_matches.call(null,/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.call(null,vec__15909,(0),null);
var ns = cljs.core.nth.call(null,vec__15909,(1),null);
var name = cljs.core.nth.call(null,vec__15909,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.call(null,"_",cljs.core.nth.call(null,name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.call(null,name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.call(null,["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
throw cljs.core.ex_info.call(null,["Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid.call(null,(3),(2)),fluree.db.flake.__GT_sid.call(null,(3),(9)),fluree.db.flake.__GT_sid.call(null,(3),(14)),fluree.db.flake.__GT_sid.call(null,(3),(16)),fluree.db.flake.__GT_sid.call(null,(3),(8)),fluree.db.flake.__GT_sid.call(null,(3),(4)),fluree.db.flake.__GT_sid.call(null,(3),(5)),fluree.db.flake.__GT_sid.call(null,(3),(15)),fluree.db.flake.__GT_sid.call(null,(3),(17)),fluree.db.flake.__GT_sid.call(null,(3),(11)),fluree.db.flake.__GT_sid.call(null,(3),(12)),fluree.db.flake.__GT_sid.call(null,(3),(1)),fluree.db.flake.__GT_sid.call(null,(3),(10)),fluree.db.flake.__GT_sid.call(null,(3),(6)),fluree.db.flake.__GT_sid.call(null,(3),(7)),fluree.db.flake.__GT_sid.call(null,(3),(13))],[new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword(null,"int","int",-1741416922),new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"bytes","bytes",1175866680),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"geojson","geojson",-719473398),new cljs.core.Keyword(null,"bigint","bigint",-1710937017),new cljs.core.Keyword(null,"float","float",-1732389368),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"long","long",-171452093),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"uri","uri",-774711847),new cljs.core.Keyword(null,"double","double",884886883)]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid.call(null,(3),(62)),fluree.db.flake.__GT_sid.call(null,(3),(68)),fluree.db.flake.__GT_sid.call(null,(3),(67)),fluree.db.flake.__GT_sid.call(null,(3),(69)),fluree.db.flake.__GT_sid.call(null,(3),(63)),fluree.db.flake.__GT_sid.call(null,(3),(70)),fluree.db.flake.__GT_sid.call(null,(3),(65)),fluree.db.flake.__GT_sid.call(null,(3),(66)),fluree.db.flake.__GT_sid.call(null,(3),(64)),fluree.db.flake.__GT_sid.call(null,(3),(61))],[new cljs.core.Keyword(null,"bn","bn",-1320495310),new cljs.core.Keyword(null,"hi","hi",-1821422114),new cljs.core.Keyword(null,"fr","fr",1577713888),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"br","br",934104792),new cljs.core.Keyword(null,"ru","ru",-1755311210),new cljs.core.Keyword(null,"en","en",88457073),new cljs.core.Keyword(null,"es","es",1831673219),new cljs.core.Keyword(null,"cn","cn",457269822),new cljs.core.Keyword(null,"ar","ar",-2093907980)]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.call(null,(function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.call(null,acc,p);
if(cljs.core.truth_((function (){var and__4115__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.vector_QMARK_.call(null,existing_QMARK_);
} else {
return and__4115__auto__;
}
})())){
return cljs.core.update.call(null,acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.call(null,acc,p,(function (p1__15912_SHARP_,p2__15913_SHARP_){
return cljs.core.vec.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__15912_SHARP_,p2__15913_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.call(null,acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with two keys:
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_15979){
var state_val_15980 = (state_15979[(1)]);
if((state_val_15980 === (1))){
var state_15979__$1 = state_15979;
var statearr_15981_15998 = state_15979__$1;
(statearr_15981_15998[(2)] = null);

(statearr_15981_15998[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15980 === (2))){
var _ = (function (){var statearr_15982 = state_15979;
(statearr_15982[(4)] = cljs.core.cons.call(null,(5),(state_15979[(4)])));

return statearr_15982;
})();
var inst_15931 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15932 = fluree.db.flake.max_subject_id.call(null,(1));
var inst_15933 = [inst_15932];
var inst_15934 = (new cljs.core.PersistentVector(null,1,(5),inst_15931,inst_15933,null));
var inst_15935 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15936 = [(0)];
var inst_15937 = (new cljs.core.PersistentVector(null,1,(5),inst_15935,inst_15936,null));
var inst_15938 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_15934,cljs.core._LT__EQ_,inst_15937);
var state_15979__$1 = state_15979;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15979__$1,(6),inst_15938);
} else {
if((state_val_15980 === (3))){
var inst_15977 = (state_15979[(2)]);
var state_15979__$1 = state_15979;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15979__$1,inst_15977);
} else {
if((state_val_15980 === (4))){
var inst_15919 = (state_15979[(2)]);
var state_15979__$1 = state_15979;
var statearr_15984_15999 = state_15979__$1;
(statearr_15984_15999[(2)] = inst_15919);

(statearr_15984_15999[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15980 === (5))){
var _ = (function (){var statearr_15985 = state_15979;
(statearr_15985[(4)] = cljs.core.rest.call(null,(state_15979[(4)])));

return statearr_15985;
})();
var state_15979__$1 = state_15979;
var ex15983 = (state_15979__$1[(2)]);
var statearr_15986_16000 = state_15979__$1;
(statearr_15986_16000[(5)] = ex15983);


if((ex15983 instanceof Error)){
var statearr_15987_16001 = state_15979__$1;
(statearr_15987_16001[(1)] = (4));

(statearr_15987_16001[(5)] = null);

} else {
throw ex15983;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15980 === (6))){
var inst_15940 = (state_15979[(2)]);
var inst_15941 = fluree.db.util.async.throw_err.call(null,inst_15940);
var inst_15942 = (function (){var schema_flakes = inst_15941;
return (function (p1__15914_SHARP_){
return (p1__15914_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_15943 = cljs.core.partition_by.call(null,inst_15942,inst_15941);
var inst_15944 = cljs.core.nth.call(null,inst_15943,(0),null);
var inst_15945 = cljs.core.nth.call(null,inst_15943,(1),null);
var inst_15946 = (function (){var schema_flakes = inst_15941;
var vec__15925 = inst_15943;
var collection_flakes = inst_15944;
var predicate_flakes = inst_15945;
return (function (acc,coll_flakes){
var sid = cljs.core.first.call(null,coll_flakes).s;
var id = fluree.db.flake.sid__GT_i.call(null,sid);
var p__GT_v = cljs.core.reduce.call(null,(function (p1__15916_SHARP_,p2__15917_SHARP_){
return cljs.core.assoc.call(null,p1__15916_SHARP_,p2__15917_SHARP_.p,p2__15917_SHARP_.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var c_name = cljs.core.get.call(null,p__GT_v,(40));
var spec = cljs.core.get.call(null,p__GT_v,(43));
var specDoc = cljs.core.get.call(null,p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),c_name,new cljs.core.Keyword(null,"sid","sid",1815016414),sid,new cljs.core.Keyword(null,"spec","spec",347520401),spec,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),specDoc,new cljs.core.Keyword(null,"id","id",-1388402092),id], null);
return cljs.core.assoc.call(null,acc,id,c_props,c_name,c_props);
});
})();
var inst_15947 = [(-1),"_tx"];
var inst_15948 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414)];
var inst_15949 = ["_tx",(-1),(-1)];
var inst_15950 = cljs.core.PersistentHashMap.fromArrays(inst_15948,inst_15949);
var inst_15951 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414)];
var inst_15952 = ["_tx",(-1),(-1)];
var inst_15953 = cljs.core.PersistentHashMap.fromArrays(inst_15951,inst_15952);
var inst_15954 = [inst_15950,inst_15953];
var inst_15955 = cljs.core.PersistentHashMap.fromArrays(inst_15947,inst_15954);
var inst_15956 = (function (){var schema_flakes = inst_15941;
var vec__15925 = inst_15943;
var collection_flakes = inst_15944;
var predicate_flakes = inst_15945;
return (function (p1__15915_SHARP_){
return p1__15915_SHARP_.s;
});
})();
var inst_15957 = cljs.core.partition_by.call(null,inst_15956,inst_15944);
var inst_15958 = cljs.core.reduce.call(null,inst_15946,inst_15955,inst_15957);
var inst_15960 = (function (){var schema_flakes = inst_15941;
var vec__15925 = inst_15943;
var collection_flakes = inst_15944;
var predicate_flakes = inst_15945;
var coll = inst_15958;
return (function (p__15959,pred_flakes){
var vec__15988 = p__15959;
var pred = cljs.core.nth.call(null,vec__15988,(0),null);
var fullText = cljs.core.nth.call(null,vec__15988,(1),null);
var id = cljs.core.first.call(null,pred_flakes).s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map.call(null,pred_flakes);
var p_name = cljs.core.get.call(null,p__GT_v,(10));
var p_type = cljs.core.get.call(null,fluree.db.query.schema.type_sid__GT_type,cljs.core.get.call(null,p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ref","ref",1289896967),null,new cljs.core.Keyword(null,"tag","tag",-1290361223),null], null), null).call(null,p_type));
var idx_QMARK_ = cljs.core.boolean$.call(null,(function (){var or__4126__auto__ = ref_QMARK_;
if(or__4126__auto__){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = cljs.core.get.call(null,p__GT_v,(15));
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core.get.call(null,p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.call(null,p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"unique","unique",329397282),new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),new cljs.core.Keyword(null,"index","index",-1531685915),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"multi","multi",-190293005),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),new cljs.core.Keyword(null,"idx?","idx?",-564590377),new cljs.core.Keyword(null,"ref?","ref?",1932693720),new cljs.core.Keyword(null,"upsert","upsert",1416724984),new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)],[cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(13))),cljs.core.get.call(null,p__GT_v,(19)),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(15))),p_name,cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(18))),p_type,cljs.core.get.call(null,p__GT_v,(24)),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(17))),cljs.core.get.call(null,p__GT_v,(25)),cljs.core.get.call(null,p__GT_v,(20)),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(14))),id,cljs.core.get.call(null,p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(16))),cljs.core.get.call(null,p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,pred,id,p_props,p_name,p_props),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.call(null,fullText,id):fullText)], null);
});
})();
var inst_15961 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15962 = cljs.core.PersistentHashMap.EMPTY;
var inst_15963 = cljs.core.PersistentHashSet.EMPTY;
var inst_15964 = [inst_15962,inst_15963];
var inst_15965 = (new cljs.core.PersistentVector(null,2,(5),inst_15961,inst_15964,null));
var inst_15966 = (function (){var schema_flakes = inst_15941;
var vec__15925 = inst_15943;
var collection_flakes = inst_15944;
var predicate_flakes = inst_15945;
var coll = inst_15958;
return (function (p1__15918_SHARP_){
return p1__15918_SHARP_.s;
});
})();
var inst_15967 = cljs.core.partition_by.call(null,inst_15966,inst_15945);
var inst_15968 = cljs.core.reduce.call(null,inst_15960,inst_15965,inst_15967);
var inst_15969 = cljs.core.nth.call(null,inst_15968,(0),null);
var inst_15970 = cljs.core.nth.call(null,inst_15968,(1),null);
var inst_15971 = [new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"coll","coll",1647737163),new cljs.core.Keyword(null,"pred","pred",1927423397),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)];
var inst_15972 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_15973 = [inst_15972,inst_15958,inst_15969,inst_15970];
var inst_15974 = cljs.core.PersistentHashMap.fromArrays(inst_15971,inst_15973);
var _ = (function (){var statearr_15991 = state_15979;
(statearr_15991[(4)] = cljs.core.rest.call(null,(state_15979[(4)])));

return statearr_15991;
})();
var state_15979__$1 = state_15979;
var statearr_15992_16002 = state_15979__$1;
(statearr_15992_16002[(2)] = inst_15974);

(statearr_15992_16002[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__2468__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__2468__auto____0 = (function (){
var statearr_15993 = [null,null,null,null,null,null,null];
(statearr_15993[(0)] = fluree$db$query$schema$schema_map_$_state_machine__2468__auto__);

(statearr_15993[(1)] = (1));

return statearr_15993;
});
var fluree$db$query$schema$schema_map_$_state_machine__2468__auto____1 = (function (state_15979){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_15979);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e15994){var ex__2471__auto__ = e15994;
var statearr_15995_16003 = state_15979;
(statearr_15995_16003[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_15979[(4)]))){
var statearr_15996_16004 = state_15979;
(statearr_15996_16004[(1)] = cljs.core.first.call(null,(state_15979[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16005 = state_15979;
state_15979 = G__16005;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__2468__auto__ = function(state_15979){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__2468__auto____1.call(this,state_15979);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__2468__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__2468__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_15997 = f__2491__auto__.call(null);
(statearr_15997[(6)] = c__2490__auto__);

return statearr_15997;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_16047){
var state_val_16048 = (state_16047[(1)]);
if((state_val_16048 === (7))){
var inst_16030 = (state_16047[(2)]);
var inst_16031 = fluree.db.query.schema.flake__GT_pred_map.call(null,inst_16030);
var inst_16032 = [new cljs.core.Keyword(null,"passwords","passwords",-403324634),new cljs.core.Keyword(null,"anonymous","anonymous",447897231),new cljs.core.Keyword(null,"language","language",-1591107564),new cljs.core.Keyword(null,"ledgers","ledgers",-2111050533),new cljs.core.Keyword(null,"txMax","txMax",418352369),new cljs.core.Keyword(null,"consensus","consensus",1370116681)];
var inst_16033 = cljs.core.get.call(null,inst_16031,(114));
var inst_16034 = cljs.core.boolean$.call(null,inst_16033);
var inst_16035 = cljs.core.get.call(null,inst_16031,(110));
var inst_16036 = cljs.core.get.call(null,inst_16031,(117));
var inst_16037 = cljs.core.get.call(null,fluree.db.query.schema.lang_sid__GT_lang,inst_16036);
var inst_16038 = cljs.core.get.call(null,inst_16031,(111));
var inst_16039 = cljs.core.get.call(null,inst_16031,(115));
var inst_16040 = cljs.core.get.call(null,inst_16031,(112));
var inst_16041 = [inst_16034,inst_16035,inst_16037,inst_16038,inst_16039,inst_16040];
var inst_16042 = cljs.core.PersistentHashMap.fromArrays(inst_16032,inst_16041);
var _ = (function (){var statearr_16049 = state_16047;
(statearr_16049[(4)] = cljs.core.rest.call(null,(state_16047[(4)])));

return statearr_16049;
})();
var state_16047__$1 = state_16047;
var statearr_16050_16073 = state_16047__$1;
(statearr_16050_16073[(2)] = inst_16042);

(statearr_16050_16073[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16048 === (1))){
var state_16047__$1 = state_16047;
var statearr_16051_16074 = state_16047__$1;
(statearr_16051_16074[(2)] = null);

(statearr_16051_16074[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16048 === (4))){
var inst_16006 = (state_16047[(2)]);
var state_16047__$1 = state_16047;
var statearr_16052_16075 = state_16047__$1;
(statearr_16052_16075[(2)] = inst_16006);

(statearr_16052_16075[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16048 === (6))){
var _ = (function (){var statearr_16053 = state_16047;
(statearr_16053[(4)] = cljs.core.cons.call(null,(9),(state_16047[(4)])));

return statearr_16053;
})();
var inst_16018 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16019 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16020 = ["_setting/id","root"];
var inst_16021 = (new cljs.core.PersistentVector(null,2,(5),inst_16019,inst_16020,null));
var inst_16022 = [inst_16021];
var inst_16023 = (new cljs.core.PersistentVector(null,1,(5),inst_16018,inst_16022,null));
var inst_16024 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_16023);
var state_16047__$1 = state_16047;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16047__$1,(10),inst_16024);
} else {
if((state_val_16048 === (3))){
var inst_16045 = (state_16047[(2)]);
var state_16047__$1 = state_16047;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16047__$1,inst_16045);
} else {
if((state_val_16048 === (2))){
var _ = (function (){var statearr_16056 = state_16047;
(statearr_16056[(4)] = cljs.core.cons.call(null,(5),(state_16047[(4)])));

return statearr_16056;
})();
var state_16047__$1 = state_16047;
var statearr_16057_16076 = state_16047__$1;
(statearr_16057_16076[(2)] = null);

(statearr_16057_16076[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16048 === (9))){
var _ = (function (){var statearr_16058 = state_16047;
(statearr_16058[(4)] = cljs.core.rest.call(null,(state_16047[(4)])));

return statearr_16058;
})();
var state_16047__$1 = state_16047;
var ex16054 = (state_16047__$1[(2)]);
var statearr_16059_16077 = state_16047__$1;
(statearr_16059_16077[(5)] = ex16054);


if((ex16054 instanceof java.lang.Exception)){
var statearr_16060_16078 = state_16047__$1;
(statearr_16060_16078[(1)] = (8));

(statearr_16060_16078[(5)] = null);

} else {
throw ex16054;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16048 === (5))){
var _ = (function (){var statearr_16061 = state_16047;
(statearr_16061[(4)] = cljs.core.rest.call(null,(state_16047[(4)])));

return statearr_16061;
})();
var state_16047__$1 = state_16047;
var ex16055 = (state_16047__$1[(2)]);
var statearr_16062_16079 = state_16047__$1;
(statearr_16062_16079[(5)] = ex16055);


if((ex16055 instanceof Error)){
var statearr_16063_16080 = state_16047__$1;
(statearr_16063_16080[(1)] = (4));

(statearr_16063_16080[(5)] = null);

} else {
throw ex16055;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16048 === (10))){
var inst_16026 = (state_16047[(2)]);
var inst_16027 = fluree.db.util.async.throw_err.call(null,inst_16026);
var _ = (function (){var statearr_16064 = state_16047;
(statearr_16064[(4)] = cljs.core.rest.call(null,(state_16047[(4)])));

return statearr_16064;
})();
var state_16047__$1 = state_16047;
var statearr_16065_16081 = state_16047__$1;
(statearr_16065_16081[(2)] = inst_16027);

(statearr_16065_16081[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16048 === (8))){
var inst_16012 = (state_16047[(2)]);
var state_16047__$1 = (function (){var statearr_16066 = state_16047;
(statearr_16066[(7)] = inst_16012);

return statearr_16066;
})();
var statearr_16067_16082 = state_16047__$1;
(statearr_16067_16082[(2)] = null);

(statearr_16067_16082[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__2468__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__2468__auto____0 = (function (){
var statearr_16068 = [null,null,null,null,null,null,null,null];
(statearr_16068[(0)] = fluree$db$query$schema$setting_map_$_state_machine__2468__auto__);

(statearr_16068[(1)] = (1));

return statearr_16068;
});
var fluree$db$query$schema$setting_map_$_state_machine__2468__auto____1 = (function (state_16047){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_16047);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e16069){var ex__2471__auto__ = e16069;
var statearr_16070_16083 = state_16047;
(statearr_16070_16083[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_16047[(4)]))){
var statearr_16071_16084 = state_16047;
(statearr_16071_16084[(1)] = cljs.core.first.call(null,(state_16047[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16085 = state_16047;
state_16047 = G__16085;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__2468__auto__ = function(state_16047){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__2468__auto____1.call(this,state_16047);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__2468__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__2468__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_16072 = f__2491__auto__.call(null);
(statearr_16072[(6)] = c__2490__auto__);

return statearr_16072;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"t","t",-1397832519)], null));
});

//# sourceMappingURL=schema.js.map
