// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"?")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.call(null,(function (value_group){
var stringified = cljs.core.map.call(null,(function (p1__19129_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19129_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.call(null," ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.call(null," ",value_groups);
return ["VALUES ( ",clojure.string.join.call(null," ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__19133 = coll;
var vec__19134 = G__19133;
var seq__19135 = cljs.core.seq.call(null,vec__19134);
var first__19136 = cljs.core.first.call(null,seq__19135);
var seq__19135__$1 = cljs.core.next.call(null,seq__19135);
var clause = first__19136;
var r = seq__19135__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__19133__$1 = G__19133;
var res__$1 = res;
while(true){
var vec__19140 = G__19133__$1;
var seq__19141 = cljs.core.seq.call(null,vec__19140);
var first__19142 = cljs.core.first.call(null,seq__19141);
var seq__19141__$1 = cljs.core.next.call(null,seq__19141);
var clause__$1 = first__19142;
var r__$1 = seq__19141__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__19143 = r__$1;
var G__19144 = cljs.core.conj.call(null,res__$2,clause__$1);
G__19133__$1 = G__19143;
res__$1 = G__19144;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__19148 = coll;
var vec__19149 = G__19148;
var seq__19150 = cljs.core.seq.call(null,vec__19149);
var first__19151 = cljs.core.first.call(null,seq__19150);
var seq__19150__$1 = cljs.core.next.call(null,seq__19150);
var clause = first__19151;
var r = seq__19150__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__19148__$1 = G__19148;
var res__$1 = res;
while(true){
var vec__19155 = G__19148__$1;
var seq__19156 = cljs.core.seq.call(null,vec__19155);
var first__19157 = cljs.core.first.call(null,seq__19156);
var seq__19156__$1 = cljs.core.next.call(null,seq__19156);
var clause__$1 = first__19157;
var r__$1 = seq__19156__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__19158 = r__$1;
var G__19159 = cljs.core.conj.call(null,res__$2,cljs.core.rest.call(null,clause__$1));
G__19148__$1 = G__19158;
res__$1 = G__19159;
continue;
} else {
var G__19160 = r__$1;
var G__19161 = res__$2;
G__19148__$1 = G__19160;
res__$1 = G__19161;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__19165 = coll;
var vec__19166 = G__19165;
var seq__19167 = cljs.core.seq.call(null,vec__19166);
var first__19168 = cljs.core.first.call(null,seq__19167);
var seq__19167__$1 = cljs.core.next.call(null,seq__19167);
var clause = first__19168;
var r = seq__19167__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__19165__$1 = G__19165;
var res__$1 = res;
while(true){
var vec__19172 = G__19165__$1;
var seq__19173 = cljs.core.seq.call(null,vec__19172);
var first__19174 = cljs.core.first.call(null,seq__19173);
var seq__19173__$1 = cljs.core.next.call(null,seq__19173);
var clause__$1 = first__19174;
var r__$1 = seq__19173__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__19175 = r__$1;
var G__19176 = res__$2;
G__19165__$1 = G__19175;
res__$1 = G__19176;
continue;
} else {
var G__19177 = r__$1;
var G__19178 = cljs.core.conj.call(null,res__$2,clause__$1);
G__19165__$1 = G__19177;
res__$1 = G__19178;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_ = (function fluree$db$query$analytical_wikidata$wikiDataVar_QMARK_(string){
if(cljs.core.truth_(((typeof string === 'string')?cljs.core.re_matches.call(null,/^wd(t)*:(P|Q)\d+$/,string):false))){
cljs.core.symbol.call(null,string);
} else {
if(typeof string === 'string'){
["\"",string,"\""].join('');
} else {
}
}


return string;
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var clause_str = [clojure.string.join.call(null," ",cljs.core.map.call(null,fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_,clause)),"."].join('');
if(cljs.core.truth_(optional_QMARK_)){
return ["OPTIONAL {",clause_str,"}"].join('');
} else {
return clause_str;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.call(null,(function (acc_str,prefix){
var pfx = cljs.core.symbol.call(null,[fluree.db.util.core.keyword__GT_str.call(null,cljs.core.key.call(null,prefix)),":"].join(''));
var source = cljs.core.symbol.call(null,cljs.core.val.call(null,prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var _ = (cljs.core.truth_(new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132).cljs$core$IFn$_invoke$arity$1(q_map))?fluree.db.util.log.warn.call(null,["The Wikidata query option map should be included in the opts map. Top-level options are being deprecated. Provided: ",cljs.core.pr_str.call(null,q_map)].join('')):null);
var opts = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"limit","limit",-1355822363),(100),new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),false,new cljs.core.Keyword(null,"language","language",-1591107564),"en"], null),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132).cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132)], null),q_map));
var map__19182 = opts;
var map__19182__$1 = (((((!((map__19182 == null))))?(((((map__19182.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19182.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19182):map__19182);
var limit = cljs.core.get.call(null,map__19182__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__19182__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var distinct = cljs.core.get.call(null,map__19182__$1,new cljs.core.Keyword(null,"distinct","distinct",-1788879121));
var language = cljs.core.get.call(null,map__19182__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var prefixes = cljs.core.get.call(null,map__19182__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes.call(null,prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.call(null," ",cljs.core.map.call(null,(function (p1__19179_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19179_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.call(null," ",select_vars)].join('');
var where_smt = clojure.string.join.call(null," ",cljs.core.mapv.call(null,(function (p1__19180_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata.call(null,p1__19180_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.call(null," ",cljs.core.mapv.call(null,(function (p1__19181_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata.call(null,p1__19181_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4126__auto__ = language;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_19197){
var state_val_19198 = (state_19197[(1)]);
if((state_val_19198 === (1))){
var inst_19184 = fluree.db.util.core.url_encode.call(null,query);
var inst_19185 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_19184)].join('');
var inst_19186 = ["User-Agent","Accept"];
var inst_19187 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_19188 = cljs.core.PersistentHashMap.fromArrays(inst_19186,inst_19187);
var inst_19189 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_19190 = [inst_19188,(30000),new cljs.core.Keyword(null,"wikidata","wikidata",2100084440)];
var inst_19191 = cljs.core.PersistentHashMap.fromArrays(inst_19189,inst_19190);
var inst_19192 = fluree.db.util.xhttp.get.call(null,inst_19185,inst_19191);
var state_19197__$1 = state_19197;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19197__$1,(2),inst_19192);
} else {
if((state_val_19198 === (2))){
var inst_19194 = (state_19197[(2)]);
var inst_19195 = fluree.db.util.async.throw_err.call(null,inst_19194);
var state_19197__$1 = state_19197;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19197__$1,inst_19195);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2468__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2468__auto____0 = (function (){
var statearr_19199 = [null,null,null,null,null,null,null];
(statearr_19199[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2468__auto__);

(statearr_19199[(1)] = (1));

return statearr_19199;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2468__auto____1 = (function (state_19197){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_19197);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e19200){var ex__2471__auto__ = e19200;
var statearr_19201_19204 = state_19197;
(statearr_19201_19204[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_19197[(4)]))){
var statearr_19202_19205 = state_19197;
(statearr_19202_19205[(1)] = cljs.core.first.call(null,(state_19197[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19206 = state_19197;
state_19197 = G__19206;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2468__auto__ = function(state_19197){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2468__auto____1.call(this,state_19197);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2468__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2468__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_19203 = f__2491__auto__.call(null);
(statearr_19203[(6)] = c__2490__auto__);

return statearr_19203;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_19224){
var state_val_19225 = (state_19224[(1)]);
if((state_val_19225 === (1))){
var inst_19207 = fluree.db.query.analytical_wikidata.submit_wikidata_query.call(null,query);
var state_19224__$1 = state_19224;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19224__$1,(2),inst_19207);
} else {
if((state_val_19225 === (2))){
var inst_19210 = (state_19224[(7)]);
var inst_19209 = (state_19224[(2)]);
var inst_19210__$1 = fluree.db.util.async.throw_err.call(null,inst_19209);
var inst_19211 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_19210__$1);
var inst_19212 = cljs.core.not_EQ_.call(null,(200),inst_19211);
var state_19224__$1 = (function (){var statearr_19226 = state_19224;
(statearr_19226[(7)] = inst_19210__$1);

return statearr_19226;
})();
if(inst_19212){
var statearr_19227_19236 = state_19224__$1;
(statearr_19227_19236[(1)] = (3));

} else {
var statearr_19228_19237 = state_19224__$1;
(statearr_19228_19237[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19225 === (3))){
var inst_19210 = (state_19224[(7)]);
var state_19224__$1 = state_19224;
var statearr_19229_19238 = state_19224__$1;
(statearr_19229_19238[(2)] = inst_19210);

(statearr_19229_19238[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19225 === (4))){
var inst_19210 = (state_19224[(7)]);
var inst_19215 = (function (){var body = inst_19210;
return (function (item){
return cljs.core.reduce.call(null,(function (acc,k_v){
return cljs.core.assoc.call(null,acc,cljs.core.key.call(null,k_v),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_19216 = cljs.core.second.call(null,inst_19210);
var inst_19217 = cljs.core.second.call(null,inst_19216);
var inst_19218 = cljs.core.first.call(null,inst_19217);
var inst_19219 = cljs.core.second.call(null,inst_19218);
var inst_19220 = cljs.core.mapv.call(null,inst_19215,inst_19219);
var state_19224__$1 = state_19224;
var statearr_19230_19239 = state_19224__$1;
(statearr_19230_19239[(2)] = inst_19220);

(statearr_19230_19239[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19225 === (5))){
var inst_19222 = (state_19224[(2)]);
var state_19224__$1 = state_19224;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19224__$1,inst_19222);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2468__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2468__auto____0 = (function (){
var statearr_19231 = [null,null,null,null,null,null,null,null];
(statearr_19231[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2468__auto__);

(statearr_19231[(1)] = (1));

return statearr_19231;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2468__auto____1 = (function (state_19224){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_19224);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e19232){var ex__2471__auto__ = e19232;
var statearr_19233_19240 = state_19224;
(statearr_19233_19240[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_19224[(4)]))){
var statearr_19234_19241 = state_19224;
(statearr_19234_19241[(1)] = cljs.core.first.call(null,(state_19224[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19242 = state_19224;
state_19224 = G__19242;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2468__auto__ = function(state_19224){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2468__auto____1.call(this,state_19224);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2468__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2468__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_19235 = f__2491__auto__.call(null);
(statearr_19235[(6)] = c__2490__auto__);

return statearr_19235;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.call(null,(function (p1__19243_SHARP_){
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19243_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.call(null,cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.call(null,(function (p1__19244_SHARP_){
return fluree.db.util.core.str__GT_keyword.call(null,cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19244_SHARP_),(1)));
}),headers);
var results = new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.call(null,(function (res){
return cljs.core.map.call(null,(function (p1__19245_SHARP_){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(p1__19245_SHARP_.call(null,res));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_19283){
var state_val_19284 = (state_19283[(1)]);
if((state_val_19284 === (7))){
var inst_19255 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt.call(null,matching_vars,matching_vals);
var state_19283__$1 = state_19283;
var statearr_19285_19308 = state_19283__$1;
(statearr_19285_19308[(2)] = inst_19255);

(statearr_19285_19308[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (1))){
var state_19283__$1 = state_19283;
var statearr_19286_19309 = state_19283__$1;
(statearr_19286_19309[(2)] = null);

(statearr_19286_19309[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (4))){
var inst_19246 = (state_19283[(2)]);
var state_19283__$1 = state_19283;
var statearr_19287_19310 = state_19283__$1;
(statearr_19287_19310[(2)] = inst_19246);

(statearr_19287_19310[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (6))){
var state_19283__$1 = state_19283;
var statearr_19288_19311 = state_19283__$1;
(statearr_19288_19311[(2)] = null);

(statearr_19288_19311[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (3))){
var inst_19281 = (state_19283[(2)]);
var state_19283__$1 = state_19283;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19283__$1,inst_19281);
} else {
if((state_val_19284 === (12))){
var inst_19278 = (state_19283[(2)]);
var _ = (function (){var statearr_19289 = state_19283;
(statearr_19289[(4)] = cljs.core.rest.call(null,(state_19283[(4)])));

return statearr_19289;
})();
var state_19283__$1 = state_19283;
var statearr_19290_19312 = state_19283__$1;
(statearr_19290_19312[(2)] = inst_19278);

(statearr_19290_19312[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (2))){
var _ = (function (){var statearr_19291 = state_19283;
(statearr_19291[(4)] = cljs.core.cons.call(null,(5),(state_19283[(4)])));

return statearr_19291;
})();
var inst_19252 = cljs.core.empty_QMARK_.call(null,matching_vars);
var state_19283__$1 = state_19283;
if(inst_19252){
var statearr_19292_19313 = state_19283__$1;
(statearr_19292_19313[(1)] = (6));

} else {
var statearr_19293_19314 = state_19283__$1;
(statearr_19293_19314[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (11))){
var inst_19262 = (state_19283[(7)]);
var inst_19276 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples.call(null,inst_19262,all_vars);
var state_19283__$1 = state_19283;
var statearr_19295_19315 = state_19283__$1;
(statearr_19295_19315[(2)] = inst_19276);

(statearr_19295_19315[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (9))){
var inst_19262 = (state_19283[(7)]);
var inst_19261 = (state_19283[(2)]);
var inst_19262__$1 = fluree.db.util.async.throw_err.call(null,inst_19261);
var inst_19263 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_19262__$1);
var inst_19264 = cljs.core._EQ_.call(null,(400),inst_19263);
var state_19283__$1 = (function (){var statearr_19296 = state_19283;
(statearr_19296[(7)] = inst_19262__$1);

return statearr_19296;
})();
if(inst_19264){
var statearr_19297_19316 = state_19283__$1;
(statearr_19297_19316[(1)] = (10));

} else {
var statearr_19298_19317 = state_19283__$1;
(statearr_19298_19317[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (5))){
var _ = (function (){var statearr_19299 = state_19283;
(statearr_19299[(4)] = cljs.core.rest.call(null,(state_19283[(4)])));

return statearr_19299;
})();
var state_19283__$1 = state_19283;
var ex19294 = (state_19283__$1[(2)]);
var statearr_19300_19318 = state_19283__$1;
(statearr_19300_19318[(5)] = ex19294);


if((ex19294 instanceof Error)){
var statearr_19301_19319 = state_19283__$1;
(statearr_19301_19319[(1)] = (4));

(statearr_19301_19319[(5)] = null);

} else {
throw ex19294;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (10))){
var inst_19262 = (state_19283[(7)]);
var inst_19266 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_19262);
var inst_19267 = cljs.core.subs.call(null,inst_19266,(0),(1000));
var inst_19268 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19269 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_19262);
var inst_19270 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_19262);
var inst_19271 = [inst_19269,inst_19270];
var inst_19272 = cljs.core.PersistentHashMap.fromArrays(inst_19268,inst_19271);
var inst_19273 = cljs.core.ex_info.call(null,inst_19267,inst_19272);
var inst_19274 = (function(){throw inst_19273})();
var state_19283__$1 = state_19283;
var statearr_19302_19320 = state_19283__$1;
(statearr_19302_19320[(2)] = inst_19274);

(statearr_19302_19320[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (8))){
var inst_19257 = (state_19283[(2)]);
var inst_19258 = fluree.db.query.analytical_wikidata.generateWikiDataQuery.call(null,q_map,clauses,all_vars,inst_19257,optional_clauses);
var inst_19259 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query.call(null,inst_19258);
var state_19283__$1 = state_19283;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19283__$1,(9),inst_19259);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2468__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2468__auto____0 = (function (){
var statearr_19303 = [null,null,null,null,null,null,null,null];
(statearr_19303[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2468__auto__);

(statearr_19303[(1)] = (1));

return statearr_19303;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2468__auto____1 = (function (state_19283){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_19283);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e19304){var ex__2471__auto__ = e19304;
var statearr_19305_19321 = state_19283;
(statearr_19305_19321[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_19283[(4)]))){
var statearr_19306_19322 = state_19283;
(statearr_19306_19322[(1)] = cljs.core.first.call(null,(state_19283[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19323 = state_19283;
state_19283 = G__19323;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2468__auto__ = function(state_19283){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2468__auto____1.call(this,state_19283);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2468__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2468__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_19307 = f__2491__auto__.call(null);
(statearr_19307[(6)] = c__2490__auto__);

return statearr_19307;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});

//# sourceMappingURL=analytical_wikidata.js.map
