// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.dbproto');
goog.require('cljs.core');

/**
 * All nodes must implement this protocol. It's includes the minimal functionality
 * necessary to avoid resolving nodes unless strictly necessary.
 * @interface
 */
fluree.db.dbproto.IResolve = function(){};

var fluree$db$dbproto$IResolve$_first_flake$dyn_12987 = (function (node){
var x__4428__auto__ = (((node == null))?null:node);
var m__4429__auto__ = (fluree.db.dbproto._first_flake[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,node);
} else {
var m__4426__auto__ = (fluree.db.dbproto._first_flake["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,node);
} else {
throw cljs.core.missing_protocol.call(null,"IResolve.-first-flake",node);
}
}
});
/**
 * Returns the first flake in this node
 */
fluree.db.dbproto._first_flake = (function fluree$db$dbproto$_first_flake(node){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$IResolve$_first_flake$arity$1 == null)))))){
return node.fluree$db$dbproto$IResolve$_first_flake$arity$1(node);
} else {
return fluree$db$dbproto$IResolve$_first_flake$dyn_12987.call(null,node);
}
});

var fluree$db$dbproto$IResolve$_rhs$dyn_12988 = (function (node){
var x__4428__auto__ = (((node == null))?null:node);
var m__4429__auto__ = (fluree.db.dbproto._rhs[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,node);
} else {
var m__4426__auto__ = (fluree.db.dbproto._rhs["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,node);
} else {
throw cljs.core.missing_protocol.call(null,"IResolve.-rhs",node);
}
}
});
/**
 * Returns the next node's first flake
 */
fluree.db.dbproto._rhs = (function fluree$db$dbproto$_rhs(node){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$IResolve$_rhs$arity$1 == null)))))){
return node.fluree$db$dbproto$IResolve$_rhs$arity$1(node);
} else {
return fluree$db$dbproto$IResolve$_rhs$dyn_12988.call(null,node);
}
});

var fluree$db$dbproto$IResolve$_history_count$dyn_12989 = (function (node){
var x__4428__auto__ = (((node == null))?null:node);
var m__4429__auto__ = (fluree.db.dbproto._history_count[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,node);
} else {
var m__4426__auto__ = (fluree.db.dbproto._history_count["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,node);
} else {
throw cljs.core.missing_protocol.call(null,"IResolve.-history-count",node);
}
}
});
/**
 * Returns how many history nodes are present for this node (if a leaf)
 */
fluree.db.dbproto._history_count = (function fluree$db$dbproto$_history_count(node){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$IResolve$_history_count$arity$1 == null)))))){
return node.fluree$db$dbproto$IResolve$_history_count$arity$1(node);
} else {
return fluree$db$dbproto$IResolve$_history_count$dyn_12989.call(null,node);
}
});

var fluree$db$dbproto$IResolve$_resolve$dyn_12990 = (function (node){
var x__4428__auto__ = (((node == null))?null:node);
var m__4429__auto__ = (fluree.db.dbproto._resolve[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,node);
} else {
var m__4426__auto__ = (fluree.db.dbproto._resolve["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,node);
} else {
throw cljs.core.missing_protocol.call(null,"IResolve.-resolve",node);
}
}
});
/**
 * Returns node resolved with data as async channel
 */
fluree.db.dbproto._resolve = (function fluree$db$dbproto$_resolve(node){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$IResolve$_resolve$arity$1 == null)))))){
return node.fluree$db$dbproto$IResolve$_resolve$arity$1(node);
} else {
return fluree$db$dbproto$IResolve$_resolve$dyn_12990.call(null,node);
}
});

var fluree$db$dbproto$IResolve$_resolve_to_t$dyn_12991 = (function() {
var G__12992 = null;
var G__12992__3 = (function (node,t,idx_novelty){
var x__4428__auto__ = (((node == null))?null:node);
var m__4429__auto__ = (fluree.db.dbproto._resolve_to_t[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,node,t,idx_novelty);
} else {
var m__4426__auto__ = (fluree.db.dbproto._resolve_to_t["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,node,t,idx_novelty);
} else {
throw cljs.core.missing_protocol.call(null,"IResolve.-resolve-to-t",node);
}
}
});
var G__12992__4 = (function (node,t,idx_novelty,fast_forward_db_QMARK_){
var x__4428__auto__ = (((node == null))?null:node);
var m__4429__auto__ = (fluree.db.dbproto._resolve_to_t[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,node,t,idx_novelty,fast_forward_db_QMARK_);
} else {
var m__4426__auto__ = (fluree.db.dbproto._resolve_to_t["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,node,t,idx_novelty,fast_forward_db_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"IResolve.-resolve-to-t",node);
}
}
});
var G__12992__5 = (function (node,t,idx_novelty,fast_forward_db_QMARK_,remove_flakes){
var x__4428__auto__ = (((node == null))?null:node);
var m__4429__auto__ = (fluree.db.dbproto._resolve_to_t[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,node,t,idx_novelty,fast_forward_db_QMARK_,remove_flakes);
} else {
var m__4426__auto__ = (fluree.db.dbproto._resolve_to_t["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,node,t,idx_novelty,fast_forward_db_QMARK_,remove_flakes);
} else {
throw cljs.core.missing_protocol.call(null,"IResolve.-resolve-to-t",node);
}
}
});
G__12992 = function(node,t,idx_novelty,fast_forward_db_QMARK_,remove_flakes){
switch(arguments.length){
case 3:
return G__12992__3.call(this,node,t,idx_novelty);
case 4:
return G__12992__4.call(this,node,t,idx_novelty,fast_forward_db_QMARK_);
case 5:
return G__12992__5.call(this,node,t,idx_novelty,fast_forward_db_QMARK_,remove_flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__12992.cljs$core$IFn$_invoke$arity$3 = G__12992__3;
G__12992.cljs$core$IFn$_invoke$arity$4 = G__12992__4;
G__12992.cljs$core$IFn$_invoke$arity$5 = G__12992__5;
return G__12992;
})()
;
/**
 * Resolves this node at specified transaction 't'. Novelty included for the specified index.
 */
fluree.db.dbproto._resolve_to_t = (function fluree$db$dbproto$_resolve_to_t(var_args){
var G__12984 = arguments.length;
switch (G__12984) {
case 3:
return fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$3 = (function (node,t,idx_novelty){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 == null)))))){
return node.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3(node,t,idx_novelty);
} else {
return fluree$db$dbproto$IResolve$_resolve_to_t$dyn_12991.call(null,node,t,idx_novelty);
}
}));

(fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$4 = (function (node,t,idx_novelty,fast_forward_db_QMARK_){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 == null)))))){
return node.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4(node,t,idx_novelty,fast_forward_db_QMARK_);
} else {
return fluree$db$dbproto$IResolve$_resolve_to_t$dyn_12991.call(null,node,t,idx_novelty,fast_forward_db_QMARK_);
}
}));

(fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$5 = (function (node,t,idx_novelty,fast_forward_db_QMARK_,remove_flakes){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 == null)))))){
return node.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5(node,t,idx_novelty,fast_forward_db_QMARK_,remove_flakes);
} else {
return fluree$db$dbproto$IResolve$_resolve_to_t$dyn_12991.call(null,node,t,idx_novelty,fast_forward_db_QMARK_,remove_flakes);
}
}));

(fluree.db.dbproto._resolve_to_t.cljs$lang$maxFixedArity = 5);


var fluree$db$dbproto$IResolve$_resolve_history$dyn_12994 = (function (node){
var x__4428__auto__ = (((node == null))?null:node);
var m__4429__auto__ = (fluree.db.dbproto._resolve_history[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,node);
} else {
var m__4426__auto__ = (fluree.db.dbproto._resolve_history["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,node);
} else {
throw cljs.core.missing_protocol.call(null,"IResolve.-resolve-history",node);
}
}
});
/**
 * Returns the history for data nodes.
 */
fluree.db.dbproto._resolve_history = (function fluree$db$dbproto$_resolve_history(node){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$IResolve$_resolve_history$arity$1 == null)))))){
return node.fluree$db$dbproto$IResolve$_resolve_history$arity$1(node);
} else {
return fluree$db$dbproto$IResolve$_resolve_history$dyn_12994.call(null,node);
}
});

var fluree$db$dbproto$IResolve$_resolve_history_range$dyn_12995 = (function() {
var G__12996 = null;
var G__12996__3 = (function (node,from_t,to_t){
var x__4428__auto__ = (((node == null))?null:node);
var m__4429__auto__ = (fluree.db.dbproto._resolve_history_range[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,node,from_t,to_t);
} else {
var m__4426__auto__ = (fluree.db.dbproto._resolve_history_range["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,node,from_t,to_t);
} else {
throw cljs.core.missing_protocol.call(null,"IResolve.-resolve-history-range",node);
}
}
});
var G__12996__4 = (function (node,from_t,to_t,idx_novelty){
var x__4428__auto__ = (((node == null))?null:node);
var m__4429__auto__ = (fluree.db.dbproto._resolve_history_range[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,node,from_t,to_t,idx_novelty);
} else {
var m__4426__auto__ = (fluree.db.dbproto._resolve_history_range["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,node,from_t,to_t,idx_novelty);
} else {
throw cljs.core.missing_protocol.call(null,"IResolve.-resolve-history-range",node);
}
}
});
G__12996 = function(node,from_t,to_t,idx_novelty){
switch(arguments.length){
case 3:
return G__12996__3.call(this,node,from_t,to_t);
case 4:
return G__12996__4.call(this,node,from_t,to_t,idx_novelty);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__12996.cljs$core$IFn$_invoke$arity$3 = G__12996__3;
G__12996.cljs$core$IFn$_invoke$arity$4 = G__12996__4;
return G__12996;
})()
;
/**
 * Returns the history within specified range of 't' values. From is most recent time.
 */
fluree.db.dbproto._resolve_history_range = (function fluree$db$dbproto$_resolve_history_range(var_args){
var G__12986 = arguments.length;
switch (G__12986) {
case 3:
return fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$3 = (function (node,from_t,to_t){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 == null)))))){
return node.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3(node,from_t,to_t);
} else {
return fluree$db$dbproto$IResolve$_resolve_history_range$dyn_12995.call(null,node,from_t,to_t);
}
}));

(fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$4 = (function (node,from_t,to_t,idx_novelty){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 == null)))))){
return node.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4(node,from_t,to_t,idx_novelty);
} else {
return fluree$db$dbproto$IResolve$_resolve_history_range$dyn_12995.call(null,node,from_t,to_t,idx_novelty);
}
}));

(fluree.db.dbproto._resolve_history_range.cljs$lang$maxFixedArity = 4);



/**
 * @interface
 */
fluree.db.dbproto.INode = function(){};

var fluree$db$dbproto$INode$_lookup$dyn_12998 = (function (node,flake){
var x__4428__auto__ = (((node == null))?null:node);
var m__4429__auto__ = (fluree.db.dbproto._lookup[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,node,flake);
} else {
var m__4426__auto__ = (fluree.db.dbproto._lookup["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,node,flake);
} else {
throw cljs.core.missing_protocol.call(null,"INode.-lookup",node);
}
}
});
/**
 * Returns the child node which contains the given key
 */
fluree.db.dbproto._lookup = (function fluree$db$dbproto$_lookup(node,flake){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$INode$_lookup$arity$2 == null)))))){
return node.fluree$db$dbproto$INode$_lookup$arity$2(node,flake);
} else {
return fluree$db$dbproto$INode$_lookup$dyn_12998.call(null,node,flake);
}
});

var fluree$db$dbproto$INode$_lookup_after$dyn_12999 = (function (node,flake){
var x__4428__auto__ = (((node == null))?null:node);
var m__4429__auto__ = (fluree.db.dbproto._lookup_after[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,node,flake);
} else {
var m__4426__auto__ = (fluree.db.dbproto._lookup_after["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,node,flake);
} else {
throw cljs.core.missing_protocol.call(null,"INode.-lookup-after",node);
}
}
});
/**
 * Returns the child node which comes after the given key
 */
fluree.db.dbproto._lookup_after = (function fluree$db$dbproto$_lookup_after(node,flake){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$INode$_lookup_after$arity$2 == null)))))){
return node.fluree$db$dbproto$INode$_lookup_after$arity$2(node,flake);
} else {
return fluree$db$dbproto$INode$_lookup_after$dyn_12999.call(null,node,flake);
}
});

var fluree$db$dbproto$INode$_lookup_leaf$dyn_13000 = (function (node,flake){
var x__4428__auto__ = (((node == null))?null:node);
var m__4429__auto__ = (fluree.db.dbproto._lookup_leaf[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,node,flake);
} else {
var m__4426__auto__ = (fluree.db.dbproto._lookup_leaf["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,node,flake);
} else {
throw cljs.core.missing_protocol.call(null,"INode.-lookup-leaf",node);
}
}
});
/**
 * Returns the leaf node which contains the given key
 */
fluree.db.dbproto._lookup_leaf = (function fluree$db$dbproto$_lookup_leaf(node,flake){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$INode$_lookup_leaf$arity$2 == null)))))){
return node.fluree$db$dbproto$INode$_lookup_leaf$arity$2(node,flake);
} else {
return fluree$db$dbproto$INode$_lookup_leaf$dyn_13000.call(null,node,flake);
}
});

var fluree$db$dbproto$INode$_lookup_leaf_after$dyn_13001 = (function (node,flake){
var x__4428__auto__ = (((node == null))?null:node);
var m__4429__auto__ = (fluree.db.dbproto._lookup_leaf_after[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,node,flake);
} else {
var m__4426__auto__ = (fluree.db.dbproto._lookup_leaf_after["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,node,flake);
} else {
throw cljs.core.missing_protocol.call(null,"INode.-lookup-leaf-after",node);
}
}
});
/**
 * Returns the leaf node which comes after the given key
 */
fluree.db.dbproto._lookup_leaf_after = (function fluree$db$dbproto$_lookup_leaf_after(node,flake){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$INode$_lookup_leaf_after$arity$2 == null)))))){
return node.fluree$db$dbproto$INode$_lookup_leaf_after$arity$2(node,flake);
} else {
return fluree$db$dbproto$INode$_lookup_leaf_after$dyn_13001.call(null,node,flake);
}
});


/**
 * @interface
 */
fluree.db.dbproto.IFlureeDb = function(){};

var fluree$db$dbproto$IFlureeDb$_latest_db$dyn_13012 = (function (db){
var x__4428__auto__ = (((db == null))?null:db);
var m__4429__auto__ = (fluree.db.dbproto._latest_db[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,db);
} else {
var m__4426__auto__ = (fluree.db.dbproto._latest_db["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,db);
} else {
throw cljs.core.missing_protocol.call(null,"IFlureeDb.-latest-db",db);
}
}
});
/**
 * Updates a db to the most current version of the db known to this server. Maintains existing permissions
 */
fluree.db.dbproto._latest_db = (function fluree$db$dbproto$_latest_db(db){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1(db);
} else {
return fluree$db$dbproto$IFlureeDb$_latest_db$dyn_13012.call(null,db);
}
});

var fluree$db$dbproto$IFlureeDb$_rootdb$dyn_13013 = (function (db){
var x__4428__auto__ = (((db == null))?null:db);
var m__4429__auto__ = (fluree.db.dbproto._rootdb[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,db);
} else {
var m__4426__auto__ = (fluree.db.dbproto._rootdb["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,db);
} else {
throw cljs.core.missing_protocol.call(null,"IFlureeDb.-rootdb",db);
}
}
});
/**
 * Returns root db version of this db.
 */
fluree.db.dbproto._rootdb = (function fluree$db$dbproto$_rootdb(db){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1(db);
} else {
return fluree$db$dbproto$IFlureeDb$_rootdb$dyn_13013.call(null,db);
}
});

var fluree$db$dbproto$IFlureeDb$_forward_time_travel$dyn_13014 = (function() {
var G__13015 = null;
var G__13015__2 = (function (db,flakes){
var x__4428__auto__ = (((db == null))?null:db);
var m__4429__auto__ = (fluree.db.dbproto._forward_time_travel[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,db,flakes);
} else {
var m__4426__auto__ = (fluree.db.dbproto._forward_time_travel["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,db,flakes);
} else {
throw cljs.core.missing_protocol.call(null,"IFlureeDb.-forward-time-travel",db);
}
}
});
var G__13015__3 = (function (db,tt_id,flakes){
var x__4428__auto__ = (((db == null))?null:db);
var m__4429__auto__ = (fluree.db.dbproto._forward_time_travel[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,db,tt_id,flakes);
} else {
var m__4426__auto__ = (fluree.db.dbproto._forward_time_travel["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,db,tt_id,flakes);
} else {
throw cljs.core.missing_protocol.call(null,"IFlureeDb.-forward-time-travel",db);
}
}
});
G__13015 = function(db,tt_id,flakes){
switch(arguments.length){
case 2:
return G__13015__2.call(this,db,tt_id);
case 3:
return G__13015__3.call(this,db,tt_id,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__13015.cljs$core$IFn$_invoke$arity$2 = G__13015__2;
G__13015.cljs$core$IFn$_invoke$arity$3 = G__13015__3;
return G__13015;
})()
;
fluree.db.dbproto._forward_time_travel = (function fluree$db$dbproto$_forward_time_travel(var_args){
var G__13003 = arguments.length;
switch (G__13003) {
case 2:
return fluree.db.dbproto._forward_time_travel.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbproto._forward_time_travel.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbproto._forward_time_travel.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2(db,flakes);
} else {
return fluree$db$dbproto$IFlureeDb$_forward_time_travel$dyn_13014.call(null,db,flakes);
}
}));

(fluree.db.dbproto._forward_time_travel.cljs$core$IFn$_invoke$arity$3 = (function (db,tt_id,flakes){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3(db,tt_id,flakes);
} else {
return fluree$db$dbproto$IFlureeDb$_forward_time_travel$dyn_13014.call(null,db,tt_id,flakes);
}
}));

(fluree.db.dbproto._forward_time_travel.cljs$lang$maxFixedArity = 3);


var fluree$db$dbproto$IFlureeDb$_c_prop$dyn_13017 = (function (db,property,collection){
var x__4428__auto__ = (((db == null))?null:db);
var m__4429__auto__ = (fluree.db.dbproto._c_prop[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,db,property,collection);
} else {
var m__4426__auto__ = (fluree.db.dbproto._c_prop["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,db,property,collection);
} else {
throw cljs.core.missing_protocol.call(null,"IFlureeDb.-c-prop",db);
}
}
});
/**
 * Returns schema property for a collection.
 */
fluree.db.dbproto._c_prop = (function fluree$db$dbproto$_c_prop(db,property,collection){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3(db,property,collection);
} else {
return fluree$db$dbproto$IFlureeDb$_c_prop$dyn_13017.call(null,db,property,collection);
}
});

var fluree$db$dbproto$IFlureeDb$_p_prop$dyn_13018 = (function (db,property,predicate){
var x__4428__auto__ = (((db == null))?null:db);
var m__4429__auto__ = (fluree.db.dbproto._p_prop[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,db,property,predicate);
} else {
var m__4426__auto__ = (fluree.db.dbproto._p_prop["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,db,property,predicate);
} else {
throw cljs.core.missing_protocol.call(null,"IFlureeDb.-p-prop",db);
}
}
});
/**
 * Returns the property specified for the given predicate.
 */
fluree.db.dbproto._p_prop = (function fluree$db$dbproto$_p_prop(db,property,predicate){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3(db,property,predicate);
} else {
return fluree$db$dbproto$IFlureeDb$_p_prop$dyn_13018.call(null,db,property,predicate);
}
});

var fluree$db$dbproto$IFlureeDb$_tag$dyn_13019 = (function() {
var G__13020 = null;
var G__13020__2 = (function (db,tag_id){
var x__4428__auto__ = (((db == null))?null:db);
var m__4429__auto__ = (fluree.db.dbproto._tag[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,db,tag_id);
} else {
var m__4426__auto__ = (fluree.db.dbproto._tag["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,db,tag_id);
} else {
throw cljs.core.missing_protocol.call(null,"IFlureeDb.-tag",db);
}
}
});
var G__13020__3 = (function (db,tag_id,pred){
var x__4428__auto__ = (((db == null))?null:db);
var m__4429__auto__ = (fluree.db.dbproto._tag[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,db,tag_id,pred);
} else {
var m__4426__auto__ = (fluree.db.dbproto._tag["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,db,tag_id,pred);
} else {
throw cljs.core.missing_protocol.call(null,"IFlureeDb.-tag",db);
}
}
});
G__13020 = function(db,tag_id,pred){
switch(arguments.length){
case 2:
return G__13020__2.call(this,db,tag_id);
case 3:
return G__13020__3.call(this,db,tag_id,pred);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__13020.cljs$core$IFn$_invoke$arity$2 = G__13020__2;
G__13020.cljs$core$IFn$_invoke$arity$3 = G__13020__3;
return G__13020;
})()
;
/**
 * Returns resolved tag, shortens namespace if pred provided.
 */
fluree.db.dbproto._tag = (function fluree$db$dbproto$_tag(var_args){
var G__13005 = arguments.length;
switch (G__13005) {
case 2:
return fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$2 = (function (db,tag_id){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_tag$arity$2 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_tag$arity$2(db,tag_id);
} else {
return fluree$db$dbproto$IFlureeDb$_tag$dyn_13019.call(null,db,tag_id);
}
}));

(fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3 = (function (db,tag_id,pred){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_tag$arity$3 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_tag$arity$3(db,tag_id,pred);
} else {
return fluree$db$dbproto$IFlureeDb$_tag$dyn_13019.call(null,db,tag_id,pred);
}
}));

(fluree.db.dbproto._tag.cljs$lang$maxFixedArity = 3);


var fluree$db$dbproto$IFlureeDb$_tag_id$dyn_13022 = (function() {
var G__13023 = null;
var G__13023__2 = (function (db,tag_name){
var x__4428__auto__ = (((db == null))?null:db);
var m__4429__auto__ = (fluree.db.dbproto._tag_id[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,db,tag_name);
} else {
var m__4426__auto__ = (fluree.db.dbproto._tag_id["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,db,tag_name);
} else {
throw cljs.core.missing_protocol.call(null,"IFlureeDb.-tag-id",db);
}
}
});
var G__13023__3 = (function (db,tag_name,pred){
var x__4428__auto__ = (((db == null))?null:db);
var m__4429__auto__ = (fluree.db.dbproto._tag_id[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,db,tag_name,pred);
} else {
var m__4426__auto__ = (fluree.db.dbproto._tag_id["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,db,tag_name,pred);
} else {
throw cljs.core.missing_protocol.call(null,"IFlureeDb.-tag-id",db);
}
}
});
G__13023 = function(db,tag_name,pred){
switch(arguments.length){
case 2:
return G__13023__2.call(this,db,tag_name);
case 3:
return G__13023__3.call(this,db,tag_name,pred);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__13023.cljs$core$IFn$_invoke$arity$2 = G__13023__2;
G__13023.cljs$core$IFn$_invoke$arity$3 = G__13023__3;
return G__13023;
})()
;
/**
 * Returns the tag sid. If pred provided will namespace tag if not already.
 */
fluree.db.dbproto._tag_id = (function fluree$db$dbproto$_tag_id(var_args){
var G__13007 = arguments.length;
switch (G__13007) {
case 2:
return fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2 = (function (db,tag_name){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2(db,tag_name);
} else {
return fluree$db$dbproto$IFlureeDb$_tag_id$dyn_13022.call(null,db,tag_name);
}
}));

(fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$3 = (function (db,tag_name,pred){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3(db,tag_name,pred);
} else {
return fluree$db$dbproto$IFlureeDb$_tag_id$dyn_13022.call(null,db,tag_name,pred);
}
}));

(fluree.db.dbproto._tag_id.cljs$lang$maxFixedArity = 3);


var fluree$db$dbproto$IFlureeDb$_subid$dyn_13025 = (function() {
var G__13026 = null;
var G__13026__2 = (function (db,ident){
var x__4428__auto__ = (((db == null))?null:db);
var m__4429__auto__ = (fluree.db.dbproto._subid[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,db,ident);
} else {
var m__4426__auto__ = (fluree.db.dbproto._subid["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,db,ident);
} else {
throw cljs.core.missing_protocol.call(null,"IFlureeDb.-subid",db);
}
}
});
var G__13026__3 = (function (db,ident,strict_QMARK_){
var x__4428__auto__ = (((db == null))?null:db);
var m__4429__auto__ = (fluree.db.dbproto._subid[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,db,ident,strict_QMARK_);
} else {
var m__4426__auto__ = (fluree.db.dbproto._subid["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,db,ident,strict_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"IFlureeDb.-subid",db);
}
}
});
G__13026 = function(db,ident,strict_QMARK_){
switch(arguments.length){
case 2:
return G__13026__2.call(this,db,ident);
case 3:
return G__13026__3.call(this,db,ident,strict_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__13026.cljs$core$IFn$_invoke$arity$2 = G__13026__2;
G__13026.cljs$core$IFn$_invoke$arity$3 = G__13026__3;
return G__13026;
})()
;
/**
 * Returns subject ID if exists, else nil
 */
fluree.db.dbproto._subid = (function fluree$db$dbproto$_subid(var_args){
var G__13009 = arguments.length;
switch (G__13009) {
case 2:
return fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2 = (function (db,ident){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_subid$arity$2 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_subid$arity$2(db,ident);
} else {
return fluree$db$dbproto$IFlureeDb$_subid$dyn_13025.call(null,db,ident);
}
}));

(fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3 = (function (db,ident,strict_QMARK_){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_subid$arity$3 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_subid$arity$3(db,ident,strict_QMARK_);
} else {
return fluree$db$dbproto$IFlureeDb$_subid$dyn_13025.call(null,db,ident,strict_QMARK_);
}
}));

(fluree.db.dbproto._subid.cljs$lang$maxFixedArity = 3);


var fluree$db$dbproto$IFlureeDb$_search$dyn_13028 = (function (db,fparts){
var x__4428__auto__ = (((db == null))?null:db);
var m__4429__auto__ = (fluree.db.dbproto._search[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,db,fparts);
} else {
var m__4426__auto__ = (fluree.db.dbproto._search["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,db,fparts);
} else {
throw cljs.core.missing_protocol.call(null,"IFlureeDb.-search",db);
}
}
});
/**
 * Performs a slice, but determines best index to use.
 */
fluree.db.dbproto._search = (function fluree$db$dbproto$_search(db,fparts){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_search$arity$2 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_search$arity$2(db,fparts);
} else {
return fluree$db$dbproto$IFlureeDb$_search$dyn_13028.call(null,db,fparts);
}
});

var fluree$db$dbproto$IFlureeDb$_query$dyn_13029 = (function() {
var G__13030 = null;
var G__13030__2 = (function (db,query){
var x__4428__auto__ = (((db == null))?null:db);
var m__4429__auto__ = (fluree.db.dbproto._query[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,db,query);
} else {
var m__4426__auto__ = (fluree.db.dbproto._query["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,db,query);
} else {
throw cljs.core.missing_protocol.call(null,"IFlureeDb.-query",db);
}
}
});
var G__13030__3 = (function (db,query,opts){
var x__4428__auto__ = (((db == null))?null:db);
var m__4429__auto__ = (fluree.db.dbproto._query[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,db,query,opts);
} else {
var m__4426__auto__ = (fluree.db.dbproto._query["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,db,query,opts);
} else {
throw cljs.core.missing_protocol.call(null,"IFlureeDb.-query",db);
}
}
});
G__13030 = function(db,query,opts){
switch(arguments.length){
case 2:
return G__13030__2.call(this,db,query);
case 3:
return G__13030__3.call(this,db,query,opts);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__13030.cljs$core$IFn$_invoke$arity$2 = G__13030__2;
G__13030.cljs$core$IFn$_invoke$arity$3 = G__13030__3;
return G__13030;
})()
;
/**
 * Performs a query.
 */
fluree.db.dbproto._query = (function fluree$db$dbproto$_query(var_args){
var G__13011 = arguments.length;
switch (G__13011) {
case 2:
return fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$2 = (function (db,query){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_query$arity$2 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_query$arity$2(db,query);
} else {
return fluree$db$dbproto$IFlureeDb$_query$dyn_13029.call(null,db,query);
}
}));

(fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$3 = (function (db,query,opts){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_query$arity$3 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_query$arity$3(db,query,opts);
} else {
return fluree$db$dbproto$IFlureeDb$_query$dyn_13029.call(null,db,query,opts);
}
}));

(fluree.db.dbproto._query.cljs$lang$maxFixedArity = 3);


var fluree$db$dbproto$IFlureeDb$_with$dyn_13032 = (function (db,block,flakes){
var x__4428__auto__ = (((db == null))?null:db);
var m__4429__auto__ = (fluree.db.dbproto._with[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,db,block,flakes);
} else {
var m__4426__auto__ = (fluree.db.dbproto._with["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,db,block,flakes);
} else {
throw cljs.core.missing_protocol.call(null,"IFlureeDb.-with",db);
}
}
});
/**
 * Applies flakes to this db as a new block with possibly multiple 't' transactions.
 */
fluree.db.dbproto._with = (function fluree$db$dbproto$_with(db,block,flakes){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_with$arity$3 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_with$arity$3(db,block,flakes);
} else {
return fluree$db$dbproto$IFlureeDb$_with$dyn_13032.call(null,db,block,flakes);
}
});

var fluree$db$dbproto$IFlureeDb$_with_t$dyn_13033 = (function (db,flakes){
var x__4428__auto__ = (((db == null))?null:db);
var m__4429__auto__ = (fluree.db.dbproto._with_t[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,db,flakes);
} else {
var m__4426__auto__ = (fluree.db.dbproto._with_t["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,db,flakes);
} else {
throw cljs.core.missing_protocol.call(null,"IFlureeDb.-with-t",db);
}
}
});
/**
 * Applies flakes to this db as a new 't', but retains current block.
 */
fluree.db.dbproto._with_t = (function fluree$db$dbproto$_with_t(db,flakes){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_with_t$arity$2(db,flakes);
} else {
return fluree$db$dbproto$IFlureeDb$_with_t$dyn_13033.call(null,db,flakes);
}
});

var fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$dyn_13034 = (function (db,pred_id){
var x__4428__auto__ = (((db == null))?null:db);
var m__4429__auto__ = (fluree.db.dbproto._add_predicate_to_idx[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,db,pred_id);
} else {
var m__4426__auto__ = (fluree.db.dbproto._add_predicate_to_idx["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,db,pred_id);
} else {
throw cljs.core.missing_protocol.call(null,"IFlureeDb.-add-predicate-to-idx",db);
}
}
});
/**
 * Adds predicate to idx, return updated db.
 */
fluree.db.dbproto._add_predicate_to_idx = (function fluree$db$dbproto$_add_predicate_to_idx(db,pred_id){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2(db,pred_id);
} else {
return fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$dyn_13034.call(null,db,pred_id);
}
});

fluree.db.dbproto.db_QMARK_ = (function fluree$db$dbproto$db_QMARK_(db){
if((!((db == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === db.fluree$db$dbproto$IFlureeDb$)))){
return true;
} else {
if((!db.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,fluree.db.dbproto.IFlureeDb,db);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,fluree.db.dbproto.IFlureeDb,db);
}
});

//# sourceMappingURL=dbproto.js.map
