// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__4785__auto___53766 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null)))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_53817){
var state_val_53818 = (state_53817[(1)]);
if((state_val_53818 === (7))){
var inst_53812 = (state_53817[(2)]);
var _ = (function (){var statearr_53819 = state_53817;
(statearr_53819[(4)] = cljs.core.rest.call(null,(state_53817[(4)])));

return statearr_53819;
})();
var state_53817__$1 = state_53817;
var statearr_53820_53847 = state_53817__$1;
(statearr_53820_53847[(2)] = inst_53812);

(statearr_53820_53847[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53818 === (1))){
var state_53817__$1 = state_53817;
var statearr_53821_53848 = state_53817__$1;
(statearr_53821_53848[(2)] = null);

(statearr_53821_53848[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53818 === (4))){
var inst_53767 = (state_53817[(2)]);
var state_53817__$1 = state_53817;
var statearr_53822_53849 = state_53817__$1;
(statearr_53822_53849[(2)] = inst_53767);

(statearr_53822_53849[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53818 === (13))){
var inst_53808 = (state_53817[(2)]);
var state_53817__$1 = state_53817;
var statearr_53823_53850 = state_53817__$1;
(statearr_53823_53850[(2)] = inst_53808);

(statearr_53823_53850[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53818 === (6))){
var inst_53792 = (state_53817[(7)]);
var inst_53785 = (state_53817[(8)]);
var inst_53791 = cljs.core.seq.call(null,inst_53785);
var inst_53792__$1 = cljs.core.first.call(null,inst_53791);
var inst_53793 = cljs.core.next.call(null,inst_53791);
var inst_53794 = cljs.core.not.call(null,inst_53792__$1);
var state_53817__$1 = (function (){var statearr_53824 = state_53817;
(statearr_53824[(7)] = inst_53792__$1);

(statearr_53824[(9)] = inst_53793);

return statearr_53824;
})();
if(inst_53794){
var statearr_53825_53851 = state_53817__$1;
(statearr_53825_53851[(1)] = (8));

} else {
var statearr_53826_53852 = state_53817__$1;
(statearr_53826_53852[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53818 === (3))){
var inst_53815 = (state_53817[(2)]);
var state_53817__$1 = state_53817;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53817__$1,inst_53815);
} else {
if((state_val_53818 === (12))){
var inst_53792 = (state_53817[(7)]);
var inst_53786 = (state_53817[(10)]);
var inst_53793 = (state_53817[(9)]);
var inst_53805 = cljs.core.conj.call(null,inst_53786,inst_53792);
var inst_53785 = inst_53793;
var inst_53786__$1 = inst_53805;
var state_53817__$1 = (function (){var statearr_53827 = state_53817;
(statearr_53827[(10)] = inst_53786__$1);

(statearr_53827[(8)] = inst_53785);

return statearr_53827;
})();
var statearr_53828_53853 = state_53817__$1;
(statearr_53828_53853[(2)] = null);

(statearr_53828_53853[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53818 === (2))){
var _ = (function (){var statearr_53829 = state_53817;
(statearr_53829[(4)] = cljs.core.cons.call(null,(5),(state_53817[(4)])));

return statearr_53829;
})();
var inst_53780 = args;
var inst_53781 = cljs.core.seq.call(null,inst_53780);
var inst_53782 = cljs.core.first.call(null,inst_53781);
var inst_53783 = cljs.core.next.call(null,inst_53781);
var inst_53784 = cljs.core.PersistentVector.EMPTY;
var inst_53785 = inst_53780;
var inst_53786 = inst_53784;
var state_53817__$1 = (function (){var statearr_53830 = state_53817;
(statearr_53830[(11)] = inst_53782);

(statearr_53830[(10)] = inst_53786);

(statearr_53830[(8)] = inst_53785);

(statearr_53830[(12)] = inst_53783);

return statearr_53830;
})();
var statearr_53831_53854 = state_53817__$1;
(statearr_53831_53854[(2)] = null);

(statearr_53831_53854[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53818 === (11))){
var inst_53792 = (state_53817[(7)]);
var state_53817__$1 = state_53817;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53817__$1,(14),inst_53792);
} else {
if((state_val_53818 === (9))){
var inst_53792 = (state_53817[(7)]);
var inst_53797 = fluree.db.util.async.channel_QMARK_.call(null,inst_53792);
var state_53817__$1 = state_53817;
if(inst_53797){
var statearr_53833_53855 = state_53817__$1;
(statearr_53833_53855[(1)] = (11));

} else {
var statearr_53834_53856 = state_53817__$1;
(statearr_53834_53856[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53818 === (5))){
var _ = (function (){var statearr_53835 = state_53817;
(statearr_53835[(4)] = cljs.core.rest.call(null,(state_53817[(4)])));

return statearr_53835;
})();
var state_53817__$1 = state_53817;
var ex53832 = (state_53817__$1[(2)]);
var statearr_53836_53857 = state_53817__$1;
(statearr_53836_53857[(5)] = ex53832);


if((ex53832 instanceof Error)){
var statearr_53837_53858 = state_53817__$1;
(statearr_53837_53858[(1)] = (4));

(statearr_53837_53858[(5)] = null);

} else {
throw ex53832;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53818 === (14))){
var inst_53786 = (state_53817[(10)]);
var inst_53793 = (state_53817[(9)]);
var inst_53800 = (state_53817[(2)]);
var inst_53801 = fluree.db.util.async.throw_err.call(null,inst_53800);
var inst_53802 = cljs.core.conj.call(null,inst_53786,inst_53801);
var inst_53785 = inst_53793;
var inst_53786__$1 = inst_53802;
var state_53817__$1 = (function (){var statearr_53838 = state_53817;
(statearr_53838[(10)] = inst_53786__$1);

(statearr_53838[(8)] = inst_53785);

return statearr_53838;
})();
var statearr_53839_53859 = state_53817__$1;
(statearr_53839_53859[(2)] = null);

(statearr_53839_53859[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53818 === (10))){
var inst_53810 = (state_53817[(2)]);
var state_53817__$1 = state_53817;
var statearr_53840_53860 = state_53817__$1;
(statearr_53840_53860[(2)] = inst_53810);

(statearr_53840_53860[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53818 === (8))){
var inst_53786 = (state_53817[(10)]);
var state_53817__$1 = state_53817;
var statearr_53841_53861 = state_53817__$1;
(statearr_53841_53861[(2)] = inst_53786);

(statearr_53841_53861[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2468__auto____0 = (function (){
var statearr_53842 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_53842[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2468__auto__);

(statearr_53842[(1)] = (1));

return statearr_53842;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2468__auto____1 = (function (state_53817){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_53817);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e53843){var ex__2471__auto__ = e53843;
var statearr_53844_53862 = state_53817;
(statearr_53844_53862[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_53817[(4)]))){
var statearr_53845_53863 = state_53817;
(statearr_53845_53863[(1)] = cljs.core.first.call(null,(state_53817[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53864 = state_53817;
state_53817 = G__53864;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2468__auto__ = function(state_53817){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2468__auto____1.call(this,state_53817);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_53846 = f__2491__auto__.call(null);
(statearr_53846[(6)] = c__2490__auto__);

return statearr_53846;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__53865 = entry;
var res = cljs.core.nth.call(null,vec__53865,(0),null);
var cost = cljs.core.nth.call(null,vec__53865,(1),null);
fluree.db.util.log.debug.call(null,"Smart function stack: ",res);

return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (s){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword(null,"stack","stack",-793405930),cljs.core.conj.call(null,new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(s),entry),new cljs.core.Keyword(null,"credits","credits",785860820),fluree.db.dbfunctions.internal._.call(null,new cljs.core.Keyword(null,"credits","credits",785860820).cljs$core$IFn$_invoke$arity$1(s),cost),new cljs.core.Keyword(null,"spent","spent",-62769180),fluree.db.dbfunctions.internal._PLUS_.call(null,new cljs.core.Keyword(null,"spent","spent",-62769180).cljs$core$IFn$_invoke$arity$1(s),cost));
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.call(null,msg,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"stack","stack",-793405930),fluree.db.dbfunctions.fns.stack.call(null,_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_53913){
var state_val_53914 = (state_53913[(1)]);
if((state_val_53914 === (7))){
var state_53913__$1 = state_53913;
var statearr_53915_53944 = state_53913__$1;
(statearr_53915_53944[(2)] = coll);

(statearr_53915_53944[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53914 === (1))){
var state_53913__$1 = state_53913;
var statearr_53916_53945 = state_53913__$1;
(statearr_53916_53945[(2)] = null);

(statearr_53916_53945[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53914 === (4))){
var inst_53868 = (state_53913[(2)]);
var state_53913__$1 = state_53913;
var statearr_53917_53946 = state_53913__$1;
(statearr_53917_53946[(2)] = inst_53868);

(statearr_53917_53946[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53914 === (15))){
var inst_53887 = (state_53913[(7)]);
var inst_53895 = (state_53913[(2)]);
var inst_53896 = fluree.db.dbfunctions.internal.nth.call(null,inst_53887,inst_53895);
var inst_53897 = cljs.core.count.call(null,inst_53887);
var inst_53898 = ((9) + inst_53897);
var inst_53899 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53900 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53901 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53902 = [inst_53887,inst_53895];
var inst_53903 = (new cljs.core.PersistentVector(null,2,(5),inst_53901,inst_53902,null));
var inst_53904 = ["nth",inst_53903,inst_53896];
var inst_53905 = cljs.core.PersistentHashMap.fromArrays(inst_53900,inst_53904);
var inst_53906 = [inst_53905,inst_53898];
var inst_53907 = (new cljs.core.PersistentVector(null,2,(5),inst_53899,inst_53906,null));
var inst_53908 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53907);
var _ = (function (){var statearr_53918 = state_53913;
(statearr_53918[(4)] = cljs.core.rest.call(null,(state_53913[(4)])));

return statearr_53918;
})();
var state_53913__$1 = (function (){var statearr_53919 = state_53913;
(statearr_53919[(8)] = inst_53908);

return statearr_53919;
})();
var statearr_53920_53947 = state_53913__$1;
(statearr_53920_53947[(2)] = inst_53896);

(statearr_53920_53947[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53914 === (13))){
var state_53913__$1 = state_53913;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53913__$1,(16),key);
} else {
if((state_val_53914 === (6))){
var state_53913__$1 = state_53913;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53913__$1,(9),coll);
} else {
if((state_val_53914 === (3))){
var inst_53911 = (state_53913[(2)]);
var state_53913__$1 = state_53913;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53913__$1,inst_53911);
} else {
if((state_val_53914 === (12))){
var inst_53887 = (state_53913[(2)]);
var inst_53888 = fluree.db.util.async.channel_QMARK_.call(null,key);
var state_53913__$1 = (function (){var statearr_53921 = state_53913;
(statearr_53921[(7)] = inst_53887);

return statearr_53921;
})();
if(inst_53888){
var statearr_53922_53948 = state_53913__$1;
(statearr_53922_53948[(1)] = (13));

} else {
var statearr_53923_53949 = state_53913__$1;
(statearr_53923_53949[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53914 === (2))){
var _ = (function (){var statearr_53924 = state_53913;
(statearr_53924[(4)] = cljs.core.cons.call(null,(5),(state_53913[(4)])));

return statearr_53924;
})();
var inst_53874 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_53913__$1 = state_53913;
if(inst_53874){
var statearr_53925_53950 = state_53913__$1;
(statearr_53925_53950[(1)] = (6));

} else {
var statearr_53926_53951 = state_53913__$1;
(statearr_53926_53951[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53914 === (11))){
var inst_53881 = (state_53913[(9)]);
var state_53913__$1 = state_53913;
var statearr_53928_53952 = state_53913__$1;
(statearr_53928_53952[(2)] = inst_53881);

(statearr_53928_53952[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53914 === (9))){
var inst_53877 = (state_53913[(2)]);
var inst_53878 = fluree.db.util.async.throw_err.call(null,inst_53877);
var state_53913__$1 = state_53913;
var statearr_53929_53953 = state_53913__$1;
(statearr_53929_53953[(2)] = inst_53878);

(statearr_53929_53953[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53914 === (5))){
var _ = (function (){var statearr_53930 = state_53913;
(statearr_53930[(4)] = cljs.core.rest.call(null,(state_53913[(4)])));

return statearr_53930;
})();
var state_53913__$1 = state_53913;
var ex53927 = (state_53913__$1[(2)]);
var statearr_53931_53954 = state_53913__$1;
(statearr_53931_53954[(5)] = ex53927);


if((ex53927 instanceof Error)){
var statearr_53932_53955 = state_53913__$1;
(statearr_53932_53955[(1)] = (4));

(statearr_53932_53955[(5)] = null);

} else {
throw ex53927;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53914 === (14))){
var state_53913__$1 = state_53913;
var statearr_53933_53956 = state_53913__$1;
(statearr_53933_53956[(2)] = key);

(statearr_53933_53956[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53914 === (16))){
var inst_53891 = (state_53913[(2)]);
var inst_53892 = fluree.db.util.async.throw_err.call(null,inst_53891);
var state_53913__$1 = state_53913;
var statearr_53934_53957 = state_53913__$1;
(statearr_53934_53957[(2)] = inst_53892);

(statearr_53934_53957[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53914 === (10))){
var inst_53881 = (state_53913[(9)]);
var inst_53884 = cljs.core.vec.call(null,inst_53881);
var state_53913__$1 = state_53913;
var statearr_53935_53958 = state_53913__$1;
(statearr_53935_53958[(2)] = inst_53884);

(statearr_53935_53958[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53914 === (8))){
var inst_53881 = (state_53913[(9)]);
var inst_53881__$1 = (state_53913[(2)]);
var inst_53882 = cljs.core.set_QMARK_.call(null,inst_53881__$1);
var state_53913__$1 = (function (){var statearr_53936 = state_53913;
(statearr_53936[(9)] = inst_53881__$1);

return statearr_53936;
})();
if(inst_53882){
var statearr_53937_53959 = state_53913__$1;
(statearr_53937_53959[(1)] = (10));

} else {
var statearr_53938_53960 = state_53913__$1;
(statearr_53938_53960[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__2468__auto____0 = (function (){
var statearr_53939 = [null,null,null,null,null,null,null,null,null,null];
(statearr_53939[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__2468__auto__);

(statearr_53939[(1)] = (1));

return statearr_53939;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__2468__auto____1 = (function (state_53913){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_53913);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e53940){var ex__2471__auto__ = e53940;
var statearr_53941_53961 = state_53913;
(statearr_53941_53961[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_53913[(4)]))){
var statearr_53942_53962 = state_53913;
(statearr_53942_53962[(1)] = cljs.core.first.call(null,(state_53913[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53963 = state_53913;
state_53913 = G__53963;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__2468__auto__ = function(state_53913){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2468__auto____1.call(this,state_53913);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_53943 = f__2491__auto__.call(null);
(statearr_53943[(6)] = c__2490__auto__);

return statearr_53943;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_54024){
var state_val_54025 = (state_54024[(1)]);
if((state_val_54025 === (7))){
var state_54024__$1 = state_54024;
var statearr_54026_54060 = state_54024__$1;
(statearr_54026_54060[(2)] = test);

(statearr_54026_54060[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54025 === (20))){
var inst_53998 = (state_54024[(2)]);
var inst_53999 = fluree.db.util.async.throw_err.call(null,inst_53998);
var state_54024__$1 = state_54024;
var statearr_54027_54061 = state_54024__$1;
(statearr_54027_54061[(2)] = inst_53999);

(statearr_54027_54061[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54025 === (1))){
var state_54024__$1 = state_54024;
var statearr_54028_54062 = state_54024__$1;
(statearr_54028_54062[(2)] = null);

(statearr_54028_54062[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54025 === (4))){
var inst_53964 = (state_54024[(2)]);
var state_54024__$1 = state_54024;
var statearr_54029_54063 = state_54024__$1;
(statearr_54029_54063[(2)] = inst_53964);

(statearr_54029_54063[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54025 === (15))){
var inst_53982 = (state_54024[(7)]);
var inst_53990 = (state_54024[(2)]);
var inst_53991 = [inst_53990,f];
var inst_53992 = (new cljs.core.PersistentVector(null,2,(5),inst_53982,inst_53991,null));
var state_54024__$1 = state_54024;
var statearr_54030_54064 = state_54024__$1;
(statearr_54030_54064[(2)] = inst_53992);

(statearr_54030_54064[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54025 === (13))){
var state_54024__$1 = state_54024;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54024__$1,(16),t);
} else {
if((state_val_54025 === (6))){
var state_54024__$1 = state_54024;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54024__$1,(9),test);
} else {
if((state_val_54025 === (17))){
var state_54024__$1 = state_54024;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54024__$1,(20),f);
} else {
if((state_val_54025 === (3))){
var inst_54022 = (state_54024[(2)]);
var state_54024__$1 = state_54024;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54024__$1,inst_54022);
} else {
if((state_val_54025 === (12))){
var inst_53980 = (state_54024[(8)]);
var inst_54006 = (state_54024[(2)]);
var inst_54007 = cljs.core.nth.call(null,inst_54006,(0),null);
var inst_54008 = cljs.core.nth.call(null,inst_54006,(1),null);
var inst_54009 = fluree.db.dbfunctions.internal.if_else.call(null,inst_53980,inst_54007,inst_54008);
var inst_54010 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54011 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54012 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54013 = [inst_53980,inst_54007,inst_54008];
var inst_54014 = (new cljs.core.PersistentVector(null,3,(5),inst_54012,inst_54013,null));
var inst_54015 = ["if-else",inst_54014,inst_54009];
var inst_54016 = cljs.core.PersistentHashMap.fromArrays(inst_54011,inst_54015);
var inst_54017 = [inst_54016,(10)];
var inst_54018 = (new cljs.core.PersistentVector(null,2,(5),inst_54010,inst_54017,null));
var inst_54019 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54018);
var _ = (function (){var statearr_54031 = state_54024;
(statearr_54031[(4)] = cljs.core.rest.call(null,(state_54024[(4)])));

return statearr_54031;
})();
var state_54024__$1 = (function (){var statearr_54032 = state_54024;
(statearr_54032[(9)] = inst_54019);

return statearr_54032;
})();
var statearr_54033_54065 = state_54024__$1;
(statearr_54033_54065[(2)] = inst_54009);

(statearr_54033_54065[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54025 === (2))){
var _ = (function (){var statearr_54034 = state_54024;
(statearr_54034[(4)] = cljs.core.cons.call(null,(5),(state_54024[(4)])));

return statearr_54034;
})();
var inst_53973 = fluree.db.util.async.channel_QMARK_.call(null,test);
var state_54024__$1 = state_54024;
if(inst_53973){
var statearr_54035_54066 = state_54024__$1;
(statearr_54035_54066[(1)] = (6));

} else {
var statearr_54036_54067 = state_54024__$1;
(statearr_54036_54067[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54025 === (19))){
var inst_53994 = (state_54024[(10)]);
var inst_54002 = (state_54024[(2)]);
var inst_54003 = [f,inst_54002];
var inst_54004 = (new cljs.core.PersistentVector(null,2,(5),inst_53994,inst_54003,null));
var state_54024__$1 = state_54024;
var statearr_54037_54068 = state_54024__$1;
(statearr_54037_54068[(2)] = inst_54004);

(statearr_54037_54068[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54025 === (11))){
var inst_53994 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53995 = fluree.db.util.async.channel_QMARK_.call(null,f);
var state_54024__$1 = (function (){var statearr_54039 = state_54024;
(statearr_54039[(10)] = inst_53994);

return statearr_54039;
})();
if(inst_53995){
var statearr_54040_54069 = state_54024__$1;
(statearr_54040_54069[(1)] = (17));

} else {
var statearr_54041_54070 = state_54024__$1;
(statearr_54041_54070[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54025 === (9))){
var inst_53976 = (state_54024[(2)]);
var inst_53977 = fluree.db.util.async.throw_err.call(null,inst_53976);
var state_54024__$1 = state_54024;
var statearr_54042_54071 = state_54024__$1;
(statearr_54042_54071[(2)] = inst_53977);

(statearr_54042_54071[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54025 === (5))){
var _ = (function (){var statearr_54043 = state_54024;
(statearr_54043[(4)] = cljs.core.rest.call(null,(state_54024[(4)])));

return statearr_54043;
})();
var state_54024__$1 = state_54024;
var ex54038 = (state_54024__$1[(2)]);
var statearr_54044_54072 = state_54024__$1;
(statearr_54044_54072[(5)] = ex54038);


if((ex54038 instanceof Error)){
var statearr_54045_54073 = state_54024__$1;
(statearr_54045_54073[(1)] = (4));

(statearr_54045_54073[(5)] = null);

} else {
throw ex54038;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54025 === (14))){
var state_54024__$1 = state_54024;
var statearr_54046_54074 = state_54024__$1;
(statearr_54046_54074[(2)] = t);

(statearr_54046_54074[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54025 === (16))){
var inst_53986 = (state_54024[(2)]);
var inst_53987 = fluree.db.util.async.throw_err.call(null,inst_53986);
var state_54024__$1 = state_54024;
var statearr_54047_54075 = state_54024__$1;
(statearr_54047_54075[(2)] = inst_53987);

(statearr_54047_54075[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54025 === (10))){
var inst_53982 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53983 = fluree.db.util.async.channel_QMARK_.call(null,t);
var state_54024__$1 = (function (){var statearr_54048 = state_54024;
(statearr_54048[(7)] = inst_53982);

return statearr_54048;
})();
if(inst_53983){
var statearr_54049_54076 = state_54024__$1;
(statearr_54049_54076[(1)] = (13));

} else {
var statearr_54050_54077 = state_54024__$1;
(statearr_54050_54077[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54025 === (18))){
var state_54024__$1 = state_54024;
var statearr_54051_54078 = state_54024__$1;
(statearr_54051_54078[(2)] = f);

(statearr_54051_54078[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54025 === (8))){
var inst_53980 = (state_54024[(8)]);
var inst_53980__$1 = (state_54024[(2)]);
var state_54024__$1 = (function (){var statearr_54052 = state_54024;
(statearr_54052[(8)] = inst_53980__$1);

return statearr_54052;
})();
if(cljs.core.truth_(inst_53980__$1)){
var statearr_54053_54079 = state_54024__$1;
(statearr_54053_54079[(1)] = (10));

} else {
var statearr_54054_54080 = state_54024__$1;
(statearr_54054_54080[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2468__auto____0 = (function (){
var statearr_54055 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_54055[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__2468__auto__);

(statearr_54055[(1)] = (1));

return statearr_54055;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2468__auto____1 = (function (state_54024){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_54024);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e54056){var ex__2471__auto__ = e54056;
var statearr_54057_54081 = state_54024;
(statearr_54057_54081[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_54024[(4)]))){
var statearr_54058_54082 = state_54024;
(statearr_54058_54082[(1)] = cljs.core.first.call(null,(state_54024[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54083 = state_54024;
state_54024 = G__54083;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__2468__auto__ = function(state_54024){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2468__auto____1.call(this,state_54024);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_54059 = f__2491__auto__.call(null);
(statearr_54059[(6)] = c__2490__auto__);

return statearr_54059;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_54113){
var state_val_54114 = (state_54113[(1)]);
if((state_val_54114 === (7))){
var state_54113__$1 = state_54113;
var statearr_54115_54134 = state_54113__$1;
(statearr_54115_54134[(2)] = arg);

(statearr_54115_54134[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54114 === (1))){
var state_54113__$1 = state_54113;
var statearr_54116_54135 = state_54113__$1;
(statearr_54116_54135[(2)] = null);

(statearr_54116_54135[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54114 === (4))){
var inst_54084 = (state_54113[(2)]);
var state_54113__$1 = state_54113;
var statearr_54117_54136 = state_54113__$1;
(statearr_54117_54136[(2)] = inst_54084);

(statearr_54117_54136[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54114 === (6))){
var state_54113__$1 = state_54113;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54113__$1,(9),arg);
} else {
if((state_val_54114 === (3))){
var inst_54111 = (state_54113[(2)]);
var state_54113__$1 = state_54113;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54113__$1,inst_54111);
} else {
if((state_val_54114 === (2))){
var _ = (function (){var statearr_54119 = state_54113;
(statearr_54119[(4)] = cljs.core.cons.call(null,(5),(state_54113[(4)])));

return statearr_54119;
})();
var inst_54090 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_54113__$1 = state_54113;
if(inst_54090){
var statearr_54120_54137 = state_54113__$1;
(statearr_54120_54137[(1)] = (6));

} else {
var statearr_54121_54138 = state_54113__$1;
(statearr_54121_54138[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54114 === (9))){
var inst_54093 = (state_54113[(2)]);
var inst_54094 = fluree.db.util.async.throw_err.call(null,inst_54093);
var state_54113__$1 = state_54113;
var statearr_54122_54139 = state_54113__$1;
(statearr_54122_54139[(2)] = inst_54094);

(statearr_54122_54139[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54114 === (5))){
var _ = (function (){var statearr_54123 = state_54113;
(statearr_54123[(4)] = cljs.core.rest.call(null,(state_54113[(4)])));

return statearr_54123;
})();
var state_54113__$1 = state_54113;
var ex54118 = (state_54113__$1[(2)]);
var statearr_54124_54140 = state_54113__$1;
(statearr_54124_54140[(5)] = ex54118);


if((ex54118 instanceof Error)){
var statearr_54125_54141 = state_54113__$1;
(statearr_54125_54141[(1)] = (4));

(statearr_54125_54141[(5)] = null);

} else {
throw ex54118;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54114 === (8))){
var inst_54097 = (state_54113[(2)]);
var inst_54098 = fluree.db.dbfunctions.internal.nil_QMARK_.call(null,inst_54097);
var inst_54099 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54100 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54101 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54102 = [inst_54097];
var inst_54103 = (new cljs.core.PersistentVector(null,1,(5),inst_54101,inst_54102,null));
var inst_54104 = ["nil?",inst_54103,inst_54098];
var inst_54105 = cljs.core.PersistentHashMap.fromArrays(inst_54100,inst_54104);
var inst_54106 = [inst_54105,(10)];
var inst_54107 = (new cljs.core.PersistentVector(null,2,(5),inst_54099,inst_54106,null));
var inst_54108 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54107);
var _ = (function (){var statearr_54126 = state_54113;
(statearr_54126[(4)] = cljs.core.rest.call(null,(state_54113[(4)])));

return statearr_54126;
})();
var state_54113__$1 = (function (){var statearr_54127 = state_54113;
(statearr_54127[(7)] = inst_54108);

return statearr_54127;
})();
var statearr_54128_54142 = state_54113__$1;
(statearr_54128_54142[(2)] = inst_54098);

(statearr_54128_54142[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2468__auto____0 = (function (){
var statearr_54129 = [null,null,null,null,null,null,null,null];
(statearr_54129[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2468__auto__);

(statearr_54129[(1)] = (1));

return statearr_54129;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2468__auto____1 = (function (state_54113){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_54113);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e54130){var ex__2471__auto__ = e54130;
var statearr_54131_54143 = state_54113;
(statearr_54131_54143[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_54113[(4)]))){
var statearr_54132_54144 = state_54113;
(statearr_54132_54144[(1)] = cljs.core.first.call(null,(state_54113[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54145 = state_54113;
state_54113 = G__54145;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2468__auto__ = function(state_54113){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2468__auto____1.call(this,state_54113);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_54133 = f__2491__auto__.call(null);
(statearr_54133[(6)] = c__2490__auto__);

return statearr_54133;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_54175){
var state_val_54176 = (state_54175[(1)]);
if((state_val_54176 === (7))){
var state_54175__$1 = state_54175;
var statearr_54177_54196 = state_54175__$1;
(statearr_54177_54196[(2)] = arg);

(statearr_54177_54196[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54176 === (1))){
var state_54175__$1 = state_54175;
var statearr_54178_54197 = state_54175__$1;
(statearr_54178_54197[(2)] = null);

(statearr_54178_54197[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54176 === (4))){
var inst_54146 = (state_54175[(2)]);
var state_54175__$1 = state_54175;
var statearr_54179_54198 = state_54175__$1;
(statearr_54179_54198[(2)] = inst_54146);

(statearr_54179_54198[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54176 === (6))){
var state_54175__$1 = state_54175;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54175__$1,(9),arg);
} else {
if((state_val_54176 === (3))){
var inst_54173 = (state_54175[(2)]);
var state_54175__$1 = state_54175;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54175__$1,inst_54173);
} else {
if((state_val_54176 === (2))){
var _ = (function (){var statearr_54181 = state_54175;
(statearr_54181[(4)] = cljs.core.cons.call(null,(5),(state_54175[(4)])));

return statearr_54181;
})();
var inst_54152 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_54175__$1 = state_54175;
if(inst_54152){
var statearr_54182_54199 = state_54175__$1;
(statearr_54182_54199[(1)] = (6));

} else {
var statearr_54183_54200 = state_54175__$1;
(statearr_54183_54200[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54176 === (9))){
var inst_54155 = (state_54175[(2)]);
var inst_54156 = fluree.db.util.async.throw_err.call(null,inst_54155);
var state_54175__$1 = state_54175;
var statearr_54184_54201 = state_54175__$1;
(statearr_54184_54201[(2)] = inst_54156);

(statearr_54184_54201[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54176 === (5))){
var _ = (function (){var statearr_54185 = state_54175;
(statearr_54185[(4)] = cljs.core.rest.call(null,(state_54175[(4)])));

return statearr_54185;
})();
var state_54175__$1 = state_54175;
var ex54180 = (state_54175__$1[(2)]);
var statearr_54186_54202 = state_54175__$1;
(statearr_54186_54202[(5)] = ex54180);


if((ex54180 instanceof Error)){
var statearr_54187_54203 = state_54175__$1;
(statearr_54187_54203[(1)] = (4));

(statearr_54187_54203[(5)] = null);

} else {
throw ex54180;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54176 === (8))){
var inst_54159 = (state_54175[(2)]);
var inst_54160 = fluree.db.dbfunctions.internal.not.call(null,inst_54159);
var inst_54161 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54162 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54163 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54164 = [inst_54159];
var inst_54165 = (new cljs.core.PersistentVector(null,1,(5),inst_54163,inst_54164,null));
var inst_54166 = ["not?",inst_54165,inst_54160];
var inst_54167 = cljs.core.PersistentHashMap.fromArrays(inst_54162,inst_54166);
var inst_54168 = [inst_54167,(10)];
var inst_54169 = (new cljs.core.PersistentVector(null,2,(5),inst_54161,inst_54168,null));
var inst_54170 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54169);
var _ = (function (){var statearr_54188 = state_54175;
(statearr_54188[(4)] = cljs.core.rest.call(null,(state_54175[(4)])));

return statearr_54188;
})();
var state_54175__$1 = (function (){var statearr_54189 = state_54175;
(statearr_54189[(7)] = inst_54170);

return statearr_54189;
})();
var statearr_54190_54204 = state_54175__$1;
(statearr_54190_54204[(2)] = inst_54160);

(statearr_54190_54204[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__2468__auto____0 = (function (){
var statearr_54191 = [null,null,null,null,null,null,null,null];
(statearr_54191[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__2468__auto__);

(statearr_54191[(1)] = (1));

return statearr_54191;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__2468__auto____1 = (function (state_54175){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_54175);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e54192){var ex__2471__auto__ = e54192;
var statearr_54193_54205 = state_54175;
(statearr_54193_54205[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_54175[(4)]))){
var statearr_54194_54206 = state_54175;
(statearr_54194_54206[(1)] = cljs.core.first.call(null,(state_54175[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54207 = state_54175;
state_54175 = G__54207;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__2468__auto__ = function(state_54175){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__2468__auto____1.call(this,state_54175);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_54195 = f__2491__auto__.call(null);
(statearr_54195[(6)] = c__2490__auto__);

return statearr_54195;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_54237){
var state_val_54238 = (state_54237[(1)]);
if((state_val_54238 === (7))){
var state_54237__$1 = state_54237;
var statearr_54239_54258 = state_54237__$1;
(statearr_54239_54258[(2)] = arg);

(statearr_54239_54258[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54238 === (1))){
var state_54237__$1 = state_54237;
var statearr_54240_54259 = state_54237__$1;
(statearr_54240_54259[(2)] = null);

(statearr_54240_54259[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54238 === (4))){
var inst_54208 = (state_54237[(2)]);
var state_54237__$1 = state_54237;
var statearr_54241_54260 = state_54237__$1;
(statearr_54241_54260[(2)] = inst_54208);

(statearr_54241_54260[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54238 === (6))){
var state_54237__$1 = state_54237;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54237__$1,(9),arg);
} else {
if((state_val_54238 === (3))){
var inst_54235 = (state_54237[(2)]);
var state_54237__$1 = state_54237;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54237__$1,inst_54235);
} else {
if((state_val_54238 === (2))){
var _ = (function (){var statearr_54243 = state_54237;
(statearr_54243[(4)] = cljs.core.cons.call(null,(5),(state_54237[(4)])));

return statearr_54243;
})();
var inst_54214 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_54237__$1 = state_54237;
if(inst_54214){
var statearr_54244_54261 = state_54237__$1;
(statearr_54244_54261[(1)] = (6));

} else {
var statearr_54245_54262 = state_54237__$1;
(statearr_54245_54262[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54238 === (9))){
var inst_54217 = (state_54237[(2)]);
var inst_54218 = fluree.db.util.async.throw_err.call(null,inst_54217);
var state_54237__$1 = state_54237;
var statearr_54246_54263 = state_54237__$1;
(statearr_54246_54263[(2)] = inst_54218);

(statearr_54246_54263[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54238 === (5))){
var _ = (function (){var statearr_54247 = state_54237;
(statearr_54247[(4)] = cljs.core.rest.call(null,(state_54237[(4)])));

return statearr_54247;
})();
var state_54237__$1 = state_54237;
var ex54242 = (state_54237__$1[(2)]);
var statearr_54248_54264 = state_54237__$1;
(statearr_54248_54264[(5)] = ex54242);


if((ex54242 instanceof Error)){
var statearr_54249_54265 = state_54237__$1;
(statearr_54249_54265[(1)] = (4));

(statearr_54249_54265[(5)] = null);

} else {
throw ex54242;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54238 === (8))){
var inst_54221 = (state_54237[(2)]);
var inst_54222 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,inst_54221);
var inst_54223 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54224 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54225 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54226 = [inst_54221];
var inst_54227 = (new cljs.core.PersistentVector(null,1,(5),inst_54225,inst_54226,null));
var inst_54228 = ["empty?",inst_54227,inst_54222];
var inst_54229 = cljs.core.PersistentHashMap.fromArrays(inst_54224,inst_54228);
var inst_54230 = [inst_54229,(10)];
var inst_54231 = (new cljs.core.PersistentVector(null,2,(5),inst_54223,inst_54230,null));
var inst_54232 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54231);
var _ = (function (){var statearr_54250 = state_54237;
(statearr_54250[(4)] = cljs.core.rest.call(null,(state_54237[(4)])));

return statearr_54250;
})();
var state_54237__$1 = (function (){var statearr_54251 = state_54237;
(statearr_54251[(7)] = inst_54232);

return statearr_54251;
})();
var statearr_54252_54266 = state_54237__$1;
(statearr_54252_54266[(2)] = inst_54222);

(statearr_54252_54266[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2468__auto____0 = (function (){
var statearr_54253 = [null,null,null,null,null,null,null,null];
(statearr_54253[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2468__auto__);

(statearr_54253[(1)] = (1));

return statearr_54253;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2468__auto____1 = (function (state_54237){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_54237);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e54254){var ex__2471__auto__ = e54254;
var statearr_54255_54267 = state_54237;
(statearr_54255_54267[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_54237[(4)]))){
var statearr_54256_54268 = state_54237;
(statearr_54256_54268[(1)] = cljs.core.first.call(null,(state_54237[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54269 = state_54237;
state_54237 = G__54269;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2468__auto__ = function(state_54237){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2468__auto____1.call(this,state_54237);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_54257 = f__2491__auto__.call(null);
(statearr_54257[(6)] = c__2490__auto__);

return statearr_54257;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__4742__auto__ = [];
var len__4736__auto___54314 = arguments.length;
var i__4737__auto___54315 = (0);
while(true){
if((i__4737__auto___54315 < len__4736__auto___54314)){
args__4742__auto__.push((arguments[i__4737__auto___54315]));

var G__54316 = (i__4737__auto___54315 + (1));
i__4737__auto___54315 = G__54316;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_54297){
var state_val_54298 = (state_54297[(1)]);
if((state_val_54298 === (1))){
var state_54297__$1 = state_54297;
var statearr_54299_54317 = state_54297__$1;
(statearr_54299_54317[(2)] = null);

(statearr_54299_54317[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54298 === (2))){
var _ = (function (){var statearr_54300 = state_54297;
(statearr_54300[(4)] = cljs.core.cons.call(null,(5),(state_54297[(4)])));

return statearr_54300;
})();
var inst_54278 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54297__$1 = state_54297;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54297__$1,(6),inst_54278);
} else {
if((state_val_54298 === (3))){
var inst_54295 = (state_54297[(2)]);
var state_54297__$1 = state_54297;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54297__$1,inst_54295);
} else {
if((state_val_54298 === (4))){
var inst_54272 = (state_54297[(2)]);
var state_54297__$1 = state_54297;
var statearr_54302_54318 = state_54297__$1;
(statearr_54302_54318[(2)] = inst_54272);

(statearr_54302_54318[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54298 === (5))){
var _ = (function (){var statearr_54303 = state_54297;
(statearr_54303[(4)] = cljs.core.rest.call(null,(state_54297[(4)])));

return statearr_54303;
})();
var state_54297__$1 = state_54297;
var ex54301 = (state_54297__$1[(2)]);
var statearr_54304_54319 = state_54297__$1;
(statearr_54304_54319[(5)] = ex54301);


if((ex54301 instanceof Error)){
var statearr_54305_54320 = state_54297__$1;
(statearr_54305_54320[(1)] = (4));

(statearr_54305_54320[(5)] = null);

} else {
throw ex54301;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54298 === (6))){
var inst_54280 = (state_54297[(2)]);
var inst_54281 = fluree.db.util.async.throw_err.call(null,inst_54280);
var inst_54282 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.str,inst_54281);
var inst_54283 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54284 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54285 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54286 = [inst_54281];
var inst_54287 = (new cljs.core.PersistentVector(null,1,(5),inst_54285,inst_54286,null));
var inst_54288 = ["str",inst_54287,inst_54282];
var inst_54289 = cljs.core.PersistentHashMap.fromArrays(inst_54284,inst_54288);
var inst_54290 = [inst_54289,(10)];
var inst_54291 = (new cljs.core.PersistentVector(null,2,(5),inst_54283,inst_54290,null));
var inst_54292 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54291);
var _ = (function (){var statearr_54306 = state_54297;
(statearr_54306[(4)] = cljs.core.rest.call(null,(state_54297[(4)])));

return statearr_54306;
})();
var state_54297__$1 = (function (){var statearr_54307 = state_54297;
(statearr_54307[(7)] = inst_54292);

return statearr_54307;
})();
var statearr_54308_54321 = state_54297__$1;
(statearr_54308_54321[(2)] = inst_54282);

(statearr_54308_54321[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2468__auto____0 = (function (){
var statearr_54309 = [null,null,null,null,null,null,null,null];
(statearr_54309[(0)] = fluree$db$dbfunctions$fns$state_machine__2468__auto__);

(statearr_54309[(1)] = (1));

return statearr_54309;
});
var fluree$db$dbfunctions$fns$state_machine__2468__auto____1 = (function (state_54297){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_54297);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e54310){var ex__2471__auto__ = e54310;
var statearr_54311_54322 = state_54297;
(statearr_54311_54322[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_54297[(4)]))){
var statearr_54312_54323 = state_54297;
(statearr_54312_54323[(1)] = cljs.core.first.call(null,(state_54297[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54324 = state_54297;
state_54297 = G__54324;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2468__auto__ = function(state_54297){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2468__auto____1.call(this,state_54297);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_54313 = f__2491__auto__.call(null);
(statearr_54313[(6)] = c__2490__auto__);

return statearr_54313;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq54270){
var G__54271 = cljs.core.first.call(null,seq54270);
var seq54270__$1 = cljs.core.next.call(null,seq54270);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54271,seq54270__$1);
}));

/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_54354){
var state_val_54355 = (state_54354[(1)]);
if((state_val_54355 === (7))){
var state_54354__$1 = state_54354;
var statearr_54356_54375 = state_54354__$1;
(statearr_54356_54375[(2)] = str);

(statearr_54356_54375[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54355 === (1))){
var state_54354__$1 = state_54354;
var statearr_54357_54376 = state_54354__$1;
(statearr_54357_54376[(2)] = null);

(statearr_54357_54376[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54355 === (4))){
var inst_54325 = (state_54354[(2)]);
var state_54354__$1 = state_54354;
var statearr_54358_54377 = state_54354__$1;
(statearr_54358_54377[(2)] = inst_54325);

(statearr_54358_54377[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54355 === (6))){
var state_54354__$1 = state_54354;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54354__$1,(9),str);
} else {
if((state_val_54355 === (3))){
var inst_54352 = (state_54354[(2)]);
var state_54354__$1 = state_54354;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54354__$1,inst_54352);
} else {
if((state_val_54355 === (2))){
var _ = (function (){var statearr_54360 = state_54354;
(statearr_54360[(4)] = cljs.core.cons.call(null,(5),(state_54354[(4)])));

return statearr_54360;
})();
var inst_54331 = fluree.db.util.async.channel_QMARK_.call(null,str);
var state_54354__$1 = state_54354;
if(inst_54331){
var statearr_54361_54378 = state_54354__$1;
(statearr_54361_54378[(1)] = (6));

} else {
var statearr_54362_54379 = state_54354__$1;
(statearr_54362_54379[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54355 === (9))){
var inst_54334 = (state_54354[(2)]);
var inst_54335 = fluree.db.util.async.throw_err.call(null,inst_54334);
var state_54354__$1 = state_54354;
var statearr_54363_54380 = state_54354__$1;
(statearr_54363_54380[(2)] = inst_54335);

(statearr_54363_54380[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54355 === (5))){
var _ = (function (){var statearr_54364 = state_54354;
(statearr_54364[(4)] = cljs.core.rest.call(null,(state_54354[(4)])));

return statearr_54364;
})();
var state_54354__$1 = state_54354;
var ex54359 = (state_54354__$1[(2)]);
var statearr_54365_54381 = state_54354__$1;
(statearr_54365_54381[(5)] = ex54359);


if((ex54359 instanceof Error)){
var statearr_54366_54382 = state_54354__$1;
(statearr_54366_54382[(1)] = (4));

(statearr_54366_54382[(5)] = null);

} else {
throw ex54359;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54355 === (8))){
var inst_54338 = (state_54354[(2)]);
var inst_54339 = fluree.db.dbfunctions.internal.lower_case.call(null,inst_54338);
var inst_54340 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54341 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54342 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54343 = [inst_54338];
var inst_54344 = (new cljs.core.PersistentVector(null,1,(5),inst_54342,inst_54343,null));
var inst_54345 = ["lower-case",inst_54344,inst_54339];
var inst_54346 = cljs.core.PersistentHashMap.fromArrays(inst_54341,inst_54345);
var inst_54347 = [inst_54346,(10)];
var inst_54348 = (new cljs.core.PersistentVector(null,2,(5),inst_54340,inst_54347,null));
var inst_54349 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54348);
var _ = (function (){var statearr_54367 = state_54354;
(statearr_54367[(4)] = cljs.core.rest.call(null,(state_54354[(4)])));

return statearr_54367;
})();
var state_54354__$1 = (function (){var statearr_54368 = state_54354;
(statearr_54368[(7)] = inst_54349);

return statearr_54368;
})();
var statearr_54369_54383 = state_54354__$1;
(statearr_54369_54383[(2)] = inst_54339);

(statearr_54369_54383[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2468__auto____0 = (function (){
var statearr_54370 = [null,null,null,null,null,null,null,null];
(statearr_54370[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2468__auto__);

(statearr_54370[(1)] = (1));

return statearr_54370;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2468__auto____1 = (function (state_54354){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_54354);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e54371){var ex__2471__auto__ = e54371;
var statearr_54372_54384 = state_54354;
(statearr_54372_54384[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_54354[(4)]))){
var statearr_54373_54385 = state_54354;
(statearr_54373_54385[(1)] = cljs.core.first.call(null,(state_54354[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54386 = state_54354;
state_54354 = G__54386;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2468__auto__ = function(state_54354){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2468__auto____1.call(this,state_54354);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_54374 = f__2491__auto__.call(null);
(statearr_54374[(6)] = c__2490__auto__);

return statearr_54374;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_54416){
var state_val_54417 = (state_54416[(1)]);
if((state_val_54417 === (7))){
var state_54416__$1 = state_54416;
var statearr_54418_54437 = state_54416__$1;
(statearr_54418_54437[(2)] = str);

(statearr_54418_54437[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54417 === (1))){
var state_54416__$1 = state_54416;
var statearr_54419_54438 = state_54416__$1;
(statearr_54419_54438[(2)] = null);

(statearr_54419_54438[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54417 === (4))){
var inst_54387 = (state_54416[(2)]);
var state_54416__$1 = state_54416;
var statearr_54420_54439 = state_54416__$1;
(statearr_54420_54439[(2)] = inst_54387);

(statearr_54420_54439[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54417 === (6))){
var state_54416__$1 = state_54416;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54416__$1,(9),str);
} else {
if((state_val_54417 === (3))){
var inst_54414 = (state_54416[(2)]);
var state_54416__$1 = state_54416;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54416__$1,inst_54414);
} else {
if((state_val_54417 === (2))){
var _ = (function (){var statearr_54422 = state_54416;
(statearr_54422[(4)] = cljs.core.cons.call(null,(5),(state_54416[(4)])));

return statearr_54422;
})();
var inst_54393 = fluree.db.util.async.channel_QMARK_.call(null,str);
var state_54416__$1 = state_54416;
if(inst_54393){
var statearr_54423_54440 = state_54416__$1;
(statearr_54423_54440[(1)] = (6));

} else {
var statearr_54424_54441 = state_54416__$1;
(statearr_54424_54441[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54417 === (9))){
var inst_54396 = (state_54416[(2)]);
var inst_54397 = fluree.db.util.async.throw_err.call(null,inst_54396);
var state_54416__$1 = state_54416;
var statearr_54425_54442 = state_54416__$1;
(statearr_54425_54442[(2)] = inst_54397);

(statearr_54425_54442[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54417 === (5))){
var _ = (function (){var statearr_54426 = state_54416;
(statearr_54426[(4)] = cljs.core.rest.call(null,(state_54416[(4)])));

return statearr_54426;
})();
var state_54416__$1 = state_54416;
var ex54421 = (state_54416__$1[(2)]);
var statearr_54427_54443 = state_54416__$1;
(statearr_54427_54443[(5)] = ex54421);


if((ex54421 instanceof Error)){
var statearr_54428_54444 = state_54416__$1;
(statearr_54428_54444[(1)] = (4));

(statearr_54428_54444[(5)] = null);

} else {
throw ex54421;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54417 === (8))){
var inst_54400 = (state_54416[(2)]);
var inst_54401 = fluree.db.dbfunctions.internal.upper_case.call(null,inst_54400);
var inst_54402 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54403 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54404 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54405 = [inst_54400];
var inst_54406 = (new cljs.core.PersistentVector(null,1,(5),inst_54404,inst_54405,null));
var inst_54407 = ["upper-case",inst_54406,inst_54401];
var inst_54408 = cljs.core.PersistentHashMap.fromArrays(inst_54403,inst_54407);
var inst_54409 = [inst_54408,(10)];
var inst_54410 = (new cljs.core.PersistentVector(null,2,(5),inst_54402,inst_54409,null));
var inst_54411 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54410);
var _ = (function (){var statearr_54429 = state_54416;
(statearr_54429[(4)] = cljs.core.rest.call(null,(state_54416[(4)])));

return statearr_54429;
})();
var state_54416__$1 = (function (){var statearr_54430 = state_54416;
(statearr_54430[(7)] = inst_54411);

return statearr_54430;
})();
var statearr_54431_54445 = state_54416__$1;
(statearr_54431_54445[(2)] = inst_54401);

(statearr_54431_54445[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2468__auto____0 = (function (){
var statearr_54432 = [null,null,null,null,null,null,null,null];
(statearr_54432[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2468__auto__);

(statearr_54432[(1)] = (1));

return statearr_54432;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2468__auto____1 = (function (state_54416){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_54416);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e54433){var ex__2471__auto__ = e54433;
var statearr_54434_54446 = state_54416;
(statearr_54434_54446[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_54416[(4)]))){
var statearr_54435_54447 = state_54416;
(statearr_54435_54447[(1)] = cljs.core.first.call(null,(state_54416[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54448 = state_54416;
state_54416 = G__54448;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2468__auto__ = function(state_54416){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2468__auto____1.call(this,state_54416);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_54436 = f__2491__auto__.call(null);
(statearr_54436[(6)] = c__2490__auto__);

return statearr_54436;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__4115__auto__)){
return (!(typeof cljs.core.get_in.call(null,_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null)) === 'string'));
} else {
return and__4115__auto__;
}
})())){
var res = cljs.core.get_in.call(null,_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?pid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__54450 = arguments.length;
switch (G__54450) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_54478){
var state_val_54479 = (state_54478[(1)]);
if((state_val_54479 === (1))){
var state_54478__$1 = state_54478;
var statearr_54480_54496 = state_54478__$1;
(statearr_54480_54496[(2)] = null);

(statearr_54480_54496[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54479 === (2))){
var _ = (function (){var statearr_54481 = state_54478;
(statearr_54481[(4)] = cljs.core.cons.call(null,(5),(state_54478[(4)])));

return statearr_54481;
})();
var inst_54460 = fluree.db.dbfunctions.internal._QMARK_s.call(null,_QMARK_ctx,additional_select);
var state_54478__$1 = state_54478;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54478__$1,(6),inst_54460);
} else {
if((state_val_54479 === (3))){
var inst_54476 = (state_54478[(2)]);
var state_54478__$1 = state_54478;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54478__$1,inst_54476);
} else {
if((state_val_54479 === (4))){
var inst_54451 = (state_54478[(2)]);
var state_54478__$1 = state_54478;
var statearr_54483_54497 = state_54478__$1;
(statearr_54483_54497[(2)] = inst_54451);

(statearr_54483_54497[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54479 === (5))){
var _ = (function (){var statearr_54484 = state_54478;
(statearr_54484[(4)] = cljs.core.rest.call(null,(state_54478[(4)])));

return statearr_54484;
})();
var state_54478__$1 = state_54478;
var ex54482 = (state_54478__$1[(2)]);
var statearr_54485_54498 = state_54478__$1;
(statearr_54485_54498[(5)] = ex54482);


if((ex54482 instanceof Error)){
var statearr_54486_54499 = state_54478__$1;
(statearr_54486_54499[(1)] = (4));

(statearr_54486_54499[(5)] = null);

} else {
throw ex54482;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54479 === (6))){
var inst_54462 = (state_54478[(2)]);
var inst_54463 = fluree.db.util.async.throw_err.call(null,inst_54462);
var inst_54464 = cljs.core.nth.call(null,inst_54463,(0),null);
var inst_54465 = cljs.core.nth.call(null,inst_54463,(1),null);
var inst_54466 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54467 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54468 = ["?s","?ctx",inst_54464];
var inst_54469 = cljs.core.PersistentHashMap.fromArrays(inst_54467,inst_54468);
var inst_54470 = ((10) + inst_54465);
var inst_54471 = [inst_54469,inst_54470];
var inst_54472 = (new cljs.core.PersistentVector(null,2,(5),inst_54466,inst_54471,null));
var inst_54473 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54472);
var _ = (function (){var statearr_54487 = state_54478;
(statearr_54487[(4)] = cljs.core.rest.call(null,(state_54478[(4)])));

return statearr_54487;
})();
var state_54478__$1 = (function (){var statearr_54488 = state_54478;
(statearr_54488[(7)] = inst_54473);

return statearr_54488;
})();
var statearr_54489_54500 = state_54478__$1;
(statearr_54489_54500[(2)] = inst_54464);

(statearr_54489_54500[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2468__auto____0 = (function (){
var statearr_54490 = [null,null,null,null,null,null,null,null];
(statearr_54490[(0)] = fluree$db$dbfunctions$fns$state_machine__2468__auto__);

(statearr_54490[(1)] = (1));

return statearr_54490;
});
var fluree$db$dbfunctions$fns$state_machine__2468__auto____1 = (function (state_54478){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_54478);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e54491){var ex__2471__auto__ = e54491;
var statearr_54492_54501 = state_54478;
(statearr_54492_54501[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_54478[(4)]))){
var statearr_54493_54502 = state_54478;
(statearr_54493_54502[(1)] = cljs.core.first.call(null,(state_54478[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54503 = state_54478;
state_54478 = G__54503;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2468__auto__ = function(state_54478){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2468__auto____1.call(this,state_54478);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_54494 = f__2491__auto__.call(null);
(statearr_54494[(6)] = c__2490__auto__);

return statearr_54494;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__54505 = arguments.length;
switch (G__54505) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_54543){
var state_val_54544 = (state_54543[(1)]);
if((state_val_54544 === (7))){
var inst_54536 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?p from this function interface");
var state_54543__$1 = state_54543;
var statearr_54545_54565 = state_54543__$1;
(statearr_54545_54565[(2)] = inst_54536);

(statearr_54545_54565[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54544 === (1))){
var state_54543__$1 = state_54543;
var statearr_54546_54566 = state_54543__$1;
(statearr_54546_54566[(2)] = null);

(statearr_54546_54566[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54544 === (4))){
var inst_54506 = (state_54543[(2)]);
var state_54543__$1 = state_54543;
var statearr_54547_54567 = state_54543__$1;
(statearr_54547_54567[(2)] = inst_54506);

(statearr_54547_54567[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54544 === (6))){
var inst_54517 = fluree.db.dbfunctions.fns.coerce_args.call(null,additional_select);
var state_54543__$1 = state_54543;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54543__$1,(10),inst_54517);
} else {
if((state_val_54544 === (3))){
var inst_54541 = (state_54543[(2)]);
var state_54543__$1 = state_54543;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54543__$1,inst_54541);
} else {
if((state_val_54544 === (2))){
var _ = (function (){var statearr_54549 = state_54543;
(statearr_54549[(4)] = cljs.core.cons.call(null,(5),(state_54543[(4)])));

return statearr_54549;
})();
var inst_54512 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_54543__$1 = state_54543;
if(cljs.core.truth_(inst_54512)){
var statearr_54550_54568 = state_54543__$1;
(statearr_54550_54568[(1)] = (6));

} else {
var statearr_54551_54569 = state_54543__$1;
(statearr_54551_54569[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54544 === (9))){
var inst_54523 = (state_54543[(2)]);
var inst_54524 = fluree.db.util.async.throw_err.call(null,inst_54523);
var inst_54525 = cljs.core.nth.call(null,inst_54524,(0),null);
var inst_54526 = cljs.core.nth.call(null,inst_54524,(1),null);
var inst_54527 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54528 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54529 = ["?p","?ctx",inst_54525];
var inst_54530 = cljs.core.PersistentHashMap.fromArrays(inst_54528,inst_54529);
var inst_54531 = ((10) + inst_54526);
var inst_54532 = [inst_54530,inst_54531];
var inst_54533 = (new cljs.core.PersistentVector(null,2,(5),inst_54527,inst_54532,null));
var inst_54534 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54533);
var state_54543__$1 = (function (){var statearr_54552 = state_54543;
(statearr_54552[(7)] = inst_54534);

return statearr_54552;
})();
var statearr_54553_54570 = state_54543__$1;
(statearr_54553_54570[(2)] = inst_54525);

(statearr_54553_54570[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54544 === (5))){
var _ = (function (){var statearr_54554 = state_54543;
(statearr_54554[(4)] = cljs.core.rest.call(null,(state_54543[(4)])));

return statearr_54554;
})();
var state_54543__$1 = state_54543;
var ex54548 = (state_54543__$1[(2)]);
var statearr_54555_54571 = state_54543__$1;
(statearr_54555_54571[(5)] = ex54548);


if((ex54548 instanceof Error)){
var statearr_54556_54572 = state_54543__$1;
(statearr_54556_54572[(1)] = (4));

(statearr_54556_54572[(5)] = null);

} else {
throw ex54548;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54544 === (10))){
var inst_54519 = (state_54543[(2)]);
var inst_54520 = fluree.db.util.async.throw_err.call(null,inst_54519);
var inst_54521 = fluree.db.dbfunctions.internal._QMARK_p.call(null,_QMARK_ctx,inst_54520);
var state_54543__$1 = state_54543;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54543__$1,(9),inst_54521);
} else {
if((state_val_54544 === (8))){
var inst_54538 = (state_54543[(2)]);
var _ = (function (){var statearr_54557 = state_54543;
(statearr_54557[(4)] = cljs.core.rest.call(null,(state_54543[(4)])));

return statearr_54557;
})();
var state_54543__$1 = state_54543;
var statearr_54558_54573 = state_54543__$1;
(statearr_54558_54573[(2)] = inst_54538);

(statearr_54558_54573[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2468__auto____0 = (function (){
var statearr_54559 = [null,null,null,null,null,null,null,null];
(statearr_54559[(0)] = fluree$db$dbfunctions$fns$state_machine__2468__auto__);

(statearr_54559[(1)] = (1));

return statearr_54559;
});
var fluree$db$dbfunctions$fns$state_machine__2468__auto____1 = (function (state_54543){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_54543);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e54560){var ex__2471__auto__ = e54560;
var statearr_54561_54574 = state_54543;
(statearr_54561_54574[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_54543[(4)]))){
var statearr_54562_54575 = state_54543;
(statearr_54562_54575[(1)] = cljs.core.first.call(null,(state_54543[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54576 = state_54543;
state_54543 = G__54576;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2468__auto__ = function(state_54543){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2468__auto____1.call(this,state_54543);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_54563 = f__2491__auto__.call(null);
(statearr_54563[(6)] = c__2490__auto__);

return statearr_54563;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__4742__auto__ = [];
var len__4736__auto___54625 = arguments.length;
var i__4737__auto___54626 = (0);
while(true){
if((i__4737__auto___54626 < len__4736__auto___54625)){
args__4742__auto__.push((arguments[i__4737__auto___54626]));

var G__54627 = (i__4737__auto___54626 + (1));
i__4737__auto___54626 = G__54627;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_54608){
var state_val_54609 = (state_54608[(1)]);
if((state_val_54609 === (1))){
var state_54608__$1 = state_54608;
var statearr_54610_54628 = state_54608__$1;
(statearr_54610_54628[(2)] = null);

(statearr_54610_54628[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54609 === (2))){
var _ = (function (){var statearr_54611 = state_54608;
(statearr_54611[(4)] = cljs.core.cons.call(null,(5),(state_54608[(4)])));

return statearr_54611;
})();
var inst_54585 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54608__$1 = state_54608;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54608__$1,(6),inst_54585);
} else {
if((state_val_54609 === (3))){
var inst_54606 = (state_54608[(2)]);
var state_54608__$1 = state_54608;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54608__$1,inst_54606);
} else {
if((state_val_54609 === (4))){
var inst_54579 = (state_54608[(2)]);
var state_54608__$1 = state_54608;
var statearr_54613_54629 = state_54608__$1;
(statearr_54613_54629[(2)] = inst_54579);

(statearr_54613_54629[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54609 === (5))){
var _ = (function (){var statearr_54614 = state_54608;
(statearr_54614[(4)] = cljs.core.rest.call(null,(state_54608[(4)])));

return statearr_54614;
})();
var state_54608__$1 = state_54608;
var ex54612 = (state_54608__$1[(2)]);
var statearr_54615_54630 = state_54608__$1;
(statearr_54615_54630[(5)] = ex54612);


if((ex54612 instanceof Error)){
var statearr_54616_54631 = state_54608__$1;
(statearr_54616_54631[(1)] = (4));

(statearr_54616_54631[(5)] = null);

} else {
throw ex54612;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54609 === (6))){
var inst_54587 = (state_54608[(2)]);
var inst_54588 = fluree.db.util.async.throw_err.call(null,inst_54587);
var inst_54589 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.and,inst_54588);
var inst_54590 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54591 = [inst_54588];
var inst_54592 = (new cljs.core.PersistentVector(null,1,(5),inst_54590,inst_54591,null));
var inst_54593 = cljs.core.count.call(null,inst_54592);
var inst_54594 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54595 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54596 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54597 = [inst_54588];
var inst_54598 = (new cljs.core.PersistentVector(null,1,(5),inst_54596,inst_54597,null));
var inst_54599 = ["and",inst_54598,inst_54589];
var inst_54600 = cljs.core.PersistentHashMap.fromArrays(inst_54595,inst_54599);
var inst_54601 = [inst_54600,inst_54593];
var inst_54602 = (new cljs.core.PersistentVector(null,2,(5),inst_54594,inst_54601,null));
var inst_54603 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54602);
var _ = (function (){var statearr_54617 = state_54608;
(statearr_54617[(4)] = cljs.core.rest.call(null,(state_54608[(4)])));

return statearr_54617;
})();
var state_54608__$1 = (function (){var statearr_54618 = state_54608;
(statearr_54618[(7)] = inst_54603);

return statearr_54618;
})();
var statearr_54619_54632 = state_54608__$1;
(statearr_54619_54632[(2)] = inst_54589);

(statearr_54619_54632[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2468__auto____0 = (function (){
var statearr_54620 = [null,null,null,null,null,null,null,null];
(statearr_54620[(0)] = fluree$db$dbfunctions$fns$state_machine__2468__auto__);

(statearr_54620[(1)] = (1));

return statearr_54620;
});
var fluree$db$dbfunctions$fns$state_machine__2468__auto____1 = (function (state_54608){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_54608);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e54621){var ex__2471__auto__ = e54621;
var statearr_54622_54633 = state_54608;
(statearr_54622_54633[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_54608[(4)]))){
var statearr_54623_54634 = state_54608;
(statearr_54623_54634[(1)] = cljs.core.first.call(null,(state_54608[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54635 = state_54608;
state_54608 = G__54635;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2468__auto__ = function(state_54608){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2468__auto____1.call(this,state_54608);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_54624 = f__2491__auto__.call(null);
(statearr_54624[(6)] = c__2490__auto__);

return statearr_54624;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq54577){
var G__54578 = cljs.core.first.call(null,seq54577);
var seq54577__$1 = cljs.core.next.call(null,seq54577);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54578,seq54577__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__4742__auto__ = [];
var len__4736__auto___54684 = arguments.length;
var i__4737__auto___54685 = (0);
while(true){
if((i__4737__auto___54685 < len__4736__auto___54684)){
args__4742__auto__.push((arguments[i__4737__auto___54685]));

var G__54686 = (i__4737__auto___54685 + (1));
i__4737__auto___54685 = G__54686;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_54667){
var state_val_54668 = (state_54667[(1)]);
if((state_val_54668 === (1))){
var state_54667__$1 = state_54667;
var statearr_54669_54687 = state_54667__$1;
(statearr_54669_54687[(2)] = null);

(statearr_54669_54687[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54668 === (2))){
var _ = (function (){var statearr_54670 = state_54667;
(statearr_54670[(4)] = cljs.core.cons.call(null,(5),(state_54667[(4)])));

return statearr_54670;
})();
var inst_54644 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54667__$1 = state_54667;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54667__$1,(6),inst_54644);
} else {
if((state_val_54668 === (3))){
var inst_54665 = (state_54667[(2)]);
var state_54667__$1 = state_54667;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54667__$1,inst_54665);
} else {
if((state_val_54668 === (4))){
var inst_54638 = (state_54667[(2)]);
var state_54667__$1 = state_54667;
var statearr_54672_54688 = state_54667__$1;
(statearr_54672_54688[(2)] = inst_54638);

(statearr_54672_54688[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54668 === (5))){
var _ = (function (){var statearr_54673 = state_54667;
(statearr_54673[(4)] = cljs.core.rest.call(null,(state_54667[(4)])));

return statearr_54673;
})();
var state_54667__$1 = state_54667;
var ex54671 = (state_54667__$1[(2)]);
var statearr_54674_54689 = state_54667__$1;
(statearr_54674_54689[(5)] = ex54671);


if((ex54671 instanceof Error)){
var statearr_54675_54690 = state_54667__$1;
(statearr_54675_54690[(1)] = (4));

(statearr_54675_54690[(5)] = null);

} else {
throw ex54671;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54668 === (6))){
var inst_54646 = (state_54667[(2)]);
var inst_54647 = fluree.db.util.async.throw_err.call(null,inst_54646);
var inst_54648 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.or,inst_54647);
var inst_54649 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54650 = [inst_54647];
var inst_54651 = (new cljs.core.PersistentVector(null,1,(5),inst_54649,inst_54650,null));
var inst_54652 = cljs.core.count.call(null,inst_54651);
var inst_54653 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54654 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54655 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54656 = [inst_54647];
var inst_54657 = (new cljs.core.PersistentVector(null,1,(5),inst_54655,inst_54656,null));
var inst_54658 = ["or",inst_54657,inst_54648];
var inst_54659 = cljs.core.PersistentHashMap.fromArrays(inst_54654,inst_54658);
var inst_54660 = [inst_54659,inst_54652];
var inst_54661 = (new cljs.core.PersistentVector(null,2,(5),inst_54653,inst_54660,null));
var inst_54662 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54661);
var _ = (function (){var statearr_54676 = state_54667;
(statearr_54676[(4)] = cljs.core.rest.call(null,(state_54667[(4)])));

return statearr_54676;
})();
var state_54667__$1 = (function (){var statearr_54677 = state_54667;
(statearr_54677[(7)] = inst_54662);

return statearr_54677;
})();
var statearr_54678_54691 = state_54667__$1;
(statearr_54678_54691[(2)] = inst_54648);

(statearr_54678_54691[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2468__auto____0 = (function (){
var statearr_54679 = [null,null,null,null,null,null,null,null];
(statearr_54679[(0)] = fluree$db$dbfunctions$fns$state_machine__2468__auto__);

(statearr_54679[(1)] = (1));

return statearr_54679;
});
var fluree$db$dbfunctions$fns$state_machine__2468__auto____1 = (function (state_54667){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_54667);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e54680){var ex__2471__auto__ = e54680;
var statearr_54681_54692 = state_54667;
(statearr_54681_54692[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_54667[(4)]))){
var statearr_54682_54693 = state_54667;
(statearr_54682_54693[(1)] = cljs.core.first.call(null,(state_54667[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54694 = state_54667;
state_54667 = G__54694;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2468__auto__ = function(state_54667){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2468__auto____1.call(this,state_54667);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_54683 = f__2491__auto__.call(null);
(statearr_54683[(6)] = c__2490__auto__);

return statearr_54683;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq54636){
var G__54637 = cljs.core.first.call(null,seq54636);
var seq54636__$1 = cljs.core.next.call(null,seq54636);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54637,seq54636__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_54732){
var state_val_54733 = (state_54732[(1)]);
if((state_val_54733 === (7))){
var inst_54708 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_54732__$1 = state_54732;
if(inst_54708){
var statearr_54734_54757 = state_54732__$1;
(statearr_54734_54757[(1)] = (10));

} else {
var statearr_54735_54758 = state_54732__$1;
(statearr_54735_54758[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54733 === (1))){
var state_54732__$1 = state_54732;
var statearr_54736_54759 = state_54732__$1;
(statearr_54736_54759[(2)] = null);

(statearr_54736_54759[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54733 === (4))){
var inst_54695 = (state_54732[(2)]);
var state_54732__$1 = state_54732;
var statearr_54737_54760 = state_54732__$1;
(statearr_54737_54760[(2)] = inst_54695);

(statearr_54737_54760[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54733 === (13))){
var inst_54711 = (state_54732[(2)]);
var inst_54712 = fluree.db.util.async.throw_err.call(null,inst_54711);
var state_54732__$1 = state_54732;
var statearr_54738_54761 = state_54732__$1;
(statearr_54738_54761[(2)] = inst_54712);

(statearr_54738_54761[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54733 === (6))){
var inst_54703 = fluree.db.dbfunctions.fns.coerce_args.call(null,coll);
var state_54732__$1 = state_54732;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54732__$1,(9),inst_54703);
} else {
if((state_val_54733 === (3))){
var inst_54730 = (state_54732[(2)]);
var state_54732__$1 = state_54732;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54732__$1,inst_54730);
} else {
if((state_val_54733 === (12))){
var inst_54715 = (state_54732[(2)]);
var state_54732__$1 = state_54732;
var statearr_54739_54762 = state_54732__$1;
(statearr_54739_54762[(2)] = inst_54715);

(statearr_54739_54762[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54733 === (2))){
var _ = (function (){var statearr_54740 = state_54732;
(statearr_54740[(4)] = cljs.core.cons.call(null,(5),(state_54732[(4)])));

return statearr_54740;
})();
var inst_54701 = cljs.core.vector_QMARK_.call(null,coll);
var state_54732__$1 = state_54732;
if(inst_54701){
var statearr_54741_54763 = state_54732__$1;
(statearr_54741_54763[(1)] = (6));

} else {
var statearr_54742_54764 = state_54732__$1;
(statearr_54742_54764[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54733 === (11))){
var state_54732__$1 = state_54732;
var statearr_54744_54765 = state_54732__$1;
(statearr_54744_54765[(2)] = coll);

(statearr_54744_54765[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54733 === (9))){
var inst_54705 = (state_54732[(2)]);
var inst_54706 = fluree.db.util.async.throw_err.call(null,inst_54705);
var state_54732__$1 = state_54732;
var statearr_54745_54766 = state_54732__$1;
(statearr_54745_54766[(2)] = inst_54706);

(statearr_54745_54766[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54733 === (5))){
var _ = (function (){var statearr_54746 = state_54732;
(statearr_54746[(4)] = cljs.core.rest.call(null,(state_54732[(4)])));

return statearr_54746;
})();
var state_54732__$1 = state_54732;
var ex54743 = (state_54732__$1[(2)]);
var statearr_54747_54767 = state_54732__$1;
(statearr_54747_54767[(5)] = ex54743);


if((ex54743 instanceof Error)){
var statearr_54748_54768 = state_54732__$1;
(statearr_54748_54768[(1)] = (4));

(statearr_54748_54768[(5)] = null);

} else {
throw ex54743;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54733 === (10))){
var state_54732__$1 = state_54732;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54732__$1,(13),coll);
} else {
if((state_val_54733 === (8))){
var inst_54717 = (state_54732[(2)]);
var inst_54718 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_54717);
var inst_54719 = cljs.core.count.call(null,inst_54718);
var inst_54720 = ((9) + inst_54719);
var inst_54721 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54722 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54723 = ["count",inst_54717,inst_54719];
var inst_54724 = cljs.core.PersistentHashMap.fromArrays(inst_54722,inst_54723);
var inst_54725 = [inst_54724,inst_54720];
var inst_54726 = (new cljs.core.PersistentVector(null,2,(5),inst_54721,inst_54725,null));
var inst_54727 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54726);
var _ = (function (){var statearr_54749 = state_54732;
(statearr_54749[(4)] = cljs.core.rest.call(null,(state_54732[(4)])));

return statearr_54749;
})();
var state_54732__$1 = (function (){var statearr_54750 = state_54732;
(statearr_54750[(7)] = inst_54727);

return statearr_54750;
})();
var statearr_54751_54769 = state_54732__$1;
(statearr_54751_54769[(2)] = inst_54719);

(statearr_54751_54769[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__2468__auto____0 = (function (){
var statearr_54752 = [null,null,null,null,null,null,null,null];
(statearr_54752[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__2468__auto__);

(statearr_54752[(1)] = (1));

return statearr_54752;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__2468__auto____1 = (function (state_54732){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_54732);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e54753){var ex__2471__auto__ = e54753;
var statearr_54754_54770 = state_54732;
(statearr_54754_54770[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_54732[(4)]))){
var statearr_54755_54771 = state_54732;
(statearr_54755_54771[(1)] = cljs.core.first.call(null,(state_54732[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54772 = state_54732;
state_54732 = G__54772;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__2468__auto__ = function(state_54732){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__2468__auto____1.call(this,state_54732);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_54756 = f__2491__auto__.call(null);
(statearr_54756[(6)] = c__2490__auto__);

return statearr_54756;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(_QMARK_ctx,subject,pred){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_54822){
var state_val_54823 = (state_54822[(1)]);
if((state_val_54823 === (7))){
var state_54822__$1 = state_54822;
var statearr_54824_54857 = state_54822__$1;
(statearr_54824_54857[(2)] = subject);

(statearr_54824_54857[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (1))){
var state_54822__$1 = state_54822;
var statearr_54825_54858 = state_54822__$1;
(statearr_54825_54858[(2)] = null);

(statearr_54825_54858[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (4))){
var inst_54773 = (state_54822[(2)]);
var state_54822__$1 = state_54822;
var statearr_54826_54859 = state_54822__$1;
(statearr_54826_54859[(2)] = inst_54773);

(statearr_54826_54859[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (15))){
var inst_54786 = (state_54822[(7)]);
var state_54822__$1 = state_54822;
var statearr_54827_54860 = state_54822__$1;
(statearr_54827_54860[(2)] = inst_54786);

(statearr_54827_54860[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (13))){
var inst_54790 = (state_54822[(2)]);
var inst_54791 = fluree.db.util.async.throw_err.call(null,inst_54790);
var state_54822__$1 = state_54822;
var statearr_54828_54861 = state_54822__$1;
(statearr_54828_54861[(2)] = inst_54791);

(statearr_54828_54861[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (6))){
var state_54822__$1 = state_54822;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54822__$1,(9),subject);
} else {
if((state_val_54823 === (17))){
var inst_54786 = (state_54822[(7)]);
var inst_54800 = cljs.core.first.call(null,inst_54786);
var state_54822__$1 = state_54822;
var statearr_54829_54862 = state_54822__$1;
(statearr_54829_54862[(2)] = inst_54800);

(statearr_54829_54862[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (3))){
var inst_54820 = (state_54822[(2)]);
var state_54822__$1 = state_54822;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54822__$1,inst_54820);
} else {
if((state_val_54823 === (12))){
var inst_54786 = (state_54822[(7)]);
var inst_54794 = (state_54822[(2)]);
var inst_54795 = cljs.core.vector_QMARK_.call(null,inst_54786);
var state_54822__$1 = (function (){var statearr_54830 = state_54822;
(statearr_54830[(8)] = inst_54794);

return statearr_54830;
})();
if(inst_54795){
var statearr_54831_54863 = state_54822__$1;
(statearr_54831_54863[(1)] = (14));

} else {
var statearr_54832_54864 = state_54822__$1;
(statearr_54832_54864[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (2))){
var _ = (function (){var statearr_54833 = state_54822;
(statearr_54833[(4)] = cljs.core.cons.call(null,(5),(state_54822[(4)])));

return statearr_54833;
})();
var inst_54779 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_54822__$1 = state_54822;
if(inst_54779){
var statearr_54834_54865 = state_54822__$1;
(statearr_54834_54865[(1)] = (6));

} else {
var statearr_54835_54866 = state_54822__$1;
(statearr_54835_54866[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (19))){
var inst_54803 = (state_54822[(2)]);
var state_54822__$1 = state_54822;
var statearr_54836_54867 = state_54822__$1;
(statearr_54836_54867[(2)] = inst_54803);

(statearr_54836_54867[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (11))){
var state_54822__$1 = state_54822;
var statearr_54838_54868 = state_54822__$1;
(statearr_54838_54868[(2)] = pred);

(statearr_54838_54868[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (9))){
var inst_54782 = (state_54822[(2)]);
var inst_54783 = fluree.db.util.async.throw_err.call(null,inst_54782);
var state_54822__$1 = state_54822;
var statearr_54839_54869 = state_54822__$1;
(statearr_54839_54869[(2)] = inst_54783);

(statearr_54839_54869[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (5))){
var _ = (function (){var statearr_54840 = state_54822;
(statearr_54840[(4)] = cljs.core.rest.call(null,(state_54822[(4)])));

return statearr_54840;
})();
var state_54822__$1 = state_54822;
var ex54837 = (state_54822__$1[(2)]);
var statearr_54841_54870 = state_54822__$1;
(statearr_54841_54870[(5)] = ex54837);


if((ex54837 instanceof Error)){
var statearr_54842_54871 = state_54822__$1;
(statearr_54842_54871[(1)] = (4));

(statearr_54842_54871[(5)] = null);

} else {
throw ex54837;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (14))){
var inst_54786 = (state_54822[(7)]);
var inst_54797 = cljs.core.count.call(null,inst_54786);
var inst_54798 = cljs.core._EQ_.call(null,(1),inst_54797);
var state_54822__$1 = state_54822;
if(inst_54798){
var statearr_54843_54872 = state_54822__$1;
(statearr_54843_54872[(1)] = (17));

} else {
var statearr_54844_54873 = state_54822__$1;
(statearr_54844_54873[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (16))){
var inst_54794 = (state_54822[(8)]);
var inst_54786 = (state_54822[(7)]);
var inst_54806 = (state_54822[(2)]);
var inst_54807 = fluree.db.dbfunctions.internal.get.call(null,inst_54806,inst_54794);
var inst_54808 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54809 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54810 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54811 = [inst_54786,inst_54794];
var inst_54812 = (new cljs.core.PersistentVector(null,2,(5),inst_54810,inst_54811,null));
var inst_54813 = ["get",inst_54812,inst_54807];
var inst_54814 = cljs.core.PersistentHashMap.fromArrays(inst_54809,inst_54813);
var inst_54815 = [inst_54814,(10)];
var inst_54816 = (new cljs.core.PersistentVector(null,2,(5),inst_54808,inst_54815,null));
var inst_54817 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54816);
var _ = (function (){var statearr_54845 = state_54822;
(statearr_54845[(4)] = cljs.core.rest.call(null,(state_54822[(4)])));

return statearr_54845;
})();
var state_54822__$1 = (function (){var statearr_54846 = state_54822;
(statearr_54846[(9)] = inst_54817);

return statearr_54846;
})();
var statearr_54847_54874 = state_54822__$1;
(statearr_54847_54874[(2)] = inst_54807);

(statearr_54847_54874[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (10))){
var state_54822__$1 = state_54822;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54822__$1,(13),pred);
} else {
if((state_val_54823 === (18))){
var inst_54786 = (state_54822[(7)]);
var state_54822__$1 = state_54822;
var statearr_54848_54875 = state_54822__$1;
(statearr_54848_54875[(2)] = inst_54786);

(statearr_54848_54875[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (8))){
var inst_54786 = (state_54822[(2)]);
var inst_54787 = fluree.db.util.async.channel_QMARK_.call(null,pred);
var state_54822__$1 = (function (){var statearr_54849 = state_54822;
(statearr_54849[(7)] = inst_54786);

return statearr_54849;
})();
if(inst_54787){
var statearr_54850_54876 = state_54822__$1;
(statearr_54850_54876[(1)] = (10));

} else {
var statearr_54851_54877 = state_54822__$1;
(statearr_54851_54877[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__2468__auto____0 = (function (){
var statearr_54852 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54852[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__2468__auto__);

(statearr_54852[(1)] = (1));

return statearr_54852;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__2468__auto____1 = (function (state_54822){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_54822);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e54853){var ex__2471__auto__ = e54853;
var statearr_54854_54878 = state_54822;
(statearr_54854_54878[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_54822[(4)]))){
var statearr_54855_54879 = state_54822;
(statearr_54855_54879[(1)] = cljs.core.first.call(null,(state_54822[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54880 = state_54822;
state_54822 = G__54880;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__2468__auto__ = function(state_54822){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__2468__auto____1.call(this,state_54822);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_54856 = f__2491__auto__.call(null);
(statearr_54856[(6)] = c__2490__auto__);

return statearr_54856;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?o",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_54919){
var state_val_54920 = (state_54919[(1)]);
if((state_val_54920 === (7))){
var inst_54887 = (state_54919[(7)]);
var state_54919__$1 = state_54919;
var statearr_54921_54945 = state_54919__$1;
(statearr_54921_54945[(2)] = inst_54887);

(statearr_54921_54945[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54920 === (1))){
var state_54919__$1 = state_54919;
var statearr_54922_54946 = state_54919__$1;
(statearr_54922_54946[(2)] = null);

(statearr_54922_54946[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54920 === (4))){
var inst_54881 = (state_54919[(2)]);
var state_54919__$1 = state_54919;
var statearr_54923_54947 = state_54919__$1;
(statearr_54923_54947[(2)] = inst_54881);

(statearr_54923_54947[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54920 === (6))){
var inst_54889 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_54919__$1 = state_54919;
var statearr_54924_54948 = state_54919__$1;
(statearr_54924_54948[(2)] = inst_54889);

(statearr_54924_54948[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54920 === (3))){
var inst_54917 = (state_54919[(2)]);
var state_54919__$1 = state_54919;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54919__$1,inst_54917);
} else {
if((state_val_54920 === (12))){
var inst_54899 = (state_54919[(2)]);
var inst_54900 = fluree.db.util.async.throw_err.call(null,inst_54899);
var inst_54901 = cljs.core.nth.call(null,inst_54900,(0),null);
var inst_54902 = cljs.core.nth.call(null,inst_54900,(1),null);
var inst_54903 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54904 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54905 = ["?pO","?ctx",inst_54901];
var inst_54906 = cljs.core.PersistentHashMap.fromArrays(inst_54904,inst_54905);
var inst_54907 = ((10) + inst_54902);
var inst_54908 = [inst_54906,inst_54907];
var inst_54909 = (new cljs.core.PersistentVector(null,2,(5),inst_54903,inst_54908,null));
var inst_54910 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54909);
var state_54919__$1 = (function (){var statearr_54925 = state_54919;
(statearr_54925[(8)] = inst_54910);

return statearr_54925;
})();
var statearr_54926_54949 = state_54919__$1;
(statearr_54926_54949[(2)] = inst_54901);

(statearr_54926_54949[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54920 === (2))){
var inst_54887 = (state_54919[(7)]);
var _ = (function (){var statearr_54927 = state_54919;
(statearr_54927[(4)] = cljs.core.cons.call(null,(5),(state_54919[(4)])));

return statearr_54927;
})();
var inst_54887__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_54919__$1 = (function (){var statearr_54928 = state_54919;
(statearr_54928[(7)] = inst_54887__$1);

return statearr_54928;
})();
if(cljs.core.truth_(inst_54887__$1)){
var statearr_54929_54950 = state_54919__$1;
(statearr_54929_54950[(1)] = (6));

} else {
var statearr_54930_54951 = state_54919__$1;
(statearr_54930_54951[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54920 === (11))){
var inst_54914 = (state_54919[(2)]);
var _ = (function (){var statearr_54932 = state_54919;
(statearr_54932[(4)] = cljs.core.rest.call(null,(state_54919[(4)])));

return statearr_54932;
})();
var state_54919__$1 = state_54919;
var statearr_54933_54952 = state_54919__$1;
(statearr_54933_54952[(2)] = inst_54914);

(statearr_54933_54952[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54920 === (9))){
var inst_54897 = fluree.db.dbfunctions.internal._QMARK_pO.call(null,_QMARK_ctx);
var state_54919__$1 = state_54919;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54919__$1,(12),inst_54897);
} else {
if((state_val_54920 === (5))){
var _ = (function (){var statearr_54934 = state_54919;
(statearr_54934[(4)] = cljs.core.rest.call(null,(state_54919[(4)])));

return statearr_54934;
})();
var state_54919__$1 = state_54919;
var ex54931 = (state_54919__$1[(2)]);
var statearr_54935_54953 = state_54919__$1;
(statearr_54935_54953[(5)] = ex54931);


if((ex54931 instanceof Error)){
var statearr_54936_54954 = state_54919__$1;
(statearr_54936_54954[(1)] = (4));

(statearr_54936_54954[(5)] = null);

} else {
throw ex54931;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54920 === (10))){
var inst_54912 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_54919__$1 = state_54919;
var statearr_54937_54955 = state_54919__$1;
(statearr_54937_54955[(2)] = inst_54912);

(statearr_54937_54955[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54920 === (8))){
var inst_54892 = (state_54919[(2)]);
var state_54919__$1 = state_54919;
if(cljs.core.truth_(inst_54892)){
var statearr_54938_54956 = state_54919__$1;
(statearr_54938_54956[(1)] = (9));

} else {
var statearr_54939_54957 = state_54919__$1;
(statearr_54939_54957[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2468__auto____0 = (function (){
var statearr_54940 = [null,null,null,null,null,null,null,null,null];
(statearr_54940[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2468__auto__);

(statearr_54940[(1)] = (1));

return statearr_54940;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2468__auto____1 = (function (state_54919){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_54919);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e54941){var ex__2471__auto__ = e54941;
var statearr_54942_54958 = state_54919;
(statearr_54942_54958[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_54919[(4)]))){
var statearr_54943_54959 = state_54919;
(statearr_54943_54959[(1)] = cljs.core.first.call(null,(state_54919[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54960 = state_54919;
state_54919 = G__54960;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2468__auto__ = function(state_54919){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2468__auto____1.call(this,state_54919);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_54944 = f__2491__auto__.call(null);
(statearr_54944[(6)] = c__2490__auto__);

return statearr_54944;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_55012){
var state_val_55013 = (state_55012[(1)]);
if((state_val_55013 === (7))){
var state_55012__$1 = state_55012;
var statearr_55014_55047 = state_55012__$1;
(statearr_55014_55047[(2)] = subject);

(statearr_55014_55047[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55013 === (1))){
var state_55012__$1 = state_55012;
var statearr_55015_55048 = state_55012__$1;
(statearr_55015_55048[(2)] = null);

(statearr_55015_55048[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55013 === (4))){
var inst_54961 = (state_55012[(2)]);
var state_55012__$1 = state_55012;
var statearr_55016_55049 = state_55012__$1;
(statearr_55016_55049[(2)] = inst_54961);

(statearr_55016_55049[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55013 === (15))){
var inst_54974 = (state_55012[(7)]);
var state_55012__$1 = state_55012;
var statearr_55017_55050 = state_55012__$1;
(statearr_55017_55050[(2)] = inst_54974);

(statearr_55017_55050[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55013 === (13))){
var inst_54978 = (state_55012[(2)]);
var inst_54979 = fluree.db.util.async.throw_err.call(null,inst_54978);
var state_55012__$1 = state_55012;
var statearr_55018_55051 = state_55012__$1;
(statearr_55018_55051[(2)] = inst_54979);

(statearr_55018_55051[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55013 === (6))){
var state_55012__$1 = state_55012;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55012__$1,(9),subject);
} else {
if((state_val_55013 === (17))){
var inst_54974 = (state_55012[(7)]);
var inst_54988 = cljs.core.first.call(null,inst_54974);
var state_55012__$1 = state_55012;
var statearr_55019_55052 = state_55012__$1;
(statearr_55019_55052[(2)] = inst_54988);

(statearr_55019_55052[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55013 === (3))){
var inst_55010 = (state_55012[(2)]);
var state_55012__$1 = state_55012;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55012__$1,inst_55010);
} else {
if((state_val_55013 === (12))){
var inst_54974 = (state_55012[(7)]);
var inst_54982 = (state_55012[(2)]);
var inst_54983 = cljs.core.vector_QMARK_.call(null,inst_54974);
var state_55012__$1 = (function (){var statearr_55020 = state_55012;
(statearr_55020[(8)] = inst_54982);

return statearr_55020;
})();
if(inst_54983){
var statearr_55021_55053 = state_55012__$1;
(statearr_55021_55053[(1)] = (14));

} else {
var statearr_55022_55054 = state_55012__$1;
(statearr_55022_55054[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55013 === (2))){
var _ = (function (){var statearr_55023 = state_55012;
(statearr_55023[(4)] = cljs.core.cons.call(null,(5),(state_55012[(4)])));

return statearr_55023;
})();
var inst_54967 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_55012__$1 = state_55012;
if(inst_54967){
var statearr_55024_55055 = state_55012__$1;
(statearr_55024_55055[(1)] = (6));

} else {
var statearr_55025_55056 = state_55012__$1;
(statearr_55025_55056[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55013 === (19))){
var inst_54991 = (state_55012[(2)]);
var state_55012__$1 = state_55012;
var statearr_55026_55057 = state_55012__$1;
(statearr_55026_55057[(2)] = inst_54991);

(statearr_55026_55057[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55013 === (11))){
var state_55012__$1 = state_55012;
var statearr_55028_55058 = state_55012__$1;
(statearr_55028_55058[(2)] = path);

(statearr_55028_55058[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55013 === (9))){
var inst_54970 = (state_55012[(2)]);
var inst_54971 = fluree.db.util.async.throw_err.call(null,inst_54970);
var state_55012__$1 = state_55012;
var statearr_55029_55059 = state_55012__$1;
(statearr_55029_55059[(2)] = inst_54971);

(statearr_55029_55059[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55013 === (5))){
var _ = (function (){var statearr_55030 = state_55012;
(statearr_55030[(4)] = cljs.core.rest.call(null,(state_55012[(4)])));

return statearr_55030;
})();
var state_55012__$1 = state_55012;
var ex55027 = (state_55012__$1[(2)]);
var statearr_55031_55060 = state_55012__$1;
(statearr_55031_55060[(5)] = ex55027);


if((ex55027 instanceof Error)){
var statearr_55032_55061 = state_55012__$1;
(statearr_55032_55061[(1)] = (4));

(statearr_55032_55061[(5)] = null);

} else {
throw ex55027;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55013 === (14))){
var inst_54974 = (state_55012[(7)]);
var inst_54985 = cljs.core.count.call(null,inst_54974);
var inst_54986 = cljs.core._EQ_.call(null,(1),inst_54985);
var state_55012__$1 = state_55012;
if(inst_54986){
var statearr_55033_55062 = state_55012__$1;
(statearr_55033_55062[(1)] = (17));

} else {
var statearr_55034_55063 = state_55012__$1;
(statearr_55034_55063[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55013 === (16))){
var inst_54982 = (state_55012[(8)]);
var inst_54974 = (state_55012[(7)]);
var inst_54994 = (state_55012[(2)]);
var inst_54995 = fluree.db.dbfunctions.internal.get_all.call(null,inst_54994,inst_54982);
var inst_54996 = cljs.core.count.call(null,inst_54982);
var inst_54997 = ((9) + inst_54996);
var inst_54998 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54999 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55000 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55001 = [inst_54974,inst_54982];
var inst_55002 = (new cljs.core.PersistentVector(null,2,(5),inst_55000,inst_55001,null));
var inst_55003 = ["get-all",inst_55002,inst_54995];
var inst_55004 = cljs.core.PersistentHashMap.fromArrays(inst_54999,inst_55003);
var inst_55005 = [inst_55004,inst_54997];
var inst_55006 = (new cljs.core.PersistentVector(null,2,(5),inst_54998,inst_55005,null));
var inst_55007 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55006);
var _ = (function (){var statearr_55035 = state_55012;
(statearr_55035[(4)] = cljs.core.rest.call(null,(state_55012[(4)])));

return statearr_55035;
})();
var state_55012__$1 = (function (){var statearr_55036 = state_55012;
(statearr_55036[(9)] = inst_55007);

return statearr_55036;
})();
var statearr_55037_55064 = state_55012__$1;
(statearr_55037_55064[(2)] = inst_54995);

(statearr_55037_55064[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55013 === (10))){
var state_55012__$1 = state_55012;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55012__$1,(13),path);
} else {
if((state_val_55013 === (18))){
var inst_54974 = (state_55012[(7)]);
var state_55012__$1 = state_55012;
var statearr_55038_55065 = state_55012__$1;
(statearr_55038_55065[(2)] = inst_54974);

(statearr_55038_55065[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55013 === (8))){
var inst_54974 = (state_55012[(2)]);
var inst_54975 = fluree.db.util.async.channel_QMARK_.call(null,path);
var state_55012__$1 = (function (){var statearr_55039 = state_55012;
(statearr_55039[(7)] = inst_54974);

return statearr_55039;
})();
if(inst_54975){
var statearr_55040_55066 = state_55012__$1;
(statearr_55040_55066[(1)] = (10));

} else {
var statearr_55041_55067 = state_55012__$1;
(statearr_55041_55067[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2468__auto____0 = (function (){
var statearr_55042 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55042[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__2468__auto__);

(statearr_55042[(1)] = (1));

return statearr_55042;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2468__auto____1 = (function (state_55012){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_55012);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e55043){var ex__2471__auto__ = e55043;
var statearr_55044_55068 = state_55012;
(statearr_55044_55068[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_55012[(4)]))){
var statearr_55045_55069 = state_55012;
(statearr_55045_55069[(1)] = cljs.core.first.call(null,(state_55012[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55070 = state_55012;
state_55012 = G__55070;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__2468__auto__ = function(state_55012){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2468__auto____1.call(this,state_55012);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_55046 = f__2491__auto__.call(null);
(statearr_55046[(6)] = c__2490__auto__);

return statearr_55046;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [_QMARK_ctx,subject,path], null);

var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_55109){
var state_val_55110 = (state_55109[(1)]);
if((state_val_55110 === (7))){
var state_55109__$1 = state_55109;
var statearr_55111_55135 = state_55109__$1;
(statearr_55111_55135[(2)] = subject);

(statearr_55111_55135[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55110 === (1))){
var state_55109__$1 = state_55109;
var statearr_55112_55136 = state_55109__$1;
(statearr_55112_55136[(2)] = null);

(statearr_55112_55136[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55110 === (4))){
var inst_55071 = (state_55109[(2)]);
var state_55109__$1 = state_55109;
var statearr_55113_55137 = state_55109__$1;
(statearr_55113_55137[(2)] = inst_55071);

(statearr_55113_55137[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55110 === (13))){
var inst_55088 = (state_55109[(2)]);
var inst_55089 = fluree.db.util.async.throw_err.call(null,inst_55088);
var state_55109__$1 = state_55109;
var statearr_55114_55138 = state_55109__$1;
(statearr_55114_55138[(2)] = inst_55089);

(statearr_55114_55138[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55110 === (6))){
var state_55109__$1 = state_55109;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55109__$1,(9),subject);
} else {
if((state_val_55110 === (3))){
var inst_55107 = (state_55109[(2)]);
var state_55109__$1 = state_55109;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55109__$1,inst_55107);
} else {
if((state_val_55110 === (12))){
var inst_55084 = (state_55109[(7)]);
var inst_55092 = (state_55109[(2)]);
var inst_55093 = fluree.db.dbfunctions.internal.get_in.call(null,inst_55084,inst_55092);
var inst_55094 = cljs.core.count.call(null,inst_55092);
var inst_55095 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55096 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55097 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55098 = [inst_55084,inst_55092];
var inst_55099 = (new cljs.core.PersistentVector(null,2,(5),inst_55097,inst_55098,null));
var inst_55100 = ["get-in",inst_55099,inst_55093];
var inst_55101 = cljs.core.PersistentHashMap.fromArrays(inst_55096,inst_55100);
var inst_55102 = [inst_55101,inst_55094];
var inst_55103 = (new cljs.core.PersistentVector(null,2,(5),inst_55095,inst_55102,null));
var inst_55104 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55103);
var _ = (function (){var statearr_55115 = state_55109;
(statearr_55115[(4)] = cljs.core.rest.call(null,(state_55109[(4)])));

return statearr_55115;
})();
var state_55109__$1 = (function (){var statearr_55116 = state_55109;
(statearr_55116[(8)] = inst_55104);

return statearr_55116;
})();
var statearr_55117_55139 = state_55109__$1;
(statearr_55117_55139[(2)] = inst_55093);

(statearr_55117_55139[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55110 === (2))){
var _ = (function (){var statearr_55118 = state_55109;
(statearr_55118[(4)] = cljs.core.cons.call(null,(5),(state_55109[(4)])));

return statearr_55118;
})();
var inst_55077 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_55109__$1 = state_55109;
if(inst_55077){
var statearr_55119_55140 = state_55109__$1;
(statearr_55119_55140[(1)] = (6));

} else {
var statearr_55120_55141 = state_55109__$1;
(statearr_55120_55141[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55110 === (11))){
var state_55109__$1 = state_55109;
var statearr_55122_55142 = state_55109__$1;
(statearr_55122_55142[(2)] = path);

(statearr_55122_55142[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55110 === (9))){
var inst_55080 = (state_55109[(2)]);
var inst_55081 = fluree.db.util.async.throw_err.call(null,inst_55080);
var state_55109__$1 = state_55109;
var statearr_55123_55143 = state_55109__$1;
(statearr_55123_55143[(2)] = inst_55081);

(statearr_55123_55143[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55110 === (5))){
var _ = (function (){var statearr_55124 = state_55109;
(statearr_55124[(4)] = cljs.core.rest.call(null,(state_55109[(4)])));

return statearr_55124;
})();
var state_55109__$1 = state_55109;
var ex55121 = (state_55109__$1[(2)]);
var statearr_55125_55144 = state_55109__$1;
(statearr_55125_55144[(5)] = ex55121);


if((ex55121 instanceof Error)){
var statearr_55126_55145 = state_55109__$1;
(statearr_55126_55145[(1)] = (4));

(statearr_55126_55145[(5)] = null);

} else {
throw ex55121;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55110 === (10))){
var state_55109__$1 = state_55109;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55109__$1,(13),path);
} else {
if((state_val_55110 === (8))){
var inst_55084 = (state_55109[(2)]);
var inst_55085 = fluree.db.util.async.channel_QMARK_.call(null,path);
var state_55109__$1 = (function (){var statearr_55127 = state_55109;
(statearr_55127[(7)] = inst_55084);

return statearr_55127;
})();
if(inst_55085){
var statearr_55128_55146 = state_55109__$1;
(statearr_55128_55146[(1)] = (10));

} else {
var statearr_55129_55147 = state_55109__$1;
(statearr_55129_55147[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2468__auto____0 = (function (){
var statearr_55130 = [null,null,null,null,null,null,null,null,null];
(statearr_55130[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__2468__auto__);

(statearr_55130[(1)] = (1));

return statearr_55130;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2468__auto____1 = (function (state_55109){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_55109);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e55131){var ex__2471__auto__ = e55131;
var statearr_55132_55148 = state_55109;
(statearr_55132_55148[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_55109[(4)]))){
var statearr_55133_55149 = state_55109;
(statearr_55133_55149[(1)] = cljs.core.first.call(null,(state_55109[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55150 = state_55109;
state_55109 = G__55150;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__2468__auto__ = function(state_55109){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2468__auto____1.call(this,state_55109);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_55134 = f__2491__auto__.call(null);
(statearr_55134[(6)] = c__2490__auto__);

return statearr_55134;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_55195){
var state_val_55196 = (state_55195[(1)]);
if((state_val_55196 === (7))){
var state_55195__$1 = state_55195;
var statearr_55197_55226 = state_55195__$1;
(statearr_55197_55226[(2)] = coll);

(statearr_55197_55226[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55196 === (1))){
var state_55195__$1 = state_55195;
var statearr_55198_55227 = state_55195__$1;
(statearr_55198_55227[(2)] = null);

(statearr_55198_55227[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55196 === (4))){
var inst_55151 = (state_55195[(2)]);
var state_55195__$1 = state_55195;
var statearr_55199_55228 = state_55195__$1;
(statearr_55199_55228[(2)] = inst_55151);

(statearr_55199_55228[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55196 === (15))){
var inst_55171 = (state_55195[(7)]);
var inst_55179 = (state_55195[(2)]);
var inst_55180 = fluree.db.dbfunctions.internal.contains_QMARK_.call(null,inst_55171,inst_55179);
var inst_55181 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55182 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55183 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55184 = [inst_55171,inst_55179];
var inst_55185 = (new cljs.core.PersistentVector(null,2,(5),inst_55183,inst_55184,null));
var inst_55186 = ["contains?",inst_55185,inst_55180];
var inst_55187 = cljs.core.PersistentHashMap.fromArrays(inst_55182,inst_55186);
var inst_55188 = [inst_55187,(10)];
var inst_55189 = (new cljs.core.PersistentVector(null,2,(5),inst_55181,inst_55188,null));
var inst_55190 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55189);
var _ = (function (){var statearr_55200 = state_55195;
(statearr_55200[(4)] = cljs.core.rest.call(null,(state_55195[(4)])));

return statearr_55200;
})();
var state_55195__$1 = (function (){var statearr_55201 = state_55195;
(statearr_55201[(8)] = inst_55190);

return statearr_55201;
})();
var statearr_55202_55229 = state_55195__$1;
(statearr_55202_55229[(2)] = inst_55180);

(statearr_55202_55229[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55196 === (13))){
var state_55195__$1 = state_55195;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55195__$1,(16),key);
} else {
if((state_val_55196 === (6))){
var state_55195__$1 = state_55195;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55195__$1,(9),coll);
} else {
if((state_val_55196 === (3))){
var inst_55193 = (state_55195[(2)]);
var state_55195__$1 = state_55195;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55195__$1,inst_55193);
} else {
if((state_val_55196 === (12))){
var inst_55171 = (state_55195[(2)]);
var inst_55172 = fluree.db.util.async.channel_QMARK_.call(null,key);
var state_55195__$1 = (function (){var statearr_55203 = state_55195;
(statearr_55203[(7)] = inst_55171);

return statearr_55203;
})();
if(inst_55172){
var statearr_55204_55230 = state_55195__$1;
(statearr_55204_55230[(1)] = (13));

} else {
var statearr_55205_55231 = state_55195__$1;
(statearr_55205_55231[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55196 === (2))){
var _ = (function (){var statearr_55206 = state_55195;
(statearr_55206[(4)] = cljs.core.cons.call(null,(5),(state_55195[(4)])));

return statearr_55206;
})();
var inst_55157 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_55195__$1 = state_55195;
if(inst_55157){
var statearr_55207_55232 = state_55195__$1;
(statearr_55207_55232[(1)] = (6));

} else {
var statearr_55208_55233 = state_55195__$1;
(statearr_55208_55233[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55196 === (11))){
var inst_55164 = (state_55195[(9)]);
var inst_55168 = cljs.core.flatten.call(null,inst_55164);
var inst_55169 = cljs.core.set.call(null,inst_55168);
var state_55195__$1 = state_55195;
var statearr_55210_55234 = state_55195__$1;
(statearr_55210_55234[(2)] = inst_55169);

(statearr_55210_55234[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55196 === (9))){
var inst_55160 = (state_55195[(2)]);
var inst_55161 = fluree.db.util.async.throw_err.call(null,inst_55160);
var state_55195__$1 = state_55195;
var statearr_55211_55235 = state_55195__$1;
(statearr_55211_55235[(2)] = inst_55161);

(statearr_55211_55235[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55196 === (5))){
var _ = (function (){var statearr_55212 = state_55195;
(statearr_55212[(4)] = cljs.core.rest.call(null,(state_55195[(4)])));

return statearr_55212;
})();
var state_55195__$1 = state_55195;
var ex55209 = (state_55195__$1[(2)]);
var statearr_55213_55236 = state_55195__$1;
(statearr_55213_55236[(5)] = ex55209);


if((ex55209 instanceof Error)){
var statearr_55214_55237 = state_55195__$1;
(statearr_55214_55237[(1)] = (4));

(statearr_55214_55237[(5)] = null);

} else {
throw ex55209;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55196 === (14))){
var state_55195__$1 = state_55195;
var statearr_55215_55238 = state_55195__$1;
(statearr_55215_55238[(2)] = key);

(statearr_55215_55238[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55196 === (16))){
var inst_55175 = (state_55195[(2)]);
var inst_55176 = fluree.db.util.async.throw_err.call(null,inst_55175);
var state_55195__$1 = state_55195;
var statearr_55216_55239 = state_55195__$1;
(statearr_55216_55239[(2)] = inst_55176);

(statearr_55216_55239[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55196 === (10))){
var inst_55164 = (state_55195[(9)]);
var state_55195__$1 = state_55195;
var statearr_55217_55240 = state_55195__$1;
(statearr_55217_55240[(2)] = inst_55164);

(statearr_55217_55240[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55196 === (8))){
var inst_55164 = (state_55195[(9)]);
var inst_55164__$1 = (state_55195[(2)]);
var inst_55165 = cljs.core.set_QMARK_.call(null,inst_55164__$1);
var state_55195__$1 = (function (){var statearr_55218 = state_55195;
(statearr_55218[(9)] = inst_55164__$1);

return statearr_55218;
})();
if(inst_55165){
var statearr_55219_55241 = state_55195__$1;
(statearr_55219_55241[(1)] = (10));

} else {
var statearr_55220_55242 = state_55195__$1;
(statearr_55220_55242[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2468__auto____0 = (function (){
var statearr_55221 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55221[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2468__auto__);

(statearr_55221[(1)] = (1));

return statearr_55221;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2468__auto____1 = (function (state_55195){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_55195);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e55222){var ex__2471__auto__ = e55222;
var statearr_55223_55243 = state_55195;
(statearr_55223_55243[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_55195[(4)]))){
var statearr_55224_55244 = state_55195;
(statearr_55224_55244[(1)] = cljs.core.first.call(null,(state_55195[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55245 = state_55195;
state_55195 = G__55245;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2468__auto__ = function(state_55195){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2468__auto____1.call(this,state_55195);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_55225 = f__2491__auto__.call(null);
(statearr_55225[(6)] = c__2490__auto__);

return statearr_55225;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__4742__auto__ = [];
var len__4736__auto___55310 = arguments.length;
var i__4737__auto___55311 = (0);
while(true){
if((i__4737__auto___55311 < len__4736__auto___55310)){
args__4742__auto__.push((arguments[i__4737__auto___55311]));

var G__55312 = (i__4737__auto___55311 + (1));
i__4737__auto___55311 = G__55312;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_55288){
var state_val_55289 = (state_55288[(1)]);
if((state_val_55289 === (7))){
var inst_55257 = (state_55288[(7)]);
var inst_55264 = cljs.core.first.call(null,inst_55257);
var state_55288__$1 = state_55288;
var statearr_55290_55313 = state_55288__$1;
(statearr_55290_55313[(2)] = inst_55264);

(statearr_55290_55313[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55289 === (1))){
var state_55288__$1 = state_55288;
var statearr_55291_55314 = state_55288__$1;
(statearr_55291_55314[(2)] = null);

(statearr_55291_55314[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55289 === (4))){
var inst_55248 = (state_55288[(2)]);
var state_55288__$1 = state_55288;
var statearr_55292_55315 = state_55288__$1;
(statearr_55292_55315[(2)] = inst_55248);

(statearr_55292_55315[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55289 === (6))){
var inst_55257 = (state_55288[(7)]);
var inst_55256 = (state_55288[(2)]);
var inst_55257__$1 = fluree.db.util.async.throw_err.call(null,inst_55256);
var inst_55258 = cljs.core.count.call(null,inst_55257__$1);
var inst_55259 = cljs.core._EQ_.call(null,(1),inst_55258);
var inst_55260 = cljs.core.first.call(null,inst_55257__$1);
var inst_55261 = cljs.core.coll_QMARK_.call(null,inst_55260);
var inst_55262 = ((inst_55259) && (inst_55261));
var state_55288__$1 = (function (){var statearr_55293 = state_55288;
(statearr_55293[(7)] = inst_55257__$1);

return statearr_55293;
})();
if(cljs.core.truth_(inst_55262)){
var statearr_55294_55316 = state_55288__$1;
(statearr_55294_55316[(1)] = (7));

} else {
var statearr_55295_55317 = state_55288__$1;
(statearr_55295_55317[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55289 === (3))){
var inst_55286 = (state_55288[(2)]);
var state_55288__$1 = state_55288;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55288__$1,inst_55286);
} else {
if((state_val_55289 === (2))){
var _ = (function (){var statearr_55297 = state_55288;
(statearr_55297[(4)] = cljs.core.cons.call(null,(5),(state_55288[(4)])));

return statearr_55297;
})();
var inst_55254 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55288__$1 = state_55288;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55288__$1,(6),inst_55254);
} else {
if((state_val_55289 === (9))){
var inst_55267 = (state_55288[(2)]);
var inst_55268 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.hash_set,inst_55267);
var inst_55269 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55270 = [inst_55267];
var inst_55271 = (new cljs.core.PersistentVector(null,1,(5),inst_55269,inst_55270,null));
var inst_55272 = cljs.core.count.call(null,inst_55271);
var inst_55273 = ((9) + inst_55272);
var inst_55274 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55275 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55276 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55277 = [inst_55267];
var inst_55278 = (new cljs.core.PersistentVector(null,1,(5),inst_55276,inst_55277,null));
var inst_55279 = ["hash-set",inst_55278,inst_55268];
var inst_55280 = cljs.core.PersistentHashMap.fromArrays(inst_55275,inst_55279);
var inst_55281 = [inst_55280,inst_55273];
var inst_55282 = (new cljs.core.PersistentVector(null,2,(5),inst_55274,inst_55281,null));
var inst_55283 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55282);
var _ = (function (){var statearr_55298 = state_55288;
(statearr_55298[(4)] = cljs.core.rest.call(null,(state_55288[(4)])));

return statearr_55298;
})();
var state_55288__$1 = (function (){var statearr_55299 = state_55288;
(statearr_55299[(8)] = inst_55283);

return statearr_55299;
})();
var statearr_55300_55318 = state_55288__$1;
(statearr_55300_55318[(2)] = inst_55268);

(statearr_55300_55318[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55289 === (5))){
var _ = (function (){var statearr_55301 = state_55288;
(statearr_55301[(4)] = cljs.core.rest.call(null,(state_55288[(4)])));

return statearr_55301;
})();
var state_55288__$1 = state_55288;
var ex55296 = (state_55288__$1[(2)]);
var statearr_55302_55319 = state_55288__$1;
(statearr_55302_55319[(5)] = ex55296);


if((ex55296 instanceof Error)){
var statearr_55303_55320 = state_55288__$1;
(statearr_55303_55320[(1)] = (4));

(statearr_55303_55320[(5)] = null);

} else {
throw ex55296;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55289 === (8))){
var inst_55257 = (state_55288[(7)]);
var state_55288__$1 = state_55288;
var statearr_55304_55321 = state_55288__$1;
(statearr_55304_55321[(2)] = inst_55257);

(statearr_55304_55321[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2468__auto____0 = (function (){
var statearr_55305 = [null,null,null,null,null,null,null,null,null];
(statearr_55305[(0)] = fluree$db$dbfunctions$fns$state_machine__2468__auto__);

(statearr_55305[(1)] = (1));

return statearr_55305;
});
var fluree$db$dbfunctions$fns$state_machine__2468__auto____1 = (function (state_55288){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_55288);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e55306){var ex__2471__auto__ = e55306;
var statearr_55307_55322 = state_55288;
(statearr_55307_55322[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_55288[(4)]))){
var statearr_55308_55323 = state_55288;
(statearr_55308_55323[(1)] = cljs.core.first.call(null,(state_55288[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55324 = state_55288;
state_55288 = G__55324;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2468__auto__ = function(state_55288){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2468__auto____1.call(this,state_55288);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_55309 = f__2491__auto__.call(null);
(statearr_55309[(6)] = c__2490__auto__);

return statearr_55309;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq55246){
var G__55247 = cljs.core.first.call(null,seq55246);
var seq55246__$1 = cljs.core.next.call(null,seq55246);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55247,seq55246__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___55374 = arguments.length;
var i__4737__auto___55375 = (0);
while(true){
if((i__4737__auto___55375 < len__4736__auto___55374)){
args__4742__auto__.push((arguments[i__4737__auto___55375]));

var G__55376 = (i__4737__auto___55375 + (1));
i__4737__auto___55375 = G__55376;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_55357){
var state_val_55358 = (state_55357[(1)]);
if((state_val_55358 === (1))){
var state_55357__$1 = state_55357;
var statearr_55359_55377 = state_55357__$1;
(statearr_55359_55377[(2)] = null);

(statearr_55359_55377[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55358 === (2))){
var _ = (function (){var statearr_55360 = state_55357;
(statearr_55360[(4)] = cljs.core.cons.call(null,(5),(state_55357[(4)])));

return statearr_55360;
})();
var inst_55333 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55357__$1 = state_55357;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55357__$1,(6),inst_55333);
} else {
if((state_val_55358 === (3))){
var inst_55355 = (state_55357[(2)]);
var state_55357__$1 = state_55357;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55357__$1,inst_55355);
} else {
if((state_val_55358 === (4))){
var inst_55327 = (state_55357[(2)]);
var state_55357__$1 = state_55357;
var statearr_55362_55378 = state_55357__$1;
(statearr_55362_55378[(2)] = inst_55327);

(statearr_55362_55378[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55358 === (5))){
var _ = (function (){var statearr_55363 = state_55357;
(statearr_55363[(4)] = cljs.core.rest.call(null,(state_55357[(4)])));

return statearr_55363;
})();
var state_55357__$1 = state_55357;
var ex55361 = (state_55357__$1[(2)]);
var statearr_55364_55379 = state_55357__$1;
(statearr_55364_55379[(5)] = ex55361);


if((ex55361 instanceof Error)){
var statearr_55365_55380 = state_55357__$1;
(statearr_55365_55380[(1)] = (4));

(statearr_55365_55380[(5)] = null);

} else {
throw ex55361;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55358 === (6))){
var inst_55335 = (state_55357[(2)]);
var inst_55336 = fluree.db.util.async.throw_err.call(null,inst_55335);
var inst_55337 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._EQ__EQ_,inst_55336);
var inst_55338 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55339 = [inst_55336];
var inst_55340 = (new cljs.core.PersistentVector(null,1,(5),inst_55338,inst_55339,null));
var inst_55341 = cljs.core.count.call(null,inst_55340);
var inst_55342 = ((9) + inst_55341);
var inst_55343 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55344 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55345 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55346 = [inst_55336];
var inst_55347 = (new cljs.core.PersistentVector(null,1,(5),inst_55345,inst_55346,null));
var inst_55348 = ["==",inst_55347,inst_55337];
var inst_55349 = cljs.core.PersistentHashMap.fromArrays(inst_55344,inst_55348);
var inst_55350 = [inst_55349,inst_55342];
var inst_55351 = (new cljs.core.PersistentVector(null,2,(5),inst_55343,inst_55350,null));
var inst_55352 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55351);
var _ = (function (){var statearr_55366 = state_55357;
(statearr_55366[(4)] = cljs.core.rest.call(null,(state_55357[(4)])));

return statearr_55366;
})();
var state_55357__$1 = (function (){var statearr_55367 = state_55357;
(statearr_55367[(7)] = inst_55352);

return statearr_55367;
})();
var statearr_55368_55381 = state_55357__$1;
(statearr_55368_55381[(2)] = inst_55337);

(statearr_55368_55381[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2468__auto____0 = (function (){
var statearr_55369 = [null,null,null,null,null,null,null,null];
(statearr_55369[(0)] = fluree$db$dbfunctions$fns$state_machine__2468__auto__);

(statearr_55369[(1)] = (1));

return statearr_55369;
});
var fluree$db$dbfunctions$fns$state_machine__2468__auto____1 = (function (state_55357){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_55357);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e55370){var ex__2471__auto__ = e55370;
var statearr_55371_55382 = state_55357;
(statearr_55371_55382[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_55357[(4)]))){
var statearr_55372_55383 = state_55357;
(statearr_55372_55383[(1)] = cljs.core.first.call(null,(state_55357[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55384 = state_55357;
state_55357 = G__55384;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2468__auto__ = function(state_55357){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2468__auto____1.call(this,state_55357);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_55373 = f__2491__auto__.call(null);
(statearr_55373[(6)] = c__2490__auto__);

return statearr_55373;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq55325){
var G__55326 = cljs.core.first.call(null,seq55325);
var seq55325__$1 = cljs.core.next.call(null,seq55325);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55326,seq55325__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___55434 = arguments.length;
var i__4737__auto___55435 = (0);
while(true){
if((i__4737__auto___55435 < len__4736__auto___55434)){
args__4742__auto__.push((arguments[i__4737__auto___55435]));

var G__55436 = (i__4737__auto___55435 + (1));
i__4737__auto___55435 = G__55436;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_55417){
var state_val_55418 = (state_55417[(1)]);
if((state_val_55418 === (1))){
var state_55417__$1 = state_55417;
var statearr_55419_55437 = state_55417__$1;
(statearr_55419_55437[(2)] = null);

(statearr_55419_55437[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55418 === (2))){
var _ = (function (){var statearr_55420 = state_55417;
(statearr_55420[(4)] = cljs.core.cons.call(null,(5),(state_55417[(4)])));

return statearr_55420;
})();
var inst_55393 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55417__$1 = state_55417;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55417__$1,(6),inst_55393);
} else {
if((state_val_55418 === (3))){
var inst_55415 = (state_55417[(2)]);
var state_55417__$1 = state_55417;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55417__$1,inst_55415);
} else {
if((state_val_55418 === (4))){
var inst_55387 = (state_55417[(2)]);
var state_55417__$1 = state_55417;
var statearr_55422_55438 = state_55417__$1;
(statearr_55422_55438[(2)] = inst_55387);

(statearr_55422_55438[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55418 === (5))){
var _ = (function (){var statearr_55423 = state_55417;
(statearr_55423[(4)] = cljs.core.rest.call(null,(state_55417[(4)])));

return statearr_55423;
})();
var state_55417__$1 = state_55417;
var ex55421 = (state_55417__$1[(2)]);
var statearr_55424_55439 = state_55417__$1;
(statearr_55424_55439[(5)] = ex55421);


if((ex55421 instanceof Error)){
var statearr_55425_55440 = state_55417__$1;
(statearr_55425_55440[(1)] = (4));

(statearr_55425_55440[(5)] = null);

} else {
throw ex55421;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55418 === (6))){
var inst_55395 = (state_55417[(2)]);
var inst_55396 = fluree.db.util.async.throw_err.call(null,inst_55395);
var inst_55397 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._GT_,inst_55396);
var inst_55398 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55399 = [inst_55396];
var inst_55400 = (new cljs.core.PersistentVector(null,1,(5),inst_55398,inst_55399,null));
var inst_55401 = cljs.core.count.call(null,inst_55400);
var inst_55402 = ((9) + inst_55401);
var inst_55403 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55404 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55405 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55406 = [inst_55396];
var inst_55407 = (new cljs.core.PersistentVector(null,1,(5),inst_55405,inst_55406,null));
var inst_55408 = [">",inst_55407,inst_55397];
var inst_55409 = cljs.core.PersistentHashMap.fromArrays(inst_55404,inst_55408);
var inst_55410 = [inst_55409,inst_55402];
var inst_55411 = (new cljs.core.PersistentVector(null,2,(5),inst_55403,inst_55410,null));
var inst_55412 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55411);
var _ = (function (){var statearr_55426 = state_55417;
(statearr_55426[(4)] = cljs.core.rest.call(null,(state_55417[(4)])));

return statearr_55426;
})();
var state_55417__$1 = (function (){var statearr_55427 = state_55417;
(statearr_55427[(7)] = inst_55412);

return statearr_55427;
})();
var statearr_55428_55441 = state_55417__$1;
(statearr_55428_55441[(2)] = inst_55397);

(statearr_55428_55441[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2468__auto____0 = (function (){
var statearr_55429 = [null,null,null,null,null,null,null,null];
(statearr_55429[(0)] = fluree$db$dbfunctions$fns$state_machine__2468__auto__);

(statearr_55429[(1)] = (1));

return statearr_55429;
});
var fluree$db$dbfunctions$fns$state_machine__2468__auto____1 = (function (state_55417){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_55417);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e55430){var ex__2471__auto__ = e55430;
var statearr_55431_55442 = state_55417;
(statearr_55431_55442[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_55417[(4)]))){
var statearr_55432_55443 = state_55417;
(statearr_55432_55443[(1)] = cljs.core.first.call(null,(state_55417[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55444 = state_55417;
state_55417 = G__55444;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2468__auto__ = function(state_55417){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2468__auto____1.call(this,state_55417);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_55433 = f__2491__auto__.call(null);
(statearr_55433[(6)] = c__2490__auto__);

return statearr_55433;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq55385){
var G__55386 = cljs.core.first.call(null,seq55385);
var seq55385__$1 = cljs.core.next.call(null,seq55385);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55386,seq55385__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___55494 = arguments.length;
var i__4737__auto___55495 = (0);
while(true){
if((i__4737__auto___55495 < len__4736__auto___55494)){
args__4742__auto__.push((arguments[i__4737__auto___55495]));

var G__55496 = (i__4737__auto___55495 + (1));
i__4737__auto___55495 = G__55496;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_55477){
var state_val_55478 = (state_55477[(1)]);
if((state_val_55478 === (1))){
var state_55477__$1 = state_55477;
var statearr_55479_55497 = state_55477__$1;
(statearr_55479_55497[(2)] = null);

(statearr_55479_55497[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55478 === (2))){
var _ = (function (){var statearr_55480 = state_55477;
(statearr_55480[(4)] = cljs.core.cons.call(null,(5),(state_55477[(4)])));

return statearr_55480;
})();
var inst_55453 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55477__$1 = state_55477;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55477__$1,(6),inst_55453);
} else {
if((state_val_55478 === (3))){
var inst_55475 = (state_55477[(2)]);
var state_55477__$1 = state_55477;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55477__$1,inst_55475);
} else {
if((state_val_55478 === (4))){
var inst_55447 = (state_55477[(2)]);
var state_55477__$1 = state_55477;
var statearr_55482_55498 = state_55477__$1;
(statearr_55482_55498[(2)] = inst_55447);

(statearr_55482_55498[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55478 === (5))){
var _ = (function (){var statearr_55483 = state_55477;
(statearr_55483[(4)] = cljs.core.rest.call(null,(state_55477[(4)])));

return statearr_55483;
})();
var state_55477__$1 = state_55477;
var ex55481 = (state_55477__$1[(2)]);
var statearr_55484_55499 = state_55477__$1;
(statearr_55484_55499[(5)] = ex55481);


if((ex55481 instanceof Error)){
var statearr_55485_55500 = state_55477__$1;
(statearr_55485_55500[(1)] = (4));

(statearr_55485_55500[(5)] = null);

} else {
throw ex55481;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55478 === (6))){
var inst_55455 = (state_55477[(2)]);
var inst_55456 = fluree.db.util.async.throw_err.call(null,inst_55455);
var inst_55457 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._LT_,inst_55456);
var inst_55458 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55459 = [inst_55456];
var inst_55460 = (new cljs.core.PersistentVector(null,1,(5),inst_55458,inst_55459,null));
var inst_55461 = cljs.core.count.call(null,inst_55460);
var inst_55462 = ((9) + inst_55461);
var inst_55463 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55464 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55465 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55466 = [inst_55456];
var inst_55467 = (new cljs.core.PersistentVector(null,1,(5),inst_55465,inst_55466,null));
var inst_55468 = ["<",inst_55467,inst_55457];
var inst_55469 = cljs.core.PersistentHashMap.fromArrays(inst_55464,inst_55468);
var inst_55470 = [inst_55469,inst_55462];
var inst_55471 = (new cljs.core.PersistentVector(null,2,(5),inst_55463,inst_55470,null));
var inst_55472 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55471);
var _ = (function (){var statearr_55486 = state_55477;
(statearr_55486[(4)] = cljs.core.rest.call(null,(state_55477[(4)])));

return statearr_55486;
})();
var state_55477__$1 = (function (){var statearr_55487 = state_55477;
(statearr_55487[(7)] = inst_55472);

return statearr_55487;
})();
var statearr_55488_55501 = state_55477__$1;
(statearr_55488_55501[(2)] = inst_55457);

(statearr_55488_55501[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2468__auto____0 = (function (){
var statearr_55489 = [null,null,null,null,null,null,null,null];
(statearr_55489[(0)] = fluree$db$dbfunctions$fns$state_machine__2468__auto__);

(statearr_55489[(1)] = (1));

return statearr_55489;
});
var fluree$db$dbfunctions$fns$state_machine__2468__auto____1 = (function (state_55477){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_55477);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e55490){var ex__2471__auto__ = e55490;
var statearr_55491_55502 = state_55477;
(statearr_55491_55502[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_55477[(4)]))){
var statearr_55492_55503 = state_55477;
(statearr_55492_55503[(1)] = cljs.core.first.call(null,(state_55477[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55504 = state_55477;
state_55477 = G__55504;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2468__auto__ = function(state_55477){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2468__auto____1.call(this,state_55477);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_55493 = f__2491__auto__.call(null);
(statearr_55493[(6)] = c__2490__auto__);

return statearr_55493;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq55445){
var G__55446 = cljs.core.first.call(null,seq55445);
var seq55445__$1 = cljs.core.next.call(null,seq55445);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55446,seq55445__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___55554 = arguments.length;
var i__4737__auto___55555 = (0);
while(true){
if((i__4737__auto___55555 < len__4736__auto___55554)){
args__4742__auto__.push((arguments[i__4737__auto___55555]));

var G__55556 = (i__4737__auto___55555 + (1));
i__4737__auto___55555 = G__55556;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_55537){
var state_val_55538 = (state_55537[(1)]);
if((state_val_55538 === (1))){
var state_55537__$1 = state_55537;
var statearr_55539_55557 = state_55537__$1;
(statearr_55539_55557[(2)] = null);

(statearr_55539_55557[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55538 === (2))){
var _ = (function (){var statearr_55540 = state_55537;
(statearr_55540[(4)] = cljs.core.cons.call(null,(5),(state_55537[(4)])));

return statearr_55540;
})();
var inst_55513 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55537__$1 = state_55537;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55537__$1,(6),inst_55513);
} else {
if((state_val_55538 === (3))){
var inst_55535 = (state_55537[(2)]);
var state_55537__$1 = state_55537;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55537__$1,inst_55535);
} else {
if((state_val_55538 === (4))){
var inst_55507 = (state_55537[(2)]);
var state_55537__$1 = state_55537;
var statearr_55542_55558 = state_55537__$1;
(statearr_55542_55558[(2)] = inst_55507);

(statearr_55542_55558[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55538 === (5))){
var _ = (function (){var statearr_55543 = state_55537;
(statearr_55543[(4)] = cljs.core.rest.call(null,(state_55537[(4)])));

return statearr_55543;
})();
var state_55537__$1 = state_55537;
var ex55541 = (state_55537__$1[(2)]);
var statearr_55544_55559 = state_55537__$1;
(statearr_55544_55559[(5)] = ex55541);


if((ex55541 instanceof Error)){
var statearr_55545_55560 = state_55537__$1;
(statearr_55545_55560[(1)] = (4));

(statearr_55545_55560[(5)] = null);

} else {
throw ex55541;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55538 === (6))){
var inst_55515 = (state_55537[(2)]);
var inst_55516 = fluree.db.util.async.throw_err.call(null,inst_55515);
var inst_55517 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._LT__EQ_,inst_55516);
var inst_55518 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55519 = [inst_55516];
var inst_55520 = (new cljs.core.PersistentVector(null,1,(5),inst_55518,inst_55519,null));
var inst_55521 = cljs.core.count.call(null,inst_55520);
var inst_55522 = ((9) + inst_55521);
var inst_55523 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55524 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55525 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55526 = [inst_55516];
var inst_55527 = (new cljs.core.PersistentVector(null,1,(5),inst_55525,inst_55526,null));
var inst_55528 = ["<=",inst_55527,inst_55517];
var inst_55529 = cljs.core.PersistentHashMap.fromArrays(inst_55524,inst_55528);
var inst_55530 = [inst_55529,inst_55522];
var inst_55531 = (new cljs.core.PersistentVector(null,2,(5),inst_55523,inst_55530,null));
var inst_55532 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55531);
var _ = (function (){var statearr_55546 = state_55537;
(statearr_55546[(4)] = cljs.core.rest.call(null,(state_55537[(4)])));

return statearr_55546;
})();
var state_55537__$1 = (function (){var statearr_55547 = state_55537;
(statearr_55547[(7)] = inst_55532);

return statearr_55547;
})();
var statearr_55548_55561 = state_55537__$1;
(statearr_55548_55561[(2)] = inst_55517);

(statearr_55548_55561[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2468__auto____0 = (function (){
var statearr_55549 = [null,null,null,null,null,null,null,null];
(statearr_55549[(0)] = fluree$db$dbfunctions$fns$state_machine__2468__auto__);

(statearr_55549[(1)] = (1));

return statearr_55549;
});
var fluree$db$dbfunctions$fns$state_machine__2468__auto____1 = (function (state_55537){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_55537);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e55550){var ex__2471__auto__ = e55550;
var statearr_55551_55562 = state_55537;
(statearr_55551_55562[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_55537[(4)]))){
var statearr_55552_55563 = state_55537;
(statearr_55552_55563[(1)] = cljs.core.first.call(null,(state_55537[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55564 = state_55537;
state_55537 = G__55564;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2468__auto__ = function(state_55537){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2468__auto____1.call(this,state_55537);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_55553 = f__2491__auto__.call(null);
(statearr_55553[(6)] = c__2490__auto__);

return statearr_55553;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq55505){
var G__55506 = cljs.core.first.call(null,seq55505);
var seq55505__$1 = cljs.core.next.call(null,seq55505);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55506,seq55505__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___55614 = arguments.length;
var i__4737__auto___55615 = (0);
while(true){
if((i__4737__auto___55615 < len__4736__auto___55614)){
args__4742__auto__.push((arguments[i__4737__auto___55615]));

var G__55616 = (i__4737__auto___55615 + (1));
i__4737__auto___55615 = G__55616;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_55597){
var state_val_55598 = (state_55597[(1)]);
if((state_val_55598 === (1))){
var state_55597__$1 = state_55597;
var statearr_55599_55617 = state_55597__$1;
(statearr_55599_55617[(2)] = null);

(statearr_55599_55617[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55598 === (2))){
var _ = (function (){var statearr_55600 = state_55597;
(statearr_55600[(4)] = cljs.core.cons.call(null,(5),(state_55597[(4)])));

return statearr_55600;
})();
var inst_55573 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55597__$1 = state_55597;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55597__$1,(6),inst_55573);
} else {
if((state_val_55598 === (3))){
var inst_55595 = (state_55597[(2)]);
var state_55597__$1 = state_55597;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55597__$1,inst_55595);
} else {
if((state_val_55598 === (4))){
var inst_55567 = (state_55597[(2)]);
var state_55597__$1 = state_55597;
var statearr_55602_55618 = state_55597__$1;
(statearr_55602_55618[(2)] = inst_55567);

(statearr_55602_55618[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55598 === (5))){
var _ = (function (){var statearr_55603 = state_55597;
(statearr_55603[(4)] = cljs.core.rest.call(null,(state_55597[(4)])));

return statearr_55603;
})();
var state_55597__$1 = state_55597;
var ex55601 = (state_55597__$1[(2)]);
var statearr_55604_55619 = state_55597__$1;
(statearr_55604_55619[(5)] = ex55601);


if((ex55601 instanceof Error)){
var statearr_55605_55620 = state_55597__$1;
(statearr_55605_55620[(1)] = (4));

(statearr_55605_55620[(5)] = null);

} else {
throw ex55601;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55598 === (6))){
var inst_55575 = (state_55597[(2)]);
var inst_55576 = fluree.db.util.async.throw_err.call(null,inst_55575);
var inst_55577 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._GT__EQ_,inst_55576);
var inst_55578 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55579 = [inst_55576];
var inst_55580 = (new cljs.core.PersistentVector(null,1,(5),inst_55578,inst_55579,null));
var inst_55581 = cljs.core.count.call(null,inst_55580);
var inst_55582 = ((9) + inst_55581);
var inst_55583 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55584 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55585 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55586 = [inst_55576];
var inst_55587 = (new cljs.core.PersistentVector(null,1,(5),inst_55585,inst_55586,null));
var inst_55588 = [">=",inst_55587,inst_55577];
var inst_55589 = cljs.core.PersistentHashMap.fromArrays(inst_55584,inst_55588);
var inst_55590 = [inst_55589,inst_55582];
var inst_55591 = (new cljs.core.PersistentVector(null,2,(5),inst_55583,inst_55590,null));
var inst_55592 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55591);
var _ = (function (){var statearr_55606 = state_55597;
(statearr_55606[(4)] = cljs.core.rest.call(null,(state_55597[(4)])));

return statearr_55606;
})();
var state_55597__$1 = (function (){var statearr_55607 = state_55597;
(statearr_55607[(7)] = inst_55592);

return statearr_55607;
})();
var statearr_55608_55621 = state_55597__$1;
(statearr_55608_55621[(2)] = inst_55577);

(statearr_55608_55621[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2468__auto____0 = (function (){
var statearr_55609 = [null,null,null,null,null,null,null,null];
(statearr_55609[(0)] = fluree$db$dbfunctions$fns$state_machine__2468__auto__);

(statearr_55609[(1)] = (1));

return statearr_55609;
});
var fluree$db$dbfunctions$fns$state_machine__2468__auto____1 = (function (state_55597){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_55597);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e55610){var ex__2471__auto__ = e55610;
var statearr_55611_55622 = state_55597;
(statearr_55611_55622[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_55597[(4)]))){
var statearr_55612_55623 = state_55597;
(statearr_55612_55623[(1)] = cljs.core.first.call(null,(state_55597[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55624 = state_55597;
state_55597 = G__55624;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2468__auto__ = function(state_55597){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2468__auto____1.call(this,state_55597);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_55613 = f__2491__auto__.call(null);
(statearr_55613[(6)] = c__2490__auto__);

return statearr_55613;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq55565){
var G__55566 = cljs.core.first.call(null,seq55565);
var seq55565__$1 = cljs.core.next.call(null,seq55565);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55566,seq55565__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__4742__auto__ = [];
var len__4736__auto___55674 = arguments.length;
var i__4737__auto___55675 = (0);
while(true){
if((i__4737__auto___55675 < len__4736__auto___55674)){
args__4742__auto__.push((arguments[i__4737__auto___55675]));

var G__55676 = (i__4737__auto___55675 + (1));
i__4737__auto___55675 = G__55676;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_55657){
var state_val_55658 = (state_55657[(1)]);
if((state_val_55658 === (1))){
var state_55657__$1 = state_55657;
var statearr_55659_55677 = state_55657__$1;
(statearr_55659_55677[(2)] = null);

(statearr_55659_55677[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55658 === (2))){
var _ = (function (){var statearr_55660 = state_55657;
(statearr_55660[(4)] = cljs.core.cons.call(null,(5),(state_55657[(4)])));

return statearr_55660;
})();
var inst_55633 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55657__$1 = state_55657;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55657__$1,(6),inst_55633);
} else {
if((state_val_55658 === (3))){
var inst_55655 = (state_55657[(2)]);
var state_55657__$1 = state_55657;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55657__$1,inst_55655);
} else {
if((state_val_55658 === (4))){
var inst_55627 = (state_55657[(2)]);
var state_55657__$1 = state_55657;
var statearr_55662_55678 = state_55657__$1;
(statearr_55662_55678[(2)] = inst_55627);

(statearr_55662_55678[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55658 === (5))){
var _ = (function (){var statearr_55663 = state_55657;
(statearr_55663[(4)] = cljs.core.rest.call(null,(state_55657[(4)])));

return statearr_55663;
})();
var state_55657__$1 = state_55657;
var ex55661 = (state_55657__$1[(2)]);
var statearr_55664_55679 = state_55657__$1;
(statearr_55664_55679[(5)] = ex55661);


if((ex55661 instanceof Error)){
var statearr_55665_55680 = state_55657__$1;
(statearr_55665_55680[(1)] = (4));

(statearr_55665_55680[(5)] = null);

} else {
throw ex55661;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55658 === (6))){
var inst_55635 = (state_55657[(2)]);
var inst_55636 = fluree.db.util.async.throw_err.call(null,inst_55635);
var inst_55637 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.max,inst_55636);
var inst_55638 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55639 = [inst_55636];
var inst_55640 = (new cljs.core.PersistentVector(null,1,(5),inst_55638,inst_55639,null));
var inst_55641 = cljs.core.count.call(null,inst_55640);
var inst_55642 = ((9) + inst_55641);
var inst_55643 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55644 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55645 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55646 = [inst_55636];
var inst_55647 = (new cljs.core.PersistentVector(null,1,(5),inst_55645,inst_55646,null));
var inst_55648 = ["max",inst_55647,inst_55637];
var inst_55649 = cljs.core.PersistentHashMap.fromArrays(inst_55644,inst_55648);
var inst_55650 = [inst_55649,inst_55642];
var inst_55651 = (new cljs.core.PersistentVector(null,2,(5),inst_55643,inst_55650,null));
var inst_55652 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55651);
var _ = (function (){var statearr_55666 = state_55657;
(statearr_55666[(4)] = cljs.core.rest.call(null,(state_55657[(4)])));

return statearr_55666;
})();
var state_55657__$1 = (function (){var statearr_55667 = state_55657;
(statearr_55667[(7)] = inst_55652);

return statearr_55667;
})();
var statearr_55668_55681 = state_55657__$1;
(statearr_55668_55681[(2)] = inst_55637);

(statearr_55668_55681[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2468__auto____0 = (function (){
var statearr_55669 = [null,null,null,null,null,null,null,null];
(statearr_55669[(0)] = fluree$db$dbfunctions$fns$state_machine__2468__auto__);

(statearr_55669[(1)] = (1));

return statearr_55669;
});
var fluree$db$dbfunctions$fns$state_machine__2468__auto____1 = (function (state_55657){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_55657);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e55670){var ex__2471__auto__ = e55670;
var statearr_55671_55682 = state_55657;
(statearr_55671_55682[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_55657[(4)]))){
var statearr_55672_55683 = state_55657;
(statearr_55672_55683[(1)] = cljs.core.first.call(null,(state_55657[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55684 = state_55657;
state_55657 = G__55684;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2468__auto__ = function(state_55657){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2468__auto____1.call(this,state_55657);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_55673 = f__2491__auto__.call(null);
(statearr_55673[(6)] = c__2490__auto__);

return statearr_55673;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq55625){
var G__55626 = cljs.core.first.call(null,seq55625);
var seq55625__$1 = cljs.core.next.call(null,seq55625);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55626,seq55625__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__4742__auto__ = [];
var len__4736__auto___55733 = arguments.length;
var i__4737__auto___55734 = (0);
while(true){
if((i__4737__auto___55734 < len__4736__auto___55733)){
args__4742__auto__.push((arguments[i__4737__auto___55734]));

var G__55735 = (i__4737__auto___55734 + (1));
i__4737__auto___55734 = G__55735;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_55716){
var state_val_55717 = (state_55716[(1)]);
if((state_val_55717 === (1))){
var state_55716__$1 = state_55716;
var statearr_55718_55736 = state_55716__$1;
(statearr_55718_55736[(2)] = null);

(statearr_55718_55736[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55717 === (2))){
var _ = (function (){var statearr_55719 = state_55716;
(statearr_55719[(4)] = cljs.core.cons.call(null,(5),(state_55716[(4)])));

return statearr_55719;
})();
var inst_55693 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55716__$1 = state_55716;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55716__$1,(6),inst_55693);
} else {
if((state_val_55717 === (3))){
var inst_55714 = (state_55716[(2)]);
var state_55716__$1 = state_55716;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55716__$1,inst_55714);
} else {
if((state_val_55717 === (4))){
var inst_55687 = (state_55716[(2)]);
var state_55716__$1 = state_55716;
var statearr_55721_55737 = state_55716__$1;
(statearr_55721_55737[(2)] = inst_55687);

(statearr_55721_55737[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55717 === (5))){
var _ = (function (){var statearr_55722 = state_55716;
(statearr_55722[(4)] = cljs.core.rest.call(null,(state_55716[(4)])));

return statearr_55722;
})();
var state_55716__$1 = state_55716;
var ex55720 = (state_55716__$1[(2)]);
var statearr_55723_55738 = state_55716__$1;
(statearr_55723_55738[(5)] = ex55720);


if((ex55720 instanceof Error)){
var statearr_55724_55739 = state_55716__$1;
(statearr_55724_55739[(1)] = (4));

(statearr_55724_55739[(5)] = null);

} else {
throw ex55720;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55717 === (6))){
var inst_55695 = (state_55716[(2)]);
var inst_55696 = fluree.db.util.async.throw_err.call(null,inst_55695);
var inst_55697 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.min,inst_55696);
var inst_55698 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55699 = [inst_55696];
var inst_55700 = (new cljs.core.PersistentVector(null,1,(5),inst_55698,inst_55699,null));
var inst_55701 = cljs.core.count.call(null,inst_55700);
var inst_55702 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55703 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55704 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55705 = [inst_55696];
var inst_55706 = (new cljs.core.PersistentVector(null,1,(5),inst_55704,inst_55705,null));
var inst_55707 = ["min",inst_55706,inst_55697];
var inst_55708 = cljs.core.PersistentHashMap.fromArrays(inst_55703,inst_55707);
var inst_55709 = [inst_55708,inst_55701];
var inst_55710 = (new cljs.core.PersistentVector(null,2,(5),inst_55702,inst_55709,null));
var inst_55711 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55710);
var _ = (function (){var statearr_55725 = state_55716;
(statearr_55725[(4)] = cljs.core.rest.call(null,(state_55716[(4)])));

return statearr_55725;
})();
var state_55716__$1 = (function (){var statearr_55726 = state_55716;
(statearr_55726[(7)] = inst_55711);

return statearr_55726;
})();
var statearr_55727_55740 = state_55716__$1;
(statearr_55727_55740[(2)] = inst_55697);

(statearr_55727_55740[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2468__auto____0 = (function (){
var statearr_55728 = [null,null,null,null,null,null,null,null];
(statearr_55728[(0)] = fluree$db$dbfunctions$fns$state_machine__2468__auto__);

(statearr_55728[(1)] = (1));

return statearr_55728;
});
var fluree$db$dbfunctions$fns$state_machine__2468__auto____1 = (function (state_55716){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_55716);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e55729){var ex__2471__auto__ = e55729;
var statearr_55730_55741 = state_55716;
(statearr_55730_55741[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_55716[(4)]))){
var statearr_55731_55742 = state_55716;
(statearr_55731_55742[(1)] = cljs.core.first.call(null,(state_55716[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55743 = state_55716;
state_55716 = G__55743;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2468__auto__ = function(state_55716){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2468__auto____1.call(this,state_55716);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_55732 = f__2491__auto__.call(null);
(statearr_55732[(6)] = c__2490__auto__);

return statearr_55732;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq55685){
var G__55686 = cljs.core.first.call(null,seq55685);
var seq55685__$1 = cljs.core.next.call(null,seq55685);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55686,seq55685__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__55745 = arguments.length;
switch (G__55745) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_55790){
var state_val_55791 = (state_55790[(1)]);
if((state_val_55791 === (7))){
var state_55790__$1 = state_55790;
var statearr_55792_55929 = state_55790__$1;
(statearr_55792_55929[(2)] = query_map);

(statearr_55792_55929[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55791 === (1))){
var state_55790__$1 = state_55790;
var statearr_55793_55930 = state_55790__$1;
(statearr_55793_55930[(2)] = null);

(statearr_55793_55930[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55791 === (4))){
var inst_55746 = (state_55790[(2)]);
var state_55790__$1 = state_55790;
var statearr_55794_55931 = state_55790__$1;
(statearr_55794_55931[(2)] = inst_55746);

(statearr_55794_55931[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55791 === (13))){
var inst_55768 = (state_55790[(7)]);
var inst_55772 = (state_55790[(2)]);
var inst_55773 = fluree.db.util.async.throw_err.call(null,inst_55772);
var inst_55774 = cljs.core.nth.call(null,inst_55773,(0),null);
var inst_55775 = cljs.core.nth.call(null,inst_55773,(1),null);
var inst_55776 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55777 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55778 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55779 = [inst_55768];
var inst_55780 = (new cljs.core.PersistentVector(null,1,(5),inst_55778,inst_55779,null));
var inst_55781 = ["query",inst_55780,inst_55774];
var inst_55782 = cljs.core.PersistentHashMap.fromArrays(inst_55777,inst_55781);
var inst_55783 = [inst_55782,inst_55775];
var inst_55784 = (new cljs.core.PersistentVector(null,2,(5),inst_55776,inst_55783,null));
var inst_55785 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55784);
var _ = (function (){var statearr_55795 = state_55790;
(statearr_55795[(4)] = cljs.core.rest.call(null,(state_55790[(4)])));

return statearr_55795;
})();
var state_55790__$1 = (function (){var statearr_55796 = state_55790;
(statearr_55796[(8)] = inst_55785);

return statearr_55796;
})();
var statearr_55797_55932 = state_55790__$1;
(statearr_55797_55932[(2)] = inst_55774);

(statearr_55797_55932[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55791 === (6))){
var state_55790__$1 = state_55790;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55790__$1,(9),query_map);
} else {
if((state_val_55791 === (3))){
var inst_55788 = (state_55790[(2)]);
var state_55790__$1 = state_55790;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55790__$1,inst_55788);
} else {
if((state_val_55791 === (12))){
var inst_55768 = (state_55790[(7)]);
var inst_55768__$1 = (state_55790[(2)]);
var inst_55769 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55770 = fluree.db.dbfunctions.internal.query.call(null,inst_55769,inst_55768__$1);
var state_55790__$1 = (function (){var statearr_55798 = state_55790;
(statearr_55798[(7)] = inst_55768__$1);

return statearr_55798;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55790__$1,(13),inst_55770);
} else {
if((state_val_55791 === (2))){
var _ = (function (){var statearr_55799 = state_55790;
(statearr_55799[(4)] = cljs.core.cons.call(null,(5),(state_55790[(4)])));

return statearr_55799;
})();
var inst_55755 = fluree.db.util.async.channel_QMARK_.call(null,query_map);
var state_55790__$1 = state_55790;
if(inst_55755){
var statearr_55800_55933 = state_55790__$1;
(statearr_55800_55933[(1)] = (6));

} else {
var statearr_55801_55934 = state_55790__$1;
(statearr_55801_55934[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55791 === (11))){
var inst_55762 = (state_55790[(9)]);
var state_55790__$1 = state_55790;
var statearr_55803_55935 = state_55790__$1;
(statearr_55803_55935[(2)] = inst_55762);

(statearr_55803_55935[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55791 === (9))){
var inst_55758 = (state_55790[(2)]);
var inst_55759 = fluree.db.util.async.throw_err.call(null,inst_55758);
var state_55790__$1 = state_55790;
var statearr_55804_55936 = state_55790__$1;
(statearr_55804_55936[(2)] = inst_55759);

(statearr_55804_55936[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55791 === (5))){
var _ = (function (){var statearr_55805 = state_55790;
(statearr_55805[(4)] = cljs.core.rest.call(null,(state_55790[(4)])));

return statearr_55805;
})();
var state_55790__$1 = state_55790;
var ex55802 = (state_55790__$1[(2)]);
var statearr_55806_55937 = state_55790__$1;
(statearr_55806_55937[(5)] = ex55802);


if((ex55802 instanceof Error)){
var statearr_55807_55938 = state_55790__$1;
(statearr_55807_55938[(1)] = (4));

(statearr_55807_55938[(5)] = null);

} else {
throw ex55802;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55791 === (10))){
var inst_55762 = (state_55790[(9)]);
var inst_55765 = fluree.db.util.json.parse.call(null,inst_55762);
var state_55790__$1 = state_55790;
var statearr_55808_55939 = state_55790__$1;
(statearr_55808_55939[(2)] = inst_55765);

(statearr_55808_55939[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55791 === (8))){
var inst_55762 = (state_55790[(9)]);
var inst_55762__$1 = (state_55790[(2)]);
var inst_55763 = typeof inst_55762__$1 === 'string';
var state_55790__$1 = (function (){var statearr_55809 = state_55790;
(statearr_55809[(9)] = inst_55762__$1);

return statearr_55809;
})();
if(cljs.core.truth_(inst_55763)){
var statearr_55810_55940 = state_55790__$1;
(statearr_55810_55940[(1)] = (10));

} else {
var statearr_55811_55941 = state_55790__$1;
(statearr_55811_55941[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2468__auto____0 = (function (){
var statearr_55812 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55812[(0)] = fluree$db$dbfunctions$fns$state_machine__2468__auto__);

(statearr_55812[(1)] = (1));

return statearr_55812;
});
var fluree$db$dbfunctions$fns$state_machine__2468__auto____1 = (function (state_55790){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_55790);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e55813){var ex__2471__auto__ = e55813;
var statearr_55814_55942 = state_55790;
(statearr_55814_55942[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_55790[(4)]))){
var statearr_55815_55943 = state_55790;
(statearr_55815_55943[(1)] = cljs.core.first.call(null,(state_55790[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55944 = state_55790;
state_55790 = G__55944;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2468__auto__ = function(state_55790){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2468__auto____1.call(this,state_55790);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_55816 = f__2491__auto__.call(null);
(statearr_55816[(6)] = c__2490__auto__);

return statearr_55816;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_55887){
var state_val_55888 = (state_55887[(1)]);
if((state_val_55888 === (7))){
var state_55887__$1 = state_55887;
var statearr_55889_55945 = state_55887__$1;
(statearr_55889_55945[(2)] = select);

(statearr_55889_55945[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55888 === (20))){
var inst_55857 = (state_55887[(2)]);
var inst_55858 = fluree.db.util.async.channel_QMARK_.call(null,limit);
var state_55887__$1 = (function (){var statearr_55890 = state_55887;
(statearr_55890[(7)] = inst_55857);

return statearr_55890;
})();
if(inst_55858){
var statearr_55891_55946 = state_55887__$1;
(statearr_55891_55946[(1)] = (22));

} else {
var statearr_55892_55947 = state_55887__$1;
(statearr_55892_55947[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55888 === (1))){
var state_55887__$1 = state_55887;
var statearr_55893_55948 = state_55887__$1;
(statearr_55893_55948[(2)] = null);

(statearr_55893_55948[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55888 === (24))){
var inst_55841 = (state_55887[(8)]);
var inst_55857 = (state_55887[(7)]);
var inst_55833 = (state_55887[(9)]);
var inst_55849 = (state_55887[(10)]);
var inst_55865 = (state_55887[(2)]);
var inst_55866 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55867 = fluree.db.dbfunctions.internal.query.call(null,inst_55866,inst_55833,inst_55841,inst_55849,inst_55857,inst_55865);
var state_55887__$1 = state_55887;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55887__$1,(26),inst_55867);
} else {
if((state_val_55888 === (4))){
var inst_55817 = (state_55887[(2)]);
var state_55887__$1 = state_55887;
var statearr_55894_55949 = state_55887__$1;
(statearr_55894_55949[(2)] = inst_55817);

(statearr_55894_55949[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55888 === (15))){
var state_55887__$1 = state_55887;
var statearr_55895_55950 = state_55887__$1;
(statearr_55895_55950[(2)] = where);

(statearr_55895_55950[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55888 === (21))){
var inst_55853 = (state_55887[(2)]);
var inst_55854 = fluree.db.util.async.throw_err.call(null,inst_55853);
var state_55887__$1 = state_55887;
var statearr_55896_55951 = state_55887__$1;
(statearr_55896_55951[(2)] = inst_55854);

(statearr_55896_55951[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55888 === (13))){
var inst_55837 = (state_55887[(2)]);
var inst_55838 = fluree.db.util.async.throw_err.call(null,inst_55837);
var state_55887__$1 = state_55887;
var statearr_55897_55952 = state_55887__$1;
(statearr_55897_55952[(2)] = inst_55838);

(statearr_55897_55952[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55888 === (22))){
var state_55887__$1 = state_55887;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55887__$1,(25),limit);
} else {
if((state_val_55888 === (6))){
var state_55887__$1 = state_55887;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55887__$1,(9),select);
} else {
if((state_val_55888 === (25))){
var inst_55861 = (state_55887[(2)]);
var inst_55862 = fluree.db.util.async.throw_err.call(null,inst_55861);
var state_55887__$1 = state_55887;
var statearr_55898_55953 = state_55887__$1;
(statearr_55898_55953[(2)] = inst_55862);

(statearr_55898_55953[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55888 === (17))){
var inst_55845 = (state_55887[(2)]);
var inst_55846 = fluree.db.util.async.throw_err.call(null,inst_55845);
var state_55887__$1 = state_55887;
var statearr_55899_55954 = state_55887__$1;
(statearr_55899_55954[(2)] = inst_55846);

(statearr_55899_55954[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55888 === (3))){
var inst_55885 = (state_55887[(2)]);
var state_55887__$1 = state_55887;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55887__$1,inst_55885);
} else {
if((state_val_55888 === (12))){
var inst_55841 = (state_55887[(2)]);
var inst_55842 = fluree.db.util.async.channel_QMARK_.call(null,where);
var state_55887__$1 = (function (){var statearr_55900 = state_55887;
(statearr_55900[(8)] = inst_55841);

return statearr_55900;
})();
if(inst_55842){
var statearr_55901_55955 = state_55887__$1;
(statearr_55901_55955[(1)] = (14));

} else {
var statearr_55902_55956 = state_55887__$1;
(statearr_55902_55956[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55888 === (2))){
var _ = (function (){var statearr_55903 = state_55887;
(statearr_55903[(4)] = cljs.core.cons.call(null,(5),(state_55887[(4)])));

return statearr_55903;
})();
var inst_55826 = fluree.db.util.async.channel_QMARK_.call(null,select);
var state_55887__$1 = state_55887;
if(inst_55826){
var statearr_55904_55957 = state_55887__$1;
(statearr_55904_55957[(1)] = (6));

} else {
var statearr_55905_55958 = state_55887__$1;
(statearr_55905_55958[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55888 === (23))){
var state_55887__$1 = state_55887;
var statearr_55906_55959 = state_55887__$1;
(statearr_55906_55959[(2)] = limit);

(statearr_55906_55959[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55888 === (19))){
var state_55887__$1 = state_55887;
var statearr_55907_55960 = state_55887__$1;
(statearr_55907_55960[(2)] = block);

(statearr_55907_55960[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55888 === (11))){
var state_55887__$1 = state_55887;
var statearr_55909_55961 = state_55887__$1;
(statearr_55909_55961[(2)] = from);

(statearr_55909_55961[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55888 === (9))){
var inst_55829 = (state_55887[(2)]);
var inst_55830 = fluree.db.util.async.throw_err.call(null,inst_55829);
var state_55887__$1 = state_55887;
var statearr_55910_55962 = state_55887__$1;
(statearr_55910_55962[(2)] = inst_55830);

(statearr_55910_55962[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55888 === (5))){
var _ = (function (){var statearr_55911 = state_55887;
(statearr_55911[(4)] = cljs.core.rest.call(null,(state_55887[(4)])));

return statearr_55911;
})();
var state_55887__$1 = state_55887;
var ex55908 = (state_55887__$1[(2)]);
var statearr_55912_55963 = state_55887__$1;
(statearr_55912_55963[(5)] = ex55908);


if((ex55908 instanceof Error)){
var statearr_55913_55964 = state_55887__$1;
(statearr_55913_55964[(1)] = (4));

(statearr_55913_55964[(5)] = null);

} else {
throw ex55908;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55888 === (14))){
var state_55887__$1 = state_55887;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55887__$1,(17),where);
} else {
if((state_val_55888 === (26))){
var inst_55841 = (state_55887[(8)]);
var inst_55857 = (state_55887[(7)]);
var inst_55833 = (state_55887[(9)]);
var inst_55849 = (state_55887[(10)]);
var inst_55869 = (state_55887[(2)]);
var inst_55870 = fluree.db.util.async.throw_err.call(null,inst_55869);
var inst_55871 = cljs.core.nth.call(null,inst_55870,(0),null);
var inst_55872 = cljs.core.nth.call(null,inst_55870,(1),null);
var inst_55873 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55874 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55875 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55876 = [inst_55833,inst_55841,inst_55849,inst_55857];
var inst_55877 = (new cljs.core.PersistentVector(null,4,(5),inst_55875,inst_55876,null));
var inst_55878 = ["query",inst_55877,inst_55871];
var inst_55879 = cljs.core.PersistentHashMap.fromArrays(inst_55874,inst_55878);
var inst_55880 = [inst_55879,inst_55872];
var inst_55881 = (new cljs.core.PersistentVector(null,2,(5),inst_55873,inst_55880,null));
var inst_55882 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55881);
var _ = (function (){var statearr_55914 = state_55887;
(statearr_55914[(4)] = cljs.core.rest.call(null,(state_55887[(4)])));

return statearr_55914;
})();
var state_55887__$1 = (function (){var statearr_55915 = state_55887;
(statearr_55915[(11)] = inst_55882);

return statearr_55915;
})();
var statearr_55916_55965 = state_55887__$1;
(statearr_55916_55965[(2)] = inst_55871);

(statearr_55916_55965[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55888 === (16))){
var inst_55849 = (state_55887[(2)]);
var inst_55850 = fluree.db.util.async.channel_QMARK_.call(null,block);
var state_55887__$1 = (function (){var statearr_55917 = state_55887;
(statearr_55917[(10)] = inst_55849);

return statearr_55917;
})();
if(inst_55850){
var statearr_55918_55966 = state_55887__$1;
(statearr_55918_55966[(1)] = (18));

} else {
var statearr_55919_55967 = state_55887__$1;
(statearr_55919_55967[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55888 === (10))){
var state_55887__$1 = state_55887;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55887__$1,(13),from);
} else {
if((state_val_55888 === (18))){
var state_55887__$1 = state_55887;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55887__$1,(21),block);
} else {
if((state_val_55888 === (8))){
var inst_55833 = (state_55887[(2)]);
var inst_55834 = fluree.db.util.async.channel_QMARK_.call(null,from);
var state_55887__$1 = (function (){var statearr_55920 = state_55887;
(statearr_55920[(9)] = inst_55833);

return statearr_55920;
})();
if(inst_55834){
var statearr_55921_55968 = state_55887__$1;
(statearr_55921_55968[(1)] = (10));

} else {
var statearr_55922_55969 = state_55887__$1;
(statearr_55922_55969[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2468__auto____0 = (function (){
var statearr_55923 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55923[(0)] = fluree$db$dbfunctions$fns$state_machine__2468__auto__);

(statearr_55923[(1)] = (1));

return statearr_55923;
});
var fluree$db$dbfunctions$fns$state_machine__2468__auto____1 = (function (state_55887){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_55887);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e55924){var ex__2471__auto__ = e55924;
var statearr_55925_55970 = state_55887;
(statearr_55925_55970[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_55887[(4)]))){
var statearr_55926_55971 = state_55887;
(statearr_55926_55971[(1)] = cljs.core.first.call(null,(state_55887[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55972 = state_55887;
state_55887 = G__55972;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2468__auto__ = function(state_55887){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2468__auto____1.call(this,state_55887);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_55927 = f__2491__auto__.call(null);
(statearr_55927[(6)] = c__2490__auto__);

return statearr_55927;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_56028){
var state_val_56029 = (state_56028[(1)]);
if((state_val_56029 === (7))){
var state_56028__$1 = state_56028;
var statearr_56030_56061 = state_56028__$1;
(statearr_56030_56061[(2)] = startSubject);

(statearr_56030_56061[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56029 === (1))){
var state_56028__$1 = state_56028;
var statearr_56031_56062 = state_56028__$1;
(statearr_56031_56062[(2)] = null);

(statearr_56031_56062[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56029 === (4))){
var inst_55973 = (state_56028[(2)]);
var state_56028__$1 = state_56028;
var statearr_56032_56063 = state_56028__$1;
(statearr_56032_56063[(2)] = inst_55973);

(statearr_56032_56063[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56029 === (15))){
var inst_56005 = (state_56028[(2)]);
var inst_56006 = fluree.db.util.async.throw_err.call(null,inst_56005);
var inst_56007 = cljs.core.nth.call(null,inst_56006,(0),null);
var inst_56008 = cljs.core.nth.call(null,inst_56006,(1),null);
var inst_56009 = cljs.core.empty_QMARK_.call(null,inst_56007);
var state_56028__$1 = (function (){var statearr_56033 = state_56028;
(statearr_56033[(7)] = inst_56008);

return statearr_56033;
})();
if(inst_56009){
var statearr_56034_56064 = state_56028__$1;
(statearr_56034_56064[(1)] = (16));

} else {
var statearr_56035_56065 = state_56028__$1;
(statearr_56035_56065[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56029 === (13))){
var inst_55993 = (state_56028[(8)]);
var inst_56001 = (state_56028[(9)]);
var inst_55989 = (state_56028[(10)]);
var inst_56001__$1 = (state_56028[(2)]);
var inst_56002 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56003 = fluree.db.dbfunctions.internal.relationship_QMARK_.call(null,inst_56002,inst_55989,inst_55993,inst_56001__$1);
var state_56028__$1 = (function (){var statearr_56036 = state_56028;
(statearr_56036[(9)] = inst_56001__$1);

return statearr_56036;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56028__$1,(15),inst_56003);
} else {
if((state_val_56029 === (6))){
var state_56028__$1 = state_56028;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56028__$1,(9),startSubject);
} else {
if((state_val_56029 === (17))){
var state_56028__$1 = state_56028;
var statearr_56037_56066 = state_56028__$1;
(statearr_56037_56066[(2)] = true);

(statearr_56037_56066[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56029 === (3))){
var inst_56026 = (state_56028[(2)]);
var state_56028__$1 = state_56028;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56028__$1,inst_56026);
} else {
if((state_val_56029 === (12))){
var state_56028__$1 = state_56028;
var statearr_56038_56067 = state_56028__$1;
(statearr_56038_56067[(2)] = endSubject);

(statearr_56038_56067[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56029 === (2))){
var _ = (function (){var statearr_56039 = state_56028;
(statearr_56039[(4)] = cljs.core.cons.call(null,(5),(state_56028[(4)])));

return statearr_56039;
})();
var inst_55982 = fluree.db.util.async.channel_QMARK_.call(null,startSubject);
var state_56028__$1 = state_56028;
if(inst_55982){
var statearr_56040_56068 = state_56028__$1;
(statearr_56040_56068[(1)] = (6));

} else {
var statearr_56041_56069 = state_56028__$1;
(statearr_56041_56069[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56029 === (11))){
var state_56028__$1 = state_56028;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56028__$1,(14),endSubject);
} else {
if((state_val_56029 === (9))){
var inst_55985 = (state_56028[(2)]);
var inst_55986 = fluree.db.util.async.throw_err.call(null,inst_55985);
var state_56028__$1 = state_56028;
var statearr_56043_56070 = state_56028__$1;
(statearr_56043_56070[(2)] = inst_55986);

(statearr_56043_56070[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56029 === (5))){
var _ = (function (){var statearr_56044 = state_56028;
(statearr_56044[(4)] = cljs.core.rest.call(null,(state_56028[(4)])));

return statearr_56044;
})();
var state_56028__$1 = state_56028;
var ex56042 = (state_56028__$1[(2)]);
var statearr_56045_56071 = state_56028__$1;
(statearr_56045_56071[(5)] = ex56042);


if((ex56042 instanceof Error)){
var statearr_56046_56072 = state_56028__$1;
(statearr_56046_56072[(1)] = (4));

(statearr_56046_56072[(5)] = null);

} else {
throw ex56042;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56029 === (14))){
var inst_55997 = (state_56028[(2)]);
var inst_55998 = fluree.db.util.async.throw_err.call(null,inst_55997);
var state_56028__$1 = state_56028;
var statearr_56047_56073 = state_56028__$1;
(statearr_56047_56073[(2)] = inst_55998);

(statearr_56047_56073[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56029 === (16))){
var state_56028__$1 = state_56028;
var statearr_56048_56074 = state_56028__$1;
(statearr_56048_56074[(2)] = false);

(statearr_56048_56074[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56029 === (10))){
var inst_55992 = (state_56028[(2)]);
var inst_55993 = fluree.db.util.async.throw_err.call(null,inst_55992);
var inst_55994 = fluree.db.util.async.channel_QMARK_.call(null,endSubject);
var state_56028__$1 = (function (){var statearr_56049 = state_56028;
(statearr_56049[(8)] = inst_55993);

return statearr_56049;
})();
if(inst_55994){
var statearr_56050_56075 = state_56028__$1;
(statearr_56050_56075[(1)] = (11));

} else {
var statearr_56051_56076 = state_56028__$1;
(statearr_56051_56076[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56029 === (18))){
var inst_55993 = (state_56028[(8)]);
var inst_56001 = (state_56028[(9)]);
var inst_55989 = (state_56028[(10)]);
var inst_56008 = (state_56028[(7)]);
var inst_56013 = (state_56028[(2)]);
var inst_56014 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56015 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56016 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56017 = [inst_55989,inst_55993,inst_56001];
var inst_56018 = (new cljs.core.PersistentVector(null,3,(5),inst_56016,inst_56017,null));
var inst_56019 = ["relationship?",inst_56018,inst_56013];
var inst_56020 = cljs.core.PersistentHashMap.fromArrays(inst_56015,inst_56019);
var inst_56021 = [inst_56020,inst_56008];
var inst_56022 = (new cljs.core.PersistentVector(null,2,(5),inst_56014,inst_56021,null));
var inst_56023 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56022);
var _ = (function (){var statearr_56052 = state_56028;
(statearr_56052[(4)] = cljs.core.rest.call(null,(state_56028[(4)])));

return statearr_56052;
})();
var state_56028__$1 = (function (){var statearr_56053 = state_56028;
(statearr_56053[(11)] = inst_56023);

return statearr_56053;
})();
var statearr_56054_56077 = state_56028__$1;
(statearr_56054_56077[(2)] = inst_56013);

(statearr_56054_56077[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56029 === (8))){
var inst_55989 = (state_56028[(2)]);
var inst_55990 = fluree.db.dbfunctions.fns.coerce_args.call(null,path);
var state_56028__$1 = (function (){var statearr_56055 = state_56028;
(statearr_56055[(10)] = inst_55989);

return statearr_56055;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56028__$1,(10),inst_55990);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2468__auto____0 = (function (){
var statearr_56056 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56056[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2468__auto__);

(statearr_56056[(1)] = (1));

return statearr_56056;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2468__auto____1 = (function (state_56028){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_56028);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e56057){var ex__2471__auto__ = e56057;
var statearr_56058_56078 = state_56028;
(statearr_56058_56078[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_56028[(4)]))){
var statearr_56059_56079 = state_56028;
(statearr_56059_56079[(1)] = cljs.core.first.call(null,(state_56028[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56080 = state_56028;
state_56028 = G__56080;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2468__auto__ = function(state_56028){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2468__auto____1.call(this,state_56028);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_56060 = f__2491__auto__.call(null);
(statearr_56060[(6)] = c__2490__auto__);

return statearr_56060;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_56117){
var state_val_56118 = (state_56117[(1)]);
if((state_val_56118 === (7))){
var state_56117__$1 = state_56117;
var statearr_56119_56139 = state_56117__$1;
(statearr_56119_56139[(2)] = pred_name);

(statearr_56119_56139[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56118 === (1))){
var state_56117__$1 = state_56117;
var statearr_56120_56140 = state_56117__$1;
(statearr_56120_56140[(2)] = null);

(statearr_56120_56140[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56118 === (4))){
var inst_56081 = (state_56117[(2)]);
var state_56117__$1 = state_56117;
var statearr_56121_56141 = state_56117__$1;
(statearr_56121_56141[(2)] = inst_56081);

(statearr_56121_56141[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56118 === (6))){
var state_56117__$1 = state_56117;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56117__$1,(9),pred_name);
} else {
if((state_val_56118 === (3))){
var inst_56115 = (state_56117[(2)]);
var state_56117__$1 = state_56117;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56117__$1,inst_56115);
} else {
if((state_val_56118 === (2))){
var _ = (function (){var statearr_56123 = state_56117;
(statearr_56123[(4)] = cljs.core.cons.call(null,(5),(state_56117[(4)])));

return statearr_56123;
})();
var inst_56090 = fluree.db.util.async.channel_QMARK_.call(null,pred_name);
var state_56117__$1 = state_56117;
if(inst_56090){
var statearr_56124_56142 = state_56117__$1;
(statearr_56124_56142[(1)] = (6));

} else {
var statearr_56125_56143 = state_56117__$1;
(statearr_56125_56143[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56118 === (9))){
var inst_56093 = (state_56117[(2)]);
var inst_56094 = fluree.db.util.async.throw_err.call(null,inst_56093);
var state_56117__$1 = state_56117;
var statearr_56126_56144 = state_56117__$1;
(statearr_56126_56144[(2)] = inst_56094);

(statearr_56126_56144[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56118 === (5))){
var _ = (function (){var statearr_56127 = state_56117;
(statearr_56127[(4)] = cljs.core.rest.call(null,(state_56117[(4)])));

return statearr_56127;
})();
var state_56117__$1 = state_56117;
var ex56122 = (state_56117__$1[(2)]);
var statearr_56128_56145 = state_56117__$1;
(statearr_56128_56145[(5)] = ex56122);


if((ex56122 instanceof Error)){
var statearr_56129_56146 = state_56117__$1;
(statearr_56129_56146[(1)] = (4));

(statearr_56129_56146[(5)] = null);

} else {
throw ex56122;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56118 === (10))){
var inst_56097 = (state_56117[(7)]);
var inst_56101 = (state_56117[(2)]);
var inst_56102 = fluree.db.util.async.throw_err.call(null,inst_56101);
var inst_56103 = cljs.core.nth.call(null,inst_56102,(0),null);
var inst_56104 = cljs.core.nth.call(null,inst_56102,(1),null);
var inst_56105 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56106 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56107 = ["max-pred-val",inst_56097,inst_56103];
var inst_56108 = cljs.core.PersistentHashMap.fromArrays(inst_56106,inst_56107);
var inst_56109 = (inst_56104 + (10));
var inst_56110 = [inst_56108,inst_56109];
var inst_56111 = (new cljs.core.PersistentVector(null,2,(5),inst_56105,inst_56110,null));
var inst_56112 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56111);
var _ = (function (){var statearr_56130 = state_56117;
(statearr_56130[(4)] = cljs.core.rest.call(null,(state_56117[(4)])));

return statearr_56130;
})();
var state_56117__$1 = (function (){var statearr_56131 = state_56117;
(statearr_56131[(8)] = inst_56112);

return statearr_56131;
})();
var statearr_56132_56147 = state_56117__$1;
(statearr_56132_56147[(2)] = inst_56103);

(statearr_56132_56147[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56118 === (8))){
var inst_56097 = (state_56117[(7)]);
var inst_56097__$1 = (state_56117[(2)]);
var inst_56098 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56099 = fluree.db.dbfunctions.internal.max_pred_val.call(null,inst_56098,inst_56097__$1);
var state_56117__$1 = (function (){var statearr_56133 = state_56117;
(statearr_56133[(7)] = inst_56097__$1);

return statearr_56133;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56117__$1,(10),inst_56099);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2468__auto____0 = (function (){
var statearr_56134 = [null,null,null,null,null,null,null,null,null];
(statearr_56134[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2468__auto__);

(statearr_56134[(1)] = (1));

return statearr_56134;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2468__auto____1 = (function (state_56117){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_56117);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e56135){var ex__2471__auto__ = e56135;
var statearr_56136_56148 = state_56117;
(statearr_56136_56148[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_56117[(4)]))){
var statearr_56137_56149 = state_56117;
(statearr_56137_56149[(1)] = cljs.core.first.call(null,(state_56117[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56150 = state_56117;
state_56117 = G__56150;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2468__auto__ = function(state_56117){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2468__auto____1.call(this,state_56117);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_56138 = f__2491__auto__.call(null);
(statearr_56138[(6)] = c__2490__auto__);

return statearr_56138;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_56177){
var state_val_56178 = (state_56177[(1)]);
if((state_val_56178 === (7))){
var state_56177__$1 = state_56177;
var statearr_56179_56198 = state_56177__$1;
(statearr_56179_56198[(2)] = n);

(statearr_56179_56198[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56178 === (1))){
var state_56177__$1 = state_56177;
var statearr_56180_56199 = state_56177__$1;
(statearr_56180_56199[(2)] = null);

(statearr_56180_56199[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56178 === (4))){
var inst_56151 = (state_56177[(2)]);
var state_56177__$1 = state_56177;
var statearr_56181_56200 = state_56177__$1;
(statearr_56181_56200[(2)] = inst_56151);

(statearr_56181_56200[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56178 === (6))){
var state_56177__$1 = state_56177;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56177__$1,(9),n);
} else {
if((state_val_56178 === (3))){
var inst_56175 = (state_56177[(2)]);
var state_56177__$1 = state_56177;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56177__$1,inst_56175);
} else {
if((state_val_56178 === (2))){
var _ = (function (){var statearr_56183 = state_56177;
(statearr_56183[(4)] = cljs.core.cons.call(null,(5),(state_56177[(4)])));

return statearr_56183;
})();
var inst_56157 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_56177__$1 = state_56177;
if(inst_56157){
var statearr_56184_56201 = state_56177__$1;
(statearr_56184_56201[(1)] = (6));

} else {
var statearr_56185_56202 = state_56177__$1;
(statearr_56185_56202[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56178 === (9))){
var inst_56160 = (state_56177[(2)]);
var inst_56161 = fluree.db.util.async.throw_err.call(null,inst_56160);
var state_56177__$1 = state_56177;
var statearr_56186_56203 = state_56177__$1;
(statearr_56186_56203[(2)] = inst_56161);

(statearr_56186_56203[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56178 === (5))){
var _ = (function (){var statearr_56187 = state_56177;
(statearr_56187[(4)] = cljs.core.rest.call(null,(state_56177[(4)])));

return statearr_56187;
})();
var state_56177__$1 = state_56177;
var ex56182 = (state_56177__$1[(2)]);
var statearr_56188_56204 = state_56177__$1;
(statearr_56188_56204[(5)] = ex56182);


if((ex56182 instanceof Error)){
var statearr_56189_56205 = state_56177__$1;
(statearr_56189_56205[(1)] = (4));

(statearr_56189_56205[(5)] = null);

} else {
throw ex56182;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56178 === (8))){
var inst_56164 = (state_56177[(2)]);
var inst_56165 = fluree.db.dbfunctions.internal.inc.call(null,inst_56164);
var inst_56166 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56167 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56168 = ["inc",inst_56164,inst_56165];
var inst_56169 = cljs.core.PersistentHashMap.fromArrays(inst_56167,inst_56168);
var inst_56170 = [inst_56169,(10)];
var inst_56171 = (new cljs.core.PersistentVector(null,2,(5),inst_56166,inst_56170,null));
var inst_56172 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56171);
var _ = (function (){var statearr_56190 = state_56177;
(statearr_56190[(4)] = cljs.core.rest.call(null,(state_56177[(4)])));

return statearr_56190;
})();
var state_56177__$1 = (function (){var statearr_56191 = state_56177;
(statearr_56191[(7)] = inst_56172);

return statearr_56191;
})();
var statearr_56192_56206 = state_56177__$1;
(statearr_56192_56206[(2)] = inst_56165);

(statearr_56192_56206[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__2468__auto____0 = (function (){
var statearr_56193 = [null,null,null,null,null,null,null,null];
(statearr_56193[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__2468__auto__);

(statearr_56193[(1)] = (1));

return statearr_56193;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__2468__auto____1 = (function (state_56177){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_56177);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e56194){var ex__2471__auto__ = e56194;
var statearr_56195_56207 = state_56177;
(statearr_56195_56207[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_56177[(4)]))){
var statearr_56196_56208 = state_56177;
(statearr_56196_56208[(1)] = cljs.core.first.call(null,(state_56177[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56209 = state_56177;
state_56177 = G__56209;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__2468__auto__ = function(state_56177){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2468__auto____1.call(this,state_56177);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_56197 = f__2491__auto__.call(null);
(statearr_56197[(6)] = c__2490__auto__);

return statearr_56197;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_56236){
var state_val_56237 = (state_56236[(1)]);
if((state_val_56237 === (7))){
var state_56236__$1 = state_56236;
var statearr_56238_56257 = state_56236__$1;
(statearr_56238_56257[(2)] = n);

(statearr_56238_56257[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56237 === (1))){
var state_56236__$1 = state_56236;
var statearr_56239_56258 = state_56236__$1;
(statearr_56239_56258[(2)] = null);

(statearr_56239_56258[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56237 === (4))){
var inst_56210 = (state_56236[(2)]);
var state_56236__$1 = state_56236;
var statearr_56240_56259 = state_56236__$1;
(statearr_56240_56259[(2)] = inst_56210);

(statearr_56240_56259[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56237 === (6))){
var state_56236__$1 = state_56236;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56236__$1,(9),n);
} else {
if((state_val_56237 === (3))){
var inst_56234 = (state_56236[(2)]);
var state_56236__$1 = state_56236;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56236__$1,inst_56234);
} else {
if((state_val_56237 === (2))){
var _ = (function (){var statearr_56242 = state_56236;
(statearr_56242[(4)] = cljs.core.cons.call(null,(5),(state_56236[(4)])));

return statearr_56242;
})();
var inst_56216 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_56236__$1 = state_56236;
if(inst_56216){
var statearr_56243_56260 = state_56236__$1;
(statearr_56243_56260[(1)] = (6));

} else {
var statearr_56244_56261 = state_56236__$1;
(statearr_56244_56261[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56237 === (9))){
var inst_56219 = (state_56236[(2)]);
var inst_56220 = fluree.db.util.async.throw_err.call(null,inst_56219);
var state_56236__$1 = state_56236;
var statearr_56245_56262 = state_56236__$1;
(statearr_56245_56262[(2)] = inst_56220);

(statearr_56245_56262[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56237 === (5))){
var _ = (function (){var statearr_56246 = state_56236;
(statearr_56246[(4)] = cljs.core.rest.call(null,(state_56236[(4)])));

return statearr_56246;
})();
var state_56236__$1 = state_56236;
var ex56241 = (state_56236__$1[(2)]);
var statearr_56247_56263 = state_56236__$1;
(statearr_56247_56263[(5)] = ex56241);


if((ex56241 instanceof Error)){
var statearr_56248_56264 = state_56236__$1;
(statearr_56248_56264[(1)] = (4));

(statearr_56248_56264[(5)] = null);

} else {
throw ex56241;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56237 === (8))){
var inst_56223 = (state_56236[(2)]);
var inst_56224 = fluree.db.dbfunctions.internal.dec.call(null,inst_56223);
var inst_56225 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56226 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56227 = ["dec",inst_56223,inst_56224];
var inst_56228 = cljs.core.PersistentHashMap.fromArrays(inst_56226,inst_56227);
var inst_56229 = [inst_56228,(10)];
var inst_56230 = (new cljs.core.PersistentVector(null,2,(5),inst_56225,inst_56229,null));
var inst_56231 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56230);
var _ = (function (){var statearr_56249 = state_56236;
(statearr_56249[(4)] = cljs.core.rest.call(null,(state_56236[(4)])));

return statearr_56249;
})();
var state_56236__$1 = (function (){var statearr_56250 = state_56236;
(statearr_56250[(7)] = inst_56231);

return statearr_56250;
})();
var statearr_56251_56265 = state_56236__$1;
(statearr_56251_56265[(2)] = inst_56224);

(statearr_56251_56265[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__2468__auto____0 = (function (){
var statearr_56252 = [null,null,null,null,null,null,null,null];
(statearr_56252[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__2468__auto__);

(statearr_56252[(1)] = (1));

return statearr_56252;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__2468__auto____1 = (function (state_56236){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_56236);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e56253){var ex__2471__auto__ = e56253;
var statearr_56254_56266 = state_56236;
(statearr_56254_56266[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_56236[(4)]))){
var statearr_56255_56267 = state_56236;
(statearr_56255_56267[(1)] = cljs.core.first.call(null,(state_56236[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56268 = state_56236;
state_56236 = G__56268;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__2468__auto__ = function(state_56236){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2468__auto____1.call(this,state_56236);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_56256 = f__2491__auto__.call(null);
(statearr_56256[(6)] = c__2490__auto__);

return statearr_56256;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx).toEpochMilli();
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"now",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___56318 = arguments.length;
var i__4737__auto___56319 = (0);
while(true){
if((i__4737__auto___56319 < len__4736__auto___56318)){
args__4742__auto__.push((arguments[i__4737__auto___56319]));

var G__56320 = (i__4737__auto___56319 + (1));
i__4737__auto___56319 = G__56320;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_56301){
var state_val_56302 = (state_56301[(1)]);
if((state_val_56302 === (1))){
var state_56301__$1 = state_56301;
var statearr_56303_56321 = state_56301__$1;
(statearr_56303_56321[(2)] = null);

(statearr_56303_56321[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56302 === (2))){
var _ = (function (){var statearr_56304 = state_56301;
(statearr_56304[(4)] = cljs.core.cons.call(null,(5),(state_56301[(4)])));

return statearr_56304;
})();
var inst_56277 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_56301__$1 = state_56301;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56301__$1,(6),inst_56277);
} else {
if((state_val_56302 === (3))){
var inst_56299 = (state_56301[(2)]);
var state_56301__$1 = state_56301;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56301__$1,inst_56299);
} else {
if((state_val_56302 === (4))){
var inst_56271 = (state_56301[(2)]);
var state_56301__$1 = state_56301;
var statearr_56306_56322 = state_56301__$1;
(statearr_56306_56322[(2)] = inst_56271);

(statearr_56306_56322[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56302 === (5))){
var _ = (function (){var statearr_56307 = state_56301;
(statearr_56307[(4)] = cljs.core.rest.call(null,(state_56301[(4)])));

return statearr_56307;
})();
var state_56301__$1 = state_56301;
var ex56305 = (state_56301__$1[(2)]);
var statearr_56308_56323 = state_56301__$1;
(statearr_56308_56323[(5)] = ex56305);


if((ex56305 instanceof Error)){
var statearr_56309_56324 = state_56301__$1;
(statearr_56309_56324[(1)] = (4));

(statearr_56309_56324[(5)] = null);

} else {
throw ex56305;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56302 === (6))){
var inst_56279 = (state_56301[(2)]);
var inst_56280 = fluree.db.util.async.throw_err.call(null,inst_56279);
var inst_56281 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._PLUS_,inst_56280);
var inst_56282 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56283 = [inst_56280];
var inst_56284 = (new cljs.core.PersistentVector(null,1,(5),inst_56282,inst_56283,null));
var inst_56285 = cljs.core.count.call(null,inst_56284);
var inst_56286 = ((9) + inst_56285);
var inst_56287 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56288 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56289 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56290 = [inst_56280];
var inst_56291 = (new cljs.core.PersistentVector(null,1,(5),inst_56289,inst_56290,null));
var inst_56292 = ["+",inst_56291,inst_56281];
var inst_56293 = cljs.core.PersistentHashMap.fromArrays(inst_56288,inst_56292);
var inst_56294 = [inst_56293,inst_56286];
var inst_56295 = (new cljs.core.PersistentVector(null,2,(5),inst_56287,inst_56294,null));
var inst_56296 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56295);
var _ = (function (){var statearr_56310 = state_56301;
(statearr_56310[(4)] = cljs.core.rest.call(null,(state_56301[(4)])));

return statearr_56310;
})();
var state_56301__$1 = (function (){var statearr_56311 = state_56301;
(statearr_56311[(7)] = inst_56296);

return statearr_56311;
})();
var statearr_56312_56325 = state_56301__$1;
(statearr_56312_56325[(2)] = inst_56281);

(statearr_56312_56325[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2468__auto____0 = (function (){
var statearr_56313 = [null,null,null,null,null,null,null,null];
(statearr_56313[(0)] = fluree$db$dbfunctions$fns$state_machine__2468__auto__);

(statearr_56313[(1)] = (1));

return statearr_56313;
});
var fluree$db$dbfunctions$fns$state_machine__2468__auto____1 = (function (state_56301){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_56301);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e56314){var ex__2471__auto__ = e56314;
var statearr_56315_56326 = state_56301;
(statearr_56315_56326[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_56301[(4)]))){
var statearr_56316_56327 = state_56301;
(statearr_56316_56327[(1)] = cljs.core.first.call(null,(state_56301[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56328 = state_56301;
state_56301 = G__56328;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2468__auto__ = function(state_56301){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2468__auto____1.call(this,state_56301);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_56317 = f__2491__auto__.call(null);
(statearr_56317[(6)] = c__2490__auto__);

return statearr_56317;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq56269){
var G__56270 = cljs.core.first.call(null,seq56269);
var seq56269__$1 = cljs.core.next.call(null,seq56269);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56270,seq56269__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___56378 = arguments.length;
var i__4737__auto___56379 = (0);
while(true){
if((i__4737__auto___56379 < len__4736__auto___56378)){
args__4742__auto__.push((arguments[i__4737__auto___56379]));

var G__56380 = (i__4737__auto___56379 + (1));
i__4737__auto___56379 = G__56380;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_56361){
var state_val_56362 = (state_56361[(1)]);
if((state_val_56362 === (1))){
var state_56361__$1 = state_56361;
var statearr_56363_56381 = state_56361__$1;
(statearr_56363_56381[(2)] = null);

(statearr_56363_56381[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56362 === (2))){
var _ = (function (){var statearr_56364 = state_56361;
(statearr_56364[(4)] = cljs.core.cons.call(null,(5),(state_56361[(4)])));

return statearr_56364;
})();
var inst_56337 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_56361__$1 = state_56361;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56361__$1,(6),inst_56337);
} else {
if((state_val_56362 === (3))){
var inst_56359 = (state_56361[(2)]);
var state_56361__$1 = state_56361;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56361__$1,inst_56359);
} else {
if((state_val_56362 === (4))){
var inst_56331 = (state_56361[(2)]);
var state_56361__$1 = state_56361;
var statearr_56366_56382 = state_56361__$1;
(statearr_56366_56382[(2)] = inst_56331);

(statearr_56366_56382[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56362 === (5))){
var _ = (function (){var statearr_56367 = state_56361;
(statearr_56367[(4)] = cljs.core.rest.call(null,(state_56361[(4)])));

return statearr_56367;
})();
var state_56361__$1 = state_56361;
var ex56365 = (state_56361__$1[(2)]);
var statearr_56368_56383 = state_56361__$1;
(statearr_56368_56383[(5)] = ex56365);


if((ex56365 instanceof Error)){
var statearr_56369_56384 = state_56361__$1;
(statearr_56369_56384[(1)] = (4));

(statearr_56369_56384[(5)] = null);

} else {
throw ex56365;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56362 === (6))){
var inst_56339 = (state_56361[(2)]);
var inst_56340 = fluree.db.util.async.throw_err.call(null,inst_56339);
var inst_56341 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._,inst_56340);
var inst_56342 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56343 = [inst_56340];
var inst_56344 = (new cljs.core.PersistentVector(null,1,(5),inst_56342,inst_56343,null));
var inst_56345 = cljs.core.count.call(null,inst_56344);
var inst_56346 = ((9) + inst_56345);
var inst_56347 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56348 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56349 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56350 = [inst_56340];
var inst_56351 = (new cljs.core.PersistentVector(null,1,(5),inst_56349,inst_56350,null));
var inst_56352 = ["-",inst_56351,inst_56341];
var inst_56353 = cljs.core.PersistentHashMap.fromArrays(inst_56348,inst_56352);
var inst_56354 = [inst_56353,inst_56346];
var inst_56355 = (new cljs.core.PersistentVector(null,2,(5),inst_56347,inst_56354,null));
var inst_56356 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56355);
var _ = (function (){var statearr_56370 = state_56361;
(statearr_56370[(4)] = cljs.core.rest.call(null,(state_56361[(4)])));

return statearr_56370;
})();
var state_56361__$1 = (function (){var statearr_56371 = state_56361;
(statearr_56371[(7)] = inst_56356);

return statearr_56371;
})();
var statearr_56372_56385 = state_56361__$1;
(statearr_56372_56385[(2)] = inst_56341);

(statearr_56372_56385[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2468__auto____0 = (function (){
var statearr_56373 = [null,null,null,null,null,null,null,null];
(statearr_56373[(0)] = fluree$db$dbfunctions$fns$state_machine__2468__auto__);

(statearr_56373[(1)] = (1));

return statearr_56373;
});
var fluree$db$dbfunctions$fns$state_machine__2468__auto____1 = (function (state_56361){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_56361);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e56374){var ex__2471__auto__ = e56374;
var statearr_56375_56386 = state_56361;
(statearr_56375_56386[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_56361[(4)]))){
var statearr_56376_56387 = state_56361;
(statearr_56376_56387[(1)] = cljs.core.first.call(null,(state_56361[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56388 = state_56361;
state_56361 = G__56388;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2468__auto__ = function(state_56361){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2468__auto____1.call(this,state_56361);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_56377 = f__2491__auto__.call(null);
(statearr_56377[(6)] = c__2490__auto__);

return statearr_56377;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq56329){
var G__56330 = cljs.core.first.call(null,seq56329);
var seq56329__$1 = cljs.core.next.call(null,seq56329);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56330,seq56329__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___56438 = arguments.length;
var i__4737__auto___56439 = (0);
while(true){
if((i__4737__auto___56439 < len__4736__auto___56438)){
args__4742__auto__.push((arguments[i__4737__auto___56439]));

var G__56440 = (i__4737__auto___56439 + (1));
i__4737__auto___56439 = G__56440;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_56421){
var state_val_56422 = (state_56421[(1)]);
if((state_val_56422 === (1))){
var state_56421__$1 = state_56421;
var statearr_56423_56441 = state_56421__$1;
(statearr_56423_56441[(2)] = null);

(statearr_56423_56441[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56422 === (2))){
var _ = (function (){var statearr_56424 = state_56421;
(statearr_56424[(4)] = cljs.core.cons.call(null,(5),(state_56421[(4)])));

return statearr_56424;
})();
var inst_56397 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_56421__$1 = state_56421;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56421__$1,(6),inst_56397);
} else {
if((state_val_56422 === (3))){
var inst_56419 = (state_56421[(2)]);
var state_56421__$1 = state_56421;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56421__$1,inst_56419);
} else {
if((state_val_56422 === (4))){
var inst_56391 = (state_56421[(2)]);
var state_56421__$1 = state_56421;
var statearr_56426_56442 = state_56421__$1;
(statearr_56426_56442[(2)] = inst_56391);

(statearr_56426_56442[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56422 === (5))){
var _ = (function (){var statearr_56427 = state_56421;
(statearr_56427[(4)] = cljs.core.rest.call(null,(state_56421[(4)])));

return statearr_56427;
})();
var state_56421__$1 = state_56421;
var ex56425 = (state_56421__$1[(2)]);
var statearr_56428_56443 = state_56421__$1;
(statearr_56428_56443[(5)] = ex56425);


if((ex56425 instanceof Error)){
var statearr_56429_56444 = state_56421__$1;
(statearr_56429_56444[(1)] = (4));

(statearr_56429_56444[(5)] = null);

} else {
throw ex56425;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56422 === (6))){
var inst_56399 = (state_56421[(2)]);
var inst_56400 = fluree.db.util.async.throw_err.call(null,inst_56399);
var inst_56401 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._STAR_,inst_56400);
var inst_56402 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56403 = [inst_56400];
var inst_56404 = (new cljs.core.PersistentVector(null,1,(5),inst_56402,inst_56403,null));
var inst_56405 = cljs.core.count.call(null,inst_56404);
var inst_56406 = ((9) + inst_56405);
var inst_56407 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56408 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56409 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56410 = [inst_56400];
var inst_56411 = (new cljs.core.PersistentVector(null,1,(5),inst_56409,inst_56410,null));
var inst_56412 = ["*",inst_56411,inst_56401];
var inst_56413 = cljs.core.PersistentHashMap.fromArrays(inst_56408,inst_56412);
var inst_56414 = [inst_56413,inst_56406];
var inst_56415 = (new cljs.core.PersistentVector(null,2,(5),inst_56407,inst_56414,null));
var inst_56416 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56415);
var _ = (function (){var statearr_56430 = state_56421;
(statearr_56430[(4)] = cljs.core.rest.call(null,(state_56421[(4)])));

return statearr_56430;
})();
var state_56421__$1 = (function (){var statearr_56431 = state_56421;
(statearr_56431[(7)] = inst_56416);

return statearr_56431;
})();
var statearr_56432_56445 = state_56421__$1;
(statearr_56432_56445[(2)] = inst_56401);

(statearr_56432_56445[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2468__auto____0 = (function (){
var statearr_56433 = [null,null,null,null,null,null,null,null];
(statearr_56433[(0)] = fluree$db$dbfunctions$fns$state_machine__2468__auto__);

(statearr_56433[(1)] = (1));

return statearr_56433;
});
var fluree$db$dbfunctions$fns$state_machine__2468__auto____1 = (function (state_56421){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_56421);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e56434){var ex__2471__auto__ = e56434;
var statearr_56435_56446 = state_56421;
(statearr_56435_56446[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_56421[(4)]))){
var statearr_56436_56447 = state_56421;
(statearr_56436_56447[(1)] = cljs.core.first.call(null,(state_56421[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56448 = state_56421;
state_56421 = G__56448;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2468__auto__ = function(state_56421){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2468__auto____1.call(this,state_56421);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_56437 = f__2491__auto__.call(null);
(statearr_56437[(6)] = c__2490__auto__);

return statearr_56437;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq56389){
var G__56390 = cljs.core.first.call(null,seq56389);
var seq56389__$1 = cljs.core.next.call(null,seq56389);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56390,seq56389__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___56498 = arguments.length;
var i__4737__auto___56499 = (0);
while(true){
if((i__4737__auto___56499 < len__4736__auto___56498)){
args__4742__auto__.push((arguments[i__4737__auto___56499]));

var G__56500 = (i__4737__auto___56499 + (1));
i__4737__auto___56499 = G__56500;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_56481){
var state_val_56482 = (state_56481[(1)]);
if((state_val_56482 === (1))){
var state_56481__$1 = state_56481;
var statearr_56483_56501 = state_56481__$1;
(statearr_56483_56501[(2)] = null);

(statearr_56483_56501[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56482 === (2))){
var _ = (function (){var statearr_56484 = state_56481;
(statearr_56484[(4)] = cljs.core.cons.call(null,(5),(state_56481[(4)])));

return statearr_56484;
})();
var inst_56457 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_56481__$1 = state_56481;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56481__$1,(6),inst_56457);
} else {
if((state_val_56482 === (3))){
var inst_56479 = (state_56481[(2)]);
var state_56481__$1 = state_56481;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56481__$1,inst_56479);
} else {
if((state_val_56482 === (4))){
var inst_56451 = (state_56481[(2)]);
var state_56481__$1 = state_56481;
var statearr_56486_56502 = state_56481__$1;
(statearr_56486_56502[(2)] = inst_56451);

(statearr_56486_56502[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56482 === (5))){
var _ = (function (){var statearr_56487 = state_56481;
(statearr_56487[(4)] = cljs.core.rest.call(null,(state_56481[(4)])));

return statearr_56487;
})();
var state_56481__$1 = state_56481;
var ex56485 = (state_56481__$1[(2)]);
var statearr_56488_56503 = state_56481__$1;
(statearr_56488_56503[(5)] = ex56485);


if((ex56485 instanceof Error)){
var statearr_56489_56504 = state_56481__$1;
(statearr_56489_56504[(1)] = (4));

(statearr_56489_56504[(5)] = null);

} else {
throw ex56485;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56482 === (6))){
var inst_56459 = (state_56481[(2)]);
var inst_56460 = fluree.db.util.async.throw_err.call(null,inst_56459);
var inst_56461 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._SLASH_,inst_56460);
var inst_56462 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56463 = [inst_56460];
var inst_56464 = (new cljs.core.PersistentVector(null,1,(5),inst_56462,inst_56463,null));
var inst_56465 = cljs.core.count.call(null,inst_56464);
var inst_56466 = ((9) + inst_56465);
var inst_56467 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56468 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56469 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56470 = [inst_56460];
var inst_56471 = (new cljs.core.PersistentVector(null,1,(5),inst_56469,inst_56470,null));
var inst_56472 = ["/",inst_56471,inst_56461];
var inst_56473 = cljs.core.PersistentHashMap.fromArrays(inst_56468,inst_56472);
var inst_56474 = [inst_56473,inst_56466];
var inst_56475 = (new cljs.core.PersistentVector(null,2,(5),inst_56467,inst_56474,null));
var inst_56476 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56475);
var _ = (function (){var statearr_56490 = state_56481;
(statearr_56490[(4)] = cljs.core.rest.call(null,(state_56481[(4)])));

return statearr_56490;
})();
var state_56481__$1 = (function (){var statearr_56491 = state_56481;
(statearr_56491[(7)] = inst_56476);

return statearr_56491;
})();
var statearr_56492_56505 = state_56481__$1;
(statearr_56492_56505[(2)] = inst_56461);

(statearr_56492_56505[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2468__auto____0 = (function (){
var statearr_56493 = [null,null,null,null,null,null,null,null];
(statearr_56493[(0)] = fluree$db$dbfunctions$fns$state_machine__2468__auto__);

(statearr_56493[(1)] = (1));

return statearr_56493;
});
var fluree$db$dbfunctions$fns$state_machine__2468__auto____1 = (function (state_56481){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_56481);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e56494){var ex__2471__auto__ = e56494;
var statearr_56495_56506 = state_56481;
(statearr_56495_56506[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_56481[(4)]))){
var statearr_56496_56507 = state_56481;
(statearr_56496_56507[(1)] = cljs.core.first.call(null,(state_56481[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56508 = state_56481;
state_56481 = G__56508;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2468__auto__ = function(state_56481){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2468__auto____1.call(this,state_56481);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_56497 = f__2491__auto__.call(null);
(statearr_56497[(6)] = c__2490__auto__);

return statearr_56497;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq56449){
var G__56450 = cljs.core.first.call(null,seq56449);
var seq56449__$1 = cljs.core.next.call(null,seq56449);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56450,seq56449__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_56546){
var state_val_56547 = (state_56546[(1)]);
if((state_val_56547 === (7))){
var state_56546__$1 = state_56546;
var statearr_56548_56572 = state_56546__$1;
(statearr_56548_56572[(2)] = n);

(statearr_56548_56572[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56547 === (1))){
var state_56546__$1 = state_56546;
var statearr_56549_56573 = state_56546__$1;
(statearr_56549_56573[(2)] = null);

(statearr_56549_56573[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56547 === (4))){
var inst_56509 = (state_56546[(2)]);
var state_56546__$1 = state_56546;
var statearr_56550_56574 = state_56546__$1;
(statearr_56550_56574[(2)] = inst_56509);

(statearr_56550_56574[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56547 === (13))){
var inst_56526 = (state_56546[(2)]);
var inst_56527 = fluree.db.util.async.throw_err.call(null,inst_56526);
var state_56546__$1 = state_56546;
var statearr_56551_56575 = state_56546__$1;
(statearr_56551_56575[(2)] = inst_56527);

(statearr_56551_56575[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56547 === (6))){
var state_56546__$1 = state_56546;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56546__$1,(9),n);
} else {
if((state_val_56547 === (3))){
var inst_56544 = (state_56546[(2)]);
var state_56546__$1 = state_56546;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56546__$1,inst_56544);
} else {
if((state_val_56547 === (12))){
var inst_56522 = (state_56546[(7)]);
var inst_56530 = (state_56546[(2)]);
var inst_56531 = fluree.db.dbfunctions.internal.quot.call(null,inst_56522,inst_56530);
var inst_56532 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56533 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56534 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56535 = [inst_56522,inst_56530];
var inst_56536 = (new cljs.core.PersistentVector(null,2,(5),inst_56534,inst_56535,null));
var inst_56537 = ["quot",inst_56536,inst_56531];
var inst_56538 = cljs.core.PersistentHashMap.fromArrays(inst_56533,inst_56537);
var inst_56539 = [inst_56538,(2)];
var inst_56540 = (new cljs.core.PersistentVector(null,2,(5),inst_56532,inst_56539,null));
var inst_56541 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56540);
var _ = (function (){var statearr_56552 = state_56546;
(statearr_56552[(4)] = cljs.core.rest.call(null,(state_56546[(4)])));

return statearr_56552;
})();
var state_56546__$1 = (function (){var statearr_56553 = state_56546;
(statearr_56553[(8)] = inst_56541);

return statearr_56553;
})();
var statearr_56554_56576 = state_56546__$1;
(statearr_56554_56576[(2)] = inst_56531);

(statearr_56554_56576[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56547 === (2))){
var _ = (function (){var statearr_56555 = state_56546;
(statearr_56555[(4)] = cljs.core.cons.call(null,(5),(state_56546[(4)])));

return statearr_56555;
})();
var inst_56515 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_56546__$1 = state_56546;
if(inst_56515){
var statearr_56556_56577 = state_56546__$1;
(statearr_56556_56577[(1)] = (6));

} else {
var statearr_56557_56578 = state_56546__$1;
(statearr_56557_56578[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56547 === (11))){
var state_56546__$1 = state_56546;
var statearr_56559_56579 = state_56546__$1;
(statearr_56559_56579[(2)] = d);

(statearr_56559_56579[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56547 === (9))){
var inst_56518 = (state_56546[(2)]);
var inst_56519 = fluree.db.util.async.throw_err.call(null,inst_56518);
var state_56546__$1 = state_56546;
var statearr_56560_56580 = state_56546__$1;
(statearr_56560_56580[(2)] = inst_56519);

(statearr_56560_56580[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56547 === (5))){
var _ = (function (){var statearr_56561 = state_56546;
(statearr_56561[(4)] = cljs.core.rest.call(null,(state_56546[(4)])));

return statearr_56561;
})();
var state_56546__$1 = state_56546;
var ex56558 = (state_56546__$1[(2)]);
var statearr_56562_56581 = state_56546__$1;
(statearr_56562_56581[(5)] = ex56558);


if((ex56558 instanceof Error)){
var statearr_56563_56582 = state_56546__$1;
(statearr_56563_56582[(1)] = (4));

(statearr_56563_56582[(5)] = null);

} else {
throw ex56558;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56547 === (10))){
var state_56546__$1 = state_56546;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56546__$1,(13),d);
} else {
if((state_val_56547 === (8))){
var inst_56522 = (state_56546[(2)]);
var inst_56523 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_56546__$1 = (function (){var statearr_56564 = state_56546;
(statearr_56564[(7)] = inst_56522);

return statearr_56564;
})();
if(inst_56523){
var statearr_56565_56583 = state_56546__$1;
(statearr_56565_56583[(1)] = (10));

} else {
var statearr_56566_56584 = state_56546__$1;
(statearr_56566_56584[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__2468__auto____0 = (function (){
var statearr_56567 = [null,null,null,null,null,null,null,null,null];
(statearr_56567[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__2468__auto__);

(statearr_56567[(1)] = (1));

return statearr_56567;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__2468__auto____1 = (function (state_56546){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_56546);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e56568){var ex__2471__auto__ = e56568;
var statearr_56569_56585 = state_56546;
(statearr_56569_56585[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_56546[(4)]))){
var statearr_56570_56586 = state_56546;
(statearr_56570_56586[(1)] = cljs.core.first.call(null,(state_56546[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56587 = state_56546;
state_56546 = G__56587;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__2468__auto__ = function(state_56546){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2468__auto____1.call(this,state_56546);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_56571 = f__2491__auto__.call(null);
(statearr_56571[(6)] = c__2490__auto__);

return statearr_56571;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_56625){
var state_val_56626 = (state_56625[(1)]);
if((state_val_56626 === (7))){
var state_56625__$1 = state_56625;
var statearr_56627_56651 = state_56625__$1;
(statearr_56627_56651[(2)] = n);

(statearr_56627_56651[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56626 === (1))){
var state_56625__$1 = state_56625;
var statearr_56628_56652 = state_56625__$1;
(statearr_56628_56652[(2)] = null);

(statearr_56628_56652[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56626 === (4))){
var inst_56588 = (state_56625[(2)]);
var state_56625__$1 = state_56625;
var statearr_56629_56653 = state_56625__$1;
(statearr_56629_56653[(2)] = inst_56588);

(statearr_56629_56653[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56626 === (13))){
var inst_56605 = (state_56625[(2)]);
var inst_56606 = fluree.db.util.async.throw_err.call(null,inst_56605);
var state_56625__$1 = state_56625;
var statearr_56630_56654 = state_56625__$1;
(statearr_56630_56654[(2)] = inst_56606);

(statearr_56630_56654[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56626 === (6))){
var state_56625__$1 = state_56625;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56625__$1,(9),n);
} else {
if((state_val_56626 === (3))){
var inst_56623 = (state_56625[(2)]);
var state_56625__$1 = state_56625;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56625__$1,inst_56623);
} else {
if((state_val_56626 === (12))){
var inst_56601 = (state_56625[(7)]);
var inst_56609 = (state_56625[(2)]);
var inst_56610 = fluree.db.dbfunctions.internal.mod.call(null,inst_56601,inst_56609);
var inst_56611 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56612 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56613 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56614 = [inst_56601,inst_56609];
var inst_56615 = (new cljs.core.PersistentVector(null,2,(5),inst_56613,inst_56614,null));
var inst_56616 = ["mod",inst_56615,inst_56610];
var inst_56617 = cljs.core.PersistentHashMap.fromArrays(inst_56612,inst_56616);
var inst_56618 = [inst_56617,(2)];
var inst_56619 = (new cljs.core.PersistentVector(null,2,(5),inst_56611,inst_56618,null));
var inst_56620 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56619);
var _ = (function (){var statearr_56631 = state_56625;
(statearr_56631[(4)] = cljs.core.rest.call(null,(state_56625[(4)])));

return statearr_56631;
})();
var state_56625__$1 = (function (){var statearr_56632 = state_56625;
(statearr_56632[(8)] = inst_56620);

return statearr_56632;
})();
var statearr_56633_56655 = state_56625__$1;
(statearr_56633_56655[(2)] = inst_56610);

(statearr_56633_56655[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56626 === (2))){
var _ = (function (){var statearr_56634 = state_56625;
(statearr_56634[(4)] = cljs.core.cons.call(null,(5),(state_56625[(4)])));

return statearr_56634;
})();
var inst_56594 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_56625__$1 = state_56625;
if(inst_56594){
var statearr_56635_56656 = state_56625__$1;
(statearr_56635_56656[(1)] = (6));

} else {
var statearr_56636_56657 = state_56625__$1;
(statearr_56636_56657[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56626 === (11))){
var state_56625__$1 = state_56625;
var statearr_56638_56658 = state_56625__$1;
(statearr_56638_56658[(2)] = d);

(statearr_56638_56658[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56626 === (9))){
var inst_56597 = (state_56625[(2)]);
var inst_56598 = fluree.db.util.async.throw_err.call(null,inst_56597);
var state_56625__$1 = state_56625;
var statearr_56639_56659 = state_56625__$1;
(statearr_56639_56659[(2)] = inst_56598);

(statearr_56639_56659[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56626 === (5))){
var _ = (function (){var statearr_56640 = state_56625;
(statearr_56640[(4)] = cljs.core.rest.call(null,(state_56625[(4)])));

return statearr_56640;
})();
var state_56625__$1 = state_56625;
var ex56637 = (state_56625__$1[(2)]);
var statearr_56641_56660 = state_56625__$1;
(statearr_56641_56660[(5)] = ex56637);


if((ex56637 instanceof Error)){
var statearr_56642_56661 = state_56625__$1;
(statearr_56642_56661[(1)] = (4));

(statearr_56642_56661[(5)] = null);

} else {
throw ex56637;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56626 === (10))){
var state_56625__$1 = state_56625;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56625__$1,(13),d);
} else {
if((state_val_56626 === (8))){
var inst_56601 = (state_56625[(2)]);
var inst_56602 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_56625__$1 = (function (){var statearr_56643 = state_56625;
(statearr_56643[(7)] = inst_56601);

return statearr_56643;
})();
if(inst_56602){
var statearr_56644_56662 = state_56625__$1;
(statearr_56644_56662[(1)] = (10));

} else {
var statearr_56645_56663 = state_56625__$1;
(statearr_56645_56663[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__2468__auto____0 = (function (){
var statearr_56646 = [null,null,null,null,null,null,null,null,null];
(statearr_56646[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__2468__auto__);

(statearr_56646[(1)] = (1));

return statearr_56646;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__2468__auto____1 = (function (state_56625){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_56625);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e56647){var ex__2471__auto__ = e56647;
var statearr_56648_56664 = state_56625;
(statearr_56648_56664[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_56625[(4)]))){
var statearr_56649_56665 = state_56625;
(statearr_56649_56665[(1)] = cljs.core.first.call(null,(state_56625[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56666 = state_56625;
state_56625 = G__56666;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__2468__auto__ = function(state_56625){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2468__auto____1.call(this,state_56625);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_56650 = f__2491__auto__.call(null);
(statearr_56650[(6)] = c__2490__auto__);

return statearr_56650;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_56704){
var state_val_56705 = (state_56704[(1)]);
if((state_val_56705 === (7))){
var state_56704__$1 = state_56704;
var statearr_56706_56730 = state_56704__$1;
(statearr_56706_56730[(2)] = n);

(statearr_56706_56730[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56705 === (1))){
var state_56704__$1 = state_56704;
var statearr_56707_56731 = state_56704__$1;
(statearr_56707_56731[(2)] = null);

(statearr_56707_56731[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56705 === (4))){
var inst_56667 = (state_56704[(2)]);
var state_56704__$1 = state_56704;
var statearr_56708_56732 = state_56704__$1;
(statearr_56708_56732[(2)] = inst_56667);

(statearr_56708_56732[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56705 === (13))){
var inst_56684 = (state_56704[(2)]);
var inst_56685 = fluree.db.util.async.throw_err.call(null,inst_56684);
var state_56704__$1 = state_56704;
var statearr_56709_56733 = state_56704__$1;
(statearr_56709_56733[(2)] = inst_56685);

(statearr_56709_56733[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56705 === (6))){
var state_56704__$1 = state_56704;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56704__$1,(9),n);
} else {
if((state_val_56705 === (3))){
var inst_56702 = (state_56704[(2)]);
var state_56704__$1 = state_56704;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56704__$1,inst_56702);
} else {
if((state_val_56705 === (12))){
var inst_56680 = (state_56704[(7)]);
var inst_56688 = (state_56704[(2)]);
var inst_56689 = fluree.db.dbfunctions.internal.rem.call(null,inst_56680,inst_56688);
var inst_56690 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56691 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56692 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56693 = [inst_56680,inst_56688];
var inst_56694 = (new cljs.core.PersistentVector(null,2,(5),inst_56692,inst_56693,null));
var inst_56695 = ["rem",inst_56694,inst_56689];
var inst_56696 = cljs.core.PersistentHashMap.fromArrays(inst_56691,inst_56695);
var inst_56697 = [inst_56696,(2)];
var inst_56698 = (new cljs.core.PersistentVector(null,2,(5),inst_56690,inst_56697,null));
var inst_56699 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56698);
var _ = (function (){var statearr_56710 = state_56704;
(statearr_56710[(4)] = cljs.core.rest.call(null,(state_56704[(4)])));

return statearr_56710;
})();
var state_56704__$1 = (function (){var statearr_56711 = state_56704;
(statearr_56711[(8)] = inst_56699);

return statearr_56711;
})();
var statearr_56712_56734 = state_56704__$1;
(statearr_56712_56734[(2)] = inst_56689);

(statearr_56712_56734[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56705 === (2))){
var _ = (function (){var statearr_56713 = state_56704;
(statearr_56713[(4)] = cljs.core.cons.call(null,(5),(state_56704[(4)])));

return statearr_56713;
})();
var inst_56673 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_56704__$1 = state_56704;
if(inst_56673){
var statearr_56714_56735 = state_56704__$1;
(statearr_56714_56735[(1)] = (6));

} else {
var statearr_56715_56736 = state_56704__$1;
(statearr_56715_56736[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56705 === (11))){
var state_56704__$1 = state_56704;
var statearr_56717_56737 = state_56704__$1;
(statearr_56717_56737[(2)] = d);

(statearr_56717_56737[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56705 === (9))){
var inst_56676 = (state_56704[(2)]);
var inst_56677 = fluree.db.util.async.throw_err.call(null,inst_56676);
var state_56704__$1 = state_56704;
var statearr_56718_56738 = state_56704__$1;
(statearr_56718_56738[(2)] = inst_56677);

(statearr_56718_56738[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56705 === (5))){
var _ = (function (){var statearr_56719 = state_56704;
(statearr_56719[(4)] = cljs.core.rest.call(null,(state_56704[(4)])));

return statearr_56719;
})();
var state_56704__$1 = state_56704;
var ex56716 = (state_56704__$1[(2)]);
var statearr_56720_56739 = state_56704__$1;
(statearr_56720_56739[(5)] = ex56716);


if((ex56716 instanceof Error)){
var statearr_56721_56740 = state_56704__$1;
(statearr_56721_56740[(1)] = (4));

(statearr_56721_56740[(5)] = null);

} else {
throw ex56716;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56705 === (10))){
var state_56704__$1 = state_56704;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56704__$1,(13),d);
} else {
if((state_val_56705 === (8))){
var inst_56680 = (state_56704[(2)]);
var inst_56681 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_56704__$1 = (function (){var statearr_56722 = state_56704;
(statearr_56722[(7)] = inst_56680);

return statearr_56722;
})();
if(inst_56681){
var statearr_56723_56741 = state_56704__$1;
(statearr_56723_56741[(1)] = (10));

} else {
var statearr_56724_56742 = state_56704__$1;
(statearr_56724_56742[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__2468__auto____0 = (function (){
var statearr_56725 = [null,null,null,null,null,null,null,null,null];
(statearr_56725[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__2468__auto__);

(statearr_56725[(1)] = (1));

return statearr_56725;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__2468__auto____1 = (function (state_56704){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_56704);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e56726){var ex__2471__auto__ = e56726;
var statearr_56727_56743 = state_56704;
(statearr_56727_56743[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_56704[(4)]))){
var statearr_56728_56744 = state_56704;
(statearr_56728_56744[(1)] = cljs.core.first.call(null,(state_56704[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56745 = state_56704;
state_56704 = G__56745;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__2468__auto__ = function(state_56704){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2468__auto____1.call(this,state_56704);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_56729 = f__2491__auto__.call(null);
(statearr_56729[(6)] = c__2490__auto__);

return statearr_56729;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_56772){
var state_val_56773 = (state_56772[(1)]);
if((state_val_56773 === (7))){
var state_56772__$1 = state_56772;
var statearr_56774_56793 = state_56772__$1;
(statearr_56774_56793[(2)] = x);

(statearr_56774_56793[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56773 === (1))){
var state_56772__$1 = state_56772;
var statearr_56775_56794 = state_56772__$1;
(statearr_56775_56794[(2)] = null);

(statearr_56775_56794[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56773 === (4))){
var inst_56746 = (state_56772[(2)]);
var state_56772__$1 = state_56772;
var statearr_56776_56795 = state_56772__$1;
(statearr_56776_56795[(2)] = inst_56746);

(statearr_56776_56795[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56773 === (6))){
var state_56772__$1 = state_56772;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56772__$1,(9),x);
} else {
if((state_val_56773 === (3))){
var inst_56770 = (state_56772[(2)]);
var state_56772__$1 = state_56772;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56772__$1,inst_56770);
} else {
if((state_val_56773 === (2))){
var _ = (function (){var statearr_56778 = state_56772;
(statearr_56778[(4)] = cljs.core.cons.call(null,(5),(state_56772[(4)])));

return statearr_56778;
})();
var inst_56752 = fluree.db.util.async.channel_QMARK_.call(null,x);
var state_56772__$1 = state_56772;
if(inst_56752){
var statearr_56779_56796 = state_56772__$1;
(statearr_56779_56796[(1)] = (6));

} else {
var statearr_56780_56797 = state_56772__$1;
(statearr_56780_56797[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56773 === (9))){
var inst_56755 = (state_56772[(2)]);
var inst_56756 = fluree.db.util.async.throw_err.call(null,inst_56755);
var state_56772__$1 = state_56772;
var statearr_56781_56798 = state_56772__$1;
(statearr_56781_56798[(2)] = inst_56756);

(statearr_56781_56798[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56773 === (5))){
var _ = (function (){var statearr_56782 = state_56772;
(statearr_56782[(4)] = cljs.core.rest.call(null,(state_56772[(4)])));

return statearr_56782;
})();
var state_56772__$1 = state_56772;
var ex56777 = (state_56772__$1[(2)]);
var statearr_56783_56799 = state_56772__$1;
(statearr_56783_56799[(5)] = ex56777);


if((ex56777 instanceof Error)){
var statearr_56784_56800 = state_56772__$1;
(statearr_56784_56800[(1)] = (4));

(statearr_56784_56800[(5)] = null);

} else {
throw ex56777;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56773 === (8))){
var inst_56759 = (state_56772[(2)]);
var inst_56760 = fluree.db.dbfunctions.internal.boolean$.call(null,inst_56759);
var inst_56761 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56762 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56763 = ["boolean",inst_56759,inst_56760];
var inst_56764 = cljs.core.PersistentHashMap.fromArrays(inst_56762,inst_56763);
var inst_56765 = [inst_56764,(10)];
var inst_56766 = (new cljs.core.PersistentVector(null,2,(5),inst_56761,inst_56765,null));
var inst_56767 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56766);
var _ = (function (){var statearr_56785 = state_56772;
(statearr_56785[(4)] = cljs.core.rest.call(null,(state_56772[(4)])));

return statearr_56785;
})();
var state_56772__$1 = (function (){var statearr_56786 = state_56772;
(statearr_56786[(7)] = inst_56767);

return statearr_56786;
})();
var statearr_56787_56801 = state_56772__$1;
(statearr_56787_56801[(2)] = inst_56760);

(statearr_56787_56801[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2468__auto____0 = (function (){
var statearr_56788 = [null,null,null,null,null,null,null,null];
(statearr_56788[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__2468__auto__);

(statearr_56788[(1)] = (1));

return statearr_56788;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2468__auto____1 = (function (state_56772){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_56772);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e56789){var ex__2471__auto__ = e56789;
var statearr_56790_56802 = state_56772;
(statearr_56790_56802[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_56772[(4)]))){
var statearr_56791_56803 = state_56772;
(statearr_56791_56803[(1)] = cljs.core.first.call(null,(state_56772[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56804 = state_56772;
state_56772 = G__56804;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__2468__auto__ = function(state_56772){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2468__auto____1.call(this,state_56772);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_56792 = f__2491__auto__.call(null);
(statearr_56792[(6)] = c__2490__auto__);

return statearr_56792;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_56842){
var state_val_56843 = (state_56842[(1)]);
if((state_val_56843 === (7))){
var state_56842__$1 = state_56842;
var statearr_56844_56868 = state_56842__$1;
(statearr_56844_56868[(2)] = pattern);

(statearr_56844_56868[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56843 === (1))){
var state_56842__$1 = state_56842;
var statearr_56845_56869 = state_56842__$1;
(statearr_56845_56869[(2)] = null);

(statearr_56845_56869[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56843 === (4))){
var inst_56805 = (state_56842[(2)]);
var state_56842__$1 = state_56842;
var statearr_56846_56870 = state_56842__$1;
(statearr_56846_56870[(2)] = inst_56805);

(statearr_56846_56870[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56843 === (13))){
var inst_56822 = (state_56842[(2)]);
var inst_56823 = fluree.db.util.async.throw_err.call(null,inst_56822);
var state_56842__$1 = state_56842;
var statearr_56847_56871 = state_56842__$1;
(statearr_56847_56871[(2)] = inst_56823);

(statearr_56847_56871[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56843 === (6))){
var state_56842__$1 = state_56842;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56842__$1,(9),pattern);
} else {
if((state_val_56843 === (3))){
var inst_56840 = (state_56842[(2)]);
var state_56842__$1 = state_56842;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56842__$1,inst_56840);
} else {
if((state_val_56843 === (12))){
var inst_56818 = (state_56842[(7)]);
var inst_56826 = (state_56842[(2)]);
var inst_56827 = fluree.db.dbfunctions.internal.re_find.call(null,inst_56818,inst_56826);
var inst_56828 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56829 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56830 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56831 = [inst_56818,inst_56826];
var inst_56832 = (new cljs.core.PersistentVector(null,2,(5),inst_56830,inst_56831,null));
var inst_56833 = ["re-find",inst_56832,inst_56827];
var inst_56834 = cljs.core.PersistentHashMap.fromArrays(inst_56829,inst_56833);
var inst_56835 = [inst_56834,(10)];
var inst_56836 = (new cljs.core.PersistentVector(null,2,(5),inst_56828,inst_56835,null));
var inst_56837 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56836);
var _ = (function (){var statearr_56848 = state_56842;
(statearr_56848[(4)] = cljs.core.rest.call(null,(state_56842[(4)])));

return statearr_56848;
})();
var state_56842__$1 = (function (){var statearr_56849 = state_56842;
(statearr_56849[(8)] = inst_56837);

return statearr_56849;
})();
var statearr_56850_56872 = state_56842__$1;
(statearr_56850_56872[(2)] = inst_56827);

(statearr_56850_56872[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56843 === (2))){
var _ = (function (){var statearr_56851 = state_56842;
(statearr_56851[(4)] = cljs.core.cons.call(null,(5),(state_56842[(4)])));

return statearr_56851;
})();
var inst_56811 = fluree.db.util.async.channel_QMARK_.call(null,pattern);
var state_56842__$1 = state_56842;
if(inst_56811){
var statearr_56852_56873 = state_56842__$1;
(statearr_56852_56873[(1)] = (6));

} else {
var statearr_56853_56874 = state_56842__$1;
(statearr_56853_56874[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56843 === (11))){
var state_56842__$1 = state_56842;
var statearr_56855_56875 = state_56842__$1;
(statearr_56855_56875[(2)] = string);

(statearr_56855_56875[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56843 === (9))){
var inst_56814 = (state_56842[(2)]);
var inst_56815 = fluree.db.util.async.throw_err.call(null,inst_56814);
var state_56842__$1 = state_56842;
var statearr_56856_56876 = state_56842__$1;
(statearr_56856_56876[(2)] = inst_56815);

(statearr_56856_56876[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56843 === (5))){
var _ = (function (){var statearr_56857 = state_56842;
(statearr_56857[(4)] = cljs.core.rest.call(null,(state_56842[(4)])));

return statearr_56857;
})();
var state_56842__$1 = state_56842;
var ex56854 = (state_56842__$1[(2)]);
var statearr_56858_56877 = state_56842__$1;
(statearr_56858_56877[(5)] = ex56854);


if((ex56854 instanceof Error)){
var statearr_56859_56878 = state_56842__$1;
(statearr_56859_56878[(1)] = (4));

(statearr_56859_56878[(5)] = null);

} else {
throw ex56854;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56843 === (10))){
var state_56842__$1 = state_56842;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56842__$1,(13),string);
} else {
if((state_val_56843 === (8))){
var inst_56818 = (state_56842[(2)]);
var inst_56819 = fluree.db.util.async.channel_QMARK_.call(null,string);
var state_56842__$1 = (function (){var statearr_56860 = state_56842;
(statearr_56860[(7)] = inst_56818);

return statearr_56860;
})();
if(inst_56819){
var statearr_56861_56879 = state_56842__$1;
(statearr_56861_56879[(1)] = (10));

} else {
var statearr_56862_56880 = state_56842__$1;
(statearr_56862_56880[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2468__auto____0 = (function (){
var statearr_56863 = [null,null,null,null,null,null,null,null,null];
(statearr_56863[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__2468__auto__);

(statearr_56863[(1)] = (1));

return statearr_56863;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2468__auto____1 = (function (state_56842){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_56842);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e56864){var ex__2471__auto__ = e56864;
var statearr_56865_56881 = state_56842;
(statearr_56865_56881[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_56842[(4)]))){
var statearr_56866_56882 = state_56842;
(statearr_56866_56882[(1)] = cljs.core.first.call(null,(state_56842[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56883 = state_56842;
state_56842 = G__56883;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__2468__auto__ = function(state_56842){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2468__auto____1.call(this,state_56842);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_56867 = f__2491__auto__.call(null);
(statearr_56867[(6)] = c__2490__auto__);

return statearr_56867;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_56910){
var state_val_56911 = (state_56910[(1)]);
if((state_val_56911 === (7))){
var state_56910__$1 = state_56910;
var statearr_56912_56931 = state_56910__$1;
(statearr_56912_56931[(2)] = email);

(statearr_56912_56931[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56911 === (1))){
var state_56910__$1 = state_56910;
var statearr_56913_56932 = state_56910__$1;
(statearr_56913_56932[(2)] = null);

(statearr_56913_56932[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56911 === (4))){
var inst_56884 = (state_56910[(2)]);
var state_56910__$1 = state_56910;
var statearr_56914_56933 = state_56910__$1;
(statearr_56914_56933[(2)] = inst_56884);

(statearr_56914_56933[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56911 === (6))){
var state_56910__$1 = state_56910;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56910__$1,(9),email);
} else {
if((state_val_56911 === (3))){
var inst_56908 = (state_56910[(2)]);
var state_56910__$1 = state_56910;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56910__$1,inst_56908);
} else {
if((state_val_56911 === (2))){
var _ = (function (){var statearr_56916 = state_56910;
(statearr_56916[(4)] = cljs.core.cons.call(null,(5),(state_56910[(4)])));

return statearr_56916;
})();
var inst_56890 = fluree.db.util.async.channel_QMARK_.call(null,email);
var state_56910__$1 = state_56910;
if(inst_56890){
var statearr_56917_56934 = state_56910__$1;
(statearr_56917_56934[(1)] = (6));

} else {
var statearr_56918_56935 = state_56910__$1;
(statearr_56918_56935[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56911 === (9))){
var inst_56893 = (state_56910[(2)]);
var inst_56894 = fluree.db.util.async.throw_err.call(null,inst_56893);
var state_56910__$1 = state_56910;
var statearr_56919_56936 = state_56910__$1;
(statearr_56919_56936[(2)] = inst_56894);

(statearr_56919_56936[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56911 === (5))){
var _ = (function (){var statearr_56920 = state_56910;
(statearr_56920[(4)] = cljs.core.rest.call(null,(state_56910[(4)])));

return statearr_56920;
})();
var state_56910__$1 = state_56910;
var ex56915 = (state_56910__$1[(2)]);
var statearr_56921_56937 = state_56910__$1;
(statearr_56921_56937[(5)] = ex56915);


if((ex56915 instanceof Error)){
var statearr_56922_56938 = state_56910__$1;
(statearr_56922_56938[(1)] = (4));

(statearr_56922_56938[(5)] = null);

} else {
throw ex56915;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56911 === (8))){
var inst_56897 = (state_56910[(2)]);
var inst_56898 = fluree.db.dbfunctions.internal.valid_email_QMARK_.call(null,inst_56897);
var inst_56899 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56900 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56901 = ["re-find",inst_56897,inst_56898];
var inst_56902 = cljs.core.PersistentHashMap.fromArrays(inst_56900,inst_56901);
var inst_56903 = [inst_56902,(10)];
var inst_56904 = (new cljs.core.PersistentVector(null,2,(5),inst_56899,inst_56903,null));
var inst_56905 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56904);
var _ = (function (){var statearr_56923 = state_56910;
(statearr_56923[(4)] = cljs.core.rest.call(null,(state_56910[(4)])));

return statearr_56923;
})();
var state_56910__$1 = (function (){var statearr_56924 = state_56910;
(statearr_56924[(7)] = inst_56905);

return statearr_56924;
})();
var statearr_56925_56939 = state_56910__$1;
(statearr_56925_56939[(2)] = inst_56898);

(statearr_56925_56939[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2468__auto____0 = (function (){
var statearr_56926 = [null,null,null,null,null,null,null,null];
(statearr_56926[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2468__auto__);

(statearr_56926[(1)] = (1));

return statearr_56926;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2468__auto____1 = (function (state_56910){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_56910);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e56927){var ex__2471__auto__ = e56927;
var statearr_56928_56940 = state_56910;
(statearr_56928_56940[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_56910[(4)]))){
var statearr_56929_56941 = state_56910;
(statearr_56929_56941[(1)] = cljs.core.first.call(null,(state_56910[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56942 = state_56910;
state_56910 = G__56942;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2468__auto__ = function(state_56910){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2468__auto____1.call(this,state_56910);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_56930 = f__2491__auto__.call(null);
(statearr_56930[(6)] = c__2490__auto__);

return statearr_56930;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_56989){
var state_val_56990 = (state_56989[(1)]);
if((state_val_56990 === (7))){
var inst_56959 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_56989__$1 = state_56989;
if(cljs.core.truth_(inst_56959)){
var statearr_56991_57018 = state_56989__$1;
(statearr_56991_57018[(1)] = (9));

} else {
var statearr_56992_57019 = state_56989__$1;
(statearr_56992_57019[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56990 === (1))){
var state_56989__$1 = state_56989;
var statearr_56993_57020 = state_56989__$1;
(statearr_56993_57020[(2)] = null);

(statearr_56993_57020[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56990 === (4))){
var inst_56943 = (state_56989[(2)]);
var state_56989__$1 = state_56989;
var statearr_56994_57021 = state_56989__$1;
(statearr_56994_57021[(2)] = inst_56943);

(statearr_56994_57021[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56990 === (15))){
var inst_56970 = (state_56989[(2)]);
var state_56989__$1 = state_56989;
var statearr_56995_57022 = state_56989__$1;
(statearr_56995_57022[(2)] = inst_56970);

(statearr_56995_57022[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56990 === (13))){
var inst_56967 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_56989__$1 = state_56989;
var statearr_56996_57023 = state_56989__$1;
(statearr_56996_57023[(2)] = inst_56967);

(statearr_56996_57023[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56990 === (6))){
var inst_56954 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56955 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56956 = [inst_56955,(0)];
var inst_56957 = (new cljs.core.PersistentVector(null,2,(5),inst_56954,inst_56956,null));
var state_56989__$1 = state_56989;
var statearr_56997_57024 = state_56989__$1;
(statearr_56997_57024[(2)] = inst_56957);

(statearr_56997_57024[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56990 === (3))){
var inst_56987 = (state_56989[(2)]);
var state_56989__$1 = state_56989;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56989__$1,inst_56987);
} else {
if((state_val_56990 === (12))){
var inst_56963 = (state_56989[(2)]);
var inst_56964 = fluree.db.util.async.throw_err.call(null,inst_56963);
var state_56989__$1 = state_56989;
var statearr_56998_57025 = state_56989__$1;
(statearr_56998_57025[(2)] = inst_56964);

(statearr_56998_57025[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56990 === (2))){
var _ = (function (){var statearr_56999 = state_56989;
(statearr_56999[(4)] = cljs.core.cons.call(null,(5),(state_56989[(4)])));

return statearr_56999;
})();
var inst_56952 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_56989__$1 = state_56989;
if(cljs.core.truth_(inst_56952)){
var statearr_57000_57026 = state_56989__$1;
(statearr_57000_57026[(1)] = (6));

} else {
var statearr_57001_57027 = state_56989__$1;
(statearr_57001_57027[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56990 === (11))){
var inst_56972 = (state_56989[(2)]);
var state_56989__$1 = state_56989;
var statearr_57003_57028 = state_56989__$1;
(statearr_57003_57028[(2)] = inst_56972);

(statearr_57003_57028[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56990 === (9))){
var inst_56961 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth.call(null,_QMARK_ctx);
var state_56989__$1 = state_56989;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56989__$1,(12),inst_56961);
} else {
if((state_val_56990 === (5))){
var _ = (function (){var statearr_57004 = state_56989;
(statearr_57004[(4)] = cljs.core.rest.call(null,(state_56989[(4)])));

return statearr_57004;
})();
var state_56989__$1 = state_56989;
var ex57002 = (state_56989__$1[(2)]);
var statearr_57005_57029 = state_56989__$1;
(statearr_57005_57029[(5)] = ex57002);


if((ex57002 instanceof Error)){
var statearr_57006_57030 = state_56989__$1;
(statearr_57006_57030[(1)] = (4));

(statearr_57006_57030[(5)] = null);

} else {
throw ex57002;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56990 === (14))){
var state_56989__$1 = state_56989;
var statearr_57007_57031 = state_56989__$1;
(statearr_57007_57031[(2)] = null);

(statearr_57007_57031[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56990 === (10))){
var state_56989__$1 = state_56989;
var statearr_57008_57032 = state_56989__$1;
(statearr_57008_57032[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56990 === (8))){
var inst_56974 = (state_56989[(2)]);
var inst_56975 = cljs.core.nth.call(null,inst_56974,(0),null);
var inst_56976 = cljs.core.nth.call(null,inst_56974,(1),null);
var inst_56977 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56978 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56979 = ["?user_id","?ctx",inst_56975];
var inst_56980 = cljs.core.PersistentHashMap.fromArrays(inst_56978,inst_56979);
var inst_56981 = ((10) + inst_56976);
var inst_56982 = [inst_56980,inst_56981];
var inst_56983 = (new cljs.core.PersistentVector(null,2,(5),inst_56977,inst_56982,null));
var inst_56984 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56983);
var _ = (function (){var statearr_57010 = state_56989;
(statearr_57010[(4)] = cljs.core.rest.call(null,(state_56989[(4)])));

return statearr_57010;
})();
var state_56989__$1 = (function (){var statearr_57011 = state_56989;
(statearr_57011[(7)] = inst_56984);

return statearr_57011;
})();
var statearr_57012_57033 = state_56989__$1;
(statearr_57012_57033[(2)] = inst_56975);

(statearr_57012_57033[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2468__auto____0 = (function (){
var statearr_57013 = [null,null,null,null,null,null,null,null];
(statearr_57013[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2468__auto__);

(statearr_57013[(1)] = (1));

return statearr_57013;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2468__auto____1 = (function (state_56989){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_56989);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e57014){var ex__2471__auto__ = e57014;
var statearr_57015_57034 = state_56989;
(statearr_57015_57034[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_56989[(4)]))){
var statearr_57016_57035 = state_56989;
(statearr_57016_57035[(1)] = cljs.core.first.call(null,(state_56989[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57036 = state_56989;
state_56989 = G__57036;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2468__auto__ = function(state_56989){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2468__auto____1.call(this,state_56989);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_57017 = f__2491__auto__.call(null);
(statearr_57017[(6)] = c__2490__auto__);

return statearr_57017;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_57064){
var state_val_57065 = (state_57064[(1)]);
if((state_val_57065 === (7))){
var inst_57057 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_57064__$1 = state_57064;
var statearr_57066_57085 = state_57064__$1;
(statearr_57066_57085[(2)] = inst_57057);

(statearr_57066_57085[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57065 === (1))){
var state_57064__$1 = state_57064;
var statearr_57067_57086 = state_57064__$1;
(statearr_57067_57086[(2)] = null);

(statearr_57067_57086[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57065 === (4))){
var inst_57037 = (state_57064[(2)]);
var state_57064__$1 = state_57064;
var statearr_57068_57087 = state_57064__$1;
(statearr_57068_57087[(2)] = inst_57037);

(statearr_57068_57087[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57065 === (6))){
var inst_57045 = fluree.db.dbfunctions.internal._QMARK_auth_id.call(null,_QMARK_ctx);
var state_57064__$1 = state_57064;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57064__$1,(9),inst_57045);
} else {
if((state_val_57065 === (3))){
var inst_57062 = (state_57064[(2)]);
var state_57064__$1 = state_57064;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57064__$1,inst_57062);
} else {
if((state_val_57065 === (2))){
var _ = (function (){var statearr_57070 = state_57064;
(statearr_57070[(4)] = cljs.core.cons.call(null,(5),(state_57064[(4)])));

return statearr_57070;
})();
var inst_57043 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57064__$1 = state_57064;
if(cljs.core.truth_(inst_57043)){
var statearr_57071_57088 = state_57064__$1;
(statearr_57071_57088[(1)] = (6));

} else {
var statearr_57072_57089 = state_57064__$1;
(statearr_57072_57089[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57065 === (9))){
var inst_57047 = (state_57064[(2)]);
var inst_57048 = fluree.db.util.async.throw_err.call(null,inst_57047);
var inst_57049 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57050 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57051 = ["?auth_id","?ctx",inst_57048];
var inst_57052 = cljs.core.PersistentHashMap.fromArrays(inst_57050,inst_57051);
var inst_57053 = [inst_57052,(10)];
var inst_57054 = (new cljs.core.PersistentVector(null,2,(5),inst_57049,inst_57053,null));
var inst_57055 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57054);
var state_57064__$1 = (function (){var statearr_57073 = state_57064;
(statearr_57073[(7)] = inst_57055);

return statearr_57073;
})();
var statearr_57074_57090 = state_57064__$1;
(statearr_57074_57090[(2)] = inst_57048);

(statearr_57074_57090[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57065 === (5))){
var _ = (function (){var statearr_57075 = state_57064;
(statearr_57075[(4)] = cljs.core.rest.call(null,(state_57064[(4)])));

return statearr_57075;
})();
var state_57064__$1 = state_57064;
var ex57069 = (state_57064__$1[(2)]);
var statearr_57076_57091 = state_57064__$1;
(statearr_57076_57091[(5)] = ex57069);


if((ex57069 instanceof Error)){
var statearr_57077_57092 = state_57064__$1;
(statearr_57077_57092[(1)] = (4));

(statearr_57077_57092[(5)] = null);

} else {
throw ex57069;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57065 === (8))){
var inst_57059 = (state_57064[(2)]);
var _ = (function (){var statearr_57078 = state_57064;
(statearr_57078[(4)] = cljs.core.rest.call(null,(state_57064[(4)])));

return statearr_57078;
})();
var state_57064__$1 = state_57064;
var statearr_57079_57093 = state_57064__$1;
(statearr_57079_57093[(2)] = inst_57059);

(statearr_57079_57093[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2468__auto____0 = (function (){
var statearr_57080 = [null,null,null,null,null,null,null,null];
(statearr_57080[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2468__auto__);

(statearr_57080[(1)] = (1));

return statearr_57080;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2468__auto____1 = (function (state_57064){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_57064);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e57081){var ex__2471__auto__ = e57081;
var statearr_57082_57094 = state_57064;
(statearr_57082_57094[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_57064[(4)]))){
var statearr_57083_57095 = state_57064;
(statearr_57083_57095[(1)] = cljs.core.first.call(null,(state_57064[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57096 = state_57064;
state_57064 = G__57096;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2468__auto__ = function(state_57064){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2468__auto____1.call(this,state_57064);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_57084 = f__2491__auto__.call(null);
(statearr_57084[(6)] = c__2490__auto__);

return statearr_57084;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objT",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objF",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"flakes",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__57098 = arguments.length;
switch (G__57098) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.call(null,_QMARK_ctx,max,new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx).toEpochMilli());
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_57140){
var state_val_57141 = (state_57140[(1)]);
if((state_val_57141 === (7))){
var state_57140__$1 = state_57140;
var statearr_57142_57172 = state_57140__$1;
(statearr_57142_57172[(2)] = seed);

(statearr_57142_57172[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57141 === (1))){
var state_57140__$1 = state_57140;
var statearr_57143_57173 = state_57140__$1;
(statearr_57143_57173[(2)] = null);

(statearr_57143_57173[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57141 === (4))){
var inst_57099 = (state_57140[(2)]);
var state_57140__$1 = state_57140;
var statearr_57144_57174 = state_57140__$1;
(statearr_57144_57174[(2)] = inst_57099);

(statearr_57144_57174[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57141 === (15))){
var state_57140__$1 = state_57140;
var statearr_57145_57175 = state_57140__$1;
(statearr_57145_57175[(2)] = (10));

(statearr_57145_57175[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57141 === (13))){
var inst_57116 = (state_57140[(2)]);
var inst_57117 = fluree.db.util.async.throw_err.call(null,inst_57116);
var state_57140__$1 = state_57140;
var statearr_57146_57176 = state_57140__$1;
(statearr_57146_57176[(2)] = inst_57117);

(statearr_57146_57176[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57141 === (6))){
var state_57140__$1 = state_57140;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57140__$1,(9),seed);
} else {
if((state_val_57141 === (3))){
var inst_57138 = (state_57140[(2)]);
var state_57140__$1 = state_57140;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57140__$1,inst_57138);
} else {
if((state_val_57141 === (12))){
var inst_57120 = (state_57140[(7)]);
var inst_57120__$1 = (state_57140[(2)]);
var state_57140__$1 = (function (){var statearr_57147 = state_57140;
(statearr_57147[(7)] = inst_57120__$1);

return statearr_57147;
})();
if(cljs.core.truth_(inst_57120__$1)){
var statearr_57148_57177 = state_57140__$1;
(statearr_57148_57177[(1)] = (14));

} else {
var statearr_57149_57178 = state_57140__$1;
(statearr_57149_57178[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57141 === (2))){
var _ = (function (){var statearr_57150 = state_57140;
(statearr_57150[(4)] = cljs.core.cons.call(null,(5),(state_57140[(4)])));

return statearr_57150;
})();
var inst_57105 = fluree.db.util.async.channel_QMARK_.call(null,seed);
var state_57140__$1 = state_57140;
if(inst_57105){
var statearr_57151_57179 = state_57140__$1;
(statearr_57151_57179[(1)] = (6));

} else {
var statearr_57152_57180 = state_57140__$1;
(statearr_57152_57180[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57141 === (11))){
var state_57140__$1 = state_57140;
var statearr_57154_57181 = state_57140__$1;
(statearr_57154_57181[(2)] = max);

(statearr_57154_57181[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57141 === (9))){
var inst_57108 = (state_57140[(2)]);
var inst_57109 = fluree.db.util.async.throw_err.call(null,inst_57108);
var state_57140__$1 = state_57140;
var statearr_57155_57182 = state_57140__$1;
(statearr_57155_57182[(2)] = inst_57109);

(statearr_57155_57182[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57141 === (5))){
var _ = (function (){var statearr_57156 = state_57140;
(statearr_57156[(4)] = cljs.core.rest.call(null,(state_57140[(4)])));

return statearr_57156;
})();
var state_57140__$1 = state_57140;
var ex57153 = (state_57140__$1[(2)]);
var statearr_57157_57183 = state_57140__$1;
(statearr_57157_57183[(5)] = ex57153);


if((ex57153 instanceof Error)){
var statearr_57158_57184 = state_57140__$1;
(statearr_57158_57184[(1)] = (4));

(statearr_57158_57184[(5)] = null);

} else {
throw ex57153;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57141 === (14))){
var inst_57120 = (state_57140[(7)]);
var state_57140__$1 = state_57140;
var statearr_57159_57185 = state_57140__$1;
(statearr_57159_57185[(2)] = inst_57120);

(statearr_57159_57185[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57141 === (16))){
var inst_57112 = (state_57140[(8)]);
var inst_57124 = (state_57140[(2)]);
var inst_57125 = fluree.db.dbfunctions.internal.rand.call(null,inst_57112,inst_57124);
var inst_57126 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57127 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57128 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57129 = [seed,max];
var inst_57130 = (new cljs.core.PersistentVector(null,2,(5),inst_57128,inst_57129,null));
var inst_57131 = ["rand",inst_57130,inst_57125];
var inst_57132 = cljs.core.PersistentHashMap.fromArrays(inst_57127,inst_57131);
var inst_57133 = [inst_57132,(10)];
var inst_57134 = (new cljs.core.PersistentVector(null,2,(5),inst_57126,inst_57133,null));
var inst_57135 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57134);
var _ = (function (){var statearr_57160 = state_57140;
(statearr_57160[(4)] = cljs.core.rest.call(null,(state_57140[(4)])));

return statearr_57160;
})();
var state_57140__$1 = (function (){var statearr_57161 = state_57140;
(statearr_57161[(9)] = inst_57135);

return statearr_57161;
})();
var statearr_57162_57186 = state_57140__$1;
(statearr_57162_57186[(2)] = inst_57125);

(statearr_57162_57186[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57141 === (10))){
var state_57140__$1 = state_57140;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57140__$1,(13),max);
} else {
if((state_val_57141 === (8))){
var inst_57112 = (state_57140[(2)]);
var inst_57113 = fluree.db.util.async.channel_QMARK_.call(null,max);
var state_57140__$1 = (function (){var statearr_57163 = state_57140;
(statearr_57163[(8)] = inst_57112);

return statearr_57163;
})();
if(inst_57113){
var statearr_57164_57187 = state_57140__$1;
(statearr_57164_57187[(1)] = (10));

} else {
var statearr_57165_57188 = state_57140__$1;
(statearr_57165_57188[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2468__auto____0 = (function (){
var statearr_57166 = [null,null,null,null,null,null,null,null,null,null];
(statearr_57166[(0)] = fluree$db$dbfunctions$fns$state_machine__2468__auto__);

(statearr_57166[(1)] = (1));

return statearr_57166;
});
var fluree$db$dbfunctions$fns$state_machine__2468__auto____1 = (function (state_57140){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_57140);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e57167){var ex__2471__auto__ = e57167;
var statearr_57168_57189 = state_57140;
(statearr_57168_57189[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_57140[(4)]))){
var statearr_57169_57190 = state_57140;
(statearr_57169_57190[(1)] = cljs.core.first.call(null,(state_57140[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57191 = state_57140;
state_57140 = G__57191;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2468__auto__ = function(state_57140){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2468__auto____1.call(this,state_57140);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_57170 = f__2491__auto__.call(null);
(statearr_57170[(6)] = c__2490__auto__);

return statearr_57170;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_57212){
var state_val_57213 = (state_57212[(1)]);
if((state_val_57213 === (1))){
var state_57212__$1 = state_57212;
var statearr_57214_57229 = state_57212__$1;
(statearr_57214_57229[(2)] = null);

(statearr_57214_57229[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57213 === (2))){
var _ = (function (){var statearr_57215 = state_57212;
(statearr_57215[(4)] = cljs.core.cons.call(null,(5),(state_57212[(4)])));

return statearr_57215;
})();
var inst_57198 = fluree.db.util.core.random_uuid.call(null);
var inst_57199 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_57198);
var inst_57200 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57201 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57202 = cljs.core.PersistentVector.EMPTY;
var inst_57203 = ["uuid",inst_57202,inst_57199];
var inst_57204 = cljs.core.PersistentHashMap.fromArrays(inst_57201,inst_57203);
var inst_57205 = [inst_57204,(10)];
var inst_57206 = (new cljs.core.PersistentVector(null,2,(5),inst_57200,inst_57205,null));
var inst_57207 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57206);
var ___$1 = (function (){var statearr_57216 = state_57212;
(statearr_57216[(4)] = cljs.core.rest.call(null,(state_57212[(4)])));

return statearr_57216;
})();
var state_57212__$1 = (function (){var statearr_57217 = state_57212;
(statearr_57217[(7)] = inst_57207);

return statearr_57217;
})();
var statearr_57218_57230 = state_57212__$1;
(statearr_57218_57230[(2)] = inst_57199);

(statearr_57218_57230[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57213 === (3))){
var inst_57210 = (state_57212[(2)]);
var state_57212__$1 = state_57212;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57212__$1,inst_57210);
} else {
if((state_val_57213 === (4))){
var inst_57192 = (state_57212[(2)]);
var state_57212__$1 = state_57212;
var statearr_57220_57231 = state_57212__$1;
(statearr_57220_57231[(2)] = inst_57192);

(statearr_57220_57231[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57213 === (5))){
var _ = (function (){var statearr_57221 = state_57212;
(statearr_57221[(4)] = cljs.core.rest.call(null,(state_57212[(4)])));

return statearr_57221;
})();
var state_57212__$1 = state_57212;
var ex57219 = (state_57212__$1[(2)]);
var statearr_57222_57232 = state_57212__$1;
(statearr_57222_57232[(5)] = ex57219);


if((ex57219 instanceof Error)){
var statearr_57223_57233 = state_57212__$1;
(statearr_57223_57233[(1)] = (4));

(statearr_57223_57233[(5)] = null);

} else {
throw ex57219;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2468__auto____0 = (function (){
var statearr_57224 = [null,null,null,null,null,null,null,null];
(statearr_57224[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__2468__auto__);

(statearr_57224[(1)] = (1));

return statearr_57224;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2468__auto____1 = (function (state_57212){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_57212);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e57225){var ex__2471__auto__ = e57225;
var statearr_57226_57234 = state_57212;
(statearr_57226_57234[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_57212[(4)]))){
var statearr_57227_57235 = state_57212;
(statearr_57227_57235[(1)] = cljs.core.first.call(null,(state_57212[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57236 = state_57212;
state_57212 = G__57236;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__2468__auto__ = function(state_57212){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2468__auto____1.call(this,state_57212);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_57228 = f__2491__auto__.call(null);
(statearr_57228[(6)] = c__2490__auto__);

return statearr_57228;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_57266){
var state_val_57267 = (state_57266[(1)]);
if((state_val_57267 === (7))){
var state_57266__$1 = state_57266;
var statearr_57268_57287 = state_57266__$1;
(statearr_57268_57287[(2)] = num);

(statearr_57268_57287[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57267 === (1))){
var state_57266__$1 = state_57266;
var statearr_57269_57288 = state_57266__$1;
(statearr_57269_57288[(2)] = null);

(statearr_57269_57288[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57267 === (4))){
var inst_57237 = (state_57266[(2)]);
var state_57266__$1 = state_57266;
var statearr_57270_57289 = state_57266__$1;
(statearr_57270_57289[(2)] = inst_57237);

(statearr_57270_57289[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57267 === (6))){
var state_57266__$1 = state_57266;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57266__$1,(9),num);
} else {
if((state_val_57267 === (3))){
var inst_57264 = (state_57266[(2)]);
var state_57266__$1 = state_57266;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57266__$1,inst_57264);
} else {
if((state_val_57267 === (2))){
var _ = (function (){var statearr_57272 = state_57266;
(statearr_57272[(4)] = cljs.core.cons.call(null,(5),(state_57266[(4)])));

return statearr_57272;
})();
var inst_57243 = fluree.db.util.async.channel_QMARK_.call(null,num);
var state_57266__$1 = state_57266;
if(inst_57243){
var statearr_57273_57290 = state_57266__$1;
(statearr_57273_57290[(1)] = (6));

} else {
var statearr_57274_57291 = state_57266__$1;
(statearr_57274_57291[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57267 === (9))){
var inst_57246 = (state_57266[(2)]);
var inst_57247 = fluree.db.util.async.throw_err.call(null,inst_57246);
var state_57266__$1 = state_57266;
var statearr_57275_57292 = state_57266__$1;
(statearr_57275_57292[(2)] = inst_57247);

(statearr_57275_57292[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57267 === (5))){
var _ = (function (){var statearr_57276 = state_57266;
(statearr_57276[(4)] = cljs.core.rest.call(null,(state_57266[(4)])));

return statearr_57276;
})();
var state_57266__$1 = state_57266;
var ex57271 = (state_57266__$1[(2)]);
var statearr_57277_57293 = state_57266__$1;
(statearr_57277_57293[(5)] = ex57271);


if((ex57271 instanceof Error)){
var statearr_57278_57294 = state_57266__$1;
(statearr_57278_57294[(1)] = (4));

(statearr_57278_57294[(5)] = null);

} else {
throw ex57271;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57267 === (8))){
var inst_57250 = (state_57266[(2)]);
var inst_57251 = fluree.db.dbfunctions.internal.ceil.call(null,inst_57250);
var inst_57252 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57253 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57254 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57255 = [fluree.db.dbfunctions.fns.ceil];
var inst_57256 = (new cljs.core.PersistentVector(null,1,(5),inst_57254,inst_57255,null));
var inst_57257 = ["",inst_57256,inst_57251];
var inst_57258 = cljs.core.PersistentHashMap.fromArrays(inst_57253,inst_57257);
var inst_57259 = [inst_57258,(10)];
var inst_57260 = (new cljs.core.PersistentVector(null,2,(5),inst_57252,inst_57259,null));
var inst_57261 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57260);
var _ = (function (){var statearr_57279 = state_57266;
(statearr_57279[(4)] = cljs.core.rest.call(null,(state_57266[(4)])));

return statearr_57279;
})();
var state_57266__$1 = (function (){var statearr_57280 = state_57266;
(statearr_57280[(7)] = inst_57261);

return statearr_57280;
})();
var statearr_57281_57295 = state_57266__$1;
(statearr_57281_57295[(2)] = inst_57251);

(statearr_57281_57295[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2468__auto____0 = (function (){
var statearr_57282 = [null,null,null,null,null,null,null,null];
(statearr_57282[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__2468__auto__);

(statearr_57282[(1)] = (1));

return statearr_57282;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2468__auto____1 = (function (state_57266){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_57266);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e57283){var ex__2471__auto__ = e57283;
var statearr_57284_57296 = state_57266;
(statearr_57284_57296[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_57266[(4)]))){
var statearr_57285_57297 = state_57266;
(statearr_57285_57297[(1)] = cljs.core.first.call(null,(state_57266[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57298 = state_57266;
state_57266 = G__57298;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__2468__auto__ = function(state_57266){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2468__auto____1.call(this,state_57266);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_57286 = f__2491__auto__.call(null);
(statearr_57286[(6)] = c__2490__auto__);

return statearr_57286;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_57328){
var state_val_57329 = (state_57328[(1)]);
if((state_val_57329 === (7))){
var state_57328__$1 = state_57328;
var statearr_57330_57349 = state_57328__$1;
(statearr_57330_57349[(2)] = num);

(statearr_57330_57349[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57329 === (1))){
var state_57328__$1 = state_57328;
var statearr_57331_57350 = state_57328__$1;
(statearr_57331_57350[(2)] = null);

(statearr_57331_57350[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57329 === (4))){
var inst_57299 = (state_57328[(2)]);
var state_57328__$1 = state_57328;
var statearr_57332_57351 = state_57328__$1;
(statearr_57332_57351[(2)] = inst_57299);

(statearr_57332_57351[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57329 === (6))){
var state_57328__$1 = state_57328;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57328__$1,(9),num);
} else {
if((state_val_57329 === (3))){
var inst_57326 = (state_57328[(2)]);
var state_57328__$1 = state_57328;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57328__$1,inst_57326);
} else {
if((state_val_57329 === (2))){
var _ = (function (){var statearr_57334 = state_57328;
(statearr_57334[(4)] = cljs.core.cons.call(null,(5),(state_57328[(4)])));

return statearr_57334;
})();
var inst_57305 = fluree.db.util.async.channel_QMARK_.call(null,num);
var state_57328__$1 = state_57328;
if(inst_57305){
var statearr_57335_57352 = state_57328__$1;
(statearr_57335_57352[(1)] = (6));

} else {
var statearr_57336_57353 = state_57328__$1;
(statearr_57336_57353[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57329 === (9))){
var inst_57308 = (state_57328[(2)]);
var inst_57309 = fluree.db.util.async.throw_err.call(null,inst_57308);
var state_57328__$1 = state_57328;
var statearr_57337_57354 = state_57328__$1;
(statearr_57337_57354[(2)] = inst_57309);

(statearr_57337_57354[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57329 === (5))){
var _ = (function (){var statearr_57338 = state_57328;
(statearr_57338[(4)] = cljs.core.rest.call(null,(state_57328[(4)])));

return statearr_57338;
})();
var state_57328__$1 = state_57328;
var ex57333 = (state_57328__$1[(2)]);
var statearr_57339_57355 = state_57328__$1;
(statearr_57339_57355[(5)] = ex57333);


if((ex57333 instanceof Error)){
var statearr_57340_57356 = state_57328__$1;
(statearr_57340_57356[(1)] = (4));

(statearr_57340_57356[(5)] = null);

} else {
throw ex57333;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57329 === (8))){
var inst_57312 = (state_57328[(2)]);
var inst_57313 = fluree.db.dbfunctions.internal.floor.call(null,inst_57312);
var inst_57314 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57315 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57316 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57317 = [fluree.db.dbfunctions.fns.floor];
var inst_57318 = (new cljs.core.PersistentVector(null,1,(5),inst_57316,inst_57317,null));
var inst_57319 = ["",inst_57318,inst_57313];
var inst_57320 = cljs.core.PersistentHashMap.fromArrays(inst_57315,inst_57319);
var inst_57321 = [inst_57320,(10)];
var inst_57322 = (new cljs.core.PersistentVector(null,2,(5),inst_57314,inst_57321,null));
var inst_57323 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57322);
var _ = (function (){var statearr_57341 = state_57328;
(statearr_57341[(4)] = cljs.core.rest.call(null,(state_57328[(4)])));

return statearr_57341;
})();
var state_57328__$1 = (function (){var statearr_57342 = state_57328;
(statearr_57342[(7)] = inst_57323);

return statearr_57342;
})();
var statearr_57343_57357 = state_57328__$1;
(statearr_57343_57357[(2)] = inst_57313);

(statearr_57343_57357[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__2468__auto____0 = (function (){
var statearr_57344 = [null,null,null,null,null,null,null,null];
(statearr_57344[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__2468__auto__);

(statearr_57344[(1)] = (1));

return statearr_57344;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__2468__auto____1 = (function (state_57328){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_57328);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e57345){var ex__2471__auto__ = e57345;
var statearr_57346_57358 = state_57328;
(statearr_57346_57358[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_57328[(4)]))){
var statearr_57347_57359 = state_57328;
(statearr_57347_57359[(1)] = cljs.core.first.call(null,(state_57328[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57360 = state_57328;
state_57328 = G__57360;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__2468__auto__ = function(state_57328){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2468__auto____1.call(this,state_57328);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__2468__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__2468__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_57348 = f__2491__auto__.call(null);
(statearr_57348[(6)] = c__2490__auto__);

return statearr_57348;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});

//# sourceMappingURL=fns.js.map
