// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.call(null,(function (m,p__2435){
var vec__2436 = p__2435;
var i = cljs.core.nth.call(null,vec__2436,(0),null);
var v = cljs.core.nth.call(null,vec__2436,(1),null);
return cljs.core.assoc.call(null,m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.call(null,(function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources.call(null,sources);
return (function (a,b){
return cljs.core.compare.call(null,sources__$1.call(null,a),sources__$1.call(null,b));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__2439 = seg;
var gcol = cljs.core.nth.call(null,vec__2439,(0),null);
var source = cljs.core.nth.call(null,vec__2439,(1),null);
var line = cljs.core.nth.call(null,vec__2439,(2),null);
var col = cljs.core.nth.call(null,vec__2439,(3),null);
var name = cljs.core.nth.call(null,vec__2439,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(goog.object.get(source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,seg));
if(cljs.core.truth_(temp__5735__auto__)){
var name__$1 = temp__5735__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__2442 = seg;
var gcol = cljs.core.nth.call(null,vec__2442,(0),null);
var source = cljs.core.nth.call(null,vec__2442,(1),null);
var line = cljs.core.nth.call(null,vec__2442,(2),null);
var col = cljs.core.nth.call(null,vec__2442,(3),null);
var name = cljs.core.nth.call(null,vec__2442,(4),null);
var vec__2445 = relseg;
var rgcol = cljs.core.nth.call(null,vec__2445,(0),null);
var rsource = cljs.core.nth.call(null,vec__2445,(1),null);
var rline = cljs.core.nth.call(null,vec__2445,(2),null);
var rcol = cljs.core.nth.call(null,vec__2445,(3),null);
var rname = cljs.core.nth.call(null,vec__2445,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4126__auto__ = source;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4126__auto__ = line;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4126__auto__ = col;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4126__auto__ = name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta.call(null,nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__2448 = segmap;
var map__2448__$1 = (((((!((map__2448 == null))))?(((((map__2448.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__2448.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__2448):map__2448);
var gcol = cljs.core.get.call(null,map__2448__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.call(null,map__2448__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.call(null,map__2448__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.call(null,map__2448__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.call(null,map__2448__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.call(null,d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.call(null,result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.call(null,(function (m){
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.call(null,(function (m__$1){
return cljs.core.update_in.call(null,m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.call(null,(function (v){
return cljs.core.conj.call(null,v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map.call(null)));
}),cljs.core.sorted_map.call(null)));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__2451 = arguments.length;
switch (G__2451) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.call(null,goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq.call(null,clojure.string.split.call(null,mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by.call(null,cljs.source_map.source_compare.call(null,sources));
while(true){
if(lines__$1){
var line = cljs.core.first.call(null,lines__$1);
var vec__2455 = ((clojure.string.blank_QMARK_.call(null,line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq.call(null,clojure.string.split.call(null,line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first.call(null,segs__$1);
var nrelseg = cljs.source_map.seg_combine.call(null,cljs.source_map.base64_vlq.decode.call(null,seg),relseg__$1);
var G__2459 = cljs.core.next.call(null,segs__$1);
var G__2460 = nrelseg;
var G__2461 = cljs.source_map.update_reverse_result.call(null,result__$1,cljs.source_map.seg__GT_map.call(null,nrelseg,source_map),gline);
segs__$1 = G__2459;
relseg__$1 = G__2460;
result__$1 = G__2461;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.call(null,vec__2455,(0),null);
var relseg__$1 = cljs.core.nth.call(null,vec__2455,(1),null);
var G__2462 = (gline + (1));
var G__2463 = cljs.core.next.call(null,lines__$1);
var G__2464 = cljs.core.assoc.call(null,relseg__$1,(0),(0));
var G__2465 = result__$1;
gline = G__2462;
lines__$1 = G__2463;
relseg = G__2464;
result = G__2465;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__2467 = segmap;
var map__2467__$1 = (((((!((map__2467 == null))))?(((((map__2467.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__2467.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__2467):map__2467);
var gcol = cljs.core.get.call(null,map__2467__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.call(null,map__2467__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.call(null,map__2467__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.call(null,map__2467__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.call(null,map__2467__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.call(null,d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.call(null,result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.call(null,(function (m){
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.call(null,(function (p1__2466_SHARP_){
return cljs.core.conj.call(null,p1__2466_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map.call(null)));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__2470 = arguments.length;
switch (G__2470) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.call(null,goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq.call(null,clojure.string.split.call(null,mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first.call(null,lines__$1);
var vec__2474 = ((clojure.string.blank_QMARK_.call(null,line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq.call(null,clojure.string.split.call(null,line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first.call(null,segs__$1);
var nrelseg = cljs.source_map.seg_combine.call(null,cljs.source_map.base64_vlq.decode.call(null,seg),relseg__$1);
var G__2478 = cljs.core.next.call(null,segs__$1);
var G__2479 = nrelseg;
var G__2480 = cljs.source_map.update_result.call(null,result__$1,cljs.source_map.seg__GT_map.call(null,nrelseg,source_map),gline);
segs__$1 = G__2478;
relseg__$1 = G__2479;
result__$1 = G__2480;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.call(null,vec__2474,(0),null);
var relseg__$1 = cljs.core.nth.call(null,vec__2474,(1),null);
var G__2481 = (gline + (1));
var G__2482 = cljs.core.next.call(null,lines__$1);
var G__2483 = cljs.core.assoc.call(null,relseg__$1,(0),(0));
var G__2484 = result__$1;
gline = G__2481;
lines__$1 = G__2482;
relseg = G__2483;
result = G__2484;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.call(null,(function (segs,cols){
cljs.core.swap_BANG_.call(null,relseg,(function (p__2485){
var vec__2486 = p__2485;
var _ = cljs.core.nth.call(null,vec__2486,(0),null);
var source = cljs.core.nth.call(null,vec__2486,(1),null);
var line = cljs.core.nth.call(null,vec__2486,(2),null);
var col = cljs.core.nth.call(null,vec__2486,(3),null);
var name = cljs.core.nth.call(null,vec__2486,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.call(null,segs,cljs.core.reduce.call(null,(function (cols__$1,p__2489){
var vec__2490 = p__2489;
var gcol = cljs.core.nth.call(null,vec__2490,(0),null);
var sidx = cljs.core.nth.call(null,vec__2490,(1),null);
var line = cljs.core.nth.call(null,vec__2490,(2),null);
var col = cljs.core.nth.call(null,vec__2490,(3),null);
var name = cljs.core.nth.call(null,vec__2490,(4),null);
var seg = vec__2490;
var offset = cljs.core.map.call(null,cljs.core._,seg,cljs.core.deref.call(null,relseg));
cljs.core.swap_BANG_.call(null,relseg,(function (p__2493){
var vec__2494 = p__2493;
var _ = cljs.core.nth.call(null,vec__2494,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__2494,(1),null);
var ___$2 = cljs.core.nth.call(null,vec__2494,(2),null);
var ___$3 = cljs.core.nth.call(null,vec__2494,(3),null);
var lname = cljs.core.nth.call(null,vec__2494,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4126__auto__ = name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.call(null,cols__$1,cljs.source_map.base64_vlq.encode.call(null,offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.call(null,(0));
var preamble_lines = cljs.core.take.call(null,(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.call(null,cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5733__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5733__auto__)){
var name = temp__5733__auto__;
var idx = (function (){var temp__5733__auto____$1 = cljs.core.get.call(null,cljs.core.deref.call(null,names__GT_idx),name);
if(cljs.core.truth_(temp__5733__auto____$1)){
var idx = temp__5733__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref.call(null,name_idx);
cljs.core.swap_BANG_.call(null,names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.call(null,name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.call(null,segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__2500 = cljs.core.seq.call(null,infos);
var chunk__2501 = null;
var count__2502 = (0);
var i__2503 = (0);
while(true){
if((i__2503 < count__2502)){
var info = cljs.core._nth.call(null,chunk__2501,i__2503);
var segv_2854 = info__GT_segv.call(null,info,source_idx,line,col);
var gline_2855 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_2856 = cljs.core.count.call(null,cljs.core.deref.call(null,lines));
if((gline_2855 > (lc_2856 - (1)))){
cljs.core.swap_BANG_.call(null,lines,((function (seq__2500,chunk__2501,count__2502,i__2503,segv_2854,gline_2855,lc_2856,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.call(null,cljs.core.into.call(null,lines__$1,cljs.core.repeat.call(null,((gline_2855 - (lc_2856 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_2854], null));
});})(seq__2500,chunk__2501,count__2502,i__2503,segv_2854,gline_2855,lc_2856,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.call(null,lines,((function (seq__2500,chunk__2501,count__2502,i__2503,segv_2854,gline_2855,lc_2856,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.call(null,lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_2855], null),cljs.core.conj,segv_2854);
});})(seq__2500,chunk__2501,count__2502,i__2503,segv_2854,gline_2855,lc_2856,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__2857 = seq__2500;
var G__2858 = chunk__2501;
var G__2859 = count__2502;
var G__2860 = (i__2503 + (1));
seq__2500 = G__2857;
chunk__2501 = G__2858;
count__2502 = G__2859;
i__2503 = G__2860;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__2500);
if(temp__5735__auto__){
var seq__2500__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__2500__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__2500__$1);
var G__2861 = cljs.core.chunk_rest.call(null,seq__2500__$1);
var G__2862 = c__4556__auto__;
var G__2863 = cljs.core.count.call(null,c__4556__auto__);
var G__2864 = (0);
seq__2500 = G__2861;
chunk__2501 = G__2862;
count__2502 = G__2863;
i__2503 = G__2864;
continue;
} else {
var info = cljs.core.first.call(null,seq__2500__$1);
var segv_2865 = info__GT_segv.call(null,info,source_idx,line,col);
var gline_2866 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_2867 = cljs.core.count.call(null,cljs.core.deref.call(null,lines));
if((gline_2866 > (lc_2867 - (1)))){
cljs.core.swap_BANG_.call(null,lines,((function (seq__2500,chunk__2501,count__2502,i__2503,segv_2865,gline_2866,lc_2867,info,seq__2500__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.call(null,cljs.core.into.call(null,lines__$1,cljs.core.repeat.call(null,((gline_2866 - (lc_2867 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_2865], null));
});})(seq__2500,chunk__2501,count__2502,i__2503,segv_2865,gline_2866,lc_2867,info,seq__2500__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.call(null,lines,((function (seq__2500,chunk__2501,count__2502,i__2503,segv_2865,gline_2866,lc_2867,info,seq__2500__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.call(null,lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_2866], null),cljs.core.conj,segv_2865);
});})(seq__2500,chunk__2501,count__2502,i__2503,segv_2865,gline_2866,lc_2867,info,seq__2500__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__2868 = cljs.core.next.call(null,seq__2500__$1);
var G__2869 = null;
var G__2870 = (0);
var G__2871 = (0);
seq__2500 = G__2868;
chunk__2501 = G__2869;
count__2502 = G__2870;
i__2503 = G__2871;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__2504_2872 = cljs.core.seq.call(null,cljs.core.map_indexed.call(null,((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__2505_2873 = null;
var count__2506_2874 = (0);
var i__2507_2875 = (0);
while(true){
if((i__2507_2875 < count__2506_2874)){
var vec__2680_2876 = cljs.core._nth.call(null,chunk__2505_2873,i__2507_2875);
var source_idx_2877 = cljs.core.nth.call(null,vec__2680_2876,(0),null);
var vec__2683_2878 = cljs.core.nth.call(null,vec__2680_2876,(1),null);
var __2879 = cljs.core.nth.call(null,vec__2683_2878,(0),null);
var lines_2880__$1 = cljs.core.nth.call(null,vec__2683_2878,(1),null);
var seq__2686_2881 = cljs.core.seq.call(null,lines_2880__$1);
var chunk__2687_2882 = null;
var count__2688_2883 = (0);
var i__2689_2884 = (0);
while(true){
if((i__2689_2884 < count__2688_2883)){
var vec__2728_2885 = cljs.core._nth.call(null,chunk__2687_2882,i__2689_2884);
var line_2886 = cljs.core.nth.call(null,vec__2728_2885,(0),null);
var cols_2887 = cljs.core.nth.call(null,vec__2728_2885,(1),null);
var seq__2731_2888 = cljs.core.seq.call(null,cols_2887);
var chunk__2732_2889 = null;
var count__2733_2890 = (0);
var i__2734_2891 = (0);
while(true){
if((i__2734_2891 < count__2733_2890)){
var vec__2741_2892 = cljs.core._nth.call(null,chunk__2732_2889,i__2734_2891);
var col_2893 = cljs.core.nth.call(null,vec__2741_2892,(0),null);
var infos_2894 = cljs.core.nth.call(null,vec__2741_2892,(1),null);
encode_cols.call(null,infos_2894,source_idx_2877,line_2886,col_2893);


var G__2895 = seq__2731_2888;
var G__2896 = chunk__2732_2889;
var G__2897 = count__2733_2890;
var G__2898 = (i__2734_2891 + (1));
seq__2731_2888 = G__2895;
chunk__2732_2889 = G__2896;
count__2733_2890 = G__2897;
i__2734_2891 = G__2898;
continue;
} else {
var temp__5735__auto___2899 = cljs.core.seq.call(null,seq__2731_2888);
if(temp__5735__auto___2899){
var seq__2731_2900__$1 = temp__5735__auto___2899;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__2731_2900__$1)){
var c__4556__auto___2901 = cljs.core.chunk_first.call(null,seq__2731_2900__$1);
var G__2902 = cljs.core.chunk_rest.call(null,seq__2731_2900__$1);
var G__2903 = c__4556__auto___2901;
var G__2904 = cljs.core.count.call(null,c__4556__auto___2901);
var G__2905 = (0);
seq__2731_2888 = G__2902;
chunk__2732_2889 = G__2903;
count__2733_2890 = G__2904;
i__2734_2891 = G__2905;
continue;
} else {
var vec__2744_2906 = cljs.core.first.call(null,seq__2731_2900__$1);
var col_2907 = cljs.core.nth.call(null,vec__2744_2906,(0),null);
var infos_2908 = cljs.core.nth.call(null,vec__2744_2906,(1),null);
encode_cols.call(null,infos_2908,source_idx_2877,line_2886,col_2907);


var G__2909 = cljs.core.next.call(null,seq__2731_2900__$1);
var G__2910 = null;
var G__2911 = (0);
var G__2912 = (0);
seq__2731_2888 = G__2909;
chunk__2732_2889 = G__2910;
count__2733_2890 = G__2911;
i__2734_2891 = G__2912;
continue;
}
} else {
}
}
break;
}


var G__2913 = seq__2686_2881;
var G__2914 = chunk__2687_2882;
var G__2915 = count__2688_2883;
var G__2916 = (i__2689_2884 + (1));
seq__2686_2881 = G__2913;
chunk__2687_2882 = G__2914;
count__2688_2883 = G__2915;
i__2689_2884 = G__2916;
continue;
} else {
var temp__5735__auto___2917 = cljs.core.seq.call(null,seq__2686_2881);
if(temp__5735__auto___2917){
var seq__2686_2918__$1 = temp__5735__auto___2917;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__2686_2918__$1)){
var c__4556__auto___2919 = cljs.core.chunk_first.call(null,seq__2686_2918__$1);
var G__2920 = cljs.core.chunk_rest.call(null,seq__2686_2918__$1);
var G__2921 = c__4556__auto___2919;
var G__2922 = cljs.core.count.call(null,c__4556__auto___2919);
var G__2923 = (0);
seq__2686_2881 = G__2920;
chunk__2687_2882 = G__2921;
count__2688_2883 = G__2922;
i__2689_2884 = G__2923;
continue;
} else {
var vec__2747_2924 = cljs.core.first.call(null,seq__2686_2918__$1);
var line_2925 = cljs.core.nth.call(null,vec__2747_2924,(0),null);
var cols_2926 = cljs.core.nth.call(null,vec__2747_2924,(1),null);
var seq__2750_2927 = cljs.core.seq.call(null,cols_2926);
var chunk__2751_2928 = null;
var count__2752_2929 = (0);
var i__2753_2930 = (0);
while(true){
if((i__2753_2930 < count__2752_2929)){
var vec__2760_2931 = cljs.core._nth.call(null,chunk__2751_2928,i__2753_2930);
var col_2932 = cljs.core.nth.call(null,vec__2760_2931,(0),null);
var infos_2933 = cljs.core.nth.call(null,vec__2760_2931,(1),null);
encode_cols.call(null,infos_2933,source_idx_2877,line_2925,col_2932);


var G__2934 = seq__2750_2927;
var G__2935 = chunk__2751_2928;
var G__2936 = count__2752_2929;
var G__2937 = (i__2753_2930 + (1));
seq__2750_2927 = G__2934;
chunk__2751_2928 = G__2935;
count__2752_2929 = G__2936;
i__2753_2930 = G__2937;
continue;
} else {
var temp__5735__auto___2938__$1 = cljs.core.seq.call(null,seq__2750_2927);
if(temp__5735__auto___2938__$1){
var seq__2750_2939__$1 = temp__5735__auto___2938__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__2750_2939__$1)){
var c__4556__auto___2940 = cljs.core.chunk_first.call(null,seq__2750_2939__$1);
var G__2941 = cljs.core.chunk_rest.call(null,seq__2750_2939__$1);
var G__2942 = c__4556__auto___2940;
var G__2943 = cljs.core.count.call(null,c__4556__auto___2940);
var G__2944 = (0);
seq__2750_2927 = G__2941;
chunk__2751_2928 = G__2942;
count__2752_2929 = G__2943;
i__2753_2930 = G__2944;
continue;
} else {
var vec__2763_2945 = cljs.core.first.call(null,seq__2750_2939__$1);
var col_2946 = cljs.core.nth.call(null,vec__2763_2945,(0),null);
var infos_2947 = cljs.core.nth.call(null,vec__2763_2945,(1),null);
encode_cols.call(null,infos_2947,source_idx_2877,line_2925,col_2946);


var G__2948 = cljs.core.next.call(null,seq__2750_2939__$1);
var G__2949 = null;
var G__2950 = (0);
var G__2951 = (0);
seq__2750_2927 = G__2948;
chunk__2751_2928 = G__2949;
count__2752_2929 = G__2950;
i__2753_2930 = G__2951;
continue;
}
} else {
}
}
break;
}


var G__2952 = cljs.core.next.call(null,seq__2686_2918__$1);
var G__2953 = null;
var G__2954 = (0);
var G__2955 = (0);
seq__2686_2881 = G__2952;
chunk__2687_2882 = G__2953;
count__2688_2883 = G__2954;
i__2689_2884 = G__2955;
continue;
}
} else {
}
}
break;
}


var G__2956 = seq__2504_2872;
var G__2957 = chunk__2505_2873;
var G__2958 = count__2506_2874;
var G__2959 = (i__2507_2875 + (1));
seq__2504_2872 = G__2956;
chunk__2505_2873 = G__2957;
count__2506_2874 = G__2958;
i__2507_2875 = G__2959;
continue;
} else {
var temp__5735__auto___2960 = cljs.core.seq.call(null,seq__2504_2872);
if(temp__5735__auto___2960){
var seq__2504_2961__$1 = temp__5735__auto___2960;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__2504_2961__$1)){
var c__4556__auto___2962 = cljs.core.chunk_first.call(null,seq__2504_2961__$1);
var G__2963 = cljs.core.chunk_rest.call(null,seq__2504_2961__$1);
var G__2964 = c__4556__auto___2962;
var G__2965 = cljs.core.count.call(null,c__4556__auto___2962);
var G__2966 = (0);
seq__2504_2872 = G__2963;
chunk__2505_2873 = G__2964;
count__2506_2874 = G__2965;
i__2507_2875 = G__2966;
continue;
} else {
var vec__2766_2967 = cljs.core.first.call(null,seq__2504_2961__$1);
var source_idx_2968 = cljs.core.nth.call(null,vec__2766_2967,(0),null);
var vec__2769_2969 = cljs.core.nth.call(null,vec__2766_2967,(1),null);
var __2970 = cljs.core.nth.call(null,vec__2769_2969,(0),null);
var lines_2971__$1 = cljs.core.nth.call(null,vec__2769_2969,(1),null);
var seq__2772_2972 = cljs.core.seq.call(null,lines_2971__$1);
var chunk__2773_2973 = null;
var count__2774_2974 = (0);
var i__2775_2975 = (0);
while(true){
if((i__2775_2975 < count__2774_2974)){
var vec__2814_2976 = cljs.core._nth.call(null,chunk__2773_2973,i__2775_2975);
var line_2977 = cljs.core.nth.call(null,vec__2814_2976,(0),null);
var cols_2978 = cljs.core.nth.call(null,vec__2814_2976,(1),null);
var seq__2817_2979 = cljs.core.seq.call(null,cols_2978);
var chunk__2818_2980 = null;
var count__2819_2981 = (0);
var i__2820_2982 = (0);
while(true){
if((i__2820_2982 < count__2819_2981)){
var vec__2827_2983 = cljs.core._nth.call(null,chunk__2818_2980,i__2820_2982);
var col_2984 = cljs.core.nth.call(null,vec__2827_2983,(0),null);
var infos_2985 = cljs.core.nth.call(null,vec__2827_2983,(1),null);
encode_cols.call(null,infos_2985,source_idx_2968,line_2977,col_2984);


var G__2986 = seq__2817_2979;
var G__2987 = chunk__2818_2980;
var G__2988 = count__2819_2981;
var G__2989 = (i__2820_2982 + (1));
seq__2817_2979 = G__2986;
chunk__2818_2980 = G__2987;
count__2819_2981 = G__2988;
i__2820_2982 = G__2989;
continue;
} else {
var temp__5735__auto___2990__$1 = cljs.core.seq.call(null,seq__2817_2979);
if(temp__5735__auto___2990__$1){
var seq__2817_2991__$1 = temp__5735__auto___2990__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__2817_2991__$1)){
var c__4556__auto___2992 = cljs.core.chunk_first.call(null,seq__2817_2991__$1);
var G__2993 = cljs.core.chunk_rest.call(null,seq__2817_2991__$1);
var G__2994 = c__4556__auto___2992;
var G__2995 = cljs.core.count.call(null,c__4556__auto___2992);
var G__2996 = (0);
seq__2817_2979 = G__2993;
chunk__2818_2980 = G__2994;
count__2819_2981 = G__2995;
i__2820_2982 = G__2996;
continue;
} else {
var vec__2830_2997 = cljs.core.first.call(null,seq__2817_2991__$1);
var col_2998 = cljs.core.nth.call(null,vec__2830_2997,(0),null);
var infos_2999 = cljs.core.nth.call(null,vec__2830_2997,(1),null);
encode_cols.call(null,infos_2999,source_idx_2968,line_2977,col_2998);


var G__3000 = cljs.core.next.call(null,seq__2817_2991__$1);
var G__3001 = null;
var G__3002 = (0);
var G__3003 = (0);
seq__2817_2979 = G__3000;
chunk__2818_2980 = G__3001;
count__2819_2981 = G__3002;
i__2820_2982 = G__3003;
continue;
}
} else {
}
}
break;
}


var G__3004 = seq__2772_2972;
var G__3005 = chunk__2773_2973;
var G__3006 = count__2774_2974;
var G__3007 = (i__2775_2975 + (1));
seq__2772_2972 = G__3004;
chunk__2773_2973 = G__3005;
count__2774_2974 = G__3006;
i__2775_2975 = G__3007;
continue;
} else {
var temp__5735__auto___3008__$1 = cljs.core.seq.call(null,seq__2772_2972);
if(temp__5735__auto___3008__$1){
var seq__2772_3009__$1 = temp__5735__auto___3008__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__2772_3009__$1)){
var c__4556__auto___3010 = cljs.core.chunk_first.call(null,seq__2772_3009__$1);
var G__3011 = cljs.core.chunk_rest.call(null,seq__2772_3009__$1);
var G__3012 = c__4556__auto___3010;
var G__3013 = cljs.core.count.call(null,c__4556__auto___3010);
var G__3014 = (0);
seq__2772_2972 = G__3011;
chunk__2773_2973 = G__3012;
count__2774_2974 = G__3013;
i__2775_2975 = G__3014;
continue;
} else {
var vec__2833_3015 = cljs.core.first.call(null,seq__2772_3009__$1);
var line_3016 = cljs.core.nth.call(null,vec__2833_3015,(0),null);
var cols_3017 = cljs.core.nth.call(null,vec__2833_3015,(1),null);
var seq__2836_3018 = cljs.core.seq.call(null,cols_3017);
var chunk__2837_3019 = null;
var count__2838_3020 = (0);
var i__2839_3021 = (0);
while(true){
if((i__2839_3021 < count__2838_3020)){
var vec__2846_3022 = cljs.core._nth.call(null,chunk__2837_3019,i__2839_3021);
var col_3023 = cljs.core.nth.call(null,vec__2846_3022,(0),null);
var infos_3024 = cljs.core.nth.call(null,vec__2846_3022,(1),null);
encode_cols.call(null,infos_3024,source_idx_2968,line_3016,col_3023);


var G__3025 = seq__2836_3018;
var G__3026 = chunk__2837_3019;
var G__3027 = count__2838_3020;
var G__3028 = (i__2839_3021 + (1));
seq__2836_3018 = G__3025;
chunk__2837_3019 = G__3026;
count__2838_3020 = G__3027;
i__2839_3021 = G__3028;
continue;
} else {
var temp__5735__auto___3029__$2 = cljs.core.seq.call(null,seq__2836_3018);
if(temp__5735__auto___3029__$2){
var seq__2836_3030__$1 = temp__5735__auto___3029__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__2836_3030__$1)){
var c__4556__auto___3031 = cljs.core.chunk_first.call(null,seq__2836_3030__$1);
var G__3032 = cljs.core.chunk_rest.call(null,seq__2836_3030__$1);
var G__3033 = c__4556__auto___3031;
var G__3034 = cljs.core.count.call(null,c__4556__auto___3031);
var G__3035 = (0);
seq__2836_3018 = G__3032;
chunk__2837_3019 = G__3033;
count__2838_3020 = G__3034;
i__2839_3021 = G__3035;
continue;
} else {
var vec__2849_3036 = cljs.core.first.call(null,seq__2836_3030__$1);
var col_3037 = cljs.core.nth.call(null,vec__2849_3036,(0),null);
var infos_3038 = cljs.core.nth.call(null,vec__2849_3036,(1),null);
encode_cols.call(null,infos_3038,source_idx_2968,line_3016,col_3037);


var G__3039 = cljs.core.next.call(null,seq__2836_3030__$1);
var G__3040 = null;
var G__3041 = (0);
var G__3042 = (0);
seq__2836_3018 = G__3039;
chunk__2837_3019 = G__3040;
count__2838_3020 = G__3041;
i__2839_3021 = G__3042;
continue;
}
} else {
}
}
break;
}


var G__3043 = cljs.core.next.call(null,seq__2772_3009__$1);
var G__3044 = null;
var G__3045 = (0);
var G__3046 = (0);
seq__2772_2972 = G__3043;
chunk__2773_2973 = G__3044;
count__2774_2974 = G__3045;
i__2775_2975 = G__3046;
continue;
}
} else {
}
}
break;
}


var G__3047 = cljs.core.next.call(null,seq__2504_2961__$1);
var G__3048 = null;
var G__3049 = (0);
var G__3050 = (0);
seq__2504_2872 = G__3047;
chunk__2505_2873 = G__3048;
count__2506_2874 = G__3049;
i__2507_2875 = G__3050;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__2852 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys.call(null,m);
var f = cljs.core.comp.call(null,((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__2497_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__2497_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__2498_SHARP_){
return cljs.core.last.call(null,clojure.string.split.call(null,p1__2498_SHARP_,/\//));
}));
return cljs.core.into_array.call(null,cljs.core.map.call(null,f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.call(null,";",cljs.core.map.call(null,(function (p1__2499_SHARP_){
return clojure.string.join.call(null,",",p1__2499_SHARP_);
}),cljs.source_map.lines__GT_segs.call(null,cljs.core.concat.call(null,preamble_lines,cljs.core.deref.call(null,lines))))), "names": cljs.core.into_array.call(null,cljs.core.map.call(null,clojure.set.map_invert.call(null,cljs.core.deref.call(null,names__GT_idx)),cljs.core.range.call(null,cljs.core.count.call(null,cljs.core.deref.call(null,names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__2853 = G__2852;
goog.object.set(G__2853,"sourcesContent",cljs.core.into_array.call(null,new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts)));

return G__2853;
} else {
return G__2852;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq.call(null,cljs_map);
var new_lines = cljs.core.sorted_map.call(null);
while(true){
if(line_map_seq){
var vec__3051 = cljs.core.first.call(null,line_map_seq);
var line = cljs.core.nth.call(null,vec__3051,(0),null);
var col_map = cljs.core.nth.call(null,vec__3051,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq.call(null,col_map);
var new_cols = cljs.core.sorted_map.call(null);
while(true){
if(col_map_seq){
var vec__3054 = cljs.core.first.call(null,col_map_seq);
var col = cljs.core.nth.call(null,vec__3054,(0),null);
var infos = cljs.core.nth.call(null,vec__3054,(1),null);
var G__3060 = cljs.core.next.call(null,col_map_seq);
var G__3061 = cljs.core.assoc.call(null,new_cols,col,cljs.core.reduce.call(null,((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__3054,col,infos,vec__3051,line,col_map){
return (function (v,p__3057){
var map__3058 = p__3057;
var map__3058__$1 = (((((!((map__3058 == null))))?(((((map__3058.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3058.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3058):map__3058);
var gline = cljs.core.get.call(null,map__3058__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.call(null,map__3058__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.call(null,v,cljs.core.get_in.call(null,js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__3054,col,infos,vec__3051,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__3060;
new_cols = G__3061;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__3062 = cljs.core.next.call(null,line_map_seq);
var G__3063 = cljs.core.assoc.call(null,new_lines,line,new_cols);
line_map_seq = G__3062;
new_lines = G__3063;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.call(null,cljs.core.sorted_map.call(null));
var seq__3064_3336 = cljs.core.seq.call(null,reverse_map);
var chunk__3065_3337 = null;
var count__3066_3338 = (0);
var i__3067_3339 = (0);
while(true){
if((i__3067_3339 < count__3066_3338)){
var vec__3202_3340 = cljs.core._nth.call(null,chunk__3065_3337,i__3067_3339);
var line_3341 = cljs.core.nth.call(null,vec__3202_3340,(0),null);
var columns_3342 = cljs.core.nth.call(null,vec__3202_3340,(1),null);
var seq__3205_3343 = cljs.core.seq.call(null,columns_3342);
var chunk__3206_3344 = null;
var count__3207_3345 = (0);
var i__3208_3346 = (0);
while(true){
if((i__3208_3346 < count__3207_3345)){
var vec__3239_3347 = cljs.core._nth.call(null,chunk__3206_3344,i__3208_3346);
var column_3348 = cljs.core.nth.call(null,vec__3239_3347,(0),null);
var column_info_3349 = cljs.core.nth.call(null,vec__3239_3347,(1),null);
var seq__3242_3350 = cljs.core.seq.call(null,column_info_3349);
var chunk__3243_3351 = null;
var count__3244_3352 = (0);
var i__3245_3353 = (0);
while(true){
if((i__3245_3353 < count__3244_3352)){
var map__3250_3354 = cljs.core._nth.call(null,chunk__3243_3351,i__3245_3353);
var map__3250_3355__$1 = (((((!((map__3250_3354 == null))))?(((((map__3250_3354.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3250_3354.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3250_3354):map__3250_3354);
var gline_3356 = cljs.core.get.call(null,map__3250_3355__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_3357 = cljs.core.get.call(null,map__3250_3355__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_3358 = cljs.core.get.call(null,map__3250_3355__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_3356], null),cljs.core.fnil.call(null,((function (seq__3242_3350,chunk__3243_3351,count__3244_3352,i__3245_3353,seq__3205_3343,chunk__3206_3344,count__3207_3345,i__3208_3346,seq__3064_3336,chunk__3065_3337,count__3066_3338,i__3067_3339,map__3250_3354,map__3250_3355__$1,gline_3356,gcol_3357,name_3358,vec__3239_3347,column_3348,column_info_3349,vec__3202_3340,line_3341,columns_3342,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_3357], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_3341,new cljs.core.Keyword(null,"col","col",-1959363084),column_3348,new cljs.core.Keyword(null,"name","name",1843675177),name_3358], null));
});})(seq__3242_3350,chunk__3243_3351,count__3244_3352,i__3245_3353,seq__3205_3343,chunk__3206_3344,count__3207_3345,i__3208_3346,seq__3064_3336,chunk__3065_3337,count__3066_3338,i__3067_3339,map__3250_3354,map__3250_3355__$1,gline_3356,gcol_3357,name_3358,vec__3239_3347,column_3348,column_info_3349,vec__3202_3340,line_3341,columns_3342,inverted))
,cljs.core.sorted_map.call(null)));


var G__3359 = seq__3242_3350;
var G__3360 = chunk__3243_3351;
var G__3361 = count__3244_3352;
var G__3362 = (i__3245_3353 + (1));
seq__3242_3350 = G__3359;
chunk__3243_3351 = G__3360;
count__3244_3352 = G__3361;
i__3245_3353 = G__3362;
continue;
} else {
var temp__5735__auto___3363 = cljs.core.seq.call(null,seq__3242_3350);
if(temp__5735__auto___3363){
var seq__3242_3364__$1 = temp__5735__auto___3363;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__3242_3364__$1)){
var c__4556__auto___3365 = cljs.core.chunk_first.call(null,seq__3242_3364__$1);
var G__3366 = cljs.core.chunk_rest.call(null,seq__3242_3364__$1);
var G__3367 = c__4556__auto___3365;
var G__3368 = cljs.core.count.call(null,c__4556__auto___3365);
var G__3369 = (0);
seq__3242_3350 = G__3366;
chunk__3243_3351 = G__3367;
count__3244_3352 = G__3368;
i__3245_3353 = G__3369;
continue;
} else {
var map__3252_3370 = cljs.core.first.call(null,seq__3242_3364__$1);
var map__3252_3371__$1 = (((((!((map__3252_3370 == null))))?(((((map__3252_3370.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3252_3370.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3252_3370):map__3252_3370);
var gline_3372 = cljs.core.get.call(null,map__3252_3371__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_3373 = cljs.core.get.call(null,map__3252_3371__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_3374 = cljs.core.get.call(null,map__3252_3371__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_3372], null),cljs.core.fnil.call(null,((function (seq__3242_3350,chunk__3243_3351,count__3244_3352,i__3245_3353,seq__3205_3343,chunk__3206_3344,count__3207_3345,i__3208_3346,seq__3064_3336,chunk__3065_3337,count__3066_3338,i__3067_3339,map__3252_3370,map__3252_3371__$1,gline_3372,gcol_3373,name_3374,seq__3242_3364__$1,temp__5735__auto___3363,vec__3239_3347,column_3348,column_info_3349,vec__3202_3340,line_3341,columns_3342,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_3373], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_3341,new cljs.core.Keyword(null,"col","col",-1959363084),column_3348,new cljs.core.Keyword(null,"name","name",1843675177),name_3374], null));
});})(seq__3242_3350,chunk__3243_3351,count__3244_3352,i__3245_3353,seq__3205_3343,chunk__3206_3344,count__3207_3345,i__3208_3346,seq__3064_3336,chunk__3065_3337,count__3066_3338,i__3067_3339,map__3252_3370,map__3252_3371__$1,gline_3372,gcol_3373,name_3374,seq__3242_3364__$1,temp__5735__auto___3363,vec__3239_3347,column_3348,column_info_3349,vec__3202_3340,line_3341,columns_3342,inverted))
,cljs.core.sorted_map.call(null)));


var G__3375 = cljs.core.next.call(null,seq__3242_3364__$1);
var G__3376 = null;
var G__3377 = (0);
var G__3378 = (0);
seq__3242_3350 = G__3375;
chunk__3243_3351 = G__3376;
count__3244_3352 = G__3377;
i__3245_3353 = G__3378;
continue;
}
} else {
}
}
break;
}


var G__3379 = seq__3205_3343;
var G__3380 = chunk__3206_3344;
var G__3381 = count__3207_3345;
var G__3382 = (i__3208_3346 + (1));
seq__3205_3343 = G__3379;
chunk__3206_3344 = G__3380;
count__3207_3345 = G__3381;
i__3208_3346 = G__3382;
continue;
} else {
var temp__5735__auto___3383 = cljs.core.seq.call(null,seq__3205_3343);
if(temp__5735__auto___3383){
var seq__3205_3384__$1 = temp__5735__auto___3383;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__3205_3384__$1)){
var c__4556__auto___3385 = cljs.core.chunk_first.call(null,seq__3205_3384__$1);
var G__3386 = cljs.core.chunk_rest.call(null,seq__3205_3384__$1);
var G__3387 = c__4556__auto___3385;
var G__3388 = cljs.core.count.call(null,c__4556__auto___3385);
var G__3389 = (0);
seq__3205_3343 = G__3386;
chunk__3206_3344 = G__3387;
count__3207_3345 = G__3388;
i__3208_3346 = G__3389;
continue;
} else {
var vec__3254_3390 = cljs.core.first.call(null,seq__3205_3384__$1);
var column_3391 = cljs.core.nth.call(null,vec__3254_3390,(0),null);
var column_info_3392 = cljs.core.nth.call(null,vec__3254_3390,(1),null);
var seq__3257_3393 = cljs.core.seq.call(null,column_info_3392);
var chunk__3258_3394 = null;
var count__3259_3395 = (0);
var i__3260_3396 = (0);
while(true){
if((i__3260_3396 < count__3259_3395)){
var map__3265_3397 = cljs.core._nth.call(null,chunk__3258_3394,i__3260_3396);
var map__3265_3398__$1 = (((((!((map__3265_3397 == null))))?(((((map__3265_3397.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3265_3397.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3265_3397):map__3265_3397);
var gline_3399 = cljs.core.get.call(null,map__3265_3398__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_3400 = cljs.core.get.call(null,map__3265_3398__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_3401 = cljs.core.get.call(null,map__3265_3398__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_3399], null),cljs.core.fnil.call(null,((function (seq__3257_3393,chunk__3258_3394,count__3259_3395,i__3260_3396,seq__3205_3343,chunk__3206_3344,count__3207_3345,i__3208_3346,seq__3064_3336,chunk__3065_3337,count__3066_3338,i__3067_3339,map__3265_3397,map__3265_3398__$1,gline_3399,gcol_3400,name_3401,vec__3254_3390,column_3391,column_info_3392,seq__3205_3384__$1,temp__5735__auto___3383,vec__3202_3340,line_3341,columns_3342,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_3400], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_3341,new cljs.core.Keyword(null,"col","col",-1959363084),column_3391,new cljs.core.Keyword(null,"name","name",1843675177),name_3401], null));
});})(seq__3257_3393,chunk__3258_3394,count__3259_3395,i__3260_3396,seq__3205_3343,chunk__3206_3344,count__3207_3345,i__3208_3346,seq__3064_3336,chunk__3065_3337,count__3066_3338,i__3067_3339,map__3265_3397,map__3265_3398__$1,gline_3399,gcol_3400,name_3401,vec__3254_3390,column_3391,column_info_3392,seq__3205_3384__$1,temp__5735__auto___3383,vec__3202_3340,line_3341,columns_3342,inverted))
,cljs.core.sorted_map.call(null)));


var G__3402 = seq__3257_3393;
var G__3403 = chunk__3258_3394;
var G__3404 = count__3259_3395;
var G__3405 = (i__3260_3396 + (1));
seq__3257_3393 = G__3402;
chunk__3258_3394 = G__3403;
count__3259_3395 = G__3404;
i__3260_3396 = G__3405;
continue;
} else {
var temp__5735__auto___3406__$1 = cljs.core.seq.call(null,seq__3257_3393);
if(temp__5735__auto___3406__$1){
var seq__3257_3407__$1 = temp__5735__auto___3406__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__3257_3407__$1)){
var c__4556__auto___3408 = cljs.core.chunk_first.call(null,seq__3257_3407__$1);
var G__3409 = cljs.core.chunk_rest.call(null,seq__3257_3407__$1);
var G__3410 = c__4556__auto___3408;
var G__3411 = cljs.core.count.call(null,c__4556__auto___3408);
var G__3412 = (0);
seq__3257_3393 = G__3409;
chunk__3258_3394 = G__3410;
count__3259_3395 = G__3411;
i__3260_3396 = G__3412;
continue;
} else {
var map__3267_3413 = cljs.core.first.call(null,seq__3257_3407__$1);
var map__3267_3414__$1 = (((((!((map__3267_3413 == null))))?(((((map__3267_3413.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3267_3413.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3267_3413):map__3267_3413);
var gline_3415 = cljs.core.get.call(null,map__3267_3414__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_3416 = cljs.core.get.call(null,map__3267_3414__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_3417 = cljs.core.get.call(null,map__3267_3414__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_3415], null),cljs.core.fnil.call(null,((function (seq__3257_3393,chunk__3258_3394,count__3259_3395,i__3260_3396,seq__3205_3343,chunk__3206_3344,count__3207_3345,i__3208_3346,seq__3064_3336,chunk__3065_3337,count__3066_3338,i__3067_3339,map__3267_3413,map__3267_3414__$1,gline_3415,gcol_3416,name_3417,seq__3257_3407__$1,temp__5735__auto___3406__$1,vec__3254_3390,column_3391,column_info_3392,seq__3205_3384__$1,temp__5735__auto___3383,vec__3202_3340,line_3341,columns_3342,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_3416], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_3341,new cljs.core.Keyword(null,"col","col",-1959363084),column_3391,new cljs.core.Keyword(null,"name","name",1843675177),name_3417], null));
});})(seq__3257_3393,chunk__3258_3394,count__3259_3395,i__3260_3396,seq__3205_3343,chunk__3206_3344,count__3207_3345,i__3208_3346,seq__3064_3336,chunk__3065_3337,count__3066_3338,i__3067_3339,map__3267_3413,map__3267_3414__$1,gline_3415,gcol_3416,name_3417,seq__3257_3407__$1,temp__5735__auto___3406__$1,vec__3254_3390,column_3391,column_info_3392,seq__3205_3384__$1,temp__5735__auto___3383,vec__3202_3340,line_3341,columns_3342,inverted))
,cljs.core.sorted_map.call(null)));


var G__3418 = cljs.core.next.call(null,seq__3257_3407__$1);
var G__3419 = null;
var G__3420 = (0);
var G__3421 = (0);
seq__3257_3393 = G__3418;
chunk__3258_3394 = G__3419;
count__3259_3395 = G__3420;
i__3260_3396 = G__3421;
continue;
}
} else {
}
}
break;
}


var G__3422 = cljs.core.next.call(null,seq__3205_3384__$1);
var G__3423 = null;
var G__3424 = (0);
var G__3425 = (0);
seq__3205_3343 = G__3422;
chunk__3206_3344 = G__3423;
count__3207_3345 = G__3424;
i__3208_3346 = G__3425;
continue;
}
} else {
}
}
break;
}


var G__3426 = seq__3064_3336;
var G__3427 = chunk__3065_3337;
var G__3428 = count__3066_3338;
var G__3429 = (i__3067_3339 + (1));
seq__3064_3336 = G__3426;
chunk__3065_3337 = G__3427;
count__3066_3338 = G__3428;
i__3067_3339 = G__3429;
continue;
} else {
var temp__5735__auto___3430 = cljs.core.seq.call(null,seq__3064_3336);
if(temp__5735__auto___3430){
var seq__3064_3431__$1 = temp__5735__auto___3430;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__3064_3431__$1)){
var c__4556__auto___3432 = cljs.core.chunk_first.call(null,seq__3064_3431__$1);
var G__3433 = cljs.core.chunk_rest.call(null,seq__3064_3431__$1);
var G__3434 = c__4556__auto___3432;
var G__3435 = cljs.core.count.call(null,c__4556__auto___3432);
var G__3436 = (0);
seq__3064_3336 = G__3433;
chunk__3065_3337 = G__3434;
count__3066_3338 = G__3435;
i__3067_3339 = G__3436;
continue;
} else {
var vec__3269_3437 = cljs.core.first.call(null,seq__3064_3431__$1);
var line_3438 = cljs.core.nth.call(null,vec__3269_3437,(0),null);
var columns_3439 = cljs.core.nth.call(null,vec__3269_3437,(1),null);
var seq__3272_3440 = cljs.core.seq.call(null,columns_3439);
var chunk__3273_3441 = null;
var count__3274_3442 = (0);
var i__3275_3443 = (0);
while(true){
if((i__3275_3443 < count__3274_3442)){
var vec__3306_3444 = cljs.core._nth.call(null,chunk__3273_3441,i__3275_3443);
var column_3445 = cljs.core.nth.call(null,vec__3306_3444,(0),null);
var column_info_3446 = cljs.core.nth.call(null,vec__3306_3444,(1),null);
var seq__3309_3447 = cljs.core.seq.call(null,column_info_3446);
var chunk__3310_3448 = null;
var count__3311_3449 = (0);
var i__3312_3450 = (0);
while(true){
if((i__3312_3450 < count__3311_3449)){
var map__3317_3451 = cljs.core._nth.call(null,chunk__3310_3448,i__3312_3450);
var map__3317_3452__$1 = (((((!((map__3317_3451 == null))))?(((((map__3317_3451.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3317_3451.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3317_3451):map__3317_3451);
var gline_3453 = cljs.core.get.call(null,map__3317_3452__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_3454 = cljs.core.get.call(null,map__3317_3452__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_3455 = cljs.core.get.call(null,map__3317_3452__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_3453], null),cljs.core.fnil.call(null,((function (seq__3309_3447,chunk__3310_3448,count__3311_3449,i__3312_3450,seq__3272_3440,chunk__3273_3441,count__3274_3442,i__3275_3443,seq__3064_3336,chunk__3065_3337,count__3066_3338,i__3067_3339,map__3317_3451,map__3317_3452__$1,gline_3453,gcol_3454,name_3455,vec__3306_3444,column_3445,column_info_3446,vec__3269_3437,line_3438,columns_3439,seq__3064_3431__$1,temp__5735__auto___3430,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_3454], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_3438,new cljs.core.Keyword(null,"col","col",-1959363084),column_3445,new cljs.core.Keyword(null,"name","name",1843675177),name_3455], null));
});})(seq__3309_3447,chunk__3310_3448,count__3311_3449,i__3312_3450,seq__3272_3440,chunk__3273_3441,count__3274_3442,i__3275_3443,seq__3064_3336,chunk__3065_3337,count__3066_3338,i__3067_3339,map__3317_3451,map__3317_3452__$1,gline_3453,gcol_3454,name_3455,vec__3306_3444,column_3445,column_info_3446,vec__3269_3437,line_3438,columns_3439,seq__3064_3431__$1,temp__5735__auto___3430,inverted))
,cljs.core.sorted_map.call(null)));


var G__3456 = seq__3309_3447;
var G__3457 = chunk__3310_3448;
var G__3458 = count__3311_3449;
var G__3459 = (i__3312_3450 + (1));
seq__3309_3447 = G__3456;
chunk__3310_3448 = G__3457;
count__3311_3449 = G__3458;
i__3312_3450 = G__3459;
continue;
} else {
var temp__5735__auto___3460__$1 = cljs.core.seq.call(null,seq__3309_3447);
if(temp__5735__auto___3460__$1){
var seq__3309_3461__$1 = temp__5735__auto___3460__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__3309_3461__$1)){
var c__4556__auto___3462 = cljs.core.chunk_first.call(null,seq__3309_3461__$1);
var G__3463 = cljs.core.chunk_rest.call(null,seq__3309_3461__$1);
var G__3464 = c__4556__auto___3462;
var G__3465 = cljs.core.count.call(null,c__4556__auto___3462);
var G__3466 = (0);
seq__3309_3447 = G__3463;
chunk__3310_3448 = G__3464;
count__3311_3449 = G__3465;
i__3312_3450 = G__3466;
continue;
} else {
var map__3319_3467 = cljs.core.first.call(null,seq__3309_3461__$1);
var map__3319_3468__$1 = (((((!((map__3319_3467 == null))))?(((((map__3319_3467.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3319_3467.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3319_3467):map__3319_3467);
var gline_3469 = cljs.core.get.call(null,map__3319_3468__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_3470 = cljs.core.get.call(null,map__3319_3468__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_3471 = cljs.core.get.call(null,map__3319_3468__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_3469], null),cljs.core.fnil.call(null,((function (seq__3309_3447,chunk__3310_3448,count__3311_3449,i__3312_3450,seq__3272_3440,chunk__3273_3441,count__3274_3442,i__3275_3443,seq__3064_3336,chunk__3065_3337,count__3066_3338,i__3067_3339,map__3319_3467,map__3319_3468__$1,gline_3469,gcol_3470,name_3471,seq__3309_3461__$1,temp__5735__auto___3460__$1,vec__3306_3444,column_3445,column_info_3446,vec__3269_3437,line_3438,columns_3439,seq__3064_3431__$1,temp__5735__auto___3430,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_3470], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_3438,new cljs.core.Keyword(null,"col","col",-1959363084),column_3445,new cljs.core.Keyword(null,"name","name",1843675177),name_3471], null));
});})(seq__3309_3447,chunk__3310_3448,count__3311_3449,i__3312_3450,seq__3272_3440,chunk__3273_3441,count__3274_3442,i__3275_3443,seq__3064_3336,chunk__3065_3337,count__3066_3338,i__3067_3339,map__3319_3467,map__3319_3468__$1,gline_3469,gcol_3470,name_3471,seq__3309_3461__$1,temp__5735__auto___3460__$1,vec__3306_3444,column_3445,column_info_3446,vec__3269_3437,line_3438,columns_3439,seq__3064_3431__$1,temp__5735__auto___3430,inverted))
,cljs.core.sorted_map.call(null)));


var G__3472 = cljs.core.next.call(null,seq__3309_3461__$1);
var G__3473 = null;
var G__3474 = (0);
var G__3475 = (0);
seq__3309_3447 = G__3472;
chunk__3310_3448 = G__3473;
count__3311_3449 = G__3474;
i__3312_3450 = G__3475;
continue;
}
} else {
}
}
break;
}


var G__3476 = seq__3272_3440;
var G__3477 = chunk__3273_3441;
var G__3478 = count__3274_3442;
var G__3479 = (i__3275_3443 + (1));
seq__3272_3440 = G__3476;
chunk__3273_3441 = G__3477;
count__3274_3442 = G__3478;
i__3275_3443 = G__3479;
continue;
} else {
var temp__5735__auto___3480__$1 = cljs.core.seq.call(null,seq__3272_3440);
if(temp__5735__auto___3480__$1){
var seq__3272_3481__$1 = temp__5735__auto___3480__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__3272_3481__$1)){
var c__4556__auto___3482 = cljs.core.chunk_first.call(null,seq__3272_3481__$1);
var G__3483 = cljs.core.chunk_rest.call(null,seq__3272_3481__$1);
var G__3484 = c__4556__auto___3482;
var G__3485 = cljs.core.count.call(null,c__4556__auto___3482);
var G__3486 = (0);
seq__3272_3440 = G__3483;
chunk__3273_3441 = G__3484;
count__3274_3442 = G__3485;
i__3275_3443 = G__3486;
continue;
} else {
var vec__3321_3487 = cljs.core.first.call(null,seq__3272_3481__$1);
var column_3488 = cljs.core.nth.call(null,vec__3321_3487,(0),null);
var column_info_3489 = cljs.core.nth.call(null,vec__3321_3487,(1),null);
var seq__3324_3490 = cljs.core.seq.call(null,column_info_3489);
var chunk__3325_3491 = null;
var count__3326_3492 = (0);
var i__3327_3493 = (0);
while(true){
if((i__3327_3493 < count__3326_3492)){
var map__3332_3494 = cljs.core._nth.call(null,chunk__3325_3491,i__3327_3493);
var map__3332_3495__$1 = (((((!((map__3332_3494 == null))))?(((((map__3332_3494.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3332_3494.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3332_3494):map__3332_3494);
var gline_3496 = cljs.core.get.call(null,map__3332_3495__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_3497 = cljs.core.get.call(null,map__3332_3495__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_3498 = cljs.core.get.call(null,map__3332_3495__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_3496], null),cljs.core.fnil.call(null,((function (seq__3324_3490,chunk__3325_3491,count__3326_3492,i__3327_3493,seq__3272_3440,chunk__3273_3441,count__3274_3442,i__3275_3443,seq__3064_3336,chunk__3065_3337,count__3066_3338,i__3067_3339,map__3332_3494,map__3332_3495__$1,gline_3496,gcol_3497,name_3498,vec__3321_3487,column_3488,column_info_3489,seq__3272_3481__$1,temp__5735__auto___3480__$1,vec__3269_3437,line_3438,columns_3439,seq__3064_3431__$1,temp__5735__auto___3430,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_3497], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_3438,new cljs.core.Keyword(null,"col","col",-1959363084),column_3488,new cljs.core.Keyword(null,"name","name",1843675177),name_3498], null));
});})(seq__3324_3490,chunk__3325_3491,count__3326_3492,i__3327_3493,seq__3272_3440,chunk__3273_3441,count__3274_3442,i__3275_3443,seq__3064_3336,chunk__3065_3337,count__3066_3338,i__3067_3339,map__3332_3494,map__3332_3495__$1,gline_3496,gcol_3497,name_3498,vec__3321_3487,column_3488,column_info_3489,seq__3272_3481__$1,temp__5735__auto___3480__$1,vec__3269_3437,line_3438,columns_3439,seq__3064_3431__$1,temp__5735__auto___3430,inverted))
,cljs.core.sorted_map.call(null)));


var G__3499 = seq__3324_3490;
var G__3500 = chunk__3325_3491;
var G__3501 = count__3326_3492;
var G__3502 = (i__3327_3493 + (1));
seq__3324_3490 = G__3499;
chunk__3325_3491 = G__3500;
count__3326_3492 = G__3501;
i__3327_3493 = G__3502;
continue;
} else {
var temp__5735__auto___3503__$2 = cljs.core.seq.call(null,seq__3324_3490);
if(temp__5735__auto___3503__$2){
var seq__3324_3504__$1 = temp__5735__auto___3503__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__3324_3504__$1)){
var c__4556__auto___3505 = cljs.core.chunk_first.call(null,seq__3324_3504__$1);
var G__3506 = cljs.core.chunk_rest.call(null,seq__3324_3504__$1);
var G__3507 = c__4556__auto___3505;
var G__3508 = cljs.core.count.call(null,c__4556__auto___3505);
var G__3509 = (0);
seq__3324_3490 = G__3506;
chunk__3325_3491 = G__3507;
count__3326_3492 = G__3508;
i__3327_3493 = G__3509;
continue;
} else {
var map__3334_3510 = cljs.core.first.call(null,seq__3324_3504__$1);
var map__3334_3511__$1 = (((((!((map__3334_3510 == null))))?(((((map__3334_3510.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3334_3510.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3334_3510):map__3334_3510);
var gline_3512 = cljs.core.get.call(null,map__3334_3511__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_3513 = cljs.core.get.call(null,map__3334_3511__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_3514 = cljs.core.get.call(null,map__3334_3511__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_3512], null),cljs.core.fnil.call(null,((function (seq__3324_3490,chunk__3325_3491,count__3326_3492,i__3327_3493,seq__3272_3440,chunk__3273_3441,count__3274_3442,i__3275_3443,seq__3064_3336,chunk__3065_3337,count__3066_3338,i__3067_3339,map__3334_3510,map__3334_3511__$1,gline_3512,gcol_3513,name_3514,seq__3324_3504__$1,temp__5735__auto___3503__$2,vec__3321_3487,column_3488,column_info_3489,seq__3272_3481__$1,temp__5735__auto___3480__$1,vec__3269_3437,line_3438,columns_3439,seq__3064_3431__$1,temp__5735__auto___3430,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_3513], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_3438,new cljs.core.Keyword(null,"col","col",-1959363084),column_3488,new cljs.core.Keyword(null,"name","name",1843675177),name_3514], null));
});})(seq__3324_3490,chunk__3325_3491,count__3326_3492,i__3327_3493,seq__3272_3440,chunk__3273_3441,count__3274_3442,i__3275_3443,seq__3064_3336,chunk__3065_3337,count__3066_3338,i__3067_3339,map__3334_3510,map__3334_3511__$1,gline_3512,gcol_3513,name_3514,seq__3324_3504__$1,temp__5735__auto___3503__$2,vec__3321_3487,column_3488,column_info_3489,seq__3272_3481__$1,temp__5735__auto___3480__$1,vec__3269_3437,line_3438,columns_3439,seq__3064_3431__$1,temp__5735__auto___3430,inverted))
,cljs.core.sorted_map.call(null)));


var G__3515 = cljs.core.next.call(null,seq__3324_3504__$1);
var G__3516 = null;
var G__3517 = (0);
var G__3518 = (0);
seq__3324_3490 = G__3515;
chunk__3325_3491 = G__3516;
count__3326_3492 = G__3517;
i__3327_3493 = G__3518;
continue;
}
} else {
}
}
break;
}


var G__3519 = cljs.core.next.call(null,seq__3272_3481__$1);
var G__3520 = null;
var G__3521 = (0);
var G__3522 = (0);
seq__3272_3440 = G__3519;
chunk__3273_3441 = G__3520;
count__3274_3442 = G__3521;
i__3275_3443 = G__3522;
continue;
}
} else {
}
}
break;
}


var G__3523 = cljs.core.next.call(null,seq__3064_3431__$1);
var G__3524 = null;
var G__3525 = (0);
var G__3526 = (0);
seq__3064_3336 = G__3523;
chunk__3065_3337 = G__3524;
count__3066_3338 = G__3525;
i__3067_3339 = G__3526;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref.call(null,inverted);
});

//# sourceMappingURL=source_map.js.map
