(ns alphabase.base58
  "Base58-check encoding implementation."
  (:require [alphabase.codec :as abc]
            [clojure.set :as set]))

#?(:clj (set! *warn-on-reflection* true))

(def ^:const base58-chars "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz")
(def ^:const base58-set (set base58-chars))

(defn base58?
  "Test if input is base58."
  [x]
  (and (string? x) (set/subset? (set x) base58-set)))


(defn encode
  "Converts a byte array into a base58-check string."
  ^String
  [ba]
  (abc/encode base58-chars ba))


(defn decode
  "Decodes a base58-check string into a byte array."
  ^bytes
  [b58-string]
  (abc/decode base58-chars b58-string))
