(defproject com.flocktory/staff.logging "3.1.3"
  :description
  "JSON Layout with context."

  :url
  "http://github.com/flocktory/staff.logging"

  :license
  {:name "Eclipse Public License",
   :url "http://www.eclipse.org/legal/epl-v10.html"}

  :parent-project
  {:coords [com.flocktory/staff.root "1.4.0"],
   :inherit [:managed-dependencies]}

  :dependencies
  [[org.clojure/clojure]
   [cheshire]
   [org.slf4j/slf4j-api]
   [ch.qos.logback/logback-core]
   [ch.qos.logback/logback-classic]
   [org.slf4j/log4j-over-slf4j]
   [org.clojure/tools.logging]
   [com.flocktory/angryman]]

  :plugins
  [[lein-parent "0.3.1"]]

  :aot
  [flock.staff.logging.json-layout]

  :uberjar-name
  "flock-staff.logging-%s-standalone.jar"

  :mirrors
  {"central"
   {:name "Nexus",
    :url
    "http://artifacts.dev.flocktory.com:8081/nexus/content/groups/public/",
    :repo-manager true},
   #"clojars"
   {:name "Nexus",
    :url
    "http://artifacts.dev.flocktory.com:8081/nexus/content/groups/public/",
    :repo-manager true}}

  :repositories
  [["snapshots"
    {:sign-releases false,
     :url
     "http://artifacts.dev.flocktory.com:8081/nexus/content/repositories/snapshots/"}]
   ["releases"
    {:sign-releases false,
     :url
     "http://artifacts.dev.flocktory.com:8081/nexus/content/repositories/releases/"}]]

  :deploy-repositories
  [["snapshots"
    {:sign-releases false,
     :url
     "http://artifacts.dev.flocktory.com:8081/nexus/content/repositories/releases/",
     :username :env/nexus_username,
     :password :env/nexus_password}]
   ["releases"
    {:sign-releases false,
     :url
     "http://artifacts.dev.flocktory.com:8081/nexus/content/repositories/releases/",
     :username :env/nexus_username,
     :password :env/nexus_password}]]
)
