/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.varadhi.spi.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.varadhi.entities.Message;
import com.flipkart.varadhi.entities.Offset;
import com.flipkart.varadhi.spi.services.Producer;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;

public class DummyProducer
implements Producer {
    private final ObjectMapper objectMapper;

    public DummyProducer(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public CompletableFuture<Offset> produceAsync(Message message) {
        byte[] payload = message.getPayload();
        DummyMessage dm = this.toDummyMsg(payload);
        return CompletableFuture.supplyAsync(() -> {
            if (dm.sleepMillis > 0) {
                try {
                    Thread.sleep(dm.sleepMillis);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (null != dm.exceptionClass && !dm.exceptionClass.isBlank()) {
                throw this.loadClass(dm.exceptionClass);
            }
            return new DummyOffset(dm.offSet);
        });
    }

    private DummyMessage toDummyMsg(byte[] payload) {
        DummyMessage dm;
        try {
            dm = (DummyMessage)this.objectMapper.readValue(payload, DummyMessage.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return dm;
    }

    private RuntimeException loadClass(String className) {
        try {
            Class<?> pluginClass = Class.forName(className);
            return (RuntimeException)pluginClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Fail to load class %s.", className), e);
        }
    }

    public record DummyMessage(int sleepMillis, int offSet, String exceptionClass, byte[] randomData) {
    }

    public static class DummyOffset
    implements Offset {
        int offset;

        public DummyOffset(int offset) {
            this.offset = offset;
        }

        public int compareTo(Offset o) {
            return this.offset - ((DummyOffset)o).offset;
        }
    }
}

