/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.varadhi.spi.services;

import com.flipkart.varadhi.spi.services.Consumer;
import com.flipkart.varadhi.spi.services.DummyProducer;
import com.flipkart.varadhi.spi.services.PolledMessage;
import com.flipkart.varadhi.spi.services.PolledMessages;
import com.google.common.collect.Multimap;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class DummyConsumer
implements Consumer<DummyProducer.DummyOffset> {
    private final Map<String, Boolean> messages;
    private boolean isCalled = false;

    public DummyConsumer(List<String> messages) {
        this.messages = messages.stream().map(message -> Map.entry(message, false)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public CompletableFuture<PolledMessages<DummyProducer.DummyOffset>> receiveAsync() {
        if (this.isCalled) {
            return CompletableFuture.completedFuture(new PolledMessages<DummyProducer.DummyOffset>(this){

                public int getCount() {
                    return 0;
                }

                public Iterator<PolledMessage<DummyProducer.DummyOffset>> iterator() {
                    return new Iterator<PolledMessage<DummyProducer.DummyOffset>>(this){

                        @Override
                        public boolean hasNext() {
                            return false;
                        }

                        @Override
                        public PolledMessage<DummyProducer.DummyOffset> next() {
                            return null;
                        }
                    };
                }
            });
        }
        this.isCalled = true;
        return CompletableFuture.supplyAsync(() -> new PolledMessages<DummyProducer.DummyOffset>(){

            public int getCount() {
                return DummyConsumer.this.messages.size();
            }

            public Iterator<PolledMessage<DummyProducer.DummyOffset>> iterator() {
                final Iterator<String> iter = DummyConsumer.this.messages.keySet().iterator();
                return new Iterator<PolledMessage<DummyProducer.DummyOffset>>(this){

                    @Override
                    public boolean hasNext() {
                        return iter.hasNext();
                    }

                    @Override
                    public PolledMessage<DummyProducer.DummyOffset> next() {
                        final String message = (String)iter.next();
                        return new PolledMessage<DummyProducer.DummyOffset>(this){

                            public long getProducedTimestampMs() {
                                return 0L;
                            }

                            public String getTopicName() {
                                return null;
                            }

                            public int getPartition() {
                                return 0;
                            }

                            public DummyProducer.DummyOffset getOffset() {
                                return new DummyProducer.DummyOffset(1);
                            }

                            public String getMessageId() {
                                return null;
                            }

                            public String getGroupId() {
                                return null;
                            }

                            public boolean hasHeader(String key) {
                                return false;
                            }

                            public String getHeader(String key) {
                                return null;
                            }

                            public List<String> getHeaders(String key) {
                                return null;
                            }

                            public byte[] getPayload() {
                                return message.getBytes(StandardCharsets.UTF_8);
                            }

                            public Multimap<String, String> getHeaders() {
                                return null;
                            }

                            public void release() {
                            }
                        };
                    }
                };
            }
        });
    }

    public CompletableFuture<Void> commitCumulativeAsync(PolledMessage<DummyProducer.DummyOffset> message) {
        return null;
    }

    public CompletableFuture<Void> commitIndividualAsync(PolledMessage<DummyProducer.DummyOffset> message) {
        this.messages.put(new String(message.getPayload(), StandardCharsets.UTF_8), true);
        return null;
    }

    public int getCommittedMessagesCount() {
        return this.messages.entrySet().stream().filter(Map.Entry::getValue).mapToInt(entry -> 1).sum();
    }

    public List<String> getCommittedMessages() {
        return this.messages.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).toList();
    }

    public void permitMoreMessages() {
        this.isCalled = false;
    }

    public void close() {
    }

    public static class SlowConsumer
    extends DummyConsumer {
        private final long delayInSeconds;

        public SlowConsumer(List<String> messages, int delayInSeconds) {
            super(messages);
            this.delayInSeconds = delayInSeconds;
        }

        @Override
        public CompletableFuture<PolledMessages<DummyProducer.DummyOffset>> receiveAsync() {
            return CompletableFuture.supplyAsync(() -> {
                try {
                    Thread.sleep(this.delayInSeconds * 1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                return super.receiveAsync().join();
            });
        }
    }
}

