/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.varadhi.server.spi.vo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;

public class URLDefinition {
    @NotBlank
    @NonNull
    private String path;
    @NotNull
    @NotEmpty
    private List<String> methodList;
    @JsonIgnore
    private Pattern urlPattern;

    public static boolean anyMatch(List<URLDefinition> urlDefinitions, String method, String path) {
        for (URLDefinition urlDefinition : urlDefinitions) {
            if (!urlDefinition.getMethodList().contains(method) || !urlDefinition.getUrlPattern().matcher(path).matches()) continue;
            return true;
        }
        return false;
    }

    public URLDefinition(String path, List<String> methodList) {
        this.methodList = methodList;
        this.setPath(path);
    }

    private void compilePattern() {
        try {
            this.urlPattern = Pattern.compile(this.path);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid regex pattern: " + this.path, e);
        }
    }

    public void setPath(String path) {
        this.path = path;
        this.compilePattern();
    }

    public void setMethodList(List<String> methodList) {
        this.methodList = methodList;
    }

    @NonNull
    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public List<String> getMethodList() {
        return this.methodList;
    }

    @Generated
    public Pattern getUrlPattern() {
        return this.urlPattern;
    }

    @Generated
    public URLDefinition() {
    }
}

