/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.varadhi.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.flipkart.varadhi.entities.AbstractTopic;
import com.flipkart.varadhi.entities.InternalCompositeTopic;
import com.flipkart.varadhi.entities.LifecycleEntity;
import com.flipkart.varadhi.entities.LifecycleStatus;
import com.flipkart.varadhi.entities.TopicCapacityPolicy;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public class VaradhiTopic
extends LifecycleEntity
implements AbstractTopic {
    private final Map<String, InternalCompositeTopic> internalTopics;
    private final boolean grouped;
    private final TopicCapacityPolicy capacity;
    private final String nfrFilterName;

    private VaradhiTopic(String name, int version, boolean grouped, TopicCapacityPolicy capacity, Map<String, InternalCompositeTopic> internalTopics, LifecycleStatus status, String nfrFilterName) {
        super(name, version);
        this.grouped = grouped;
        this.capacity = capacity;
        this.internalTopics = internalTopics;
        this.nfrFilterName = nfrFilterName;
        this.status = status;
    }

    public static VaradhiTopic of(String project, String name, boolean grouped, TopicCapacityPolicy capacity, LifecycleStatus.ActorCode actorCode) {
        return VaradhiTopic.of(project, name, grouped, capacity, actorCode, null);
    }

    public static VaradhiTopic of(String project, String name, boolean grouped, TopicCapacityPolicy capacity, LifecycleStatus.ActorCode actorCode, String nfrStrategy) {
        return new VaradhiTopic(VaradhiTopic.buildTopicName(project, name), 0, grouped, capacity, new HashMap<String, InternalCompositeTopic>(), new LifecycleStatus(LifecycleStatus.State.CREATING, actorCode), nfrStrategy);
    }

    public static String buildTopicName(String projectName, String topicName) {
        return String.join((CharSequence)".", projectName, topicName);
    }

    public void addInternalTopic(String region, InternalCompositeTopic internalTopic) {
        this.internalTopics.put(region, internalTopic);
    }

    @JsonIgnore
    public String getProjectName() {
        return this.getName().split("\\.")[0];
    }

    public InternalCompositeTopic getProduceTopicForRegion(String region) {
        return this.internalTopics.get(region);
    }

    @Generated
    public Map<String, InternalCompositeTopic> getInternalTopics() {
        return this.internalTopics;
    }

    @Generated
    public boolean isGrouped() {
        return this.grouped;
    }

    @Generated
    public TopicCapacityPolicy getCapacity() {
        return this.capacity;
    }

    @Generated
    public String getNfrFilterName() {
        return this.nfrFilterName;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VaradhiTopic)) {
            return false;
        }
        VaradhiTopic other = (VaradhiTopic)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isGrouped() != other.isGrouped()) {
            return false;
        }
        Map<String, InternalCompositeTopic> this$internalTopics = this.getInternalTopics();
        Map<String, InternalCompositeTopic> other$internalTopics = other.getInternalTopics();
        if (this$internalTopics == null ? other$internalTopics != null : !((Object)this$internalTopics).equals(other$internalTopics)) {
            return false;
        }
        TopicCapacityPolicy this$capacity = this.getCapacity();
        TopicCapacityPolicy other$capacity = other.getCapacity();
        if (this$capacity == null ? other$capacity != null : !((Object)this$capacity).equals(other$capacity)) {
            return false;
        }
        String this$nfrFilterName = this.getNfrFilterName();
        String other$nfrFilterName = other.getNfrFilterName();
        return !(this$nfrFilterName == null ? other$nfrFilterName != null : !this$nfrFilterName.equals(other$nfrFilterName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof VaradhiTopic;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isGrouped() ? 79 : 97);
        Map<String, InternalCompositeTopic> $internalTopics = this.getInternalTopics();
        result = result * 59 + ($internalTopics == null ? 43 : ((Object)$internalTopics).hashCode());
        TopicCapacityPolicy $capacity = this.getCapacity();
        result = result * 59 + ($capacity == null ? 43 : ((Object)$capacity).hashCode());
        String $nfrFilterName = this.getNfrFilterName();
        result = result * 59 + ($nfrFilterName == null ? 43 : $nfrFilterName.hashCode());
        return result;
    }
}

