/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.restbus.turbo.config;

import com.flipkart.restbus.turbo.config.TurboConfigProvider;
import com.flipkart.restbus.turbo.exceptions.InvalidInvocationException;
import com.flipkart.restbus.turbo.utils.TurboHelper;
import java.util.HashMap;
import java.util.List;
import javax.naming.ConfigurationException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;

public class TurboSessionProvider {
    private static SessionFactory sessionFactory;
    private static final HashMap<String, SessionFactory> dbShardToSessionFactory;

    public static Session getSession() {
        if (sessionFactory == null) {
            TurboSessionProvider.initSessionFactory();
        }
        return sessionFactory.openSession();
    }

    public static Session getSession(String dbShard) throws ConfigurationException {
        if (dbShardToSessionFactory.get(dbShard) == null) {
            TurboSessionProvider.initSessionFactory(dbShard);
        }
        return dbShardToSessionFactory.get(dbShard).openSession();
    }

    private static synchronized void initSessionFactory() {
        if (TurboConfigProvider.getConfig().getMysql() == null) {
            throw new InvalidInvocationException("Default MySQL config isn't provided");
        }
        if (sessionFactory == null) {
            AnnotationConfiguration conf = new AnnotationConfiguration();
            List<Class<?>> annotatedClasses = TurboHelper.getAnnotatedClasses();
            for (Class<?> clazz : annotatedClasses) {
                conf.addAnnotatedClass(clazz);
            }
            sessionFactory = conf.addProperties(TurboConfigProvider.getConfig().getMysql()).buildSessionFactory();
        }
    }

    private static synchronized void initSessionFactory(String dbShard) throws ConfigurationException {
        if (dbShardToSessionFactory.get(dbShard) == null) {
            AnnotationConfiguration conf = new AnnotationConfiguration();
            List<Class<?>> annotatedClasses = TurboHelper.getAnnotatedClasses();
            for (Class<?> clazz : annotatedClasses) {
                conf.addAnnotatedClass(clazz);
            }
            if (TurboConfigProvider.getConfig().getDbShard(dbShard) == null) {
                throw new ConfigurationException("Db Shard config isn't provided/invalid" + dbShard);
            }
            dbShardToSessionFactory.put(dbShard, conf.addProperties(TurboConfigProvider.getConfig().getDbShard(dbShard)).buildSessionFactory());
        }
    }

    public static void closeSession(Session session) {
        try {
            if (session != null) {
                session.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        dbShardToSessionFactory = new HashMap();
    }
}

