/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.restbus.hibernate.utils;

import com.flipkart.restbus.client.entity.OutboundMessage;
import com.flipkart.restbus.turbo.config.TurboConfigProvider;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.security.InvalidParameterException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MessageUtilsCommon {
    private static final Logger logger = LoggerFactory.getLogger(MessageUtilsCommon.class);
    private static final Gson GSON = new Gson();

    MessageUtilsCommon() {
    }

    static OutboundMessage constructOutboundMessage(OutboundMessage outboundMessage, String exchangeName, String exchangeType, String httpMethod, String httpUri, String replyToExchangeName, String replyToHttpMethod, String replyToHttpUri, String payload, String groupId, Map<String, String> options, String appId, boolean modifyHeader) {
        Map<String, String> headers = MessageUtilsCommon.addDefaultHeaders(MessageUtilsCommon.getOption(options, "customHeaders", "{}"), payload, exchangeName, exchangeType, modifyHeader);
        return MessageUtilsCommon.constructOutboundMessage(outboundMessage, exchangeName, exchangeType, httpMethod, httpUri, replyToExchangeName, replyToHttpMethod, replyToHttpUri, payload, groupId, options, headers, appId);
    }

    static OutboundMessage constructOutboundMessage(OutboundMessage outboundMessage, String exchangeName, String exchangeType, String httpMethod, String httpUri, String replyToExchangeName, String replyToHttpMethod, String replyToHttpUri, String payload, String groupId, Map<String, String> options, Map<String, String> headers, String appId) {
        Long allowedPayloadLength = TurboConfigProvider.getConfig().getPayloadLength();
        if (allowedPayloadLength != null && (long)payload.length() > allowedPayloadLength) {
            logger.error("Payload length is more that allowed length");
            throw new InvalidParameterException("Payload length is more that allowed length, length found: " + payload.length() + ", allowed length: " + allowedPayloadLength);
        }
        outboundMessage.setMessageId(MessageUtilsCommon.getOption(options, "messageId", UUID.randomUUID().toString()));
        outboundMessage.setGroupId(groupId != null ? groupId.toUpperCase() : outboundMessage.getMessageId());
        outboundMessage.setHttpMethod(httpMethod);
        outboundMessage.setHttpUri(httpUri);
        outboundMessage.setMessage(payload);
        outboundMessage.setExchangeName(exchangeName);
        outboundMessage.setExchangeType(exchangeType);
        outboundMessage.setReplyTo(replyToExchangeName);
        String replyToUrl = MessageUtilsCommon.constructReplyTo(outboundMessage.getMessageId(), replyToHttpUri, options);
        outboundMessage.setReplyToHttpUri(replyToUrl != null ? replyToUrl : MessageUtilsCommon.getOption(options, "replyToHttpUrl", null));
        outboundMessage.setReplyToHttpMethod(replyToHttpMethod != null ? replyToHttpMethod : MessageUtilsCommon.getOption(options, "replyToHttpMethod", null));
        outboundMessage.setContext(MessageUtilsCommon.getOption(options, "context", ""));
        outboundMessage.setCustomHeaders(GSON.toJson(headers));
        outboundMessage.setTxnId(MessageUtilsCommon.getOption(options, "txnId", "TXN-" + outboundMessage.getMessageId()));
        outboundMessage.setCreatedAt(new Date());
        outboundMessage.setAppId(appId);
        outboundMessage.setRetries(0L);
        return outboundMessage;
    }

    private static Map<String, String> addDefaultHeaders(String customHeaders, String payload, String exchangeName, String exchangeType, boolean modifyHeader) {
        Map<String, String> headers = MessageUtilsCommon.parseOrDefaultJSON(customHeaders);
        if (modifyHeader && "topic".equalsIgnoreCase(exchangeType)) {
            Map<String, String> body = MessageUtilsCommon.parseOrDefaultJSON(payload);
            MessageUtilsCommon.addTopicHeaders(headers, body.get("event"), exchangeName);
        }
        return headers;
    }

    private static Map<String, String> parseOrDefaultJSON(String payload) {
        try {
            return (Map)GSON.fromJson(payload, Map.class);
        }
        catch (JsonSyntaxException e) {
            return new HashMap<String, String>();
        }
    }

    private static void addTopicHeaders(Map<String, String> headers, String event, String exchangeName) {
        headers.put("X_EVENT_NAME", event);
        headers.put("X_TOPIC_NAME", exchangeName);
    }

    static String getOption(Map<String, String> options, String key, String defaultValue) {
        return options.containsKey(key) ? options.get(key) : defaultValue;
    }

    static String constructReplyTo(String messageId, String replyToHttpUrl, Map<String, String> options) {
        String messageIdQueryParam;
        if (replyToHttpUrl != null && options != null && options.containsKey("messageIdQueryParam") && (messageIdQueryParam = options.get("messageIdQueryParam")) != null) {
            if (replyToHttpUrl.contains("&")) {
                return replyToHttpUrl + "&" + messageIdQueryParam + "=" + messageId;
            }
            return replyToHttpUrl + "?" + messageIdQueryParam + "=" + messageId;
        }
        return replyToHttpUrl;
    }
}

