/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.restbus.hibernate.client;

import com.flipkart.restbus.client.entity.OutboundMessage;
import com.flipkart.restbus.hibernate.client.OutboundMessageRepository;
import com.flipkart.restbus.hibernate.models.OutboundMessageEntity;
import com.flipkart.restbus.hibernate.models.TurboAppMessageEntity;
import com.flipkart.restbus.hibernate.models.TurboOutboundMessageEntity;
import com.flipkart.restbus.hibernate.utils.TurboOutboundMessageUtils;
import com.flipkart.restbus.turbo.config.TurboSessionProvider;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.naming.ConfigurationException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.jdbc.Work;

public class TurboHibernateOutboundMessageRepository
implements OutboundMessageRepository {
    private final Session session;
    private Boolean isMultiDbWriteEnabled;
    private Boolean isSingleDbWriteEnabled;
    private boolean turboOutboundWithoutTrxEnabled;

    public TurboHibernateOutboundMessageRepository(Session session, Boolean isMultiDbWriteEnabled, Boolean isSingleDbWriteEnabled, boolean turboOutboundWithoutTrxEnabled) {
        this.session = session;
        this.isMultiDbWriteEnabled = isMultiDbWriteEnabled;
        this.isSingleDbWriteEnabled = isSingleDbWriteEnabled;
        this.turboOutboundWithoutTrxEnabled = turboOutboundWithoutTrxEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persist(OutboundMessage message) {
        block9: {
            if (this.isSingleDbWriteEnabled.booleanValue()) {
                OutboundMessageEntity outboundMessageEntity = new OutboundMessageEntity(message);
                this.session.saveOrUpdate((Object)outboundMessageEntity);
            }
            if (this.isMultiDbWriteEnabled.booleanValue()) {
                TurboOutboundMessageEntity turboOutboundMessageEntity = new TurboOutboundMessageEntity(message);
                Session outboundSession = TurboSessionProvider.getSession();
                try {
                    Long outboundId = (Long)outboundSession.save((Object)turboOutboundMessageEntity);
                    if (this.turboOutboundWithoutTrxEnabled) break block9;
                    TurboAppMessageEntity turboAppMessageEntity = new TurboAppMessageEntity(outboundId, turboOutboundMessageEntity.getMessageId());
                    this.session.persist((Object)turboAppMessageEntity);
                }
                finally {
                    TurboSessionProvider.closeSession(outboundSession);
                }
            }
        }
    }

    @Override
    public void persist(List<OutboundMessage> messages) {
        if (this.isSingleDbWriteEnabled.booleanValue()) {
            this.fkscFormatWrite(messages);
        }
        if (this.isMultiDbWriteEnabled.booleanValue()) {
            this.turboFormatWrite(TurboSessionProvider.getSession(), messages);
        }
    }

    @Override
    public void persist(String dbShard, List<OutboundMessage> messages) throws ConfigurationException {
        if (this.isSingleDbWriteEnabled.booleanValue()) {
            this.fkscFormatWrite(messages);
        }
        if (this.isMultiDbWriteEnabled.booleanValue()) {
            this.turboFormatWrite(TurboSessionProvider.getSession(dbShard), messages);
        }
    }

    @Override
    public OutboundMessage findMessageById(String messageId, String tableName) {
        OutboundMessageEntity outboundMessageEntity = (OutboundMessageEntity)this.session.createCriteria(OutboundMessageEntity.class).add((Criterion)Restrictions.eq((String)"messageId", (Object)messageId)).uniqueResult();
        return outboundMessageEntity;
    }

    private void fkscFormatWrite(List<OutboundMessage> messages) {
        final ArrayList<OutboundMessageEntity> outboundMessageEntities = new ArrayList<OutboundMessageEntity>();
        for (OutboundMessage outboundMessage : messages) {
            OutboundMessageEntity outboundMessageEntity = new OutboundMessageEntity(outboundMessage);
            outboundMessageEntities.add(outboundMessageEntity);
        }
        this.session.doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                PreparedStatement preparedStatement = connection.prepareStatement(TurboOutboundMessageUtils.getCreateSqlQueryForOutboundMessages());
                try {
                    TurboOutboundMessageUtils.bulkInsertMessages(preparedStatement, outboundMessageEntities);
                }
                finally {
                    if (null != preparedStatement) {
                        preparedStatement.close();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void turboFormatWrite(Session outboundSession, List<OutboundMessage> messages) {
        final ArrayList<TurboOutboundMessageEntity> turboOutboundMessageEntities = new ArrayList<TurboOutboundMessageEntity>();
        ArrayList<String> messageIds = new ArrayList<String>();
        for (OutboundMessage outboundMessage : messages) {
            messageIds.add(outboundMessage.getMessageId());
            TurboOutboundMessageEntity turboOutboundMessageEntity = new TurboOutboundMessageEntity(outboundMessage);
            turboOutboundMessageEntities.add(turboOutboundMessageEntity);
        }
        try {
            outboundSession.doWork(new Work(){

                public void execute(Connection connection) throws SQLException {
                    PreparedStatement preparedStatement = connection.prepareStatement(TurboOutboundMessageUtils.getCreateSqlQueryForTurboOutboundMessages());
                    try {
                        TurboOutboundMessageUtils.bulkInsertTurboMessages(preparedStatement, turboOutboundMessageEntities);
                    }
                    catch (BatchUpdateException e) {
                        throw e;
                    }
                    finally {
                        if (null != preparedStatement) {
                            preparedStatement.close();
                        }
                    }
                }
            });
            if (!this.turboOutboundWithoutTrxEnabled) {
                final List<TurboAppMessageEntity> turboAppMessageEntities = TurboOutboundMessageUtils.prepareTurboAppEntities(outboundSession, messageIds, "messages");
                this.session.doWork(new Work(){

                    public void execute(Connection connection) throws SQLException {
                        PreparedStatement preparedStatement = connection.prepareStatement(TurboOutboundMessageUtils.getCreateSqlQueryForTurboMetaData());
                        try {
                            TurboOutboundMessageUtils.bulkInsertTurboMetaData(preparedStatement, turboAppMessageEntities);
                        }
                        catch (BatchUpdateException e) {
                            throw e;
                        }
                        finally {
                            if (null != preparedStatement) {
                                preparedStatement.close();
                            }
                        }
                    }
                });
            }
        }
        finally {
            TurboSessionProvider.closeSession(outboundSession);
        }
    }
}

