/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.restbus.hibernate.client;

import com.flipkart.restbus.client.entity.OutboundMessage;
import com.flipkart.restbus.client.entity.TDSOutboundMessage;
import com.flipkart.restbus.client.shards.Shard;
import com.flipkart.restbus.client.shards.ShardStrategy;
import com.flipkart.restbus.hibernate.client.TDSOutboundMessageRepository;
import com.flipkart.restbus.hibernate.models.OutboundMessageEntity;
import com.flipkart.restbus.hibernate.models.TDSMetaDataEntity;
import com.flipkart.restbus.hibernate.models.TDSTurboAppMessageEntity;
import com.flipkart.restbus.hibernate.models.TurboOutboundMessageEntity;
import com.flipkart.restbus.hibernate.utils.OutboundMessageUtils;
import com.flipkart.restbus.hibernate.utils.TurboOutboundMessageUtils;
import com.flipkart.restbus.turbo.config.TurboSessionProvider;
import com.flipkart.restbus.turbo.shard.DynamicShardStrategy;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;

public class TDSTurboHibernateOutboundMessageShardRepository
implements TDSOutboundMessageRepository {
    private final Session session;
    private Boolean isMultiDbWriteEnabled;
    private Boolean isSingleDbWriteEnabled;
    private boolean turboOutboundWithoutTrxEnabled;
    private final ShardStrategy<OutboundMessage> omsShardStrategy;
    private final DynamicShardStrategy<OutboundMessage> turboShardStrategy;

    public TDSTurboHibernateOutboundMessageShardRepository(Session session, Boolean isMultiDbWriteEnabled, Boolean isSingleDbWriteEnabled, boolean turboOutboundWithoutTrxEnabled, ShardStrategy<OutboundMessage> omsShardStrategy, DynamicShardStrategy<OutboundMessage> turboShardStrategy) {
        this.session = session;
        this.isMultiDbWriteEnabled = isMultiDbWriteEnabled;
        this.isSingleDbWriteEnabled = isSingleDbWriteEnabled;
        this.turboOutboundWithoutTrxEnabled = turboOutboundWithoutTrxEnabled;
        this.omsShardStrategy = omsShardStrategy;
        this.turboShardStrategy = turboShardStrategy;
    }

    @Override
    public TDSMetaDataEntity persist(OutboundMessage message) {
        ArrayList<OutboundMessage> messages = new ArrayList<OutboundMessage>();
        messages.add(message);
        List<TDSMetaDataEntity> tdsMetaDataEntityList = this.persist(messages);
        return tdsMetaDataEntityList.size() == 0 ? null : tdsMetaDataEntityList.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TDSMetaDataEntity> persist(List<? extends OutboundMessage> messages) {
        ArrayList<TDSMetaDataEntity> tdsMetaDataEntityList = new ArrayList<TDSMetaDataEntity>();
        if (this.isSingleDbWriteEnabled.booleanValue()) {
            final Map<String, List<OutboundMessageEntity>> shardToOutboundMessages = this.groupOutboundMessagesByShardName(messages);
            this.session.doWork(new Work(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void execute(Connection connection) throws SQLException {
                    for (Map.Entry entry : shardToOutboundMessages.entrySet()) {
                        Shard shard = TDSTurboHibernateOutboundMessageShardRepository.this.omsShardStrategy.resolve(((List)entry.getValue()).get(0));
                        TurboOutboundMessageUtils.ensureShard(TDSTurboHibernateOutboundMessageShardRepository.this.session, shard);
                        String shardName = (String)entry.getKey();
                        List outboundMessages = (List)entry.getValue();
                        PreparedStatement preparedStatement = connection.prepareStatement(OutboundMessageUtils.getCreateSqlQueryForOutboundMessages(shardName));
                        try {
                            TurboOutboundMessageUtils.bulkInsertMessages(preparedStatement, outboundMessages);
                        }
                        finally {
                            if (null == preparedStatement) continue;
                            preparedStatement.close();
                        }
                    }
                }
            });
        }
        if (this.isMultiDbWriteEnabled.booleanValue()) {
            Session outboundSession = TurboSessionProvider.getSession();
            try {
                Map<String, List<TurboOutboundMessageEntity>> shardToTurboOutboundMessages = this.groupTurboOutboundMessagesByShardName(messages);
                Map<String, List<OutboundMessage>> appShardToMessages = this.groupOutboundMessageByAppShardName(messages);
                for (Map.Entry<String, List<TurboOutboundMessageEntity>> entry : shardToTurboOutboundMessages.entrySet()) {
                    final String string = entry.getKey();
                    final List<TurboOutboundMessageEntity> turboOutboundMessageEntities = entry.getValue();
                    outboundSession.doWork(new Work(){

                        public void execute(Connection connection) throws SQLException {
                            PreparedStatement preparedStatement = connection.prepareStatement(TurboOutboundMessageUtils.getCreateSqlQueryForTurboOutboundMessages(string));
                            try {
                                TurboOutboundMessageUtils.bulkInsertTurboMessages(preparedStatement, turboOutboundMessageEntities);
                            }
                            catch (BatchUpdateException e) {
                                throw e;
                            }
                            finally {
                                if (null != preparedStatement) {
                                    preparedStatement.close();
                                }
                            }
                        }
                    });
                }
                HashMap<String, List> shardToMetaDataEntity = new HashMap<String, List>();
                for (Map.Entry<String, List<OutboundMessage>> entry : appShardToMessages.entrySet()) {
                    final String appShardName = entry.getKey();
                    String outboundShardName = this.turboShardStrategy.resolve("messages", entry.getValue().get(0)).getShardName();
                    final List<TDSTurboAppMessageEntity> tdsTurboAppMessageEntities = TurboOutboundMessageUtils.prepareTDSTurboAppEntities(outboundSession, this.getMessageIds(entry.getValue()), outboundShardName, this.getMessageIdShardMapping(entry.getValue()));
                    List messageList = (List)shardToMetaDataEntity.get(appShardName);
                    messageList = messageList == null ? new ArrayList() : messageList;
                    messageList.addAll(tdsTurboAppMessageEntities);
                    shardToMetaDataEntity.put(appShardName, messageList);
                    if (this.turboOutboundWithoutTrxEnabled) continue;
                    this.session.doWork(new Work(){

                        public void execute(Connection connection) throws SQLException {
                            PreparedStatement preparedStatement = connection.prepareStatement(TurboOutboundMessageUtils.getCreateSqlQueryForTDSTurboMetaData(appShardName));
                            try {
                                TurboOutboundMessageUtils.bulkInsertTDSTurboMetaData(preparedStatement, tdsTurboAppMessageEntities);
                            }
                            catch (BatchUpdateException e) {
                                throw e;
                            }
                            finally {
                                if (null != preparedStatement) {
                                    preparedStatement.close();
                                }
                            }
                        }
                    });
                }
                for (Map.Entry<String, List<OutboundMessage>> entry : shardToMetaDataEntity.entrySet()) {
                    TDSMetaDataEntity tdsMetaDataEntity = new TDSMetaDataEntity();
                    tdsMetaDataEntity.setTableName(entry.getKey());
                    tdsMetaDataEntity.setTdsTurboAppMessageEntityList(entry.getValue());
                    tdsMetaDataEntityList.add(tdsMetaDataEntity);
                }
            }
            finally {
                TurboSessionProvider.closeSession(outboundSession);
            }
        }
        return tdsMetaDataEntityList;
    }

    @Override
    public List<TDSMetaDataEntity> persist(String dbShard, List<? extends OutboundMessage> messages) {
        throw new UnsupportedOperationException("method not implemented");
    }

    private List<String> getMessageIds(List<OutboundMessage> messages) {
        ArrayList<String> messageIds = new ArrayList<String>();
        for (OutboundMessage message : messages) {
            messageIds.add(message.getMessageId());
        }
        return messageIds;
    }

    private Map<String, String> getMessageIdShardMapping(List<OutboundMessage> messages) {
        HashMap<String, String> mIdShardKeyMapping = new HashMap<String, String>();
        for (OutboundMessage message : messages) {
            mIdShardKeyMapping.put(message.getMessageId(), ((TDSOutboundMessage)message).getShardKey());
        }
        return mIdShardKeyMapping;
    }

    private Map<String, List<OutboundMessageEntity>> groupOutboundMessagesByShardName(List<? extends OutboundMessage> messages) {
        HashMap<String, List<OutboundMessageEntity>> map = new HashMap<String, List<OutboundMessageEntity>>();
        for (OutboundMessage outboundMessage : messages) {
            outboundMessage.setCreatedAt(TurboOutboundMessageUtils.convertToSqlTimestamp(outboundMessage.getCreatedAt()));
            OutboundMessageEntity outboundMessageEntity = new OutboundMessageEntity(outboundMessage);
            Shard shard = this.omsShardStrategy.resolve(outboundMessage);
            String shardName = shard.getShardName();
            if (!map.containsKey(shardName)) {
                map.put(shardName, new ArrayList());
            }
            ((List)map.get(shardName)).add(outboundMessageEntity);
        }
        return map;
    }

    private Map<String, List<TurboOutboundMessageEntity>> groupTurboOutboundMessagesByShardName(List<? extends OutboundMessage> messages) {
        HashMap<String, List<TurboOutboundMessageEntity>> map = new HashMap<String, List<TurboOutboundMessageEntity>>();
        for (OutboundMessage outboundMessage : messages) {
            outboundMessage.setCreatedAt(TurboOutboundMessageUtils.convertToSqlTimestamp(outboundMessage.getCreatedAt()));
            TurboOutboundMessageEntity outboundMessageEntity = new TurboOutboundMessageEntity(outboundMessage);
            Shard shard = this.turboShardStrategy.resolve("messages", outboundMessage);
            String shardName = shard.getShardName();
            if (!map.containsKey(shardName)) {
                map.put(shardName, new ArrayList());
            }
            ((List)map.get(shardName)).add(outboundMessageEntity);
        }
        return map;
    }

    private Map<String, List<OutboundMessage>> groupOutboundMessageByAppShardName(List<? extends OutboundMessage> messages) {
        HashMap<String, List<OutboundMessage>> map = new HashMap<String, List<OutboundMessage>>();
        for (OutboundMessage outboundMessage : messages) {
            Shard shard = this.turboShardStrategy.resolve("message_meta_data", outboundMessage);
            String shardName = shard.getShardName();
            if (!map.containsKey(shardName)) {
                map.put(shardName, new ArrayList());
            }
            ((List)map.get(shardName)).add(outboundMessage);
        }
        return map;
    }

    @Override
    public OutboundMessage findMessageById(String messageId, String tableName) {
        return OutboundMessageUtils.findOutboundMessageByMessageId(this.session, messageId, tableName);
    }
}

