/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.restbus.hibernate.client;

import com.flipkart.restbus.client.entity.OutboundMessage;
import com.flipkart.restbus.client.entity.TDSOutboundMessage;
import com.flipkart.restbus.hibernate.client.TDSOutboundMessageRepository;
import com.flipkart.restbus.hibernate.models.OutboundMessageEntity;
import com.flipkart.restbus.hibernate.models.TDSMetaDataEntity;
import com.flipkart.restbus.hibernate.models.TDSTurboAppMessageEntity;
import com.flipkart.restbus.hibernate.models.TurboOutboundMessageEntity;
import com.flipkart.restbus.hibernate.utils.TurboOutboundMessageUtils;
import com.flipkart.restbus.turbo.config.TurboSessionProvider;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.jdbc.Work;

public class TDSTurboHibernateOutboundMessageRepository
implements TDSOutboundMessageRepository {
    private final Session session;
    private Boolean isMultiDbWriteEnabled;
    private Boolean isSingleDbWriteEnabled;
    private boolean turboOutboundWithoutTrxEnabled;

    public TDSTurboHibernateOutboundMessageRepository(Session session, Boolean isMultiDbWriteEnabled, Boolean isSingleDbWriteEnabled, boolean turboOutboundWithoutTrxEnabled) {
        this.session = session;
        this.isMultiDbWriteEnabled = isMultiDbWriteEnabled;
        this.isSingleDbWriteEnabled = isSingleDbWriteEnabled;
        this.turboOutboundWithoutTrxEnabled = turboOutboundWithoutTrxEnabled;
    }

    @Override
    public TDSMetaDataEntity persist(OutboundMessage message) {
        ArrayList<OutboundMessage> messages = new ArrayList<OutboundMessage>();
        messages.add(message);
        List<TDSMetaDataEntity> tdsMetaDataEntityList = this.persist(messages);
        return tdsMetaDataEntityList.size() == 0 ? null : tdsMetaDataEntityList.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TDSMetaDataEntity> persist(List<? extends OutboundMessage> messages) {
        ArrayList<TDSMetaDataEntity> tdsMetaDataEntityList = new ArrayList<TDSMetaDataEntity>();
        if (this.isSingleDbWriteEnabled.booleanValue()) {
            final ArrayList<Object> outboundMessageEntities = new ArrayList<Object>();
            for (OutboundMessage outboundMessage : messages) {
                OutboundMessageEntity outboundMessageEntity = new OutboundMessageEntity(outboundMessage);
                outboundMessageEntities.add(outboundMessageEntity);
            }
            this.session.doWork(new Work(){

                public void execute(Connection connection) throws SQLException {
                    PreparedStatement preparedStatement = connection.prepareStatement(TurboOutboundMessageUtils.getCreateSqlQueryForOutboundMessages());
                    try {
                        TurboOutboundMessageUtils.bulkInsertMessages(preparedStatement, outboundMessageEntities);
                    }
                    finally {
                        if (null != preparedStatement) {
                            preparedStatement.close();
                        }
                    }
                }
            });
        }
        if (this.isMultiDbWriteEnabled.booleanValue()) {
            final ArrayList<TurboOutboundMessageEntity> turboOutboundMessageEntities = new ArrayList<TurboOutboundMessageEntity>();
            ArrayList<String> messageIds = new ArrayList<String>();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (OutboundMessage outboundMessage : messages) {
                messageIds.add(outboundMessage.getMessageId());
                hashMap.put(outboundMessage.getMessageId(), ((TDSOutboundMessage)outboundMessage).getShardKey());
                TurboOutboundMessageEntity turboOutboundMessageEntity = new TurboOutboundMessageEntity(outboundMessage);
                turboOutboundMessageEntities.add(turboOutboundMessageEntity);
            }
            Session outboundSession = TurboSessionProvider.getSession();
            try {
                outboundSession.doWork(new Work(){

                    public void execute(Connection connection) throws SQLException {
                        PreparedStatement preparedStatement = connection.prepareStatement(TurboOutboundMessageUtils.getCreateSqlQueryForTurboOutboundMessages());
                        try {
                            TurboOutboundMessageUtils.bulkInsertTurboMessages(preparedStatement, turboOutboundMessageEntities);
                        }
                        catch (BatchUpdateException e) {
                            throw e;
                        }
                        finally {
                            if (null != preparedStatement) {
                                preparedStatement.close();
                            }
                        }
                    }
                });
                final List<TDSTurboAppMessageEntity> list = TurboOutboundMessageUtils.prepareTDSTurboAppEntities(outboundSession, messageIds, "messages", hashMap);
                TDSMetaDataEntity tdsMetaDataEntity = new TDSMetaDataEntity();
                tdsMetaDataEntity.setTableName("message_meta_data");
                tdsMetaDataEntity.setTdsTurboAppMessageEntityList(list);
                tdsMetaDataEntityList.add(tdsMetaDataEntity);
                if (!this.turboOutboundWithoutTrxEnabled) {
                    this.session.doWork(new Work(){

                        public void execute(Connection connection) throws SQLException {
                            PreparedStatement preparedStatement = connection.prepareStatement(TurboOutboundMessageUtils.getCreateSqlQueryForTDSTurboMetaData());
                            try {
                                TurboOutboundMessageUtils.bulkInsertTDSTurboMetaData(preparedStatement, list);
                            }
                            catch (BatchUpdateException e) {
                                throw e;
                            }
                            finally {
                                preparedStatement.close();
                            }
                        }
                    });
                }
            }
            finally {
                TurboSessionProvider.closeSession(outboundSession);
            }
        }
        return tdsMetaDataEntityList;
    }

    @Override
    public List<TDSMetaDataEntity> persist(String dbShard, List<? extends OutboundMessage> messages) {
        throw new UnsupportedOperationException("method not implemented");
    }

    @Override
    public OutboundMessage findMessageById(String messageId, String tableName) {
        OutboundMessageEntity outboundMessageEntity = (OutboundMessageEntity)this.session.createCriteria(TurboOutboundMessageEntity.class).add((Criterion)Restrictions.eq((String)"messageId", (Object)messageId)).uniqueResult();
        return outboundMessageEntity;
    }
}

