/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.restbus.hibernate.client;

import com.flipkart.restbus.client.entity.OutboundMessage;
import com.flipkart.restbus.client.shards.OMShardStrategyProvider;
import com.flipkart.restbus.client.shards.ShardStrategy;
import com.flipkart.restbus.hibernate.client.HibernateOutboundMessageRepository;
import com.flipkart.restbus.hibernate.client.HibernateOutboundMessageShardRepository;
import com.flipkart.restbus.hibernate.client.OutboundMessageRepository;
import com.flipkart.restbus.hibernate.client.TDSOutboundMessageRepository;
import com.flipkart.restbus.hibernate.client.TDSTurboHibernateOutboundMessageRepository;
import com.flipkart.restbus.hibernate.client.TDSTurboHibernateOutboundMessageShardRepository;
import com.flipkart.restbus.hibernate.client.TurboHibernateOutboundMessageRepository;
import com.flipkart.restbus.hibernate.client.TurboHibernateOutboundMessageShardRepository;
import com.flipkart.restbus.turbo.config.TurboConfigProvider;
import com.flipkart.restbus.turbo.shard.DummyOmsShardStrategy;
import com.flipkart.restbus.turbo.shard.DummyTurboShardStrategy;
import com.flipkart.restbus.turbo.shard.DynamicShardStrategy;
import com.flipkart.restbus.turbo.shard.TurboShardStrategyProvider;
import org.hibernate.Session;

public class OutboundMessageRepositoryFactory {
    public static OutboundMessageRepository getOutboundMessageRepository(Session session) {
        if (session == null) {
            throw new RuntimeException("Session can't be null while getting outboundMessageRepository");
        }
        return OutboundMessageRepositoryFactory.prepareOutboundMessageRepository(session);
    }

    public static OutboundMessageRepository getOutboundMessageRepositoryWithoutTrx() {
        return OutboundMessageRepositoryFactory.prepareOutboundMessageRepository(null);
    }

    public static TDSOutboundMessageRepository getTDSOutboundMessageRepository(Session session) {
        if (session == null) {
            throw new RuntimeException("Session can't be null while getting outboundMessageRepository");
        }
        return OutboundMessageRepositoryFactory.prepareTDSOutboundMessageRepository(session);
    }

    public static TDSOutboundMessageRepository getTDSOutboundMessageRepositoryWithoutTrx() {
        return OutboundMessageRepositoryFactory.prepareTDSOutboundMessageRepository(null);
    }

    private static OutboundMessageRepository prepareOutboundMessageRepository(Session session) {
        ShardStrategy<OutboundMessage> shardStrategy = OMShardStrategyProvider.getStrategy();
        Boolean isMultiDbWriteEnabled = TurboConfigProvider.getConfig().getMultiDbWriteEnabled();
        Boolean isSingleDbWriteEnabled = TurboConfigProvider.getConfig().getSingleDbWriteEnabled();
        boolean turboOutboundWithoutTrxEnabled = TurboConfigProvider.getConfig().isTurboOutboundWithoutTrxEnabled() == null ? false : TurboConfigProvider.getConfig().isTurboOutboundWithoutTrxEnabled();
        Boolean appOnTDS = "TDS".equalsIgnoreCase(TurboConfigProvider.getConfig().getAppDbType());
        if (isMultiDbWriteEnabled.booleanValue()) {
            DynamicShardStrategy<OutboundMessage> dynamicShardStrategy = TurboShardStrategyProvider.getStrategy();
            if (shardStrategy == null && dynamicShardStrategy == null) {
                if (appOnTDS.booleanValue()) {
                    throw new IllegalArgumentException("use prepareTDSOutboundMessageRepository to construct repository");
                }
                return new TurboHibernateOutboundMessageRepository(session, true, isSingleDbWriteEnabled, turboOutboundWithoutTrxEnabled);
            }
            if (shardStrategy == null) {
                shardStrategy = new DummyOmsShardStrategy();
            }
            if (dynamicShardStrategy == null) {
                dynamicShardStrategy = new DummyTurboShardStrategy();
            }
            if (appOnTDS.booleanValue()) {
                throw new IllegalArgumentException("use prepareTDSOutboundMessageRepository to construct repository");
            }
            return new TurboHibernateOutboundMessageShardRepository(session, shardStrategy, dynamicShardStrategy, true, isSingleDbWriteEnabled, turboOutboundWithoutTrxEnabled);
        }
        if (shardStrategy == null) {
            return new HibernateOutboundMessageRepository(session);
        }
        return new HibernateOutboundMessageShardRepository(session, shardStrategy);
    }

    private static TDSOutboundMessageRepository prepareTDSOutboundMessageRepository(Session session) {
        ShardStrategy<OutboundMessage> shardStrategy = OMShardStrategyProvider.getStrategy();
        Boolean isMultiDbWriteEnabled = TurboConfigProvider.getConfig().getMultiDbWriteEnabled();
        Boolean isSingleDbWriteEnabled = TurboConfigProvider.getConfig().getSingleDbWriteEnabled();
        boolean turboOutboundWithoutTrxEnabled = TurboConfigProvider.getConfig().isTurboOutboundWithoutTrxEnabled() == null ? false : TurboConfigProvider.getConfig().isTurboOutboundWithoutTrxEnabled();
        Boolean appOnTDS = "TDS".equalsIgnoreCase(TurboConfigProvider.getConfig().getAppDbType());
        if (!appOnTDS.booleanValue()) {
            throw new IllegalArgumentException("use prepareOutboundMessageRepository to construct repository");
        }
        if (isMultiDbWriteEnabled.booleanValue()) {
            DynamicShardStrategy<OutboundMessage> dynamicShardStrategy = TurboShardStrategyProvider.getStrategy();
            if (shardStrategy == null && dynamicShardStrategy == null) {
                return new TDSTurboHibernateOutboundMessageRepository(session, true, isSingleDbWriteEnabled, turboOutboundWithoutTrxEnabled);
            }
            if (shardStrategy == null) {
                shardStrategy = new DummyOmsShardStrategy();
            }
            if (dynamicShardStrategy == null) {
                dynamicShardStrategy = new DummyTurboShardStrategy();
            }
            return new TDSTurboHibernateOutboundMessageShardRepository(session, true, isSingleDbWriteEnabled, turboOutboundWithoutTrxEnabled, shardStrategy, dynamicShardStrategy);
        }
        throw new IllegalArgumentException("use prepareOutboundMessageRepository to construct repository");
    }
}

