/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.restbus.hibernate.client;

import com.flipkart.restbus.client.entity.OutboundMessage;
import com.flipkart.restbus.hibernate.client.OutboundMessageRepository;
import com.flipkart.restbus.hibernate.models.OutboundMessageEntity;
import com.flipkart.restbus.hibernate.utils.OutboundMessageUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.jdbc.Work;

public class HibernateOutboundMessageRepository
implements OutboundMessageRepository {
    private final Session session;

    public HibernateOutboundMessageRepository(Session session) {
        this.session = session;
    }

    @Override
    public void persist(OutboundMessage message) {
        this.session.saveOrUpdate((Object)new OutboundMessageEntity(message));
    }

    @Override
    public void persist(List<OutboundMessage> messages) {
        final List<OutboundMessage> outboundMessages = messages;
        this.session.doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                PreparedStatement preparedStatement = connection.prepareStatement(OutboundMessageUtils.getCreateSqlQueryForOutboundMessages());
                try {
                    OutboundMessageUtils.bulkInsertMessages(preparedStatement, outboundMessages);
                }
                finally {
                    if (null != preparedStatement) {
                        preparedStatement.close();
                    }
                }
            }
        });
    }

    @Override
    public void persist(String dbShard, List<OutboundMessage> messages) {
        throw new UnsupportedOperationException("method not implemented");
    }

    @Override
    public OutboundMessage findMessageById(String messageId, String tableName) {
        OutboundMessageEntity outboundMessageEntity = (OutboundMessageEntity)this.session.createCriteria(OutboundMessageEntity.class).add((Criterion)Restrictions.eq((String)"messageId", (Object)messageId)).uniqueResult();
        return outboundMessageEntity;
    }
}

