/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.restbus.client.shards;

import com.flipkart.restbus.client.entity.OutboundMessage;
import com.flipkart.restbus.client.shards.OMShardStrategy;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TimeBasedOMShardStrategy
extends OMShardStrategy {
    public static final String HOURLY = "hourly";
    public static final String DAILY = "daily";
    public static final String WEEKLY = "weekly";
    public static final String MONTHLY = "monthly";
    private Frequency frequency;

    public TimeBasedOMShardStrategy(String config) {
        if (HOURLY.equals(config)) {
            this.frequency = FrequencyBuilder.build(0);
        } else if (DAILY.equals(config)) {
            this.frequency = FrequencyBuilder.build(1);
        } else if (WEEKLY.equals(config)) {
            this.frequency = FrequencyBuilder.build(2);
        } else if (MONTHLY.equals(config)) {
            this.frequency = FrequencyBuilder.build(3);
        } else {
            throw new IllegalArgumentException(String.format("TimeBasedOMShardStrategy config '%s' is invalid", config));
        }
    }

    @Override
    public String getShardSuffix(OutboundMessage message) {
        return this.frequency.getSuffix(message.getCreatedAt());
    }

    public static class FrequencyBuilder {
        public static final int HOURLY = 0;
        public static final int DAILY = 1;
        public static final int WEEKLY = 2;
        public static final int MONTHLY = 3;

        public static Frequency build(int frequency) {
            String prefix;
            String dateFormat;
            switch (frequency) {
                case 0: {
                    dateFormat = "yyyyMMddHH";
                    prefix = "h";
                    break;
                }
                case 1: {
                    dateFormat = "yyyyMMdd";
                    prefix = "d";
                    break;
                }
                case 3: {
                    dateFormat = "yyyyMM";
                    prefix = "m";
                    break;
                }
                default: {
                    dateFormat = "yyyyww";
                    prefix = "w";
                }
            }
            return new Frequency(prefix, dateFormat);
        }
    }

    public static class Frequency {
        private String prefix;
        private String pattern;
        private DateFormat dateFormat;

        Frequency(String prefix, String pattern) {
            this.prefix = prefix;
            this.pattern = pattern;
            this.dateFormat = new SimpleDateFormat(pattern);
        }

        public String getSuffix(Date date) {
            return this.prefix + "_" + this.dateFormat.format(date);
        }
    }
}

