/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.restbus.client.shards;

import com.flipkart.restbus.client.shards.ExchangeBasedOMShardStrategy;
import com.flipkart.restbus.client.shards.MixedShardStrategy;
import com.flipkart.restbus.client.shards.OMShardConfig;
import com.flipkart.restbus.client.shards.OMShardStrategy;
import com.flipkart.restbus.client.shards.TimeBasedOMShardStrategy;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMShardStrategyProvider {
    private static final Logger logger = LoggerFactory.getLogger(OMShardStrategyProvider.class);
    private static final String TYPE_TIME_BASED = "time_based";
    private static final String TYPE_QUEUE_BASED = "queue_based";
    private static final String TYPE_MIXED = "mixed";
    private static OMShardStrategy strategy = null;
    private static final String DEFAULT_SHARD_CONFIG_FILE_PATH = "/etc/fk-sc-mq/config.yml";

    private static OMShardStrategy createShardStrategy(OMShardConfig config) {
        OMShardStrategy shardStrategy = null;
        if (config != null && config.sharding) {
            String strategyType = StringUtils.defaultIfEmpty((String)config.sharding_strategy, (String)TYPE_TIME_BASED);
            String timeConfig = StringUtils.defaultIfEmpty((String)config.time_shard_strategy, (String)"weekly");
            if (TYPE_TIME_BASED.equals(strategyType)) {
                shardStrategy = new TimeBasedOMShardStrategy(timeConfig);
            } else if (TYPE_QUEUE_BASED.equals(strategyType)) {
                shardStrategy = new ExchangeBasedOMShardStrategy(config.queue_shard_strategy);
            } else if (TYPE_MIXED.equals(strategyType)) {
                shardStrategy = new MixedShardStrategy(new TimeBasedOMShardStrategy(timeConfig), new ExchangeBasedOMShardStrategy(config.queue_shard_strategy));
            }
        }
        return shardStrategy;
    }

    private static OMShardConfig getShardConfig() {
        OMShardConfig config = null;
        String configFilePath = System.getProperty("SC_MQ_CONFIG");
        if (configFilePath == null || configFilePath.isEmpty()) {
            configFilePath = DEFAULT_SHARD_CONFIG_FILE_PATH;
        }
        FileInputStream document = null;
        try {
            document = new FileInputStream(new File(configFilePath));
            config = OMShardConfig.parseDocument(document);
            logger.info("Outbound Message sharding config loaded from " + configFilePath);
        }
        catch (FileNotFoundException e) {
            if (DEFAULT_SHARD_CONFIG_FILE_PATH.equals(configFilePath)) {
                logger.debug("Default shard config at /etc/fk-sc-mq/config.yml not found.");
            }
            logger.error(configFilePath + " file not found.");
        }
        return config;
    }

    public static OMShardStrategy getStrategy() {
        if (strategy == null) {
            OMShardConfig config = OMShardStrategyProvider.getShardConfig();
            strategy = OMShardStrategyProvider.getStrategy(config);
            logger.info("Using shard strategy: " + strategy);
        }
        return strategy;
    }

    public static OMShardStrategy getStrategy(OMShardConfig config) {
        return OMShardStrategyProvider.createShardStrategy(config);
    }
}

