/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.serde.handlers.json;

import com.flipkart.gojira.serde.TestSerdeException;
import com.flipkart.gojira.serde.handlers.TestSerdeHandler;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.gojira.com.fasterxml.jackson.core.JsonProcessingException;
import shaded.gojira.com.fasterxml.jackson.databind.DeserializationFeature;
import shaded.gojira.com.fasterxml.jackson.databind.ObjectMapper;
import shaded.gojira.com.fasterxml.jackson.databind.SerializationFeature;
import shaded.gojira.com.fasterxml.jackson.databind.jsontype.impl.StdSubtypeResolver;

public class JsonDefaultTestSerdeHandler
implements TestSerdeHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonDefaultTestSerdeHandler.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    @Override
    public <T> byte[] serialize(T obj) throws TestSerdeException {
        try {
            return mapper.writeValueAsBytes(obj);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("error serializing data.", e);
            throw new TestSerdeException("error serializing data.", e);
        }
    }

    @Override
    public <T> T deserialize(byte[] bytes, Class<T> clazz) throws TestSerdeException {
        try {
            return mapper.readValue(bytes, clazz);
        }
        catch (IOException e) {
            LOGGER.error("error de-serializing data.", e);
            throw new TestSerdeException("error de-serializing data.", e);
        }
    }

    @Override
    public <T> void deserializeToInstance(byte[] bytes, T obj) throws TestSerdeException {
        try {
            mapper.readerForUpdating(obj).readValue(bytes);
        }
        catch (IOException e) {
            throw new TestSerdeException("error updating object.", e);
        }
    }

    static {
        mapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        mapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        mapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        mapper.setSubtypeResolver(new StdSubtypeResolver());
    }
}

