/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.execute;

import com.flipkart.gojira.core.injectors.GuiceInjector;
import com.flipkart.gojira.execute.TestExecutionException;
import com.flipkart.gojira.execute.TestExecutor;
import com.flipkart.gojira.models.TestData;
import com.flipkart.gojira.models.TestDataType;
import com.flipkart.gojira.models.TestRequestData;
import com.flipkart.gojira.serde.SerdeHandlerRepository;
import com.flipkart.gojira.serde.TestSerdeException;
import com.flipkart.gojira.serde.handlers.TestSerdeHandler;
import com.flipkart.gojira.sinkstore.SinkException;
import com.flipkart.gojira.sinkstore.handlers.SinkHandler;
import com.google.inject.Key;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdBasedTestExecutor<T extends TestDataType> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdBasedTestExecutor.class);
    private String testId;
    private SinkHandler sinkHandler = GuiceInjector.getInjector().getInstance(SinkHandler.class);
    private TestSerdeHandler testDataSerdeHandler = GuiceInjector.getInjector().getInstance(SerdeHandlerRepository.class).getTestDataSerdeHandler();

    public void execute(String testId) throws TestExecutionException, SinkException, TestSerdeException {
        TestData testData = this.testDataSerdeHandler.deserialize(this.sinkHandler.read(testId), TestData.class);
        GuiceInjector.getInjector().getInstance(Key.get(TestExecutor.class, (Annotation)Names.named(((TestRequestData)testData.getRequestData()).getType()))).execute(testData);
    }

    public void execute(String testId, String clientId) throws TestExecutionException, SinkException, TestSerdeException {
        TestData testData = this.testDataSerdeHandler.deserialize(this.sinkHandler.read(testId), TestData.class);
        GuiceInjector.getInjector().getInstance(Key.get(TestExecutor.class, (Annotation)Names.named(((TestRequestData)testData.getRequestData()).getType()))).execute(testData, clientId);
    }
}

