/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.core;

import com.flipkart.gojira.compare.GojiraComparisonModule;
import com.flipkart.gojira.compare.config.GojiraComparisonConfig;
import com.flipkart.gojira.core.Mode;
import com.flipkart.gojira.core.ProfileRepository;
import com.flipkart.gojira.core.injectors.GuiceInjector;
import com.flipkart.gojira.queuedsender.TestQueuedSenderModule;
import com.flipkart.gojira.queuedsender.config.TestQueuedSenderConfig;
import com.flipkart.gojira.requestsampling.RequestSamplingModule;
import com.flipkart.gojira.requestsampling.config.RequestSamplingConfig;
import com.flipkart.gojira.serde.SerdeModule;
import com.flipkart.gojira.serde.config.SerdeConfig;
import com.flipkart.gojira.sinkstore.config.DataStoreConfig;
import com.flipkart.gojira.sinkstore.config.DataStoreModule;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.gojira.com.fasterxml.jackson.databind.ObjectMapper;

public class SetupModule
extends AbstractModule {
    public static final Logger LOGGER = LoggerFactory.getLogger(SetupModule.class);
    private Mode mode;
    private RequestSamplingConfig requestSamplingConfig;
    private SerdeConfig serdeConfig;
    private GojiraComparisonConfig gojiraComparisonConfig;
    private DataStoreConfig dataStoreConfig;
    private TestQueuedSenderConfig testQueuedSenderConfig;

    public SetupModule(Mode mode, RequestSamplingConfig requestSamplingConfig, SerdeConfig serdeConfig, GojiraComparisonConfig gojiraComparisonConfig, DataStoreConfig dataStoreConfig, TestQueuedSenderConfig testQueuedSenderConfig) {
        this.mode = mode;
        this.requestSamplingConfig = requestSamplingConfig;
        this.serdeConfig = serdeConfig;
        this.gojiraComparisonConfig = gojiraComparisonConfig;
        this.dataStoreConfig = dataStoreConfig;
        this.testQueuedSenderConfig = testQueuedSenderConfig;
    }

    @Override
    protected void configure() {
        ProfileRepository.setMode(this.mode);
        Injector injector = Guice.createInjector(new AbstractModule(){

            @Override
            protected void configure() {
                this.bind(ObjectMapper.class).asEagerSingleton();
                this.install(new RequestSamplingModule(SetupModule.this.requestSamplingConfig));
                this.install(new SerdeModule(SetupModule.this.serdeConfig));
                this.install(new GojiraComparisonModule(SetupModule.this.gojiraComparisonConfig));
                this.install(new DataStoreModule(SetupModule.this.dataStoreConfig));
                this.install(new TestQueuedSenderModule(SetupModule.this.testQueuedSenderConfig));
            }
        });
        GuiceInjector.assignInjector(injector);
    }
}

