/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.compare.diff;

import com.flipkart.compare.diff.DiffIgnoreRepository;
import com.flipkart.compare.diff.DiffType;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiffIgnoreRepositoryImpl
extends DiffIgnoreRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiffIgnoreRepositoryImpl.class);

    @Override
    public Map<DiffType, List<Pattern>> getDiffIgnorePatterns() {
        return diffIgnorePatterns;
    }

    @Override
    public synchronized void setupDiffIgnorePatterns(Map<String, List<String>> jsonDiffIgnoreMap) {
        if (jsonDiffIgnoreMap != null) {
            for (Map.Entry<String, List<String>> entry : jsonDiffIgnoreMap.entrySet()) {
                DiffType diffType = Enum.valueOf(DiffType.class, entry.getKey());
                List ignorePatternList = entry.getValue().stream().map(ignorePattern -> Pattern.compile(ignorePattern, 2)).collect(Collectors.toList());
                diffIgnorePatterns.put(diffType, ignorePatternList);
                LOGGER.info(diffType.toString() + " type added for paths: " + ignorePatternList.toString());
            }
        }
    }
}

