/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.compare.diff;

import com.flipkart.compare.diff.DiffType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.gojira.com.fasterxml.jackson.core.JsonProcessingException;
import shaded.gojira.com.fasterxml.jackson.databind.ObjectMapper;

public class DiffDetail {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiffDetail.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private DiffType diffType;
    private String diffPath = "";
    private Object expectedValue;
    private Object actualValue;

    private DiffDetail() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public DiffType getDiffType() {
        return this.diffType;
    }

    public String getDiffPath() {
        return this.diffPath;
    }

    public Object getExpectedValue() {
        return this.expectedValue;
    }

    public Object getActualValue() {
        return this.actualValue;
    }

    public String toString() {
        try {
            return objectMapper.writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("something  went  wrong with diff detail: ", e);
            return null;
        }
    }

    public static class Builder {
        private DiffDetail diffDetailToBuild = new DiffDetail();

        private Builder() {
        }

        public DiffDetail build() {
            return this.diffDetailToBuild;
        }

        public Builder setDiffType(DiffType diffType) {
            this.diffDetailToBuild.diffType = diffType;
            return this;
        }

        public Builder setDiffPath(String diffPath) {
            this.diffDetailToBuild.diffPath = diffPath;
            return this;
        }

        public Builder setExpectedValue(Object expectedValue) {
            this.diffDetailToBuild.expectedValue = expectedValue;
            return this;
        }

        public Builder setActualValue(Object actualValue) {
            this.diffDetailToBuild.actualValue = actualValue;
            return this;
        }
    }
}

