/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.hash;

import com.flipkart.gojira.hash.TestHashException;
import com.flipkart.gojira.hash.TestHashHandler;
import com.flipkart.gojira.hash.annotations.HashHandler;
import java.lang.annotation.Annotation;
import java.util.concurrent.ConcurrentHashMap;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashHandlerUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(HashHandlerUtil.class);
    private static ConcurrentHashMap<String, TestHashHandler> hashHandlerMap = new ConcurrentHashMap();

    public static TestHashHandler getHashHandler(MethodInvocation invocation, int position) throws TestHashException {
        try {
            String genericMethodName = invocation.getMethod().toGenericString();
            if (hashHandlerMap.containsKey(genericMethodName + "|" + position)) {
                return hashHandlerMap.get(genericMethodName + "|" + position);
            }
            HashHandler annotatedHashHandler = HashHandlerUtil.annotatedHashHandler(invocation, position);
            if (annotatedHashHandler != null) {
                hashHandlerMap.put(genericMethodName + "|" + position, annotatedHashHandler.hashHandlerClass().newInstance());
                return hashHandlerMap.get(genericMethodName + "|" + position);
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.error("error trying to get hash handler.", e);
            throw new TestHashException("error trying to get hash handler.", e);
        }
    }

    private static HashHandler annotatedHashHandler(MethodInvocation invocation, int position) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = invocation.getMethod().getParameterAnnotations()[position]) {
            if (!(annotation instanceof HashHandler)) continue;
            return (HashHandler)annotation;
        }
        return null;
    }
}

