/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.core;

import com.flipkart.gojira.core.MethodDataInterceptorHandler;
import com.flipkart.gojira.core.ProfileRepository;
import com.flipkart.gojira.core.ProfileState;
import com.flipkart.gojira.core.injectors.GuiceInjector;
import com.flipkart.gojira.execute.TestExecutionException;
import com.flipkart.gojira.models.MethodData;
import com.flipkart.gojira.models.MethodDataType;
import com.flipkart.gojira.serde.SerdeHandlerRepository;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializeMethodDataInterceptorHandler
implements MethodDataInterceptorHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerializeMethodDataInterceptorHandler.class);
    private SerdeHandlerRepository serdeHandlerRepository = GuiceInjector.getInjector().getInstance(SerdeHandlerRepository.class);

    @Override
    public Object handle(MethodInvocation invocation) throws Throwable {
        if (!ProfileRepository.getProfileState().equals((Object)ProfileState.INITIATED)) {
            throw new TestExecutionException("Serialize test was not initiated.");
        }
        String genericMethodName = null;
        String globalPerRequestId = null;
        globalPerRequestId = ProfileRepository.getGlobalPerRequestID();
        genericMethodName = invocation.getMethod().toGenericString();
        ConcurrentSkipListMap<Long, ConcurrentHashMap<MethodDataType, List<MethodData>>> perMethodAllEntries = ProfileRepository.getTestData().getMethodDataMap().get(genericMethodName);
        for (Map.Entry<Long, ConcurrentHashMap<MethodDataType, List<MethodData>>> perMethodEntry : perMethodAllEntries.entrySet()) {
            int index;
            Map methodDataMap = perMethodEntry.getValue();
            if (methodDataMap.containsKey((Object)MethodDataType.ARGUMENT_BEFORE) && !((List)methodDataMap.get((Object)MethodDataType.ARGUMENT_BEFORE)).isEmpty()) {
                index = -1;
                for (MethodData methodData : (List)methodDataMap.get((Object)MethodDataType.ARGUMENT_BEFORE)) {
                    ++index;
                    if (methodData.getData() != null) continue;
                    try {
                        LOGGER.info("deserialization starting for ");
                        this.serdeHandlerRepository.getOrUpdateAndGetOrDefaultMethodArgumentDataSerdeHandler(invocation, index).deserializeToInstance(methodData.getData(), invocation.getArguments()[index]);
                    }
                    catch (Exception e) {
                        LOGGER.error("deserialization failed");
                    }
                }
            }
            if (methodDataMap.containsKey((Object)MethodDataType.ARGUMENT_AFTER) && !((List)methodDataMap.get((Object)MethodDataType.ARGUMENT_AFTER)).isEmpty()) {
                index = -1;
                for (MethodData methodData : (List)methodDataMap.get((Object)MethodDataType.ARGUMENT_AFTER)) {
                    ++index;
                    if (methodData.getData() == null) continue;
                    try {
                        LOGGER.info("deserialization starting for ");
                        this.serdeHandlerRepository.getOrUpdateAndGetOrDefaultMethodArgumentDataSerdeHandler(invocation, index).deserializeToInstance(methodData.getData(), invocation.getArguments()[index]);
                    }
                    catch (Exception e) {
                        LOGGER.error("deserialization failed");
                    }
                }
            }
            if (methodDataMap.containsKey((Object)MethodDataType.EXCEPTION) && !((List)methodDataMap.get((Object)MethodDataType.EXCEPTION)).isEmpty()) {
                if (((List)methodDataMap.get((Object)MethodDataType.EXCEPTION)).get(0) == null || ((MethodData)((List)methodDataMap.get((Object)MethodDataType.EXCEPTION)).get(0)).getClassName() == null || ((MethodData)((List)methodDataMap.get((Object)MethodDataType.EXCEPTION)).get(0)).getData() == null) {
                    LOGGER.error("exception methodData or methodData.className or methodData.data null, error running test.method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
                }
                try {
                    LOGGER.info("deserialization starting for " + Class.forName(((MethodData)((List)methodDataMap.get((Object)MethodDataType.EXCEPTION)).get(0)).getClassName()));
                    this.serdeHandlerRepository.getExceptionDataSerdeHandler(genericMethodName, ((MethodData)((List)methodDataMap.get((Object)MethodDataType.EXCEPTION)).get(0)).getClassName()).deserialize(((MethodData)((List)methodDataMap.get((Object)MethodDataType.EXCEPTION)).get(0)).getData(), Class.forName(((MethodData)((List)methodDataMap.get((Object)MethodDataType.EXCEPTION)).get(0)).getClassName()));
                }
                catch (Exception e) {
                    LOGGER.error("deserialization failed for " + Class.forName(((MethodData)((List)methodDataMap.get((Object)MethodDataType.EXCEPTION)).get(0)).getClassName()));
                }
            }
            if (!methodDataMap.containsKey((Object)MethodDataType.RETURN) || ((List)methodDataMap.get((Object)MethodDataType.RETURN)).isEmpty()) continue;
            if (((List)methodDataMap.get((Object)MethodDataType.RETURN)).get(0) == null || ((MethodData)((List)methodDataMap.get((Object)MethodDataType.RETURN)).get(0)).getData() != null && ((MethodData)((List)methodDataMap.get((Object)MethodDataType.RETURN)).get(0)).getClassName() == null) {
                LOGGER.error("return methodData or methodData.getData not null and methodData.className null, error running test.method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
            }
            try {
                LOGGER.info("deserialization starting for " + Class.forName(((MethodData)((List)methodDataMap.get((Object)MethodDataType.RETURN)).get(0)).getClassName()));
                this.serdeHandlerRepository.getOrUpdateAndGetOrDefaultReturnDataSerdeHandler(invocation).deserialize(((MethodData)((List)methodDataMap.get((Object)MethodDataType.RETURN)).get(0)).getData(), Class.forName(((MethodData)((List)methodDataMap.get((Object)MethodDataType.RETURN)).get(0)).getClassName()));
            }
            catch (Exception e) {
                LOGGER.error("deserialization failed for " + Class.forName(((MethodData)((List)methodDataMap.get((Object)MethodDataType.RETURN)).get(0)).getClassName()));
            }
        }
        return null;
    }
}

