/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.core;

import com.flipkart.gojira.core.HttpFilter;
import com.flipkart.gojira.core.injectors.GuiceInjector;
import com.flipkart.gojira.requestsampling.RequestSamplingRepository;
import com.flipkart.gojira.serde.TestSerdeException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpFilterHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpFilterHandler.class);
    protected final String TEST_HEADER = "X-GOJIRA-ID";

    protected abstract boolean preFilter(HttpFilter.CustomHttpServletRequestWrapper var1);

    protected final void filter(HttpFilter.CustomHttpServletRequestWrapper request, HttpFilter.TestServletResponseWrapper response, FilterChain chain) throws IOException, ServletException {
        chain.doFilter(request, response);
    }

    protected abstract void postFilter(HttpFilter.CustomHttpServletRequestWrapper var1, HttpFilter.TestServletResponseWrapper var2, ServletResponse var3) throws IOException;

    protected final Map<String, String> getHeaders(HttpFilter.TestServletResponseWrapper resWrapper) throws TestSerdeException {
        Collection<String> headerNames = resWrapper.getHeaderNames();
        HashMap<String, String> headersMap = new HashMap<String, String>();
        if (headerNames != null) {
            for (String headerName : headerNames) {
                headersMap.put(headerName, resWrapper.getHeader(headerName));
            }
        }
        return headersMap;
    }

    protected final String getTestId(HttpFilter.CustomHttpServletRequestWrapper request) {
        return request.getHeader("X-GOJIRA-ID");
    }

    protected final boolean isWhitelistedURL(String uri, String method) {
        List<Pattern> whitelistedURIs = GuiceInjector.getInjector().getInstance(RequestSamplingRepository.class).getWhitelist();
        for (Pattern whitelistedURI : whitelistedURIs) {
            if (!whitelistedURI.matcher(method + " " + uri).matches()) continue;
            return true;
        }
        LOGGER.info(String.format("uri: %s and method: %s is not whitelisted for Gojira... Hence ignoring!", uri, method));
        return false;
    }
}

