/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.compare;

import com.flipkart.compare.CompareHandlerRepository;
import com.flipkart.compare.CompareHandlerRepositoryImpl;
import com.flipkart.compare.config.ComparisonConfig;
import com.flipkart.compare.diff.DiffIgnoreRepository;
import com.flipkart.compare.diff.DiffIgnoreRepositoryImpl;
import com.flipkart.compare.handlers.TestCompareHandler;
import com.google.inject.AbstractModule;

public class ComparisonModule
extends AbstractModule {
    private final ComparisonConfig comparisonConfig;

    public ComparisonModule(ComparisonConfig comparisonConfig) {
        this.comparisonConfig = comparisonConfig;
    }

    @Override
    protected void configure() {
        CompareHandlerRepositoryImpl compareHandlerRepository = new CompareHandlerRepositoryImpl();
        ((CompareHandlerRepository)compareHandlerRepository).setDefaultCompareHandler(this.comparisonConfig.getDefaultCompareHandler());
        this.bind(CompareHandlerRepository.class).toInstance(compareHandlerRepository);
        DiffIgnoreRepositoryImpl diffIgnoreRepository = new DiffIgnoreRepositoryImpl();
        ((DiffIgnoreRepository)diffIgnoreRepository).setupDiffIgnorePatterns(this.comparisonConfig.getDiffIgnoreMap());
        this.bind(DiffIgnoreRepository.class).toInstance(diffIgnoreRepository);
        this.requestStaticInjection(TestCompareHandler.class);
    }
}

