/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.masquerade.util;

import com.flipkart.masquerade.Configuration;
import com.flipkart.masquerade.rule.BasicRule;
import com.flipkart.masquerade.rule.Rule;
import com.flipkart.masquerade.util.ClassMeta;
import com.google.common.reflect.ClassPath;
import com.squareup.javapoet.ClassName;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Helper {
    private static final Set<Class<?>> wrapperTypes = new HashSet();
    private static final Set<Class<?>> primitiveTypes = new HashSet();
    private static final Map<Class<?>, ClassMeta<?>> classInformation = new HashMap();

    public static String getSetterName(String name, boolean isBoolean) {
        String capitalizedName = Helper.capitalize(name);
        String prefix = "set";
        if (isBoolean) {
            capitalizedName = Helper.handleIsPrefix(capitalizedName);
        }
        return prefix + capitalizedName;
    }

    public static String getGetterName(String name, boolean isBoolean, boolean isPrimitive) {
        String capitalizedName = Helper.capitalize(name);
        String prefix = "get";
        if (isBoolean) {
            capitalizedName = Helper.handleIsPrefix(capitalizedName);
            if (isPrimitive) {
                prefix = "is";
            }
        }
        return prefix + capitalizedName;
    }

    public static String handleIsPrefix(String name) {
        String capitalizedName = Helper.capitalize(name);
        if (capitalizedName.startsWith("Is") && capitalizedName.length() > 2 && Character.isUpperCase(capitalizedName.charAt(2))) {
            capitalizedName = capitalizedName.substring(2);
        }
        return capitalizedName;
    }

    public static Set<Class<?>> getWrapperTypes() {
        return wrapperTypes;
    }

    public static Set<Class<?>> getPrimitivesTypes() {
        return primitiveTypes;
    }

    public static Set<Class<?>> getEmptiableTypes() {
        HashSet ret = new HashSet();
        ret.add(Map.class);
        ret.add(Collection.class);
        ret.add(String.class);
        return ret;
    }

    private static String capitalize(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static String deCapitalize(String name) {
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }

    public static ClassName getRuleInterface(Configuration configuration, Rule rule) {
        return ClassName.get((String)configuration.getCloakPackage(), (String)(rule.getName() + "Mask"), (String[])new String[0]);
    }

    public static ClassName getRepositoryClass(Configuration configuration) {
        return ClassName.get((String)configuration.getCloakPackage(), (String)"Trunk", (String[])new String[0]);
    }

    public static String getRepositoryGetter() {
        return "getTrunk";
    }

    public static String getInterfaceName(Rule rule) {
        return rule.getName() + "Mask";
    }

    public static String getImplementationName(Rule rule, Class<?> clazz) {
        return Helper.generateImplementationName(rule, clazz.getSimpleName());
    }

    public static String getNoOpImplementationName(Rule rule) {
        return Helper.generateImplementationName(rule, "NoOp");
    }

    public static String getEnumImplementationName(Rule rule) {
        return Helper.generateImplementationName(rule, "Enum");
    }

    public static String getToStringImplementationName(Rule rule) {
        return Helper.generateImplementationName(rule, "ToString");
    }

    public static String getMapImplementationName(Rule rule) {
        return Helper.generateImplementationName(rule, "Map");
    }

    public static String getStringImplementationName(Rule rule) {
        return Helper.generateImplementationName(rule, "String");
    }

    public static String getCollectionImplementationName(Rule rule) {
        return Helper.generateImplementationName(rule, "Collection");
    }

    public static String getObjectArrayImplementationName(Rule rule) {
        return Helper.generateImplementationName(rule, "ObjectArray");
    }

    public static String getPrimitiveArrayImplementationName(Rule rule, Class<?> clazz) {
        return Helper.generateImplementationName(rule, Helper.capitalize(clazz.getSimpleName()) + "ArrayPrimitive");
    }

    public static String getPrimitiveImplementationName(Rule rule, Class<?> clazz) {
        return Helper.generateImplementationName(rule, Helper.capitalize(clazz.getSimpleName()));
    }

    public static ClassName getNoOpImplementationClass(Configuration configuration, Rule rule) {
        return ClassName.get((String)configuration.getCloakPackage(), (String)Helper.getNoOpImplementationName(rule), (String[])new String[0]);
    }

    public static ClassName getEnumImplementationClass(Configuration configuration, Rule rule) {
        return ClassName.get((String)configuration.getCloakPackage(), (String)Helper.getEnumImplementationName(rule), (String[])new String[0]);
    }

    public static ClassName getToStringImplementationClass(Configuration configuration, Rule rule) {
        return ClassName.get((String)configuration.getCloakPackage(), (String)Helper.getToStringImplementationName(rule), (String[])new String[0]);
    }

    public static ClassName getMapImplementationClass(Configuration configuration, Rule rule) {
        return ClassName.get((String)configuration.getCloakPackage(), (String)Helper.getMapImplementationName(rule), (String[])new String[0]);
    }

    public static ClassName getCollectionImplementationClass(Configuration configuration, Rule rule) {
        return ClassName.get((String)configuration.getCloakPackage(), (String)Helper.getCollectionImplementationName(rule), (String[])new String[0]);
    }

    public static ClassName getObjectArrayImplementationClass(Configuration configuration, Rule rule) {
        return ClassName.get((String)configuration.getCloakPackage(), (String)Helper.getObjectArrayImplementationName(rule), (String[])new String[0]);
    }

    public static ClassName getStringImplementationClass(Configuration configuration, Rule rule) {
        return ClassName.get((String)configuration.getCloakPackage(), (String)Helper.getStringImplementationName(rule), (String[])new String[0]);
    }

    public static ClassName getPrimitiveArrayImplementationClass(Configuration configuration, Rule rule, Class<?> clazz) {
        return ClassName.get((String)configuration.getCloakPackage(), (String)Helper.getPrimitiveArrayImplementationName(rule, clazz), (String[])new String[0]);
    }

    public static ClassName getPrimitiveImplementationClass(Configuration configuration, Rule rule, Class<?> clazz) {
        return ClassName.get((String)configuration.getCloakPackage(), (String)Helper.getPrimitiveImplementationName(rule, clazz), (String[])new String[0]);
    }

    private static String generateImplementationName(Rule rule, String prefix) {
        return prefix + rule.getName() + "Mask";
    }

    public static String getImplementationPackage(Configuration configuration, Class<?> clazz) {
        return configuration.getCloakPackage() + "." + clazz.getPackage().getName();
    }

    public static ClassName getEntryClass(Configuration configuration) {
        return ClassName.get((String)configuration.getCloakPackage(), (String)"Cloak", (String[])new String[0]);
    }

    public static String getNoOpVariableName(Rule rule) {
        return "noOp" + rule.getName();
    }

    public static String getEnumVariableName(Rule rule) {
        return "enum" + rule.getName();
    }

    public static String getVariableName(ClassName className) {
        return className.reflectionName().replaceAll("\\.", "_");
    }

    public static String getVariableName(Configuration configuration, Rule rule, Class<?> clazz) {
        return Helper.getVariableName(ClassName.get((String)Helper.getImplementationPackage(configuration, clazz), (String)Helper.getImplementationName(rule, clazz), (String[])new String[0]));
    }

    public static String getToStringVariableName(Rule rule) {
        return "toString" + rule.getName();
    }

    public static String getMapVariableName(Rule rule) {
        return "map" + rule.getName();
    }

    public static String getCollectionVariableName(Rule rule) {
        return "collection" + rule.getName();
    }

    public static String getObjectArrayVariableName(Rule rule) {
        return "objectArray" + rule.getName();
    }

    public static String getStringVariableName(Rule rule) {
        return "string" + rule.getName();
    }

    public static String getPrimitiveArrayVariableName(Rule rule, Class<?> clazz) {
        return clazz.getSimpleName().toLowerCase() + "ArrayPrimitive" + rule.getName();
    }

    public static String getPrimitiveVariableName(Rule rule, Class<?> clazz) {
        return clazz.getSimpleName().toLowerCase() + rule.getName();
    }

    public static Set<ClassPath.ClassInfo> getPackageClasses(ClassLoader classLoader, List<String> packagesToScan) throws IOException {
        ClassPath classpath = ClassPath.from((ClassLoader)classLoader);
        HashSet<ClassPath.ClassInfo> classDescriptions = new HashSet<ClassPath.ClassInfo>();
        for (String basePackage : packagesToScan) {
            classDescriptions.addAll((Collection<ClassPath.ClassInfo>)classpath.getTopLevelClassesRecursive(basePackage));
        }
        return classDescriptions;
    }

    public static List<Field> getNonStaticFields(Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> c = type; c != null; c = c.getSuperclass()) {
            fields.addAll(Arrays.asList(c.getDeclaredFields()).stream().filter(field -> !Modifier.isStatic(field.getModifiers())).collect(Collectors.toList()));
        }
        return fields;
    }

    public static <T extends Annotation> T getAnnotation(Class<?> type, Class<T> annotationClass) {
        for (Class<?> c = type; c != null; c = c.getSuperclass()) {
            T annotation = c.getAnnotation(annotationClass);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    public static String getEvaluationFunction(BasicRule basicRule) {
        return "eval." + basicRule.getEvaluatorFunction();
    }

    public static boolean isAbstract(Class clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    public static boolean isPublic(Class clazz) {
        return Modifier.isPublic(clazz.getModifiers());
    }

    public static boolean isBoolean(Class<?> clazz) {
        return clazz.equals(Boolean.TYPE) || clazz.equals(Boolean.class);
    }

    public static void mapClasses(Set<ClassPath.ClassInfo> scannedClasses, ClassLoader classLoader) throws ClassNotFoundException {
        for (ClassPath.ClassInfo classInfo : scannedClasses) {
            Class<?> clazz = Class.forName(classInfo.getName(), true, classLoader);
            classInformation.put(clazz, new ClassMeta(clazz));
        }
        for (Class clazz : classInformation.keySet()) {
            ClassMeta<?> superClassMeta;
            Class superclass = clazz.getSuperclass();
            if (superclass == null || superclass.equals(Object.class) || (superClassMeta = classInformation.get(superclass)) == null) continue;
            superClassMeta.addSubClass(clazz);
        }
    }

    public static Map<Class<?>, ClassMeta<?>> getClassInformation() {
        return classInformation;
    }

    public static Set<Class<?>> getClasses() {
        return classInformation.keySet();
    }

    public static ClassMeta<?> getClassInformation(Class<?> clazz) {
        return classInformation.get(clazz);
    }

    static {
        wrapperTypes.add(Boolean.class);
        wrapperTypes.add(Character.class);
        wrapperTypes.add(Byte.class);
        wrapperTypes.add(Short.class);
        wrapperTypes.add(Integer.class);
        wrapperTypes.add(Long.class);
        wrapperTypes.add(Float.class);
        wrapperTypes.add(Double.class);
        wrapperTypes.add(Void.class);
        primitiveTypes.add(Boolean.TYPE);
        primitiveTypes.add(Byte.TYPE);
        primitiveTypes.add(Short.TYPE);
        primitiveTypes.add(Integer.TYPE);
        primitiveTypes.add(Long.TYPE);
        primitiveTypes.add(Float.TYPE);
        primitiveTypes.add(Double.TYPE);
    }
}

