/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.masquerade.processor.type;

import com.flipkart.masquerade.Configuration;
import com.flipkart.masquerade.processor.BaseOverrideProcessor;
import com.flipkart.masquerade.rule.Rule;
import com.flipkart.masquerade.util.Helper;
import com.flipkart.masquerade.util.Strings;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.List;

public class PrimitiveArrayOverrideProcessor
extends BaseOverrideProcessor {
    public PrimitiveArrayOverrideProcessor(Configuration configuration, TypeSpec.Builder cloakBuilder) {
        super(configuration, cloakBuilder);
    }

    public List<TypeSpec> createOverrides(Rule rule) {
        ArrayList<TypeSpec> typeSpecs = new ArrayList<TypeSpec>();
        for (Class<?> primitiveType : Helper.getPrimitivesTypes()) {
            String implName = Helper.getPrimitiveArrayImplementationName(rule, primitiveType);
            MethodSpec.Builder methodBuilder = this.generateOverrideMethod(rule, (TypeName)ArrayTypeName.of(primitiveType));
            if (this.configuration.isNativeSerializationEnabled()) {
                methodBuilder.addStatement("$L.append($S)", new Object[]{"serialized", "["});
                methodBuilder.beginControlFlow("for ($T o : $L)", new Object[]{primitiveType, Strings.OBJECT_PARAMETER});
                methodBuilder.addStatement("$L.$L(o, $L, $L)", new Object[]{Strings.CLOAK_PARAMETER, "hide", "eval", "serialized"});
                methodBuilder.addStatement("$L.append($S)", new Object[]{"serialized", ","});
                methodBuilder.endControlFlow();
                methodBuilder.beginControlFlow("if ($L.charAt($L.length() - 1) == ',')", new Object[]{"serialized", "serialized"});
                methodBuilder.addStatement("$L.deleteCharAt($L.length() - 1)", new Object[]{"serialized", "serialized"});
                methodBuilder.endControlFlow();
                methodBuilder.addStatement("$L.append($S)", new Object[]{"serialized", "]"});
            }
            typeSpecs.add(this.generateImplementationType(rule, (TypeName)ArrayTypeName.of(primitiveType), implName, methodBuilder.build()));
        }
        return typeSpecs;
    }
}

