/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.masquerade.processor.type;

import com.flipkart.masquerade.Configuration;
import com.flipkart.masquerade.processor.BaseOverrideProcessor;
import com.flipkart.masquerade.rule.Rule;
import com.flipkart.masquerade.util.Helper;
import com.flipkart.masquerade.util.Strings;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.List;

public class NumericalOverrideProcessor
extends BaseOverrideProcessor {
    public NumericalOverrideProcessor(Configuration configuration, TypeSpec.Builder cloakBuilder) {
        super(configuration, cloakBuilder);
    }

    public List<TypeSpec> createOverrides(Rule rule) {
        ArrayList<TypeSpec> typeSpecs = new ArrayList<TypeSpec>();
        for (Class<?> numericalType : this.configuration.numericalSerializableClasses()) {
            String implName = Helper.getPrimitiveImplementationName(rule, numericalType);
            MethodSpec.Builder methodBuilder = this.generateOverrideMethod(rule, numericalType);
            if (this.configuration.isNativeSerializationEnabled()) {
                methodBuilder.addStatement("$L.append($L.toString())", new Object[]{"serialized", Strings.OBJECT_PARAMETER});
            }
            typeSpecs.add(this.generateImplementationType(rule, numericalType, implName, methodBuilder.build()));
        }
        return typeSpecs;
    }
}

