/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.masquerade.processor.type;

import com.fasterxml.jackson.core.io.CharTypes;
import com.flipkart.masquerade.Configuration;
import com.flipkart.masquerade.processor.BaseOverrideProcessor;
import com.flipkart.masquerade.rule.Rule;
import com.flipkart.masquerade.util.Helper;
import com.flipkart.masquerade.util.Strings;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;

public class StringOverrideProcessor
extends BaseOverrideProcessor {
    public StringOverrideProcessor(Configuration configuration, TypeSpec.Builder cloakBuilder) {
        super(configuration, cloakBuilder);
    }

    public TypeSpec createOverride(Rule rule) {
        String implName = Helper.getStringImplementationName(rule);
        MethodSpec.Builder methodBuilder = this.generateOverrideMethod(rule, String.class);
        if (this.configuration.isNativeSerializationEnabled()) {
            methodBuilder.addStatement("$L.ensureCapacity($L.length() + $L.length() + 2);", new Object[]{"serialized", "serialized", Strings.OBJECT_PARAMETER});
            methodBuilder.addStatement("$L.append($S)", new Object[]{"serialized", "\""});
            methodBuilder.beginControlFlow("for (int i = 0; i < $L.length(); i++)", new Object[]{Strings.OBJECT_PARAMETER});
            methodBuilder.addStatement("char c = $L.charAt(i);", new Object[]{Strings.OBJECT_PARAMETER});
            methodBuilder.beginControlFlow("if (c < escLen && escCodes[c] != 0)", new Object[0]);
            methodBuilder.addStatement("$L.append((char) 92);", new Object[]{"serialized"});
            methodBuilder.addStatement("$L.append((char) escCodes[c]);", new Object[]{"serialized"});
            methodBuilder.nextControlFlow("else", new Object[0]);
            methodBuilder.addStatement("$L.append(c)", new Object[]{"serialized"});
            methodBuilder.endControlFlow();
            methodBuilder.endControlFlow();
            methodBuilder.addStatement("$L.append($S)", new Object[]{"serialized", "\""});
        }
        TypeSpec.Builder builder = this.generateImplementationType(rule, String.class, implName, methodBuilder.build()).toBuilder();
        builder.addField(FieldSpec.builder((TypeName)ArrayTypeName.of(Integer.TYPE), (String)"escCodes", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("$T.get7BitOutputEscapes()", new Object[]{CharTypes.class}).build());
        builder.addField(FieldSpec.builder(Integer.TYPE, (String)"escLen", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("escCodes.length", new Object[0]).build());
        return builder.build();
    }
}

