/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.masquerade.processor;

import com.flipkart.masquerade.Configuration;
import com.flipkart.masquerade.processor.DefaultRuleObjectProcessor;
import com.flipkart.masquerade.processor.InterfaceProcessor;
import com.flipkart.masquerade.processor.ReferenceMapProcessor;
import com.flipkart.masquerade.processor.RuleObjectProcessor;
import com.flipkart.masquerade.processor.SerializationRuleObjectProcessor;
import com.flipkart.masquerade.processor.type.CharacterPrimitiveArrayOverrideProcessor;
import com.flipkart.masquerade.processor.type.CollectionOverrideProcessor;
import com.flipkart.masquerade.processor.type.EnumOverrideProcessor;
import com.flipkart.masquerade.processor.type.MapOverrideProcessor;
import com.flipkart.masquerade.processor.type.NoOpOverrideProcessor;
import com.flipkart.masquerade.processor.type.ObjectArrayOverrideProcessor;
import com.flipkart.masquerade.processor.type.PrimitiveArrayOverrideProcessor;
import com.flipkart.masquerade.processor.type.PrimitiveOverrideProcessor;
import com.flipkart.masquerade.processor.type.StringOverrideProcessor;
import com.flipkart.masquerade.processor.type.ToStringProcessor;
import com.flipkart.masquerade.rule.Rule;
import com.flipkart.masquerade.util.TypeSpecContainer;
import com.flipkart.masquerade.util.Verifier;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class RuleProcessor {
    private final Configuration configuration;
    private final TypeSpec.Builder cloakBuilder;
    private final List<TypeSpecContainer> specs = new ArrayList<TypeSpecContainer>();

    public RuleProcessor(Configuration configuration, TypeSpec.Builder cloakBuilder) {
        this.configuration = configuration;
        this.cloakBuilder = cloakBuilder;
    }

    public List<TypeSpecContainer> generateRuleTypeSpecs() {
        ReferenceMapProcessor mapProcessor = new ReferenceMapProcessor(this.configuration, this.cloakBuilder);
        InterfaceProcessor interfaceProcessor = new InterfaceProcessor(this.configuration, this.cloakBuilder);
        RuleObjectProcessor ruleObjectProcessor = this.configuration.isNativeSerializationEnabled() ? new SerializationRuleObjectProcessor(this.configuration, this.cloakBuilder) : new DefaultRuleObjectProcessor(this.configuration, this.cloakBuilder);
        NoOpOverrideProcessor noOpOverrideProcessor = new NoOpOverrideProcessor(this.configuration, this.cloakBuilder);
        EnumOverrideProcessor enumOverrideProcessor = new EnumOverrideProcessor(this.configuration, this.cloakBuilder);
        ToStringProcessor toStringProcessor = new ToStringProcessor(this.configuration, this.cloakBuilder);
        MapOverrideProcessor mapOverrideProcessor = new MapOverrideProcessor(this.configuration, this.cloakBuilder);
        CollectionOverrideProcessor collectionOverrideProcessor = new CollectionOverrideProcessor(this.configuration, this.cloakBuilder);
        ObjectArrayOverrideProcessor objectArrayOverrideProcessor = new ObjectArrayOverrideProcessor(this.configuration, this.cloakBuilder);
        PrimitiveArrayOverrideProcessor primitiveArrayOverrideProcessor = new PrimitiveArrayOverrideProcessor(this.configuration, this.cloakBuilder);
        CharacterPrimitiveArrayOverrideProcessor characterPrimitiveArrayOverrideProcessor = new CharacterPrimitiveArrayOverrideProcessor(this.configuration, this.cloakBuilder);
        StringOverrideProcessor stringOverrideProcessor = new StringOverrideProcessor(this.configuration, this.cloakBuilder);
        PrimitiveOverrideProcessor primitiveOverrideProcessor = new PrimitiveOverrideProcessor(this.configuration, this.cloakBuilder);
        for (Rule rule : this.configuration.getRules()) {
            Verifier.verifyEvaluationObject(rule);
            Verifier.verifyAnnotation(rule);
            Verifier.verifyTypes(rule);
            mapProcessor.addMap(rule);
            this.specs.add(new TypeSpecContainer(this.configuration.getCloakPackage(), interfaceProcessor.generateInterface(rule)));
            ruleObjectProcessor.addEntry(rule);
            this.specs.add(new TypeSpecContainer(this.configuration.getCloakPackage(), noOpOverrideProcessor.createOverride(rule)));
            this.specs.add(new TypeSpecContainer(this.configuration.getCloakPackage(), enumOverrideProcessor.createOverride(rule)));
            this.specs.add(new TypeSpecContainer(this.configuration.getCloakPackage(), toStringProcessor.createOverride(rule)));
            this.specs.add(new TypeSpecContainer(this.configuration.getCloakPackage(), mapOverrideProcessor.createOverride(rule)));
            this.specs.add(new TypeSpecContainer(this.configuration.getCloakPackage(), collectionOverrideProcessor.createOverride(rule)));
            this.specs.add(new TypeSpecContainer(this.configuration.getCloakPackage(), objectArrayOverrideProcessor.createOverride(rule)));
            this.specs.addAll(primitiveArrayOverrideProcessor.createOverrides(rule).stream().map(t -> new TypeSpecContainer(this.configuration.getCloakPackage(), (TypeSpec)t)).collect(Collectors.toList()));
            this.specs.add(new TypeSpecContainer(this.configuration.getCloakPackage(), characterPrimitiveArrayOverrideProcessor.createOverride(rule)));
            this.specs.add(new TypeSpecContainer(this.configuration.getCloakPackage(), stringOverrideProcessor.createOverride(rule)));
            this.specs.addAll(primitiveOverrideProcessor.createOverrides(rule).stream().map(t -> new TypeSpecContainer(this.configuration.getCloakPackage(), (TypeSpec)t)).collect(Collectors.toList()));
        }
        return this.specs;
    }
}

