/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.masquerade.processor;

import com.flipkart.masquerade.Configuration;
import com.flipkart.masquerade.rule.Rule;
import com.flipkart.masquerade.util.Helper;
import com.flipkart.masquerade.util.Strings;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;

public abstract class BaseOverrideProcessor {
    protected final Configuration configuration;
    protected final TypeSpec.Builder cloakBuilder;

    public BaseOverrideProcessor(Configuration configuration, TypeSpec.Builder cloakBuilder) {
        this.configuration = configuration;
        this.cloakBuilder = cloakBuilder;
    }

    protected MethodSpec.Builder generateOverrideMethod(Rule rule, Class<?> clazz) {
        return this.generateOverrideMethod(rule, ParameterSpec.builder(clazz, (String)Strings.OBJECT_PARAMETER, (Modifier[])new Modifier[0]).build());
    }

    protected MethodSpec.Builder generateOverrideMethod(Rule rule, TypeName typeName) {
        return this.generateOverrideMethod(rule, ParameterSpec.builder((TypeName)typeName, (String)Strings.OBJECT_PARAMETER, (Modifier[])new Modifier[0]).build());
    }

    private MethodSpec.Builder generateOverrideMethod(Rule rule, ParameterSpec parameterSpec) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)Strings.INTERFACE_METHOD);
        methodBuilder.addAnnotation(Override.class);
        methodBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        methodBuilder.addParameter(parameterSpec);
        methodBuilder.addParameter(rule.getEvaluatorClass(), "eval", new Modifier[0]);
        methodBuilder.addParameter((TypeName)Helper.getEntryClass(this.configuration), Strings.CLOAK_PARAMETER, new Modifier[0]);
        methodBuilder.addParameter((TypeName)Helper.getRepositoryClass(this.configuration), Strings.SET_PARAMETER, new Modifier[0]);
        if (this.configuration.isNativeSerializationEnabled()) {
            methodBuilder.addParameter(StringBuilder.class, "serialized", new Modifier[0]);
            methodBuilder.beginControlFlow("if ($L == null)", new Object[]{Strings.OBJECT_PARAMETER});
            methodBuilder.addStatement("$L.append($L)", new Object[]{"serialized", "_null"});
            methodBuilder.addStatement("return", new Object[0]);
            methodBuilder.endControlFlow();
        }
        return methodBuilder;
    }

    protected TypeSpec generateImplementationType(Rule rule, Class<?> clazz, String implName, MethodSpec method) {
        return this.generateImplementationType(rule, TypeName.get(clazz), implName, method);
    }

    protected TypeSpec generateImplementationType(Rule rule, TypeName typeName, String implName, MethodSpec method) {
        TypeSpec.Builder implBuilder = TypeSpec.classBuilder((String)implName);
        implBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        implBuilder.addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)Helper.getRuleInterface(this.configuration, rule), (TypeName[])new TypeName[]{typeName}));
        implBuilder.addMethod(method);
        if (this.configuration.isNativeSerializationEnabled()) {
            implBuilder.addField(FieldSpec.builder(String.class, (String)"_null", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("$S", new Object[]{"null"}).build());
        }
        return implBuilder.build();
    }
}

