/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.masquerade.processor;

import com.flipkart.masquerade.Configuration;
import com.flipkart.masquerade.processor.RuleObjectProcessor;
import com.flipkart.masquerade.rule.Rule;
import com.flipkart.masquerade.util.Helper;
import com.flipkart.masquerade.util.Strings;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class SerializationRuleObjectProcessor
extends RuleObjectProcessor {
    public SerializationRuleObjectProcessor(Configuration configuration, TypeSpec.Builder cloakBuilder) {
        super(configuration, cloakBuilder);
    }

    @Override
    protected void handleReturnsForNullObjects(MethodSpec.Builder objectMaskBuilder) {
        objectMaskBuilder.addStatement("return null", new Object[0]);
    }

    @Override
    protected void handleRegisteredClasses(MethodSpec.Builder objectMaskBuilder) {
        objectMaskBuilder.addStatement("return $L.$L($L, $L, this, $L)", new Object[]{"masker", Strings.INTERFACE_METHOD, Strings.OBJECT_PARAMETER, "eval", Strings.SET_PARAMETER});
    }

    @Override
    protected void handleMaps(Rule rule, MethodSpec.Builder objectMaskBuilder) {
        objectMaskBuilder.addStatement("return $L.$L().$L(($T) $L, $L, this, $L)", new Object[]{Strings.SET_PARAMETER, Helper.getMapVariableName(rule), Strings.INTERFACE_METHOD, Map.class, Strings.OBJECT_PARAMETER, "eval", Strings.SET_PARAMETER});
    }

    @Override
    protected void handleCollections(Rule rule, MethodSpec.Builder objectMaskBuilder) {
        objectMaskBuilder.addStatement("return $L.$L().$L(($T) $L, $L, this, $L)", new Object[]{Strings.SET_PARAMETER, Helper.getCollectionVariableName(rule), Strings.INTERFACE_METHOD, Collection.class, Strings.OBJECT_PARAMETER, "eval", Strings.SET_PARAMETER});
    }

    @Override
    protected void handleObjectArrays(Rule rule, MethodSpec.Builder objectMaskBuilder) {
        objectMaskBuilder.addStatement("return $L.$L().$L(($T) $L, $L, this, $L)", new Object[]{Strings.SET_PARAMETER, Helper.getObjectArrayVariableName(rule), Strings.INTERFACE_METHOD, ArrayTypeName.of(Object.class), Strings.OBJECT_PARAMETER, "eval", Strings.SET_PARAMETER});
    }

    @Override
    protected void handlePrimitiveArrays(Rule rule, MethodSpec.Builder objectMaskBuilder) {
        objectMaskBuilder.nextControlFlow("else if ($L.getClass().isArray())", new Object[]{Strings.OBJECT_PARAMETER});
        objectMaskBuilder.beginControlFlow("if ($L instanceof $T[])", new Object[]{Strings.OBJECT_PARAMETER, Character.TYPE});
        objectMaskBuilder.addStatement("return $L.$L().$L(($T) $L, $L, this, $L)", new Object[]{Strings.SET_PARAMETER, Helper.getPrimitiveArrayVariableName(rule, Character.TYPE), Strings.INTERFACE_METHOD, ArrayTypeName.of(Character.TYPE), Strings.OBJECT_PARAMETER, "eval", Strings.SET_PARAMETER});
        ArrayList primitiveTypes = new ArrayList(Helper.getPrimitivesTypes());
        for (int i = 0; i < primitiveTypes.size(); ++i) {
            Class primitiveType = (Class)primitiveTypes.get(i);
            objectMaskBuilder.nextControlFlow("else if ($L instanceof $T[])", new Object[]{Strings.OBJECT_PARAMETER, primitiveType});
            objectMaskBuilder.addStatement("return $L.$L().$L(($T) $L, $L, this, $L)", new Object[]{Strings.SET_PARAMETER, Helper.getPrimitiveArrayVariableName(rule, primitiveType), Strings.INTERFACE_METHOD, ArrayTypeName.of((Type)primitiveType), Strings.OBJECT_PARAMETER, "eval", Strings.SET_PARAMETER});
        }
        objectMaskBuilder.endControlFlow();
    }

    @Override
    protected void handleReturns(MethodSpec.Builder objectMaskBuilder) {
        objectMaskBuilder.returns(String.class);
        objectMaskBuilder.addStatement("return null", new Object[0]);
    }
}

