/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.masquerade.processor;

import com.flipkart.masquerade.Configuration;
import com.flipkart.masquerade.processor.DebugProcessor;
import com.flipkart.masquerade.processor.FallbackProcessor;
import com.flipkart.masquerade.rule.Rule;
import com.flipkart.masquerade.util.Helper;
import com.flipkart.masquerade.util.Strings;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.util.Collection;
import java.util.Map;
import javax.lang.model.element.Modifier;

public abstract class RuleObjectProcessor {
    private final Configuration configuration;
    private final TypeSpec.Builder cloakBuilder;
    private final DebugProcessor debugProcessor;
    private final FallbackProcessor fallbackProcessor;

    public RuleObjectProcessor(Configuration configuration, TypeSpec.Builder cloakBuilder) {
        this.configuration = configuration;
        this.cloakBuilder = cloakBuilder;
        this.debugProcessor = new DebugProcessor(configuration, cloakBuilder);
        this.fallbackProcessor = new FallbackProcessor(configuration, cloakBuilder);
    }

    public void addEntry(Rule rule) {
        MethodSpec.Builder objectMaskBuilder = MethodSpec.methodBuilder((String)"hide");
        objectMaskBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        objectMaskBuilder.addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"unchecked"}).build());
        objectMaskBuilder.addParameter(Object.class, Strings.OBJECT_PARAMETER, new Modifier[0]);
        objectMaskBuilder.addParameter(rule.getEvaluatorClass(), "eval", new Modifier[0]);
        objectMaskBuilder.beginControlFlow("if ($L == null)", new Object[]{Strings.OBJECT_PARAMETER});
        this.handleReturnsForNullObjects(objectMaskBuilder);
        objectMaskBuilder.endControlFlow();
        objectMaskBuilder.addStatement("$T $L = this.$L.get($L.getClass().getName())", new Object[]{Helper.getRuleInterface(this.configuration, rule), "masker", rule.getName(), Strings.OBJECT_PARAMETER});
        objectMaskBuilder.beginControlFlow("if ($L != null)", new Object[]{"masker"});
        this.handleRegisteredClasses(objectMaskBuilder);
        objectMaskBuilder.nextControlFlow("else", new Object[0]);
        objectMaskBuilder.beginControlFlow("if ($L instanceof $T)", new Object[]{Strings.OBJECT_PARAMETER, Map.class});
        this.handleMaps(rule, objectMaskBuilder);
        objectMaskBuilder.nextControlFlow("else if ($L instanceof $T)", new Object[]{Strings.OBJECT_PARAMETER, Collection.class});
        this.handleCollections(rule, objectMaskBuilder);
        objectMaskBuilder.nextControlFlow("else if ($L instanceof Object[])", new Object[]{Strings.OBJECT_PARAMETER});
        this.handleObjectArrays(rule, objectMaskBuilder);
        this.handlePrimitiveArrays(rule, objectMaskBuilder);
        this.debugProcessor.addDebugCollector(objectMaskBuilder);
        this.fallbackProcessor.addFallbackCall(objectMaskBuilder);
        objectMaskBuilder.endControlFlow();
        objectMaskBuilder.endControlFlow();
        this.handleReturns(objectMaskBuilder);
        this.cloakBuilder.addMethod(objectMaskBuilder.build());
    }

    protected abstract void handleReturnsForNullObjects(MethodSpec.Builder var1);

    protected abstract void handleRegisteredClasses(MethodSpec.Builder var1);

    protected abstract void handleMaps(Rule var1, MethodSpec.Builder var2);

    protected abstract void handleCollections(Rule var1, MethodSpec.Builder var2);

    protected abstract void handleObjectArrays(Rule var1, MethodSpec.Builder var2);

    protected abstract void handlePrimitiveArrays(Rule var1, MethodSpec.Builder var2);

    protected abstract void handleReturns(MethodSpec.Builder var1);
}

